<p align="center">
  <img src="https://www.rapier.rs/img/rapier_logo_color_textpath_dark.svg" alt="crates.io">
</p>
<p align="center">
    <a href="https://discord.gg/vt9DJSW">
        <img src="https://img.shields.io/discord/507548572338880513.svg?logo=discord&colorB=7289DA">
    </a>
    <a href="https://github.com/dimforge/rapier/actions">
        <img src="https://github.com/dimforge/rapier/workflows/Rapier%20CI%20build/badge.svg" alt="Build status">
    </a>
    <a href="https://crates.io/crates/rapier2d">
         <img src="https://img.shields.io/crates/v/rapier2d.svg?style=flat-square" alt="crates.io">
    </a>
    <a href="https://crates.io/crates/rapier3d">
         <img src="https://img.shields.io/crates/v/rapier3d.svg?style=flat-square" alt="crates.io">
    </a>
    <a href="https://opensource.org/licenses/Apache-2.0">
        <img src="https://img.shields.io/badge/License-Apache%202.0-blue.svg">
    </a>
</p>
<p align = "center">
    <strong>
        <a href="https://rapier.rs">Website</a> | <a href="https://rapier.rs/docs/">Documentation</a>
    </strong>
</p>

-----

<p align = "center">
<b>2D and 3D physics engines</b>
<i>for the Rust programming language.</i>
</p>

-----

## What is Rapier?

Rapier is a set of 2D and 3D physics engines for games, animation, and robotics. These crates 
are `rapier2d`, `rapier3d`, `rapier2d-f64`, and `rapier3d-f64`. They are written with the Rust
programming language, by the [Dimforge](https://dimforge.com) organization. It is forever free
and open-source!

## Roadmap
We update our roadmap at the beginning of each year. Our 2021 roadmap can be seen
[there](https://www.dimforge.com/blog/2021/01/01/physics-simulation-with-rapier-2021-roadmap/#rapier-roadmap-for-2021).
We regularly give updates about our progress on [our blog](https://www.dimforge.com/blog).

## Getting started
The easiest way to get started with Rapier is to:
1. Read the [user-guides](https://www.rapier.rs/docs/).
2. Play with the examples: `cargo run --release --bin all_examples2` and `cargo run --release --bin all_examples3`.
   Their source code are available on the `examples2d/` and `examples3d/` directory.
3. Don't hesitate to ask for help on [Discord](https://discord.gg/vt9DJSW), or by opening an issue on GitHub.
  
## Resources and discussions
- [Dimforge](https://dimforge.com): See all the open-source projects we are working on! Follow our announcements
  on our [blog](https://www.dimforge.com/blog).
- [User guide](https://www.rapier.rs/docs/): Learn to use Rapier in your project by reading the official User Guides.
- [Discord](https://discord.gg/vt9DJSW): Come chat with us, get help, suggest features, on Discord!
- [NPM packages](https://www.npmjs.com/search?q=%40dimforge): Check out our NPM packages for Rapier, if you need to
  use it with JavaScript/Typescript.

Please make sure to familiarize yourself with our [Code of Conduct](CODE_OF_CONDUCT.md)
and our [Contribution Guidelines](CONTRIBUTING.md) before contributing or participating in
discussions with the community.


## Acknowledgements
Parry is supported by our **platinum** sponsors:
<p>
  <a href="https://embark-studios.com">
    <img src="https://www.embark.dev/img/logo_black.png" width="301px">
  </a>
</p>

And our gold sponsors:

<p>
  <a href="https://fragcolor.com">
    <img src="https://dimforge.com/img/fragcolor_logo1_color_black.svg" width="151px">
  </a>
</p>