# random-distributions-cli
Command-line tool to generate samples of various random distributions

# Installation

You can download pre-built files from [Github releases](https://github.com/vi/random-distributions-cli/releases) or install the tool from crates.io using `cargo install random-distributions-cli`.


# Usage

```
$ random-distributions-cli -n 5 normal 0 1
0.2691767185
-1.1783043912
0.5623772742
0.1078446497
0.2829313503

$ target/release/random-distributions-cli -n 3 uniform -- -1 1
0.0218074136
0.4381694923
-0.7817481855

$ random-distributions-cli --help
Usage: random-distributions-cli [-p <precision>] [-C] [-S <seed>] [-b <binary-format>] [-n <num-samples>] [-e] [-L <discard-below>] [-H <discard-above>] <command> [<args>]

Command-line tool to generate samples of various random distributions.

Options:
  -p, --precision   number of digits after decimal to print
  -C, --cumulative  add value of each sample to accumulator, outputting a random
                    walk instead of individual samples
  -S, --seed        use specified seed instead for PRNG
  -b, --binary-format
                    output as binary numbers of specified format instead of
                    text. Valid formats are f{32,64}{be,le}, {u,s}8,
                    {u,s}{16,32,64}{le,be}. Out of range values are
                    clamped to valid ranges
  -n, --num-samples number of sampels to generate, instead of an infinite stream
  -e, --exponentiate
                    exponentiate (e^x) each sample, producing log-normal instead
                    of normal distribution, log-Cauchy instead of Cauchy, etc.
  -L, --discard-below
                    discard samples that are below the specified value
  -H, --discard-above
                    discard samples that are above the specified value
  --help            display usage information

Commands:
  uniform           Uniform distribution
  normal            Normal, Gaussian distribution
  cauchy            Cauchy, Lorentz distribution - fat-tailed and continuous
  triangular        Triangular distribution - continuous
  studentt          Student-T distribution
  stable            General case of stable continuous distribution, generated by
                    CMS method. Note that version 0.1 of this program used
                    nonstandard distribution when alpha was not 1.0.
  empirical         Discrete distribution that just endlessly randomly selects
                    one of specified values
  categorical       Discrete distribution that generates values according to
                    specified probabilities
  beta              Beta distribution
  binomial          Binomial distribution
  discreteuniform   Discrete uniform, generates integer numbers from min to max,
                    both inclusive
  chisquared        Chi-squared distribution which is a special case of the
                    Gamma distribution
  chi               Chi distribution
  gamma             Gamma distribution
  exp               Exponential distribution and is a special case of the Gamma
                    distribution
  fisher            Fisher-Snedecor distribution also commonly known as the
                    F-distribution
  geometric         Geometric distribution
  hypergeometric    Hypergeometric distribution
  inversegamma      Inverse Gamma distribution
  laplace           Laplace distribution.
  pareto            Pareto distribution
  poisson           Poisson distribution
  weibull           Weibull distribution
```

Individual distributions may provide additional internal `--help` messages.
