
use clipboard_win::{formats, set_clipboard};
use rand::thread_rng;
use rand::prelude::*;

fn main() -> Result<(), Box<dyn std::error::Error>> {
    let config = unsafe{String::from_utf8_unchecked(std::fs::read("config.csv")?)};
    let nums: Vec<u32> = config.trim().split(",").map(|s|s.parse().unwrap()).collect();

    let student_num = nums[0];
    let min_grade = nums[1];
    let max_grade = nums[2];

    let mut rng = thread_rng();
    let mut list = String::new();
    for _ in 0..student_num {
        let grade = rng.gen_range(min_grade..=max_grade);
        list += &grade.to_string();
        list += "\n";
    }
    
    set_clipboard(formats::Unicode,list).unwrap();

    Ok(())
}
