// Copyright 2015 The Ramp Developers
//
//    Licensed under the Apache License, Version 2.0 (the "License");
//    you may not use this file except in compliance with the License.
//    You may obtain a copy of the License at
//
//        http://www.apache.org/licenses/LICENSE-2.0
//
//    Unless required by applicable law or agreed to in writing, software
//    distributed under the License is distributed on an "AS IS" BASIS,
//    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//    See the License for the specific language governing permissions and
//    limitations under the License.

//! This module holds various traits.

/// A trait for types which can compute division and remainder in one step.
pub trait DivRem<RHS = Self> {
    // Default to (Self, RHS) when associated type defaults are more stable.
    type Output;

    fn divrem(self, rhs: RHS) -> Self::Output;
}

/// We re-export num_integer::Integer for convenience.
pub use num_integer::Integer;
