# Copyright 2020 Jack Grigg
#
# Licensed under the Apache License, Version 2.0 <LICENSE-APACHE or
# http://www.apache.org/licenses/LICENSE-2.0> or the MIT license
# <LICENSE-MIT or http://opensource.org/licenses/MIT>, at your
# option. This file may not be copied, modified, or distributed
# except according to those terms.

### Localization for strings in the rage CLI tools

-age = age
-rage = rage

## CLI flags

-flag-armor = -a/--armor
-flag-decrypt = -d/--decrypt
-flag-encrypt = -e/--encrypt
-flag-identity = -i/--identity
-flag-recipient = -r/--recipient
-flag-recipients-file = -R/--recipients-file
-flag-passphrase = -p/--passphrase
-flag-max-work-factor = --max-work-factor
-flag-unstable = --features unstable

## Usage

-input = INPUT
-output = OUTPUT
-identity = IDENTITY
-recipient = RECIPIENT
-recipients-file = PATH

usage-header = Usage:

rage-usage =
    {usage-header}
    {"  "}{$usage_a}
    {"  "}{$usage_b}

    {$flags}

    {-input} ha come valore predefinito lo standard input, e {-output} ha come
    valore predefinito lo standard output.

    {-recipient} può essere:
    - Una chiave pubblica {-age}, come generata da {$keygen_name} ("age1...").
    - Una chiave pubblica SSH ("ssh-ed25519 AAAA...", "ssh-rsa AAAA...").

    {-recipients-file} è il percorso ad un file contenente dei destinatari {-age}, uno per riga
    (ignorando i commenti prefissati da "#" e le righe vuote).

    {-identity} è il percorso ad un file contenente identità {-age}, una per
    riga (ignorando i commenti prefissati da "#" e le righe vuote), o ad un file
    contenente una chiave SSH.
    Possono essere fornite più identità, quelle inutilizzate verranno ignorate.

    Esempio:
    {"  "}{$example_a}
    {"  "}{tty-pubkey}: {$example_a_output}
    {"  "}{$example_b}
    {"  "}{$example_c}

## Keygen messages

tty-pubkey = Chiave pubblica
identity-file-created = creato
identity-file-pubkey = chiave pubblica

## Encryption messages

autogenerated-passphrase = Utilizzo di una passphrase generata automaticamente:
type-passphrase = Scrivi la passphrase
prompt-passphrase = Passphrase

## General errors

err-failed-to-open-output = Impossibile aprire l'output: {$err}
err-failed-to-write-output = Impossibile scrivere sull'output: {$err}
err-enc-mixed-encrypt-decrypt = {-flag-encrypt} non può essere usato assieme a {-flag-decrypt}.
err-passphrase-timed-out = Tempo di attesa per l'inserimento della passphrase scaduto.

err-ux-A = {-rage} non fa quello che ti aspetti? Potrebbe un errore essere più utile?
err-ux-B = Faccelo sapere
# Put (len(A) - len(B) - 32) spaces here.
err-ux-C = {"                         "}

## Encryption errors

err-enc-broken-stdout = Impossibile scrivere sullo standard output: {$err}
rec-enc-broken-stdout = Stai usando una pipe verso un programma che non sta leggendo dallo standard input?

err-enc-broken-file = Impossibile scrivere sul file: {$err}

err-enc-invalid-recipient = Destinatario '{$recipient}' invalido

err-enc-missing-recipients = Destinatari mancanti.
rec-enc-missing-recipients = Hai dimenticato di specificare {-flag-recipient}?

err-enc-mixed-identity-passphrase = {-flag-identity} non può essere usato assieme a {-flag-passphrase}.
err-enc-mixed-recipient-passphrase = {-flag-recipient} non può essere usato assieme a {-flag-passphrase}
err-enc-mixed-recipients-file-passphrase = {-flag-recipients-file} non può essere usato assieme a {-flag-passphrase}
err-enc-passphrase-without-file = Il file da cifrare deve essere passato come argomento quando si usa {-flag-passphrase}

## Decryption errors

rec-dec-excessive-work = Per decifrare, riprova usando {-flag-max-work-factor} {$wf}

err-dec-armor-flag = {-flag-armor} non può essere usato assieme a {-flag-decrypt}.
rec-dec-armor-flag = Nota che i file armored vengono rilevati automaticamente.

err-dec-identity-not-found = File di identità non trovato: {$filename}

err-dec-missing-identities = Identità mancanti.
rec-dec-missing-identities = Hai dimenticato di specificare {-flag-identity}?

err-dec-passphrase-flag = {-flag-passphrase} non può essere usato assieme a {-flag-decrypt}.
rec-dec-passphrase-flag = Nota che i file crittografati con la passphrase vengono rilevati automaticamente.

err-dec-passphrase-without-file-win =
    Questo file richiede una passphrase, e su Windows il
    file da decifrare deve essere passato come argomento
    posizionale quando si decifra con la passphrase.

err-dec-recipient-flag = {-flag-recipient} non può essere usato assieme a {-flag-decrypt}.
err-dec-recipients-file-flag = {-flag-recipients-file} non può essere usato assieme a {-flag-decrypt}.
rec-dec-recipient-flag = Intendevi usare {-flag-identity} per specificare una chiave privata?

## rage-mount strings

-flag-mnt-types = -t/--types

info-decrypting = Decifrando {$filename}
info-mounting-as-fuse = Montando come filesystem FUSE

err-mnt-missing-filename = Nome del file mancante.
err-mnt-missing-mountpoint = Punto di montaggio mancante.
err-mnt-missing-types = {-flag-mnt-types} mancante.
err-mnt-unknown-type = Tipo di filesystem sconosciuto "{$fs_type}"

## Unstable features

test-unstable = Per testare questo esegui la build di {-rage} con {-flag-unstable}.
