// This code is auto-generated by the shader processor.

#[allow(unused_imports)]
use rafx::RafxResult;

#[allow(unused_imports)]
use rafx::framework::{
    DescriptorSetAllocator, DescriptorSetArc, DescriptorSetBindings, DescriptorSetInitializer,
    DescriptorSetWriter, DescriptorSetWriterContext, DynDescriptorSet, ImageViewResource,
    ResourceArc,
};

#[derive(Copy, Clone, Debug)]
#[repr(C)]
pub struct ConfigStd140 {
    pub horizontal: u32,     // +0 (size: 4)
    pub _padding0: [u8; 12], // +4 (size: 12)
} // 16 bytes

impl Default for ConfigStd140 {
    fn default() -> Self {
        ConfigStd140 {
            horizontal: <u32>::default(),
            _padding0: [u8::default(); 12],
        }
    }
}

pub type ConfigUniform = ConfigStd140;

pub const TEX_DESCRIPTOR_SET_INDEX: usize = 0;
pub const TEX_DESCRIPTOR_BINDING_INDEX: usize = 0;
pub const SMP_DESCRIPTOR_SET_INDEX: usize = 0;
pub const SMP_DESCRIPTOR_BINDING_INDEX: usize = 1;
pub const CONFIG_DESCRIPTOR_SET_INDEX: usize = 0;
pub const CONFIG_DESCRIPTOR_BINDING_INDEX: usize = 2;

pub struct DescriptorSet0Args<'a> {
    pub tex: &'a ResourceArc<ImageViewResource>,
    pub config: &'a ConfigUniform,
}

impl<'a> DescriptorSetInitializer<'a> for DescriptorSet0Args<'a> {
    type Output = DescriptorSet0;

    fn create_dyn_descriptor_set(
        descriptor_set: DynDescriptorSet,
        args: Self,
    ) -> Self::Output {
        let mut descriptor = DescriptorSet0(descriptor_set);
        descriptor.set_args(args);
        descriptor
    }

    fn create_descriptor_set(
        descriptor_set_allocator: &mut DescriptorSetAllocator,
        descriptor_set: DynDescriptorSet,
        args: Self,
    ) -> RafxResult<DescriptorSetArc> {
        let mut descriptor = Self::create_dyn_descriptor_set(descriptor_set, args);
        descriptor.0.flush(descriptor_set_allocator)?;
        Ok(descriptor.0.descriptor_set().clone())
    }
}

impl<'a> DescriptorSetWriter<'a> for DescriptorSet0Args<'a> {
    fn write_to(
        descriptor_set: &mut DescriptorSetWriterContext,
        args: Self,
    ) {
        descriptor_set.set_image(TEX_DESCRIPTOR_BINDING_INDEX as u32, args.tex);
        descriptor_set.set_buffer_data(CONFIG_DESCRIPTOR_BINDING_INDEX as u32, args.config);
    }
}

pub struct DescriptorSet0(pub DynDescriptorSet);

impl DescriptorSet0 {
    pub fn set_args_static(
        descriptor_set: &mut DynDescriptorSet,
        args: DescriptorSet0Args,
    ) {
        descriptor_set.set_image(TEX_DESCRIPTOR_BINDING_INDEX as u32, args.tex);
        descriptor_set.set_buffer_data(CONFIG_DESCRIPTOR_BINDING_INDEX as u32, args.config);
    }

    pub fn set_args(
        &mut self,
        args: DescriptorSet0Args,
    ) {
        self.set_tex(args.tex);
        self.set_config(args.config);
    }

    pub fn set_tex(
        &mut self,
        tex: &ResourceArc<ImageViewResource>,
    ) {
        self.0.set_image(TEX_DESCRIPTOR_BINDING_INDEX as u32, tex);
    }

    pub fn set_config(
        &mut self,
        config: &ConfigUniform,
    ) {
        self.0
            .set_buffer_data(CONFIG_DESCRIPTOR_BINDING_INDEX as u32, config);
    }

    pub fn flush(
        &mut self,
        descriptor_set_allocator: &mut DescriptorSetAllocator,
    ) -> RafxResult<()> {
        self.0.flush(descriptor_set_allocator)
    }
}

#[cfg(test)]
mod test {
    use super::*;

    #[test]
    fn test_struct_config_std140() {
        assert_eq!(std::mem::size_of::<ConfigStd140>(), 16);
        assert_eq!(std::mem::size_of::<u32>(), 4);
        assert_eq!(std::mem::align_of::<u32>(), 4);
        assert_eq!(memoffset::offset_of!(ConfigStd140, horizontal), 0);
        assert_eq!(std::mem::size_of::<[u8; 12]>(), 12);
        assert_eq!(std::mem::align_of::<[u8; 12]>(), 1);
        assert_eq!(memoffset::offset_of!(ConfigStd140, _padding0), 4);
    }
}
