// This code is auto-generated by the shader processor.

#[allow(unused_imports)]
use rafx_api::RafxResult;

#[allow(unused_imports)]
use crate::{
    DescriptorSetAllocator, DescriptorSetArc, DescriptorSetBindings, DescriptorSetInitializer,
    DescriptorSetWriter, DescriptorSetWriterContext, DynDescriptorSet, ImageViewResource,
    ResourceArc,
};

#[derive(Copy, Clone, Debug)]
#[repr(C)]
pub struct BufferStd430 {
    pub data: [u32; 0], // +0 (size: 0)
} // 0 bytes

pub type BufferBuffer = BufferStd430;

#[derive(Copy, Clone, Debug)]
#[repr(C)]
pub struct ClearBufferConfigStd140 {
    pub buffer_bytes_div_by_four: u32, // +0 (size: 4)
    pub fill_value: u32,               // +4 (size: 4)
    pub _padding0: [u8; 8],            // +8 (size: 8)
} // 16 bytes

impl Default for ClearBufferConfigStd140 {
    fn default() -> Self {
        ClearBufferConfigStd140 {
            buffer_bytes_div_by_four: <u32>::default(),
            fill_value: <u32>::default(),
            _padding0: [u8::default(); 8],
        }
    }
}

pub type ClearBufferConfigUniform = ClearBufferConfigStd140;

pub const CONFIG_DESCRIPTOR_SET_INDEX: usize = 0;
pub const CONFIG_DESCRIPTOR_BINDING_INDEX: usize = 0;
pub const DATA_DESCRIPTOR_SET_INDEX: usize = 0;
pub const DATA_DESCRIPTOR_BINDING_INDEX: usize = 1;

pub struct DescriptorSet0Args<'a> {
    pub config: &'a ClearBufferConfigUniform,
    pub data: &'a BufferBuffer,
}

impl<'a> DescriptorSetInitializer<'a> for DescriptorSet0Args<'a> {
    type Output = DescriptorSet0;

    fn create_dyn_descriptor_set(
        descriptor_set: DynDescriptorSet,
        args: Self,
    ) -> Self::Output {
        let mut descriptor = DescriptorSet0(descriptor_set);
        descriptor.set_args(args);
        descriptor
    }

    fn create_descriptor_set(
        descriptor_set_allocator: &mut DescriptorSetAllocator,
        descriptor_set: DynDescriptorSet,
        args: Self,
    ) -> RafxResult<DescriptorSetArc> {
        let mut descriptor = Self::create_dyn_descriptor_set(descriptor_set, args);
        descriptor.0.flush(descriptor_set_allocator)?;
        Ok(descriptor.0.descriptor_set().clone())
    }
}

impl<'a> DescriptorSetWriter<'a> for DescriptorSet0Args<'a> {
    fn write_to(
        descriptor_set: &mut DescriptorSetWriterContext,
        args: Self,
    ) {
        descriptor_set.set_buffer_data(CONFIG_DESCRIPTOR_BINDING_INDEX as u32, args.config);
        descriptor_set.set_buffer_data(DATA_DESCRIPTOR_BINDING_INDEX as u32, args.data);
    }
}

pub struct DescriptorSet0(pub DynDescriptorSet);

impl DescriptorSet0 {
    pub fn set_args_static(
        descriptor_set: &mut DynDescriptorSet,
        args: DescriptorSet0Args,
    ) {
        descriptor_set.set_buffer_data(CONFIG_DESCRIPTOR_BINDING_INDEX as u32, args.config);
        descriptor_set.set_buffer_data(DATA_DESCRIPTOR_BINDING_INDEX as u32, args.data);
    }

    pub fn set_args(
        &mut self,
        args: DescriptorSet0Args,
    ) {
        self.set_config(args.config);
        self.set_data(args.data);
    }

    pub fn set_config(
        &mut self,
        config: &ClearBufferConfigUniform,
    ) {
        self.0
            .set_buffer_data(CONFIG_DESCRIPTOR_BINDING_INDEX as u32, config);
    }

    pub fn set_data(
        &mut self,
        data: &BufferBuffer,
    ) {
        self.0
            .set_buffer_data(DATA_DESCRIPTOR_BINDING_INDEX as u32, data);
    }

    pub fn flush(
        &mut self,
        descriptor_set_allocator: &mut DescriptorSetAllocator,
    ) -> RafxResult<()> {
        self.0.flush(descriptor_set_allocator)
    }
}

#[cfg(test)]
mod test {
    use super::*;

    #[test]
    fn test_struct_buffer_std430() {
        assert_eq!(std::mem::size_of::<BufferStd430>(), 0);
        assert_eq!(std::mem::size_of::<[u32; 0]>(), 0);
        assert_eq!(std::mem::align_of::<[u32; 0]>(), 4);
        assert_eq!(memoffset::offset_of!(BufferStd430, data), 0);
    }

    #[test]
    fn test_struct_clear_buffer_config_std140() {
        assert_eq!(std::mem::size_of::<ClearBufferConfigStd140>(), 16);
        assert_eq!(std::mem::size_of::<u32>(), 4);
        assert_eq!(std::mem::align_of::<u32>(), 4);
        assert_eq!(
            memoffset::offset_of!(ClearBufferConfigStd140, buffer_bytes_div_by_four),
            0
        );
        assert_eq!(std::mem::size_of::<u32>(), 4);
        assert_eq!(std::mem::align_of::<u32>(), 4);
        assert_eq!(
            memoffset::offset_of!(ClearBufferConfigStd140, fill_value),
            4
        );
        assert_eq!(std::mem::size_of::<[u8; 8]>(), 8);
        assert_eq!(std::mem::align_of::<[u8; 8]>(), 1);
        assert_eq!(memoffset::offset_of!(ClearBufferConfigStd140, _padding0), 8);
    }
}
