#[cfg(any(feature = "rafx-gles2", feature = "rafx-gles3"))]
type GLenum = u32;

#[cfg(feature = "rafx-vulkan")]
use ash::vk;
#[cfg(feature = "rafx-metal")]
use metal_rs::MTLPixelFormat;
#[cfg(feature = "rafx-metal")]
use metal_rs::MTLVertexFormat;
#[cfg(feature = "serde-support")]
use serde::{Deserialize, Serialize};

//TODO: Try using Some/None instead of UNDEFINED format

/// Describes the encoding of an image or buffer.
#[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)]
#[cfg_attr(feature = "serde-support", derive(Serialize, Deserialize))]
#[allow(non_camel_case_types)]
pub enum RafxFormat {
    UNDEFINED,
    R4G4_UNORM_PACK8,
    R4G4B4A4_UNORM_PACK16,
    B4G4R4A4_UNORM_PACK16,
    R5G6B5_UNORM_PACK16,
    B5G6R5_UNORM_PACK16,
    R5G5B5A1_UNORM_PACK16,
    B5G5R5A1_UNORM_PACK16,
    A1R5G5B5_UNORM_PACK16,
    R8_UNORM,
    R8_SNORM,
    R8_USCALED,
    R8_SSCALED,
    R8_UINT,
    R8_SINT,
    R8_SRGB,
    R8G8_UNORM,
    R8G8_SNORM,
    R8G8_USCALED,
    R8G8_SSCALED,
    R8G8_UINT,
    R8G8_SINT,
    R8G8_SRGB,
    R8G8B8_UNORM,
    R8G8B8_SNORM,
    R8G8B8_USCALED,
    R8G8B8_SSCALED,
    R8G8B8_UINT,
    R8G8B8_SINT,
    R8G8B8_SRGB,
    B8G8R8_UNORM,
    B8G8R8_SNORM,
    B8G8R8_USCALED,
    B8G8R8_SSCALED,
    B8G8R8_UINT,
    B8G8R8_SINT,
    B8G8R8_SRGB,
    R8G8B8A8_UNORM,
    R8G8B8A8_SNORM,
    R8G8B8A8_USCALED,
    R8G8B8A8_SSCALED,
    R8G8B8A8_UINT,
    R8G8B8A8_SINT,
    R8G8B8A8_SRGB,
    B8G8R8A8_UNORM,
    B8G8R8A8_SNORM,
    B8G8R8A8_USCALED,
    B8G8R8A8_SSCALED,
    B8G8R8A8_UINT,
    B8G8R8A8_SINT,
    B8G8R8A8_SRGB,
    A8B8G8R8_UNORM_PACK32,
    A8B8G8R8_SNORM_PACK32,
    A8B8G8R8_USCALED_PACK32,
    A8B8G8R8_SSCALED_PACK32,
    A8B8G8R8_UINT_PACK32,
    A8B8G8R8_SINT_PACK32,
    A8B8G8R8_SRGB_PACK32,
    A2R10G10B10_UNORM_PACK32,
    A2R10G10B10_SNORM_PACK32,
    A2R10G10B10_USCALED_PACK32,
    A2R10G10B10_SSCALED_PACK32,
    A2R10G10B10_UINT_PACK32,
    A2R10G10B10_SINT_PACK32,
    A2B10G10R10_UNORM_PACK32,
    A2B10G10R10_SNORM_PACK32,
    A2B10G10R10_USCALED_PACK32,
    A2B10G10R10_SSCALED_PACK32,
    A2B10G10R10_UINT_PACK32,
    A2B10G10R10_SINT_PACK32,
    R16_UNORM,
    R16_SNORM,
    R16_USCALED,
    R16_SSCALED,
    R16_UINT,
    R16_SINT,
    R16_SFLOAT,
    R16G16_UNORM,
    R16G16_SNORM,
    R16G16_USCALED,
    R16G16_SSCALED,
    R16G16_UINT,
    R16G16_SINT,
    R16G16_SFLOAT,
    R16G16B16_UNORM,
    R16G16B16_SNORM,
    R16G16B16_USCALED,
    R16G16B16_SSCALED,
    R16G16B16_UINT,
    R16G16B16_SINT,
    R16G16B16_SFLOAT,
    R16G16B16A16_UNORM,
    R16G16B16A16_SNORM,
    R16G16B16A16_USCALED,
    R16G16B16A16_SSCALED,
    R16G16B16A16_UINT,
    R16G16B16A16_SINT,
    R16G16B16A16_SFLOAT,
    R32_UINT,
    R32_SINT,
    R32_SFLOAT,
    R32G32_UINT,
    R32G32_SINT,
    R32G32_SFLOAT,
    R32G32B32_UINT,
    R32G32B32_SINT,
    R32G32B32_SFLOAT,
    R32G32B32A32_UINT,
    R32G32B32A32_SINT,
    R32G32B32A32_SFLOAT,
    R64_UINT,
    R64_SINT,
    R64_SFLOAT,
    R64G64_UINT,
    R64G64_SINT,
    R64G64_SFLOAT,
    R64G64B64_UINT,
    R64G64B64_SINT,
    R64G64B64_SFLOAT,
    R64G64B64A64_UINT,
    R64G64B64A64_SINT,
    R64G64B64A64_SFLOAT,
    B10G11R11_UFLOAT_PACK32,
    E5B9G9R9_UFLOAT_PACK32,
    D16_UNORM,
    X8_D24_UNORM_PACK32,
    D32_SFLOAT,
    S8_UINT,
    D16_UNORM_S8_UINT,
    D24_UNORM_S8_UINT,
    D32_SFLOAT_S8_UINT,
    BC1_RGB_UNORM_BLOCK,
    BC1_RGB_SRGB_BLOCK,
    BC1_RGBA_UNORM_BLOCK,
    BC1_RGBA_SRGB_BLOCK,
    BC2_UNORM_BLOCK,
    BC2_SRGB_BLOCK,
    BC3_UNORM_BLOCK,
    BC3_SRGB_BLOCK,
    BC4_UNORM_BLOCK,
    BC4_SNORM_BLOCK,
    BC5_UNORM_BLOCK,
    BC5_SNORM_BLOCK,
    BC6H_UFLOAT_BLOCK,
    BC6H_SFLOAT_BLOCK,
    BC7_UNORM_BLOCK,
    BC7_SRGB_BLOCK,
    ETC2_R8G8B8_UNORM_BLOCK,
    ETC2_R8G8B8_SRGB_BLOCK,
    ETC2_R8G8B8A1_UNORM_BLOCK,
    ETC2_R8G8B8A1_SRGB_BLOCK,
    ETC2_R8G8B8A8_UNORM_BLOCK,
    ETC2_R8G8B8A8_SRGB_BLOCK,
    EAC_R11_UNORM_BLOCK,
    EAC_R11_SNORM_BLOCK,
    EAC_R11G11_UNORM_BLOCK,
    EAC_R11G11_SNORM_BLOCK,
    ASTC_4X4_UNORM_BLOCK,
    ASTC_4X4_SRGB_BLOCK,
    ASTC_5X4_UNORM_BLOCK,
    ASTC_5X4_SRGB_BLOCK,
    ASTC_5X5_UNORM_BLOCK,
    ASTC_5X5_SRGB_BLOCK,
    ASTC_6X5_UNORM_BLOCK,
    ASTC_6X5_SRGB_BLOCK,
    ASTC_6X6_UNORM_BLOCK,
    ASTC_6X6_SRGB_BLOCK,
    ASTC_8X5_UNORM_BLOCK,
    ASTC_8X5_SRGB_BLOCK,
    ASTC_8X6_UNORM_BLOCK,
    ASTC_8X6_SRGB_BLOCK,
    ASTC_8X8_UNORM_BLOCK,
    ASTC_8X8_SRGB_BLOCK,
    ASTC_10X5_UNORM_BLOCK,
    ASTC_10X5_SRGB_BLOCK,
    ASTC_10X6_UNORM_BLOCK,
    ASTC_10X6_SRGB_BLOCK,
    ASTC_10X8_UNORM_BLOCK,
    ASTC_10X8_SRGB_BLOCK,
    ASTC_10X10_UNORM_BLOCK,
    ASTC_10X10_SRGB_BLOCK,
    ASTC_12X10_UNORM_BLOCK,
    ASTC_12X10_SRGB_BLOCK,
    ASTC_12X12_UNORM_BLOCK,
    ASTC_12X12_SRGB_BLOCK,
}

impl Default for RafxFormat {
    fn default() -> Self {
        RafxFormat::UNDEFINED
    }
}

#[cfg(feature = "rafx-vulkan")]
impl Into<vk::Format> for RafxFormat {
    fn into(self) -> vk::Format {
        match self {
            RafxFormat::UNDEFINED => vk::Format::UNDEFINED,
            RafxFormat::R4G4_UNORM_PACK8 => vk::Format::R4G4_UNORM_PACK8,
            RafxFormat::R4G4B4A4_UNORM_PACK16 => vk::Format::R4G4B4A4_UNORM_PACK16,
            RafxFormat::B4G4R4A4_UNORM_PACK16 => vk::Format::B4G4R4A4_UNORM_PACK16,
            RafxFormat::R5G6B5_UNORM_PACK16 => vk::Format::R5G6B5_UNORM_PACK16,
            RafxFormat::B5G6R5_UNORM_PACK16 => vk::Format::B5G6R5_UNORM_PACK16,
            RafxFormat::R5G5B5A1_UNORM_PACK16 => vk::Format::R5G5B5A1_UNORM_PACK16,
            RafxFormat::B5G5R5A1_UNORM_PACK16 => vk::Format::B5G5R5A1_UNORM_PACK16,
            RafxFormat::A1R5G5B5_UNORM_PACK16 => vk::Format::A1R5G5B5_UNORM_PACK16,
            RafxFormat::R8_UNORM => vk::Format::R8_UNORM,
            RafxFormat::R8_SNORM => vk::Format::R8_SNORM,
            RafxFormat::R8_USCALED => vk::Format::R8_USCALED,
            RafxFormat::R8_SSCALED => vk::Format::R8_SSCALED,
            RafxFormat::R8_UINT => vk::Format::R8_UINT,
            RafxFormat::R8_SINT => vk::Format::R8_SINT,
            RafxFormat::R8_SRGB => vk::Format::R8_SRGB,
            RafxFormat::R8G8_UNORM => vk::Format::R8G8_UNORM,
            RafxFormat::R8G8_SNORM => vk::Format::R8G8_SNORM,
            RafxFormat::R8G8_USCALED => vk::Format::R8G8_USCALED,
            RafxFormat::R8G8_SSCALED => vk::Format::R8G8_SSCALED,
            RafxFormat::R8G8_UINT => vk::Format::R8G8_UINT,
            RafxFormat::R8G8_SINT => vk::Format::R8G8_SINT,
            RafxFormat::R8G8_SRGB => vk::Format::R8G8_SRGB,
            RafxFormat::R8G8B8_UNORM => vk::Format::R8G8B8_UNORM,
            RafxFormat::R8G8B8_SNORM => vk::Format::R8G8B8_SNORM,
            RafxFormat::R8G8B8_USCALED => vk::Format::R8G8B8_USCALED,
            RafxFormat::R8G8B8_SSCALED => vk::Format::R8G8B8_SSCALED,
            RafxFormat::R8G8B8_UINT => vk::Format::R8G8B8_UINT,
            RafxFormat::R8G8B8_SINT => vk::Format::R8G8B8_SINT,
            RafxFormat::R8G8B8_SRGB => vk::Format::R8G8B8_SRGB,
            RafxFormat::B8G8R8_UNORM => vk::Format::B8G8R8_UNORM,
            RafxFormat::B8G8R8_SNORM => vk::Format::B8G8R8_SNORM,
            RafxFormat::B8G8R8_USCALED => vk::Format::B8G8R8_USCALED,
            RafxFormat::B8G8R8_SSCALED => vk::Format::B8G8R8_SSCALED,
            RafxFormat::B8G8R8_UINT => vk::Format::B8G8R8_UINT,
            RafxFormat::B8G8R8_SINT => vk::Format::B8G8R8_SINT,
            RafxFormat::B8G8R8_SRGB => vk::Format::B8G8R8_SRGB,
            RafxFormat::R8G8B8A8_UNORM => vk::Format::R8G8B8A8_UNORM,
            RafxFormat::R8G8B8A8_SNORM => vk::Format::R8G8B8A8_SNORM,
            RafxFormat::R8G8B8A8_USCALED => vk::Format::R8G8B8A8_USCALED,
            RafxFormat::R8G8B8A8_SSCALED => vk::Format::R8G8B8A8_SSCALED,
            RafxFormat::R8G8B8A8_UINT => vk::Format::R8G8B8A8_UINT,
            RafxFormat::R8G8B8A8_SINT => vk::Format::R8G8B8A8_SINT,
            RafxFormat::R8G8B8A8_SRGB => vk::Format::R8G8B8A8_SRGB,
            RafxFormat::B8G8R8A8_UNORM => vk::Format::B8G8R8A8_UNORM,
            RafxFormat::B8G8R8A8_SNORM => vk::Format::B8G8R8A8_SNORM,
            RafxFormat::B8G8R8A8_USCALED => vk::Format::B8G8R8A8_USCALED,
            RafxFormat::B8G8R8A8_SSCALED => vk::Format::B8G8R8A8_SSCALED,
            RafxFormat::B8G8R8A8_UINT => vk::Format::B8G8R8A8_UINT,
            RafxFormat::B8G8R8A8_SINT => vk::Format::B8G8R8A8_SINT,
            RafxFormat::B8G8R8A8_SRGB => vk::Format::B8G8R8A8_SRGB,
            RafxFormat::A8B8G8R8_UNORM_PACK32 => vk::Format::A8B8G8R8_UNORM_PACK32,
            RafxFormat::A8B8G8R8_SNORM_PACK32 => vk::Format::A8B8G8R8_SNORM_PACK32,
            RafxFormat::A8B8G8R8_USCALED_PACK32 => vk::Format::A8B8G8R8_USCALED_PACK32,
            RafxFormat::A8B8G8R8_SSCALED_PACK32 => vk::Format::A8B8G8R8_SSCALED_PACK32,
            RafxFormat::A8B8G8R8_UINT_PACK32 => vk::Format::A8B8G8R8_UINT_PACK32,
            RafxFormat::A8B8G8R8_SINT_PACK32 => vk::Format::A8B8G8R8_SINT_PACK32,
            RafxFormat::A8B8G8R8_SRGB_PACK32 => vk::Format::A8B8G8R8_SRGB_PACK32,
            RafxFormat::A2R10G10B10_UNORM_PACK32 => vk::Format::A2R10G10B10_UNORM_PACK32,
            RafxFormat::A2R10G10B10_SNORM_PACK32 => vk::Format::A2R10G10B10_SNORM_PACK32,
            RafxFormat::A2R10G10B10_USCALED_PACK32 => vk::Format::A2R10G10B10_USCALED_PACK32,
            RafxFormat::A2R10G10B10_SSCALED_PACK32 => vk::Format::A2R10G10B10_SSCALED_PACK32,
            RafxFormat::A2R10G10B10_UINT_PACK32 => vk::Format::A2R10G10B10_UINT_PACK32,
            RafxFormat::A2R10G10B10_SINT_PACK32 => vk::Format::A2R10G10B10_SINT_PACK32,
            RafxFormat::A2B10G10R10_UNORM_PACK32 => vk::Format::A2B10G10R10_UNORM_PACK32,
            RafxFormat::A2B10G10R10_SNORM_PACK32 => vk::Format::A2B10G10R10_SNORM_PACK32,
            RafxFormat::A2B10G10R10_USCALED_PACK32 => vk::Format::A2B10G10R10_USCALED_PACK32,
            RafxFormat::A2B10G10R10_SSCALED_PACK32 => vk::Format::A2B10G10R10_SSCALED_PACK32,
            RafxFormat::A2B10G10R10_UINT_PACK32 => vk::Format::A2B10G10R10_UINT_PACK32,
            RafxFormat::A2B10G10R10_SINT_PACK32 => vk::Format::A2B10G10R10_SINT_PACK32,
            RafxFormat::R16_UNORM => vk::Format::R16_UNORM,
            RafxFormat::R16_SNORM => vk::Format::R16_SNORM,
            RafxFormat::R16_USCALED => vk::Format::R16_USCALED,
            RafxFormat::R16_SSCALED => vk::Format::R16_SSCALED,
            RafxFormat::R16_UINT => vk::Format::R16_UINT,
            RafxFormat::R16_SINT => vk::Format::R16_SINT,
            RafxFormat::R16_SFLOAT => vk::Format::R16_SFLOAT,
            RafxFormat::R16G16_UNORM => vk::Format::R16G16_UNORM,
            RafxFormat::R16G16_SNORM => vk::Format::R16G16_SNORM,
            RafxFormat::R16G16_USCALED => vk::Format::R16G16_USCALED,
            RafxFormat::R16G16_SSCALED => vk::Format::R16G16_SSCALED,
            RafxFormat::R16G16_UINT => vk::Format::R16G16_UINT,
            RafxFormat::R16G16_SINT => vk::Format::R16G16_SINT,
            RafxFormat::R16G16_SFLOAT => vk::Format::R16G16_SFLOAT,
            RafxFormat::R16G16B16_UNORM => vk::Format::R16G16B16_UNORM,
            RafxFormat::R16G16B16_SNORM => vk::Format::R16G16B16_SNORM,
            RafxFormat::R16G16B16_USCALED => vk::Format::R16G16B16_USCALED,
            RafxFormat::R16G16B16_SSCALED => vk::Format::R16G16B16_SSCALED,
            RafxFormat::R16G16B16_UINT => vk::Format::R16G16B16_UINT,
            RafxFormat::R16G16B16_SINT => vk::Format::R16G16B16_SINT,
            RafxFormat::R16G16B16_SFLOAT => vk::Format::R16G16B16_SFLOAT,
            RafxFormat::R16G16B16A16_UNORM => vk::Format::R16G16B16A16_UNORM,
            RafxFormat::R16G16B16A16_SNORM => vk::Format::R16G16B16A16_SNORM,
            RafxFormat::R16G16B16A16_USCALED => vk::Format::R16G16B16A16_USCALED,
            RafxFormat::R16G16B16A16_SSCALED => vk::Format::R16G16B16A16_SSCALED,
            RafxFormat::R16G16B16A16_UINT => vk::Format::R16G16B16A16_UINT,
            RafxFormat::R16G16B16A16_SINT => vk::Format::R16G16B16A16_SINT,
            RafxFormat::R16G16B16A16_SFLOAT => vk::Format::R16G16B16A16_SFLOAT,
            RafxFormat::R32_UINT => vk::Format::R32_UINT,
            RafxFormat::R32_SINT => vk::Format::R32_SINT,
            RafxFormat::R32_SFLOAT => vk::Format::R32_SFLOAT,
            RafxFormat::R32G32_UINT => vk::Format::R32G32_UINT,
            RafxFormat::R32G32_SINT => vk::Format::R32G32_SINT,
            RafxFormat::R32G32_SFLOAT => vk::Format::R32G32_SFLOAT,
            RafxFormat::R32G32B32_UINT => vk::Format::R32G32B32_UINT,
            RafxFormat::R32G32B32_SINT => vk::Format::R32G32B32_SINT,
            RafxFormat::R32G32B32_SFLOAT => vk::Format::R32G32B32_SFLOAT,
            RafxFormat::R32G32B32A32_UINT => vk::Format::R32G32B32A32_UINT,
            RafxFormat::R32G32B32A32_SINT => vk::Format::R32G32B32A32_SINT,
            RafxFormat::R32G32B32A32_SFLOAT => vk::Format::R32G32B32A32_SFLOAT,
            RafxFormat::R64_UINT => vk::Format::R64_UINT,
            RafxFormat::R64_SINT => vk::Format::R64_SINT,
            RafxFormat::R64_SFLOAT => vk::Format::R64_SFLOAT,
            RafxFormat::R64G64_UINT => vk::Format::R64G64_UINT,
            RafxFormat::R64G64_SINT => vk::Format::R64G64_SINT,
            RafxFormat::R64G64_SFLOAT => vk::Format::R64G64_SFLOAT,
            RafxFormat::R64G64B64_UINT => vk::Format::R64G64B64_UINT,
            RafxFormat::R64G64B64_SINT => vk::Format::R64G64B64_SINT,
            RafxFormat::R64G64B64_SFLOAT => vk::Format::R64G64B64_SFLOAT,
            RafxFormat::R64G64B64A64_UINT => vk::Format::R64G64B64A64_UINT,
            RafxFormat::R64G64B64A64_SINT => vk::Format::R64G64B64A64_SINT,
            RafxFormat::R64G64B64A64_SFLOAT => vk::Format::R64G64B64A64_SFLOAT,
            RafxFormat::B10G11R11_UFLOAT_PACK32 => vk::Format::B10G11R11_UFLOAT_PACK32,
            RafxFormat::E5B9G9R9_UFLOAT_PACK32 => vk::Format::E5B9G9R9_UFLOAT_PACK32,
            RafxFormat::D16_UNORM => vk::Format::D16_UNORM,
            RafxFormat::X8_D24_UNORM_PACK32 => vk::Format::X8_D24_UNORM_PACK32,
            RafxFormat::D32_SFLOAT => vk::Format::D32_SFLOAT,
            RafxFormat::S8_UINT => vk::Format::S8_UINT,
            RafxFormat::D16_UNORM_S8_UINT => vk::Format::D16_UNORM_S8_UINT,
            RafxFormat::D24_UNORM_S8_UINT => vk::Format::D24_UNORM_S8_UINT,
            RafxFormat::D32_SFLOAT_S8_UINT => vk::Format::D32_SFLOAT_S8_UINT,
            RafxFormat::BC1_RGB_UNORM_BLOCK => vk::Format::BC1_RGB_UNORM_BLOCK,
            RafxFormat::BC1_RGB_SRGB_BLOCK => vk::Format::BC1_RGB_SRGB_BLOCK,
            RafxFormat::BC1_RGBA_UNORM_BLOCK => vk::Format::BC1_RGBA_UNORM_BLOCK,
            RafxFormat::BC1_RGBA_SRGB_BLOCK => vk::Format::BC1_RGBA_SRGB_BLOCK,
            RafxFormat::BC2_UNORM_BLOCK => vk::Format::BC2_UNORM_BLOCK,
            RafxFormat::BC2_SRGB_BLOCK => vk::Format::BC2_SRGB_BLOCK,
            RafxFormat::BC3_UNORM_BLOCK => vk::Format::BC3_UNORM_BLOCK,
            RafxFormat::BC3_SRGB_BLOCK => vk::Format::BC3_SRGB_BLOCK,
            RafxFormat::BC4_UNORM_BLOCK => vk::Format::BC4_UNORM_BLOCK,
            RafxFormat::BC4_SNORM_BLOCK => vk::Format::BC4_SNORM_BLOCK,
            RafxFormat::BC5_UNORM_BLOCK => vk::Format::BC5_UNORM_BLOCK,
            RafxFormat::BC5_SNORM_BLOCK => vk::Format::BC5_SNORM_BLOCK,
            RafxFormat::BC6H_UFLOAT_BLOCK => vk::Format::BC6H_UFLOAT_BLOCK,
            RafxFormat::BC6H_SFLOAT_BLOCK => vk::Format::BC6H_SFLOAT_BLOCK,
            RafxFormat::BC7_UNORM_BLOCK => vk::Format::BC7_UNORM_BLOCK,
            RafxFormat::BC7_SRGB_BLOCK => vk::Format::BC7_SRGB_BLOCK,
            RafxFormat::ETC2_R8G8B8_UNORM_BLOCK => vk::Format::ETC2_R8G8B8_UNORM_BLOCK,
            RafxFormat::ETC2_R8G8B8_SRGB_BLOCK => vk::Format::ETC2_R8G8B8_SRGB_BLOCK,
            RafxFormat::ETC2_R8G8B8A1_UNORM_BLOCK => vk::Format::ETC2_R8G8B8A1_UNORM_BLOCK,
            RafxFormat::ETC2_R8G8B8A1_SRGB_BLOCK => vk::Format::ETC2_R8G8B8A1_SRGB_BLOCK,
            RafxFormat::ETC2_R8G8B8A8_UNORM_BLOCK => vk::Format::ETC2_R8G8B8A8_UNORM_BLOCK,
            RafxFormat::ETC2_R8G8B8A8_SRGB_BLOCK => vk::Format::ETC2_R8G8B8A8_SRGB_BLOCK,
            RafxFormat::EAC_R11_UNORM_BLOCK => vk::Format::EAC_R11_UNORM_BLOCK,
            RafxFormat::EAC_R11_SNORM_BLOCK => vk::Format::EAC_R11_SNORM_BLOCK,
            RafxFormat::EAC_R11G11_UNORM_BLOCK => vk::Format::EAC_R11G11_UNORM_BLOCK,
            RafxFormat::EAC_R11G11_SNORM_BLOCK => vk::Format::EAC_R11G11_SNORM_BLOCK,
            RafxFormat::ASTC_4X4_UNORM_BLOCK => vk::Format::ASTC_4X4_UNORM_BLOCK,
            RafxFormat::ASTC_4X4_SRGB_BLOCK => vk::Format::ASTC_4X4_SRGB_BLOCK,
            RafxFormat::ASTC_5X4_UNORM_BLOCK => vk::Format::ASTC_5X4_UNORM_BLOCK,
            RafxFormat::ASTC_5X4_SRGB_BLOCK => vk::Format::ASTC_5X4_SRGB_BLOCK,
            RafxFormat::ASTC_5X5_UNORM_BLOCK => vk::Format::ASTC_5X5_UNORM_BLOCK,
            RafxFormat::ASTC_5X5_SRGB_BLOCK => vk::Format::ASTC_5X5_SRGB_BLOCK,
            RafxFormat::ASTC_6X5_UNORM_BLOCK => vk::Format::ASTC_6X5_UNORM_BLOCK,
            RafxFormat::ASTC_6X5_SRGB_BLOCK => vk::Format::ASTC_6X5_SRGB_BLOCK,
            RafxFormat::ASTC_6X6_UNORM_BLOCK => vk::Format::ASTC_6X6_UNORM_BLOCK,
            RafxFormat::ASTC_6X6_SRGB_BLOCK => vk::Format::ASTC_6X6_SRGB_BLOCK,
            RafxFormat::ASTC_8X5_UNORM_BLOCK => vk::Format::ASTC_8X5_UNORM_BLOCK,
            RafxFormat::ASTC_8X5_SRGB_BLOCK => vk::Format::ASTC_8X5_SRGB_BLOCK,
            RafxFormat::ASTC_8X6_UNORM_BLOCK => vk::Format::ASTC_8X6_UNORM_BLOCK,
            RafxFormat::ASTC_8X6_SRGB_BLOCK => vk::Format::ASTC_8X6_SRGB_BLOCK,
            RafxFormat::ASTC_8X8_UNORM_BLOCK => vk::Format::ASTC_8X8_UNORM_BLOCK,
            RafxFormat::ASTC_8X8_SRGB_BLOCK => vk::Format::ASTC_8X8_SRGB_BLOCK,
            RafxFormat::ASTC_10X5_UNORM_BLOCK => vk::Format::ASTC_10X5_UNORM_BLOCK,
            RafxFormat::ASTC_10X5_SRGB_BLOCK => vk::Format::ASTC_10X5_SRGB_BLOCK,
            RafxFormat::ASTC_10X6_UNORM_BLOCK => vk::Format::ASTC_10X6_UNORM_BLOCK,
            RafxFormat::ASTC_10X6_SRGB_BLOCK => vk::Format::ASTC_10X6_SRGB_BLOCK,
            RafxFormat::ASTC_10X8_UNORM_BLOCK => vk::Format::ASTC_10X8_UNORM_BLOCK,
            RafxFormat::ASTC_10X8_SRGB_BLOCK => vk::Format::ASTC_10X8_SRGB_BLOCK,
            RafxFormat::ASTC_10X10_UNORM_BLOCK => vk::Format::ASTC_10X10_UNORM_BLOCK,
            RafxFormat::ASTC_10X10_SRGB_BLOCK => vk::Format::ASTC_10X10_SRGB_BLOCK,
            RafxFormat::ASTC_12X10_UNORM_BLOCK => vk::Format::ASTC_12X10_UNORM_BLOCK,
            RafxFormat::ASTC_12X10_SRGB_BLOCK => vk::Format::ASTC_12X10_SRGB_BLOCK,
            RafxFormat::ASTC_12X12_UNORM_BLOCK => vk::Format::ASTC_12X12_UNORM_BLOCK,
            RafxFormat::ASTC_12X12_SRGB_BLOCK => vk::Format::ASTC_12X12_SRGB_BLOCK,
        }
    }
}

#[cfg(feature = "rafx-vulkan")]
impl From<vk::Format> for RafxFormat {
    fn from(format: vk::Format) -> RafxFormat {
        match format {
            vk::Format::UNDEFINED => RafxFormat::UNDEFINED,
            vk::Format::R4G4_UNORM_PACK8 => RafxFormat::R4G4_UNORM_PACK8,
            vk::Format::R4G4B4A4_UNORM_PACK16 => RafxFormat::R4G4B4A4_UNORM_PACK16,
            vk::Format::B4G4R4A4_UNORM_PACK16 => RafxFormat::B4G4R4A4_UNORM_PACK16,
            vk::Format::R5G6B5_UNORM_PACK16 => RafxFormat::R5G6B5_UNORM_PACK16,
            vk::Format::B5G6R5_UNORM_PACK16 => RafxFormat::B5G6R5_UNORM_PACK16,
            vk::Format::R5G5B5A1_UNORM_PACK16 => RafxFormat::R5G5B5A1_UNORM_PACK16,
            vk::Format::B5G5R5A1_UNORM_PACK16 => RafxFormat::B5G5R5A1_UNORM_PACK16,
            vk::Format::A1R5G5B5_UNORM_PACK16 => RafxFormat::A1R5G5B5_UNORM_PACK16,
            vk::Format::R8_UNORM => RafxFormat::R8_UNORM,
            vk::Format::R8_SNORM => RafxFormat::R8_SNORM,
            vk::Format::R8_USCALED => RafxFormat::R8_USCALED,
            vk::Format::R8_SSCALED => RafxFormat::R8_SSCALED,
            vk::Format::R8_UINT => RafxFormat::R8_UINT,
            vk::Format::R8_SINT => RafxFormat::R8_SINT,
            vk::Format::R8_SRGB => RafxFormat::R8_SRGB,
            vk::Format::R8G8_UNORM => RafxFormat::R8G8_UNORM,
            vk::Format::R8G8_SNORM => RafxFormat::R8G8_SNORM,
            vk::Format::R8G8_USCALED => RafxFormat::R8G8_USCALED,
            vk::Format::R8G8_SSCALED => RafxFormat::R8G8_SSCALED,
            vk::Format::R8G8_UINT => RafxFormat::R8G8_UINT,
            vk::Format::R8G8_SINT => RafxFormat::R8G8_SINT,
            vk::Format::R8G8_SRGB => RafxFormat::R8G8_SRGB,
            vk::Format::R8G8B8_UNORM => RafxFormat::R8G8B8_UNORM,
            vk::Format::R8G8B8_SNORM => RafxFormat::R8G8B8_SNORM,
            vk::Format::R8G8B8_USCALED => RafxFormat::R8G8B8_USCALED,
            vk::Format::R8G8B8_SSCALED => RafxFormat::R8G8B8_SSCALED,
            vk::Format::R8G8B8_UINT => RafxFormat::R8G8B8_UINT,
            vk::Format::R8G8B8_SINT => RafxFormat::R8G8B8_SINT,
            vk::Format::R8G8B8_SRGB => RafxFormat::R8G8B8_SRGB,
            vk::Format::B8G8R8_UNORM => RafxFormat::B8G8R8_UNORM,
            vk::Format::B8G8R8_SNORM => RafxFormat::B8G8R8_SNORM,
            vk::Format::B8G8R8_USCALED => RafxFormat::B8G8R8_USCALED,
            vk::Format::B8G8R8_SSCALED => RafxFormat::B8G8R8_SSCALED,
            vk::Format::B8G8R8_UINT => RafxFormat::B8G8R8_UINT,
            vk::Format::B8G8R8_SINT => RafxFormat::B8G8R8_SINT,
            vk::Format::B8G8R8_SRGB => RafxFormat::B8G8R8_SRGB,
            vk::Format::R8G8B8A8_UNORM => RafxFormat::R8G8B8A8_UNORM,
            vk::Format::R8G8B8A8_SNORM => RafxFormat::R8G8B8A8_SNORM,
            vk::Format::R8G8B8A8_USCALED => RafxFormat::R8G8B8A8_USCALED,
            vk::Format::R8G8B8A8_SSCALED => RafxFormat::R8G8B8A8_SSCALED,
            vk::Format::R8G8B8A8_UINT => RafxFormat::R8G8B8A8_UINT,
            vk::Format::R8G8B8A8_SINT => RafxFormat::R8G8B8A8_SINT,
            vk::Format::R8G8B8A8_SRGB => RafxFormat::R8G8B8A8_SRGB,
            vk::Format::B8G8R8A8_UNORM => RafxFormat::B8G8R8A8_UNORM,
            vk::Format::B8G8R8A8_SNORM => RafxFormat::B8G8R8A8_SNORM,
            vk::Format::B8G8R8A8_USCALED => RafxFormat::B8G8R8A8_USCALED,
            vk::Format::B8G8R8A8_SSCALED => RafxFormat::B8G8R8A8_SSCALED,
            vk::Format::B8G8R8A8_UINT => RafxFormat::B8G8R8A8_UINT,
            vk::Format::B8G8R8A8_SINT => RafxFormat::B8G8R8A8_SINT,
            vk::Format::B8G8R8A8_SRGB => RafxFormat::B8G8R8A8_SRGB,
            vk::Format::A8B8G8R8_UNORM_PACK32 => RafxFormat::A8B8G8R8_UNORM_PACK32,
            vk::Format::A8B8G8R8_SNORM_PACK32 => RafxFormat::A8B8G8R8_SNORM_PACK32,
            vk::Format::A8B8G8R8_USCALED_PACK32 => RafxFormat::A8B8G8R8_USCALED_PACK32,
            vk::Format::A8B8G8R8_SSCALED_PACK32 => RafxFormat::A8B8G8R8_SSCALED_PACK32,
            vk::Format::A8B8G8R8_UINT_PACK32 => RafxFormat::A8B8G8R8_UINT_PACK32,
            vk::Format::A8B8G8R8_SINT_PACK32 => RafxFormat::A8B8G8R8_SINT_PACK32,
            vk::Format::A8B8G8R8_SRGB_PACK32 => RafxFormat::A8B8G8R8_SRGB_PACK32,
            vk::Format::A2R10G10B10_UNORM_PACK32 => RafxFormat::A2R10G10B10_UNORM_PACK32,
            vk::Format::A2R10G10B10_SNORM_PACK32 => RafxFormat::A2R10G10B10_SNORM_PACK32,
            vk::Format::A2R10G10B10_USCALED_PACK32 => RafxFormat::A2R10G10B10_USCALED_PACK32,
            vk::Format::A2R10G10B10_SSCALED_PACK32 => RafxFormat::A2R10G10B10_SSCALED_PACK32,
            vk::Format::A2R10G10B10_UINT_PACK32 => RafxFormat::A2R10G10B10_UINT_PACK32,
            vk::Format::A2R10G10B10_SINT_PACK32 => RafxFormat::A2R10G10B10_SINT_PACK32,
            vk::Format::A2B10G10R10_UNORM_PACK32 => RafxFormat::A2B10G10R10_UNORM_PACK32,
            vk::Format::A2B10G10R10_SNORM_PACK32 => RafxFormat::A2B10G10R10_SNORM_PACK32,
            vk::Format::A2B10G10R10_USCALED_PACK32 => RafxFormat::A2B10G10R10_USCALED_PACK32,
            vk::Format::A2B10G10R10_SSCALED_PACK32 => RafxFormat::A2B10G10R10_SSCALED_PACK32,
            vk::Format::A2B10G10R10_UINT_PACK32 => RafxFormat::A2B10G10R10_UINT_PACK32,
            vk::Format::A2B10G10R10_SINT_PACK32 => RafxFormat::A2B10G10R10_SINT_PACK32,
            vk::Format::R16_UNORM => RafxFormat::R16_UNORM,
            vk::Format::R16_SNORM => RafxFormat::R16_SNORM,
            vk::Format::R16_USCALED => RafxFormat::R16_USCALED,
            vk::Format::R16_SSCALED => RafxFormat::R16_SSCALED,
            vk::Format::R16_UINT => RafxFormat::R16_UINT,
            vk::Format::R16_SINT => RafxFormat::R16_SINT,
            vk::Format::R16_SFLOAT => RafxFormat::R16_SFLOAT,
            vk::Format::R16G16_UNORM => RafxFormat::R16G16_UNORM,
            vk::Format::R16G16_SNORM => RafxFormat::R16G16_SNORM,
            vk::Format::R16G16_USCALED => RafxFormat::R16G16_USCALED,
            vk::Format::R16G16_SSCALED => RafxFormat::R16G16_SSCALED,
            vk::Format::R16G16_UINT => RafxFormat::R16G16_UINT,
            vk::Format::R16G16_SINT => RafxFormat::R16G16_SINT,
            vk::Format::R16G16_SFLOAT => RafxFormat::R16G16_SFLOAT,
            vk::Format::R16G16B16_UNORM => RafxFormat::R16G16B16_UNORM,
            vk::Format::R16G16B16_SNORM => RafxFormat::R16G16B16_SNORM,
            vk::Format::R16G16B16_USCALED => RafxFormat::R16G16B16_USCALED,
            vk::Format::R16G16B16_SSCALED => RafxFormat::R16G16B16_SSCALED,
            vk::Format::R16G16B16_UINT => RafxFormat::R16G16B16_UINT,
            vk::Format::R16G16B16_SINT => RafxFormat::R16G16B16_SINT,
            vk::Format::R16G16B16_SFLOAT => RafxFormat::R16G16B16_SFLOAT,
            vk::Format::R16G16B16A16_UNORM => RafxFormat::R16G16B16A16_UNORM,
            vk::Format::R16G16B16A16_SNORM => RafxFormat::R16G16B16A16_SNORM,
            vk::Format::R16G16B16A16_USCALED => RafxFormat::R16G16B16A16_USCALED,
            vk::Format::R16G16B16A16_SSCALED => RafxFormat::R16G16B16A16_SSCALED,
            vk::Format::R16G16B16A16_UINT => RafxFormat::R16G16B16A16_UINT,
            vk::Format::R16G16B16A16_SINT => RafxFormat::R16G16B16A16_SINT,
            vk::Format::R16G16B16A16_SFLOAT => RafxFormat::R16G16B16A16_SFLOAT,
            vk::Format::R32_UINT => RafxFormat::R32_UINT,
            vk::Format::R32_SINT => RafxFormat::R32_SINT,
            vk::Format::R32_SFLOAT => RafxFormat::R32_SFLOAT,
            vk::Format::R32G32_UINT => RafxFormat::R32G32_UINT,
            vk::Format::R32G32_SINT => RafxFormat::R32G32_SINT,
            vk::Format::R32G32_SFLOAT => RafxFormat::R32G32_SFLOAT,
            vk::Format::R32G32B32_UINT => RafxFormat::R32G32B32_UINT,
            vk::Format::R32G32B32_SINT => RafxFormat::R32G32B32_SINT,
            vk::Format::R32G32B32_SFLOAT => RafxFormat::R32G32B32_SFLOAT,
            vk::Format::R32G32B32A32_UINT => RafxFormat::R32G32B32A32_UINT,
            vk::Format::R32G32B32A32_SINT => RafxFormat::R32G32B32A32_SINT,
            vk::Format::R32G32B32A32_SFLOAT => RafxFormat::R32G32B32A32_SFLOAT,
            vk::Format::R64_UINT => RafxFormat::R64_UINT,
            vk::Format::R64_SINT => RafxFormat::R64_SINT,
            vk::Format::R64_SFLOAT => RafxFormat::R64_SFLOAT,
            vk::Format::R64G64_UINT => RafxFormat::R64G64_UINT,
            vk::Format::R64G64_SINT => RafxFormat::R64G64_SINT,
            vk::Format::R64G64_SFLOAT => RafxFormat::R64G64_SFLOAT,
            vk::Format::R64G64B64_UINT => RafxFormat::R64G64B64_UINT,
            vk::Format::R64G64B64_SINT => RafxFormat::R64G64B64_SINT,
            vk::Format::R64G64B64_SFLOAT => RafxFormat::R64G64B64_SFLOAT,
            vk::Format::R64G64B64A64_UINT => RafxFormat::R64G64B64A64_UINT,
            vk::Format::R64G64B64A64_SINT => RafxFormat::R64G64B64A64_SINT,
            vk::Format::R64G64B64A64_SFLOAT => RafxFormat::R64G64B64A64_SFLOAT,
            vk::Format::B10G11R11_UFLOAT_PACK32 => RafxFormat::B10G11R11_UFLOAT_PACK32,
            vk::Format::E5B9G9R9_UFLOAT_PACK32 => RafxFormat::E5B9G9R9_UFLOAT_PACK32,
            vk::Format::D16_UNORM => RafxFormat::D16_UNORM,
            vk::Format::X8_D24_UNORM_PACK32 => RafxFormat::X8_D24_UNORM_PACK32,
            vk::Format::D32_SFLOAT => RafxFormat::D32_SFLOAT,
            vk::Format::S8_UINT => RafxFormat::S8_UINT,
            vk::Format::D16_UNORM_S8_UINT => RafxFormat::D16_UNORM_S8_UINT,
            vk::Format::D24_UNORM_S8_UINT => RafxFormat::D24_UNORM_S8_UINT,
            vk::Format::D32_SFLOAT_S8_UINT => RafxFormat::D32_SFLOAT_S8_UINT,
            vk::Format::BC1_RGB_UNORM_BLOCK => RafxFormat::BC1_RGB_UNORM_BLOCK,
            vk::Format::BC1_RGB_SRGB_BLOCK => RafxFormat::BC1_RGB_SRGB_BLOCK,
            vk::Format::BC1_RGBA_UNORM_BLOCK => RafxFormat::BC1_RGBA_UNORM_BLOCK,
            vk::Format::BC1_RGBA_SRGB_BLOCK => RafxFormat::BC1_RGBA_SRGB_BLOCK,
            vk::Format::BC2_UNORM_BLOCK => RafxFormat::BC2_UNORM_BLOCK,
            vk::Format::BC2_SRGB_BLOCK => RafxFormat::BC2_SRGB_BLOCK,
            vk::Format::BC3_UNORM_BLOCK => RafxFormat::BC3_UNORM_BLOCK,
            vk::Format::BC3_SRGB_BLOCK => RafxFormat::BC3_SRGB_BLOCK,
            vk::Format::BC4_UNORM_BLOCK => RafxFormat::BC4_UNORM_BLOCK,
            vk::Format::BC4_SNORM_BLOCK => RafxFormat::BC4_SNORM_BLOCK,
            vk::Format::BC5_UNORM_BLOCK => RafxFormat::BC5_UNORM_BLOCK,
            vk::Format::BC5_SNORM_BLOCK => RafxFormat::BC5_SNORM_BLOCK,
            vk::Format::BC6H_UFLOAT_BLOCK => RafxFormat::BC6H_UFLOAT_BLOCK,
            vk::Format::BC6H_SFLOAT_BLOCK => RafxFormat::BC6H_SFLOAT_BLOCK,
            vk::Format::BC7_UNORM_BLOCK => RafxFormat::BC7_UNORM_BLOCK,
            vk::Format::BC7_SRGB_BLOCK => RafxFormat::BC7_SRGB_BLOCK,
            vk::Format::ETC2_R8G8B8_UNORM_BLOCK => RafxFormat::ETC2_R8G8B8_UNORM_BLOCK,
            vk::Format::ETC2_R8G8B8_SRGB_BLOCK => RafxFormat::ETC2_R8G8B8_SRGB_BLOCK,
            vk::Format::ETC2_R8G8B8A1_UNORM_BLOCK => RafxFormat::ETC2_R8G8B8A1_UNORM_BLOCK,
            vk::Format::ETC2_R8G8B8A1_SRGB_BLOCK => RafxFormat::ETC2_R8G8B8A1_SRGB_BLOCK,
            vk::Format::ETC2_R8G8B8A8_UNORM_BLOCK => RafxFormat::ETC2_R8G8B8A8_UNORM_BLOCK,
            vk::Format::ETC2_R8G8B8A8_SRGB_BLOCK => RafxFormat::ETC2_R8G8B8A8_SRGB_BLOCK,
            vk::Format::EAC_R11_UNORM_BLOCK => RafxFormat::EAC_R11_UNORM_BLOCK,
            vk::Format::EAC_R11_SNORM_BLOCK => RafxFormat::EAC_R11_SNORM_BLOCK,
            vk::Format::EAC_R11G11_UNORM_BLOCK => RafxFormat::EAC_R11G11_UNORM_BLOCK,
            vk::Format::EAC_R11G11_SNORM_BLOCK => RafxFormat::EAC_R11G11_SNORM_BLOCK,
            vk::Format::ASTC_4X4_UNORM_BLOCK => RafxFormat::ASTC_4X4_UNORM_BLOCK,
            vk::Format::ASTC_4X4_SRGB_BLOCK => RafxFormat::ASTC_4X4_SRGB_BLOCK,
            vk::Format::ASTC_5X4_UNORM_BLOCK => RafxFormat::ASTC_5X4_UNORM_BLOCK,
            vk::Format::ASTC_5X4_SRGB_BLOCK => RafxFormat::ASTC_5X4_SRGB_BLOCK,
            vk::Format::ASTC_5X5_UNORM_BLOCK => RafxFormat::ASTC_5X5_UNORM_BLOCK,
            vk::Format::ASTC_5X5_SRGB_BLOCK => RafxFormat::ASTC_5X5_SRGB_BLOCK,
            vk::Format::ASTC_6X5_UNORM_BLOCK => RafxFormat::ASTC_6X5_UNORM_BLOCK,
            vk::Format::ASTC_6X5_SRGB_BLOCK => RafxFormat::ASTC_6X5_SRGB_BLOCK,
            vk::Format::ASTC_6X6_UNORM_BLOCK => RafxFormat::ASTC_6X6_UNORM_BLOCK,
            vk::Format::ASTC_6X6_SRGB_BLOCK => RafxFormat::ASTC_6X6_SRGB_BLOCK,
            vk::Format::ASTC_8X5_UNORM_BLOCK => RafxFormat::ASTC_8X5_UNORM_BLOCK,
            vk::Format::ASTC_8X5_SRGB_BLOCK => RafxFormat::ASTC_8X5_SRGB_BLOCK,
            vk::Format::ASTC_8X6_UNORM_BLOCK => RafxFormat::ASTC_8X6_UNORM_BLOCK,
            vk::Format::ASTC_8X6_SRGB_BLOCK => RafxFormat::ASTC_8X6_SRGB_BLOCK,
            vk::Format::ASTC_8X8_UNORM_BLOCK => RafxFormat::ASTC_8X8_UNORM_BLOCK,
            vk::Format::ASTC_8X8_SRGB_BLOCK => RafxFormat::ASTC_8X8_SRGB_BLOCK,
            vk::Format::ASTC_10X5_UNORM_BLOCK => RafxFormat::ASTC_10X5_UNORM_BLOCK,
            vk::Format::ASTC_10X5_SRGB_BLOCK => RafxFormat::ASTC_10X5_SRGB_BLOCK,
            vk::Format::ASTC_10X6_UNORM_BLOCK => RafxFormat::ASTC_10X6_UNORM_BLOCK,
            vk::Format::ASTC_10X6_SRGB_BLOCK => RafxFormat::ASTC_10X6_SRGB_BLOCK,
            vk::Format::ASTC_10X8_UNORM_BLOCK => RafxFormat::ASTC_10X8_UNORM_BLOCK,
            vk::Format::ASTC_10X8_SRGB_BLOCK => RafxFormat::ASTC_10X8_SRGB_BLOCK,
            vk::Format::ASTC_10X10_UNORM_BLOCK => RafxFormat::ASTC_10X10_UNORM_BLOCK,
            vk::Format::ASTC_10X10_SRGB_BLOCK => RafxFormat::ASTC_10X10_SRGB_BLOCK,
            vk::Format::ASTC_12X10_UNORM_BLOCK => RafxFormat::ASTC_12X10_UNORM_BLOCK,
            vk::Format::ASTC_12X10_SRGB_BLOCK => RafxFormat::ASTC_12X10_SRGB_BLOCK,
            vk::Format::ASTC_12X12_UNORM_BLOCK => RafxFormat::ASTC_12X12_UNORM_BLOCK,
            vk::Format::ASTC_12X12_SRGB_BLOCK => RafxFormat::ASTC_12X12_SRGB_BLOCK,
            _ => unimplemented!(),
        }
    }
}

#[cfg(feature = "rafx-metal")]
impl Into<MTLPixelFormat> for RafxFormat {
    fn into(self) -> MTLPixelFormat {
        match self {
            RafxFormat::UNDEFINED => MTLPixelFormat::Invalid,
            // RafxFormat::R4G4_UNORM_PACK8 => MTLPixelFormat::R4G4_UNORM_PACK8,
            // RafxFormat::R4G4B4A4_UNORM_PACK16 => MTLPixelFormat::R4G4B4A4_UNORM_PACK16,
            // RafxFormat::B4G4R4A4_UNORM_PACK16 => MTLPixelFormat::B4G4R4A4_UNORM_PACK16,
            // RafxFormat::R5G6B5_UNORM_PACK16 => MTLPixelFormat::R5G6B5_UNORM_PACK16,
            RafxFormat::B5G6R5_UNORM_PACK16 => MTLPixelFormat::B5G6R5Unorm,
            // RafxFormat::R5G5B5A1_UNORM_PACK16 => MTLPixelFormat::R5G5B5A1_UNORM_PACK16,
            RafxFormat::B5G5R5A1_UNORM_PACK16 => MTLPixelFormat::BGR5A1Unorm,
            // RafxFormat::A1R5G5B5_UNORM_PACK16 => MTLPixelFormat::A1R5G5B5_UNORM_PACK16,
            RafxFormat::R8_UNORM => MTLPixelFormat::R8Unorm,
            RafxFormat::R8_SNORM => MTLPixelFormat::R8Snorm,
            //RafxFormat::R8_USCALED => MTLPixelFormat::R8_USCALED,
            //RafxFormat::R8_SSCALED => MTLPixelFormat::R8_SSCALED,
            RafxFormat::R8_UINT => MTLPixelFormat::R8Uint,
            RafxFormat::R8_SINT => MTLPixelFormat::R8Sint,
            RafxFormat::R8_SRGB => MTLPixelFormat::R8Unorm_sRGB,
            RafxFormat::R8G8_UNORM => MTLPixelFormat::RG8Unorm,
            RafxFormat::R8G8_SNORM => MTLPixelFormat::RG8Snorm,
            //RafxFormat::R8G8_USCALED => MTLPixelFormat::R8G8_USCALED,
            //RafxFormat::R8G8_SSCALED => MTLPixelFormat::R8G8_SSCALED,
            RafxFormat::R8G8_UINT => MTLPixelFormat::RG8Uint,
            RafxFormat::R8G8_SINT => MTLPixelFormat::RG8Sint,
            RafxFormat::R8G8_SRGB => MTLPixelFormat::RG8Unorm_sRGB,
            // RafxFormat::R8G8B8_UNORM => MTLPixelFormat::R8G8B8_UNORM,
            // RafxFormat::R8G8B8_SNORM => MTLPixelFormat::R8G8B8_SNORM,
            // RafxFormat::R8G8B8_USCALED => MTLPixelFormat::R8G8B8_USCALED,
            // RafxFormat::R8G8B8_SSCALED => MTLPixelFormat::R8G8B8_SSCALED,
            // RafxFormat::R8G8B8_UINT => MTLPixelFormat::R8G8B8_UINT,
            // RafxFormat::R8G8B8_SINT => MTLPixelFormat::R8G8B8_SINT,
            // RafxFormat::R8G8B8_SRGB => MTLPixelFormat::R8G8B8_SRGB,
            // RafxFormat::B8G8R8_UNORM => MTLPixelFormat::B8G8R8_UNORM,
            // RafxFormat::B8G8R8_SNORM => MTLPixelFormat::B8G8R8_SNORM,
            // RafxFormat::B8G8R8_USCALED => MTLPixelFormat::B8G8R8_USCALED,
            // RafxFormat::B8G8R8_SSCALED => MTLPixelFormat::B8G8R8_SSCALED,
            // RafxFormat::B8G8R8_UINT => MTLPixelFormat::B8G8R8_UINT,
            // RafxFormat::B8G8R8_SINT => MTLPixelFormat::B8G8R8_SINT,
            // RafxFormat::B8G8R8_SRGB => MTLPixelFormat::B8G8R8_SRGB,
            RafxFormat::R8G8B8A8_UNORM => MTLPixelFormat::RGBA8Unorm,
            RafxFormat::R8G8B8A8_SNORM => MTLPixelFormat::RGBA8Snorm,
            // RafxFormat::R8G8B8A8_USCALED => MTLPixelFormat::R8G8B8A8_USCALED,
            // RafxFormat::R8G8B8A8_SSCALED => MTLPixelFormat::R8G8B8A8_SSCALED,
            RafxFormat::R8G8B8A8_UINT => MTLPixelFormat::RGBA8Uint,
            RafxFormat::R8G8B8A8_SINT => MTLPixelFormat::RGBA8Sint,
            RafxFormat::R8G8B8A8_SRGB => MTLPixelFormat::RGBA8Unorm_sRGB,
            RafxFormat::B8G8R8A8_UNORM => MTLPixelFormat::BGRA8Unorm,
            // RafxFormat::B8G8R8A8_SNORM => MTLPixelFormat::B8G8R8A8_SNORM,
            // RafxFormat::B8G8R8A8_USCALED => MTLPixelFormat::B8G8R8A8_USCALED,
            // RafxFormat::B8G8R8A8_SSCALED => MTLPixelFormat::B8G8R8A8_SSCALED,
            //RafxFormat::B8G8R8A8_UINT => MTLPixelFormat::B8G8R8A8_UINT,
            //RafxFormat::B8G8R8A8_SINT => MTLPixelFormat::B8G8R8A8_SINT,
            RafxFormat::B8G8R8A8_SRGB => MTLPixelFormat::BGRA8Unorm_sRGB,
            // RafxFormat::A8B8G8R8_UNORM_PACK32 => MTLPixelFormat::A8B8G8R8_UNORM_PACK32,
            // RafxFormat::A8B8G8R8_SNORM_PACK32 => MTLPixelFormat::A8B8G8R8_SNORM_PACK32,
            // RafxFormat::A8B8G8R8_USCALED_PACK32 => MTLPixelFormat::A8B8G8R8_USCALED_PACK32,
            // RafxFormat::A8B8G8R8_SSCALED_PACK32 => MTLPixelFormat::A8B8G8R8_SSCALED_PACK32,
            // RafxFormat::A8B8G8R8_UINT_PACK32 => MTLPixelFormat::A8B8G8R8_UINT_PACK32,
            // RafxFormat::A8B8G8R8_SINT_PACK32 => MTLPixelFormat::A8B8G8R8_SINT_PACK32,
            // RafxFormat::A8B8G8R8_SRGB_PACK32 => MTLPixelFormat::A8B8G8R8_SRGB_PACK32,
            // RafxFormat::A2R10G10B10_UNORM_PACK32 => MTLPixelFormat::A2R10G10B10_UNORM_PACK32,
            // RafxFormat::A2R10G10B10_SNORM_PACK32 => MTLPixelFormat::A2R10G10B10_SNORM_PACK32,
            // RafxFormat::A2R10G10B10_USCALED_PACK32 => MTLPixelFormat::A2R10G10B10_USCALED_PACK32,
            // RafxFormat::A2R10G10B10_SSCALED_PACK32 => MTLPixelFormat::A2R10G10B10_SSCALED_PACK32,
            // RafxFormat::A2R10G10B10_UINT_PACK32 => MTLPixelFormat::A2R10G10B10_UINT_PACK32,
            // RafxFormat::A2R10G10B10_SINT_PACK32 => MTLPixelFormat::A2R10G10B10_SINT_PACK32,
            // RafxFormat::A2B10G10R10_UNORM_PACK32 => MTLPixelFormat::A2B10G10R10_UNORM_PACK32,
            // RafxFormat::A2B10G10R10_SNORM_PACK32 => MTLPixelFormat::A2B10G10R10_SNORM_PACK32,
            // RafxFormat::A2B10G10R10_USCALED_PACK32 => MTLPixelFormat::A2B10G10R10_USCALED_PACK32,
            // RafxFormat::A2B10G10R10_SSCALED_PACK32 => MTLPixelFormat::A2B10G10R10_SSCALED_PACK32,
            // RafxFormat::A2B10G10R10_UINT_PACK32 => MTLPixelFormat::A2B10G10R10_UINT_PACK32,
            // RafxFormat::A2B10G10R10_SINT_PACK32 => MTLPixelFormat::A2B10G10R10_SINT_PACK32,
            RafxFormat::R16_UNORM => MTLPixelFormat::R16Unorm,
            RafxFormat::R16_SNORM => MTLPixelFormat::R16Snorm,
            // RafxFormat::R16_USCALED => MTLPixelFormat::R16_USCALED,
            // RafxFormat::R16_SSCALED => MTLPixelFormat::R16_SSCALED,
            RafxFormat::R16_UINT => MTLPixelFormat::R16Uint,
            RafxFormat::R16_SINT => MTLPixelFormat::R16Sint,
            RafxFormat::R16_SFLOAT => MTLPixelFormat::R16Float,
            RafxFormat::R16G16_UNORM => MTLPixelFormat::RG16Float,
            RafxFormat::R16G16_SNORM => MTLPixelFormat::RG16Snorm,
            // RafxFormat::R16G16_USCALED => MTLPixelFormat::R16G16_USCALED,
            // RafxFormat::R16G16_SSCALED => MTLPixelFormat::R16G16_SSCALED,
            RafxFormat::R16G16_UINT => MTLPixelFormat::RG16Uint,
            RafxFormat::R16G16_SINT => MTLPixelFormat::RG16Sint,
            RafxFormat::R16G16_SFLOAT => MTLPixelFormat::RG16Float,
            // RafxFormat::R16G16B16_UNORM => MTLPixelFormat::R16G16B16_UNORM,
            // RafxFormat::R16G16B16_SNORM => MTLPixelFormat::R16G16B16_SNORM,
            // RafxFormat::R16G16B16_USCALED => MTLPixelFormat::R16G16B16_USCALED,
            // RafxFormat::R16G16B16_SSCALED => MTLPixelFormat::R16G16B16_SSCALED,
            // RafxFormat::R16G16B16_UINT => MTLPixelFormat::R16G16B16_UINT,
            // RafxFormat::R16G16B16_SINT => MTLPixelFormat::R16G16B16_SINT,
            // RafxFormat::R16G16B16_SFLOAT => MTLPixelFormat::R16G16B16_SFLOAT,
            RafxFormat::R16G16B16A16_UNORM => MTLPixelFormat::RGBA16Unorm,
            RafxFormat::R16G16B16A16_SNORM => MTLPixelFormat::RGBA16Snorm,
            // RafxFormat::R16G16B16A16_USCALED => MTLPixelFormat::R16G16B16A16_USCALED,
            // RafxFormat::R16G16B16A16_SSCALED => MTLPixelFormat::R16G16B16A16_SSCALED,
            RafxFormat::R16G16B16A16_UINT => MTLPixelFormat::RGBA16Uint,
            RafxFormat::R16G16B16A16_SINT => MTLPixelFormat::RGBA16Sint,
            RafxFormat::R16G16B16A16_SFLOAT => MTLPixelFormat::RGBA16Float,
            RafxFormat::R32_UINT => MTLPixelFormat::R32Uint,
            RafxFormat::R32_SINT => MTLPixelFormat::R32Sint,
            RafxFormat::R32_SFLOAT => MTLPixelFormat::R32Float,
            RafxFormat::R32G32_UINT => MTLPixelFormat::RG32Uint,
            RafxFormat::R32G32_SINT => MTLPixelFormat::RG32Sint,
            RafxFormat::R32G32_SFLOAT => MTLPixelFormat::RG32Float,
            // RafxFormat::R32G32B32_UINT => MTLPixelFormat::R32G32B32_UINT,
            // RafxFormat::R32G32B32_SINT => MTLPixelFormat::R32G32B32_SINT,
            // RafxFormat::R32G32B32_SFLOAT => MTLPixelFormat::R32G32B32_SFLOAT,
            RafxFormat::R32G32B32A32_UINT => MTLPixelFormat::RGBA32Uint,
            RafxFormat::R32G32B32A32_SINT => MTLPixelFormat::RGBA32Sint,
            RafxFormat::R32G32B32A32_SFLOAT => MTLPixelFormat::RGBA32Float,
            // RafxFormat::R64_UINT => MTLPixelFormat::R64_UINT,
            // RafxFormat::R64_SINT => MTLPixelFormat::R64_SINT,
            // RafxFormat::R64_SFLOAT => MTLPixelFormat::R64_SFLOAT,
            // RafxFormat::R64G64_UINT => MTLPixelFormat::R64G64_UINT,
            // RafxFormat::R64G64_SINT => MTLPixelFormat::R64G64_SINT,
            // RafxFormat::R64G64_SFLOAT => MTLPixelFormat::R64G64_SFLOAT,
            // RafxFormat::R64G64B64_UINT => MTLPixelFormat::R64G64B64_UINT,
            // RafxFormat::R64G64B64_SINT => MTLPixelFormat::R64G64B64_SINT,
            // RafxFormat::R64G64B64_SFLOAT => MTLPixelFormat::R64G64B64_SFLOAT,
            // RafxFormat::R64G64B64A64_UINT => MTLPixelFormat::R64G64B64A64_UINT,
            // RafxFormat::R64G64B64A64_SINT => MTLPixelFormat::R64G64B64A64_SINT,
            // RafxFormat::R64G64B64A64_SFLOAT => MTLPixelFormat::R64G64B64A64_SFLOAT,
            //RafxFormat::B10G11R11_UFLOAT_PACK32 => MTLPixelFormat::B10G11R11_UFLOAT_PACK32,
            //RafxFormat::E5B9G9R9_UFLOAT_PACK32 => MTLPixelFormat::E5B9G9R9_UFLOAT_PACK32,
            RafxFormat::D16_UNORM => MTLPixelFormat::Depth16Unorm,
            // RafxFormat::X8_D24_UNORM_PACK32 => MTLPixelFormat::X8_D24_UNORM_PACK32,
            RafxFormat::D32_SFLOAT => MTLPixelFormat::Depth32Float,
            RafxFormat::S8_UINT => MTLPixelFormat::Stencil8,
            // RafxFormat::D16_UNORM_S8_UINT => MTLPixelFormat::D16_UNORM_S8_UINT,
            RafxFormat::D24_UNORM_S8_UINT => MTLPixelFormat::Depth24Unorm_Stencil8,
            RafxFormat::D32_SFLOAT_S8_UINT => MTLPixelFormat::Depth32Float_Stencil8,
            // RafxFormat::BC1_RGB_UNORM_BLOCK => MTLPixelFormat::BC1_RGB_UNORM_BLOCK,
            // RafxFormat::BC1_RGB_SRGB_BLOCK => MTLPixelFormat::BC1_RGB_SRGB_BLOCK,
            RafxFormat::BC1_RGBA_UNORM_BLOCK => MTLPixelFormat::BC1_RGBA,
            RafxFormat::BC1_RGBA_SRGB_BLOCK => MTLPixelFormat::BC1_RGBA_sRGB,
            RafxFormat::BC2_UNORM_BLOCK => MTLPixelFormat::BC2_RGBA,
            RafxFormat::BC2_SRGB_BLOCK => MTLPixelFormat::BC2_RGBA_sRGB,
            RafxFormat::BC3_UNORM_BLOCK => MTLPixelFormat::BC3_RGBA,
            RafxFormat::BC3_SRGB_BLOCK => MTLPixelFormat::BC3_RGBA_sRGB,
            RafxFormat::BC4_UNORM_BLOCK => MTLPixelFormat::BC4_RUnorm,
            RafxFormat::BC4_SNORM_BLOCK => MTLPixelFormat::BC4_RSnorm,
            RafxFormat::BC5_UNORM_BLOCK => MTLPixelFormat::BC5_RGUnorm,
            RafxFormat::BC5_SNORM_BLOCK => MTLPixelFormat::BC5_RGSnorm,
            RafxFormat::BC6H_UFLOAT_BLOCK => MTLPixelFormat::BC6H_RGBUfloat,
            RafxFormat::BC6H_SFLOAT_BLOCK => MTLPixelFormat::BC6H_RGBFloat,
            RafxFormat::BC7_UNORM_BLOCK => MTLPixelFormat::BC7_RGBAUnorm,
            RafxFormat::BC7_SRGB_BLOCK => MTLPixelFormat::BC7_RGBAUnorm_sRGB,
            RafxFormat::ETC2_R8G8B8_UNORM_BLOCK => MTLPixelFormat::ETC2_RGB8,
            RafxFormat::ETC2_R8G8B8_SRGB_BLOCK => MTLPixelFormat::ETC2_RGB8_sRGB,
            RafxFormat::ETC2_R8G8B8A1_UNORM_BLOCK => MTLPixelFormat::ETC2_RGB8A1,
            RafxFormat::ETC2_R8G8B8A1_SRGB_BLOCK => MTLPixelFormat::ETC2_RGB8A1_sRGB,
            // RafxFormat::ETC2_R8G8B8A8_UNORM_BLOCK => MTLPixelFormat::ETC2_R8G8B8A8_UNORM_BLOCK,
            // RafxFormat::ETC2_R8G8B8A8_SRGB_BLOCK => MTLPixelFormat::ETC2_R8G8B8A8_SRGB_BLOCK,
            RafxFormat::EAC_R11_UNORM_BLOCK => MTLPixelFormat::EAC_R11Unorm,
            RafxFormat::EAC_R11_SNORM_BLOCK => MTLPixelFormat::EAC_R11Snorm,
            RafxFormat::EAC_R11G11_UNORM_BLOCK => MTLPixelFormat::EAC_RG11Unorm,
            RafxFormat::EAC_R11G11_SNORM_BLOCK => MTLPixelFormat::EAC_RG11Snorm,
            RafxFormat::ASTC_4X4_UNORM_BLOCK => MTLPixelFormat::ASTC_4x4_LDR,
            RafxFormat::ASTC_4X4_SRGB_BLOCK => MTLPixelFormat::ASTC_4x4_sRGB,
            RafxFormat::ASTC_5X4_UNORM_BLOCK => MTLPixelFormat::ASTC_5x4_LDR,
            RafxFormat::ASTC_5X4_SRGB_BLOCK => MTLPixelFormat::ASTC_5x4_sRGB,
            RafxFormat::ASTC_5X5_UNORM_BLOCK => MTLPixelFormat::ASTC_5x5_LDR,
            RafxFormat::ASTC_5X5_SRGB_BLOCK => MTLPixelFormat::ASTC_5x5_sRGB,
            RafxFormat::ASTC_6X5_UNORM_BLOCK => MTLPixelFormat::ASTC_6x5_LDR,
            RafxFormat::ASTC_6X5_SRGB_BLOCK => MTLPixelFormat::ASTC_6x5_sRGB,
            RafxFormat::ASTC_6X6_UNORM_BLOCK => MTLPixelFormat::ASTC_6x6_LDR,
            RafxFormat::ASTC_6X6_SRGB_BLOCK => MTLPixelFormat::ASTC_6x6_sRGB,
            RafxFormat::ASTC_8X5_UNORM_BLOCK => MTLPixelFormat::ASTC_8x5_LDR,
            RafxFormat::ASTC_8X5_SRGB_BLOCK => MTLPixelFormat::ASTC_8x5_sRGB,
            RafxFormat::ASTC_8X6_UNORM_BLOCK => MTLPixelFormat::ASTC_8x6_LDR,
            RafxFormat::ASTC_8X6_SRGB_BLOCK => MTLPixelFormat::ASTC_8x6_sRGB,
            RafxFormat::ASTC_8X8_UNORM_BLOCK => MTLPixelFormat::ASTC_8x8_LDR,
            RafxFormat::ASTC_8X8_SRGB_BLOCK => MTLPixelFormat::ASTC_8x8_sRGB,
            RafxFormat::ASTC_10X5_UNORM_BLOCK => MTLPixelFormat::ASTC_10x5_LDR,
            RafxFormat::ASTC_10X5_SRGB_BLOCK => MTLPixelFormat::ASTC_10x5_sRGB,
            RafxFormat::ASTC_10X6_UNORM_BLOCK => MTLPixelFormat::ASTC_10x6_LDR,
            RafxFormat::ASTC_10X6_SRGB_BLOCK => MTLPixelFormat::ASTC_10x6_sRGB,
            RafxFormat::ASTC_10X8_UNORM_BLOCK => MTLPixelFormat::ASTC_10x8_LDR,
            RafxFormat::ASTC_10X8_SRGB_BLOCK => MTLPixelFormat::ASTC_10x8_sRGB,
            RafxFormat::ASTC_10X10_UNORM_BLOCK => MTLPixelFormat::ASTC_10x10_LDR,
            RafxFormat::ASTC_10X10_SRGB_BLOCK => MTLPixelFormat::ASTC_10x10_sRGB,
            RafxFormat::ASTC_12X10_UNORM_BLOCK => MTLPixelFormat::ASTC_12x10_LDR,
            RafxFormat::ASTC_12X10_SRGB_BLOCK => MTLPixelFormat::ASTC_12x10_sRGB,
            RafxFormat::ASTC_12X12_UNORM_BLOCK => MTLPixelFormat::ASTC_12x12_LDR,
            RafxFormat::ASTC_12X12_SRGB_BLOCK => MTLPixelFormat::ASTC_12x12_sRGB,
            _ => unimplemented!(),
        }
    }
}

#[cfg(feature = "rafx-metal")]
impl Into<MTLVertexFormat> for RafxFormat {
    fn into(self) -> MTLVertexFormat {
        match self {
            RafxFormat::R8_UNORM => MTLVertexFormat::UCharNormalized,
            RafxFormat::R8_SNORM => MTLVertexFormat::CharNormalized,
            RafxFormat::R8_UINT => MTLVertexFormat::UChar,
            RafxFormat::R8_SINT => MTLVertexFormat::Char,
            RafxFormat::R8G8_UNORM => MTLVertexFormat::UChar2Normalized,
            RafxFormat::R8G8_SNORM => MTLVertexFormat::Char2Normalized,
            RafxFormat::R8G8_UINT => MTLVertexFormat::UChar2,
            RafxFormat::R8G8_SINT => MTLVertexFormat::Char2,
            RafxFormat::R8G8B8_UNORM => MTLVertexFormat::UChar3Normalized,
            RafxFormat::R8G8B8_SNORM => MTLVertexFormat::Char3Normalized,
            RafxFormat::R8G8B8_UINT => MTLVertexFormat::UChar3,
            RafxFormat::R8G8B8_SINT => MTLVertexFormat::Char3,
            RafxFormat::R8G8B8A8_UNORM => MTLVertexFormat::UChar4Normalized,
            RafxFormat::R8G8B8A8_SNORM => MTLVertexFormat::Char4Normalized,
            RafxFormat::R8G8B8A8_UINT => MTLVertexFormat::UChar4,
            RafxFormat::R8G8B8A8_SINT => MTLVertexFormat::Char4,
            RafxFormat::B8G8R8A8_UNORM => MTLVertexFormat::UChar4Normalized_BGRA,
            RafxFormat::R16_UNORM => MTLVertexFormat::UShortNormalized,
            RafxFormat::R16_SNORM => MTLVertexFormat::ShortNormalized,
            RafxFormat::R16_UINT => MTLVertexFormat::UShort,
            RafxFormat::R16_SINT => MTLVertexFormat::Short,
            RafxFormat::R16_SFLOAT => MTLVertexFormat::Half,
            RafxFormat::R16G16_UNORM => MTLVertexFormat::UShort2Normalized,
            RafxFormat::R16G16_SNORM => MTLVertexFormat::Short2Normalized,
            RafxFormat::R16G16_UINT => MTLVertexFormat::UShort2,
            RafxFormat::R16G16_SINT => MTLVertexFormat::Short2,
            RafxFormat::R16G16_SFLOAT => MTLVertexFormat::Half2,
            RafxFormat::R16G16B16_UNORM => MTLVertexFormat::UShort3Normalized,
            RafxFormat::R16G16B16_SNORM => MTLVertexFormat::Short3Normalized,
            RafxFormat::R16G16B16_UINT => MTLVertexFormat::UShort3,
            RafxFormat::R16G16B16_SINT => MTLVertexFormat::Short3,
            RafxFormat::R16G16B16_SFLOAT => MTLVertexFormat::Half3,
            RafxFormat::R16G16B16A16_UNORM => MTLVertexFormat::UShort4Normalized,
            RafxFormat::R16G16B16A16_SNORM => MTLVertexFormat::Short4Normalized,
            RafxFormat::R16G16B16A16_UINT => MTLVertexFormat::UShort4,
            RafxFormat::R16G16B16A16_SINT => MTLVertexFormat::Short4,
            RafxFormat::R16G16B16A16_SFLOAT => MTLVertexFormat::Half4,
            RafxFormat::R32_UINT => MTLVertexFormat::UInt,
            RafxFormat::R32_SINT => MTLVertexFormat::Int,
            RafxFormat::R32_SFLOAT => MTLVertexFormat::Float,
            RafxFormat::R32G32_UINT => MTLVertexFormat::UInt2,
            RafxFormat::R32G32_SINT => MTLVertexFormat::Int2,
            RafxFormat::R32G32_SFLOAT => MTLVertexFormat::Float2,
            RafxFormat::R32G32B32_UINT => MTLVertexFormat::UInt3,
            RafxFormat::R32G32B32_SINT => MTLVertexFormat::Int3,
            RafxFormat::R32G32B32_SFLOAT => MTLVertexFormat::Float3,
            RafxFormat::R32G32B32A32_UINT => MTLVertexFormat::UInt4,
            RafxFormat::R32G32B32A32_SINT => MTLVertexFormat::Int4,
            RafxFormat::R32G32B32A32_SFLOAT => MTLVertexFormat::Float4,
            _ => unimplemented!("into MTLVertexFormat unimplemented for {:?}", self),
        }
    }
}

#[cfg(any(feature = "rafx-gles2", feature = "rafx-gles3"))]
#[derive(Debug)]
pub struct GlTextureFormatInfo {
    pub gl_format: GLenum,
    pub gl_type: GLenum,
    pub gl_internal_format: i32,
}

//TODO: Really not sure about this or what GL ES 2.0 supports
// format (source/cpu format): GL_ALPHA, GL_LUMINANCE, GL_LUMINANCE_ALPHA, GL_RGB, or GL_RGBA
// type:
// internal (gpu format): GL_ALPHA, GL_LUMINANCE, GL_LUMINANCE_ALPHA, GL_RGB, or GL_RGBA

#[rustfmt::skip]
#[cfg(feature = "rafx-gles2")]
impl RafxFormat {
    pub fn gles2_type(self) -> Option<GLenum> {
        use crate::gles2::gles2_bindings as gl;
        match self {
            RafxFormat::R4G4_UNORM_PACK8 => Some(gl::UNSIGNED_SHORT_4_4_4_4),
            RafxFormat::R4G4B4A4_UNORM_PACK16 => Some(gl::UNSIGNED_SHORT_4_4_4_4),
            //RafxFormat::B4G4R4A4_UNORM_PACK16 => None,
            RafxFormat::R5G6B5_UNORM_PACK16 => Some(gl::UNSIGNED_SHORT_5_6_5),
            //RafxFormat::B5G6R5_UNORM_PACK16 => None,
            RafxFormat::R5G5B5A1_UNORM_PACK16 => Some(gl::UNSIGNED_SHORT_5_5_5_1),
            //RafxFormat::B5G5R5A1_UNORM_PACK16 => None,
            //RafxFormat::A1R5G5B5_UNORM_PACK16 => None,
            RafxFormat::R8_UNORM => Some(gl::UNSIGNED_BYTE),
            RafxFormat::R8_SNORM => Some(gl::BYTE),
            //RafxFormat::R8_USCALED => None,
            //RafxFormat::R8_SSCALED => None,
            RafxFormat::R8_UINT => Some(gl::UNSIGNED_BYTE),
            RafxFormat::R8_SINT => Some(gl::BYTE),
            RafxFormat::R8_SRGB => Some(gl::UNSIGNED_BYTE),
            RafxFormat::R8G8_UNORM => Some(gl::UNSIGNED_BYTE),
            RafxFormat::R8G8_SNORM => Some(gl::BYTE),
            //RafxFormat::R8G8_USCALED => None,
            //RafxFormat::R8G8_SSCALED => None,
            RafxFormat::R8G8_UINT => Some(gl::UNSIGNED_BYTE),
            RafxFormat::R8G8_SINT => Some(gl::BYTE),
            RafxFormat::R8G8_SRGB => Some(gl::UNSIGNED_BYTE),
            RafxFormat::R8G8B8_UNORM => Some(gl::UNSIGNED_BYTE),
            RafxFormat::R8G8B8_SNORM => Some(gl::BYTE),
            //RafxFormat::R8G8B8_USCALED => None,
            //RafxFormat::R8G8B8_SSCALED => None,
            RafxFormat::R8G8B8_UINT => Some(gl::UNSIGNED_BYTE),
            RafxFormat::R8G8B8_SINT => Some(gl::BYTE),
            RafxFormat::R8G8B8_SRGB => Some(gl::UNSIGNED_BYTE),
            RafxFormat::B8G8R8_UNORM => Some(gl::UNSIGNED_BYTE),
            RafxFormat::B8G8R8_SNORM => Some(gl::BYTE),
            //RafxFormat::B8G8R8_USCALED => None,
            //RafxFormat::B8G8R8_SSCALED => None,
            RafxFormat::B8G8R8_UINT => Some(gl::UNSIGNED_BYTE),
            RafxFormat::B8G8R8_SINT => Some(gl::BYTE),
            RafxFormat::B8G8R8_SRGB => Some(gl::UNSIGNED_BYTE),
            RafxFormat::R8G8B8A8_UNORM => Some(gl::UNSIGNED_BYTE),
            RafxFormat::R8G8B8A8_SNORM => Some(gl::BYTE),
            //RafxFormat::R8G8B8A8_USCALED => None,
            //RafxFormat::R8G8B8A8_SSCALED => None,
            RafxFormat::R8G8B8A8_UINT => Some(gl::UNSIGNED_BYTE),
            RafxFormat::R8G8B8A8_SINT => Some(gl::BYTE),
            RafxFormat::R8G8B8A8_SRGB => Some(gl::UNSIGNED_BYTE),
            RafxFormat::B8G8R8A8_UNORM => Some(gl::UNSIGNED_BYTE),
            RafxFormat::B8G8R8A8_SNORM => Some(gl::BYTE),
            //RafxFormat::B8G8R8A8_USCALED => None,
            //RafxFormat::B8G8R8A8_SSCALED => None,
            RafxFormat::B8G8R8A8_UINT => Some(gl::UNSIGNED_BYTE),
            RafxFormat::B8G8R8A8_SINT => Some(gl::BYTE),
            RafxFormat::B8G8R8A8_SRGB => Some(gl::UNSIGNED_BYTE),
            //RafxFormat::A8B8G8R8_UNORM_PACK32 => None,
            //RafxFormat::A8B8G8R8_SNORM_PACK32 => None,
            //RafxFormat::A8B8G8R8_USCALED_PACK32 => None,
            //RafxFormat::A8B8G8R8_SSCALED_PACK32 => None,
            //RafxFormat::A8B8G8R8_UINT_PACK32 => None,
            //RafxFormat::A8B8G8R8_SINT_PACK32 => None,
            //RafxFormat::A8B8G8R8_SRGB_PACK32 => None,
            //RafxFormat::A2R10G10B10_UNORM_PACK32 => None,
            //RafxFormat::A2R10G10B10_SNORM_PACK32 => None,
            //RafxFormat::A2R10G10B10_USCALED_PACK32 => None,
            //RafxFormat::A2R10G10B10_SSCALED_PACK32 => None,
            //RafxFormat::A2R10G10B10_UINT_PACK32 => None,
            //RafxFormat::A2R10G10B10_SINT_PACK32 => None,
            //RafxFormat::A2B10G10R10_UNORM_PACK32 => None,
            //RafxFormat::A2B10G10R10_SNORM_PACK32 => None,
            //RafxFormat::A2B10G10R10_USCALED_PACK32 => None,
            //RafxFormat::A2B10G10R10_SSCALED_PACK32 => None,
            //RafxFormat::A2B10G10R10_UINT_PACK32 => None,
            //RafxFormat::A2B10G10R10_SINT_PACK32 => None,
            RafxFormat::R16_UNORM => Some(gl::UNSIGNED_SHORT),
            RafxFormat::R16_SNORM => Some(gl::SHORT),
            //RafxFormat::R16_USCALED => None,
            //RafxFormat::R16_SSCALED => None,
            RafxFormat::R16_UINT => Some(gl::UNSIGNED_SHORT),
            RafxFormat::R16_SINT => Some(gl::SHORT),
            //RafxFormat::R16_SFLOAT => None,
            RafxFormat::R16G16_UNORM => Some(gl::UNSIGNED_SHORT),
            RafxFormat::R16G16_SNORM => Some(gl::SHORT),
            //RafxFormat::R16G16_USCALED => None,
            //RafxFormat::R16G16_SSCALED => None,
            RafxFormat::R16G16_UINT => Some(gl::UNSIGNED_SHORT),
            RafxFormat::R16G16_SINT => Some(gl::SHORT),
            //RafxFormat::R16G16_SFLOAT => None,
            RafxFormat::R16G16B16_UNORM => Some(gl::UNSIGNED_SHORT),
            RafxFormat::R16G16B16_SNORM => Some(gl::SHORT),
            //RafxFormat::R16G16B16_USCALED => None,
            //RafxFormat::R16G16B16_SSCALED => None,
            RafxFormat::R16G16B16_UINT => Some(gl::UNSIGNED_SHORT),
            RafxFormat::R16G16B16_SINT => Some(gl::SHORT),
            //RafxFormat::R16G16B16_SFLOAT => None,
            RafxFormat::R16G16B16A16_UNORM => Some(gl::UNSIGNED_SHORT),
            RafxFormat::R16G16B16A16_SNORM => Some(gl::SHORT),
            //RafxFormat::R16G16B16A16_USCALED => None,
            //RafxFormat::R16G16B16A16_SSCALED => None,
            RafxFormat::R16G16B16A16_UINT => Some(gl::UNSIGNED_SHORT),
            RafxFormat::R16G16B16A16_SINT => Some(gl::SHORT),
            //RafxFormat::R16G16B16A16_SFLOAT => None,
            RafxFormat::R32_UINT => Some(gl::UNSIGNED_INT),
            RafxFormat::R32_SINT => Some(gl::INT),
            RafxFormat::R32_SFLOAT => Some(gl::FLOAT),
            RafxFormat::R32G32_UINT => Some(gl::UNSIGNED_INT),
            RafxFormat::R32G32_SINT => Some(gl::INT),
            RafxFormat::R32G32_SFLOAT => Some(gl::FLOAT),
            RafxFormat::R32G32B32_UINT => Some(gl::UNSIGNED_INT),
            RafxFormat::R32G32B32_SINT => Some(gl::INT),
            RafxFormat::R32G32B32_SFLOAT => Some(gl::FLOAT),
            RafxFormat::R32G32B32A32_UINT => Some(gl::UNSIGNED_INT),
            RafxFormat::R32G32B32A32_SINT => Some(gl::INT),
            RafxFormat::R32G32B32A32_SFLOAT => Some(gl::FLOAT),
            // RafxFormat::R64_UINT => None,
            // RafxFormat::R64_SINT => None,
            // RafxFormat::R64_SFLOAT => None,
            // RafxFormat::R64G64_UINT => None,
            // RafxFormat::R64G64_SINT => None,
            // RafxFormat::R64G64_SFLOAT => None,
            // RafxFormat::R64G64B64_UINT => None,
            // RafxFormat::R64G64B64_SINT => None,
            // RafxFormat::R64G64B64_SFLOAT => None,
            // RafxFormat::R64G64B64A64_UINT => None,
            // RafxFormat::R64G64B64A64_SINT => None,
            // RafxFormat::R64G64B64A64_SFLOAT => None,
            // RafxFormat::B10G11R11_UFLOAT_PACK32 => None,
            // RafxFormat::E5B9G9R9_UFLOAT_PACK32 => None,
            RafxFormat::D16_UNORM => Some(gl::UNSIGNED_SHORT),
            // RafxFormat::X8_D24_UNORM_PACK32 => None,
            RafxFormat::D32_SFLOAT => Some(gl::FLOAT),
            RafxFormat::S8_UINT => Some(gl::UNSIGNED_BYTE),
            // RafxFormat::D16_UNORM_S8_UINT => None,
            // RafxFormat::D24_UNORM_S8_UINT => None,
            // RafxFormat::D32_SFLOAT_S8_UINT => None,
            // RafxFormat::BC1_RGB_UNORM_BLOCK => None,
            // RafxFormat::BC1_RGB_SRGB_BLOCK => None,
            // RafxFormat::BC1_RGBA_UNORM_BLOCK => None,
            // RafxFormat::BC1_RGBA_SRGB_BLOCK => None,
            // RafxFormat::BC2_UNORM_BLOCK => None,
            // RafxFormat::BC2_SRGB_BLOCK => None,
            // RafxFormat::BC3_UNORM_BLOCK => None,
            // RafxFormat::BC3_SRGB_BLOCK => None,
            // RafxFormat::BC4_UNORM_BLOCK => None,
            // RafxFormat::BC4_SNORM_BLOCK => None,
            // RafxFormat::BC5_UNORM_BLOCK => None,
            // RafxFormat::BC5_SNORM_BLOCK => None,
            // RafxFormat::BC6H_UFLOAT_BLOCK => None,
            // RafxFormat::BC6H_SFLOAT_BLOCK => None,
            // RafxFormat::BC7_UNORM_BLOCK => None,
            // RafxFormat::BC7_SRGB_BLOCK => None,
            // RafxFormat::ETC2_R8G8B8_UNORM_BLOCK => None,
            // RafxFormat::ETC2_R8G8B8_SRGB_BLOCK => None,
            // RafxFormat::ETC2_R8G8B8A1_UNORM_BLOCK => None,
            // RafxFormat::ETC2_R8G8B8A1_SRGB_BLOCK => None,
            // RafxFormat::ETC2_R8G8B8A8_UNORM_BLOCK => None,
            // RafxFormat::ETC2_R8G8B8A8_SRGB_BLOCK => None,
            // RafxFormat::EAC_R11_UNORM_BLOCK => None,
            // RafxFormat::EAC_R11_SNORM_BLOCK => None,
            // RafxFormat::EAC_R11G11_UNORM_BLOCK => None,
            // RafxFormat::EAC_R11G11_SNORM_BLOCK => None,
            // RafxFormat::ASTC_4X4_UNORM_BLOCK => None,
            // RafxFormat::ASTC_4X4_SRGB_BLOCK => None,
            // RafxFormat::ASTC_5X4_UNORM_BLOCK => None,
            // RafxFormat::ASTC_5X4_SRGB_BLOCK => None,
            // RafxFormat::ASTC_5X5_UNORM_BLOCK => None,
            // RafxFormat::ASTC_5X5_SRGB_BLOCK => None,
            // RafxFormat::ASTC_6X5_UNORM_BLOCK => None,
            // RafxFormat::ASTC_6X5_SRGB_BLOCK => None,
            // RafxFormat::ASTC_6X6_UNORM_BLOCK => None,
            // RafxFormat::ASTC_6X6_SRGB_BLOCK => None,
            // RafxFormat::ASTC_8X5_UNORM_BLOCK => None,
            // RafxFormat::ASTC_8X5_SRGB_BLOCK => None,
            // RafxFormat::ASTC_8X6_UNORM_BLOCK => None,
            // RafxFormat::ASTC_8X6_SRGB_BLOCK => None,
            // RafxFormat::ASTC_8X8_UNORM_BLOCK => None,
            // RafxFormat::ASTC_8X8_SRGB_BLOCK => None,
            // RafxFormat::ASTC_10X5_UNORM_BLOCK => None,
            // RafxFormat::ASTC_10X5_SRGB_BLOCK => None,
            // RafxFormat::ASTC_10X6_UNORM_BLOCK => None,
            // RafxFormat::ASTC_10X6_SRGB_BLOCK => None,
            // RafxFormat::ASTC_10X8_UNORM_BLOCK => None,
            // RafxFormat::ASTC_10X8_SRGB_BLOCK => None,
            // RafxFormat::ASTC_10X10_UNORM_BLOCK => None,
            // RafxFormat::ASTC_10X10_SRGB_BLOCK => None,
            // RafxFormat::ASTC_12X10_UNORM_BLOCK => None,
            // RafxFormat::ASTC_12X10_SRGB_BLOCK => None,
            // RafxFormat::ASTC_12X12_UNORM_BLOCK => None,
            // RafxFormat::ASTC_12X12_SRGB_BLOCK => None,
            _ => None,
        }
    }

    pub fn gles2_texture_format_info(self) -> Option<GlTextureFormatInfo> {
        use crate::gles2::gles2_bindings as gl;
        #[rustfmt::skip]
        let formats = match self {
            // RafxFormat::UNDEFINED => None,
            // RafxFormat::R4G4_UNORM_PACK8 => None,
            RafxFormat::R4G4B4A4_UNORM_PACK16 => Some((gl::RGBA, gl::RGBA)),
            // RafxFormat::B4G4R4A4_UNORM_PACK16 => None,
            RafxFormat::R5G6B5_UNORM_PACK16 => Some((gl::RGB, gl::RGB)),
            // RafxFormat::B5G6R5_UNORM_PACK16 => None,
            RafxFormat::R5G5B5A1_UNORM_PACK16 => Some((gl::RGBA, gl::RGBA)),
            // RafxFormat::B5G5R5A1_UNORM_PACK16 => None,
            // RafxFormat::A1R5G5B5_UNORM_PACK16 => None,
            RafxFormat::R8_UNORM => Some((gl::LUMINANCE, gl::LUMINANCE)),
            // RafxFormat::R8_SNORM => Some((gl::LUMINANCE, gl::LUMINANCE)),
            // RafxFormat::R8_USCALED => None,
            // RafxFormat::R8_SSCALED => None,
            // RafxFormat::R8_UINT => None,
            // RafxFormat::R8_SINT => None,
            // RafxFormat::R8_SRGB => None,
            // RafxFormat::R8G8_UNORM => None,
            // RafxFormat::R8G8_SNORM => None,
            // RafxFormat::R8G8_USCALED => None,
            // RafxFormat::R8G8_SSCALED => None,
            // RafxFormat::R8G8_UINT => None,
            // RafxFormat::R8G8_SINT => None,
            // RafxFormat::R8G8_SRGB => None,
            RafxFormat::R8G8B8_UNORM => Some((gl::RGB, gl::RGB)),
            // RafxFormat::R8G8B8_SNORM => Some((gl::RGB, gl::RGB)),
            // RafxFormat::R8G8B8_USCALED => None,
            // RafxFormat::R8G8B8_SSCALED => None,
            // RafxFormat::R8G8B8_UINT => None,
            // RafxFormat::R8G8B8_SINT => None,
            // RafxFormat::R8G8B8_SRGB => None,
            // RafxFormat::B8G8R8_UNORM => None,
            // RafxFormat::B8G8R8_SNORM => None,
            // RafxFormat::B8G8R8_USCALED => None,
            // RafxFormat::B8G8R8_SSCALED => None,
            // RafxFormat::B8G8R8_UINT => None,
            // RafxFormat::B8G8R8_SINT => None,
            // RafxFormat::B8G8R8_SRGB => None,
            RafxFormat::R8G8B8A8_UNORM => Some((gl::RGBA, gl::RGBA)),
            // //RafxFormat::R8G8B8A8_SNORM => None,
            // RafxFormat::R8G8B8A8_USCALED => None,
            // RafxFormat::R8G8B8A8_SSCALED => None,
            // RafxFormat::R8G8B8A8_UINT => None,
            // RafxFormat::R8G8B8A8_SINT => None,
            // RafxFormat::R8G8B8A8_SRGB => None,
            // RafxFormat::B8G8R8A8_UNORM => None,
            // RafxFormat::B8G8R8A8_SNORM => None,
            // RafxFormat::B8G8R8A8_USCALED => None,
            // RafxFormat::B8G8R8A8_SSCALED => None,
            // RafxFormat::B8G8R8A8_UINT => None,
            // RafxFormat::B8G8R8A8_SINT => None,
            // RafxFormat::B8G8R8A8_SRGB => None,
            // RafxFormat::A8B8G8R8_UNORM_PACK32 => None,
            // RafxFormat::A8B8G8R8_SNORM_PACK32 => None,
            // RafxFormat::A8B8G8R8_USCALED_PACK32 => None,
            // RafxFormat::A8B8G8R8_SSCALED_PACK32 => None,
            // RafxFormat::A8B8G8R8_UINT_PACK32 => None,
            // RafxFormat::A8B8G8R8_SINT_PACK32 => None,
            // RafxFormat::A8B8G8R8_SRGB_PACK32 => None,
            // RafxFormat::A2R10G10B10_UNORM_PACK32 => None,
            // RafxFormat::A2R10G10B10_SNORM_PACK32 => None,
            // RafxFormat::A2R10G10B10_USCALED_PACK32 => None,
            // RafxFormat::A2R10G10B10_SSCALED_PACK32 => None,
            // RafxFormat::A2R10G10B10_UINT_PACK32 => None,
            // RafxFormat::A2R10G10B10_SINT_PACK32 => None,
            // RafxFormat::A2B10G10R10_UNORM_PACK32 => None,
            // RafxFormat::A2B10G10R10_SNORM_PACK32 => None,
            // RafxFormat::A2B10G10R10_USCALED_PACK32 => None,
            // RafxFormat::A2B10G10R10_SSCALED_PACK32 => None,
            // RafxFormat::A2B10G10R10_UINT_PACK32 => None,
            // RafxFormat::A2B10G10R10_SINT_PACK32 => None,
            // RafxFormat::R16_UNORM => None,
            // RafxFormat::R16_SNORM => None,
            // RafxFormat::R16_USCALED => None,
            // RafxFormat::R16_SSCALED => None,
            // RafxFormat::R16_UINT => None,
            // RafxFormat::R16_SINT => None,
            // RafxFormat::R16_SFLOAT => None,
            // RafxFormat::R16G16_UNORM => None,
            // RafxFormat::R16G16_SNORM => None,
            // RafxFormat::R16G16_USCALED => None,
            // RafxFormat::R16G16_SSCALED => None,
            // RafxFormat::R16G16_UINT => None,
            // RafxFormat::R16G16_SINT => None,
            // RafxFormat::R16G16_SFLOAT => None,
            // RafxFormat::R16G16B16_UNORM => None,
            // RafxFormat::R16G16B16_SNORM => None,
            // RafxFormat::R16G16B16_USCALED => None,
            // RafxFormat::R16G16B16_SSCALED => None,
            // RafxFormat::R16G16B16_UINT => None,
            // RafxFormat::R16G16B16_SINT => None,
            // RafxFormat::R16G16B16_SFLOAT => None,
            // RafxFormat::R16G16B16A16_UNORM => None,
            // RafxFormat::R16G16B16A16_SNORM => None,
            // RafxFormat::R16G16B16A16_USCALED => None,
            // RafxFormat::R16G16B16A16_SSCALED => None,
            // RafxFormat::R16G16B16A16_UINT => None,
            // RafxFormat::R16G16B16A16_SINT => None,
            // RafxFormat::R16G16B16A16_SFLOAT => None,
            // RafxFormat::R32_UINT => None,
            // RafxFormat::R32_SINT => None,
            // RafxFormat::R32_SFLOAT => None,
            // RafxFormat::R32G32_UINT => None,
            // RafxFormat::R32G32_SINT => None,
            // RafxFormat::R32G32_SFLOAT => None,
            // RafxFormat::R32G32B32_UINT => None,
            // RafxFormat::R32G32B32_SINT => None,
            // RafxFormat::R32G32B32_SFLOAT => None,
            // RafxFormat::R32G32B32A32_UINT => None,
            // RafxFormat::R32G32B32A32_SINT => None,
            // RafxFormat::R32G32B32A32_SFLOAT => None,
            // RafxFormat::R64_UINT => None,
            // RafxFormat::R64_SINT => None,
            // RafxFormat::R64_SFLOAT => None,
            // RafxFormat::R64G64_UINT => None,
            // RafxFormat::R64G64_SINT => None,
            // RafxFormat::R64G64_SFLOAT => None,
            // RafxFormat::R64G64B64_UINT => None,
            // RafxFormat::R64G64B64_SINT => None,
            // RafxFormat::R64G64B64_SFLOAT => None,
            // RafxFormat::R64G64B64A64_UINT => None,
            // RafxFormat::R64G64B64A64_SINT => None,
            // RafxFormat::R64G64B64A64_SFLOAT => None,
            // RafxFormat::B10G11R11_UFLOAT_PACK32 => None,
            // RafxFormat::E5B9G9R9_UFLOAT_PACK32 => None,
            // RafxFormat::D16_UNORM => None,
            // RafxFormat::X8_D24_UNORM_PACK32 => None,
            // RafxFormat::D32_SFLOAT => None,
            // RafxFormat::S8_UINT => None,
            // RafxFormat::D16_UNORM_S8_UINT => None,
            // RafxFormat::D24_UNORM_S8_UINT => None,
            // RafxFormat::D32_SFLOAT_S8_UINT => None,
            // RafxFormat::BC1_RGB_UNORM_BLOCK => None,
            // RafxFormat::BC1_RGB_SRGB_BLOCK => None,
            // RafxFormat::BC1_RGBA_UNORM_BLOCK => None,
            // RafxFormat::BC1_RGBA_SRGB_BLOCK => None,
            // RafxFormat::BC2_UNORM_BLOCK => None,
            // RafxFormat::BC2_SRGB_BLOCK => None,
            // RafxFormat::BC3_UNORM_BLOCK => None,
            // RafxFormat::BC3_SRGB_BLOCK => None,
            // RafxFormat::BC4_UNORM_BLOCK => None,
            // RafxFormat::BC4_SNORM_BLOCK => None,
            // RafxFormat::BC5_UNORM_BLOCK => None,
            // RafxFormat::BC5_SNORM_BLOCK => None,
            // RafxFormat::BC6H_UFLOAT_BLOCK => None,
            // RafxFormat::BC6H_SFLOAT_BLOCK => None,
            // RafxFormat::BC7_UNORM_BLOCK => None,
            // RafxFormat::BC7_SRGB_BLOCK => None,
            // RafxFormat::ETC2_R8G8B8_UNORM_BLOCK => None,
            // RafxFormat::ETC2_R8G8B8_SRGB_BLOCK => None,
            // RafxFormat::ETC2_R8G8B8A1_UNORM_BLOCK => None,
            // RafxFormat::ETC2_R8G8B8A1_SRGB_BLOCK => None,
            // RafxFormat::ETC2_R8G8B8A8_UNORM_BLOCK => None,
            // RafxFormat::ETC2_R8G8B8A8_SRGB_BLOCK => None,
            // RafxFormat::EAC_R11_UNORM_BLOCK => None,
            // RafxFormat::EAC_R11_SNORM_BLOCK => None,
            // RafxFormat::EAC_R11G11_UNORM_BLOCK => None,
            // RafxFormat::EAC_R11G11_SNORM_BLOCK => None,
            // RafxFormat::ASTC_4X4_UNORM_BLOCK => None,
            // RafxFormat::ASTC_4X4_SRGB_BLOCK => None,
            // RafxFormat::ASTC_5X4_UNORM_BLOCK => None,
            // RafxFormat::ASTC_5X4_SRGB_BLOCK => None,
            // RafxFormat::ASTC_5X5_UNORM_BLOCK => None,
            // RafxFormat::ASTC_5X5_SRGB_BLOCK => None,
            // RafxFormat::ASTC_6X5_UNORM_BLOCK => None,
            // RafxFormat::ASTC_6X5_SRGB_BLOCK => None,
            // RafxFormat::ASTC_6X6_UNORM_BLOCK => None,
            // RafxFormat::ASTC_6X6_SRGB_BLOCK => None,
            // RafxFormat::ASTC_8X5_UNORM_BLOCK => None,
            // RafxFormat::ASTC_8X5_SRGB_BLOCK => None,
            // RafxFormat::ASTC_8X6_UNORM_BLOCK => None,
            // RafxFormat::ASTC_8X6_SRGB_BLOCK => None,
            // RafxFormat::ASTC_8X8_UNORM_BLOCK => None,
            // RafxFormat::ASTC_8X8_SRGB_BLOCK => None,
            // RafxFormat::ASTC_10X5_UNORM_BLOCK => None,
            // RafxFormat::ASTC_10X5_SRGB_BLOCK => None,
            // RafxFormat::ASTC_10X6_UNORM_BLOCK => None,
            // RafxFormat::ASTC_10X6_SRGB_BLOCK => None,
            // RafxFormat::ASTC_10X8_UNORM_BLOCK => None,
            // RafxFormat::ASTC_10X8_SRGB_BLOCK => None,
            // RafxFormat::ASTC_10X10_UNORM_BLOCK => None,
            // RafxFormat::ASTC_10X10_SRGB_BLOCK => None,
            // RafxFormat::ASTC_12X10_UNORM_BLOCK => None,
            // RafxFormat::ASTC_12X10_SRGB_BLOCK => None,
            // RafxFormat::ASTC_12X12_UNORM_BLOCK => None,
            // RafxFormat::ASTC_12X12_SRGB_BLOCK => None,
            _ => None,
        };

        let gl_type = self.gles2_type()?;
        formats.map(|(gl_format, gl_internal_format)| GlTextureFormatInfo {
            gl_format,
            gl_type,
            gl_internal_format: gl_internal_format as i32
        })
    }
}

#[rustfmt::skip]
#[cfg(feature = "rafx-gles3")]
impl RafxFormat {
    pub fn gles3_type(self) -> Option<GLenum> {
        use crate::gles3::gles3_bindings as gl;
        match self {
            RafxFormat::R4G4_UNORM_PACK8 => Some(gl::UNSIGNED_SHORT_4_4_4_4),
            RafxFormat::R4G4B4A4_UNORM_PACK16 => Some(gl::UNSIGNED_SHORT_4_4_4_4),
            //RafxFormat::B4G4R4A4_UNORM_PACK16 => None,
            RafxFormat::R5G6B5_UNORM_PACK16 => Some(gl::UNSIGNED_SHORT_5_6_5),
            //RafxFormat::B5G6R5_UNORM_PACK16 => None,
            RafxFormat::R5G5B5A1_UNORM_PACK16 => Some(gl::UNSIGNED_SHORT_5_5_5_1),
            //RafxFormat::B5G5R5A1_UNORM_PACK16 => None,
            //RafxFormat::A1R5G5B5_UNORM_PACK16 => None,
            RafxFormat::R8_UNORM => Some(gl::UNSIGNED_BYTE),
            RafxFormat::R8_SNORM => Some(gl::BYTE),
            //RafxFormat::R8_USCALED => None,
            //RafxFormat::R8_SSCALED => None,
            RafxFormat::R8_UINT => Some(gl::UNSIGNED_BYTE),
            RafxFormat::R8_SINT => Some(gl::BYTE),
            RafxFormat::R8_SRGB => Some(gl::UNSIGNED_BYTE),
            RafxFormat::R8G8_UNORM => Some(gl::UNSIGNED_BYTE),
            RafxFormat::R8G8_SNORM => Some(gl::BYTE),
            //RafxFormat::R8G8_USCALED => None,
            //RafxFormat::R8G8_SSCALED => None,
            RafxFormat::R8G8_UINT => Some(gl::UNSIGNED_BYTE),
            RafxFormat::R8G8_SINT => Some(gl::BYTE),
            RafxFormat::R8G8_SRGB => Some(gl::UNSIGNED_BYTE),
            RafxFormat::R8G8B8_UNORM => Some(gl::UNSIGNED_BYTE),
            RafxFormat::R8G8B8_SNORM => Some(gl::BYTE),
            //RafxFormat::R8G8B8_USCALED => None,
            //RafxFormat::R8G8B8_SSCALED => None,
            RafxFormat::R8G8B8_UINT => Some(gl::UNSIGNED_BYTE),
            RafxFormat::R8G8B8_SINT => Some(gl::BYTE),
            RafxFormat::R8G8B8_SRGB => Some(gl::UNSIGNED_BYTE),
            RafxFormat::B8G8R8_UNORM => Some(gl::UNSIGNED_BYTE),
            RafxFormat::B8G8R8_SNORM => Some(gl::BYTE),
            //RafxFormat::B8G8R8_USCALED => None,
            //RafxFormat::B8G8R8_SSCALED => None,
            RafxFormat::B8G8R8_UINT => Some(gl::UNSIGNED_BYTE),
            RafxFormat::B8G8R8_SINT => Some(gl::BYTE),
            RafxFormat::B8G8R8_SRGB => Some(gl::UNSIGNED_BYTE),
            RafxFormat::R8G8B8A8_UNORM => Some(gl::UNSIGNED_BYTE),
            RafxFormat::R8G8B8A8_SNORM => Some(gl::BYTE),
            //RafxFormat::R8G8B8A8_USCALED => None,
            //RafxFormat::R8G8B8A8_SSCALED => None,
            RafxFormat::R8G8B8A8_UINT => Some(gl::UNSIGNED_BYTE),
            RafxFormat::R8G8B8A8_SINT => Some(gl::BYTE),
            RafxFormat::R8G8B8A8_SRGB => Some(gl::UNSIGNED_BYTE),
            RafxFormat::B8G8R8A8_UNORM => Some(gl::UNSIGNED_BYTE),
            RafxFormat::B8G8R8A8_SNORM => Some(gl::BYTE),
            //RafxFormat::B8G8R8A8_USCALED => None,
            //RafxFormat::B8G8R8A8_SSCALED => None,
            RafxFormat::B8G8R8A8_UINT => Some(gl::UNSIGNED_BYTE),
            RafxFormat::B8G8R8A8_SINT => Some(gl::BYTE),
            RafxFormat::B8G8R8A8_SRGB => Some(gl::UNSIGNED_BYTE),
            //RafxFormat::A8B8G8R8_UNORM_PACK32 => None,
            //RafxFormat::A8B8G8R8_SNORM_PACK32 => None,
            //RafxFormat::A8B8G8R8_USCALED_PACK32 => None,
            //RafxFormat::A8B8G8R8_SSCALED_PACK32 => None,
            //RafxFormat::A8B8G8R8_UINT_PACK32 => None,
            //RafxFormat::A8B8G8R8_SINT_PACK32 => None,
            //RafxFormat::A8B8G8R8_SRGB_PACK32 => None,
            //RafxFormat::A2R10G10B10_UNORM_PACK32 => None,
            //RafxFormat::A2R10G10B10_SNORM_PACK32 => None,
            //RafxFormat::A2R10G10B10_USCALED_PACK32 => None,
            //RafxFormat::A2R10G10B10_SSCALED_PACK32 => None,
            //RafxFormat::A2R10G10B10_UINT_PACK32 => None,
            //RafxFormat::A2R10G10B10_SINT_PACK32 => None,
            //RafxFormat::A2B10G10R10_UNORM_PACK32 => None,
            //RafxFormat::A2B10G10R10_SNORM_PACK32 => None,
            //RafxFormat::A2B10G10R10_USCALED_PACK32 => None,
            //RafxFormat::A2B10G10R10_SSCALED_PACK32 => None,
            //RafxFormat::A2B10G10R10_UINT_PACK32 => None,
            //RafxFormat::A2B10G10R10_SINT_PACK32 => None,
            RafxFormat::R16_UNORM => Some(gl::UNSIGNED_SHORT),
            RafxFormat::R16_SNORM => Some(gl::SHORT),
            //RafxFormat::R16_USCALED => None,
            //RafxFormat::R16_SSCALED => None,
            RafxFormat::R16_UINT => Some(gl::UNSIGNED_SHORT),
            RafxFormat::R16_SINT => Some(gl::SHORT),
            //RafxFormat::R16_SFLOAT => None,
            RafxFormat::R16G16_UNORM => Some(gl::UNSIGNED_SHORT),
            RafxFormat::R16G16_SNORM => Some(gl::SHORT),
            //RafxFormat::R16G16_USCALED => None,
            //RafxFormat::R16G16_SSCALED => None,
            RafxFormat::R16G16_UINT => Some(gl::UNSIGNED_SHORT),
            RafxFormat::R16G16_SINT => Some(gl::SHORT),
            //RafxFormat::R16G16_SFLOAT => None,
            RafxFormat::R16G16B16_UNORM => Some(gl::UNSIGNED_SHORT),
            RafxFormat::R16G16B16_SNORM => Some(gl::SHORT),
            //RafxFormat::R16G16B16_USCALED => None,
            //RafxFormat::R16G16B16_SSCALED => None,
            RafxFormat::R16G16B16_UINT => Some(gl::UNSIGNED_SHORT),
            RafxFormat::R16G16B16_SINT => Some(gl::SHORT),
            //RafxFormat::R16G16B16_SFLOAT => None,
            RafxFormat::R16G16B16A16_UNORM => Some(gl::UNSIGNED_SHORT),
            RafxFormat::R16G16B16A16_SNORM => Some(gl::SHORT),
            //RafxFormat::R16G16B16A16_USCALED => None,
            //RafxFormat::R16G16B16A16_SSCALED => None,
            RafxFormat::R16G16B16A16_UINT => Some(gl::UNSIGNED_SHORT),
            RafxFormat::R16G16B16A16_SINT => Some(gl::SHORT),
            //RafxFormat::R16G16B16A16_SFLOAT => None,
            RafxFormat::R32_UINT => Some(gl::UNSIGNED_INT),
            RafxFormat::R32_SINT => Some(gl::INT),
            RafxFormat::R32_SFLOAT => Some(gl::FLOAT),
            RafxFormat::R32G32_UINT => Some(gl::UNSIGNED_INT),
            RafxFormat::R32G32_SINT => Some(gl::INT),
            RafxFormat::R32G32_SFLOAT => Some(gl::FLOAT),
            RafxFormat::R32G32B32_UINT => Some(gl::UNSIGNED_INT),
            RafxFormat::R32G32B32_SINT => Some(gl::INT),
            RafxFormat::R32G32B32_SFLOAT => Some(gl::FLOAT),
            RafxFormat::R32G32B32A32_UINT => Some(gl::UNSIGNED_INT),
            RafxFormat::R32G32B32A32_SINT => Some(gl::INT),
            RafxFormat::R32G32B32A32_SFLOAT => Some(gl::FLOAT),
            // RafxFormat::R64_UINT => None,
            // RafxFormat::R64_SINT => None,
            // RafxFormat::R64_SFLOAT => None,
            // RafxFormat::R64G64_UINT => None,
            // RafxFormat::R64G64_SINT => None,
            // RafxFormat::R64G64_SFLOAT => None,
            // RafxFormat::R64G64B64_UINT => None,
            // RafxFormat::R64G64B64_SINT => None,
            // RafxFormat::R64G64B64_SFLOAT => None,
            // RafxFormat::R64G64B64A64_UINT => None,
            // RafxFormat::R64G64B64A64_SINT => None,
            // RafxFormat::R64G64B64A64_SFLOAT => None,
            // RafxFormat::B10G11R11_UFLOAT_PACK32 => None,
            // RafxFormat::E5B9G9R9_UFLOAT_PACK32 => None,
            RafxFormat::D16_UNORM => Some(gl::UNSIGNED_SHORT),
            // RafxFormat::X8_D24_UNORM_PACK32 => None,
            RafxFormat::D32_SFLOAT => Some(gl::FLOAT),
            RafxFormat::S8_UINT => Some(gl::UNSIGNED_BYTE),
            RafxFormat::D16_UNORM_S8_UINT => Some(gl::UNSIGNED_INT_24_8),
            RafxFormat::D24_UNORM_S8_UINT => Some(gl::FLOAT_32_UNSIGNED_INT_24_8_REV),
            // RafxFormat::D32_SFLOAT_S8_UINT => None,
            // RafxFormat::BC1_RGB_UNORM_BLOCK => None,
            // RafxFormat::BC1_RGB_SRGB_BLOCK => None,
            // RafxFormat::BC1_RGBA_UNORM_BLOCK => None,
            // RafxFormat::BC1_RGBA_SRGB_BLOCK => None,
            // RafxFormat::BC2_UNORM_BLOCK => None,
            // RafxFormat::BC2_SRGB_BLOCK => None,
            // RafxFormat::BC3_UNORM_BLOCK => None,
            // RafxFormat::BC3_SRGB_BLOCK => None,
            // RafxFormat::BC4_UNORM_BLOCK => None,
            // RafxFormat::BC4_SNORM_BLOCK => None,
            // RafxFormat::BC5_UNORM_BLOCK => None,
            // RafxFormat::BC5_SNORM_BLOCK => None,
            // RafxFormat::BC6H_UFLOAT_BLOCK => None,
            // RafxFormat::BC6H_SFLOAT_BLOCK => None,
            // RafxFormat::BC7_UNORM_BLOCK => None,
            // RafxFormat::BC7_SRGB_BLOCK => None,
            // RafxFormat::ETC2_R8G8B8_UNORM_BLOCK => None,
            // RafxFormat::ETC2_R8G8B8_SRGB_BLOCK => None,
            // RafxFormat::ETC2_R8G8B8A1_UNORM_BLOCK => None,
            // RafxFormat::ETC2_R8G8B8A1_SRGB_BLOCK => None,
            // RafxFormat::ETC2_R8G8B8A8_UNORM_BLOCK => None,
            // RafxFormat::ETC2_R8G8B8A8_SRGB_BLOCK => None,
            // RafxFormat::EAC_R11_UNORM_BLOCK => None,
            // RafxFormat::EAC_R11_SNORM_BLOCK => None,
            // RafxFormat::EAC_R11G11_UNORM_BLOCK => None,
            // RafxFormat::EAC_R11G11_SNORM_BLOCK => None,
            // RafxFormat::ASTC_4X4_UNORM_BLOCK => None,
            // RafxFormat::ASTC_4X4_SRGB_BLOCK => None,
            // RafxFormat::ASTC_5X4_UNORM_BLOCK => None,
            // RafxFormat::ASTC_5X4_SRGB_BLOCK => None,
            // RafxFormat::ASTC_5X5_UNORM_BLOCK => None,
            // RafxFormat::ASTC_5X5_SRGB_BLOCK => None,
            // RafxFormat::ASTC_6X5_UNORM_BLOCK => None,
            // RafxFormat::ASTC_6X5_SRGB_BLOCK => None,
            // RafxFormat::ASTC_6X6_UNORM_BLOCK => None,
            // RafxFormat::ASTC_6X6_SRGB_BLOCK => None,
            // RafxFormat::ASTC_8X5_UNORM_BLOCK => None,
            // RafxFormat::ASTC_8X5_SRGB_BLOCK => None,
            // RafxFormat::ASTC_8X6_UNORM_BLOCK => None,
            // RafxFormat::ASTC_8X6_SRGB_BLOCK => None,
            // RafxFormat::ASTC_8X8_UNORM_BLOCK => None,
            // RafxFormat::ASTC_8X8_SRGB_BLOCK => None,
            // RafxFormat::ASTC_10X5_UNORM_BLOCK => None,
            // RafxFormat::ASTC_10X5_SRGB_BLOCK => None,
            // RafxFormat::ASTC_10X6_UNORM_BLOCK => None,
            // RafxFormat::ASTC_10X6_SRGB_BLOCK => None,
            // RafxFormat::ASTC_10X8_UNORM_BLOCK => None,
            // RafxFormat::ASTC_10X8_SRGB_BLOCK => None,
            // RafxFormat::ASTC_10X10_UNORM_BLOCK => None,
            // RafxFormat::ASTC_10X10_SRGB_BLOCK => None,
            // RafxFormat::ASTC_12X10_UNORM_BLOCK => None,
            // RafxFormat::ASTC_12X10_SRGB_BLOCK => None,
            // RafxFormat::ASTC_12X12_UNORM_BLOCK => None,
            // RafxFormat::ASTC_12X12_SRGB_BLOCK => None,
            _ => None,
        }
    }

    pub fn gles3_texture_format_info(self) -> Option<GlTextureFormatInfo> {
        use crate::gles3::gles3_bindings as gl;
        #[rustfmt::skip]
        let formats = match self {
            // RafxFormat::UNDEFINED => None,
            // RafxFormat::R4G4_UNORM_PACK8 => None,
            RafxFormat::R4G4B4A4_UNORM_PACK16 => Some((gl::RGBA, gl::RGBA)),
            // RafxFormat::B4G4R4A4_UNORM_PACK16 => None,
            RafxFormat::R5G6B5_UNORM_PACK16 => Some((gl::RGB, gl::RGB)),
            // RafxFormat::B5G6R5_UNORM_PACK16 => None,
            RafxFormat::R5G5B5A1_UNORM_PACK16 => Some((gl::RGBA, gl::RGBA)),
            // RafxFormat::B5G5R5A1_UNORM_PACK16 => None,
            // RafxFormat::A1R5G5B5_UNORM_PACK16 => None,
            RafxFormat::R8_UNORM => Some((gl::RED, gl::R8)),
            // RafxFormat::R8_SNORM => Some((gl::LUMINANCE, gl::LUMINANCE)),
            // RafxFormat::R8_USCALED => None,
            // RafxFormat::R8_SSCALED => None,
            // RafxFormat::R8_UINT => None,
            // RafxFormat::R8_SINT => None,
            // RafxFormat::R8_SRGB => None,
            // RafxFormat::R8G8_UNORM => None,
            // RafxFormat::R8G8_SNORM => None,
            // RafxFormat::R8G8_USCALED => None,
            // RafxFormat::R8G8_SSCALED => None,
            // RafxFormat::R8G8_UINT => None,
            // RafxFormat::R8G8_SINT => None,
            // RafxFormat::R8G8_SRGB => None,
            RafxFormat::R8G8B8_UNORM => Some((gl::RGB, gl::RGB)),
            // RafxFormat::R8G8B8_SNORM => Some((gl::RGB, gl::RGB)),
            // RafxFormat::R8G8B8_USCALED => None,
            // RafxFormat::R8G8B8_SSCALED => None,
            // RafxFormat::R8G8B8_UINT => None,
            // RafxFormat::R8G8B8_SINT => None,
            RafxFormat::R8G8B8_SRGB => Some((gl::RGB, gl::SRGB8)),
            // RafxFormat::B8G8R8_UNORM => None,
            // RafxFormat::B8G8R8_SNORM => None,
            // RafxFormat::B8G8R8_USCALED => None,
            // RafxFormat::B8G8R8_SSCALED => None,
            // RafxFormat::B8G8R8_UINT => None,
            // RafxFormat::B8G8R8_SINT => None,
            // RafxFormat::B8G8R8_SRGB => None,
            RafxFormat::R8G8B8A8_UNORM => Some((gl::RGBA, gl::RGBA)),
            // //RafxFormat::R8G8B8A8_SNORM => None,
            // RafxFormat::R8G8B8A8_USCALED => None,
            // RafxFormat::R8G8B8A8_SSCALED => None,
            // RafxFormat::R8G8B8A8_UINT => None,
            // RafxFormat::R8G8B8A8_SINT => None,
            RafxFormat::R8G8B8A8_SRGB => Some((gl::RGBA, gl::SRGB8_ALPHA8)),
            // RafxFormat::B8G8R8A8_UNORM => None,
            // RafxFormat::B8G8R8A8_SNORM => None,
            // RafxFormat::B8G8R8A8_USCALED => None,
            // RafxFormat::B8G8R8A8_SSCALED => None,
            // RafxFormat::B8G8R8A8_UINT => None,
            // RafxFormat::B8G8R8A8_SINT => None,
            // RafxFormat::B8G8R8A8_SRGB => None,
            // RafxFormat::A8B8G8R8_UNORM_PACK32 => None,
            // RafxFormat::A8B8G8R8_SNORM_PACK32 => None,
            // RafxFormat::A8B8G8R8_USCALED_PACK32 => None,
            // RafxFormat::A8B8G8R8_SSCALED_PACK32 => None,
            // RafxFormat::A8B8G8R8_UINT_PACK32 => None,
            // RafxFormat::A8B8G8R8_SINT_PACK32 => None,
            // RafxFormat::A8B8G8R8_SRGB_PACK32 => None,
            // RafxFormat::A2R10G10B10_UNORM_PACK32 => None,
            // RafxFormat::A2R10G10B10_SNORM_PACK32 => None,
            // RafxFormat::A2R10G10B10_USCALED_PACK32 => None,
            // RafxFormat::A2R10G10B10_SSCALED_PACK32 => None,
            // RafxFormat::A2R10G10B10_UINT_PACK32 => None,
            // RafxFormat::A2R10G10B10_SINT_PACK32 => None,
            // RafxFormat::A2B10G10R10_UNORM_PACK32 => None,
            // RafxFormat::A2B10G10R10_SNORM_PACK32 => None,
            // RafxFormat::A2B10G10R10_USCALED_PACK32 => None,
            // RafxFormat::A2B10G10R10_SSCALED_PACK32 => None,
            // RafxFormat::A2B10G10R10_UINT_PACK32 => None,
            // RafxFormat::A2B10G10R10_SINT_PACK32 => None,
            // RafxFormat::R16_UNORM => None,
            // RafxFormat::R16_SNORM => None,
            // RafxFormat::R16_USCALED => None,
            // RafxFormat::R16_SSCALED => None,
            // RafxFormat::R16_UINT => None,
            // RafxFormat::R16_SINT => None,
            // RafxFormat::R16_SFLOAT => None,
            // RafxFormat::R16G16_UNORM => None,
            // RafxFormat::R16G16_SNORM => None,
            // RafxFormat::R16G16_USCALED => None,
            // RafxFormat::R16G16_SSCALED => None,
            // RafxFormat::R16G16_UINT => None,
            // RafxFormat::R16G16_SINT => None,
            // RafxFormat::R16G16_SFLOAT => None,
            // RafxFormat::R16G16B16_UNORM => None,
            // RafxFormat::R16G16B16_SNORM => None,
            // RafxFormat::R16G16B16_USCALED => None,
            // RafxFormat::R16G16B16_SSCALED => None,
            // RafxFormat::R16G16B16_UINT => None,
            // RafxFormat::R16G16B16_SINT => None,
            // RafxFormat::R16G16B16_SFLOAT => None,
            // RafxFormat::R16G16B16A16_UNORM => None,
            // RafxFormat::R16G16B16A16_SNORM => None,
            // RafxFormat::R16G16B16A16_USCALED => None,
            // RafxFormat::R16G16B16A16_SSCALED => None,
            // RafxFormat::R16G16B16A16_UINT => None,
            // RafxFormat::R16G16B16A16_SINT => None,
            // RafxFormat::R16G16B16A16_SFLOAT => None,
            // RafxFormat::R32_UINT => None,
            // RafxFormat::R32_SINT => None,
            // RafxFormat::R32_SFLOAT => None,
            // RafxFormat::R32G32_UINT => None,
            // RafxFormat::R32G32_SINT => None,
            // RafxFormat::R32G32_SFLOAT => None,
            // RafxFormat::R32G32B32_UINT => None,
            // RafxFormat::R32G32B32_SINT => None,
            // RafxFormat::R32G32B32_SFLOAT => None,
            // RafxFormat::R32G32B32A32_UINT => None,
            // RafxFormat::R32G32B32A32_SINT => None,
            RafxFormat::R32G32B32A32_SFLOAT => Some((gl::RGBA, gl::RGBA32F)),
            // RafxFormat::R64_UINT => None,
            // RafxFormat::R64_SINT => None,
            // RafxFormat::R64_SFLOAT => None,
            // RafxFormat::R64G64_UINT => None,
            // RafxFormat::R64G64_SINT => None,
            // RafxFormat::R64G64_SFLOAT => None,
            // RafxFormat::R64G64B64_UINT => None,
            // RafxFormat::R64G64B64_SINT => None,
            // RafxFormat::R64G64B64_SFLOAT => None,
            // RafxFormat::R64G64B64A64_UINT => None,
            // RafxFormat::R64G64B64A64_SINT => None,
            // RafxFormat::R64G64B64A64_SFLOAT => None,
            // RafxFormat::B10G11R11_UFLOAT_PACK32 => None,
            // RafxFormat::E5B9G9R9_UFLOAT_PACK32 => None,
            RafxFormat::D16_UNORM => Some((gl::DEPTH_COMPONENT, gl::DEPTH_COMPONENT16)),
            // RafxFormat::X8_D24_UNORM_PACK32 => None,
            RafxFormat::D32_SFLOAT => Some((gl::DEPTH_COMPONENT, gl::DEPTH_COMPONENT32F)),
            // RafxFormat::S8_UINT => None,
            //RafxFormat::D16_UNORM_S8_UINT => None,
            RafxFormat::D24_UNORM_S8_UINT => Some((gl::DEPTH_STENCIL, gl::DEPTH24_STENCIL8)),
            RafxFormat::D32_SFLOAT_S8_UINT => Some((gl::DEPTH_STENCIL, gl::DEPTH32F_STENCIL8)),
            // RafxFormat::BC1_RGB_UNORM_BLOCK => None,
            // RafxFormat::BC1_RGB_SRGB_BLOCK => None,
            // RafxFormat::BC1_RGBA_UNORM_BLOCK => None,
            // RafxFormat::BC1_RGBA_SRGB_BLOCK => None,
            // RafxFormat::BC2_UNORM_BLOCK => None,
            // RafxFormat::BC2_SRGB_BLOCK => None,
            // RafxFormat::BC3_UNORM_BLOCK => None,
            // RafxFormat::BC3_SRGB_BLOCK => None,
            // RafxFormat::BC4_UNORM_BLOCK => None,
            // RafxFormat::BC4_SNORM_BLOCK => None,
            // RafxFormat::BC5_UNORM_BLOCK => None,
            // RafxFormat::BC5_SNORM_BLOCK => None,
            // RafxFormat::BC6H_UFLOAT_BLOCK => None,
            // RafxFormat::BC6H_SFLOAT_BLOCK => None,
            // RafxFormat::BC7_UNORM_BLOCK => None,
            // RafxFormat::BC7_SRGB_BLOCK => None,
            // RafxFormat::ETC2_R8G8B8_UNORM_BLOCK => None,
            // RafxFormat::ETC2_R8G8B8_SRGB_BLOCK => None,
            // RafxFormat::ETC2_R8G8B8A1_UNORM_BLOCK => None,
            // RafxFormat::ETC2_R8G8B8A1_SRGB_BLOCK => None,
            // RafxFormat::ETC2_R8G8B8A8_UNORM_BLOCK => None,
            // RafxFormat::ETC2_R8G8B8A8_SRGB_BLOCK => None,
            // RafxFormat::EAC_R11_UNORM_BLOCK => None,
            // RafxFormat::EAC_R11_SNORM_BLOCK => None,
            // RafxFormat::EAC_R11G11_UNORM_BLOCK => None,
            // RafxFormat::EAC_R11G11_SNORM_BLOCK => None,
            // RafxFormat::ASTC_4X4_UNORM_BLOCK => None,
            // RafxFormat::ASTC_4X4_SRGB_BLOCK => None,
            // RafxFormat::ASTC_5X4_UNORM_BLOCK => None,
            // RafxFormat::ASTC_5X4_SRGB_BLOCK => None,
            // RafxFormat::ASTC_5X5_UNORM_BLOCK => None,
            // RafxFormat::ASTC_5X5_SRGB_BLOCK => None,
            // RafxFormat::ASTC_6X5_UNORM_BLOCK => None,
            // RafxFormat::ASTC_6X5_SRGB_BLOCK => None,
            // RafxFormat::ASTC_6X6_UNORM_BLOCK => None,
            // RafxFormat::ASTC_6X6_SRGB_BLOCK => None,
            // RafxFormat::ASTC_8X5_UNORM_BLOCK => None,
            // RafxFormat::ASTC_8X5_SRGB_BLOCK => None,
            // RafxFormat::ASTC_8X6_UNORM_BLOCK => None,
            // RafxFormat::ASTC_8X6_SRGB_BLOCK => None,
            // RafxFormat::ASTC_8X8_UNORM_BLOCK => None,
            // RafxFormat::ASTC_8X8_SRGB_BLOCK => None,
            // RafxFormat::ASTC_10X5_UNORM_BLOCK => None,
            // RafxFormat::ASTC_10X5_SRGB_BLOCK => None,
            // RafxFormat::ASTC_10X6_UNORM_BLOCK => None,
            // RafxFormat::ASTC_10X6_SRGB_BLOCK => None,
            // RafxFormat::ASTC_10X8_UNORM_BLOCK => None,
            // RafxFormat::ASTC_10X8_SRGB_BLOCK => None,
            // RafxFormat::ASTC_10X10_UNORM_BLOCK => None,
            // RafxFormat::ASTC_10X10_SRGB_BLOCK => None,
            // RafxFormat::ASTC_12X10_UNORM_BLOCK => None,
            // RafxFormat::ASTC_12X10_SRGB_BLOCK => None,
            // RafxFormat::ASTC_12X12_UNORM_BLOCK => None,
            // RafxFormat::ASTC_12X12_SRGB_BLOCK => None,
            _ => None,
        };

        let gl_type = self.gles3_type()?;
        formats.map(|(gl_format, gl_internal_format)| GlTextureFormatInfo {
            gl_format,
            gl_type,
            gl_internal_format: gl_internal_format as i32
        })
    }
}

// Returns None for formats unlikely to be used for vertices (like ATSC blocks) or undefined
impl RafxFormat {
    pub fn is_depth_only(self) -> bool {
        match self {
            RafxFormat::D16_UNORM | RafxFormat::X8_D24_UNORM_PACK32 | RafxFormat::D32_SFLOAT => {
                true
            }
            _ => false,
        }
    }

    pub fn is_stencil_only(self) -> bool {
        self == RafxFormat::S8_UINT
    }

    pub fn is_depth_and_stencil(self) -> bool {
        match self {
            RafxFormat::D16_UNORM_S8_UINT
            | RafxFormat::D24_UNORM_S8_UINT
            | RafxFormat::D32_SFLOAT_S8_UINT => true,
            _ => false,
        }
    }

    pub fn has_depth(self) -> bool {
        self.is_depth_and_stencil() || self.is_depth_only()
    }

    pub fn has_stencil(self) -> bool {
        self.is_depth_and_stencil() || self.is_stencil_only()
    }

    pub fn has_depth_or_stencil(self) -> bool {
        self.is_depth_and_stencil() || self.is_stencil_only() || self.is_depth_only()
    }

    pub fn is_undefined(self) -> bool {
        self == RafxFormat::UNDEFINED
    }

    pub fn is_compressed(self) -> bool {
        match self {
            RafxFormat::BC1_RGB_UNORM_BLOCK
            | RafxFormat::BC1_RGB_SRGB_BLOCK
            | RafxFormat::BC1_RGBA_UNORM_BLOCK
            | RafxFormat::BC1_RGBA_SRGB_BLOCK
            | RafxFormat::BC2_UNORM_BLOCK
            | RafxFormat::BC2_SRGB_BLOCK
            | RafxFormat::BC3_UNORM_BLOCK
            | RafxFormat::BC3_SRGB_BLOCK
            | RafxFormat::BC4_UNORM_BLOCK
            | RafxFormat::BC4_SNORM_BLOCK
            | RafxFormat::BC5_UNORM_BLOCK
            | RafxFormat::BC5_SNORM_BLOCK
            | RafxFormat::BC6H_UFLOAT_BLOCK
            | RafxFormat::BC6H_SFLOAT_BLOCK
            | RafxFormat::BC7_UNORM_BLOCK
            | RafxFormat::BC7_SRGB_BLOCK
            | RafxFormat::ETC2_R8G8B8_UNORM_BLOCK
            | RafxFormat::ETC2_R8G8B8_SRGB_BLOCK
            | RafxFormat::ETC2_R8G8B8A1_UNORM_BLOCK
            | RafxFormat::ETC2_R8G8B8A1_SRGB_BLOCK
            | RafxFormat::ETC2_R8G8B8A8_UNORM_BLOCK
            | RafxFormat::ETC2_R8G8B8A8_SRGB_BLOCK
            | RafxFormat::EAC_R11_UNORM_BLOCK
            | RafxFormat::EAC_R11_SNORM_BLOCK
            | RafxFormat::EAC_R11G11_UNORM_BLOCK
            | RafxFormat::EAC_R11G11_SNORM_BLOCK
            | RafxFormat::ASTC_4X4_UNORM_BLOCK
            | RafxFormat::ASTC_4X4_SRGB_BLOCK
            | RafxFormat::ASTC_5X4_UNORM_BLOCK
            | RafxFormat::ASTC_5X4_SRGB_BLOCK
            | RafxFormat::ASTC_5X5_UNORM_BLOCK
            | RafxFormat::ASTC_5X5_SRGB_BLOCK
            | RafxFormat::ASTC_6X5_UNORM_BLOCK
            | RafxFormat::ASTC_6X5_SRGB_BLOCK
            | RafxFormat::ASTC_6X6_UNORM_BLOCK
            | RafxFormat::ASTC_6X6_SRGB_BLOCK
            | RafxFormat::ASTC_8X5_UNORM_BLOCK
            | RafxFormat::ASTC_8X5_SRGB_BLOCK
            | RafxFormat::ASTC_8X6_UNORM_BLOCK
            | RafxFormat::ASTC_8X6_SRGB_BLOCK
            | RafxFormat::ASTC_8X8_UNORM_BLOCK
            | RafxFormat::ASTC_8X8_SRGB_BLOCK
            | RafxFormat::ASTC_10X5_UNORM_BLOCK
            | RafxFormat::ASTC_10X5_SRGB_BLOCK
            | RafxFormat::ASTC_10X6_UNORM_BLOCK
            | RafxFormat::ASTC_10X6_SRGB_BLOCK
            | RafxFormat::ASTC_10X8_UNORM_BLOCK
            | RafxFormat::ASTC_10X8_SRGB_BLOCK
            | RafxFormat::ASTC_10X10_UNORM_BLOCK
            | RafxFormat::ASTC_10X10_SRGB_BLOCK
            | RafxFormat::ASTC_12X10_UNORM_BLOCK
            | RafxFormat::ASTC_12X10_SRGB_BLOCK
            | RafxFormat::ASTC_12X12_UNORM_BLOCK
            | RafxFormat::ASTC_12X12_SRGB_BLOCK => true,
            _ => false,
        }
    }

    pub fn block_or_pixel_size_in_bytes(self) -> u32 {
        match self {
            RafxFormat::UNDEFINED => unimplemented!(),

            // Pixel-based
            RafxFormat::R4G4_UNORM_PACK8 => 1,
            RafxFormat::R4G4B4A4_UNORM_PACK16 => 2,
            RafxFormat::B4G4R4A4_UNORM_PACK16 => 2,
            RafxFormat::R5G6B5_UNORM_PACK16 => 2,
            RafxFormat::B5G6R5_UNORM_PACK16 => 2,
            RafxFormat::R5G5B5A1_UNORM_PACK16 => 2,
            RafxFormat::B5G5R5A1_UNORM_PACK16 => 2,
            RafxFormat::A1R5G5B5_UNORM_PACK16 => 2,
            RafxFormat::R8_UNORM => 1,
            RafxFormat::R8_SNORM => 1,
            RafxFormat::R8_USCALED => 1,
            RafxFormat::R8_SSCALED => 1,
            RafxFormat::R8_UINT => 1,
            RafxFormat::R8_SINT => 1,
            RafxFormat::R8_SRGB => 1,
            RafxFormat::R8G8_UNORM => 2,
            RafxFormat::R8G8_SNORM => 2,
            RafxFormat::R8G8_USCALED => 2,
            RafxFormat::R8G8_SSCALED => 2,
            RafxFormat::R8G8_UINT => 2,
            RafxFormat::R8G8_SINT => 2,
            RafxFormat::R8G8_SRGB => 2,
            RafxFormat::R8G8B8_UNORM => 3,
            RafxFormat::R8G8B8_SNORM => 3,
            RafxFormat::R8G8B8_USCALED => 3,
            RafxFormat::R8G8B8_SSCALED => 3,
            RafxFormat::R8G8B8_UINT => 3,
            RafxFormat::R8G8B8_SINT => 3,
            RafxFormat::R8G8B8_SRGB => 3,
            RafxFormat::B8G8R8_UNORM => 3,
            RafxFormat::B8G8R8_SNORM => 3,
            RafxFormat::B8G8R8_USCALED => 3,
            RafxFormat::B8G8R8_SSCALED => 3,
            RafxFormat::B8G8R8_UINT => 3,
            RafxFormat::B8G8R8_SINT => 3,
            RafxFormat::B8G8R8_SRGB => 3,
            RafxFormat::R8G8B8A8_UNORM => 4,
            RafxFormat::R8G8B8A8_SNORM => 4,
            RafxFormat::R8G8B8A8_USCALED => 4,
            RafxFormat::R8G8B8A8_SSCALED => 4,
            RafxFormat::R8G8B8A8_UINT => 4,
            RafxFormat::R8G8B8A8_SINT => 4,
            RafxFormat::R8G8B8A8_SRGB => 4,
            RafxFormat::B8G8R8A8_UNORM => 4,
            RafxFormat::B8G8R8A8_SNORM => 4,
            RafxFormat::B8G8R8A8_USCALED => 4,
            RafxFormat::B8G8R8A8_SSCALED => 4,
            RafxFormat::B8G8R8A8_UINT => 4,
            RafxFormat::B8G8R8A8_SINT => 4,
            RafxFormat::B8G8R8A8_SRGB => 4,
            RafxFormat::A8B8G8R8_UNORM_PACK32 => 4,
            RafxFormat::A8B8G8R8_SNORM_PACK32 => 4,
            RafxFormat::A8B8G8R8_USCALED_PACK32 => 4,
            RafxFormat::A8B8G8R8_SSCALED_PACK32 => 4,
            RafxFormat::A8B8G8R8_UINT_PACK32 => 4,
            RafxFormat::A8B8G8R8_SINT_PACK32 => 4,
            RafxFormat::A8B8G8R8_SRGB_PACK32 => 4,
            RafxFormat::A2R10G10B10_UNORM_PACK32 => 4,
            RafxFormat::A2R10G10B10_SNORM_PACK32 => 4,
            RafxFormat::A2R10G10B10_USCALED_PACK32 => 4,
            RafxFormat::A2R10G10B10_SSCALED_PACK32 => 4,
            RafxFormat::A2R10G10B10_UINT_PACK32 => 4,
            RafxFormat::A2R10G10B10_SINT_PACK32 => 4,
            RafxFormat::A2B10G10R10_UNORM_PACK32 => 4,
            RafxFormat::A2B10G10R10_SNORM_PACK32 => 4,
            RafxFormat::A2B10G10R10_USCALED_PACK32 => 4,
            RafxFormat::A2B10G10R10_SSCALED_PACK32 => 4,
            RafxFormat::A2B10G10R10_UINT_PACK32 => 4,
            RafxFormat::A2B10G10R10_SINT_PACK32 => 4,
            RafxFormat::R16_UNORM => 2,
            RafxFormat::R16_SNORM => 2,
            RafxFormat::R16_USCALED => 2,
            RafxFormat::R16_SSCALED => 2,
            RafxFormat::R16_UINT => 2,
            RafxFormat::R16_SINT => 2,
            RafxFormat::R16_SFLOAT => 2,
            RafxFormat::R16G16_UNORM => 4,
            RafxFormat::R16G16_SNORM => 4,
            RafxFormat::R16G16_USCALED => 4,
            RafxFormat::R16G16_SSCALED => 4,
            RafxFormat::R16G16_UINT => 4,
            RafxFormat::R16G16_SINT => 4,
            RafxFormat::R16G16_SFLOAT => 4,
            RafxFormat::R16G16B16_UNORM => 6,
            RafxFormat::R16G16B16_SNORM => 6,
            RafxFormat::R16G16B16_USCALED => 6,
            RafxFormat::R16G16B16_SSCALED => 6,
            RafxFormat::R16G16B16_UINT => 6,
            RafxFormat::R16G16B16_SINT => 6,
            RafxFormat::R16G16B16_SFLOAT => 6,
            RafxFormat::R16G16B16A16_UNORM => 8,
            RafxFormat::R16G16B16A16_SNORM => 8,
            RafxFormat::R16G16B16A16_USCALED => 8,
            RafxFormat::R16G16B16A16_SSCALED => 8,
            RafxFormat::R16G16B16A16_UINT => 8,
            RafxFormat::R16G16B16A16_SINT => 8,
            RafxFormat::R16G16B16A16_SFLOAT => 8,
            RafxFormat::R32_UINT => 4,
            RafxFormat::R32_SINT => 4,
            RafxFormat::R32_SFLOAT => 4,
            RafxFormat::R32G32_UINT => 8,
            RafxFormat::R32G32_SINT => 8,
            RafxFormat::R32G32_SFLOAT => 8,
            RafxFormat::R32G32B32_UINT => 12,
            RafxFormat::R32G32B32_SINT => 12,
            RafxFormat::R32G32B32_SFLOAT => 12,
            RafxFormat::R32G32B32A32_UINT => 16,
            RafxFormat::R32G32B32A32_SINT => 16,
            RafxFormat::R32G32B32A32_SFLOAT => 16,
            RafxFormat::R64_UINT => 8,
            RafxFormat::R64_SINT => 8,
            RafxFormat::R64_SFLOAT => 8,
            RafxFormat::R64G64_UINT => 16,
            RafxFormat::R64G64_SINT => 16,
            RafxFormat::R64G64_SFLOAT => 16,
            RafxFormat::R64G64B64_UINT => 24,
            RafxFormat::R64G64B64_SINT => 24,
            RafxFormat::R64G64B64_SFLOAT => 24,
            RafxFormat::R64G64B64A64_UINT => 32,
            RafxFormat::R64G64B64A64_SINT => 32,
            RafxFormat::R64G64B64A64_SFLOAT => 32,
            RafxFormat::B10G11R11_UFLOAT_PACK32 => 4,
            RafxFormat::E5B9G9R9_UFLOAT_PACK32 => 4,
            RafxFormat::D16_UNORM => 2,
            RafxFormat::X8_D24_UNORM_PACK32 => 4,
            RafxFormat::D32_SFLOAT => 4,
            RafxFormat::S8_UINT => 1,
            RafxFormat::D16_UNORM_S8_UINT => 3,
            RafxFormat::D24_UNORM_S8_UINT => 4,
            RafxFormat::D32_SFLOAT_S8_UINT => 5,

            // Block-based
            RafxFormat::BC1_RGB_UNORM_BLOCK => 8,
            RafxFormat::BC1_RGB_SRGB_BLOCK => 8,
            RafxFormat::BC1_RGBA_UNORM_BLOCK => 8,
            RafxFormat::BC1_RGBA_SRGB_BLOCK => 8,
            RafxFormat::BC2_UNORM_BLOCK => 16,
            RafxFormat::BC2_SRGB_BLOCK => 16,
            RafxFormat::BC3_UNORM_BLOCK => 16,
            RafxFormat::BC3_SRGB_BLOCK => 16,
            RafxFormat::BC4_UNORM_BLOCK => 8,
            RafxFormat::BC4_SNORM_BLOCK => 8,
            RafxFormat::BC5_UNORM_BLOCK => 16,
            RafxFormat::BC5_SNORM_BLOCK => 16,
            RafxFormat::BC6H_UFLOAT_BLOCK => 16,
            RafxFormat::BC6H_SFLOAT_BLOCK => 16,
            RafxFormat::BC7_UNORM_BLOCK => 16,
            RafxFormat::BC7_SRGB_BLOCK => 16,
            RafxFormat::ETC2_R8G8B8_UNORM_BLOCK => 8,
            RafxFormat::ETC2_R8G8B8_SRGB_BLOCK => 8,
            RafxFormat::ETC2_R8G8B8A1_UNORM_BLOCK => 8,
            RafxFormat::ETC2_R8G8B8A1_SRGB_BLOCK => 8,
            RafxFormat::ETC2_R8G8B8A8_UNORM_BLOCK => 8,
            RafxFormat::ETC2_R8G8B8A8_SRGB_BLOCK => 8,
            RafxFormat::EAC_R11_UNORM_BLOCK => 8,
            RafxFormat::EAC_R11_SNORM_BLOCK => 8,
            RafxFormat::EAC_R11G11_UNORM_BLOCK => 8,
            RafxFormat::EAC_R11G11_SNORM_BLOCK => 8,
            RafxFormat::ASTC_4X4_UNORM_BLOCK => 16,
            RafxFormat::ASTC_4X4_SRGB_BLOCK => 16,
            RafxFormat::ASTC_5X4_UNORM_BLOCK => 16,
            RafxFormat::ASTC_5X4_SRGB_BLOCK => 16,
            RafxFormat::ASTC_5X5_UNORM_BLOCK => 16,
            RafxFormat::ASTC_5X5_SRGB_BLOCK => 16,
            RafxFormat::ASTC_6X5_UNORM_BLOCK => 16,
            RafxFormat::ASTC_6X5_SRGB_BLOCK => 16,
            RafxFormat::ASTC_6X6_UNORM_BLOCK => 16,
            RafxFormat::ASTC_6X6_SRGB_BLOCK => 16,
            RafxFormat::ASTC_8X5_UNORM_BLOCK => 16,
            RafxFormat::ASTC_8X5_SRGB_BLOCK => 16,
            RafxFormat::ASTC_8X6_UNORM_BLOCK => 16,
            RafxFormat::ASTC_8X6_SRGB_BLOCK => 16,
            RafxFormat::ASTC_8X8_UNORM_BLOCK => 16,
            RafxFormat::ASTC_8X8_SRGB_BLOCK => 16,
            RafxFormat::ASTC_10X5_UNORM_BLOCK => 16,
            RafxFormat::ASTC_10X5_SRGB_BLOCK => 16,
            RafxFormat::ASTC_10X6_UNORM_BLOCK => 16,
            RafxFormat::ASTC_10X6_SRGB_BLOCK => 16,
            RafxFormat::ASTC_10X8_UNORM_BLOCK => 16,
            RafxFormat::ASTC_10X8_SRGB_BLOCK => 16,
            RafxFormat::ASTC_10X10_UNORM_BLOCK => 16,
            RafxFormat::ASTC_10X10_SRGB_BLOCK => 16,
            RafxFormat::ASTC_12X10_UNORM_BLOCK => 16,
            RafxFormat::ASTC_12X10_SRGB_BLOCK => 16,
            RafxFormat::ASTC_12X12_UNORM_BLOCK => 16,
            RafxFormat::ASTC_12X12_SRGB_BLOCK => 16,
        }
    }

    pub fn block_width_in_pixels(self) -> u32 {
        match self {
            RafxFormat::UNDEFINED => unimplemented!(),

            RafxFormat::BC1_RGB_UNORM_BLOCK => 4,
            RafxFormat::BC1_RGB_SRGB_BLOCK => 4,
            RafxFormat::BC1_RGBA_UNORM_BLOCK => 4,
            RafxFormat::BC1_RGBA_SRGB_BLOCK => 4,
            RafxFormat::BC2_UNORM_BLOCK => 4,
            RafxFormat::BC2_SRGB_BLOCK => 4,
            RafxFormat::BC3_UNORM_BLOCK => 4,
            RafxFormat::BC3_SRGB_BLOCK => 4,
            RafxFormat::BC4_UNORM_BLOCK => 4,
            RafxFormat::BC4_SNORM_BLOCK => 4,
            RafxFormat::BC5_UNORM_BLOCK => 4,
            RafxFormat::BC5_SNORM_BLOCK => 4,
            RafxFormat::BC6H_UFLOAT_BLOCK => 4,
            RafxFormat::BC6H_SFLOAT_BLOCK => 4,
            RafxFormat::BC7_UNORM_BLOCK => 4,
            RafxFormat::BC7_SRGB_BLOCK => 4,
            RafxFormat::ETC2_R8G8B8_UNORM_BLOCK => 4,
            RafxFormat::ETC2_R8G8B8_SRGB_BLOCK => 4,
            RafxFormat::ETC2_R8G8B8A1_UNORM_BLOCK => 4,
            RafxFormat::ETC2_R8G8B8A1_SRGB_BLOCK => 4,
            RafxFormat::ETC2_R8G8B8A8_UNORM_BLOCK => 4,
            RafxFormat::ETC2_R8G8B8A8_SRGB_BLOCK => 4,
            RafxFormat::EAC_R11_UNORM_BLOCK => 4,
            RafxFormat::EAC_R11_SNORM_BLOCK => 4,
            RafxFormat::EAC_R11G11_UNORM_BLOCK => 4,
            RafxFormat::EAC_R11G11_SNORM_BLOCK => 4,
            RafxFormat::ASTC_4X4_UNORM_BLOCK => 4,
            RafxFormat::ASTC_4X4_SRGB_BLOCK => 4,
            RafxFormat::ASTC_5X4_UNORM_BLOCK => 5,
            RafxFormat::ASTC_5X4_SRGB_BLOCK => 5,
            RafxFormat::ASTC_5X5_UNORM_BLOCK => 5,
            RafxFormat::ASTC_5X5_SRGB_BLOCK => 5,
            RafxFormat::ASTC_6X5_UNORM_BLOCK => 6,
            RafxFormat::ASTC_6X5_SRGB_BLOCK => 6,
            RafxFormat::ASTC_6X6_UNORM_BLOCK => 6,
            RafxFormat::ASTC_6X6_SRGB_BLOCK => 6,
            RafxFormat::ASTC_8X5_UNORM_BLOCK => 8,
            RafxFormat::ASTC_8X5_SRGB_BLOCK => 8,
            RafxFormat::ASTC_8X6_UNORM_BLOCK => 8,
            RafxFormat::ASTC_8X6_SRGB_BLOCK => 8,
            RafxFormat::ASTC_8X8_UNORM_BLOCK => 8,
            RafxFormat::ASTC_8X8_SRGB_BLOCK => 8,
            RafxFormat::ASTC_10X5_UNORM_BLOCK => 10,
            RafxFormat::ASTC_10X5_SRGB_BLOCK => 10,
            RafxFormat::ASTC_10X6_UNORM_BLOCK => 10,
            RafxFormat::ASTC_10X6_SRGB_BLOCK => 10,
            RafxFormat::ASTC_10X8_UNORM_BLOCK => 10,
            RafxFormat::ASTC_10X8_SRGB_BLOCK => 10,
            RafxFormat::ASTC_10X10_UNORM_BLOCK => 10,
            RafxFormat::ASTC_10X10_SRGB_BLOCK => 10,
            RafxFormat::ASTC_12X10_UNORM_BLOCK => 12,
            RafxFormat::ASTC_12X10_SRGB_BLOCK => 12,
            RafxFormat::ASTC_12X12_UNORM_BLOCK => 12,
            RafxFormat::ASTC_12X12_SRGB_BLOCK => 12,

            _ => 1,
        }
    }

    pub fn block_height_in_pixels(self) -> u32 {
        match self {
            RafxFormat::UNDEFINED => unimplemented!(),

            RafxFormat::BC1_RGB_UNORM_BLOCK => 4,
            RafxFormat::BC1_RGB_SRGB_BLOCK => 4,
            RafxFormat::BC1_RGBA_UNORM_BLOCK => 4,
            RafxFormat::BC1_RGBA_SRGB_BLOCK => 4,
            RafxFormat::BC2_UNORM_BLOCK => 4,
            RafxFormat::BC2_SRGB_BLOCK => 4,
            RafxFormat::BC3_UNORM_BLOCK => 4,
            RafxFormat::BC3_SRGB_BLOCK => 4,
            RafxFormat::BC4_UNORM_BLOCK => 4,
            RafxFormat::BC4_SNORM_BLOCK => 4,
            RafxFormat::BC5_UNORM_BLOCK => 4,
            RafxFormat::BC5_SNORM_BLOCK => 4,
            RafxFormat::BC6H_UFLOAT_BLOCK => 4,
            RafxFormat::BC6H_SFLOAT_BLOCK => 4,
            RafxFormat::BC7_UNORM_BLOCK => 4,
            RafxFormat::BC7_SRGB_BLOCK => 4,
            RafxFormat::ETC2_R8G8B8_UNORM_BLOCK => 4,
            RafxFormat::ETC2_R8G8B8_SRGB_BLOCK => 4,
            RafxFormat::ETC2_R8G8B8A1_UNORM_BLOCK => 4,
            RafxFormat::ETC2_R8G8B8A1_SRGB_BLOCK => 4,
            RafxFormat::ETC2_R8G8B8A8_UNORM_BLOCK => 4,
            RafxFormat::ETC2_R8G8B8A8_SRGB_BLOCK => 4,
            RafxFormat::EAC_R11_UNORM_BLOCK => 4,
            RafxFormat::EAC_R11_SNORM_BLOCK => 4,
            RafxFormat::EAC_R11G11_UNORM_BLOCK => 4,
            RafxFormat::EAC_R11G11_SNORM_BLOCK => 4,
            RafxFormat::ASTC_4X4_UNORM_BLOCK => 4,
            RafxFormat::ASTC_4X4_SRGB_BLOCK => 4,
            RafxFormat::ASTC_5X4_UNORM_BLOCK => 4,
            RafxFormat::ASTC_5X4_SRGB_BLOCK => 4,
            RafxFormat::ASTC_5X5_UNORM_BLOCK => 5,
            RafxFormat::ASTC_5X5_SRGB_BLOCK => 5,
            RafxFormat::ASTC_6X5_UNORM_BLOCK => 5,
            RafxFormat::ASTC_6X5_SRGB_BLOCK => 5,
            RafxFormat::ASTC_6X6_UNORM_BLOCK => 6,
            RafxFormat::ASTC_6X6_SRGB_BLOCK => 6,
            RafxFormat::ASTC_8X5_UNORM_BLOCK => 5,
            RafxFormat::ASTC_8X5_SRGB_BLOCK => 5,
            RafxFormat::ASTC_8X6_UNORM_BLOCK => 6,
            RafxFormat::ASTC_8X6_SRGB_BLOCK => 6,
            RafxFormat::ASTC_8X8_UNORM_BLOCK => 8,
            RafxFormat::ASTC_8X8_SRGB_BLOCK => 8,
            RafxFormat::ASTC_10X5_UNORM_BLOCK => 5,
            RafxFormat::ASTC_10X5_SRGB_BLOCK => 5,
            RafxFormat::ASTC_10X6_UNORM_BLOCK => 6,
            RafxFormat::ASTC_10X6_SRGB_BLOCK => 6,
            RafxFormat::ASTC_10X8_UNORM_BLOCK => 8,
            RafxFormat::ASTC_10X8_SRGB_BLOCK => 8,
            RafxFormat::ASTC_10X10_UNORM_BLOCK => 10,
            RafxFormat::ASTC_10X10_SRGB_BLOCK => 10,
            RafxFormat::ASTC_12X10_UNORM_BLOCK => 10,
            RafxFormat::ASTC_12X10_SRGB_BLOCK => 10,
            RafxFormat::ASTC_12X12_UNORM_BLOCK => 12,
            RafxFormat::ASTC_12X12_SRGB_BLOCK => 12,
            _ => 1,
        }
    }

    pub fn channel_count(self) -> u32 {
        match self {
            RafxFormat::UNDEFINED => unimplemented!(),

            // Pixel-based
            RafxFormat::R4G4_UNORM_PACK8 => 2,
            RafxFormat::R4G4B4A4_UNORM_PACK16 => 4,
            RafxFormat::B4G4R4A4_UNORM_PACK16 => 4,
            RafxFormat::R5G6B5_UNORM_PACK16 => 3,
            RafxFormat::B5G6R5_UNORM_PACK16 => 3,
            RafxFormat::R5G5B5A1_UNORM_PACK16 => 4,
            RafxFormat::B5G5R5A1_UNORM_PACK16 => 4,
            RafxFormat::A1R5G5B5_UNORM_PACK16 => 4,
            RafxFormat::R8_UNORM => 1,
            RafxFormat::R8_SNORM => 1,
            RafxFormat::R8_USCALED => 1,
            RafxFormat::R8_SSCALED => 1,
            RafxFormat::R8_UINT => 1,
            RafxFormat::R8_SINT => 1,
            RafxFormat::R8_SRGB => 1,
            RafxFormat::R8G8_UNORM => 2,
            RafxFormat::R8G8_SNORM => 2,
            RafxFormat::R8G8_USCALED => 2,
            RafxFormat::R8G8_SSCALED => 2,
            RafxFormat::R8G8_UINT => 2,
            RafxFormat::R8G8_SINT => 2,
            RafxFormat::R8G8_SRGB => 2,
            RafxFormat::R8G8B8_UNORM => 3,
            RafxFormat::R8G8B8_SNORM => 3,
            RafxFormat::R8G8B8_USCALED => 3,
            RafxFormat::R8G8B8_SSCALED => 3,
            RafxFormat::R8G8B8_UINT => 3,
            RafxFormat::R8G8B8_SINT => 3,
            RafxFormat::R8G8B8_SRGB => 3,
            RafxFormat::B8G8R8_UNORM => 3,
            RafxFormat::B8G8R8_SNORM => 3,
            RafxFormat::B8G8R8_USCALED => 3,
            RafxFormat::B8G8R8_SSCALED => 3,
            RafxFormat::B8G8R8_UINT => 3,
            RafxFormat::B8G8R8_SINT => 3,
            RafxFormat::B8G8R8_SRGB => 3,
            RafxFormat::R8G8B8A8_UNORM => 4,
            RafxFormat::R8G8B8A8_SNORM => 4,
            RafxFormat::R8G8B8A8_USCALED => 4,
            RafxFormat::R8G8B8A8_SSCALED => 4,
            RafxFormat::R8G8B8A8_UINT => 4,
            RafxFormat::R8G8B8A8_SINT => 4,
            RafxFormat::R8G8B8A8_SRGB => 4,
            RafxFormat::B8G8R8A8_UNORM => 4,
            RafxFormat::B8G8R8A8_SNORM => 4,
            RafxFormat::B8G8R8A8_USCALED => 4,
            RafxFormat::B8G8R8A8_SSCALED => 4,
            RafxFormat::B8G8R8A8_UINT => 4,
            RafxFormat::B8G8R8A8_SINT => 4,
            RafxFormat::B8G8R8A8_SRGB => 4,
            RafxFormat::A8B8G8R8_UNORM_PACK32 => 4,
            RafxFormat::A8B8G8R8_SNORM_PACK32 => 4,
            RafxFormat::A8B8G8R8_USCALED_PACK32 => 4,
            RafxFormat::A8B8G8R8_SSCALED_PACK32 => 4,
            RafxFormat::A8B8G8R8_UINT_PACK32 => 4,
            RafxFormat::A8B8G8R8_SINT_PACK32 => 4,
            RafxFormat::A8B8G8R8_SRGB_PACK32 => 4,
            RafxFormat::A2R10G10B10_UNORM_PACK32 => 4,
            RafxFormat::A2R10G10B10_SNORM_PACK32 => 4,
            RafxFormat::A2R10G10B10_USCALED_PACK32 => 4,
            RafxFormat::A2R10G10B10_SSCALED_PACK32 => 4,
            RafxFormat::A2R10G10B10_UINT_PACK32 => 4,
            RafxFormat::A2R10G10B10_SINT_PACK32 => 4,
            RafxFormat::A2B10G10R10_UNORM_PACK32 => 4,
            RafxFormat::A2B10G10R10_SNORM_PACK32 => 4,
            RafxFormat::A2B10G10R10_USCALED_PACK32 => 4,
            RafxFormat::A2B10G10R10_SSCALED_PACK32 => 4,
            RafxFormat::A2B10G10R10_UINT_PACK32 => 4,
            RafxFormat::A2B10G10R10_SINT_PACK32 => 4,
            RafxFormat::R16_UNORM => 1,
            RafxFormat::R16_SNORM => 1,
            RafxFormat::R16_USCALED => 1,
            RafxFormat::R16_SSCALED => 1,
            RafxFormat::R16_UINT => 1,
            RafxFormat::R16_SINT => 1,
            RafxFormat::R16_SFLOAT => 1,
            RafxFormat::R16G16_UNORM => 2,
            RafxFormat::R16G16_SNORM => 2,
            RafxFormat::R16G16_USCALED => 2,
            RafxFormat::R16G16_SSCALED => 2,
            RafxFormat::R16G16_UINT => 2,
            RafxFormat::R16G16_SINT => 2,
            RafxFormat::R16G16_SFLOAT => 2,
            RafxFormat::R16G16B16_UNORM => 3,
            RafxFormat::R16G16B16_SNORM => 3,
            RafxFormat::R16G16B16_USCALED => 3,
            RafxFormat::R16G16B16_SSCALED => 3,
            RafxFormat::R16G16B16_UINT => 3,
            RafxFormat::R16G16B16_SINT => 3,
            RafxFormat::R16G16B16_SFLOAT => 3,
            RafxFormat::R16G16B16A16_UNORM => 4,
            RafxFormat::R16G16B16A16_SNORM => 4,
            RafxFormat::R16G16B16A16_USCALED => 4,
            RafxFormat::R16G16B16A16_SSCALED => 4,
            RafxFormat::R16G16B16A16_UINT => 4,
            RafxFormat::R16G16B16A16_SINT => 4,
            RafxFormat::R16G16B16A16_SFLOAT => 4,
            RafxFormat::R32_UINT => 1,
            RafxFormat::R32_SINT => 1,
            RafxFormat::R32_SFLOAT => 1,
            RafxFormat::R32G32_UINT => 2,
            RafxFormat::R32G32_SINT => 2,
            RafxFormat::R32G32_SFLOAT => 2,
            RafxFormat::R32G32B32_UINT => 3,
            RafxFormat::R32G32B32_SINT => 3,
            RafxFormat::R32G32B32_SFLOAT => 3,
            RafxFormat::R32G32B32A32_UINT => 4,
            RafxFormat::R32G32B32A32_SINT => 4,
            RafxFormat::R32G32B32A32_SFLOAT => 4,
            RafxFormat::R64_UINT => 1,
            RafxFormat::R64_SINT => 1,
            RafxFormat::R64_SFLOAT => 1,
            RafxFormat::R64G64_UINT => 2,
            RafxFormat::R64G64_SINT => 2,
            RafxFormat::R64G64_SFLOAT => 2,
            RafxFormat::R64G64B64_UINT => 3,
            RafxFormat::R64G64B64_SINT => 3,
            RafxFormat::R64G64B64_SFLOAT => 3,
            RafxFormat::R64G64B64A64_UINT => 4,
            RafxFormat::R64G64B64A64_SINT => 4,
            RafxFormat::R64G64B64A64_SFLOAT => 4,
            RafxFormat::B10G11R11_UFLOAT_PACK32 => 3,
            RafxFormat::E5B9G9R9_UFLOAT_PACK32 => 4,
            RafxFormat::D16_UNORM => 1,
            RafxFormat::X8_D24_UNORM_PACK32 => 2,
            RafxFormat::D32_SFLOAT => 1,
            RafxFormat::S8_UINT => 1,
            RafxFormat::D16_UNORM_S8_UINT => 2,
            RafxFormat::D24_UNORM_S8_UINT => 2,
            RafxFormat::D32_SFLOAT_S8_UINT => 2,

            // Block-based
            RafxFormat::BC1_RGB_UNORM_BLOCK => 3,
            RafxFormat::BC1_RGB_SRGB_BLOCK => 3,
            RafxFormat::BC1_RGBA_UNORM_BLOCK => 4,
            RafxFormat::BC1_RGBA_SRGB_BLOCK => 4,
            RafxFormat::BC2_UNORM_BLOCK => 4,
            RafxFormat::BC2_SRGB_BLOCK => 4,
            RafxFormat::BC3_UNORM_BLOCK => 4,
            RafxFormat::BC3_SRGB_BLOCK => 4,
            RafxFormat::BC4_UNORM_BLOCK => 1,
            RafxFormat::BC4_SNORM_BLOCK => 1,
            RafxFormat::BC5_UNORM_BLOCK => 2,
            RafxFormat::BC5_SNORM_BLOCK => 2,
            RafxFormat::BC6H_UFLOAT_BLOCK => 3,
            RafxFormat::BC6H_SFLOAT_BLOCK => 3,
            RafxFormat::BC7_UNORM_BLOCK => 4,
            RafxFormat::BC7_SRGB_BLOCK => 4,
            RafxFormat::ETC2_R8G8B8_UNORM_BLOCK => 3,
            RafxFormat::ETC2_R8G8B8_SRGB_BLOCK => 3,
            RafxFormat::ETC2_R8G8B8A1_UNORM_BLOCK => 4,
            RafxFormat::ETC2_R8G8B8A1_SRGB_BLOCK => 4,
            RafxFormat::ETC2_R8G8B8A8_UNORM_BLOCK => 4,
            RafxFormat::ETC2_R8G8B8A8_SRGB_BLOCK => 4,
            RafxFormat::EAC_R11_UNORM_BLOCK => 1,
            RafxFormat::EAC_R11_SNORM_BLOCK => 1,
            RafxFormat::EAC_R11G11_UNORM_BLOCK => 2,
            RafxFormat::EAC_R11G11_SNORM_BLOCK => 2,
            RafxFormat::ASTC_4X4_UNORM_BLOCK => 4,
            RafxFormat::ASTC_4X4_SRGB_BLOCK => 4,
            RafxFormat::ASTC_5X4_UNORM_BLOCK => 4,
            RafxFormat::ASTC_5X4_SRGB_BLOCK => 4,
            RafxFormat::ASTC_5X5_UNORM_BLOCK => 4,
            RafxFormat::ASTC_5X5_SRGB_BLOCK => 4,
            RafxFormat::ASTC_6X5_UNORM_BLOCK => 4,
            RafxFormat::ASTC_6X5_SRGB_BLOCK => 4,
            RafxFormat::ASTC_6X6_UNORM_BLOCK => 4,
            RafxFormat::ASTC_6X6_SRGB_BLOCK => 4,
            RafxFormat::ASTC_8X5_UNORM_BLOCK => 4,
            RafxFormat::ASTC_8X5_SRGB_BLOCK => 4,
            RafxFormat::ASTC_8X6_UNORM_BLOCK => 4,
            RafxFormat::ASTC_8X6_SRGB_BLOCK => 4,
            RafxFormat::ASTC_8X8_UNORM_BLOCK => 4,
            RafxFormat::ASTC_8X8_SRGB_BLOCK => 4,
            RafxFormat::ASTC_10X5_UNORM_BLOCK => 4,
            RafxFormat::ASTC_10X5_SRGB_BLOCK => 4,
            RafxFormat::ASTC_10X6_UNORM_BLOCK => 4,
            RafxFormat::ASTC_10X6_SRGB_BLOCK => 4,
            RafxFormat::ASTC_10X8_UNORM_BLOCK => 4,
            RafxFormat::ASTC_10X8_SRGB_BLOCK => 4,
            RafxFormat::ASTC_10X10_UNORM_BLOCK => 4,
            RafxFormat::ASTC_10X10_SRGB_BLOCK => 4,
            RafxFormat::ASTC_12X10_UNORM_BLOCK => 4,
            RafxFormat::ASTC_12X10_SRGB_BLOCK => 4,
            RafxFormat::ASTC_12X12_UNORM_BLOCK => 4,
            RafxFormat::ASTC_12X12_SRGB_BLOCK => 4,
        }
    }

    pub fn is_normalized(self) -> bool {
        match self {
            RafxFormat::UNDEFINED => unimplemented!(),

            // Pixel-based
            RafxFormat::R4G4_UNORM_PACK8 => true,
            RafxFormat::R4G4B4A4_UNORM_PACK16 => true,
            RafxFormat::B4G4R4A4_UNORM_PACK16 => true,
            RafxFormat::R5G6B5_UNORM_PACK16 => true,
            RafxFormat::B5G6R5_UNORM_PACK16 => true,
            RafxFormat::R5G5B5A1_UNORM_PACK16 => true,
            RafxFormat::B5G5R5A1_UNORM_PACK16 => true,
            RafxFormat::A1R5G5B5_UNORM_PACK16 => true,
            RafxFormat::R8_UNORM => true,
            RafxFormat::R8_SNORM => true,
            RafxFormat::R8_SRGB => true,
            RafxFormat::R8G8_UNORM => true,
            RafxFormat::R8G8_SNORM => true,
            RafxFormat::R8G8_SRGB => true,
            RafxFormat::R8G8B8_UNORM => true,
            RafxFormat::R8G8B8_SNORM => true,
            RafxFormat::R8G8B8_SRGB => true,
            RafxFormat::B8G8R8_UNORM => true,
            RafxFormat::B8G8R8_SNORM => true,
            RafxFormat::B8G8R8_SRGB => true,
            RafxFormat::R8G8B8A8_UNORM => true,
            RafxFormat::R8G8B8A8_SNORM => true,
            RafxFormat::R8G8B8A8_SRGB => true,
            RafxFormat::B8G8R8A8_UNORM => true,
            RafxFormat::B8G8R8A8_SNORM => true,
            RafxFormat::B8G8R8A8_SRGB => true,
            RafxFormat::A8B8G8R8_UNORM_PACK32 => true,
            RafxFormat::A8B8G8R8_SNORM_PACK32 => true,
            RafxFormat::A8B8G8R8_SRGB_PACK32 => true,
            RafxFormat::A2R10G10B10_UNORM_PACK32 => true,
            RafxFormat::A2R10G10B10_SNORM_PACK32 => true,
            RafxFormat::A2B10G10R10_UNORM_PACK32 => true,
            RafxFormat::A2B10G10R10_SNORM_PACK32 => true,
            RafxFormat::R16_UNORM => true,
            RafxFormat::R16_SNORM => true,
            RafxFormat::R16G16_UNORM => true,
            RafxFormat::R16G16_SNORM => true,
            RafxFormat::R16G16B16_UNORM => true,
            RafxFormat::R16G16B16_SNORM => true,
            RafxFormat::R16G16B16A16_UNORM => true,
            RafxFormat::R16G16B16A16_SNORM => true,
            RafxFormat::D16_UNORM => true,
            RafxFormat::X8_D24_UNORM_PACK32 => true,
            RafxFormat::D16_UNORM_S8_UINT => true,
            RafxFormat::D24_UNORM_S8_UINT => true,

            // Block-based
            RafxFormat::BC1_RGB_UNORM_BLOCK => true,
            RafxFormat::BC1_RGB_SRGB_BLOCK => true,
            RafxFormat::BC1_RGBA_UNORM_BLOCK => true,
            RafxFormat::BC1_RGBA_SRGB_BLOCK => true,
            RafxFormat::BC2_UNORM_BLOCK => true,
            RafxFormat::BC2_SRGB_BLOCK => true,
            RafxFormat::BC3_UNORM_BLOCK => true,
            RafxFormat::BC3_SRGB_BLOCK => true,
            RafxFormat::BC4_UNORM_BLOCK => true,
            RafxFormat::BC4_SNORM_BLOCK => true,
            RafxFormat::BC5_UNORM_BLOCK => true,
            RafxFormat::BC5_SNORM_BLOCK => true,
            RafxFormat::BC7_UNORM_BLOCK => true,
            RafxFormat::BC7_SRGB_BLOCK => true,
            RafxFormat::ETC2_R8G8B8_UNORM_BLOCK => true,
            RafxFormat::ETC2_R8G8B8_SRGB_BLOCK => true,
            RafxFormat::ETC2_R8G8B8A1_UNORM_BLOCK => true,
            RafxFormat::ETC2_R8G8B8A1_SRGB_BLOCK => true,
            RafxFormat::ETC2_R8G8B8A8_UNORM_BLOCK => true,
            RafxFormat::ETC2_R8G8B8A8_SRGB_BLOCK => true,
            RafxFormat::EAC_R11_UNORM_BLOCK => true,
            RafxFormat::EAC_R11_SNORM_BLOCK => true,
            RafxFormat::EAC_R11G11_UNORM_BLOCK => true,
            RafxFormat::EAC_R11G11_SNORM_BLOCK => true,
            RafxFormat::ASTC_4X4_UNORM_BLOCK => true,
            RafxFormat::ASTC_4X4_SRGB_BLOCK => true,
            RafxFormat::ASTC_5X4_UNORM_BLOCK => true,
            RafxFormat::ASTC_5X4_SRGB_BLOCK => true,
            RafxFormat::ASTC_5X5_UNORM_BLOCK => true,
            RafxFormat::ASTC_5X5_SRGB_BLOCK => true,
            RafxFormat::ASTC_6X5_UNORM_BLOCK => true,
            RafxFormat::ASTC_6X5_SRGB_BLOCK => true,
            RafxFormat::ASTC_6X6_UNORM_BLOCK => true,
            RafxFormat::ASTC_6X6_SRGB_BLOCK => true,
            RafxFormat::ASTC_8X5_UNORM_BLOCK => true,
            RafxFormat::ASTC_8X5_SRGB_BLOCK => true,
            RafxFormat::ASTC_8X6_UNORM_BLOCK => true,
            RafxFormat::ASTC_8X6_SRGB_BLOCK => true,
            RafxFormat::ASTC_8X8_UNORM_BLOCK => true,
            RafxFormat::ASTC_8X8_SRGB_BLOCK => true,
            RafxFormat::ASTC_10X5_UNORM_BLOCK => true,
            RafxFormat::ASTC_10X5_SRGB_BLOCK => true,
            RafxFormat::ASTC_10X6_UNORM_BLOCK => true,
            RafxFormat::ASTC_10X6_SRGB_BLOCK => true,
            RafxFormat::ASTC_10X8_UNORM_BLOCK => true,
            RafxFormat::ASTC_10X8_SRGB_BLOCK => true,
            RafxFormat::ASTC_10X10_UNORM_BLOCK => true,
            RafxFormat::ASTC_10X10_SRGB_BLOCK => true,
            RafxFormat::ASTC_12X10_UNORM_BLOCK => true,
            RafxFormat::ASTC_12X10_SRGB_BLOCK => true,
            RafxFormat::ASTC_12X12_UNORM_BLOCK => true,
            RafxFormat::ASTC_12X12_SRGB_BLOCK => true,

            _ => false,
        }
    }
}

//
// The following represent reasonable defaults with broad hardware support. These lists work well
// with RafxDeviceContext::find_supported_format()
//
pub mod recommended_formats {
    use super::RafxFormat;

    // If using an SDR format, consider using the swapchain surface format!
    pub const COLOR_FORMATS_SDR: [RafxFormat; 1] = [
        RafxFormat::R8G8B8A8_SNORM, // vulkan: 100% coverage with optimal
    ];

    pub const COLOR_FORMATS_HDR: [RafxFormat; 1] = [
        RafxFormat::R32G32B32A32_SFLOAT, // vulkan: 100% coverage with optimal
    ];

    pub const DEPTH_FORMATS: [RafxFormat; 4] = [
        RafxFormat::D32_SFLOAT,         // vulkan: 100% coverage with optimal
        RafxFormat::D32_SFLOAT_S8_UINT, // vulkan: 100% coverage with optimal
        RafxFormat::D24_UNORM_S8_UINT,
        RafxFormat::D16_UNORM, // Most likely to be used by GL ES 2.0
    ];
}
