// Code generated by machine generator; DO NOT EDIT.

//! Utility for rfc7155 packet.
//!
//! This module handles the packet according to the following definition:
//! ```text
//! //! # -*- text -*-
//! # Copyright (C) 2020 The FreeRADIUS Server project and contributors
//! # This work is licensed under CC-BY version 4.0 https://creativecommons.org/licenses/by/4.0
//! # Version $Id$
//! #
//! #        Attributes and values defined in RFC 7155
//! #        http://www.ietf.org/rfc/rfc7155.txt
//! #
//!
//! # The Value field contains two octets (00 - 99).  ANSI T1.113 and
//! # BELLCORE 394 can be used for additional information about these
//! # values and their use.
//! ATTRIBUTE    Originating-Line-Info            94    octets[2]
//! ```

use crate::core::avp::{AVPError, AVPType, AVP};
use crate::core::packet::Packet;

pub const ORIGINATING_LINE_INFO_TYPE: AVPType = 94;
/// Delete all of `originating_line_info` values from a packet.
pub fn delete_originating_line_info(packet: &mut Packet) {
    packet.delete(ORIGINATING_LINE_INFO_TYPE);
}
/// Add `originating_line_info` fixed-length octets value to a packet.
pub fn add_originating_line_info(packet: &mut Packet, value: &[u8]) -> Result<(), AVPError> {
    if value.len() != 2 {
        return Err(AVPError::InvalidAttributeLengthError(
            "2 bytes".to_owned(),
            value.len(),
        ));
    }
    packet.add(AVP::from_bytes(ORIGINATING_LINE_INFO_TYPE, value));
    Ok(())
}
/// Lookup a `originating_line_info` fixed-length octets value from a packet.
///
/// It returns the first looked up value. If there is no associated value with `originating_line_info`, it returns `None`.
pub fn lookup_originating_line_info(packet: &Packet) -> Option<Vec<u8>> {
    packet
        .lookup(ORIGINATING_LINE_INFO_TYPE)
        .map(|v| v.encode_bytes())
}
/// Lookup all of the `originating_line_info` fixed-length octets value from a packet.
pub fn lookup_all_originating_line_info(packet: &Packet) -> Vec<Vec<u8>> {
    let mut vec = Vec::new();
    for avp in packet.lookup_all(ORIGINATING_LINE_INFO_TYPE) {
        vec.push(avp.encode_bytes())
    }
    vec
}
