// Code generated by machine generator; DO NOT EDIT.

//! Utility for rfc7055 packet.
//!
//! This module handles the packet according to the following definition:
//! ```text
//! //! # -*- text -*-
//! # Copyright (C) 2020 The FreeRADIUS Server project and contributors
//! # This work is licensed under CC-BY version 4.0 https://creativecommons.org/licenses/by/4.0
//! # Version $Id$
//! #
//! #        Attributes and values defined in RFC 7055
//! #        http://www.ietf.org/rfc/rfc7055.txt
//! #
//!
//! ATTRIBUTE    GSS-Acceptor-Service-Name        164    string
//! ATTRIBUTE    GSS-Acceptor-Host-Name            165    string
//! ATTRIBUTE    GSS-Acceptor-Service-Specifics        166    string
//! ATTRIBUTE    GSS-Acceptor-Realm-Name            167    string
//! ```

use crate::core::avp::{AVPError, AVPType, AVP};
use crate::core::packet::Packet;

pub const GSS_ACCEPTOR_SERVICE_NAME_TYPE: AVPType = 164;
/// Delete all of `gss_acceptor_service_name` values from a packet.
pub fn delete_gss_acceptor_service_name(packet: &mut Packet) {
    packet.delete(GSS_ACCEPTOR_SERVICE_NAME_TYPE);
}
/// Add `gss_acceptor_service_name` string value to a packet.
pub fn add_gss_acceptor_service_name(packet: &mut Packet, value: &str) {
    packet.add(AVP::from_string(GSS_ACCEPTOR_SERVICE_NAME_TYPE, value));
}
/// Lookup a `gss_acceptor_service_name` string value from a packet.
///
/// It returns the first looked up value. If there is no associated value with `gss_acceptor_service_name`, it returns `None`.
pub fn lookup_gss_acceptor_service_name(packet: &Packet) -> Option<Result<String, AVPError>> {
    packet
        .lookup(GSS_ACCEPTOR_SERVICE_NAME_TYPE)
        .map(|v| v.encode_string())
}
/// Lookup all of the `gss_acceptor_service_name` string value from a packet.
pub fn lookup_all_gss_acceptor_service_name(packet: &Packet) -> Result<Vec<String>, AVPError> {
    let mut vec = Vec::new();
    for avp in packet.lookup_all(GSS_ACCEPTOR_SERVICE_NAME_TYPE) {
        vec.push(avp.encode_string()?)
    }
    Ok(vec)
}

pub const GSS_ACCEPTOR_HOST_NAME_TYPE: AVPType = 165;
/// Delete all of `gss_acceptor_host_name` values from a packet.
pub fn delete_gss_acceptor_host_name(packet: &mut Packet) {
    packet.delete(GSS_ACCEPTOR_HOST_NAME_TYPE);
}
/// Add `gss_acceptor_host_name` string value to a packet.
pub fn add_gss_acceptor_host_name(packet: &mut Packet, value: &str) {
    packet.add(AVP::from_string(GSS_ACCEPTOR_HOST_NAME_TYPE, value));
}
/// Lookup a `gss_acceptor_host_name` string value from a packet.
///
/// It returns the first looked up value. If there is no associated value with `gss_acceptor_host_name`, it returns `None`.
pub fn lookup_gss_acceptor_host_name(packet: &Packet) -> Option<Result<String, AVPError>> {
    packet
        .lookup(GSS_ACCEPTOR_HOST_NAME_TYPE)
        .map(|v| v.encode_string())
}
/// Lookup all of the `gss_acceptor_host_name` string value from a packet.
pub fn lookup_all_gss_acceptor_host_name(packet: &Packet) -> Result<Vec<String>, AVPError> {
    let mut vec = Vec::new();
    for avp in packet.lookup_all(GSS_ACCEPTOR_HOST_NAME_TYPE) {
        vec.push(avp.encode_string()?)
    }
    Ok(vec)
}

pub const GSS_ACCEPTOR_SERVICE_SPECIFICS_TYPE: AVPType = 166;
/// Delete all of `gss_acceptor_service_specifics` values from a packet.
pub fn delete_gss_acceptor_service_specifics(packet: &mut Packet) {
    packet.delete(GSS_ACCEPTOR_SERVICE_SPECIFICS_TYPE);
}
/// Add `gss_acceptor_service_specifics` string value to a packet.
pub fn add_gss_acceptor_service_specifics(packet: &mut Packet, value: &str) {
    packet.add(AVP::from_string(GSS_ACCEPTOR_SERVICE_SPECIFICS_TYPE, value));
}
/// Lookup a `gss_acceptor_service_specifics` string value from a packet.
///
/// It returns the first looked up value. If there is no associated value with `gss_acceptor_service_specifics`, it returns `None`.
pub fn lookup_gss_acceptor_service_specifics(packet: &Packet) -> Option<Result<String, AVPError>> {
    packet
        .lookup(GSS_ACCEPTOR_SERVICE_SPECIFICS_TYPE)
        .map(|v| v.encode_string())
}
/// Lookup all of the `gss_acceptor_service_specifics` string value from a packet.
pub fn lookup_all_gss_acceptor_service_specifics(packet: &Packet) -> Result<Vec<String>, AVPError> {
    let mut vec = Vec::new();
    for avp in packet.lookup_all(GSS_ACCEPTOR_SERVICE_SPECIFICS_TYPE) {
        vec.push(avp.encode_string()?)
    }
    Ok(vec)
}

pub const GSS_ACCEPTOR_REALM_NAME_TYPE: AVPType = 167;
/// Delete all of `gss_acceptor_realm_name` values from a packet.
pub fn delete_gss_acceptor_realm_name(packet: &mut Packet) {
    packet.delete(GSS_ACCEPTOR_REALM_NAME_TYPE);
}
/// Add `gss_acceptor_realm_name` string value to a packet.
pub fn add_gss_acceptor_realm_name(packet: &mut Packet, value: &str) {
    packet.add(AVP::from_string(GSS_ACCEPTOR_REALM_NAME_TYPE, value));
}
/// Lookup a `gss_acceptor_realm_name` string value from a packet.
///
/// It returns the first looked up value. If there is no associated value with `gss_acceptor_realm_name`, it returns `None`.
pub fn lookup_gss_acceptor_realm_name(packet: &Packet) -> Option<Result<String, AVPError>> {
    packet
        .lookup(GSS_ACCEPTOR_REALM_NAME_TYPE)
        .map(|v| v.encode_string())
}
/// Lookup all of the `gss_acceptor_realm_name` string value from a packet.
pub fn lookup_all_gss_acceptor_realm_name(packet: &Packet) -> Result<Vec<String>, AVPError> {
    let mut vec = Vec::new();
    for avp in packet.lookup_all(GSS_ACCEPTOR_REALM_NAME_TYPE) {
        vec.push(avp.encode_string()?)
    }
    Ok(vec)
}
