// Code generated by machine generator; DO NOT EDIT.

//! Utility for rfc6677 packet.
//!
//! This module handles the packet according to the following definition:
//! ```text
//! //! # -*- text -*-
//! # Copyright (C) 2020 The FreeRADIUS Server project and contributors
//! # This work is licensed under CC-BY version 4.0 https://creativecommons.org/licenses/by/4.0
//! # Version $Id$
//! #
//! #    Attributes and values defined in RFC 6677
//! #    http://www.ietf.org/rfc/rfc6677.txt
//! #
//!
//! ATTRIBUTE    EAP-Lower-Layer                163    integer
//!
//! VALUE    EAP-Lower-Layer            Wired-IEEE-802.1X    1
//! VALUE    EAP-Lower-Layer            IEEE-802.1X-No-Preauth    2
//! VALUE    EAP-Lower-Layer            IEEE-802.1X-Preauth    3
//! VALUE    EAP-Lower-Layer            IEEE-802.16e        4
//! VALUE    EAP-Lower-Layer            IKEv2            5
//! VALUE    EAP-Lower-Layer            PPP            6
//! VALUE    EAP-Lower-Layer            PANA-No-Preauth        7
//! VALUE    EAP-Lower-Layer            GSS-API            8
//! VALUE    EAP-Lower-Layer            PANA-Preauth        9
//! ```

use crate::core::avp::{AVPError, AVPType, AVP};
use crate::core::packet::Packet;

pub const EAP_LOWER_LAYER_TYPE: AVPType = 163;
/// Delete all of `eap_lower_layer` values from a packet.
pub fn delete_eap_lower_layer(packet: &mut Packet) {
    packet.delete(EAP_LOWER_LAYER_TYPE);
}
/// Add `eap_lower_layer` value-defined integer value to a packet.
pub fn add_eap_lower_layer(packet: &mut Packet, value: EapLowerLayer) {
    packet.add(AVP::from_u32(EAP_LOWER_LAYER_TYPE, value as u32));
}
/// Lookup a `eap_lower_layer` value-defined integer value from a packet.
///
/// It returns the first looked up value. If there is no associated value with `eap_lower_layer`, it returns `None`.
pub fn lookup_eap_lower_layer(packet: &Packet) -> Option<Result<EapLowerLayer, AVPError>> {
    packet
        .lookup(EAP_LOWER_LAYER_TYPE)
        .map(|v| Ok(v.encode_u32()? as EapLowerLayer))
}
/// Lookup all of the `eap_lower_layer` value-defined integer value from a packet.
pub fn lookup_all_eap_lower_layer(packet: &Packet) -> Result<Vec<EapLowerLayer>, AVPError> {
    let mut vec = Vec::new();
    for avp in packet.lookup_all(EAP_LOWER_LAYER_TYPE) {
        vec.push(avp.encode_u32()? as EapLowerLayer)
    }
    Ok(vec)
}

pub type EapLowerLayer = u32;
pub const EAP_LOWER_LAYER_WIRED_IEEE_802_1X: EapLowerLayer = 1;
pub const EAP_LOWER_LAYER_IEEE_802_1X_NO_PREAUTH: EapLowerLayer = 2;
pub const EAP_LOWER_LAYER_IEEE_802_1X_PREAUTH: EapLowerLayer = 3;
pub const EAP_LOWER_LAYER_IEEE_802_1_6E: EapLowerLayer = 4;
pub const EAP_LOWER_LAYER_IK_EV_2: EapLowerLayer = 5;
pub const EAP_LOWER_LAYER_PPP: EapLowerLayer = 6;
pub const EAP_LOWER_LAYER_PANA_NO_PREAUTH: EapLowerLayer = 7;
pub const EAP_LOWER_LAYER_GSS_API: EapLowerLayer = 8;
pub const EAP_LOWER_LAYER_PANA_PREAUTH: EapLowerLayer = 9;
