// Code generated by machine generator; DO NOT EDIT.

//! Utility for rfc6572 packet.
//!
//! This module handles the packet according to the following definition:
//! ```text
//! //! # -*- text -*-
//! # Copyright (C) 2020 The FreeRADIUS Server project and contributors
//! # This work is licensed under CC-BY version 4.0 https://creativecommons.org/licenses/by/4.0
//! # Version $Id$
//! #
//! #    Attributes and values defined in RFC 6572.
//! #    http://www.ietf.org/rfc/rfc6572.txt
//! #
//! #    $Id$
//! #
//!
//! ATTRIBUTE    Mobile-Node-Identifier            145    octets
//! ATTRIBUTE    Service-Selection            146    string
//! ATTRIBUTE    PMIP6-Home-LMA-IPV6-Address        147    ipv6addr
//! ATTRIBUTE    PMIP6-Visited-LMA-IPV6-Address        148    ipv6addr
//! ATTRIBUTE    PMIP6-Home-LMA-IPV4-Address        149    ipaddr
//! ATTRIBUTE    PMIP6-Visited-LMA-IPV4-Address        150    ipaddr
//! ATTRIBUTE    PMIP6-Home-HN-Prefix            151    ipv6prefix
//! ATTRIBUTE    PMIP6-Visited-HN-Prefix            152    ipv6prefix
//! ATTRIBUTE    PMIP6-Home-Interface-ID            153    ifid
//! ATTRIBUTE    PMIP6-Visited-Interface-ID        154    ifid
//! ATTRIBUTE    PMIP6-Home-IPV4-HoA            155    ipv4prefix
//! ATTRIBUTE    PMIP6-Visited-IPV4-HoA            156    ipv4prefix
//! ATTRIBUTE    PMIP6-Home-DHCP4-Server-Address        157    ipaddr
//! ATTRIBUTE    PMIP6-Visited-DHCP4-Server-Address    158    ipaddr
//! ATTRIBUTE    PMIP6-Home-DHCP6-Server-Address        159    ipv6addr
//! ATTRIBUTE    PMIP6-Visited-DHCP6-Server-Address    160    ipv6addr
//! ATTRIBUTE    PMIP6-Home-IPV4-Gateway            161    ipaddr
//! ATTRIBUTE    PMIP6-Visited-IPV4-Gateway        162    ipaddr
//! ```

use std::net::{Ipv4Addr, Ipv6Addr};

use crate::core::avp::{AVPError, AVPType, AVP};
use crate::core::packet::Packet;

pub const MOBILE_NODE_IDENTIFIER_TYPE: AVPType = 145;
/// Delete all of `mobile_node_identifier` values from a packet.
pub fn delete_mobile_node_identifier(packet: &mut Packet) {
    packet.delete(MOBILE_NODE_IDENTIFIER_TYPE);
}
/// Add `mobile_node_identifier` octets value to a packet.
pub fn add_mobile_node_identifier(packet: &mut Packet, value: &[u8]) {
    packet.add(AVP::from_bytes(MOBILE_NODE_IDENTIFIER_TYPE, value));
}
/// Lookup a `mobile_node_identifier` octets value from a packet.
///
/// It returns the first looked up value. If there is no associated value with `mobile_node_identifier`, it returns `None`.
pub fn lookup_mobile_node_identifier(packet: &Packet) -> Option<Vec<u8>> {
    packet
        .lookup(MOBILE_NODE_IDENTIFIER_TYPE)
        .map(|v| v.encode_bytes())
}
/// Lookup all of the `mobile_node_identifier` octets value from a packet.
pub fn lookup_all_mobile_node_identifier(packet: &Packet) -> Vec<Vec<u8>> {
    let mut vec = Vec::new();
    for avp in packet.lookup_all(MOBILE_NODE_IDENTIFIER_TYPE) {
        vec.push(avp.encode_bytes())
    }
    vec
}

pub const SERVICE_SELECTION_TYPE: AVPType = 146;
/// Delete all of `service_selection` values from a packet.
pub fn delete_service_selection(packet: &mut Packet) {
    packet.delete(SERVICE_SELECTION_TYPE);
}
/// Add `service_selection` string value to a packet.
pub fn add_service_selection(packet: &mut Packet, value: &str) {
    packet.add(AVP::from_string(SERVICE_SELECTION_TYPE, value));
}
/// Lookup a `service_selection` string value from a packet.
///
/// It returns the first looked up value. If there is no associated value with `service_selection`, it returns `None`.
pub fn lookup_service_selection(packet: &Packet) -> Option<Result<String, AVPError>> {
    packet
        .lookup(SERVICE_SELECTION_TYPE)
        .map(|v| v.encode_string())
}
/// Lookup all of the `service_selection` string value from a packet.
pub fn lookup_all_service_selection(packet: &Packet) -> Result<Vec<String>, AVPError> {
    let mut vec = Vec::new();
    for avp in packet.lookup_all(SERVICE_SELECTION_TYPE) {
        vec.push(avp.encode_string()?)
    }
    Ok(vec)
}

pub const PMIP6_HOME_LMA_IPV6_ADDRESS_TYPE: AVPType = 147;
/// Delete all of `pmip6_home_lma_ipv6_address` values from a packet.
pub fn delete_pmip6_home_lma_ipv6_address(packet: &mut Packet) {
    packet.delete(PMIP6_HOME_LMA_IPV6_ADDRESS_TYPE);
}
/// Add `pmip6_home_lma_ipv6_address` ipv6addr value to a packet.
pub fn add_pmip6_home_lma_ipv6_address(packet: &mut Packet, value: &Ipv6Addr) {
    packet.add(AVP::from_ipv6(PMIP6_HOME_LMA_IPV6_ADDRESS_TYPE, value));
}
/// Lookup a `pmip6_home_lma_ipv6_address` ipv6addr value from a packet.
///
/// It returns the first looked up value. If there is no associated value with `pmip6_home_lma_ipv6_address`, it returns `None`.
pub fn lookup_pmip6_home_lma_ipv6_address(packet: &Packet) -> Option<Result<Ipv6Addr, AVPError>> {
    packet
        .lookup(PMIP6_HOME_LMA_IPV6_ADDRESS_TYPE)
        .map(|v| v.encode_ipv6())
}
/// Lookup all of the `pmip6_home_lma_ipv6_address` ipv6addr value from a packet.
pub fn lookup_all_pmip6_home_lma_ipv6_address(packet: &Packet) -> Result<Vec<Ipv6Addr>, AVPError> {
    let mut vec = Vec::new();
    for avp in packet.lookup_all(PMIP6_HOME_LMA_IPV6_ADDRESS_TYPE) {
        vec.push(avp.encode_ipv6()?)
    }
    Ok(vec)
}

pub const PMIP6_VISITED_LMA_IPV6_ADDRESS_TYPE: AVPType = 148;
/// Delete all of `pmip6_visited_lma_ipv6_address` values from a packet.
pub fn delete_pmip6_visited_lma_ipv6_address(packet: &mut Packet) {
    packet.delete(PMIP6_VISITED_LMA_IPV6_ADDRESS_TYPE);
}
/// Add `pmip6_visited_lma_ipv6_address` ipv6addr value to a packet.
pub fn add_pmip6_visited_lma_ipv6_address(packet: &mut Packet, value: &Ipv6Addr) {
    packet.add(AVP::from_ipv6(PMIP6_VISITED_LMA_IPV6_ADDRESS_TYPE, value));
}
/// Lookup a `pmip6_visited_lma_ipv6_address` ipv6addr value from a packet.
///
/// It returns the first looked up value. If there is no associated value with `pmip6_visited_lma_ipv6_address`, it returns `None`.
pub fn lookup_pmip6_visited_lma_ipv6_address(
    packet: &Packet,
) -> Option<Result<Ipv6Addr, AVPError>> {
    packet
        .lookup(PMIP6_VISITED_LMA_IPV6_ADDRESS_TYPE)
        .map(|v| v.encode_ipv6())
}
/// Lookup all of the `pmip6_visited_lma_ipv6_address` ipv6addr value from a packet.
pub fn lookup_all_pmip6_visited_lma_ipv6_address(
    packet: &Packet,
) -> Result<Vec<Ipv6Addr>, AVPError> {
    let mut vec = Vec::new();
    for avp in packet.lookup_all(PMIP6_VISITED_LMA_IPV6_ADDRESS_TYPE) {
        vec.push(avp.encode_ipv6()?)
    }
    Ok(vec)
}

pub const PMIP6_HOME_LMA_IPV4_ADDRESS_TYPE: AVPType = 149;
/// Delete all of `pmip6_home_lma_ipv4_address` values from a packet.
pub fn delete_pmip6_home_lma_ipv4_address(packet: &mut Packet) {
    packet.delete(PMIP6_HOME_LMA_IPV4_ADDRESS_TYPE);
}
/// Add `pmip6_home_lma_ipv4_address` ipaddr value to a packet.
pub fn add_pmip6_home_lma_ipv4_address(packet: &mut Packet, value: &Ipv4Addr) {
    packet.add(AVP::from_ipv4(PMIP6_HOME_LMA_IPV4_ADDRESS_TYPE, value));
}
/// Lookup a `pmip6_home_lma_ipv4_address` ipaddr value from a packet.
///
/// It returns the first looked up value. If there is no associated value with `pmip6_home_lma_ipv4_address`, it returns `None`.
pub fn lookup_pmip6_home_lma_ipv4_address(packet: &Packet) -> Option<Result<Ipv4Addr, AVPError>> {
    packet
        .lookup(PMIP6_HOME_LMA_IPV4_ADDRESS_TYPE)
        .map(|v| v.encode_ipv4())
}
/// Lookup all of the `pmip6_home_lma_ipv4_address` ipaddr value from a packet.
pub fn lookup_all_pmip6_home_lma_ipv4_address(packet: &Packet) -> Result<Vec<Ipv4Addr>, AVPError> {
    let mut vec = Vec::new();
    for avp in packet.lookup_all(PMIP6_HOME_LMA_IPV4_ADDRESS_TYPE) {
        vec.push(avp.encode_ipv4()?)
    }
    Ok(vec)
}

pub const PMIP6_VISITED_LMA_IPV4_ADDRESS_TYPE: AVPType = 150;
/// Delete all of `pmip6_visited_lma_ipv4_address` values from a packet.
pub fn delete_pmip6_visited_lma_ipv4_address(packet: &mut Packet) {
    packet.delete(PMIP6_VISITED_LMA_IPV4_ADDRESS_TYPE);
}
/// Add `pmip6_visited_lma_ipv4_address` ipaddr value to a packet.
pub fn add_pmip6_visited_lma_ipv4_address(packet: &mut Packet, value: &Ipv4Addr) {
    packet.add(AVP::from_ipv4(PMIP6_VISITED_LMA_IPV4_ADDRESS_TYPE, value));
}
/// Lookup a `pmip6_visited_lma_ipv4_address` ipaddr value from a packet.
///
/// It returns the first looked up value. If there is no associated value with `pmip6_visited_lma_ipv4_address`, it returns `None`.
pub fn lookup_pmip6_visited_lma_ipv4_address(
    packet: &Packet,
) -> Option<Result<Ipv4Addr, AVPError>> {
    packet
        .lookup(PMIP6_VISITED_LMA_IPV4_ADDRESS_TYPE)
        .map(|v| v.encode_ipv4())
}
/// Lookup all of the `pmip6_visited_lma_ipv4_address` ipaddr value from a packet.
pub fn lookup_all_pmip6_visited_lma_ipv4_address(
    packet: &Packet,
) -> Result<Vec<Ipv4Addr>, AVPError> {
    let mut vec = Vec::new();
    for avp in packet.lookup_all(PMIP6_VISITED_LMA_IPV4_ADDRESS_TYPE) {
        vec.push(avp.encode_ipv4()?)
    }
    Ok(vec)
}

pub const PMIP6_HOME_HN_PREFIX_TYPE: AVPType = 151;
/// Delete all of `pmip6_home_hn_prefix` values from a packet.
pub fn delete_pmip6_home_hn_prefix(packet: &mut Packet) {
    packet.delete(PMIP6_HOME_HN_PREFIX_TYPE);
}
/// Add `pmip6_home_hn_prefix` ipv6 prefix value to a packet.
pub fn add_pmip6_home_hn_prefix(packet: &mut Packet, value: &[u8]) -> Result<(), AVPError> {
    packet.add(AVP::from_ipv6_prefix(PMIP6_HOME_HN_PREFIX_TYPE, value)?);
    Ok(())
}
/// Lookup a `pmip6_home_hn_prefix` ipv6 prefix value from a packet.
///
/// It returns the first looked up value. If there is no associated value with `pmip6_home_hn_prefix`, it returns `None`.
pub fn lookup_pmip6_home_hn_prefix(packet: &Packet) -> Option<Result<Vec<u8>, AVPError>> {
    packet
        .lookup(PMIP6_HOME_HN_PREFIX_TYPE)
        .map(|v| v.encode_ipv6_prefix())
}
/// Lookup all of the `pmip6_home_hn_prefix` ipv6 prefix value from a packet.
pub fn lookup_all_pmip6_home_hn_prefix(packet: &Packet) -> Result<Vec<Vec<u8>>, AVPError> {
    let mut vec = Vec::new();
    for avp in packet.lookup_all(PMIP6_HOME_HN_PREFIX_TYPE) {
        vec.push(avp.encode_ipv6_prefix()?)
    }
    Ok(vec)
}

pub const PMIP6_VISITED_HN_PREFIX_TYPE: AVPType = 152;
/// Delete all of `pmip6_visited_hn_prefix` values from a packet.
pub fn delete_pmip6_visited_hn_prefix(packet: &mut Packet) {
    packet.delete(PMIP6_VISITED_HN_PREFIX_TYPE);
}
/// Add `pmip6_visited_hn_prefix` ipv6 prefix value to a packet.
pub fn add_pmip6_visited_hn_prefix(packet: &mut Packet, value: &[u8]) -> Result<(), AVPError> {
    packet.add(AVP::from_ipv6_prefix(PMIP6_VISITED_HN_PREFIX_TYPE, value)?);
    Ok(())
}
/// Lookup a `pmip6_visited_hn_prefix` ipv6 prefix value from a packet.
///
/// It returns the first looked up value. If there is no associated value with `pmip6_visited_hn_prefix`, it returns `None`.
pub fn lookup_pmip6_visited_hn_prefix(packet: &Packet) -> Option<Result<Vec<u8>, AVPError>> {
    packet
        .lookup(PMIP6_VISITED_HN_PREFIX_TYPE)
        .map(|v| v.encode_ipv6_prefix())
}
/// Lookup all of the `pmip6_visited_hn_prefix` ipv6 prefix value from a packet.
pub fn lookup_all_pmip6_visited_hn_prefix(packet: &Packet) -> Result<Vec<Vec<u8>>, AVPError> {
    let mut vec = Vec::new();
    for avp in packet.lookup_all(PMIP6_VISITED_HN_PREFIX_TYPE) {
        vec.push(avp.encode_ipv6_prefix()?)
    }
    Ok(vec)
}

pub const PMIP6_HOME_INTERFACE_ID_TYPE: AVPType = 153;
/// Delete all of `pmip6_home_interface_id` values from a packet.
pub fn delete_pmip6_home_interface_id(packet: &mut Packet) {
    packet.delete(PMIP6_HOME_INTERFACE_ID_TYPE);
}
/// Add `pmip6_home_interface_id` fixed-length octets value to a packet.
pub fn add_pmip6_home_interface_id(packet: &mut Packet, value: &[u8]) -> Result<(), AVPError> {
    if value.len() != 8 {
        return Err(AVPError::InvalidAttributeLengthError(
            "8 bytes".to_owned(),
            value.len(),
        ));
    }
    packet.add(AVP::from_bytes(PMIP6_HOME_INTERFACE_ID_TYPE, value));
    Ok(())
}
/// Lookup a `pmip6_home_interface_id` fixed-length octets value from a packet.
///
/// It returns the first looked up value. If there is no associated value with `pmip6_home_interface_id`, it returns `None`.
pub fn lookup_pmip6_home_interface_id(packet: &Packet) -> Option<Vec<u8>> {
    packet
        .lookup(PMIP6_HOME_INTERFACE_ID_TYPE)
        .map(|v| v.encode_bytes())
}
/// Lookup all of the `pmip6_home_interface_id` fixed-length octets value from a packet.
pub fn lookup_all_pmip6_home_interface_id(packet: &Packet) -> Vec<Vec<u8>> {
    let mut vec = Vec::new();
    for avp in packet.lookup_all(PMIP6_HOME_INTERFACE_ID_TYPE) {
        vec.push(avp.encode_bytes())
    }
    vec
}

pub const PMIP6_VISITED_INTERFACE_ID_TYPE: AVPType = 154;
/// Delete all of `pmip6_visited_interface_id` values from a packet.
pub fn delete_pmip6_visited_interface_id(packet: &mut Packet) {
    packet.delete(PMIP6_VISITED_INTERFACE_ID_TYPE);
}
/// Add `pmip6_visited_interface_id` fixed-length octets value to a packet.
pub fn add_pmip6_visited_interface_id(packet: &mut Packet, value: &[u8]) -> Result<(), AVPError> {
    if value.len() != 8 {
        return Err(AVPError::InvalidAttributeLengthError(
            "8 bytes".to_owned(),
            value.len(),
        ));
    }
    packet.add(AVP::from_bytes(PMIP6_VISITED_INTERFACE_ID_TYPE, value));
    Ok(())
}
/// Lookup a `pmip6_visited_interface_id` fixed-length octets value from a packet.
///
/// It returns the first looked up value. If there is no associated value with `pmip6_visited_interface_id`, it returns `None`.
pub fn lookup_pmip6_visited_interface_id(packet: &Packet) -> Option<Vec<u8>> {
    packet
        .lookup(PMIP6_VISITED_INTERFACE_ID_TYPE)
        .map(|v| v.encode_bytes())
}
/// Lookup all of the `pmip6_visited_interface_id` fixed-length octets value from a packet.
pub fn lookup_all_pmip6_visited_interface_id(packet: &Packet) -> Vec<Vec<u8>> {
    let mut vec = Vec::new();
    for avp in packet.lookup_all(PMIP6_VISITED_INTERFACE_ID_TYPE) {
        vec.push(avp.encode_bytes())
    }
    vec
}

pub const PMIP6_HOME_IPV4_HO_A_TYPE: AVPType = 155;
/// Delete all of `pmip6_home_ipv4_ho_a` values from a packet.
pub fn delete_pmip6_home_ipv4_ho_a(packet: &mut Packet) {
    packet.delete(PMIP6_HOME_IPV4_HO_A_TYPE);
}
/// Add `pmip6_home_ipv4_ho_a` ipv4 prefix value to a packet.
pub fn add_pmip6_home_ipv4_ho_a(packet: &mut Packet, value: &[u8]) -> Result<(), AVPError> {
    packet.add(AVP::from_ipv4_prefix(PMIP6_HOME_IPV4_HO_A_TYPE, value)?);
    Ok(())
}
/// Lookup a `pmip6_home_ipv4_ho_a` ipv4 prefix value from a packet.
///
/// It returns the first looked up value. If there is no associated value with `pmip6_home_ipv4_ho_a`, it returns `None`.
pub fn lookup_pmip6_home_ipv4_ho_a(packet: &Packet) -> Option<Result<Vec<u8>, AVPError>> {
    packet
        .lookup(PMIP6_HOME_IPV4_HO_A_TYPE)
        .map(|v| v.encode_ipv4_prefix())
}
/// Lookup all of the `pmip6_home_ipv4_ho_a` ipv4 prefix value from a packet.
pub fn lookup_all_pmip6_home_ipv4_ho_a(packet: &Packet) -> Result<Vec<Vec<u8>>, AVPError> {
    let mut vec = Vec::new();
    for avp in packet.lookup_all(PMIP6_HOME_IPV4_HO_A_TYPE) {
        vec.push(avp.encode_ipv4_prefix()?)
    }
    Ok(vec)
}

pub const PMIP6_VISITED_IPV4_HO_A_TYPE: AVPType = 156;
/// Delete all of `pmip6_visited_ipv4_ho_a` values from a packet.
pub fn delete_pmip6_visited_ipv4_ho_a(packet: &mut Packet) {
    packet.delete(PMIP6_VISITED_IPV4_HO_A_TYPE);
}
/// Add `pmip6_visited_ipv4_ho_a` ipv4 prefix value to a packet.
pub fn add_pmip6_visited_ipv4_ho_a(packet: &mut Packet, value: &[u8]) -> Result<(), AVPError> {
    packet.add(AVP::from_ipv4_prefix(PMIP6_VISITED_IPV4_HO_A_TYPE, value)?);
    Ok(())
}
/// Lookup a `pmip6_visited_ipv4_ho_a` ipv4 prefix value from a packet.
///
/// It returns the first looked up value. If there is no associated value with `pmip6_visited_ipv4_ho_a`, it returns `None`.
pub fn lookup_pmip6_visited_ipv4_ho_a(packet: &Packet) -> Option<Result<Vec<u8>, AVPError>> {
    packet
        .lookup(PMIP6_VISITED_IPV4_HO_A_TYPE)
        .map(|v| v.encode_ipv4_prefix())
}
/// Lookup all of the `pmip6_visited_ipv4_ho_a` ipv4 prefix value from a packet.
pub fn lookup_all_pmip6_visited_ipv4_ho_a(packet: &Packet) -> Result<Vec<Vec<u8>>, AVPError> {
    let mut vec = Vec::new();
    for avp in packet.lookup_all(PMIP6_VISITED_IPV4_HO_A_TYPE) {
        vec.push(avp.encode_ipv4_prefix()?)
    }
    Ok(vec)
}

pub const PMIP6_HOME_DHCP4_SERVER_ADDRESS_TYPE: AVPType = 157;
/// Delete all of `pmip6_home_dhcp4_server_address` values from a packet.
pub fn delete_pmip6_home_dhcp4_server_address(packet: &mut Packet) {
    packet.delete(PMIP6_HOME_DHCP4_SERVER_ADDRESS_TYPE);
}
/// Add `pmip6_home_dhcp4_server_address` ipaddr value to a packet.
pub fn add_pmip6_home_dhcp4_server_address(packet: &mut Packet, value: &Ipv4Addr) {
    packet.add(AVP::from_ipv4(PMIP6_HOME_DHCP4_SERVER_ADDRESS_TYPE, value));
}
/// Lookup a `pmip6_home_dhcp4_server_address` ipaddr value from a packet.
///
/// It returns the first looked up value. If there is no associated value with `pmip6_home_dhcp4_server_address`, it returns `None`.
pub fn lookup_pmip6_home_dhcp4_server_address(
    packet: &Packet,
) -> Option<Result<Ipv4Addr, AVPError>> {
    packet
        .lookup(PMIP6_HOME_DHCP4_SERVER_ADDRESS_TYPE)
        .map(|v| v.encode_ipv4())
}
/// Lookup all of the `pmip6_home_dhcp4_server_address` ipaddr value from a packet.
pub fn lookup_all_pmip6_home_dhcp4_server_address(
    packet: &Packet,
) -> Result<Vec<Ipv4Addr>, AVPError> {
    let mut vec = Vec::new();
    for avp in packet.lookup_all(PMIP6_HOME_DHCP4_SERVER_ADDRESS_TYPE) {
        vec.push(avp.encode_ipv4()?)
    }
    Ok(vec)
}

pub const PMIP6_VISITED_DHCP4_SERVER_ADDRESS_TYPE: AVPType = 158;
/// Delete all of `pmip6_visited_dhcp4_server_address` values from a packet.
pub fn delete_pmip6_visited_dhcp4_server_address(packet: &mut Packet) {
    packet.delete(PMIP6_VISITED_DHCP4_SERVER_ADDRESS_TYPE);
}
/// Add `pmip6_visited_dhcp4_server_address` ipaddr value to a packet.
pub fn add_pmip6_visited_dhcp4_server_address(packet: &mut Packet, value: &Ipv4Addr) {
    packet.add(AVP::from_ipv4(
        PMIP6_VISITED_DHCP4_SERVER_ADDRESS_TYPE,
        value,
    ));
}
/// Lookup a `pmip6_visited_dhcp4_server_address` ipaddr value from a packet.
///
/// It returns the first looked up value. If there is no associated value with `pmip6_visited_dhcp4_server_address`, it returns `None`.
pub fn lookup_pmip6_visited_dhcp4_server_address(
    packet: &Packet,
) -> Option<Result<Ipv4Addr, AVPError>> {
    packet
        .lookup(PMIP6_VISITED_DHCP4_SERVER_ADDRESS_TYPE)
        .map(|v| v.encode_ipv4())
}
/// Lookup all of the `pmip6_visited_dhcp4_server_address` ipaddr value from a packet.
pub fn lookup_all_pmip6_visited_dhcp4_server_address(
    packet: &Packet,
) -> Result<Vec<Ipv4Addr>, AVPError> {
    let mut vec = Vec::new();
    for avp in packet.lookup_all(PMIP6_VISITED_DHCP4_SERVER_ADDRESS_TYPE) {
        vec.push(avp.encode_ipv4()?)
    }
    Ok(vec)
}

pub const PMIP6_HOME_DHCP6_SERVER_ADDRESS_TYPE: AVPType = 159;
/// Delete all of `pmip6_home_dhcp6_server_address` values from a packet.
pub fn delete_pmip6_home_dhcp6_server_address(packet: &mut Packet) {
    packet.delete(PMIP6_HOME_DHCP6_SERVER_ADDRESS_TYPE);
}
/// Add `pmip6_home_dhcp6_server_address` ipv6addr value to a packet.
pub fn add_pmip6_home_dhcp6_server_address(packet: &mut Packet, value: &Ipv6Addr) {
    packet.add(AVP::from_ipv6(PMIP6_HOME_DHCP6_SERVER_ADDRESS_TYPE, value));
}
/// Lookup a `pmip6_home_dhcp6_server_address` ipv6addr value from a packet.
///
/// It returns the first looked up value. If there is no associated value with `pmip6_home_dhcp6_server_address`, it returns `None`.
pub fn lookup_pmip6_home_dhcp6_server_address(
    packet: &Packet,
) -> Option<Result<Ipv6Addr, AVPError>> {
    packet
        .lookup(PMIP6_HOME_DHCP6_SERVER_ADDRESS_TYPE)
        .map(|v| v.encode_ipv6())
}
/// Lookup all of the `pmip6_home_dhcp6_server_address` ipv6addr value from a packet.
pub fn lookup_all_pmip6_home_dhcp6_server_address(
    packet: &Packet,
) -> Result<Vec<Ipv6Addr>, AVPError> {
    let mut vec = Vec::new();
    for avp in packet.lookup_all(PMIP6_HOME_DHCP6_SERVER_ADDRESS_TYPE) {
        vec.push(avp.encode_ipv6()?)
    }
    Ok(vec)
}

pub const PMIP6_VISITED_DHCP6_SERVER_ADDRESS_TYPE: AVPType = 160;
/// Delete all of `pmip6_visited_dhcp6_server_address` values from a packet.
pub fn delete_pmip6_visited_dhcp6_server_address(packet: &mut Packet) {
    packet.delete(PMIP6_VISITED_DHCP6_SERVER_ADDRESS_TYPE);
}
/// Add `pmip6_visited_dhcp6_server_address` ipv6addr value to a packet.
pub fn add_pmip6_visited_dhcp6_server_address(packet: &mut Packet, value: &Ipv6Addr) {
    packet.add(AVP::from_ipv6(
        PMIP6_VISITED_DHCP6_SERVER_ADDRESS_TYPE,
        value,
    ));
}
/// Lookup a `pmip6_visited_dhcp6_server_address` ipv6addr value from a packet.
///
/// It returns the first looked up value. If there is no associated value with `pmip6_visited_dhcp6_server_address`, it returns `None`.
pub fn lookup_pmip6_visited_dhcp6_server_address(
    packet: &Packet,
) -> Option<Result<Ipv6Addr, AVPError>> {
    packet
        .lookup(PMIP6_VISITED_DHCP6_SERVER_ADDRESS_TYPE)
        .map(|v| v.encode_ipv6())
}
/// Lookup all of the `pmip6_visited_dhcp6_server_address` ipv6addr value from a packet.
pub fn lookup_all_pmip6_visited_dhcp6_server_address(
    packet: &Packet,
) -> Result<Vec<Ipv6Addr>, AVPError> {
    let mut vec = Vec::new();
    for avp in packet.lookup_all(PMIP6_VISITED_DHCP6_SERVER_ADDRESS_TYPE) {
        vec.push(avp.encode_ipv6()?)
    }
    Ok(vec)
}

pub const PMIP6_HOME_IPV4_GATEWAY_TYPE: AVPType = 161;
/// Delete all of `pmip6_home_ipv4_gateway` values from a packet.
pub fn delete_pmip6_home_ipv4_gateway(packet: &mut Packet) {
    packet.delete(PMIP6_HOME_IPV4_GATEWAY_TYPE);
}
/// Add `pmip6_home_ipv4_gateway` ipaddr value to a packet.
pub fn add_pmip6_home_ipv4_gateway(packet: &mut Packet, value: &Ipv4Addr) {
    packet.add(AVP::from_ipv4(PMIP6_HOME_IPV4_GATEWAY_TYPE, value));
}
/// Lookup a `pmip6_home_ipv4_gateway` ipaddr value from a packet.
///
/// It returns the first looked up value. If there is no associated value with `pmip6_home_ipv4_gateway`, it returns `None`.
pub fn lookup_pmip6_home_ipv4_gateway(packet: &Packet) -> Option<Result<Ipv4Addr, AVPError>> {
    packet
        .lookup(PMIP6_HOME_IPV4_GATEWAY_TYPE)
        .map(|v| v.encode_ipv4())
}
/// Lookup all of the `pmip6_home_ipv4_gateway` ipaddr value from a packet.
pub fn lookup_all_pmip6_home_ipv4_gateway(packet: &Packet) -> Result<Vec<Ipv4Addr>, AVPError> {
    let mut vec = Vec::new();
    for avp in packet.lookup_all(PMIP6_HOME_IPV4_GATEWAY_TYPE) {
        vec.push(avp.encode_ipv4()?)
    }
    Ok(vec)
}

pub const PMIP6_VISITED_IPV4_GATEWAY_TYPE: AVPType = 162;
/// Delete all of `pmip6_visited_ipv4_gateway` values from a packet.
pub fn delete_pmip6_visited_ipv4_gateway(packet: &mut Packet) {
    packet.delete(PMIP6_VISITED_IPV4_GATEWAY_TYPE);
}
/// Add `pmip6_visited_ipv4_gateway` ipaddr value to a packet.
pub fn add_pmip6_visited_ipv4_gateway(packet: &mut Packet, value: &Ipv4Addr) {
    packet.add(AVP::from_ipv4(PMIP6_VISITED_IPV4_GATEWAY_TYPE, value));
}
/// Lookup a `pmip6_visited_ipv4_gateway` ipaddr value from a packet.
///
/// It returns the first looked up value. If there is no associated value with `pmip6_visited_ipv4_gateway`, it returns `None`.
pub fn lookup_pmip6_visited_ipv4_gateway(packet: &Packet) -> Option<Result<Ipv4Addr, AVPError>> {
    packet
        .lookup(PMIP6_VISITED_IPV4_GATEWAY_TYPE)
        .map(|v| v.encode_ipv4())
}
/// Lookup all of the `pmip6_visited_ipv4_gateway` ipaddr value from a packet.
pub fn lookup_all_pmip6_visited_ipv4_gateway(packet: &Packet) -> Result<Vec<Ipv4Addr>, AVPError> {
    let mut vec = Vec::new();
    for avp in packet.lookup_all(PMIP6_VISITED_IPV4_GATEWAY_TYPE) {
        vec.push(avp.encode_ipv4()?)
    }
    Ok(vec)
}
