// Code generated by machine generator; DO NOT EDIT.

//! Utility for rfc6519 packet.
//!
//! This module handles the packet according to the following definition:
//! ```text
//! //! # -*- text -*-
//! # Copyright (C) 2020 The FreeRADIUS Server project and contributors
//! # This work is licensed under CC-BY version 4.0 https://creativecommons.org/licenses/by/4.0
//! # Version $Id$
//! #
//! #    Attributes and values defined in RFC 6519.
//! #    http://www.ietf.org/rfc/rfc6519.txt
//! #
//! #    $Id$
//! #
//!
//! ATTRIBUTE    DS-Lite-Tunnel-Name            144    string
//! ```

use crate::core::avp::{AVPError, AVPType, AVP};
use crate::core::packet::Packet;

pub const DS_LITE_TUNNEL_NAME_TYPE: AVPType = 144;
/// Delete all of `ds_lite_tunnel_name` values from a packet.
pub fn delete_ds_lite_tunnel_name(packet: &mut Packet) {
    packet.delete(DS_LITE_TUNNEL_NAME_TYPE);
}
/// Add `ds_lite_tunnel_name` string value to a packet.
pub fn add_ds_lite_tunnel_name(packet: &mut Packet, value: &str) {
    packet.add(AVP::from_string(DS_LITE_TUNNEL_NAME_TYPE, value));
}
/// Lookup a `ds_lite_tunnel_name` string value from a packet.
///
/// It returns the first looked up value. If there is no associated value with `ds_lite_tunnel_name`, it returns `None`.
pub fn lookup_ds_lite_tunnel_name(packet: &Packet) -> Option<Result<String, AVPError>> {
    packet
        .lookup(DS_LITE_TUNNEL_NAME_TYPE)
        .map(|v| v.encode_string())
}
/// Lookup all of the `ds_lite_tunnel_name` string value from a packet.
pub fn lookup_all_ds_lite_tunnel_name(packet: &Packet) -> Result<Vec<String>, AVPError> {
    let mut vec = Vec::new();
    for avp in packet.lookup_all(DS_LITE_TUNNEL_NAME_TYPE) {
        vec.push(avp.encode_string()?)
    }
    Ok(vec)
}
