// Code generated by machine generator; DO NOT EDIT.

//! Utility for rfc5904 packet.
//!
//! This module handles the packet according to the following definition:
//! ```text
//! //! # -*- text -*-
//! # Copyright (C) 2020 The FreeRADIUS Server project and contributors
//! # This work is licensed under CC-BY version 4.0 https://creativecommons.org/licenses/by/4.0
//! # Version $Id$
//! #
//! #    Attributes and values defined in RFC 5904.
//! #    http://www.ietf.org/rfc/rfc5904.txt
//! #
//! #    $Id$
//! #
//!
//! # The next two attributes are continued, like EAP-Message
//! ATTRIBUTE    PKM-SS-Cert                137    octets    concat
//! ATTRIBUTE    PKM-CA-Cert                138    octets    concat
//!
//! # 28 bytes of data, 7 integers
//! ATTRIBUTE    PKM-Config-Settings            139    octets
//! ATTRIBUTE    PKM-Cryptosuite-List            140    octets
//! ATTRIBUTE    PKM-SAID                141    short
//!
//! # 6 bytes of data: SAID, 1 byte of type, 3 of cryptosuite
//! ATTRIBUTE    PKM-SA-Descriptor            142    octets
//!
//! # 133 bytes of data: integer lifetime, 1 byte sequence, 128 bytes of key
//! ATTRIBUTE    PKM-Auth-Key                143    octets
//! ```

use crate::core::avp::{AVPError, AVPType, AVP};
use crate::core::packet::Packet;

pub const PKM_SS_CERT_TYPE: AVPType = 137;
/// Delete all of `pkm_ss_cert` values from a packet.
pub fn delete_pkm_ss_cert(packet: &mut Packet) {
    packet.delete(PKM_SS_CERT_TYPE);
}
pub fn add_pkm_ss_cert(packet: &mut Packet, value: &[u8]) {
    packet.extend(
        value
            .chunks(253)
            .map(|chunk| AVP::from_bytes(PKM_SS_CERT_TYPE, chunk))
            .collect(),
    );
}
pub fn lookup_pkm_ss_cert(packet: &Packet) -> Option<Vec<u8>> {
    let avps = packet.lookup_all(PKM_SS_CERT_TYPE);
    match avps.is_empty() {
        true => None,
        false => Some(avps.into_iter().fold(Vec::new(), |mut acc, v| {
            acc.extend(v.encode_bytes());
            acc
        })),
    }
}

pub const PKM_CA_CERT_TYPE: AVPType = 138;
/// Delete all of `pkm_ca_cert` values from a packet.
pub fn delete_pkm_ca_cert(packet: &mut Packet) {
    packet.delete(PKM_CA_CERT_TYPE);
}
pub fn add_pkm_ca_cert(packet: &mut Packet, value: &[u8]) {
    packet.extend(
        value
            .chunks(253)
            .map(|chunk| AVP::from_bytes(PKM_CA_CERT_TYPE, chunk))
            .collect(),
    );
}
pub fn lookup_pkm_ca_cert(packet: &Packet) -> Option<Vec<u8>> {
    let avps = packet.lookup_all(PKM_CA_CERT_TYPE);
    match avps.is_empty() {
        true => None,
        false => Some(avps.into_iter().fold(Vec::new(), |mut acc, v| {
            acc.extend(v.encode_bytes());
            acc
        })),
    }
}

pub const PKM_CONFIG_SETTINGS_TYPE: AVPType = 139;
/// Delete all of `pkm_config_settings` values from a packet.
pub fn delete_pkm_config_settings(packet: &mut Packet) {
    packet.delete(PKM_CONFIG_SETTINGS_TYPE);
}
/// Add `pkm_config_settings` octets value to a packet.
pub fn add_pkm_config_settings(packet: &mut Packet, value: &[u8]) {
    packet.add(AVP::from_bytes(PKM_CONFIG_SETTINGS_TYPE, value));
}
/// Lookup a `pkm_config_settings` octets value from a packet.
///
/// It returns the first looked up value. If there is no associated value with `pkm_config_settings`, it returns `None`.
pub fn lookup_pkm_config_settings(packet: &Packet) -> Option<Vec<u8>> {
    packet
        .lookup(PKM_CONFIG_SETTINGS_TYPE)
        .map(|v| v.encode_bytes())
}
/// Lookup all of the `pkm_config_settings` octets value from a packet.
pub fn lookup_all_pkm_config_settings(packet: &Packet) -> Vec<Vec<u8>> {
    let mut vec = Vec::new();
    for avp in packet.lookup_all(PKM_CONFIG_SETTINGS_TYPE) {
        vec.push(avp.encode_bytes())
    }
    vec
}

pub const PKM_CRYPTOSUITE_LIST_TYPE: AVPType = 140;
/// Delete all of `pkm_cryptosuite_list` values from a packet.
pub fn delete_pkm_cryptosuite_list(packet: &mut Packet) {
    packet.delete(PKM_CRYPTOSUITE_LIST_TYPE);
}
/// Add `pkm_cryptosuite_list` octets value to a packet.
pub fn add_pkm_cryptosuite_list(packet: &mut Packet, value: &[u8]) {
    packet.add(AVP::from_bytes(PKM_CRYPTOSUITE_LIST_TYPE, value));
}
/// Lookup a `pkm_cryptosuite_list` octets value from a packet.
///
/// It returns the first looked up value. If there is no associated value with `pkm_cryptosuite_list`, it returns `None`.
pub fn lookup_pkm_cryptosuite_list(packet: &Packet) -> Option<Vec<u8>> {
    packet
        .lookup(PKM_CRYPTOSUITE_LIST_TYPE)
        .map(|v| v.encode_bytes())
}
/// Lookup all of the `pkm_cryptosuite_list` octets value from a packet.
pub fn lookup_all_pkm_cryptosuite_list(packet: &Packet) -> Vec<Vec<u8>> {
    let mut vec = Vec::new();
    for avp in packet.lookup_all(PKM_CRYPTOSUITE_LIST_TYPE) {
        vec.push(avp.encode_bytes())
    }
    vec
}

pub const PKM_SAID_TYPE: AVPType = 141;
/// Delete all of `pkm_said` values from a packet.
pub fn delete_pkm_said(packet: &mut Packet) {
    packet.delete(PKM_SAID_TYPE);
}
/// Add `pkm_said` short integer value to a packet.
pub fn add_pkm_said(packet: &mut Packet, value: u16) {
    packet.add(AVP::from_u16(PKM_SAID_TYPE, value));
}
/// Lookup a `pkm_said` short integer value from a packet.
///
/// It returns the first looked up value. If there is no associated value with `pkm_said`, it returns `None`.
pub fn lookup_pkm_said(packet: &Packet) -> Option<Result<u16, AVPError>> {
    packet.lookup(PKM_SAID_TYPE).map(|v| v.encode_u16())
}
/// Lookup all of the `pkm_said` short integer value from a packet.
pub fn lookup_all_pkm_said(packet: &Packet) -> Result<Vec<u16>, AVPError> {
    let mut vec = Vec::new();
    for avp in packet.lookup_all(PKM_SAID_TYPE) {
        vec.push(avp.encode_u16()?)
    }
    Ok(vec)
}

pub const PKM_SA_DESCRIPTOR_TYPE: AVPType = 142;
/// Delete all of `pkm_sa_descriptor` values from a packet.
pub fn delete_pkm_sa_descriptor(packet: &mut Packet) {
    packet.delete(PKM_SA_DESCRIPTOR_TYPE);
}
/// Add `pkm_sa_descriptor` octets value to a packet.
pub fn add_pkm_sa_descriptor(packet: &mut Packet, value: &[u8]) {
    packet.add(AVP::from_bytes(PKM_SA_DESCRIPTOR_TYPE, value));
}
/// Lookup a `pkm_sa_descriptor` octets value from a packet.
///
/// It returns the first looked up value. If there is no associated value with `pkm_sa_descriptor`, it returns `None`.
pub fn lookup_pkm_sa_descriptor(packet: &Packet) -> Option<Vec<u8>> {
    packet
        .lookup(PKM_SA_DESCRIPTOR_TYPE)
        .map(|v| v.encode_bytes())
}
/// Lookup all of the `pkm_sa_descriptor` octets value from a packet.
pub fn lookup_all_pkm_sa_descriptor(packet: &Packet) -> Vec<Vec<u8>> {
    let mut vec = Vec::new();
    for avp in packet.lookup_all(PKM_SA_DESCRIPTOR_TYPE) {
        vec.push(avp.encode_bytes())
    }
    vec
}

pub const PKM_AUTH_KEY_TYPE: AVPType = 143;
/// Delete all of `pkm_auth_key` values from a packet.
pub fn delete_pkm_auth_key(packet: &mut Packet) {
    packet.delete(PKM_AUTH_KEY_TYPE);
}
/// Add `pkm_auth_key` octets value to a packet.
pub fn add_pkm_auth_key(packet: &mut Packet, value: &[u8]) {
    packet.add(AVP::from_bytes(PKM_AUTH_KEY_TYPE, value));
}
/// Lookup a `pkm_auth_key` octets value from a packet.
///
/// It returns the first looked up value. If there is no associated value with `pkm_auth_key`, it returns `None`.
pub fn lookup_pkm_auth_key(packet: &Packet) -> Option<Vec<u8>> {
    packet.lookup(PKM_AUTH_KEY_TYPE).map(|v| v.encode_bytes())
}
/// Lookup all of the `pkm_auth_key` octets value from a packet.
pub fn lookup_all_pkm_auth_key(packet: &Packet) -> Vec<Vec<u8>> {
    let mut vec = Vec::new();
    for avp in packet.lookup_all(PKM_AUTH_KEY_TYPE) {
        vec.push(avp.encode_bytes())
    }
    vec
}
