// Code generated by machine generator; DO NOT EDIT.

//! Utility for rfc5090 packet.
//!
//! This module handles the packet according to the following definition:
//! ```text
//! //! # -*- text -*-
//! # Copyright (C) 2020 The FreeRADIUS Server project and contributors
//! # This work is licensed under CC-BY version 4.0 https://creativecommons.org/licenses/by/4.0
//! # Version $Id$
//! #
//! #    Attributes and values defined in RFC 5090.
//! #    http://www.ietf.org/rfc/rfc5090.txt
//! #
//! #    $Id$
//! #
//! ATTRIBUTE    Digest-Response                103    string
//! ATTRIBUTE    Digest-Realm                104    string
//! ATTRIBUTE    Digest-Nonce                105    string
//! ATTRIBUTE    Digest-Response-Auth            106    string
//! ATTRIBUTE    Digest-Nextnonce            107    string
//! ATTRIBUTE    Digest-Method                108    string
//! ATTRIBUTE    Digest-URI                109    string
//! ATTRIBUTE    Digest-Qop                110    string
//! ATTRIBUTE    Digest-Algorithm            111    string
//! ATTRIBUTE    Digest-Entity-Body-Hash            112    string
//! ATTRIBUTE    Digest-CNonce                113    string
//! ATTRIBUTE    Digest-Nonce-Count            114    string
//! ATTRIBUTE    Digest-Username                115    string
//! ATTRIBUTE    Digest-Opaque                116    string
//! ATTRIBUTE    Digest-Auth-Param            117    string
//! ATTRIBUTE    Digest-AKA-Auts                118    string
//! ATTRIBUTE    Digest-Domain                119    string
//! ATTRIBUTE    Digest-Stale                120    string
//! ATTRIBUTE    Digest-HA1                121    string
//! ATTRIBUTE    SIP-AOR                    122    string
//! ```

use crate::core::avp::{AVPError, AVPType, AVP};
use crate::core::packet::Packet;

pub const DIGEST_RESPONSE_TYPE: AVPType = 103;
/// Delete all of `digest_response` values from a packet.
pub fn delete_digest_response(packet: &mut Packet) {
    packet.delete(DIGEST_RESPONSE_TYPE);
}
/// Add `digest_response` string value to a packet.
pub fn add_digest_response(packet: &mut Packet, value: &str) {
    packet.add(AVP::from_string(DIGEST_RESPONSE_TYPE, value));
}
/// Lookup a `digest_response` string value from a packet.
///
/// It returns the first looked up value. If there is no associated value with `digest_response`, it returns `None`.
pub fn lookup_digest_response(packet: &Packet) -> Option<Result<String, AVPError>> {
    packet
        .lookup(DIGEST_RESPONSE_TYPE)
        .map(|v| v.encode_string())
}
/// Lookup all of the `digest_response` string value from a packet.
pub fn lookup_all_digest_response(packet: &Packet) -> Result<Vec<String>, AVPError> {
    let mut vec = Vec::new();
    for avp in packet.lookup_all(DIGEST_RESPONSE_TYPE) {
        vec.push(avp.encode_string()?)
    }
    Ok(vec)
}

pub const DIGEST_REALM_TYPE: AVPType = 104;
/// Delete all of `digest_realm` values from a packet.
pub fn delete_digest_realm(packet: &mut Packet) {
    packet.delete(DIGEST_REALM_TYPE);
}
/// Add `digest_realm` string value to a packet.
pub fn add_digest_realm(packet: &mut Packet, value: &str) {
    packet.add(AVP::from_string(DIGEST_REALM_TYPE, value));
}
/// Lookup a `digest_realm` string value from a packet.
///
/// It returns the first looked up value. If there is no associated value with `digest_realm`, it returns `None`.
pub fn lookup_digest_realm(packet: &Packet) -> Option<Result<String, AVPError>> {
    packet.lookup(DIGEST_REALM_TYPE).map(|v| v.encode_string())
}
/// Lookup all of the `digest_realm` string value from a packet.
pub fn lookup_all_digest_realm(packet: &Packet) -> Result<Vec<String>, AVPError> {
    let mut vec = Vec::new();
    for avp in packet.lookup_all(DIGEST_REALM_TYPE) {
        vec.push(avp.encode_string()?)
    }
    Ok(vec)
}

pub const DIGEST_NONCE_TYPE: AVPType = 105;
/// Delete all of `digest_nonce` values from a packet.
pub fn delete_digest_nonce(packet: &mut Packet) {
    packet.delete(DIGEST_NONCE_TYPE);
}
/// Add `digest_nonce` string value to a packet.
pub fn add_digest_nonce(packet: &mut Packet, value: &str) {
    packet.add(AVP::from_string(DIGEST_NONCE_TYPE, value));
}
/// Lookup a `digest_nonce` string value from a packet.
///
/// It returns the first looked up value. If there is no associated value with `digest_nonce`, it returns `None`.
pub fn lookup_digest_nonce(packet: &Packet) -> Option<Result<String, AVPError>> {
    packet.lookup(DIGEST_NONCE_TYPE).map(|v| v.encode_string())
}
/// Lookup all of the `digest_nonce` string value from a packet.
pub fn lookup_all_digest_nonce(packet: &Packet) -> Result<Vec<String>, AVPError> {
    let mut vec = Vec::new();
    for avp in packet.lookup_all(DIGEST_NONCE_TYPE) {
        vec.push(avp.encode_string()?)
    }
    Ok(vec)
}

pub const DIGEST_RESPONSE_AUTH_TYPE: AVPType = 106;
/// Delete all of `digest_response_auth` values from a packet.
pub fn delete_digest_response_auth(packet: &mut Packet) {
    packet.delete(DIGEST_RESPONSE_AUTH_TYPE);
}
/// Add `digest_response_auth` string value to a packet.
pub fn add_digest_response_auth(packet: &mut Packet, value: &str) {
    packet.add(AVP::from_string(DIGEST_RESPONSE_AUTH_TYPE, value));
}
/// Lookup a `digest_response_auth` string value from a packet.
///
/// It returns the first looked up value. If there is no associated value with `digest_response_auth`, it returns `None`.
pub fn lookup_digest_response_auth(packet: &Packet) -> Option<Result<String, AVPError>> {
    packet
        .lookup(DIGEST_RESPONSE_AUTH_TYPE)
        .map(|v| v.encode_string())
}
/// Lookup all of the `digest_response_auth` string value from a packet.
pub fn lookup_all_digest_response_auth(packet: &Packet) -> Result<Vec<String>, AVPError> {
    let mut vec = Vec::new();
    for avp in packet.lookup_all(DIGEST_RESPONSE_AUTH_TYPE) {
        vec.push(avp.encode_string()?)
    }
    Ok(vec)
}

pub const DIGEST_NEXTNONCE_TYPE: AVPType = 107;
/// Delete all of `digest_nextnonce` values from a packet.
pub fn delete_digest_nextnonce(packet: &mut Packet) {
    packet.delete(DIGEST_NEXTNONCE_TYPE);
}
/// Add `digest_nextnonce` string value to a packet.
pub fn add_digest_nextnonce(packet: &mut Packet, value: &str) {
    packet.add(AVP::from_string(DIGEST_NEXTNONCE_TYPE, value));
}
/// Lookup a `digest_nextnonce` string value from a packet.
///
/// It returns the first looked up value. If there is no associated value with `digest_nextnonce`, it returns `None`.
pub fn lookup_digest_nextnonce(packet: &Packet) -> Option<Result<String, AVPError>> {
    packet
        .lookup(DIGEST_NEXTNONCE_TYPE)
        .map(|v| v.encode_string())
}
/// Lookup all of the `digest_nextnonce` string value from a packet.
pub fn lookup_all_digest_nextnonce(packet: &Packet) -> Result<Vec<String>, AVPError> {
    let mut vec = Vec::new();
    for avp in packet.lookup_all(DIGEST_NEXTNONCE_TYPE) {
        vec.push(avp.encode_string()?)
    }
    Ok(vec)
}

pub const DIGEST_METHOD_TYPE: AVPType = 108;
/// Delete all of `digest_method` values from a packet.
pub fn delete_digest_method(packet: &mut Packet) {
    packet.delete(DIGEST_METHOD_TYPE);
}
/// Add `digest_method` string value to a packet.
pub fn add_digest_method(packet: &mut Packet, value: &str) {
    packet.add(AVP::from_string(DIGEST_METHOD_TYPE, value));
}
/// Lookup a `digest_method` string value from a packet.
///
/// It returns the first looked up value. If there is no associated value with `digest_method`, it returns `None`.
pub fn lookup_digest_method(packet: &Packet) -> Option<Result<String, AVPError>> {
    packet.lookup(DIGEST_METHOD_TYPE).map(|v| v.encode_string())
}
/// Lookup all of the `digest_method` string value from a packet.
pub fn lookup_all_digest_method(packet: &Packet) -> Result<Vec<String>, AVPError> {
    let mut vec = Vec::new();
    for avp in packet.lookup_all(DIGEST_METHOD_TYPE) {
        vec.push(avp.encode_string()?)
    }
    Ok(vec)
}

pub const DIGEST_URI_TYPE: AVPType = 109;
/// Delete all of `digest_uri` values from a packet.
pub fn delete_digest_uri(packet: &mut Packet) {
    packet.delete(DIGEST_URI_TYPE);
}
/// Add `digest_uri` string value to a packet.
pub fn add_digest_uri(packet: &mut Packet, value: &str) {
    packet.add(AVP::from_string(DIGEST_URI_TYPE, value));
}
/// Lookup a `digest_uri` string value from a packet.
///
/// It returns the first looked up value. If there is no associated value with `digest_uri`, it returns `None`.
pub fn lookup_digest_uri(packet: &Packet) -> Option<Result<String, AVPError>> {
    packet.lookup(DIGEST_URI_TYPE).map(|v| v.encode_string())
}
/// Lookup all of the `digest_uri` string value from a packet.
pub fn lookup_all_digest_uri(packet: &Packet) -> Result<Vec<String>, AVPError> {
    let mut vec = Vec::new();
    for avp in packet.lookup_all(DIGEST_URI_TYPE) {
        vec.push(avp.encode_string()?)
    }
    Ok(vec)
}

pub const DIGEST_QOP_TYPE: AVPType = 110;
/// Delete all of `digest_qop` values from a packet.
pub fn delete_digest_qop(packet: &mut Packet) {
    packet.delete(DIGEST_QOP_TYPE);
}
/// Add `digest_qop` string value to a packet.
pub fn add_digest_qop(packet: &mut Packet, value: &str) {
    packet.add(AVP::from_string(DIGEST_QOP_TYPE, value));
}
/// Lookup a `digest_qop` string value from a packet.
///
/// It returns the first looked up value. If there is no associated value with `digest_qop`, it returns `None`.
pub fn lookup_digest_qop(packet: &Packet) -> Option<Result<String, AVPError>> {
    packet.lookup(DIGEST_QOP_TYPE).map(|v| v.encode_string())
}
/// Lookup all of the `digest_qop` string value from a packet.
pub fn lookup_all_digest_qop(packet: &Packet) -> Result<Vec<String>, AVPError> {
    let mut vec = Vec::new();
    for avp in packet.lookup_all(DIGEST_QOP_TYPE) {
        vec.push(avp.encode_string()?)
    }
    Ok(vec)
}

pub const DIGEST_ALGORITHM_TYPE: AVPType = 111;
/// Delete all of `digest_algorithm` values from a packet.
pub fn delete_digest_algorithm(packet: &mut Packet) {
    packet.delete(DIGEST_ALGORITHM_TYPE);
}
/// Add `digest_algorithm` string value to a packet.
pub fn add_digest_algorithm(packet: &mut Packet, value: &str) {
    packet.add(AVP::from_string(DIGEST_ALGORITHM_TYPE, value));
}
/// Lookup a `digest_algorithm` string value from a packet.
///
/// It returns the first looked up value. If there is no associated value with `digest_algorithm`, it returns `None`.
pub fn lookup_digest_algorithm(packet: &Packet) -> Option<Result<String, AVPError>> {
    packet
        .lookup(DIGEST_ALGORITHM_TYPE)
        .map(|v| v.encode_string())
}
/// Lookup all of the `digest_algorithm` string value from a packet.
pub fn lookup_all_digest_algorithm(packet: &Packet) -> Result<Vec<String>, AVPError> {
    let mut vec = Vec::new();
    for avp in packet.lookup_all(DIGEST_ALGORITHM_TYPE) {
        vec.push(avp.encode_string()?)
    }
    Ok(vec)
}

pub const DIGEST_ENTITY_BODY_HASH_TYPE: AVPType = 112;
/// Delete all of `digest_entity_body_hash` values from a packet.
pub fn delete_digest_entity_body_hash(packet: &mut Packet) {
    packet.delete(DIGEST_ENTITY_BODY_HASH_TYPE);
}
/// Add `digest_entity_body_hash` string value to a packet.
pub fn add_digest_entity_body_hash(packet: &mut Packet, value: &str) {
    packet.add(AVP::from_string(DIGEST_ENTITY_BODY_HASH_TYPE, value));
}
/// Lookup a `digest_entity_body_hash` string value from a packet.
///
/// It returns the first looked up value. If there is no associated value with `digest_entity_body_hash`, it returns `None`.
pub fn lookup_digest_entity_body_hash(packet: &Packet) -> Option<Result<String, AVPError>> {
    packet
        .lookup(DIGEST_ENTITY_BODY_HASH_TYPE)
        .map(|v| v.encode_string())
}
/// Lookup all of the `digest_entity_body_hash` string value from a packet.
pub fn lookup_all_digest_entity_body_hash(packet: &Packet) -> Result<Vec<String>, AVPError> {
    let mut vec = Vec::new();
    for avp in packet.lookup_all(DIGEST_ENTITY_BODY_HASH_TYPE) {
        vec.push(avp.encode_string()?)
    }
    Ok(vec)
}

pub const DIGEST_C_NONCE_TYPE: AVPType = 113;
/// Delete all of `digest_c_nonce` values from a packet.
pub fn delete_digest_c_nonce(packet: &mut Packet) {
    packet.delete(DIGEST_C_NONCE_TYPE);
}
/// Add `digest_c_nonce` string value to a packet.
pub fn add_digest_c_nonce(packet: &mut Packet, value: &str) {
    packet.add(AVP::from_string(DIGEST_C_NONCE_TYPE, value));
}
/// Lookup a `digest_c_nonce` string value from a packet.
///
/// It returns the first looked up value. If there is no associated value with `digest_c_nonce`, it returns `None`.
pub fn lookup_digest_c_nonce(packet: &Packet) -> Option<Result<String, AVPError>> {
    packet
        .lookup(DIGEST_C_NONCE_TYPE)
        .map(|v| v.encode_string())
}
/// Lookup all of the `digest_c_nonce` string value from a packet.
pub fn lookup_all_digest_c_nonce(packet: &Packet) -> Result<Vec<String>, AVPError> {
    let mut vec = Vec::new();
    for avp in packet.lookup_all(DIGEST_C_NONCE_TYPE) {
        vec.push(avp.encode_string()?)
    }
    Ok(vec)
}

pub const DIGEST_NONCE_COUNT_TYPE: AVPType = 114;
/// Delete all of `digest_nonce_count` values from a packet.
pub fn delete_digest_nonce_count(packet: &mut Packet) {
    packet.delete(DIGEST_NONCE_COUNT_TYPE);
}
/// Add `digest_nonce_count` string value to a packet.
pub fn add_digest_nonce_count(packet: &mut Packet, value: &str) {
    packet.add(AVP::from_string(DIGEST_NONCE_COUNT_TYPE, value));
}
/// Lookup a `digest_nonce_count` string value from a packet.
///
/// It returns the first looked up value. If there is no associated value with `digest_nonce_count`, it returns `None`.
pub fn lookup_digest_nonce_count(packet: &Packet) -> Option<Result<String, AVPError>> {
    packet
        .lookup(DIGEST_NONCE_COUNT_TYPE)
        .map(|v| v.encode_string())
}
/// Lookup all of the `digest_nonce_count` string value from a packet.
pub fn lookup_all_digest_nonce_count(packet: &Packet) -> Result<Vec<String>, AVPError> {
    let mut vec = Vec::new();
    for avp in packet.lookup_all(DIGEST_NONCE_COUNT_TYPE) {
        vec.push(avp.encode_string()?)
    }
    Ok(vec)
}

pub const DIGEST_USERNAME_TYPE: AVPType = 115;
/// Delete all of `digest_username` values from a packet.
pub fn delete_digest_username(packet: &mut Packet) {
    packet.delete(DIGEST_USERNAME_TYPE);
}
/// Add `digest_username` string value to a packet.
pub fn add_digest_username(packet: &mut Packet, value: &str) {
    packet.add(AVP::from_string(DIGEST_USERNAME_TYPE, value));
}
/// Lookup a `digest_username` string value from a packet.
///
/// It returns the first looked up value. If there is no associated value with `digest_username`, it returns `None`.
pub fn lookup_digest_username(packet: &Packet) -> Option<Result<String, AVPError>> {
    packet
        .lookup(DIGEST_USERNAME_TYPE)
        .map(|v| v.encode_string())
}
/// Lookup all of the `digest_username` string value from a packet.
pub fn lookup_all_digest_username(packet: &Packet) -> Result<Vec<String>, AVPError> {
    let mut vec = Vec::new();
    for avp in packet.lookup_all(DIGEST_USERNAME_TYPE) {
        vec.push(avp.encode_string()?)
    }
    Ok(vec)
}

pub const DIGEST_OPAQUE_TYPE: AVPType = 116;
/// Delete all of `digest_opaque` values from a packet.
pub fn delete_digest_opaque(packet: &mut Packet) {
    packet.delete(DIGEST_OPAQUE_TYPE);
}
/// Add `digest_opaque` string value to a packet.
pub fn add_digest_opaque(packet: &mut Packet, value: &str) {
    packet.add(AVP::from_string(DIGEST_OPAQUE_TYPE, value));
}
/// Lookup a `digest_opaque` string value from a packet.
///
/// It returns the first looked up value. If there is no associated value with `digest_opaque`, it returns `None`.
pub fn lookup_digest_opaque(packet: &Packet) -> Option<Result<String, AVPError>> {
    packet.lookup(DIGEST_OPAQUE_TYPE).map(|v| v.encode_string())
}
/// Lookup all of the `digest_opaque` string value from a packet.
pub fn lookup_all_digest_opaque(packet: &Packet) -> Result<Vec<String>, AVPError> {
    let mut vec = Vec::new();
    for avp in packet.lookup_all(DIGEST_OPAQUE_TYPE) {
        vec.push(avp.encode_string()?)
    }
    Ok(vec)
}

pub const DIGEST_AUTH_PARAM_TYPE: AVPType = 117;
/// Delete all of `digest_auth_param` values from a packet.
pub fn delete_digest_auth_param(packet: &mut Packet) {
    packet.delete(DIGEST_AUTH_PARAM_TYPE);
}
/// Add `digest_auth_param` string value to a packet.
pub fn add_digest_auth_param(packet: &mut Packet, value: &str) {
    packet.add(AVP::from_string(DIGEST_AUTH_PARAM_TYPE, value));
}
/// Lookup a `digest_auth_param` string value from a packet.
///
/// It returns the first looked up value. If there is no associated value with `digest_auth_param`, it returns `None`.
pub fn lookup_digest_auth_param(packet: &Packet) -> Option<Result<String, AVPError>> {
    packet
        .lookup(DIGEST_AUTH_PARAM_TYPE)
        .map(|v| v.encode_string())
}
/// Lookup all of the `digest_auth_param` string value from a packet.
pub fn lookup_all_digest_auth_param(packet: &Packet) -> Result<Vec<String>, AVPError> {
    let mut vec = Vec::new();
    for avp in packet.lookup_all(DIGEST_AUTH_PARAM_TYPE) {
        vec.push(avp.encode_string()?)
    }
    Ok(vec)
}

pub const DIGEST_AKA_AUTS_TYPE: AVPType = 118;
/// Delete all of `digest_aka_auts` values from a packet.
pub fn delete_digest_aka_auts(packet: &mut Packet) {
    packet.delete(DIGEST_AKA_AUTS_TYPE);
}
/// Add `digest_aka_auts` string value to a packet.
pub fn add_digest_aka_auts(packet: &mut Packet, value: &str) {
    packet.add(AVP::from_string(DIGEST_AKA_AUTS_TYPE, value));
}
/// Lookup a `digest_aka_auts` string value from a packet.
///
/// It returns the first looked up value. If there is no associated value with `digest_aka_auts`, it returns `None`.
pub fn lookup_digest_aka_auts(packet: &Packet) -> Option<Result<String, AVPError>> {
    packet
        .lookup(DIGEST_AKA_AUTS_TYPE)
        .map(|v| v.encode_string())
}
/// Lookup all of the `digest_aka_auts` string value from a packet.
pub fn lookup_all_digest_aka_auts(packet: &Packet) -> Result<Vec<String>, AVPError> {
    let mut vec = Vec::new();
    for avp in packet.lookup_all(DIGEST_AKA_AUTS_TYPE) {
        vec.push(avp.encode_string()?)
    }
    Ok(vec)
}

pub const DIGEST_DOMAIN_TYPE: AVPType = 119;
/// Delete all of `digest_domain` values from a packet.
pub fn delete_digest_domain(packet: &mut Packet) {
    packet.delete(DIGEST_DOMAIN_TYPE);
}
/// Add `digest_domain` string value to a packet.
pub fn add_digest_domain(packet: &mut Packet, value: &str) {
    packet.add(AVP::from_string(DIGEST_DOMAIN_TYPE, value));
}
/// Lookup a `digest_domain` string value from a packet.
///
/// It returns the first looked up value. If there is no associated value with `digest_domain`, it returns `None`.
pub fn lookup_digest_domain(packet: &Packet) -> Option<Result<String, AVPError>> {
    packet.lookup(DIGEST_DOMAIN_TYPE).map(|v| v.encode_string())
}
/// Lookup all of the `digest_domain` string value from a packet.
pub fn lookup_all_digest_domain(packet: &Packet) -> Result<Vec<String>, AVPError> {
    let mut vec = Vec::new();
    for avp in packet.lookup_all(DIGEST_DOMAIN_TYPE) {
        vec.push(avp.encode_string()?)
    }
    Ok(vec)
}

pub const DIGEST_STALE_TYPE: AVPType = 120;
/// Delete all of `digest_stale` values from a packet.
pub fn delete_digest_stale(packet: &mut Packet) {
    packet.delete(DIGEST_STALE_TYPE);
}
/// Add `digest_stale` string value to a packet.
pub fn add_digest_stale(packet: &mut Packet, value: &str) {
    packet.add(AVP::from_string(DIGEST_STALE_TYPE, value));
}
/// Lookup a `digest_stale` string value from a packet.
///
/// It returns the first looked up value. If there is no associated value with `digest_stale`, it returns `None`.
pub fn lookup_digest_stale(packet: &Packet) -> Option<Result<String, AVPError>> {
    packet.lookup(DIGEST_STALE_TYPE).map(|v| v.encode_string())
}
/// Lookup all of the `digest_stale` string value from a packet.
pub fn lookup_all_digest_stale(packet: &Packet) -> Result<Vec<String>, AVPError> {
    let mut vec = Vec::new();
    for avp in packet.lookup_all(DIGEST_STALE_TYPE) {
        vec.push(avp.encode_string()?)
    }
    Ok(vec)
}

pub const DIGEST_HA1_TYPE: AVPType = 121;
/// Delete all of `digest_ha1` values from a packet.
pub fn delete_digest_ha1(packet: &mut Packet) {
    packet.delete(DIGEST_HA1_TYPE);
}
/// Add `digest_ha1` string value to a packet.
pub fn add_digest_ha1(packet: &mut Packet, value: &str) {
    packet.add(AVP::from_string(DIGEST_HA1_TYPE, value));
}
/// Lookup a `digest_ha1` string value from a packet.
///
/// It returns the first looked up value. If there is no associated value with `digest_ha1`, it returns `None`.
pub fn lookup_digest_ha1(packet: &Packet) -> Option<Result<String, AVPError>> {
    packet.lookup(DIGEST_HA1_TYPE).map(|v| v.encode_string())
}
/// Lookup all of the `digest_ha1` string value from a packet.
pub fn lookup_all_digest_ha1(packet: &Packet) -> Result<Vec<String>, AVPError> {
    let mut vec = Vec::new();
    for avp in packet.lookup_all(DIGEST_HA1_TYPE) {
        vec.push(avp.encode_string()?)
    }
    Ok(vec)
}

pub const SIP_AOR_TYPE: AVPType = 122;
/// Delete all of `sip_aor` values from a packet.
pub fn delete_sip_aor(packet: &mut Packet) {
    packet.delete(SIP_AOR_TYPE);
}
/// Add `sip_aor` string value to a packet.
pub fn add_sip_aor(packet: &mut Packet, value: &str) {
    packet.add(AVP::from_string(SIP_AOR_TYPE, value));
}
/// Lookup a `sip_aor` string value from a packet.
///
/// It returns the first looked up value. If there is no associated value with `sip_aor`, it returns `None`.
pub fn lookup_sip_aor(packet: &Packet) -> Option<Result<String, AVPError>> {
    packet.lookup(SIP_AOR_TYPE).map(|v| v.encode_string())
}
/// Lookup all of the `sip_aor` string value from a packet.
pub fn lookup_all_sip_aor(packet: &Packet) -> Result<Vec<String>, AVPError> {
    let mut vec = Vec::new();
    for avp in packet.lookup_all(SIP_AOR_TYPE) {
        vec.push(avp.encode_string()?)
    }
    Ok(vec)
}
