// Code generated by machine generator; DO NOT EDIT.

//! Utility for rfc4818 packet.
//!
//! This module handles the packet according to the following definition:
//! ```text
//! //! # -*- text -*-
//! # Copyright (C) 2020 The FreeRADIUS Server project and contributors
//! # This work is licensed under CC-BY version 4.0 https://creativecommons.org/licenses/by/4.0
//! # Version $Id$
//! ##############################################################################
//! #
//! #    Attributes and values defined in RFC 4818.
//! #    http://www.ietf.org/rfc/rfc4818.txt
//! #
//! #    $Id$
//! #
//! ##############################################################################
//!
//! ATTRIBUTE    Delegated-IPV6-Prefix            123    ipv6prefix
//! ```

use crate::core::avp::{AVPError, AVPType, AVP};
use crate::core::packet::Packet;

pub const DELEGATED_IPV6_PREFIX_TYPE: AVPType = 123;
/// Delete all of `delegated_ipv6_prefix` values from a packet.
pub fn delete_delegated_ipv6_prefix(packet: &mut Packet) {
    packet.delete(DELEGATED_IPV6_PREFIX_TYPE);
}
/// Add `delegated_ipv6_prefix` ipv6 prefix value to a packet.
pub fn add_delegated_ipv6_prefix(packet: &mut Packet, value: &[u8]) -> Result<(), AVPError> {
    packet.add(AVP::from_ipv6_prefix(DELEGATED_IPV6_PREFIX_TYPE, value)?);
    Ok(())
}
/// Lookup a `delegated_ipv6_prefix` ipv6 prefix value from a packet.
///
/// It returns the first looked up value. If there is no associated value with `delegated_ipv6_prefix`, it returns `None`.
pub fn lookup_delegated_ipv6_prefix(packet: &Packet) -> Option<Result<Vec<u8>, AVPError>> {
    packet
        .lookup(DELEGATED_IPV6_PREFIX_TYPE)
        .map(|v| v.encode_ipv6_prefix())
}
/// Lookup all of the `delegated_ipv6_prefix` ipv6 prefix value from a packet.
pub fn lookup_all_delegated_ipv6_prefix(packet: &Packet) -> Result<Vec<Vec<u8>>, AVPError> {
    let mut vec = Vec::new();
    for avp in packet.lookup_all(DELEGATED_IPV6_PREFIX_TYPE) {
        vec.push(avp.encode_ipv6_prefix()?)
    }
    Ok(vec)
}
