// Code generated by machine generator; DO NOT EDIT.

//! Utility for rfc4372 packet.
//!
//! This module handles the packet according to the following definition:
//! ```text
//! //! # -*- text -*-
//! # Copyright (C) 2020 The FreeRADIUS Server project and contributors
//! # This work is licensed under CC-BY version 4.0 https://creativecommons.org/licenses/by/4.0
//! # Version $Id$
//! #
//! #    Attributes and values defined in RFC 4372.
//! #    http://www.ietf.org/rfc/rfc4372.txt
//! #
//! #    $Id$
//! #
//! ATTRIBUTE    Chargeable-User-Identity        89    octets
//! ```

use crate::core::avp::{AVPType, AVP};
use crate::core::packet::Packet;

pub const CHARGEABLE_USER_IDENTITY_TYPE: AVPType = 89;
/// Delete all of `chargeable_user_identity` values from a packet.
pub fn delete_chargeable_user_identity(packet: &mut Packet) {
    packet.delete(CHARGEABLE_USER_IDENTITY_TYPE);
}
/// Add `chargeable_user_identity` octets value to a packet.
pub fn add_chargeable_user_identity(packet: &mut Packet, value: &[u8]) {
    packet.add(AVP::from_bytes(CHARGEABLE_USER_IDENTITY_TYPE, value));
}
/// Lookup a `chargeable_user_identity` octets value from a packet.
///
/// It returns the first looked up value. If there is no associated value with `chargeable_user_identity`, it returns `None`.
pub fn lookup_chargeable_user_identity(packet: &Packet) -> Option<Vec<u8>> {
    packet
        .lookup(CHARGEABLE_USER_IDENTITY_TYPE)
        .map(|v| v.encode_bytes())
}
/// Lookup all of the `chargeable_user_identity` octets value from a packet.
pub fn lookup_all_chargeable_user_identity(packet: &Packet) -> Vec<Vec<u8>> {
    let mut vec = Vec::new();
    for avp in packet.lookup_all(CHARGEABLE_USER_IDENTITY_TYPE) {
        vec.push(avp.encode_bytes())
    }
    vec
}
