// Code generated by machine generator; DO NOT EDIT.

//! Utility for rfc2869 packet.
//!
//! This module handles the packet according to the following definition:
//! ```text
//! //! # -*- text -*-
//! # Copyright (C) 2020 The FreeRADIUS Server project and contributors
//! # This work is licensed under CC-BY version 4.0 https://creativecommons.org/licenses/by/4.0
//! # Version $Id$
//! #
//! #    Attributes and values defined in RFC 2869.
//! #    http://www.ietf.org/rfc/rfc2869.txt
//! #
//! #    $Id$
//! #
//! ATTRIBUTE    Acct-Input-Gigawords            52    integer
//! ATTRIBUTE    Acct-Output-Gigawords            53    integer
//!
//! ATTRIBUTE    Event-Timestamp                55    date
//!
//! ATTRIBUTE    ARAP-Password                70    octets[16]
//! ATTRIBUTE    ARAP-Features                71    octets[14]
//! ATTRIBUTE    ARAP-Zone-Access            72    integer
//! ATTRIBUTE    ARAP-Security                73    integer
//! ATTRIBUTE    ARAP-Security-Data            74    string
//! ATTRIBUTE    Password-Retry                75    integer
//! ATTRIBUTE    Prompt                    76    integer
//! ATTRIBUTE    Connect-Info                77    string
//! ATTRIBUTE    Configuration-Token            78    string
//! ATTRIBUTE    EAP-Message                79    octets    concat
//! ATTRIBUTE    Message-Authenticator            80    octets
//!
//! ATTRIBUTE    ARAP-Challenge-Response            84    octets[8]
//! ATTRIBUTE    Acct-Interim-Interval            85    integer
//! # 86: RFC 2867
//! ATTRIBUTE    NAS-Port-Id                87    string
//! ATTRIBUTE    Framed-Pool                88    string
//!
//! #    ARAP Zone Access
//!
//! VALUE    ARAP-Zone-Access        Default-Zone        1
//! VALUE    ARAP-Zone-Access        Zone-Filter-Inclusive    2
//! VALUE    ARAP-Zone-Access        Zone-Filter-Exclusive    4
//!
//! #    Prompt
//! VALUE    Prompt                No-Echo            0
//! VALUE    Prompt                Echo            1
//! ```

use chrono::{DateTime, Utc};

use crate::core::avp::{AVPError, AVPType, AVP};
use crate::core::packet::Packet;

pub const ACCT_INPUT_GIGAWORDS_TYPE: AVPType = 52;
/// Delete all of `acct_input_gigawords` values from a packet.
pub fn delete_acct_input_gigawords(packet: &mut Packet) {
    packet.delete(ACCT_INPUT_GIGAWORDS_TYPE);
}
/// Add `acct_input_gigawords` integer value to a packet.
pub fn add_acct_input_gigawords(packet: &mut Packet, value: u32) {
    packet.add(AVP::from_u32(ACCT_INPUT_GIGAWORDS_TYPE, value));
}
/// Lookup a `acct_input_gigawords` integer value from a packet.
///
/// It returns the first looked up value. If there is no associated value with `acct_input_gigawords`, it returns `None`.
pub fn lookup_acct_input_gigawords(packet: &Packet) -> Option<Result<u32, AVPError>> {
    packet
        .lookup(ACCT_INPUT_GIGAWORDS_TYPE)
        .map(|v| v.encode_u32())
}
/// Lookup all of the `acct_input_gigawords` integer value from a packet.
pub fn lookup_all_acct_input_gigawords(packet: &Packet) -> Result<Vec<u32>, AVPError> {
    let mut vec = Vec::new();
    for avp in packet.lookup_all(ACCT_INPUT_GIGAWORDS_TYPE) {
        vec.push(avp.encode_u32()?)
    }
    Ok(vec)
}

pub const ACCT_OUTPUT_GIGAWORDS_TYPE: AVPType = 53;
/// Delete all of `acct_output_gigawords` values from a packet.
pub fn delete_acct_output_gigawords(packet: &mut Packet) {
    packet.delete(ACCT_OUTPUT_GIGAWORDS_TYPE);
}
/// Add `acct_output_gigawords` integer value to a packet.
pub fn add_acct_output_gigawords(packet: &mut Packet, value: u32) {
    packet.add(AVP::from_u32(ACCT_OUTPUT_GIGAWORDS_TYPE, value));
}
/// Lookup a `acct_output_gigawords` integer value from a packet.
///
/// It returns the first looked up value. If there is no associated value with `acct_output_gigawords`, it returns `None`.
pub fn lookup_acct_output_gigawords(packet: &Packet) -> Option<Result<u32, AVPError>> {
    packet
        .lookup(ACCT_OUTPUT_GIGAWORDS_TYPE)
        .map(|v| v.encode_u32())
}
/// Lookup all of the `acct_output_gigawords` integer value from a packet.
pub fn lookup_all_acct_output_gigawords(packet: &Packet) -> Result<Vec<u32>, AVPError> {
    let mut vec = Vec::new();
    for avp in packet.lookup_all(ACCT_OUTPUT_GIGAWORDS_TYPE) {
        vec.push(avp.encode_u32()?)
    }
    Ok(vec)
}

pub const EVENT_TIMESTAMP_TYPE: AVPType = 55;
/// Delete all of `event_timestamp` values from a packet.
pub fn delete_event_timestamp(packet: &mut Packet) {
    packet.delete(EVENT_TIMESTAMP_TYPE);
}
/// Add `event_timestamp` date value to a packet.
pub fn add_event_timestamp(packet: &mut Packet, value: &DateTime<Utc>) {
    packet.add(AVP::from_date(EVENT_TIMESTAMP_TYPE, value));
}
/// Lookup a `event_timestamp` date value from a packet.
///
/// It returns the first looked up value. If there is no associated value with `event_timestamp`, it returns `None`.
pub fn lookup_event_timestamp(packet: &Packet) -> Option<Result<DateTime<Utc>, AVPError>> {
    packet.lookup(EVENT_TIMESTAMP_TYPE).map(|v| v.encode_date())
}
/// Lookup all of the `event_timestamp` date value from a packet.
pub fn lookup_all_event_timestamp(packet: &Packet) -> Result<Vec<DateTime<Utc>>, AVPError> {
    let mut vec = Vec::new();
    for avp in packet.lookup_all(EVENT_TIMESTAMP_TYPE) {
        vec.push(avp.encode_date()?)
    }
    Ok(vec)
}

pub const ARAP_PASSWORD_TYPE: AVPType = 70;
/// Delete all of `arap_password` values from a packet.
pub fn delete_arap_password(packet: &mut Packet) {
    packet.delete(ARAP_PASSWORD_TYPE);
}
/// Add `arap_password` fixed-length octets value to a packet.
pub fn add_arap_password(packet: &mut Packet, value: &[u8]) -> Result<(), AVPError> {
    if value.len() != 16 {
        return Err(AVPError::InvalidAttributeLengthError(
            "16 bytes".to_owned(),
            value.len(),
        ));
    }
    packet.add(AVP::from_bytes(ARAP_PASSWORD_TYPE, value));
    Ok(())
}
/// Lookup a `arap_password` fixed-length octets value from a packet.
///
/// It returns the first looked up value. If there is no associated value with `arap_password`, it returns `None`.
pub fn lookup_arap_password(packet: &Packet) -> Option<Vec<u8>> {
    packet.lookup(ARAP_PASSWORD_TYPE).map(|v| v.encode_bytes())
}
/// Lookup all of the `arap_password` fixed-length octets value from a packet.
pub fn lookup_all_arap_password(packet: &Packet) -> Vec<Vec<u8>> {
    let mut vec = Vec::new();
    for avp in packet.lookup_all(ARAP_PASSWORD_TYPE) {
        vec.push(avp.encode_bytes())
    }
    vec
}

pub const ARAP_FEATURES_TYPE: AVPType = 71;
/// Delete all of `arap_features` values from a packet.
pub fn delete_arap_features(packet: &mut Packet) {
    packet.delete(ARAP_FEATURES_TYPE);
}
/// Add `arap_features` fixed-length octets value to a packet.
pub fn add_arap_features(packet: &mut Packet, value: &[u8]) -> Result<(), AVPError> {
    if value.len() != 14 {
        return Err(AVPError::InvalidAttributeLengthError(
            "14 bytes".to_owned(),
            value.len(),
        ));
    }
    packet.add(AVP::from_bytes(ARAP_FEATURES_TYPE, value));
    Ok(())
}
/// Lookup a `arap_features` fixed-length octets value from a packet.
///
/// It returns the first looked up value. If there is no associated value with `arap_features`, it returns `None`.
pub fn lookup_arap_features(packet: &Packet) -> Option<Vec<u8>> {
    packet.lookup(ARAP_FEATURES_TYPE).map(|v| v.encode_bytes())
}
/// Lookup all of the `arap_features` fixed-length octets value from a packet.
pub fn lookup_all_arap_features(packet: &Packet) -> Vec<Vec<u8>> {
    let mut vec = Vec::new();
    for avp in packet.lookup_all(ARAP_FEATURES_TYPE) {
        vec.push(avp.encode_bytes())
    }
    vec
}

pub const ARAP_ZONE_ACCESS_TYPE: AVPType = 72;
/// Delete all of `arap_zone_access` values from a packet.
pub fn delete_arap_zone_access(packet: &mut Packet) {
    packet.delete(ARAP_ZONE_ACCESS_TYPE);
}
/// Add `arap_zone_access` value-defined integer value to a packet.
pub fn add_arap_zone_access(packet: &mut Packet, value: ArapZoneAccess) {
    packet.add(AVP::from_u32(ARAP_ZONE_ACCESS_TYPE, value as u32));
}
/// Lookup a `arap_zone_access` value-defined integer value from a packet.
///
/// It returns the first looked up value. If there is no associated value with `arap_zone_access`, it returns `None`.
pub fn lookup_arap_zone_access(packet: &Packet) -> Option<Result<ArapZoneAccess, AVPError>> {
    packet
        .lookup(ARAP_ZONE_ACCESS_TYPE)
        .map(|v| Ok(v.encode_u32()? as ArapZoneAccess))
}
/// Lookup all of the `arap_zone_access` value-defined integer value from a packet.
pub fn lookup_all_arap_zone_access(packet: &Packet) -> Result<Vec<ArapZoneAccess>, AVPError> {
    let mut vec = Vec::new();
    for avp in packet.lookup_all(ARAP_ZONE_ACCESS_TYPE) {
        vec.push(avp.encode_u32()? as ArapZoneAccess)
    }
    Ok(vec)
}

pub const ARAP_SECURITY_TYPE: AVPType = 73;
/// Delete all of `arap_security` values from a packet.
pub fn delete_arap_security(packet: &mut Packet) {
    packet.delete(ARAP_SECURITY_TYPE);
}
/// Add `arap_security` integer value to a packet.
pub fn add_arap_security(packet: &mut Packet, value: u32) {
    packet.add(AVP::from_u32(ARAP_SECURITY_TYPE, value));
}
/// Lookup a `arap_security` integer value from a packet.
///
/// It returns the first looked up value. If there is no associated value with `arap_security`, it returns `None`.
pub fn lookup_arap_security(packet: &Packet) -> Option<Result<u32, AVPError>> {
    packet.lookup(ARAP_SECURITY_TYPE).map(|v| v.encode_u32())
}
/// Lookup all of the `arap_security` integer value from a packet.
pub fn lookup_all_arap_security(packet: &Packet) -> Result<Vec<u32>, AVPError> {
    let mut vec = Vec::new();
    for avp in packet.lookup_all(ARAP_SECURITY_TYPE) {
        vec.push(avp.encode_u32()?)
    }
    Ok(vec)
}

pub const ARAP_SECURITY_DATA_TYPE: AVPType = 74;
/// Delete all of `arap_security_data` values from a packet.
pub fn delete_arap_security_data(packet: &mut Packet) {
    packet.delete(ARAP_SECURITY_DATA_TYPE);
}
/// Add `arap_security_data` string value to a packet.
pub fn add_arap_security_data(packet: &mut Packet, value: &str) {
    packet.add(AVP::from_string(ARAP_SECURITY_DATA_TYPE, value));
}
/// Lookup a `arap_security_data` string value from a packet.
///
/// It returns the first looked up value. If there is no associated value with `arap_security_data`, it returns `None`.
pub fn lookup_arap_security_data(packet: &Packet) -> Option<Result<String, AVPError>> {
    packet
        .lookup(ARAP_SECURITY_DATA_TYPE)
        .map(|v| v.encode_string())
}
/// Lookup all of the `arap_security_data` string value from a packet.
pub fn lookup_all_arap_security_data(packet: &Packet) -> Result<Vec<String>, AVPError> {
    let mut vec = Vec::new();
    for avp in packet.lookup_all(ARAP_SECURITY_DATA_TYPE) {
        vec.push(avp.encode_string()?)
    }
    Ok(vec)
}

pub const PASSWORD_RETRY_TYPE: AVPType = 75;
/// Delete all of `password_retry` values from a packet.
pub fn delete_password_retry(packet: &mut Packet) {
    packet.delete(PASSWORD_RETRY_TYPE);
}
/// Add `password_retry` integer value to a packet.
pub fn add_password_retry(packet: &mut Packet, value: u32) {
    packet.add(AVP::from_u32(PASSWORD_RETRY_TYPE, value));
}
/// Lookup a `password_retry` integer value from a packet.
///
/// It returns the first looked up value. If there is no associated value with `password_retry`, it returns `None`.
pub fn lookup_password_retry(packet: &Packet) -> Option<Result<u32, AVPError>> {
    packet.lookup(PASSWORD_RETRY_TYPE).map(|v| v.encode_u32())
}
/// Lookup all of the `password_retry` integer value from a packet.
pub fn lookup_all_password_retry(packet: &Packet) -> Result<Vec<u32>, AVPError> {
    let mut vec = Vec::new();
    for avp in packet.lookup_all(PASSWORD_RETRY_TYPE) {
        vec.push(avp.encode_u32()?)
    }
    Ok(vec)
}

pub const PROMPT_TYPE: AVPType = 76;
/// Delete all of `prompt` values from a packet.
pub fn delete_prompt(packet: &mut Packet) {
    packet.delete(PROMPT_TYPE);
}
/// Add `prompt` value-defined integer value to a packet.
pub fn add_prompt(packet: &mut Packet, value: Prompt) {
    packet.add(AVP::from_u32(PROMPT_TYPE, value as u32));
}
/// Lookup a `prompt` value-defined integer value from a packet.
///
/// It returns the first looked up value. If there is no associated value with `prompt`, it returns `None`.
pub fn lookup_prompt(packet: &Packet) -> Option<Result<Prompt, AVPError>> {
    packet
        .lookup(PROMPT_TYPE)
        .map(|v| Ok(v.encode_u32()? as Prompt))
}
/// Lookup all of the `prompt` value-defined integer value from a packet.
pub fn lookup_all_prompt(packet: &Packet) -> Result<Vec<Prompt>, AVPError> {
    let mut vec = Vec::new();
    for avp in packet.lookup_all(PROMPT_TYPE) {
        vec.push(avp.encode_u32()? as Prompt)
    }
    Ok(vec)
}

pub const CONNECT_INFO_TYPE: AVPType = 77;
/// Delete all of `connect_info` values from a packet.
pub fn delete_connect_info(packet: &mut Packet) {
    packet.delete(CONNECT_INFO_TYPE);
}
/// Add `connect_info` string value to a packet.
pub fn add_connect_info(packet: &mut Packet, value: &str) {
    packet.add(AVP::from_string(CONNECT_INFO_TYPE, value));
}
/// Lookup a `connect_info` string value from a packet.
///
/// It returns the first looked up value. If there is no associated value with `connect_info`, it returns `None`.
pub fn lookup_connect_info(packet: &Packet) -> Option<Result<String, AVPError>> {
    packet.lookup(CONNECT_INFO_TYPE).map(|v| v.encode_string())
}
/// Lookup all of the `connect_info` string value from a packet.
pub fn lookup_all_connect_info(packet: &Packet) -> Result<Vec<String>, AVPError> {
    let mut vec = Vec::new();
    for avp in packet.lookup_all(CONNECT_INFO_TYPE) {
        vec.push(avp.encode_string()?)
    }
    Ok(vec)
}

pub const CONFIGURATION_TOKEN_TYPE: AVPType = 78;
/// Delete all of `configuration_token` values from a packet.
pub fn delete_configuration_token(packet: &mut Packet) {
    packet.delete(CONFIGURATION_TOKEN_TYPE);
}
/// Add `configuration_token` string value to a packet.
pub fn add_configuration_token(packet: &mut Packet, value: &str) {
    packet.add(AVP::from_string(CONFIGURATION_TOKEN_TYPE, value));
}
/// Lookup a `configuration_token` string value from a packet.
///
/// It returns the first looked up value. If there is no associated value with `configuration_token`, it returns `None`.
pub fn lookup_configuration_token(packet: &Packet) -> Option<Result<String, AVPError>> {
    packet
        .lookup(CONFIGURATION_TOKEN_TYPE)
        .map(|v| v.encode_string())
}
/// Lookup all of the `configuration_token` string value from a packet.
pub fn lookup_all_configuration_token(packet: &Packet) -> Result<Vec<String>, AVPError> {
    let mut vec = Vec::new();
    for avp in packet.lookup_all(CONFIGURATION_TOKEN_TYPE) {
        vec.push(avp.encode_string()?)
    }
    Ok(vec)
}

pub const EAP_MESSAGE_TYPE: AVPType = 79;
/// Delete all of `eap_message` values from a packet.
pub fn delete_eap_message(packet: &mut Packet) {
    packet.delete(EAP_MESSAGE_TYPE);
}
pub fn add_eap_message(packet: &mut Packet, value: &[u8]) {
    packet.extend(
        value
            .chunks(253)
            .map(|chunk| AVP::from_bytes(EAP_MESSAGE_TYPE, chunk))
            .collect(),
    );
}
pub fn lookup_eap_message(packet: &Packet) -> Option<Vec<u8>> {
    let avps = packet.lookup_all(EAP_MESSAGE_TYPE);
    match avps.is_empty() {
        true => None,
        false => Some(avps.into_iter().fold(Vec::new(), |mut acc, v| {
            acc.extend(v.encode_bytes());
            acc
        })),
    }
}

pub const MESSAGE_AUTHENTICATOR_TYPE: AVPType = 80;
/// Delete all of `message_authenticator` values from a packet.
pub fn delete_message_authenticator(packet: &mut Packet) {
    packet.delete(MESSAGE_AUTHENTICATOR_TYPE);
}
/// Add `message_authenticator` octets value to a packet.
pub fn add_message_authenticator(packet: &mut Packet, value: &[u8]) {
    packet.add(AVP::from_bytes(MESSAGE_AUTHENTICATOR_TYPE, value));
}
/// Lookup a `message_authenticator` octets value from a packet.
///
/// It returns the first looked up value. If there is no associated value with `message_authenticator`, it returns `None`.
pub fn lookup_message_authenticator(packet: &Packet) -> Option<Vec<u8>> {
    packet
        .lookup(MESSAGE_AUTHENTICATOR_TYPE)
        .map(|v| v.encode_bytes())
}
/// Lookup all of the `message_authenticator` octets value from a packet.
pub fn lookup_all_message_authenticator(packet: &Packet) -> Vec<Vec<u8>> {
    let mut vec = Vec::new();
    for avp in packet.lookup_all(MESSAGE_AUTHENTICATOR_TYPE) {
        vec.push(avp.encode_bytes())
    }
    vec
}

pub const ARAP_CHALLENGE_RESPONSE_TYPE: AVPType = 84;
/// Delete all of `arap_challenge_response` values from a packet.
pub fn delete_arap_challenge_response(packet: &mut Packet) {
    packet.delete(ARAP_CHALLENGE_RESPONSE_TYPE);
}
/// Add `arap_challenge_response` fixed-length octets value to a packet.
pub fn add_arap_challenge_response(packet: &mut Packet, value: &[u8]) -> Result<(), AVPError> {
    if value.len() != 8 {
        return Err(AVPError::InvalidAttributeLengthError(
            "8 bytes".to_owned(),
            value.len(),
        ));
    }
    packet.add(AVP::from_bytes(ARAP_CHALLENGE_RESPONSE_TYPE, value));
    Ok(())
}
/// Lookup a `arap_challenge_response` fixed-length octets value from a packet.
///
/// It returns the first looked up value. If there is no associated value with `arap_challenge_response`, it returns `None`.
pub fn lookup_arap_challenge_response(packet: &Packet) -> Option<Vec<u8>> {
    packet
        .lookup(ARAP_CHALLENGE_RESPONSE_TYPE)
        .map(|v| v.encode_bytes())
}
/// Lookup all of the `arap_challenge_response` fixed-length octets value from a packet.
pub fn lookup_all_arap_challenge_response(packet: &Packet) -> Vec<Vec<u8>> {
    let mut vec = Vec::new();
    for avp in packet.lookup_all(ARAP_CHALLENGE_RESPONSE_TYPE) {
        vec.push(avp.encode_bytes())
    }
    vec
}

pub const ACCT_INTERIM_INTERVAL_TYPE: AVPType = 85;
/// Delete all of `acct_interim_interval` values from a packet.
pub fn delete_acct_interim_interval(packet: &mut Packet) {
    packet.delete(ACCT_INTERIM_INTERVAL_TYPE);
}
/// Add `acct_interim_interval` integer value to a packet.
pub fn add_acct_interim_interval(packet: &mut Packet, value: u32) {
    packet.add(AVP::from_u32(ACCT_INTERIM_INTERVAL_TYPE, value));
}
/// Lookup a `acct_interim_interval` integer value from a packet.
///
/// It returns the first looked up value. If there is no associated value with `acct_interim_interval`, it returns `None`.
pub fn lookup_acct_interim_interval(packet: &Packet) -> Option<Result<u32, AVPError>> {
    packet
        .lookup(ACCT_INTERIM_INTERVAL_TYPE)
        .map(|v| v.encode_u32())
}
/// Lookup all of the `acct_interim_interval` integer value from a packet.
pub fn lookup_all_acct_interim_interval(packet: &Packet) -> Result<Vec<u32>, AVPError> {
    let mut vec = Vec::new();
    for avp in packet.lookup_all(ACCT_INTERIM_INTERVAL_TYPE) {
        vec.push(avp.encode_u32()?)
    }
    Ok(vec)
}

pub const NAS_PORT_ID_TYPE: AVPType = 87;
/// Delete all of `nas_port_id` values from a packet.
pub fn delete_nas_port_id(packet: &mut Packet) {
    packet.delete(NAS_PORT_ID_TYPE);
}
/// Add `nas_port_id` string value to a packet.
pub fn add_nas_port_id(packet: &mut Packet, value: &str) {
    packet.add(AVP::from_string(NAS_PORT_ID_TYPE, value));
}
/// Lookup a `nas_port_id` string value from a packet.
///
/// It returns the first looked up value. If there is no associated value with `nas_port_id`, it returns `None`.
pub fn lookup_nas_port_id(packet: &Packet) -> Option<Result<String, AVPError>> {
    packet.lookup(NAS_PORT_ID_TYPE).map(|v| v.encode_string())
}
/// Lookup all of the `nas_port_id` string value from a packet.
pub fn lookup_all_nas_port_id(packet: &Packet) -> Result<Vec<String>, AVPError> {
    let mut vec = Vec::new();
    for avp in packet.lookup_all(NAS_PORT_ID_TYPE) {
        vec.push(avp.encode_string()?)
    }
    Ok(vec)
}

pub const FRAMED_POOL_TYPE: AVPType = 88;
/// Delete all of `framed_pool` values from a packet.
pub fn delete_framed_pool(packet: &mut Packet) {
    packet.delete(FRAMED_POOL_TYPE);
}
/// Add `framed_pool` string value to a packet.
pub fn add_framed_pool(packet: &mut Packet, value: &str) {
    packet.add(AVP::from_string(FRAMED_POOL_TYPE, value));
}
/// Lookup a `framed_pool` string value from a packet.
///
/// It returns the first looked up value. If there is no associated value with `framed_pool`, it returns `None`.
pub fn lookup_framed_pool(packet: &Packet) -> Option<Result<String, AVPError>> {
    packet.lookup(FRAMED_POOL_TYPE).map(|v| v.encode_string())
}
/// Lookup all of the `framed_pool` string value from a packet.
pub fn lookup_all_framed_pool(packet: &Packet) -> Result<Vec<String>, AVPError> {
    let mut vec = Vec::new();
    for avp in packet.lookup_all(FRAMED_POOL_TYPE) {
        vec.push(avp.encode_string()?)
    }
    Ok(vec)
}

pub type ArapZoneAccess = u32;
pub const ARAP_ZONE_ACCESS_DEFAULT_ZONE: ArapZoneAccess = 1;
pub const ARAP_ZONE_ACCESS_ZONE_FILTER_INCLUSIVE: ArapZoneAccess = 2;
pub const ARAP_ZONE_ACCESS_ZONE_FILTER_EXCLUSIVE: ArapZoneAccess = 4;

pub type Prompt = u32;
pub const PROMPT_NO_ECHO: Prompt = 0;
pub const PROMPT_ECHO: Prompt = 1;
