// Code generated by machine generator; DO NOT EDIT.

//! Utility for rfc2867 packet.
//!
//! This module handles the packet according to the following definition:
//! ```text
//! //! # -*- text -*-
//! # Copyright (C) 2020 The FreeRADIUS Server project and contributors
//! # This work is licensed under CC-BY version 4.0 https://creativecommons.org/licenses/by/4.0
//! # Version $Id$
//! #
//! #    Attributes and values defined in RFC 2867.
//! #    http://www.ietf.org/rfc/rfc2867.txt
//! #
//! #    $Id$
//! #
//! ATTRIBUTE    Acct-Tunnel-Connection            68    string
//! ATTRIBUTE    Acct-Tunnel-Packets-Lost        86    integer
//!
//! VALUE    Acct-Status-Type        Tunnel-Start        9
//! VALUE    Acct-Status-Type        Tunnel-Stop        10
//! VALUE    Acct-Status-Type        Tunnel-Reject        11
//! VALUE    Acct-Status-Type        Tunnel-Link-Start    12
//! VALUE    Acct-Status-Type        Tunnel-Link-Stop    13
//! VALUE    Acct-Status-Type        Tunnel-Link-Reject    14
//! ```

use crate::core::avp::{AVPError, AVPType, AVP};
use crate::core::packet::Packet;

use crate::core::rfc2866;

pub const ACCT_TUNNEL_CONNECTION_TYPE: AVPType = 68;
/// Delete all of `acct_tunnel_connection` values from a packet.
pub fn delete_acct_tunnel_connection(packet: &mut Packet) {
    packet.delete(ACCT_TUNNEL_CONNECTION_TYPE);
}
/// Add `acct_tunnel_connection` string value to a packet.
pub fn add_acct_tunnel_connection(packet: &mut Packet, value: &str) {
    packet.add(AVP::from_string(ACCT_TUNNEL_CONNECTION_TYPE, value));
}
/// Lookup a `acct_tunnel_connection` string value from a packet.
///
/// It returns the first looked up value. If there is no associated value with `acct_tunnel_connection`, it returns `None`.
pub fn lookup_acct_tunnel_connection(packet: &Packet) -> Option<Result<String, AVPError>> {
    packet
        .lookup(ACCT_TUNNEL_CONNECTION_TYPE)
        .map(|v| v.encode_string())
}
/// Lookup all of the `acct_tunnel_connection` string value from a packet.
pub fn lookup_all_acct_tunnel_connection(packet: &Packet) -> Result<Vec<String>, AVPError> {
    let mut vec = Vec::new();
    for avp in packet.lookup_all(ACCT_TUNNEL_CONNECTION_TYPE) {
        vec.push(avp.encode_string()?)
    }
    Ok(vec)
}

pub const ACCT_TUNNEL_PACKETS_LOST_TYPE: AVPType = 86;
/// Delete all of `acct_tunnel_packets_lost` values from a packet.
pub fn delete_acct_tunnel_packets_lost(packet: &mut Packet) {
    packet.delete(ACCT_TUNNEL_PACKETS_LOST_TYPE);
}
/// Add `acct_tunnel_packets_lost` integer value to a packet.
pub fn add_acct_tunnel_packets_lost(packet: &mut Packet, value: u32) {
    packet.add(AVP::from_u32(ACCT_TUNNEL_PACKETS_LOST_TYPE, value));
}
/// Lookup a `acct_tunnel_packets_lost` integer value from a packet.
///
/// It returns the first looked up value. If there is no associated value with `acct_tunnel_packets_lost`, it returns `None`.
pub fn lookup_acct_tunnel_packets_lost(packet: &Packet) -> Option<Result<u32, AVPError>> {
    packet
        .lookup(ACCT_TUNNEL_PACKETS_LOST_TYPE)
        .map(|v| v.encode_u32())
}
/// Lookup all of the `acct_tunnel_packets_lost` integer value from a packet.
pub fn lookup_all_acct_tunnel_packets_lost(packet: &Packet) -> Result<Vec<u32>, AVPError> {
    let mut vec = Vec::new();
    for avp in packet.lookup_all(ACCT_TUNNEL_PACKETS_LOST_TYPE) {
        vec.push(avp.encode_u32()?)
    }
    Ok(vec)
}
pub const ACCT_STATUS_TYPE_TUNNEL_START: rfc2866::AcctStatusType = 9;
pub const ACCT_STATUS_TYPE_TUNNEL_STOP: rfc2866::AcctStatusType = 10;
pub const ACCT_STATUS_TYPE_TUNNEL_REJECT: rfc2866::AcctStatusType = 11;
pub const ACCT_STATUS_TYPE_TUNNEL_LINK_START: rfc2866::AcctStatusType = 12;
pub const ACCT_STATUS_TYPE_TUNNEL_LINK_STOP: rfc2866::AcctStatusType = 13;
pub const ACCT_STATUS_TYPE_TUNNEL_LINK_REJECT: rfc2866::AcctStatusType = 14;
