// Code generated by machine generator; DO NOT EDIT.

//! Utility for rfc2865 packet.
//!
//! This module handles the packet according to the following definition:
//! ```text
//! //! # -*- text -*-
//! # Copyright (C) 2020 The FreeRADIUS Server project and contributors
//! # This work is licensed under CC-BY version 4.0 https://creativecommons.org/licenses/by/4.0
//! # Version $Id$
//! #
//! #    Attributes and values defined in RFC 2865.
//! #    http://www.ietf.org/rfc/rfc2865.txt
//! #
//! #    $Id$
//! #
//! ATTRIBUTE    User-Name                1    string
//! ATTRIBUTE    User-Password                2    string    encrypt=1
//! ATTRIBUTE    CHAP-Password                3    octets
//! ATTRIBUTE    NAS-IP-Address                4    ipaddr
//! ATTRIBUTE    NAS-Port                5    integer
//! ATTRIBUTE    Service-Type                6    integer
//! ATTRIBUTE    Framed-Protocol                7    integer
//! ATTRIBUTE    Framed-IP-Address            8    ipaddr
//! ATTRIBUTE    Framed-IP-Netmask            9    ipaddr
//! ATTRIBUTE    Framed-Routing                10    integer
//! ATTRIBUTE    Filter-Id                11    string
//! ATTRIBUTE    Framed-MTU                12    integer
//! ATTRIBUTE    Framed-Compression            13    integer
//! ATTRIBUTE    Login-IP-Host                14    ipaddr
//! ATTRIBUTE    Login-Service                15    integer
//! ATTRIBUTE    Login-TCP-Port                16    integer
//! # Attribute 17 is undefined
//! ATTRIBUTE    Reply-Message                18    string
//! ATTRIBUTE    Callback-Number                19    string
//! ATTRIBUTE    Callback-Id                20    string
//! # Attribute 21 is undefined
//! ATTRIBUTE    Framed-Route                22    string
//! ATTRIBUTE    Framed-IPX-Network            23    ipaddr
//! ATTRIBUTE    State                    24    octets
//! ATTRIBUTE    Class                    25    octets
//! ATTRIBUTE    Vendor-Specific                26    vsa
//! ATTRIBUTE    Session-Timeout                27    integer
//! ATTRIBUTE    Idle-Timeout                28    integer
//! ATTRIBUTE    Termination-Action            29    integer
//! ATTRIBUTE    Called-Station-Id            30    string
//! ATTRIBUTE    Calling-Station-Id            31    string
//! ATTRIBUTE    NAS-Identifier                32    string
//! ATTRIBUTE    Proxy-State                33    octets
//! ATTRIBUTE    Login-LAT-Service            34    string
//! ATTRIBUTE    Login-LAT-Node                35    string
//! ATTRIBUTE    Login-LAT-Group                36    octets
//! ATTRIBUTE    Framed-AppleTalk-Link            37    integer
//! ATTRIBUTE    Framed-AppleTalk-Network        38    integer
//! ATTRIBUTE    Framed-AppleTalk-Zone            39    string
//!
//! ATTRIBUTE    CHAP-Challenge                60    octets
//! ATTRIBUTE    NAS-Port-Type                61    integer
//! ATTRIBUTE    Port-Limit                62    integer
//! ATTRIBUTE    Login-LAT-Port                63    string
//!
//! #
//! #    Integer Translations
//! #
//!
//! #    Service types
//!
//! VALUE    Service-Type            Login-User        1
//! VALUE    Service-Type            Framed-User        2
//! VALUE    Service-Type            Callback-Login-User    3
//! VALUE    Service-Type            Callback-Framed-User    4
//! VALUE    Service-Type            Outbound-User        5
//! VALUE    Service-Type            Administrative-User    6
//! VALUE    Service-Type            NAS-Prompt-User        7
//! VALUE    Service-Type            Authenticate-Only    8
//! VALUE    Service-Type            Callback-NAS-Prompt    9
//! VALUE    Service-Type            Call-Check        10
//! VALUE    Service-Type            Callback-Administrative    11
//!
//! #    Framed Protocols
//!
//! VALUE    Framed-Protocol            PPP            1
//! VALUE    Framed-Protocol            SLIP            2
//! VALUE    Framed-Protocol            ARAP            3
//! VALUE    Framed-Protocol            Gandalf-SLML        4
//! VALUE    Framed-Protocol            Xylogics-IPX-SLIP    5
//! VALUE    Framed-Protocol            X.75-Synchronous    6
//!
//! #    Framed Routing Values
//!
//! VALUE    Framed-Routing            None            0
//! VALUE    Framed-Routing            Broadcast        1
//! VALUE    Framed-Routing            Listen            2
//! VALUE    Framed-Routing            Broadcast-Listen    3
//!
//! #    Framed Compression Types
//!
//! VALUE    Framed-Compression        None            0
//! VALUE    Framed-Compression        Van-Jacobson-TCP-IP    1
//! VALUE    Framed-Compression        IPX-Header-Compression    2
//! VALUE    Framed-Compression        Stac-LZS        3
//!
//! #    Login Services
//!
//! VALUE    Login-Service            Telnet            0
//! VALUE    Login-Service            Rlogin            1
//! VALUE    Login-Service            TCP-Clear        2
//! VALUE    Login-Service            PortMaster        3
//! VALUE    Login-Service            LAT            4
//! VALUE    Login-Service            X25-PAD            5
//! VALUE    Login-Service            X25-T3POS        6
//! VALUE    Login-Service            TCP-Clear-Quiet        8
//!
//! #    Login-TCP-Port        (see /etc/services for more examples)
//!
//! VALUE    Login-TCP-Port            Telnet            23
//! VALUE    Login-TCP-Port            Rlogin            513
//! VALUE    Login-TCP-Port            Rsh            514
//!
//! #    Termination Options
//!
//! VALUE    Termination-Action        Default            0
//! VALUE    Termination-Action        RADIUS-Request        1
//!
//! #    NAS Port Types
//!
//! VALUE    NAS-Port-Type            Async            0
//! VALUE    NAS-Port-Type            Sync            1
//! VALUE    NAS-Port-Type            ISDN            2
//! VALUE    NAS-Port-Type            ISDN-V120        3
//! VALUE    NAS-Port-Type            ISDN-V110        4
//! VALUE    NAS-Port-Type            Virtual            5
//! VALUE    NAS-Port-Type            PIAFS            6
//! VALUE    NAS-Port-Type            HDLC-Clear-Channel    7
//! VALUE    NAS-Port-Type            X.25            8
//! VALUE    NAS-Port-Type            X.75            9
//! VALUE    NAS-Port-Type            G.3-Fax            10
//! VALUE    NAS-Port-Type            SDSL            11
//! VALUE    NAS-Port-Type            ADSL-CAP        12
//! VALUE    NAS-Port-Type            ADSL-DMT        13
//! VALUE    NAS-Port-Type            IDSL            14
//! VALUE    NAS-Port-Type            Ethernet        15
//! VALUE    NAS-Port-Type            xDSL            16
//! VALUE    NAS-Port-Type            Cable            17
//! VALUE    NAS-Port-Type            Wireless-Other        18
//! VALUE    NAS-Port-Type            Wireless-802.11        19
//! ```

use std::net::Ipv4Addr;

use crate::core::avp::{AVPError, AVPType, AVP};
use crate::core::packet::Packet;

pub const USER_NAME_TYPE: AVPType = 1;
/// Delete all of `user_name` values from a packet.
pub fn delete_user_name(packet: &mut Packet) {
    packet.delete(USER_NAME_TYPE);
}
/// Add `user_name` string value to a packet.
pub fn add_user_name(packet: &mut Packet, value: &str) {
    packet.add(AVP::from_string(USER_NAME_TYPE, value));
}
/// Lookup a `user_name` string value from a packet.
///
/// It returns the first looked up value. If there is no associated value with `user_name`, it returns `None`.
pub fn lookup_user_name(packet: &Packet) -> Option<Result<String, AVPError>> {
    packet.lookup(USER_NAME_TYPE).map(|v| v.encode_string())
}
/// Lookup all of the `user_name` string value from a packet.
pub fn lookup_all_user_name(packet: &Packet) -> Result<Vec<String>, AVPError> {
    let mut vec = Vec::new();
    for avp in packet.lookup_all(USER_NAME_TYPE) {
        vec.push(avp.encode_string()?)
    }
    Ok(vec)
}

pub const USER_PASSWORD_TYPE: AVPType = 2;
/// Delete all of `user_password` values from a packet.
pub fn delete_user_password(packet: &mut Packet) {
    packet.delete(USER_PASSWORD_TYPE);
}
/// Add `user_password` user-password value to a packet.
pub fn add_user_password(packet: &mut Packet, value: &[u8]) -> Result<(), AVPError> {
    packet.add(AVP::from_user_password(
        USER_PASSWORD_TYPE,
        value,
        packet.get_secret(),
        packet.get_authenticator(),
    )?);
    Ok(())
}
/// Lookup a `user_password` user-password value from a packet.
///
/// It returns the first looked up value. If there is no associated value with `user_password`, it returns `None`.
pub fn lookup_user_password(packet: &Packet) -> Option<Result<Vec<u8>, AVPError>> {
    packet
        .lookup(USER_PASSWORD_TYPE)
        .map(|v| v.encode_user_password(packet.get_secret(), packet.get_authenticator()))
}
/// Lookup all of the `user_password` user-password value from a packet.
pub fn lookup_all_user_password(packet: &Packet) -> Result<Vec<Vec<u8>>, AVPError> {
    let mut vec = Vec::new();
    for avp in packet.lookup_all(USER_PASSWORD_TYPE) {
        vec.push(avp.encode_user_password(packet.get_secret(), packet.get_authenticator())?)
    }
    Ok(vec)
}

pub const CHAP_PASSWORD_TYPE: AVPType = 3;
/// Delete all of `chap_password` values from a packet.
pub fn delete_chap_password(packet: &mut Packet) {
    packet.delete(CHAP_PASSWORD_TYPE);
}
/// Add `chap_password` octets value to a packet.
pub fn add_chap_password(packet: &mut Packet, value: &[u8]) {
    packet.add(AVP::from_bytes(CHAP_PASSWORD_TYPE, value));
}
/// Lookup a `chap_password` octets value from a packet.
///
/// It returns the first looked up value. If there is no associated value with `chap_password`, it returns `None`.
pub fn lookup_chap_password(packet: &Packet) -> Option<Vec<u8>> {
    packet.lookup(CHAP_PASSWORD_TYPE).map(|v| v.encode_bytes())
}
/// Lookup all of the `chap_password` octets value from a packet.
pub fn lookup_all_chap_password(packet: &Packet) -> Vec<Vec<u8>> {
    let mut vec = Vec::new();
    for avp in packet.lookup_all(CHAP_PASSWORD_TYPE) {
        vec.push(avp.encode_bytes())
    }
    vec
}

pub const NAS_IP_ADDRESS_TYPE: AVPType = 4;
/// Delete all of `nas_ip_address` values from a packet.
pub fn delete_nas_ip_address(packet: &mut Packet) {
    packet.delete(NAS_IP_ADDRESS_TYPE);
}
/// Add `nas_ip_address` ipaddr value to a packet.
pub fn add_nas_ip_address(packet: &mut Packet, value: &Ipv4Addr) {
    packet.add(AVP::from_ipv4(NAS_IP_ADDRESS_TYPE, value));
}
/// Lookup a `nas_ip_address` ipaddr value from a packet.
///
/// It returns the first looked up value. If there is no associated value with `nas_ip_address`, it returns `None`.
pub fn lookup_nas_ip_address(packet: &Packet) -> Option<Result<Ipv4Addr, AVPError>> {
    packet.lookup(NAS_IP_ADDRESS_TYPE).map(|v| v.encode_ipv4())
}
/// Lookup all of the `nas_ip_address` ipaddr value from a packet.
pub fn lookup_all_nas_ip_address(packet: &Packet) -> Result<Vec<Ipv4Addr>, AVPError> {
    let mut vec = Vec::new();
    for avp in packet.lookup_all(NAS_IP_ADDRESS_TYPE) {
        vec.push(avp.encode_ipv4()?)
    }
    Ok(vec)
}

pub const NAS_PORT_TYPE: AVPType = 5;
/// Delete all of `nas_port` values from a packet.
pub fn delete_nas_port(packet: &mut Packet) {
    packet.delete(NAS_PORT_TYPE);
}
/// Add `nas_port` integer value to a packet.
pub fn add_nas_port(packet: &mut Packet, value: u32) {
    packet.add(AVP::from_u32(NAS_PORT_TYPE, value));
}
/// Lookup a `nas_port` integer value from a packet.
///
/// It returns the first looked up value. If there is no associated value with `nas_port`, it returns `None`.
pub fn lookup_nas_port(packet: &Packet) -> Option<Result<u32, AVPError>> {
    packet.lookup(NAS_PORT_TYPE).map(|v| v.encode_u32())
}
/// Lookup all of the `nas_port` integer value from a packet.
pub fn lookup_all_nas_port(packet: &Packet) -> Result<Vec<u32>, AVPError> {
    let mut vec = Vec::new();
    for avp in packet.lookup_all(NAS_PORT_TYPE) {
        vec.push(avp.encode_u32()?)
    }
    Ok(vec)
}

pub const SERVICE_TYPE_TYPE: AVPType = 6;
/// Delete all of `service_type` values from a packet.
pub fn delete_service_type(packet: &mut Packet) {
    packet.delete(SERVICE_TYPE_TYPE);
}
/// Add `service_type` value-defined integer value to a packet.
pub fn add_service_type(packet: &mut Packet, value: ServiceType) {
    packet.add(AVP::from_u32(SERVICE_TYPE_TYPE, value as u32));
}
/// Lookup a `service_type` value-defined integer value from a packet.
///
/// It returns the first looked up value. If there is no associated value with `service_type`, it returns `None`.
pub fn lookup_service_type(packet: &Packet) -> Option<Result<ServiceType, AVPError>> {
    packet
        .lookup(SERVICE_TYPE_TYPE)
        .map(|v| Ok(v.encode_u32()? as ServiceType))
}
/// Lookup all of the `service_type` value-defined integer value from a packet.
pub fn lookup_all_service_type(packet: &Packet) -> Result<Vec<ServiceType>, AVPError> {
    let mut vec = Vec::new();
    for avp in packet.lookup_all(SERVICE_TYPE_TYPE) {
        vec.push(avp.encode_u32()? as ServiceType)
    }
    Ok(vec)
}

pub const FRAMED_PROTOCOL_TYPE: AVPType = 7;
/// Delete all of `framed_protocol` values from a packet.
pub fn delete_framed_protocol(packet: &mut Packet) {
    packet.delete(FRAMED_PROTOCOL_TYPE);
}
/// Add `framed_protocol` value-defined integer value to a packet.
pub fn add_framed_protocol(packet: &mut Packet, value: FramedProtocol) {
    packet.add(AVP::from_u32(FRAMED_PROTOCOL_TYPE, value as u32));
}
/// Lookup a `framed_protocol` value-defined integer value from a packet.
///
/// It returns the first looked up value. If there is no associated value with `framed_protocol`, it returns `None`.
pub fn lookup_framed_protocol(packet: &Packet) -> Option<Result<FramedProtocol, AVPError>> {
    packet
        .lookup(FRAMED_PROTOCOL_TYPE)
        .map(|v| Ok(v.encode_u32()? as FramedProtocol))
}
/// Lookup all of the `framed_protocol` value-defined integer value from a packet.
pub fn lookup_all_framed_protocol(packet: &Packet) -> Result<Vec<FramedProtocol>, AVPError> {
    let mut vec = Vec::new();
    for avp in packet.lookup_all(FRAMED_PROTOCOL_TYPE) {
        vec.push(avp.encode_u32()? as FramedProtocol)
    }
    Ok(vec)
}

pub const FRAMED_IP_ADDRESS_TYPE: AVPType = 8;
/// Delete all of `framed_ip_address` values from a packet.
pub fn delete_framed_ip_address(packet: &mut Packet) {
    packet.delete(FRAMED_IP_ADDRESS_TYPE);
}
/// Add `framed_ip_address` ipaddr value to a packet.
pub fn add_framed_ip_address(packet: &mut Packet, value: &Ipv4Addr) {
    packet.add(AVP::from_ipv4(FRAMED_IP_ADDRESS_TYPE, value));
}
/// Lookup a `framed_ip_address` ipaddr value from a packet.
///
/// It returns the first looked up value. If there is no associated value with `framed_ip_address`, it returns `None`.
pub fn lookup_framed_ip_address(packet: &Packet) -> Option<Result<Ipv4Addr, AVPError>> {
    packet
        .lookup(FRAMED_IP_ADDRESS_TYPE)
        .map(|v| v.encode_ipv4())
}
/// Lookup all of the `framed_ip_address` ipaddr value from a packet.
pub fn lookup_all_framed_ip_address(packet: &Packet) -> Result<Vec<Ipv4Addr>, AVPError> {
    let mut vec = Vec::new();
    for avp in packet.lookup_all(FRAMED_IP_ADDRESS_TYPE) {
        vec.push(avp.encode_ipv4()?)
    }
    Ok(vec)
}

pub const FRAMED_IP_NETMASK_TYPE: AVPType = 9;
/// Delete all of `framed_ip_netmask` values from a packet.
pub fn delete_framed_ip_netmask(packet: &mut Packet) {
    packet.delete(FRAMED_IP_NETMASK_TYPE);
}
/// Add `framed_ip_netmask` ipaddr value to a packet.
pub fn add_framed_ip_netmask(packet: &mut Packet, value: &Ipv4Addr) {
    packet.add(AVP::from_ipv4(FRAMED_IP_NETMASK_TYPE, value));
}
/// Lookup a `framed_ip_netmask` ipaddr value from a packet.
///
/// It returns the first looked up value. If there is no associated value with `framed_ip_netmask`, it returns `None`.
pub fn lookup_framed_ip_netmask(packet: &Packet) -> Option<Result<Ipv4Addr, AVPError>> {
    packet
        .lookup(FRAMED_IP_NETMASK_TYPE)
        .map(|v| v.encode_ipv4())
}
/// Lookup all of the `framed_ip_netmask` ipaddr value from a packet.
pub fn lookup_all_framed_ip_netmask(packet: &Packet) -> Result<Vec<Ipv4Addr>, AVPError> {
    let mut vec = Vec::new();
    for avp in packet.lookup_all(FRAMED_IP_NETMASK_TYPE) {
        vec.push(avp.encode_ipv4()?)
    }
    Ok(vec)
}

pub const FRAMED_ROUTING_TYPE: AVPType = 10;
/// Delete all of `framed_routing` values from a packet.
pub fn delete_framed_routing(packet: &mut Packet) {
    packet.delete(FRAMED_ROUTING_TYPE);
}
/// Add `framed_routing` value-defined integer value to a packet.
pub fn add_framed_routing(packet: &mut Packet, value: FramedRouting) {
    packet.add(AVP::from_u32(FRAMED_ROUTING_TYPE, value as u32));
}
/// Lookup a `framed_routing` value-defined integer value from a packet.
///
/// It returns the first looked up value. If there is no associated value with `framed_routing`, it returns `None`.
pub fn lookup_framed_routing(packet: &Packet) -> Option<Result<FramedRouting, AVPError>> {
    packet
        .lookup(FRAMED_ROUTING_TYPE)
        .map(|v| Ok(v.encode_u32()? as FramedRouting))
}
/// Lookup all of the `framed_routing` value-defined integer value from a packet.
pub fn lookup_all_framed_routing(packet: &Packet) -> Result<Vec<FramedRouting>, AVPError> {
    let mut vec = Vec::new();
    for avp in packet.lookup_all(FRAMED_ROUTING_TYPE) {
        vec.push(avp.encode_u32()? as FramedRouting)
    }
    Ok(vec)
}

pub const FILTER_ID_TYPE: AVPType = 11;
/// Delete all of `filter_id` values from a packet.
pub fn delete_filter_id(packet: &mut Packet) {
    packet.delete(FILTER_ID_TYPE);
}
/// Add `filter_id` string value to a packet.
pub fn add_filter_id(packet: &mut Packet, value: &str) {
    packet.add(AVP::from_string(FILTER_ID_TYPE, value));
}
/// Lookup a `filter_id` string value from a packet.
///
/// It returns the first looked up value. If there is no associated value with `filter_id`, it returns `None`.
pub fn lookup_filter_id(packet: &Packet) -> Option<Result<String, AVPError>> {
    packet.lookup(FILTER_ID_TYPE).map(|v| v.encode_string())
}
/// Lookup all of the `filter_id` string value from a packet.
pub fn lookup_all_filter_id(packet: &Packet) -> Result<Vec<String>, AVPError> {
    let mut vec = Vec::new();
    for avp in packet.lookup_all(FILTER_ID_TYPE) {
        vec.push(avp.encode_string()?)
    }
    Ok(vec)
}

pub const FRAMED_MTU_TYPE: AVPType = 12;
/// Delete all of `framed_mtu` values from a packet.
pub fn delete_framed_mtu(packet: &mut Packet) {
    packet.delete(FRAMED_MTU_TYPE);
}
/// Add `framed_mtu` integer value to a packet.
pub fn add_framed_mtu(packet: &mut Packet, value: u32) {
    packet.add(AVP::from_u32(FRAMED_MTU_TYPE, value));
}
/// Lookup a `framed_mtu` integer value from a packet.
///
/// It returns the first looked up value. If there is no associated value with `framed_mtu`, it returns `None`.
pub fn lookup_framed_mtu(packet: &Packet) -> Option<Result<u32, AVPError>> {
    packet.lookup(FRAMED_MTU_TYPE).map(|v| v.encode_u32())
}
/// Lookup all of the `framed_mtu` integer value from a packet.
pub fn lookup_all_framed_mtu(packet: &Packet) -> Result<Vec<u32>, AVPError> {
    let mut vec = Vec::new();
    for avp in packet.lookup_all(FRAMED_MTU_TYPE) {
        vec.push(avp.encode_u32()?)
    }
    Ok(vec)
}

pub const FRAMED_COMPRESSION_TYPE: AVPType = 13;
/// Delete all of `framed_compression` values from a packet.
pub fn delete_framed_compression(packet: &mut Packet) {
    packet.delete(FRAMED_COMPRESSION_TYPE);
}
/// Add `framed_compression` value-defined integer value to a packet.
pub fn add_framed_compression(packet: &mut Packet, value: FramedCompression) {
    packet.add(AVP::from_u32(FRAMED_COMPRESSION_TYPE, value as u32));
}
/// Lookup a `framed_compression` value-defined integer value from a packet.
///
/// It returns the first looked up value. If there is no associated value with `framed_compression`, it returns `None`.
pub fn lookup_framed_compression(packet: &Packet) -> Option<Result<FramedCompression, AVPError>> {
    packet
        .lookup(FRAMED_COMPRESSION_TYPE)
        .map(|v| Ok(v.encode_u32()? as FramedCompression))
}
/// Lookup all of the `framed_compression` value-defined integer value from a packet.
pub fn lookup_all_framed_compression(packet: &Packet) -> Result<Vec<FramedCompression>, AVPError> {
    let mut vec = Vec::new();
    for avp in packet.lookup_all(FRAMED_COMPRESSION_TYPE) {
        vec.push(avp.encode_u32()? as FramedCompression)
    }
    Ok(vec)
}

pub const LOGIN_IP_HOST_TYPE: AVPType = 14;
/// Delete all of `login_ip_host` values from a packet.
pub fn delete_login_ip_host(packet: &mut Packet) {
    packet.delete(LOGIN_IP_HOST_TYPE);
}
/// Add `login_ip_host` ipaddr value to a packet.
pub fn add_login_ip_host(packet: &mut Packet, value: &Ipv4Addr) {
    packet.add(AVP::from_ipv4(LOGIN_IP_HOST_TYPE, value));
}
/// Lookup a `login_ip_host` ipaddr value from a packet.
///
/// It returns the first looked up value. If there is no associated value with `login_ip_host`, it returns `None`.
pub fn lookup_login_ip_host(packet: &Packet) -> Option<Result<Ipv4Addr, AVPError>> {
    packet.lookup(LOGIN_IP_HOST_TYPE).map(|v| v.encode_ipv4())
}
/// Lookup all of the `login_ip_host` ipaddr value from a packet.
pub fn lookup_all_login_ip_host(packet: &Packet) -> Result<Vec<Ipv4Addr>, AVPError> {
    let mut vec = Vec::new();
    for avp in packet.lookup_all(LOGIN_IP_HOST_TYPE) {
        vec.push(avp.encode_ipv4()?)
    }
    Ok(vec)
}

pub const LOGIN_SERVICE_TYPE: AVPType = 15;
/// Delete all of `login_service` values from a packet.
pub fn delete_login_service(packet: &mut Packet) {
    packet.delete(LOGIN_SERVICE_TYPE);
}
/// Add `login_service` value-defined integer value to a packet.
pub fn add_login_service(packet: &mut Packet, value: LoginService) {
    packet.add(AVP::from_u32(LOGIN_SERVICE_TYPE, value as u32));
}
/// Lookup a `login_service` value-defined integer value from a packet.
///
/// It returns the first looked up value. If there is no associated value with `login_service`, it returns `None`.
pub fn lookup_login_service(packet: &Packet) -> Option<Result<LoginService, AVPError>> {
    packet
        .lookup(LOGIN_SERVICE_TYPE)
        .map(|v| Ok(v.encode_u32()? as LoginService))
}
/// Lookup all of the `login_service` value-defined integer value from a packet.
pub fn lookup_all_login_service(packet: &Packet) -> Result<Vec<LoginService>, AVPError> {
    let mut vec = Vec::new();
    for avp in packet.lookup_all(LOGIN_SERVICE_TYPE) {
        vec.push(avp.encode_u32()? as LoginService)
    }
    Ok(vec)
}

pub const LOGIN_TCP_PORT_TYPE: AVPType = 16;
/// Delete all of `login_tcp_port` values from a packet.
pub fn delete_login_tcp_port(packet: &mut Packet) {
    packet.delete(LOGIN_TCP_PORT_TYPE);
}
/// Add `login_tcp_port` value-defined integer value to a packet.
pub fn add_login_tcp_port(packet: &mut Packet, value: LoginTCPPort) {
    packet.add(AVP::from_u32(LOGIN_TCP_PORT_TYPE, value as u32));
}
/// Lookup a `login_tcp_port` value-defined integer value from a packet.
///
/// It returns the first looked up value. If there is no associated value with `login_tcp_port`, it returns `None`.
pub fn lookup_login_tcp_port(packet: &Packet) -> Option<Result<LoginTCPPort, AVPError>> {
    packet
        .lookup(LOGIN_TCP_PORT_TYPE)
        .map(|v| Ok(v.encode_u32()? as LoginTCPPort))
}
/// Lookup all of the `login_tcp_port` value-defined integer value from a packet.
pub fn lookup_all_login_tcp_port(packet: &Packet) -> Result<Vec<LoginTCPPort>, AVPError> {
    let mut vec = Vec::new();
    for avp in packet.lookup_all(LOGIN_TCP_PORT_TYPE) {
        vec.push(avp.encode_u32()? as LoginTCPPort)
    }
    Ok(vec)
}

pub const REPLY_MESSAGE_TYPE: AVPType = 18;
/// Delete all of `reply_message` values from a packet.
pub fn delete_reply_message(packet: &mut Packet) {
    packet.delete(REPLY_MESSAGE_TYPE);
}
/// Add `reply_message` string value to a packet.
pub fn add_reply_message(packet: &mut Packet, value: &str) {
    packet.add(AVP::from_string(REPLY_MESSAGE_TYPE, value));
}
/// Lookup a `reply_message` string value from a packet.
///
/// It returns the first looked up value. If there is no associated value with `reply_message`, it returns `None`.
pub fn lookup_reply_message(packet: &Packet) -> Option<Result<String, AVPError>> {
    packet.lookup(REPLY_MESSAGE_TYPE).map(|v| v.encode_string())
}
/// Lookup all of the `reply_message` string value from a packet.
pub fn lookup_all_reply_message(packet: &Packet) -> Result<Vec<String>, AVPError> {
    let mut vec = Vec::new();
    for avp in packet.lookup_all(REPLY_MESSAGE_TYPE) {
        vec.push(avp.encode_string()?)
    }
    Ok(vec)
}

pub const CALLBACK_NUMBER_TYPE: AVPType = 19;
/// Delete all of `callback_number` values from a packet.
pub fn delete_callback_number(packet: &mut Packet) {
    packet.delete(CALLBACK_NUMBER_TYPE);
}
/// Add `callback_number` string value to a packet.
pub fn add_callback_number(packet: &mut Packet, value: &str) {
    packet.add(AVP::from_string(CALLBACK_NUMBER_TYPE, value));
}
/// Lookup a `callback_number` string value from a packet.
///
/// It returns the first looked up value. If there is no associated value with `callback_number`, it returns `None`.
pub fn lookup_callback_number(packet: &Packet) -> Option<Result<String, AVPError>> {
    packet
        .lookup(CALLBACK_NUMBER_TYPE)
        .map(|v| v.encode_string())
}
/// Lookup all of the `callback_number` string value from a packet.
pub fn lookup_all_callback_number(packet: &Packet) -> Result<Vec<String>, AVPError> {
    let mut vec = Vec::new();
    for avp in packet.lookup_all(CALLBACK_NUMBER_TYPE) {
        vec.push(avp.encode_string()?)
    }
    Ok(vec)
}

pub const CALLBACK_ID_TYPE: AVPType = 20;
/// Delete all of `callback_id` values from a packet.
pub fn delete_callback_id(packet: &mut Packet) {
    packet.delete(CALLBACK_ID_TYPE);
}
/// Add `callback_id` string value to a packet.
pub fn add_callback_id(packet: &mut Packet, value: &str) {
    packet.add(AVP::from_string(CALLBACK_ID_TYPE, value));
}
/// Lookup a `callback_id` string value from a packet.
///
/// It returns the first looked up value. If there is no associated value with `callback_id`, it returns `None`.
pub fn lookup_callback_id(packet: &Packet) -> Option<Result<String, AVPError>> {
    packet.lookup(CALLBACK_ID_TYPE).map(|v| v.encode_string())
}
/// Lookup all of the `callback_id` string value from a packet.
pub fn lookup_all_callback_id(packet: &Packet) -> Result<Vec<String>, AVPError> {
    let mut vec = Vec::new();
    for avp in packet.lookup_all(CALLBACK_ID_TYPE) {
        vec.push(avp.encode_string()?)
    }
    Ok(vec)
}

pub const FRAMED_ROUTE_TYPE: AVPType = 22;
/// Delete all of `framed_route` values from a packet.
pub fn delete_framed_route(packet: &mut Packet) {
    packet.delete(FRAMED_ROUTE_TYPE);
}
/// Add `framed_route` string value to a packet.
pub fn add_framed_route(packet: &mut Packet, value: &str) {
    packet.add(AVP::from_string(FRAMED_ROUTE_TYPE, value));
}
/// Lookup a `framed_route` string value from a packet.
///
/// It returns the first looked up value. If there is no associated value with `framed_route`, it returns `None`.
pub fn lookup_framed_route(packet: &Packet) -> Option<Result<String, AVPError>> {
    packet.lookup(FRAMED_ROUTE_TYPE).map(|v| v.encode_string())
}
/// Lookup all of the `framed_route` string value from a packet.
pub fn lookup_all_framed_route(packet: &Packet) -> Result<Vec<String>, AVPError> {
    let mut vec = Vec::new();
    for avp in packet.lookup_all(FRAMED_ROUTE_TYPE) {
        vec.push(avp.encode_string()?)
    }
    Ok(vec)
}

pub const FRAMED_IPX_NETWORK_TYPE: AVPType = 23;
/// Delete all of `framed_ipx_network` values from a packet.
pub fn delete_framed_ipx_network(packet: &mut Packet) {
    packet.delete(FRAMED_IPX_NETWORK_TYPE);
}
/// Add `framed_ipx_network` ipaddr value to a packet.
pub fn add_framed_ipx_network(packet: &mut Packet, value: &Ipv4Addr) {
    packet.add(AVP::from_ipv4(FRAMED_IPX_NETWORK_TYPE, value));
}
/// Lookup a `framed_ipx_network` ipaddr value from a packet.
///
/// It returns the first looked up value. If there is no associated value with `framed_ipx_network`, it returns `None`.
pub fn lookup_framed_ipx_network(packet: &Packet) -> Option<Result<Ipv4Addr, AVPError>> {
    packet
        .lookup(FRAMED_IPX_NETWORK_TYPE)
        .map(|v| v.encode_ipv4())
}
/// Lookup all of the `framed_ipx_network` ipaddr value from a packet.
pub fn lookup_all_framed_ipx_network(packet: &Packet) -> Result<Vec<Ipv4Addr>, AVPError> {
    let mut vec = Vec::new();
    for avp in packet.lookup_all(FRAMED_IPX_NETWORK_TYPE) {
        vec.push(avp.encode_ipv4()?)
    }
    Ok(vec)
}

pub const STATE_TYPE: AVPType = 24;
/// Delete all of `state` values from a packet.
pub fn delete_state(packet: &mut Packet) {
    packet.delete(STATE_TYPE);
}
/// Add `state` octets value to a packet.
pub fn add_state(packet: &mut Packet, value: &[u8]) {
    packet.add(AVP::from_bytes(STATE_TYPE, value));
}
/// Lookup a `state` octets value from a packet.
///
/// It returns the first looked up value. If there is no associated value with `state`, it returns `None`.
pub fn lookup_state(packet: &Packet) -> Option<Vec<u8>> {
    packet.lookup(STATE_TYPE).map(|v| v.encode_bytes())
}
/// Lookup all of the `state` octets value from a packet.
pub fn lookup_all_state(packet: &Packet) -> Vec<Vec<u8>> {
    let mut vec = Vec::new();
    for avp in packet.lookup_all(STATE_TYPE) {
        vec.push(avp.encode_bytes())
    }
    vec
}

pub const CLASS_TYPE: AVPType = 25;
/// Delete all of `class` values from a packet.
pub fn delete_class(packet: &mut Packet) {
    packet.delete(CLASS_TYPE);
}
/// Add `class` octets value to a packet.
pub fn add_class(packet: &mut Packet, value: &[u8]) {
    packet.add(AVP::from_bytes(CLASS_TYPE, value));
}
/// Lookup a `class` octets value from a packet.
///
/// It returns the first looked up value. If there is no associated value with `class`, it returns `None`.
pub fn lookup_class(packet: &Packet) -> Option<Vec<u8>> {
    packet.lookup(CLASS_TYPE).map(|v| v.encode_bytes())
}
/// Lookup all of the `class` octets value from a packet.
pub fn lookup_all_class(packet: &Packet) -> Vec<Vec<u8>> {
    let mut vec = Vec::new();
    for avp in packet.lookup_all(CLASS_TYPE) {
        vec.push(avp.encode_bytes())
    }
    vec
}

pub const VENDOR_SPECIFIC_TYPE: AVPType = 26;
/// Delete all of `vendor_specific` values from a packet.
pub fn delete_vendor_specific(packet: &mut Packet) {
    packet.delete(VENDOR_SPECIFIC_TYPE);
}

pub const SESSION_TIMEOUT_TYPE: AVPType = 27;
/// Delete all of `session_timeout` values from a packet.
pub fn delete_session_timeout(packet: &mut Packet) {
    packet.delete(SESSION_TIMEOUT_TYPE);
}
/// Add `session_timeout` integer value to a packet.
pub fn add_session_timeout(packet: &mut Packet, value: u32) {
    packet.add(AVP::from_u32(SESSION_TIMEOUT_TYPE, value));
}
/// Lookup a `session_timeout` integer value from a packet.
///
/// It returns the first looked up value. If there is no associated value with `session_timeout`, it returns `None`.
pub fn lookup_session_timeout(packet: &Packet) -> Option<Result<u32, AVPError>> {
    packet.lookup(SESSION_TIMEOUT_TYPE).map(|v| v.encode_u32())
}
/// Lookup all of the `session_timeout` integer value from a packet.
pub fn lookup_all_session_timeout(packet: &Packet) -> Result<Vec<u32>, AVPError> {
    let mut vec = Vec::new();
    for avp in packet.lookup_all(SESSION_TIMEOUT_TYPE) {
        vec.push(avp.encode_u32()?)
    }
    Ok(vec)
}

pub const IDLE_TIMEOUT_TYPE: AVPType = 28;
/// Delete all of `idle_timeout` values from a packet.
pub fn delete_idle_timeout(packet: &mut Packet) {
    packet.delete(IDLE_TIMEOUT_TYPE);
}
/// Add `idle_timeout` integer value to a packet.
pub fn add_idle_timeout(packet: &mut Packet, value: u32) {
    packet.add(AVP::from_u32(IDLE_TIMEOUT_TYPE, value));
}
/// Lookup a `idle_timeout` integer value from a packet.
///
/// It returns the first looked up value. If there is no associated value with `idle_timeout`, it returns `None`.
pub fn lookup_idle_timeout(packet: &Packet) -> Option<Result<u32, AVPError>> {
    packet.lookup(IDLE_TIMEOUT_TYPE).map(|v| v.encode_u32())
}
/// Lookup all of the `idle_timeout` integer value from a packet.
pub fn lookup_all_idle_timeout(packet: &Packet) -> Result<Vec<u32>, AVPError> {
    let mut vec = Vec::new();
    for avp in packet.lookup_all(IDLE_TIMEOUT_TYPE) {
        vec.push(avp.encode_u32()?)
    }
    Ok(vec)
}

pub const TERMINATION_ACTION_TYPE: AVPType = 29;
/// Delete all of `termination_action` values from a packet.
pub fn delete_termination_action(packet: &mut Packet) {
    packet.delete(TERMINATION_ACTION_TYPE);
}
/// Add `termination_action` value-defined integer value to a packet.
pub fn add_termination_action(packet: &mut Packet, value: TerminationAction) {
    packet.add(AVP::from_u32(TERMINATION_ACTION_TYPE, value as u32));
}
/// Lookup a `termination_action` value-defined integer value from a packet.
///
/// It returns the first looked up value. If there is no associated value with `termination_action`, it returns `None`.
pub fn lookup_termination_action(packet: &Packet) -> Option<Result<TerminationAction, AVPError>> {
    packet
        .lookup(TERMINATION_ACTION_TYPE)
        .map(|v| Ok(v.encode_u32()? as TerminationAction))
}
/// Lookup all of the `termination_action` value-defined integer value from a packet.
pub fn lookup_all_termination_action(packet: &Packet) -> Result<Vec<TerminationAction>, AVPError> {
    let mut vec = Vec::new();
    for avp in packet.lookup_all(TERMINATION_ACTION_TYPE) {
        vec.push(avp.encode_u32()? as TerminationAction)
    }
    Ok(vec)
}

pub const CALLED_STATION_ID_TYPE: AVPType = 30;
/// Delete all of `called_station_id` values from a packet.
pub fn delete_called_station_id(packet: &mut Packet) {
    packet.delete(CALLED_STATION_ID_TYPE);
}
/// Add `called_station_id` string value to a packet.
pub fn add_called_station_id(packet: &mut Packet, value: &str) {
    packet.add(AVP::from_string(CALLED_STATION_ID_TYPE, value));
}
/// Lookup a `called_station_id` string value from a packet.
///
/// It returns the first looked up value. If there is no associated value with `called_station_id`, it returns `None`.
pub fn lookup_called_station_id(packet: &Packet) -> Option<Result<String, AVPError>> {
    packet
        .lookup(CALLED_STATION_ID_TYPE)
        .map(|v| v.encode_string())
}
/// Lookup all of the `called_station_id` string value from a packet.
pub fn lookup_all_called_station_id(packet: &Packet) -> Result<Vec<String>, AVPError> {
    let mut vec = Vec::new();
    for avp in packet.lookup_all(CALLED_STATION_ID_TYPE) {
        vec.push(avp.encode_string()?)
    }
    Ok(vec)
}

pub const CALLING_STATION_ID_TYPE: AVPType = 31;
/// Delete all of `calling_station_id` values from a packet.
pub fn delete_calling_station_id(packet: &mut Packet) {
    packet.delete(CALLING_STATION_ID_TYPE);
}
/// Add `calling_station_id` string value to a packet.
pub fn add_calling_station_id(packet: &mut Packet, value: &str) {
    packet.add(AVP::from_string(CALLING_STATION_ID_TYPE, value));
}
/// Lookup a `calling_station_id` string value from a packet.
///
/// It returns the first looked up value. If there is no associated value with `calling_station_id`, it returns `None`.
pub fn lookup_calling_station_id(packet: &Packet) -> Option<Result<String, AVPError>> {
    packet
        .lookup(CALLING_STATION_ID_TYPE)
        .map(|v| v.encode_string())
}
/// Lookup all of the `calling_station_id` string value from a packet.
pub fn lookup_all_calling_station_id(packet: &Packet) -> Result<Vec<String>, AVPError> {
    let mut vec = Vec::new();
    for avp in packet.lookup_all(CALLING_STATION_ID_TYPE) {
        vec.push(avp.encode_string()?)
    }
    Ok(vec)
}

pub const NAS_IDENTIFIER_TYPE: AVPType = 32;
/// Delete all of `nas_identifier` values from a packet.
pub fn delete_nas_identifier(packet: &mut Packet) {
    packet.delete(NAS_IDENTIFIER_TYPE);
}
/// Add `nas_identifier` string value to a packet.
pub fn add_nas_identifier(packet: &mut Packet, value: &str) {
    packet.add(AVP::from_string(NAS_IDENTIFIER_TYPE, value));
}
/// Lookup a `nas_identifier` string value from a packet.
///
/// It returns the first looked up value. If there is no associated value with `nas_identifier`, it returns `None`.
pub fn lookup_nas_identifier(packet: &Packet) -> Option<Result<String, AVPError>> {
    packet
        .lookup(NAS_IDENTIFIER_TYPE)
        .map(|v| v.encode_string())
}
/// Lookup all of the `nas_identifier` string value from a packet.
pub fn lookup_all_nas_identifier(packet: &Packet) -> Result<Vec<String>, AVPError> {
    let mut vec = Vec::new();
    for avp in packet.lookup_all(NAS_IDENTIFIER_TYPE) {
        vec.push(avp.encode_string()?)
    }
    Ok(vec)
}

pub const PROXY_STATE_TYPE: AVPType = 33;
/// Delete all of `proxy_state` values from a packet.
pub fn delete_proxy_state(packet: &mut Packet) {
    packet.delete(PROXY_STATE_TYPE);
}
/// Add `proxy_state` octets value to a packet.
pub fn add_proxy_state(packet: &mut Packet, value: &[u8]) {
    packet.add(AVP::from_bytes(PROXY_STATE_TYPE, value));
}
/// Lookup a `proxy_state` octets value from a packet.
///
/// It returns the first looked up value. If there is no associated value with `proxy_state`, it returns `None`.
pub fn lookup_proxy_state(packet: &Packet) -> Option<Vec<u8>> {
    packet.lookup(PROXY_STATE_TYPE).map(|v| v.encode_bytes())
}
/// Lookup all of the `proxy_state` octets value from a packet.
pub fn lookup_all_proxy_state(packet: &Packet) -> Vec<Vec<u8>> {
    let mut vec = Vec::new();
    for avp in packet.lookup_all(PROXY_STATE_TYPE) {
        vec.push(avp.encode_bytes())
    }
    vec
}

pub const LOGIN_LAT_SERVICE_TYPE: AVPType = 34;
/// Delete all of `login_lat_service` values from a packet.
pub fn delete_login_lat_service(packet: &mut Packet) {
    packet.delete(LOGIN_LAT_SERVICE_TYPE);
}
/// Add `login_lat_service` string value to a packet.
pub fn add_login_lat_service(packet: &mut Packet, value: &str) {
    packet.add(AVP::from_string(LOGIN_LAT_SERVICE_TYPE, value));
}
/// Lookup a `login_lat_service` string value from a packet.
///
/// It returns the first looked up value. If there is no associated value with `login_lat_service`, it returns `None`.
pub fn lookup_login_lat_service(packet: &Packet) -> Option<Result<String, AVPError>> {
    packet
        .lookup(LOGIN_LAT_SERVICE_TYPE)
        .map(|v| v.encode_string())
}
/// Lookup all of the `login_lat_service` string value from a packet.
pub fn lookup_all_login_lat_service(packet: &Packet) -> Result<Vec<String>, AVPError> {
    let mut vec = Vec::new();
    for avp in packet.lookup_all(LOGIN_LAT_SERVICE_TYPE) {
        vec.push(avp.encode_string()?)
    }
    Ok(vec)
}

pub const LOGIN_LAT_NODE_TYPE: AVPType = 35;
/// Delete all of `login_lat_node` values from a packet.
pub fn delete_login_lat_node(packet: &mut Packet) {
    packet.delete(LOGIN_LAT_NODE_TYPE);
}
/// Add `login_lat_node` string value to a packet.
pub fn add_login_lat_node(packet: &mut Packet, value: &str) {
    packet.add(AVP::from_string(LOGIN_LAT_NODE_TYPE, value));
}
/// Lookup a `login_lat_node` string value from a packet.
///
/// It returns the first looked up value. If there is no associated value with `login_lat_node`, it returns `None`.
pub fn lookup_login_lat_node(packet: &Packet) -> Option<Result<String, AVPError>> {
    packet
        .lookup(LOGIN_LAT_NODE_TYPE)
        .map(|v| v.encode_string())
}
/// Lookup all of the `login_lat_node` string value from a packet.
pub fn lookup_all_login_lat_node(packet: &Packet) -> Result<Vec<String>, AVPError> {
    let mut vec = Vec::new();
    for avp in packet.lookup_all(LOGIN_LAT_NODE_TYPE) {
        vec.push(avp.encode_string()?)
    }
    Ok(vec)
}

pub const LOGIN_LAT_GROUP_TYPE: AVPType = 36;
/// Delete all of `login_lat_group` values from a packet.
pub fn delete_login_lat_group(packet: &mut Packet) {
    packet.delete(LOGIN_LAT_GROUP_TYPE);
}
/// Add `login_lat_group` octets value to a packet.
pub fn add_login_lat_group(packet: &mut Packet, value: &[u8]) {
    packet.add(AVP::from_bytes(LOGIN_LAT_GROUP_TYPE, value));
}
/// Lookup a `login_lat_group` octets value from a packet.
///
/// It returns the first looked up value. If there is no associated value with `login_lat_group`, it returns `None`.
pub fn lookup_login_lat_group(packet: &Packet) -> Option<Vec<u8>> {
    packet
        .lookup(LOGIN_LAT_GROUP_TYPE)
        .map(|v| v.encode_bytes())
}
/// Lookup all of the `login_lat_group` octets value from a packet.
pub fn lookup_all_login_lat_group(packet: &Packet) -> Vec<Vec<u8>> {
    let mut vec = Vec::new();
    for avp in packet.lookup_all(LOGIN_LAT_GROUP_TYPE) {
        vec.push(avp.encode_bytes())
    }
    vec
}

pub const FRAMED_APPLE_TALK_LINK_TYPE: AVPType = 37;
/// Delete all of `framed_apple_talk_link` values from a packet.
pub fn delete_framed_apple_talk_link(packet: &mut Packet) {
    packet.delete(FRAMED_APPLE_TALK_LINK_TYPE);
}
/// Add `framed_apple_talk_link` integer value to a packet.
pub fn add_framed_apple_talk_link(packet: &mut Packet, value: u32) {
    packet.add(AVP::from_u32(FRAMED_APPLE_TALK_LINK_TYPE, value));
}
/// Lookup a `framed_apple_talk_link` integer value from a packet.
///
/// It returns the first looked up value. If there is no associated value with `framed_apple_talk_link`, it returns `None`.
pub fn lookup_framed_apple_talk_link(packet: &Packet) -> Option<Result<u32, AVPError>> {
    packet
        .lookup(FRAMED_APPLE_TALK_LINK_TYPE)
        .map(|v| v.encode_u32())
}
/// Lookup all of the `framed_apple_talk_link` integer value from a packet.
pub fn lookup_all_framed_apple_talk_link(packet: &Packet) -> Result<Vec<u32>, AVPError> {
    let mut vec = Vec::new();
    for avp in packet.lookup_all(FRAMED_APPLE_TALK_LINK_TYPE) {
        vec.push(avp.encode_u32()?)
    }
    Ok(vec)
}

pub const FRAMED_APPLE_TALK_NETWORK_TYPE: AVPType = 38;
/// Delete all of `framed_apple_talk_network` values from a packet.
pub fn delete_framed_apple_talk_network(packet: &mut Packet) {
    packet.delete(FRAMED_APPLE_TALK_NETWORK_TYPE);
}
/// Add `framed_apple_talk_network` integer value to a packet.
pub fn add_framed_apple_talk_network(packet: &mut Packet, value: u32) {
    packet.add(AVP::from_u32(FRAMED_APPLE_TALK_NETWORK_TYPE, value));
}
/// Lookup a `framed_apple_talk_network` integer value from a packet.
///
/// It returns the first looked up value. If there is no associated value with `framed_apple_talk_network`, it returns `None`.
pub fn lookup_framed_apple_talk_network(packet: &Packet) -> Option<Result<u32, AVPError>> {
    packet
        .lookup(FRAMED_APPLE_TALK_NETWORK_TYPE)
        .map(|v| v.encode_u32())
}
/// Lookup all of the `framed_apple_talk_network` integer value from a packet.
pub fn lookup_all_framed_apple_talk_network(packet: &Packet) -> Result<Vec<u32>, AVPError> {
    let mut vec = Vec::new();
    for avp in packet.lookup_all(FRAMED_APPLE_TALK_NETWORK_TYPE) {
        vec.push(avp.encode_u32()?)
    }
    Ok(vec)
}

pub const FRAMED_APPLE_TALK_ZONE_TYPE: AVPType = 39;
/// Delete all of `framed_apple_talk_zone` values from a packet.
pub fn delete_framed_apple_talk_zone(packet: &mut Packet) {
    packet.delete(FRAMED_APPLE_TALK_ZONE_TYPE);
}
/// Add `framed_apple_talk_zone` string value to a packet.
pub fn add_framed_apple_talk_zone(packet: &mut Packet, value: &str) {
    packet.add(AVP::from_string(FRAMED_APPLE_TALK_ZONE_TYPE, value));
}
/// Lookup a `framed_apple_talk_zone` string value from a packet.
///
/// It returns the first looked up value. If there is no associated value with `framed_apple_talk_zone`, it returns `None`.
pub fn lookup_framed_apple_talk_zone(packet: &Packet) -> Option<Result<String, AVPError>> {
    packet
        .lookup(FRAMED_APPLE_TALK_ZONE_TYPE)
        .map(|v| v.encode_string())
}
/// Lookup all of the `framed_apple_talk_zone` string value from a packet.
pub fn lookup_all_framed_apple_talk_zone(packet: &Packet) -> Result<Vec<String>, AVPError> {
    let mut vec = Vec::new();
    for avp in packet.lookup_all(FRAMED_APPLE_TALK_ZONE_TYPE) {
        vec.push(avp.encode_string()?)
    }
    Ok(vec)
}

pub const CHAP_CHALLENGE_TYPE: AVPType = 60;
/// Delete all of `chap_challenge` values from a packet.
pub fn delete_chap_challenge(packet: &mut Packet) {
    packet.delete(CHAP_CHALLENGE_TYPE);
}
/// Add `chap_challenge` octets value to a packet.
pub fn add_chap_challenge(packet: &mut Packet, value: &[u8]) {
    packet.add(AVP::from_bytes(CHAP_CHALLENGE_TYPE, value));
}
/// Lookup a `chap_challenge` octets value from a packet.
///
/// It returns the first looked up value. If there is no associated value with `chap_challenge`, it returns `None`.
pub fn lookup_chap_challenge(packet: &Packet) -> Option<Vec<u8>> {
    packet.lookup(CHAP_CHALLENGE_TYPE).map(|v| v.encode_bytes())
}
/// Lookup all of the `chap_challenge` octets value from a packet.
pub fn lookup_all_chap_challenge(packet: &Packet) -> Vec<Vec<u8>> {
    let mut vec = Vec::new();
    for avp in packet.lookup_all(CHAP_CHALLENGE_TYPE) {
        vec.push(avp.encode_bytes())
    }
    vec
}

pub const NAS_PORT_TYPE_TYPE: AVPType = 61;
/// Delete all of `nas_port_type` values from a packet.
pub fn delete_nas_port_type(packet: &mut Packet) {
    packet.delete(NAS_PORT_TYPE_TYPE);
}
/// Add `nas_port_type` value-defined integer value to a packet.
pub fn add_nas_port_type(packet: &mut Packet, value: NasPortType) {
    packet.add(AVP::from_u32(NAS_PORT_TYPE_TYPE, value as u32));
}
/// Lookup a `nas_port_type` value-defined integer value from a packet.
///
/// It returns the first looked up value. If there is no associated value with `nas_port_type`, it returns `None`.
pub fn lookup_nas_port_type(packet: &Packet) -> Option<Result<NasPortType, AVPError>> {
    packet
        .lookup(NAS_PORT_TYPE_TYPE)
        .map(|v| Ok(v.encode_u32()? as NasPortType))
}
/// Lookup all of the `nas_port_type` value-defined integer value from a packet.
pub fn lookup_all_nas_port_type(packet: &Packet) -> Result<Vec<NasPortType>, AVPError> {
    let mut vec = Vec::new();
    for avp in packet.lookup_all(NAS_PORT_TYPE_TYPE) {
        vec.push(avp.encode_u32()? as NasPortType)
    }
    Ok(vec)
}

pub const PORT_LIMIT_TYPE: AVPType = 62;
/// Delete all of `port_limit` values from a packet.
pub fn delete_port_limit(packet: &mut Packet) {
    packet.delete(PORT_LIMIT_TYPE);
}
/// Add `port_limit` integer value to a packet.
pub fn add_port_limit(packet: &mut Packet, value: u32) {
    packet.add(AVP::from_u32(PORT_LIMIT_TYPE, value));
}
/// Lookup a `port_limit` integer value from a packet.
///
/// It returns the first looked up value. If there is no associated value with `port_limit`, it returns `None`.
pub fn lookup_port_limit(packet: &Packet) -> Option<Result<u32, AVPError>> {
    packet.lookup(PORT_LIMIT_TYPE).map(|v| v.encode_u32())
}
/// Lookup all of the `port_limit` integer value from a packet.
pub fn lookup_all_port_limit(packet: &Packet) -> Result<Vec<u32>, AVPError> {
    let mut vec = Vec::new();
    for avp in packet.lookup_all(PORT_LIMIT_TYPE) {
        vec.push(avp.encode_u32()?)
    }
    Ok(vec)
}

pub const LOGIN_LAT_PORT_TYPE: AVPType = 63;
/// Delete all of `login_lat_port` values from a packet.
pub fn delete_login_lat_port(packet: &mut Packet) {
    packet.delete(LOGIN_LAT_PORT_TYPE);
}
/// Add `login_lat_port` string value to a packet.
pub fn add_login_lat_port(packet: &mut Packet, value: &str) {
    packet.add(AVP::from_string(LOGIN_LAT_PORT_TYPE, value));
}
/// Lookup a `login_lat_port` string value from a packet.
///
/// It returns the first looked up value. If there is no associated value with `login_lat_port`, it returns `None`.
pub fn lookup_login_lat_port(packet: &Packet) -> Option<Result<String, AVPError>> {
    packet
        .lookup(LOGIN_LAT_PORT_TYPE)
        .map(|v| v.encode_string())
}
/// Lookup all of the `login_lat_port` string value from a packet.
pub fn lookup_all_login_lat_port(packet: &Packet) -> Result<Vec<String>, AVPError> {
    let mut vec = Vec::new();
    for avp in packet.lookup_all(LOGIN_LAT_PORT_TYPE) {
        vec.push(avp.encode_string()?)
    }
    Ok(vec)
}

pub type FramedCompression = u32;
pub const FRAMED_COMPRESSION_NONE: FramedCompression = 0;
pub const FRAMED_COMPRESSION_VAN_JACOBSON_TCP_IP: FramedCompression = 1;
pub const FRAMED_COMPRESSION_IPX_HEADER_COMPRESSION: FramedCompression = 2;
pub const FRAMED_COMPRESSION_STAC_LZS: FramedCompression = 3;

pub type FramedProtocol = u32;
pub const FRAMED_PROTOCOL_PPP: FramedProtocol = 1;
pub const FRAMED_PROTOCOL_SLIP: FramedProtocol = 2;
pub const FRAMED_PROTOCOL_ARAP: FramedProtocol = 3;
pub const FRAMED_PROTOCOL_GANDALF_SLML: FramedProtocol = 4;
pub const FRAMED_PROTOCOL_XYLOGICS_IPX_SLIP: FramedProtocol = 5;
pub const FRAMED_PROTOCOL_X_75_SYNCHRONOUS: FramedProtocol = 6;

pub type FramedRouting = u32;
pub const FRAMED_ROUTING_NONE: FramedRouting = 0;
pub const FRAMED_ROUTING_BROADCAST: FramedRouting = 1;
pub const FRAMED_ROUTING_LISTEN: FramedRouting = 2;
pub const FRAMED_ROUTING_BROADCAST_LISTEN: FramedRouting = 3;

pub type LoginService = u32;
pub const LOGIN_SERVICE_TELNET: LoginService = 0;
pub const LOGIN_SERVICE_RLOGIN: LoginService = 1;
pub const LOGIN_SERVICE_TCP_CLEAR: LoginService = 2;
pub const LOGIN_SERVICE_PORT_MASTER: LoginService = 3;
pub const LOGIN_SERVICE_LAT: LoginService = 4;
pub const LOGIN_SERVICE_X25_PAD: LoginService = 5;
pub const LOGIN_SERVICE_X25_T3POS: LoginService = 6;
pub const LOGIN_SERVICE_TCP_CLEAR_QUIET: LoginService = 8;

pub type LoginTCPPort = u32;
pub const LOGIN_TCP_PORT_TELNET: LoginTCPPort = 23;
pub const LOGIN_TCP_PORT_RLOGIN: LoginTCPPort = 513;
pub const LOGIN_TCP_PORT_RSH: LoginTCPPort = 514;

pub type NasPortType = u32;
pub const NAS_PORT_TYPE_ASYNC: NasPortType = 0;
pub const NAS_PORT_TYPE_SYNC: NasPortType = 1;
pub const NAS_PORT_TYPE_ISDN: NasPortType = 2;
pub const NAS_PORT_TYPE_ISDN_V120: NasPortType = 3;
pub const NAS_PORT_TYPE_ISDN_V110: NasPortType = 4;
pub const NAS_PORT_TYPE_VIRTUAL: NasPortType = 5;
pub const NAS_PORT_TYPE_PIAFS: NasPortType = 6;
pub const NAS_PORT_TYPE_HDLC_CLEAR_CHANNEL: NasPortType = 7;
pub const NAS_PORT_TYPE_X_25: NasPortType = 8;
pub const NAS_PORT_TYPE_X_75: NasPortType = 9;
pub const NAS_PORT_TYPE_G_3_FAX: NasPortType = 10;
pub const NAS_PORT_TYPE_SDSL: NasPortType = 11;
pub const NAS_PORT_TYPE_ADSL_CAP: NasPortType = 12;
pub const NAS_PORT_TYPE_ADSL_DMT: NasPortType = 13;
pub const NAS_PORT_TYPE_IDSL: NasPortType = 14;
pub const NAS_PORT_TYPE_ETHERNET: NasPortType = 15;
pub const NAS_PORT_TYPE_X_DSL: NasPortType = 16;
pub const NAS_PORT_TYPE_CABLE: NasPortType = 17;
pub const NAS_PORT_TYPE_WIRELESS_OTHER: NasPortType = 18;
pub const NAS_PORT_TYPE_WIRELESS_802_11: NasPortType = 19;

pub type ServiceType = u32;
pub const SERVICE_TYPE_LOGIN_USER: ServiceType = 1;
pub const SERVICE_TYPE_FRAMED_USER: ServiceType = 2;
pub const SERVICE_TYPE_CALLBACK_LOGIN_USER: ServiceType = 3;
pub const SERVICE_TYPE_CALLBACK_FRAMED_USER: ServiceType = 4;
pub const SERVICE_TYPE_OUTBOUND_USER: ServiceType = 5;
pub const SERVICE_TYPE_ADMINISTRATIVE_USER: ServiceType = 6;
pub const SERVICE_TYPE_NAS_PROMPT_USER: ServiceType = 7;
pub const SERVICE_TYPE_AUTHENTICATE_ONLY: ServiceType = 8;
pub const SERVICE_TYPE_CALLBACK_NAS_PROMPT: ServiceType = 9;
pub const SERVICE_TYPE_CALL_CHECK: ServiceType = 10;
pub const SERVICE_TYPE_CALLBACK_ADMINISTRATIVE: ServiceType = 11;

pub type TerminationAction = u32;
pub const TERMINATION_ACTION_DEFAULT: TerminationAction = 0;
pub const TERMINATION_ACTION_RADIUS_REQUEST: TerminationAction = 1;
