// This file is part of the rust-radio-sx1231 project.
//
// This Source Code Form is subject to the terms of the Mozilla Public
// License, v. 2.0. If a copy of the MPL was not distributed with this
// file, You can obtain one at http://mozilla.org/MPL/2.0/.
//
// Copyright 2018 Ryan Kurte
// Copyright 2020-2021 Erik Henriksson

// This warning is generated by some modular bitfield macro.
#![allow(clippy::unnecessary_cast)]

use core::convert::Infallible;
use modular_bitfield::prelude::*;

#[derive(Copy, Clone, PartialEq, Debug)]
#[cfg_attr(feature = "serde", derive(serde::Deserialize, serde::Serialize))]
#[cfg_attr(feature = "defmt", derive(defmt::Format))]
pub struct Fifo {}

impl Fifo {
    pub const ADDRESS: u8 = 0x00;
}

#[derive(BitfieldSpecifier, Copy, Clone, PartialEq, Debug)]
#[cfg_attr(feature = "serde", derive(serde::Deserialize, serde::Serialize))]
#[cfg_attr(feature = "defmt", derive(defmt::Format))]
#[bits = 3]
pub enum ModemMode {
    Sleep = 0,
    Standby = 1,
    FreqSynthesizer = 2,
    Transmitter = 3,
    Receiver = 4,
}

impl radio::RadioState for ModemMode {
    fn idle() -> Self {
        ModemMode::Standby
    }

    fn sleep() -> Self {
        ModemMode::Sleep
    }
}

#[bitfield]
#[derive(BitfieldSpecifier, Copy, Clone, PartialEq, Debug)]
#[cfg_attr(feature = "serde", derive(serde::Deserialize, serde::Serialize))]
#[cfg_attr(feature = "defmt", derive(defmt::Format))]
#[repr(u8)]
pub struct OpMode {
    #[skip]
    _reserved: B2,
    pub modem_mode: ModemMode,
    pub listen_abort: bool,
    pub listen_on: bool,
    pub sequencer_off: bool,
}

impl radio::Register for OpMode {
    const ADDRESS: u8 = 0x01;
    type Word = u8;
    type Error = Infallible;
}

#[derive(BitfieldSpecifier, Copy, Clone, PartialEq, Debug)]
#[cfg_attr(feature = "serde", derive(serde::Deserialize, serde::Serialize))]
#[cfg_attr(feature = "defmt", derive(defmt::Format))]
#[bits = 5]
pub enum ModulationType {
    Fsk = 0b00000,
    Gfsk1 = 0b00001,
    Gfsk05 = 0b00010,
    Gfsk03 = 0b00011,
    Ook = 0b01000,
    OokBr = 0b01001,
    Ook2Br = 0b01010,
    // 0b01011 reserved
    // 0b1xxxx reserved
}

#[derive(BitfieldSpecifier, Copy, Clone, PartialEq, Debug)]
#[cfg_attr(feature = "serde", derive(serde::Deserialize, serde::Serialize))]
#[cfg_attr(feature = "defmt", derive(defmt::Format))]
#[bits = 2]
pub enum DataMode {
    Packet = 0,
    ContinousWithBitSync = 1,
    // 0b01 reserved
    Continous = 3,
}

#[bitfield]
#[derive(BitfieldSpecifier, Copy, Clone, PartialEq, Debug)]
#[cfg_attr(feature = "serde", derive(serde::Deserialize, serde::Serialize))]
#[cfg_attr(feature = "defmt", derive(defmt::Format))]
#[repr(u8)]
pub struct DataModulation {
    pub mod_type: ModulationType,
    pub mode: DataMode,
    #[skip]
    __: B1,
}

impl radio::Register for DataModulation {
    const ADDRESS: u8 = 0x02;
    type Word = u8;
    type Error = Infallible;
}

#[bitfield]
#[derive(Copy, Clone, PartialEq, Debug)]
#[cfg_attr(feature = "serde", derive(serde::Deserialize, serde::Serialize))]
#[cfg_attr(feature = "defmt", derive(defmt::Format))]
#[repr(u16)]
pub struct Bitrate {
    pub bitrate: u16,
}

impl radio::Register for Bitrate {
    const ADDRESS: u8 = 0x03;
    type Word = u16;
    type Error = Infallible;
}

#[bitfield]
#[derive(Copy, Clone, PartialEq, Debug)]
#[cfg_attr(feature = "serde", derive(serde::Deserialize, serde::Serialize))]
#[cfg_attr(feature = "defmt", derive(defmt::Format))]
#[repr(u16)]
pub struct Fdev {
    pub freq_dev: u16,
}

impl radio::Register for Fdev {
    const ADDRESS: u8 = 0x05;
    type Word = u16;
    type Error = Infallible;
}

#[bitfield]
#[derive(Copy, Clone, PartialEq, Debug)]
#[cfg_attr(feature = "serde", derive(serde::Deserialize, serde::Serialize))]
#[cfg_attr(feature = "defmt", derive(defmt::Format))]
#[repr(u16)]
pub struct FreqDev {
    pub freq_dev: u16,
}

impl radio::Register for FreqDev {
    const ADDRESS: u8 = 0x05;
    type Word = u16;
    type Error = Infallible;
}

#[bitfield]
#[derive(Copy, Clone, PartialEq, Debug)]
#[cfg_attr(feature = "serde", derive(serde::Deserialize, serde::Serialize))]
#[cfg_attr(feature = "defmt", derive(defmt::Format))]
pub struct CarrierFreq {
    pub freq: B24,
}

impl radio::Register for CarrierFreq {
    const ADDRESS: u8 = 0x07;
    type Word = [u8; 3];
    type Error = Infallible;
}

impl From<[u8; 3]> for CarrierFreq {
    fn from(bytes: [u8; 3]) -> Self {
        CarrierFreq::from_bytes(bytes)
    }
}

impl From<CarrierFreq> for [u8; 3] {
    fn from(reg: CarrierFreq) -> Self {
        reg.into_bytes()
    }
}

#[bitfield]
#[derive(Copy, Clone, PartialEq, Debug)]
#[cfg_attr(feature = "serde", derive(serde::Deserialize, serde::Serialize))]
#[cfg_attr(feature = "defmt", derive(defmt::Format))]
#[repr(u8)]
pub struct Oscillator {
    #[skip]
    __: B6,
    pub rc_cal_done: bool,
    pub rc_cal_start: bool,
}

impl radio::Register for Oscillator {
    const ADDRESS: u8 = 0x0A;
    type Word = u8;
    type Error = Infallible;
}

#[bitfield]
#[derive(Copy, Clone, PartialEq, Debug)]
#[cfg_attr(feature = "serde", derive(serde::Deserialize, serde::Serialize))]
#[cfg_attr(feature = "defmt", derive(defmt::Format))]
#[repr(u8)]
pub struct AfcControl {
    #[skip]
    __: B5,
    pub low_beta_on: bool,
    #[skip]
    __2: B2,
}

impl radio::Register for AfcControl {
    const ADDRESS: u8 = 0x0B;
    type Word = u8;
    type Error = Infallible;
}

/// Action taken after acceptance of a packet in Listen mode
#[derive(BitfieldSpecifier, Copy, Clone, PartialEq, Debug)]
#[cfg_attr(feature = "serde", derive(serde::Deserialize, serde::Serialize))]
#[cfg_attr(feature = "defmt", derive(defmt::Format))]
#[bits = 2]
pub enum ListenEnd {
    Rx = 0,
    Mode = 1,
    Idle = 2,
}

/// Criteria for packet acceptance in Listen mode
#[derive(BitfieldSpecifier, Copy, Clone, PartialEq, Debug)]
#[cfg_attr(feature = "serde", derive(serde::Deserialize, serde::Serialize))]
#[bits = 1]
pub enum ListenCriteria {
    Rssi = 0,
    RssiAndSync = 1,
}

/// Criteria for packet acceptance in Listen mode
#[derive(BitfieldSpecifier, Copy, Clone, PartialEq, Debug)]
#[cfg_attr(feature = "serde", derive(serde::Deserialize, serde::Serialize))]
#[cfg_attr(feature = "defmt", derive(defmt::Format))]
#[bits = 2]
pub enum ListenBaseDuration {
    Dur64us = 0,
    Dur4_1ms = 1,
    Dur262ms = 2,
}

#[bitfield]
#[derive(Copy, Clone, PartialEq, Debug)]
#[cfg_attr(feature = "serde", derive(serde::Deserialize, serde::Serialize))]
#[cfg_attr(feature = "defmt", derive(defmt::Format))]
pub struct Listen {
    #[skip]
    __: B1,
    pub end: ListenEnd,
    pub criteria: ListenCriteria,
    pub rx_base: ListenBaseDuration,
    pub idle_base: ListenBaseDuration,
    // Idle duration = coeff_idle * idle_base_time
    pub coeff_idle: u8,
    // RX duration = coeff_idle * idle_base_time
    pub coeff_rx: u8,
}

impl radio::Register for Listen {
    const ADDRESS: u8 = 0x0D;
    type Word = [u8; 3];
    type Error = Infallible;
}

impl From<[u8; 3]> for Listen {
    fn from(bytes: [u8; 3]) -> Self {
        Listen::from_bytes(bytes)
    }
}

impl From<Listen> for [u8; 3] {
    fn from(listen: Listen) -> Self {
        listen.into_bytes()
    }
}

#[bitfield]
#[derive(Copy, Clone, PartialEq, Debug)]
#[cfg_attr(feature = "serde", derive(serde::Deserialize, serde::Serialize))]
#[cfg_attr(feature = "defmt", derive(defmt::Format))]
#[repr(u8)]
pub struct AfcFei {
    #[skip]
    __: B5,
    pub afc_auto_on: bool,
    pub afc_clear: bool,
    pub afc_start: bool,
}

impl radio::Register for AfcFei {
    const ADDRESS: u8 = 0x0E;
    type Word = u8;
    type Error = Infallible;
}

#[bitfield]
#[derive(Copy, Clone, PartialEq, Debug)]
#[cfg_attr(feature = "serde", derive(serde::Deserialize, serde::Serialize))]
#[cfg_attr(feature = "defmt", derive(defmt::Format))]
#[repr(u8)]
pub struct Version {
    pub version: u8,
}

impl radio::Register for Version {
    const ADDRESS: u8 = 0x10;
    type Word = u8;
    type Error = Infallible;
}

#[bitfield]
#[derive(Copy, Clone, PartialEq, Debug)]
#[cfg_attr(feature = "serde", derive(serde::Deserialize, serde::Serialize))]
#[cfg_attr(feature = "defmt", derive(defmt::Format))]
#[repr(u8)]
pub struct PaLevel {
    pub level: B5,
    pub pa2_on: bool,
    pub pa1_on: bool,
    pub pa0_on: bool,
}

impl radio::Register for PaLevel {
    const ADDRESS: u8 = 0x11;
    type Word = u8;
    type Error = Infallible;
}

// Rise/Fall time of ramp up/down in FSK
#[derive(BitfieldSpecifier, Copy, Clone, PartialEq, Debug)]
#[cfg_attr(feature = "serde", derive(serde::Deserialize, serde::Serialize))]
#[cfg_attr(feature = "defmt", derive(defmt::Format))]
#[bits = 4]
pub enum RampTime {
    Ramp3400us = 0,
    Ramp2000us = 1,
    Ramp1000us = 2,
    Ramp500us = 3,
    Ramp250us = 4,
    Ramp125us = 5,
    Ramp100us = 6,
    Ramp62us = 7,
    Ramp50us = 8,
    Ramp40us = 9,
    Ramp31us = 10,
    Ramp25us = 11,
    Ramp20us = 12,
    Ramp15us = 13,
    Ramp12us = 14,
    Ramp10us = 15,
}

#[bitfield]
#[derive(Copy, Clone, PartialEq, Debug)]
#[cfg_attr(feature = "serde", derive(serde::Deserialize, serde::Serialize))]
#[cfg_attr(feature = "defmt", derive(defmt::Format))]
#[repr(u8)]
pub struct PaRamp {
    pub time: RampTime,
    #[skip]
    __: B4,
}

impl radio::Register for PaRamp {
    const ADDRESS: u8 = 0x12;
    type Word = u8;
    type Error = Infallible;
}

#[bitfield]
#[derive(Copy, Clone, PartialEq, Debug)]
#[cfg_attr(feature = "serde", derive(serde::Deserialize, serde::Serialize))]
#[cfg_attr(feature = "defmt", derive(defmt::Format))]
#[repr(u8)]
pub struct Ocp {
    pub trim: B4,
    pub ocp_on: bool,
    #[skip]
    __: B3,
}

impl radio::Register for Ocp {
    const ADDRESS: u8 = 0x13;
    type Word = u8;
    type Error = Infallible;
}

#[derive(BitfieldSpecifier, Copy, Clone, PartialEq, Debug)]
#[cfg_attr(feature = "serde", derive(serde::Deserialize, serde::Serialize))]
#[cfg_attr(feature = "defmt", derive(defmt::Format))]
#[bits = 3]
pub enum LnaGainSelect {
    Agc = 0,
    G1 = 1,
    G2 = 2,
    G3 = 3,
    G4 = 4,
    G5 = 5,
    G6 = 6,
}

#[derive(BitfieldSpecifier, Copy, Clone, PartialEq, Debug)]
#[cfg_attr(feature = "serde", derive(serde::Deserialize, serde::Serialize))]
#[cfg_attr(feature = "defmt", derive(defmt::Format))]
#[bits = 1]
pub enum LnaZin {
    Zin50Ohm = 0,
    Zin200Ohm = 1,
}

#[bitfield]
#[derive(BitfieldSpecifier, Copy, Clone, PartialEq, Debug)]
#[cfg_attr(feature = "serde", derive(serde::Deserialize, serde::Serialize))]
#[cfg_attr(feature = "defmt", derive(defmt::Format))]
#[repr(u8)]
pub struct Lna {
    pub gain_select: LnaGainSelect,
    pub current_gain: B3,
    #[skip]
    __: B1,
    pub zin: LnaZin,
}

impl radio::Register for Lna {
    const ADDRESS: u8 = 0x18;
    type Word = u8;
    type Error = Infallible;
}

// FSK bandwidth register values
#[derive(BitfieldSpecifier, Copy, Clone, PartialEq, Debug)]
#[cfg_attr(feature = "serde", derive(serde::Deserialize, serde::Serialize))]
#[cfg_attr(feature = "defmt", derive(defmt::Format))]
#[bits = 5]
pub enum Bandwidth {
    Bw2600 = 0x17,
    Bw3100 = 0x0F,
    Bw3900 = 0x07,
    Bw5200 = 0x16,
    Bw6300 = 0x0E,
    Bw7800 = 0x06,
    Bw10400 = 0x15,
    Bw12500 = 0x0D,
    Bw15600 = 0x05,
    Bw20800 = 0x14,
    Bw25000 = 0x0C,
    Bw31300 = 0x04,
    Bw41700 = 0x13,
    Bw50000 = 0x0B,
    Bw62500 = 0x03,
    Bw83333 = 0x12,
    Bw100000 = 0x0A,
    Bw125000 = 0x02,
    Bw166700 = 0x11,
    Bw200000 = 0x09,
    Bw250000 = 0x01,
}

#[derive(BitfieldSpecifier, Copy, Clone, PartialEq, Debug)]
#[cfg_attr(feature = "serde", derive(serde::Deserialize, serde::Serialize))]
#[cfg_attr(feature = "defmt", derive(defmt::Format))]
#[bits = 3]
pub enum DccFreq {
    Fc16 = 0,
    Fc8 = 1,
    Fc4 = 2,
    Fc2 = 3,
    Fc1 = 4,
    Fc05 = 5,
    Fc025 = 6,
    Fc0125 = 7,
}

#[bitfield]
#[derive(Copy, Clone, PartialEq, Debug)]
#[cfg_attr(feature = "serde", derive(serde::Deserialize, serde::Serialize))]
#[cfg_attr(feature = "defmt", derive(defmt::Format))]
#[repr(u8)]
pub struct RxBw {
    pub bw: Bandwidth,
    pub dcc: DccFreq,
}

impl radio::Register for RxBw {
    const ADDRESS: u8 = 0x19;
    type Word = u8;
    type Error = Infallible;
}

#[bitfield]
#[derive(Copy, Clone, PartialEq, Debug)]
#[cfg_attr(feature = "serde", derive(serde::Deserialize, serde::Serialize))]
#[cfg_attr(feature = "defmt", derive(defmt::Format))]
#[repr(u8)]
pub struct AfcBw {
    pub bw: Bandwidth,
    pub dcc: DccFreq,
}

impl radio::Register for AfcBw {
    const ADDRESS: u8 = 0x20;
    type Word = u8;
    type Error = Infallible;
}

#[bitfield]
#[derive(Copy, Clone, PartialEq, Debug)]
#[cfg_attr(feature = "serde", derive(serde::Deserialize, serde::Serialize))]
#[repr(u8)]
pub struct RssiConfig {
    pub start: bool,
    pub done: bool,
    #[skip]
    __: B6,
}

impl radio::Register for RssiConfig {
    const ADDRESS: u8 = 0x23;
    type Word = u8;
    type Error = Infallible;
}

#[bitfield]
#[derive(Copy, Clone, PartialEq, Debug)]
#[cfg_attr(feature = "serde", derive(serde::Deserialize, serde::Serialize))]
#[cfg_attr(feature = "defmt", derive(defmt::Format))]
#[repr(u8)]
pub struct RssiValue {
    pub value: u8,
}

impl radio::Register for RssiValue {
    const ADDRESS: u8 = 0x24;
    type Word = u8;
    type Error = Infallible;
}

#[bitfield]
#[derive(Copy, Clone, PartialEq)]
#[cfg_attr(feature = "serde", derive(serde::Deserialize, serde::Serialize))]
#[cfg_attr(feature = "defmt", derive(defmt::Format))]
#[repr(u16)]
pub struct IrqFlags {
    pub sync_address_match: bool,
    pub auto_mode: bool,
    pub timeout: bool,
    pub rssi: bool,
    pub pll_lock: bool,
    pub tx_ready: bool,
    pub rx_ready: bool,
    pub mode_ready: bool,
    #[skip]
    __: bool,
    pub crc_ok: bool,
    pub payload_ready: bool,
    pub packet_sent: bool,
    pub fifo_overrun: bool,
    pub fifo_level: bool,
    pub fifo_not_empty: bool,
    pub fifo_full: bool,
}

impl radio::Register for IrqFlags {
    const ADDRESS: u8 = 0x27;
    type Word = u16;
    type Error = Infallible;
}

// #[cfg(feature = "std")]
impl core::fmt::Debug for IrqFlags {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        if self.sync_address_match() {
            f.write_str("SyncAddressMatch ")?;
        }
        if self.auto_mode() {
            f.write_str("AutoMode ")?;
        }
        if self.timeout() {
            f.write_str("Timeout ")?;
        }
        if self.rssi() {
            f.write_str("Rssi ")?;
        }
        if self.pll_lock() {
            f.write_str("PllLock ")?;
        }
        if self.tx_ready() {
            f.write_str("TxReady ")?;
        }
        if self.rx_ready() {
            f.write_str("RxReady ")?;
        }
        if self.mode_ready() {
            f.write_str("ModeReady ")?;
        }
        if self.crc_ok() {
            f.write_str("CrcOk ")?;
        }
        if self.payload_ready() {
            f.write_str("PayloadReady ")?;
        }
        if self.packet_sent() {
            f.write_str("PacketSent ")?;
        }
        if self.fifo_overrun() {
            f.write_str("FifoOverrun ")?;
        }
        if self.fifo_level() {
            f.write_str("FifoLevel ")?;
        }
        if self.fifo_not_empty() {
            f.write_str("FifoNotEmpty ")?;
        }
        if self.fifo_full() {
            f.write_str("FifoFull ")?;
        }
        Ok(())
    }
}

#[bitfield]
#[derive(Copy, Clone, PartialEq, Debug)]
#[cfg_attr(feature = "serde", derive(serde::Deserialize, serde::Serialize))]
#[cfg_attr(feature = "defmt", derive(defmt::Format))]
#[repr(u8)]
pub struct RssiThreshold {
    pub value: u8,
}

impl radio::Register for RssiThreshold {
    const ADDRESS: u8 = 0x29;
    type Word = u8;
    type Error = Infallible;
}

#[bitfield]
#[derive(Copy, Clone, PartialEq, Debug)]
#[cfg_attr(feature = "serde", derive(serde::Deserialize, serde::Serialize))]
#[cfg_attr(feature = "defmt", derive(defmt::Format))]
#[repr(u8)]
pub struct TimeoutRssiThresh {
    pub value: u8,
}

impl radio::Register for TimeoutRssiThresh {
    const ADDRESS: u8 = 0x2B;
    type Word = u8;
    type Error = Infallible;
}

#[bitfield]
#[derive(Copy, Clone, PartialEq, Debug)]
#[cfg_attr(feature = "serde", derive(serde::Deserialize, serde::Serialize))]
#[cfg_attr(feature = "defmt", derive(defmt::Format))]
#[repr(u16)]
pub struct Preamble {
    pub length: u16,
}

impl radio::Register for Preamble {
    const ADDRESS: u8 = 0x2c;
    type Word = u16;
    type Error = Infallible;
}

#[derive(BitfieldSpecifier, Copy, Clone, PartialEq, Debug)]
#[cfg_attr(feature = "serde", derive(serde::Deserialize, serde::Serialize))]
#[cfg_attr(feature = "defmt", derive(defmt::Format))]
#[bits = 1]
pub enum FifoFillCondition {
    SyncAddressInterrupt = 0,
    FifoFillConditionBit = 1,
}

#[bitfield]
#[derive(Copy, Clone, PartialEq, Debug)]
#[cfg_attr(feature = "serde", derive(serde::Deserialize, serde::Serialize))]
#[cfg_attr(feature = "defmt", derive(defmt::Format))]
#[repr(u8)]
pub struct SyncConfig {
    pub tolerated_bit_errors: B3,
    pub size_minus_one: B3,
    pub fifo_fill_condition: FifoFillCondition,
    pub sync_on: bool,
}

impl radio::Register for SyncConfig {
    const ADDRESS: u8 = 0x2e;
    type Word = u8;
    type Error = Infallible;
}

#[bitfield]
#[derive(Copy, Clone, PartialEq, Debug)]
#[cfg_attr(feature = "serde", derive(serde::Deserialize, serde::Serialize))]
#[cfg_attr(feature = "defmt", derive(defmt::Format))]
#[repr(u64)]
pub struct SyncValue {
    pub value: B64,
}

impl radio::Register for SyncValue {
    const ADDRESS: u8 = 0x2f;
    type Word = u64;
    type Error = Infallible;
}

#[derive(BitfieldSpecifier, Copy, Clone, PartialEq, Debug)]
#[cfg_attr(feature = "serde", derive(serde::Deserialize, serde::Serialize))]
#[cfg_attr(feature = "defmt", derive(defmt::Format))]
#[bits = 2]
pub enum AddressFilter {
    Off = 0,
    MatchNode = 1,
    MatchNodeOrBroadcast = 2,
}

#[derive(BitfieldSpecifier, Copy, Clone, PartialEq, Debug)]
#[cfg_attr(feature = "serde", derive(serde::Deserialize, serde::Serialize))]
#[cfg_attr(feature = "defmt", derive(defmt::Format))]
#[bits = 1]
pub enum CrcAutoClear {
    On = 0,
    Off = 1,
}

#[derive(BitfieldSpecifier, Copy, Clone, PartialEq, Debug)]
#[cfg_attr(feature = "serde", derive(serde::Deserialize, serde::Serialize))]
#[cfg_attr(feature = "defmt", derive(defmt::Format))]
#[bits = 1]
pub enum Crc {
    Off = 0,
    On = 1,
}

#[derive(BitfieldSpecifier, Copy, Clone, PartialEq, Debug)]
#[cfg_attr(feature = "serde", derive(serde::Deserialize, serde::Serialize))]
#[cfg_attr(feature = "defmt", derive(defmt::Format))]
#[bits = 2]
pub enum DcFree {
    Off = 0,
    Manchester = 1,
    Whitening = 2,
}

#[derive(BitfieldSpecifier, Copy, Clone, PartialEq, Debug)]
#[cfg_attr(feature = "serde", derive(serde::Deserialize, serde::Serialize))]
#[cfg_attr(feature = "defmt", derive(defmt::Format))]
#[bits = 1]
pub enum PacketFormat {
    Fixed = 0,
    Variable = 1,
}

#[bitfield]
#[derive(Copy, Clone, PartialEq, Debug)]
#[cfg_attr(feature = "serde", derive(serde::Deserialize, serde::Serialize))]
#[cfg_attr(feature = "defmt", derive(defmt::Format))]
#[repr(u8)]
pub struct PacketConfig1 {
    #[skip]
    __: B1,
    pub address_filter: AddressFilter,
    pub crc_auto_clear: CrcAutoClear,
    pub crc: Crc,
    pub dc_free: DcFree,
    pub packet_format: PacketFormat,
}

impl radio::Register for PacketConfig1 {
    const ADDRESS: u8 = 0x37;
    type Word = u8;
    type Error = Infallible;
}

#[bitfield]
#[derive(Copy, Clone, PartialEq, Debug)]
#[cfg_attr(feature = "serde", derive(serde::Deserialize, serde::Serialize))]
#[cfg_attr(feature = "defmt", derive(defmt::Format))]
#[repr(u8)]
pub struct PayloadLength {
    pub length: u8,
}

impl radio::Register for PayloadLength {
    const ADDRESS: u8 = 0x38;
    type Word = u8;
    type Error = Infallible;
}

#[derive(BitfieldSpecifier, Copy, Clone, PartialEq, Debug)]
#[cfg_attr(feature = "serde", derive(serde::Deserialize, serde::Serialize))]
#[cfg_attr(feature = "defmt", derive(defmt::Format))]
#[bits = 1]
pub enum TxStartCondition {
    /// The number of bytes in the FIFO exceeds FifoThreshold.
    FifoLevel = 0,
    /// At least one byte in the FIFO
    FifoNotEmpty = 1,
}

#[bitfield]
#[derive(Copy, Clone, PartialEq, Debug)]
#[cfg_attr(feature = "serde", derive(serde::Deserialize, serde::Serialize))]
#[cfg_attr(feature = "defmt", derive(defmt::Format))]
#[repr(u8)]
pub struct FifoThreshold {
    pub threshold: B7,
    pub start_condition: TxStartCondition,
}

impl radio::Register for FifoThreshold {
    const ADDRESS: u8 = 0x3C;
    type Word = u8;
    type Error = Infallible;
}

#[derive(BitfieldSpecifier, Copy, Clone, PartialEq, Debug)]
#[cfg_attr(feature = "serde", derive(serde::Deserialize, serde::Serialize))]
#[cfg_attr(feature = "defmt", derive(defmt::Format))]
#[bits = 1]
pub enum Aes {
    Off = 0,
    On = 1,
}

#[derive(BitfieldSpecifier, Copy, Clone, PartialEq, Debug)]
#[cfg_attr(feature = "serde", derive(serde::Deserialize, serde::Serialize))]
#[cfg_attr(feature = "defmt", derive(defmt::Format))]
#[bits = 1]
pub enum AutoRxRestart {
    Off = 0,
    On = 1,
}

#[bitfield]
#[derive(Copy, Clone, PartialEq, Debug)]
#[cfg_attr(feature = "serde", derive(serde::Deserialize, serde::Serialize))]
#[cfg_attr(feature = "defmt", derive(defmt::Format))]
#[repr(u8)]
pub struct PacketConfig2 {
    pub aes: Aes,
    pub auto_rx_restart: AutoRxRestart,
    pub rx_restart: bool,
    pub inter_packet_rx_delay: B5,
}

impl radio::Register for PacketConfig2 {
    const ADDRESS: u8 = 0x3D;
    type Word = u8;
    type Error = Infallible;
}

#[derive(BitfieldSpecifier, Copy, Clone, PartialEq, Debug)]
#[cfg_attr(feature = "serde", derive(serde::Deserialize, serde::Serialize))]
#[cfg_attr(feature = "defmt", derive(defmt::Format))]
#[bits = 8]
pub enum SensitivityBoost {
    NormalMode = 0x1B,
    HighSensitivity = 0x2D,
}

#[bitfield]
#[derive(Copy, Clone, PartialEq, Debug)]
#[cfg_attr(feature = "serde", derive(serde::Deserialize, serde::Serialize))]
#[cfg_attr(feature = "defmt", derive(defmt::Format))]
#[repr(u8)]
pub struct TestLna {
    pub sensitivity_boost: SensitivityBoost,
}

impl radio::Register for TestLna {
    const ADDRESS: u8 = 0x6F;
    type Word = u8;
    type Error = Infallible;
}

#[derive(BitfieldSpecifier, Copy, Clone, PartialEq, Debug)]
#[cfg_attr(feature = "serde", derive(serde::Deserialize, serde::Serialize))]
#[cfg_attr(feature = "defmt", derive(defmt::Format))]
#[bits = 8]
pub enum ContinousDagc {
    NormalMode = 0x10,
    ImprovedMarginLowBetaOn = 0x20,
    ImprovedMarginLowBetaOff = 0x30,
}

#[bitfield]
#[derive(Copy, Clone, PartialEq, Debug)]
#[cfg_attr(feature = "serde", derive(serde::Deserialize, serde::Serialize))]
#[cfg_attr(feature = "defmt", derive(defmt::Format))]
#[repr(u8)]
pub struct TestDagc {
    pub continous_dagc: ContinousDagc,
}

impl radio::Register for TestDagc {
    const ADDRESS: u8 = 0x6F;
    type Word = u8;
    type Error = Infallible;
}

#[bitfield]
#[derive(Copy, Clone, PartialEq, Debug)]
#[cfg_attr(feature = "serde", derive(serde::Deserialize, serde::Serialize))]
#[cfg_attr(feature = "defmt", derive(defmt::Format))]
#[repr(u8)]
pub struct TestAfc {
    pub low_beta_offset: u8,
}

impl radio::Register for TestAfc {
    const ADDRESS: u8 = 0x71;
    type Word = u8;
    type Error = Infallible;
}
