use r_rg::Config;
use std::env;
use std::process;

fn main() {
    let config = Config::new(env::args()).unwrap_or_else(|err| {
        eprintln!("Problem parsing arguments: {}", err);
        process::exit(1)
    });

    println!("Searching for {} in {}", config.query, config.filename);

    if let Err(e) = r_rg::run(config) {
        eprintln!("Application error: {}", e);
        process::exit(1);
    }
}
