/* automatically generated by rust-bindgen 0.59.1 */

#[repr(C)]
#[derive(Copy, Clone, Debug, Default, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct __BindgenBitfieldUnit<Storage> {
    storage: Storage,
}
impl<Storage> __BindgenBitfieldUnit<Storage> {
    #[inline]
    pub const fn new(storage: Storage) -> Self {
        Self { storage }
    }
}
impl<Storage> __BindgenBitfieldUnit<Storage>
where
    Storage: AsRef<[u8]> + AsMut<[u8]>,
{
    #[inline]
    pub fn get_bit(&self, index: usize) -> bool {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = self.storage.as_ref()[byte_index];
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        byte & mask == mask
    }
    #[inline]
    pub fn set_bit(&mut self, index: usize, val: bool) {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = &mut self.storage.as_mut()[byte_index];
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        if val {
            *byte |= mask;
        } else {
            *byte &= !mask;
        }
    }
    #[inline]
    pub fn get(&self, bit_offset: usize, bit_width: u8) -> u64 {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        let mut val = 0;
        for i in 0..(bit_width as usize) {
            if self.get_bit(i + bit_offset) {
                let index = if cfg!(target_endian = "big") {
                    bit_width as usize - 1 - i
                } else {
                    i
                };
                val |= 1 << index;
            }
        }
        val
    }
    #[inline]
    pub fn set(&mut self, bit_offset: usize, bit_width: u8, val: u64) {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        for i in 0..(bit_width as usize) {
            let mask = 1 << i;
            let val_bit_is_set = val & mask == mask;
            let index = if cfg!(target_endian = "big") {
                bit_width as usize - 1 - i
            } else {
                i
            };
            self.set_bit(index + bit_offset, val_bit_is_set);
        }
    }
}
pub const _FILE_OFFSET_BITS: u32 = 64;
pub const R_VERSION_H: u32 = 1;
pub const R2_VERSION_COMMIT: u32 = 30797;
pub const R2_VERSION: &'static [u8; 6usize] = b"5.4.1\0";
pub const R2_VERSION_MAJOR: u32 = 5;
pub const R2_VERSION_MINOR: u32 = 4;
pub const R2_VERSION_PATCH: u32 = 1;
pub const R2_VERSION_NUMBER: u32 = 50401;
pub const R2_GITTAP: &'static [u8; 10usize] = b"5.4.0-git\0";
pub const R2_GITTIP: &'static [u8; 41usize] = b"9c2bd20abf77cdfdc2fea00ce17f907af0b65f74\0";
pub const R2_BIRTH: &'static [u8; 21usize] = b"2021-08-31__20:44:06\0";
pub const R_CHECKS_LEVEL: u32 = 2;
pub const DEBUGGER: u32 = 1;
pub const HAVE_DECL_ADDR_NO_RANDOMIZE: u32 = 0;
pub const HAVE_ARC4RANDOM_UNIFORM: u32 = 0;
pub const HAVE_EXPLICIT_BZERO: u32 = 0;
pub const HAVE_EXPLICIT_MEMSET: u32 = 0;
pub const HAVE_CLOCK_NANOSLEEP: u32 = 0;
pub const HAVE_SIGACTION: u32 = 0;
pub const WANT_THREADS: u32 = 1;
pub const WANT_CAPSTONE: u32 = 1;
pub const HAVE_GPERF: u32 = 1;
pub const R2_PREFIX: &'static [u8; 11usize] = b"/usr/local\0";
pub const R2_ETCDIR: &'static [u8; 5usize] = b"/etc\0";
pub const R2_LIBDIR: &'static [u8; 15usize] = b"/usr/local/lib\0";
pub const R2_INCDIR: &'static [u8; 24usize] = b"/usr/local/include/libr\0";
pub const R2_DATDIR: &'static [u8; 17usize] = b"/usr/local/share\0";
pub const R2_WWWROOT: &'static [u8; 35usize] = b"/usr/local/share/radare2/5.4.1/www\0";
pub const R2_PLUGINS: &'static [u8; 18usize] = b"lib/radare2/5.4.1\0";
pub const R2_EXTRAS: &'static [u8; 25usize] = b"lib/radare2-extras/5.4.1\0";
pub const R2_BINDINGS: &'static [u8; 27usize] = b"lib/radare2-bindings/5.4.1\0";
pub const HAVE_LIB_MAGIC: u32 = 1;
pub const USE_LIB_MAGIC: u32 = 0;
pub const HAVE_LIB_XXHASH: u32 = 0;
pub const USE_LIB_XXHASH: u32 = 0;
pub const HAVE_LIB_SSL: u32 = 0;
pub const HAVE_LIBUV: u32 = 1;
pub const HAVE_PTRACE: u32 = 1;
pub const USE_PTRACE_WRAP: u32 = 0;
pub const HAVE_FORK: u32 = 1;
pub const WANT_DYLINK: u32 = 1;
pub const WITH_GPL: u32 = 1;
pub const HAVE_JEMALLOC: u32 = 1;
pub const __API_TO_BE_DEPRECATED: u32 = 100000;
pub const __MAC_10_0: u32 = 1000;
pub const __MAC_10_1: u32 = 1010;
pub const __MAC_10_2: u32 = 1020;
pub const __MAC_10_3: u32 = 1030;
pub const __MAC_10_4: u32 = 1040;
pub const __MAC_10_5: u32 = 1050;
pub const __MAC_10_6: u32 = 1060;
pub const __MAC_10_7: u32 = 1070;
pub const __MAC_10_8: u32 = 1080;
pub const __MAC_10_9: u32 = 1090;
pub const __MAC_10_10: u32 = 101000;
pub const __MAC_10_10_2: u32 = 101002;
pub const __MAC_10_10_3: u32 = 101003;
pub const __MAC_10_11: u32 = 101100;
pub const __MAC_10_11_2: u32 = 101102;
pub const __MAC_10_11_3: u32 = 101103;
pub const __MAC_10_11_4: u32 = 101104;
pub const __MAC_10_12: u32 = 101200;
pub const __MAC_10_12_1: u32 = 101201;
pub const __MAC_10_12_2: u32 = 101202;
pub const __MAC_10_12_4: u32 = 101204;
pub const __MAC_10_13: u32 = 101300;
pub const __MAC_10_13_1: u32 = 101301;
pub const __MAC_10_13_2: u32 = 101302;
pub const __MAC_10_13_4: u32 = 101304;
pub const __MAC_10_14: u32 = 101400;
pub const __MAC_10_14_1: u32 = 101401;
pub const __MAC_10_14_4: u32 = 101404;
pub const __MAC_10_15: u32 = 101500;
pub const __MAC_10_15_1: u32 = 101501;
pub const __MAC_10_15_4: u32 = 101504;
pub const __IPHONE_2_0: u32 = 20000;
pub const __IPHONE_2_1: u32 = 20100;
pub const __IPHONE_2_2: u32 = 20200;
pub const __IPHONE_3_0: u32 = 30000;
pub const __IPHONE_3_1: u32 = 30100;
pub const __IPHONE_3_2: u32 = 30200;
pub const __IPHONE_4_0: u32 = 40000;
pub const __IPHONE_4_1: u32 = 40100;
pub const __IPHONE_4_2: u32 = 40200;
pub const __IPHONE_4_3: u32 = 40300;
pub const __IPHONE_5_0: u32 = 50000;
pub const __IPHONE_5_1: u32 = 50100;
pub const __IPHONE_6_0: u32 = 60000;
pub const __IPHONE_6_1: u32 = 60100;
pub const __IPHONE_7_0: u32 = 70000;
pub const __IPHONE_7_1: u32 = 70100;
pub const __IPHONE_8_0: u32 = 80000;
pub const __IPHONE_8_1: u32 = 80100;
pub const __IPHONE_8_2: u32 = 80200;
pub const __IPHONE_8_3: u32 = 80300;
pub const __IPHONE_8_4: u32 = 80400;
pub const __IPHONE_9_0: u32 = 90000;
pub const __IPHONE_9_1: u32 = 90100;
pub const __IPHONE_9_2: u32 = 90200;
pub const __IPHONE_9_3: u32 = 90300;
pub const __IPHONE_10_0: u32 = 100000;
pub const __IPHONE_10_1: u32 = 100100;
pub const __IPHONE_10_2: u32 = 100200;
pub const __IPHONE_10_3: u32 = 100300;
pub const __IPHONE_11_0: u32 = 110000;
pub const __IPHONE_11_1: u32 = 110100;
pub const __IPHONE_11_2: u32 = 110200;
pub const __IPHONE_11_3: u32 = 110300;
pub const __IPHONE_11_4: u32 = 110400;
pub const __IPHONE_12_0: u32 = 120000;
pub const __IPHONE_12_1: u32 = 120100;
pub const __IPHONE_12_2: u32 = 120200;
pub const __IPHONE_12_3: u32 = 120300;
pub const __IPHONE_13_0: u32 = 130000;
pub const __IPHONE_13_1: u32 = 130100;
pub const __IPHONE_13_2: u32 = 130200;
pub const __IPHONE_13_3: u32 = 130300;
pub const __IPHONE_13_4: u32 = 130400;
pub const __IPHONE_13_5: u32 = 130500;
pub const __IPHONE_13_6: u32 = 130600;
pub const __TVOS_9_0: u32 = 90000;
pub const __TVOS_9_1: u32 = 90100;
pub const __TVOS_9_2: u32 = 90200;
pub const __TVOS_10_0: u32 = 100000;
pub const __TVOS_10_0_1: u32 = 100001;
pub const __TVOS_10_1: u32 = 100100;
pub const __TVOS_10_2: u32 = 100200;
pub const __TVOS_11_0: u32 = 110000;
pub const __TVOS_11_1: u32 = 110100;
pub const __TVOS_11_2: u32 = 110200;
pub const __TVOS_11_3: u32 = 110300;
pub const __TVOS_11_4: u32 = 110400;
pub const __TVOS_12_0: u32 = 120000;
pub const __TVOS_12_1: u32 = 120100;
pub const __TVOS_12_2: u32 = 120200;
pub const __TVOS_12_3: u32 = 120300;
pub const __TVOS_13_0: u32 = 130000;
pub const __TVOS_13_2: u32 = 130200;
pub const __TVOS_13_3: u32 = 130300;
pub const __TVOS_13_4: u32 = 130400;
pub const __WATCHOS_1_0: u32 = 10000;
pub const __WATCHOS_2_0: u32 = 20000;
pub const __WATCHOS_2_1: u32 = 20100;
pub const __WATCHOS_2_2: u32 = 20200;
pub const __WATCHOS_3_0: u32 = 30000;
pub const __WATCHOS_3_1: u32 = 30100;
pub const __WATCHOS_3_1_1: u32 = 30101;
pub const __WATCHOS_3_2: u32 = 30200;
pub const __WATCHOS_4_0: u32 = 40000;
pub const __WATCHOS_4_1: u32 = 40100;
pub const __WATCHOS_4_2: u32 = 40200;
pub const __WATCHOS_4_3: u32 = 40300;
pub const __WATCHOS_5_0: u32 = 50000;
pub const __WATCHOS_5_1: u32 = 50100;
pub const __WATCHOS_5_2: u32 = 50200;
pub const __WATCHOS_6_0: u32 = 60000;
pub const __WATCHOS_6_1: u32 = 60100;
pub const __WATCHOS_6_2: u32 = 60200;
pub const __DRIVERKIT_19_0: u32 = 190000;
pub const __MAC_OS_X_VERSION_MAX_ALLOWED: u32 = 101500;
pub const __ENABLE_LEGACY_MAC_AVAILABILITY: u32 = 1;
pub const __DARWIN_ONLY_64_BIT_INO_T: u32 = 0;
pub const __DARWIN_ONLY_VERS_1050: u32 = 0;
pub const __DARWIN_ONLY_UNIX_CONFORMANCE: u32 = 1;
pub const __DARWIN_UNIX03: u32 = 1;
pub const __DARWIN_64_BIT_INO_T: u32 = 1;
pub const __DARWIN_VERS_1050: u32 = 1;
pub const __DARWIN_NON_CANCELABLE: u32 = 0;
pub const __DARWIN_SUF_64_BIT_INO_T: &'static [u8; 9usize] = b"$INODE64\0";
pub const __DARWIN_SUF_1050: &'static [u8; 6usize] = b"$1050\0";
pub const __DARWIN_SUF_EXTSN: &'static [u8; 14usize] = b"$DARWIN_EXTSN\0";
pub const __DARWIN_C_ANSI: u32 = 4096;
pub const __DARWIN_C_FULL: u32 = 900000;
pub const __DARWIN_C_LEVEL: u32 = 900000;
pub const __STDC_WANT_LIB_EXT1__: u32 = 1;
pub const __DARWIN_NO_LONG_LONG: u32 = 0;
pub const _DARWIN_FEATURE_64_BIT_INODE: u32 = 1;
pub const _DARWIN_FEATURE_ONLY_UNIX_CONFORMANCE: u32 = 1;
pub const _DARWIN_FEATURE_UNIX_CONFORMANCE: u32 = 3;
pub const __PTHREAD_SIZE__: u32 = 8176;
pub const __PTHREAD_ATTR_SIZE__: u32 = 56;
pub const __PTHREAD_MUTEXATTR_SIZE__: u32 = 8;
pub const __PTHREAD_MUTEX_SIZE__: u32 = 56;
pub const __PTHREAD_CONDATTR_SIZE__: u32 = 8;
pub const __PTHREAD_COND_SIZE__: u32 = 40;
pub const __PTHREAD_ONCE_SIZE__: u32 = 8;
pub const __PTHREAD_RWLOCK_SIZE__: u32 = 192;
pub const __PTHREAD_RWLOCKATTR_SIZE__: u32 = 16;
pub const __DARWIN_WCHAR_MIN: i32 = -2147483648;
pub const _FORTIFY_SOURCE: u32 = 2;
pub const __DARWIN_NSIG: u32 = 32;
pub const NSIG: u32 = 32;
pub const _I386_SIGNAL_H_: u32 = 1;
pub const SIGHUP: u32 = 1;
pub const SIGINT: u32 = 2;
pub const SIGQUIT: u32 = 3;
pub const SIGILL: u32 = 4;
pub const SIGTRAP: u32 = 5;
pub const SIGABRT: u32 = 6;
pub const SIGIOT: u32 = 6;
pub const SIGEMT: u32 = 7;
pub const SIGFPE: u32 = 8;
pub const SIGKILL: u32 = 9;
pub const SIGBUS: u32 = 10;
pub const SIGSEGV: u32 = 11;
pub const SIGSYS: u32 = 12;
pub const SIGPIPE: u32 = 13;
pub const SIGALRM: u32 = 14;
pub const SIGTERM: u32 = 15;
pub const SIGURG: u32 = 16;
pub const SIGSTOP: u32 = 17;
pub const SIGTSTP: u32 = 18;
pub const SIGCONT: u32 = 19;
pub const SIGCHLD: u32 = 20;
pub const SIGTTIN: u32 = 21;
pub const SIGTTOU: u32 = 22;
pub const SIGIO: u32 = 23;
pub const SIGXCPU: u32 = 24;
pub const SIGXFSZ: u32 = 25;
pub const SIGVTALRM: u32 = 26;
pub const SIGPROF: u32 = 27;
pub const SIGWINCH: u32 = 28;
pub const SIGINFO: u32 = 29;
pub const SIGUSR1: u32 = 30;
pub const SIGUSR2: u32 = 31;
pub const FP_PREC_24B: u32 = 0;
pub const FP_PREC_53B: u32 = 2;
pub const FP_PREC_64B: u32 = 3;
pub const FP_RND_NEAR: u32 = 0;
pub const FP_RND_DOWN: u32 = 1;
pub const FP_RND_UP: u32 = 2;
pub const FP_CHOP: u32 = 3;
pub const FP_STATE_BYTES: u32 = 512;
pub const SIGEV_NONE: u32 = 0;
pub const SIGEV_SIGNAL: u32 = 1;
pub const SIGEV_THREAD: u32 = 3;
pub const ILL_NOOP: u32 = 0;
pub const ILL_ILLOPC: u32 = 1;
pub const ILL_ILLTRP: u32 = 2;
pub const ILL_PRVOPC: u32 = 3;
pub const ILL_ILLOPN: u32 = 4;
pub const ILL_ILLADR: u32 = 5;
pub const ILL_PRVREG: u32 = 6;
pub const ILL_COPROC: u32 = 7;
pub const ILL_BADSTK: u32 = 8;
pub const FPE_NOOP: u32 = 0;
pub const FPE_FLTDIV: u32 = 1;
pub const FPE_FLTOVF: u32 = 2;
pub const FPE_FLTUND: u32 = 3;
pub const FPE_FLTRES: u32 = 4;
pub const FPE_FLTINV: u32 = 5;
pub const FPE_FLTSUB: u32 = 6;
pub const FPE_INTDIV: u32 = 7;
pub const FPE_INTOVF: u32 = 8;
pub const SEGV_NOOP: u32 = 0;
pub const SEGV_MAPERR: u32 = 1;
pub const SEGV_ACCERR: u32 = 2;
pub const BUS_NOOP: u32 = 0;
pub const BUS_ADRALN: u32 = 1;
pub const BUS_ADRERR: u32 = 2;
pub const BUS_OBJERR: u32 = 3;
pub const TRAP_BRKPT: u32 = 1;
pub const TRAP_TRACE: u32 = 2;
pub const CLD_NOOP: u32 = 0;
pub const CLD_EXITED: u32 = 1;
pub const CLD_KILLED: u32 = 2;
pub const CLD_DUMPED: u32 = 3;
pub const CLD_TRAPPED: u32 = 4;
pub const CLD_STOPPED: u32 = 5;
pub const CLD_CONTINUED: u32 = 6;
pub const POLL_IN: u32 = 1;
pub const POLL_OUT: u32 = 2;
pub const POLL_MSG: u32 = 3;
pub const POLL_ERR: u32 = 4;
pub const POLL_PRI: u32 = 5;
pub const POLL_HUP: u32 = 6;
pub const SA_ONSTACK: u32 = 1;
pub const SA_RESTART: u32 = 2;
pub const SA_RESETHAND: u32 = 4;
pub const SA_NOCLDSTOP: u32 = 8;
pub const SA_NODEFER: u32 = 16;
pub const SA_NOCLDWAIT: u32 = 32;
pub const SA_SIGINFO: u32 = 64;
pub const SA_USERTRAMP: u32 = 256;
pub const SA_64REGSET: u32 = 512;
pub const SA_USERSPACE_MASK: u32 = 127;
pub const SIG_BLOCK: u32 = 1;
pub const SIG_UNBLOCK: u32 = 2;
pub const SIG_SETMASK: u32 = 3;
pub const SI_USER: u32 = 65537;
pub const SI_QUEUE: u32 = 65538;
pub const SI_TIMER: u32 = 65539;
pub const SI_ASYNCIO: u32 = 65540;
pub const SI_MESGQ: u32 = 65541;
pub const SS_ONSTACK: u32 = 1;
pub const SS_DISABLE: u32 = 4;
pub const MINSIGSTKSZ: u32 = 32768;
pub const SIGSTKSZ: u32 = 131072;
pub const SV_ONSTACK: u32 = 1;
pub const SV_INTERRUPT: u32 = 2;
pub const SV_RESETHAND: u32 = 4;
pub const SV_NODEFER: u32 = 16;
pub const SV_NOCLDSTOP: u32 = 8;
pub const SV_SIGINFO: u32 = 64;
pub const __WORDSIZE: u32 = 64;
pub const INT8_MAX: u32 = 127;
pub const INT16_MAX: u32 = 32767;
pub const INT32_MAX: u32 = 2147483647;
pub const INT64_MAX: u64 = 9223372036854775807;
pub const INT8_MIN: i32 = -128;
pub const INT16_MIN: i32 = -32768;
pub const INT32_MIN: i32 = -2147483648;
pub const INT64_MIN: i64 = -9223372036854775808;
pub const UINT8_MAX: u32 = 255;
pub const UINT16_MAX: u32 = 65535;
pub const UINT32_MAX: u32 = 4294967295;
pub const UINT64_MAX: i32 = -1;
pub const INT_LEAST8_MIN: i32 = -128;
pub const INT_LEAST16_MIN: i32 = -32768;
pub const INT_LEAST32_MIN: i32 = -2147483648;
pub const INT_LEAST64_MIN: i64 = -9223372036854775808;
pub const INT_LEAST8_MAX: u32 = 127;
pub const INT_LEAST16_MAX: u32 = 32767;
pub const INT_LEAST32_MAX: u32 = 2147483647;
pub const INT_LEAST64_MAX: u64 = 9223372036854775807;
pub const UINT_LEAST8_MAX: u32 = 255;
pub const UINT_LEAST16_MAX: u32 = 65535;
pub const UINT_LEAST32_MAX: u32 = 4294967295;
pub const UINT_LEAST64_MAX: i32 = -1;
pub const INT_FAST8_MIN: i32 = -128;
pub const INT_FAST16_MIN: i32 = -32768;
pub const INT_FAST32_MIN: i32 = -2147483648;
pub const INT_FAST64_MIN: i64 = -9223372036854775808;
pub const INT_FAST8_MAX: u32 = 127;
pub const INT_FAST16_MAX: u32 = 32767;
pub const INT_FAST32_MAX: u32 = 2147483647;
pub const INT_FAST64_MAX: u64 = 9223372036854775807;
pub const UINT_FAST8_MAX: u32 = 255;
pub const UINT_FAST16_MAX: u32 = 65535;
pub const UINT_FAST32_MAX: u32 = 4294967295;
pub const UINT_FAST64_MAX: i32 = -1;
pub const INTPTR_MAX: u64 = 9223372036854775807;
pub const INTPTR_MIN: i64 = -9223372036854775808;
pub const UINTPTR_MAX: i32 = -1;
pub const SIZE_MAX: i32 = -1;
pub const RSIZE_MAX: i32 = -1;
pub const WINT_MIN: i32 = -2147483648;
pub const WINT_MAX: u32 = 2147483647;
pub const SIG_ATOMIC_MIN: i32 = -2147483648;
pub const SIG_ATOMIC_MAX: u32 = 2147483647;
pub const PRIO_PROCESS: u32 = 0;
pub const PRIO_PGRP: u32 = 1;
pub const PRIO_USER: u32 = 2;
pub const PRIO_DARWIN_THREAD: u32 = 3;
pub const PRIO_DARWIN_PROCESS: u32 = 4;
pub const PRIO_MIN: i32 = -20;
pub const PRIO_MAX: u32 = 20;
pub const PRIO_DARWIN_BG: u32 = 4096;
pub const PRIO_DARWIN_NONUI: u32 = 4097;
pub const RUSAGE_SELF: u32 = 0;
pub const RUSAGE_CHILDREN: i32 = -1;
pub const RUSAGE_INFO_V0: u32 = 0;
pub const RUSAGE_INFO_V1: u32 = 1;
pub const RUSAGE_INFO_V2: u32 = 2;
pub const RUSAGE_INFO_V3: u32 = 3;
pub const RUSAGE_INFO_V4: u32 = 4;
pub const RUSAGE_INFO_CURRENT: u32 = 4;
pub const RLIMIT_CPU: u32 = 0;
pub const RLIMIT_FSIZE: u32 = 1;
pub const RLIMIT_DATA: u32 = 2;
pub const RLIMIT_STACK: u32 = 3;
pub const RLIMIT_CORE: u32 = 4;
pub const RLIMIT_AS: u32 = 5;
pub const RLIMIT_RSS: u32 = 5;
pub const RLIMIT_MEMLOCK: u32 = 6;
pub const RLIMIT_NPROC: u32 = 7;
pub const RLIMIT_NOFILE: u32 = 8;
pub const RLIM_NLIMITS: u32 = 9;
pub const _RLIMIT_POSIX_FLAG: u32 = 4096;
pub const RLIMIT_WAKEUPS_MONITOR: u32 = 1;
pub const RLIMIT_CPU_USAGE_MONITOR: u32 = 2;
pub const RLIMIT_THREAD_CPULIMITS: u32 = 3;
pub const RLIMIT_FOOTPRINT_INTERVAL: u32 = 4;
pub const WAKEMON_ENABLE: u32 = 1;
pub const WAKEMON_DISABLE: u32 = 2;
pub const WAKEMON_GET_PARAMS: u32 = 4;
pub const WAKEMON_SET_DEFAULTS: u32 = 8;
pub const WAKEMON_MAKE_FATAL: u32 = 16;
pub const CPUMON_MAKE_FATAL: u32 = 4096;
pub const FOOTPRINT_INTERVAL_RESET: u32 = 1;
pub const IOPOL_TYPE_DISK: u32 = 0;
pub const IOPOL_TYPE_VFS_ATIME_UPDATES: u32 = 2;
pub const IOPOL_TYPE_VFS_MATERIALIZE_DATALESS_FILES: u32 = 3;
pub const IOPOL_TYPE_VFS_STATFS_NO_DATA_VOLUME: u32 = 4;
pub const IOPOL_SCOPE_PROCESS: u32 = 0;
pub const IOPOL_SCOPE_THREAD: u32 = 1;
pub const IOPOL_SCOPE_DARWIN_BG: u32 = 2;
pub const IOPOL_DEFAULT: u32 = 0;
pub const IOPOL_IMPORTANT: u32 = 1;
pub const IOPOL_PASSIVE: u32 = 2;
pub const IOPOL_THROTTLE: u32 = 3;
pub const IOPOL_UTILITY: u32 = 4;
pub const IOPOL_STANDARD: u32 = 5;
pub const IOPOL_APPLICATION: u32 = 5;
pub const IOPOL_NORMAL: u32 = 1;
pub const IOPOL_ATIME_UPDATES_DEFAULT: u32 = 0;
pub const IOPOL_ATIME_UPDATES_OFF: u32 = 1;
pub const IOPOL_MATERIALIZE_DATALESS_FILES_DEFAULT: u32 = 0;
pub const IOPOL_MATERIALIZE_DATALESS_FILES_OFF: u32 = 1;
pub const IOPOL_MATERIALIZE_DATALESS_FILES_ON: u32 = 2;
pub const IOPOL_VFS_STATFS_NO_DATA_VOLUME_DEFAULT: u32 = 0;
pub const IOPOL_VFS_STATFS_FORCE_NO_DATA_VOLUME: u32 = 1;
pub const WNOHANG: u32 = 1;
pub const WUNTRACED: u32 = 2;
pub const WCOREFLAG: u32 = 128;
pub const _WSTOPPED: u32 = 127;
pub const WEXITED: u32 = 4;
pub const WSTOPPED: u32 = 8;
pub const WCONTINUED: u32 = 16;
pub const WNOWAIT: u32 = 32;
pub const WAIT_ANY: i32 = -1;
pub const WAIT_MYPGRP: u32 = 0;
pub const _QUAD_HIGHWORD: u32 = 1;
pub const _QUAD_LOWWORD: u32 = 0;
pub const __DARWIN_LITTLE_ENDIAN: u32 = 1234;
pub const __DARWIN_BIG_ENDIAN: u32 = 4321;
pub const __DARWIN_PDP_ENDIAN: u32 = 3412;
pub const __DARWIN_BYTE_ORDER: u32 = 1234;
pub const LITTLE_ENDIAN: u32 = 1234;
pub const BIG_ENDIAN: u32 = 4321;
pub const PDP_ENDIAN: u32 = 3412;
pub const BYTE_ORDER: u32 = 1234;
pub const EXIT_FAILURE: u32 = 1;
pub const EXIT_SUCCESS: u32 = 0;
pub const RAND_MAX: u32 = 2147483647;
pub const R_MODE_PRINT: u32 = 0;
pub const R_MODE_RADARE: u32 = 1;
pub const R_MODE_SET: u32 = 2;
pub const R_MODE_SIMPLE: u32 = 4;
pub const R_MODE_JSON: u32 = 8;
pub const R_MODE_ARRAY: u32 = 16;
pub const R_MODE_SIMPLEST: u32 = 32;
pub const R_MODE_CLASSDUMP: u32 = 64;
pub const R_MODE_EQUAL: u32 = 128;
pub const R_PERM_R: u32 = 4;
pub const R_PERM_W: u32 = 2;
pub const R_PERM_X: u32 = 1;
pub const R_PERM_RW: u32 = 6;
pub const R_PERM_RX: u32 = 5;
pub const R_PERM_RWX: u32 = 7;
pub const R_PERM_WX: u32 = 3;
pub const R_PERM_SHAR: u32 = 8;
pub const R_PERM_PRIV: u32 = 16;
pub const R_PERM_ACCESS: u32 = 32;
pub const R_PERM_CREAT: u32 = 64;
pub const TARGET_OS_IPHONE: u32 = 0;
pub const LIBC_HAVE_SYSTEM: u32 = 1;
pub const HAVE_SYSTEM: u32 = 1;
pub const LIBC_HAVE_PTRACE: u32 = 1;
pub const LIBC_HAVE_FORK: u32 = 1;
pub const LIBC_HAVE_PLEDGE: u32 = 0;
pub const LIBC_HAVE_PRIV_SET: u32 = 0;
pub const __KFBSD__: u32 = 0;
pub const __BSD__: u32 = 0;
pub const __UNIX__: u32 = 1;
pub const _CACHED_RUNES: u32 = 256;
pub const _CRMASK: i32 = -256;
pub const _RUNE_MAGIC_A: &'static [u8; 9usize] = b"RuneMagA\0";
pub const _CTYPE_A: u32 = 256;
pub const _CTYPE_C: u32 = 512;
pub const _CTYPE_D: u32 = 1024;
pub const _CTYPE_G: u32 = 2048;
pub const _CTYPE_L: u32 = 4096;
pub const _CTYPE_P: u32 = 8192;
pub const _CTYPE_S: u32 = 16384;
pub const _CTYPE_U: u32 = 32768;
pub const _CTYPE_X: u32 = 65536;
pub const _CTYPE_B: u32 = 131072;
pub const _CTYPE_R: u32 = 262144;
pub const _CTYPE_I: u32 = 524288;
pub const _CTYPE_T: u32 = 1048576;
pub const _CTYPE_Q: u32 = 2097152;
pub const _CTYPE_SW0: u32 = 536870912;
pub const _CTYPE_SW1: u32 = 1073741824;
pub const _CTYPE_SW2: u32 = 2147483648;
pub const _CTYPE_SW3: u32 = 3221225472;
pub const _CTYPE_SWM: u32 = 3758096384;
pub const _CTYPE_SWS: u32 = 30;
pub const __DARWIN_FD_SETSIZE: u32 = 1024;
pub const __DARWIN_NBBY: u32 = 8;
pub const NBBY: u32 = 8;
pub const FD_SETSIZE: u32 = 1024;
pub const __DARWIN_CLK_TCK: u32 = 100;
pub const CHAR_BIT: u32 = 8;
pub const MB_LEN_MAX: u32 = 6;
pub const CLK_TCK: u32 = 100;
pub const SCHAR_MAX: u32 = 127;
pub const SCHAR_MIN: i32 = -128;
pub const UCHAR_MAX: u32 = 255;
pub const CHAR_MAX: u32 = 127;
pub const CHAR_MIN: i32 = -128;
pub const USHRT_MAX: u32 = 65535;
pub const SHRT_MAX: u32 = 32767;
pub const SHRT_MIN: i32 = -32768;
pub const UINT_MAX: u32 = 4294967295;
pub const INT_MAX: u32 = 2147483647;
pub const INT_MIN: i32 = -2147483648;
pub const ULONG_MAX: i32 = -1;
pub const LONG_MAX: u64 = 9223372036854775807;
pub const LONG_MIN: i64 = -9223372036854775808;
pub const ULLONG_MAX: i32 = -1;
pub const LLONG_MAX: u64 = 9223372036854775807;
pub const LLONG_MIN: i64 = -9223372036854775808;
pub const LONG_BIT: u32 = 64;
pub const SSIZE_MAX: u64 = 9223372036854775807;
pub const WORD_BIT: u32 = 32;
pub const SIZE_T_MAX: i32 = -1;
pub const UQUAD_MAX: i32 = -1;
pub const QUAD_MAX: u64 = 9223372036854775807;
pub const QUAD_MIN: i64 = -9223372036854775808;
pub const ARG_MAX: u32 = 262144;
pub const CHILD_MAX: u32 = 266;
pub const GID_MAX: u32 = 2147483647;
pub const LINK_MAX: u32 = 32767;
pub const MAX_CANON: u32 = 1024;
pub const MAX_INPUT: u32 = 1024;
pub const NAME_MAX: u32 = 255;
pub const NGROUPS_MAX: u32 = 16;
pub const UID_MAX: u32 = 2147483647;
pub const OPEN_MAX: u32 = 10240;
pub const PATH_MAX: u32 = 1024;
pub const PIPE_BUF: u32 = 512;
pub const BC_BASE_MAX: u32 = 99;
pub const BC_DIM_MAX: u32 = 2048;
pub const BC_SCALE_MAX: u32 = 99;
pub const BC_STRING_MAX: u32 = 1000;
pub const CHARCLASS_NAME_MAX: u32 = 14;
pub const COLL_WEIGHTS_MAX: u32 = 2;
pub const EQUIV_CLASS_MAX: u32 = 2;
pub const EXPR_NEST_MAX: u32 = 32;
pub const LINE_MAX: u32 = 2048;
pub const RE_DUP_MAX: u32 = 255;
pub const NZERO: u32 = 20;
pub const _POSIX_ARG_MAX: u32 = 4096;
pub const _POSIX_CHILD_MAX: u32 = 25;
pub const _POSIX_LINK_MAX: u32 = 8;
pub const _POSIX_MAX_CANON: u32 = 255;
pub const _POSIX_MAX_INPUT: u32 = 255;
pub const _POSIX_NAME_MAX: u32 = 14;
pub const _POSIX_NGROUPS_MAX: u32 = 8;
pub const _POSIX_OPEN_MAX: u32 = 20;
pub const _POSIX_PATH_MAX: u32 = 256;
pub const _POSIX_PIPE_BUF: u32 = 512;
pub const _POSIX_SSIZE_MAX: u32 = 32767;
pub const _POSIX_STREAM_MAX: u32 = 8;
pub const _POSIX_TZNAME_MAX: u32 = 6;
pub const _POSIX2_BC_BASE_MAX: u32 = 99;
pub const _POSIX2_BC_DIM_MAX: u32 = 2048;
pub const _POSIX2_BC_SCALE_MAX: u32 = 99;
pub const _POSIX2_BC_STRING_MAX: u32 = 1000;
pub const _POSIX2_EQUIV_CLASS_MAX: u32 = 2;
pub const _POSIX2_EXPR_NEST_MAX: u32 = 32;
pub const _POSIX2_LINE_MAX: u32 = 2048;
pub const _POSIX2_RE_DUP_MAX: u32 = 255;
pub const _POSIX_AIO_LISTIO_MAX: u32 = 2;
pub const _POSIX_AIO_MAX: u32 = 1;
pub const _POSIX_DELAYTIMER_MAX: u32 = 32;
pub const _POSIX_MQ_OPEN_MAX: u32 = 8;
pub const _POSIX_MQ_PRIO_MAX: u32 = 32;
pub const _POSIX_RTSIG_MAX: u32 = 8;
pub const _POSIX_SEM_NSEMS_MAX: u32 = 256;
pub const _POSIX_SEM_VALUE_MAX: u32 = 32767;
pub const _POSIX_SIGQUEUE_MAX: u32 = 32;
pub const _POSIX_TIMER_MAX: u32 = 32;
pub const _POSIX_CLOCKRES_MIN: u32 = 20000000;
pub const _POSIX_THREAD_DESTRUCTOR_ITERATIONS: u32 = 4;
pub const _POSIX_THREAD_KEYS_MAX: u32 = 128;
pub const _POSIX_THREAD_THREADS_MAX: u32 = 64;
pub const PTHREAD_DESTRUCTOR_ITERATIONS: u32 = 4;
pub const PTHREAD_KEYS_MAX: u32 = 512;
pub const PTHREAD_STACK_MIN: u32 = 8192;
pub const _POSIX_HOST_NAME_MAX: u32 = 255;
pub const _POSIX_LOGIN_NAME_MAX: u32 = 9;
pub const _POSIX_SS_REPL_MAX: u32 = 4;
pub const _POSIX_SYMLINK_MAX: u32 = 255;
pub const _POSIX_SYMLOOP_MAX: u32 = 8;
pub const _POSIX_TRACE_EVENT_NAME_MAX: u32 = 30;
pub const _POSIX_TRACE_NAME_MAX: u32 = 8;
pub const _POSIX_TRACE_SYS_MAX: u32 = 8;
pub const _POSIX_TRACE_USER_EVENT_MAX: u32 = 32;
pub const _POSIX_TTY_NAME_MAX: u32 = 9;
pub const _POSIX2_CHARCLASS_NAME_MAX: u32 = 14;
pub const _POSIX2_COLL_WEIGHTS_MAX: u32 = 2;
pub const _POSIX_RE_DUP_MAX: u32 = 255;
pub const OFF_MIN: i64 = -9223372036854775808;
pub const OFF_MAX: u64 = 9223372036854775807;
pub const PASS_MAX: u32 = 128;
pub const NL_ARGMAX: u32 = 9;
pub const NL_LANGMAX: u32 = 14;
pub const NL_MSGMAX: u32 = 32767;
pub const NL_NMAX: u32 = 1;
pub const NL_SETMAX: u32 = 255;
pub const NL_TEXTMAX: u32 = 2048;
pub const _XOPEN_IOV_MAX: u32 = 16;
pub const IOV_MAX: u32 = 1024;
pub const _XOPEN_NAME_MAX: u32 = 255;
pub const _XOPEN_PATH_MAX: u32 = 1024;
pub const true_: u32 = 1;
pub const false_: u32 = 0;
pub const __bool_true_false_are_defined: u32 = 1;
pub const UT64_MAX: i32 = -1;
pub const UT64_GT0: i64 = -9223372036854775808;
pub const UT64_LT0: u64 = 9223372036854775807;
pub const UT64_MIN: u32 = 0;
pub const UT64_32U: i64 = -4294967296;
pub const UT64_16U: i32 = -65536;
pub const UT64_8U: i32 = -256;
pub const UT32_MIN: u32 = 0;
pub const UT16_MIN: u32 = 0;
pub const UT32_GT0: u32 = 2147483648;
pub const UT32_LT0: u32 = 2147483647;
pub const ST32_MAX: u32 = 2147483647;
pub const ST32_MIN: i32 = -2147483648;
pub const UT32_MAX: u32 = 4294967295;
pub const ST16_MAX: u32 = 32767;
pub const ST16_MIN: i32 = -32768;
pub const UT16_GT0: u32 = 32768;
pub const UT16_MAX: u32 = 65535;
pub const ST8_MAX: u32 = 127;
pub const ST8_MIN: i32 = -128;
pub const UT8_GT0: u32 = 128;
pub const UT8_MAX: u32 = 255;
pub const UT8_MIN: u32 = 0;
pub const ASCII_MIN: u32 = 32;
pub const ASCII_MAX: u32 = 127;
pub const SZT_MAX: i32 = -1;
pub const SZT_MIN: u32 = 0;
pub const B11111: u32 = 31;
pub const B11110: u32 = 30;
pub const B11101: u32 = 29;
pub const B11100: u32 = 28;
pub const B11011: u32 = 27;
pub const B11010: u32 = 26;
pub const B11001: u32 = 25;
pub const B11000: u32 = 24;
pub const B10111: u32 = 23;
pub const B10110: u32 = 22;
pub const B10101: u32 = 21;
pub const B10100: u32 = 20;
pub const B10011: u32 = 19;
pub const B10010: u32 = 18;
pub const B10001: u32 = 17;
pub const B10000: u32 = 16;
pub const B1111: u32 = 15;
pub const B1110: u32 = 14;
pub const B1101: u32 = 13;
pub const B1100: u32 = 12;
pub const B1011: u32 = 11;
pub const B1010: u32 = 10;
pub const B1001: u32 = 9;
pub const B1000: u32 = 8;
pub const B0111: u32 = 7;
pub const B0110: u32 = 6;
pub const B0101: u32 = 5;
pub const B0100: u32 = 4;
pub const B0011: u32 = 3;
pub const B0010: u32 = 2;
pub const B0001: u32 = 1;
pub const B0000: u32 = 0;
pub const INFINITY: f64 = ::std::f64::INFINITY;
pub const NAN: f64 = ::std::f64::NAN;
pub const RENAME_SECLUDE: u32 = 1;
pub const RENAME_SWAP: u32 = 2;
pub const RENAME_EXCL: u32 = 4;
pub const __SLBF: u32 = 1;
pub const __SNBF: u32 = 2;
pub const __SRD: u32 = 4;
pub const __SWR: u32 = 8;
pub const __SRW: u32 = 16;
pub const __SEOF: u32 = 32;
pub const __SERR: u32 = 64;
pub const __SMBF: u32 = 128;
pub const __SAPP: u32 = 256;
pub const __SSTR: u32 = 512;
pub const __SOPT: u32 = 1024;
pub const __SNPT: u32 = 2048;
pub const __SOFF: u32 = 4096;
pub const __SMOD: u32 = 8192;
pub const __SALC: u32 = 16384;
pub const __SIGN: u32 = 32768;
pub const _IOFBF: u32 = 0;
pub const _IOLBF: u32 = 1;
pub const _IONBF: u32 = 2;
pub const BUFSIZ: u32 = 1024;
pub const EOF: i32 = -1;
pub const FOPEN_MAX: u32 = 20;
pub const FILENAME_MAX: u32 = 1024;
pub const P_tmpdir: &'static [u8; 10usize] = b"/var/tmp/\0";
pub const L_tmpnam: u32 = 1024;
pub const TMP_MAX: u32 = 308915776;
pub const SEEK_SET: u32 = 0;
pub const SEEK_CUR: u32 = 1;
pub const SEEK_END: u32 = 2;
pub const L_ctermid: u32 = 1024;
pub const _USE_FORTIFY_LEVEL: u32 = 2;
pub const __HAS_FIXED_CHK_PROTOTYPES: u32 = 1;
pub const __GNUC_VA_LIST: u32 = 1;
pub const O_RDONLY: u32 = 0;
pub const O_WRONLY: u32 = 1;
pub const O_RDWR: u32 = 2;
pub const O_ACCMODE: u32 = 3;
pub const FREAD: u32 = 1;
pub const FWRITE: u32 = 2;
pub const O_NONBLOCK: u32 = 4;
pub const O_APPEND: u32 = 8;
pub const O_SYNC: u32 = 128;
pub const O_SHLOCK: u32 = 16;
pub const O_EXLOCK: u32 = 32;
pub const O_ASYNC: u32 = 64;
pub const O_FSYNC: u32 = 128;
pub const O_NOFOLLOW: u32 = 256;
pub const O_CREAT: u32 = 512;
pub const O_TRUNC: u32 = 1024;
pub const O_EXCL: u32 = 2048;
pub const AT_FDCWD: i32 = -2;
pub const AT_EACCESS: u32 = 16;
pub const AT_SYMLINK_NOFOLLOW: u32 = 32;
pub const AT_SYMLINK_FOLLOW: u32 = 64;
pub const AT_REMOVEDIR: u32 = 128;
pub const AT_REALDEV: u32 = 512;
pub const AT_FDONLY: u32 = 1024;
pub const O_EVTONLY: u32 = 32768;
pub const O_NOCTTY: u32 = 131072;
pub const O_DIRECTORY: u32 = 1048576;
pub const O_SYMLINK: u32 = 2097152;
pub const O_DSYNC: u32 = 4194304;
pub const O_CLOEXEC: u32 = 16777216;
pub const O_DP_GETRAWENCRYPTED: u32 = 1;
pub const O_DP_GETRAWUNENCRYPTED: u32 = 2;
pub const FAPPEND: u32 = 8;
pub const FASYNC: u32 = 64;
pub const FFSYNC: u32 = 128;
pub const FFDSYNC: u32 = 4194304;
pub const FNONBLOCK: u32 = 4;
pub const FNDELAY: u32 = 4;
pub const O_NDELAY: u32 = 4;
pub const CPF_OVERWRITE: u32 = 1;
pub const CPF_IGNORE_MODE: u32 = 2;
pub const CPF_MASK: u32 = 3;
pub const F_DUPFD: u32 = 0;
pub const F_GETFD: u32 = 1;
pub const F_SETFD: u32 = 2;
pub const F_GETFL: u32 = 3;
pub const F_SETFL: u32 = 4;
pub const F_GETOWN: u32 = 5;
pub const F_SETOWN: u32 = 6;
pub const F_GETLK: u32 = 7;
pub const F_SETLK: u32 = 8;
pub const F_SETLKW: u32 = 9;
pub const F_SETLKWTIMEOUT: u32 = 10;
pub const F_FLUSH_DATA: u32 = 40;
pub const F_CHKCLEAN: u32 = 41;
pub const F_PREALLOCATE: u32 = 42;
pub const F_SETSIZE: u32 = 43;
pub const F_RDADVISE: u32 = 44;
pub const F_RDAHEAD: u32 = 45;
pub const F_NOCACHE: u32 = 48;
pub const F_LOG2PHYS: u32 = 49;
pub const F_GETPATH: u32 = 50;
pub const F_FULLFSYNC: u32 = 51;
pub const F_PATHPKG_CHECK: u32 = 52;
pub const F_FREEZE_FS: u32 = 53;
pub const F_THAW_FS: u32 = 54;
pub const F_GLOBAL_NOCACHE: u32 = 55;
pub const F_ADDSIGS: u32 = 59;
pub const F_ADDFILESIGS: u32 = 61;
pub const F_NODIRECT: u32 = 62;
pub const F_GETPROTECTIONCLASS: u32 = 63;
pub const F_SETPROTECTIONCLASS: u32 = 64;
pub const F_LOG2PHYS_EXT: u32 = 65;
pub const F_GETLKPID: u32 = 66;
pub const F_SETBACKINGSTORE: u32 = 70;
pub const F_GETPATH_MTMINFO: u32 = 71;
pub const F_GETCODEDIR: u32 = 72;
pub const F_SETNOSIGPIPE: u32 = 73;
pub const F_GETNOSIGPIPE: u32 = 74;
pub const F_TRANSCODEKEY: u32 = 75;
pub const F_SINGLE_WRITER: u32 = 76;
pub const F_GETPROTECTIONLEVEL: u32 = 77;
pub const F_FINDSIGS: u32 = 78;
pub const F_ADDFILESIGS_FOR_DYLD_SIM: u32 = 83;
pub const F_BARRIERFSYNC: u32 = 85;
pub const F_ADDFILESIGS_RETURN: u32 = 97;
pub const F_CHECK_LV: u32 = 98;
pub const F_PUNCHHOLE: u32 = 99;
pub const F_TRIM_ACTIVE_FILE: u32 = 100;
pub const F_SPECULATIVE_READ: u32 = 101;
pub const F_GETPATH_NOFIRMLINK: u32 = 102;
pub const FCNTL_FS_SPECIFIC_BASE: u32 = 65536;
pub const F_DUPFD_CLOEXEC: u32 = 67;
pub const FD_CLOEXEC: u32 = 1;
pub const F_RDLCK: u32 = 1;
pub const F_UNLCK: u32 = 2;
pub const F_WRLCK: u32 = 3;
pub const SEEK_HOLE: u32 = 3;
pub const SEEK_DATA: u32 = 4;
pub const S_IFMT: u32 = 61440;
pub const S_IFIFO: u32 = 4096;
pub const S_IFCHR: u32 = 8192;
pub const S_IFDIR: u32 = 16384;
pub const S_IFBLK: u32 = 24576;
pub const S_IFREG: u32 = 32768;
pub const S_IFLNK: u32 = 40960;
pub const S_IFSOCK: u32 = 49152;
pub const S_IFWHT: u32 = 57344;
pub const S_IRWXU: u32 = 448;
pub const S_IRUSR: u32 = 256;
pub const S_IWUSR: u32 = 128;
pub const S_IXUSR: u32 = 64;
pub const S_IRWXG: u32 = 56;
pub const S_IRGRP: u32 = 32;
pub const S_IWGRP: u32 = 16;
pub const S_IXGRP: u32 = 8;
pub const S_IRWXO: u32 = 7;
pub const S_IROTH: u32 = 4;
pub const S_IWOTH: u32 = 2;
pub const S_IXOTH: u32 = 1;
pub const S_ISUID: u32 = 2048;
pub const S_ISGID: u32 = 1024;
pub const S_ISVTX: u32 = 512;
pub const S_ISTXT: u32 = 512;
pub const S_IREAD: u32 = 256;
pub const S_IWRITE: u32 = 128;
pub const S_IEXEC: u32 = 64;
pub const F_ALLOCATECONTIG: u32 = 2;
pub const F_ALLOCATEALL: u32 = 4;
pub const F_PEOFPOSMODE: u32 = 3;
pub const F_VOLPOSMODE: u32 = 4;
pub const LOCK_SH: u32 = 1;
pub const LOCK_EX: u32 = 2;
pub const LOCK_NB: u32 = 4;
pub const LOCK_UN: u32 = 8;
pub const O_POPUP: u32 = 2147483648;
pub const O_ALERT: u32 = 536870912;
pub const FS: &'static [u8; 2usize] = b"/\0";
pub const R_SYS_DIR: &'static [u8; 2usize] = b"/\0";
pub const R_SYS_ENVSEP: &'static [u8; 2usize] = b":\0";
pub const R_SYS_HOME: &'static [u8; 5usize] = b"HOME\0";
pub const R_SYS_TMP: &'static [u8; 7usize] = b"TMPDIR\0";
pub const PERROR_WITH_FILELINE: u32 = 0;
pub const ACCESSPERMS: u32 = 511;
pub const ALLPERMS: u32 = 4095;
pub const DEFFILEMODE: u32 = 438;
pub const S_BLKSIZE: u32 = 512;
pub const UF_SETTABLE: u32 = 65535;
pub const UF_NODUMP: u32 = 1;
pub const UF_IMMUTABLE: u32 = 2;
pub const UF_APPEND: u32 = 4;
pub const UF_OPAQUE: u32 = 8;
pub const UF_COMPRESSED: u32 = 32;
pub const UF_TRACKED: u32 = 64;
pub const UF_DATAVAULT: u32 = 128;
pub const UF_HIDDEN: u32 = 32768;
pub const SF_SUPPORTED: u32 = 10420224;
pub const SF_SETTABLE: u32 = 1073676288;
pub const SF_SYNTHETIC: u32 = 3221225472;
pub const SF_ARCHIVED: u32 = 65536;
pub const SF_IMMUTABLE: u32 = 131072;
pub const SF_APPEND: u32 = 262144;
pub const SF_RESTRICTED: u32 = 524288;
pub const SF_NOUNLINK: u32 = 1048576;
pub const SF_FIRMLINK: u32 = 8388608;
pub const SF_DATALESS: u32 = 1073741824;
pub const EF_MAY_SHARE_BLOCKS: u32 = 1;
pub const EF_NO_XATTRS: u32 = 2;
pub const EF_IS_SYNC_ROOT: u32 = 4;
pub const EF_IS_PURGEABLE: u32 = 8;
pub const EF_IS_SPARSE: u32 = 16;
pub const UTIME_NOW: i32 = -1;
pub const UTIME_OMIT: i32 = -2;
pub const __DARWIN_MAXNAMLEN: u32 = 255;
pub const __DARWIN_MAXPATHLEN: u32 = 1024;
pub const MAXNAMLEN: u32 = 255;
pub const DT_UNKNOWN: u32 = 0;
pub const DT_FIFO: u32 = 1;
pub const DT_CHR: u32 = 2;
pub const DT_DIR: u32 = 4;
pub const DT_BLK: u32 = 6;
pub const DT_REG: u32 = 8;
pub const DT_LNK: u32 = 10;
pub const DT_SOCK: u32 = 12;
pub const DT_WHT: u32 = 14;
pub const DIRBLKSIZ: u32 = 1024;
pub const DTF_HIDEW: u32 = 1;
pub const DTF_NODUP: u32 = 2;
pub const DTF_REWIND: u32 = 4;
pub const __DTF_READALL: u32 = 8;
pub const __DTF_SKIPREAD: u32 = 16;
pub const __DTF_ATEND: u32 = 32;
pub const _POSIX_VERSION: u32 = 200112;
pub const _POSIX2_VERSION: u32 = 200112;
pub const F_OK: u32 = 0;
pub const X_OK: u32 = 1;
pub const W_OK: u32 = 2;
pub const R_OK: u32 = 4;
pub const _READ_OK: u32 = 512;
pub const _WRITE_OK: u32 = 1024;
pub const _EXECUTE_OK: u32 = 2048;
pub const _DELETE_OK: u32 = 4096;
pub const _APPEND_OK: u32 = 8192;
pub const _RMFILE_OK: u32 = 16384;
pub const _RATTR_OK: u32 = 32768;
pub const _WATTR_OK: u32 = 65536;
pub const _REXT_OK: u32 = 131072;
pub const _WEXT_OK: u32 = 262144;
pub const _RPERM_OK: u32 = 524288;
pub const _WPERM_OK: u32 = 1048576;
pub const _CHOWN_OK: u32 = 2097152;
pub const _ACCESS_EXTENDED_MASK: u32 = 4193792;
pub const L_SET: u32 = 0;
pub const L_INCR: u32 = 1;
pub const L_XTND: u32 = 2;
pub const ACCESSX_MAX_DESCRIPTORS: u32 = 100;
pub const ACCESSX_MAX_TABLESIZE: u32 = 16384;
pub const _PC_LINK_MAX: u32 = 1;
pub const _PC_MAX_CANON: u32 = 2;
pub const _PC_MAX_INPUT: u32 = 3;
pub const _PC_NAME_MAX: u32 = 4;
pub const _PC_PATH_MAX: u32 = 5;
pub const _PC_PIPE_BUF: u32 = 6;
pub const _PC_CHOWN_RESTRICTED: u32 = 7;
pub const _PC_NO_TRUNC: u32 = 8;
pub const _PC_VDISABLE: u32 = 9;
pub const _PC_NAME_CHARS_MAX: u32 = 10;
pub const _PC_CASE_SENSITIVE: u32 = 11;
pub const _PC_CASE_PRESERVING: u32 = 12;
pub const _PC_EXTENDED_SECURITY_NP: u32 = 13;
pub const _PC_AUTH_OPAQUE_NP: u32 = 14;
pub const _PC_2_SYMLINKS: u32 = 15;
pub const _PC_ALLOC_SIZE_MIN: u32 = 16;
pub const _PC_ASYNC_IO: u32 = 17;
pub const _PC_FILESIZEBITS: u32 = 18;
pub const _PC_PRIO_IO: u32 = 19;
pub const _PC_REC_INCR_XFER_SIZE: u32 = 20;
pub const _PC_REC_MAX_XFER_SIZE: u32 = 21;
pub const _PC_REC_MIN_XFER_SIZE: u32 = 22;
pub const _PC_REC_XFER_ALIGN: u32 = 23;
pub const _PC_SYMLINK_MAX: u32 = 24;
pub const _PC_SYNC_IO: u32 = 25;
pub const _PC_XATTR_SIZE_BITS: u32 = 26;
pub const _PC_MIN_HOLE_SIZE: u32 = 27;
pub const _CS_PATH: u32 = 1;
pub const STDIN_FILENO: u32 = 0;
pub const STDOUT_FILENO: u32 = 1;
pub const STDERR_FILENO: u32 = 2;
pub const _XOPEN_VERSION: u32 = 600;
pub const _XOPEN_XCU_VERSION: u32 = 4;
pub const _POSIX_ADVISORY_INFO: i32 = -1;
pub const _POSIX_ASYNCHRONOUS_IO: i32 = -1;
pub const _POSIX_BARRIERS: i32 = -1;
pub const _POSIX_CHOWN_RESTRICTED: u32 = 200112;
pub const _POSIX_CLOCK_SELECTION: i32 = -1;
pub const _POSIX_CPUTIME: i32 = -1;
pub const _POSIX_FSYNC: u32 = 200112;
pub const _POSIX_IPV6: u32 = 200112;
pub const _POSIX_JOB_CONTROL: u32 = 200112;
pub const _POSIX_MAPPED_FILES: u32 = 200112;
pub const _POSIX_MEMLOCK: i32 = -1;
pub const _POSIX_MEMLOCK_RANGE: i32 = -1;
pub const _POSIX_MEMORY_PROTECTION: u32 = 200112;
pub const _POSIX_MESSAGE_PASSING: i32 = -1;
pub const _POSIX_MONOTONIC_CLOCK: i32 = -1;
pub const _POSIX_NO_TRUNC: u32 = 200112;
pub const _POSIX_PRIORITIZED_IO: i32 = -1;
pub const _POSIX_PRIORITY_SCHEDULING: i32 = -1;
pub const _POSIX_RAW_SOCKETS: i32 = -1;
pub const _POSIX_READER_WRITER_LOCKS: u32 = 200112;
pub const _POSIX_REALTIME_SIGNALS: i32 = -1;
pub const _POSIX_REGEXP: u32 = 200112;
pub const _POSIX_SAVED_IDS: u32 = 200112;
pub const _POSIX_SEMAPHORES: i32 = -1;
pub const _POSIX_SHARED_MEMORY_OBJECTS: i32 = -1;
pub const _POSIX_SHELL: u32 = 200112;
pub const _POSIX_SPAWN: i32 = -1;
pub const _POSIX_SPIN_LOCKS: i32 = -1;
pub const _POSIX_SPORADIC_SERVER: i32 = -1;
pub const _POSIX_SYNCHRONIZED_IO: i32 = -1;
pub const _POSIX_THREAD_ATTR_STACKADDR: u32 = 200112;
pub const _POSIX_THREAD_ATTR_STACKSIZE: u32 = 200112;
pub const _POSIX_THREAD_CPUTIME: i32 = -1;
pub const _POSIX_THREAD_PRIO_INHERIT: i32 = -1;
pub const _POSIX_THREAD_PRIO_PROTECT: i32 = -1;
pub const _POSIX_THREAD_PRIORITY_SCHEDULING: i32 = -1;
pub const _POSIX_THREAD_PROCESS_SHARED: u32 = 200112;
pub const _POSIX_THREAD_SAFE_FUNCTIONS: u32 = 200112;
pub const _POSIX_THREAD_SPORADIC_SERVER: i32 = -1;
pub const _POSIX_THREADS: u32 = 200112;
pub const _POSIX_TIMEOUTS: i32 = -1;
pub const _POSIX_TIMERS: i32 = -1;
pub const _POSIX_TRACE: i32 = -1;
pub const _POSIX_TRACE_EVENT_FILTER: i32 = -1;
pub const _POSIX_TRACE_INHERIT: i32 = -1;
pub const _POSIX_TRACE_LOG: i32 = -1;
pub const _POSIX_TYPED_MEMORY_OBJECTS: i32 = -1;
pub const _POSIX2_C_BIND: u32 = 200112;
pub const _POSIX2_C_DEV: u32 = 200112;
pub const _POSIX2_CHAR_TERM: u32 = 200112;
pub const _POSIX2_FORT_DEV: i32 = -1;
pub const _POSIX2_FORT_RUN: u32 = 200112;
pub const _POSIX2_LOCALEDEF: u32 = 200112;
pub const _POSIX2_PBS: i32 = -1;
pub const _POSIX2_PBS_ACCOUNTING: i32 = -1;
pub const _POSIX2_PBS_CHECKPOINT: i32 = -1;
pub const _POSIX2_PBS_LOCATE: i32 = -1;
pub const _POSIX2_PBS_MESSAGE: i32 = -1;
pub const _POSIX2_PBS_TRACK: i32 = -1;
pub const _POSIX2_SW_DEV: u32 = 200112;
pub const _POSIX2_UPE: u32 = 200112;
pub const __ILP32_OFF32: i32 = -1;
pub const __ILP32_OFFBIG: i32 = -1;
pub const __LP64_OFF64: u32 = 1;
pub const __LPBIG_OFFBIG: u32 = 1;
pub const _POSIX_V6_ILP32_OFF32: i32 = -1;
pub const _POSIX_V6_ILP32_OFFBIG: i32 = -1;
pub const _POSIX_V6_LP64_OFF64: u32 = 1;
pub const _POSIX_V6_LPBIG_OFFBIG: u32 = 1;
pub const _POSIX_V7_ILP32_OFF32: i32 = -1;
pub const _POSIX_V7_ILP32_OFFBIG: i32 = -1;
pub const _POSIX_V7_LP64_OFF64: u32 = 1;
pub const _POSIX_V7_LPBIG_OFFBIG: u32 = 1;
pub const _V6_ILP32_OFF32: i32 = -1;
pub const _V6_ILP32_OFFBIG: i32 = -1;
pub const _V6_LP64_OFF64: u32 = 1;
pub const _V6_LPBIG_OFFBIG: u32 = 1;
pub const _XBS5_ILP32_OFF32: i32 = -1;
pub const _XBS5_ILP32_OFFBIG: i32 = -1;
pub const _XBS5_LP64_OFF64: u32 = 1;
pub const _XBS5_LPBIG_OFFBIG: u32 = 1;
pub const _XOPEN_CRYPT: u32 = 1;
pub const _XOPEN_ENH_I18N: u32 = 1;
pub const _XOPEN_LEGACY: i32 = -1;
pub const _XOPEN_REALTIME: i32 = -1;
pub const _XOPEN_REALTIME_THREADS: i32 = -1;
pub const _XOPEN_SHM: u32 = 1;
pub const _XOPEN_STREAMS: i32 = -1;
pub const _XOPEN_UNIX: u32 = 1;
pub const _SC_ARG_MAX: u32 = 1;
pub const _SC_CHILD_MAX: u32 = 2;
pub const _SC_CLK_TCK: u32 = 3;
pub const _SC_NGROUPS_MAX: u32 = 4;
pub const _SC_OPEN_MAX: u32 = 5;
pub const _SC_JOB_CONTROL: u32 = 6;
pub const _SC_SAVED_IDS: u32 = 7;
pub const _SC_VERSION: u32 = 8;
pub const _SC_BC_BASE_MAX: u32 = 9;
pub const _SC_BC_DIM_MAX: u32 = 10;
pub const _SC_BC_SCALE_MAX: u32 = 11;
pub const _SC_BC_STRING_MAX: u32 = 12;
pub const _SC_COLL_WEIGHTS_MAX: u32 = 13;
pub const _SC_EXPR_NEST_MAX: u32 = 14;
pub const _SC_LINE_MAX: u32 = 15;
pub const _SC_RE_DUP_MAX: u32 = 16;
pub const _SC_2_VERSION: u32 = 17;
pub const _SC_2_C_BIND: u32 = 18;
pub const _SC_2_C_DEV: u32 = 19;
pub const _SC_2_CHAR_TERM: u32 = 20;
pub const _SC_2_FORT_DEV: u32 = 21;
pub const _SC_2_FORT_RUN: u32 = 22;
pub const _SC_2_LOCALEDEF: u32 = 23;
pub const _SC_2_SW_DEV: u32 = 24;
pub const _SC_2_UPE: u32 = 25;
pub const _SC_STREAM_MAX: u32 = 26;
pub const _SC_TZNAME_MAX: u32 = 27;
pub const _SC_ASYNCHRONOUS_IO: u32 = 28;
pub const _SC_PAGESIZE: u32 = 29;
pub const _SC_MEMLOCK: u32 = 30;
pub const _SC_MEMLOCK_RANGE: u32 = 31;
pub const _SC_MEMORY_PROTECTION: u32 = 32;
pub const _SC_MESSAGE_PASSING: u32 = 33;
pub const _SC_PRIORITIZED_IO: u32 = 34;
pub const _SC_PRIORITY_SCHEDULING: u32 = 35;
pub const _SC_REALTIME_SIGNALS: u32 = 36;
pub const _SC_SEMAPHORES: u32 = 37;
pub const _SC_FSYNC: u32 = 38;
pub const _SC_SHARED_MEMORY_OBJECTS: u32 = 39;
pub const _SC_SYNCHRONIZED_IO: u32 = 40;
pub const _SC_TIMERS: u32 = 41;
pub const _SC_AIO_LISTIO_MAX: u32 = 42;
pub const _SC_AIO_MAX: u32 = 43;
pub const _SC_AIO_PRIO_DELTA_MAX: u32 = 44;
pub const _SC_DELAYTIMER_MAX: u32 = 45;
pub const _SC_MQ_OPEN_MAX: u32 = 46;
pub const _SC_MAPPED_FILES: u32 = 47;
pub const _SC_RTSIG_MAX: u32 = 48;
pub const _SC_SEM_NSEMS_MAX: u32 = 49;
pub const _SC_SEM_VALUE_MAX: u32 = 50;
pub const _SC_SIGQUEUE_MAX: u32 = 51;
pub const _SC_TIMER_MAX: u32 = 52;
pub const _SC_NPROCESSORS_CONF: u32 = 57;
pub const _SC_NPROCESSORS_ONLN: u32 = 58;
pub const _SC_2_PBS: u32 = 59;
pub const _SC_2_PBS_ACCOUNTING: u32 = 60;
pub const _SC_2_PBS_CHECKPOINT: u32 = 61;
pub const _SC_2_PBS_LOCATE: u32 = 62;
pub const _SC_2_PBS_MESSAGE: u32 = 63;
pub const _SC_2_PBS_TRACK: u32 = 64;
pub const _SC_ADVISORY_INFO: u32 = 65;
pub const _SC_BARRIERS: u32 = 66;
pub const _SC_CLOCK_SELECTION: u32 = 67;
pub const _SC_CPUTIME: u32 = 68;
pub const _SC_FILE_LOCKING: u32 = 69;
pub const _SC_GETGR_R_SIZE_MAX: u32 = 70;
pub const _SC_GETPW_R_SIZE_MAX: u32 = 71;
pub const _SC_HOST_NAME_MAX: u32 = 72;
pub const _SC_LOGIN_NAME_MAX: u32 = 73;
pub const _SC_MONOTONIC_CLOCK: u32 = 74;
pub const _SC_MQ_PRIO_MAX: u32 = 75;
pub const _SC_READER_WRITER_LOCKS: u32 = 76;
pub const _SC_REGEXP: u32 = 77;
pub const _SC_SHELL: u32 = 78;
pub const _SC_SPAWN: u32 = 79;
pub const _SC_SPIN_LOCKS: u32 = 80;
pub const _SC_SPORADIC_SERVER: u32 = 81;
pub const _SC_THREAD_ATTR_STACKADDR: u32 = 82;
pub const _SC_THREAD_ATTR_STACKSIZE: u32 = 83;
pub const _SC_THREAD_CPUTIME: u32 = 84;
pub const _SC_THREAD_DESTRUCTOR_ITERATIONS: u32 = 85;
pub const _SC_THREAD_KEYS_MAX: u32 = 86;
pub const _SC_THREAD_PRIO_INHERIT: u32 = 87;
pub const _SC_THREAD_PRIO_PROTECT: u32 = 88;
pub const _SC_THREAD_PRIORITY_SCHEDULING: u32 = 89;
pub const _SC_THREAD_PROCESS_SHARED: u32 = 90;
pub const _SC_THREAD_SAFE_FUNCTIONS: u32 = 91;
pub const _SC_THREAD_SPORADIC_SERVER: u32 = 92;
pub const _SC_THREAD_STACK_MIN: u32 = 93;
pub const _SC_THREAD_THREADS_MAX: u32 = 94;
pub const _SC_TIMEOUTS: u32 = 95;
pub const _SC_THREADS: u32 = 96;
pub const _SC_TRACE: u32 = 97;
pub const _SC_TRACE_EVENT_FILTER: u32 = 98;
pub const _SC_TRACE_INHERIT: u32 = 99;
pub const _SC_TRACE_LOG: u32 = 100;
pub const _SC_TTY_NAME_MAX: u32 = 101;
pub const _SC_TYPED_MEMORY_OBJECTS: u32 = 102;
pub const _SC_V6_ILP32_OFF32: u32 = 103;
pub const _SC_V6_ILP32_OFFBIG: u32 = 104;
pub const _SC_V6_LP64_OFF64: u32 = 105;
pub const _SC_V6_LPBIG_OFFBIG: u32 = 106;
pub const _SC_IPV6: u32 = 118;
pub const _SC_RAW_SOCKETS: u32 = 119;
pub const _SC_SYMLOOP_MAX: u32 = 120;
pub const _SC_ATEXIT_MAX: u32 = 107;
pub const _SC_IOV_MAX: u32 = 56;
pub const _SC_PAGE_SIZE: u32 = 29;
pub const _SC_XOPEN_CRYPT: u32 = 108;
pub const _SC_XOPEN_ENH_I18N: u32 = 109;
pub const _SC_XOPEN_LEGACY: u32 = 110;
pub const _SC_XOPEN_REALTIME: u32 = 111;
pub const _SC_XOPEN_REALTIME_THREADS: u32 = 112;
pub const _SC_XOPEN_SHM: u32 = 113;
pub const _SC_XOPEN_STREAMS: u32 = 114;
pub const _SC_XOPEN_UNIX: u32 = 115;
pub const _SC_XOPEN_VERSION: u32 = 116;
pub const _SC_XOPEN_XCU_VERSION: u32 = 121;
pub const _SC_XBS5_ILP32_OFF32: u32 = 122;
pub const _SC_XBS5_ILP32_OFFBIG: u32 = 123;
pub const _SC_XBS5_LP64_OFF64: u32 = 124;
pub const _SC_XBS5_LPBIG_OFFBIG: u32 = 125;
pub const _SC_SS_REPL_MAX: u32 = 126;
pub const _SC_TRACE_EVENT_NAME_MAX: u32 = 127;
pub const _SC_TRACE_NAME_MAX: u32 = 128;
pub const _SC_TRACE_SYS_MAX: u32 = 129;
pub const _SC_TRACE_USER_EVENT_MAX: u32 = 130;
pub const _SC_PASS_MAX: u32 = 131;
pub const _SC_PHYS_PAGES: u32 = 200;
pub const _CS_POSIX_V6_ILP32_OFF32_CFLAGS: u32 = 2;
pub const _CS_POSIX_V6_ILP32_OFF32_LDFLAGS: u32 = 3;
pub const _CS_POSIX_V6_ILP32_OFF32_LIBS: u32 = 4;
pub const _CS_POSIX_V6_ILP32_OFFBIG_CFLAGS: u32 = 5;
pub const _CS_POSIX_V6_ILP32_OFFBIG_LDFLAGS: u32 = 6;
pub const _CS_POSIX_V6_ILP32_OFFBIG_LIBS: u32 = 7;
pub const _CS_POSIX_V6_LP64_OFF64_CFLAGS: u32 = 8;
pub const _CS_POSIX_V6_LP64_OFF64_LDFLAGS: u32 = 9;
pub const _CS_POSIX_V6_LP64_OFF64_LIBS: u32 = 10;
pub const _CS_POSIX_V6_LPBIG_OFFBIG_CFLAGS: u32 = 11;
pub const _CS_POSIX_V6_LPBIG_OFFBIG_LDFLAGS: u32 = 12;
pub const _CS_POSIX_V6_LPBIG_OFFBIG_LIBS: u32 = 13;
pub const _CS_POSIX_V6_WIDTH_RESTRICTED_ENVS: u32 = 14;
pub const _CS_XBS5_ILP32_OFF32_CFLAGS: u32 = 20;
pub const _CS_XBS5_ILP32_OFF32_LDFLAGS: u32 = 21;
pub const _CS_XBS5_ILP32_OFF32_LIBS: u32 = 22;
pub const _CS_XBS5_ILP32_OFF32_LINTFLAGS: u32 = 23;
pub const _CS_XBS5_ILP32_OFFBIG_CFLAGS: u32 = 24;
pub const _CS_XBS5_ILP32_OFFBIG_LDFLAGS: u32 = 25;
pub const _CS_XBS5_ILP32_OFFBIG_LIBS: u32 = 26;
pub const _CS_XBS5_ILP32_OFFBIG_LINTFLAGS: u32 = 27;
pub const _CS_XBS5_LP64_OFF64_CFLAGS: u32 = 28;
pub const _CS_XBS5_LP64_OFF64_LDFLAGS: u32 = 29;
pub const _CS_XBS5_LP64_OFF64_LIBS: u32 = 30;
pub const _CS_XBS5_LP64_OFF64_LINTFLAGS: u32 = 31;
pub const _CS_XBS5_LPBIG_OFFBIG_CFLAGS: u32 = 32;
pub const _CS_XBS5_LPBIG_OFFBIG_LDFLAGS: u32 = 33;
pub const _CS_XBS5_LPBIG_OFFBIG_LIBS: u32 = 34;
pub const _CS_XBS5_LPBIG_OFFBIG_LINTFLAGS: u32 = 35;
pub const _CS_DARWIN_USER_DIR: u32 = 65536;
pub const _CS_DARWIN_USER_TEMP_DIR: u32 = 65537;
pub const _CS_DARWIN_USER_CACHE_DIR: u32 = 65538;
pub const F_ULOCK: u32 = 0;
pub const F_LOCK: u32 = 1;
pub const F_TLOCK: u32 = 2;
pub const F_TEST: u32 = 3;
pub const SYNC_VOLUME_FULLSYNC: u32 = 1;
pub const SYNC_VOLUME_WAIT: u32 = 2;
pub const ITIMER_REAL: u32 = 0;
pub const ITIMER_VIRTUAL: u32 = 1;
pub const ITIMER_PROF: u32 = 2;
pub const DST_NONE: u32 = 0;
pub const DST_USA: u32 = 1;
pub const DST_AUST: u32 = 2;
pub const DST_WET: u32 = 3;
pub const DST_MET: u32 = 4;
pub const DST_EET: u32 = 5;
pub const DST_CAN: u32 = 6;
pub const CLOCKS_PER_SEC: u32 = 1000000;
pub const TIME_UTC: u32 = 1;
pub const HAVE_EPRINTF: u32 = 1;
pub const HAVE_REGEXP: u32 = 1;
pub const PFMT64x: &'static [u8; 4usize] = b"llx\0";
pub const PFMT64d: &'static [u8; 4usize] = b"lld\0";
pub const PFMT64u: &'static [u8; 4usize] = b"llu\0";
pub const PFMT64o: &'static [u8; 4usize] = b"llo\0";
pub const PFMTSZx: &'static [u8; 3usize] = b"zx\0";
pub const PFMTSZd: &'static [u8; 3usize] = b"zd\0";
pub const PFMTSZu: &'static [u8; 3usize] = b"zu\0";
pub const PFMTSZo: &'static [u8; 3usize] = b"zo\0";
pub const LDBLFMT: &'static [u8; 3usize] = b"Lf\0";
pub const HHXFMT: &'static [u8; 4usize] = b"hhx\0";
pub const PFMTDPTR: &'static [u8; 3usize] = b"td\0";
pub const PFMT32x: &'static [u8; 2usize] = b"x\0";
pub const PFMT32d: &'static [u8; 2usize] = b"d\0";
pub const PFMT32u: &'static [u8; 2usize] = b"u\0";
pub const PFMT32o: &'static [u8; 2usize] = b"o\0";
pub const O_BINARY: u32 = 0;
pub const R_SYS_ARCH: &'static [u8; 4usize] = b"x86\0";
pub const R_SYS_ENDIAN: u32 = 0;
pub const R_SYS_ENDIAN_NONE: u32 = 0;
pub const R_SYS_ENDIAN_LITTLE: u32 = 1;
pub const R_SYS_ENDIAN_BIG: u32 = 2;
pub const R_SYS_ENDIAN_BI: u32 = 3;
pub const HAS_CLOCK_NANOSLEEP: u32 = 0;
pub const HAS_CLOCK_MONOTONIC: u32 = 0;
pub const R_SYS_OS: &'static [u8; 7usize] = b"darwin\0";
pub const R_GETOPT_H: u32 = 1;
pub const R_PJ_H: u32 = 1;
pub const R_PRINT_JSON_DEPTH_LIMIT: u32 = 128;
pub const __PRI_8_LENGTH_MODIFIER__: &'static [u8; 3usize] = b"hh\0";
pub const __PRI_64_LENGTH_MODIFIER__: &'static [u8; 3usize] = b"ll\0";
pub const __SCN_64_LENGTH_MODIFIER__: &'static [u8; 3usize] = b"ll\0";
pub const __PRI_MAX_LENGTH_MODIFIER__: &'static [u8; 2usize] = b"j\0";
pub const __SCN_MAX_LENGTH_MODIFIER__: &'static [u8; 2usize] = b"j\0";
pub const PRId8: &'static [u8; 4usize] = b"hhd\0";
pub const PRIi8: &'static [u8; 4usize] = b"hhi\0";
pub const PRIo8: &'static [u8; 4usize] = b"hho\0";
pub const PRIu8: &'static [u8; 4usize] = b"hhu\0";
pub const PRIx8: &'static [u8; 4usize] = b"hhx\0";
pub const PRIX8: &'static [u8; 4usize] = b"hhX\0";
pub const PRId16: &'static [u8; 3usize] = b"hd\0";
pub const PRIi16: &'static [u8; 3usize] = b"hi\0";
pub const PRIo16: &'static [u8; 3usize] = b"ho\0";
pub const PRIu16: &'static [u8; 3usize] = b"hu\0";
pub const PRIx16: &'static [u8; 3usize] = b"hx\0";
pub const PRIX16: &'static [u8; 3usize] = b"hX\0";
pub const PRId32: &'static [u8; 2usize] = b"d\0";
pub const PRIi32: &'static [u8; 2usize] = b"i\0";
pub const PRIo32: &'static [u8; 2usize] = b"o\0";
pub const PRIu32: &'static [u8; 2usize] = b"u\0";
pub const PRIx32: &'static [u8; 2usize] = b"x\0";
pub const PRIX32: &'static [u8; 2usize] = b"X\0";
pub const PRId64: &'static [u8; 4usize] = b"lld\0";
pub const PRIi64: &'static [u8; 4usize] = b"lli\0";
pub const PRIo64: &'static [u8; 4usize] = b"llo\0";
pub const PRIu64: &'static [u8; 4usize] = b"llu\0";
pub const PRIx64: &'static [u8; 4usize] = b"llx\0";
pub const PRIX64: &'static [u8; 4usize] = b"llX\0";
pub const PRIdLEAST8: &'static [u8; 4usize] = b"hhd\0";
pub const PRIiLEAST8: &'static [u8; 4usize] = b"hhi\0";
pub const PRIoLEAST8: &'static [u8; 4usize] = b"hho\0";
pub const PRIuLEAST8: &'static [u8; 4usize] = b"hhu\0";
pub const PRIxLEAST8: &'static [u8; 4usize] = b"hhx\0";
pub const PRIXLEAST8: &'static [u8; 4usize] = b"hhX\0";
pub const PRIdLEAST16: &'static [u8; 3usize] = b"hd\0";
pub const PRIiLEAST16: &'static [u8; 3usize] = b"hi\0";
pub const PRIoLEAST16: &'static [u8; 3usize] = b"ho\0";
pub const PRIuLEAST16: &'static [u8; 3usize] = b"hu\0";
pub const PRIxLEAST16: &'static [u8; 3usize] = b"hx\0";
pub const PRIXLEAST16: &'static [u8; 3usize] = b"hX\0";
pub const PRIdLEAST32: &'static [u8; 2usize] = b"d\0";
pub const PRIiLEAST32: &'static [u8; 2usize] = b"i\0";
pub const PRIoLEAST32: &'static [u8; 2usize] = b"o\0";
pub const PRIuLEAST32: &'static [u8; 2usize] = b"u\0";
pub const PRIxLEAST32: &'static [u8; 2usize] = b"x\0";
pub const PRIXLEAST32: &'static [u8; 2usize] = b"X\0";
pub const PRIdLEAST64: &'static [u8; 4usize] = b"lld\0";
pub const PRIiLEAST64: &'static [u8; 4usize] = b"lli\0";
pub const PRIoLEAST64: &'static [u8; 4usize] = b"llo\0";
pub const PRIuLEAST64: &'static [u8; 4usize] = b"llu\0";
pub const PRIxLEAST64: &'static [u8; 4usize] = b"llx\0";
pub const PRIXLEAST64: &'static [u8; 4usize] = b"llX\0";
pub const PRIdFAST8: &'static [u8; 4usize] = b"hhd\0";
pub const PRIiFAST8: &'static [u8; 4usize] = b"hhi\0";
pub const PRIoFAST8: &'static [u8; 4usize] = b"hho\0";
pub const PRIuFAST8: &'static [u8; 4usize] = b"hhu\0";
pub const PRIxFAST8: &'static [u8; 4usize] = b"hhx\0";
pub const PRIXFAST8: &'static [u8; 4usize] = b"hhX\0";
pub const PRIdFAST16: &'static [u8; 3usize] = b"hd\0";
pub const PRIiFAST16: &'static [u8; 3usize] = b"hi\0";
pub const PRIoFAST16: &'static [u8; 3usize] = b"ho\0";
pub const PRIuFAST16: &'static [u8; 3usize] = b"hu\0";
pub const PRIxFAST16: &'static [u8; 3usize] = b"hx\0";
pub const PRIXFAST16: &'static [u8; 3usize] = b"hX\0";
pub const PRIdFAST32: &'static [u8; 2usize] = b"d\0";
pub const PRIiFAST32: &'static [u8; 2usize] = b"i\0";
pub const PRIoFAST32: &'static [u8; 2usize] = b"o\0";
pub const PRIuFAST32: &'static [u8; 2usize] = b"u\0";
pub const PRIxFAST32: &'static [u8; 2usize] = b"x\0";
pub const PRIXFAST32: &'static [u8; 2usize] = b"X\0";
pub const PRIdFAST64: &'static [u8; 4usize] = b"lld\0";
pub const PRIiFAST64: &'static [u8; 4usize] = b"lli\0";
pub const PRIoFAST64: &'static [u8; 4usize] = b"llo\0";
pub const PRIuFAST64: &'static [u8; 4usize] = b"llu\0";
pub const PRIxFAST64: &'static [u8; 4usize] = b"llx\0";
pub const PRIXFAST64: &'static [u8; 4usize] = b"llX\0";
pub const PRIdPTR: &'static [u8; 3usize] = b"ld\0";
pub const PRIiPTR: &'static [u8; 3usize] = b"li\0";
pub const PRIoPTR: &'static [u8; 3usize] = b"lo\0";
pub const PRIuPTR: &'static [u8; 3usize] = b"lu\0";
pub const PRIxPTR: &'static [u8; 3usize] = b"lx\0";
pub const PRIXPTR: &'static [u8; 3usize] = b"lX\0";
pub const PRIdMAX: &'static [u8; 3usize] = b"jd\0";
pub const PRIiMAX: &'static [u8; 3usize] = b"ji\0";
pub const PRIoMAX: &'static [u8; 3usize] = b"jo\0";
pub const PRIuMAX: &'static [u8; 3usize] = b"ju\0";
pub const PRIxMAX: &'static [u8; 3usize] = b"jx\0";
pub const PRIXMAX: &'static [u8; 3usize] = b"jX\0";
pub const SCNd8: &'static [u8; 4usize] = b"hhd\0";
pub const SCNi8: &'static [u8; 4usize] = b"hhi\0";
pub const SCNo8: &'static [u8; 4usize] = b"hho\0";
pub const SCNu8: &'static [u8; 4usize] = b"hhu\0";
pub const SCNx8: &'static [u8; 4usize] = b"hhx\0";
pub const SCNd16: &'static [u8; 3usize] = b"hd\0";
pub const SCNi16: &'static [u8; 3usize] = b"hi\0";
pub const SCNo16: &'static [u8; 3usize] = b"ho\0";
pub const SCNu16: &'static [u8; 3usize] = b"hu\0";
pub const SCNx16: &'static [u8; 3usize] = b"hx\0";
pub const SCNd32: &'static [u8; 2usize] = b"d\0";
pub const SCNi32: &'static [u8; 2usize] = b"i\0";
pub const SCNo32: &'static [u8; 2usize] = b"o\0";
pub const SCNu32: &'static [u8; 2usize] = b"u\0";
pub const SCNx32: &'static [u8; 2usize] = b"x\0";
pub const SCNd64: &'static [u8; 4usize] = b"lld\0";
pub const SCNi64: &'static [u8; 4usize] = b"lli\0";
pub const SCNo64: &'static [u8; 4usize] = b"llo\0";
pub const SCNu64: &'static [u8; 4usize] = b"llu\0";
pub const SCNx64: &'static [u8; 4usize] = b"llx\0";
pub const SCNdLEAST8: &'static [u8; 4usize] = b"hhd\0";
pub const SCNiLEAST8: &'static [u8; 4usize] = b"hhi\0";
pub const SCNoLEAST8: &'static [u8; 4usize] = b"hho\0";
pub const SCNuLEAST8: &'static [u8; 4usize] = b"hhu\0";
pub const SCNxLEAST8: &'static [u8; 4usize] = b"hhx\0";
pub const SCNdLEAST16: &'static [u8; 3usize] = b"hd\0";
pub const SCNiLEAST16: &'static [u8; 3usize] = b"hi\0";
pub const SCNoLEAST16: &'static [u8; 3usize] = b"ho\0";
pub const SCNuLEAST16: &'static [u8; 3usize] = b"hu\0";
pub const SCNxLEAST16: &'static [u8; 3usize] = b"hx\0";
pub const SCNdLEAST32: &'static [u8; 2usize] = b"d\0";
pub const SCNiLEAST32: &'static [u8; 2usize] = b"i\0";
pub const SCNoLEAST32: &'static [u8; 2usize] = b"o\0";
pub const SCNuLEAST32: &'static [u8; 2usize] = b"u\0";
pub const SCNxLEAST32: &'static [u8; 2usize] = b"x\0";
pub const SCNdLEAST64: &'static [u8; 4usize] = b"lld\0";
pub const SCNiLEAST64: &'static [u8; 4usize] = b"lli\0";
pub const SCNoLEAST64: &'static [u8; 4usize] = b"llo\0";
pub const SCNuLEAST64: &'static [u8; 4usize] = b"llu\0";
pub const SCNxLEAST64: &'static [u8; 4usize] = b"llx\0";
pub const SCNdFAST8: &'static [u8; 4usize] = b"hhd\0";
pub const SCNiFAST8: &'static [u8; 4usize] = b"hhi\0";
pub const SCNoFAST8: &'static [u8; 4usize] = b"hho\0";
pub const SCNuFAST8: &'static [u8; 4usize] = b"hhu\0";
pub const SCNxFAST8: &'static [u8; 4usize] = b"hhx\0";
pub const SCNdFAST16: &'static [u8; 3usize] = b"hd\0";
pub const SCNiFAST16: &'static [u8; 3usize] = b"hi\0";
pub const SCNoFAST16: &'static [u8; 3usize] = b"ho\0";
pub const SCNuFAST16: &'static [u8; 3usize] = b"hu\0";
pub const SCNxFAST16: &'static [u8; 3usize] = b"hx\0";
pub const SCNdFAST32: &'static [u8; 2usize] = b"d\0";
pub const SCNiFAST32: &'static [u8; 2usize] = b"i\0";
pub const SCNoFAST32: &'static [u8; 2usize] = b"o\0";
pub const SCNuFAST32: &'static [u8; 2usize] = b"u\0";
pub const SCNxFAST32: &'static [u8; 2usize] = b"x\0";
pub const SCNdFAST64: &'static [u8; 4usize] = b"lld\0";
pub const SCNiFAST64: &'static [u8; 4usize] = b"lli\0";
pub const SCNoFAST64: &'static [u8; 4usize] = b"llo\0";
pub const SCNuFAST64: &'static [u8; 4usize] = b"llu\0";
pub const SCNxFAST64: &'static [u8; 4usize] = b"llx\0";
pub const SCNdPTR: &'static [u8; 3usize] = b"ld\0";
pub const SCNiPTR: &'static [u8; 3usize] = b"li\0";
pub const SCNoPTR: &'static [u8; 3usize] = b"lo\0";
pub const SCNuPTR: &'static [u8; 3usize] = b"lu\0";
pub const SCNxPTR: &'static [u8; 3usize] = b"lx\0";
pub const SCNdMAX: &'static [u8; 3usize] = b"jd\0";
pub const SCNiMAX: &'static [u8; 3usize] = b"ji\0";
pub const SCNoMAX: &'static [u8; 3usize] = b"jo\0";
pub const SCNuMAX: &'static [u8; 3usize] = b"ju\0";
pub const SCNxMAX: &'static [u8; 3usize] = b"jx\0";
pub const __SDB_WINDOWS__: u32 = 0;
pub const DIRSEP: u8 = 47u8;
pub const HAVE_MMAN: u32 = 1;
pub const ULLFMT: &'static [u8; 3usize] = b"ll\0";
pub const USE_MMAN: u32 = 1;
pub const SDB_KEYSIZE: u32 = 32;
pub const USE_MONOTONIC_CLOCK: u32 = 0;
pub const HT_TYPE: u32 = 1;
pub const MHTSZ: u32 = 32;
pub const MHTNO: u32 = 0;
pub const KVLSZ: u32 = 4;
pub const CDB_MAX_KEY: u32 = 255;
pub const CDB_MAX_VALUE: u32 = 16777215;
pub const CDB_HASHSTART: u32 = 5381;
pub const BUFFER_INSIZE: u32 = 8192;
pub const BUFFER_OUTSIZE: u32 = 8192;
pub const CDB_HPLIST: u32 = 1000;
pub const SDB_VERSION: &'static [u8; 6usize] = b"1.8.1\0";
pub const SDB_MIN_VALUE: u32 = 1;
pub const SDB_MAX_VALUE: u32 = 16777215;
pub const SDB_MIN_KEY: u32 = 1;
pub const SDB_MAX_KEY: u32 = 255;
pub const SDB_MAX_GPERF_KEYS: u32 = 15000;
pub const SDB_MODE: u32 = 420;
pub const SDB_RS: u8 = 44u8;
pub const SDB_SS: &'static [u8; 2usize] = b",\0";
pub const SDB_MAX_PATH: u32 = 256;
pub const SDB_NUM_BASE: u32 = 16;
pub const SDB_NUM_BUFSZ: u32 = 64;
pub const SDB_OPTION_NONE: u32 = 0;
pub const SDB_OPTION_ALL: u32 = 255;
pub const SDB_OPTION_SYNC: u32 = 1;
pub const SDB_OPTION_NOSTAMP: u32 = 2;
pub const SDB_OPTION_FS: u32 = 4;
pub const SDB_OPTION_JOURNAL: u32 = 8;
pub const SDB_LIST_UNSORTED: u32 = 0;
pub const SDB_LIST_SORTED: u32 = 1;
pub const SDB_KSZ: u32 = 255;
pub const SDB_VSZ: u32 = 16777215;
pub const R_NUMCALC_STRSZ: u32 = 1024;
pub const HAVE_CAPSICUM: u32 = 0;
pub const EPERM: u32 = 1;
pub const ENOENT: u32 = 2;
pub const ESRCH: u32 = 3;
pub const EINTR: u32 = 4;
pub const EIO: u32 = 5;
pub const ENXIO: u32 = 6;
pub const E2BIG: u32 = 7;
pub const ENOEXEC: u32 = 8;
pub const EBADF: u32 = 9;
pub const ECHILD: u32 = 10;
pub const EDEADLK: u32 = 11;
pub const ENOMEM: u32 = 12;
pub const EACCES: u32 = 13;
pub const EFAULT: u32 = 14;
pub const ENOTBLK: u32 = 15;
pub const EBUSY: u32 = 16;
pub const EEXIST: u32 = 17;
pub const EXDEV: u32 = 18;
pub const ENODEV: u32 = 19;
pub const ENOTDIR: u32 = 20;
pub const EISDIR: u32 = 21;
pub const EINVAL: u32 = 22;
pub const ENFILE: u32 = 23;
pub const EMFILE: u32 = 24;
pub const ENOTTY: u32 = 25;
pub const ETXTBSY: u32 = 26;
pub const EFBIG: u32 = 27;
pub const ENOSPC: u32 = 28;
pub const ESPIPE: u32 = 29;
pub const EROFS: u32 = 30;
pub const EMLINK: u32 = 31;
pub const EPIPE: u32 = 32;
pub const EDOM: u32 = 33;
pub const ERANGE: u32 = 34;
pub const EAGAIN: u32 = 35;
pub const EWOULDBLOCK: u32 = 35;
pub const EINPROGRESS: u32 = 36;
pub const EALREADY: u32 = 37;
pub const ENOTSOCK: u32 = 38;
pub const EDESTADDRREQ: u32 = 39;
pub const EMSGSIZE: u32 = 40;
pub const EPROTOTYPE: u32 = 41;
pub const ENOPROTOOPT: u32 = 42;
pub const EPROTONOSUPPORT: u32 = 43;
pub const ESOCKTNOSUPPORT: u32 = 44;
pub const ENOTSUP: u32 = 45;
pub const EPFNOSUPPORT: u32 = 46;
pub const EAFNOSUPPORT: u32 = 47;
pub const EADDRINUSE: u32 = 48;
pub const EADDRNOTAVAIL: u32 = 49;
pub const ENETDOWN: u32 = 50;
pub const ENETUNREACH: u32 = 51;
pub const ENETRESET: u32 = 52;
pub const ECONNABORTED: u32 = 53;
pub const ECONNRESET: u32 = 54;
pub const ENOBUFS: u32 = 55;
pub const EISCONN: u32 = 56;
pub const ENOTCONN: u32 = 57;
pub const ESHUTDOWN: u32 = 58;
pub const ETOOMANYREFS: u32 = 59;
pub const ETIMEDOUT: u32 = 60;
pub const ECONNREFUSED: u32 = 61;
pub const ELOOP: u32 = 62;
pub const ENAMETOOLONG: u32 = 63;
pub const EHOSTDOWN: u32 = 64;
pub const EHOSTUNREACH: u32 = 65;
pub const ENOTEMPTY: u32 = 66;
pub const EPROCLIM: u32 = 67;
pub const EUSERS: u32 = 68;
pub const EDQUOT: u32 = 69;
pub const ESTALE: u32 = 70;
pub const EREMOTE: u32 = 71;
pub const EBADRPC: u32 = 72;
pub const ERPCMISMATCH: u32 = 73;
pub const EPROGUNAVAIL: u32 = 74;
pub const EPROGMISMATCH: u32 = 75;
pub const EPROCUNAVAIL: u32 = 76;
pub const ENOLCK: u32 = 77;
pub const ENOSYS: u32 = 78;
pub const EFTYPE: u32 = 79;
pub const EAUTH: u32 = 80;
pub const ENEEDAUTH: u32 = 81;
pub const EPWROFF: u32 = 82;
pub const EDEVERR: u32 = 83;
pub const EOVERFLOW: u32 = 84;
pub const EBADEXEC: u32 = 85;
pub const EBADARCH: u32 = 86;
pub const ESHLIBVERS: u32 = 87;
pub const EBADMACHO: u32 = 88;
pub const ECANCELED: u32 = 89;
pub const EIDRM: u32 = 90;
pub const ENOMSG: u32 = 91;
pub const EILSEQ: u32 = 92;
pub const ENOATTR: u32 = 93;
pub const EBADMSG: u32 = 94;
pub const EMULTIHOP: u32 = 95;
pub const ENODATA: u32 = 96;
pub const ENOLINK: u32 = 97;
pub const ENOSR: u32 = 98;
pub const ENOSTR: u32 = 99;
pub const EPROTO: u32 = 100;
pub const ETIME: u32 = 101;
pub const EOPNOTSUPP: u32 = 102;
pub const ENOPOLICY: u32 = 103;
pub const ENOTRECOVERABLE: u32 = 104;
pub const EOWNERDEAD: u32 = 105;
pub const EQFULL: u32 = 106;
pub const ELAST: u32 = 106;
pub const R_SYS_DEVNULL: &'static [u8; 10usize] = b"/dev/null\0";
pub const R_SYS_BITS_8: u32 = 1;
pub const R_SYS_BITS_16: u32 = 2;
pub const R_SYS_BITS_32: u32 = 4;
pub const R_SYS_BITS_64: u32 = 8;
pub const SHELL_PATH: &'static [u8; 8usize] = b"/bin/sh\0";
pub const TERMUX_PREFIX: &'static [u8; 32usize] = b"/data/data/com.termux/files/usr\0";
pub const HT_NULL_VALUE: u32 = 0;
pub const VEOF: u32 = 0;
pub const VEOL: u32 = 1;
pub const VEOL2: u32 = 2;
pub const VERASE: u32 = 3;
pub const VWERASE: u32 = 4;
pub const VKILL: u32 = 5;
pub const VREPRINT: u32 = 6;
pub const VINTR: u32 = 8;
pub const VQUIT: u32 = 9;
pub const VSUSP: u32 = 10;
pub const VDSUSP: u32 = 11;
pub const VSTART: u32 = 12;
pub const VSTOP: u32 = 13;
pub const VLNEXT: u32 = 14;
pub const VDISCARD: u32 = 15;
pub const VMIN: u32 = 16;
pub const VTIME: u32 = 17;
pub const VSTATUS: u32 = 18;
pub const NCCS: u32 = 20;
pub const IGNBRK: u32 = 1;
pub const BRKINT: u32 = 2;
pub const IGNPAR: u32 = 4;
pub const PARMRK: u32 = 8;
pub const INPCK: u32 = 16;
pub const ISTRIP: u32 = 32;
pub const INLCR: u32 = 64;
pub const IGNCR: u32 = 128;
pub const ICRNL: u32 = 256;
pub const IXON: u32 = 512;
pub const IXOFF: u32 = 1024;
pub const IXANY: u32 = 2048;
pub const IMAXBEL: u32 = 8192;
pub const IUTF8: u32 = 16384;
pub const OPOST: u32 = 1;
pub const ONLCR: u32 = 2;
pub const OXTABS: u32 = 4;
pub const ONOEOT: u32 = 8;
pub const OCRNL: u32 = 16;
pub const ONOCR: u32 = 32;
pub const ONLRET: u32 = 64;
pub const OFILL: u32 = 128;
pub const NLDLY: u32 = 768;
pub const TABDLY: u32 = 3076;
pub const CRDLY: u32 = 12288;
pub const FFDLY: u32 = 16384;
pub const BSDLY: u32 = 32768;
pub const VTDLY: u32 = 65536;
pub const OFDEL: u32 = 131072;
pub const NL0: u32 = 0;
pub const NL1: u32 = 256;
pub const NL2: u32 = 512;
pub const NL3: u32 = 768;
pub const TAB0: u32 = 0;
pub const TAB1: u32 = 1024;
pub const TAB2: u32 = 2048;
pub const TAB3: u32 = 4;
pub const CR0: u32 = 0;
pub const CR1: u32 = 4096;
pub const CR2: u32 = 8192;
pub const CR3: u32 = 12288;
pub const FF0: u32 = 0;
pub const FF1: u32 = 16384;
pub const BS0: u32 = 0;
pub const BS1: u32 = 32768;
pub const VT0: u32 = 0;
pub const VT1: u32 = 65536;
pub const CIGNORE: u32 = 1;
pub const CSIZE: u32 = 768;
pub const CS5: u32 = 0;
pub const CS6: u32 = 256;
pub const CS7: u32 = 512;
pub const CS8: u32 = 768;
pub const CSTOPB: u32 = 1024;
pub const CREAD: u32 = 2048;
pub const PARENB: u32 = 4096;
pub const PARODD: u32 = 8192;
pub const HUPCL: u32 = 16384;
pub const CLOCAL: u32 = 32768;
pub const CCTS_OFLOW: u32 = 65536;
pub const CRTS_IFLOW: u32 = 131072;
pub const CDTR_IFLOW: u32 = 262144;
pub const CDSR_OFLOW: u32 = 524288;
pub const CCAR_OFLOW: u32 = 1048576;
pub const MDMBUF: u32 = 1048576;
pub const ECHOKE: u32 = 1;
pub const ECHOE: u32 = 2;
pub const ECHOK: u32 = 4;
pub const ECHO: u32 = 8;
pub const ECHONL: u32 = 16;
pub const ECHOPRT: u32 = 32;
pub const ECHOCTL: u32 = 64;
pub const ISIG: u32 = 128;
pub const ICANON: u32 = 256;
pub const ALTWERASE: u32 = 512;
pub const IEXTEN: u32 = 1024;
pub const EXTPROC: u32 = 2048;
pub const TOSTOP: u32 = 4194304;
pub const FLUSHO: u32 = 8388608;
pub const NOKERNINFO: u32 = 33554432;
pub const PENDIN: u32 = 536870912;
pub const NOFLSH: u32 = 2147483648;
pub const TCSANOW: u32 = 0;
pub const TCSADRAIN: u32 = 1;
pub const TCSAFLUSH: u32 = 2;
pub const TCSASOFT: u32 = 16;
pub const B0: u32 = 0;
pub const B50: u32 = 50;
pub const B75: u32 = 75;
pub const B110: u32 = 110;
pub const B134: u32 = 134;
pub const B150: u32 = 150;
pub const B200: u32 = 200;
pub const B300: u32 = 300;
pub const B600: u32 = 600;
pub const B1200: u32 = 1200;
pub const B1800: u32 = 1800;
pub const B2400: u32 = 2400;
pub const B4800: u32 = 4800;
pub const B9600: u32 = 9600;
pub const B19200: u32 = 19200;
pub const B38400: u32 = 38400;
pub const B7200: u32 = 7200;
pub const B14400: u32 = 14400;
pub const B28800: u32 = 28800;
pub const B57600: u32 = 57600;
pub const B76800: u32 = 76800;
pub const B115200: u32 = 115200;
pub const B230400: u32 = 230400;
pub const EXTA: u32 = 19200;
pub const EXTB: u32 = 38400;
pub const TCIFLUSH: u32 = 1;
pub const TCOFLUSH: u32 = 2;
pub const TCIOFLUSH: u32 = 3;
pub const TCOOFF: u32 = 1;
pub const TCOON: u32 = 2;
pub const TCIOFF: u32 = 3;
pub const TCION: u32 = 4;
pub const IOCPARM_MASK: u32 = 8191;
pub const IOCPARM_MAX: u32 = 8192;
pub const TIOCM_LE: u32 = 1;
pub const TIOCM_DTR: u32 = 2;
pub const TIOCM_RTS: u32 = 4;
pub const TIOCM_ST: u32 = 8;
pub const TIOCM_SR: u32 = 16;
pub const TIOCM_CTS: u32 = 32;
pub const TIOCM_CAR: u32 = 64;
pub const TIOCM_CD: u32 = 64;
pub const TIOCM_RNG: u32 = 128;
pub const TIOCM_RI: u32 = 128;
pub const TIOCM_DSR: u32 = 256;
pub const TIOCPKT_DATA: u32 = 0;
pub const TIOCPKT_FLUSHREAD: u32 = 1;
pub const TIOCPKT_FLUSHWRITE: u32 = 2;
pub const TIOCPKT_STOP: u32 = 4;
pub const TIOCPKT_START: u32 = 8;
pub const TIOCPKT_NOSTOP: u32 = 16;
pub const TIOCPKT_DOSTOP: u32 = 32;
pub const TIOCPKT_IOCTL: u32 = 64;
pub const TTYDISC: u32 = 0;
pub const TABLDISC: u32 = 3;
pub const SLIPDISC: u32 = 4;
pub const PPPDISC: u32 = 5;
pub const TTYDEF_IFLAG: u32 = 11010;
pub const TTYDEF_OFLAG: u32 = 3;
pub const TTYDEF_LFLAG: u32 = 1483;
pub const TTYDEF_CFLAG: u32 = 19200;
pub const TTYDEF_SPEED: u32 = 9600;
pub const CEOL: u32 = 255;
pub const CERASE: u32 = 127;
pub const CMIN: u32 = 1;
pub const CQUIT: u32 = 28;
pub const CTIME: u32 = 0;
pub const CBRK: u32 = 255;
pub const KEV_INET_SUBCLASS: u32 = 1;
pub const KEV_INET_NEW_ADDR: u32 = 1;
pub const KEV_INET_CHANGED_ADDR: u32 = 2;
pub const KEV_INET_ADDR_DELETED: u32 = 3;
pub const KEV_INET_SIFDSTADDR: u32 = 4;
pub const KEV_INET_SIFBRDADDR: u32 = 5;
pub const KEV_INET_SIFNETMASK: u32 = 6;
pub const KEV_INET_ARPCOLLISION: u32 = 7;
pub const KEV_INET_PORTINUSE: u32 = 8;
pub const KEV_INET_ARPRTRFAILURE: u32 = 9;
pub const KEV_INET_ARPRTRALIVE: u32 = 10;
pub const KEV_DL_SUBCLASS: u32 = 2;
pub const KEV_DL_SIFFLAGS: u32 = 1;
pub const KEV_DL_SIFMETRICS: u32 = 2;
pub const KEV_DL_SIFMTU: u32 = 3;
pub const KEV_DL_SIFPHYS: u32 = 4;
pub const KEV_DL_SIFMEDIA: u32 = 5;
pub const KEV_DL_SIFGENERIC: u32 = 6;
pub const KEV_DL_ADDMULTI: u32 = 7;
pub const KEV_DL_DELMULTI: u32 = 8;
pub const KEV_DL_IF_ATTACHED: u32 = 9;
pub const KEV_DL_IF_DETACHING: u32 = 10;
pub const KEV_DL_IF_DETACHED: u32 = 11;
pub const KEV_DL_LINK_OFF: u32 = 12;
pub const KEV_DL_LINK_ON: u32 = 13;
pub const KEV_DL_PROTO_ATTACHED: u32 = 14;
pub const KEV_DL_PROTO_DETACHED: u32 = 15;
pub const KEV_DL_LINK_ADDRESS_CHANGED: u32 = 16;
pub const KEV_DL_WAKEFLAGS_CHANGED: u32 = 17;
pub const KEV_DL_IF_IDLE_ROUTE_REFCNT: u32 = 18;
pub const KEV_DL_IFCAP_CHANGED: u32 = 19;
pub const KEV_DL_LINK_QUALITY_METRIC_CHANGED: u32 = 20;
pub const KEV_DL_NODE_PRESENCE: u32 = 21;
pub const KEV_DL_NODE_ABSENCE: u32 = 22;
pub const KEV_DL_MASTER_ELECTED: u32 = 23;
pub const KEV_DL_ISSUES: u32 = 24;
pub const KEV_DL_IFDELEGATE_CHANGED: u32 = 25;
pub const KEV_DL_AWDL_RESTRICTED: u32 = 26;
pub const KEV_DL_AWDL_UNRESTRICTED: u32 = 27;
pub const KEV_DL_RRC_STATE_CHANGED: u32 = 28;
pub const KEV_DL_QOS_MODE_CHANGED: u32 = 29;
pub const KEV_DL_LOW_POWER_MODE_CHANGED: u32 = 30;
pub const KEV_INET6_SUBCLASS: u32 = 6;
pub const KEV_INET6_NEW_USER_ADDR: u32 = 1;
pub const KEV_INET6_CHANGED_ADDR: u32 = 2;
pub const KEV_INET6_ADDR_DELETED: u32 = 3;
pub const KEV_INET6_NEW_LL_ADDR: u32 = 4;
pub const KEV_INET6_NEW_RTADV_ADDR: u32 = 5;
pub const KEV_INET6_DEFROUTER: u32 = 6;
pub const KEV_INET6_REQUEST_NAT64_PREFIX: u32 = 7;
pub const SOCK_STREAM: u32 = 1;
pub const SOCK_DGRAM: u32 = 2;
pub const SOCK_RAW: u32 = 3;
pub const SOCK_RDM: u32 = 4;
pub const SOCK_SEQPACKET: u32 = 5;
pub const SO_DEBUG: u32 = 1;
pub const SO_ACCEPTCONN: u32 = 2;
pub const SO_REUSEADDR: u32 = 4;
pub const SO_KEEPALIVE: u32 = 8;
pub const SO_DONTROUTE: u32 = 16;
pub const SO_BROADCAST: u32 = 32;
pub const SO_USELOOPBACK: u32 = 64;
pub const SO_LINGER: u32 = 128;
pub const SO_OOBINLINE: u32 = 256;
pub const SO_REUSEPORT: u32 = 512;
pub const SO_TIMESTAMP: u32 = 1024;
pub const SO_TIMESTAMP_MONOTONIC: u32 = 2048;
pub const SO_DONTTRUNC: u32 = 8192;
pub const SO_WANTMORE: u32 = 16384;
pub const SO_WANTOOBFLAG: u32 = 32768;
pub const SO_SNDBUF: u32 = 4097;
pub const SO_RCVBUF: u32 = 4098;
pub const SO_SNDLOWAT: u32 = 4099;
pub const SO_RCVLOWAT: u32 = 4100;
pub const SO_SNDTIMEO: u32 = 4101;
pub const SO_RCVTIMEO: u32 = 4102;
pub const SO_ERROR: u32 = 4103;
pub const SO_TYPE: u32 = 4104;
pub const SO_LABEL: u32 = 4112;
pub const SO_PEERLABEL: u32 = 4113;
pub const SO_NREAD: u32 = 4128;
pub const SO_NKE: u32 = 4129;
pub const SO_NOSIGPIPE: u32 = 4130;
pub const SO_NOADDRERR: u32 = 4131;
pub const SO_NWRITE: u32 = 4132;
pub const SO_REUSESHAREUID: u32 = 4133;
pub const SO_NOTIFYCONFLICT: u32 = 4134;
pub const SO_UPCALLCLOSEWAIT: u32 = 4135;
pub const SO_LINGER_SEC: u32 = 4224;
pub const SO_RANDOMPORT: u32 = 4226;
pub const SO_NP_EXTENSIONS: u32 = 4227;
pub const SO_NUMRCVPKT: u32 = 4370;
pub const SO_NET_SERVICE_TYPE: u32 = 4374;
pub const SO_NETSVC_MARKING_LEVEL: u32 = 4377;
pub const NET_SERVICE_TYPE_BE: u32 = 0;
pub const NET_SERVICE_TYPE_BK: u32 = 1;
pub const NET_SERVICE_TYPE_SIG: u32 = 2;
pub const NET_SERVICE_TYPE_VI: u32 = 3;
pub const NET_SERVICE_TYPE_VO: u32 = 4;
pub const NET_SERVICE_TYPE_RV: u32 = 5;
pub const NET_SERVICE_TYPE_AV: u32 = 6;
pub const NET_SERVICE_TYPE_OAM: u32 = 7;
pub const NET_SERVICE_TYPE_RD: u32 = 8;
pub const NETSVC_MRKNG_UNKNOWN: u32 = 0;
pub const NETSVC_MRKNG_LVL_L2: u32 = 1;
pub const NETSVC_MRKNG_LVL_L3L2_ALL: u32 = 2;
pub const NETSVC_MRKNG_LVL_L3L2_BK: u32 = 3;
pub const SAE_ASSOCID_ANY: u32 = 0;
pub const SAE_CONNID_ANY: u32 = 0;
pub const CONNECT_RESUME_ON_READ_WRITE: u32 = 1;
pub const CONNECT_DATA_IDEMPOTENT: u32 = 2;
pub const CONNECT_DATA_AUTHENTICATED: u32 = 4;
pub const SONPX_SETOPTSHUT: u32 = 1;
pub const SOL_SOCKET: u32 = 65535;
pub const AF_UNSPEC: u32 = 0;
pub const AF_UNIX: u32 = 1;
pub const AF_LOCAL: u32 = 1;
pub const AF_INET: u32 = 2;
pub const AF_IMPLINK: u32 = 3;
pub const AF_PUP: u32 = 4;
pub const AF_CHAOS: u32 = 5;
pub const AF_NS: u32 = 6;
pub const AF_ISO: u32 = 7;
pub const AF_OSI: u32 = 7;
pub const AF_ECMA: u32 = 8;
pub const AF_DATAKIT: u32 = 9;
pub const AF_CCITT: u32 = 10;
pub const AF_SNA: u32 = 11;
pub const AF_DECnet: u32 = 12;
pub const AF_DLI: u32 = 13;
pub const AF_LAT: u32 = 14;
pub const AF_HYLINK: u32 = 15;
pub const AF_APPLETALK: u32 = 16;
pub const AF_ROUTE: u32 = 17;
pub const AF_LINK: u32 = 18;
pub const pseudo_AF_XTP: u32 = 19;
pub const AF_COIP: u32 = 20;
pub const AF_CNT: u32 = 21;
pub const pseudo_AF_RTIP: u32 = 22;
pub const AF_IPX: u32 = 23;
pub const AF_SIP: u32 = 24;
pub const pseudo_AF_PIP: u32 = 25;
pub const AF_NDRV: u32 = 27;
pub const AF_ISDN: u32 = 28;
pub const AF_E164: u32 = 28;
pub const pseudo_AF_KEY: u32 = 29;
pub const AF_INET6: u32 = 30;
pub const AF_NATM: u32 = 31;
pub const AF_SYSTEM: u32 = 32;
pub const AF_NETBIOS: u32 = 33;
pub const AF_PPP: u32 = 34;
pub const pseudo_AF_HDRCMPLT: u32 = 35;
pub const AF_RESERVED_36: u32 = 36;
pub const AF_IEEE80211: u32 = 37;
pub const AF_UTUN: u32 = 38;
pub const AF_MAX: u32 = 40;
pub const SOCK_MAXADDRLEN: u32 = 255;
pub const _SS_MAXSIZE: u32 = 128;
pub const PF_UNSPEC: u32 = 0;
pub const PF_LOCAL: u32 = 1;
pub const PF_UNIX: u32 = 1;
pub const PF_INET: u32 = 2;
pub const PF_IMPLINK: u32 = 3;
pub const PF_PUP: u32 = 4;
pub const PF_CHAOS: u32 = 5;
pub const PF_NS: u32 = 6;
pub const PF_ISO: u32 = 7;
pub const PF_OSI: u32 = 7;
pub const PF_ECMA: u32 = 8;
pub const PF_DATAKIT: u32 = 9;
pub const PF_CCITT: u32 = 10;
pub const PF_SNA: u32 = 11;
pub const PF_DECnet: u32 = 12;
pub const PF_DLI: u32 = 13;
pub const PF_LAT: u32 = 14;
pub const PF_HYLINK: u32 = 15;
pub const PF_APPLETALK: u32 = 16;
pub const PF_ROUTE: u32 = 17;
pub const PF_LINK: u32 = 18;
pub const PF_XTP: u32 = 19;
pub const PF_COIP: u32 = 20;
pub const PF_CNT: u32 = 21;
pub const PF_SIP: u32 = 24;
pub const PF_IPX: u32 = 23;
pub const PF_RTIP: u32 = 22;
pub const PF_PIP: u32 = 25;
pub const PF_NDRV: u32 = 27;
pub const PF_ISDN: u32 = 28;
pub const PF_KEY: u32 = 29;
pub const PF_INET6: u32 = 30;
pub const PF_NATM: u32 = 31;
pub const PF_SYSTEM: u32 = 32;
pub const PF_NETBIOS: u32 = 33;
pub const PF_PPP: u32 = 34;
pub const PF_RESERVED_36: u32 = 36;
pub const PF_UTUN: u32 = 38;
pub const PF_MAX: u32 = 40;
pub const NET_MAXID: u32 = 40;
pub const NET_RT_DUMP: u32 = 1;
pub const NET_RT_FLAGS: u32 = 2;
pub const NET_RT_IFLIST: u32 = 3;
pub const NET_RT_STAT: u32 = 4;
pub const NET_RT_TRASH: u32 = 5;
pub const NET_RT_IFLIST2: u32 = 6;
pub const NET_RT_DUMP2: u32 = 7;
pub const NET_RT_FLAGS_PRIV: u32 = 10;
pub const NET_RT_MAXID: u32 = 11;
pub const SOMAXCONN: u32 = 128;
pub const MSG_OOB: u32 = 1;
pub const MSG_PEEK: u32 = 2;
pub const MSG_DONTROUTE: u32 = 4;
pub const MSG_EOR: u32 = 8;
pub const MSG_TRUNC: u32 = 16;
pub const MSG_CTRUNC: u32 = 32;
pub const MSG_WAITALL: u32 = 64;
pub const MSG_DONTWAIT: u32 = 128;
pub const MSG_EOF: u32 = 256;
pub const MSG_WAITSTREAM: u32 = 512;
pub const MSG_FLUSH: u32 = 1024;
pub const MSG_HOLD: u32 = 2048;
pub const MSG_SEND: u32 = 4096;
pub const MSG_HAVEMORE: u32 = 8192;
pub const MSG_RCVMORE: u32 = 16384;
pub const MSG_NEEDSA: u32 = 65536;
pub const SCM_RIGHTS: u32 = 1;
pub const SCM_TIMESTAMP: u32 = 2;
pub const SCM_CREDS: u32 = 3;
pub const SCM_TIMESTAMP_MONOTONIC: u32 = 4;
pub const SHUT_RD: u32 = 0;
pub const SHUT_WR: u32 = 1;
pub const SHUT_RDWR: u32 = 2;
pub const CONS_MAX_USER: u32 = 102400;
pub const CONS_BUFSZ: u32 = 20224;
pub const CONS_PALETTE_SIZE: u32 = 22;
pub const CONS_COLORS_SIZE: u32 = 21;
pub const R_CONS_GREP_WORDS: u32 = 10;
pub const R_CONS_GREP_WORD_SIZE: u32 = 64;
pub const R_CONS_GREP_TOKENS: u32 = 64;
pub const R_CONS_GREP_COUNT: u32 = 10;
pub const R_CONS_CMD_DEPTH: u32 = 100;
pub const CONS_MAX_ATTR_SZ: u32 = 16;
pub const RUNECODE_MIN: u32 = 200;
pub const RUNECODE_LINE_VERT: u32 = 200;
pub const RUNECODE_LINE_CROSS: u32 = 201;
pub const RUNECODE_CORNER_BR: u32 = 202;
pub const RUNECODE_CORNER_BL: u32 = 203;
pub const RUNECODE_ARROW_RIGHT: u32 = 204;
pub const RUNECODE_ARROW_LEFT: u32 = 205;
pub const RUNECODE_LINE_HORIZ: u32 = 206;
pub const RUNECODE_CORNER_TL: u32 = 207;
pub const RUNECODE_CORNER_TR: u32 = 208;
pub const RUNECODE_LINE_UP: u32 = 209;
pub const RUNECODE_CURVE_CORNER_TL: u32 = 210;
pub const RUNECODE_CURVE_CORNER_TR: u32 = 211;
pub const RUNECODE_CURVE_CORNER_BR: u32 = 212;
pub const RUNECODE_CURVE_CORNER_BL: u32 = 213;
pub const RUNECODE_MAX: u32 = 214;
pub const RUNECODESTR_MIN: u32 = 200;
pub const RUNECODESTR_LINE_VERT: [u8; 2usize] = [200u8, 0u8];
pub const RUNECODESTR_LINE_CROSS: [u8; 2usize] = [201u8, 0u8];
pub const RUNECODESTR_CORNER_BR: [u8; 2usize] = [202u8, 0u8];
pub const RUNECODESTR_CORNER_BL: [u8; 2usize] = [203u8, 0u8];
pub const RUNECODESTR_ARROW_RIGHT: [u8; 2usize] = [204u8, 0u8];
pub const RUNECODESTR_ARROW_LEFT: [u8; 2usize] = [205u8, 0u8];
pub const RUNECODESTR_LINE_HORIZ: [u8; 2usize] = [206u8, 0u8];
pub const RUNECODESTR_CORNER_TL: [u8; 2usize] = [207u8, 0u8];
pub const RUNECODESTR_CORNER_TR: [u8; 2usize] = [208u8, 0u8];
pub const RUNECODESTR_LINE_UP: [u8; 2usize] = [209u8, 0u8];
pub const RUNECODESTR_CURVE_CORNER_TL: [u8; 2usize] = [210u8, 0u8];
pub const RUNECODESTR_CURVE_CORNER_TR: [u8; 2usize] = [211u8, 0u8];
pub const RUNECODESTR_CURVE_CORNER_BR: [u8; 2usize] = [212u8, 0u8];
pub const RUNECODESTR_CURVE_CORNER_BL: [u8; 2usize] = [213u8, 0u8];
pub const RUNECODESTR_MAX: u32 = 213;
pub const RUNE_LINE_VERT: &'static [u8; 4usize] = b"\xE2\x94\x82\0";
pub const RUNE_LINE_CROSS: &'static [u8; 4usize] = b"\xE2\x94\xBC\0";
pub const RUNE_LINE_HORIZ: &'static [u8; 4usize] = b"\xE2\x94\x80\0";
pub const RUNE_LINE_UP: &'static [u8; 4usize] = b"\xE2\x86\x91\0";
pub const RUNE_CORNER_BR: &'static [u8; 4usize] = b"\xE2\x94\x98\0";
pub const RUNE_CORNER_BL: &'static [u8; 4usize] = b"\xE2\x94\x94\0";
pub const RUNE_CORNER_TL: &'static [u8; 4usize] = b"\xE2\x94\x8C\0";
pub const RUNE_CORNER_TR: &'static [u8; 4usize] = b"\xE2\x94\x90\0";
pub const RUNE_ARROW_RIGHT: &'static [u8; 2usize] = b">\0";
pub const RUNE_ARROW_LEFT: &'static [u8; 2usize] = b"<\0";
pub const RUNE_CURVE_CORNER_TL: &'static [u8; 4usize] = b"\xE2\x95\xAD\0";
pub const RUNE_CURVE_CORNER_TR: &'static [u8; 4usize] = b"\xE2\x95\xAE\0";
pub const RUNE_CURVE_CORNER_BR: &'static [u8; 4usize] = b"\xE2\x95\xAF\0";
pub const RUNE_CURVE_CORNER_BL: &'static [u8; 4usize] = b"\xE2\x95\xB0\0";
pub const RUNE_LONG_LINE_HORIZ: &'static [u8; 4usize] = b"\xE2\x80\x95\0";
pub const R_UTF8_CIRCLE: &'static [u8; 4usize] = b"\xE2\x97\xAF\0";
pub const R_UTF8_BLOCK: &'static [u8; 4usize] = b"\xE2\x96\x88\0";
pub const R_UTF8_POLICE_CARS_REVOLVING_LIGHT: &'static [u8; 5usize] = b"\xF0\x9F\x9A\xA8\0";
pub const R_UTF8_WHITE_HEAVY_CHECK_MARK: &'static [u8; 4usize] = b"\xE2\x9C\x85\0";
pub const R_UTF8_SEE_NO_EVIL_MONKEY: &'static [u8; 5usize] = b"\xF0\x9F\x99\x88\0";
pub const R_UTF8_SKULL_AND_CROSSBONES: &'static [u8; 4usize] = b"\xE2\x98\xA0\0";
pub const R_UTF8_KEYBOARD: &'static [u8; 4usize] = b"\xE2\x8C\xA8\0";
pub const R_UTF8_LEFT_POINTING_MAGNIFYING_GLASS: &'static [u8; 5usize] = b"\xF0\x9F\x94\x8D\0";
pub const R_UTF8_DOOR: &'static [u8; 5usize] = b"\xF0\x9F\x9A\xAA\0";
pub const R_UTF8_VS16: &'static [u8; 4usize] = b"\xEF\xB8\x8F\0";
pub const HUD_BUF_SIZE: u32 = 512;
pub const R_CONS_KEY_F1: u32 = 241;
pub const R_CONS_KEY_F2: u32 = 242;
pub const R_CONS_KEY_F3: u32 = 243;
pub const R_CONS_KEY_F4: u32 = 244;
pub const R_CONS_KEY_F5: u32 = 245;
pub const R_CONS_KEY_F6: u32 = 246;
pub const R_CONS_KEY_F7: u32 = 247;
pub const R_CONS_KEY_F8: u32 = 248;
pub const R_CONS_KEY_F9: u32 = 249;
pub const R_CONS_KEY_F10: u32 = 250;
pub const R_CONS_KEY_F11: u32 = 251;
pub const R_CONS_KEY_F12: u32 = 252;
pub const R_CONS_KEY_ESC: u32 = 27;
pub const R_CONS_CLEAR_LINE: &'static [u8; 6usize] = b"\x1B[2K\r\0";
pub const R_CONS_CLEAR_SCREEN: &'static [u8; 6usize] = b"\x1B[2J\r\0";
pub const R_CONS_CLEAR_FROM_CURSOR_TO_END: &'static [u8; 6usize] = b"\x1B[0J\r\0";
pub const R_CONS_CURSOR_SAVE: &'static [u8; 4usize] = b"\x1B[s\0";
pub const R_CONS_CURSOR_RESTORE: &'static [u8; 4usize] = b"\x1B[u\0";
pub const R_CONS_GET_CURSOR_POSITION: &'static [u8; 5usize] = b"\x1B[6n\0";
pub const R_CONS_CURSOR_UP: &'static [u8; 4usize] = b"\x1B[A\0";
pub const R_CONS_CURSOR_DOWN: &'static [u8; 4usize] = b"\x1B[B\0";
pub const R_CONS_CURSOR_RIGHT: &'static [u8; 4usize] = b"\x1B[C\0";
pub const R_CONS_CURSOR_LEFT: &'static [u8; 4usize] = b"\x1B[D\0";
pub const Color_BLINK: &'static [u8; 5usize] = b"\x1B[5m\0";
pub const Color_INVERT: &'static [u8; 5usize] = b"\x1B[7m\0";
pub const Color_INVERT_RESET: &'static [u8; 6usize] = b"\x1B[27m\0";
pub const Color_RESET_TERMINAL: &'static [u8; 19usize] = b"\x1Bc\x1B(K\x1B[0m\x1B[J\x1B[?25h\0";
pub const Color_RESET: &'static [u8; 5usize] = b"\x1B[0m\0";
pub const Color_RESET_NOBG: &'static [u8; 21usize] = b"\x1B[27;22;24;25;28;39m\0";
pub const Color_RESET_BG: &'static [u8; 6usize] = b"\x1B[49m\0";
pub const Color_RESET_ALL: &'static [u8; 10usize] = b"\x1B[0m\x1B[49m\0";
pub const Color_BLACK: &'static [u8; 6usize] = b"\x1B[30m\0";
pub const Color_BGBLACK: &'static [u8; 6usize] = b"\x1B[40m\0";
pub const Color_RED: &'static [u8; 6usize] = b"\x1B[31m\0";
pub const Color_BGRED: &'static [u8; 6usize] = b"\x1B[41m\0";
pub const Color_WHITE: &'static [u8; 6usize] = b"\x1B[37m\0";
pub const Color_BGWHITE: &'static [u8; 6usize] = b"\x1B[47m\0";
pub const Color_GREEN: &'static [u8; 6usize] = b"\x1B[32m\0";
pub const Color_BGGREEN: &'static [u8; 6usize] = b"\x1B[42m\0";
pub const Color_MAGENTA: &'static [u8; 6usize] = b"\x1B[35m\0";
pub const Color_BGMAGENTA: &'static [u8; 6usize] = b"\x1B[45m\0";
pub const Color_YELLOW: &'static [u8; 6usize] = b"\x1B[33m\0";
pub const Color_BGYELLOW: &'static [u8; 6usize] = b"\x1B[43m\0";
pub const Color_CYAN: &'static [u8; 6usize] = b"\x1B[36m\0";
pub const Color_BGCYAN: &'static [u8; 6usize] = b"\x1B[46m\0";
pub const Color_BLUE: &'static [u8; 6usize] = b"\x1B[34m\0";
pub const Color_BGBLUE: &'static [u8; 6usize] = b"\x1B[44m\0";
pub const Color_GRAY: &'static [u8; 6usize] = b"\x1B[90m\0";
pub const Color_BGGRAY: &'static [u8; 7usize] = b"\x1B[100m\0";
pub const Color_BBLACK: &'static [u8; 6usize] = b"\x1B[90m\0";
pub const Color_BBGBLACK: &'static [u8; 7usize] = b"\x1B[100m\0";
pub const Color_BRED: &'static [u8; 6usize] = b"\x1B[91m\0";
pub const Color_BBGRED: &'static [u8; 7usize] = b"\x1B[101m\0";
pub const Color_BWHITE: &'static [u8; 6usize] = b"\x1B[97m\0";
pub const Color_BBGWHITE: &'static [u8; 7usize] = b"\x1B[107m\0";
pub const Color_BGREEN: &'static [u8; 6usize] = b"\x1B[92m\0";
pub const Color_BBGGREEN: &'static [u8; 7usize] = b"\x1B[102m\0";
pub const Color_BMAGENTA: &'static [u8; 6usize] = b"\x1B[95m\0";
pub const Color_BBGMAGENTA: &'static [u8; 7usize] = b"\x1B[105m\0";
pub const Color_BYELLOW: &'static [u8; 6usize] = b"\x1B[93m\0";
pub const Color_BBGYELLOW: &'static [u8; 7usize] = b"\x1B[103m\0";
pub const Color_BCYAN: &'static [u8; 6usize] = b"\x1B[96m\0";
pub const Color_BBGCYAN: &'static [u8; 7usize] = b"\x1B[106m\0";
pub const Color_BBLUE: &'static [u8; 6usize] = b"\x1B[94m\0";
pub const Color_BBGBLUE: &'static [u8; 7usize] = b"\x1B[104m\0";
pub const DOT_STYLE_NORMAL: u32 = 0;
pub const DOT_STYLE_CONDITIONAL: u32 = 1;
pub const DOT_STYLE_BACKEDGE: u32 = 2;
pub const LINE_VERT: u32 = 0;
pub const LINE_CROSS: u32 = 1;
pub const LINE_HORIZ: u32 = 2;
pub const LINE_UP: u32 = 3;
pub const CORNER_TL: u32 = 6;
pub const CORNER_BR: u32 = 4;
pub const CORNER_BL: u32 = 5;
pub const CORNER_TR: u32 = 6;
pub const ARROW_RIGHT: u32 = 8;
pub const ARROW_LEFT: u32 = 9;
pub const R_LINE_BUFSIZE: u32 = 4096;
pub const R_LINE_HISTSIZE: u32 = 256;
pub const R_EDGES_X_INC: u32 = 4;
pub const R_SELWIDGET_MAXH: u32 = 15;
pub const R_SELWIDGET_MAXW: u32 = 30;
pub const R_SELWIDGET_DIR_UP: u32 = 0;
pub const R_SELWIDGET_DIR_DOWN: u32 = 1;
pub const Color_INSERT: &'static [u8; 6usize] = b"\x1B[92m\0";
pub const Color_DELETE: &'static [u8; 6usize] = b"\x1B[91m\0";
pub const Color_BGINSERT: &'static [u8; 11usize] = b"\x1B[48;5;22m\0";
pub const Color_BGDELETE: &'static [u8; 11usize] = b"\x1B[48;5;52m\0";
pub const Color_HLINSERT: &'static [u8; 16usize] = b"\x1B[48;5;22m\x1B[92m\0";
pub const Color_HLDELETE: &'static [u8; 16usize] = b"\x1B[48;5;52m\x1B[91m\0";
pub const R_REGEX_BASIC: u32 = 0;
pub const R_REGEX_EXTENDED: u32 = 1;
pub const R_REGEX_ICASE: u32 = 2;
pub const R_REGEX_NOSUB: u32 = 4;
pub const R_REGEX_NEWLINE: u32 = 8;
pub const R_REGEX_NOSPEC: u32 = 16;
pub const R_REGEX_PEND: u32 = 32;
pub const R_REGEX_DUMP: u32 = 128;
pub const R_REGEX_ENOSYS: i32 = -1;
pub const R_REGEX_NOMATCH: u32 = 1;
pub const R_REGEX_BADPAT: u32 = 2;
pub const R_REGEX_ECOLLATE: u32 = 3;
pub const R_REGEX_ECTYPE: u32 = 4;
pub const R_REGEX_EESCAPE: u32 = 5;
pub const R_REGEX_ESUBREG: u32 = 6;
pub const R_REGEX_EBRACK: u32 = 7;
pub const R_REGEX_EPAREN: u32 = 8;
pub const R_REGEX_EBRACE: u32 = 9;
pub const R_REGEX_BADBR: u32 = 10;
pub const R_REGEX_ERANGE: u32 = 11;
pub const R_REGEX_ESPACE: u32 = 12;
pub const R_REGEX_BADRPT: u32 = 13;
pub const R_REGEX_EMPTY: u32 = 14;
pub const R_REGEX_ASSERT: u32 = 15;
pub const R_REGEX_INVARG: u32 = 16;
pub const R_REGEX_ILLSEQ: u32 = 17;
pub const R_REGEX_ATOI: u32 = 255;
pub const R_REGEX_ITOA: u32 = 256;
pub const R_REGEX_NOTBOL: u32 = 1;
pub const R_REGEX_NOTEOL: u32 = 2;
pub const R_REGEX_STARTEND: u32 = 4;
pub const R_REGEX_TRACE: u32 = 256;
pub const R_REGEX_LARGE: u32 = 512;
pub const R_REGEX_BACKR: u32 = 1024;
pub const HAVE_PTHREAD: u32 = 1;
pub const SEM_VALUE_MAX: u32 = 32767;
pub const _PTHREAD_MUTEX_SIG_init: u32 = 850045863;
pub const _PTHREAD_ERRORCHECK_MUTEX_SIG_init: u32 = 850045857;
pub const _PTHREAD_RECURSIVE_MUTEX_SIG_init: u32 = 850045858;
pub const _PTHREAD_FIRSTFIT_MUTEX_SIG_init: u32 = 850045859;
pub const _PTHREAD_COND_SIG_init: u32 = 1018212795;
pub const _PTHREAD_ONCE_SIG_init: u32 = 816954554;
pub const _PTHREAD_RWLOCK_SIG_init: u32 = 766030772;
pub const SCHED_OTHER: u32 = 1;
pub const SCHED_FIFO: u32 = 4;
pub const SCHED_RR: u32 = 2;
pub const __SCHED_PARAM_SIZE__: u32 = 4;
pub const QOS_MIN_RELATIVE_PRIORITY: i32 = -15;
pub const PTHREAD_CREATE_JOINABLE: u32 = 1;
pub const PTHREAD_CREATE_DETACHED: u32 = 2;
pub const PTHREAD_INHERIT_SCHED: u32 = 1;
pub const PTHREAD_EXPLICIT_SCHED: u32 = 2;
pub const PTHREAD_CANCEL_ENABLE: u32 = 1;
pub const PTHREAD_CANCEL_DISABLE: u32 = 0;
pub const PTHREAD_CANCEL_DEFERRED: u32 = 2;
pub const PTHREAD_CANCEL_ASYNCHRONOUS: u32 = 0;
pub const PTHREAD_SCOPE_SYSTEM: u32 = 1;
pub const PTHREAD_SCOPE_PROCESS: u32 = 2;
pub const PTHREAD_PROCESS_SHARED: u32 = 1;
pub const PTHREAD_PROCESS_PRIVATE: u32 = 2;
pub const PTHREAD_PRIO_NONE: u32 = 0;
pub const PTHREAD_PRIO_INHERIT: u32 = 1;
pub const PTHREAD_PRIO_PROTECT: u32 = 2;
pub const PTHREAD_MUTEX_NORMAL: u32 = 0;
pub const PTHREAD_MUTEX_ERRORCHECK: u32 = 1;
pub const PTHREAD_MUTEX_RECURSIVE: u32 = 2;
pub const PTHREAD_MUTEX_DEFAULT: u32 = 0;
pub const PTHREAD_MUTEX_POLICY_FAIRSHARE_NP: u32 = 1;
pub const PTHREAD_MUTEX_POLICY_FIRSTFIT_NP: u32 = 3;
pub const HAVE_PTHREAD_NP: u32 = 1;
pub const _R_UTIL_ALLOC_H_: u32 = 1;
pub const R_MALLOC_WRAPPER: u32 = 0;
pub const R_MALLOC_GLOBAL: u32 = 0;
pub const R_RBTREE_MAX_HEIGHT: u32 = 62;
pub const R_BIG_WORD_SIZE: u32 = 4;
pub const R_BIG_ARRAY_SIZE: u32 = 128;
pub const R_BIG_SPRINTF_FORMAT_STR: &'static [u8; 6usize] = b"%.08x\0";
pub const R_BIG_FORMAT_STR_LEN: u32 = 9;
pub const R_BIG_SSCANF_FORMAT_STR: &'static [u8; 4usize] = b"%8x\0";
pub const R_BUF_SET: u32 = 0;
pub const R_BUF_CUR: u32 = 1;
pub const R_BUF_END: u32 = 2;
pub const BITWORD_BITS_SHIFT: u32 = 6;
pub const R_NSEC_PER_SEC: u32 = 1000000000;
pub const R_NSEC_PER_MSEC: u32 = 1000000;
pub const R_USEC_PER_SEC: u32 = 1000000;
pub const R_NSEC_PER_USEC: u32 = 1000;
pub const R_USEC_PER_MSEC: u32 = 1000;
pub const ASCTIME_BUF_MINLEN: u32 = 26;
pub const R_TIME_PROFILE_ENABLED: u32 = 0;
pub const R_SPACES_MAX: u32 = 512;
pub const R_STRPOOL_INC: u32 = 1024;
pub const ASN1_JSON_NULL: &'static [u8; 5usize] = b"null\0";
pub const ASN1_JSON_EMPTY: &'static [u8; 3usize] = b"{}\0";
pub const ASN1_OID_LEN: u32 = 64;
pub const ASN1_CLASS: u32 = 192;
pub const ASN1_FORM: u32 = 32;
pub const ASN1_TAG: u32 = 31;
pub const ASN1_LENLONG: u32 = 128;
pub const ASN1_LENSHORT: u32 = 127;
pub const CLASS_UNIVERSAL: u32 = 0;
pub const CLASS_APPLICATION: u32 = 64;
pub const CLASS_CONTEXT: u32 = 128;
pub const CLASS_PRIVATE: u32 = 192;
pub const FORM_PRIMITIVE: u32 = 0;
pub const FORM_CONSTRUCTED: u32 = 32;
pub const TAG_EOC: u32 = 0;
pub const TAG_BOOLEAN: u32 = 1;
pub const TAG_INTEGER: u32 = 2;
pub const TAG_BITSTRING: u32 = 3;
pub const TAG_OCTETSTRING: u32 = 4;
pub const TAG_NULL: u32 = 5;
pub const TAG_OID: u32 = 6;
pub const TAG_OBJDESCRIPTOR: u32 = 7;
pub const TAG_EXTERNAL: u32 = 8;
pub const TAG_REAL: u32 = 9;
pub const TAG_ENUMERATED: u32 = 10;
pub const TAG_EMBEDDED_PDV: u32 = 11;
pub const TAG_UTF8STRING: u32 = 12;
pub const TAG_SEQUENCE: u32 = 16;
pub const TAG_SET: u32 = 17;
pub const TAG_NUMERICSTRING: u32 = 18;
pub const TAG_PRINTABLESTRING: u32 = 19;
pub const TAG_T61STRING: u32 = 20;
pub const TAG_VIDEOTEXSTRING: u32 = 21;
pub const TAG_IA5STRING: u32 = 22;
pub const TAG_UTCTIME: u32 = 23;
pub const TAG_GENERALIZEDTIME: u32 = 24;
pub const TAG_GRAPHICSTRING: u32 = 25;
pub const TAG_VISIBLESTRING: u32 = 26;
pub const TAG_GENERALSTRING: u32 = 27;
pub const TAG_UNIVERSALSTRING: u32 = 28;
pub const TAG_BMPSTRING: u32 = 30;
pub const IPPROTO_IP: u32 = 0;
pub const IPPROTO_HOPOPTS: u32 = 0;
pub const IPPROTO_ICMP: u32 = 1;
pub const IPPROTO_IGMP: u32 = 2;
pub const IPPROTO_GGP: u32 = 3;
pub const IPPROTO_IPV4: u32 = 4;
pub const IPPROTO_IPIP: u32 = 4;
pub const IPPROTO_TCP: u32 = 6;
pub const IPPROTO_ST: u32 = 7;
pub const IPPROTO_EGP: u32 = 8;
pub const IPPROTO_PIGP: u32 = 9;
pub const IPPROTO_RCCMON: u32 = 10;
pub const IPPROTO_NVPII: u32 = 11;
pub const IPPROTO_PUP: u32 = 12;
pub const IPPROTO_ARGUS: u32 = 13;
pub const IPPROTO_EMCON: u32 = 14;
pub const IPPROTO_XNET: u32 = 15;
pub const IPPROTO_CHAOS: u32 = 16;
pub const IPPROTO_UDP: u32 = 17;
pub const IPPROTO_MUX: u32 = 18;
pub const IPPROTO_MEAS: u32 = 19;
pub const IPPROTO_HMP: u32 = 20;
pub const IPPROTO_PRM: u32 = 21;
pub const IPPROTO_IDP: u32 = 22;
pub const IPPROTO_TRUNK1: u32 = 23;
pub const IPPROTO_TRUNK2: u32 = 24;
pub const IPPROTO_LEAF1: u32 = 25;
pub const IPPROTO_LEAF2: u32 = 26;
pub const IPPROTO_RDP: u32 = 27;
pub const IPPROTO_IRTP: u32 = 28;
pub const IPPROTO_TP: u32 = 29;
pub const IPPROTO_BLT: u32 = 30;
pub const IPPROTO_NSP: u32 = 31;
pub const IPPROTO_INP: u32 = 32;
pub const IPPROTO_SEP: u32 = 33;
pub const IPPROTO_3PC: u32 = 34;
pub const IPPROTO_IDPR: u32 = 35;
pub const IPPROTO_XTP: u32 = 36;
pub const IPPROTO_DDP: u32 = 37;
pub const IPPROTO_CMTP: u32 = 38;
pub const IPPROTO_TPXX: u32 = 39;
pub const IPPROTO_IL: u32 = 40;
pub const IPPROTO_IPV6: u32 = 41;
pub const IPPROTO_SDRP: u32 = 42;
pub const IPPROTO_ROUTING: u32 = 43;
pub const IPPROTO_FRAGMENT: u32 = 44;
pub const IPPROTO_IDRP: u32 = 45;
pub const IPPROTO_RSVP: u32 = 46;
pub const IPPROTO_GRE: u32 = 47;
pub const IPPROTO_MHRP: u32 = 48;
pub const IPPROTO_BHA: u32 = 49;
pub const IPPROTO_ESP: u32 = 50;
pub const IPPROTO_AH: u32 = 51;
pub const IPPROTO_INLSP: u32 = 52;
pub const IPPROTO_SWIPE: u32 = 53;
pub const IPPROTO_NHRP: u32 = 54;
pub const IPPROTO_ICMPV6: u32 = 58;
pub const IPPROTO_NONE: u32 = 59;
pub const IPPROTO_DSTOPTS: u32 = 60;
pub const IPPROTO_AHIP: u32 = 61;
pub const IPPROTO_CFTP: u32 = 62;
pub const IPPROTO_HELLO: u32 = 63;
pub const IPPROTO_SATEXPAK: u32 = 64;
pub const IPPROTO_KRYPTOLAN: u32 = 65;
pub const IPPROTO_RVD: u32 = 66;
pub const IPPROTO_IPPC: u32 = 67;
pub const IPPROTO_ADFS: u32 = 68;
pub const IPPROTO_SATMON: u32 = 69;
pub const IPPROTO_VISA: u32 = 70;
pub const IPPROTO_IPCV: u32 = 71;
pub const IPPROTO_CPNX: u32 = 72;
pub const IPPROTO_CPHB: u32 = 73;
pub const IPPROTO_WSN: u32 = 74;
pub const IPPROTO_PVP: u32 = 75;
pub const IPPROTO_BRSATMON: u32 = 76;
pub const IPPROTO_ND: u32 = 77;
pub const IPPROTO_WBMON: u32 = 78;
pub const IPPROTO_WBEXPAK: u32 = 79;
pub const IPPROTO_EON: u32 = 80;
pub const IPPROTO_VMTP: u32 = 81;
pub const IPPROTO_SVMTP: u32 = 82;
pub const IPPROTO_VINES: u32 = 83;
pub const IPPROTO_TTP: u32 = 84;
pub const IPPROTO_IGP: u32 = 85;
pub const IPPROTO_DGP: u32 = 86;
pub const IPPROTO_TCF: u32 = 87;
pub const IPPROTO_IGRP: u32 = 88;
pub const IPPROTO_OSPFIGP: u32 = 89;
pub const IPPROTO_SRPC: u32 = 90;
pub const IPPROTO_LARP: u32 = 91;
pub const IPPROTO_MTP: u32 = 92;
pub const IPPROTO_AX25: u32 = 93;
pub const IPPROTO_IPEIP: u32 = 94;
pub const IPPROTO_MICP: u32 = 95;
pub const IPPROTO_SCCSP: u32 = 96;
pub const IPPROTO_ETHERIP: u32 = 97;
pub const IPPROTO_ENCAP: u32 = 98;
pub const IPPROTO_APES: u32 = 99;
pub const IPPROTO_GMTP: u32 = 100;
pub const IPPROTO_PIM: u32 = 103;
pub const IPPROTO_IPCOMP: u32 = 108;
pub const IPPROTO_PGM: u32 = 113;
pub const IPPROTO_SCTP: u32 = 132;
pub const IPPROTO_DIVERT: u32 = 254;
pub const IPPROTO_RAW: u32 = 255;
pub const IPPROTO_MAX: u32 = 256;
pub const IPPROTO_DONE: u32 = 257;
pub const __DARWIN_IPPORT_RESERVED: u32 = 1024;
pub const IPPORT_RESERVED: u32 = 1024;
pub const IPPORT_USERRESERVED: u32 = 5000;
pub const IPPORT_HIFIRSTAUTO: u32 = 49152;
pub const IPPORT_HILASTAUTO: u32 = 65535;
pub const IPPORT_RESERVEDSTART: u32 = 600;
pub const IN_CLASSA_NET: u32 = 4278190080;
pub const IN_CLASSA_NSHIFT: u32 = 24;
pub const IN_CLASSA_HOST: u32 = 16777215;
pub const IN_CLASSA_MAX: u32 = 128;
pub const IN_CLASSB_NET: u32 = 4294901760;
pub const IN_CLASSB_NSHIFT: u32 = 16;
pub const IN_CLASSB_HOST: u32 = 65535;
pub const IN_CLASSB_MAX: u32 = 65536;
pub const IN_CLASSC_NET: u32 = 4294967040;
pub const IN_CLASSC_NSHIFT: u32 = 8;
pub const IN_CLASSC_HOST: u32 = 255;
pub const IN_CLASSD_NET: u32 = 4026531840;
pub const IN_CLASSD_NSHIFT: u32 = 28;
pub const IN_CLASSD_HOST: u32 = 268435455;
pub const INADDR_NONE: u32 = 4294967295;
pub const IN_LOOPBACKNET: u32 = 127;
pub const INET_ADDRSTRLEN: u32 = 16;
pub const IP_OPTIONS: u32 = 1;
pub const IP_HDRINCL: u32 = 2;
pub const IP_TOS: u32 = 3;
pub const IP_TTL: u32 = 4;
pub const IP_RECVOPTS: u32 = 5;
pub const IP_RECVRETOPTS: u32 = 6;
pub const IP_RECVDSTADDR: u32 = 7;
pub const IP_RETOPTS: u32 = 8;
pub const IP_MULTICAST_IF: u32 = 9;
pub const IP_MULTICAST_TTL: u32 = 10;
pub const IP_MULTICAST_LOOP: u32 = 11;
pub const IP_ADD_MEMBERSHIP: u32 = 12;
pub const IP_DROP_MEMBERSHIP: u32 = 13;
pub const IP_MULTICAST_VIF: u32 = 14;
pub const IP_RSVP_ON: u32 = 15;
pub const IP_RSVP_OFF: u32 = 16;
pub const IP_RSVP_VIF_ON: u32 = 17;
pub const IP_RSVP_VIF_OFF: u32 = 18;
pub const IP_PORTRANGE: u32 = 19;
pub const IP_RECVIF: u32 = 20;
pub const IP_IPSEC_POLICY: u32 = 21;
pub const IP_FAITH: u32 = 22;
pub const IP_STRIPHDR: u32 = 23;
pub const IP_RECVTTL: u32 = 24;
pub const IP_BOUND_IF: u32 = 25;
pub const IP_PKTINFO: u32 = 26;
pub const IP_RECVPKTINFO: u32 = 26;
pub const IP_RECVTOS: u32 = 27;
pub const IP_FW_ADD: u32 = 40;
pub const IP_FW_DEL: u32 = 41;
pub const IP_FW_FLUSH: u32 = 42;
pub const IP_FW_ZERO: u32 = 43;
pub const IP_FW_GET: u32 = 44;
pub const IP_FW_RESETLOG: u32 = 45;
pub const IP_OLD_FW_ADD: u32 = 50;
pub const IP_OLD_FW_DEL: u32 = 51;
pub const IP_OLD_FW_FLUSH: u32 = 52;
pub const IP_OLD_FW_ZERO: u32 = 53;
pub const IP_OLD_FW_GET: u32 = 54;
pub const IP_NAT__XXX: u32 = 55;
pub const IP_OLD_FW_RESETLOG: u32 = 56;
pub const IP_DUMMYNET_CONFIGURE: u32 = 60;
pub const IP_DUMMYNET_DEL: u32 = 61;
pub const IP_DUMMYNET_FLUSH: u32 = 62;
pub const IP_DUMMYNET_GET: u32 = 64;
pub const IP_TRAFFIC_MGT_BACKGROUND: u32 = 65;
pub const IP_MULTICAST_IFINDEX: u32 = 66;
pub const IP_ADD_SOURCE_MEMBERSHIP: u32 = 70;
pub const IP_DROP_SOURCE_MEMBERSHIP: u32 = 71;
pub const IP_BLOCK_SOURCE: u32 = 72;
pub const IP_UNBLOCK_SOURCE: u32 = 73;
pub const IP_MSFILTER: u32 = 74;
pub const MCAST_JOIN_GROUP: u32 = 80;
pub const MCAST_LEAVE_GROUP: u32 = 81;
pub const MCAST_JOIN_SOURCE_GROUP: u32 = 82;
pub const MCAST_LEAVE_SOURCE_GROUP: u32 = 83;
pub const MCAST_BLOCK_SOURCE: u32 = 84;
pub const MCAST_UNBLOCK_SOURCE: u32 = 85;
pub const IP_DEFAULT_MULTICAST_TTL: u32 = 1;
pub const IP_DEFAULT_MULTICAST_LOOP: u32 = 1;
pub const IP_MIN_MEMBERSHIPS: u32 = 31;
pub const IP_MAX_MEMBERSHIPS: u32 = 4095;
pub const IP_MAX_GROUP_SRC_FILTER: u32 = 512;
pub const IP_MAX_SOCK_SRC_FILTER: u32 = 128;
pub const IP_MAX_SOCK_MUTE_FILTER: u32 = 128;
pub const MCAST_UNDEFINED: u32 = 0;
pub const MCAST_INCLUDE: u32 = 1;
pub const MCAST_EXCLUDE: u32 = 2;
pub const IP_PORTRANGE_DEFAULT: u32 = 0;
pub const IP_PORTRANGE_HIGH: u32 = 1;
pub const IP_PORTRANGE_LOW: u32 = 2;
pub const IPPROTO_MAXID: u32 = 52;
pub const IPCTL_FORWARDING: u32 = 1;
pub const IPCTL_SENDREDIRECTS: u32 = 2;
pub const IPCTL_DEFTTL: u32 = 3;
pub const IPCTL_RTEXPIRE: u32 = 5;
pub const IPCTL_RTMINEXPIRE: u32 = 6;
pub const IPCTL_RTMAXCACHE: u32 = 7;
pub const IPCTL_SOURCEROUTE: u32 = 8;
pub const IPCTL_DIRECTEDBROADCAST: u32 = 9;
pub const IPCTL_INTRQMAXLEN: u32 = 10;
pub const IPCTL_INTRQDROPS: u32 = 11;
pub const IPCTL_STATS: u32 = 12;
pub const IPCTL_ACCEPTSOURCEROUTE: u32 = 13;
pub const IPCTL_FASTFORWARDING: u32 = 14;
pub const IPCTL_KEEPFAITH: u32 = 15;
pub const IPCTL_GIF_TTL: u32 = 16;
pub const IPCTL_MAXID: u32 = 17;
pub const __KAME_VERSION: &'static [u8; 18usize] = b"2009/apple-darwin\0";
pub const IPV6PORT_RESERVED: u32 = 1024;
pub const IPV6PORT_ANONMIN: u32 = 49152;
pub const IPV6PORT_ANONMAX: u32 = 65535;
pub const IPV6PORT_RESERVEDMIN: u32 = 600;
pub const IPV6PORT_RESERVEDMAX: u32 = 1023;
pub const INET6_ADDRSTRLEN: u32 = 46;
pub const __IPV6_ADDR_SCOPE_NODELOCAL: u32 = 1;
pub const __IPV6_ADDR_SCOPE_INTFACELOCAL: u32 = 1;
pub const __IPV6_ADDR_SCOPE_LINKLOCAL: u32 = 2;
pub const __IPV6_ADDR_SCOPE_SITELOCAL: u32 = 5;
pub const __IPV6_ADDR_SCOPE_ORGLOCAL: u32 = 8;
pub const __IPV6_ADDR_SCOPE_GLOBAL: u32 = 14;
pub const IPV6_SOCKOPT_RESERVED1: u32 = 3;
pub const IPV6_UNICAST_HOPS: u32 = 4;
pub const IPV6_MULTICAST_IF: u32 = 9;
pub const IPV6_MULTICAST_HOPS: u32 = 10;
pub const IPV6_MULTICAST_LOOP: u32 = 11;
pub const IPV6_JOIN_GROUP: u32 = 12;
pub const IPV6_LEAVE_GROUP: u32 = 13;
pub const IPV6_PORTRANGE: u32 = 14;
pub const ICMP6_FILTER: u32 = 18;
pub const IPV6_2292PKTINFO: u32 = 19;
pub const IPV6_2292HOPLIMIT: u32 = 20;
pub const IPV6_2292NEXTHOP: u32 = 21;
pub const IPV6_2292HOPOPTS: u32 = 22;
pub const IPV6_2292DSTOPTS: u32 = 23;
pub const IPV6_2292RTHDR: u32 = 24;
pub const IPV6_2292PKTOPTIONS: u32 = 25;
pub const IPV6_CHECKSUM: u32 = 26;
pub const IPV6_V6ONLY: u32 = 27;
pub const IPV6_BINDV6ONLY: u32 = 27;
pub const IPV6_IPSEC_POLICY: u32 = 28;
pub const IPV6_FAITH: u32 = 29;
pub const IPV6_FW_ADD: u32 = 30;
pub const IPV6_FW_DEL: u32 = 31;
pub const IPV6_FW_FLUSH: u32 = 32;
pub const IPV6_FW_ZERO: u32 = 33;
pub const IPV6_FW_GET: u32 = 34;
pub const IPV6_RECVTCLASS: u32 = 35;
pub const IPV6_TCLASS: u32 = 36;
pub const IPV6_BOUND_IF: u32 = 125;
pub const IPV6_RTHDR_LOOSE: u32 = 0;
pub const IPV6_RTHDR_STRICT: u32 = 1;
pub const IPV6_RTHDR_TYPE_0: u32 = 0;
pub const IPV6_DEFAULT_MULTICAST_HOPS: u32 = 1;
pub const IPV6_DEFAULT_MULTICAST_LOOP: u32 = 1;
pub const IPV6_MIN_MEMBERSHIPS: u32 = 31;
pub const IPV6_MAX_MEMBERSHIPS: u32 = 4095;
pub const IPV6_MAX_GROUP_SRC_FILTER: u32 = 512;
pub const IPV6_MAX_SOCK_SRC_FILTER: u32 = 128;
pub const IPV6_PORTRANGE_DEFAULT: u32 = 0;
pub const IPV6_PORTRANGE_HIGH: u32 = 1;
pub const IPV6_PORTRANGE_LOW: u32 = 2;
pub const IPV6PROTO_MAXID: u32 = 104;
pub const IPV6CTL_FORWARDING: u32 = 1;
pub const IPV6CTL_SENDREDIRECTS: u32 = 2;
pub const IPV6CTL_DEFHLIM: u32 = 3;
pub const IPV6CTL_FORWSRCRT: u32 = 5;
pub const IPV6CTL_STATS: u32 = 6;
pub const IPV6CTL_MRTSTATS: u32 = 7;
pub const IPV6CTL_MRTPROTO: u32 = 8;
pub const IPV6CTL_MAXFRAGPACKETS: u32 = 9;
pub const IPV6CTL_SOURCECHECK: u32 = 10;
pub const IPV6CTL_SOURCECHECK_LOGINT: u32 = 11;
pub const IPV6CTL_ACCEPT_RTADV: u32 = 12;
pub const IPV6CTL_KEEPFAITH: u32 = 13;
pub const IPV6CTL_LOG_INTERVAL: u32 = 14;
pub const IPV6CTL_HDRNESTLIMIT: u32 = 15;
pub const IPV6CTL_DAD_COUNT: u32 = 16;
pub const IPV6CTL_AUTO_FLOWLABEL: u32 = 17;
pub const IPV6CTL_DEFMCASTHLIM: u32 = 18;
pub const IPV6CTL_GIF_HLIM: u32 = 19;
pub const IPV6CTL_KAME_VERSION: u32 = 20;
pub const IPV6CTL_USE_DEPRECATED: u32 = 21;
pub const IPV6CTL_RR_PRUNE: u32 = 22;
pub const IPV6CTL_V6ONLY: u32 = 24;
pub const IPV6CTL_RTEXPIRE: u32 = 25;
pub const IPV6CTL_RTMINEXPIRE: u32 = 26;
pub const IPV6CTL_RTMAXCACHE: u32 = 27;
pub const IPV6CTL_USETEMPADDR: u32 = 32;
pub const IPV6CTL_TEMPPLTIME: u32 = 33;
pub const IPV6CTL_TEMPVLTIME: u32 = 34;
pub const IPV6CTL_AUTO_LINKLOCAL: u32 = 35;
pub const IPV6CTL_RIP6STATS: u32 = 36;
pub const IPV6CTL_PREFER_TEMPADDR: u32 = 37;
pub const IPV6CTL_ADDRCTLPOLICY: u32 = 38;
pub const IPV6CTL_USE_DEFAULTZONE: u32 = 39;
pub const IPV6CTL_MAXFRAGS: u32 = 41;
pub const IPV6CTL_MCAST_PMTU: u32 = 44;
pub const IPV6CTL_NEIGHBORGCTHRESH: u32 = 46;
pub const IPV6CTL_MAXIFPREFIXES: u32 = 47;
pub const IPV6CTL_MAXIFDEFROUTERS: u32 = 48;
pub const IPV6CTL_MAXDYNROUTES: u32 = 49;
pub const ICMPV6CTL_ND6_ONLINKNSRFC4861: u32 = 50;
pub const IPV6CTL_MAXID: u32 = 51;
pub const SOL_LOCAL: u32 = 0;
pub const LOCAL_PEERCRED: u32 = 1;
pub const LOCAL_PEERPID: u32 = 2;
pub const LOCAL_PEEREPID: u32 = 3;
pub const LOCAL_PEERUUID: u32 = 4;
pub const LOCAL_PEEREUUID: u32 = 5;
pub const POLLIN: u32 = 1;
pub const POLLPRI: u32 = 2;
pub const POLLOUT: u32 = 4;
pub const POLLRDNORM: u32 = 64;
pub const POLLWRNORM: u32 = 4;
pub const POLLRDBAND: u32 = 128;
pub const POLLWRBAND: u32 = 256;
pub const POLLEXTEND: u32 = 512;
pub const POLLATTRIB: u32 = 1024;
pub const POLLNLINK: u32 = 2048;
pub const POLLWRITE: u32 = 4096;
pub const POLLERR: u32 = 8;
pub const POLLHUP: u32 = 16;
pub const POLLNVAL: u32 = 32;
pub const POLLSTANDARD: u32 = 511;
pub const _PATH_HEQUIV: &'static [u8; 17usize] = b"/etc/hosts.equiv\0";
pub const _PATH_HOSTS: &'static [u8; 11usize] = b"/etc/hosts\0";
pub const _PATH_NETWORKS: &'static [u8; 14usize] = b"/etc/networks\0";
pub const _PATH_PROTOCOLS: &'static [u8; 15usize] = b"/etc/protocols\0";
pub const _PATH_SERVICES: &'static [u8; 14usize] = b"/etc/services\0";
pub const NETDB_INTERNAL: i32 = -1;
pub const NETDB_SUCCESS: u32 = 0;
pub const HOST_NOT_FOUND: u32 = 1;
pub const TRY_AGAIN: u32 = 2;
pub const NO_RECOVERY: u32 = 3;
pub const NO_DATA: u32 = 4;
pub const NO_ADDRESS: u32 = 4;
pub const EAI_ADDRFAMILY: u32 = 1;
pub const EAI_AGAIN: u32 = 2;
pub const EAI_BADFLAGS: u32 = 3;
pub const EAI_FAIL: u32 = 4;
pub const EAI_FAMILY: u32 = 5;
pub const EAI_MEMORY: u32 = 6;
pub const EAI_NODATA: u32 = 7;
pub const EAI_NONAME: u32 = 8;
pub const EAI_SERVICE: u32 = 9;
pub const EAI_SOCKTYPE: u32 = 10;
pub const EAI_SYSTEM: u32 = 11;
pub const EAI_BADHINTS: u32 = 12;
pub const EAI_PROTOCOL: u32 = 13;
pub const EAI_OVERFLOW: u32 = 14;
pub const EAI_MAX: u32 = 15;
pub const AI_PASSIVE: u32 = 1;
pub const AI_CANONNAME: u32 = 2;
pub const AI_NUMERICHOST: u32 = 4;
pub const AI_NUMERICSERV: u32 = 4096;
pub const AI_ALL: u32 = 256;
pub const AI_V4MAPPED_CFG: u32 = 512;
pub const AI_ADDRCONFIG: u32 = 1024;
pub const AI_V4MAPPED: u32 = 2048;
pub const AI_DEFAULT: u32 = 1536;
pub const AI_UNUSABLE: u32 = 268435456;
pub const NI_MAXHOST: u32 = 1025;
pub const NI_MAXSERV: u32 = 32;
pub const NI_NOFQDN: u32 = 1;
pub const NI_NUMERICHOST: u32 = 2;
pub const NI_NAMEREQD: u32 = 4;
pub const NI_NUMERICSERV: u32 = 8;
pub const NI_NUMERICSCOPE: u32 = 256;
pub const NI_DGRAM: u32 = 16;
pub const NI_WITHSCOPEID: u32 = 32;
pub const SCOPE_DELIMITER: u8 = 37u8;
pub const TH_FIN: u32 = 1;
pub const TH_SYN: u32 = 2;
pub const TH_RST: u32 = 4;
pub const TH_PUSH: u32 = 8;
pub const TH_ACK: u32 = 16;
pub const TH_URG: u32 = 32;
pub const TH_ECE: u32 = 64;
pub const TH_CWR: u32 = 128;
pub const TH_FLAGS: u32 = 247;
pub const TH_ACCEPT: u32 = 23;
pub const TCPOPT_EOL: u32 = 0;
pub const TCPOPT_NOP: u32 = 1;
pub const TCPOPT_MAXSEG: u32 = 2;
pub const TCPOLEN_MAXSEG: u32 = 4;
pub const TCPOPT_WINDOW: u32 = 3;
pub const TCPOLEN_WINDOW: u32 = 3;
pub const TCPOPT_SACK_PERMITTED: u32 = 4;
pub const TCPOLEN_SACK_PERMITTED: u32 = 2;
pub const TCPOPT_SACK: u32 = 5;
pub const TCPOLEN_SACK: u32 = 8;
pub const TCPOPT_TIMESTAMP: u32 = 8;
pub const TCPOLEN_TIMESTAMP: u32 = 10;
pub const TCPOLEN_TSTAMP_APPA: u32 = 12;
pub const TCPOPT_TSTAMP_HDR: u32 = 16844810;
pub const MAX_TCPOPTLEN: u32 = 40;
pub const TCPOPT_CC: u32 = 11;
pub const TCPOPT_CCNEW: u32 = 12;
pub const TCPOPT_CCECHO: u32 = 13;
pub const TCPOLEN_CC: u32 = 6;
pub const TCPOLEN_CC_APPA: u32 = 8;
pub const TCPOPT_SIGNATURE: u32 = 19;
pub const TCPOLEN_SIGNATURE: u32 = 18;
pub const TCPOPT_FASTOPEN: u32 = 34;
pub const TCPOLEN_FASTOPEN_REQ: u32 = 2;
pub const TCPOPT_SACK_HDR: u32 = 16844032;
pub const MAX_SACK_BLKS: u32 = 6;
pub const TCP_MAX_SACK: u32 = 4;
pub const TCP_MSS: u32 = 512;
pub const TCP_MINMSS: u32 = 216;
pub const TCP6_MSS: u32 = 1024;
pub const TCP_MAXWIN: u32 = 65535;
pub const TTCP_CLIENT_SND_WND: u32 = 4096;
pub const TCP_MAX_WINSHIFT: u32 = 14;
pub const TCP_MAXHLEN: u32 = 60;
pub const TCP_NODELAY: u32 = 1;
pub const TCP_MAXSEG: u32 = 2;
pub const TCP_NOPUSH: u32 = 4;
pub const TCP_NOOPT: u32 = 8;
pub const TCP_KEEPALIVE: u32 = 16;
pub const TCP_CONNECTIONTIMEOUT: u32 = 32;
pub const PERSIST_TIMEOUT: u32 = 64;
pub const TCP_RXT_CONNDROPTIME: u32 = 128;
pub const TCP_RXT_FINDROP: u32 = 256;
pub const TCP_KEEPINTVL: u32 = 257;
pub const TCP_KEEPCNT: u32 = 258;
pub const TCP_SENDMOREACKS: u32 = 259;
pub const TCP_ENABLE_ECN: u32 = 260;
pub const TCP_FASTOPEN: u32 = 261;
pub const TCP_CONNECTION_INFO: u32 = 262;
pub const TCP_NOTSENT_LOWAT: u32 = 513;
pub const TCPCI_OPT_TIMESTAMPS: u32 = 1;
pub const TCPCI_OPT_SACK: u32 = 2;
pub const TCPCI_OPT_WSCALE: u32 = 4;
pub const TCPCI_OPT_ECN: u32 = 8;
pub const TCPCI_FLAG_LOSSRECOVERY: u32 = 1;
pub const TCPCI_FLAG_REORDERING_DETECTED: u32 = 2;
pub const SD_RECEIVE: u32 = 0;
pub const SD_SEND: u32 = 1;
pub const SD_BOTH: u32 = 2;
pub const R_INVALID_SOCKET: i32 = -1;
pub const R_SOCKET_PROTO_TCP: u32 = 6;
pub const R_SOCKET_PROTO_UDP: u32 = 17;
pub const R_SOCKET_PROTO_UNIX: u32 = 4919;
pub const R_SOCKET_PROTO_NONE: u32 = 0;
pub const R_SOCKET_PROTO_DEFAULT: u32 = 6;
pub const R_RUN_PROFILE_NARGS: u32 = 512;
pub const PATHSEP: u8 = 58u8;
pub const HOWMANY: u32 = 262144;
pub const MAXDESC: u32 = 64;
pub const MAXMAGIS: u32 = 8192;
pub const MAXstring: u32 = 32;
pub const MAGICNO: u32 = 4045276188;
pub const VERSIONNO: u32 = 5;
pub const FILE_MAGICSIZE: u32 = 192;
pub const FILE_LOAD: u32 = 0;
pub const FILE_CHECK: u32 = 1;
pub const FILE_COMPILE: u32 = 2;
pub const INDIR: u32 = 1;
pub const OFFADD: u32 = 2;
pub const INDIROFFADD: u32 = 4;
pub const UNSIGNED: u32 = 8;
pub const NOSPACE: u32 = 16;
pub const BINTEST: u32 = 32;
pub const TEXTTEST: u32 = 0;
pub const FILE_INVALID: u32 = 0;
pub const FILE_BYTE: u32 = 1;
pub const FILE_SHORT: u32 = 2;
pub const FILE_DEFAULT: u32 = 3;
pub const FILE_LONG: u32 = 4;
pub const FILE_STRING: u32 = 5;
pub const FILE_DATE: u32 = 6;
pub const FILE_BESHORT: u32 = 7;
pub const FILE_BELONG: u32 = 8;
pub const FILE_BEDATE: u32 = 9;
pub const FILE_LESHORT: u32 = 10;
pub const FILE_LELONG: u32 = 11;
pub const FILE_LEDATE: u32 = 12;
pub const FILE_PSTRING: u32 = 13;
pub const FILE_LDATE: u32 = 14;
pub const FILE_BELDATE: u32 = 15;
pub const FILE_LELDATE: u32 = 16;
pub const FILE_REGEX: u32 = 17;
pub const FILE_BESTRING16: u32 = 18;
pub const FILE_LESTRING16: u32 = 19;
pub const FILE_SEARCH: u32 = 20;
pub const FILE_MEDATE: u32 = 21;
pub const FILE_MELDATE: u32 = 22;
pub const FILE_MELONG: u32 = 23;
pub const FILE_QUAD: u32 = 24;
pub const FILE_LEQUAD: u32 = 25;
pub const FILE_BEQUAD: u32 = 26;
pub const FILE_QDATE: u32 = 27;
pub const FILE_LEQDATE: u32 = 28;
pub const FILE_BEQDATE: u32 = 29;
pub const FILE_QLDATE: u32 = 30;
pub const FILE_LEQLDATE: u32 = 31;
pub const FILE_BEQLDATE: u32 = 32;
pub const FILE_FLOAT: u32 = 33;
pub const FILE_BEFLOAT: u32 = 34;
pub const FILE_LEFLOAT: u32 = 35;
pub const FILE_DOUBLE: u32 = 36;
pub const FILE_BEDOUBLE: u32 = 37;
pub const FILE_LEDOUBLE: u32 = 38;
pub const FILE_NAMES_SIZE: u32 = 39;
pub const FILE_FMT_NONE: u32 = 0;
pub const FILE_FMT_NUM: u32 = 1;
pub const FILE_FMT_STR: u32 = 2;
pub const FILE_FMT_QUAD: u32 = 3;
pub const FILE_FMT_FLOAT: u32 = 4;
pub const FILE_FMT_DOUBLE: u32 = 5;
pub const FILE_OPS: &'static [u8; 9usize] = b"&|^+-*/%\0";
pub const FILE_OPAND: u32 = 0;
pub const FILE_OPOR: u32 = 1;
pub const FILE_OPXOR: u32 = 2;
pub const FILE_OPADD: u32 = 3;
pub const FILE_OPMINUS: u32 = 4;
pub const FILE_OPMULTIPLY: u32 = 5;
pub const FILE_OPDIVIDE: u32 = 6;
pub const FILE_OPMODULO: u32 = 7;
pub const FILE_OPS_MASK: u32 = 7;
pub const FILE_UNUSED_1: u32 = 8;
pub const FILE_UNUSED_2: u32 = 16;
pub const FILE_UNUSED_3: u32 = 32;
pub const FILE_OPINVERSE: u32 = 64;
pub const FILE_OPINDIRECT: u32 = 128;
pub const COND_NONE: u32 = 0;
pub const COND_IF: u32 = 1;
pub const COND_ELIF: u32 = 2;
pub const COND_ELSE: u32 = 3;
pub const CHAR_COMPACT_BLANK: u8 = 66u8;
pub const CHAR_COMPACT_OPTIONAL_BLANK: u8 = 98u8;
pub const CHAR_IGNORE_LOWERCASE: u8 = 99u8;
pub const CHAR_IGNORE_UPPERCASE: u8 = 67u8;
pub const CHAR_REGEX_OFFSET_START: u8 = 115u8;
pub const STRING_DEFAULT_RANGE: u32 = 100;
pub const R_MAGIC_NONE: u32 = 0;
pub const R_MAGIC_DEBUG: u32 = 1;
pub const R_MAGIC_SYMLINK: u32 = 2;
pub const R_MAGIC_COMPRESS: u32 = 4;
pub const R_MAGIC_DEVICES: u32 = 8;
pub const R_MAGIC_MIME_TYPE: u32 = 16;
pub const R_MAGIC_CONTINUE: u32 = 32;
pub const R_MAGIC_CHECK: u32 = 64;
pub const R_MAGIC_PRESERVE_ATIME: u32 = 128;
pub const R_MAGIC_RAW: u32 = 256;
pub const R_MAGIC_ERROR: u32 = 512;
pub const R_MAGIC_MIME_ENCODING: u32 = 1024;
pub const R_MAGIC_MIME: u32 = 1040;
pub const R_MAGIC_NO_CHECK_COMPRESS: u32 = 4096;
pub const R_MAGIC_NO_CHECK_TAR: u32 = 8192;
pub const R_MAGIC_NO_CHECK_SOFT: u32 = 16384;
pub const R_MAGIC_NO_CHECK_APPTYPE: u32 = 32768;
pub const R_MAGIC_NO_CHECK_ELF: u32 = 65536;
pub const R_MAGIC_NO_CHECK_ASCII: u32 = 131072;
pub const R_MAGIC_NO_CHECK_TOKENS: u32 = 1048576;
pub const MAGIC_NO_CHECK_FORTRAN: u32 = 0;
pub const MAGIC_NO_CHECK_TROFF: u32 = 0;
pub const R_AGRAPH_MODE_NORMAL: u32 = 0;
pub const R_AGRAPH_MODE_OFFSET: u32 = 1;
pub const R_AGRAPH_MODE_MINI: u32 = 2;
pub const R_AGRAPH_MODE_TINY: u32 = 3;
pub const R_AGRAPH_MODE_SUMMARY: u32 = 4;
pub const R_AGRAPH_MODE_COMMENTS: u32 = 5;
pub const R_AGRAPH_MODE_MAX: u32 = 6;
pub const R_IO_SEEK_SET: u32 = 0;
pub const R_IO_SEEK_CUR: u32 = 1;
pub const R_IO_SEEK_END: u32 = 2;
pub const R_IO_UNDOS: u32 = 64;
pub const PT_TRACE_ME: u32 = 0;
pub const PT_READ_I: u32 = 1;
pub const PT_READ_D: u32 = 2;
pub const PT_READ_U: u32 = 3;
pub const PT_WRITE_I: u32 = 4;
pub const PT_WRITE_D: u32 = 5;
pub const PT_WRITE_U: u32 = 6;
pub const PT_CONTINUE: u32 = 7;
pub const PT_KILL: u32 = 8;
pub const PT_STEP: u32 = 9;
pub const PT_DETACH: u32 = 11;
pub const PT_SIGEXC: u32 = 12;
pub const PT_THUPDATE: u32 = 13;
pub const PT_ATTACHEXC: u32 = 14;
pub const PT_FORCEQUOTA: u32 = 30;
pub const PT_DENY_ATTACH: u32 = 31;
pub const PT_FIRSTMACH: u32 = 32;
pub const R_FS_FILE_TYPE_MOUNTPOINT: u8 = 109u8;
pub const R_FS_FILE_TYPE_DIRECTORY: u8 = 100u8;
pub const R_FS_FILE_TYPE_REGULAR: u8 = 114u8;
pub const R_FS_FILE_TYPE_DELETED: u8 = 120u8;
pub const R_FS_FILE_TYPE_SPECIAL: u8 = 115u8;
pub const R_FS_FILE_TYPE_MOUNT: u8 = 109u8;
pub const RTLD_LAZY: u32 = 1;
pub const RTLD_NOW: u32 = 2;
pub const RTLD_LOCAL: u32 = 4;
pub const RTLD_GLOBAL: u32 = 8;
pub const RTLD_NOLOAD: u32 = 16;
pub const RTLD_NODELETE: u32 = 128;
pub const RTLD_FIRST: u32 = 256;
pub const R_LIB_SEPARATOR: &'static [u8; 2usize] = b".\0";
pub const R_LIB_SYMNAME: &'static [u8; 14usize] = b"radare_plugin\0";
pub const R_LIB_SYMFUNC: &'static [u8; 23usize] = b"radare_plugin_function\0";
pub const R_LIB_ENV: &'static [u8; 16usize] = b"R2_LIBR_PLUGINS\0";
pub const R_LIB_EXT: &'static [u8; 6usize] = b"dylib\0";
pub const DW_EXTENDED_OPCODE: u32 = 0;
pub const LOP_EXTENDED: u32 = 1;
pub const LOP_DISCARD: u32 = 2;
pub const LOP_STANDARD: u32 = 3;
pub const LOP_SPECIAL: u32 = 4;
pub const DW_LNS_copy: u32 = 1;
pub const DW_LNS_advance_pc: u32 = 2;
pub const DW_LNS_advance_line: u32 = 3;
pub const DW_LNS_set_file: u32 = 4;
pub const DW_LNS_set_column: u32 = 5;
pub const DW_LNS_negate_stmt: u32 = 6;
pub const DW_LNS_set_basic_block: u32 = 7;
pub const DW_LNS_const_add_pc: u32 = 8;
pub const DW_LNS_fixed_advance_pc: u32 = 9;
pub const DW_LNS_set_prologue_end: u32 = 10;
pub const DW_LNS_set_epilogue_begin: u32 = 11;
pub const DW_LNS_set_isa: u32 = 12;
pub const DW_LNE_end_sequence: u32 = 1;
pub const DW_LNE_set_address: u32 = 2;
pub const DW_LNE_define_file: u32 = 3;
pub const DW_LNE_set_discriminator: u32 = 4;
pub const DW_LNE_lo_user: u32 = 128;
pub const DW_LNE_hi_user: u32 = 255;
pub const DW_LNE_HP_negate_is_UV_update: u32 = 17;
pub const DW_LNE_HP_push_context: u32 = 18;
pub const DW_LNE_HP_pop_context: u32 = 19;
pub const DW_LNE_HP_set_file_line_column: u32 = 20;
pub const DW_LNE_HP_set_routine_name: u32 = 21;
pub const DW_LNE_HP_set_sequence: u32 = 22;
pub const DW_LNE_HP_negate_post_semantics: u32 = 23;
pub const DW_LNE_HP_negate_function_exit: u32 = 24;
pub const DW_LNE_HP_negate_front_end_logical: u32 = 25;
pub const DW_LNE_HP_define_proc: u32 = 32;
pub const DW_TAG_null_entry: u32 = 0;
pub const DW_TAG_array_type: u32 = 1;
pub const DW_TAG_class_type: u32 = 2;
pub const DW_TAG_entry_point: u32 = 3;
pub const DW_TAG_enumeration_type: u32 = 4;
pub const DW_TAG_formal_parameter: u32 = 5;
pub const DW_TAG_imported_declaration: u32 = 8;
pub const DW_TAG_label: u32 = 10;
pub const DW_TAG_lexical_block: u32 = 11;
pub const DW_TAG_member: u32 = 13;
pub const DW_TAG_pointer_type: u32 = 15;
pub const DW_TAG_reference_type: u32 = 16;
pub const DW_TAG_compile_unit: u32 = 17;
pub const DW_TAG_string_type: u32 = 18;
pub const DW_TAG_structure_type: u32 = 19;
pub const DW_TAG_subroutine_type: u32 = 21;
pub const DW_TAG_typedef: u32 = 22;
pub const DW_TAG_union_type: u32 = 23;
pub const DW_TAG_unspecified_parameters: u32 = 24;
pub const DW_TAG_variant: u32 = 25;
pub const DW_TAG_common_block: u32 = 26;
pub const DW_TAG_common_inclusion: u32 = 27;
pub const DW_TAG_inheritance: u32 = 28;
pub const DW_TAG_inlined_subroutine: u32 = 29;
pub const DW_TAG_module: u32 = 30;
pub const DW_TAG_ptr_to_member_type: u32 = 31;
pub const DW_TAG_set_type: u32 = 32;
pub const DW_TAG_subrange_type: u32 = 33;
pub const DW_TAG_with_stmt: u32 = 34;
pub const DW_TAG_access_declaration: u32 = 35;
pub const DW_TAG_base_type: u32 = 36;
pub const DW_TAG_catch_block: u32 = 37;
pub const DW_TAG_const_type: u32 = 38;
pub const DW_TAG_constant: u32 = 39;
pub const DW_TAG_enumerator: u32 = 40;
pub const DW_TAG_file_type: u32 = 41;
pub const DW_TAG_friend: u32 = 42;
pub const DW_TAG_namelist: u32 = 43;
pub const DW_TAG_namelist_item: u32 = 44;
pub const DW_TAG_namelist_items: u32 = 44;
pub const DW_TAG_packed_type: u32 = 45;
pub const DW_TAG_subprogram: u32 = 46;
pub const DW_TAG_template_type_parameter: u32 = 47;
pub const DW_TAG_template_type_param: u32 = 47;
pub const DW_TAG_template_value_parameter: u32 = 48;
pub const DW_TAG_template_value_param: u32 = 48;
pub const DW_TAG_thrown_type: u32 = 49;
pub const DW_TAG_try_block: u32 = 50;
pub const DW_TAG_variant_part: u32 = 51;
pub const DW_TAG_variable: u32 = 52;
pub const DW_TAG_volatile_type: u32 = 53;
pub const DW_TAG_dwarf_procedure: u32 = 54;
pub const DW_TAG_restrict_type: u32 = 55;
pub const DW_TAG_interface_type: u32 = 56;
pub const DW_TAG_namespace: u32 = 57;
pub const DW_TAG_imported_module: u32 = 58;
pub const DW_TAG_unspecified_type: u32 = 59;
pub const DW_TAG_partial_unit: u32 = 60;
pub const DW_TAG_imported_unit: u32 = 61;
pub const DW_TAG_mutable_type: u32 = 62;
pub const DW_TAG_condition: u32 = 63;
pub const DW_TAG_shared_type: u32 = 64;
pub const DW_TAG_type_unit: u32 = 65;
pub const DW_TAG_rvalue_reference_type: u32 = 66;
pub const DW_TAG_template_alias: u32 = 67;
pub const DW_TAG_LAST: u32 = 68;
pub const DW_TAG_lo_user: u32 = 16512;
pub const DW_TAG_hi_user: u32 = 65535;
pub const DW_CHILDREN_no: u32 = 0;
pub const DW_CHILDREN_yes: u32 = 1;
pub const DW_AT_sibling: u32 = 1;
pub const DW_AT_location: u32 = 2;
pub const DW_AT_name: u32 = 3;
pub const DW_AT_ordering: u32 = 9;
pub const DW_AT_byte_size: u32 = 11;
pub const DW_AT_bit_offset: u32 = 12;
pub const DW_AT_bit_size: u32 = 13;
pub const DW_AT_stmt_list: u32 = 16;
pub const DW_AT_low_pc: u32 = 17;
pub const DW_AT_high_pc: u32 = 18;
pub const DW_AT_language: u32 = 19;
pub const DW_AT_discr: u32 = 21;
pub const DW_AT_discr_value: u32 = 22;
pub const DW_AT_visibility: u32 = 23;
pub const DW_AT_import: u32 = 24;
pub const DW_AT_string_length: u32 = 25;
pub const DW_AT_common_reference: u32 = 26;
pub const DW_AT_comp_dir: u32 = 27;
pub const DW_AT_const_value: u32 = 28;
pub const DW_AT_containing_type: u32 = 29;
pub const DW_AT_default_value: u32 = 30;
pub const DW_AT_inline: u32 = 32;
pub const DW_AT_is_optional: u32 = 33;
pub const DW_AT_lower_bound: u32 = 34;
pub const DW_AT_producer: u32 = 37;
pub const DW_AT_prototyped: u32 = 39;
pub const DW_AT_return_addr: u32 = 42;
pub const DW_AT_start_scope: u32 = 44;
pub const DW_AT_stride_size: u32 = 46;
pub const DW_AT_upper_bound: u32 = 47;
pub const DW_AT_abstract_origin: u32 = 49;
pub const DW_AT_accessibility: u32 = 50;
pub const DW_AT_address_class: u32 = 51;
pub const DW_AT_artificial: u32 = 52;
pub const DW_AT_base_types: u32 = 53;
pub const DW_AT_calling_convention: u32 = 54;
pub const DW_AT_count: u32 = 55;
pub const DW_AT_data_member_location: u32 = 56;
pub const DW_AT_decl_column: u32 = 57;
pub const DW_AT_decl_file: u32 = 58;
pub const DW_AT_decl_line: u32 = 59;
pub const DW_AT_declaration: u32 = 60;
pub const DW_AT_discr_list: u32 = 61;
pub const DW_AT_encoding: u32 = 62;
pub const DW_AT_external: u32 = 63;
pub const DW_AT_frame_base: u32 = 64;
pub const DW_AT_friend: u32 = 65;
pub const DW_AT_identifier_case: u32 = 66;
pub const DW_AT_macro_info: u32 = 67;
pub const DW_AT_namelist_item: u32 = 68;
pub const DW_AT_priority: u32 = 69;
pub const DW_AT_segment: u32 = 70;
pub const DW_AT_specification: u32 = 71;
pub const DW_AT_static_link: u32 = 72;
pub const DW_AT_type: u32 = 73;
pub const DW_AT_use_location: u32 = 74;
pub const DW_AT_variable_parameter: u32 = 75;
pub const DW_AT_virtuality: u32 = 76;
pub const DW_AT_vtable_elem_location: u32 = 77;
pub const DW_AT_allocated: u32 = 78;
pub const DW_AT_associated: u32 = 79;
pub const DW_AT_data_location: u32 = 80;
pub const DW_AT_byte_stride: u32 = 81;
pub const DW_AT_entry_pc: u32 = 82;
pub const DW_AT_use_UTF8: u32 = 83;
pub const DW_AT_extension: u32 = 84;
pub const DW_AT_ranges: u32 = 85;
pub const DW_AT_trampoline: u32 = 86;
pub const DW_AT_call_column: u32 = 87;
pub const DW_AT_call_file: u32 = 88;
pub const DW_AT_call_line: u32 = 89;
pub const DW_AT_description: u32 = 90;
pub const DW_AT_binary_scale: u32 = 91;
pub const DW_AT_decimal_scale: u32 = 92;
pub const DW_AT_small: u32 = 93;
pub const DW_AT_decimal_sign: u32 = 94;
pub const DW_AT_digit_count: u32 = 95;
pub const DW_AT_picture_string: u32 = 96;
pub const DW_AT_mutable: u32 = 97;
pub const DW_AT_threads_scaled: u32 = 98;
pub const DW_AT_explicit: u32 = 99;
pub const DW_AT_object_pointer: u32 = 100;
pub const DW_AT_endianity: u32 = 101;
pub const DW_AT_elemental: u32 = 102;
pub const DW_AT_pure: u32 = 103;
pub const DW_AT_recursive: u32 = 104;
pub const DW_AT_signature: u32 = 105;
pub const DW_AT_main_subprogram: u32 = 106;
pub const DW_AT_data_bit_offset: u32 = 107;
pub const DW_AT_const_expr: u32 = 108;
pub const DW_AT_enum_class: u32 = 109;
pub const DW_AT_linkage_name: u32 = 110;
pub const DW_AT_string_length_bit_size: u32 = 111;
pub const DW_AT_string_length_byte_size: u32 = 112;
pub const DW_AT_rank: u32 = 113;
pub const DW_AT_str_offsets_base: u32 = 114;
pub const DW_AT_addr_base: u32 = 115;
pub const DW_AT_rnglists_base: u32 = 116;
pub const DW_AT_dwo_name: u32 = 118;
pub const DW_AT_reference: u32 = 119;
pub const DW_AT_rvalue_reference: u32 = 120;
pub const DW_AT_macros: u32 = 121;
pub const DW_AT_call_all_calls: u32 = 122;
pub const DW_AT_call_all_source_calls: u32 = 123;
pub const DW_AT_call_all_tail_calls: u32 = 124;
pub const DW_AT_call_return_pc: u32 = 125;
pub const DW_AT_call_value: u32 = 126;
pub const DW_AT_call_origin: u32 = 127;
pub const DW_AT_call_parameter: u32 = 128;
pub const DW_AT_call_pc: u32 = 129;
pub const DW_AT_call_tail_call: u32 = 130;
pub const DW_AT_call_target: u32 = 131;
pub const DW_AT_call_target_clobbered: u32 = 132;
pub const DW_AT_call_data_location: u32 = 133;
pub const DW_AT_call_data_value: u32 = 134;
pub const DW_AT_noreturn: u32 = 135;
pub const DW_AT_alignment: u32 = 136;
pub const DW_AT_export_symbols: u32 = 137;
pub const DW_AT_deleted: u32 = 138;
pub const DW_AT_defaulted: u32 = 139;
pub const DW_AT_loclists_base: u32 = 140;
pub const DW_AT_lo_user: u32 = 8192;
pub const DW_AT_MIPS_linkage_name: u32 = 8199;
pub const DW_AT_GNU_call_site_value: u32 = 8465;
pub const DW_AT_GNU_call_site_data_value: u32 = 8466;
pub const DW_AT_GNU_call_site_target: u32 = 8467;
pub const DW_AT_GNU_call_site_target_clobbered: u32 = 8468;
pub const DW_AT_GNU_tail_call: u32 = 8469;
pub const DW_AT_GNU_all_tail_call_sites: u32 = 8470;
pub const DW_AT_GNU_all_call_sites: u32 = 8471;
pub const DW_AT_GNU_all_source_call_sites: u32 = 8472;
pub const DW_AT_GNU_macros: u32 = 8473;
pub const DW_AT_GNU_deleted: u32 = 8474;
pub const DW_AT_GNU_dwo_name: u32 = 8496;
pub const DW_AT_GNU_dwo_id: u32 = 8497;
pub const DW_AT_GNU_ranges_base: u32 = 8498;
pub const DW_AT_GNU_addr_base: u32 = 8499;
pub const DW_AT_GNU_pubnames: u32 = 8500;
pub const DW_AT_GNU_pubtypes: u32 = 8501;
pub const DW_AT_hi_user: u32 = 16383;
pub const DW_FORM_addr: u32 = 1;
pub const DW_FORM_block2: u32 = 3;
pub const DW_FORM_block4: u32 = 4;
pub const DW_FORM_data2: u32 = 5;
pub const DW_FORM_data4: u32 = 6;
pub const DW_FORM_data8: u32 = 7;
pub const DW_FORM_string: u32 = 8;
pub const DW_FORM_block: u32 = 9;
pub const DW_FORM_block1: u32 = 10;
pub const DW_FORM_data1: u32 = 11;
pub const DW_FORM_flag: u32 = 12;
pub const DW_FORM_sdata: u32 = 13;
pub const DW_FORM_strp: u32 = 14;
pub const DW_FORM_udata: u32 = 15;
pub const DW_FORM_ref_addr: u32 = 16;
pub const DW_FORM_ref1: u32 = 17;
pub const DW_FORM_ref2: u32 = 18;
pub const DW_FORM_ref4: u32 = 19;
pub const DW_FORM_ref8: u32 = 20;
pub const DW_FORM_ref_udata: u32 = 21;
pub const DW_FORM_indirect: u32 = 22;
pub const DW_FORM_sec_offset: u32 = 23;
pub const DW_FORM_exprloc: u32 = 24;
pub const DW_FORM_flag_present: u32 = 25;
pub const DW_FORM_strx: u32 = 26;
pub const DW_FORM_addrx: u32 = 27;
pub const DW_FORM_ref_sup4: u32 = 28;
pub const DW_FORM_strp_sup: u32 = 29;
pub const DW_FORM_data16: u32 = 30;
pub const DW_FORM_line_ptr: u32 = 31;
pub const DW_FORM_ref_sig8: u32 = 32;
pub const DW_FORM_implicit_const: u32 = 33;
pub const DW_FORM_loclistx: u32 = 34;
pub const DW_FORM_rnglistx: u32 = 35;
pub const DW_FORM_ref_sup8: u32 = 36;
pub const DW_FORM_strx1: u32 = 37;
pub const DW_FORM_strx2: u32 = 38;
pub const DW_FORM_strx3: u32 = 39;
pub const DW_FORM_strx4: u32 = 40;
pub const DW_FORM_addrx1: u32 = 41;
pub const DW_FORM_addrx2: u32 = 42;
pub const DW_FORM_addrx3: u32 = 43;
pub const DW_FORM_addrx4: u32 = 44;
pub const DW_OP_addr: u32 = 3;
pub const DW_OP_deref: u32 = 6;
pub const DW_OP_const1u: u32 = 8;
pub const DW_OP_const1s: u32 = 9;
pub const DW_OP_const2u: u32 = 10;
pub const DW_OP_const2s: u32 = 11;
pub const DW_OP_const4u: u32 = 12;
pub const DW_OP_const4s: u32 = 13;
pub const DW_OP_const8u: u32 = 14;
pub const DW_OP_const8s: u32 = 15;
pub const DW_OP_constu: u32 = 16;
pub const DW_OP_consts: u32 = 17;
pub const DW_OP_dup: u32 = 18;
pub const DW_OP_drop: u32 = 19;
pub const DW_OP_over: u32 = 20;
pub const DW_OP_pick: u32 = 21;
pub const DW_OP_swap: u32 = 22;
pub const DW_OP_rot: u32 = 23;
pub const DW_OP_xderef: u32 = 24;
pub const DW_OP_abs: u32 = 25;
pub const DW_OP_and: u32 = 26;
pub const DW_OP_div: u32 = 27;
pub const DW_OP_minus: u32 = 28;
pub const DW_OP_mod: u32 = 29;
pub const DW_OP_mul: u32 = 30;
pub const DW_OP_neg: u32 = 31;
pub const DW_OP_not: u32 = 32;
pub const DW_OP_or: u32 = 33;
pub const DW_OP_plus: u32 = 34;
pub const DW_OP_plus_uconst: u32 = 35;
pub const DW_OP_shl: u32 = 36;
pub const DW_OP_shr: u32 = 37;
pub const DW_OP_shra: u32 = 38;
pub const DW_OP_xor: u32 = 39;
pub const DW_OP_skip: u32 = 47;
pub const DW_OP_bra: u32 = 40;
pub const DW_OP_eq: u32 = 41;
pub const DW_OP_ge: u32 = 42;
pub const DW_OP_gt: u32 = 43;
pub const DW_OP_le: u32 = 44;
pub const DW_OP_lt: u32 = 45;
pub const DW_OP_ne: u32 = 46;
pub const DW_OP_lit0: u32 = 48;
pub const DW_OP_lit1: u32 = 49;
pub const DW_OP_lit2: u32 = 50;
pub const DW_OP_lit3: u32 = 51;
pub const DW_OP_lit4: u32 = 52;
pub const DW_OP_lit5: u32 = 53;
pub const DW_OP_lit6: u32 = 54;
pub const DW_OP_lit7: u32 = 55;
pub const DW_OP_lit8: u32 = 56;
pub const DW_OP_lit9: u32 = 57;
pub const DW_OP_lit10: u32 = 58;
pub const DW_OP_lit11: u32 = 59;
pub const DW_OP_lit12: u32 = 60;
pub const DW_OP_lit13: u32 = 61;
pub const DW_OP_lit14: u32 = 62;
pub const DW_OP_lit15: u32 = 63;
pub const DW_OP_lit16: u32 = 64;
pub const DW_OP_lit17: u32 = 65;
pub const DW_OP_lit18: u32 = 66;
pub const DW_OP_lit19: u32 = 67;
pub const DW_OP_lit20: u32 = 68;
pub const DW_OP_lit21: u32 = 69;
pub const DW_OP_lit22: u32 = 70;
pub const DW_OP_lit23: u32 = 71;
pub const DW_OP_lit24: u32 = 72;
pub const DW_OP_lit25: u32 = 73;
pub const DW_OP_lit26: u32 = 74;
pub const DW_OP_lit27: u32 = 75;
pub const DW_OP_lit28: u32 = 76;
pub const DW_OP_lit29: u32 = 77;
pub const DW_OP_lit30: u32 = 78;
pub const DW_OP_lit31: u32 = 79;
pub const DW_OP_reg0: u32 = 80;
pub const DW_OP_reg1: u32 = 81;
pub const DW_OP_reg2: u32 = 82;
pub const DW_OP_reg3: u32 = 83;
pub const DW_OP_reg4: u32 = 84;
pub const DW_OP_reg5: u32 = 85;
pub const DW_OP_reg6: u32 = 86;
pub const DW_OP_reg7: u32 = 87;
pub const DW_OP_reg8: u32 = 88;
pub const DW_OP_reg9: u32 = 89;
pub const DW_OP_reg10: u32 = 90;
pub const DW_OP_reg11: u32 = 91;
pub const DW_OP_reg12: u32 = 92;
pub const DW_OP_reg13: u32 = 93;
pub const DW_OP_reg14: u32 = 94;
pub const DW_OP_reg15: u32 = 95;
pub const DW_OP_reg16: u32 = 96;
pub const DW_OP_reg17: u32 = 97;
pub const DW_OP_reg18: u32 = 98;
pub const DW_OP_reg19: u32 = 99;
pub const DW_OP_reg20: u32 = 100;
pub const DW_OP_reg21: u32 = 101;
pub const DW_OP_reg22: u32 = 102;
pub const DW_OP_reg23: u32 = 103;
pub const DW_OP_reg24: u32 = 104;
pub const DW_OP_reg25: u32 = 105;
pub const DW_OP_reg26: u32 = 106;
pub const DW_OP_reg27: u32 = 107;
pub const DW_OP_reg28: u32 = 108;
pub const DW_OP_reg29: u32 = 109;
pub const DW_OP_reg30: u32 = 110;
pub const DW_OP_reg31: u32 = 111;
pub const DW_OP_breg0: u32 = 112;
pub const DW_OP_breg1: u32 = 113;
pub const DW_OP_breg2: u32 = 114;
pub const DW_OP_breg3: u32 = 115;
pub const DW_OP_breg4: u32 = 116;
pub const DW_OP_breg5: u32 = 117;
pub const DW_OP_breg6: u32 = 118;
pub const DW_OP_breg7: u32 = 119;
pub const DW_OP_breg8: u32 = 120;
pub const DW_OP_breg9: u32 = 121;
pub const DW_OP_breg10: u32 = 122;
pub const DW_OP_breg11: u32 = 123;
pub const DW_OP_breg12: u32 = 124;
pub const DW_OP_breg13: u32 = 125;
pub const DW_OP_breg14: u32 = 126;
pub const DW_OP_breg15: u32 = 127;
pub const DW_OP_breg16: u32 = 128;
pub const DW_OP_breg17: u32 = 129;
pub const DW_OP_breg18: u32 = 130;
pub const DW_OP_breg19: u32 = 131;
pub const DW_OP_breg20: u32 = 132;
pub const DW_OP_breg21: u32 = 133;
pub const DW_OP_breg22: u32 = 134;
pub const DW_OP_breg23: u32 = 135;
pub const DW_OP_breg24: u32 = 136;
pub const DW_OP_breg25: u32 = 137;
pub const DW_OP_breg26: u32 = 138;
pub const DW_OP_breg27: u32 = 139;
pub const DW_OP_breg28: u32 = 140;
pub const DW_OP_breg29: u32 = 141;
pub const DW_OP_breg30: u32 = 142;
pub const DW_OP_breg31: u32 = 143;
pub const DW_OP_regx: u32 = 144;
pub const DW_OP_fbreg: u32 = 145;
pub const DW_OP_bregx: u32 = 146;
pub const DW_OP_piece: u32 = 147;
pub const DW_OP_deref_size: u32 = 148;
pub const DW_OP_xderef_size: u32 = 149;
pub const DW_OP_nop: u32 = 150;
pub const DW_OP_push_object_address: u32 = 151;
pub const DW_OP_call2: u32 = 152;
pub const DW_OP_call4: u32 = 153;
pub const DW_OP_call_ref: u32 = 154;
pub const DW_OP_form_tls_address: u32 = 155;
pub const DW_OP_call_frame_cfa: u32 = 156;
pub const DW_OP_bit_piece: u32 = 157;
pub const DW_OP_implicit_value: u32 = 158;
pub const DW_OP_stack_value: u32 = 159;
pub const DW_OP_lo_user: u32 = 224;
pub const DW_OP_hi_user: u32 = 255;
pub const DW_ATE_address: u32 = 1;
pub const DW_ATE_boolean: u32 = 2;
pub const DW_ATE_complex_float: u32 = 3;
pub const DW_ATE_float: u32 = 4;
pub const DW_ATE_signed: u32 = 5;
pub const DW_ATE_signed_char: u32 = 6;
pub const DW_ATE_unsigned: u32 = 7;
pub const DW_ATE_unsigned_char: u32 = 8;
pub const DW_ATE_imaginary_float: u32 = 9;
pub const DW_ATE_packed_decimal: u32 = 10;
pub const DW_ATE_numeric_string: u32 = 11;
pub const DW_ATE_edited: u32 = 12;
pub const DW_ATE_signed_fixed: u32 = 13;
pub const DW_ATE_unsigned_fixed: u32 = 14;
pub const DW_ATE_decimal_float: u32 = 15;
pub const DW_ATE_UTF: u32 = 16;
pub const DW_ATE_lo_user: u32 = 128;
pub const DW_ATE_hi_user: u32 = 255;
pub const DW_DS_unsigned: u32 = 1;
pub const DW_DS_leading_overpunch: u32 = 2;
pub const DW_DS_trailing_overpunch: u32 = 3;
pub const DW_DS_leading_separate: u32 = 4;
pub const DW_DS_trailing_separate: u32 = 5;
pub const DW_END_default: u32 = 0;
pub const DW_END_big: u32 = 1;
pub const DW_END_little: u32 = 2;
pub const DW_END_lo_user: u32 = 64;
pub const DW_END_hi_user: u32 = 255;
pub const DW_ACCESS_public: u32 = 1;
pub const DW_ACCESS_protected: u32 = 2;
pub const DW_ACCESS_private: u32 = 3;
pub const DW_VIS_local: u32 = 1;
pub const DW_VIS_exported: u32 = 2;
pub const DW_VIS_qualified: u32 = 3;
pub const DW_VIRTUALITY_none: u32 = 0;
pub const DW_VIRTUALITY_virtual: u32 = 1;
pub const DW_VIRTUALITY_pure_virtual: u32 = 2;
pub const DW_LANG_C89: u32 = 1;
pub const DW_LANG_C: u32 = 2;
pub const DW_LANG_Ada83: u32 = 3;
pub const DW_LANG_C_plus_plus: u32 = 4;
pub const DW_LANG_Cobol74: u32 = 5;
pub const DW_LANG_Cobol85: u32 = 6;
pub const DW_LANG_Fortran77: u32 = 7;
pub const DW_LANG_Fortran90: u32 = 8;
pub const DW_LANG_Pascal83: u32 = 9;
pub const DW_LANG_Modula2: u32 = 10;
pub const DW_LANG_Java: u32 = 11;
pub const DW_LANG_C99: u32 = 12;
pub const DW_LANG_Ada95: u32 = 13;
pub const DW_LANG_Fortran95: u32 = 14;
pub const DW_LANG_PLI: u32 = 15;
pub const DW_LANG_ObjC: u32 = 16;
pub const DW_LANG_ObjC_plus_plus: u32 = 17;
pub const DW_LANG_UPC: u32 = 18;
pub const DW_LANG_D: u32 = 19;
pub const DW_LANG_Python: u32 = 20;
pub const DW_LANG_Rust: u32 = 28;
pub const DW_LANG_C11: u32 = 29;
pub const DW_LANG_Swift: u32 = 30;
pub const DW_LANG_Julia: u32 = 31;
pub const DW_LANG_Dylan: u32 = 32;
pub const DW_LANG_C_plus_plus_14: u32 = 33;
pub const DW_LANG_Fortran03: u32 = 34;
pub const DW_LANG_Fortran08: u32 = 35;
pub const DW_LANG_lo_user: u32 = 32768;
pub const DW_LANG_hi_user: u32 = 65535;
pub const DW_ID_case_sensitive: u32 = 0;
pub const DW_ID_up_case: u32 = 1;
pub const DW_ID_down_case: u32 = 2;
pub const DW_ID_case_insensitive: u32 = 3;
pub const DW_CC_normal: u32 = 1;
pub const DW_CC_program: u32 = 2;
pub const DW_CC_nocall: u32 = 3;
pub const DW_CC_lo_user: u32 = 64;
pub const DW_CC_hi_user: u32 = 255;
pub const DW_INL_not_inlined: u32 = 0;
pub const DW_INL_inlined: u32 = 1;
pub const DW_INL_declared_not_inlined: u32 = 2;
pub const DW_INL_declared_inlined: u32 = 3;
pub const DW_ORD_row_major: u32 = 0;
pub const DW_ORD_col_major: u32 = 1;
pub const DW_DSC_label: u32 = 0;
pub const DW_DSC_range: u32 = 1;
pub const DW_MACINFO_define: u32 = 1;
pub const DW_MACINFO_undef: u32 = 2;
pub const DW_MACINFO_start_file: u32 = 3;
pub const DW_MACINFO_end_file: u32 = 4;
pub const DW_MACINFO_vendor_ext: u32 = 255;
pub const DW_CFA_advance_loc: u32 = 64;
pub const DW_CFA_offset: u32 = 128;
pub const DW_CFA_restore: u32 = 192;
pub const DW_CFA_nop: u32 = 0;
pub const DW_CFA_set_loc: u32 = 1;
pub const DW_CFA_advance_loc1: u32 = 2;
pub const DW_CFA_advance_loc2: u32 = 3;
pub const DW_CFA_advance_loc4: u32 = 4;
pub const DW_CFA_offse_extended: u32 = 5;
pub const DW_CFA_restore_extended: u32 = 6;
pub const DW_CFA_undefined: u32 = 7;
pub const DW_CFA_same_value: u32 = 8;
pub const DW_CFA_register: u32 = 9;
pub const DW_CFA_remember_state: u32 = 10;
pub const DW_CFA_restore_state: u32 = 11;
pub const DW_CFA_def_cfa: u32 = 12;
pub const DW_CFA_def_cfa_register: u32 = 13;
pub const DW_CFA_def_cfa_offset: u32 = 14;
pub const DW_CFA_def_cfa_expression: u32 = 15;
pub const DW_CFA_expression: u32 = 16;
pub const DW_CFA_offset_extended_sf: u32 = 17;
pub const DW_CFA_def_cfa_sf: u32 = 18;
pub const DW_CFA_def_cfa_offset_sf: u32 = 19;
pub const DW_CFA_val_offset: u32 = 20;
pub const DW_CFA_val_offset_sf: u32 = 21;
pub const DW_CFA_val_expression: u32 = 22;
pub const DW_CFA_lo_user: u32 = 28;
pub const DW_CFA_hi_user: u32 = 63;
pub const DW_UT_compile: u32 = 1;
pub const DW_UT_type: u32 = 2;
pub const DW_UT_partial: u32 = 3;
pub const DW_UT_skeleton: u32 = 4;
pub const DW_UT_split_compile: u32 = 5;
pub const DW_UT_split_type: u32 = 6;
pub const DW_UT_lo_user: u32 = 128;
pub const DW_UT_hi_user: u32 = 255;
pub const DWARF_INIT_LEN_64: u32 = 4294967295;
pub const COMP_UNIT_CAPACITY: u32 = 8;
pub const DEBUG_INFO_CAPACITY: u32 = 8;
pub const ABBREV_DECL_CAP: u32 = 8;
pub const DEBUG_ABBREV_CAP: u32 = 32;
pub const DWARF_FALSE: u32 = 0;
pub const DWARF_TRUE: u32 = 1;
pub const FILE_NAME_LEN: u32 = 256;
pub const R_BIN_DBG_STRIPPED: u32 = 1;
pub const R_BIN_DBG_STATIC: u32 = 2;
pub const R_BIN_DBG_LINENUMS: u32 = 4;
pub const R_BIN_DBG_SYMS: u32 = 8;
pub const R_BIN_DBG_RELOCS: u32 = 16;
pub const R_BIN_ENTRY_TYPE_PROGRAM: u32 = 0;
pub const R_BIN_ENTRY_TYPE_MAIN: u32 = 1;
pub const R_BIN_ENTRY_TYPE_INIT: u32 = 2;
pub const R_BIN_ENTRY_TYPE_FINI: u32 = 3;
pub const R_BIN_ENTRY_TYPE_TLS: u32 = 4;
pub const R_BIN_ENTRY_TYPE_PREINIT: u32 = 5;
pub const R_BIN_SIZEOF_STRINGS: u32 = 512;
pub const R_BIN_MAX_ARCH: u32 = 1024;
pub const R_BIN_REQ_ALL: i32 = -1;
pub const R_BIN_REQ_UNK: u32 = 0;
pub const R_BIN_REQ_ENTRIES: u32 = 1;
pub const R_BIN_REQ_IMPORTS: u32 = 2;
pub const R_BIN_REQ_SYMBOLS: u32 = 4;
pub const R_BIN_REQ_SECTIONS: u32 = 8;
pub const R_BIN_REQ_INFO: u32 = 16;
pub const R_BIN_REQ_OPERATION: u32 = 32;
pub const R_BIN_REQ_HELP: u32 = 64;
pub const R_BIN_REQ_STRINGS: u32 = 128;
pub const R_BIN_REQ_FIELDS: u32 = 256;
pub const R_BIN_REQ_LIBS: u32 = 512;
pub const R_BIN_REQ_SRCLINE: u32 = 1024;
pub const R_BIN_REQ_MAIN: u32 = 2048;
pub const R_BIN_REQ_EXTRACT: u32 = 4096;
pub const R_BIN_REQ_RELOCS: u32 = 8192;
pub const R_BIN_REQ_LISTARCHS: u32 = 16384;
pub const R_BIN_REQ_CREATE: u32 = 32768;
pub const R_BIN_REQ_CLASSES: u32 = 65536;
pub const R_BIN_REQ_DWARF: u32 = 131072;
pub const R_BIN_REQ_SIZE: u32 = 262144;
pub const R_BIN_REQ_PDB: u32 = 524288;
pub const R_BIN_REQ_PDB_DWNLD: u32 = 1048576;
pub const R_BIN_REQ_DLOPEN: u32 = 2097152;
pub const R_BIN_REQ_EXPORTS: u32 = 4194304;
pub const R_BIN_REQ_VERSIONINFO: u32 = 8388608;
pub const R_BIN_REQ_PACKAGE: u32 = 16777216;
pub const R_BIN_REQ_HEADER: u32 = 33554432;
pub const R_BIN_REQ_LISTPLUGINS: u32 = 67108864;
pub const R_BIN_REQ_RESOURCES: u32 = 134217728;
pub const R_BIN_REQ_INITFINI: u32 = 268435456;
pub const R_BIN_REQ_SEGMENTS: u32 = 536870912;
pub const R_BIN_REQ_HASHES: u32 = 1073741824;
pub const R_BIN_REQ_SIGNATURE: u32 = 2147483648;
pub const R_BIN_REQ_TRYCATCH: u64 = 4294967296;
pub const R_BIN_REQ_SECTIONS_MAPPING: u64 = 8589934592;
pub const R_BIN_METH_CLASS: u32 = 1;
pub const R_BIN_METH_STATIC: u32 = 2;
pub const R_BIN_METH_PUBLIC: u32 = 4;
pub const R_BIN_METH_PRIVATE: u32 = 8;
pub const R_BIN_METH_PROTECTED: u32 = 16;
pub const R_BIN_METH_INTERNAL: u32 = 32;
pub const R_BIN_METH_OPEN: u32 = 64;
pub const R_BIN_METH_FILEPRIVATE: u32 = 128;
pub const R_BIN_METH_FINAL: u32 = 256;
pub const R_BIN_METH_VIRTUAL: u32 = 512;
pub const R_BIN_METH_CONST: u32 = 1024;
pub const R_BIN_METH_MUTATING: u32 = 2048;
pub const R_BIN_METH_ABSTRACT: u32 = 4096;
pub const R_BIN_METH_SYNCHRONIZED: u32 = 8192;
pub const R_BIN_METH_NATIVE: u32 = 16384;
pub const R_BIN_METH_BRIDGE: u32 = 32768;
pub const R_BIN_METH_VARARGS: u32 = 65536;
pub const R_BIN_METH_SYNTHETIC: u32 = 131072;
pub const R_BIN_METH_STRICT: u32 = 262144;
pub const R_BIN_METH_MIRANDA: u32 = 524288;
pub const R_BIN_METH_CONSTRUCTOR: u32 = 1048576;
pub const R_BIN_METH_DECLARED_SYNCHRONIZED: u32 = 2097152;
pub const R_BIN_BIND_LOCAL_STR: &'static [u8; 6usize] = b"LOCAL\0";
pub const R_BIN_BIND_GLOBAL_STR: &'static [u8; 7usize] = b"GLOBAL\0";
pub const R_BIN_BIND_WEAK_STR: &'static [u8; 5usize] = b"WEAK\0";
pub const R_BIN_BIND_NUM_STR: &'static [u8; 4usize] = b"NUM\0";
pub const R_BIN_BIND_LOOS_STR: &'static [u8; 5usize] = b"LOOS\0";
pub const R_BIN_BIND_HIOS_STR: &'static [u8; 5usize] = b"HIOS\0";
pub const R_BIN_BIND_LOPROC_STR: &'static [u8; 7usize] = b"LOPROC\0";
pub const R_BIN_BIND_HIPROC_STR: &'static [u8; 7usize] = b"HIPROC\0";
pub const R_BIN_BIND_UNKNOWN_STR: &'static [u8; 8usize] = b"UNKNOWN\0";
pub const R_BIN_TYPE_NOTYPE_STR: &'static [u8; 7usize] = b"NOTYPE\0";
pub const R_BIN_TYPE_OBJECT_STR: &'static [u8; 4usize] = b"OBJ\0";
pub const R_BIN_TYPE_FUNC_STR: &'static [u8; 5usize] = b"FUNC\0";
pub const R_BIN_TYPE_METH_STR: &'static [u8; 5usize] = b"METH\0";
pub const R_BIN_TYPE_STATIC_STR: &'static [u8; 7usize] = b"STATIC\0";
pub const R_BIN_TYPE_SECTION_STR: &'static [u8; 5usize] = b"SECT\0";
pub const R_BIN_TYPE_FILE_STR: &'static [u8; 5usize] = b"FILE\0";
pub const R_BIN_TYPE_COMMON_STR: &'static [u8; 7usize] = b"COMMON\0";
pub const R_BIN_TYPE_TLS_STR: &'static [u8; 4usize] = b"TLS\0";
pub const R_BIN_TYPE_NUM_STR: &'static [u8; 4usize] = b"NUM\0";
pub const R_BIN_TYPE_LOOS_STR: &'static [u8; 5usize] = b"LOOS\0";
pub const R_BIN_TYPE_HIOS_STR: &'static [u8; 5usize] = b"HIOS\0";
pub const R_BIN_TYPE_LOPROC_STR: &'static [u8; 7usize] = b"LOPROC\0";
pub const R_BIN_TYPE_HIPROC_STR: &'static [u8; 7usize] = b"HIPROC\0";
pub const R_BIN_TYPE_SPECIAL_SYM_STR: &'static [u8; 5usize] = b"SPCL\0";
pub const R_BIN_TYPE_UNKNOWN_STR: &'static [u8; 4usize] = b"UNK\0";
pub const R_FLAG_NAME_SIZE: u32 = 512;
pub const R_FLAG_ZONE_USE_SDB: u32 = 0;
pub const USE_VARSUBS: u32 = 0;
pub const R_REG_COND_EQ: u32 = 0;
pub const R_REG_COND_NE: u32 = 1;
pub const R_REG_COND_CF: u32 = 2;
pub const R_REG_COND_CARRY: u32 = 2;
pub const R_REG_COND_NEG: u32 = 3;
pub const R_REG_COND_NEGATIVE: u32 = 3;
pub const R_REG_COND_OF: u32 = 4;
pub const R_REG_COND_OVERFLOW: u32 = 4;
pub const R_REG_COND_HI: u32 = 5;
pub const R_REG_COND_HE: u32 = 6;
pub const R_REG_COND_LO: u32 = 7;
pub const R_REG_COND_LOE: u32 = 8;
pub const R_REG_COND_GE: u32 = 9;
pub const R_REG_COND_GT: u32 = 10;
pub const R_REG_COND_LT: u32 = 11;
pub const R_REG_COND_LE: u32 = 12;
pub const R_REG_COND_LAST: u32 = 13;
pub const R_SEARCH_DISTANCE_MAX: u32 = 10;
pub const R_SEARCH_KEYWORD_TYPE_BINARY: u8 = 105u8;
pub const R_SEARCH_KEYWORD_TYPE_STRING: u8 = 115u8;
pub const R_SEARCH_AES_BOX_SIZE: u32 = 31;
pub const R_SYSCALL_ARGS: u32 = 7;
pub const R_ANAL_ADDR_TYPE_EXEC: u32 = 1;
pub const R_ANAL_ADDR_TYPE_READ: u32 = 2;
pub const R_ANAL_ADDR_TYPE_WRITE: u32 = 4;
pub const R_ANAL_ADDR_TYPE_FLAG: u32 = 8;
pub const R_ANAL_ADDR_TYPE_FUNC: u32 = 16;
pub const R_ANAL_ADDR_TYPE_HEAP: u32 = 32;
pub const R_ANAL_ADDR_TYPE_STACK: u32 = 64;
pub const R_ANAL_ADDR_TYPE_REG: u32 = 128;
pub const R_ANAL_ADDR_TYPE_PROGRAM: u32 = 256;
pub const R_ANAL_ADDR_TYPE_LIBRARY: u32 = 512;
pub const R_ANAL_ADDR_TYPE_ASCII: u32 = 1024;
pub const R_ANAL_ADDR_TYPE_SEQUENCE: u32 = 2048;
pub const R_ANAL_ARCHINFO_MIN_OP_SIZE: u32 = 0;
pub const R_ANAL_ARCHINFO_MAX_OP_SIZE: u32 = 1;
pub const R_ANAL_ARCHINFO_ALIGN: u32 = 2;
pub const R_ANAL_ARCHINFO_DATA_ALIGN: u32 = 4;
pub const R_ANAL_CC_MAXARG: u32 = 16;
pub const R_ANAL_OP_TYPE_MASK: u32 = 2147549183;
pub const R_ANAL_OP_HINT_MASK: u32 = 4026531840;
pub const R_ANAL_ESIL_GOTO_LIMIT: u32 = 4096;
pub const VARPREFIX: &'static [u8; 4usize] = b"var\0";
pub const ARGPREFIX: &'static [u8; 4usize] = b"arg\0";
pub const ESIL_INTERNAL_PREFIX: u8 = 36u8;
pub const ESIL_STACK_NAME: &'static [u8; 9usize] = b"esil.ram\0";
pub const R_ANAL_FCN_VARKIND_LOCAL: u8 = 118u8;
pub const R_ANAL_THRESHOLDFCN: f64 = 0.7;
pub const R_ANAL_THRESHOLDBB: f64 = 0.7;
pub const R_EGG_INCDIR_ENV: &'static [u8; 11usize] = b"EGG_INCDIR\0";
pub const R_EGG_INCDIR_PATH: &'static [u8; 23usize] = b"/lib/radare2/5.4.1/egg\0";
pub const R_EGG_PLUGIN_SHELLCODE: u32 = 0;
pub const R_EGG_PLUGIN_ENCODER: u32 = 1;
pub const R_EGG_OS_LINUX: u32 = 1554393667;
pub const R_EGG_OS_OSX: u32 = 181769121;
pub const R_EGG_OS_DARWIN: u32 = 3631028962;
pub const R_EGG_OS_WATCHOS: u32 = 345267312;
pub const R_EGG_OS_IOS: u32 = 181766192;
pub const R_EGG_OS_MACOS: u32 = 1555184662;
pub const R_EGG_OS_W32: u32 = 181795763;
pub const R_EGG_OS_WINDOWS: u32 = 95936154;
pub const R_EGG_OS_BEOS: u32 = 1348536510;
pub const R_EGG_OS_FREEBSD: u32 = 1940334916;
pub const R_EGG_OS_DEFAULT: u32 = 181769121;
pub const R_EGG_OS_NAME: &'static [u8; 7usize] = b"darwin\0";
pub const R_EGG_FORMAT_DEFAULT: &'static [u8; 6usize] = b"mach0\0";
pub const MACRO_LIMIT: u32 = 1024;
pub const MACRO_LABELS: u32 = 20;
pub const R_CMD_MAXLEN: u32 = 4096;
pub const ZIGN_HASH: &'static [u8; 7usize] = b"sha256\0";
pub const R_SIGN_COL_DELEM: u8 = 58u8;
pub const SHA256_BLOCK_LENGTH: u32 = 64;
pub const SHA384_BLOCK_LENGTH: u32 = 128;
pub const SHA512_BLOCK_LENGTH: u32 = 128;
pub const R_HAVE_CRC15_EXTRA: u32 = 1;
pub const R_HAVE_CRC24: u32 = 1;
pub const R_HAVE_CRC32_EXTRA: u32 = 1;
pub const R_HAVE_CRC64: u32 = 1;
pub const R_HAVE_CRC64_EXTRA: u32 = 1;
pub const PFMTCRCx: &'static [u8; 4usize] = b"llx\0";
pub const R_HASH_SIZE_SSDEEP: u32 = 128;
pub const R_HASH_SIZE_CRC8_SMBUS: u32 = 1;
pub const R_HASH_SIZE_CRC15_CAN: u32 = 2;
pub const R_HASH_SIZE_CRC16: u32 = 2;
pub const R_HASH_SIZE_CRC16_HDLC: u32 = 2;
pub const R_HASH_SIZE_CRC16_USB: u32 = 2;
pub const R_HASH_SIZE_CRC16_CITT: u32 = 2;
pub const R_HASH_SIZE_CRC24: u32 = 3;
pub const R_HASH_SIZE_CRC32: u32 = 4;
pub const R_HASH_SIZE_CRC32C: u32 = 4;
pub const R_HASH_SIZE_CRC32_ECMA_267: u32 = 4;
pub const R_HASH_SIZE_CRC32_BZIP2: u32 = 4;
pub const R_HASH_SIZE_CRC32D: u32 = 4;
pub const R_HASH_SIZE_CRC32_MPEG2: u32 = 4;
pub const R_HASH_SIZE_CRC32_POSIX: u32 = 4;
pub const R_HASH_SIZE_CRC32Q: u32 = 4;
pub const R_HASH_SIZE_CRC32_JAMCRC: u32 = 4;
pub const R_HASH_SIZE_CRC32_XFER: u32 = 4;
pub const R_HASH_SIZE_CRC64: u32 = 8;
pub const R_HASH_SIZE_CRC64_ECMA182: u32 = 8;
pub const R_HASH_SIZE_CRC64_WE: u32 = 8;
pub const R_HASH_SIZE_CRC64_XZ: u32 = 8;
pub const R_HASH_SIZE_CRC64_ISO: u32 = 8;
pub const R_HASH_SIZE_XXHASH: u32 = 4;
pub const R_HASH_SIZE_MD4: u32 = 16;
pub const R_HASH_SIZE_MD5: u32 = 16;
pub const R_HASH_SIZE_SHA1: u32 = 20;
pub const R_HASH_SIZE_SHA256: u32 = 32;
pub const R_HASH_SIZE_SHA384: u32 = 48;
pub const R_HASH_SIZE_SHA512: u32 = 64;
pub const R_HASH_SIZE_ADLER32: u32 = 4;
pub const R_HASH_SIZE_ENTROPY: u32 = 0;
pub const R_HASH_SIZE_PCPRINT: u32 = 1;
pub const R_HASH_SIZE_MOD255: u32 = 1;
pub const R_HASH_SIZE_PARITY: u32 = 1;
pub const R_HASH_SIZE_XOR: u32 = 1;
pub const R_HASH_SIZE_XORPAIR: u32 = 2;
pub const R_HASH_SIZE_HAMDIST: u32 = 1;
pub const R_HASH_SIZE_LUHN: u32 = 1;
pub const R_HASH_SIZE_FLETCHER8: u32 = 1;
pub const R_HASH_SIZE_FLETCHER16: u32 = 2;
pub const R_HASH_SIZE_FLETCHER32: u32 = 4;
pub const R_HASH_SIZE_FLETCHER64: u32 = 8;
pub const R_HASH_NONE: u32 = 0;
pub const R_BP_MAXPIDS: u32 = 10;
pub const R_BP_CONT_NORMAL: u32 = 0;
pub const CN_BOOL: u32 = 1;
pub const CN_INT: u32 = 2;
pub const CN_STR: u32 = 8;
pub const CN_RO: u32 = 16;
pub const CN_RW: u32 = 32;
pub const SNAP_PAGE_SIZE: u32 = 4096;
pub const CHECK_POINT_LIMIT: u32 = 1048576;
pub const R_PRINT_FLAGS_COLOR: u32 = 1;
pub const R_PRINT_FLAGS_ADDRMOD: u32 = 2;
pub const R_PRINT_FLAGS_CURSOR: u32 = 4;
pub const R_PRINT_FLAGS_HEADER: u32 = 8;
pub const R_PRINT_FLAGS_SPARSE: u32 = 16;
pub const R_PRINT_FLAGS_SEGOFF: u32 = 32;
pub const R_PRINT_FLAGS_OFFSET: u32 = 64;
pub const R_PRINT_FLAGS_REFS: u32 = 128;
pub const R_PRINT_FLAGS_DIFFOUT: u32 = 256;
pub const R_PRINT_FLAGS_ADDRDEC: u32 = 512;
pub const R_PRINT_FLAGS_COMMENT: u32 = 1024;
pub const R_PRINT_FLAGS_COMPACT: u32 = 2048;
pub const R_PRINT_FLAGS_NONHEX: u32 = 4096;
pub const R_PRINT_FLAGS_SECSUB: u32 = 8192;
pub const R_PRINT_FLAGS_RAINBOW: u32 = 16384;
pub const R_PRINT_FLAGS_HDROFF: u32 = 32768;
pub const R_PRINT_FLAGS_STYLE: u32 = 65536;
pub const R_PRINT_FLAGS_NONASCII: u32 = 131072;
pub const R_PRINT_FLAGS_ALIGN: u32 = 262144;
pub const R_PRINT_FLAGS_UNALLOC: u32 = 524288;
pub const R_PRINT_FLAGS_BGFILL: u32 = 1048576;
pub const R_PRINT_FLAGS_SECTION: u32 = 2097152;
pub const _00_: u32 = 1;
pub const _01_: u32 = 8;
pub const _10_: u32 = 2;
pub const _11_: u32 = 16;
pub const _20_: u32 = 4;
pub const _21_: u32 = 32;
pub const _30_: u32 = 256;
pub const _31_: u32 = 512;
pub const BRAILE_ONE: u32 = 569;
pub const BRAILE_TWO: u32 = 797;
pub const BRAILE_TRI: u32 = 825;
pub const BRAILE_FUR: u32 = 563;
pub const BRAILE_FIV: u32 = 299;
pub const BRAILE_SIX: u32 = 814;
pub const BRAILE_SEV: u32 = 285;
pub const BRAILE_EIG: u32 = 831;
pub const BRAILE_NIN: u32 = 315;
pub const SEEFLAG: i32 = -2;
pub const JSONOUTPUT: i32 = -3;
pub const R_PRINT_MUSTSEE: u32 = 1;
pub const R_PRINT_ISFIELD: u32 = 2;
pub const R_PRINT_SEEFLAGS: u32 = 4;
pub const R_PRINT_JSON: u32 = 8;
pub const R_PRINT_MUSTSET: u32 = 16;
pub const R_PRINT_UNIONMODE: u32 = 32;
pub const R_PRINT_VALUE: u32 = 64;
pub const R_PRINT_DOT: u32 = 128;
pub const R_PRINT_QUIET: u32 = 256;
pub const R_PRINT_STRUCT: u32 = 512;
pub const R_PRINT_STRING_WIDE: u32 = 1;
pub const R_PRINT_STRING_ZEROEND: u32 = 2;
pub const R_PRINT_STRING_URLENCODE: u32 = 4;
pub const R_PRINT_STRING_WRAP: u32 = 8;
pub const R_PRINT_STRING_WIDE32: u32 = 16;
pub const R_PRINT_STRING_ESC_NL: u32 = 32;
pub const DES_KEY_SIZE: u32 = 8;
pub const DES_BLOCK_SIZE: u32 = 8;
pub const R_CRYPTO_NONE: u32 = 0;
pub const R_CRYPTO_RC2: u32 = 1;
pub const R_CRYPTO_RC4: u32 = 2;
pub const R_CRYPTO_RC6: u32 = 4;
pub const R_CRYPTO_AES_ECB: u32 = 8;
pub const R_CRYPTO_AES_CBC: u32 = 16;
pub const R_CRYPTO_ROR: u32 = 32;
pub const R_CRYPTO_ROL: u32 = 64;
pub const R_CRYPTO_ROT: u32 = 128;
pub const R_CRYPTO_BLOWFISH: u32 = 256;
pub const R_CRYPTO_CPS2: u32 = 512;
pub const R_CRYPTO_DES_ECB: u32 = 1024;
pub const R_CRYPTO_XOR: u32 = 2048;
pub const R_CRYPTO_SERPENT: u32 = 4096;
pub const R_CRYPTO_ALL: u32 = 65535;
pub const R_CODEC_NONE: u32 = 0;
pub const R_CODEC_B64: u32 = 1;
pub const R_CODEC_B91: u32 = 2;
pub const R_CODEC_PUNYCODE: u32 = 4;
pub const R_CODEC_ALL: u32 = 65535;
pub const R_CORE_CMD_OK: u32 = 0;
pub const R_CORE_CMD_INVALID: i32 = -1;
pub const R_CORE_CMD_EXIT: i32 = -2;
pub const R_CORE_BLOCKSIZE: u32 = 256;
pub const R_CORE_BLOCKSIZE_MAX: u32 = 52428800;
pub const R_CORE_ANAL_GRAPHLINES: u32 = 1;
pub const R_CORE_ANAL_GRAPHBODY: u32 = 2;
pub const R_CORE_ANAL_GRAPHDIFF: u32 = 4;
pub const R_CORE_ANAL_JSON: u32 = 8;
pub const R_CORE_ANAL_KEYVALUE: u32 = 16;
pub const R_CORE_ANAL_JSON_FORMAT_DISASM: u32 = 32;
pub const R_CORE_ANAL_STAR: u32 = 64;
pub const R_FLAGS_FS_CLASSES: &'static [u8; 8usize] = b"classes\0";
pub const R_FLAGS_FS_FUNCTIONS: &'static [u8; 10usize] = b"functions\0";
pub const R_FLAGS_FS_IMPORTS: &'static [u8; 8usize] = b"imports\0";
pub const R_FLAGS_FS_RELOCS: &'static [u8; 7usize] = b"relocs\0";
pub const R_FLAGS_FS_REGISTERS: &'static [u8; 10usize] = b"registers\0";
pub const R_FLAGS_FS_RESOURCES: &'static [u8; 10usize] = b"resources\0";
pub const R_FLAGS_FS_SECTIONS: &'static [u8; 9usize] = b"sections\0";
pub const R_FLAGS_FS_SEGMENTS: &'static [u8; 9usize] = b"segments\0";
pub const R_FLAGS_FS_SIGNS: &'static [u8; 5usize] = b"sign\0";
pub const R_FLAGS_FS_STRINGS: &'static [u8; 8usize] = b"strings\0";
pub const R_FLAGS_FS_SYMBOLS: &'static [u8; 8usize] = b"symbols\0";
pub const R_FLAGS_FS_SYMBOLS_SECTIONS: &'static [u8; 17usize] = b"symbols.sections\0";
pub const R_FLAGS_FS_SYSCALLS: &'static [u8; 9usize] = b"syscalls\0";
pub const R_GRAPH_FORMAT_NO: u32 = 0;
pub const R_GRAPH_FORMAT_GMLFCN: u32 = 1;
pub const R_GRAPH_FORMAT_JSON: u32 = 2;
pub const R_GRAPH_FORMAT_GML: u32 = 3;
pub const R_GRAPH_FORMAT_DOT: u32 = 4;
pub const R_GRAPH_FORMAT_CMD: u32 = 5;
pub const RTR_PROTOCOL_RAP: u32 = 0;
pub const RTR_PROTOCOL_TCP: u32 = 1;
pub const RTR_PROTOCOL_UDP: u32 = 2;
pub const RTR_PROTOCOL_HTTP: u32 = 3;
pub const RTR_PROTOCOL_UNIX: u32 = 4;
pub const RTR_MAX_HOSTS: u32 = 255;
pub const R_CORE_ASMQJMPS_NUM: u32 = 10;
pub const R_CORE_ASMQJMPS_LETTERS: u32 = 26;
pub const R_CORE_ASMQJMPS_MAX_LETTERS: u32 = 11881376;
pub const R_CORE_ASMQJMPS_LEN_LETTERS: u32 = 5;
pub const R_CORE_FOREIGN_ADDR: i32 = -1;
pub const R_CORE_LOADLIBS_ENV: u32 = 1;
pub const R_CORE_LOADLIBS_HOME: u32 = 2;
pub const R_CORE_LOADLIBS_SYSTEM: u32 = 4;
pub const R_CORE_LOADLIBS_CONFIG: u32 = 8;
pub const R_CORE_LOADLIBS_ALL: u32 = 4294967295;
pub const R_MIDFLAGS_HIDE: u32 = 0;
pub const R_MIDFLAGS_SHOW: u32 = 1;
pub const R_MIDFLAGS_REALIGN: u32 = 2;
pub const R_MIDFLAGS_SYMALIGN: u32 = 3;
pub const R_CORE_BIN_ACC_STRINGS: u32 = 1;
pub const R_CORE_BIN_ACC_INFO: u32 = 2;
pub const R_CORE_BIN_ACC_MAIN: u32 = 4;
pub const R_CORE_BIN_ACC_ENTRIES: u32 = 8;
pub const R_CORE_BIN_ACC_RELOCS: u32 = 16;
pub const R_CORE_BIN_ACC_IMPORTS: u32 = 32;
pub const R_CORE_BIN_ACC_SYMBOLS: u32 = 64;
pub const R_CORE_BIN_ACC_SECTIONS: u32 = 128;
pub const R_CORE_BIN_ACC_FIELDS: u32 = 256;
pub const R_CORE_BIN_ACC_LIBS: u32 = 512;
pub const R_CORE_BIN_ACC_CLASSES: u32 = 1024;
pub const R_CORE_BIN_ACC_DWARF: u32 = 2048;
pub const R_CORE_BIN_ACC_SIZE: u32 = 4096;
pub const R_CORE_BIN_ACC_PDB: u32 = 8192;
pub const R_CORE_BIN_ACC_MEM: u32 = 16384;
pub const R_CORE_BIN_ACC_EXPORTS: u32 = 32768;
pub const R_CORE_BIN_ACC_VERSIONINFO: u32 = 65536;
pub const R_CORE_BIN_ACC_SIGNATURE: u32 = 131072;
pub const R_CORE_BIN_ACC_RAW_STRINGS: u32 = 262144;
pub const R_CORE_BIN_ACC_HEADER: u32 = 524288;
pub const R_CORE_BIN_ACC_RESOURCES: u32 = 1048576;
pub const R_CORE_BIN_ACC_INITFINI: u32 = 2097152;
pub const R_CORE_BIN_ACC_SEGMENTS: u32 = 4194304;
pub const R_CORE_BIN_ACC_SOURCE: u32 = 8388608;
pub const R_CORE_BIN_ACC_HASHES: u32 = 268435456;
pub const R_CORE_BIN_ACC_TRYCATCH: u32 = 536870912;
pub const R_CORE_BIN_ACC_SECTIONS_MAPPING: u32 = 1073741824;
pub const R_CORE_BIN_ACC_ALL: u32 = 5263359;
pub const R_CORE_PRJ_FLAGS: u32 = 1;
pub const R_CORE_PRJ_EVAL: u32 = 2;
pub const R_CORE_PRJ_IO_MAPS: u32 = 4;
pub const R_CORE_PRJ_SECTIONS: u32 = 8;
pub const R_CORE_PRJ_META: u32 = 16;
pub const R_CORE_PRJ_XREFS: u32 = 32;
pub const R_CORE_PRJ_FCNS: u32 = 64;
pub const R_CORE_PRJ_ANAL_HINTS: u32 = 128;
pub const R_CORE_PRJ_ANAL_TYPES: u32 = 256;
pub const R_CORE_PRJ_ANAL_MACROS: u32 = 512;
pub const R_CORE_PRJ_ANAL_SEEK: u32 = 1024;
pub const R_CORE_PRJ_DBG_BREAK: u32 = 2048;
pub const R_CORE_PRJ_ALL: u32 = 65535;
pub type size_t = ::std::os::raw::c_ulong;
pub type wchar_t = ::std::os::raw::c_int;
pub type max_align_t = u128;
pub type __int8_t = ::std::os::raw::c_schar;
pub type __uint8_t = ::std::os::raw::c_uchar;
pub type __int16_t = ::std::os::raw::c_short;
pub type __uint16_t = ::std::os::raw::c_ushort;
pub type __int32_t = ::std::os::raw::c_int;
pub type __uint32_t = ::std::os::raw::c_uint;
pub type __int64_t = ::std::os::raw::c_longlong;
pub type __uint64_t = ::std::os::raw::c_ulonglong;
pub type __darwin_intptr_t = ::std::os::raw::c_long;
pub type __darwin_natural_t = ::std::os::raw::c_uint;
pub type __darwin_ct_rune_t = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Copy, Clone)]
pub union __mbstate_t {
    pub __mbstate8: [::std::os::raw::c_char; 128usize],
    pub _mbstateL: ::std::os::raw::c_longlong,
}
#[test]
fn bindgen_test_layout___mbstate_t() {
    assert_eq!(
        ::std::mem::size_of::<__mbstate_t>(),
        128usize,
        concat!("Size of: ", stringify!(__mbstate_t))
    );
    assert_eq!(
        ::std::mem::align_of::<__mbstate_t>(),
        8usize,
        concat!("Alignment of ", stringify!(__mbstate_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__mbstate_t>())).__mbstate8 as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__mbstate_t),
            "::",
            stringify!(__mbstate8)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__mbstate_t>()))._mbstateL as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__mbstate_t),
            "::",
            stringify!(_mbstateL)
        )
    );
}
pub type __darwin_mbstate_t = __mbstate_t;
pub type __darwin_ptrdiff_t = ::std::os::raw::c_long;
pub type __darwin_size_t = ::std::os::raw::c_ulong;
pub type __darwin_va_list = __builtin_va_list;
pub type __darwin_wchar_t = ::std::os::raw::c_int;
pub type __darwin_rune_t = __darwin_wchar_t;
pub type __darwin_wint_t = ::std::os::raw::c_int;
pub type __darwin_clock_t = ::std::os::raw::c_ulong;
pub type __darwin_socklen_t = __uint32_t;
pub type __darwin_ssize_t = ::std::os::raw::c_long;
pub type __darwin_time_t = ::std::os::raw::c_long;
pub type __darwin_blkcnt_t = __int64_t;
pub type __darwin_blksize_t = __int32_t;
pub type __darwin_dev_t = __int32_t;
pub type __darwin_fsblkcnt_t = ::std::os::raw::c_uint;
pub type __darwin_fsfilcnt_t = ::std::os::raw::c_uint;
pub type __darwin_gid_t = __uint32_t;
pub type __darwin_id_t = __uint32_t;
pub type __darwin_ino64_t = __uint64_t;
pub type __darwin_ino_t = __darwin_ino64_t;
pub type __darwin_mach_port_name_t = __darwin_natural_t;
pub type __darwin_mach_port_t = __darwin_mach_port_name_t;
pub type __darwin_mode_t = __uint16_t;
pub type __darwin_off_t = __int64_t;
pub type __darwin_pid_t = __int32_t;
pub type __darwin_sigset_t = __uint32_t;
pub type __darwin_suseconds_t = __int32_t;
pub type __darwin_uid_t = __uint32_t;
pub type __darwin_useconds_t = __uint32_t;
pub type __darwin_uuid_t = [::std::os::raw::c_uchar; 16usize];
pub type __darwin_uuid_string_t = [::std::os::raw::c_char; 37usize];
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_pthread_handler_rec {
    pub __routine: ::std::option::Option<unsafe extern "C" fn(arg1: *mut ::std::os::raw::c_void)>,
    pub __arg: *mut ::std::os::raw::c_void,
    pub __next: *mut __darwin_pthread_handler_rec,
}
#[test]
fn bindgen_test_layout___darwin_pthread_handler_rec() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_pthread_handler_rec>(),
        24usize,
        concat!("Size of: ", stringify!(__darwin_pthread_handler_rec))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_pthread_handler_rec>(),
        8usize,
        concat!("Alignment of ", stringify!(__darwin_pthread_handler_rec))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_pthread_handler_rec>())).__routine as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_pthread_handler_rec),
            "::",
            stringify!(__routine)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_pthread_handler_rec>())).__arg as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_pthread_handler_rec),
            "::",
            stringify!(__arg)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_pthread_handler_rec>())).__next as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_pthread_handler_rec),
            "::",
            stringify!(__next)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _opaque_pthread_attr_t {
    pub __sig: ::std::os::raw::c_long,
    pub __opaque: [::std::os::raw::c_char; 56usize],
}
#[test]
fn bindgen_test_layout__opaque_pthread_attr_t() {
    assert_eq!(
        ::std::mem::size_of::<_opaque_pthread_attr_t>(),
        64usize,
        concat!("Size of: ", stringify!(_opaque_pthread_attr_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_opaque_pthread_attr_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_opaque_pthread_attr_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_opaque_pthread_attr_t>())).__sig as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_attr_t),
            "::",
            stringify!(__sig)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_opaque_pthread_attr_t>())).__opaque as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_attr_t),
            "::",
            stringify!(__opaque)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _opaque_pthread_cond_t {
    pub __sig: ::std::os::raw::c_long,
    pub __opaque: [::std::os::raw::c_char; 40usize],
}
#[test]
fn bindgen_test_layout__opaque_pthread_cond_t() {
    assert_eq!(
        ::std::mem::size_of::<_opaque_pthread_cond_t>(),
        48usize,
        concat!("Size of: ", stringify!(_opaque_pthread_cond_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_opaque_pthread_cond_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_opaque_pthread_cond_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_opaque_pthread_cond_t>())).__sig as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_cond_t),
            "::",
            stringify!(__sig)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_opaque_pthread_cond_t>())).__opaque as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_cond_t),
            "::",
            stringify!(__opaque)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _opaque_pthread_condattr_t {
    pub __sig: ::std::os::raw::c_long,
    pub __opaque: [::std::os::raw::c_char; 8usize],
}
#[test]
fn bindgen_test_layout__opaque_pthread_condattr_t() {
    assert_eq!(
        ::std::mem::size_of::<_opaque_pthread_condattr_t>(),
        16usize,
        concat!("Size of: ", stringify!(_opaque_pthread_condattr_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_opaque_pthread_condattr_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_opaque_pthread_condattr_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_opaque_pthread_condattr_t>())).__sig as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_condattr_t),
            "::",
            stringify!(__sig)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_opaque_pthread_condattr_t>())).__opaque as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_condattr_t),
            "::",
            stringify!(__opaque)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _opaque_pthread_mutex_t {
    pub __sig: ::std::os::raw::c_long,
    pub __opaque: [::std::os::raw::c_char; 56usize],
}
#[test]
fn bindgen_test_layout__opaque_pthread_mutex_t() {
    assert_eq!(
        ::std::mem::size_of::<_opaque_pthread_mutex_t>(),
        64usize,
        concat!("Size of: ", stringify!(_opaque_pthread_mutex_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_opaque_pthread_mutex_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_opaque_pthread_mutex_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_opaque_pthread_mutex_t>())).__sig as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_mutex_t),
            "::",
            stringify!(__sig)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_opaque_pthread_mutex_t>())).__opaque as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_mutex_t),
            "::",
            stringify!(__opaque)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _opaque_pthread_mutexattr_t {
    pub __sig: ::std::os::raw::c_long,
    pub __opaque: [::std::os::raw::c_char; 8usize],
}
#[test]
fn bindgen_test_layout__opaque_pthread_mutexattr_t() {
    assert_eq!(
        ::std::mem::size_of::<_opaque_pthread_mutexattr_t>(),
        16usize,
        concat!("Size of: ", stringify!(_opaque_pthread_mutexattr_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_opaque_pthread_mutexattr_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_opaque_pthread_mutexattr_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_opaque_pthread_mutexattr_t>())).__sig as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_mutexattr_t),
            "::",
            stringify!(__sig)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_opaque_pthread_mutexattr_t>())).__opaque as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_mutexattr_t),
            "::",
            stringify!(__opaque)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _opaque_pthread_once_t {
    pub __sig: ::std::os::raw::c_long,
    pub __opaque: [::std::os::raw::c_char; 8usize],
}
#[test]
fn bindgen_test_layout__opaque_pthread_once_t() {
    assert_eq!(
        ::std::mem::size_of::<_opaque_pthread_once_t>(),
        16usize,
        concat!("Size of: ", stringify!(_opaque_pthread_once_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_opaque_pthread_once_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_opaque_pthread_once_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_opaque_pthread_once_t>())).__sig as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_once_t),
            "::",
            stringify!(__sig)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_opaque_pthread_once_t>())).__opaque as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_once_t),
            "::",
            stringify!(__opaque)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _opaque_pthread_rwlock_t {
    pub __sig: ::std::os::raw::c_long,
    pub __opaque: [::std::os::raw::c_char; 192usize],
}
#[test]
fn bindgen_test_layout__opaque_pthread_rwlock_t() {
    assert_eq!(
        ::std::mem::size_of::<_opaque_pthread_rwlock_t>(),
        200usize,
        concat!("Size of: ", stringify!(_opaque_pthread_rwlock_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_opaque_pthread_rwlock_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_opaque_pthread_rwlock_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_opaque_pthread_rwlock_t>())).__sig as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_rwlock_t),
            "::",
            stringify!(__sig)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_opaque_pthread_rwlock_t>())).__opaque as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_rwlock_t),
            "::",
            stringify!(__opaque)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _opaque_pthread_rwlockattr_t {
    pub __sig: ::std::os::raw::c_long,
    pub __opaque: [::std::os::raw::c_char; 16usize],
}
#[test]
fn bindgen_test_layout__opaque_pthread_rwlockattr_t() {
    assert_eq!(
        ::std::mem::size_of::<_opaque_pthread_rwlockattr_t>(),
        24usize,
        concat!("Size of: ", stringify!(_opaque_pthread_rwlockattr_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_opaque_pthread_rwlockattr_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_opaque_pthread_rwlockattr_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_opaque_pthread_rwlockattr_t>())).__sig as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_rwlockattr_t),
            "::",
            stringify!(__sig)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_opaque_pthread_rwlockattr_t>())).__opaque as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_rwlockattr_t),
            "::",
            stringify!(__opaque)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _opaque_pthread_t {
    pub __sig: ::std::os::raw::c_long,
    pub __cleanup_stack: *mut __darwin_pthread_handler_rec,
    pub __opaque: [::std::os::raw::c_char; 8176usize],
}
#[test]
fn bindgen_test_layout__opaque_pthread_t() {
    assert_eq!(
        ::std::mem::size_of::<_opaque_pthread_t>(),
        8192usize,
        concat!("Size of: ", stringify!(_opaque_pthread_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_opaque_pthread_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_opaque_pthread_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_opaque_pthread_t>())).__sig as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_t),
            "::",
            stringify!(__sig)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_opaque_pthread_t>())).__cleanup_stack as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_t),
            "::",
            stringify!(__cleanup_stack)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_opaque_pthread_t>())).__opaque as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_t),
            "::",
            stringify!(__opaque)
        )
    );
}
pub type __darwin_pthread_attr_t = _opaque_pthread_attr_t;
pub type __darwin_pthread_cond_t = _opaque_pthread_cond_t;
pub type __darwin_pthread_condattr_t = _opaque_pthread_condattr_t;
pub type __darwin_pthread_key_t = ::std::os::raw::c_ulong;
pub type __darwin_pthread_mutex_t = _opaque_pthread_mutex_t;
pub type __darwin_pthread_mutexattr_t = _opaque_pthread_mutexattr_t;
pub type __darwin_pthread_once_t = _opaque_pthread_once_t;
pub type __darwin_pthread_rwlock_t = _opaque_pthread_rwlock_t;
pub type __darwin_pthread_rwlockattr_t = _opaque_pthread_rwlockattr_t;
pub type __darwin_pthread_t = *mut _opaque_pthread_t;
pub type __darwin_nl_item = ::std::os::raw::c_int;
pub type __darwin_wctrans_t = ::std::os::raw::c_int;
pub type __darwin_wctype_t = __uint32_t;
pub const idtype_t_P_ALL: idtype_t = 0;
pub const idtype_t_P_PID: idtype_t = 1;
pub const idtype_t_P_PGID: idtype_t = 2;
pub type idtype_t = ::std::os::raw::c_uint;
pub type pid_t = __darwin_pid_t;
pub type id_t = __darwin_id_t;
pub type sig_atomic_t = ::std::os::raw::c_int;
pub type u_int8_t = ::std::os::raw::c_uchar;
pub type u_int16_t = ::std::os::raw::c_ushort;
pub type u_int32_t = ::std::os::raw::c_uint;
pub type u_int64_t = ::std::os::raw::c_ulonglong;
pub type register_t = i64;
pub type user_addr_t = u_int64_t;
pub type user_size_t = u_int64_t;
pub type user_ssize_t = i64;
pub type user_long_t = i64;
pub type user_ulong_t = u_int64_t;
pub type user_time_t = i64;
pub type user_off_t = i64;
pub type syscall_arg_t = u_int64_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_i386_thread_state {
    pub __eax: ::std::os::raw::c_uint,
    pub __ebx: ::std::os::raw::c_uint,
    pub __ecx: ::std::os::raw::c_uint,
    pub __edx: ::std::os::raw::c_uint,
    pub __edi: ::std::os::raw::c_uint,
    pub __esi: ::std::os::raw::c_uint,
    pub __ebp: ::std::os::raw::c_uint,
    pub __esp: ::std::os::raw::c_uint,
    pub __ss: ::std::os::raw::c_uint,
    pub __eflags: ::std::os::raw::c_uint,
    pub __eip: ::std::os::raw::c_uint,
    pub __cs: ::std::os::raw::c_uint,
    pub __ds: ::std::os::raw::c_uint,
    pub __es: ::std::os::raw::c_uint,
    pub __fs: ::std::os::raw::c_uint,
    pub __gs: ::std::os::raw::c_uint,
}
#[test]
fn bindgen_test_layout___darwin_i386_thread_state() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_i386_thread_state>(),
        64usize,
        concat!("Size of: ", stringify!(__darwin_i386_thread_state))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_i386_thread_state>(),
        4usize,
        concat!("Alignment of ", stringify!(__darwin_i386_thread_state))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_thread_state>())).__eax as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_thread_state),
            "::",
            stringify!(__eax)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_thread_state>())).__ebx as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_thread_state),
            "::",
            stringify!(__ebx)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_thread_state>())).__ecx as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_thread_state),
            "::",
            stringify!(__ecx)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_thread_state>())).__edx as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_thread_state),
            "::",
            stringify!(__edx)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_thread_state>())).__edi as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_thread_state),
            "::",
            stringify!(__edi)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_thread_state>())).__esi as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_thread_state),
            "::",
            stringify!(__esi)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_thread_state>())).__ebp as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_thread_state),
            "::",
            stringify!(__ebp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_thread_state>())).__esp as *const _ as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_thread_state),
            "::",
            stringify!(__esp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_i386_thread_state>())).__ss as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_thread_state),
            "::",
            stringify!(__ss)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_thread_state>())).__eflags as *const _ as usize
        },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_thread_state),
            "::",
            stringify!(__eflags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_thread_state>())).__eip as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_thread_state),
            "::",
            stringify!(__eip)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_i386_thread_state>())).__cs as *const _ as usize },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_thread_state),
            "::",
            stringify!(__cs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_i386_thread_state>())).__ds as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_thread_state),
            "::",
            stringify!(__ds)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_i386_thread_state>())).__es as *const _ as usize },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_thread_state),
            "::",
            stringify!(__es)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_i386_thread_state>())).__fs as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_thread_state),
            "::",
            stringify!(__fs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_i386_thread_state>())).__gs as *const _ as usize },
        60usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_thread_state),
            "::",
            stringify!(__gs)
        )
    );
}
#[repr(C)]
#[repr(align(2))]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_fp_control {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 2usize]>,
}
#[test]
fn bindgen_test_layout___darwin_fp_control() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_fp_control>(),
        2usize,
        concat!("Size of: ", stringify!(__darwin_fp_control))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_fp_control>(),
        2usize,
        concat!("Alignment of ", stringify!(__darwin_fp_control))
    );
}
impl __darwin_fp_control {
    #[inline]
    pub fn __invalid(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___invalid(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __denorm(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___denorm(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __zdiv(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___zdiv(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __ovrfl(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___ovrfl(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __undfl(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___undfl(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __precis(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(5usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___precis(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(5usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __pc(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 2u8) as u16) }
    }
    #[inline]
    pub fn set___pc(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn __rc(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(10usize, 2u8) as u16) }
    }
    #[inline]
    pub fn set___rc(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(10usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        __invalid: ::std::os::raw::c_ushort,
        __denorm: ::std::os::raw::c_ushort,
        __zdiv: ::std::os::raw::c_ushort,
        __ovrfl: ::std::os::raw::c_ushort,
        __undfl: ::std::os::raw::c_ushort,
        __precis: ::std::os::raw::c_ushort,
        __pc: ::std::os::raw::c_ushort,
        __rc: ::std::os::raw::c_ushort,
    ) -> __BindgenBitfieldUnit<[u8; 2usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 2usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let __invalid: u16 = unsafe { ::std::mem::transmute(__invalid) };
            __invalid as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let __denorm: u16 = unsafe { ::std::mem::transmute(__denorm) };
            __denorm as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let __zdiv: u16 = unsafe { ::std::mem::transmute(__zdiv) };
            __zdiv as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let __ovrfl: u16 = unsafe { ::std::mem::transmute(__ovrfl) };
            __ovrfl as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let __undfl: u16 = unsafe { ::std::mem::transmute(__undfl) };
            __undfl as u64
        });
        __bindgen_bitfield_unit.set(5usize, 1u8, {
            let __precis: u16 = unsafe { ::std::mem::transmute(__precis) };
            __precis as u64
        });
        __bindgen_bitfield_unit.set(8usize, 2u8, {
            let __pc: u16 = unsafe { ::std::mem::transmute(__pc) };
            __pc as u64
        });
        __bindgen_bitfield_unit.set(10usize, 2u8, {
            let __rc: u16 = unsafe { ::std::mem::transmute(__rc) };
            __rc as u64
        });
        __bindgen_bitfield_unit
    }
}
pub type __darwin_fp_control_t = __darwin_fp_control;
#[repr(C)]
#[repr(align(2))]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_fp_status {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 2usize]>,
}
#[test]
fn bindgen_test_layout___darwin_fp_status() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_fp_status>(),
        2usize,
        concat!("Size of: ", stringify!(__darwin_fp_status))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_fp_status>(),
        2usize,
        concat!("Alignment of ", stringify!(__darwin_fp_status))
    );
}
impl __darwin_fp_status {
    #[inline]
    pub fn __invalid(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___invalid(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __denorm(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___denorm(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __zdiv(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___zdiv(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __ovrfl(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___ovrfl(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __undfl(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___undfl(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __precis(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(5usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___precis(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(5usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __stkflt(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(6usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___stkflt(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(6usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __errsumm(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(7usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___errsumm(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(7usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __c0(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___c0(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __c1(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(9usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___c1(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(9usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __c2(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(10usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___c2(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(10usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __tos(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(11usize, 3u8) as u16) }
    }
    #[inline]
    pub fn set___tos(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(11usize, 3u8, val as u64)
        }
    }
    #[inline]
    pub fn __c3(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(14usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___c3(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(14usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __busy(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(15usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___busy(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(15usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        __invalid: ::std::os::raw::c_ushort,
        __denorm: ::std::os::raw::c_ushort,
        __zdiv: ::std::os::raw::c_ushort,
        __ovrfl: ::std::os::raw::c_ushort,
        __undfl: ::std::os::raw::c_ushort,
        __precis: ::std::os::raw::c_ushort,
        __stkflt: ::std::os::raw::c_ushort,
        __errsumm: ::std::os::raw::c_ushort,
        __c0: ::std::os::raw::c_ushort,
        __c1: ::std::os::raw::c_ushort,
        __c2: ::std::os::raw::c_ushort,
        __tos: ::std::os::raw::c_ushort,
        __c3: ::std::os::raw::c_ushort,
        __busy: ::std::os::raw::c_ushort,
    ) -> __BindgenBitfieldUnit<[u8; 2usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 2usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let __invalid: u16 = unsafe { ::std::mem::transmute(__invalid) };
            __invalid as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let __denorm: u16 = unsafe { ::std::mem::transmute(__denorm) };
            __denorm as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let __zdiv: u16 = unsafe { ::std::mem::transmute(__zdiv) };
            __zdiv as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let __ovrfl: u16 = unsafe { ::std::mem::transmute(__ovrfl) };
            __ovrfl as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let __undfl: u16 = unsafe { ::std::mem::transmute(__undfl) };
            __undfl as u64
        });
        __bindgen_bitfield_unit.set(5usize, 1u8, {
            let __precis: u16 = unsafe { ::std::mem::transmute(__precis) };
            __precis as u64
        });
        __bindgen_bitfield_unit.set(6usize, 1u8, {
            let __stkflt: u16 = unsafe { ::std::mem::transmute(__stkflt) };
            __stkflt as u64
        });
        __bindgen_bitfield_unit.set(7usize, 1u8, {
            let __errsumm: u16 = unsafe { ::std::mem::transmute(__errsumm) };
            __errsumm as u64
        });
        __bindgen_bitfield_unit.set(8usize, 1u8, {
            let __c0: u16 = unsafe { ::std::mem::transmute(__c0) };
            __c0 as u64
        });
        __bindgen_bitfield_unit.set(9usize, 1u8, {
            let __c1: u16 = unsafe { ::std::mem::transmute(__c1) };
            __c1 as u64
        });
        __bindgen_bitfield_unit.set(10usize, 1u8, {
            let __c2: u16 = unsafe { ::std::mem::transmute(__c2) };
            __c2 as u64
        });
        __bindgen_bitfield_unit.set(11usize, 3u8, {
            let __tos: u16 = unsafe { ::std::mem::transmute(__tos) };
            __tos as u64
        });
        __bindgen_bitfield_unit.set(14usize, 1u8, {
            let __c3: u16 = unsafe { ::std::mem::transmute(__c3) };
            __c3 as u64
        });
        __bindgen_bitfield_unit.set(15usize, 1u8, {
            let __busy: u16 = unsafe { ::std::mem::transmute(__busy) };
            __busy as u64
        });
        __bindgen_bitfield_unit
    }
}
pub type __darwin_fp_status_t = __darwin_fp_status;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_mmst_reg {
    pub __mmst_reg: [::std::os::raw::c_char; 10usize],
    pub __mmst_rsrv: [::std::os::raw::c_char; 6usize],
}
#[test]
fn bindgen_test_layout___darwin_mmst_reg() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_mmst_reg>(),
        16usize,
        concat!("Size of: ", stringify!(__darwin_mmst_reg))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_mmst_reg>(),
        1usize,
        concat!("Alignment of ", stringify!(__darwin_mmst_reg))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_mmst_reg>())).__mmst_reg as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mmst_reg),
            "::",
            stringify!(__mmst_reg)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_mmst_reg>())).__mmst_rsrv as *const _ as usize },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mmst_reg),
            "::",
            stringify!(__mmst_rsrv)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_xmm_reg {
    pub __xmm_reg: [::std::os::raw::c_char; 16usize],
}
#[test]
fn bindgen_test_layout___darwin_xmm_reg() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_xmm_reg>(),
        16usize,
        concat!("Size of: ", stringify!(__darwin_xmm_reg))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_xmm_reg>(),
        1usize,
        concat!("Alignment of ", stringify!(__darwin_xmm_reg))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_xmm_reg>())).__xmm_reg as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_xmm_reg),
            "::",
            stringify!(__xmm_reg)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_ymm_reg {
    pub __ymm_reg: [::std::os::raw::c_char; 32usize],
}
#[test]
fn bindgen_test_layout___darwin_ymm_reg() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_ymm_reg>(),
        32usize,
        concat!("Size of: ", stringify!(__darwin_ymm_reg))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_ymm_reg>(),
        1usize,
        concat!("Alignment of ", stringify!(__darwin_ymm_reg))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_ymm_reg>())).__ymm_reg as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_ymm_reg),
            "::",
            stringify!(__ymm_reg)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_zmm_reg {
    pub __zmm_reg: [::std::os::raw::c_char; 64usize],
}
#[test]
fn bindgen_test_layout___darwin_zmm_reg() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_zmm_reg>(),
        64usize,
        concat!("Size of: ", stringify!(__darwin_zmm_reg))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_zmm_reg>(),
        1usize,
        concat!("Alignment of ", stringify!(__darwin_zmm_reg))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_zmm_reg>())).__zmm_reg as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_zmm_reg),
            "::",
            stringify!(__zmm_reg)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_opmask_reg {
    pub __opmask_reg: [::std::os::raw::c_char; 8usize],
}
#[test]
fn bindgen_test_layout___darwin_opmask_reg() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_opmask_reg>(),
        8usize,
        concat!("Size of: ", stringify!(__darwin_opmask_reg))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_opmask_reg>(),
        1usize,
        concat!("Alignment of ", stringify!(__darwin_opmask_reg))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_opmask_reg>())).__opmask_reg as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_opmask_reg),
            "::",
            stringify!(__opmask_reg)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_i386_float_state {
    pub __fpu_reserved: [::std::os::raw::c_int; 2usize],
    pub __fpu_fcw: __darwin_fp_control,
    pub __fpu_fsw: __darwin_fp_status,
    pub __fpu_ftw: __uint8_t,
    pub __fpu_rsrv1: __uint8_t,
    pub __fpu_fop: __uint16_t,
    pub __fpu_ip: __uint32_t,
    pub __fpu_cs: __uint16_t,
    pub __fpu_rsrv2: __uint16_t,
    pub __fpu_dp: __uint32_t,
    pub __fpu_ds: __uint16_t,
    pub __fpu_rsrv3: __uint16_t,
    pub __fpu_mxcsr: __uint32_t,
    pub __fpu_mxcsrmask: __uint32_t,
    pub __fpu_stmm0: __darwin_mmst_reg,
    pub __fpu_stmm1: __darwin_mmst_reg,
    pub __fpu_stmm2: __darwin_mmst_reg,
    pub __fpu_stmm3: __darwin_mmst_reg,
    pub __fpu_stmm4: __darwin_mmst_reg,
    pub __fpu_stmm5: __darwin_mmst_reg,
    pub __fpu_stmm6: __darwin_mmst_reg,
    pub __fpu_stmm7: __darwin_mmst_reg,
    pub __fpu_xmm0: __darwin_xmm_reg,
    pub __fpu_xmm1: __darwin_xmm_reg,
    pub __fpu_xmm2: __darwin_xmm_reg,
    pub __fpu_xmm3: __darwin_xmm_reg,
    pub __fpu_xmm4: __darwin_xmm_reg,
    pub __fpu_xmm5: __darwin_xmm_reg,
    pub __fpu_xmm6: __darwin_xmm_reg,
    pub __fpu_xmm7: __darwin_xmm_reg,
    pub __fpu_rsrv4: [::std::os::raw::c_char; 224usize],
    pub __fpu_reserved1: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout___darwin_i386_float_state() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_i386_float_state>(),
        524usize,
        concat!("Size of: ", stringify!(__darwin_i386_float_state))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_i386_float_state>(),
        4usize,
        concat!("Alignment of ", stringify!(__darwin_i386_float_state))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_reserved as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_reserved)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_fcw as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_fcw)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_fsw as *const _ as usize
        },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_fsw)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_ftw as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_ftw)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_rsrv1 as *const _ as usize
        },
        13usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_rsrv1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_fop as *const _ as usize
        },
        14usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_fop)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_ip as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_ip)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_cs as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_cs)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_rsrv2 as *const _ as usize
        },
        22usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_rsrv2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_dp as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_dp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_ds as *const _ as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_ds)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_rsrv3 as *const _ as usize
        },
        30usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_rsrv3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_mxcsr as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_mxcsr)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_mxcsrmask as *const _
                as usize
        },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_mxcsrmask)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_stmm0 as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_stmm0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_stmm1 as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_stmm1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_stmm2 as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_stmm2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_stmm3 as *const _ as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_stmm3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_stmm4 as *const _ as usize
        },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_stmm4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_stmm5 as *const _ as usize
        },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_stmm5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_stmm6 as *const _ as usize
        },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_stmm6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_stmm7 as *const _ as usize
        },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_stmm7)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_xmm0 as *const _ as usize
        },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_xmm0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_xmm1 as *const _ as usize
        },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_xmm1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_xmm2 as *const _ as usize
        },
        200usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_xmm2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_xmm3 as *const _ as usize
        },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_xmm3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_xmm4 as *const _ as usize
        },
        232usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_xmm4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_xmm5 as *const _ as usize
        },
        248usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_xmm5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_xmm6 as *const _ as usize
        },
        264usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_xmm6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_xmm7 as *const _ as usize
        },
        280usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_xmm7)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_rsrv4 as *const _ as usize
        },
        296usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_rsrv4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_reserved1 as *const _
                as usize
        },
        520usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_reserved1)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_i386_avx_state {
    pub __fpu_reserved: [::std::os::raw::c_int; 2usize],
    pub __fpu_fcw: __darwin_fp_control,
    pub __fpu_fsw: __darwin_fp_status,
    pub __fpu_ftw: __uint8_t,
    pub __fpu_rsrv1: __uint8_t,
    pub __fpu_fop: __uint16_t,
    pub __fpu_ip: __uint32_t,
    pub __fpu_cs: __uint16_t,
    pub __fpu_rsrv2: __uint16_t,
    pub __fpu_dp: __uint32_t,
    pub __fpu_ds: __uint16_t,
    pub __fpu_rsrv3: __uint16_t,
    pub __fpu_mxcsr: __uint32_t,
    pub __fpu_mxcsrmask: __uint32_t,
    pub __fpu_stmm0: __darwin_mmst_reg,
    pub __fpu_stmm1: __darwin_mmst_reg,
    pub __fpu_stmm2: __darwin_mmst_reg,
    pub __fpu_stmm3: __darwin_mmst_reg,
    pub __fpu_stmm4: __darwin_mmst_reg,
    pub __fpu_stmm5: __darwin_mmst_reg,
    pub __fpu_stmm6: __darwin_mmst_reg,
    pub __fpu_stmm7: __darwin_mmst_reg,
    pub __fpu_xmm0: __darwin_xmm_reg,
    pub __fpu_xmm1: __darwin_xmm_reg,
    pub __fpu_xmm2: __darwin_xmm_reg,
    pub __fpu_xmm3: __darwin_xmm_reg,
    pub __fpu_xmm4: __darwin_xmm_reg,
    pub __fpu_xmm5: __darwin_xmm_reg,
    pub __fpu_xmm6: __darwin_xmm_reg,
    pub __fpu_xmm7: __darwin_xmm_reg,
    pub __fpu_rsrv4: [::std::os::raw::c_char; 224usize],
    pub __fpu_reserved1: ::std::os::raw::c_int,
    pub __avx_reserved1: [::std::os::raw::c_char; 64usize],
    pub __fpu_ymmh0: __darwin_xmm_reg,
    pub __fpu_ymmh1: __darwin_xmm_reg,
    pub __fpu_ymmh2: __darwin_xmm_reg,
    pub __fpu_ymmh3: __darwin_xmm_reg,
    pub __fpu_ymmh4: __darwin_xmm_reg,
    pub __fpu_ymmh5: __darwin_xmm_reg,
    pub __fpu_ymmh6: __darwin_xmm_reg,
    pub __fpu_ymmh7: __darwin_xmm_reg,
}
#[test]
fn bindgen_test_layout___darwin_i386_avx_state() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_i386_avx_state>(),
        716usize,
        concat!("Size of: ", stringify!(__darwin_i386_avx_state))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_i386_avx_state>(),
        4usize,
        concat!("Alignment of ", stringify!(__darwin_i386_avx_state))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_reserved as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_reserved)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_fcw as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_fcw)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_fsw as *const _ as usize
        },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_fsw)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_ftw as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_ftw)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_rsrv1 as *const _ as usize
        },
        13usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_rsrv1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_fop as *const _ as usize
        },
        14usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_fop)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_ip as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_ip)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_cs as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_cs)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_rsrv2 as *const _ as usize
        },
        22usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_rsrv2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_dp as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_dp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_ds as *const _ as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_ds)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_rsrv3 as *const _ as usize
        },
        30usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_rsrv3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_mxcsr as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_mxcsr)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_mxcsrmask as *const _ as usize
        },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_mxcsrmask)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_stmm0 as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_stmm0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_stmm1 as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_stmm1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_stmm2 as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_stmm2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_stmm3 as *const _ as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_stmm3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_stmm4 as *const _ as usize
        },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_stmm4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_stmm5 as *const _ as usize
        },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_stmm5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_stmm6 as *const _ as usize
        },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_stmm6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_stmm7 as *const _ as usize
        },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_stmm7)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_xmm0 as *const _ as usize
        },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_xmm0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_xmm1 as *const _ as usize
        },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_xmm1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_xmm2 as *const _ as usize
        },
        200usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_xmm2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_xmm3 as *const _ as usize
        },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_xmm3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_xmm4 as *const _ as usize
        },
        232usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_xmm4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_xmm5 as *const _ as usize
        },
        248usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_xmm5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_xmm6 as *const _ as usize
        },
        264usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_xmm6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_xmm7 as *const _ as usize
        },
        280usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_xmm7)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_rsrv4 as *const _ as usize
        },
        296usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_rsrv4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_reserved1 as *const _ as usize
        },
        520usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_reserved1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__avx_reserved1 as *const _ as usize
        },
        524usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__avx_reserved1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_ymmh0 as *const _ as usize
        },
        588usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_ymmh0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_ymmh1 as *const _ as usize
        },
        604usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_ymmh1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_ymmh2 as *const _ as usize
        },
        620usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_ymmh2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_ymmh3 as *const _ as usize
        },
        636usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_ymmh3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_ymmh4 as *const _ as usize
        },
        652usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_ymmh4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_ymmh5 as *const _ as usize
        },
        668usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_ymmh5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_ymmh6 as *const _ as usize
        },
        684usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_ymmh6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_ymmh7 as *const _ as usize
        },
        700usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_ymmh7)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_i386_avx512_state {
    pub __fpu_reserved: [::std::os::raw::c_int; 2usize],
    pub __fpu_fcw: __darwin_fp_control,
    pub __fpu_fsw: __darwin_fp_status,
    pub __fpu_ftw: __uint8_t,
    pub __fpu_rsrv1: __uint8_t,
    pub __fpu_fop: __uint16_t,
    pub __fpu_ip: __uint32_t,
    pub __fpu_cs: __uint16_t,
    pub __fpu_rsrv2: __uint16_t,
    pub __fpu_dp: __uint32_t,
    pub __fpu_ds: __uint16_t,
    pub __fpu_rsrv3: __uint16_t,
    pub __fpu_mxcsr: __uint32_t,
    pub __fpu_mxcsrmask: __uint32_t,
    pub __fpu_stmm0: __darwin_mmst_reg,
    pub __fpu_stmm1: __darwin_mmst_reg,
    pub __fpu_stmm2: __darwin_mmst_reg,
    pub __fpu_stmm3: __darwin_mmst_reg,
    pub __fpu_stmm4: __darwin_mmst_reg,
    pub __fpu_stmm5: __darwin_mmst_reg,
    pub __fpu_stmm6: __darwin_mmst_reg,
    pub __fpu_stmm7: __darwin_mmst_reg,
    pub __fpu_xmm0: __darwin_xmm_reg,
    pub __fpu_xmm1: __darwin_xmm_reg,
    pub __fpu_xmm2: __darwin_xmm_reg,
    pub __fpu_xmm3: __darwin_xmm_reg,
    pub __fpu_xmm4: __darwin_xmm_reg,
    pub __fpu_xmm5: __darwin_xmm_reg,
    pub __fpu_xmm6: __darwin_xmm_reg,
    pub __fpu_xmm7: __darwin_xmm_reg,
    pub __fpu_rsrv4: [::std::os::raw::c_char; 224usize],
    pub __fpu_reserved1: ::std::os::raw::c_int,
    pub __avx_reserved1: [::std::os::raw::c_char; 64usize],
    pub __fpu_ymmh0: __darwin_xmm_reg,
    pub __fpu_ymmh1: __darwin_xmm_reg,
    pub __fpu_ymmh2: __darwin_xmm_reg,
    pub __fpu_ymmh3: __darwin_xmm_reg,
    pub __fpu_ymmh4: __darwin_xmm_reg,
    pub __fpu_ymmh5: __darwin_xmm_reg,
    pub __fpu_ymmh6: __darwin_xmm_reg,
    pub __fpu_ymmh7: __darwin_xmm_reg,
    pub __fpu_k0: __darwin_opmask_reg,
    pub __fpu_k1: __darwin_opmask_reg,
    pub __fpu_k2: __darwin_opmask_reg,
    pub __fpu_k3: __darwin_opmask_reg,
    pub __fpu_k4: __darwin_opmask_reg,
    pub __fpu_k5: __darwin_opmask_reg,
    pub __fpu_k6: __darwin_opmask_reg,
    pub __fpu_k7: __darwin_opmask_reg,
    pub __fpu_zmmh0: __darwin_ymm_reg,
    pub __fpu_zmmh1: __darwin_ymm_reg,
    pub __fpu_zmmh2: __darwin_ymm_reg,
    pub __fpu_zmmh3: __darwin_ymm_reg,
    pub __fpu_zmmh4: __darwin_ymm_reg,
    pub __fpu_zmmh5: __darwin_ymm_reg,
    pub __fpu_zmmh6: __darwin_ymm_reg,
    pub __fpu_zmmh7: __darwin_ymm_reg,
}
#[test]
fn bindgen_test_layout___darwin_i386_avx512_state() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_i386_avx512_state>(),
        1036usize,
        concat!("Size of: ", stringify!(__darwin_i386_avx512_state))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_i386_avx512_state>(),
        4usize,
        concat!("Alignment of ", stringify!(__darwin_i386_avx512_state))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_reserved as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_reserved)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_fcw as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_fcw)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_fsw as *const _ as usize
        },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_fsw)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_ftw as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_ftw)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_rsrv1 as *const _ as usize
        },
        13usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_rsrv1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_fop as *const _ as usize
        },
        14usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_fop)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_ip as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_ip)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_cs as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_cs)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_rsrv2 as *const _ as usize
        },
        22usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_rsrv2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_dp as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_dp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_ds as *const _ as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_ds)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_rsrv3 as *const _ as usize
        },
        30usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_rsrv3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_mxcsr as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_mxcsr)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_mxcsrmask as *const _
                as usize
        },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_mxcsrmask)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_stmm0 as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_stmm0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_stmm1 as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_stmm1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_stmm2 as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_stmm2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_stmm3 as *const _ as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_stmm3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_stmm4 as *const _ as usize
        },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_stmm4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_stmm5 as *const _ as usize
        },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_stmm5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_stmm6 as *const _ as usize
        },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_stmm6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_stmm7 as *const _ as usize
        },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_stmm7)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_xmm0 as *const _ as usize
        },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_xmm0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_xmm1 as *const _ as usize
        },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_xmm1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_xmm2 as *const _ as usize
        },
        200usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_xmm2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_xmm3 as *const _ as usize
        },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_xmm3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_xmm4 as *const _ as usize
        },
        232usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_xmm4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_xmm5 as *const _ as usize
        },
        248usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_xmm5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_xmm6 as *const _ as usize
        },
        264usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_xmm6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_xmm7 as *const _ as usize
        },
        280usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_xmm7)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_rsrv4 as *const _ as usize
        },
        296usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_rsrv4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_reserved1 as *const _
                as usize
        },
        520usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_reserved1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__avx_reserved1 as *const _
                as usize
        },
        524usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__avx_reserved1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_ymmh0 as *const _ as usize
        },
        588usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_ymmh0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_ymmh1 as *const _ as usize
        },
        604usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_ymmh1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_ymmh2 as *const _ as usize
        },
        620usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_ymmh2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_ymmh3 as *const _ as usize
        },
        636usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_ymmh3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_ymmh4 as *const _ as usize
        },
        652usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_ymmh4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_ymmh5 as *const _ as usize
        },
        668usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_ymmh5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_ymmh6 as *const _ as usize
        },
        684usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_ymmh6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_ymmh7 as *const _ as usize
        },
        700usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_ymmh7)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_k0 as *const _ as usize
        },
        716usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_k0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_k1 as *const _ as usize
        },
        724usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_k1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_k2 as *const _ as usize
        },
        732usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_k2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_k3 as *const _ as usize
        },
        740usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_k3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_k4 as *const _ as usize
        },
        748usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_k4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_k5 as *const _ as usize
        },
        756usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_k5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_k6 as *const _ as usize
        },
        764usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_k6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_k7 as *const _ as usize
        },
        772usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_k7)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_zmmh0 as *const _ as usize
        },
        780usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_zmmh0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_zmmh1 as *const _ as usize
        },
        812usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_zmmh1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_zmmh2 as *const _ as usize
        },
        844usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_zmmh2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_zmmh3 as *const _ as usize
        },
        876usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_zmmh3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_zmmh4 as *const _ as usize
        },
        908usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_zmmh4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_zmmh5 as *const _ as usize
        },
        940usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_zmmh5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_zmmh6 as *const _ as usize
        },
        972usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_zmmh6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_zmmh7 as *const _ as usize
        },
        1004usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_zmmh7)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_i386_exception_state {
    pub __trapno: __uint16_t,
    pub __cpu: __uint16_t,
    pub __err: __uint32_t,
    pub __faultvaddr: __uint32_t,
}
#[test]
fn bindgen_test_layout___darwin_i386_exception_state() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_i386_exception_state>(),
        12usize,
        concat!("Size of: ", stringify!(__darwin_i386_exception_state))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_i386_exception_state>(),
        4usize,
        concat!("Alignment of ", stringify!(__darwin_i386_exception_state))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_exception_state>())).__trapno as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_exception_state),
            "::",
            stringify!(__trapno)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_exception_state>())).__cpu as *const _ as usize
        },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_exception_state),
            "::",
            stringify!(__cpu)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_exception_state>())).__err as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_exception_state),
            "::",
            stringify!(__err)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_exception_state>())).__faultvaddr as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_exception_state),
            "::",
            stringify!(__faultvaddr)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_x86_debug_state32 {
    pub __dr0: ::std::os::raw::c_uint,
    pub __dr1: ::std::os::raw::c_uint,
    pub __dr2: ::std::os::raw::c_uint,
    pub __dr3: ::std::os::raw::c_uint,
    pub __dr4: ::std::os::raw::c_uint,
    pub __dr5: ::std::os::raw::c_uint,
    pub __dr6: ::std::os::raw::c_uint,
    pub __dr7: ::std::os::raw::c_uint,
}
#[test]
fn bindgen_test_layout___darwin_x86_debug_state32() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_x86_debug_state32>(),
        32usize,
        concat!("Size of: ", stringify!(__darwin_x86_debug_state32))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_x86_debug_state32>(),
        4usize,
        concat!("Alignment of ", stringify!(__darwin_x86_debug_state32))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_debug_state32>())).__dr0 as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_debug_state32),
            "::",
            stringify!(__dr0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_debug_state32>())).__dr1 as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_debug_state32),
            "::",
            stringify!(__dr1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_debug_state32>())).__dr2 as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_debug_state32),
            "::",
            stringify!(__dr2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_debug_state32>())).__dr3 as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_debug_state32),
            "::",
            stringify!(__dr3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_debug_state32>())).__dr4 as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_debug_state32),
            "::",
            stringify!(__dr4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_debug_state32>())).__dr5 as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_debug_state32),
            "::",
            stringify!(__dr5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_debug_state32>())).__dr6 as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_debug_state32),
            "::",
            stringify!(__dr6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_debug_state32>())).__dr7 as *const _ as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_debug_state32),
            "::",
            stringify!(__dr7)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __x86_pagein_state {
    pub __pagein_error: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout___x86_pagein_state() {
    assert_eq!(
        ::std::mem::size_of::<__x86_pagein_state>(),
        4usize,
        concat!("Size of: ", stringify!(__x86_pagein_state))
    );
    assert_eq!(
        ::std::mem::align_of::<__x86_pagein_state>(),
        4usize,
        concat!("Alignment of ", stringify!(__x86_pagein_state))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__x86_pagein_state>())).__pagein_error as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__x86_pagein_state),
            "::",
            stringify!(__pagein_error)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_x86_thread_state64 {
    pub __rax: __uint64_t,
    pub __rbx: __uint64_t,
    pub __rcx: __uint64_t,
    pub __rdx: __uint64_t,
    pub __rdi: __uint64_t,
    pub __rsi: __uint64_t,
    pub __rbp: __uint64_t,
    pub __rsp: __uint64_t,
    pub __r8: __uint64_t,
    pub __r9: __uint64_t,
    pub __r10: __uint64_t,
    pub __r11: __uint64_t,
    pub __r12: __uint64_t,
    pub __r13: __uint64_t,
    pub __r14: __uint64_t,
    pub __r15: __uint64_t,
    pub __rip: __uint64_t,
    pub __rflags: __uint64_t,
    pub __cs: __uint64_t,
    pub __fs: __uint64_t,
    pub __gs: __uint64_t,
}
#[test]
fn bindgen_test_layout___darwin_x86_thread_state64() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_x86_thread_state64>(),
        168usize,
        concat!("Size of: ", stringify!(__darwin_x86_thread_state64))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_x86_thread_state64>(),
        8usize,
        concat!("Alignment of ", stringify!(__darwin_x86_thread_state64))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__rax as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__rax)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__rbx as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__rbx)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__rcx as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__rcx)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__rdx as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__rdx)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__rdi as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__rdi)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__rsi as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__rsi)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__rbp as *const _ as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__rbp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__rsp as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__rsp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__r8 as *const _ as usize
        },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__r8)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__r9 as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__r9)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__r10 as *const _ as usize
        },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__r10)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__r11 as *const _ as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__r11)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__r12 as *const _ as usize
        },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__r12)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__r13 as *const _ as usize
        },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__r13)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__r14 as *const _ as usize
        },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__r14)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__r15 as *const _ as usize
        },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__r15)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__rip as *const _ as usize
        },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__rip)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__rflags as *const _ as usize
        },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__rflags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__cs as *const _ as usize
        },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__cs)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__fs as *const _ as usize
        },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__fs)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__gs as *const _ as usize
        },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__gs)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_x86_thread_full_state64 {
    pub __ss64: __darwin_x86_thread_state64,
    pub __ds: __uint64_t,
    pub __es: __uint64_t,
    pub __ss: __uint64_t,
    pub __gsbase: __uint64_t,
}
#[test]
fn bindgen_test_layout___darwin_x86_thread_full_state64() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_x86_thread_full_state64>(),
        200usize,
        concat!("Size of: ", stringify!(__darwin_x86_thread_full_state64))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_x86_thread_full_state64>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__darwin_x86_thread_full_state64)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_full_state64>())).__ss64 as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_full_state64),
            "::",
            stringify!(__ss64)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_full_state64>())).__ds as *const _ as usize
        },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_full_state64),
            "::",
            stringify!(__ds)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_full_state64>())).__es as *const _ as usize
        },
        176usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_full_state64),
            "::",
            stringify!(__es)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_full_state64>())).__ss as *const _ as usize
        },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_full_state64),
            "::",
            stringify!(__ss)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_full_state64>())).__gsbase as *const _
                as usize
        },
        192usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_full_state64),
            "::",
            stringify!(__gsbase)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_x86_float_state64 {
    pub __fpu_reserved: [::std::os::raw::c_int; 2usize],
    pub __fpu_fcw: __darwin_fp_control,
    pub __fpu_fsw: __darwin_fp_status,
    pub __fpu_ftw: __uint8_t,
    pub __fpu_rsrv1: __uint8_t,
    pub __fpu_fop: __uint16_t,
    pub __fpu_ip: __uint32_t,
    pub __fpu_cs: __uint16_t,
    pub __fpu_rsrv2: __uint16_t,
    pub __fpu_dp: __uint32_t,
    pub __fpu_ds: __uint16_t,
    pub __fpu_rsrv3: __uint16_t,
    pub __fpu_mxcsr: __uint32_t,
    pub __fpu_mxcsrmask: __uint32_t,
    pub __fpu_stmm0: __darwin_mmst_reg,
    pub __fpu_stmm1: __darwin_mmst_reg,
    pub __fpu_stmm2: __darwin_mmst_reg,
    pub __fpu_stmm3: __darwin_mmst_reg,
    pub __fpu_stmm4: __darwin_mmst_reg,
    pub __fpu_stmm5: __darwin_mmst_reg,
    pub __fpu_stmm6: __darwin_mmst_reg,
    pub __fpu_stmm7: __darwin_mmst_reg,
    pub __fpu_xmm0: __darwin_xmm_reg,
    pub __fpu_xmm1: __darwin_xmm_reg,
    pub __fpu_xmm2: __darwin_xmm_reg,
    pub __fpu_xmm3: __darwin_xmm_reg,
    pub __fpu_xmm4: __darwin_xmm_reg,
    pub __fpu_xmm5: __darwin_xmm_reg,
    pub __fpu_xmm6: __darwin_xmm_reg,
    pub __fpu_xmm7: __darwin_xmm_reg,
    pub __fpu_xmm8: __darwin_xmm_reg,
    pub __fpu_xmm9: __darwin_xmm_reg,
    pub __fpu_xmm10: __darwin_xmm_reg,
    pub __fpu_xmm11: __darwin_xmm_reg,
    pub __fpu_xmm12: __darwin_xmm_reg,
    pub __fpu_xmm13: __darwin_xmm_reg,
    pub __fpu_xmm14: __darwin_xmm_reg,
    pub __fpu_xmm15: __darwin_xmm_reg,
    pub __fpu_rsrv4: [::std::os::raw::c_char; 96usize],
    pub __fpu_reserved1: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout___darwin_x86_float_state64() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_x86_float_state64>(),
        524usize,
        concat!("Size of: ", stringify!(__darwin_x86_float_state64))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_x86_float_state64>(),
        4usize,
        concat!("Alignment of ", stringify!(__darwin_x86_float_state64))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_reserved as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_reserved)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_fcw as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_fcw)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_fsw as *const _ as usize
        },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_fsw)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_ftw as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_ftw)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_rsrv1 as *const _ as usize
        },
        13usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_rsrv1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_fop as *const _ as usize
        },
        14usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_fop)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_ip as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_ip)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_cs as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_cs)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_rsrv2 as *const _ as usize
        },
        22usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_rsrv2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_dp as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_dp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_ds as *const _ as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_ds)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_rsrv3 as *const _ as usize
        },
        30usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_rsrv3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_mxcsr as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_mxcsr)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_mxcsrmask as *const _
                as usize
        },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_mxcsrmask)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_stmm0 as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_stmm0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_stmm1 as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_stmm1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_stmm2 as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_stmm2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_stmm3 as *const _ as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_stmm3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_stmm4 as *const _ as usize
        },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_stmm4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_stmm5 as *const _ as usize
        },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_stmm5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_stmm6 as *const _ as usize
        },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_stmm6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_stmm7 as *const _ as usize
        },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_stmm7)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_xmm0 as *const _ as usize
        },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_xmm0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_xmm1 as *const _ as usize
        },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_xmm1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_xmm2 as *const _ as usize
        },
        200usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_xmm2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_xmm3 as *const _ as usize
        },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_xmm3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_xmm4 as *const _ as usize
        },
        232usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_xmm4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_xmm5 as *const _ as usize
        },
        248usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_xmm5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_xmm6 as *const _ as usize
        },
        264usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_xmm6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_xmm7 as *const _ as usize
        },
        280usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_xmm7)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_xmm8 as *const _ as usize
        },
        296usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_xmm8)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_xmm9 as *const _ as usize
        },
        312usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_xmm9)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_xmm10 as *const _ as usize
        },
        328usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_xmm10)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_xmm11 as *const _ as usize
        },
        344usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_xmm11)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_xmm12 as *const _ as usize
        },
        360usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_xmm12)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_xmm13 as *const _ as usize
        },
        376usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_xmm13)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_xmm14 as *const _ as usize
        },
        392usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_xmm14)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_xmm15 as *const _ as usize
        },
        408usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_xmm15)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_rsrv4 as *const _ as usize
        },
        424usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_rsrv4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_reserved1 as *const _
                as usize
        },
        520usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_reserved1)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_x86_avx_state64 {
    pub __fpu_reserved: [::std::os::raw::c_int; 2usize],
    pub __fpu_fcw: __darwin_fp_control,
    pub __fpu_fsw: __darwin_fp_status,
    pub __fpu_ftw: __uint8_t,
    pub __fpu_rsrv1: __uint8_t,
    pub __fpu_fop: __uint16_t,
    pub __fpu_ip: __uint32_t,
    pub __fpu_cs: __uint16_t,
    pub __fpu_rsrv2: __uint16_t,
    pub __fpu_dp: __uint32_t,
    pub __fpu_ds: __uint16_t,
    pub __fpu_rsrv3: __uint16_t,
    pub __fpu_mxcsr: __uint32_t,
    pub __fpu_mxcsrmask: __uint32_t,
    pub __fpu_stmm0: __darwin_mmst_reg,
    pub __fpu_stmm1: __darwin_mmst_reg,
    pub __fpu_stmm2: __darwin_mmst_reg,
    pub __fpu_stmm3: __darwin_mmst_reg,
    pub __fpu_stmm4: __darwin_mmst_reg,
    pub __fpu_stmm5: __darwin_mmst_reg,
    pub __fpu_stmm6: __darwin_mmst_reg,
    pub __fpu_stmm7: __darwin_mmst_reg,
    pub __fpu_xmm0: __darwin_xmm_reg,
    pub __fpu_xmm1: __darwin_xmm_reg,
    pub __fpu_xmm2: __darwin_xmm_reg,
    pub __fpu_xmm3: __darwin_xmm_reg,
    pub __fpu_xmm4: __darwin_xmm_reg,
    pub __fpu_xmm5: __darwin_xmm_reg,
    pub __fpu_xmm6: __darwin_xmm_reg,
    pub __fpu_xmm7: __darwin_xmm_reg,
    pub __fpu_xmm8: __darwin_xmm_reg,
    pub __fpu_xmm9: __darwin_xmm_reg,
    pub __fpu_xmm10: __darwin_xmm_reg,
    pub __fpu_xmm11: __darwin_xmm_reg,
    pub __fpu_xmm12: __darwin_xmm_reg,
    pub __fpu_xmm13: __darwin_xmm_reg,
    pub __fpu_xmm14: __darwin_xmm_reg,
    pub __fpu_xmm15: __darwin_xmm_reg,
    pub __fpu_rsrv4: [::std::os::raw::c_char; 96usize],
    pub __fpu_reserved1: ::std::os::raw::c_int,
    pub __avx_reserved1: [::std::os::raw::c_char; 64usize],
    pub __fpu_ymmh0: __darwin_xmm_reg,
    pub __fpu_ymmh1: __darwin_xmm_reg,
    pub __fpu_ymmh2: __darwin_xmm_reg,
    pub __fpu_ymmh3: __darwin_xmm_reg,
    pub __fpu_ymmh4: __darwin_xmm_reg,
    pub __fpu_ymmh5: __darwin_xmm_reg,
    pub __fpu_ymmh6: __darwin_xmm_reg,
    pub __fpu_ymmh7: __darwin_xmm_reg,
    pub __fpu_ymmh8: __darwin_xmm_reg,
    pub __fpu_ymmh9: __darwin_xmm_reg,
    pub __fpu_ymmh10: __darwin_xmm_reg,
    pub __fpu_ymmh11: __darwin_xmm_reg,
    pub __fpu_ymmh12: __darwin_xmm_reg,
    pub __fpu_ymmh13: __darwin_xmm_reg,
    pub __fpu_ymmh14: __darwin_xmm_reg,
    pub __fpu_ymmh15: __darwin_xmm_reg,
}
#[test]
fn bindgen_test_layout___darwin_x86_avx_state64() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_x86_avx_state64>(),
        844usize,
        concat!("Size of: ", stringify!(__darwin_x86_avx_state64))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_x86_avx_state64>(),
        4usize,
        concat!("Alignment of ", stringify!(__darwin_x86_avx_state64))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_reserved as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_reserved)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_fcw as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_fcw)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_fsw as *const _ as usize
        },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_fsw)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_ftw as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ftw)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_rsrv1 as *const _ as usize
        },
        13usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_rsrv1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_fop as *const _ as usize
        },
        14usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_fop)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_ip as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ip)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_cs as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_cs)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_rsrv2 as *const _ as usize
        },
        22usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_rsrv2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_dp as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_dp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_ds as *const _ as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ds)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_rsrv3 as *const _ as usize
        },
        30usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_rsrv3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_mxcsr as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_mxcsr)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_mxcsrmask as *const _
                as usize
        },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_mxcsrmask)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_stmm0 as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_stmm0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_stmm1 as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_stmm1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_stmm2 as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_stmm2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_stmm3 as *const _ as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_stmm3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_stmm4 as *const _ as usize
        },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_stmm4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_stmm5 as *const _ as usize
        },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_stmm5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_stmm6 as *const _ as usize
        },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_stmm6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_stmm7 as *const _ as usize
        },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_stmm7)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_xmm0 as *const _ as usize
        },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_xmm0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_xmm1 as *const _ as usize
        },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_xmm1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_xmm2 as *const _ as usize
        },
        200usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_xmm2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_xmm3 as *const _ as usize
        },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_xmm3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_xmm4 as *const _ as usize
        },
        232usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_xmm4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_xmm5 as *const _ as usize
        },
        248usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_xmm5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_xmm6 as *const _ as usize
        },
        264usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_xmm6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_xmm7 as *const _ as usize
        },
        280usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_xmm7)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_xmm8 as *const _ as usize
        },
        296usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_xmm8)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_xmm9 as *const _ as usize
        },
        312usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_xmm9)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_xmm10 as *const _ as usize
        },
        328usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_xmm10)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_xmm11 as *const _ as usize
        },
        344usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_xmm11)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_xmm12 as *const _ as usize
        },
        360usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_xmm12)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_xmm13 as *const _ as usize
        },
        376usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_xmm13)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_xmm14 as *const _ as usize
        },
        392usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_xmm14)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_xmm15 as *const _ as usize
        },
        408usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_xmm15)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_rsrv4 as *const _ as usize
        },
        424usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_rsrv4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_reserved1 as *const _
                as usize
        },
        520usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_reserved1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__avx_reserved1 as *const _
                as usize
        },
        524usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__avx_reserved1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_ymmh0 as *const _ as usize
        },
        588usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ymmh0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_ymmh1 as *const _ as usize
        },
        604usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ymmh1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_ymmh2 as *const _ as usize
        },
        620usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ymmh2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_ymmh3 as *const _ as usize
        },
        636usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ymmh3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_ymmh4 as *const _ as usize
        },
        652usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ymmh4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_ymmh5 as *const _ as usize
        },
        668usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ymmh5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_ymmh6 as *const _ as usize
        },
        684usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ymmh6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_ymmh7 as *const _ as usize
        },
        700usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ymmh7)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_ymmh8 as *const _ as usize
        },
        716usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ymmh8)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_ymmh9 as *const _ as usize
        },
        732usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ymmh9)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_ymmh10 as *const _ as usize
        },
        748usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ymmh10)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_ymmh11 as *const _ as usize
        },
        764usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ymmh11)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_ymmh12 as *const _ as usize
        },
        780usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ymmh12)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_ymmh13 as *const _ as usize
        },
        796usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ymmh13)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_ymmh14 as *const _ as usize
        },
        812usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ymmh14)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_ymmh15 as *const _ as usize
        },
        828usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ymmh15)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_x86_avx512_state64 {
    pub __fpu_reserved: [::std::os::raw::c_int; 2usize],
    pub __fpu_fcw: __darwin_fp_control,
    pub __fpu_fsw: __darwin_fp_status,
    pub __fpu_ftw: __uint8_t,
    pub __fpu_rsrv1: __uint8_t,
    pub __fpu_fop: __uint16_t,
    pub __fpu_ip: __uint32_t,
    pub __fpu_cs: __uint16_t,
    pub __fpu_rsrv2: __uint16_t,
    pub __fpu_dp: __uint32_t,
    pub __fpu_ds: __uint16_t,
    pub __fpu_rsrv3: __uint16_t,
    pub __fpu_mxcsr: __uint32_t,
    pub __fpu_mxcsrmask: __uint32_t,
    pub __fpu_stmm0: __darwin_mmst_reg,
    pub __fpu_stmm1: __darwin_mmst_reg,
    pub __fpu_stmm2: __darwin_mmst_reg,
    pub __fpu_stmm3: __darwin_mmst_reg,
    pub __fpu_stmm4: __darwin_mmst_reg,
    pub __fpu_stmm5: __darwin_mmst_reg,
    pub __fpu_stmm6: __darwin_mmst_reg,
    pub __fpu_stmm7: __darwin_mmst_reg,
    pub __fpu_xmm0: __darwin_xmm_reg,
    pub __fpu_xmm1: __darwin_xmm_reg,
    pub __fpu_xmm2: __darwin_xmm_reg,
    pub __fpu_xmm3: __darwin_xmm_reg,
    pub __fpu_xmm4: __darwin_xmm_reg,
    pub __fpu_xmm5: __darwin_xmm_reg,
    pub __fpu_xmm6: __darwin_xmm_reg,
    pub __fpu_xmm7: __darwin_xmm_reg,
    pub __fpu_xmm8: __darwin_xmm_reg,
    pub __fpu_xmm9: __darwin_xmm_reg,
    pub __fpu_xmm10: __darwin_xmm_reg,
    pub __fpu_xmm11: __darwin_xmm_reg,
    pub __fpu_xmm12: __darwin_xmm_reg,
    pub __fpu_xmm13: __darwin_xmm_reg,
    pub __fpu_xmm14: __darwin_xmm_reg,
    pub __fpu_xmm15: __darwin_xmm_reg,
    pub __fpu_rsrv4: [::std::os::raw::c_char; 96usize],
    pub __fpu_reserved1: ::std::os::raw::c_int,
    pub __avx_reserved1: [::std::os::raw::c_char; 64usize],
    pub __fpu_ymmh0: __darwin_xmm_reg,
    pub __fpu_ymmh1: __darwin_xmm_reg,
    pub __fpu_ymmh2: __darwin_xmm_reg,
    pub __fpu_ymmh3: __darwin_xmm_reg,
    pub __fpu_ymmh4: __darwin_xmm_reg,
    pub __fpu_ymmh5: __darwin_xmm_reg,
    pub __fpu_ymmh6: __darwin_xmm_reg,
    pub __fpu_ymmh7: __darwin_xmm_reg,
    pub __fpu_ymmh8: __darwin_xmm_reg,
    pub __fpu_ymmh9: __darwin_xmm_reg,
    pub __fpu_ymmh10: __darwin_xmm_reg,
    pub __fpu_ymmh11: __darwin_xmm_reg,
    pub __fpu_ymmh12: __darwin_xmm_reg,
    pub __fpu_ymmh13: __darwin_xmm_reg,
    pub __fpu_ymmh14: __darwin_xmm_reg,
    pub __fpu_ymmh15: __darwin_xmm_reg,
    pub __fpu_k0: __darwin_opmask_reg,
    pub __fpu_k1: __darwin_opmask_reg,
    pub __fpu_k2: __darwin_opmask_reg,
    pub __fpu_k3: __darwin_opmask_reg,
    pub __fpu_k4: __darwin_opmask_reg,
    pub __fpu_k5: __darwin_opmask_reg,
    pub __fpu_k6: __darwin_opmask_reg,
    pub __fpu_k7: __darwin_opmask_reg,
    pub __fpu_zmmh0: __darwin_ymm_reg,
    pub __fpu_zmmh1: __darwin_ymm_reg,
    pub __fpu_zmmh2: __darwin_ymm_reg,
    pub __fpu_zmmh3: __darwin_ymm_reg,
    pub __fpu_zmmh4: __darwin_ymm_reg,
    pub __fpu_zmmh5: __darwin_ymm_reg,
    pub __fpu_zmmh6: __darwin_ymm_reg,
    pub __fpu_zmmh7: __darwin_ymm_reg,
    pub __fpu_zmmh8: __darwin_ymm_reg,
    pub __fpu_zmmh9: __darwin_ymm_reg,
    pub __fpu_zmmh10: __darwin_ymm_reg,
    pub __fpu_zmmh11: __darwin_ymm_reg,
    pub __fpu_zmmh12: __darwin_ymm_reg,
    pub __fpu_zmmh13: __darwin_ymm_reg,
    pub __fpu_zmmh14: __darwin_ymm_reg,
    pub __fpu_zmmh15: __darwin_ymm_reg,
    pub __fpu_zmm16: __darwin_zmm_reg,
    pub __fpu_zmm17: __darwin_zmm_reg,
    pub __fpu_zmm18: __darwin_zmm_reg,
    pub __fpu_zmm19: __darwin_zmm_reg,
    pub __fpu_zmm20: __darwin_zmm_reg,
    pub __fpu_zmm21: __darwin_zmm_reg,
    pub __fpu_zmm22: __darwin_zmm_reg,
    pub __fpu_zmm23: __darwin_zmm_reg,
    pub __fpu_zmm24: __darwin_zmm_reg,
    pub __fpu_zmm25: __darwin_zmm_reg,
    pub __fpu_zmm26: __darwin_zmm_reg,
    pub __fpu_zmm27: __darwin_zmm_reg,
    pub __fpu_zmm28: __darwin_zmm_reg,
    pub __fpu_zmm29: __darwin_zmm_reg,
    pub __fpu_zmm30: __darwin_zmm_reg,
    pub __fpu_zmm31: __darwin_zmm_reg,
}
#[test]
fn bindgen_test_layout___darwin_x86_avx512_state64() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_x86_avx512_state64>(),
        2444usize,
        concat!("Size of: ", stringify!(__darwin_x86_avx512_state64))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_x86_avx512_state64>(),
        4usize,
        concat!("Alignment of ", stringify!(__darwin_x86_avx512_state64))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_reserved as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_reserved)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_fcw as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_fcw)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_fsw as *const _ as usize
        },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_fsw)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_ftw as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ftw)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_rsrv1 as *const _ as usize
        },
        13usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_rsrv1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_fop as *const _ as usize
        },
        14usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_fop)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_ip as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ip)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_cs as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_cs)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_rsrv2 as *const _ as usize
        },
        22usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_rsrv2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_dp as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_dp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_ds as *const _ as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ds)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_rsrv3 as *const _ as usize
        },
        30usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_rsrv3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_mxcsr as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_mxcsr)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_mxcsrmask as *const _
                as usize
        },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_mxcsrmask)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_stmm0 as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_stmm0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_stmm1 as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_stmm1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_stmm2 as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_stmm2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_stmm3 as *const _ as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_stmm3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_stmm4 as *const _ as usize
        },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_stmm4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_stmm5 as *const _ as usize
        },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_stmm5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_stmm6 as *const _ as usize
        },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_stmm6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_stmm7 as *const _ as usize
        },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_stmm7)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_xmm0 as *const _ as usize
        },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_xmm0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_xmm1 as *const _ as usize
        },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_xmm1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_xmm2 as *const _ as usize
        },
        200usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_xmm2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_xmm3 as *const _ as usize
        },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_xmm3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_xmm4 as *const _ as usize
        },
        232usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_xmm4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_xmm5 as *const _ as usize
        },
        248usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_xmm5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_xmm6 as *const _ as usize
        },
        264usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_xmm6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_xmm7 as *const _ as usize
        },
        280usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_xmm7)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_xmm8 as *const _ as usize
        },
        296usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_xmm8)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_xmm9 as *const _ as usize
        },
        312usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_xmm9)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_xmm10 as *const _ as usize
        },
        328usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_xmm10)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_xmm11 as *const _ as usize
        },
        344usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_xmm11)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_xmm12 as *const _ as usize
        },
        360usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_xmm12)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_xmm13 as *const _ as usize
        },
        376usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_xmm13)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_xmm14 as *const _ as usize
        },
        392usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_xmm14)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_xmm15 as *const _ as usize
        },
        408usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_xmm15)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_rsrv4 as *const _ as usize
        },
        424usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_rsrv4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_reserved1 as *const _
                as usize
        },
        520usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_reserved1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__avx_reserved1 as *const _
                as usize
        },
        524usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__avx_reserved1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_ymmh0 as *const _ as usize
        },
        588usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ymmh0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_ymmh1 as *const _ as usize
        },
        604usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ymmh1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_ymmh2 as *const _ as usize
        },
        620usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ymmh2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_ymmh3 as *const _ as usize
        },
        636usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ymmh3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_ymmh4 as *const _ as usize
        },
        652usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ymmh4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_ymmh5 as *const _ as usize
        },
        668usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ymmh5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_ymmh6 as *const _ as usize
        },
        684usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ymmh6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_ymmh7 as *const _ as usize
        },
        700usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ymmh7)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_ymmh8 as *const _ as usize
        },
        716usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ymmh8)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_ymmh9 as *const _ as usize
        },
        732usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ymmh9)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_ymmh10 as *const _
                as usize
        },
        748usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ymmh10)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_ymmh11 as *const _
                as usize
        },
        764usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ymmh11)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_ymmh12 as *const _
                as usize
        },
        780usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ymmh12)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_ymmh13 as *const _
                as usize
        },
        796usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ymmh13)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_ymmh14 as *const _
                as usize
        },
        812usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ymmh14)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_ymmh15 as *const _
                as usize
        },
        828usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ymmh15)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_k0 as *const _ as usize
        },
        844usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_k0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_k1 as *const _ as usize
        },
        852usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_k1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_k2 as *const _ as usize
        },
        860usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_k2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_k3 as *const _ as usize
        },
        868usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_k3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_k4 as *const _ as usize
        },
        876usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_k4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_k5 as *const _ as usize
        },
        884usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_k5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_k6 as *const _ as usize
        },
        892usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_k6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_k7 as *const _ as usize
        },
        900usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_k7)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmmh0 as *const _ as usize
        },
        908usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmmh0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmmh1 as *const _ as usize
        },
        940usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmmh1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmmh2 as *const _ as usize
        },
        972usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmmh2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmmh3 as *const _ as usize
        },
        1004usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmmh3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmmh4 as *const _ as usize
        },
        1036usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmmh4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmmh5 as *const _ as usize
        },
        1068usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmmh5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmmh6 as *const _ as usize
        },
        1100usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmmh6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmmh7 as *const _ as usize
        },
        1132usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmmh7)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmmh8 as *const _ as usize
        },
        1164usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmmh8)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmmh9 as *const _ as usize
        },
        1196usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmmh9)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmmh10 as *const _
                as usize
        },
        1228usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmmh10)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmmh11 as *const _
                as usize
        },
        1260usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmmh11)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmmh12 as *const _
                as usize
        },
        1292usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmmh12)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmmh13 as *const _
                as usize
        },
        1324usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmmh13)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmmh14 as *const _
                as usize
        },
        1356usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmmh14)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmmh15 as *const _
                as usize
        },
        1388usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmmh15)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmm16 as *const _ as usize
        },
        1420usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmm16)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmm17 as *const _ as usize
        },
        1484usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmm17)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmm18 as *const _ as usize
        },
        1548usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmm18)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmm19 as *const _ as usize
        },
        1612usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmm19)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmm20 as *const _ as usize
        },
        1676usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmm20)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmm21 as *const _ as usize
        },
        1740usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmm21)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmm22 as *const _ as usize
        },
        1804usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmm22)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmm23 as *const _ as usize
        },
        1868usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmm23)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmm24 as *const _ as usize
        },
        1932usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmm24)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmm25 as *const _ as usize
        },
        1996usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmm25)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmm26 as *const _ as usize
        },
        2060usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmm26)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmm27 as *const _ as usize
        },
        2124usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmm27)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmm28 as *const _ as usize
        },
        2188usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmm28)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmm29 as *const _ as usize
        },
        2252usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmm29)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmm30 as *const _ as usize
        },
        2316usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmm30)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmm31 as *const _ as usize
        },
        2380usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmm31)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_x86_exception_state64 {
    pub __trapno: __uint16_t,
    pub __cpu: __uint16_t,
    pub __err: __uint32_t,
    pub __faultvaddr: __uint64_t,
}
#[test]
fn bindgen_test_layout___darwin_x86_exception_state64() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_x86_exception_state64>(),
        16usize,
        concat!("Size of: ", stringify!(__darwin_x86_exception_state64))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_x86_exception_state64>(),
        8usize,
        concat!("Alignment of ", stringify!(__darwin_x86_exception_state64))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_exception_state64>())).__trapno as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_exception_state64),
            "::",
            stringify!(__trapno)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_exception_state64>())).__cpu as *const _ as usize
        },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_exception_state64),
            "::",
            stringify!(__cpu)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_exception_state64>())).__err as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_exception_state64),
            "::",
            stringify!(__err)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_exception_state64>())).__faultvaddr as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_exception_state64),
            "::",
            stringify!(__faultvaddr)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_x86_debug_state64 {
    pub __dr0: __uint64_t,
    pub __dr1: __uint64_t,
    pub __dr2: __uint64_t,
    pub __dr3: __uint64_t,
    pub __dr4: __uint64_t,
    pub __dr5: __uint64_t,
    pub __dr6: __uint64_t,
    pub __dr7: __uint64_t,
}
#[test]
fn bindgen_test_layout___darwin_x86_debug_state64() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_x86_debug_state64>(),
        64usize,
        concat!("Size of: ", stringify!(__darwin_x86_debug_state64))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_x86_debug_state64>(),
        8usize,
        concat!("Alignment of ", stringify!(__darwin_x86_debug_state64))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_debug_state64>())).__dr0 as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_debug_state64),
            "::",
            stringify!(__dr0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_debug_state64>())).__dr1 as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_debug_state64),
            "::",
            stringify!(__dr1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_debug_state64>())).__dr2 as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_debug_state64),
            "::",
            stringify!(__dr2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_debug_state64>())).__dr3 as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_debug_state64),
            "::",
            stringify!(__dr3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_debug_state64>())).__dr4 as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_debug_state64),
            "::",
            stringify!(__dr4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_debug_state64>())).__dr5 as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_debug_state64),
            "::",
            stringify!(__dr5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_debug_state64>())).__dr6 as *const _ as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_debug_state64),
            "::",
            stringify!(__dr6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_debug_state64>())).__dr7 as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_debug_state64),
            "::",
            stringify!(__dr7)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_x86_cpmu_state64 {
    pub __ctrs: [__uint64_t; 16usize],
}
#[test]
fn bindgen_test_layout___darwin_x86_cpmu_state64() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_x86_cpmu_state64>(),
        128usize,
        concat!("Size of: ", stringify!(__darwin_x86_cpmu_state64))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_x86_cpmu_state64>(),
        8usize,
        concat!("Alignment of ", stringify!(__darwin_x86_cpmu_state64))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_cpmu_state64>())).__ctrs as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_cpmu_state64),
            "::",
            stringify!(__ctrs)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_mcontext32 {
    pub __es: __darwin_i386_exception_state,
    pub __ss: __darwin_i386_thread_state,
    pub __fs: __darwin_i386_float_state,
}
#[test]
fn bindgen_test_layout___darwin_mcontext32() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_mcontext32>(),
        600usize,
        concat!("Size of: ", stringify!(__darwin_mcontext32))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_mcontext32>(),
        4usize,
        concat!("Alignment of ", stringify!(__darwin_mcontext32))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_mcontext32>())).__es as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext32),
            "::",
            stringify!(__es)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_mcontext32>())).__ss as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext32),
            "::",
            stringify!(__ss)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_mcontext32>())).__fs as *const _ as usize },
        76usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext32),
            "::",
            stringify!(__fs)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_mcontext_avx32 {
    pub __es: __darwin_i386_exception_state,
    pub __ss: __darwin_i386_thread_state,
    pub __fs: __darwin_i386_avx_state,
}
#[test]
fn bindgen_test_layout___darwin_mcontext_avx32() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_mcontext_avx32>(),
        792usize,
        concat!("Size of: ", stringify!(__darwin_mcontext_avx32))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_mcontext_avx32>(),
        4usize,
        concat!("Alignment of ", stringify!(__darwin_mcontext_avx32))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_mcontext_avx32>())).__es as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext_avx32),
            "::",
            stringify!(__es)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_mcontext_avx32>())).__ss as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext_avx32),
            "::",
            stringify!(__ss)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_mcontext_avx32>())).__fs as *const _ as usize },
        76usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext_avx32),
            "::",
            stringify!(__fs)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_mcontext_avx512_32 {
    pub __es: __darwin_i386_exception_state,
    pub __ss: __darwin_i386_thread_state,
    pub __fs: __darwin_i386_avx512_state,
}
#[test]
fn bindgen_test_layout___darwin_mcontext_avx512_32() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_mcontext_avx512_32>(),
        1112usize,
        concat!("Size of: ", stringify!(__darwin_mcontext_avx512_32))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_mcontext_avx512_32>(),
        4usize,
        concat!("Alignment of ", stringify!(__darwin_mcontext_avx512_32))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_mcontext_avx512_32>())).__es as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext_avx512_32),
            "::",
            stringify!(__es)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_mcontext_avx512_32>())).__ss as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext_avx512_32),
            "::",
            stringify!(__ss)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_mcontext_avx512_32>())).__fs as *const _ as usize
        },
        76usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext_avx512_32),
            "::",
            stringify!(__fs)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_mcontext64 {
    pub __es: __darwin_x86_exception_state64,
    pub __ss: __darwin_x86_thread_state64,
    pub __fs: __darwin_x86_float_state64,
}
#[test]
fn bindgen_test_layout___darwin_mcontext64() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_mcontext64>(),
        712usize,
        concat!("Size of: ", stringify!(__darwin_mcontext64))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_mcontext64>(),
        8usize,
        concat!("Alignment of ", stringify!(__darwin_mcontext64))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_mcontext64>())).__es as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext64),
            "::",
            stringify!(__es)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_mcontext64>())).__ss as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext64),
            "::",
            stringify!(__ss)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_mcontext64>())).__fs as *const _ as usize },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext64),
            "::",
            stringify!(__fs)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_mcontext64_full {
    pub __es: __darwin_x86_exception_state64,
    pub __ss: __darwin_x86_thread_full_state64,
    pub __fs: __darwin_x86_float_state64,
}
#[test]
fn bindgen_test_layout___darwin_mcontext64_full() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_mcontext64_full>(),
        744usize,
        concat!("Size of: ", stringify!(__darwin_mcontext64_full))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_mcontext64_full>(),
        8usize,
        concat!("Alignment of ", stringify!(__darwin_mcontext64_full))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_mcontext64_full>())).__es as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext64_full),
            "::",
            stringify!(__es)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_mcontext64_full>())).__ss as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext64_full),
            "::",
            stringify!(__ss)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_mcontext64_full>())).__fs as *const _ as usize },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext64_full),
            "::",
            stringify!(__fs)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_mcontext_avx64 {
    pub __es: __darwin_x86_exception_state64,
    pub __ss: __darwin_x86_thread_state64,
    pub __fs: __darwin_x86_avx_state64,
}
#[test]
fn bindgen_test_layout___darwin_mcontext_avx64() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_mcontext_avx64>(),
        1032usize,
        concat!("Size of: ", stringify!(__darwin_mcontext_avx64))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_mcontext_avx64>(),
        8usize,
        concat!("Alignment of ", stringify!(__darwin_mcontext_avx64))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_mcontext_avx64>())).__es as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext_avx64),
            "::",
            stringify!(__es)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_mcontext_avx64>())).__ss as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext_avx64),
            "::",
            stringify!(__ss)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_mcontext_avx64>())).__fs as *const _ as usize },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext_avx64),
            "::",
            stringify!(__fs)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_mcontext_avx64_full {
    pub __es: __darwin_x86_exception_state64,
    pub __ss: __darwin_x86_thread_full_state64,
    pub __fs: __darwin_x86_avx_state64,
}
#[test]
fn bindgen_test_layout___darwin_mcontext_avx64_full() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_mcontext_avx64_full>(),
        1064usize,
        concat!("Size of: ", stringify!(__darwin_mcontext_avx64_full))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_mcontext_avx64_full>(),
        8usize,
        concat!("Alignment of ", stringify!(__darwin_mcontext_avx64_full))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_mcontext_avx64_full>())).__es as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext_avx64_full),
            "::",
            stringify!(__es)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_mcontext_avx64_full>())).__ss as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext_avx64_full),
            "::",
            stringify!(__ss)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_mcontext_avx64_full>())).__fs as *const _ as usize
        },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext_avx64_full),
            "::",
            stringify!(__fs)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_mcontext_avx512_64 {
    pub __es: __darwin_x86_exception_state64,
    pub __ss: __darwin_x86_thread_state64,
    pub __fs: __darwin_x86_avx512_state64,
}
#[test]
fn bindgen_test_layout___darwin_mcontext_avx512_64() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_mcontext_avx512_64>(),
        2632usize,
        concat!("Size of: ", stringify!(__darwin_mcontext_avx512_64))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_mcontext_avx512_64>(),
        8usize,
        concat!("Alignment of ", stringify!(__darwin_mcontext_avx512_64))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_mcontext_avx512_64>())).__es as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext_avx512_64),
            "::",
            stringify!(__es)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_mcontext_avx512_64>())).__ss as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext_avx512_64),
            "::",
            stringify!(__ss)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_mcontext_avx512_64>())).__fs as *const _ as usize
        },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext_avx512_64),
            "::",
            stringify!(__fs)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_mcontext_avx512_64_full {
    pub __es: __darwin_x86_exception_state64,
    pub __ss: __darwin_x86_thread_full_state64,
    pub __fs: __darwin_x86_avx512_state64,
}
#[test]
fn bindgen_test_layout___darwin_mcontext_avx512_64_full() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_mcontext_avx512_64_full>(),
        2664usize,
        concat!("Size of: ", stringify!(__darwin_mcontext_avx512_64_full))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_mcontext_avx512_64_full>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__darwin_mcontext_avx512_64_full)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_mcontext_avx512_64_full>())).__es as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext_avx512_64_full),
            "::",
            stringify!(__es)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_mcontext_avx512_64_full>())).__ss as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext_avx512_64_full),
            "::",
            stringify!(__ss)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_mcontext_avx512_64_full>())).__fs as *const _ as usize
        },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext_avx512_64_full),
            "::",
            stringify!(__fs)
        )
    );
}
pub type mcontext_t = *mut __darwin_mcontext64;
pub type pthread_attr_t = __darwin_pthread_attr_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_sigaltstack {
    pub ss_sp: *mut ::std::os::raw::c_void,
    pub ss_size: __darwin_size_t,
    pub ss_flags: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout___darwin_sigaltstack() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_sigaltstack>(),
        24usize,
        concat!("Size of: ", stringify!(__darwin_sigaltstack))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_sigaltstack>(),
        8usize,
        concat!("Alignment of ", stringify!(__darwin_sigaltstack))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_sigaltstack>())).ss_sp as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_sigaltstack),
            "::",
            stringify!(ss_sp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_sigaltstack>())).ss_size as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_sigaltstack),
            "::",
            stringify!(ss_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_sigaltstack>())).ss_flags as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_sigaltstack),
            "::",
            stringify!(ss_flags)
        )
    );
}
pub type stack_t = __darwin_sigaltstack;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_ucontext {
    pub uc_onstack: ::std::os::raw::c_int,
    pub uc_sigmask: __darwin_sigset_t,
    pub uc_stack: __darwin_sigaltstack,
    pub uc_link: *mut __darwin_ucontext,
    pub uc_mcsize: __darwin_size_t,
    pub uc_mcontext: *mut __darwin_mcontext64,
}
#[test]
fn bindgen_test_layout___darwin_ucontext() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_ucontext>(),
        56usize,
        concat!("Size of: ", stringify!(__darwin_ucontext))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_ucontext>(),
        8usize,
        concat!("Alignment of ", stringify!(__darwin_ucontext))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_ucontext>())).uc_onstack as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_ucontext),
            "::",
            stringify!(uc_onstack)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_ucontext>())).uc_sigmask as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_ucontext),
            "::",
            stringify!(uc_sigmask)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_ucontext>())).uc_stack as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_ucontext),
            "::",
            stringify!(uc_stack)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_ucontext>())).uc_link as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_ucontext),
            "::",
            stringify!(uc_link)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_ucontext>())).uc_mcsize as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_ucontext),
            "::",
            stringify!(uc_mcsize)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_ucontext>())).uc_mcontext as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_ucontext),
            "::",
            stringify!(uc_mcontext)
        )
    );
}
pub type ucontext_t = __darwin_ucontext;
pub type sigset_t = __darwin_sigset_t;
pub type uid_t = __darwin_uid_t;
#[repr(C)]
#[derive(Copy, Clone)]
pub union sigval {
    pub sival_int: ::std::os::raw::c_int,
    pub sival_ptr: *mut ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout_sigval() {
    assert_eq!(
        ::std::mem::size_of::<sigval>(),
        8usize,
        concat!("Size of: ", stringify!(sigval))
    );
    assert_eq!(
        ::std::mem::align_of::<sigval>(),
        8usize,
        concat!("Alignment of ", stringify!(sigval))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigval>())).sival_int as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sigval),
            "::",
            stringify!(sival_int)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigval>())).sival_ptr as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sigval),
            "::",
            stringify!(sival_ptr)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct sigevent {
    pub sigev_notify: ::std::os::raw::c_int,
    pub sigev_signo: ::std::os::raw::c_int,
    pub sigev_value: sigval,
    pub sigev_notify_function: ::std::option::Option<unsafe extern "C" fn(arg1: sigval)>,
    pub sigev_notify_attributes: *mut pthread_attr_t,
}
#[test]
fn bindgen_test_layout_sigevent() {
    assert_eq!(
        ::std::mem::size_of::<sigevent>(),
        32usize,
        concat!("Size of: ", stringify!(sigevent))
    );
    assert_eq!(
        ::std::mem::align_of::<sigevent>(),
        8usize,
        concat!("Alignment of ", stringify!(sigevent))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigevent>())).sigev_notify as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sigevent),
            "::",
            stringify!(sigev_notify)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigevent>())).sigev_signo as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(sigevent),
            "::",
            stringify!(sigev_signo)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigevent>())).sigev_value as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(sigevent),
            "::",
            stringify!(sigev_value)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigevent>())).sigev_notify_function as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(sigevent),
            "::",
            stringify!(sigev_notify_function)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<sigevent>())).sigev_notify_attributes as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(sigevent),
            "::",
            stringify!(sigev_notify_attributes)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct __siginfo {
    pub si_signo: ::std::os::raw::c_int,
    pub si_errno: ::std::os::raw::c_int,
    pub si_code: ::std::os::raw::c_int,
    pub si_pid: pid_t,
    pub si_uid: uid_t,
    pub si_status: ::std::os::raw::c_int,
    pub si_addr: *mut ::std::os::raw::c_void,
    pub si_value: sigval,
    pub si_band: ::std::os::raw::c_long,
    pub __pad: [::std::os::raw::c_ulong; 7usize],
}
#[test]
fn bindgen_test_layout___siginfo() {
    assert_eq!(
        ::std::mem::size_of::<__siginfo>(),
        104usize,
        concat!("Size of: ", stringify!(__siginfo))
    );
    assert_eq!(
        ::std::mem::align_of::<__siginfo>(),
        8usize,
        concat!("Alignment of ", stringify!(__siginfo))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__siginfo>())).si_signo as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__siginfo),
            "::",
            stringify!(si_signo)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__siginfo>())).si_errno as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(__siginfo),
            "::",
            stringify!(si_errno)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__siginfo>())).si_code as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__siginfo),
            "::",
            stringify!(si_code)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__siginfo>())).si_pid as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(__siginfo),
            "::",
            stringify!(si_pid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__siginfo>())).si_uid as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__siginfo),
            "::",
            stringify!(si_uid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__siginfo>())).si_status as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(__siginfo),
            "::",
            stringify!(si_status)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__siginfo>())).si_addr as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__siginfo),
            "::",
            stringify!(si_addr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__siginfo>())).si_value as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__siginfo),
            "::",
            stringify!(si_value)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__siginfo>())).si_band as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__siginfo),
            "::",
            stringify!(si_band)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__siginfo>())).__pad as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(__siginfo),
            "::",
            stringify!(__pad)
        )
    );
}
pub type siginfo_t = __siginfo;
#[repr(C)]
#[derive(Copy, Clone)]
pub union __sigaction_u {
    pub __sa_handler: ::std::option::Option<unsafe extern "C" fn(arg1: ::std::os::raw::c_int)>,
    pub __sa_sigaction: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: ::std::os::raw::c_int,
            arg2: *mut __siginfo,
            arg3: *mut ::std::os::raw::c_void,
        ),
    >,
}
#[test]
fn bindgen_test_layout___sigaction_u() {
    assert_eq!(
        ::std::mem::size_of::<__sigaction_u>(),
        8usize,
        concat!("Size of: ", stringify!(__sigaction_u))
    );
    assert_eq!(
        ::std::mem::align_of::<__sigaction_u>(),
        8usize,
        concat!("Alignment of ", stringify!(__sigaction_u))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sigaction_u>())).__sa_handler as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__sigaction_u),
            "::",
            stringify!(__sa_handler)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sigaction_u>())).__sa_sigaction as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__sigaction_u),
            "::",
            stringify!(__sa_sigaction)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct __sigaction {
    pub __sigaction_u: __sigaction_u,
    pub sa_tramp: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut ::std::os::raw::c_void,
            arg2: ::std::os::raw::c_int,
            arg3: ::std::os::raw::c_int,
            arg4: *mut siginfo_t,
            arg5: *mut ::std::os::raw::c_void,
        ),
    >,
    pub sa_mask: sigset_t,
    pub sa_flags: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout___sigaction() {
    assert_eq!(
        ::std::mem::size_of::<__sigaction>(),
        24usize,
        concat!("Size of: ", stringify!(__sigaction))
    );
    assert_eq!(
        ::std::mem::align_of::<__sigaction>(),
        8usize,
        concat!("Alignment of ", stringify!(__sigaction))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sigaction>())).__sigaction_u as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__sigaction),
            "::",
            stringify!(__sigaction_u)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sigaction>())).sa_tramp as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__sigaction),
            "::",
            stringify!(sa_tramp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sigaction>())).sa_mask as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__sigaction),
            "::",
            stringify!(sa_mask)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sigaction>())).sa_flags as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(__sigaction),
            "::",
            stringify!(sa_flags)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct sigaction {
    pub __sigaction_u: __sigaction_u,
    pub sa_mask: sigset_t,
    pub sa_flags: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_sigaction() {
    assert_eq!(
        ::std::mem::size_of::<sigaction>(),
        16usize,
        concat!("Size of: ", stringify!(sigaction))
    );
    assert_eq!(
        ::std::mem::align_of::<sigaction>(),
        8usize,
        concat!("Alignment of ", stringify!(sigaction))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigaction>())).__sigaction_u as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sigaction),
            "::",
            stringify!(__sigaction_u)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigaction>())).sa_mask as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(sigaction),
            "::",
            stringify!(sa_mask)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigaction>())).sa_flags as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(sigaction),
            "::",
            stringify!(sa_flags)
        )
    );
}
pub type sig_t = ::std::option::Option<unsafe extern "C" fn(arg1: ::std::os::raw::c_int)>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct sigvec {
    pub sv_handler: ::std::option::Option<unsafe extern "C" fn(arg1: ::std::os::raw::c_int)>,
    pub sv_mask: ::std::os::raw::c_int,
    pub sv_flags: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_sigvec() {
    assert_eq!(
        ::std::mem::size_of::<sigvec>(),
        16usize,
        concat!("Size of: ", stringify!(sigvec))
    );
    assert_eq!(
        ::std::mem::align_of::<sigvec>(),
        8usize,
        concat!("Alignment of ", stringify!(sigvec))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigvec>())).sv_handler as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sigvec),
            "::",
            stringify!(sv_handler)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigvec>())).sv_mask as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(sigvec),
            "::",
            stringify!(sv_mask)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigvec>())).sv_flags as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(sigvec),
            "::",
            stringify!(sv_flags)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct sigstack {
    pub ss_sp: *mut ::std::os::raw::c_char,
    pub ss_onstack: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_sigstack() {
    assert_eq!(
        ::std::mem::size_of::<sigstack>(),
        16usize,
        concat!("Size of: ", stringify!(sigstack))
    );
    assert_eq!(
        ::std::mem::align_of::<sigstack>(),
        8usize,
        concat!("Alignment of ", stringify!(sigstack))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigstack>())).ss_sp as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sigstack),
            "::",
            stringify!(ss_sp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigstack>())).ss_onstack as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(sigstack),
            "::",
            stringify!(ss_onstack)
        )
    );
}
extern "C" {
    pub fn signal(
        arg1: ::std::os::raw::c_int,
        arg2: ::std::option::Option<unsafe extern "C" fn(arg1: ::std::os::raw::c_int)>,
    ) -> ::std::option::Option<
        unsafe extern "C" fn(
            arg1: ::std::os::raw::c_int,
            arg2: ::std::option::Option<unsafe extern "C" fn(arg1: ::std::os::raw::c_int)>,
        ),
    >;
}
pub type int_least8_t = i8;
pub type int_least16_t = i16;
pub type int_least32_t = i32;
pub type int_least64_t = i64;
pub type uint_least8_t = u8;
pub type uint_least16_t = u16;
pub type uint_least32_t = u32;
pub type uint_least64_t = u64;
pub type int_fast8_t = i8;
pub type int_fast16_t = i16;
pub type int_fast32_t = i32;
pub type int_fast64_t = i64;
pub type uint_fast8_t = u8;
pub type uint_fast16_t = u16;
pub type uint_fast32_t = u32;
pub type uint_fast64_t = u64;
pub type intmax_t = ::std::os::raw::c_long;
pub type uintmax_t = ::std::os::raw::c_ulong;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct timeval {
    pub tv_sec: __darwin_time_t,
    pub tv_usec: __darwin_suseconds_t,
}
#[test]
fn bindgen_test_layout_timeval() {
    assert_eq!(
        ::std::mem::size_of::<timeval>(),
        16usize,
        concat!("Size of: ", stringify!(timeval))
    );
    assert_eq!(
        ::std::mem::align_of::<timeval>(),
        8usize,
        concat!("Alignment of ", stringify!(timeval))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<timeval>())).tv_sec as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(timeval),
            "::",
            stringify!(tv_sec)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<timeval>())).tv_usec as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(timeval),
            "::",
            stringify!(tv_usec)
        )
    );
}
pub type rlim_t = __uint64_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rusage {
    pub ru_utime: timeval,
    pub ru_stime: timeval,
    pub ru_maxrss: ::std::os::raw::c_long,
    pub ru_ixrss: ::std::os::raw::c_long,
    pub ru_idrss: ::std::os::raw::c_long,
    pub ru_isrss: ::std::os::raw::c_long,
    pub ru_minflt: ::std::os::raw::c_long,
    pub ru_majflt: ::std::os::raw::c_long,
    pub ru_nswap: ::std::os::raw::c_long,
    pub ru_inblock: ::std::os::raw::c_long,
    pub ru_oublock: ::std::os::raw::c_long,
    pub ru_msgsnd: ::std::os::raw::c_long,
    pub ru_msgrcv: ::std::os::raw::c_long,
    pub ru_nsignals: ::std::os::raw::c_long,
    pub ru_nvcsw: ::std::os::raw::c_long,
    pub ru_nivcsw: ::std::os::raw::c_long,
}
#[test]
fn bindgen_test_layout_rusage() {
    assert_eq!(
        ::std::mem::size_of::<rusage>(),
        144usize,
        concat!("Size of: ", stringify!(rusage))
    );
    assert_eq!(
        ::std::mem::align_of::<rusage>(),
        8usize,
        concat!("Alignment of ", stringify!(rusage))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage>())).ru_utime as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage),
            "::",
            stringify!(ru_utime)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage>())).ru_stime as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage),
            "::",
            stringify!(ru_stime)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage>())).ru_maxrss as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage),
            "::",
            stringify!(ru_maxrss)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage>())).ru_ixrss as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage),
            "::",
            stringify!(ru_ixrss)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage>())).ru_idrss as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage),
            "::",
            stringify!(ru_idrss)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage>())).ru_isrss as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage),
            "::",
            stringify!(ru_isrss)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage>())).ru_minflt as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage),
            "::",
            stringify!(ru_minflt)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage>())).ru_majflt as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage),
            "::",
            stringify!(ru_majflt)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage>())).ru_nswap as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage),
            "::",
            stringify!(ru_nswap)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage>())).ru_inblock as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage),
            "::",
            stringify!(ru_inblock)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage>())).ru_oublock as *const _ as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage),
            "::",
            stringify!(ru_oublock)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage>())).ru_msgsnd as *const _ as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage),
            "::",
            stringify!(ru_msgsnd)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage>())).ru_msgrcv as *const _ as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage),
            "::",
            stringify!(ru_msgrcv)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage>())).ru_nsignals as *const _ as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage),
            "::",
            stringify!(ru_nsignals)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage>())).ru_nvcsw as *const _ as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage),
            "::",
            stringify!(ru_nvcsw)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage>())).ru_nivcsw as *const _ as usize },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage),
            "::",
            stringify!(ru_nivcsw)
        )
    );
}
pub type rusage_info_t = *mut ::std::os::raw::c_void;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rusage_info_v0 {
    pub ri_uuid: [u8; 16usize],
    pub ri_user_time: u64,
    pub ri_system_time: u64,
    pub ri_pkg_idle_wkups: u64,
    pub ri_interrupt_wkups: u64,
    pub ri_pageins: u64,
    pub ri_wired_size: u64,
    pub ri_resident_size: u64,
    pub ri_phys_footprint: u64,
    pub ri_proc_start_abstime: u64,
    pub ri_proc_exit_abstime: u64,
}
#[test]
fn bindgen_test_layout_rusage_info_v0() {
    assert_eq!(
        ::std::mem::size_of::<rusage_info_v0>(),
        96usize,
        concat!("Size of: ", stringify!(rusage_info_v0))
    );
    assert_eq!(
        ::std::mem::align_of::<rusage_info_v0>(),
        8usize,
        concat!("Alignment of ", stringify!(rusage_info_v0))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v0>())).ri_uuid as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v0),
            "::",
            stringify!(ri_uuid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v0>())).ri_user_time as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v0),
            "::",
            stringify!(ri_user_time)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v0>())).ri_system_time as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v0),
            "::",
            stringify!(ri_system_time)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v0>())).ri_pkg_idle_wkups as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v0),
            "::",
            stringify!(ri_pkg_idle_wkups)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v0>())).ri_interrupt_wkups as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v0),
            "::",
            stringify!(ri_interrupt_wkups)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v0>())).ri_pageins as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v0),
            "::",
            stringify!(ri_pageins)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v0>())).ri_wired_size as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v0),
            "::",
            stringify!(ri_wired_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v0>())).ri_resident_size as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v0),
            "::",
            stringify!(ri_resident_size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v0>())).ri_phys_footprint as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v0),
            "::",
            stringify!(ri_phys_footprint)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v0>())).ri_proc_start_abstime as *const _ as usize
        },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v0),
            "::",
            stringify!(ri_proc_start_abstime)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v0>())).ri_proc_exit_abstime as *const _ as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v0),
            "::",
            stringify!(ri_proc_exit_abstime)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rusage_info_v1 {
    pub ri_uuid: [u8; 16usize],
    pub ri_user_time: u64,
    pub ri_system_time: u64,
    pub ri_pkg_idle_wkups: u64,
    pub ri_interrupt_wkups: u64,
    pub ri_pageins: u64,
    pub ri_wired_size: u64,
    pub ri_resident_size: u64,
    pub ri_phys_footprint: u64,
    pub ri_proc_start_abstime: u64,
    pub ri_proc_exit_abstime: u64,
    pub ri_child_user_time: u64,
    pub ri_child_system_time: u64,
    pub ri_child_pkg_idle_wkups: u64,
    pub ri_child_interrupt_wkups: u64,
    pub ri_child_pageins: u64,
    pub ri_child_elapsed_abstime: u64,
}
#[test]
fn bindgen_test_layout_rusage_info_v1() {
    assert_eq!(
        ::std::mem::size_of::<rusage_info_v1>(),
        144usize,
        concat!("Size of: ", stringify!(rusage_info_v1))
    );
    assert_eq!(
        ::std::mem::align_of::<rusage_info_v1>(),
        8usize,
        concat!("Alignment of ", stringify!(rusage_info_v1))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v1>())).ri_uuid as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v1),
            "::",
            stringify!(ri_uuid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v1>())).ri_user_time as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v1),
            "::",
            stringify!(ri_user_time)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v1>())).ri_system_time as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v1),
            "::",
            stringify!(ri_system_time)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v1>())).ri_pkg_idle_wkups as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v1),
            "::",
            stringify!(ri_pkg_idle_wkups)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v1>())).ri_interrupt_wkups as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v1),
            "::",
            stringify!(ri_interrupt_wkups)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v1>())).ri_pageins as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v1),
            "::",
            stringify!(ri_pageins)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v1>())).ri_wired_size as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v1),
            "::",
            stringify!(ri_wired_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v1>())).ri_resident_size as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v1),
            "::",
            stringify!(ri_resident_size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v1>())).ri_phys_footprint as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v1),
            "::",
            stringify!(ri_phys_footprint)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v1>())).ri_proc_start_abstime as *const _ as usize
        },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v1),
            "::",
            stringify!(ri_proc_start_abstime)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v1>())).ri_proc_exit_abstime as *const _ as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v1),
            "::",
            stringify!(ri_proc_exit_abstime)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v1>())).ri_child_user_time as *const _ as usize
        },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v1),
            "::",
            stringify!(ri_child_user_time)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v1>())).ri_child_system_time as *const _ as usize
        },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v1),
            "::",
            stringify!(ri_child_system_time)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v1>())).ri_child_pkg_idle_wkups as *const _ as usize
        },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v1),
            "::",
            stringify!(ri_child_pkg_idle_wkups)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v1>())).ri_child_interrupt_wkups as *const _ as usize
        },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v1),
            "::",
            stringify!(ri_child_interrupt_wkups)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v1>())).ri_child_pageins as *const _ as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v1),
            "::",
            stringify!(ri_child_pageins)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v1>())).ri_child_elapsed_abstime as *const _ as usize
        },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v1),
            "::",
            stringify!(ri_child_elapsed_abstime)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rusage_info_v2 {
    pub ri_uuid: [u8; 16usize],
    pub ri_user_time: u64,
    pub ri_system_time: u64,
    pub ri_pkg_idle_wkups: u64,
    pub ri_interrupt_wkups: u64,
    pub ri_pageins: u64,
    pub ri_wired_size: u64,
    pub ri_resident_size: u64,
    pub ri_phys_footprint: u64,
    pub ri_proc_start_abstime: u64,
    pub ri_proc_exit_abstime: u64,
    pub ri_child_user_time: u64,
    pub ri_child_system_time: u64,
    pub ri_child_pkg_idle_wkups: u64,
    pub ri_child_interrupt_wkups: u64,
    pub ri_child_pageins: u64,
    pub ri_child_elapsed_abstime: u64,
    pub ri_diskio_bytesread: u64,
    pub ri_diskio_byteswritten: u64,
}
#[test]
fn bindgen_test_layout_rusage_info_v2() {
    assert_eq!(
        ::std::mem::size_of::<rusage_info_v2>(),
        160usize,
        concat!("Size of: ", stringify!(rusage_info_v2))
    );
    assert_eq!(
        ::std::mem::align_of::<rusage_info_v2>(),
        8usize,
        concat!("Alignment of ", stringify!(rusage_info_v2))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v2>())).ri_uuid as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v2),
            "::",
            stringify!(ri_uuid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v2>())).ri_user_time as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v2),
            "::",
            stringify!(ri_user_time)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v2>())).ri_system_time as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v2),
            "::",
            stringify!(ri_system_time)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v2>())).ri_pkg_idle_wkups as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v2),
            "::",
            stringify!(ri_pkg_idle_wkups)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v2>())).ri_interrupt_wkups as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v2),
            "::",
            stringify!(ri_interrupt_wkups)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v2>())).ri_pageins as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v2),
            "::",
            stringify!(ri_pageins)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v2>())).ri_wired_size as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v2),
            "::",
            stringify!(ri_wired_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v2>())).ri_resident_size as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v2),
            "::",
            stringify!(ri_resident_size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v2>())).ri_phys_footprint as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v2),
            "::",
            stringify!(ri_phys_footprint)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v2>())).ri_proc_start_abstime as *const _ as usize
        },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v2),
            "::",
            stringify!(ri_proc_start_abstime)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v2>())).ri_proc_exit_abstime as *const _ as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v2),
            "::",
            stringify!(ri_proc_exit_abstime)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v2>())).ri_child_user_time as *const _ as usize
        },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v2),
            "::",
            stringify!(ri_child_user_time)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v2>())).ri_child_system_time as *const _ as usize
        },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v2),
            "::",
            stringify!(ri_child_system_time)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v2>())).ri_child_pkg_idle_wkups as *const _ as usize
        },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v2),
            "::",
            stringify!(ri_child_pkg_idle_wkups)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v2>())).ri_child_interrupt_wkups as *const _ as usize
        },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v2),
            "::",
            stringify!(ri_child_interrupt_wkups)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v2>())).ri_child_pageins as *const _ as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v2),
            "::",
            stringify!(ri_child_pageins)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v2>())).ri_child_elapsed_abstime as *const _ as usize
        },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v2),
            "::",
            stringify!(ri_child_elapsed_abstime)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v2>())).ri_diskio_bytesread as *const _ as usize
        },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v2),
            "::",
            stringify!(ri_diskio_bytesread)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v2>())).ri_diskio_byteswritten as *const _ as usize
        },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v2),
            "::",
            stringify!(ri_diskio_byteswritten)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rusage_info_v3 {
    pub ri_uuid: [u8; 16usize],
    pub ri_user_time: u64,
    pub ri_system_time: u64,
    pub ri_pkg_idle_wkups: u64,
    pub ri_interrupt_wkups: u64,
    pub ri_pageins: u64,
    pub ri_wired_size: u64,
    pub ri_resident_size: u64,
    pub ri_phys_footprint: u64,
    pub ri_proc_start_abstime: u64,
    pub ri_proc_exit_abstime: u64,
    pub ri_child_user_time: u64,
    pub ri_child_system_time: u64,
    pub ri_child_pkg_idle_wkups: u64,
    pub ri_child_interrupt_wkups: u64,
    pub ri_child_pageins: u64,
    pub ri_child_elapsed_abstime: u64,
    pub ri_diskio_bytesread: u64,
    pub ri_diskio_byteswritten: u64,
    pub ri_cpu_time_qos_default: u64,
    pub ri_cpu_time_qos_maintenance: u64,
    pub ri_cpu_time_qos_background: u64,
    pub ri_cpu_time_qos_utility: u64,
    pub ri_cpu_time_qos_legacy: u64,
    pub ri_cpu_time_qos_user_initiated: u64,
    pub ri_cpu_time_qos_user_interactive: u64,
    pub ri_billed_system_time: u64,
    pub ri_serviced_system_time: u64,
}
#[test]
fn bindgen_test_layout_rusage_info_v3() {
    assert_eq!(
        ::std::mem::size_of::<rusage_info_v3>(),
        232usize,
        concat!("Size of: ", stringify!(rusage_info_v3))
    );
    assert_eq!(
        ::std::mem::align_of::<rusage_info_v3>(),
        8usize,
        concat!("Alignment of ", stringify!(rusage_info_v3))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v3>())).ri_uuid as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_uuid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v3>())).ri_user_time as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_user_time)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v3>())).ri_system_time as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_system_time)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v3>())).ri_pkg_idle_wkups as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_pkg_idle_wkups)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v3>())).ri_interrupt_wkups as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_interrupt_wkups)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v3>())).ri_pageins as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_pageins)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v3>())).ri_wired_size as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_wired_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v3>())).ri_resident_size as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_resident_size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v3>())).ri_phys_footprint as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_phys_footprint)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v3>())).ri_proc_start_abstime as *const _ as usize
        },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_proc_start_abstime)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v3>())).ri_proc_exit_abstime as *const _ as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_proc_exit_abstime)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v3>())).ri_child_user_time as *const _ as usize
        },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_child_user_time)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v3>())).ri_child_system_time as *const _ as usize
        },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_child_system_time)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v3>())).ri_child_pkg_idle_wkups as *const _ as usize
        },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_child_pkg_idle_wkups)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v3>())).ri_child_interrupt_wkups as *const _ as usize
        },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_child_interrupt_wkups)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v3>())).ri_child_pageins as *const _ as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_child_pageins)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v3>())).ri_child_elapsed_abstime as *const _ as usize
        },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_child_elapsed_abstime)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v3>())).ri_diskio_bytesread as *const _ as usize
        },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_diskio_bytesread)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v3>())).ri_diskio_byteswritten as *const _ as usize
        },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_diskio_byteswritten)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v3>())).ri_cpu_time_qos_default as *const _ as usize
        },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_cpu_time_qos_default)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v3>())).ri_cpu_time_qos_maintenance as *const _
                as usize
        },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_cpu_time_qos_maintenance)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v3>())).ri_cpu_time_qos_background as *const _
                as usize
        },
        176usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_cpu_time_qos_background)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v3>())).ri_cpu_time_qos_utility as *const _ as usize
        },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_cpu_time_qos_utility)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v3>())).ri_cpu_time_qos_legacy as *const _ as usize
        },
        192usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_cpu_time_qos_legacy)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v3>())).ri_cpu_time_qos_user_initiated as *const _
                as usize
        },
        200usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_cpu_time_qos_user_initiated)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v3>())).ri_cpu_time_qos_user_interactive as *const _
                as usize
        },
        208usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_cpu_time_qos_user_interactive)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v3>())).ri_billed_system_time as *const _ as usize
        },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_billed_system_time)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v3>())).ri_serviced_system_time as *const _ as usize
        },
        224usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_serviced_system_time)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rusage_info_v4 {
    pub ri_uuid: [u8; 16usize],
    pub ri_user_time: u64,
    pub ri_system_time: u64,
    pub ri_pkg_idle_wkups: u64,
    pub ri_interrupt_wkups: u64,
    pub ri_pageins: u64,
    pub ri_wired_size: u64,
    pub ri_resident_size: u64,
    pub ri_phys_footprint: u64,
    pub ri_proc_start_abstime: u64,
    pub ri_proc_exit_abstime: u64,
    pub ri_child_user_time: u64,
    pub ri_child_system_time: u64,
    pub ri_child_pkg_idle_wkups: u64,
    pub ri_child_interrupt_wkups: u64,
    pub ri_child_pageins: u64,
    pub ri_child_elapsed_abstime: u64,
    pub ri_diskio_bytesread: u64,
    pub ri_diskio_byteswritten: u64,
    pub ri_cpu_time_qos_default: u64,
    pub ri_cpu_time_qos_maintenance: u64,
    pub ri_cpu_time_qos_background: u64,
    pub ri_cpu_time_qos_utility: u64,
    pub ri_cpu_time_qos_legacy: u64,
    pub ri_cpu_time_qos_user_initiated: u64,
    pub ri_cpu_time_qos_user_interactive: u64,
    pub ri_billed_system_time: u64,
    pub ri_serviced_system_time: u64,
    pub ri_logical_writes: u64,
    pub ri_lifetime_max_phys_footprint: u64,
    pub ri_instructions: u64,
    pub ri_cycles: u64,
    pub ri_billed_energy: u64,
    pub ri_serviced_energy: u64,
    pub ri_interval_max_phys_footprint: u64,
    pub ri_runnable_time: u64,
}
#[test]
fn bindgen_test_layout_rusage_info_v4() {
    assert_eq!(
        ::std::mem::size_of::<rusage_info_v4>(),
        296usize,
        concat!("Size of: ", stringify!(rusage_info_v4))
    );
    assert_eq!(
        ::std::mem::align_of::<rusage_info_v4>(),
        8usize,
        concat!("Alignment of ", stringify!(rusage_info_v4))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v4>())).ri_uuid as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_uuid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v4>())).ri_user_time as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_user_time)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v4>())).ri_system_time as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_system_time)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_pkg_idle_wkups as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_pkg_idle_wkups)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_interrupt_wkups as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_interrupt_wkups)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v4>())).ri_pageins as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_pageins)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v4>())).ri_wired_size as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_wired_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v4>())).ri_resident_size as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_resident_size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_phys_footprint as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_phys_footprint)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_proc_start_abstime as *const _ as usize
        },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_proc_start_abstime)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_proc_exit_abstime as *const _ as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_proc_exit_abstime)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_child_user_time as *const _ as usize
        },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_child_user_time)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_child_system_time as *const _ as usize
        },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_child_system_time)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_child_pkg_idle_wkups as *const _ as usize
        },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_child_pkg_idle_wkups)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_child_interrupt_wkups as *const _ as usize
        },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_child_interrupt_wkups)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v4>())).ri_child_pageins as *const _ as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_child_pageins)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_child_elapsed_abstime as *const _ as usize
        },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_child_elapsed_abstime)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_diskio_bytesread as *const _ as usize
        },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_diskio_bytesread)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_diskio_byteswritten as *const _ as usize
        },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_diskio_byteswritten)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_cpu_time_qos_default as *const _ as usize
        },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_cpu_time_qos_default)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_cpu_time_qos_maintenance as *const _
                as usize
        },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_cpu_time_qos_maintenance)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_cpu_time_qos_background as *const _
                as usize
        },
        176usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_cpu_time_qos_background)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_cpu_time_qos_utility as *const _ as usize
        },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_cpu_time_qos_utility)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_cpu_time_qos_legacy as *const _ as usize
        },
        192usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_cpu_time_qos_legacy)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_cpu_time_qos_user_initiated as *const _
                as usize
        },
        200usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_cpu_time_qos_user_initiated)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_cpu_time_qos_user_interactive as *const _
                as usize
        },
        208usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_cpu_time_qos_user_interactive)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_billed_system_time as *const _ as usize
        },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_billed_system_time)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_serviced_system_time as *const _ as usize
        },
        224usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_serviced_system_time)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_logical_writes as *const _ as usize
        },
        232usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_logical_writes)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_lifetime_max_phys_footprint as *const _
                as usize
        },
        240usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_lifetime_max_phys_footprint)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v4>())).ri_instructions as *const _ as usize },
        248usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_instructions)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v4>())).ri_cycles as *const _ as usize },
        256usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_cycles)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v4>())).ri_billed_energy as *const _ as usize },
        264usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_billed_energy)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_serviced_energy as *const _ as usize
        },
        272usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_serviced_energy)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_interval_max_phys_footprint as *const _
                as usize
        },
        280usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_interval_max_phys_footprint)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v4>())).ri_runnable_time as *const _ as usize },
        288usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_runnable_time)
        )
    );
}
pub type rusage_info_current = rusage_info_v4;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rlimit {
    pub rlim_cur: rlim_t,
    pub rlim_max: rlim_t,
}
#[test]
fn bindgen_test_layout_rlimit() {
    assert_eq!(
        ::std::mem::size_of::<rlimit>(),
        16usize,
        concat!("Size of: ", stringify!(rlimit))
    );
    assert_eq!(
        ::std::mem::align_of::<rlimit>(),
        8usize,
        concat!("Alignment of ", stringify!(rlimit))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rlimit>())).rlim_cur as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(rlimit),
            "::",
            stringify!(rlim_cur)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rlimit>())).rlim_max as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(rlimit),
            "::",
            stringify!(rlim_max)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct proc_rlimit_control_wakeupmon {
    pub wm_flags: u32,
    pub wm_rate: i32,
}
#[test]
fn bindgen_test_layout_proc_rlimit_control_wakeupmon() {
    assert_eq!(
        ::std::mem::size_of::<proc_rlimit_control_wakeupmon>(),
        8usize,
        concat!("Size of: ", stringify!(proc_rlimit_control_wakeupmon))
    );
    assert_eq!(
        ::std::mem::align_of::<proc_rlimit_control_wakeupmon>(),
        4usize,
        concat!("Alignment of ", stringify!(proc_rlimit_control_wakeupmon))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<proc_rlimit_control_wakeupmon>())).wm_flags as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(proc_rlimit_control_wakeupmon),
            "::",
            stringify!(wm_flags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<proc_rlimit_control_wakeupmon>())).wm_rate as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(proc_rlimit_control_wakeupmon),
            "::",
            stringify!(wm_rate)
        )
    );
}
extern "C" {
    pub fn getpriority(arg1: ::std::os::raw::c_int, arg2: id_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getiopolicy_np(
        arg1: ::std::os::raw::c_int,
        arg2: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getrlimit(arg1: ::std::os::raw::c_int, arg2: *mut rlimit) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getrusage(arg1: ::std::os::raw::c_int, arg2: *mut rusage) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setpriority(
        arg1: ::std::os::raw::c_int,
        arg2: id_t,
        arg3: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setiopolicy_np(
        arg1: ::std::os::raw::c_int,
        arg2: ::std::os::raw::c_int,
        arg3: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setrlimit(arg1: ::std::os::raw::c_int, arg2: *const rlimit) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union wait {
    pub w_status: ::std::os::raw::c_int,
    pub w_T: wait__bindgen_ty_1,
    pub w_S: wait__bindgen_ty_2,
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct wait__bindgen_ty_1 {
    pub _bitfield_align_1: [u16; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
#[test]
fn bindgen_test_layout_wait__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<wait__bindgen_ty_1>(),
        4usize,
        concat!("Size of: ", stringify!(wait__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<wait__bindgen_ty_1>(),
        4usize,
        concat!("Alignment of ", stringify!(wait__bindgen_ty_1))
    );
}
impl wait__bindgen_ty_1 {
    #[inline]
    pub fn w_Termsig(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 7u8) as u32) }
    }
    #[inline]
    pub fn set_w_Termsig(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 7u8, val as u64)
        }
    }
    #[inline]
    pub fn w_Coredump(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(7usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_w_Coredump(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(7usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn w_Retcode(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_w_Retcode(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn w_Filler(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(16usize, 16u8) as u32) }
    }
    #[inline]
    pub fn set_w_Filler(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(16usize, 16u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        w_Termsig: ::std::os::raw::c_uint,
        w_Coredump: ::std::os::raw::c_uint,
        w_Retcode: ::std::os::raw::c_uint,
        w_Filler: ::std::os::raw::c_uint,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 7u8, {
            let w_Termsig: u32 = unsafe { ::std::mem::transmute(w_Termsig) };
            w_Termsig as u64
        });
        __bindgen_bitfield_unit.set(7usize, 1u8, {
            let w_Coredump: u32 = unsafe { ::std::mem::transmute(w_Coredump) };
            w_Coredump as u64
        });
        __bindgen_bitfield_unit.set(8usize, 8u8, {
            let w_Retcode: u32 = unsafe { ::std::mem::transmute(w_Retcode) };
            w_Retcode as u64
        });
        __bindgen_bitfield_unit.set(16usize, 16u8, {
            let w_Filler: u32 = unsafe { ::std::mem::transmute(w_Filler) };
            w_Filler as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct wait__bindgen_ty_2 {
    pub _bitfield_align_1: [u16; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
#[test]
fn bindgen_test_layout_wait__bindgen_ty_2() {
    assert_eq!(
        ::std::mem::size_of::<wait__bindgen_ty_2>(),
        4usize,
        concat!("Size of: ", stringify!(wait__bindgen_ty_2))
    );
    assert_eq!(
        ::std::mem::align_of::<wait__bindgen_ty_2>(),
        4usize,
        concat!("Alignment of ", stringify!(wait__bindgen_ty_2))
    );
}
impl wait__bindgen_ty_2 {
    #[inline]
    pub fn w_Stopval(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_w_Stopval(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn w_Stopsig(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_w_Stopsig(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn w_Filler(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(16usize, 16u8) as u32) }
    }
    #[inline]
    pub fn set_w_Filler(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(16usize, 16u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        w_Stopval: ::std::os::raw::c_uint,
        w_Stopsig: ::std::os::raw::c_uint,
        w_Filler: ::std::os::raw::c_uint,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 8u8, {
            let w_Stopval: u32 = unsafe { ::std::mem::transmute(w_Stopval) };
            w_Stopval as u64
        });
        __bindgen_bitfield_unit.set(8usize, 8u8, {
            let w_Stopsig: u32 = unsafe { ::std::mem::transmute(w_Stopsig) };
            w_Stopsig as u64
        });
        __bindgen_bitfield_unit.set(16usize, 16u8, {
            let w_Filler: u32 = unsafe { ::std::mem::transmute(w_Filler) };
            w_Filler as u64
        });
        __bindgen_bitfield_unit
    }
}
#[test]
fn bindgen_test_layout_wait() {
    assert_eq!(
        ::std::mem::size_of::<wait>(),
        4usize,
        concat!("Size of: ", stringify!(wait))
    );
    assert_eq!(
        ::std::mem::align_of::<wait>(),
        4usize,
        concat!("Alignment of ", stringify!(wait))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<wait>())).w_status as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(wait),
            "::",
            stringify!(w_status)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<wait>())).w_T as *const _ as usize },
        0usize,
        concat!("Offset of field: ", stringify!(wait), "::", stringify!(w_T))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<wait>())).w_S as *const _ as usize },
        0usize,
        concat!("Offset of field: ", stringify!(wait), "::", stringify!(w_S))
    );
}
extern "C" {
    pub fn wait(arg1: *mut ::std::os::raw::c_int) -> pid_t;
}
extern "C" {
    pub fn waitpid(
        arg1: pid_t,
        arg2: *mut ::std::os::raw::c_int,
        arg3: ::std::os::raw::c_int,
    ) -> pid_t;
}
extern "C" {
    pub fn waitid(
        arg1: idtype_t,
        arg2: id_t,
        arg3: *mut siginfo_t,
        arg4: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn wait3(
        arg1: *mut ::std::os::raw::c_int,
        arg2: ::std::os::raw::c_int,
        arg3: *mut rusage,
    ) -> pid_t;
}
extern "C" {
    pub fn wait4(
        arg1: pid_t,
        arg2: *mut ::std::os::raw::c_int,
        arg3: ::std::os::raw::c_int,
        arg4: *mut rusage,
    ) -> pid_t;
}
extern "C" {
    pub fn alloca(arg1: ::std::os::raw::c_ulong) -> *mut ::std::os::raw::c_void;
}
pub type ct_rune_t = __darwin_ct_rune_t;
pub type rune_t = __darwin_rune_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct div_t {
    pub quot: ::std::os::raw::c_int,
    pub rem: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_div_t() {
    assert_eq!(
        ::std::mem::size_of::<div_t>(),
        8usize,
        concat!("Size of: ", stringify!(div_t))
    );
    assert_eq!(
        ::std::mem::align_of::<div_t>(),
        4usize,
        concat!("Alignment of ", stringify!(div_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<div_t>())).quot as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(div_t),
            "::",
            stringify!(quot)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<div_t>())).rem as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(div_t),
            "::",
            stringify!(rem)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ldiv_t {
    pub quot: ::std::os::raw::c_long,
    pub rem: ::std::os::raw::c_long,
}
#[test]
fn bindgen_test_layout_ldiv_t() {
    assert_eq!(
        ::std::mem::size_of::<ldiv_t>(),
        16usize,
        concat!("Size of: ", stringify!(ldiv_t))
    );
    assert_eq!(
        ::std::mem::align_of::<ldiv_t>(),
        8usize,
        concat!("Alignment of ", stringify!(ldiv_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ldiv_t>())).quot as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(ldiv_t),
            "::",
            stringify!(quot)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ldiv_t>())).rem as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(ldiv_t),
            "::",
            stringify!(rem)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct lldiv_t {
    pub quot: ::std::os::raw::c_longlong,
    pub rem: ::std::os::raw::c_longlong,
}
#[test]
fn bindgen_test_layout_lldiv_t() {
    assert_eq!(
        ::std::mem::size_of::<lldiv_t>(),
        16usize,
        concat!("Size of: ", stringify!(lldiv_t))
    );
    assert_eq!(
        ::std::mem::align_of::<lldiv_t>(),
        8usize,
        concat!("Alignment of ", stringify!(lldiv_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<lldiv_t>())).quot as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lldiv_t),
            "::",
            stringify!(quot)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<lldiv_t>())).rem as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(lldiv_t),
            "::",
            stringify!(rem)
        )
    );
}
extern "C" {
    pub static mut __mb_cur_max: ::std::os::raw::c_int;
}
extern "C" {
    pub fn malloc(__size: ::std::os::raw::c_ulong) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn calloc(
        __count: ::std::os::raw::c_ulong,
        __size: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn free(arg1: *mut ::std::os::raw::c_void);
}
extern "C" {
    pub fn realloc(
        __ptr: *mut ::std::os::raw::c_void,
        __size: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn valloc(arg1: size_t) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn aligned_alloc(__alignment: size_t, __size: size_t) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn posix_memalign(
        __memptr: *mut *mut ::std::os::raw::c_void,
        __alignment: size_t,
        __size: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn abort();
}
extern "C" {
    pub fn abs(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn atexit(arg1: ::std::option::Option<unsafe extern "C" fn()>) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn atof(arg1: *const ::std::os::raw::c_char) -> f64;
}
extern "C" {
    pub fn atoi(arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn atol(arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn atoll(arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_longlong;
}
extern "C" {
    pub fn bsearch(
        __key: *const ::std::os::raw::c_void,
        __base: *const ::std::os::raw::c_void,
        __nel: size_t,
        __width: size_t,
        __compar: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: *const ::std::os::raw::c_void,
                arg2: *const ::std::os::raw::c_void,
            ) -> ::std::os::raw::c_int,
        >,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn div(arg1: ::std::os::raw::c_int, arg2: ::std::os::raw::c_int) -> div_t;
}
extern "C" {
    pub fn exit(arg1: ::std::os::raw::c_int);
}
extern "C" {
    pub fn getenv(arg1: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn labs(arg1: ::std::os::raw::c_long) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn ldiv(arg1: ::std::os::raw::c_long, arg2: ::std::os::raw::c_long) -> ldiv_t;
}
extern "C" {
    pub fn llabs(arg1: ::std::os::raw::c_longlong) -> ::std::os::raw::c_longlong;
}
extern "C" {
    pub fn lldiv(arg1: ::std::os::raw::c_longlong, arg2: ::std::os::raw::c_longlong) -> lldiv_t;
}
extern "C" {
    pub fn mblen(__s: *const ::std::os::raw::c_char, __n: size_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mbstowcs(
        arg1: *mut wchar_t,
        arg2: *const ::std::os::raw::c_char,
        arg3: size_t,
    ) -> size_t;
}
extern "C" {
    pub fn mbtowc(
        arg1: *mut wchar_t,
        arg2: *const ::std::os::raw::c_char,
        arg3: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn qsort(
        __base: *mut ::std::os::raw::c_void,
        __nel: size_t,
        __width: size_t,
        __compar: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: *const ::std::os::raw::c_void,
                arg2: *const ::std::os::raw::c_void,
            ) -> ::std::os::raw::c_int,
        >,
    );
}
extern "C" {
    pub fn rand() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn srand(arg1: ::std::os::raw::c_uint);
}
extern "C" {
    pub fn strtod(
        arg1: *const ::std::os::raw::c_char,
        arg2: *mut *mut ::std::os::raw::c_char,
    ) -> f64;
}
extern "C" {
    pub fn strtof(
        arg1: *const ::std::os::raw::c_char,
        arg2: *mut *mut ::std::os::raw::c_char,
    ) -> f32;
}
extern "C" {
    pub fn strtol(
        __str: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
        __base: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn strtold(
        arg1: *const ::std::os::raw::c_char,
        arg2: *mut *mut ::std::os::raw::c_char,
    ) -> u128;
}
extern "C" {
    pub fn strtoll(
        __str: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
        __base: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_longlong;
}
extern "C" {
    pub fn strtoul(
        __str: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
        __base: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_ulong;
}
extern "C" {
    pub fn strtoull(
        __str: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
        __base: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_ulonglong;
}
extern "C" {
    pub fn system(arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn wcstombs(
        arg1: *mut ::std::os::raw::c_char,
        arg2: *const wchar_t,
        arg3: size_t,
    ) -> size_t;
}
extern "C" {
    pub fn wctomb(arg1: *mut ::std::os::raw::c_char, arg2: wchar_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _Exit(arg1: ::std::os::raw::c_int);
}
extern "C" {
    pub fn a64l(arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn drand48() -> f64;
}
extern "C" {
    pub fn ecvt(
        arg1: f64,
        arg2: ::std::os::raw::c_int,
        arg3: *mut ::std::os::raw::c_int,
        arg4: *mut ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn erand48(arg1: *mut ::std::os::raw::c_ushort) -> f64;
}
extern "C" {
    pub fn fcvt(
        arg1: f64,
        arg2: ::std::os::raw::c_int,
        arg3: *mut ::std::os::raw::c_int,
        arg4: *mut ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn gcvt(
        arg1: f64,
        arg2: ::std::os::raw::c_int,
        arg3: *mut ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn getsubopt(
        arg1: *mut *mut ::std::os::raw::c_char,
        arg2: *const *mut ::std::os::raw::c_char,
        arg3: *mut *mut ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn grantpt(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn initstate(
        arg1: ::std::os::raw::c_uint,
        arg2: *mut ::std::os::raw::c_char,
        arg3: size_t,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn jrand48(arg1: *mut ::std::os::raw::c_ushort) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn l64a(arg1: ::std::os::raw::c_long) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn lcong48(arg1: *mut ::std::os::raw::c_ushort);
}
extern "C" {
    pub fn lrand48() -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn mktemp(arg1: *mut ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn mkstemp(arg1: *mut ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mrand48() -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn nrand48(arg1: *mut ::std::os::raw::c_ushort) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn posix_openpt(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ptsname(arg1: ::std::os::raw::c_int) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn ptsname_r(
        fildes: ::std::os::raw::c_int,
        buffer: *mut ::std::os::raw::c_char,
        buflen: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn putenv(arg1: *mut ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn random() -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn rand_r(arg1: *mut ::std::os::raw::c_uint) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}_realpath$DARWIN_EXTSN"]
    pub fn realpath(
        arg1: *const ::std::os::raw::c_char,
        arg2: *mut ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn seed48(arg1: *mut ::std::os::raw::c_ushort) -> *mut ::std::os::raw::c_ushort;
}
extern "C" {
    pub fn setenv(
        __name: *const ::std::os::raw::c_char,
        __value: *const ::std::os::raw::c_char,
        __overwrite: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setkey(arg1: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn setstate(arg1: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn srand48(arg1: ::std::os::raw::c_long);
}
extern "C" {
    pub fn srandom(arg1: ::std::os::raw::c_uint);
}
extern "C" {
    pub fn unlockpt(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn unsetenv(arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
pub type dev_t = __darwin_dev_t;
pub type mode_t = __darwin_mode_t;
extern "C" {
    pub fn arc4random() -> u32;
}
extern "C" {
    pub fn arc4random_addrandom(arg1: *mut ::std::os::raw::c_uchar, arg2: ::std::os::raw::c_int);
}
extern "C" {
    pub fn arc4random_buf(__buf: *mut ::std::os::raw::c_void, __nbytes: size_t);
}
extern "C" {
    pub fn arc4random_stir();
}
extern "C" {
    pub fn arc4random_uniform(__upper_bound: u32) -> u32;
}
extern "C" {
    pub fn atexit_b(arg1: *mut ::std::os::raw::c_void) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bsearch_b(
        __key: *const ::std::os::raw::c_void,
        __base: *const ::std::os::raw::c_void,
        __nel: size_t,
        __width: size_t,
        __compar: *mut ::std::os::raw::c_void,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn cgetcap(
        arg1: *mut ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
        arg3: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn cgetclose() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn cgetent(
        arg1: *mut *mut ::std::os::raw::c_char,
        arg2: *mut *mut ::std::os::raw::c_char,
        arg3: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn cgetfirst(
        arg1: *mut *mut ::std::os::raw::c_char,
        arg2: *mut *mut ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn cgetmatch(
        arg1: *const ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn cgetnext(
        arg1: *mut *mut ::std::os::raw::c_char,
        arg2: *mut *mut ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn cgetnum(
        arg1: *mut ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
        arg3: *mut ::std::os::raw::c_long,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn cgetset(arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn cgetstr(
        arg1: *mut ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
        arg3: *mut *mut ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn cgetustr(
        arg1: *mut ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
        arg3: *mut *mut ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}_daemon$1050"]
    pub fn daemon(
        arg1: ::std::os::raw::c_int,
        arg2: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn devname(arg1: dev_t, arg2: mode_t) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn devname_r(
        arg1: dev_t,
        arg2: mode_t,
        buf: *mut ::std::os::raw::c_char,
        len: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn getbsize(
        arg1: *mut ::std::os::raw::c_int,
        arg2: *mut ::std::os::raw::c_long,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn getloadavg(arg1: *mut f64, arg2: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getprogname() -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn setprogname(arg1: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn heapsort(
        __base: *mut ::std::os::raw::c_void,
        __nel: size_t,
        __width: size_t,
        __compar: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: *const ::std::os::raw::c_void,
                arg2: *const ::std::os::raw::c_void,
            ) -> ::std::os::raw::c_int,
        >,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn heapsort_b(
        __base: *mut ::std::os::raw::c_void,
        __nel: size_t,
        __width: size_t,
        __compar: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mergesort(
        __base: *mut ::std::os::raw::c_void,
        __nel: size_t,
        __width: size_t,
        __compar: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: *const ::std::os::raw::c_void,
                arg2: *const ::std::os::raw::c_void,
            ) -> ::std::os::raw::c_int,
        >,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mergesort_b(
        __base: *mut ::std::os::raw::c_void,
        __nel: size_t,
        __width: size_t,
        __compar: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn psort(
        __base: *mut ::std::os::raw::c_void,
        __nel: size_t,
        __width: size_t,
        __compar: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: *const ::std::os::raw::c_void,
                arg2: *const ::std::os::raw::c_void,
            ) -> ::std::os::raw::c_int,
        >,
    );
}
extern "C" {
    pub fn psort_b(
        __base: *mut ::std::os::raw::c_void,
        __nel: size_t,
        __width: size_t,
        __compar: *mut ::std::os::raw::c_void,
    );
}
extern "C" {
    pub fn psort_r(
        __base: *mut ::std::os::raw::c_void,
        __nel: size_t,
        __width: size_t,
        arg1: *mut ::std::os::raw::c_void,
        __compar: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: *mut ::std::os::raw::c_void,
                arg2: *const ::std::os::raw::c_void,
                arg3: *const ::std::os::raw::c_void,
            ) -> ::std::os::raw::c_int,
        >,
    );
}
extern "C" {
    pub fn qsort_b(
        __base: *mut ::std::os::raw::c_void,
        __nel: size_t,
        __width: size_t,
        __compar: *mut ::std::os::raw::c_void,
    );
}
extern "C" {
    pub fn qsort_r(
        __base: *mut ::std::os::raw::c_void,
        __nel: size_t,
        __width: size_t,
        arg1: *mut ::std::os::raw::c_void,
        __compar: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: *mut ::std::os::raw::c_void,
                arg2: *const ::std::os::raw::c_void,
                arg3: *const ::std::os::raw::c_void,
            ) -> ::std::os::raw::c_int,
        >,
    );
}
extern "C" {
    pub fn radixsort(
        __base: *mut *const ::std::os::raw::c_uchar,
        __nel: ::std::os::raw::c_int,
        __table: *const ::std::os::raw::c_uchar,
        __endbyte: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rpmatch(arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sradixsort(
        __base: *mut *const ::std::os::raw::c_uchar,
        __nel: ::std::os::raw::c_int,
        __table: *const ::std::os::raw::c_uchar,
        __endbyte: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sranddev();
}
extern "C" {
    pub fn srandomdev();
}
extern "C" {
    pub fn reallocf(
        __ptr: *mut ::std::os::raw::c_void,
        __size: size_t,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn strtoq(
        __str: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
        __base: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_longlong;
}
extern "C" {
    pub fn strtouq(
        __str: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
        __base: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_ulonglong;
}
extern "C" {
    pub static mut suboptarg: *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn __assert_rtn(
        arg1: *const ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
        arg3: ::std::os::raw::c_int,
        arg4: *const ::std::os::raw::c_char,
    );
}
pub type wint_t = __darwin_wint_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _RuneEntry {
    pub __min: __darwin_rune_t,
    pub __max: __darwin_rune_t,
    pub __map: __darwin_rune_t,
    pub __types: *mut __uint32_t,
}
#[test]
fn bindgen_test_layout__RuneEntry() {
    assert_eq!(
        ::std::mem::size_of::<_RuneEntry>(),
        24usize,
        concat!("Size of: ", stringify!(_RuneEntry))
    );
    assert_eq!(
        ::std::mem::align_of::<_RuneEntry>(),
        8usize,
        concat!("Alignment of ", stringify!(_RuneEntry))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_RuneEntry>())).__min as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_RuneEntry),
            "::",
            stringify!(__min)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_RuneEntry>())).__max as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(_RuneEntry),
            "::",
            stringify!(__max)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_RuneEntry>())).__map as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_RuneEntry),
            "::",
            stringify!(__map)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_RuneEntry>())).__types as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_RuneEntry),
            "::",
            stringify!(__types)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _RuneRange {
    pub __nranges: ::std::os::raw::c_int,
    pub __ranges: *mut _RuneEntry,
}
#[test]
fn bindgen_test_layout__RuneRange() {
    assert_eq!(
        ::std::mem::size_of::<_RuneRange>(),
        16usize,
        concat!("Size of: ", stringify!(_RuneRange))
    );
    assert_eq!(
        ::std::mem::align_of::<_RuneRange>(),
        8usize,
        concat!("Alignment of ", stringify!(_RuneRange))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_RuneRange>())).__nranges as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_RuneRange),
            "::",
            stringify!(__nranges)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_RuneRange>())).__ranges as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_RuneRange),
            "::",
            stringify!(__ranges)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _RuneCharClass {
    pub __name: [::std::os::raw::c_char; 14usize],
    pub __mask: __uint32_t,
}
#[test]
fn bindgen_test_layout__RuneCharClass() {
    assert_eq!(
        ::std::mem::size_of::<_RuneCharClass>(),
        20usize,
        concat!("Size of: ", stringify!(_RuneCharClass))
    );
    assert_eq!(
        ::std::mem::align_of::<_RuneCharClass>(),
        4usize,
        concat!("Alignment of ", stringify!(_RuneCharClass))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_RuneCharClass>())).__name as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_RuneCharClass),
            "::",
            stringify!(__name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_RuneCharClass>())).__mask as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_RuneCharClass),
            "::",
            stringify!(__mask)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _RuneLocale {
    pub __magic: [::std::os::raw::c_char; 8usize],
    pub __encoding: [::std::os::raw::c_char; 32usize],
    pub __sgetrune: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *const ::std::os::raw::c_char,
            arg2: __darwin_size_t,
            arg3: *mut *const ::std::os::raw::c_char,
        ) -> __darwin_rune_t,
    >,
    pub __sputrune: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: __darwin_rune_t,
            arg2: *mut ::std::os::raw::c_char,
            arg3: __darwin_size_t,
            arg4: *mut *mut ::std::os::raw::c_char,
        ) -> ::std::os::raw::c_int,
    >,
    pub __invalid_rune: __darwin_rune_t,
    pub __runetype: [__uint32_t; 256usize],
    pub __maplower: [__darwin_rune_t; 256usize],
    pub __mapupper: [__darwin_rune_t; 256usize],
    pub __runetype_ext: _RuneRange,
    pub __maplower_ext: _RuneRange,
    pub __mapupper_ext: _RuneRange,
    pub __variable: *mut ::std::os::raw::c_void,
    pub __variable_len: ::std::os::raw::c_int,
    pub __ncharclasses: ::std::os::raw::c_int,
    pub __charclasses: *mut _RuneCharClass,
}
#[test]
fn bindgen_test_layout__RuneLocale() {
    assert_eq!(
        ::std::mem::size_of::<_RuneLocale>(),
        3208usize,
        concat!("Size of: ", stringify!(_RuneLocale))
    );
    assert_eq!(
        ::std::mem::align_of::<_RuneLocale>(),
        8usize,
        concat!("Alignment of ", stringify!(_RuneLocale))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_RuneLocale>())).__magic as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_RuneLocale),
            "::",
            stringify!(__magic)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_RuneLocale>())).__encoding as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_RuneLocale),
            "::",
            stringify!(__encoding)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_RuneLocale>())).__sgetrune as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(_RuneLocale),
            "::",
            stringify!(__sgetrune)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_RuneLocale>())).__sputrune as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(_RuneLocale),
            "::",
            stringify!(__sputrune)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_RuneLocale>())).__invalid_rune as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(_RuneLocale),
            "::",
            stringify!(__invalid_rune)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_RuneLocale>())).__runetype as *const _ as usize },
        60usize,
        concat!(
            "Offset of field: ",
            stringify!(_RuneLocale),
            "::",
            stringify!(__runetype)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_RuneLocale>())).__maplower as *const _ as usize },
        1084usize,
        concat!(
            "Offset of field: ",
            stringify!(_RuneLocale),
            "::",
            stringify!(__maplower)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_RuneLocale>())).__mapupper as *const _ as usize },
        2108usize,
        concat!(
            "Offset of field: ",
            stringify!(_RuneLocale),
            "::",
            stringify!(__mapupper)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_RuneLocale>())).__runetype_ext as *const _ as usize },
        3136usize,
        concat!(
            "Offset of field: ",
            stringify!(_RuneLocale),
            "::",
            stringify!(__runetype_ext)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_RuneLocale>())).__maplower_ext as *const _ as usize },
        3152usize,
        concat!(
            "Offset of field: ",
            stringify!(_RuneLocale),
            "::",
            stringify!(__maplower_ext)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_RuneLocale>())).__mapupper_ext as *const _ as usize },
        3168usize,
        concat!(
            "Offset of field: ",
            stringify!(_RuneLocale),
            "::",
            stringify!(__mapupper_ext)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_RuneLocale>())).__variable as *const _ as usize },
        3184usize,
        concat!(
            "Offset of field: ",
            stringify!(_RuneLocale),
            "::",
            stringify!(__variable)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_RuneLocale>())).__variable_len as *const _ as usize },
        3192usize,
        concat!(
            "Offset of field: ",
            stringify!(_RuneLocale),
            "::",
            stringify!(__variable_len)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_RuneLocale>())).__ncharclasses as *const _ as usize },
        3196usize,
        concat!(
            "Offset of field: ",
            stringify!(_RuneLocale),
            "::",
            stringify!(__ncharclasses)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_RuneLocale>())).__charclasses as *const _ as usize },
        3200usize,
        concat!(
            "Offset of field: ",
            stringify!(_RuneLocale),
            "::",
            stringify!(__charclasses)
        )
    );
}
extern "C" {
    pub static mut _DefaultRuneLocale: _RuneLocale;
}
extern "C" {
    pub static mut _CurrentRuneLocale: *mut _RuneLocale;
}
extern "C" {
    pub fn ___runetype(arg1: __darwin_ct_rune_t) -> ::std::os::raw::c_ulong;
}
extern "C" {
    pub fn ___tolower(arg1: __darwin_ct_rune_t) -> __darwin_ct_rune_t;
}
extern "C" {
    pub fn ___toupper(arg1: __darwin_ct_rune_t) -> __darwin_ct_rune_t;
}
extern "C" {
    pub fn __maskrune(
        arg1: __darwin_ct_rune_t,
        arg2: ::std::os::raw::c_ulong,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __toupper(arg1: __darwin_ct_rune_t) -> __darwin_ct_rune_t;
}
extern "C" {
    pub fn __tolower(arg1: __darwin_ct_rune_t) -> __darwin_ct_rune_t;
}
pub type u_char = ::std::os::raw::c_uchar;
pub type u_short = ::std::os::raw::c_ushort;
pub type u_int = ::std::os::raw::c_uint;
pub type u_long = ::std::os::raw::c_ulong;
pub type ushort = ::std::os::raw::c_ushort;
pub type uint = ::std::os::raw::c_uint;
pub type u_quad_t = u_int64_t;
pub type quad_t = i64;
pub type qaddr_t = *mut quad_t;
pub type caddr_t = *mut ::std::os::raw::c_char;
pub type daddr_t = i32;
pub type fixpt_t = u_int32_t;
pub type blkcnt_t = __darwin_blkcnt_t;
pub type blksize_t = __darwin_blksize_t;
pub type gid_t = __darwin_gid_t;
pub type in_addr_t = __uint32_t;
pub type in_port_t = __uint16_t;
pub type ino_t = __darwin_ino_t;
pub type ino64_t = __darwin_ino64_t;
pub type key_t = __int32_t;
pub type nlink_t = __uint16_t;
pub type off_t = __darwin_off_t;
pub type segsz_t = i32;
pub type swblk_t = i32;
pub type clock_t = __darwin_clock_t;
pub type ssize_t = __darwin_ssize_t;
pub type time_t = __darwin_time_t;
pub type useconds_t = __darwin_useconds_t;
pub type suseconds_t = __darwin_suseconds_t;
pub type rsize_t = __darwin_size_t;
pub type errno_t = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct fd_set {
    pub fds_bits: [__int32_t; 32usize],
}
#[test]
fn bindgen_test_layout_fd_set() {
    assert_eq!(
        ::std::mem::size_of::<fd_set>(),
        128usize,
        concat!("Size of: ", stringify!(fd_set))
    );
    assert_eq!(
        ::std::mem::align_of::<fd_set>(),
        4usize,
        concat!("Alignment of ", stringify!(fd_set))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<fd_set>())).fds_bits as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(fd_set),
            "::",
            stringify!(fds_bits)
        )
    );
}
extern "C" {
    pub fn __darwin_check_fd_set_overflow(
        arg1: ::std::os::raw::c_int,
        arg2: *const ::std::os::raw::c_void,
        arg3: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
pub type fd_mask = __int32_t;
pub type pthread_cond_t = __darwin_pthread_cond_t;
pub type pthread_condattr_t = __darwin_pthread_condattr_t;
pub type pthread_mutex_t = __darwin_pthread_mutex_t;
pub type pthread_mutexattr_t = __darwin_pthread_mutexattr_t;
pub type pthread_once_t = __darwin_pthread_once_t;
pub type pthread_rwlock_t = __darwin_pthread_rwlock_t;
pub type pthread_rwlockattr_t = __darwin_pthread_rwlockattr_t;
pub type pthread_t = __darwin_pthread_t;
pub type pthread_key_t = __darwin_pthread_key_t;
pub type fsblkcnt_t = __darwin_fsblkcnt_t;
pub type fsfilcnt_t = __darwin_fsfilcnt_t;
pub type uut16 = ::std::os::raw::c_ushort;
pub type uut32 = ::std::os::raw::c_uint;
pub type uut64 = ::std::os::raw::c_ulonglong;
pub type ust16 = ::std::os::raw::c_short;
pub type ust32 = ::std::os::raw::c_int;
pub type ust64 = ::std::os::raw::c_longlong;
#[repr(C)]
#[derive(Copy, Clone)]
pub union utAny {
    pub v8: ::std::os::raw::c_uchar,
    pub v16: ::std::os::raw::c_ushort,
    pub v32: ::std::os::raw::c_uint,
    pub v64: ::std::os::raw::c_ulonglong,
}
#[test]
fn bindgen_test_layout_utAny() {
    assert_eq!(
        ::std::mem::size_of::<utAny>(),
        8usize,
        concat!("Size of: ", stringify!(utAny))
    );
    assert_eq!(
        ::std::mem::align_of::<utAny>(),
        8usize,
        concat!("Alignment of ", stringify!(utAny))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<utAny>())).v8 as *const _ as usize },
        0usize,
        concat!("Offset of field: ", stringify!(utAny), "::", stringify!(v8))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<utAny>())).v16 as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(utAny),
            "::",
            stringify!(v16)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<utAny>())).v32 as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(utAny),
            "::",
            stringify!(v32)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<utAny>())).v64 as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(utAny),
            "::",
            stringify!(v64)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _ut80 {
    pub Low: ::std::os::raw::c_ulonglong,
    pub High: ::std::os::raw::c_ushort,
}
#[test]
fn bindgen_test_layout__ut80() {
    assert_eq!(
        ::std::mem::size_of::<_ut80>(),
        16usize,
        concat!("Size of: ", stringify!(_ut80))
    );
    assert_eq!(
        ::std::mem::align_of::<_ut80>(),
        8usize,
        concat!("Alignment of ", stringify!(_ut80))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_ut80>())).Low as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_ut80),
            "::",
            stringify!(Low)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_ut80>())).High as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_ut80),
            "::",
            stringify!(High)
        )
    );
}
pub type ut80 = _ut80;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _ut96 {
    pub Low: ::std::os::raw::c_ulonglong,
    pub High: ::std::os::raw::c_uint,
}
#[test]
fn bindgen_test_layout__ut96() {
    assert_eq!(
        ::std::mem::size_of::<_ut96>(),
        16usize,
        concat!("Size of: ", stringify!(_ut96))
    );
    assert_eq!(
        ::std::mem::align_of::<_ut96>(),
        8usize,
        concat!("Alignment of ", stringify!(_ut96))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_ut96>())).Low as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_ut96),
            "::",
            stringify!(Low)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_ut96>())).High as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_ut96),
            "::",
            stringify!(High)
        )
    );
}
pub type ut96 = _ut96;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _ut128 {
    pub Low: ::std::os::raw::c_ulonglong,
    pub High: ::std::os::raw::c_longlong,
}
#[test]
fn bindgen_test_layout__ut128() {
    assert_eq!(
        ::std::mem::size_of::<_ut128>(),
        16usize,
        concat!("Size of: ", stringify!(_ut128))
    );
    assert_eq!(
        ::std::mem::align_of::<_ut128>(),
        8usize,
        concat!("Alignment of ", stringify!(_ut128))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_ut128>())).Low as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_ut128),
            "::",
            stringify!(Low)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_ut128>())).High as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_ut128),
            "::",
            stringify!(High)
        )
    );
}
pub type ut128 = _ut128;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _ut256 {
    pub Low: ut128,
    pub High: ut128,
}
#[test]
fn bindgen_test_layout__ut256() {
    assert_eq!(
        ::std::mem::size_of::<_ut256>(),
        32usize,
        concat!("Size of: ", stringify!(_ut256))
    );
    assert_eq!(
        ::std::mem::align_of::<_ut256>(),
        8usize,
        concat!("Alignment of ", stringify!(_ut256))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_ut256>())).Low as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_ut256),
            "::",
            stringify!(Low)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_ut256>())).High as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_ut256),
            "::",
            stringify!(High)
        )
    );
}
pub type ut256 = _ut256;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _utX {
    pub v80: ut80,
    pub v96: ut96,
    pub v128: ut128,
    pub v256: ut256,
}
#[test]
fn bindgen_test_layout__utX() {
    assert_eq!(
        ::std::mem::size_of::<_utX>(),
        80usize,
        concat!("Size of: ", stringify!(_utX))
    );
    assert_eq!(
        ::std::mem::align_of::<_utX>(),
        8usize,
        concat!("Alignment of ", stringify!(_utX))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_utX>())).v80 as *const _ as usize },
        0usize,
        concat!("Offset of field: ", stringify!(_utX), "::", stringify!(v80))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_utX>())).v96 as *const _ as usize },
        16usize,
        concat!("Offset of field: ", stringify!(_utX), "::", stringify!(v96))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_utX>())).v128 as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(_utX),
            "::",
            stringify!(v128)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_utX>())).v256 as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(_utX),
            "::",
            stringify!(v256)
        )
    );
}
pub type utX = _utX;
pub type va_list = __darwin_va_list;
extern "C" {
    pub fn renameat(
        arg1: ::std::os::raw::c_int,
        arg2: *const ::std::os::raw::c_char,
        arg3: ::std::os::raw::c_int,
        arg4: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn renamex_np(
        arg1: *const ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
        arg3: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn renameatx_np(
        arg1: ::std::os::raw::c_int,
        arg2: *const ::std::os::raw::c_char,
        arg3: ::std::os::raw::c_int,
        arg4: *const ::std::os::raw::c_char,
        arg5: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
pub type fpos_t = __darwin_off_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __sbuf {
    pub _base: *mut ::std::os::raw::c_uchar,
    pub _size: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout___sbuf() {
    assert_eq!(
        ::std::mem::size_of::<__sbuf>(),
        16usize,
        concat!("Size of: ", stringify!(__sbuf))
    );
    assert_eq!(
        ::std::mem::align_of::<__sbuf>(),
        8usize,
        concat!("Alignment of ", stringify!(__sbuf))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sbuf>()))._base as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__sbuf),
            "::",
            stringify!(_base)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sbuf>()))._size as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__sbuf),
            "::",
            stringify!(_size)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __sFILEX {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __sFILE {
    pub _p: *mut ::std::os::raw::c_uchar,
    pub _r: ::std::os::raw::c_int,
    pub _w: ::std::os::raw::c_int,
    pub _flags: ::std::os::raw::c_short,
    pub _file: ::std::os::raw::c_short,
    pub _bf: __sbuf,
    pub _lbfsize: ::std::os::raw::c_int,
    pub _cookie: *mut ::std::os::raw::c_void,
    pub _close: ::std::option::Option<
        unsafe extern "C" fn(arg1: *mut ::std::os::raw::c_void) -> ::std::os::raw::c_int,
    >,
    pub _read: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut ::std::os::raw::c_void,
            arg2: *mut ::std::os::raw::c_char,
            arg3: ::std::os::raw::c_int,
        ) -> ::std::os::raw::c_int,
    >,
    pub _seek: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut ::std::os::raw::c_void,
            arg2: fpos_t,
            arg3: ::std::os::raw::c_int,
        ) -> fpos_t,
    >,
    pub _write: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut ::std::os::raw::c_void,
            arg2: *const ::std::os::raw::c_char,
            arg3: ::std::os::raw::c_int,
        ) -> ::std::os::raw::c_int,
    >,
    pub _ub: __sbuf,
    pub _extra: *mut __sFILEX,
    pub _ur: ::std::os::raw::c_int,
    pub _ubuf: [::std::os::raw::c_uchar; 3usize],
    pub _nbuf: [::std::os::raw::c_uchar; 1usize],
    pub _lb: __sbuf,
    pub _blksize: ::std::os::raw::c_int,
    pub _offset: fpos_t,
}
#[test]
fn bindgen_test_layout___sFILE() {
    assert_eq!(
        ::std::mem::size_of::<__sFILE>(),
        152usize,
        concat!("Size of: ", stringify!(__sFILE))
    );
    assert_eq!(
        ::std::mem::align_of::<__sFILE>(),
        8usize,
        concat!("Alignment of ", stringify!(__sFILE))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sFILE>()))._p as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__sFILE),
            "::",
            stringify!(_p)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sFILE>()))._r as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__sFILE),
            "::",
            stringify!(_r)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sFILE>()))._w as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(__sFILE),
            "::",
            stringify!(_w)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sFILE>()))._flags as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__sFILE),
            "::",
            stringify!(_flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sFILE>()))._file as *const _ as usize },
        18usize,
        concat!(
            "Offset of field: ",
            stringify!(__sFILE),
            "::",
            stringify!(_file)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sFILE>()))._bf as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__sFILE),
            "::",
            stringify!(_bf)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sFILE>()))._lbfsize as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__sFILE),
            "::",
            stringify!(_lbfsize)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sFILE>()))._cookie as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(__sFILE),
            "::",
            stringify!(_cookie)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sFILE>()))._close as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(__sFILE),
            "::",
            stringify!(_close)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sFILE>()))._read as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(__sFILE),
            "::",
            stringify!(_read)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sFILE>()))._seek as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(__sFILE),
            "::",
            stringify!(_seek)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sFILE>()))._write as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(__sFILE),
            "::",
            stringify!(_write)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sFILE>()))._ub as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(__sFILE),
            "::",
            stringify!(_ub)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sFILE>()))._extra as *const _ as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(__sFILE),
            "::",
            stringify!(_extra)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sFILE>()))._ur as *const _ as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(__sFILE),
            "::",
            stringify!(_ur)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sFILE>()))._ubuf as *const _ as usize },
        116usize,
        concat!(
            "Offset of field: ",
            stringify!(__sFILE),
            "::",
            stringify!(_ubuf)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sFILE>()))._nbuf as *const _ as usize },
        119usize,
        concat!(
            "Offset of field: ",
            stringify!(__sFILE),
            "::",
            stringify!(_nbuf)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sFILE>()))._lb as *const _ as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(__sFILE),
            "::",
            stringify!(_lb)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sFILE>()))._blksize as *const _ as usize },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(__sFILE),
            "::",
            stringify!(_blksize)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sFILE>()))._offset as *const _ as usize },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(__sFILE),
            "::",
            stringify!(_offset)
        )
    );
}
pub type FILE = __sFILE;
extern "C" {
    pub static mut __stdinp: *mut FILE;
}
extern "C" {
    pub static mut __stdoutp: *mut FILE;
}
extern "C" {
    pub static mut __stderrp: *mut FILE;
}
extern "C" {
    pub fn clearerr(arg1: *mut FILE);
}
extern "C" {
    pub fn fclose(arg1: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn feof(arg1: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ferror(arg1: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fflush(arg1: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fgetc(arg1: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fgetpos(arg1: *mut FILE, arg2: *mut fpos_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fgets(
        arg1: *mut ::std::os::raw::c_char,
        arg2: ::std::os::raw::c_int,
        arg3: *mut FILE,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn fopen(
        __filename: *const ::std::os::raw::c_char,
        __mode: *const ::std::os::raw::c_char,
    ) -> *mut FILE;
}
extern "C" {
    pub fn fprintf(
        arg1: *mut FILE,
        arg2: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fputc(arg1: ::std::os::raw::c_int, arg2: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fputs(arg1: *const ::std::os::raw::c_char, arg2: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fread(
        __ptr: *mut ::std::os::raw::c_void,
        __size: ::std::os::raw::c_ulong,
        __nitems: ::std::os::raw::c_ulong,
        __stream: *mut FILE,
    ) -> ::std::os::raw::c_ulong;
}
extern "C" {
    pub fn freopen(
        arg1: *const ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
        arg3: *mut FILE,
    ) -> *mut FILE;
}
extern "C" {
    pub fn fscanf(
        arg1: *mut FILE,
        arg2: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fseek(
        arg1: *mut FILE,
        arg2: ::std::os::raw::c_long,
        arg3: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fsetpos(arg1: *mut FILE, arg2: *const fpos_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ftell(arg1: *mut FILE) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn fwrite(
        __ptr: *const ::std::os::raw::c_void,
        __size: ::std::os::raw::c_ulong,
        __nitems: ::std::os::raw::c_ulong,
        __stream: *mut FILE,
    ) -> ::std::os::raw::c_ulong;
}
extern "C" {
    pub fn getc(arg1: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getchar() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn gets(arg1: *mut ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn perror(arg1: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn printf(arg1: *const ::std::os::raw::c_char, ...) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn putc(arg1: ::std::os::raw::c_int, arg2: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn putchar(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn puts(arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn remove(arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rename(
        __old: *const ::std::os::raw::c_char,
        __new: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rewind(arg1: *mut FILE);
}
extern "C" {
    pub fn scanf(arg1: *const ::std::os::raw::c_char, ...) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setbuf(arg1: *mut FILE, arg2: *mut ::std::os::raw::c_char);
}
extern "C" {
    pub fn setvbuf(
        arg1: *mut FILE,
        arg2: *mut ::std::os::raw::c_char,
        arg3: ::std::os::raw::c_int,
        arg4: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sprintf(
        arg1: *mut ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sscanf(
        arg1: *const ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn tmpfile() -> *mut FILE;
}
extern "C" {
    pub fn tmpnam(arg1: *mut ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn ungetc(arg1: ::std::os::raw::c_int, arg2: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vfprintf(
        arg1: *mut FILE,
        arg2: *const ::std::os::raw::c_char,
        arg3: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vprintf(
        arg1: *const ::std::os::raw::c_char,
        arg2: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vsprintf(
        arg1: *mut ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
        arg3: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ctermid(arg1: *mut ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn fdopen(arg1: ::std::os::raw::c_int, arg2: *const ::std::os::raw::c_char) -> *mut FILE;
}
extern "C" {
    pub fn fileno(arg1: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pclose(arg1: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn popen(
        arg1: *const ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
    ) -> *mut FILE;
}
extern "C" {
    pub fn __srget(arg1: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __svfscanf(
        arg1: *mut FILE,
        arg2: *const ::std::os::raw::c_char,
        arg3: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __swbuf(arg1: ::std::os::raw::c_int, arg2: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn flockfile(arg1: *mut FILE);
}
extern "C" {
    pub fn ftrylockfile(arg1: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn funlockfile(arg1: *mut FILE);
}
extern "C" {
    pub fn getc_unlocked(arg1: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getchar_unlocked() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn putc_unlocked(arg1: ::std::os::raw::c_int, arg2: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn putchar_unlocked(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getw(arg1: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn putw(arg1: ::std::os::raw::c_int, arg2: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn tempnam(
        __dir: *const ::std::os::raw::c_char,
        __prefix: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn fseeko(
        __stream: *mut FILE,
        __offset: off_t,
        __whence: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ftello(__stream: *mut FILE) -> off_t;
}
extern "C" {
    pub fn snprintf(
        __str: *mut ::std::os::raw::c_char,
        __size: ::std::os::raw::c_ulong,
        __format: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vfscanf(
        __stream: *mut FILE,
        __format: *const ::std::os::raw::c_char,
        arg1: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vscanf(
        __format: *const ::std::os::raw::c_char,
        arg1: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vsnprintf(
        __str: *mut ::std::os::raw::c_char,
        __size: ::std::os::raw::c_ulong,
        __format: *const ::std::os::raw::c_char,
        arg1: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vsscanf(
        __str: *const ::std::os::raw::c_char,
        __format: *const ::std::os::raw::c_char,
        arg1: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn dprintf(
        arg1: ::std::os::raw::c_int,
        arg2: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vdprintf(
        arg1: ::std::os::raw::c_int,
        arg2: *const ::std::os::raw::c_char,
        arg3: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getdelim(
        __linep: *mut *mut ::std::os::raw::c_char,
        __linecapp: *mut size_t,
        __delimiter: ::std::os::raw::c_int,
        __stream: *mut FILE,
    ) -> ssize_t;
}
extern "C" {
    pub fn getline(
        __linep: *mut *mut ::std::os::raw::c_char,
        __linecapp: *mut size_t,
        __stream: *mut FILE,
    ) -> ssize_t;
}
extern "C" {
    pub fn fmemopen(
        __buf: *mut ::std::os::raw::c_void,
        __size: size_t,
        __mode: *const ::std::os::raw::c_char,
    ) -> *mut FILE;
}
extern "C" {
    pub fn open_memstream(
        __bufp: *mut *mut ::std::os::raw::c_char,
        __sizep: *mut size_t,
    ) -> *mut FILE;
}
extern "C" {
    pub static sys_nerr: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut sys_errlist: [*const ::std::os::raw::c_char; 0usize];
}
extern "C" {
    pub fn asprintf(
        arg1: *mut *mut ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ctermid_r(arg1: *mut ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn fgetln(arg1: *mut FILE, arg2: *mut size_t) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn fmtcheck(
        arg1: *const ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn fpurge(arg1: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setbuffer(
        arg1: *mut FILE,
        arg2: *mut ::std::os::raw::c_char,
        arg3: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn setlinebuf(arg1: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vasprintf(
        arg1: *mut *mut ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
        arg3: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn zopen(
        arg1: *const ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
        arg3: ::std::os::raw::c_int,
    ) -> *mut FILE;
}
extern "C" {
    pub fn funopen(
        arg1: *const ::std::os::raw::c_void,
        arg2: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: *mut ::std::os::raw::c_void,
                arg2: *mut ::std::os::raw::c_char,
                arg3: ::std::os::raw::c_int,
            ) -> ::std::os::raw::c_int,
        >,
        arg3: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: *mut ::std::os::raw::c_void,
                arg2: *const ::std::os::raw::c_char,
                arg3: ::std::os::raw::c_int,
            ) -> ::std::os::raw::c_int,
        >,
        arg4: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: *mut ::std::os::raw::c_void,
                arg2: fpos_t,
                arg3: ::std::os::raw::c_int,
            ) -> fpos_t,
        >,
        arg5: ::std::option::Option<
            unsafe extern "C" fn(arg1: *mut ::std::os::raw::c_void) -> ::std::os::raw::c_int,
        >,
    ) -> *mut FILE;
}
extern "C" {
    pub fn __sprintf_chk(
        arg1: *mut ::std::os::raw::c_char,
        arg2: ::std::os::raw::c_int,
        arg3: size_t,
        arg4: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __snprintf_chk(
        arg1: *mut ::std::os::raw::c_char,
        arg2: size_t,
        arg3: ::std::os::raw::c_int,
        arg4: size_t,
        arg5: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __vsprintf_chk(
        arg1: *mut ::std::os::raw::c_char,
        arg2: ::std::os::raw::c_int,
        arg3: size_t,
        arg4: *const ::std::os::raw::c_char,
        arg5: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __vsnprintf_chk(
        arg1: *mut ::std::os::raw::c_char,
        arg2: size_t,
        arg3: ::std::os::raw::c_int,
        arg4: size_t,
        arg5: *const ::std::os::raw::c_char,
        arg6: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn memchr(
        __s: *const ::std::os::raw::c_void,
        __c: ::std::os::raw::c_int,
        __n: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn memcmp(
        __s1: *const ::std::os::raw::c_void,
        __s2: *const ::std::os::raw::c_void,
        __n: ::std::os::raw::c_ulong,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn memcpy(
        __dst: *mut ::std::os::raw::c_void,
        __src: *const ::std::os::raw::c_void,
        __n: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn memmove(
        __dst: *mut ::std::os::raw::c_void,
        __src: *const ::std::os::raw::c_void,
        __len: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn memset(
        __b: *mut ::std::os::raw::c_void,
        __c: ::std::os::raw::c_int,
        __len: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn strcat(
        __s1: *mut ::std::os::raw::c_char,
        __s2: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strchr(
        __s: *const ::std::os::raw::c_char,
        __c: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strcmp(
        __s1: *const ::std::os::raw::c_char,
        __s2: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn strcoll(
        __s1: *const ::std::os::raw::c_char,
        __s2: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn strcpy(
        __dst: *mut ::std::os::raw::c_char,
        __src: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strcspn(
        __s: *const ::std::os::raw::c_char,
        __charset: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_ulong;
}
extern "C" {
    pub fn strerror(__errnum: ::std::os::raw::c_int) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strlen(__s: *const ::std::os::raw::c_char) -> ::std::os::raw::c_ulong;
}
extern "C" {
    pub fn strncat(
        __s1: *mut ::std::os::raw::c_char,
        __s2: *const ::std::os::raw::c_char,
        __n: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strncmp(
        __s1: *const ::std::os::raw::c_char,
        __s2: *const ::std::os::raw::c_char,
        __n: ::std::os::raw::c_ulong,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn strncpy(
        __dst: *mut ::std::os::raw::c_char,
        __src: *const ::std::os::raw::c_char,
        __n: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strpbrk(
        __s: *const ::std::os::raw::c_char,
        __charset: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strrchr(
        __s: *const ::std::os::raw::c_char,
        __c: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strspn(
        __s: *const ::std::os::raw::c_char,
        __charset: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_ulong;
}
extern "C" {
    pub fn strstr(
        __big: *const ::std::os::raw::c_char,
        __little: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strtok(
        __str: *mut ::std::os::raw::c_char,
        __sep: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strxfrm(
        __s1: *mut ::std::os::raw::c_char,
        __s2: *const ::std::os::raw::c_char,
        __n: ::std::os::raw::c_ulong,
    ) -> ::std::os::raw::c_ulong;
}
extern "C" {
    pub fn strtok_r(
        __str: *mut ::std::os::raw::c_char,
        __sep: *const ::std::os::raw::c_char,
        __lasts: *mut *mut ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strerror_r(
        __errnum: ::std::os::raw::c_int,
        __strerrbuf: *mut ::std::os::raw::c_char,
        __buflen: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn strdup(__s1: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn memccpy(
        __dst: *mut ::std::os::raw::c_void,
        __src: *const ::std::os::raw::c_void,
        __c: ::std::os::raw::c_int,
        __n: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn stpcpy(
        __dst: *mut ::std::os::raw::c_char,
        __src: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn stpncpy(
        __dst: *mut ::std::os::raw::c_char,
        __src: *const ::std::os::raw::c_char,
        __n: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strndup(
        __s1: *const ::std::os::raw::c_char,
        __n: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strnlen(__s1: *const ::std::os::raw::c_char, __n: size_t) -> size_t;
}
extern "C" {
    pub fn strsignal(__sig: ::std::os::raw::c_int) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn memset_s(
        __s: *mut ::std::os::raw::c_void,
        __smax: rsize_t,
        __c: ::std::os::raw::c_int,
        __n: rsize_t,
    ) -> errno_t;
}
extern "C" {
    pub fn memmem(
        __big: *const ::std::os::raw::c_void,
        __big_len: size_t,
        __little: *const ::std::os::raw::c_void,
        __little_len: size_t,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn memset_pattern4(
        __b: *mut ::std::os::raw::c_void,
        __pattern4: *const ::std::os::raw::c_void,
        __len: size_t,
    );
}
extern "C" {
    pub fn memset_pattern8(
        __b: *mut ::std::os::raw::c_void,
        __pattern8: *const ::std::os::raw::c_void,
        __len: size_t,
    );
}
extern "C" {
    pub fn memset_pattern16(
        __b: *mut ::std::os::raw::c_void,
        __pattern16: *const ::std::os::raw::c_void,
        __len: size_t,
    );
}
extern "C" {
    pub fn strcasestr(
        __big: *const ::std::os::raw::c_char,
        __little: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strnstr(
        __big: *const ::std::os::raw::c_char,
        __little: *const ::std::os::raw::c_char,
        __len: size_t,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strlcat(
        __dst: *mut ::std::os::raw::c_char,
        __source: *const ::std::os::raw::c_char,
        __size: ::std::os::raw::c_ulong,
    ) -> ::std::os::raw::c_ulong;
}
extern "C" {
    pub fn strlcpy(
        __dst: *mut ::std::os::raw::c_char,
        __source: *const ::std::os::raw::c_char,
        __size: ::std::os::raw::c_ulong,
    ) -> ::std::os::raw::c_ulong;
}
extern "C" {
    pub fn strmode(__mode: ::std::os::raw::c_int, __bp: *mut ::std::os::raw::c_char);
}
extern "C" {
    pub fn strsep(
        __stringp: *mut *mut ::std::os::raw::c_char,
        __delim: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn swab(
        arg1: *const ::std::os::raw::c_void,
        arg2: *mut ::std::os::raw::c_void,
        arg3: ssize_t,
    );
}
extern "C" {
    pub fn timingsafe_bcmp(
        __b1: *const ::std::os::raw::c_void,
        __b2: *const ::std::os::raw::c_void,
        __len: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcmp(
        arg1: *const ::std::os::raw::c_void,
        arg2: *const ::std::os::raw::c_void,
        arg3: ::std::os::raw::c_ulong,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcopy(
        arg1: *const ::std::os::raw::c_void,
        arg2: *mut ::std::os::raw::c_void,
        arg3: size_t,
    );
}
extern "C" {
    pub fn bzero(arg1: *mut ::std::os::raw::c_void, arg2: ::std::os::raw::c_ulong);
}
extern "C" {
    pub fn index(
        arg1: *const ::std::os::raw::c_char,
        arg2: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn rindex(
        arg1: *const ::std::os::raw::c_char,
        arg2: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn ffs(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn strcasecmp(
        arg1: *const ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn strncasecmp(
        arg1: *const ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
        arg3: ::std::os::raw::c_ulong,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ffsl(arg1: ::std::os::raw::c_long) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ffsll(arg1: ::std::os::raw::c_longlong) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fls(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn flsl(arg1: ::std::os::raw::c_long) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn flsll(arg1: ::std::os::raw::c_longlong) -> ::std::os::raw::c_int;
}
pub type __gnuc_va_list = __builtin_va_list;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct flock {
    pub l_start: off_t,
    pub l_len: off_t,
    pub l_pid: pid_t,
    pub l_type: ::std::os::raw::c_short,
    pub l_whence: ::std::os::raw::c_short,
}
#[test]
fn bindgen_test_layout_flock() {
    assert_eq!(
        ::std::mem::size_of::<flock>(),
        24usize,
        concat!("Size of: ", stringify!(flock))
    );
    assert_eq!(
        ::std::mem::align_of::<flock>(),
        8usize,
        concat!("Alignment of ", stringify!(flock))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<flock>())).l_start as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(flock),
            "::",
            stringify!(l_start)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<flock>())).l_len as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(flock),
            "::",
            stringify!(l_len)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<flock>())).l_pid as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(flock),
            "::",
            stringify!(l_pid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<flock>())).l_type as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(flock),
            "::",
            stringify!(l_type)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<flock>())).l_whence as *const _ as usize },
        22usize,
        concat!(
            "Offset of field: ",
            stringify!(flock),
            "::",
            stringify!(l_whence)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct timespec {
    pub tv_sec: __darwin_time_t,
    pub tv_nsec: ::std::os::raw::c_long,
}
#[test]
fn bindgen_test_layout_timespec() {
    assert_eq!(
        ::std::mem::size_of::<timespec>(),
        16usize,
        concat!("Size of: ", stringify!(timespec))
    );
    assert_eq!(
        ::std::mem::align_of::<timespec>(),
        8usize,
        concat!("Alignment of ", stringify!(timespec))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<timespec>())).tv_sec as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(timespec),
            "::",
            stringify!(tv_sec)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<timespec>())).tv_nsec as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(timespec),
            "::",
            stringify!(tv_nsec)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct flocktimeout {
    pub fl: flock,
    pub timeout: timespec,
}
#[test]
fn bindgen_test_layout_flocktimeout() {
    assert_eq!(
        ::std::mem::size_of::<flocktimeout>(),
        40usize,
        concat!("Size of: ", stringify!(flocktimeout))
    );
    assert_eq!(
        ::std::mem::align_of::<flocktimeout>(),
        8usize,
        concat!("Alignment of ", stringify!(flocktimeout))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<flocktimeout>())).fl as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(flocktimeout),
            "::",
            stringify!(fl)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<flocktimeout>())).timeout as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(flocktimeout),
            "::",
            stringify!(timeout)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct radvisory {
    pub ra_offset: off_t,
    pub ra_count: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_radvisory() {
    assert_eq!(
        ::std::mem::size_of::<radvisory>(),
        16usize,
        concat!("Size of: ", stringify!(radvisory))
    );
    assert_eq!(
        ::std::mem::align_of::<radvisory>(),
        8usize,
        concat!("Alignment of ", stringify!(radvisory))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<radvisory>())).ra_offset as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(radvisory),
            "::",
            stringify!(ra_offset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<radvisory>())).ra_count as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(radvisory),
            "::",
            stringify!(ra_count)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct fcodeblobs {
    pub f_cd_hash: *mut ::std::os::raw::c_void,
    pub f_hash_size: size_t,
    pub f_cd_buffer: *mut ::std::os::raw::c_void,
    pub f_cd_size: size_t,
    pub f_out_size: *mut ::std::os::raw::c_uint,
    pub f_arch: ::std::os::raw::c_int,
    pub __padding: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_fcodeblobs() {
    assert_eq!(
        ::std::mem::size_of::<fcodeblobs>(),
        48usize,
        concat!("Size of: ", stringify!(fcodeblobs))
    );
    assert_eq!(
        ::std::mem::align_of::<fcodeblobs>(),
        8usize,
        concat!("Alignment of ", stringify!(fcodeblobs))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<fcodeblobs>())).f_cd_hash as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(fcodeblobs),
            "::",
            stringify!(f_cd_hash)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<fcodeblobs>())).f_hash_size as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(fcodeblobs),
            "::",
            stringify!(f_hash_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<fcodeblobs>())).f_cd_buffer as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(fcodeblobs),
            "::",
            stringify!(f_cd_buffer)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<fcodeblobs>())).f_cd_size as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(fcodeblobs),
            "::",
            stringify!(f_cd_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<fcodeblobs>())).f_out_size as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(fcodeblobs),
            "::",
            stringify!(f_out_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<fcodeblobs>())).f_arch as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(fcodeblobs),
            "::",
            stringify!(f_arch)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<fcodeblobs>())).__padding as *const _ as usize },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(fcodeblobs),
            "::",
            stringify!(__padding)
        )
    );
}
pub type fcodeblobs_t = fcodeblobs;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct fsignatures {
    pub fs_file_start: off_t,
    pub fs_blob_start: *mut ::std::os::raw::c_void,
    pub fs_blob_size: size_t,
}
#[test]
fn bindgen_test_layout_fsignatures() {
    assert_eq!(
        ::std::mem::size_of::<fsignatures>(),
        24usize,
        concat!("Size of: ", stringify!(fsignatures))
    );
    assert_eq!(
        ::std::mem::align_of::<fsignatures>(),
        8usize,
        concat!("Alignment of ", stringify!(fsignatures))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<fsignatures>())).fs_file_start as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(fsignatures),
            "::",
            stringify!(fs_file_start)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<fsignatures>())).fs_blob_start as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(fsignatures),
            "::",
            stringify!(fs_blob_start)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<fsignatures>())).fs_blob_size as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(fsignatures),
            "::",
            stringify!(fs_blob_size)
        )
    );
}
pub type fsignatures_t = fsignatures;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct fchecklv {
    pub lv_file_start: off_t,
    pub lv_error_message_size: size_t,
    pub lv_error_message: *mut ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout_fchecklv() {
    assert_eq!(
        ::std::mem::size_of::<fchecklv>(),
        24usize,
        concat!("Size of: ", stringify!(fchecklv))
    );
    assert_eq!(
        ::std::mem::align_of::<fchecklv>(),
        8usize,
        concat!("Alignment of ", stringify!(fchecklv))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<fchecklv>())).lv_file_start as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(fchecklv),
            "::",
            stringify!(lv_file_start)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<fchecklv>())).lv_error_message_size as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(fchecklv),
            "::",
            stringify!(lv_error_message_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<fchecklv>())).lv_error_message as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(fchecklv),
            "::",
            stringify!(lv_error_message)
        )
    );
}
pub type fchecklv_t = fchecklv;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct fstore {
    pub fst_flags: ::std::os::raw::c_uint,
    pub fst_posmode: ::std::os::raw::c_int,
    pub fst_offset: off_t,
    pub fst_length: off_t,
    pub fst_bytesalloc: off_t,
}
#[test]
fn bindgen_test_layout_fstore() {
    assert_eq!(
        ::std::mem::size_of::<fstore>(),
        32usize,
        concat!("Size of: ", stringify!(fstore))
    );
    assert_eq!(
        ::std::mem::align_of::<fstore>(),
        8usize,
        concat!("Alignment of ", stringify!(fstore))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<fstore>())).fst_flags as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(fstore),
            "::",
            stringify!(fst_flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<fstore>())).fst_posmode as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(fstore),
            "::",
            stringify!(fst_posmode)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<fstore>())).fst_offset as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(fstore),
            "::",
            stringify!(fst_offset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<fstore>())).fst_length as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(fstore),
            "::",
            stringify!(fst_length)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<fstore>())).fst_bytesalloc as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(fstore),
            "::",
            stringify!(fst_bytesalloc)
        )
    );
}
pub type fstore_t = fstore;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct fpunchhole {
    pub fp_flags: ::std::os::raw::c_uint,
    pub reserved: ::std::os::raw::c_uint,
    pub fp_offset: off_t,
    pub fp_length: off_t,
}
#[test]
fn bindgen_test_layout_fpunchhole() {
    assert_eq!(
        ::std::mem::size_of::<fpunchhole>(),
        24usize,
        concat!("Size of: ", stringify!(fpunchhole))
    );
    assert_eq!(
        ::std::mem::align_of::<fpunchhole>(),
        8usize,
        concat!("Alignment of ", stringify!(fpunchhole))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<fpunchhole>())).fp_flags as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(fpunchhole),
            "::",
            stringify!(fp_flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<fpunchhole>())).reserved as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(fpunchhole),
            "::",
            stringify!(reserved)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<fpunchhole>())).fp_offset as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(fpunchhole),
            "::",
            stringify!(fp_offset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<fpunchhole>())).fp_length as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(fpunchhole),
            "::",
            stringify!(fp_length)
        )
    );
}
pub type fpunchhole_t = fpunchhole;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ftrimactivefile {
    pub fta_offset: off_t,
    pub fta_length: off_t,
}
#[test]
fn bindgen_test_layout_ftrimactivefile() {
    assert_eq!(
        ::std::mem::size_of::<ftrimactivefile>(),
        16usize,
        concat!("Size of: ", stringify!(ftrimactivefile))
    );
    assert_eq!(
        ::std::mem::align_of::<ftrimactivefile>(),
        8usize,
        concat!("Alignment of ", stringify!(ftrimactivefile))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ftrimactivefile>())).fta_offset as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(ftrimactivefile),
            "::",
            stringify!(fta_offset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ftrimactivefile>())).fta_length as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(ftrimactivefile),
            "::",
            stringify!(fta_length)
        )
    );
}
pub type ftrimactivefile_t = ftrimactivefile;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct fspecread {
    pub fsr_flags: ::std::os::raw::c_uint,
    pub reserved: ::std::os::raw::c_uint,
    pub fsr_offset: off_t,
    pub fsr_length: off_t,
}
#[test]
fn bindgen_test_layout_fspecread() {
    assert_eq!(
        ::std::mem::size_of::<fspecread>(),
        24usize,
        concat!("Size of: ", stringify!(fspecread))
    );
    assert_eq!(
        ::std::mem::align_of::<fspecread>(),
        8usize,
        concat!("Alignment of ", stringify!(fspecread))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<fspecread>())).fsr_flags as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(fspecread),
            "::",
            stringify!(fsr_flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<fspecread>())).reserved as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(fspecread),
            "::",
            stringify!(reserved)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<fspecread>())).fsr_offset as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(fspecread),
            "::",
            stringify!(fsr_offset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<fspecread>())).fsr_length as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(fspecread),
            "::",
            stringify!(fsr_length)
        )
    );
}
pub type fspecread_t = fspecread;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct fbootstraptransfer {
    pub fbt_offset: off_t,
    pub fbt_length: size_t,
    pub fbt_buffer: *mut ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout_fbootstraptransfer() {
    assert_eq!(
        ::std::mem::size_of::<fbootstraptransfer>(),
        24usize,
        concat!("Size of: ", stringify!(fbootstraptransfer))
    );
    assert_eq!(
        ::std::mem::align_of::<fbootstraptransfer>(),
        8usize,
        concat!("Alignment of ", stringify!(fbootstraptransfer))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<fbootstraptransfer>())).fbt_offset as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(fbootstraptransfer),
            "::",
            stringify!(fbt_offset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<fbootstraptransfer>())).fbt_length as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(fbootstraptransfer),
            "::",
            stringify!(fbt_length)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<fbootstraptransfer>())).fbt_buffer as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(fbootstraptransfer),
            "::",
            stringify!(fbt_buffer)
        )
    );
}
pub type fbootstraptransfer_t = fbootstraptransfer;
#[repr(C, packed(4))]
#[derive(Debug, Copy, Clone)]
pub struct log2phys {
    pub l2p_flags: ::std::os::raw::c_uint,
    pub l2p_contigbytes: off_t,
    pub l2p_devoffset: off_t,
}
#[test]
fn bindgen_test_layout_log2phys() {
    assert_eq!(
        ::std::mem::size_of::<log2phys>(),
        20usize,
        concat!("Size of: ", stringify!(log2phys))
    );
    assert_eq!(
        ::std::mem::align_of::<log2phys>(),
        4usize,
        concat!("Alignment of ", stringify!(log2phys))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<log2phys>())).l2p_flags as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(log2phys),
            "::",
            stringify!(l2p_flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<log2phys>())).l2p_contigbytes as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(log2phys),
            "::",
            stringify!(l2p_contigbytes)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<log2phys>())).l2p_devoffset as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(log2phys),
            "::",
            stringify!(l2p_devoffset)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _filesec {
    _unused: [u8; 0],
}
pub type filesec_t = *mut _filesec;
pub const filesec_property_t_FILESEC_OWNER: filesec_property_t = 1;
pub const filesec_property_t_FILESEC_GROUP: filesec_property_t = 2;
pub const filesec_property_t_FILESEC_UUID: filesec_property_t = 3;
pub const filesec_property_t_FILESEC_MODE: filesec_property_t = 4;
pub const filesec_property_t_FILESEC_ACL: filesec_property_t = 5;
pub const filesec_property_t_FILESEC_GRPUUID: filesec_property_t = 6;
pub const filesec_property_t_FILESEC_ACL_RAW: filesec_property_t = 100;
pub const filesec_property_t_FILESEC_ACL_ALLOCSIZE: filesec_property_t = 101;
pub type filesec_property_t = ::std::os::raw::c_uint;
extern "C" {
    pub fn open(
        arg1: *const ::std::os::raw::c_char,
        arg2: ::std::os::raw::c_int,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn openat(
        arg1: ::std::os::raw::c_int,
        arg2: *const ::std::os::raw::c_char,
        arg3: ::std::os::raw::c_int,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn creat(arg1: *const ::std::os::raw::c_char, arg2: mode_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fcntl(
        arg1: ::std::os::raw::c_int,
        arg2: ::std::os::raw::c_int,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn openx_np(
        arg1: *const ::std::os::raw::c_char,
        arg2: ::std::os::raw::c_int,
        arg3: filesec_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn open_dprotected_np(
        arg1: *const ::std::os::raw::c_char,
        arg2: ::std::os::raw::c_int,
        arg3: ::std::os::raw::c_int,
        arg4: ::std::os::raw::c_int,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn flock(arg1: ::std::os::raw::c_int, arg2: ::std::os::raw::c_int)
        -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn filesec_init() -> filesec_t;
}
extern "C" {
    pub fn filesec_dup(arg1: filesec_t) -> filesec_t;
}
extern "C" {
    pub fn filesec_free(arg1: filesec_t);
}
extern "C" {
    pub fn filesec_get_property(
        arg1: filesec_t,
        arg2: filesec_property_t,
        arg3: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn filesec_query_property(
        arg1: filesec_t,
        arg2: filesec_property_t,
        arg3: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn filesec_set_property(
        arg1: filesec_t,
        arg2: filesec_property_t,
        arg3: *const ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn filesec_unset_property(
        arg1: filesec_t,
        arg2: filesec_property_t,
    ) -> ::std::os::raw::c_int;
}
pub type PrintfCallback = ::std::option::Option<
    unsafe extern "C" fn(str_: *const ::std::os::raw::c_char, ...) -> ::std::os::raw::c_int,
>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ostat {
    pub st_dev: __uint16_t,
    pub st_ino: ino_t,
    pub st_mode: mode_t,
    pub st_nlink: nlink_t,
    pub st_uid: __uint16_t,
    pub st_gid: __uint16_t,
    pub st_rdev: __uint16_t,
    pub st_size: __int32_t,
    pub st_atimespec: timespec,
    pub st_mtimespec: timespec,
    pub st_ctimespec: timespec,
    pub st_blksize: __int32_t,
    pub st_blocks: __int32_t,
    pub st_flags: __uint32_t,
    pub st_gen: __uint32_t,
}
#[test]
fn bindgen_test_layout_ostat() {
    assert_eq!(
        ::std::mem::size_of::<ostat>(),
        96usize,
        concat!("Size of: ", stringify!(ostat))
    );
    assert_eq!(
        ::std::mem::align_of::<ostat>(),
        8usize,
        concat!("Alignment of ", stringify!(ostat))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ostat>())).st_dev as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(ostat),
            "::",
            stringify!(st_dev)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ostat>())).st_ino as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(ostat),
            "::",
            stringify!(st_ino)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ostat>())).st_mode as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(ostat),
            "::",
            stringify!(st_mode)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ostat>())).st_nlink as *const _ as usize },
        18usize,
        concat!(
            "Offset of field: ",
            stringify!(ostat),
            "::",
            stringify!(st_nlink)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ostat>())).st_uid as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(ostat),
            "::",
            stringify!(st_uid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ostat>())).st_gid as *const _ as usize },
        22usize,
        concat!(
            "Offset of field: ",
            stringify!(ostat),
            "::",
            stringify!(st_gid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ostat>())).st_rdev as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(ostat),
            "::",
            stringify!(st_rdev)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ostat>())).st_size as *const _ as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(ostat),
            "::",
            stringify!(st_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ostat>())).st_atimespec as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(ostat),
            "::",
            stringify!(st_atimespec)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ostat>())).st_mtimespec as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(ostat),
            "::",
            stringify!(st_mtimespec)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ostat>())).st_ctimespec as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(ostat),
            "::",
            stringify!(st_ctimespec)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ostat>())).st_blksize as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(ostat),
            "::",
            stringify!(st_blksize)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ostat>())).st_blocks as *const _ as usize },
        84usize,
        concat!(
            "Offset of field: ",
            stringify!(ostat),
            "::",
            stringify!(st_blocks)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ostat>())).st_flags as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(ostat),
            "::",
            stringify!(st_flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ostat>())).st_gen as *const _ as usize },
        92usize,
        concat!(
            "Offset of field: ",
            stringify!(ostat),
            "::",
            stringify!(st_gen)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct stat {
    pub st_dev: dev_t,
    pub st_mode: mode_t,
    pub st_nlink: nlink_t,
    pub st_ino: __darwin_ino64_t,
    pub st_uid: uid_t,
    pub st_gid: gid_t,
    pub st_rdev: dev_t,
    pub st_atimespec: timespec,
    pub st_mtimespec: timespec,
    pub st_ctimespec: timespec,
    pub st_birthtimespec: timespec,
    pub st_size: off_t,
    pub st_blocks: blkcnt_t,
    pub st_blksize: blksize_t,
    pub st_flags: __uint32_t,
    pub st_gen: __uint32_t,
    pub st_lspare: __int32_t,
    pub st_qspare: [__int64_t; 2usize],
}
#[test]
fn bindgen_test_layout_stat() {
    assert_eq!(
        ::std::mem::size_of::<stat>(),
        144usize,
        concat!("Size of: ", stringify!(stat))
    );
    assert_eq!(
        ::std::mem::align_of::<stat>(),
        8usize,
        concat!("Alignment of ", stringify!(stat))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stat>())).st_dev as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(stat),
            "::",
            stringify!(st_dev)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stat>())).st_mode as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(stat),
            "::",
            stringify!(st_mode)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stat>())).st_nlink as *const _ as usize },
        6usize,
        concat!(
            "Offset of field: ",
            stringify!(stat),
            "::",
            stringify!(st_nlink)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stat>())).st_ino as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(stat),
            "::",
            stringify!(st_ino)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stat>())).st_uid as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(stat),
            "::",
            stringify!(st_uid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stat>())).st_gid as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(stat),
            "::",
            stringify!(st_gid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stat>())).st_rdev as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(stat),
            "::",
            stringify!(st_rdev)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stat>())).st_atimespec as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(stat),
            "::",
            stringify!(st_atimespec)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stat>())).st_mtimespec as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(stat),
            "::",
            stringify!(st_mtimespec)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stat>())).st_ctimespec as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(stat),
            "::",
            stringify!(st_ctimespec)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stat>())).st_birthtimespec as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(stat),
            "::",
            stringify!(st_birthtimespec)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stat>())).st_size as *const _ as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(stat),
            "::",
            stringify!(st_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stat>())).st_blocks as *const _ as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(stat),
            "::",
            stringify!(st_blocks)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stat>())).st_blksize as *const _ as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(stat),
            "::",
            stringify!(st_blksize)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stat>())).st_flags as *const _ as usize },
        116usize,
        concat!(
            "Offset of field: ",
            stringify!(stat),
            "::",
            stringify!(st_flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stat>())).st_gen as *const _ as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(stat),
            "::",
            stringify!(st_gen)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stat>())).st_lspare as *const _ as usize },
        124usize,
        concat!(
            "Offset of field: ",
            stringify!(stat),
            "::",
            stringify!(st_lspare)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stat>())).st_qspare as *const _ as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(stat),
            "::",
            stringify!(st_qspare)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct stat64 {
    pub st_dev: dev_t,
    pub st_mode: mode_t,
    pub st_nlink: nlink_t,
    pub st_ino: __darwin_ino64_t,
    pub st_uid: uid_t,
    pub st_gid: gid_t,
    pub st_rdev: dev_t,
    pub st_atimespec: timespec,
    pub st_mtimespec: timespec,
    pub st_ctimespec: timespec,
    pub st_birthtimespec: timespec,
    pub st_size: off_t,
    pub st_blocks: blkcnt_t,
    pub st_blksize: blksize_t,
    pub st_flags: __uint32_t,
    pub st_gen: __uint32_t,
    pub st_lspare: __int32_t,
    pub st_qspare: [__int64_t; 2usize],
}
#[test]
fn bindgen_test_layout_stat64() {
    assert_eq!(
        ::std::mem::size_of::<stat64>(),
        144usize,
        concat!("Size of: ", stringify!(stat64))
    );
    assert_eq!(
        ::std::mem::align_of::<stat64>(),
        8usize,
        concat!("Alignment of ", stringify!(stat64))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stat64>())).st_dev as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(stat64),
            "::",
            stringify!(st_dev)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stat64>())).st_mode as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(stat64),
            "::",
            stringify!(st_mode)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stat64>())).st_nlink as *const _ as usize },
        6usize,
        concat!(
            "Offset of field: ",
            stringify!(stat64),
            "::",
            stringify!(st_nlink)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stat64>())).st_ino as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(stat64),
            "::",
            stringify!(st_ino)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stat64>())).st_uid as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(stat64),
            "::",
            stringify!(st_uid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stat64>())).st_gid as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(stat64),
            "::",
            stringify!(st_gid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stat64>())).st_rdev as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(stat64),
            "::",
            stringify!(st_rdev)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stat64>())).st_atimespec as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(stat64),
            "::",
            stringify!(st_atimespec)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stat64>())).st_mtimespec as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(stat64),
            "::",
            stringify!(st_mtimespec)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stat64>())).st_ctimespec as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(stat64),
            "::",
            stringify!(st_ctimespec)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stat64>())).st_birthtimespec as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(stat64),
            "::",
            stringify!(st_birthtimespec)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stat64>())).st_size as *const _ as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(stat64),
            "::",
            stringify!(st_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stat64>())).st_blocks as *const _ as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(stat64),
            "::",
            stringify!(st_blocks)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stat64>())).st_blksize as *const _ as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(stat64),
            "::",
            stringify!(st_blksize)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stat64>())).st_flags as *const _ as usize },
        116usize,
        concat!(
            "Offset of field: ",
            stringify!(stat64),
            "::",
            stringify!(st_flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stat64>())).st_gen as *const _ as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(stat64),
            "::",
            stringify!(st_gen)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stat64>())).st_lspare as *const _ as usize },
        124usize,
        concat!(
            "Offset of field: ",
            stringify!(stat64),
            "::",
            stringify!(st_lspare)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stat64>())).st_qspare as *const _ as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(stat64),
            "::",
            stringify!(st_qspare)
        )
    );
}
extern "C" {
    pub fn chmod(arg1: *const ::std::os::raw::c_char, arg2: mode_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fchmod(arg1: ::std::os::raw::c_int, arg2: mode_t) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}_fstat$INODE64"]
    pub fn fstat(arg1: ::std::os::raw::c_int, arg2: *mut stat) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}_lstat$INODE64"]
    pub fn lstat(arg1: *const ::std::os::raw::c_char, arg2: *mut stat) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mkdir(arg1: *const ::std::os::raw::c_char, arg2: mode_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mkfifo(arg1: *const ::std::os::raw::c_char, arg2: mode_t) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}_stat$INODE64"]
    pub fn stat(arg1: *const ::std::os::raw::c_char, arg2: *mut stat) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mknod(
        arg1: *const ::std::os::raw::c_char,
        arg2: mode_t,
        arg3: dev_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn umask(arg1: mode_t) -> mode_t;
}
extern "C" {
    pub fn fchmodat(
        arg1: ::std::os::raw::c_int,
        arg2: *const ::std::os::raw::c_char,
        arg3: mode_t,
        arg4: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}_fstatat$INODE64"]
    pub fn fstatat(
        arg1: ::std::os::raw::c_int,
        arg2: *const ::std::os::raw::c_char,
        arg3: *mut stat,
        arg4: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mkdirat(
        arg1: ::std::os::raw::c_int,
        arg2: *const ::std::os::raw::c_char,
        arg3: mode_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn futimens(__fd: ::std::os::raw::c_int, __times: *const timespec)
        -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn utimensat(
        __fd: ::std::os::raw::c_int,
        __path: *const ::std::os::raw::c_char,
        __times: *const timespec,
        __flag: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn chflags(arg1: *const ::std::os::raw::c_char, arg2: __uint32_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn chmodx_np(arg1: *const ::std::os::raw::c_char, arg2: filesec_t)
        -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fchflags(arg1: ::std::os::raw::c_int, arg2: __uint32_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fchmodx_np(arg1: ::std::os::raw::c_int, arg2: filesec_t) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}_fstatx_np$INODE64"]
    pub fn fstatx_np(
        arg1: ::std::os::raw::c_int,
        arg2: *mut stat,
        arg3: filesec_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn lchflags(arg1: *const ::std::os::raw::c_char, arg2: __uint32_t)
        -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn lchmod(arg1: *const ::std::os::raw::c_char, arg2: mode_t) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}_lstatx_np$INODE64"]
    pub fn lstatx_np(
        arg1: *const ::std::os::raw::c_char,
        arg2: *mut stat,
        arg3: filesec_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mkdirx_np(arg1: *const ::std::os::raw::c_char, arg2: filesec_t)
        -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mkfifox_np(
        arg1: *const ::std::os::raw::c_char,
        arg2: filesec_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}_statx_np$INODE64"]
    pub fn statx_np(
        arg1: *const ::std::os::raw::c_char,
        arg2: *mut stat,
        arg3: filesec_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn umaskx_np(arg1: filesec_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fstatx64_np(
        arg1: ::std::os::raw::c_int,
        arg2: *mut stat64,
        arg3: filesec_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn lstatx64_np(
        arg1: *const ::std::os::raw::c_char,
        arg2: *mut stat64,
        arg3: filesec_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn statx64_np(
        arg1: *const ::std::os::raw::c_char,
        arg2: *mut stat64,
        arg3: filesec_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fstat64(arg1: ::std::os::raw::c_int, arg2: *mut stat64) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn lstat64(arg1: *const ::std::os::raw::c_char, arg2: *mut stat64)
        -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn stat64(arg1: *const ::std::os::raw::c_char, arg2: *mut stat64) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct dirent {
    pub d_ino: __uint64_t,
    pub d_seekoff: __uint64_t,
    pub d_reclen: __uint16_t,
    pub d_namlen: __uint16_t,
    pub d_type: __uint8_t,
    pub d_name: [::std::os::raw::c_char; 1024usize],
}
#[test]
fn bindgen_test_layout_dirent() {
    assert_eq!(
        ::std::mem::size_of::<dirent>(),
        1048usize,
        concat!("Size of: ", stringify!(dirent))
    );
    assert_eq!(
        ::std::mem::align_of::<dirent>(),
        8usize,
        concat!("Alignment of ", stringify!(dirent))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<dirent>())).d_ino as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(dirent),
            "::",
            stringify!(d_ino)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<dirent>())).d_seekoff as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(dirent),
            "::",
            stringify!(d_seekoff)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<dirent>())).d_reclen as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(dirent),
            "::",
            stringify!(d_reclen)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<dirent>())).d_namlen as *const _ as usize },
        18usize,
        concat!(
            "Offset of field: ",
            stringify!(dirent),
            "::",
            stringify!(d_namlen)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<dirent>())).d_type as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(dirent),
            "::",
            stringify!(d_type)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<dirent>())).d_name as *const _ as usize },
        21usize,
        concat!(
            "Offset of field: ",
            stringify!(dirent),
            "::",
            stringify!(d_name)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _telldir {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct DIR {
    pub __dd_fd: ::std::os::raw::c_int,
    pub __dd_loc: ::std::os::raw::c_long,
    pub __dd_size: ::std::os::raw::c_long,
    pub __dd_buf: *mut ::std::os::raw::c_char,
    pub __dd_len: ::std::os::raw::c_int,
    pub __dd_seek: ::std::os::raw::c_long,
    pub __padding: ::std::os::raw::c_long,
    pub __dd_flags: ::std::os::raw::c_int,
    pub __dd_lock: __darwin_pthread_mutex_t,
    pub __dd_td: *mut _telldir,
}
#[test]
fn bindgen_test_layout_DIR() {
    assert_eq!(
        ::std::mem::size_of::<DIR>(),
        136usize,
        concat!("Size of: ", stringify!(DIR))
    );
    assert_eq!(
        ::std::mem::align_of::<DIR>(),
        8usize,
        concat!("Alignment of ", stringify!(DIR))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<DIR>())).__dd_fd as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(DIR),
            "::",
            stringify!(__dd_fd)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<DIR>())).__dd_loc as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(DIR),
            "::",
            stringify!(__dd_loc)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<DIR>())).__dd_size as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(DIR),
            "::",
            stringify!(__dd_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<DIR>())).__dd_buf as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(DIR),
            "::",
            stringify!(__dd_buf)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<DIR>())).__dd_len as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(DIR),
            "::",
            stringify!(__dd_len)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<DIR>())).__dd_seek as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(DIR),
            "::",
            stringify!(__dd_seek)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<DIR>())).__padding as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(DIR),
            "::",
            stringify!(__padding)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<DIR>())).__dd_flags as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(DIR),
            "::",
            stringify!(__dd_flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<DIR>())).__dd_lock as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(DIR),
            "::",
            stringify!(__dd_lock)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<DIR>())).__dd_td as *const _ as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(DIR),
            "::",
            stringify!(__dd_td)
        )
    );
}
extern "C" {
    pub fn closedir(arg1: *mut DIR) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}_opendir$INODE64"]
    pub fn opendir(arg1: *const ::std::os::raw::c_char) -> *mut DIR;
}
extern "C" {
    #[link_name = "\u{1}_readdir$INODE64"]
    pub fn readdir(arg1: *mut DIR) -> *mut dirent;
}
extern "C" {
    #[link_name = "\u{1}_readdir_r$INODE64"]
    pub fn readdir_r(
        arg1: *mut DIR,
        arg2: *mut dirent,
        arg3: *mut *mut dirent,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}_rewinddir$INODE64"]
    pub fn rewinddir(arg1: *mut DIR);
}
extern "C" {
    #[link_name = "\u{1}_seekdir$INODE64"]
    pub fn seekdir(arg1: *mut DIR, arg2: ::std::os::raw::c_long);
}
extern "C" {
    #[link_name = "\u{1}_telldir$INODE64"]
    pub fn telldir(arg1: *mut DIR) -> ::std::os::raw::c_long;
}
extern "C" {
    #[link_name = "\u{1}_fdopendir$INODE64"]
    pub fn fdopendir(arg1: ::std::os::raw::c_int) -> *mut DIR;
}
extern "C" {
    #[link_name = "\u{1}_alphasort$INODE64"]
    pub fn alphasort(arg1: *mut *const dirent, arg2: *mut *const dirent) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn dirfd(dirp: *mut DIR) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}_scandir$INODE64"]
    pub fn scandir(
        arg1: *const ::std::os::raw::c_char,
        arg2: *mut *mut *mut dirent,
        arg3: ::std::option::Option<
            unsafe extern "C" fn(arg1: *const dirent) -> ::std::os::raw::c_int,
        >,
        arg4: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: *mut *const dirent,
                arg2: *mut *const dirent,
            ) -> ::std::os::raw::c_int,
        >,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}_scandir_b$INODE64"]
    pub fn scandir_b(
        arg1: *const ::std::os::raw::c_char,
        arg2: *mut *mut *mut dirent,
        arg3: *mut ::std::os::raw::c_void,
        arg4: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}_getdirentries_is_not_available_when_64_bit_inodes_are_in_effect"]
    pub fn getdirentries(
        arg1: ::std::os::raw::c_int,
        arg2: *mut ::std::os::raw::c_char,
        arg3: ::std::os::raw::c_int,
        arg4: *mut ::std::os::raw::c_long,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}___opendir2$INODE64"]
    pub fn __opendir2(arg1: *const ::std::os::raw::c_char, arg2: ::std::os::raw::c_int)
        -> *mut DIR;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct accessx_descriptor {
    pub ad_name_offset: ::std::os::raw::c_uint,
    pub ad_flags: ::std::os::raw::c_int,
    pub ad_pad: [::std::os::raw::c_int; 2usize],
}
#[test]
fn bindgen_test_layout_accessx_descriptor() {
    assert_eq!(
        ::std::mem::size_of::<accessx_descriptor>(),
        16usize,
        concat!("Size of: ", stringify!(accessx_descriptor))
    );
    assert_eq!(
        ::std::mem::align_of::<accessx_descriptor>(),
        4usize,
        concat!("Alignment of ", stringify!(accessx_descriptor))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<accessx_descriptor>())).ad_name_offset as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(accessx_descriptor),
            "::",
            stringify!(ad_name_offset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<accessx_descriptor>())).ad_flags as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(accessx_descriptor),
            "::",
            stringify!(ad_flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<accessx_descriptor>())).ad_pad as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(accessx_descriptor),
            "::",
            stringify!(ad_pad)
        )
    );
}
extern "C" {
    pub fn getattrlistbulk(
        arg1: ::std::os::raw::c_int,
        arg2: *mut ::std::os::raw::c_void,
        arg3: *mut ::std::os::raw::c_void,
        arg4: size_t,
        arg5: u64,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getattrlistat(
        arg1: ::std::os::raw::c_int,
        arg2: *const ::std::os::raw::c_char,
        arg3: *mut ::std::os::raw::c_void,
        arg4: *mut ::std::os::raw::c_void,
        arg5: size_t,
        arg6: ::std::os::raw::c_ulong,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setattrlistat(
        arg1: ::std::os::raw::c_int,
        arg2: *const ::std::os::raw::c_char,
        arg3: *mut ::std::os::raw::c_void,
        arg4: *mut ::std::os::raw::c_void,
        arg5: size_t,
        arg6: u32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn faccessat(
        arg1: ::std::os::raw::c_int,
        arg2: *const ::std::os::raw::c_char,
        arg3: ::std::os::raw::c_int,
        arg4: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fchownat(
        arg1: ::std::os::raw::c_int,
        arg2: *const ::std::os::raw::c_char,
        arg3: uid_t,
        arg4: gid_t,
        arg5: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn linkat(
        arg1: ::std::os::raw::c_int,
        arg2: *const ::std::os::raw::c_char,
        arg3: ::std::os::raw::c_int,
        arg4: *const ::std::os::raw::c_char,
        arg5: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn readlinkat(
        arg1: ::std::os::raw::c_int,
        arg2: *const ::std::os::raw::c_char,
        arg3: *mut ::std::os::raw::c_char,
        arg4: size_t,
    ) -> ssize_t;
}
extern "C" {
    pub fn symlinkat(
        arg1: *const ::std::os::raw::c_char,
        arg2: ::std::os::raw::c_int,
        arg3: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn unlinkat(
        arg1: ::std::os::raw::c_int,
        arg2: *const ::std::os::raw::c_char,
        arg3: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _exit(arg1: ::std::os::raw::c_int);
}
extern "C" {
    pub fn access(
        arg1: *const ::std::os::raw::c_char,
        arg2: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn alarm(arg1: ::std::os::raw::c_uint) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn chdir(arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn chown(
        arg1: *const ::std::os::raw::c_char,
        arg2: uid_t,
        arg3: gid_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn close(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn dup(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn dup2(arg1: ::std::os::raw::c_int, arg2: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn execl(
        __path: *const ::std::os::raw::c_char,
        __arg0: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn execle(
        __path: *const ::std::os::raw::c_char,
        __arg0: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn execlp(
        __file: *const ::std::os::raw::c_char,
        __arg0: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn execv(
        __path: *const ::std::os::raw::c_char,
        __argv: *const *mut ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn execve(
        __file: *const ::std::os::raw::c_char,
        __argv: *const *mut ::std::os::raw::c_char,
        __envp: *const *mut ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn execvp(
        __file: *const ::std::os::raw::c_char,
        __argv: *const *mut ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fork() -> pid_t;
}
extern "C" {
    pub fn fpathconf(
        arg1: ::std::os::raw::c_int,
        arg2: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn getcwd(arg1: *mut ::std::os::raw::c_char, arg2: size_t) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn getegid() -> gid_t;
}
extern "C" {
    pub fn geteuid() -> uid_t;
}
extern "C" {
    pub fn getgid() -> gid_t;
}
extern "C" {
    pub fn getgroups(arg1: ::std::os::raw::c_int, arg2: *mut gid_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getlogin() -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn getpgrp() -> pid_t;
}
extern "C" {
    pub fn getpid() -> pid_t;
}
extern "C" {
    pub fn getppid() -> pid_t;
}
extern "C" {
    pub fn getuid() -> uid_t;
}
extern "C" {
    pub fn isatty(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn link(
        arg1: *const ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn lseek(arg1: ::std::os::raw::c_int, arg2: off_t, arg3: ::std::os::raw::c_int) -> off_t;
}
extern "C" {
    pub fn pathconf(
        arg1: *const ::std::os::raw::c_char,
        arg2: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn pause() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pipe(arg1: *mut ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn read(
        arg1: ::std::os::raw::c_int,
        arg2: *mut ::std::os::raw::c_void,
        arg3: size_t,
    ) -> ssize_t;
}
extern "C" {
    pub fn rmdir(arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setgid(arg1: gid_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setpgid(arg1: pid_t, arg2: pid_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setsid() -> pid_t;
}
extern "C" {
    pub fn setuid(arg1: uid_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sleep(arg1: ::std::os::raw::c_uint) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn sysconf(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn tcgetpgrp(arg1: ::std::os::raw::c_int) -> pid_t;
}
extern "C" {
    pub fn tcsetpgrp(arg1: ::std::os::raw::c_int, arg2: pid_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ttyname(arg1: ::std::os::raw::c_int) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn ttyname_r(
        arg1: ::std::os::raw::c_int,
        arg2: *mut ::std::os::raw::c_char,
        arg3: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn unlink(arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn write(
        __fd: ::std::os::raw::c_int,
        __buf: *const ::std::os::raw::c_void,
        __nbyte: size_t,
    ) -> ssize_t;
}
extern "C" {
    pub fn confstr(
        arg1: ::std::os::raw::c_int,
        arg2: *mut ::std::os::raw::c_char,
        arg3: size_t,
    ) -> size_t;
}
extern "C" {
    pub fn getopt(
        arg1: ::std::os::raw::c_int,
        arg2: *const *mut ::std::os::raw::c_char,
        arg3: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub static mut optarg: *mut ::std::os::raw::c_char;
}
extern "C" {
    pub static mut optind: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut opterr: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut optopt: ::std::os::raw::c_int;
}
extern "C" {
    pub fn brk(arg1: *const ::std::os::raw::c_void) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn chroot(arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn crypt(
        arg1: *const ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn encrypt(arg1: *mut ::std::os::raw::c_char, arg2: ::std::os::raw::c_int);
}
extern "C" {
    pub fn fchdir(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn gethostid() -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn getpgid(arg1: pid_t) -> pid_t;
}
extern "C" {
    pub fn getsid(arg1: pid_t) -> pid_t;
}
extern "C" {
    pub fn getdtablesize() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getpagesize() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getpass(arg1: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn getwd(arg1: *mut ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn lchown(
        arg1: *const ::std::os::raw::c_char,
        arg2: uid_t,
        arg3: gid_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn lockf(
        arg1: ::std::os::raw::c_int,
        arg2: ::std::os::raw::c_int,
        arg3: off_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn nice(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pread(
        __fd: ::std::os::raw::c_int,
        __buf: *mut ::std::os::raw::c_void,
        __nbyte: size_t,
        __offset: off_t,
    ) -> ssize_t;
}
extern "C" {
    pub fn pwrite(
        __fd: ::std::os::raw::c_int,
        __buf: *const ::std::os::raw::c_void,
        __nbyte: size_t,
        __offset: off_t,
    ) -> ssize_t;
}
extern "C" {
    pub fn sbrk(arg1: ::std::os::raw::c_int) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn setpgrp() -> pid_t;
}
extern "C" {
    pub fn setregid(arg1: gid_t, arg2: gid_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setreuid(arg1: uid_t, arg2: uid_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sync();
}
extern "C" {
    pub fn truncate(arg1: *const ::std::os::raw::c_char, arg2: off_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ualarm(arg1: useconds_t, arg2: useconds_t) -> useconds_t;
}
extern "C" {
    pub fn usleep(arg1: useconds_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vfork() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fsync(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ftruncate(arg1: ::std::os::raw::c_int, arg2: off_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getlogin_r(arg1: *mut ::std::os::raw::c_char, arg2: size_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fchown(arg1: ::std::os::raw::c_int, arg2: uid_t, arg3: gid_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn gethostname(arg1: *mut ::std::os::raw::c_char, arg2: size_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn readlink(
        arg1: *const ::std::os::raw::c_char,
        arg2: *mut ::std::os::raw::c_char,
        arg3: size_t,
    ) -> ssize_t;
}
extern "C" {
    pub fn setegid(arg1: gid_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn seteuid(arg1: uid_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn symlink(
        arg1: *const ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}_pselect$1050"]
    pub fn pselect(
        arg1: ::std::os::raw::c_int,
        arg2: *mut fd_set,
        arg3: *mut fd_set,
        arg4: *mut fd_set,
        arg5: *const timespec,
        arg6: *const sigset_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}_select$1050"]
    pub fn select(
        arg1: ::std::os::raw::c_int,
        arg2: *mut fd_set,
        arg3: *mut fd_set,
        arg4: *mut fd_set,
        arg5: *mut timeval,
    ) -> ::std::os::raw::c_int;
}
pub type uuid_t = __darwin_uuid_t;
extern "C" {
    pub fn accessx_np(
        arg1: *const accessx_descriptor,
        arg2: size_t,
        arg3: *mut ::std::os::raw::c_int,
        arg4: uid_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn acct(arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn add_profil(
        arg1: *mut ::std::os::raw::c_char,
        arg2: size_t,
        arg3: ::std::os::raw::c_ulong,
        arg4: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn endusershell();
}
extern "C" {
    pub fn execvP(
        __file: *const ::std::os::raw::c_char,
        __searchpath: *const ::std::os::raw::c_char,
        __argv: *const *mut ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fflagstostr(arg1: ::std::os::raw::c_ulong) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn getdomainname(
        arg1: *mut ::std::os::raw::c_char,
        arg2: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getgrouplist(
        arg1: *const ::std::os::raw::c_char,
        arg2: ::std::os::raw::c_int,
        arg3: *mut ::std::os::raw::c_int,
        arg4: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn gethostuuid(
        arg1: *mut ::std::os::raw::c_uchar,
        arg2: *const timespec,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getmode(arg1: *const ::std::os::raw::c_void, arg2: mode_t) -> mode_t;
}
extern "C" {
    pub fn getpeereid(
        arg1: ::std::os::raw::c_int,
        arg2: *mut uid_t,
        arg3: *mut gid_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getsgroups_np(
        arg1: *mut ::std::os::raw::c_int,
        arg2: *mut ::std::os::raw::c_uchar,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getusershell() -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn getwgroups_np(
        arg1: *mut ::std::os::raw::c_int,
        arg2: *mut ::std::os::raw::c_uchar,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn initgroups(
        arg1: *const ::std::os::raw::c_char,
        arg2: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn issetugid() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mkdtemp(arg1: *mut ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn mkpath_np(path: *const ::std::os::raw::c_char, omode: mode_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mkpathat_np(
        dfd: ::std::os::raw::c_int,
        path: *const ::std::os::raw::c_char,
        omode: mode_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mkstemps(
        arg1: *mut ::std::os::raw::c_char,
        arg2: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mkostemp(
        path: *mut ::std::os::raw::c_char,
        oflags: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mkostemps(
        path: *mut ::std::os::raw::c_char,
        slen: ::std::os::raw::c_int,
        oflags: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mkstemp_dprotected_np(
        path: *mut ::std::os::raw::c_char,
        dpclass: ::std::os::raw::c_int,
        dpflags: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mkdtempat_np(
        dfd: ::std::os::raw::c_int,
        path: *mut ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn mkstempsat_np(
        dfd: ::std::os::raw::c_int,
        path: *mut ::std::os::raw::c_char,
        slen: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mkostempsat_np(
        dfd: ::std::os::raw::c_int,
        path: *mut ::std::os::raw::c_char,
        slen: ::std::os::raw::c_int,
        oflags: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn nfssvc(
        arg1: ::std::os::raw::c_int,
        arg2: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn profil(
        arg1: *mut ::std::os::raw::c_char,
        arg2: size_t,
        arg3: ::std::os::raw::c_ulong,
        arg4: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_setugid_np(arg1: uid_t, arg2: gid_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_getugid_np(arg1: *mut uid_t, arg2: *mut gid_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn reboot(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn revoke(arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rcmd(
        arg1: *mut *mut ::std::os::raw::c_char,
        arg2: ::std::os::raw::c_int,
        arg3: *const ::std::os::raw::c_char,
        arg4: *const ::std::os::raw::c_char,
        arg5: *const ::std::os::raw::c_char,
        arg6: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rcmd_af(
        arg1: *mut *mut ::std::os::raw::c_char,
        arg2: ::std::os::raw::c_int,
        arg3: *const ::std::os::raw::c_char,
        arg4: *const ::std::os::raw::c_char,
        arg5: *const ::std::os::raw::c_char,
        arg6: *mut ::std::os::raw::c_int,
        arg7: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rresvport(arg1: *mut ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rresvport_af(
        arg1: *mut ::std::os::raw::c_int,
        arg2: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn iruserok(
        arg1: ::std::os::raw::c_ulong,
        arg2: ::std::os::raw::c_int,
        arg3: *const ::std::os::raw::c_char,
        arg4: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn iruserok_sa(
        arg1: *const ::std::os::raw::c_void,
        arg2: ::std::os::raw::c_int,
        arg3: ::std::os::raw::c_int,
        arg4: *const ::std::os::raw::c_char,
        arg5: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ruserok(
        arg1: *const ::std::os::raw::c_char,
        arg2: ::std::os::raw::c_int,
        arg3: *const ::std::os::raw::c_char,
        arg4: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setdomainname(
        arg1: *const ::std::os::raw::c_char,
        arg2: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setgroups(arg1: ::std::os::raw::c_int, arg2: *const gid_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sethostid(arg1: ::std::os::raw::c_long);
}
extern "C" {
    pub fn sethostname(
        arg1: *const ::std::os::raw::c_char,
        arg2: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setlogin(arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setmode(arg1: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn setrgid(arg1: gid_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setruid(arg1: uid_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setsgroups_np(
        arg1: ::std::os::raw::c_int,
        arg2: *mut ::std::os::raw::c_uchar,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setusershell();
}
extern "C" {
    pub fn setwgroups_np(
        arg1: ::std::os::raw::c_int,
        arg2: *mut ::std::os::raw::c_uchar,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn strtofflags(
        arg1: *mut *mut ::std::os::raw::c_char,
        arg2: *mut ::std::os::raw::c_ulong,
        arg3: *mut ::std::os::raw::c_ulong,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn swapon(arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ttyslot() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn undelete(arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn unwhiteout(arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn syscall(arg1: ::std::os::raw::c_int, ...) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fgetattrlist(
        arg1: ::std::os::raw::c_int,
        arg2: *mut ::std::os::raw::c_void,
        arg3: *mut ::std::os::raw::c_void,
        arg4: size_t,
        arg5: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fsetattrlist(
        arg1: ::std::os::raw::c_int,
        arg2: *mut ::std::os::raw::c_void,
        arg3: *mut ::std::os::raw::c_void,
        arg4: size_t,
        arg5: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getattrlist(
        arg1: *const ::std::os::raw::c_char,
        arg2: *mut ::std::os::raw::c_void,
        arg3: *mut ::std::os::raw::c_void,
        arg4: size_t,
        arg5: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setattrlist(
        arg1: *const ::std::os::raw::c_char,
        arg2: *mut ::std::os::raw::c_void,
        arg3: *mut ::std::os::raw::c_void,
        arg4: size_t,
        arg5: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn exchangedata(
        arg1: *const ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
        arg3: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getdirentriesattr(
        arg1: ::std::os::raw::c_int,
        arg2: *mut ::std::os::raw::c_void,
        arg3: *mut ::std::os::raw::c_void,
        arg4: size_t,
        arg5: *mut ::std::os::raw::c_uint,
        arg6: *mut ::std::os::raw::c_uint,
        arg7: *mut ::std::os::raw::c_uint,
        arg8: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct fssearchblock {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct searchstate {
    _unused: [u8; 0],
}
extern "C" {
    pub fn searchfs(
        arg1: *const ::std::os::raw::c_char,
        arg2: *mut fssearchblock,
        arg3: *mut ::std::os::raw::c_ulong,
        arg4: ::std::os::raw::c_uint,
        arg5: ::std::os::raw::c_uint,
        arg6: *mut searchstate,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fsctl(
        arg1: *const ::std::os::raw::c_char,
        arg2: ::std::os::raw::c_ulong,
        arg3: *mut ::std::os::raw::c_void,
        arg4: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ffsctl(
        arg1: ::std::os::raw::c_int,
        arg2: ::std::os::raw::c_ulong,
        arg3: *mut ::std::os::raw::c_void,
        arg4: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fsync_volume_np(
        arg1: ::std::os::raw::c_int,
        arg2: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sync_volume_np(
        arg1: *const ::std::os::raw::c_char,
        arg2: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub static mut optreset: ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct timeval64 {
    pub tv_sec: __int64_t,
    pub tv_usec: __int64_t,
}
#[test]
fn bindgen_test_layout_timeval64() {
    assert_eq!(
        ::std::mem::size_of::<timeval64>(),
        16usize,
        concat!("Size of: ", stringify!(timeval64))
    );
    assert_eq!(
        ::std::mem::align_of::<timeval64>(),
        8usize,
        concat!("Alignment of ", stringify!(timeval64))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<timeval64>())).tv_sec as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(timeval64),
            "::",
            stringify!(tv_sec)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<timeval64>())).tv_usec as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(timeval64),
            "::",
            stringify!(tv_usec)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct itimerval {
    pub it_interval: timeval,
    pub it_value: timeval,
}
#[test]
fn bindgen_test_layout_itimerval() {
    assert_eq!(
        ::std::mem::size_of::<itimerval>(),
        32usize,
        concat!("Size of: ", stringify!(itimerval))
    );
    assert_eq!(
        ::std::mem::align_of::<itimerval>(),
        8usize,
        concat!("Alignment of ", stringify!(itimerval))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<itimerval>())).it_interval as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(itimerval),
            "::",
            stringify!(it_interval)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<itimerval>())).it_value as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(itimerval),
            "::",
            stringify!(it_value)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct timezone {
    pub tz_minuteswest: ::std::os::raw::c_int,
    pub tz_dsttime: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_timezone() {
    assert_eq!(
        ::std::mem::size_of::<timezone>(),
        8usize,
        concat!("Size of: ", stringify!(timezone))
    );
    assert_eq!(
        ::std::mem::align_of::<timezone>(),
        4usize,
        concat!("Alignment of ", stringify!(timezone))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<timezone>())).tz_minuteswest as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(timezone),
            "::",
            stringify!(tz_minuteswest)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<timezone>())).tz_dsttime as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(timezone),
            "::",
            stringify!(tz_dsttime)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct clockinfo {
    pub hz: ::std::os::raw::c_int,
    pub tick: ::std::os::raw::c_int,
    pub tickadj: ::std::os::raw::c_int,
    pub stathz: ::std::os::raw::c_int,
    pub profhz: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_clockinfo() {
    assert_eq!(
        ::std::mem::size_of::<clockinfo>(),
        20usize,
        concat!("Size of: ", stringify!(clockinfo))
    );
    assert_eq!(
        ::std::mem::align_of::<clockinfo>(),
        4usize,
        concat!("Alignment of ", stringify!(clockinfo))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<clockinfo>())).hz as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(clockinfo),
            "::",
            stringify!(hz)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<clockinfo>())).tick as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(clockinfo),
            "::",
            stringify!(tick)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<clockinfo>())).tickadj as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(clockinfo),
            "::",
            stringify!(tickadj)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<clockinfo>())).stathz as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(clockinfo),
            "::",
            stringify!(stathz)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<clockinfo>())).profhz as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(clockinfo),
            "::",
            stringify!(profhz)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct tm {
    pub tm_sec: ::std::os::raw::c_int,
    pub tm_min: ::std::os::raw::c_int,
    pub tm_hour: ::std::os::raw::c_int,
    pub tm_mday: ::std::os::raw::c_int,
    pub tm_mon: ::std::os::raw::c_int,
    pub tm_year: ::std::os::raw::c_int,
    pub tm_wday: ::std::os::raw::c_int,
    pub tm_yday: ::std::os::raw::c_int,
    pub tm_isdst: ::std::os::raw::c_int,
    pub tm_gmtoff: ::std::os::raw::c_long,
    pub tm_zone: *mut ::std::os::raw::c_char,
}
#[test]
fn bindgen_test_layout_tm() {
    assert_eq!(
        ::std::mem::size_of::<tm>(),
        56usize,
        concat!("Size of: ", stringify!(tm))
    );
    assert_eq!(
        ::std::mem::align_of::<tm>(),
        8usize,
        concat!("Alignment of ", stringify!(tm))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<tm>())).tm_sec as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(tm),
            "::",
            stringify!(tm_sec)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<tm>())).tm_min as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(tm),
            "::",
            stringify!(tm_min)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<tm>())).tm_hour as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(tm),
            "::",
            stringify!(tm_hour)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<tm>())).tm_mday as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(tm),
            "::",
            stringify!(tm_mday)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<tm>())).tm_mon as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(tm),
            "::",
            stringify!(tm_mon)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<tm>())).tm_year as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(tm),
            "::",
            stringify!(tm_year)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<tm>())).tm_wday as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(tm),
            "::",
            stringify!(tm_wday)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<tm>())).tm_yday as *const _ as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(tm),
            "::",
            stringify!(tm_yday)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<tm>())).tm_isdst as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(tm),
            "::",
            stringify!(tm_isdst)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<tm>())).tm_gmtoff as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(tm),
            "::",
            stringify!(tm_gmtoff)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<tm>())).tm_zone as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(tm),
            "::",
            stringify!(tm_zone)
        )
    );
}
extern "C" {
    pub static mut tzname: [*mut ::std::os::raw::c_char; 0usize];
}
extern "C" {
    pub static mut getdate_err: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut timezone: ::std::os::raw::c_long;
}
extern "C" {
    pub static mut daylight: ::std::os::raw::c_int;
}
extern "C" {
    pub fn asctime(arg1: *const tm) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn clock() -> clock_t;
}
extern "C" {
    pub fn ctime(arg1: *const time_t) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn difftime(arg1: time_t, arg2: time_t) -> f64;
}
extern "C" {
    pub fn getdate(arg1: *const ::std::os::raw::c_char) -> *mut tm;
}
extern "C" {
    pub fn gmtime(arg1: *const time_t) -> *mut tm;
}
extern "C" {
    pub fn localtime(arg1: *const time_t) -> *mut tm;
}
extern "C" {
    pub fn mktime(arg1: *mut tm) -> time_t;
}
extern "C" {
    pub fn strftime(
        arg1: *mut ::std::os::raw::c_char,
        arg2: size_t,
        arg3: *const ::std::os::raw::c_char,
        arg4: *const tm,
    ) -> size_t;
}
extern "C" {
    pub fn strptime(
        arg1: *const ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
        arg3: *mut tm,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn time(arg1: *mut time_t) -> time_t;
}
extern "C" {
    pub fn tzset();
}
extern "C" {
    pub fn asctime_r(
        arg1: *const tm,
        arg2: *mut ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn ctime_r(
        arg1: *const time_t,
        arg2: *mut ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn gmtime_r(arg1: *const time_t, arg2: *mut tm) -> *mut tm;
}
extern "C" {
    pub fn localtime_r(arg1: *const time_t, arg2: *mut tm) -> *mut tm;
}
extern "C" {
    pub fn posix2time(arg1: time_t) -> time_t;
}
extern "C" {
    pub fn tzsetwall();
}
extern "C" {
    pub fn time2posix(arg1: time_t) -> time_t;
}
extern "C" {
    pub fn timelocal(arg1: *mut tm) -> time_t;
}
extern "C" {
    pub fn timegm(arg1: *mut tm) -> time_t;
}
extern "C" {
    pub fn nanosleep(__rqtp: *const timespec, __rmtp: *mut timespec) -> ::std::os::raw::c_int;
}
pub const clockid_t__CLOCK_REALTIME: clockid_t = 0;
pub const clockid_t__CLOCK_MONOTONIC: clockid_t = 6;
pub const clockid_t__CLOCK_MONOTONIC_RAW: clockid_t = 4;
pub const clockid_t__CLOCK_MONOTONIC_RAW_APPROX: clockid_t = 5;
pub const clockid_t__CLOCK_UPTIME_RAW: clockid_t = 8;
pub const clockid_t__CLOCK_UPTIME_RAW_APPROX: clockid_t = 9;
pub const clockid_t__CLOCK_PROCESS_CPUTIME_ID: clockid_t = 12;
pub const clockid_t__CLOCK_THREAD_CPUTIME_ID: clockid_t = 16;
pub type clockid_t = ::std::os::raw::c_uint;
extern "C" {
    pub fn clock_getres(__clock_id: clockid_t, __res: *mut timespec) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn clock_gettime(__clock_id: clockid_t, __tp: *mut timespec) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn clock_gettime_nsec_np(__clock_id: clockid_t) -> __uint64_t;
}
extern "C" {
    pub fn clock_settime(__clock_id: clockid_t, __tp: *const timespec) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn timespec_get(ts: *mut timespec, base: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn adjtime(arg1: *const timeval, arg2: *mut timeval) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn futimes(arg1: ::std::os::raw::c_int, arg2: *const timeval) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn lutimes(
        arg1: *const ::std::os::raw::c_char,
        arg2: *const timeval,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn settimeofday(arg1: *const timeval, arg2: *const timezone) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getitimer(arg1: ::std::os::raw::c_int, arg2: *mut itimerval) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn gettimeofday(
        arg1: *mut timeval,
        arg2: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setitimer(
        arg1: ::std::os::raw::c_int,
        arg2: *const itimerval,
        arg3: *mut itimerval,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn utimes(
        arg1: *const ::std::os::raw::c_char,
        arg2: *const timeval,
    ) -> ::std::os::raw::c_int;
}
pub const RSysArch_R_SYS_ARCH_NONE: RSysArch = 0;
pub const RSysArch_R_SYS_ARCH_X86: RSysArch = 1;
pub const RSysArch_R_SYS_ARCH_ARM: RSysArch = 2;
pub const RSysArch_R_SYS_ARCH_PPC: RSysArch = 3;
pub const RSysArch_R_SYS_ARCH_M68K: RSysArch = 4;
pub const RSysArch_R_SYS_ARCH_JAVA: RSysArch = 5;
pub const RSysArch_R_SYS_ARCH_MIPS: RSysArch = 6;
pub const RSysArch_R_SYS_ARCH_SPARC: RSysArch = 7;
pub const RSysArch_R_SYS_ARCH_XAP: RSysArch = 8;
pub const RSysArch_R_SYS_ARCH_MSIL: RSysArch = 9;
pub const RSysArch_R_SYS_ARCH_OBJD: RSysArch = 10;
pub const RSysArch_R_SYS_ARCH_BF: RSysArch = 11;
pub const RSysArch_R_SYS_ARCH_SH: RSysArch = 12;
pub const RSysArch_R_SYS_ARCH_AVR: RSysArch = 13;
pub const RSysArch_R_SYS_ARCH_DALVIK: RSysArch = 14;
pub const RSysArch_R_SYS_ARCH_Z80: RSysArch = 15;
pub const RSysArch_R_SYS_ARCH_ARC: RSysArch = 16;
pub const RSysArch_R_SYS_ARCH_I8080: RSysArch = 17;
pub const RSysArch_R_SYS_ARCH_RAR: RSysArch = 18;
pub const RSysArch_R_SYS_ARCH_8051: RSysArch = 19;
pub const RSysArch_R_SYS_ARCH_TMS320: RSysArch = 20;
pub const RSysArch_R_SYS_ARCH_EBC: RSysArch = 21;
pub const RSysArch_R_SYS_ARCH_H8300: RSysArch = 22;
pub const RSysArch_R_SYS_ARCH_CR16: RSysArch = 23;
pub const RSysArch_R_SYS_ARCH_V850: RSysArch = 24;
pub const RSysArch_R_SYS_ARCH_S390: RSysArch = 25;
pub const RSysArch_R_SYS_ARCH_XCORE: RSysArch = 26;
pub const RSysArch_R_SYS_ARCH_PROPELLER: RSysArch = 27;
pub const RSysArch_R_SYS_ARCH_MSP430: RSysArch = 28;
pub const RSysArch_R_SYS_ARCH_CRIS: RSysArch = 29;
pub const RSysArch_R_SYS_ARCH_HPPA: RSysArch = 30;
pub const RSysArch_R_SYS_ARCH_V810: RSysArch = 31;
pub const RSysArch_R_SYS_ARCH_LM32: RSysArch = 32;
pub const RSysArch_R_SYS_ARCH_RISCV: RSysArch = 33;
pub type RSysArch = ::std::os::raw::c_uint;
pub type RRef = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RStrBuf {
    pub buf: [::std::os::raw::c_char; 32usize],
    pub len: size_t,
    pub ptr: *mut ::std::os::raw::c_char,
    pub ptrlen: size_t,
    pub weakref: bool,
}
#[test]
fn bindgen_test_layout_RStrBuf() {
    assert_eq!(
        ::std::mem::size_of::<RStrBuf>(),
        64usize,
        concat!("Size of: ", stringify!(RStrBuf))
    );
    assert_eq!(
        ::std::mem::align_of::<RStrBuf>(),
        8usize,
        concat!("Alignment of ", stringify!(RStrBuf))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RStrBuf>())).buf as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(RStrBuf),
            "::",
            stringify!(buf)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RStrBuf>())).len as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(RStrBuf),
            "::",
            stringify!(len)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RStrBuf>())).ptr as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(RStrBuf),
            "::",
            stringify!(ptr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RStrBuf>())).ptrlen as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(RStrBuf),
            "::",
            stringify!(ptrlen)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RStrBuf>())).weakref as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(RStrBuf),
            "::",
            stringify!(weakref)
        )
    );
}
extern "C" {
    pub fn r_strbuf_new(s: *const ::std::os::raw::c_char) -> *mut RStrBuf;
}
extern "C" {
    pub fn r_strbuf_set(
        sb: *mut RStrBuf,
        s: *const ::std::os::raw::c_char,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_strbuf_slice(
        sb: *mut RStrBuf,
        from: ::std::os::raw::c_int,
        len: ::std::os::raw::c_int,
    ) -> bool;
}
extern "C" {
    pub fn r_strbuf_setbin(
        sb: *mut RStrBuf,
        s: *const ::std::os::raw::c_uchar,
        len: size_t,
    ) -> bool;
}
extern "C" {
    pub fn r_strbuf_getbin(
        sb: *mut RStrBuf,
        len: *mut ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_uchar;
}
extern "C" {
    pub fn r_strbuf_setf(
        sb: *mut RStrBuf,
        fmt: *const ::std::os::raw::c_char,
        ...
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_strbuf_vsetf(
        sb: *mut RStrBuf,
        fmt: *const ::std::os::raw::c_char,
        ap: *mut __va_list_tag,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_strbuf_append(sb: *mut RStrBuf, s: *const ::std::os::raw::c_char) -> bool;
}
extern "C" {
    pub fn r_strbuf_append_n(sb: *mut RStrBuf, s: *const ::std::os::raw::c_char, l: size_t)
        -> bool;
}
extern "C" {
    pub fn r_strbuf_prepend(sb: *mut RStrBuf, s: *const ::std::os::raw::c_char) -> bool;
}
extern "C" {
    pub fn r_strbuf_appendf(sb: *mut RStrBuf, fmt: *const ::std::os::raw::c_char, ...) -> bool;
}
extern "C" {
    pub fn r_strbuf_vappendf(
        sb: *mut RStrBuf,
        fmt: *const ::std::os::raw::c_char,
        ap: *mut __va_list_tag,
    ) -> bool;
}
extern "C" {
    pub fn r_strbuf_get(sb: *mut RStrBuf) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_strbuf_drain(sb: *mut RStrBuf) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_strbuf_drain_nofree(sb: *mut RStrBuf) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_strbuf_length(sb: *mut RStrBuf) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_strbuf_size(sb: *mut RStrBuf) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_strbuf_free(sb: *mut RStrBuf);
}
extern "C" {
    pub fn r_strbuf_fini(sb: *mut RStrBuf);
}
extern "C" {
    pub fn r_strbuf_init(sb: *mut RStrBuf);
}
extern "C" {
    pub fn r_strbuf_initf(
        sb: *mut RStrBuf,
        fmt: *const ::std::os::raw::c_char,
        ...
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_strbuf_copy(dst: *mut RStrBuf, src: *mut RStrBuf) -> bool;
}
extern "C" {
    pub fn r_strbuf_equals(sa: *mut RStrBuf, sb: *mut RStrBuf) -> bool;
}
extern "C" {
    pub fn r_strbuf_reserve(sb: *mut RStrBuf, len: size_t) -> bool;
}
extern "C" {
    pub fn r_strbuf_is_empty(sb: *mut RStrBuf) -> bool;
}
extern "C" {
    pub fn r_strbuf_setptr(
        sb: *mut RStrBuf,
        p: *mut ::std::os::raw::c_char,
        l: ::std::os::raw::c_int,
    ) -> bool;
}
pub const PJEncodingStr_PJ_ENCODING_STR_DEFAULT: PJEncodingStr = 0;
pub const PJEncodingStr_PJ_ENCODING_STR_BASE64: PJEncodingStr = 1;
pub const PJEncodingStr_PJ_ENCODING_STR_HEX: PJEncodingStr = 2;
pub const PJEncodingStr_PJ_ENCODING_STR_ARRAY: PJEncodingStr = 3;
pub const PJEncodingStr_PJ_ENCODING_STR_STRIP: PJEncodingStr = 4;
pub type PJEncodingStr = ::std::os::raw::c_uint;
pub const PJEncodingNum_PJ_ENCODING_NUM_DEFAULT: PJEncodingNum = 0;
pub const PJEncodingNum_PJ_ENCODING_NUM_STR: PJEncodingNum = 1;
pub const PJEncodingNum_PJ_ENCODING_NUM_HEX: PJEncodingNum = 2;
pub type PJEncodingNum = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pj_t {
    pub sb: RStrBuf,
    pub is_first: bool,
    pub is_key: bool,
    pub braces: [::std::os::raw::c_char; 128usize],
    pub level: ::std::os::raw::c_int,
    pub str_encoding: PJEncodingStr,
    pub num_encoding: PJEncodingNum,
}
#[test]
fn bindgen_test_layout_pj_t() {
    assert_eq!(
        ::std::mem::size_of::<pj_t>(),
        208usize,
        concat!("Size of: ", stringify!(pj_t))
    );
    assert_eq!(
        ::std::mem::align_of::<pj_t>(),
        8usize,
        concat!("Alignment of ", stringify!(pj_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pj_t>())).sb as *const _ as usize },
        0usize,
        concat!("Offset of field: ", stringify!(pj_t), "::", stringify!(sb))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pj_t>())).is_first as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(pj_t),
            "::",
            stringify!(is_first)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pj_t>())).is_key as *const _ as usize },
        65usize,
        concat!(
            "Offset of field: ",
            stringify!(pj_t),
            "::",
            stringify!(is_key)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pj_t>())).braces as *const _ as usize },
        66usize,
        concat!(
            "Offset of field: ",
            stringify!(pj_t),
            "::",
            stringify!(braces)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pj_t>())).level as *const _ as usize },
        196usize,
        concat!(
            "Offset of field: ",
            stringify!(pj_t),
            "::",
            stringify!(level)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pj_t>())).str_encoding as *const _ as usize },
        200usize,
        concat!(
            "Offset of field: ",
            stringify!(pj_t),
            "::",
            stringify!(str_encoding)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pj_t>())).num_encoding as *const _ as usize },
        204usize,
        concat!(
            "Offset of field: ",
            stringify!(pj_t),
            "::",
            stringify!(num_encoding)
        )
    );
}
pub type PJ = pj_t;
extern "C" {
    pub fn pj_new() -> *mut PJ;
}
extern "C" {
    pub fn pj_new_with_encoding(
        str_encoding: PJEncodingStr,
        num_encoding: PJEncodingNum,
    ) -> *mut PJ;
}
extern "C" {
    pub fn pj_free(j: *mut PJ);
}
extern "C" {
    pub fn pj_reset(j: *mut PJ);
}
extern "C" {
    pub fn pj_drain(j: *mut PJ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn pj_string(pj: *mut PJ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn pj_end(j: *mut PJ) -> *mut PJ;
}
extern "C" {
    pub fn pj_raw(j: *mut PJ, k: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn pj_o(j: *mut PJ) -> *mut PJ;
}
extern "C" {
    pub fn pj_a(j: *mut PJ) -> *mut PJ;
}
extern "C" {
    pub fn pj_k(j: *mut PJ, k: *const ::std::os::raw::c_char) -> *mut PJ;
}
extern "C" {
    pub fn pj_knull(j: *mut PJ, k: *const ::std::os::raw::c_char) -> *mut PJ;
}
extern "C" {
    pub fn pj_kn(
        j: *mut PJ,
        k: *const ::std::os::raw::c_char,
        n: ::std::os::raw::c_ulonglong,
    ) -> *mut PJ;
}
extern "C" {
    pub fn pj_kN(
        j: *mut PJ,
        k: *const ::std::os::raw::c_char,
        n: ::std::os::raw::c_longlong,
    ) -> *mut PJ;
}
extern "C" {
    pub fn pj_ks(
        j: *mut PJ,
        k: *const ::std::os::raw::c_char,
        v: *const ::std::os::raw::c_char,
    ) -> *mut PJ;
}
extern "C" {
    pub fn pj_ka(j: *mut PJ, k: *const ::std::os::raw::c_char) -> *mut PJ;
}
extern "C" {
    pub fn pj_ko(j: *mut PJ, k: *const ::std::os::raw::c_char) -> *mut PJ;
}
extern "C" {
    pub fn pj_ki(j: *mut PJ, k: *const ::std::os::raw::c_char, d: ::std::os::raw::c_int)
        -> *mut PJ;
}
extern "C" {
    pub fn pj_kd(j: *mut PJ, k: *const ::std::os::raw::c_char, d: f64) -> *mut PJ;
}
extern "C" {
    pub fn pj_kf(j: *mut PJ, k: *const ::std::os::raw::c_char, d: f32) -> *mut PJ;
}
extern "C" {
    pub fn pj_kb(j: *mut PJ, k: *const ::std::os::raw::c_char, v: bool) -> *mut PJ;
}
extern "C" {
    pub fn pj_null(j: *mut PJ) -> *mut PJ;
}
extern "C" {
    pub fn pj_r(j: *mut PJ, v: *const ::std::os::raw::c_uchar, v_len: size_t) -> *mut PJ;
}
extern "C" {
    pub fn pj_kr(
        j: *mut PJ,
        k: *const ::std::os::raw::c_char,
        v: *const ::std::os::raw::c_uchar,
        v_len: size_t,
    ) -> *mut PJ;
}
extern "C" {
    pub fn pj_s(j: *mut PJ, k: *const ::std::os::raw::c_char) -> *mut PJ;
}
extern "C" {
    pub fn pj_j(j: *mut PJ, k: *const ::std::os::raw::c_char) -> *mut PJ;
}
extern "C" {
    pub fn pj_se(j: *mut PJ, k: *const ::std::os::raw::c_char) -> *mut PJ;
}
extern "C" {
    pub fn pj_ne(j: *mut PJ, n: ::std::os::raw::c_ulonglong) -> *mut PJ;
}
extern "C" {
    pub fn pj_n(j: *mut PJ, n: ::std::os::raw::c_ulonglong) -> *mut PJ;
}
extern "C" {
    pub fn pj_N(j: *mut PJ, n: ::std::os::raw::c_longlong) -> *mut PJ;
}
extern "C" {
    pub fn pj_i(j: *mut PJ, d: ::std::os::raw::c_int) -> *mut PJ;
}
extern "C" {
    pub fn pj_d(j: *mut PJ, d: f64) -> *mut PJ;
}
extern "C" {
    pub fn pj_f(j: *mut PJ, d: f32) -> *mut PJ;
}
extern "C" {
    pub fn pj_b(j: *mut PJ, v: bool) -> *mut PJ;
}
extern "C" {
    pub fn r_flist_resize(
        it: *mut *mut ::std::os::raw::c_void,
        n: ::std::os::raw::c_int,
    ) -> *mut *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn imaxabs(j: intmax_t) -> intmax_t;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct imaxdiv_t {
    pub quot: intmax_t,
    pub rem: intmax_t,
}
#[test]
fn bindgen_test_layout_imaxdiv_t() {
    assert_eq!(
        ::std::mem::size_of::<imaxdiv_t>(),
        16usize,
        concat!("Size of: ", stringify!(imaxdiv_t))
    );
    assert_eq!(
        ::std::mem::align_of::<imaxdiv_t>(),
        8usize,
        concat!("Alignment of ", stringify!(imaxdiv_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<imaxdiv_t>())).quot as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(imaxdiv_t),
            "::",
            stringify!(quot)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<imaxdiv_t>())).rem as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(imaxdiv_t),
            "::",
            stringify!(rem)
        )
    );
}
extern "C" {
    pub fn imaxdiv(__numer: intmax_t, __denom: intmax_t) -> imaxdiv_t;
}
extern "C" {
    pub fn strtoimax(
        __nptr: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
        __base: ::std::os::raw::c_int,
    ) -> intmax_t;
}
extern "C" {
    pub fn strtoumax(
        __nptr: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
        __base: ::std::os::raw::c_int,
    ) -> uintmax_t;
}
extern "C" {
    pub fn wcstoimax(
        __nptr: *const wchar_t,
        __endptr: *mut *mut wchar_t,
        __base: ::std::os::raw::c_int,
    ) -> intmax_t;
}
extern "C" {
    pub fn wcstoumax(
        __nptr: *const wchar_t,
        __endptr: *mut *mut wchar_t,
        __base: ::std::os::raw::c_int,
    ) -> uintmax_t;
}
pub type SdbListFree =
    ::std::option::Option<unsafe extern "C" fn(ptr: *mut ::std::os::raw::c_void)>;
pub type SdbListComparator = ::std::option::Option<
    unsafe extern "C" fn(
        a: *const ::std::os::raw::c_void,
        b: *const ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int,
>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ls_iter_t {
    pub data: *mut ::std::os::raw::c_void,
    pub n: *mut ls_iter_t,
    pub p: *mut ls_iter_t,
}
#[test]
fn bindgen_test_layout_ls_iter_t() {
    assert_eq!(
        ::std::mem::size_of::<ls_iter_t>(),
        24usize,
        concat!("Size of: ", stringify!(ls_iter_t))
    );
    assert_eq!(
        ::std::mem::align_of::<ls_iter_t>(),
        8usize,
        concat!("Alignment of ", stringify!(ls_iter_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ls_iter_t>())).data as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(ls_iter_t),
            "::",
            stringify!(data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ls_iter_t>())).n as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(ls_iter_t),
            "::",
            stringify!(n)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ls_iter_t>())).p as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(ls_iter_t),
            "::",
            stringify!(p)
        )
    );
}
pub type SdbListIter = ls_iter_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ls_t {
    pub length: size_t,
    pub head: *mut SdbListIter,
    pub tail: *mut SdbListIter,
    pub free: SdbListFree,
    pub cmp: SdbListComparator,
    pub sorted: bool,
}
#[test]
fn bindgen_test_layout_ls_t() {
    assert_eq!(
        ::std::mem::size_of::<ls_t>(),
        48usize,
        concat!("Size of: ", stringify!(ls_t))
    );
    assert_eq!(
        ::std::mem::align_of::<ls_t>(),
        8usize,
        concat!("Alignment of ", stringify!(ls_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ls_t>())).length as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(ls_t),
            "::",
            stringify!(length)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ls_t>())).head as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(ls_t),
            "::",
            stringify!(head)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ls_t>())).tail as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(ls_t),
            "::",
            stringify!(tail)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ls_t>())).free as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(ls_t),
            "::",
            stringify!(free)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ls_t>())).cmp as *const _ as usize },
        32usize,
        concat!("Offset of field: ", stringify!(ls_t), "::", stringify!(cmp))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ls_t>())).sorted as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(ls_t),
            "::",
            stringify!(sorted)
        )
    );
}
pub type SdbList = ls_t;
extern "C" {
    pub fn ls_new() -> *mut SdbList;
}
extern "C" {
    pub fn ls_newf(freefn: SdbListFree) -> *mut SdbList;
}
extern "C" {
    pub fn ls_append(list: *mut SdbList, data: *mut ::std::os::raw::c_void) -> *mut SdbListIter;
}
extern "C" {
    pub fn ls_prepend(list: *mut SdbList, data: *mut ::std::os::raw::c_void) -> *mut SdbListIter;
}
extern "C" {
    pub fn ls_sort(list: *mut SdbList, cmp: SdbListComparator) -> bool;
}
extern "C" {
    pub fn ls_merge_sort(list: *mut SdbList, cmp: SdbListComparator) -> bool;
}
extern "C" {
    pub fn ls_delete(list: *mut SdbList, iter: *mut SdbListIter);
}
extern "C" {
    pub fn ls_delete_data(list: *mut SdbList, ptr: *mut ::std::os::raw::c_void) -> bool;
}
extern "C" {
    pub fn ls_iter_init(iter: *mut SdbListIter, list: *mut SdbList);
}
extern "C" {
    pub fn ls_destroy(list: *mut SdbList);
}
extern "C" {
    pub fn ls_free(list: *mut SdbList);
}
extern "C" {
    pub fn ls_item_new(data: *mut ::std::os::raw::c_void) -> *mut SdbListIter;
}
extern "C" {
    pub fn ls_unlink(list: *mut SdbList, ptr: *mut ::std::os::raw::c_void);
}
extern "C" {
    pub fn ls_split(list: *mut SdbList, ptr: *mut ::std::os::raw::c_void);
}
extern "C" {
    pub fn ls_split_iter(list: *mut SdbList, iter: *mut SdbListIter);
}
extern "C" {
    pub fn ls_get_n(list: *mut SdbList, n: ::std::os::raw::c_int) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn ls_get_top(list: *mut SdbList) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn ls_pop(list: *mut SdbList) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn ls_reverse(list: *mut SdbList);
}
extern "C" {
    pub fn ls_clone(list: *mut SdbList) -> *mut SdbList;
}
extern "C" {
    pub fn ls_join(first: *mut SdbList, second: *mut SdbList) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ls_del_n(list: *mut SdbList, n: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ls_insert(
        list: *mut SdbList,
        n: ::std::os::raw::c_int,
        data: *mut ::std::os::raw::c_void,
    ) -> *mut SdbListIter;
}
extern "C" {
    pub fn ls_pop_head(list: *mut SdbList) -> *mut ::std::os::raw::c_void;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ht_pp_kv {
    pub key: *mut ::std::os::raw::c_void,
    pub value: *mut ::std::os::raw::c_void,
    pub key_len: ::std::os::raw::c_uint,
    pub value_len: ::std::os::raw::c_uint,
}
#[test]
fn bindgen_test_layout_ht_pp_kv() {
    assert_eq!(
        ::std::mem::size_of::<ht_pp_kv>(),
        24usize,
        concat!("Size of: ", stringify!(ht_pp_kv))
    );
    assert_eq!(
        ::std::mem::align_of::<ht_pp_kv>(),
        8usize,
        concat!("Alignment of ", stringify!(ht_pp_kv))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ht_pp_kv>())).key as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(ht_pp_kv),
            "::",
            stringify!(key)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ht_pp_kv>())).value as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(ht_pp_kv),
            "::",
            stringify!(value)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ht_pp_kv>())).key_len as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(ht_pp_kv),
            "::",
            stringify!(key_len)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ht_pp_kv>())).value_len as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(ht_pp_kv),
            "::",
            stringify!(value_len)
        )
    );
}
pub type HtPPKv = ht_pp_kv;
pub type HtPPKvFreeFunc = ::std::option::Option<unsafe extern "C" fn(arg1: *mut HtPPKv)>;
pub type HtPPDupKey = ::std::option::Option<
    unsafe extern "C" fn(arg1: *const ::std::os::raw::c_void) -> *mut ::std::os::raw::c_void,
>;
pub type HtPPDupValue = ::std::option::Option<
    unsafe extern "C" fn(arg1: *const ::std::os::raw::c_void) -> *mut ::std::os::raw::c_void,
>;
pub type HtPPCalcSizeK = ::std::option::Option<
    unsafe extern "C" fn(arg1: *const ::std::os::raw::c_void) -> ::std::os::raw::c_uint,
>;
pub type HtPPCalcSizeV = ::std::option::Option<
    unsafe extern "C" fn(arg1: *const ::std::os::raw::c_void) -> ::std::os::raw::c_uint,
>;
pub type HtPPHashFunction = ::std::option::Option<
    unsafe extern "C" fn(arg1: *const ::std::os::raw::c_void) -> ::std::os::raw::c_uint,
>;
pub type HtPPListComparator = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: *const ::std::os::raw::c_void,
        arg2: *const ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int,
>;
pub type HtPPForeachCallback = ::std::option::Option<
    unsafe extern "C" fn(
        user: *mut ::std::os::raw::c_void,
        arg1: *const ::std::os::raw::c_void,
        arg2: *const ::std::os::raw::c_void,
    ) -> bool,
>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ht_pp_bucket_t {
    pub arr: *mut HtPPKv,
    pub count: ::std::os::raw::c_uint,
}
#[test]
fn bindgen_test_layout_ht_pp_bucket_t() {
    assert_eq!(
        ::std::mem::size_of::<ht_pp_bucket_t>(),
        16usize,
        concat!("Size of: ", stringify!(ht_pp_bucket_t))
    );
    assert_eq!(
        ::std::mem::align_of::<ht_pp_bucket_t>(),
        8usize,
        concat!("Alignment of ", stringify!(ht_pp_bucket_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ht_pp_bucket_t>())).arr as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(ht_pp_bucket_t),
            "::",
            stringify!(arr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ht_pp_bucket_t>())).count as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(ht_pp_bucket_t),
            "::",
            stringify!(count)
        )
    );
}
pub type HtPPBucket = ht_pp_bucket_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ht_pp_options_t {
    pub cmp: HtPPListComparator,
    pub hashfn: HtPPHashFunction,
    pub dupkey: HtPPDupKey,
    pub dupvalue: HtPPDupValue,
    pub calcsizeK: HtPPCalcSizeK,
    pub calcsizeV: HtPPCalcSizeV,
    pub freefn: HtPPKvFreeFunc,
    pub elem_size: size_t,
}
#[test]
fn bindgen_test_layout_ht_pp_options_t() {
    assert_eq!(
        ::std::mem::size_of::<ht_pp_options_t>(),
        64usize,
        concat!("Size of: ", stringify!(ht_pp_options_t))
    );
    assert_eq!(
        ::std::mem::align_of::<ht_pp_options_t>(),
        8usize,
        concat!("Alignment of ", stringify!(ht_pp_options_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ht_pp_options_t>())).cmp as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(ht_pp_options_t),
            "::",
            stringify!(cmp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ht_pp_options_t>())).hashfn as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(ht_pp_options_t),
            "::",
            stringify!(hashfn)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ht_pp_options_t>())).dupkey as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(ht_pp_options_t),
            "::",
            stringify!(dupkey)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ht_pp_options_t>())).dupvalue as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(ht_pp_options_t),
            "::",
            stringify!(dupvalue)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ht_pp_options_t>())).calcsizeK as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(ht_pp_options_t),
            "::",
            stringify!(calcsizeK)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ht_pp_options_t>())).calcsizeV as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(ht_pp_options_t),
            "::",
            stringify!(calcsizeV)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ht_pp_options_t>())).freefn as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(ht_pp_options_t),
            "::",
            stringify!(freefn)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ht_pp_options_t>())).elem_size as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(ht_pp_options_t),
            "::",
            stringify!(elem_size)
        )
    );
}
pub type HtPPOptions = ht_pp_options_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ht_pp_t {
    pub size: ::std::os::raw::c_uint,
    pub count: ::std::os::raw::c_uint,
    pub table: *mut HtPPBucket,
    pub prime_idx: ::std::os::raw::c_uint,
    pub opt: HtPPOptions,
}
#[test]
fn bindgen_test_layout_ht_pp_t() {
    assert_eq!(
        ::std::mem::size_of::<ht_pp_t>(),
        88usize,
        concat!("Size of: ", stringify!(ht_pp_t))
    );
    assert_eq!(
        ::std::mem::align_of::<ht_pp_t>(),
        8usize,
        concat!("Alignment of ", stringify!(ht_pp_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ht_pp_t>())).size as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(ht_pp_t),
            "::",
            stringify!(size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ht_pp_t>())).count as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(ht_pp_t),
            "::",
            stringify!(count)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ht_pp_t>())).table as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(ht_pp_t),
            "::",
            stringify!(table)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ht_pp_t>())).prime_idx as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(ht_pp_t),
            "::",
            stringify!(prime_idx)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ht_pp_t>())).opt as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(ht_pp_t),
            "::",
            stringify!(opt)
        )
    );
}
pub type HtPP = ht_pp_t;
extern "C" {
    pub fn ht_pp_new_opt(opt: *mut HtPPOptions) -> *mut HtPP;
}
extern "C" {
    pub fn ht_pp_free(ht: *mut HtPP);
}
extern "C" {
    pub fn ht_pp_insert(
        ht: *mut HtPP,
        key: *const ::std::os::raw::c_void,
        value: *mut ::std::os::raw::c_void,
    ) -> bool;
}
extern "C" {
    pub fn ht_pp_update(
        ht: *mut HtPP,
        key: *const ::std::os::raw::c_void,
        value: *mut ::std::os::raw::c_void,
    ) -> bool;
}
extern "C" {
    pub fn ht_pp_update_key(
        ht: *mut HtPP,
        old_key: *const ::std::os::raw::c_void,
        new_key: *const ::std::os::raw::c_void,
    ) -> bool;
}
extern "C" {
    pub fn ht_pp_delete(ht: *mut HtPP, key: *const ::std::os::raw::c_void) -> bool;
}
extern "C" {
    pub fn ht_pp_find(
        ht: *mut HtPP,
        key: *const ::std::os::raw::c_void,
        found: *mut bool,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn ht_pp_foreach(ht: *mut HtPP, cb: HtPPForeachCallback, user: *mut ::std::os::raw::c_void);
}
extern "C" {
    pub fn ht_pp_find_kv(
        ht: *mut HtPP,
        key: *const ::std::os::raw::c_void,
        found: *mut bool,
    ) -> *mut HtPPKv;
}
extern "C" {
    pub fn ht_pp_insert_kv(ht: *mut HtPP, kv: *mut HtPPKv, update: bool) -> bool;
}
extern "C" {
    pub fn ht_pp_new0() -> *mut HtPP;
}
extern "C" {
    pub fn ht_pp_new(
        valdup: HtPPDupValue,
        pair_free: HtPPKvFreeFunc,
        valueSize: HtPPCalcSizeV,
    ) -> *mut HtPP;
}
extern "C" {
    pub fn ht_pp_new_size(
        initial_size: ::std::os::raw::c_uint,
        valdup: HtPPDupValue,
        pair_free: HtPPKvFreeFunc,
        valueSize: HtPPCalcSizeV,
    ) -> *mut HtPP;
}
#[doc = " keyvalue pair"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct sdb_kv {
    pub base: HtPPKv,
    pub cas: ::std::os::raw::c_uint,
    pub expire: ::std::os::raw::c_ulonglong,
}
#[test]
fn bindgen_test_layout_sdb_kv() {
    assert_eq!(
        ::std::mem::size_of::<sdb_kv>(),
        40usize,
        concat!("Size of: ", stringify!(sdb_kv))
    );
    assert_eq!(
        ::std::mem::align_of::<sdb_kv>(),
        8usize,
        concat!("Alignment of ", stringify!(sdb_kv))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sdb_kv>())).base as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sdb_kv),
            "::",
            stringify!(base)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sdb_kv>())).cas as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(sdb_kv),
            "::",
            stringify!(cas)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sdb_kv>())).expire as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(sdb_kv),
            "::",
            stringify!(expire)
        )
    );
}
#[doc = " keyvalue pair"]
pub type SdbKv = sdb_kv;
extern "C" {
    pub fn sdbkv_new2(
        k: *const ::std::os::raw::c_char,
        kl: ::std::os::raw::c_int,
        v: *const ::std::os::raw::c_char,
        vl: ::std::os::raw::c_int,
    ) -> *mut SdbKv;
}
extern "C" {
    pub fn sdbkv_new(
        k: *const ::std::os::raw::c_char,
        v: *const ::std::os::raw::c_char,
    ) -> *mut SdbKv;
}
extern "C" {
    pub fn sdbkv_free(kv: *mut SdbKv);
}
extern "C" {
    pub fn sdb_hash(key: *const ::std::os::raw::c_char) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn sdb_ht_new() -> *mut HtPP;
}
extern "C" {
    pub fn sdb_ht_free(ht: *mut HtPP);
}
extern "C" {
    pub fn sdb_ht_insert(
        ht: *mut HtPP,
        key: *const ::std::os::raw::c_char,
        value: *const ::std::os::raw::c_char,
    ) -> bool;
}
extern "C" {
    pub fn sdb_ht_insert_kvp(ht: *mut HtPP, kvp: *mut SdbKv, update: bool) -> bool;
}
extern "C" {
    pub fn sdb_ht_update(
        ht: *mut HtPP,
        key: *const ::std::os::raw::c_char,
        value: *const ::std::os::raw::c_char,
    ) -> bool;
}
extern "C" {
    pub fn sdb_ht_delete(ht: *mut HtPP, key: *const ::std::os::raw::c_char) -> bool;
}
extern "C" {
    pub fn sdb_ht_find(
        ht: *mut HtPP,
        key: *const ::std::os::raw::c_char,
        found: *mut bool,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn sdb_ht_find_kvp(
        ht: *mut HtPP,
        key: *const ::std::os::raw::c_char,
        found: *mut bool,
    ) -> *mut SdbKv;
}
pub type dicti = ::std::os::raw::c_ulonglong;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct dictkv {
    pub k: dicti,
    pub v: dicti,
    pub u: *mut ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout_dictkv() {
    assert_eq!(
        ::std::mem::size_of::<dictkv>(),
        24usize,
        concat!("Size of: ", stringify!(dictkv))
    );
    assert_eq!(
        ::std::mem::align_of::<dictkv>(),
        8usize,
        concat!("Alignment of ", stringify!(dictkv))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<dictkv>())).k as *const _ as usize },
        0usize,
        concat!("Offset of field: ", stringify!(dictkv), "::", stringify!(k))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<dictkv>())).v as *const _ as usize },
        8usize,
        concat!("Offset of field: ", stringify!(dictkv), "::", stringify!(v))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<dictkv>())).u as *const _ as usize },
        16usize,
        concat!("Offset of field: ", stringify!(dictkv), "::", stringify!(u))
    );
}
pub type dict_freecb =
    ::std::option::Option<unsafe extern "C" fn(arg1: *mut ::std::os::raw::c_void)>;
pub type dictkv_cb = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: *mut dictkv,
        arg2: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int,
>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct dict {
    pub table: *mut *mut ::std::os::raw::c_void,
    pub f: dict_freecb,
    pub size: ::std::os::raw::c_uint,
}
#[test]
fn bindgen_test_layout_dict() {
    assert_eq!(
        ::std::mem::size_of::<dict>(),
        24usize,
        concat!("Size of: ", stringify!(dict))
    );
    assert_eq!(
        ::std::mem::align_of::<dict>(),
        8usize,
        concat!("Alignment of ", stringify!(dict))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<dict>())).table as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(dict),
            "::",
            stringify!(table)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<dict>())).f as *const _ as usize },
        8usize,
        concat!("Offset of field: ", stringify!(dict), "::", stringify!(f))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<dict>())).size as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(dict),
            "::",
            stringify!(size)
        )
    );
}
pub type SdbMini = dict;
extern "C" {
    pub fn dict_new(size: ::std::os::raw::c_uint, f: dict_freecb) -> *mut dict;
}
extern "C" {
    pub fn dict_free(arg1: *mut dict);
}
extern "C" {
    pub fn dict_init(m: *mut dict, arg1: ::std::os::raw::c_uint, f: dict_freecb) -> bool;
}
extern "C" {
    pub fn dict_fini(m: *mut dict);
}
extern "C" {
    pub fn dict_stats(m: *mut dict);
}
extern "C" {
    pub fn dict_hash(s: *const ::std::os::raw::c_char) -> dicti;
}
extern "C" {
    pub fn dict_set(m: *mut dict, k: dicti, v: dicti, u: *mut ::std::os::raw::c_void) -> bool;
}
extern "C" {
    pub fn dict_getr(m: *mut dict, k: dicti) -> *mut dictkv;
}
extern "C" {
    pub fn dict_get(m: *mut dict, k: dicti) -> dicti;
}
extern "C" {
    pub fn dict_getu(m: *mut dict, k: dicti) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn dict_add(m: *mut dict, k: dicti, v: dicti, u: *mut ::std::os::raw::c_void) -> bool;
}
extern "C" {
    pub fn dict_del(m: *mut dict, k: dicti) -> bool;
}
extern "C" {
    pub fn dict_foreach(m: *mut dict, cb: dictkv_cb, u: *mut ::std::os::raw::c_void);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cdb {
    pub map: *mut ::std::os::raw::c_char,
    pub fd: ::std::os::raw::c_int,
    pub size: ::std::os::raw::c_uint,
    pub loop_: ::std::os::raw::c_uint,
    pub khash: ::std::os::raw::c_uint,
    pub kpos: ::std::os::raw::c_uint,
    pub hpos: ::std::os::raw::c_uint,
    pub hslots: ::std::os::raw::c_uint,
    pub dpos: ::std::os::raw::c_uint,
    pub dlen: ::std::os::raw::c_uint,
}
#[test]
fn bindgen_test_layout_cdb() {
    assert_eq!(
        ::std::mem::size_of::<cdb>(),
        48usize,
        concat!("Size of: ", stringify!(cdb))
    );
    assert_eq!(
        ::std::mem::align_of::<cdb>(),
        8usize,
        concat!("Alignment of ", stringify!(cdb))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cdb>())).map as *const _ as usize },
        0usize,
        concat!("Offset of field: ", stringify!(cdb), "::", stringify!(map))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cdb>())).fd as *const _ as usize },
        8usize,
        concat!("Offset of field: ", stringify!(cdb), "::", stringify!(fd))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cdb>())).size as *const _ as usize },
        12usize,
        concat!("Offset of field: ", stringify!(cdb), "::", stringify!(size))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cdb>())).loop_ as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(cdb),
            "::",
            stringify!(loop_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cdb>())).khash as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(cdb),
            "::",
            stringify!(khash)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cdb>())).kpos as *const _ as usize },
        24usize,
        concat!("Offset of field: ", stringify!(cdb), "::", stringify!(kpos))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cdb>())).hpos as *const _ as usize },
        28usize,
        concat!("Offset of field: ", stringify!(cdb), "::", stringify!(hpos))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cdb>())).hslots as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(cdb),
            "::",
            stringify!(hslots)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cdb>())).dpos as *const _ as usize },
        36usize,
        concat!("Offset of field: ", stringify!(cdb), "::", stringify!(dpos))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cdb>())).dlen as *const _ as usize },
        40usize,
        concat!("Offset of field: ", stringify!(cdb), "::", stringify!(dlen))
    );
}
extern "C" {
    pub fn cdb_getkvlen(
        db: *mut cdb,
        klen: *mut ::std::os::raw::c_uint,
        vlen: *mut ::std::os::raw::c_uint,
        pos: ::std::os::raw::c_uint,
    ) -> bool;
}
extern "C" {
    pub fn cdb_free(arg1: *mut cdb);
}
extern "C" {
    pub fn cdb_init(arg1: *mut cdb, fd: ::std::os::raw::c_int) -> bool;
}
extern "C" {
    pub fn cdb_findstart(arg1: *mut cdb);
}
extern "C" {
    pub fn cdb_read(
        arg1: *mut cdb,
        arg2: *mut ::std::os::raw::c_char,
        arg3: ::std::os::raw::c_uint,
        arg4: ::std::os::raw::c_uint,
    ) -> bool;
}
extern "C" {
    pub fn cdb_findnext(
        arg1: *mut cdb,
        u: ::std::os::raw::c_uint,
        arg2: *const ::std::os::raw::c_char,
        arg3: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
pub type BufferOp = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: ::std::os::raw::c_int,
        arg2: *const ::std::os::raw::c_char,
        arg3: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int,
>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct buffer {
    pub x: *mut ::std::os::raw::c_char,
    pub p: ::std::os::raw::c_uint,
    pub n: ::std::os::raw::c_uint,
    pub fd: ::std::os::raw::c_int,
    pub op: BufferOp,
}
#[test]
fn bindgen_test_layout_buffer() {
    assert_eq!(
        ::std::mem::size_of::<buffer>(),
        32usize,
        concat!("Size of: ", stringify!(buffer))
    );
    assert_eq!(
        ::std::mem::align_of::<buffer>(),
        8usize,
        concat!("Alignment of ", stringify!(buffer))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<buffer>())).x as *const _ as usize },
        0usize,
        concat!("Offset of field: ", stringify!(buffer), "::", stringify!(x))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<buffer>())).p as *const _ as usize },
        8usize,
        concat!("Offset of field: ", stringify!(buffer), "::", stringify!(p))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<buffer>())).n as *const _ as usize },
        12usize,
        concat!("Offset of field: ", stringify!(buffer), "::", stringify!(n))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<buffer>())).fd as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(buffer),
            "::",
            stringify!(fd)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<buffer>())).op as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(buffer),
            "::",
            stringify!(op)
        )
    );
}
extern "C" {
    pub fn buffer_init(
        arg1: *mut buffer,
        arg2: BufferOp,
        arg3: ::std::os::raw::c_int,
        arg4: *mut ::std::os::raw::c_char,
        arg5: ::std::os::raw::c_uint,
    );
}
extern "C" {
    pub fn buffer_flush(arg1: *mut buffer) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn buffer_put(
        arg1: *mut buffer,
        arg2: *const ::std::os::raw::c_char,
        arg3: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn buffer_putalign(
        arg1: *mut buffer,
        arg2: *const ::std::os::raw::c_char,
        arg3: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn buffer_putflush(
        arg1: *mut buffer,
        arg2: *const ::std::os::raw::c_char,
        arg3: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn buffer_get(
        arg1: *mut buffer,
        arg2: *mut ::std::os::raw::c_char,
        arg3: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn buffer_bget(
        arg1: *mut buffer,
        arg2: *mut ::std::os::raw::c_char,
        arg3: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn buffer_feed(arg1: *mut buffer) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn buffer_peek(arg1: *mut buffer) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn buffer_seek(arg1: *mut buffer, arg2: ::std::os::raw::c_uint);
}
extern "C" {
    pub fn buffer_copy(arg1: *mut buffer, arg2: *mut buffer) -> ::std::os::raw::c_int;
}
extern "C" {
    pub static mut buffer_0: *mut buffer;
}
extern "C" {
    pub static mut buffer_0small: *mut buffer;
}
extern "C" {
    pub static mut buffer_1: *mut buffer;
}
extern "C" {
    pub static mut buffer_1small: *mut buffer;
}
extern "C" {
    pub static mut buffer_2: *mut buffer;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cdb_hp {
    pub h: ::std::os::raw::c_uint,
    pub p: ::std::os::raw::c_uint,
}
#[test]
fn bindgen_test_layout_cdb_hp() {
    assert_eq!(
        ::std::mem::size_of::<cdb_hp>(),
        8usize,
        concat!("Size of: ", stringify!(cdb_hp))
    );
    assert_eq!(
        ::std::mem::align_of::<cdb_hp>(),
        4usize,
        concat!("Alignment of ", stringify!(cdb_hp))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cdb_hp>())).h as *const _ as usize },
        0usize,
        concat!("Offset of field: ", stringify!(cdb_hp), "::", stringify!(h))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cdb_hp>())).p as *const _ as usize },
        4usize,
        concat!("Offset of field: ", stringify!(cdb_hp), "::", stringify!(p))
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cdb_hplist {
    pub hp: [cdb_hp; 1000usize],
    pub next: *mut cdb_hplist,
    pub num: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_cdb_hplist() {
    assert_eq!(
        ::std::mem::size_of::<cdb_hplist>(),
        8016usize,
        concat!("Size of: ", stringify!(cdb_hplist))
    );
    assert_eq!(
        ::std::mem::align_of::<cdb_hplist>(),
        8usize,
        concat!("Alignment of ", stringify!(cdb_hplist))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cdb_hplist>())).hp as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cdb_hplist),
            "::",
            stringify!(hp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cdb_hplist>())).next as *const _ as usize },
        8000usize,
        concat!(
            "Offset of field: ",
            stringify!(cdb_hplist),
            "::",
            stringify!(next)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cdb_hplist>())).num as *const _ as usize },
        8008usize,
        concat!(
            "Offset of field: ",
            stringify!(cdb_hplist),
            "::",
            stringify!(num)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cdb_make {
    pub bspace: [::std::os::raw::c_char; 8192usize],
    pub final_: [::std::os::raw::c_char; 1024usize],
    pub count: [::std::os::raw::c_uint; 256usize],
    pub start: [::std::os::raw::c_uint; 256usize],
    pub head: *mut cdb_hplist,
    pub split: *mut cdb_hp,
    pub hash: *mut cdb_hp,
    pub numentries: ::std::os::raw::c_uint,
    pub memsize: ::std::os::raw::c_uint,
    pub b: buffer,
    pub pos: ::std::os::raw::c_uint,
    pub fd: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_cdb_make() {
    assert_eq!(
        ::std::mem::size_of::<cdb_make>(),
        11336usize,
        concat!("Size of: ", stringify!(cdb_make))
    );
    assert_eq!(
        ::std::mem::align_of::<cdb_make>(),
        8usize,
        concat!("Alignment of ", stringify!(cdb_make))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cdb_make>())).bspace as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cdb_make),
            "::",
            stringify!(bspace)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cdb_make>())).final_ as *const _ as usize },
        8192usize,
        concat!(
            "Offset of field: ",
            stringify!(cdb_make),
            "::",
            stringify!(final_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cdb_make>())).count as *const _ as usize },
        9216usize,
        concat!(
            "Offset of field: ",
            stringify!(cdb_make),
            "::",
            stringify!(count)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cdb_make>())).start as *const _ as usize },
        10240usize,
        concat!(
            "Offset of field: ",
            stringify!(cdb_make),
            "::",
            stringify!(start)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cdb_make>())).head as *const _ as usize },
        11264usize,
        concat!(
            "Offset of field: ",
            stringify!(cdb_make),
            "::",
            stringify!(head)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cdb_make>())).split as *const _ as usize },
        11272usize,
        concat!(
            "Offset of field: ",
            stringify!(cdb_make),
            "::",
            stringify!(split)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cdb_make>())).hash as *const _ as usize },
        11280usize,
        concat!(
            "Offset of field: ",
            stringify!(cdb_make),
            "::",
            stringify!(hash)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cdb_make>())).numentries as *const _ as usize },
        11288usize,
        concat!(
            "Offset of field: ",
            stringify!(cdb_make),
            "::",
            stringify!(numentries)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cdb_make>())).memsize as *const _ as usize },
        11292usize,
        concat!(
            "Offset of field: ",
            stringify!(cdb_make),
            "::",
            stringify!(memsize)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cdb_make>())).b as *const _ as usize },
        11296usize,
        concat!(
            "Offset of field: ",
            stringify!(cdb_make),
            "::",
            stringify!(b)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cdb_make>())).pos as *const _ as usize },
        11328usize,
        concat!(
            "Offset of field: ",
            stringify!(cdb_make),
            "::",
            stringify!(pos)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cdb_make>())).fd as *const _ as usize },
        11332usize,
        concat!(
            "Offset of field: ",
            stringify!(cdb_make),
            "::",
            stringify!(fd)
        )
    );
}
extern "C" {
    pub fn cdb_make_start(
        arg1: *mut cdb_make,
        arg2: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn cdb_make_addbegin(
        arg1: *mut cdb_make,
        arg2: ::std::os::raw::c_uint,
        arg3: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn cdb_make_addend(
        arg1: *mut cdb_make,
        arg2: ::std::os::raw::c_uint,
        arg3: ::std::os::raw::c_uint,
        arg4: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn cdb_make_add(
        arg1: *mut cdb_make,
        arg2: *const ::std::os::raw::c_char,
        arg3: ::std::os::raw::c_uint,
        arg4: *const ::std::os::raw::c_char,
        arg5: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn cdb_make_finish(arg1: *mut cdb_make) -> ::std::os::raw::c_int;
}
pub type GperfForeachCallback = ::std::option::Option<
    unsafe extern "C" fn(
        user: *mut ::std::os::raw::c_void,
        k: *const ::std::os::raw::c_char,
        v: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int,
>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct sdb_gperf_t {
    pub name: *const ::std::os::raw::c_char,
    pub get: ::std::option::Option<
        unsafe extern "C" fn(k: *const ::std::os::raw::c_char) -> *const ::std::os::raw::c_char,
    >,
    pub hash: ::std::option::Option<
        unsafe extern "C" fn(k: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_uint,
    >,
    pub foreach: ::std::option::Option<
        unsafe extern "C" fn(cb: GperfForeachCallback, user: *mut ::std::os::raw::c_void) -> bool,
    >,
}
#[test]
fn bindgen_test_layout_sdb_gperf_t() {
    assert_eq!(
        ::std::mem::size_of::<sdb_gperf_t>(),
        32usize,
        concat!("Size of: ", stringify!(sdb_gperf_t))
    );
    assert_eq!(
        ::std::mem::align_of::<sdb_gperf_t>(),
        8usize,
        concat!("Alignment of ", stringify!(sdb_gperf_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sdb_gperf_t>())).name as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sdb_gperf_t),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sdb_gperf_t>())).get as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(sdb_gperf_t),
            "::",
            stringify!(get)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sdb_gperf_t>())).hash as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(sdb_gperf_t),
            "::",
            stringify!(hash)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sdb_gperf_t>())).foreach as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(sdb_gperf_t),
            "::",
            stringify!(foreach)
        )
    );
}
pub type SdbGperf = sdb_gperf_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct sdb_t {
    pub dir: *mut ::std::os::raw::c_char,
    pub path: *mut ::std::os::raw::c_char,
    pub name: *mut ::std::os::raw::c_char,
    pub fd: ::std::os::raw::c_int,
    pub refs: ::std::os::raw::c_int,
    pub lock: ::std::os::raw::c_int,
    pub journal: ::std::os::raw::c_int,
    pub db: cdb,
    pub m: cdb_make,
    pub ht: *mut HtPP,
    pub eod: ::std::os::raw::c_uint,
    pub pos: ::std::os::raw::c_uint,
    pub gp: *mut SdbGperf,
    pub fdump: ::std::os::raw::c_int,
    pub ndump: *mut ::std::os::raw::c_char,
    pub expire: ::std::os::raw::c_ulonglong,
    pub last: ::std::os::raw::c_ulonglong,
    pub options: ::std::os::raw::c_int,
    pub ns_lock: ::std::os::raw::c_int,
    pub ns: *mut SdbList,
    pub hooks: *mut SdbList,
    pub tmpkv: SdbKv,
    pub depth: ::std::os::raw::c_uint,
    pub timestamped: bool,
    pub mht: SdbMini,
}
#[test]
fn bindgen_test_layout_sdb_t() {
    assert_eq!(
        ::std::mem::size_of::<sdb_t>(),
        11576usize,
        concat!("Size of: ", stringify!(sdb_t))
    );
    assert_eq!(
        ::std::mem::align_of::<sdb_t>(),
        8usize,
        concat!("Alignment of ", stringify!(sdb_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sdb_t>())).dir as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sdb_t),
            "::",
            stringify!(dir)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sdb_t>())).path as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(sdb_t),
            "::",
            stringify!(path)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sdb_t>())).name as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(sdb_t),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sdb_t>())).fd as *const _ as usize },
        24usize,
        concat!("Offset of field: ", stringify!(sdb_t), "::", stringify!(fd))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sdb_t>())).refs as *const _ as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(sdb_t),
            "::",
            stringify!(refs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sdb_t>())).lock as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(sdb_t),
            "::",
            stringify!(lock)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sdb_t>())).journal as *const _ as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(sdb_t),
            "::",
            stringify!(journal)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sdb_t>())).db as *const _ as usize },
        40usize,
        concat!("Offset of field: ", stringify!(sdb_t), "::", stringify!(db))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sdb_t>())).m as *const _ as usize },
        88usize,
        concat!("Offset of field: ", stringify!(sdb_t), "::", stringify!(m))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sdb_t>())).ht as *const _ as usize },
        11424usize,
        concat!("Offset of field: ", stringify!(sdb_t), "::", stringify!(ht))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sdb_t>())).eod as *const _ as usize },
        11432usize,
        concat!(
            "Offset of field: ",
            stringify!(sdb_t),
            "::",
            stringify!(eod)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sdb_t>())).pos as *const _ as usize },
        11436usize,
        concat!(
            "Offset of field: ",
            stringify!(sdb_t),
            "::",
            stringify!(pos)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sdb_t>())).gp as *const _ as usize },
        11440usize,
        concat!("Offset of field: ", stringify!(sdb_t), "::", stringify!(gp))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sdb_t>())).fdump as *const _ as usize },
        11448usize,
        concat!(
            "Offset of field: ",
            stringify!(sdb_t),
            "::",
            stringify!(fdump)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sdb_t>())).ndump as *const _ as usize },
        11456usize,
        concat!(
            "Offset of field: ",
            stringify!(sdb_t),
            "::",
            stringify!(ndump)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sdb_t>())).expire as *const _ as usize },
        11464usize,
        concat!(
            "Offset of field: ",
            stringify!(sdb_t),
            "::",
            stringify!(expire)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sdb_t>())).last as *const _ as usize },
        11472usize,
        concat!(
            "Offset of field: ",
            stringify!(sdb_t),
            "::",
            stringify!(last)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sdb_t>())).options as *const _ as usize },
        11480usize,
        concat!(
            "Offset of field: ",
            stringify!(sdb_t),
            "::",
            stringify!(options)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sdb_t>())).ns_lock as *const _ as usize },
        11484usize,
        concat!(
            "Offset of field: ",
            stringify!(sdb_t),
            "::",
            stringify!(ns_lock)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sdb_t>())).ns as *const _ as usize },
        11488usize,
        concat!("Offset of field: ", stringify!(sdb_t), "::", stringify!(ns))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sdb_t>())).hooks as *const _ as usize },
        11496usize,
        concat!(
            "Offset of field: ",
            stringify!(sdb_t),
            "::",
            stringify!(hooks)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sdb_t>())).tmpkv as *const _ as usize },
        11504usize,
        concat!(
            "Offset of field: ",
            stringify!(sdb_t),
            "::",
            stringify!(tmpkv)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sdb_t>())).depth as *const _ as usize },
        11544usize,
        concat!(
            "Offset of field: ",
            stringify!(sdb_t),
            "::",
            stringify!(depth)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sdb_t>())).timestamped as *const _ as usize },
        11548usize,
        concat!(
            "Offset of field: ",
            stringify!(sdb_t),
            "::",
            stringify!(timestamped)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sdb_t>())).mht as *const _ as usize },
        11552usize,
        concat!(
            "Offset of field: ",
            stringify!(sdb_t),
            "::",
            stringify!(mht)
        )
    );
}
pub type Sdb = sdb_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct sdb_ns_t {
    pub name: *mut ::std::os::raw::c_char,
    pub hash: ::std::os::raw::c_uint,
    pub sdb: *mut Sdb,
}
#[test]
fn bindgen_test_layout_sdb_ns_t() {
    assert_eq!(
        ::std::mem::size_of::<sdb_ns_t>(),
        24usize,
        concat!("Size of: ", stringify!(sdb_ns_t))
    );
    assert_eq!(
        ::std::mem::align_of::<sdb_ns_t>(),
        8usize,
        concat!("Alignment of ", stringify!(sdb_ns_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sdb_ns_t>())).name as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sdb_ns_t),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sdb_ns_t>())).hash as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(sdb_ns_t),
            "::",
            stringify!(hash)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sdb_ns_t>())).sdb as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(sdb_ns_t),
            "::",
            stringify!(sdb)
        )
    );
}
pub type SdbNs = sdb_ns_t;
extern "C" {
    pub fn sdb_new0() -> *mut Sdb;
}
extern "C" {
    pub fn sdb_new(
        path: *const ::std::os::raw::c_char,
        file: *const ::std::os::raw::c_char,
        lock: ::std::os::raw::c_int,
    ) -> *mut Sdb;
}
extern "C" {
    pub fn sdb_open(s: *mut Sdb, file: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sdb_open_gperf(s: *mut Sdb, g: *mut SdbGperf) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sdb_close(s: *mut Sdb);
}
extern "C" {
    pub fn sdb_config(s: *mut Sdb, options: ::std::os::raw::c_int);
}
extern "C" {
    pub fn sdb_free(s: *mut Sdb) -> bool;
}
extern "C" {
    pub fn sdb_file(s: *mut Sdb, dir: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn sdb_merge(d: *mut Sdb, s: *mut Sdb) -> bool;
}
extern "C" {
    pub fn sdb_count(s: *mut Sdb) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sdb_reset(s: *mut Sdb);
}
extern "C" {
    pub fn sdb_setup(s: *mut Sdb, options: ::std::os::raw::c_int);
}
extern "C" {
    pub fn sdb_drain(arg1: *mut Sdb, arg2: *mut Sdb);
}
extern "C" {
    pub fn sdb_copy(src: *mut Sdb, dst: *mut Sdb);
}
extern "C" {
    pub fn sdb_stats(
        s: *mut Sdb,
        disk: *mut ::std::os::raw::c_uint,
        mem: *mut ::std::os::raw::c_uint,
    ) -> bool;
}
extern "C" {
    pub fn sdb_dump_hasnext(s: *mut Sdb) -> bool;
}
pub type SdbForeachCallback = ::std::option::Option<
    unsafe extern "C" fn(
        user: *mut ::std::os::raw::c_void,
        k: *const ::std::os::raw::c_char,
        v: *const ::std::os::raw::c_char,
    ) -> bool,
>;
extern "C" {
    pub fn sdb_foreach(
        s: *mut Sdb,
        cb: SdbForeachCallback,
        user: *mut ::std::os::raw::c_void,
    ) -> bool;
}
extern "C" {
    pub fn sdb_foreach_list(s: *mut Sdb, sorted: bool) -> *mut SdbList;
}
extern "C" {
    pub fn sdb_foreach_list_filter(
        s: *mut Sdb,
        filter: SdbForeachCallback,
        sorted: bool,
    ) -> *mut SdbList;
}
extern "C" {
    pub fn sdb_foreach_match(
        s: *mut Sdb,
        expr: *const ::std::os::raw::c_char,
        sorted: bool,
    ) -> *mut SdbList;
}
extern "C" {
    pub fn sdb_query(s: *mut Sdb, cmd: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sdb_queryf(
        s: *mut Sdb,
        fmt: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sdb_query_lines(
        s: *mut Sdb,
        cmd: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sdb_querys(
        s: *mut Sdb,
        buf: *mut ::std::os::raw::c_char,
        len: size_t,
        cmd: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn sdb_querysf(
        s: *mut Sdb,
        buf: *mut ::std::os::raw::c_char,
        buflen: size_t,
        fmt: *const ::std::os::raw::c_char,
        ...
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn sdb_query_file(
        s: *mut Sdb,
        file: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sdb_exists(arg1: *mut Sdb, key: *const ::std::os::raw::c_char) -> bool;
}
extern "C" {
    pub fn sdb_remove(
        arg1: *mut Sdb,
        key: *const ::std::os::raw::c_char,
        cas: ::std::os::raw::c_uint,
    ) -> bool;
}
extern "C" {
    pub fn sdb_unset(
        arg1: *mut Sdb,
        key: *const ::std::os::raw::c_char,
        cas: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sdb_unset_like(s: *mut Sdb, k: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sdb_like(
        s: *mut Sdb,
        k: *const ::std::os::raw::c_char,
        v: *const ::std::os::raw::c_char,
        cb: SdbForeachCallback,
    ) -> *mut *mut ::std::os::raw::c_char;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct sdb_diff_t {
    pub path: *const SdbList,
    pub k: *const ::std::os::raw::c_char,
    pub v: *const ::std::os::raw::c_char,
    pub add: bool,
}
#[test]
fn bindgen_test_layout_sdb_diff_t() {
    assert_eq!(
        ::std::mem::size_of::<sdb_diff_t>(),
        32usize,
        concat!("Size of: ", stringify!(sdb_diff_t))
    );
    assert_eq!(
        ::std::mem::align_of::<sdb_diff_t>(),
        8usize,
        concat!("Alignment of ", stringify!(sdb_diff_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sdb_diff_t>())).path as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sdb_diff_t),
            "::",
            stringify!(path)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sdb_diff_t>())).k as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(sdb_diff_t),
            "::",
            stringify!(k)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sdb_diff_t>())).v as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(sdb_diff_t),
            "::",
            stringify!(v)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sdb_diff_t>())).add as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(sdb_diff_t),
            "::",
            stringify!(add)
        )
    );
}
pub type SdbDiff = sdb_diff_t;
extern "C" {
    pub fn sdb_diff_format(
        str_: *mut ::std::os::raw::c_char,
        size: ::std::os::raw::c_int,
        diff: *const SdbDiff,
    ) -> ::std::os::raw::c_int;
}
pub type SdbDiffCallback = ::std::option::Option<
    unsafe extern "C" fn(diff: *const SdbDiff, user: *mut ::std::os::raw::c_void),
>;
extern "C" {
    pub fn sdb_diff(
        a: *mut Sdb,
        b: *mut Sdb,
        cb: SdbDiffCallback,
        cb_user: *mut ::std::os::raw::c_void,
    ) -> bool;
}
extern "C" {
    pub fn sdb_get(
        arg1: *mut Sdb,
        key: *const ::std::os::raw::c_char,
        cas: *mut ::std::os::raw::c_uint,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn sdb_get_len(
        arg1: *mut Sdb,
        key: *const ::std::os::raw::c_char,
        vlen: *mut ::std::os::raw::c_int,
        cas: *mut ::std::os::raw::c_uint,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn sdb_const_get(
        arg1: *mut Sdb,
        key: *const ::std::os::raw::c_char,
        cas: *mut ::std::os::raw::c_uint,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn sdb_const_get_len(
        s: *mut Sdb,
        key: *const ::std::os::raw::c_char,
        vlen: *mut ::std::os::raw::c_int,
        cas: *mut ::std::os::raw::c_uint,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn sdb_set(
        arg1: *mut Sdb,
        key: *const ::std::os::raw::c_char,
        data: *const ::std::os::raw::c_char,
        cas: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sdb_set_owned(
        s: *mut Sdb,
        key: *const ::std::os::raw::c_char,
        val: *mut ::std::os::raw::c_char,
        cas: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sdb_concat(
        s: *mut Sdb,
        key: *const ::std::os::raw::c_char,
        value: *const ::std::os::raw::c_char,
        cas: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sdb_uncat(
        s: *mut Sdb,
        key: *const ::std::os::raw::c_char,
        value: *const ::std::os::raw::c_char,
        cas: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sdb_add(
        s: *mut Sdb,
        key: *const ::std::os::raw::c_char,
        val: *const ::std::os::raw::c_char,
        cas: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sdb_sync(arg1: *mut Sdb) -> bool;
}
extern "C" {
    pub fn sdb_num_exists(arg1: *mut Sdb, key: *const ::std::os::raw::c_char) -> bool;
}
extern "C" {
    pub fn sdb_num_base(s: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sdb_num_get(
        s: *mut Sdb,
        key: *const ::std::os::raw::c_char,
        cas: *mut ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_ulonglong;
}
extern "C" {
    pub fn sdb_num_set(
        s: *mut Sdb,
        key: *const ::std::os::raw::c_char,
        v: ::std::os::raw::c_ulonglong,
        cas: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sdb_num_add(
        s: *mut Sdb,
        key: *const ::std::os::raw::c_char,
        v: ::std::os::raw::c_ulonglong,
        cas: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sdb_num_inc(
        s: *mut Sdb,
        key: *const ::std::os::raw::c_char,
        n: ::std::os::raw::c_ulonglong,
        cas: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_ulonglong;
}
extern "C" {
    pub fn sdb_num_dec(
        s: *mut Sdb,
        key: *const ::std::os::raw::c_char,
        n: ::std::os::raw::c_ulonglong,
        cas: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_ulonglong;
}
extern "C" {
    pub fn sdb_num_min(
        s: *mut Sdb,
        key: *const ::std::os::raw::c_char,
        v: ::std::os::raw::c_ulonglong,
        cas: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sdb_num_max(
        s: *mut Sdb,
        key: *const ::std::os::raw::c_char,
        v: ::std::os::raw::c_ulonglong,
        cas: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sdb_ptr_set(
        db: *mut Sdb,
        key: *const ::std::os::raw::c_char,
        p: *mut ::std::os::raw::c_void,
        cas: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sdb_ptr_get(
        db: *mut Sdb,
        key: *const ::std::os::raw::c_char,
        cas: *mut ::std::os::raw::c_uint,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn sdb_disk_create(s: *mut Sdb) -> bool;
}
extern "C" {
    pub fn sdb_disk_insert(
        s: *mut Sdb,
        key: *const ::std::os::raw::c_char,
        val: *const ::std::os::raw::c_char,
    ) -> bool;
}
extern "C" {
    pub fn sdb_disk_finish(s: *mut Sdb) -> bool;
}
extern "C" {
    pub fn sdb_disk_unlink(s: *mut Sdb) -> bool;
}
extern "C" {
    pub fn sdb_text_save_fd(s: *mut Sdb, fd: ::std::os::raw::c_int, sort: bool) -> bool;
}
extern "C" {
    pub fn sdb_text_save(s: *mut Sdb, file: *const ::std::os::raw::c_char, sort: bool) -> bool;
}
extern "C" {
    pub fn sdb_text_load_buf(s: *mut Sdb, buf: *mut ::std::os::raw::c_char, sz: size_t) -> bool;
}
extern "C" {
    pub fn sdb_text_load(s: *mut Sdb, file: *const ::std::os::raw::c_char) -> bool;
}
extern "C" {
    pub fn sdb_text_check(s: *mut Sdb, file: *const ::std::os::raw::c_char) -> bool;
}
extern "C" {
    pub fn sdb_dump_begin(s: *mut Sdb);
}
extern "C" {
    pub fn sdb_dump_next(s: *mut Sdb) -> *mut SdbKv;
}
extern "C" {
    pub fn sdb_dump_dupnext(
        s: *mut Sdb,
        key: *mut ::std::os::raw::c_char,
        value: *mut *mut ::std::os::raw::c_char,
        _vlen: *mut ::std::os::raw::c_int,
    ) -> bool;
}
extern "C" {
    pub fn sdb_journal_close(s: *mut Sdb) -> bool;
}
extern "C" {
    pub fn sdb_journal_open(s: *mut Sdb) -> bool;
}
extern "C" {
    pub fn sdb_journal_load(s: *mut Sdb) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sdb_journal_log(
        s: *mut Sdb,
        key: *const ::std::os::raw::c_char,
        val: *const ::std::os::raw::c_char,
    ) -> bool;
}
extern "C" {
    pub fn sdb_journal_clear(s: *mut Sdb) -> bool;
}
extern "C" {
    pub fn sdb_journal_unlink(s: *mut Sdb) -> bool;
}
extern "C" {
    pub fn sdb_itoa(
        n: ::std::os::raw::c_ulonglong,
        s: *mut ::std::os::raw::c_char,
        base: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn sdb_atoi(s: *const ::std::os::raw::c_char) -> ::std::os::raw::c_ulonglong;
}
extern "C" {
    pub fn sdb_itoca(n: ::std::os::raw::c_ulonglong) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn sdb_lock(s: *const ::std::os::raw::c_char) -> bool;
}
extern "C" {
    pub fn sdb_lock_file(f: *const ::std::os::raw::c_char) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn sdb_unlock(s: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn sdb_unlink(s: *mut Sdb) -> bool;
}
extern "C" {
    pub fn sdb_lock_wait(s: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sdb_expire_set(
        s: *mut Sdb,
        key: *const ::std::os::raw::c_char,
        expire: ::std::os::raw::c_ulonglong,
        cas: ::std::os::raw::c_uint,
    ) -> bool;
}
extern "C" {
    pub fn sdb_expire_get(
        s: *mut Sdb,
        key: *const ::std::os::raw::c_char,
        cas: *mut ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_ulonglong;
}
extern "C" {
    pub fn sdb_now() -> ::std::os::raw::c_ulonglong;
}
extern "C" {
    pub fn sdb_unow() -> ::std::os::raw::c_ulonglong;
}
extern "C" {
    pub fn sdb_hash_len(
        key: *const ::std::os::raw::c_char,
        len: *mut ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn sdb_hash_byte(s: *const ::std::os::raw::c_char) -> ::std::os::raw::c_uchar;
}
extern "C" {
    pub fn sdb_isjson(k: *const ::std::os::raw::c_char) -> bool;
}
extern "C" {
    pub fn sdb_json_get_str(
        json: *const ::std::os::raw::c_char,
        path: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn sdb_json_get_bool(
        json: *const ::std::os::raw::c_char,
        path: *const ::std::os::raw::c_char,
    ) -> bool;
}
extern "C" {
    pub fn sdb_json_get(
        s: *mut Sdb,
        key: *const ::std::os::raw::c_char,
        p: *const ::std::os::raw::c_char,
        cas: *mut ::std::os::raw::c_uint,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn sdb_json_set(
        s: *mut Sdb,
        k: *const ::std::os::raw::c_char,
        p: *const ::std::os::raw::c_char,
        v: *const ::std::os::raw::c_char,
        cas: ::std::os::raw::c_uint,
    ) -> bool;
}
extern "C" {
    pub fn sdb_json_num_get(
        s: *mut Sdb,
        k: *const ::std::os::raw::c_char,
        p: *const ::std::os::raw::c_char,
        cas: *mut ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sdb_json_num_set(
        s: *mut Sdb,
        k: *const ::std::os::raw::c_char,
        p: *const ::std::os::raw::c_char,
        v: ::std::os::raw::c_int,
        cas: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sdb_json_num_dec(
        s: *mut Sdb,
        k: *const ::std::os::raw::c_char,
        p: *const ::std::os::raw::c_char,
        n: ::std::os::raw::c_int,
        cas: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sdb_json_num_inc(
        s: *mut Sdb,
        k: *const ::std::os::raw::c_char,
        p: *const ::std::os::raw::c_char,
        n: ::std::os::raw::c_int,
        cas: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sdb_json_indent(
        s: *const ::std::os::raw::c_char,
        tab: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn sdb_json_unindent(s: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SdbJsonString {
    pub buf: *mut ::std::os::raw::c_char,
    pub blen: size_t,
    pub len: size_t,
}
#[test]
fn bindgen_test_layout_SdbJsonString() {
    assert_eq!(
        ::std::mem::size_of::<SdbJsonString>(),
        24usize,
        concat!("Size of: ", stringify!(SdbJsonString))
    );
    assert_eq!(
        ::std::mem::align_of::<SdbJsonString>(),
        8usize,
        concat!("Alignment of ", stringify!(SdbJsonString))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<SdbJsonString>())).buf as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(SdbJsonString),
            "::",
            stringify!(buf)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<SdbJsonString>())).blen as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(SdbJsonString),
            "::",
            stringify!(blen)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<SdbJsonString>())).len as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(SdbJsonString),
            "::",
            stringify!(len)
        )
    );
}
extern "C" {
    pub fn sdb_json_format(
        s: *mut SdbJsonString,
        fmt: *const ::std::os::raw::c_char,
        ...
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn sdb_ns(
        s: *mut Sdb,
        name: *const ::std::os::raw::c_char,
        create: ::std::os::raw::c_int,
    ) -> *mut Sdb;
}
extern "C" {
    pub fn sdb_ns_path(
        s: *mut Sdb,
        path: *const ::std::os::raw::c_char,
        create: ::std::os::raw::c_int,
    ) -> *mut Sdb;
}
extern "C" {
    pub fn sdb_ns_init(s: *mut Sdb);
}
extern "C" {
    pub fn sdb_ns_free(s: *mut Sdb);
}
extern "C" {
    pub fn sdb_ns_lock(s: *mut Sdb, lock: ::std::os::raw::c_int, depth: ::std::os::raw::c_int);
}
extern "C" {
    pub fn sdb_ns_sync(s: *mut Sdb);
}
extern "C" {
    pub fn sdb_ns_set(
        s: *mut Sdb,
        name: *const ::std::os::raw::c_char,
        r: *mut Sdb,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sdb_ns_unset(s: *mut Sdb, name: *const ::std::os::raw::c_char, r: *mut Sdb) -> bool;
}
extern "C" {
    pub fn sdb_array_contains(
        s: *mut Sdb,
        key: *const ::std::os::raw::c_char,
        val: *const ::std::os::raw::c_char,
        cas: *mut ::std::os::raw::c_uint,
    ) -> bool;
}
extern "C" {
    pub fn sdb_array_contains_num(
        s: *mut Sdb,
        key: *const ::std::os::raw::c_char,
        val: ::std::os::raw::c_ulonglong,
        cas: *mut ::std::os::raw::c_uint,
    ) -> bool;
}
extern "C" {
    pub fn sdb_array_indexof(
        s: *mut Sdb,
        key: *const ::std::os::raw::c_char,
        val: *const ::std::os::raw::c_char,
        cas: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sdb_array_set(
        s: *mut Sdb,
        key: *const ::std::os::raw::c_char,
        idx: ::std::os::raw::c_int,
        val: *const ::std::os::raw::c_char,
        cas: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sdb_array_set_num(
        s: *mut Sdb,
        key: *const ::std::os::raw::c_char,
        idx: ::std::os::raw::c_int,
        val: ::std::os::raw::c_ulonglong,
        cas: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sdb_array_append(
        s: *mut Sdb,
        key: *const ::std::os::raw::c_char,
        val: *const ::std::os::raw::c_char,
        cas: ::std::os::raw::c_uint,
    ) -> bool;
}
extern "C" {
    pub fn sdb_array_append_num(
        s: *mut Sdb,
        key: *const ::std::os::raw::c_char,
        val: ::std::os::raw::c_ulonglong,
        cas: ::std::os::raw::c_uint,
    ) -> bool;
}
extern "C" {
    pub fn sdb_array_prepend(
        s: *mut Sdb,
        key: *const ::std::os::raw::c_char,
        val: *const ::std::os::raw::c_char,
        cas: ::std::os::raw::c_uint,
    ) -> bool;
}
extern "C" {
    pub fn sdb_array_prepend_num(
        s: *mut Sdb,
        key: *const ::std::os::raw::c_char,
        val: ::std::os::raw::c_ulonglong,
        cas: ::std::os::raw::c_uint,
    ) -> bool;
}
extern "C" {
    pub fn sdb_array_get(
        s: *mut Sdb,
        key: *const ::std::os::raw::c_char,
        idx: ::std::os::raw::c_int,
        cas: *mut ::std::os::raw::c_uint,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn sdb_array_get_num(
        s: *mut Sdb,
        key: *const ::std::os::raw::c_char,
        idx: ::std::os::raw::c_int,
        cas: *mut ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_ulonglong;
}
extern "C" {
    pub fn sdb_array_get_idx(
        s: *mut Sdb,
        key: *const ::std::os::raw::c_char,
        val: *const ::std::os::raw::c_char,
        cas: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sdb_array_insert(
        s: *mut Sdb,
        key: *const ::std::os::raw::c_char,
        idx: ::std::os::raw::c_int,
        val: *const ::std::os::raw::c_char,
        cas: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sdb_array_insert_num(
        s: *mut Sdb,
        key: *const ::std::os::raw::c_char,
        idx: ::std::os::raw::c_int,
        val: ::std::os::raw::c_ulonglong,
        cas: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sdb_array_unset(
        s: *mut Sdb,
        key: *const ::std::os::raw::c_char,
        n: ::std::os::raw::c_int,
        cas: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sdb_array_delete(
        s: *mut Sdb,
        key: *const ::std::os::raw::c_char,
        n: ::std::os::raw::c_int,
        cas: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sdb_array_sort(
        s: *mut Sdb,
        key: *const ::std::os::raw::c_char,
        cas: ::std::os::raw::c_uint,
    );
}
extern "C" {
    pub fn sdb_array_sort_num(
        s: *mut Sdb,
        key: *const ::std::os::raw::c_char,
        cas: ::std::os::raw::c_uint,
    );
}
extern "C" {
    pub fn sdb_array_add(
        s: *mut Sdb,
        key: *const ::std::os::raw::c_char,
        val: *const ::std::os::raw::c_char,
        cas: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sdb_array_add_num(
        s: *mut Sdb,
        key: *const ::std::os::raw::c_char,
        val: ::std::os::raw::c_ulonglong,
        cas: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sdb_array_add_sorted(
        s: *mut Sdb,
        key: *const ::std::os::raw::c_char,
        val: *const ::std::os::raw::c_char,
        cas: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sdb_array_add_sorted_num(
        s: *mut Sdb,
        key: *const ::std::os::raw::c_char,
        val: ::std::os::raw::c_ulonglong,
        cas: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sdb_array_remove(
        s: *mut Sdb,
        key: *const ::std::os::raw::c_char,
        val: *const ::std::os::raw::c_char,
        cas: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sdb_array_remove_num(
        s: *mut Sdb,
        key: *const ::std::os::raw::c_char,
        val: ::std::os::raw::c_ulonglong,
        cas: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sdb_anext(
        str_: *mut ::std::os::raw::c_char,
        next: *mut *mut ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn sdb_const_anext(str_: *const ::std::os::raw::c_char) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn sdb_alen(str_: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sdb_alen_ignore_empty(str_: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sdb_array_size(s: *mut Sdb, key: *const ::std::os::raw::c_char)
        -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sdb_array_length(
        s: *mut Sdb,
        key: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sdb_array_list(s: *mut Sdb, key: *const ::std::os::raw::c_char)
        -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sdb_array_push(
        s: *mut Sdb,
        key: *const ::std::os::raw::c_char,
        val: *const ::std::os::raw::c_char,
        cas: ::std::os::raw::c_uint,
    ) -> bool;
}
extern "C" {
    pub fn sdb_array_pop(
        s: *mut Sdb,
        key: *const ::std::os::raw::c_char,
        cas: *mut ::std::os::raw::c_uint,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn sdb_array_push_num(
        s: *mut Sdb,
        key: *const ::std::os::raw::c_char,
        num: ::std::os::raw::c_ulonglong,
        cas: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sdb_array_pop_num(
        s: *mut Sdb,
        key: *const ::std::os::raw::c_char,
        cas: *mut ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_ulonglong;
}
extern "C" {
    pub fn sdb_array_pop_head(
        s: *mut Sdb,
        key: *const ::std::os::raw::c_char,
        cas: *mut ::std::os::raw::c_uint,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn sdb_array_pop_tail(
        s: *mut Sdb,
        key: *const ::std::os::raw::c_char,
        cas: *mut ::std::os::raw::c_uint,
    ) -> *mut ::std::os::raw::c_char;
}
pub type SdbHook = ::std::option::Option<
    unsafe extern "C" fn(
        s: *mut Sdb,
        user: *mut ::std::os::raw::c_void,
        k: *const ::std::os::raw::c_char,
        v: *const ::std::os::raw::c_char,
    ),
>;
extern "C" {
    pub fn sdb_global_hook(hook: SdbHook, user: *mut ::std::os::raw::c_void);
}
extern "C" {
    pub fn sdb_hook(s: *mut Sdb, cb: SdbHook, user: *mut ::std::os::raw::c_void) -> bool;
}
extern "C" {
    pub fn sdb_unhook(s: *mut Sdb, h: SdbHook) -> bool;
}
extern "C" {
    pub fn sdb_hook_call(
        s: *mut Sdb,
        k: *const ::std::os::raw::c_char,
        v: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sdb_hook_free(s: *mut Sdb);
}
extern "C" {
    pub fn sdb_isnum(s: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sdb_isempty(s: *mut Sdb) -> bool;
}
extern "C" {
    pub fn sdb_type(k: *const ::std::os::raw::c_char) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn sdb_match(
        str_: *const ::std::os::raw::c_char,
        glob: *const ::std::os::raw::c_char,
    ) -> bool;
}
extern "C" {
    pub fn sdb_bool_set(
        db: *mut Sdb,
        str_: *const ::std::os::raw::c_char,
        v: bool,
        cas: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sdb_bool_get(
        db: *mut Sdb,
        str_: *const ::std::os::raw::c_char,
        cas: *mut ::std::os::raw::c_uint,
    ) -> bool;
}
extern "C" {
    pub fn sdb_decode(
        in_: *const ::std::os::raw::c_char,
        len: *mut ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_uchar;
}
extern "C" {
    pub fn sdb_encode(
        bin: *const ::std::os::raw::c_uchar,
        len: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn sdb_encode_raw(
        bout: *mut ::std::os::raw::c_char,
        bin: *const ::std::os::raw::c_uchar,
        len: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn sdb_decode_raw(
        bout: *mut ::std::os::raw::c_uchar,
        bin: *const ::std::os::raw::c_char,
        len: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sdb_fmt(fmt: *const ::std::os::raw::c_char, ...) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn sdb_fmt_init(
        p: *mut ::std::os::raw::c_void,
        fmt: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sdb_fmt_free(p: *mut ::std::os::raw::c_void, fmt: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn sdb_fmt_tobin(
        _str: *const ::std::os::raw::c_char,
        fmt: *const ::std::os::raw::c_char,
        stru: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sdb_fmt_tostr(
        stru: *mut ::std::os::raw::c_void,
        fmt: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn sdb_fmt_array(list: *const ::std::os::raw::c_char) -> *mut *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn sdb_fmt_array_num(
        list: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_ulonglong;
}
extern "C" {
    pub fn sdb_array_compact(p: *mut ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn sdb_aslice(
        out: *mut ::std::os::raw::c_char,
        from: ::std::os::raw::c_int,
        to: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
pub type RListFree = ::std::option::Option<unsafe extern "C" fn(ptr: *mut ::std::os::raw::c_void)>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_list_iter_t {
    pub data: *mut ::std::os::raw::c_void,
    pub n: *mut r_list_iter_t,
    pub p: *mut r_list_iter_t,
}
#[test]
fn bindgen_test_layout_r_list_iter_t() {
    assert_eq!(
        ::std::mem::size_of::<r_list_iter_t>(),
        24usize,
        concat!("Size of: ", stringify!(r_list_iter_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_list_iter_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_list_iter_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_list_iter_t>())).data as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_list_iter_t),
            "::",
            stringify!(data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_list_iter_t>())).n as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_list_iter_t),
            "::",
            stringify!(n)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_list_iter_t>())).p as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(r_list_iter_t),
            "::",
            stringify!(p)
        )
    );
}
pub type RListIter = r_list_iter_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_list_t {
    pub head: *mut RListIter,
    pub tail: *mut RListIter,
    pub free: RListFree,
    pub length: ::std::os::raw::c_int,
    pub sorted: bool,
}
#[test]
fn bindgen_test_layout_r_list_t() {
    assert_eq!(
        ::std::mem::size_of::<r_list_t>(),
        32usize,
        concat!("Size of: ", stringify!(r_list_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_list_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_list_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_list_t>())).head as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_list_t),
            "::",
            stringify!(head)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_list_t>())).tail as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_list_t),
            "::",
            stringify!(tail)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_list_t>())).free as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(r_list_t),
            "::",
            stringify!(free)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_list_t>())).length as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(r_list_t),
            "::",
            stringify!(length)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_list_t>())).sorted as *const _ as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(r_list_t),
            "::",
            stringify!(sorted)
        )
    );
}
pub type RList = r_list_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_list_range_t {
    pub h: *mut HtPP,
    pub l: *mut RList,
}
#[test]
fn bindgen_test_layout_r_list_range_t() {
    assert_eq!(
        ::std::mem::size_of::<r_list_range_t>(),
        16usize,
        concat!("Size of: ", stringify!(r_list_range_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_list_range_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_list_range_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_list_range_t>())).h as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_list_range_t),
            "::",
            stringify!(h)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_list_range_t>())).l as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_list_range_t),
            "::",
            stringify!(l)
        )
    );
}
pub type RListRange = r_list_range_t;
pub type RListComparator = ::std::option::Option<
    unsafe extern "C" fn(
        a: *const ::std::os::raw::c_void,
        b: *const ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int,
>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_oflist_t {
    pub super_: RList,
    pub array: *mut *mut *mut ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout_r_oflist_t() {
    assert_eq!(
        ::std::mem::size_of::<r_oflist_t>(),
        40usize,
        concat!("Size of: ", stringify!(r_oflist_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_oflist_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_oflist_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_oflist_t>())).super_ as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_oflist_t),
            "::",
            stringify!(super_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_oflist_t>())).array as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(r_oflist_t),
            "::",
            stringify!(array)
        )
    );
}
pub type ROFList = r_oflist_t;
extern "C" {
    pub fn r_list_new() -> *mut RList;
}
extern "C" {
    pub fn r_list_newf(f: RListFree) -> *mut RList;
}
extern "C" {
    pub fn r_list_iter_get_next(list: *mut RListIter) -> *mut RListIter;
}
extern "C" {
    pub fn r_list_iter_get_prev(list: *mut RListIter) -> *mut RListIter;
}
extern "C" {
    pub fn r_list_set_n(
        list: *mut RList,
        n: ::std::os::raw::c_int,
        p: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_list_iter_get_data(list: *mut RListIter) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn r_list_append(list: *mut RList, data: *mut ::std::os::raw::c_void) -> *mut RListIter;
}
extern "C" {
    pub fn r_list_prepend(list: *mut RList, data: *mut ::std::os::raw::c_void) -> *mut RListIter;
}
extern "C" {
    pub fn r_list_insert(
        list: *mut RList,
        n: ::std::os::raw::c_uint,
        data: *mut ::std::os::raw::c_void,
    ) -> *mut RListIter;
}
extern "C" {
    pub fn r_list_length(list: *const RList) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_list_iter_length(iter: *mut RListIter) -> size_t;
}
extern "C" {
    pub fn r_list_first(list: *const RList) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn r_list_last(list: *const RList) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn r_list_add_sorted(
        list: *mut RList,
        data: *mut ::std::os::raw::c_void,
        cmp: RListComparator,
    ) -> *mut RListIter;
}
extern "C" {
    pub fn r_list_sort(list: *mut RList, cmp: RListComparator);
}
extern "C" {
    pub fn r_list_merge_sort(list: *mut RList, cmp: RListComparator);
}
extern "C" {
    pub fn r_list_insertion_sort(list: *mut RList, cmp: RListComparator);
}
extern "C" {
    pub fn r_list_uniq(list: *const RList, cmp: RListComparator) -> *mut RList;
}
extern "C" {
    pub fn r_list_init(list: *mut RList);
}
extern "C" {
    pub fn r_list_delete(list: *mut RList, iter: *mut RListIter);
}
extern "C" {
    pub fn r_list_delete_data(list: *mut RList, ptr: *mut ::std::os::raw::c_void) -> bool;
}
extern "C" {
    pub fn r_list_iter_init(iter: *mut RListIter, list: *mut RList);
}
extern "C" {
    pub fn r_list_purge(list: *mut RList);
}
extern "C" {
    pub fn r_list_free(list: *mut RList);
}
extern "C" {
    pub fn r_list_item_new(data: *mut ::std::os::raw::c_void) -> *mut RListIter;
}
extern "C" {
    pub fn r_list_split(list: *mut RList, ptr: *mut ::std::os::raw::c_void);
}
extern "C" {
    pub fn r_list_split_iter(list: *mut RList, iter: *mut RListIter);
}
extern "C" {
    pub fn r_list_join(list1: *mut RList, list2: *mut RList) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_list_get_n(
        list: *const RList,
        n: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn r_list_del_n(list: *mut RList, n: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_list_get_top(list: *const RList) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn r_list_get_bottom(list: *const RList) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn r_list_iter_to_top(list: *mut RList, iter: *mut RListIter);
}
extern "C" {
    pub fn r_list_pop(list: *mut RList) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn r_list_pop_head(list: *mut RList) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn r_list_reverse(list: *mut RList);
}
extern "C" {
    pub fn r_list_clone(list: *const RList) -> *mut RList;
}
extern "C" {
    pub fn r_list_to_str(
        list: *mut RList,
        ch: ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_list_contains(list: *const RList, p: *const ::std::os::raw::c_void) -> *mut RListIter;
}
extern "C" {
    pub fn r_list_find(
        list: *const RList,
        p: *const ::std::os::raw::c_void,
        cmp: RListComparator,
    ) -> *mut RListIter;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_graph_node_t {
    pub idx: ::std::os::raw::c_uint,
    pub data: *mut ::std::os::raw::c_void,
    pub out_nodes: *mut RList,
    pub in_nodes: *mut RList,
    pub all_neighbours: *mut RList,
    pub free: RListFree,
}
#[test]
fn bindgen_test_layout_r_graph_node_t() {
    assert_eq!(
        ::std::mem::size_of::<r_graph_node_t>(),
        48usize,
        concat!("Size of: ", stringify!(r_graph_node_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_graph_node_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_graph_node_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_graph_node_t>())).idx as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_graph_node_t),
            "::",
            stringify!(idx)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_graph_node_t>())).data as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_graph_node_t),
            "::",
            stringify!(data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_graph_node_t>())).out_nodes as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(r_graph_node_t),
            "::",
            stringify!(out_nodes)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_graph_node_t>())).in_nodes as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(r_graph_node_t),
            "::",
            stringify!(in_nodes)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_graph_node_t>())).all_neighbours as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(r_graph_node_t),
            "::",
            stringify!(all_neighbours)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_graph_node_t>())).free as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(r_graph_node_t),
            "::",
            stringify!(free)
        )
    );
}
pub type RGraphNode = r_graph_node_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_graph_edge_t {
    pub from: *mut RGraphNode,
    pub to: *mut RGraphNode,
    pub nth: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_r_graph_edge_t() {
    assert_eq!(
        ::std::mem::size_of::<r_graph_edge_t>(),
        24usize,
        concat!("Size of: ", stringify!(r_graph_edge_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_graph_edge_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_graph_edge_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_graph_edge_t>())).from as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_graph_edge_t),
            "::",
            stringify!(from)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_graph_edge_t>())).to as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_graph_edge_t),
            "::",
            stringify!(to)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_graph_edge_t>())).nth as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(r_graph_edge_t),
            "::",
            stringify!(nth)
        )
    );
}
pub type RGraphEdge = r_graph_edge_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_graph_t {
    pub n_nodes: ::std::os::raw::c_uint,
    pub n_edges: ::std::os::raw::c_uint,
    pub last_index: ::std::os::raw::c_int,
    pub nodes: *mut RList,
}
#[test]
fn bindgen_test_layout_r_graph_t() {
    assert_eq!(
        ::std::mem::size_of::<r_graph_t>(),
        24usize,
        concat!("Size of: ", stringify!(r_graph_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_graph_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_graph_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_graph_t>())).n_nodes as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_graph_t),
            "::",
            stringify!(n_nodes)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_graph_t>())).n_edges as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(r_graph_t),
            "::",
            stringify!(n_edges)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_graph_t>())).last_index as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_graph_t),
            "::",
            stringify!(last_index)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_graph_t>())).nodes as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(r_graph_t),
            "::",
            stringify!(nodes)
        )
    );
}
pub type RGraph = r_graph_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_graph_visitor_t {
    pub discover_node: ::std::option::Option<
        unsafe extern "C" fn(n: *mut RGraphNode, vis: *mut r_graph_visitor_t),
    >,
    pub finish_node: ::std::option::Option<
        unsafe extern "C" fn(n: *mut RGraphNode, vis: *mut r_graph_visitor_t),
    >,
    pub tree_edge: ::std::option::Option<
        unsafe extern "C" fn(e: *const RGraphEdge, vis: *mut r_graph_visitor_t),
    >,
    pub back_edge: ::std::option::Option<
        unsafe extern "C" fn(e: *const RGraphEdge, vis: *mut r_graph_visitor_t),
    >,
    pub fcross_edge: ::std::option::Option<
        unsafe extern "C" fn(e: *const RGraphEdge, vis: *mut r_graph_visitor_t),
    >,
    pub data: *mut ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout_r_graph_visitor_t() {
    assert_eq!(
        ::std::mem::size_of::<r_graph_visitor_t>(),
        48usize,
        concat!("Size of: ", stringify!(r_graph_visitor_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_graph_visitor_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_graph_visitor_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_graph_visitor_t>())).discover_node as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_graph_visitor_t),
            "::",
            stringify!(discover_node)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_graph_visitor_t>())).finish_node as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_graph_visitor_t),
            "::",
            stringify!(finish_node)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_graph_visitor_t>())).tree_edge as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(r_graph_visitor_t),
            "::",
            stringify!(tree_edge)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_graph_visitor_t>())).back_edge as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(r_graph_visitor_t),
            "::",
            stringify!(back_edge)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_graph_visitor_t>())).fcross_edge as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(r_graph_visitor_t),
            "::",
            stringify!(fcross_edge)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_graph_visitor_t>())).data as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(r_graph_visitor_t),
            "::",
            stringify!(data)
        )
    );
}
pub type RGraphVisitor = r_graph_visitor_t;
pub type RGraphNodeCallback =
    ::std::option::Option<unsafe extern "C" fn(n: *mut RGraphNode, vis: *mut RGraphVisitor)>;
pub type RGraphEdgeCallback =
    ::std::option::Option<unsafe extern "C" fn(e: *const RGraphEdge, vis: *mut RGraphVisitor)>;
extern "C" {
    pub fn r_graph_new() -> *mut RGraph;
}
extern "C" {
    pub fn r_graph_free(g: *mut RGraph);
}
extern "C" {
    pub fn r_graph_get_node(g: *const RGraph, idx: ::std::os::raw::c_uint) -> *mut RGraphNode;
}
extern "C" {
    pub fn r_graph_node_iter(g: *const RGraph, idx: ::std::os::raw::c_uint) -> *mut RListIter;
}
extern "C" {
    pub fn r_graph_reset(g: *mut RGraph);
}
extern "C" {
    pub fn r_graph_add_node(g: *mut RGraph, data: *mut ::std::os::raw::c_void) -> *mut RGraphNode;
}
extern "C" {
    pub fn r_graph_add_nodef(
        g: *mut RGraph,
        data: *mut ::std::os::raw::c_void,
        user_free: RListFree,
    ) -> *mut RGraphNode;
}
extern "C" {
    pub fn r_graph_del_node(g: *mut RGraph, n: *mut RGraphNode);
}
extern "C" {
    pub fn r_graph_add_edge(g: *mut RGraph, from: *mut RGraphNode, to: *mut RGraphNode);
}
extern "C" {
    pub fn r_graph_add_edge_at(
        g: *mut RGraph,
        from: *mut RGraphNode,
        to: *mut RGraphNode,
        nth: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn r_graph_node_split_forward(
        g: *mut RGraph,
        split_me: *mut RGraphNode,
        data: *mut ::std::os::raw::c_void,
    ) -> *mut RGraphNode;
}
extern "C" {
    pub fn r_graph_del_edge(g: *mut RGraph, from: *mut RGraphNode, to: *mut RGraphNode);
}
extern "C" {
    pub fn r_graph_get_neighbours(g: *const RGraph, n: *const RGraphNode) -> *const RList;
}
extern "C" {
    pub fn r_graph_nth_neighbour(
        g: *const RGraph,
        n: *const RGraphNode,
        nth: ::std::os::raw::c_int,
    ) -> *mut RGraphNode;
}
extern "C" {
    pub fn r_graph_innodes(g: *const RGraph, n: *const RGraphNode) -> *const RList;
}
extern "C" {
    pub fn r_graph_all_neighbours(g: *const RGraph, n: *const RGraphNode) -> *const RList;
}
extern "C" {
    pub fn r_graph_get_nodes(g: *const RGraph) -> *const RList;
}
extern "C" {
    pub fn r_graph_adjacent(
        g: *const RGraph,
        from: *const RGraphNode,
        to: *const RGraphNode,
    ) -> bool;
}
extern "C" {
    pub fn r_graph_dfs_node(g: *mut RGraph, n: *mut RGraphNode, vis: *mut RGraphVisitor);
}
extern "C" {
    pub fn r_graph_dfs_node_reverse(g: *mut RGraph, n: *mut RGraphNode, vis: *mut RGraphVisitor);
}
extern "C" {
    pub fn r_graph_dfs(g: *mut RGraph, vis: *mut RGraphVisitor);
}
extern "C" {
    pub fn r_hex_pair2bin(arg: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_hex_str2binmask(
        in_: *const ::std::os::raw::c_char,
        out: *mut ::std::os::raw::c_uchar,
        mask: *mut ::std::os::raw::c_uchar,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_hex_str2bin(
        in_: *const ::std::os::raw::c_char,
        out: *mut ::std::os::raw::c_uchar,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_hex_bin2str(
        in_: *const ::std::os::raw::c_uchar,
        len: ::std::os::raw::c_int,
        out: *mut ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_hex_bin2strdup(
        in_: *const ::std::os::raw::c_uchar,
        len: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_hex_to_byte(val: *mut ::std::os::raw::c_uchar, c: ::std::os::raw::c_uchar) -> bool;
}
extern "C" {
    pub fn r_hex_str_is_valid(s: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_hex_bin_truncate(
        in_: ::std::os::raw::c_ulonglong,
        n: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_longlong;
}
extern "C" {
    pub fn r_hex_from_c(code: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_hex_from_py(code: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_hex_from_code(code: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_hex_no_code(code: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_hex_from_py_str(
        out: *mut ::std::os::raw::c_char,
        code: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_hex_from_py_array(
        out: *mut ::std::os::raw::c_char,
        code: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_hex_from_c_str(
        out: *mut ::std::os::raw::c_char,
        code: *mut *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_hex_from_c_array(
        out: *mut ::std::os::raw::c_char,
        code: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
pub const r_log_level_R_LOGLVL_SILLY: r_log_level = 0;
pub const r_log_level_R_LOGLVL_DEBUG: r_log_level = 1;
pub const r_log_level_R_LOGLVL_VERBOSE: r_log_level = 2;
pub const r_log_level_R_LOGLVL_INFO: r_log_level = 3;
pub const r_log_level_R_LOGLVL_WARN: r_log_level = 4;
pub const r_log_level_R_LOGLVL_ERROR: r_log_level = 5;
pub const r_log_level_R_LOGLVL_FATAL: r_log_level = 6;
pub const r_log_level_R_LOGLVL_NONE: r_log_level = 255;
pub type r_log_level = ::std::os::raw::c_uint;
pub use self::r_log_level as RLogLevel;
pub type RLogCallback = ::std::option::Option<
    unsafe extern "C" fn(
        output: *const ::std::os::raw::c_char,
        funcname: *const ::std::os::raw::c_char,
        filename: *const ::std::os::raw::c_char,
        lineno: ::std::os::raw::c_uint,
        level: RLogLevel,
        tag: *const ::std::os::raw::c_char,
        fmtstr: *const ::std::os::raw::c_char,
        ...
    ),
>;
extern "C" {
    pub fn r_log_set_level(level: RLogLevel);
}
extern "C" {
    pub fn r_log_set_file(filename: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn r_log_set_srcinfo(show_info: bool);
}
extern "C" {
    pub fn r_log_set_colors(show_colors: bool);
}
extern "C" {
    pub fn r_log_set_traplevel(level: RLogLevel);
}
extern "C" {
    pub fn r_log_add_callback(cbfunc: RLogCallback);
}
extern "C" {
    pub fn r_log_del_callback(cbfunc: RLogCallback);
}
extern "C" {
    pub fn r_log(
        funcname: *const ::std::os::raw::c_char,
        filename: *const ::std::os::raw::c_char,
        lineno: ::std::os::raw::c_uint,
        level: RLogLevel,
        tag: *const ::std::os::raw::c_char,
        fmtstr: *const ::std::os::raw::c_char,
        ...
    );
}
extern "C" {
    pub fn r_vlog(
        funcname: *const ::std::os::raw::c_char,
        filename: *const ::std::os::raw::c_char,
        lineno: ::std::os::raw::c_uint,
        level: RLogLevel,
        tag: *const ::std::os::raw::c_char,
        fmtstr: *const ::std::os::raw::c_char,
        args: *mut __va_list_tag,
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RNumCalcValue {
    pub d: f64,
    pub n: ::std::os::raw::c_ulonglong,
}
#[test]
fn bindgen_test_layout_RNumCalcValue() {
    assert_eq!(
        ::std::mem::size_of::<RNumCalcValue>(),
        16usize,
        concat!("Size of: ", stringify!(RNumCalcValue))
    );
    assert_eq!(
        ::std::mem::align_of::<RNumCalcValue>(),
        8usize,
        concat!("Alignment of ", stringify!(RNumCalcValue))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RNumCalcValue>())).d as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(RNumCalcValue),
            "::",
            stringify!(d)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RNumCalcValue>())).n as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(RNumCalcValue),
            "::",
            stringify!(n)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union RNumFloat {
    pub u16_: ::std::os::raw::c_ushort,
    pub u32_: ::std::os::raw::c_uint,
    pub u64_: ::std::os::raw::c_ulonglong,
    pub s16: ::std::os::raw::c_short,
    pub s32: ::std::os::raw::c_int,
    pub s64: ::std::os::raw::c_longlong,
    pub f32_: f32,
    pub f64_: f64,
}
#[test]
fn bindgen_test_layout_RNumFloat() {
    assert_eq!(
        ::std::mem::size_of::<RNumFloat>(),
        8usize,
        concat!("Size of: ", stringify!(RNumFloat))
    );
    assert_eq!(
        ::std::mem::align_of::<RNumFloat>(),
        8usize,
        concat!("Alignment of ", stringify!(RNumFloat))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RNumFloat>())).u16_ as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(RNumFloat),
            "::",
            stringify!(u16_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RNumFloat>())).u32_ as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(RNumFloat),
            "::",
            stringify!(u32_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RNumFloat>())).u64_ as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(RNumFloat),
            "::",
            stringify!(u64_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RNumFloat>())).s16 as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(RNumFloat),
            "::",
            stringify!(s16)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RNumFloat>())).s32 as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(RNumFloat),
            "::",
            stringify!(s32)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RNumFloat>())).s64 as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(RNumFloat),
            "::",
            stringify!(s64)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RNumFloat>())).f32_ as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(RNumFloat),
            "::",
            stringify!(f32_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RNumFloat>())).f64_ as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(RNumFloat),
            "::",
            stringify!(f64_)
        )
    );
}
pub const RNumCalcToken_RNCNAME: RNumCalcToken = 0;
pub const RNumCalcToken_RNCNUMBER: RNumCalcToken = 1;
pub const RNumCalcToken_RNCEND: RNumCalcToken = 2;
pub const RNumCalcToken_RNCINC: RNumCalcToken = 3;
pub const RNumCalcToken_RNCDEC: RNumCalcToken = 4;
pub const RNumCalcToken_RNCLT: RNumCalcToken = 5;
pub const RNumCalcToken_RNCGT: RNumCalcToken = 6;
pub const RNumCalcToken_RNCPLUS: RNumCalcToken = 43;
pub const RNumCalcToken_RNCMINUS: RNumCalcToken = 45;
pub const RNumCalcToken_RNCMUL: RNumCalcToken = 42;
pub const RNumCalcToken_RNCDIV: RNumCalcToken = 47;
pub const RNumCalcToken_RNCMOD: RNumCalcToken = 37;
pub const RNumCalcToken_RNCNEG: RNumCalcToken = 126;
pub const RNumCalcToken_RNCAND: RNumCalcToken = 38;
pub const RNumCalcToken_RNCOR: RNumCalcToken = 124;
pub const RNumCalcToken_RNCXOR: RNumCalcToken = 94;
pub const RNumCalcToken_RNCPRINT: RNumCalcToken = 59;
pub const RNumCalcToken_RNCASSIGN: RNumCalcToken = 61;
pub const RNumCalcToken_RNCLEFTP: RNumCalcToken = 40;
pub const RNumCalcToken_RNCRIGHTP: RNumCalcToken = 41;
pub const RNumCalcToken_RNCSHL: RNumCalcToken = 60;
pub const RNumCalcToken_RNCSHR: RNumCalcToken = 62;
pub const RNumCalcToken_RNCROL: RNumCalcToken = 35;
pub const RNumCalcToken_RNCROR: RNumCalcToken = 36;
pub type RNumCalcToken = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_num_calc_t {
    pub curr_tok: RNumCalcToken,
    pub number_value: RNumCalcValue,
    pub string_value: [::std::os::raw::c_char; 1024usize],
    pub errors: ::std::os::raw::c_int,
    pub oc: ::std::os::raw::c_char,
    pub calc_err: *const ::std::os::raw::c_char,
    pub calc_i: ::std::os::raw::c_int,
    pub calc_buf: *const ::std::os::raw::c_char,
    pub calc_len: ::std::os::raw::c_int,
    pub under_calc: bool,
}
#[test]
fn bindgen_test_layout_r_num_calc_t() {
    assert_eq!(
        ::std::mem::size_of::<r_num_calc_t>(),
        1088usize,
        concat!("Size of: ", stringify!(r_num_calc_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_num_calc_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_num_calc_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_num_calc_t>())).curr_tok as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_num_calc_t),
            "::",
            stringify!(curr_tok)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_num_calc_t>())).number_value as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_num_calc_t),
            "::",
            stringify!(number_value)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_num_calc_t>())).string_value as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(r_num_calc_t),
            "::",
            stringify!(string_value)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_num_calc_t>())).errors as *const _ as usize },
        1048usize,
        concat!(
            "Offset of field: ",
            stringify!(r_num_calc_t),
            "::",
            stringify!(errors)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_num_calc_t>())).oc as *const _ as usize },
        1052usize,
        concat!(
            "Offset of field: ",
            stringify!(r_num_calc_t),
            "::",
            stringify!(oc)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_num_calc_t>())).calc_err as *const _ as usize },
        1056usize,
        concat!(
            "Offset of field: ",
            stringify!(r_num_calc_t),
            "::",
            stringify!(calc_err)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_num_calc_t>())).calc_i as *const _ as usize },
        1064usize,
        concat!(
            "Offset of field: ",
            stringify!(r_num_calc_t),
            "::",
            stringify!(calc_i)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_num_calc_t>())).calc_buf as *const _ as usize },
        1072usize,
        concat!(
            "Offset of field: ",
            stringify!(r_num_calc_t),
            "::",
            stringify!(calc_buf)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_num_calc_t>())).calc_len as *const _ as usize },
        1080usize,
        concat!(
            "Offset of field: ",
            stringify!(r_num_calc_t),
            "::",
            stringify!(calc_len)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_num_calc_t>())).under_calc as *const _ as usize },
        1084usize,
        concat!(
            "Offset of field: ",
            stringify!(r_num_calc_t),
            "::",
            stringify!(under_calc)
        )
    );
}
pub type RNumCalc = r_num_calc_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_num_t {
    pub callback: ::std::option::Option<
        unsafe extern "C" fn(
            userptr: *mut r_num_t,
            str_: *const ::std::os::raw::c_char,
            ok: *mut ::std::os::raw::c_int,
        ) -> ::std::os::raw::c_ulonglong,
    >,
    pub cb_from_value: ::std::option::Option<
        unsafe extern "C" fn(
            userptr: *mut r_num_t,
            value: ::std::os::raw::c_ulonglong,
            ok: *mut ::std::os::raw::c_int,
        ) -> *const ::std::os::raw::c_char,
    >,
    pub value: ::std::os::raw::c_ulonglong,
    pub fvalue: f64,
    pub userptr: *mut ::std::os::raw::c_void,
    pub dbz: ::std::os::raw::c_int,
    #[doc = " division by zero happened"]
    pub nc: RNumCalc,
}
#[test]
fn bindgen_test_layout_r_num_t() {
    assert_eq!(
        ::std::mem::size_of::<r_num_t>(),
        1136usize,
        concat!("Size of: ", stringify!(r_num_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_num_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_num_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_num_t>())).callback as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_num_t),
            "::",
            stringify!(callback)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_num_t>())).cb_from_value as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_num_t),
            "::",
            stringify!(cb_from_value)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_num_t>())).value as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(r_num_t),
            "::",
            stringify!(value)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_num_t>())).fvalue as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(r_num_t),
            "::",
            stringify!(fvalue)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_num_t>())).userptr as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(r_num_t),
            "::",
            stringify!(userptr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_num_t>())).dbz as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(r_num_t),
            "::",
            stringify!(dbz)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_num_t>())).nc as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(r_num_t),
            "::",
            stringify!(nc)
        )
    );
}
pub type RNum = r_num_t;
pub type RNumCallback = ::std::option::Option<
    unsafe extern "C" fn(
        self_: *mut r_num_t,
        str_: *const ::std::os::raw::c_char,
        ok: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_ulonglong,
>;
pub type RNumCallback2 = ::std::option::Option<
    unsafe extern "C" fn(
        self_: *mut r_num_t,
        arg1: ::std::os::raw::c_ulonglong,
        ok: *mut ::std::os::raw::c_int,
    ) -> *const ::std::os::raw::c_char,
>;
extern "C" {
    pub fn r_num_new(
        cb: RNumCallback,
        cb2: RNumCallback2,
        ptr: *mut ::std::os::raw::c_void,
    ) -> *mut RNum;
}
extern "C" {
    pub fn r_num_free(num: *mut RNum);
}
extern "C" {
    pub fn r_num_units(
        buf: *mut ::std::os::raw::c_char,
        len: size_t,
        number: ::std::os::raw::c_ulonglong,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_num_conditional(
        num: *mut RNum,
        str_: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_num_calc(
        num: *mut RNum,
        str_: *const ::std::os::raw::c_char,
        err: *mut *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_ulonglong;
}
extern "C" {
    pub fn r_num_calc_index(
        num: *mut RNum,
        p: *const ::std::os::raw::c_char,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_num_chs(
        cylinder: ::std::os::raw::c_int,
        head: ::std::os::raw::c_int,
        sector: ::std::os::raw::c_int,
        sectorsize: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_ulonglong;
}
extern "C" {
    pub fn r_num_is_valid_input(
        num: *mut RNum,
        input_value: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_num_get_input_value(
        num: *mut RNum,
        input_value: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_ulonglong;
}
extern "C" {
    pub fn r_num_get_name(
        num: *mut RNum,
        n: ::std::os::raw::c_ulonglong,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_num_as_string(
        ___: *mut RNum,
        n: ::std::os::raw::c_ulonglong,
        printable_only: bool,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_num_tail(
        num: *mut RNum,
        addr: ::std::os::raw::c_ulonglong,
        hex: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_ulonglong;
}
extern "C" {
    pub fn r_num_tail_base(
        num: *mut RNum,
        addr: ::std::os::raw::c_ulonglong,
        off: ::std::os::raw::c_ulonglong,
    ) -> ::std::os::raw::c_ulonglong;
}
extern "C" {
    pub fn r_num_minmax_swap(
        a: *mut ::std::os::raw::c_ulonglong,
        b: *mut ::std::os::raw::c_ulonglong,
    );
}
extern "C" {
    pub fn r_num_minmax_swap_i(a: *mut ::std::os::raw::c_int, b: *mut ::std::os::raw::c_int);
}
extern "C" {
    pub fn r_num_math(
        num: *mut RNum,
        str_: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_ulonglong;
}
extern "C" {
    pub fn r_num_get(
        num: *mut RNum,
        str_: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_ulonglong;
}
extern "C" {
    pub fn r_num_to_bits(
        out: *mut ::std::os::raw::c_char,
        num: ::std::os::raw::c_ulonglong,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_num_to_ternary(
        out: *mut ::std::os::raw::c_char,
        num: ::std::os::raw::c_ulonglong,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_num_rand(max: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_num_irand();
}
extern "C" {
    pub fn r_get_input_num_value(
        num: *mut RNum,
        input_value: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_ulonglong;
}
extern "C" {
    pub fn r_is_valid_input_num_value(
        num: *mut RNum,
        input_value: *const ::std::os::raw::c_char,
    ) -> bool;
}
extern "C" {
    pub fn r_num_between(
        num: *mut RNum,
        input_value: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_num_is_op(c: ::std::os::raw::c_char) -> bool;
}
extern "C" {
    pub fn r_num_str_len(str_: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_num_str_split(str_: *mut ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_num_str_split_list(str_: *mut ::std::os::raw::c_char) -> *mut RList;
}
extern "C" {
    pub fn r_num_dup(n: ::std::os::raw::c_ulonglong) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn r_num_cos(a: f64) -> f64;
}
extern "C" {
    pub fn r_num_sin(a: f64) -> f64;
}
extern "C" {
    pub fn r_num_bit_count(val: ::std::os::raw::c_uint) -> size_t;
}
extern "C" {
    pub fn r_num_get_float(num: *mut RNum, str_: *const ::std::os::raw::c_char) -> f64;
}
pub const RPanelLayout_PANEL_LAYOUT_VERTICAL: RPanelLayout = 0;
pub const RPanelLayout_PANEL_LAYOUT_HORIZONTAL: RPanelLayout = 1;
pub const RPanelLayout_PANEL_LAYOUT_NONE: RPanelLayout = 2;
pub type RPanelLayout = ::std::os::raw::c_uint;
pub const RPanelType_PANEL_TYPE_DEFAULT: RPanelType = 0;
pub const RPanelType_PANEL_TYPE_MENU: RPanelType = 1;
pub type RPanelType = ::std::os::raw::c_uint;
pub const RPanelEdge_PANEL_EDGE_NONE: RPanelEdge = 0;
pub const RPanelEdge_PANEL_EDGE_BOTTOM: RPanelEdge = 1;
pub const RPanelEdge_PANEL_EDGE_RIGHT: RPanelEdge = 2;
pub type RPanelEdge = ::std::os::raw::c_uint;
pub type RPanelMenuUpdateCallback = ::std::option::Option<
    unsafe extern "C" fn(user: *mut ::std::os::raw::c_void, parent: *const ::std::os::raw::c_char),
>;
pub type RPanelDirectionCallback = ::std::option::Option<
    unsafe extern "C" fn(user: *mut ::std::os::raw::c_void, direction: ::std::os::raw::c_int),
>;
pub type RPanelRotateCallback =
    ::std::option::Option<unsafe extern "C" fn(user: *mut ::std::os::raw::c_void, rev: bool)>;
pub type RPanelPrintCallback = ::std::option::Option<
    unsafe extern "C" fn(user: *mut ::std::os::raw::c_void, p: *mut ::std::os::raw::c_void),
>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_panel_pos_t {
    pub x: ::std::os::raw::c_int,
    pub y: ::std::os::raw::c_int,
    pub w: ::std::os::raw::c_int,
    pub h: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_r_panel_pos_t() {
    assert_eq!(
        ::std::mem::size_of::<r_panel_pos_t>(),
        16usize,
        concat!("Size of: ", stringify!(r_panel_pos_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_panel_pos_t>(),
        4usize,
        concat!("Alignment of ", stringify!(r_panel_pos_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_panel_pos_t>())).x as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_panel_pos_t),
            "::",
            stringify!(x)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_panel_pos_t>())).y as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(r_panel_pos_t),
            "::",
            stringify!(y)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_panel_pos_t>())).w as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_panel_pos_t),
            "::",
            stringify!(w)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_panel_pos_t>())).h as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(r_panel_pos_t),
            "::",
            stringify!(h)
        )
    );
}
pub type RPanelPos = r_panel_pos_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_panel_model_t {
    pub directionCb: RPanelDirectionCallback,
    pub rotateCb: RPanelRotateCallback,
    pub print_cb: RPanelPrintCallback,
    pub type_: RPanelType,
    pub cmd: *mut ::std::os::raw::c_char,
    pub title: *mut ::std::os::raw::c_char,
    pub baseAddr: ::std::os::raw::c_ulonglong,
    pub addr: ::std::os::raw::c_ulonglong,
    pub cache: bool,
    pub cmdStrCache: *mut ::std::os::raw::c_char,
    pub readOnly: *mut ::std::os::raw::c_char,
    pub funcName: *mut ::std::os::raw::c_char,
    pub filter: *mut *mut ::std::os::raw::c_char,
    pub n_filter: ::std::os::raw::c_int,
    pub rotate: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_r_panel_model_t() {
    assert_eq!(
        ::std::mem::size_of::<r_panel_model_t>(),
        112usize,
        concat!("Size of: ", stringify!(r_panel_model_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_panel_model_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_panel_model_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_panel_model_t>())).directionCb as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_panel_model_t),
            "::",
            stringify!(directionCb)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_panel_model_t>())).rotateCb as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_panel_model_t),
            "::",
            stringify!(rotateCb)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_panel_model_t>())).print_cb as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(r_panel_model_t),
            "::",
            stringify!(print_cb)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_panel_model_t>())).type_ as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(r_panel_model_t),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_panel_model_t>())).cmd as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(r_panel_model_t),
            "::",
            stringify!(cmd)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_panel_model_t>())).title as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(r_panel_model_t),
            "::",
            stringify!(title)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_panel_model_t>())).baseAddr as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(r_panel_model_t),
            "::",
            stringify!(baseAddr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_panel_model_t>())).addr as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(r_panel_model_t),
            "::",
            stringify!(addr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_panel_model_t>())).cache as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(r_panel_model_t),
            "::",
            stringify!(cache)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_panel_model_t>())).cmdStrCache as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(r_panel_model_t),
            "::",
            stringify!(cmdStrCache)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_panel_model_t>())).readOnly as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(r_panel_model_t),
            "::",
            stringify!(readOnly)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_panel_model_t>())).funcName as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(r_panel_model_t),
            "::",
            stringify!(funcName)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_panel_model_t>())).filter as *const _ as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(r_panel_model_t),
            "::",
            stringify!(filter)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_panel_model_t>())).n_filter as *const _ as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(r_panel_model_t),
            "::",
            stringify!(n_filter)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_panel_model_t>())).rotate as *const _ as usize },
        108usize,
        concat!(
            "Offset of field: ",
            stringify!(r_panel_model_t),
            "::",
            stringify!(rotate)
        )
    );
}
pub type RPanelModel = r_panel_model_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_panel_view_t {
    pub pos: RPanelPos,
    pub prevPos: RPanelPos,
    pub sx: ::std::os::raw::c_int,
    pub sy: ::std::os::raw::c_int,
    pub curpos: ::std::os::raw::c_int,
    pub refresh: bool,
    pub edge: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_r_panel_view_t() {
    assert_eq!(
        ::std::mem::size_of::<r_panel_view_t>(),
        52usize,
        concat!("Size of: ", stringify!(r_panel_view_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_panel_view_t>(),
        4usize,
        concat!("Alignment of ", stringify!(r_panel_view_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_panel_view_t>())).pos as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_panel_view_t),
            "::",
            stringify!(pos)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_panel_view_t>())).prevPos as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(r_panel_view_t),
            "::",
            stringify!(prevPos)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_panel_view_t>())).sx as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(r_panel_view_t),
            "::",
            stringify!(sx)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_panel_view_t>())).sy as *const _ as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(r_panel_view_t),
            "::",
            stringify!(sy)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_panel_view_t>())).curpos as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(r_panel_view_t),
            "::",
            stringify!(curpos)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_panel_view_t>())).refresh as *const _ as usize },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(r_panel_view_t),
            "::",
            stringify!(refresh)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_panel_view_t>())).edge as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(r_panel_view_t),
            "::",
            stringify!(edge)
        )
    );
}
pub type RPanelView = r_panel_view_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_panel_t {
    pub model: *mut RPanelModel,
    pub view: *mut RPanelView,
}
#[test]
fn bindgen_test_layout_r_panel_t() {
    assert_eq!(
        ::std::mem::size_of::<r_panel_t>(),
        16usize,
        concat!("Size of: ", stringify!(r_panel_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_panel_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_panel_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_panel_t>())).model as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_panel_t),
            "::",
            stringify!(model)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_panel_t>())).view as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_panel_t),
            "::",
            stringify!(view)
        )
    );
}
pub type RPanel = r_panel_t;
pub type RPanelAlmightyCallback = ::std::option::Option<
    unsafe extern "C" fn(
        user: *mut ::std::os::raw::c_void,
        panel: *mut RPanel,
        dir: RPanelLayout,
        title: *const ::std::os::raw::c_char,
    ),
>;
extern "C" {
    pub fn r_sandbox_opendir(path: *const ::std::os::raw::c_char) -> *mut DIR;
}
extern "C" {
    pub fn r_sandbox_truncate(
        fd: ::std::os::raw::c_int,
        length: ::std::os::raw::c_ulonglong,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_sandbox_lseek(
        fd: ::std::os::raw::c_int,
        addr: ::std::os::raw::c_ulonglong,
        mode: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_sandbox_close(fd: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_sandbox_read(
        fd: ::std::os::raw::c_int,
        buf: *mut ::std::os::raw::c_uchar,
        len: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_sandbox_write(
        fd: ::std::os::raw::c_int,
        buf: *const ::std::os::raw::c_uchar,
        len: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_sandbox_enable(e: bool) -> bool;
}
extern "C" {
    pub fn r_sandbox_disable(e: bool) -> bool;
}
extern "C" {
    pub fn r_sandbox_system(
        x: *const ::std::os::raw::c_char,
        fork: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_sandbox_creat(
        path: *const ::std::os::raw::c_char,
        mode: ::std::os::raw::c_int,
    ) -> bool;
}
extern "C" {
    pub fn r_sandbox_open(
        path: *const ::std::os::raw::c_char,
        mode: ::std::os::raw::c_int,
        perm: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_sandbox_fopen(
        path: *const ::std::os::raw::c_char,
        mode: *const ::std::os::raw::c_char,
    ) -> *mut FILE;
}
extern "C" {
    pub fn r_sandbox_chdir(path: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_sandbox_check_path(path: *const ::std::os::raw::c_char) -> bool;
}
extern "C" {
    pub fn r_sandbox_kill(
        pid: ::std::os::raw::c_int,
        sig: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub static sys_signame: [*const ::std::os::raw::c_char; 32usize];
}
extern "C" {
    pub static sys_siglist: [*const ::std::os::raw::c_char; 32usize];
}
extern "C" {
    pub fn raise(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bsd_signal(
        arg1: ::std::os::raw::c_int,
        arg2: ::std::option::Option<unsafe extern "C" fn(arg1: ::std::os::raw::c_int)>,
    ) -> ::std::option::Option<
        unsafe extern "C" fn(
            arg1: ::std::os::raw::c_int,
            arg2: ::std::option::Option<unsafe extern "C" fn(arg1: ::std::os::raw::c_int)>,
        ),
    >;
}
extern "C" {
    pub fn kill(arg1: pid_t, arg2: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn killpg(arg1: pid_t, arg2: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_kill(arg1: pthread_t, arg2: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_sigmask(
        arg1: ::std::os::raw::c_int,
        arg2: *const sigset_t,
        arg3: *mut sigset_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sigaction(
        arg1: ::std::os::raw::c_int,
        arg2: *const sigaction,
        arg3: *mut sigaction,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sigaddset(arg1: *mut sigset_t, arg2: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sigaltstack(arg1: *const stack_t, arg2: *mut stack_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sigdelset(arg1: *mut sigset_t, arg2: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sigemptyset(arg1: *mut sigset_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sigfillset(arg1: *mut sigset_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sighold(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sigignore(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn siginterrupt(
        arg1: ::std::os::raw::c_int,
        arg2: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sigismember(arg1: *const sigset_t, arg2: ::std::os::raw::c_int)
        -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sigpause(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sigpending(arg1: *mut sigset_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sigprocmask(
        arg1: ::std::os::raw::c_int,
        arg2: *const sigset_t,
        arg3: *mut sigset_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sigrelse(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sigset(
        arg1: ::std::os::raw::c_int,
        arg2: ::std::option::Option<unsafe extern "C" fn(arg1: ::std::os::raw::c_int)>,
    ) -> ::std::option::Option<
        unsafe extern "C" fn(
            arg1: ::std::os::raw::c_int,
            arg2: ::std::option::Option<unsafe extern "C" fn(arg1: ::std::os::raw::c_int)>,
        ),
    >;
}
extern "C" {
    pub fn sigsuspend(arg1: *const sigset_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sigwait(
        arg1: *const sigset_t,
        arg2: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn psignal(arg1: ::std::os::raw::c_uint, arg2: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn sigblock(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sigsetmask(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sigvec(
        arg1: ::std::os::raw::c_int,
        arg2: *mut sigvec,
        arg3: *mut sigvec,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_signal_from_string(str_: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_signal_to_string(code: ::std::os::raw::c_int) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_signal_to_human(signum: ::std::os::raw::c_int) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_signal_sigmask(
        how: ::std::os::raw::c_int,
        newmask: *const sigset_t,
        oldmask: *mut sigset_t,
    );
}
pub type RStackFree = ::std::option::Option<unsafe extern "C" fn(ptr: *mut ::std::os::raw::c_void)>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_stack_t {
    pub elems: *mut *mut ::std::os::raw::c_void,
    pub n_elems: ::std::os::raw::c_uint,
    pub top: ::std::os::raw::c_int,
    pub free: RStackFree,
}
#[test]
fn bindgen_test_layout_r_stack_t() {
    assert_eq!(
        ::std::mem::size_of::<r_stack_t>(),
        24usize,
        concat!("Size of: ", stringify!(r_stack_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_stack_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_stack_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_stack_t>())).elems as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_stack_t),
            "::",
            stringify!(elems)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_stack_t>())).n_elems as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_stack_t),
            "::",
            stringify!(n_elems)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_stack_t>())).top as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(r_stack_t),
            "::",
            stringify!(top)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_stack_t>())).free as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(r_stack_t),
            "::",
            stringify!(free)
        )
    );
}
pub type RStack = r_stack_t;
extern "C" {
    pub fn r_stack_new(n: ::std::os::raw::c_uint) -> *mut RStack;
}
extern "C" {
    pub fn r_stack_free(s: *mut RStack);
}
extern "C" {
    pub fn r_stack_is_empty(s: *mut RStack) -> bool;
}
extern "C" {
    pub fn r_stack_newf(n: ::std::os::raw::c_uint, f: RStackFree) -> *mut RStack;
}
extern "C" {
    pub fn r_stack_push(s: *mut RStack, el: *mut ::std::os::raw::c_void) -> bool;
}
extern "C" {
    pub fn r_stack_pop(s: *mut RStack) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn r_stack_size(s: *mut RStack) -> size_t;
}
extern "C" {
    pub fn r_stack_peek(s: *mut RStack) -> *mut ::std::os::raw::c_void;
}
pub type mbstate_t = __darwin_mbstate_t;
pub type wctype_t = __darwin_wctype_t;
extern "C" {
    pub fn wctype(arg1: *const ::std::os::raw::c_char) -> wctype_t;
}
extern "C" {
    pub fn btowc(arg1: ::std::os::raw::c_int) -> wint_t;
}
extern "C" {
    pub fn fgetwc(arg1: *mut FILE) -> wint_t;
}
extern "C" {
    pub fn fgetws(arg1: *mut wchar_t, arg2: ::std::os::raw::c_int, arg3: *mut FILE)
        -> *mut wchar_t;
}
extern "C" {
    pub fn fputwc(arg1: wchar_t, arg2: *mut FILE) -> wint_t;
}
extern "C" {
    pub fn fputws(arg1: *const wchar_t, arg2: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fwide(arg1: *mut FILE, arg2: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fwprintf(arg1: *mut FILE, arg2: *const wchar_t, ...) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fwscanf(arg1: *mut FILE, arg2: *const wchar_t, ...) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getwc(arg1: *mut FILE) -> wint_t;
}
extern "C" {
    pub fn getwchar() -> wint_t;
}
extern "C" {
    pub fn mbrlen(
        arg1: *const ::std::os::raw::c_char,
        arg2: size_t,
        arg3: *mut mbstate_t,
    ) -> size_t;
}
extern "C" {
    pub fn mbrtowc(
        arg1: *mut wchar_t,
        arg2: *const ::std::os::raw::c_char,
        arg3: size_t,
        arg4: *mut mbstate_t,
    ) -> size_t;
}
extern "C" {
    pub fn mbsinit(arg1: *const mbstate_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mbsrtowcs(
        arg1: *mut wchar_t,
        arg2: *mut *const ::std::os::raw::c_char,
        arg3: size_t,
        arg4: *mut mbstate_t,
    ) -> size_t;
}
extern "C" {
    pub fn putwc(arg1: wchar_t, arg2: *mut FILE) -> wint_t;
}
extern "C" {
    pub fn putwchar(arg1: wchar_t) -> wint_t;
}
extern "C" {
    pub fn swprintf(
        arg1: *mut wchar_t,
        arg2: size_t,
        arg3: *const wchar_t,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn swscanf(arg1: *const wchar_t, arg2: *const wchar_t, ...) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ungetwc(arg1: wint_t, arg2: *mut FILE) -> wint_t;
}
extern "C" {
    pub fn vfwprintf(
        arg1: *mut FILE,
        arg2: *const wchar_t,
        arg3: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vswprintf(
        arg1: *mut wchar_t,
        arg2: size_t,
        arg3: *const wchar_t,
        arg4: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vwprintf(arg1: *const wchar_t, arg2: *mut __va_list_tag) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn wcrtomb(
        arg1: *mut ::std::os::raw::c_char,
        arg2: wchar_t,
        arg3: *mut mbstate_t,
    ) -> size_t;
}
extern "C" {
    pub fn wcscat(arg1: *mut wchar_t, arg2: *const wchar_t) -> *mut wchar_t;
}
extern "C" {
    pub fn wcschr(
        arg1: *const ::std::os::raw::c_int,
        arg2: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_int;
}
extern "C" {
    pub fn wcscmp(
        arg1: *const ::std::os::raw::c_int,
        arg2: *const ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn wcscoll(arg1: *const wchar_t, arg2: *const wchar_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn wcscpy(arg1: *mut wchar_t, arg2: *const wchar_t) -> *mut wchar_t;
}
extern "C" {
    pub fn wcscspn(arg1: *const wchar_t, arg2: *const wchar_t) -> size_t;
}
extern "C" {
    pub fn wcsftime(
        arg1: *mut wchar_t,
        arg2: size_t,
        arg3: *const wchar_t,
        arg4: *const tm,
    ) -> size_t;
}
extern "C" {
    pub fn wcslen(arg1: *const ::std::os::raw::c_int) -> ::std::os::raw::c_ulong;
}
extern "C" {
    pub fn wcsncat(arg1: *mut wchar_t, arg2: *const wchar_t, arg3: size_t) -> *mut wchar_t;
}
extern "C" {
    pub fn wcsncmp(
        arg1: *const ::std::os::raw::c_int,
        arg2: *const ::std::os::raw::c_int,
        arg3: ::std::os::raw::c_ulong,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn wcsncpy(arg1: *mut wchar_t, arg2: *const wchar_t, arg3: size_t) -> *mut wchar_t;
}
extern "C" {
    pub fn wcspbrk(arg1: *const wchar_t, arg2: *const wchar_t) -> *mut wchar_t;
}
extern "C" {
    pub fn wcsrchr(arg1: *const wchar_t, arg2: wchar_t) -> *mut wchar_t;
}
extern "C" {
    pub fn wcsrtombs(
        arg1: *mut ::std::os::raw::c_char,
        arg2: *mut *const wchar_t,
        arg3: size_t,
        arg4: *mut mbstate_t,
    ) -> size_t;
}
extern "C" {
    pub fn wcsspn(arg1: *const wchar_t, arg2: *const wchar_t) -> size_t;
}
extern "C" {
    pub fn wcsstr(arg1: *const wchar_t, arg2: *const wchar_t) -> *mut wchar_t;
}
extern "C" {
    pub fn wcsxfrm(arg1: *mut wchar_t, arg2: *const wchar_t, arg3: size_t) -> size_t;
}
extern "C" {
    pub fn wctob(arg1: wint_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn wcstod(arg1: *const wchar_t, arg2: *mut *mut wchar_t) -> f64;
}
extern "C" {
    pub fn wcstok(
        arg1: *mut wchar_t,
        arg2: *const wchar_t,
        arg3: *mut *mut wchar_t,
    ) -> *mut wchar_t;
}
extern "C" {
    pub fn wcstol(
        arg1: *const wchar_t,
        arg2: *mut *mut wchar_t,
        arg3: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn wcstoul(
        arg1: *const wchar_t,
        arg2: *mut *mut wchar_t,
        arg3: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_ulong;
}
extern "C" {
    pub fn wmemchr(
        arg1: *const ::std::os::raw::c_int,
        arg2: ::std::os::raw::c_int,
        arg3: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_int;
}
extern "C" {
    pub fn wmemcmp(
        arg1: *const ::std::os::raw::c_int,
        arg2: *const ::std::os::raw::c_int,
        arg3: ::std::os::raw::c_ulong,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn wmemcpy(
        arg1: *mut ::std::os::raw::c_int,
        arg2: *const ::std::os::raw::c_int,
        arg3: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_int;
}
extern "C" {
    pub fn wmemmove(
        arg1: *mut ::std::os::raw::c_int,
        arg2: *const ::std::os::raw::c_int,
        arg3: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_int;
}
extern "C" {
    pub fn wmemset(arg1: *mut wchar_t, arg2: wchar_t, arg3: size_t) -> *mut wchar_t;
}
extern "C" {
    pub fn wprintf(arg1: *const wchar_t, ...) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn wscanf(arg1: *const wchar_t, ...) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn wcswidth(arg1: *const wchar_t, arg2: size_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn wcwidth(arg1: wchar_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vfwscanf(
        arg1: *mut FILE,
        arg2: *const wchar_t,
        arg3: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vswscanf(
        arg1: *const wchar_t,
        arg2: *const wchar_t,
        arg3: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vwscanf(arg1: *const wchar_t, arg2: *mut __va_list_tag) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn wcstof(arg1: *const wchar_t, arg2: *mut *mut wchar_t) -> f32;
}
extern "C" {
    pub fn wcstold(arg1: *const wchar_t, arg2: *mut *mut wchar_t) -> u128;
}
extern "C" {
    pub fn wcstoll(
        arg1: *const wchar_t,
        arg2: *mut *mut wchar_t,
        arg3: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_longlong;
}
extern "C" {
    pub fn wcstoull(
        arg1: *const wchar_t,
        arg2: *mut *mut wchar_t,
        arg3: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_ulonglong;
}
extern "C" {
    pub fn mbsnrtowcs(
        arg1: *mut wchar_t,
        arg2: *mut *const ::std::os::raw::c_char,
        arg3: size_t,
        arg4: size_t,
        arg5: *mut mbstate_t,
    ) -> size_t;
}
extern "C" {
    pub fn wcpcpy(arg1: *mut wchar_t, arg2: *const wchar_t) -> *mut wchar_t;
}
extern "C" {
    pub fn wcpncpy(arg1: *mut wchar_t, arg2: *const wchar_t, arg3: size_t) -> *mut wchar_t;
}
extern "C" {
    pub fn wcsdup(arg1: *const wchar_t) -> *mut wchar_t;
}
extern "C" {
    pub fn wcscasecmp(arg1: *const wchar_t, arg2: *const wchar_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn wcsncasecmp(
        arg1: *const wchar_t,
        arg2: *const wchar_t,
        n: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn wcsnlen(arg1: *const wchar_t, arg2: size_t) -> size_t;
}
extern "C" {
    pub fn wcsnrtombs(
        arg1: *mut ::std::os::raw::c_char,
        arg2: *mut *const wchar_t,
        arg3: size_t,
        arg4: size_t,
        arg5: *mut mbstate_t,
    ) -> size_t;
}
extern "C" {
    pub fn open_wmemstream(__bufp: *mut *mut wchar_t, __sizep: *mut size_t) -> *mut FILE;
}
extern "C" {
    pub fn fgetwln(arg1: *mut FILE, arg2: *mut size_t) -> *mut wchar_t;
}
extern "C" {
    pub fn wcslcat(arg1: *mut wchar_t, arg2: *const wchar_t, arg3: size_t) -> size_t;
}
extern "C" {
    pub fn wcslcpy(arg1: *mut wchar_t, arg2: *const wchar_t, arg3: size_t) -> size_t;
}
pub const RStrEnc_R_STRING_ENC_LATIN1: RStrEnc = 97;
pub const RStrEnc_R_STRING_ENC_UTF8: RStrEnc = 56;
pub const RStrEnc_R_STRING_ENC_UTF16LE: RStrEnc = 117;
pub const RStrEnc_R_STRING_ENC_UTF32LE: RStrEnc = 85;
pub const RStrEnc_R_STRING_ENC_UTF16BE: RStrEnc = 98;
pub const RStrEnc_R_STRING_ENC_UTF32BE: RStrEnc = 66;
pub const RStrEnc_R_STRING_ENC_GUESS: RStrEnc = 103;
pub type RStrEnc = ::std::os::raw::c_uint;
pub type RStrRangeCallback = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: *mut ::std::os::raw::c_void,
        arg2: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int,
>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_charset_rune_t {
    pub ch: *mut ::std::os::raw::c_uchar,
    pub hx: *mut ::std::os::raw::c_uchar,
    pub left: *mut r_charset_rune_t,
    pub right: *mut r_charset_rune_t,
}
#[test]
fn bindgen_test_layout_r_charset_rune_t() {
    assert_eq!(
        ::std::mem::size_of::<r_charset_rune_t>(),
        32usize,
        concat!("Size of: ", stringify!(r_charset_rune_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_charset_rune_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_charset_rune_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_charset_rune_t>())).ch as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_charset_rune_t),
            "::",
            stringify!(ch)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_charset_rune_t>())).hx as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_charset_rune_t),
            "::",
            stringify!(hx)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_charset_rune_t>())).left as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(r_charset_rune_t),
            "::",
            stringify!(left)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_charset_rune_t>())).right as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(r_charset_rune_t),
            "::",
            stringify!(right)
        )
    );
}
pub type RCharsetRune = r_charset_rune_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_charset_t {
    pub loaded: bool,
    pub db: *mut Sdb,
    pub db_char_to_hex: *mut Sdb,
    pub custom_charset: *mut RCharsetRune,
    pub encode_maxkeylen: size_t,
    pub decode_maxkeylen: size_t,
}
#[test]
fn bindgen_test_layout_r_charset_t() {
    assert_eq!(
        ::std::mem::size_of::<r_charset_t>(),
        48usize,
        concat!("Size of: ", stringify!(r_charset_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_charset_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_charset_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_charset_t>())).loaded as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_charset_t),
            "::",
            stringify!(loaded)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_charset_t>())).db as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_charset_t),
            "::",
            stringify!(db)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_charset_t>())).db_char_to_hex as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(r_charset_t),
            "::",
            stringify!(db_char_to_hex)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_charset_t>())).custom_charset as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(r_charset_t),
            "::",
            stringify!(custom_charset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_charset_t>())).encode_maxkeylen as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(r_charset_t),
            "::",
            stringify!(encode_maxkeylen)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_charset_t>())).decode_maxkeylen as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(r_charset_t),
            "::",
            stringify!(decode_maxkeylen)
        )
    );
}
pub type RCharset = r_charset_t;
extern "C" {
    pub fn r_charset_new() -> *mut RCharset;
}
extern "C" {
    pub fn r_charset_free(charset: *mut RCharset);
}
extern "C" {
    pub fn r_charset_rune_new(
        ch: *const ::std::os::raw::c_uchar,
        hx: *const ::std::os::raw::c_uchar,
    ) -> *mut RCharsetRune;
}
extern "C" {
    pub fn r_charset_rune_free(rcr: *mut RCharsetRune);
}
extern "C" {
    pub fn r_charset_encode_str(
        rc: *mut RCharset,
        out: *mut ::std::os::raw::c_uchar,
        out_len: size_t,
        in_: *const ::std::os::raw::c_uchar,
        in_len: size_t,
    ) -> size_t;
}
extern "C" {
    pub fn r_charset_decode_str(
        rc: *mut RCharset,
        out: *mut ::std::os::raw::c_uchar,
        out_len: size_t,
        in_: *const ::std::os::raw::c_uchar,
        in_len: size_t,
    ) -> size_t;
}
extern "C" {
    pub fn r_charset_open(c: *mut RCharset, cs: *const ::std::os::raw::c_char) -> bool;
}
extern "C" {
    pub fn r_charset_use(c: *mut RCharset, cf: *const ::std::os::raw::c_char) -> bool;
}
extern "C" {
    pub fn r_charset_list(c: *mut RCharset) -> *mut RList;
}
extern "C" {
    pub fn r_charset_close(c: *mut RCharset);
}
extern "C" {
    pub fn add_rune(
        rcsr: *mut RCharsetRune,
        ch: *const ::std::os::raw::c_uchar,
        hx: *const ::std::os::raw::c_uchar,
    ) -> *mut RCharsetRune;
}
extern "C" {
    pub fn search_from_hex(
        rcsr: *mut RCharsetRune,
        hx: *const ::std::os::raw::c_uchar,
    ) -> *mut RCharsetRune;
}
extern "C" {
    pub fn search_from_char(
        rcsr: *mut RCharsetRune,
        ch: *const ::std::os::raw::c_uchar,
    ) -> *mut RCharsetRune;
}
extern "C" {
    pub fn r_str_repeat(
        ch: *const ::std::os::raw::c_char,
        sz: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_pad(
        ch: ::std::os::raw::c_char,
        len: ::std::os::raw::c_int,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_rstr(
        base: *const ::std::os::raw::c_char,
        p: *const ::std::os::raw::c_char,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_strstr_ansi(
        a: *const ::std::os::raw::c_char,
        b: *const ::std::os::raw::c_char,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_rchr(
        base: *const ::std::os::raw::c_char,
        p: *const ::std::os::raw::c_char,
        ch: ::std::os::raw::c_int,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_closer_chr(
        b: *const ::std::os::raw::c_char,
        s: *const ::std::os::raw::c_char,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_bounds(
        str_: *const ::std::os::raw::c_char,
        h: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_str_crop(
        str_: *const ::std::os::raw::c_char,
        x: ::std::os::raw::c_uint,
        y: ::std::os::raw::c_uint,
        x2: ::std::os::raw::c_uint,
        y2: ::std::os::raw::c_uint,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_scale(
        r: *const ::std::os::raw::c_char,
        w: ::std::os::raw::c_int,
        h: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_range_in(
        r: *const ::std::os::raw::c_char,
        addr: ::std::os::raw::c_ulonglong,
    ) -> bool;
}
extern "C" {
    pub fn r_str_size(
        s: *const ::std::os::raw::c_char,
        rows: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_str_len_utf8(s: *const ::std::os::raw::c_char) -> size_t;
}
extern "C" {
    pub fn r_str_len_utf8_ansi(str_: *const ::std::os::raw::c_char) -> size_t;
}
extern "C" {
    pub fn r_str_len_utf8char(
        s: *const ::std::os::raw::c_char,
        left: ::std::os::raw::c_int,
    ) -> size_t;
}
extern "C" {
    pub fn r_str_utf8_charsize(str_: *const ::std::os::raw::c_char) -> size_t;
}
extern "C" {
    pub fn r_str_utf8_charsize_prev(
        str_: *const ::std::os::raw::c_char,
        prev_len: ::std::os::raw::c_int,
    ) -> size_t;
}
extern "C" {
    pub fn r_str_utf8_charsize_last(str_: *const ::std::os::raw::c_char) -> size_t;
}
extern "C" {
    pub fn r_str_filter_zeroline(str_: *mut ::std::os::raw::c_char, len: ::std::os::raw::c_int);
}
extern "C" {
    pub fn r_str_utf8_codepoint(s: *const ::std::os::raw::c_char, left: size_t) -> size_t;
}
extern "C" {
    pub fn r_str_char_fullwidth(s: *const ::std::os::raw::c_char, left: size_t) -> bool;
}
extern "C" {
    pub fn r_str_write(
        fd: ::std::os::raw::c_int,
        b: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_str_ncpy(
        dst: *mut ::std::os::raw::c_char,
        src: *const ::std::os::raw::c_char,
        n: size_t,
    ) -> size_t;
}
extern "C" {
    pub fn r_str_sanitize(c: *mut ::std::os::raw::c_char);
}
extern "C" {
    pub fn r_str_sanitize_sdb_key(s: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_casestr(
        a: *const ::std::os::raw::c_char,
        b: *const ::std::os::raw::c_char,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_firstbut(
        s: *const ::std::os::raw::c_char,
        ch: ::std::os::raw::c_char,
        but: *const ::std::os::raw::c_char,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_firstbut_escape(
        s: *const ::std::os::raw::c_char,
        ch: ::std::os::raw::c_char,
        but: *const ::std::os::raw::c_char,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_lastbut(
        s: *const ::std::os::raw::c_char,
        ch: ::std::os::raw::c_char,
        but: *const ::std::os::raw::c_char,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_split(
        str_: *mut ::std::os::raw::c_char,
        ch: ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_str_split_list(
        str_: *mut ::std::os::raw::c_char,
        c: *const ::std::os::raw::c_char,
        n: ::std::os::raw::c_int,
    ) -> *mut RList;
}
extern "C" {
    pub fn r_str_split_duplist(
        str_: *const ::std::os::raw::c_char,
        c: *const ::std::os::raw::c_char,
        trim: bool,
    ) -> *mut RList;
}
extern "C" {
    pub fn r_str_split_lines(str_: *mut ::std::os::raw::c_char, count: *mut size_t) -> *mut size_t;
}
extern "C" {
    pub fn r_str_replace(
        str_: *mut ::std::os::raw::c_char,
        key: *const ::std::os::raw::c_char,
        val: *const ::std::os::raw::c_char,
        g: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_replace_icase(
        str_: *mut ::std::os::raw::c_char,
        key: *const ::std::os::raw::c_char,
        val: *const ::std::os::raw::c_char,
        g: ::std::os::raw::c_int,
        keep_case: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_replace_in(
        str_: *mut ::std::os::raw::c_char,
        sz: ::std::os::raw::c_uint,
        key: *const ::std::os::raw::c_char,
        val: *const ::std::os::raw::c_char,
        g: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_bits(
        strout: *mut ::std::os::raw::c_char,
        buf: *const ::std::os::raw::c_uchar,
        len: ::std::os::raw::c_int,
        bitz: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_str_bits64(
        strout: *mut ::std::os::raw::c_char,
        in_: ::std::os::raw::c_ulonglong,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_str_bits_from_string(
        buf: *const ::std::os::raw::c_char,
        bitz: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_ulonglong;
}
extern "C" {
    pub fn r_str_rwx(str_: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_str_replace_ch(
        s: *mut ::std::os::raw::c_char,
        a: ::std::os::raw::c_char,
        b: ::std::os::raw::c_char,
        g: bool,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_str_replace_char(
        s: *mut ::std::os::raw::c_char,
        a: ::std::os::raw::c_int,
        b: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_str_replace_char_once(
        s: *mut ::std::os::raw::c_char,
        a: ::std::os::raw::c_int,
        b: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_str_remove_char(str_: *mut ::std::os::raw::c_char, c: ::std::os::raw::c_char);
}
extern "C" {
    pub fn r_str_rwx_i(rwx: ::std::os::raw::c_int) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_fmtargs(fmt: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_str_arg_escape(arg: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_arg_unescape(arg: *mut ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_str_argv(
        str_: *const ::std::os::raw::c_char,
        _argc: *mut ::std::os::raw::c_int,
    ) -> *mut *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_argv_free(argv: *mut *mut ::std::os::raw::c_char);
}
extern "C" {
    pub fn r_str_new(str_: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_snprintf(
        string: *mut ::std::os::raw::c_char,
        len: ::std::os::raw::c_int,
        fmt: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_str_is_ascii(str_: *const ::std::os::raw::c_char) -> bool;
}
extern "C" {
    pub fn r_str_nextword(
        s: *mut ::std::os::raw::c_char,
        ch: ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_is_printable(str_: *const ::std::os::raw::c_char) -> bool;
}
extern "C" {
    pub fn r_str_is_printable_limited(
        str_: *const ::std::os::raw::c_char,
        size: ::std::os::raw::c_int,
    ) -> bool;
}
extern "C" {
    pub fn r_str_is_printable_incl_newlines(str_: *const ::std::os::raw::c_char) -> bool;
}
extern "C" {
    pub fn r_str_appendlen(
        ptr: *mut ::std::os::raw::c_char,
        string: *const ::std::os::raw::c_char,
        slen: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_newf(fmt: *const ::std::os::raw::c_char, ...) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_newvf(
        fmt: *const ::std::os::raw::c_char,
        ap: *mut __va_list_tag,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_distance(
        a: *const ::std::os::raw::c_char,
        b: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_str_newlen(
        str_: *const ::std::os::raw::c_char,
        len: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_sysbits(v: ::std::os::raw::c_int) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_trunc_ellipsis(
        str_: *const ::std::os::raw::c_char,
        len: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_bool(b: ::std::os::raw::c_int) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_is_true(s: *const ::std::os::raw::c_char) -> bool;
}
extern "C" {
    pub fn r_str_is_false(s: *const ::std::os::raw::c_char) -> bool;
}
extern "C" {
    pub fn r_str_is_bool(val: *const ::std::os::raw::c_char) -> bool;
}
extern "C" {
    pub fn r_str_ansi_chrn(
        str_: *const ::std::os::raw::c_char,
        n: size_t,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_ansi_len(str_: *const ::std::os::raw::c_char) -> size_t;
}
extern "C" {
    pub fn r_str_ansi_nlen(str_: *const ::std::os::raw::c_char, len: size_t) -> size_t;
}
extern "C" {
    pub fn r_str_ansi_trim(
        str_: *mut ::std::os::raw::c_char,
        str_len: ::std::os::raw::c_int,
        n: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_str_ansi_filter(
        str_: *mut ::std::os::raw::c_char,
        out: *mut *mut ::std::os::raw::c_char,
        cposs: *mut *mut ::std::os::raw::c_int,
        len: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_str_ansi_crop(
        str_: *const ::std::os::raw::c_char,
        x: ::std::os::raw::c_uint,
        y: ::std::os::raw::c_uint,
        x2: ::std::os::raw::c_uint,
        y2: ::std::os::raw::c_uint,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_word_count(string: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_str_char_count(
        string: *const ::std::os::raw::c_char,
        ch: ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_str_word_get0set(
        stra: *mut ::std::os::raw::c_char,
        stralen: ::std::os::raw::c_int,
        idx: ::std::os::raw::c_int,
        newstr: *const ::std::os::raw::c_char,
        newlen: *mut ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_word_set0(str_: *mut ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_str_word_set0_stack(str_: *mut ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_str_word_get0(
        str_: *const ::std::os::raw::c_char,
        idx: ::std::os::raw::c_int,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_word_get_first(
        string: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_trim(str_: *mut ::std::os::raw::c_char);
}
extern "C" {
    pub fn r_str_wrap(
        str_: *const ::std::os::raw::c_char,
        w: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_trim_dup(str_: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_trim_lines(str_: *mut ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_trim_head(str_: *mut ::std::os::raw::c_char);
}
extern "C" {
    pub fn r_str_trim_head_ro(str_: *const ::std::os::raw::c_char)
        -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_trim_head_wp(str_: *const ::std::os::raw::c_char)
        -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_trim_tail(str_: *mut ::std::os::raw::c_char);
}
extern "C" {
    pub fn r_str_trim_args(str_: *mut ::std::os::raw::c_char);
}
extern "C" {
    pub fn r_str_hash(str_: *const ::std::os::raw::c_char) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn r_str_hash64(str_: *const ::std::os::raw::c_char) -> ::std::os::raw::c_ulonglong;
}
extern "C" {
    pub fn r_str_trim_nc(str_: *mut ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_nstr(
        from: *const ::std::os::raw::c_char,
        to: *const ::std::os::raw::c_char,
        size: ::std::os::raw::c_int,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_lchr(
        str_: *const ::std::os::raw::c_char,
        chr: ::std::os::raw::c_char,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_sub_str_lchr(
        str_: *const ::std::os::raw::c_char,
        start: ::std::os::raw::c_int,
        end: ::std::os::raw::c_int,
        chr: ::std::os::raw::c_char,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_sub_str_rchr(
        str_: *const ::std::os::raw::c_char,
        start: ::std::os::raw::c_int,
        end: ::std::os::raw::c_int,
        chr: ::std::os::raw::c_char,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_ichr(
        str_: *mut ::std::os::raw::c_char,
        chr: ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_ccmp(
        dst: *const ::std::os::raw::c_char,
        orig: *const ::std::os::raw::c_char,
        ch: ::std::os::raw::c_int,
    ) -> bool;
}
extern "C" {
    pub fn r_str_cmp_list(
        list: *const ::std::os::raw::c_char,
        item: *const ::std::os::raw::c_char,
        sep: ::std::os::raw::c_char,
    ) -> bool;
}
extern "C" {
    pub fn r_str_cmp(
        dst: *const ::std::os::raw::c_char,
        orig: *const ::std::os::raw::c_char,
        len: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_str_casecmp(
        dst: *const ::std::os::raw::c_char,
        orig: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_str_ncasecmp(
        dst: *const ::std::os::raw::c_char,
        orig: *const ::std::os::raw::c_char,
        n: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_str_ccpy(
        dst: *mut ::std::os::raw::c_char,
        orig: *mut ::std::os::raw::c_char,
        ch: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_str_get(str_: *const ::std::os::raw::c_char) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_get_fail(
        str_: *const ::std::os::raw::c_char,
        failstr: *const ::std::os::raw::c_char,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_getf(str_: *const ::std::os::raw::c_char) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_ndup(
        ptr: *const ::std::os::raw::c_char,
        len: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_dup(
        ptr: *mut ::std::os::raw::c_char,
        string: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_inject(
        begin: *mut ::std::os::raw::c_char,
        end: *mut ::std::os::raw::c_char,
        str_: *mut ::std::os::raw::c_char,
        maxlen: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_str_delta(
        p: *mut ::std::os::raw::c_char,
        a: ::std::os::raw::c_char,
        b: ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_str_filter(str_: *mut ::std::os::raw::c_char, len: ::std::os::raw::c_int);
}
extern "C" {
    pub fn r_str_tok(
        str1: *const ::std::os::raw::c_char,
        b: ::std::os::raw::c_char,
        len: size_t,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_mb_to_wc(buf: *const ::std::os::raw::c_char) -> *mut wchar_t;
}
extern "C" {
    pub fn r_str_wc_to_mb(buf: *const wchar_t) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_mb_to_wc_l(
        buf: *const ::std::os::raw::c_char,
        len: ::std::os::raw::c_int,
    ) -> *mut wchar_t;
}
extern "C" {
    pub fn r_str_wc_to_mb_l(
        buf: *const wchar_t,
        len: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_str_xy(
        s: *const ::std::os::raw::c_char,
        word: *const ::std::os::raw::c_char,
        prev: *const ::std::os::raw::c_char,
        x: *mut ::std::os::raw::c_int,
        y: *mut ::std::os::raw::c_int,
    ) -> *const ::std::os::raw::c_char;
}
pub type str_operation =
    ::std::option::Option<unsafe extern "C" fn(c: *mut ::std::os::raw::c_char)>;
extern "C" {
    pub fn r_str_do_until_token(
        op: str_operation,
        str_: *mut ::std::os::raw::c_char,
        tok: ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_str_reverse(str_: *mut ::std::os::raw::c_char);
}
extern "C" {
    pub fn r_str_re_match(
        str_: *const ::std::os::raw::c_char,
        reg: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_str_re_replace(
        str_: *const ::std::os::raw::c_char,
        reg: *const ::std::os::raw::c_char,
        sub: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_str_path_unescape(path: *mut ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_str_path_escape(path: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_unescape(buf: *mut ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_str_sanitize_r2(buf: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_escape(buf: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_escape_sh(buf: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_escape_sql(buf: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_escape_dot(buf: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_escape_latin1(
        buf: *const ::std::os::raw::c_char,
        show_asciidot: bool,
        esc_bslash: bool,
        colors: bool,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_escape_utf8(
        buf: *const ::std::os::raw::c_char,
        show_asciidot: bool,
        esc_bslash: bool,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_escape_utf8_keep_printable(
        buf: *const ::std::os::raw::c_char,
        show_asciidot: bool,
        esc_bslash: bool,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_escape_utf16le(
        buf: *const ::std::os::raw::c_char,
        buf_size: ::std::os::raw::c_int,
        show_asciidot: bool,
        esc_bslash: bool,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_escape_utf32le(
        buf: *const ::std::os::raw::c_char,
        buf_size: ::std::os::raw::c_int,
        show_asciidot: bool,
        esc_bslash: bool,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_escape_utf16be(
        buf: *const ::std::os::raw::c_char,
        buf_size: ::std::os::raw::c_int,
        show_asciidot: bool,
        esc_bslash: bool,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_escape_utf32be(
        buf: *const ::std::os::raw::c_char,
        buf_size: ::std::os::raw::c_int,
        show_asciidot: bool,
        esc_bslash: bool,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_byte_escape(
        p: *const ::std::os::raw::c_char,
        dst: *mut *mut ::std::os::raw::c_char,
        dot_nl: ::std::os::raw::c_int,
        default_dot: bool,
        esc_bslash: bool,
    );
}
extern "C" {
    pub fn r_str_format_msvc_argv(
        argc: size_t,
        argv: *mut *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_uri_decode(buf: *mut ::std::os::raw::c_char);
}
extern "C" {
    pub fn r_str_uri_encode(buf: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_utf16_decode(
        s: *const ::std::os::raw::c_uchar,
        len: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_utf16_to_utf8(
        dst: *mut ::std::os::raw::c_uchar,
        len_dst: ::std::os::raw::c_int,
        src: *const ::std::os::raw::c_uchar,
        len_src: ::std::os::raw::c_int,
        little_endian: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_str_utf16_encode(
        s: *const ::std::os::raw::c_char,
        len: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_escape_utf8_for_json(
        s: *const ::std::os::raw::c_char,
        len: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_escape_utf8_for_json_strip(
        buf: *const ::std::os::raw::c_char,
        buf_size: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_encoded_json(
        buf: *const ::std::os::raw::c_char,
        buf_size: ::std::os::raw::c_int,
        encoding: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_home(str_: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_r2_prefix(str_: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_nlen(s: *const ::std::os::raw::c_char, n: ::std::os::raw::c_int) -> size_t;
}
extern "C" {
    pub fn r_str_nlen_w(s: *const ::std::os::raw::c_char, n: ::std::os::raw::c_int) -> size_t;
}
extern "C" {
    pub fn r_wstr_clen(s: *const ::std::os::raw::c_char) -> size_t;
}
extern "C" {
    pub fn r_str_prepend(
        ptr: *mut ::std::os::raw::c_char,
        string: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_prefix_all(
        s: *const ::std::os::raw::c_char,
        pfx: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_append(
        ptr: *mut ::std::os::raw::c_char,
        string: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_append_owned(
        ptr: *mut ::std::os::raw::c_char,
        string: *mut ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_appendf(
        ptr: *mut ::std::os::raw::c_char,
        fmt: *const ::std::os::raw::c_char,
        ...
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_appendch(
        x: *mut ::std::os::raw::c_char,
        y: ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_case(str_: *mut ::std::os::raw::c_char, up: bool);
}
extern "C" {
    pub fn r_str_trim_path(s: *mut ::std::os::raw::c_char);
}
extern "C" {
    pub fn r_str_contains_macro(
        input_value: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_uchar;
}
extern "C" {
    pub fn r_str_truncate_cmd(string: *mut ::std::os::raw::c_char);
}
extern "C" {
    pub fn r_str_replace_thunked(
        str_: *mut ::std::os::raw::c_char,
        clean: *mut ::std::os::raw::c_char,
        thunk: *mut ::std::os::raw::c_int,
        clen: ::std::os::raw::c_int,
        key: *const ::std::os::raw::c_char,
        val: *const ::std::os::raw::c_char,
        g: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_glob(
        str_: *const ::std::os::raw::c_char,
        glob: *const ::std::os::raw::c_char,
    ) -> bool;
}
extern "C" {
    pub fn r_str_binstr2bin(
        str_: *const ::std::os::raw::c_char,
        out: *mut ::std::os::raw::c_uchar,
        outlen: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_str_between(
        str_: *const ::std::os::raw::c_char,
        prefix: *const ::std::os::raw::c_char,
        suffix: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_startswith(
        str_: *const ::std::os::raw::c_char,
        needle: *const ::std::os::raw::c_char,
    ) -> bool;
}
extern "C" {
    pub fn r_str_endswith(
        str_: *const ::std::os::raw::c_char,
        needle: *const ::std::os::raw::c_char,
    ) -> bool;
}
extern "C" {
    pub fn r_str_isnumber(str_: *const ::std::os::raw::c_char) -> bool;
}
extern "C" {
    pub fn r_str_last(
        in_: *const ::std::os::raw::c_char,
        ch: *const ::std::os::raw::c_char,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_highlight(
        str_: *mut ::std::os::raw::c_char,
        word: *const ::std::os::raw::c_char,
        color: *const ::std::os::raw::c_char,
        color_reset: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_qrcode_gen(
        text: *const ::std::os::raw::c_uchar,
        len: ::std::os::raw::c_int,
        utf8: bool,
        inverted: bool,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_from_ut64(val: ::std::os::raw::c_ulonglong) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_stripLine(str_: *mut ::std::os::raw::c_char, key: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn r_str_list_join(
        str_: *mut RList,
        sep: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_array_join(
        a: *mut *const ::std::os::raw::c_char,
        n: size_t,
        sep: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_sep(
        base: *const ::std::os::raw::c_char,
        sep: *const ::std::os::raw::c_char,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_rsep(
        base: *const ::std::os::raw::c_char,
        p: *const ::std::os::raw::c_char,
        sep: *const ::std::os::raw::c_char,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_donut(size: ::std::os::raw::c_int) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_version(program: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_str_constpool_t {
    pub ht: *mut HtPP,
}
#[test]
fn bindgen_test_layout_r_str_constpool_t() {
    assert_eq!(
        ::std::mem::size_of::<r_str_constpool_t>(),
        8usize,
        concat!("Size of: ", stringify!(r_str_constpool_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_str_constpool_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_str_constpool_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_str_constpool_t>())).ht as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_str_constpool_t),
            "::",
            stringify!(ht)
        )
    );
}
pub type RStrConstPool = r_str_constpool_t;
extern "C" {
    pub fn r_str_constpool_init(pool: *mut RStrConstPool) -> bool;
}
extern "C" {
    pub fn r_str_constpool_fini(pool: *mut RStrConstPool);
}
extern "C" {
    pub fn r_str_constpool_get(
        pool: *mut RStrConstPool,
        str_: *const ::std::os::raw::c_char,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn __error() -> *mut ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RSysInfo {
    pub sysname: *mut ::std::os::raw::c_char,
    pub nodename: *mut ::std::os::raw::c_char,
    pub release: *mut ::std::os::raw::c_char,
    pub version: *mut ::std::os::raw::c_char,
    pub machine: *mut ::std::os::raw::c_char,
}
#[test]
fn bindgen_test_layout_RSysInfo() {
    assert_eq!(
        ::std::mem::size_of::<RSysInfo>(),
        40usize,
        concat!("Size of: ", stringify!(RSysInfo))
    );
    assert_eq!(
        ::std::mem::align_of::<RSysInfo>(),
        8usize,
        concat!("Alignment of ", stringify!(RSysInfo))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RSysInfo>())).sysname as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(RSysInfo),
            "::",
            stringify!(sysname)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RSysInfo>())).nodename as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(RSysInfo),
            "::",
            stringify!(nodename)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RSysInfo>())).release as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(RSysInfo),
            "::",
            stringify!(release)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RSysInfo>())).version as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(RSysInfo),
            "::",
            stringify!(version)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RSysInfo>())).machine as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(RSysInfo),
            "::",
            stringify!(machine)
        )
    );
}
extern "C" {
    pub fn r_sys_info() -> *mut RSysInfo;
}
extern "C" {
    pub fn r_sys_info_free(si: *mut RSysInfo);
}
extern "C" {
    pub fn r_sys_sigaction(
        sig: *mut ::std::os::raw::c_int,
        handler: ::std::option::Option<unsafe extern "C" fn(arg1: ::std::os::raw::c_int)>,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_sys_signal(
        sig: ::std::os::raw::c_int,
        handler: ::std::option::Option<unsafe extern "C" fn(arg1: ::std::os::raw::c_int)>,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_sys_env_init();
}
extern "C" {
    pub fn r_sys_get_environ() -> *mut *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_sys_set_environ(e: *mut *mut ::std::os::raw::c_char);
}
extern "C" {
    pub fn r_sys_fork() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_sys_exit(status: ::std::os::raw::c_int, nocleanup: bool);
}
extern "C" {
    pub fn r_sys_stop() -> bool;
}
extern "C" {
    pub fn r_sys_pid_to_path(pid: ::std::os::raw::c_int) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_sys_run(
        buf: *const ::std::os::raw::c_uchar,
        len: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_sys_run_rop(
        buf: *const ::std::os::raw::c_uchar,
        len: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_sys_getpid() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_sys_crash_handler(cmd: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_sys_arch_str(arch: ::std::os::raw::c_int) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_sys_arch_id(arch: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_sys_arch_match(
        archstr: *const ::std::os::raw::c_char,
        arch: *const ::std::os::raw::c_char,
    ) -> bool;
}
extern "C" {
    pub fn r_sys_dir(path: *const ::std::os::raw::c_char) -> *mut RList;
}
extern "C" {
    pub fn r_sys_perror_str(fun: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn r_sys_prefix(pfx: *const ::std::os::raw::c_char) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_sys_mkdir(dir: *const ::std::os::raw::c_char) -> bool;
}
extern "C" {
    pub fn r_sys_mkdirp(dir: *const ::std::os::raw::c_char) -> bool;
}
extern "C" {
    pub fn r_sys_sleep(secs: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_sys_usleep(usecs: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_sys_getenv(key: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_sys_getenv_asbool(key: *const ::std::os::raw::c_char) -> bool;
}
extern "C" {
    pub fn r_sys_setenv(
        key: *const ::std::os::raw::c_char,
        value: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_sys_clearenv() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_sys_whoami() -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_sys_uid() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_sys_getdir() -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_sys_chdir(s: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_sys_aslr(val: ::std::os::raw::c_int) -> bool;
}
extern "C" {
    pub fn r_sys_thp_mode() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_sys_cmd_str_full(
        cmd: *const ::std::os::raw::c_char,
        input: *const ::std::os::raw::c_char,
        ilen: ::std::os::raw::c_int,
        output: *mut *mut ::std::os::raw::c_char,
        len: *mut ::std::os::raw::c_int,
        sterr: *mut *mut ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_sys_truncate(
        file: *const ::std::os::raw::c_char,
        sz: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_sys_cmd(cmd: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_sys_cmdbg(cmd: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_sys_cmdf(fmt: *const ::std::os::raw::c_char, ...) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_sys_cmd_str(
        cmd: *const ::std::os::raw::c_char,
        input: *const ::std::os::raw::c_char,
        len: *mut ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_sys_cmd_strf(cmd: *const ::std::os::raw::c_char, ...) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_sys_backtrace();
}
extern "C" {
    pub fn r_sys_tts(txt: *const ::std::os::raw::c_char, bg: bool) -> bool;
}
extern "C" {
    pub fn r_syscmd_ls(input: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_syscmd_cat(file: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_syscmd_mkdir(dir: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_syscmd_mv(input: *const ::std::os::raw::c_char) -> bool;
}
extern "C" {
    pub fn r_syscmd_uniq(file: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_syscmd_head(
        file: *const ::std::os::raw::c_char,
        count: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_syscmd_tail(
        file: *const ::std::os::raw::c_char,
        count: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_syscmd_join(
        file1: *const ::std::os::raw::c_char,
        file2: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_syscmd_sort(file: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_sys_unxz(
        data: *const ::std::os::raw::c_uchar,
        len: size_t,
        olen: *mut size_t,
    ) -> *mut ::std::os::raw::c_uchar;
}
extern "C" {
    pub fn r_w32_init() -> bool;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_mmap_t {
    pub buf: *mut ::std::os::raw::c_uchar,
    pub base: ::std::os::raw::c_ulonglong,
    pub len: ::std::os::raw::c_int,
    pub fd: ::std::os::raw::c_int,
    pub rw: ::std::os::raw::c_int,
    pub filename: *mut ::std::os::raw::c_char,
}
#[test]
fn bindgen_test_layout_r_mmap_t() {
    assert_eq!(
        ::std::mem::size_of::<r_mmap_t>(),
        40usize,
        concat!("Size of: ", stringify!(r_mmap_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_mmap_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_mmap_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_mmap_t>())).buf as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_mmap_t),
            "::",
            stringify!(buf)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_mmap_t>())).base as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_mmap_t),
            "::",
            stringify!(base)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_mmap_t>())).len as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(r_mmap_t),
            "::",
            stringify!(len)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_mmap_t>())).fd as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(r_mmap_t),
            "::",
            stringify!(fd)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_mmap_t>())).rw as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(r_mmap_t),
            "::",
            stringify!(rw)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_mmap_t>())).filename as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(r_mmap_t),
            "::",
            stringify!(filename)
        )
    );
}
pub type RMmap = r_mmap_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_mem_pool_t {
    pub nodes: *mut *mut ::std::os::raw::c_uchar,
    pub ncount: ::std::os::raw::c_int,
    pub npool: ::std::os::raw::c_int,
    pub nodesize: ::std::os::raw::c_int,
    pub poolsize: ::std::os::raw::c_int,
    pub poolcount: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_r_mem_pool_t() {
    assert_eq!(
        ::std::mem::size_of::<r_mem_pool_t>(),
        32usize,
        concat!("Size of: ", stringify!(r_mem_pool_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_mem_pool_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_mem_pool_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_mem_pool_t>())).nodes as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_mem_pool_t),
            "::",
            stringify!(nodes)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_mem_pool_t>())).ncount as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_mem_pool_t),
            "::",
            stringify!(ncount)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_mem_pool_t>())).npool as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(r_mem_pool_t),
            "::",
            stringify!(npool)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_mem_pool_t>())).nodesize as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(r_mem_pool_t),
            "::",
            stringify!(nodesize)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_mem_pool_t>())).poolsize as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(r_mem_pool_t),
            "::",
            stringify!(poolsize)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_mem_pool_t>())).poolcount as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(r_mem_pool_t),
            "::",
            stringify!(poolcount)
        )
    );
}
pub type RMemoryPool = r_mem_pool_t;
extern "C" {
    pub fn r_mem_get_num(
        b: *const ::std::os::raw::c_uchar,
        size: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_ulonglong;
}
extern "C" {
    pub fn r_mem_pool_deinit(pool: *mut RMemoryPool) -> *mut RMemoryPool;
}
extern "C" {
    pub fn r_mem_pool_new(
        nodesize: ::std::os::raw::c_int,
        poolsize: ::std::os::raw::c_int,
        poolcount: ::std::os::raw::c_int,
    ) -> *mut RMemoryPool;
}
extern "C" {
    pub fn r_mem_pool_free(pool: *mut RMemoryPool) -> *mut RMemoryPool;
}
extern "C" {
    pub fn r_mem_pool_alloc(pool: *mut RMemoryPool) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn r_mem_dup(
        s: *const ::std::os::raw::c_void,
        l: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn r_mem_alloc(sz: ::std::os::raw::c_int) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn r_mem_free(arg1: *mut ::std::os::raw::c_void);
}
extern "C" {
    pub fn r_mem_memzero(arg1: *mut ::std::os::raw::c_void, arg2: size_t);
}
extern "C" {
    pub fn r_mem_reverse(b: *mut ::std::os::raw::c_uchar, l: ::std::os::raw::c_int);
}
extern "C" {
    pub fn r_mem_protect(
        ptr: *mut ::std::os::raw::c_void,
        size: ::std::os::raw::c_int,
        prot: *const ::std::os::raw::c_char,
    ) -> bool;
}
extern "C" {
    pub fn r_mem_set_num(
        dest: *mut ::std::os::raw::c_uchar,
        dest_size: ::std::os::raw::c_int,
        num: ::std::os::raw::c_ulonglong,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_mem_eq(
        a: *mut ::std::os::raw::c_uchar,
        b: *mut ::std::os::raw::c_uchar,
        len: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_mem_copybits(
        dst: *mut ::std::os::raw::c_uchar,
        src: *const ::std::os::raw::c_uchar,
        bits: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn r_mem_copybits_delta(
        dst: *mut ::std::os::raw::c_uchar,
        doff: ::std::os::raw::c_int,
        src: *const ::std::os::raw::c_uchar,
        soff: ::std::os::raw::c_int,
        bits: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn r_mem_copyloop(
        dest: *mut ::std::os::raw::c_uchar,
        orig: *const ::std::os::raw::c_uchar,
        dsize: ::std::os::raw::c_int,
        osize: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn r_mem_swaporcopy(
        dest: *mut ::std::os::raw::c_uchar,
        src: *const ::std::os::raw::c_uchar,
        len: ::std::os::raw::c_int,
        big_endian: bool,
    );
}
extern "C" {
    pub fn r_mem_swapendian(
        dest: *mut ::std::os::raw::c_uchar,
        orig: *const ::std::os::raw::c_uchar,
        size: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn r_mem_swap(buf: *mut ::std::os::raw::c_uchar, buf_len: size_t);
}
extern "C" {
    pub fn r_mem_cmp_mask(
        dest: *const ::std::os::raw::c_uchar,
        orig: *const ::std::os::raw::c_uchar,
        mask: *const ::std::os::raw::c_uchar,
        len: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_mem_mem(
        haystack: *const ::std::os::raw::c_uchar,
        hlen: ::std::os::raw::c_int,
        needle: *const ::std::os::raw::c_uchar,
        nlen: ::std::os::raw::c_int,
    ) -> *const ::std::os::raw::c_uchar;
}
extern "C" {
    pub fn r_mem_mem_aligned(
        haystack: *const ::std::os::raw::c_uchar,
        hlen: ::std::os::raw::c_int,
        needle: *const ::std::os::raw::c_uchar,
        nlen: ::std::os::raw::c_int,
        align: ::std::os::raw::c_int,
    ) -> *const ::std::os::raw::c_uchar;
}
extern "C" {
    pub fn r_mem_count(addr: *mut *const ::std::os::raw::c_uchar) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_mem_is_printable(a: *const ::std::os::raw::c_uchar, la: ::std::os::raw::c_int)
        -> bool;
}
extern "C" {
    pub fn r_mem_is_zero(b: *const ::std::os::raw::c_uchar, l: ::std::os::raw::c_int) -> bool;
}
extern "C" {
    pub fn r_mem_mmap_resize(
        m: *mut RMmap,
        newsize: ::std::os::raw::c_ulonglong,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn r_file_is_abspath(file: *const ::std::os::raw::c_char) -> bool;
}
extern "C" {
    pub fn r_file_is_c(file: *const ::std::os::raw::c_char) -> bool;
}
extern "C" {
    pub fn r_file_is_directory(str_: *const ::std::os::raw::c_char) -> bool;
}
extern "C" {
    pub fn r_file_is_regular(str_: *const ::std::os::raw::c_char) -> bool;
}
extern "C" {
    pub fn r_file_truncate(
        filename: *const ::std::os::raw::c_char,
        newsize: ::std::os::raw::c_ulonglong,
    ) -> bool;
}
extern "C" {
    pub fn r_file_new(root: *const ::std::os::raw::c_char, ...) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_file_size(str_: *const ::std::os::raw::c_char) -> ::std::os::raw::c_ulonglong;
}
extern "C" {
    pub fn r_file_root(
        root: *const ::std::os::raw::c_char,
        path: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_file_mmap(
        file: *const ::std::os::raw::c_char,
        rw: bool,
        base: ::std::os::raw::c_ulonglong,
    ) -> *mut RMmap;
}
extern "C" {
    pub fn r_file_mmap_read(
        file: *const ::std::os::raw::c_char,
        addr: ::std::os::raw::c_ulonglong,
        buf: *mut ::std::os::raw::c_uchar,
        len: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_file_mmap_write(
        file: *const ::std::os::raw::c_char,
        addr: ::std::os::raw::c_ulonglong,
        buf: *const ::std::os::raw::c_uchar,
        len: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_file_mmap_free(m: *mut RMmap);
}
extern "C" {
    pub fn r_file_chmod(
        file: *const ::std::os::raw::c_char,
        mod_: *const ::std::os::raw::c_char,
        recursive: ::std::os::raw::c_int,
    ) -> bool;
}
extern "C" {
    pub fn r_file_temp(prefix: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_file_path(bin: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_file_binsh() -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_file_basename(path: *const ::std::os::raw::c_char) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_file_dirname(path: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_file_abspath_rel(
        cwd: *const ::std::os::raw::c_char,
        file: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_file_abspath(file: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_inflate(
        src: *const ::std::os::raw::c_uchar,
        srcLen: ::std::os::raw::c_int,
        srcConsumed: *mut ::std::os::raw::c_int,
        dstLen: *mut ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_uchar;
}
extern "C" {
    pub fn r_inflate_raw(
        src: *const ::std::os::raw::c_uchar,
        srcLen: ::std::os::raw::c_int,
        srcConsumed: *mut ::std::os::raw::c_int,
        dstLen: *mut ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_uchar;
}
extern "C" {
    pub fn r_file_gzslurp(
        str_: *const ::std::os::raw::c_char,
        outlen: *mut ::std::os::raw::c_int,
        origonfail: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_uchar;
}
extern "C" {
    pub fn r_stdin_slurp(sz: *mut ::std::os::raw::c_int) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_file_slurp(
        str_: *const ::std::os::raw::c_char,
        usz: *mut size_t,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_file_slurp_range(
        str_: *const ::std::os::raw::c_char,
        off: ::std::os::raw::c_ulonglong,
        sz: ::std::os::raw::c_int,
        osz: *mut ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_file_slurp_random_line(
        file: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_file_slurp_random_line_count(
        file: *const ::std::os::raw::c_char,
        linecount: *mut ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_file_slurp_hexpairs(
        str_: *const ::std::os::raw::c_char,
        usz: *mut ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_uchar;
}
extern "C" {
    pub fn r_file_dump(
        file: *const ::std::os::raw::c_char,
        buf: *const ::std::os::raw::c_uchar,
        len: ::std::os::raw::c_int,
        append: bool,
    ) -> bool;
}
extern "C" {
    pub fn r_file_touch(file: *const ::std::os::raw::c_char) -> bool;
}
extern "C" {
    pub fn r_file_hexdump(
        file: *const ::std::os::raw::c_char,
        buf: *const ::std::os::raw::c_uchar,
        len: ::std::os::raw::c_int,
        append: ::std::os::raw::c_int,
    ) -> bool;
}
extern "C" {
    pub fn r_file_rm(file: *const ::std::os::raw::c_char) -> bool;
}
extern "C" {
    pub fn r_file_exists(str_: *const ::std::os::raw::c_char) -> bool;
}
extern "C" {
    pub fn r_file_fexists(fmt: *const ::std::os::raw::c_char, ...) -> bool;
}
extern "C" {
    pub fn r_file_slurp_line(
        file: *const ::std::os::raw::c_char,
        line: ::std::os::raw::c_int,
        context: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_file_slurp_lines(
        file: *const ::std::os::raw::c_char,
        line: ::std::os::raw::c_int,
        count: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_file_slurp_lines_from_bottom(
        file: *const ::std::os::raw::c_char,
        line: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_file_mkstemp(
        prefix: *const ::std::os::raw::c_char,
        oname: *mut *mut ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_file_tmpdir() -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_file_readlink(path: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_file_copy(
        src: *const ::std::os::raw::c_char,
        dst: *const ::std::os::raw::c_char,
    ) -> bool;
}
extern "C" {
    pub fn r_file_move(
        src: *const ::std::os::raw::c_char,
        dst: *const ::std::os::raw::c_char,
    ) -> bool;
}
extern "C" {
    pub fn r_file_glob(
        globbed_path: *const ::std::os::raw::c_char,
        maxdepth: ::std::os::raw::c_int,
    ) -> *mut RList;
}
extern "C" {
    pub fn r_file_mmap_arch(
        map: *mut RMmap,
        filename: *const ::std::os::raw::c_char,
        fd: ::std::os::raw::c_int,
    ) -> *mut RMmap;
}
extern "C" {
    pub fn r_file_lsrf(dir: *const ::std::os::raw::c_char) -> *mut RList;
}
extern "C" {
    pub fn r_assert_log(level: RLogLevel, fmt: *const ::std::os::raw::c_char, ...);
}
pub type RPVectorComparator = ::std::option::Option<
    unsafe extern "C" fn(
        a: *const ::std::os::raw::c_void,
        b: *const ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int,
>;
pub type RVectorFree = ::std::option::Option<
    unsafe extern "C" fn(e: *mut ::std::os::raw::c_void, user: *mut ::std::os::raw::c_void),
>;
pub type RPVectorFree = ::std::option::Option<unsafe extern "C" fn(e: *mut ::std::os::raw::c_void)>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_vector_t {
    pub a: *mut ::std::os::raw::c_void,
    pub len: size_t,
    pub capacity: size_t,
    pub elem_size: size_t,
    pub free: RVectorFree,
    pub free_user: *mut ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout_r_vector_t() {
    assert_eq!(
        ::std::mem::size_of::<r_vector_t>(),
        48usize,
        concat!("Size of: ", stringify!(r_vector_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_vector_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_vector_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_vector_t>())).a as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_vector_t),
            "::",
            stringify!(a)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_vector_t>())).len as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_vector_t),
            "::",
            stringify!(len)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_vector_t>())).capacity as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(r_vector_t),
            "::",
            stringify!(capacity)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_vector_t>())).elem_size as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(r_vector_t),
            "::",
            stringify!(elem_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_vector_t>())).free as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(r_vector_t),
            "::",
            stringify!(free)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_vector_t>())).free_user as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(r_vector_t),
            "::",
            stringify!(free_user)
        )
    );
}
pub type RVector = r_vector_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_pvector_t {
    pub v: RVector,
}
#[test]
fn bindgen_test_layout_r_pvector_t() {
    assert_eq!(
        ::std::mem::size_of::<r_pvector_t>(),
        48usize,
        concat!("Size of: ", stringify!(r_pvector_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_pvector_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_pvector_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_pvector_t>())).v as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_pvector_t),
            "::",
            stringify!(v)
        )
    );
}
pub type RPVector = r_pvector_t;
extern "C" {
    pub fn r_vector_init(
        vec: *mut RVector,
        elem_size: size_t,
        free: RVectorFree,
        free_user: *mut ::std::os::raw::c_void,
    );
}
extern "C" {
    pub fn r_vector_new(
        elem_size: size_t,
        free: RVectorFree,
        free_user: *mut ::std::os::raw::c_void,
    ) -> *mut RVector;
}
extern "C" {
    pub fn r_vector_fini(vec: *mut RVector);
}
extern "C" {
    pub fn r_vector_free(vec: *mut RVector);
}
extern "C" {
    pub fn r_vector_clone(vec: *mut RVector) -> *mut RVector;
}
extern "C" {
    pub fn r_vector_clear(vec: *mut RVector);
}
extern "C" {
    pub fn r_vector_assign(
        vec: *mut RVector,
        p: *mut ::std::os::raw::c_void,
        elem: *mut ::std::os::raw::c_void,
    );
}
extern "C" {
    pub fn r_vector_assign_at(
        vec: *mut RVector,
        index: size_t,
        elem: *mut ::std::os::raw::c_void,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn r_vector_remove_at(vec: *mut RVector, index: size_t, into: *mut ::std::os::raw::c_void);
}
extern "C" {
    pub fn r_vector_insert(
        vec: *mut RVector,
        index: size_t,
        x: *mut ::std::os::raw::c_void,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn r_vector_insert_range(
        vec: *mut RVector,
        index: size_t,
        first: *mut ::std::os::raw::c_void,
        count: size_t,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn r_vector_pop(vec: *mut RVector, into: *mut ::std::os::raw::c_void);
}
extern "C" {
    pub fn r_vector_pop_front(vec: *mut RVector, into: *mut ::std::os::raw::c_void);
}
extern "C" {
    pub fn r_vector_push(
        vec: *mut RVector,
        x: *mut ::std::os::raw::c_void,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn r_vector_push_front(
        vec: *mut RVector,
        x: *mut ::std::os::raw::c_void,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn r_vector_reserve(vec: *mut RVector, capacity: size_t) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn r_vector_shrink(vec: *mut RVector) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn r_vector_flush(vec: *mut RVector) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn r_pvector_init(vec: *mut RPVector, free: RPVectorFree);
}
extern "C" {
    pub fn r_pvector_fini(vec: *mut RPVector);
}
extern "C" {
    pub fn r_pvector_new(free: RPVectorFree) -> *mut RPVector;
}
extern "C" {
    pub fn r_pvector_new_with_len(free: RPVectorFree, length: size_t) -> *mut RPVector;
}
extern "C" {
    pub fn r_pvector_clear(vec: *mut RPVector);
}
extern "C" {
    pub fn r_pvector_free(vec: *mut RPVector);
}
extern "C" {
    pub fn r_pvector_contains(
        vec: *mut RPVector,
        x: *mut ::std::os::raw::c_void,
    ) -> *mut *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn r_pvector_remove_at(vec: *mut RPVector, index: size_t) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn r_pvector_remove_data(vec: *mut RPVector, x: *mut ::std::os::raw::c_void);
}
extern "C" {
    pub fn r_pvector_pop(vec: *mut RPVector) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn r_pvector_pop_front(vec: *mut RPVector) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn r_pvector_sort(vec: *mut RPVector, cmp: RPVectorComparator);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ht_up_kv {
    pub key: ::std::os::raw::c_ulonglong,
    pub value: *mut ::std::os::raw::c_void,
    pub key_len: ::std::os::raw::c_uint,
    pub value_len: ::std::os::raw::c_uint,
}
#[test]
fn bindgen_test_layout_ht_up_kv() {
    assert_eq!(
        ::std::mem::size_of::<ht_up_kv>(),
        24usize,
        concat!("Size of: ", stringify!(ht_up_kv))
    );
    assert_eq!(
        ::std::mem::align_of::<ht_up_kv>(),
        8usize,
        concat!("Alignment of ", stringify!(ht_up_kv))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ht_up_kv>())).key as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(ht_up_kv),
            "::",
            stringify!(key)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ht_up_kv>())).value as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(ht_up_kv),
            "::",
            stringify!(value)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ht_up_kv>())).key_len as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(ht_up_kv),
            "::",
            stringify!(key_len)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ht_up_kv>())).value_len as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(ht_up_kv),
            "::",
            stringify!(value_len)
        )
    );
}
pub type HtUPKv = ht_up_kv;
pub type HtUPKvFreeFunc = ::std::option::Option<unsafe extern "C" fn(arg1: *mut HtUPKv)>;
pub type HtUPDupKey = ::std::option::Option<
    unsafe extern "C" fn(arg1: ::std::os::raw::c_ulonglong) -> ::std::os::raw::c_ulonglong,
>;
pub type HtUPDupValue = ::std::option::Option<
    unsafe extern "C" fn(arg1: *const ::std::os::raw::c_void) -> *mut ::std::os::raw::c_void,
>;
pub type HtUPCalcSizeK = ::std::option::Option<
    unsafe extern "C" fn(arg1: ::std::os::raw::c_ulonglong) -> ::std::os::raw::c_uint,
>;
pub type HtUPCalcSizeV = ::std::option::Option<
    unsafe extern "C" fn(arg1: *const ::std::os::raw::c_void) -> ::std::os::raw::c_uint,
>;
pub type HtUPHashFunction = ::std::option::Option<
    unsafe extern "C" fn(arg1: ::std::os::raw::c_ulonglong) -> ::std::os::raw::c_uint,
>;
pub type HtUPListComparator = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: ::std::os::raw::c_ulonglong,
        arg2: ::std::os::raw::c_ulonglong,
    ) -> ::std::os::raw::c_int,
>;
pub type HtUPForeachCallback = ::std::option::Option<
    unsafe extern "C" fn(
        user: *mut ::std::os::raw::c_void,
        arg1: ::std::os::raw::c_ulonglong,
        arg2: *const ::std::os::raw::c_void,
    ) -> bool,
>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ht_up_bucket_t {
    pub arr: *mut HtUPKv,
    pub count: ::std::os::raw::c_uint,
}
#[test]
fn bindgen_test_layout_ht_up_bucket_t() {
    assert_eq!(
        ::std::mem::size_of::<ht_up_bucket_t>(),
        16usize,
        concat!("Size of: ", stringify!(ht_up_bucket_t))
    );
    assert_eq!(
        ::std::mem::align_of::<ht_up_bucket_t>(),
        8usize,
        concat!("Alignment of ", stringify!(ht_up_bucket_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ht_up_bucket_t>())).arr as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(ht_up_bucket_t),
            "::",
            stringify!(arr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ht_up_bucket_t>())).count as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(ht_up_bucket_t),
            "::",
            stringify!(count)
        )
    );
}
pub type HtUPBucket = ht_up_bucket_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ht_up_options_t {
    pub cmp: HtUPListComparator,
    pub hashfn: HtUPHashFunction,
    pub dupkey: HtUPDupKey,
    pub dupvalue: HtUPDupValue,
    pub calcsizeK: HtUPCalcSizeK,
    pub calcsizeV: HtUPCalcSizeV,
    pub freefn: HtUPKvFreeFunc,
    pub elem_size: size_t,
}
#[test]
fn bindgen_test_layout_ht_up_options_t() {
    assert_eq!(
        ::std::mem::size_of::<ht_up_options_t>(),
        64usize,
        concat!("Size of: ", stringify!(ht_up_options_t))
    );
    assert_eq!(
        ::std::mem::align_of::<ht_up_options_t>(),
        8usize,
        concat!("Alignment of ", stringify!(ht_up_options_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ht_up_options_t>())).cmp as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(ht_up_options_t),
            "::",
            stringify!(cmp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ht_up_options_t>())).hashfn as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(ht_up_options_t),
            "::",
            stringify!(hashfn)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ht_up_options_t>())).dupkey as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(ht_up_options_t),
            "::",
            stringify!(dupkey)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ht_up_options_t>())).dupvalue as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(ht_up_options_t),
            "::",
            stringify!(dupvalue)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ht_up_options_t>())).calcsizeK as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(ht_up_options_t),
            "::",
            stringify!(calcsizeK)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ht_up_options_t>())).calcsizeV as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(ht_up_options_t),
            "::",
            stringify!(calcsizeV)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ht_up_options_t>())).freefn as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(ht_up_options_t),
            "::",
            stringify!(freefn)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ht_up_options_t>())).elem_size as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(ht_up_options_t),
            "::",
            stringify!(elem_size)
        )
    );
}
pub type HtUPOptions = ht_up_options_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ht_up_t {
    pub size: ::std::os::raw::c_uint,
    pub count: ::std::os::raw::c_uint,
    pub table: *mut HtUPBucket,
    pub prime_idx: ::std::os::raw::c_uint,
    pub opt: HtUPOptions,
}
#[test]
fn bindgen_test_layout_ht_up_t() {
    assert_eq!(
        ::std::mem::size_of::<ht_up_t>(),
        88usize,
        concat!("Size of: ", stringify!(ht_up_t))
    );
    assert_eq!(
        ::std::mem::align_of::<ht_up_t>(),
        8usize,
        concat!("Alignment of ", stringify!(ht_up_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ht_up_t>())).size as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(ht_up_t),
            "::",
            stringify!(size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ht_up_t>())).count as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(ht_up_t),
            "::",
            stringify!(count)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ht_up_t>())).table as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(ht_up_t),
            "::",
            stringify!(table)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ht_up_t>())).prime_idx as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(ht_up_t),
            "::",
            stringify!(prime_idx)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ht_up_t>())).opt as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(ht_up_t),
            "::",
            stringify!(opt)
        )
    );
}
pub type HtUP = ht_up_t;
extern "C" {
    pub fn ht_up_new_opt(opt: *mut HtUPOptions) -> *mut HtUP;
}
extern "C" {
    pub fn ht_up_free(ht: *mut HtUP);
}
extern "C" {
    pub fn ht_up_insert(
        ht: *mut HtUP,
        key: ::std::os::raw::c_ulonglong,
        value: *mut ::std::os::raw::c_void,
    ) -> bool;
}
extern "C" {
    pub fn ht_up_update(
        ht: *mut HtUP,
        key: ::std::os::raw::c_ulonglong,
        value: *mut ::std::os::raw::c_void,
    ) -> bool;
}
extern "C" {
    pub fn ht_up_update_key(
        ht: *mut HtUP,
        old_key: ::std::os::raw::c_ulonglong,
        new_key: ::std::os::raw::c_ulonglong,
    ) -> bool;
}
extern "C" {
    pub fn ht_up_delete(ht: *mut HtUP, key: ::std::os::raw::c_ulonglong) -> bool;
}
extern "C" {
    pub fn ht_up_find(
        ht: *mut HtUP,
        key: ::std::os::raw::c_ulonglong,
        found: *mut bool,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn ht_up_foreach(ht: *mut HtUP, cb: HtUPForeachCallback, user: *mut ::std::os::raw::c_void);
}
extern "C" {
    pub fn ht_up_find_kv(
        ht: *mut HtUP,
        key: ::std::os::raw::c_ulonglong,
        found: *mut bool,
    ) -> *mut HtUPKv;
}
extern "C" {
    pub fn ht_up_insert_kv(ht: *mut HtUP, kv: *mut HtUPKv, update: bool) -> bool;
}
extern "C" {
    pub fn ht_up_new0() -> *mut HtUP;
}
extern "C" {
    pub fn ht_up_new(
        valdup: HtUPDupValue,
        pair_free: HtUPKvFreeFunc,
        valueSize: HtUPCalcSizeV,
    ) -> *mut HtUP;
}
extern "C" {
    pub fn ht_up_new_size(
        initial_size: ::std::os::raw::c_uint,
        valdup: HtUPDupValue,
        pair_free: HtUPKvFreeFunc,
        valueSize: HtUPCalcSizeV,
    ) -> *mut HtUP;
}
pub type tcflag_t = ::std::os::raw::c_ulong;
pub type cc_t = ::std::os::raw::c_uchar;
pub type speed_t = ::std::os::raw::c_ulong;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct termios {
    pub c_iflag: tcflag_t,
    pub c_oflag: tcflag_t,
    pub c_cflag: tcflag_t,
    pub c_lflag: tcflag_t,
    pub c_cc: [cc_t; 20usize],
    pub c_ispeed: speed_t,
    pub c_ospeed: speed_t,
}
#[test]
fn bindgen_test_layout_termios() {
    assert_eq!(
        ::std::mem::size_of::<termios>(),
        72usize,
        concat!("Size of: ", stringify!(termios))
    );
    assert_eq!(
        ::std::mem::align_of::<termios>(),
        8usize,
        concat!("Alignment of ", stringify!(termios))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<termios>())).c_iflag as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(termios),
            "::",
            stringify!(c_iflag)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<termios>())).c_oflag as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(termios),
            "::",
            stringify!(c_oflag)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<termios>())).c_cflag as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(termios),
            "::",
            stringify!(c_cflag)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<termios>())).c_lflag as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(termios),
            "::",
            stringify!(c_lflag)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<termios>())).c_cc as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(termios),
            "::",
            stringify!(c_cc)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<termios>())).c_ispeed as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(termios),
            "::",
            stringify!(c_ispeed)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<termios>())).c_ospeed as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(termios),
            "::",
            stringify!(c_ospeed)
        )
    );
}
extern "C" {
    pub fn cfgetispeed(arg1: *const termios) -> speed_t;
}
extern "C" {
    pub fn cfgetospeed(arg1: *const termios) -> speed_t;
}
extern "C" {
    pub fn cfsetispeed(arg1: *mut termios, arg2: speed_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn cfsetospeed(arg1: *mut termios, arg2: speed_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn tcgetattr(arg1: ::std::os::raw::c_int, arg2: *mut termios) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn tcsetattr(
        arg1: ::std::os::raw::c_int,
        arg2: ::std::os::raw::c_int,
        arg3: *const termios,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn tcdrain(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn tcflow(
        arg1: ::std::os::raw::c_int,
        arg2: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn tcflush(
        arg1: ::std::os::raw::c_int,
        arg2: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn tcsendbreak(
        arg1: ::std::os::raw::c_int,
        arg2: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn cfmakeraw(arg1: *mut termios);
}
extern "C" {
    pub fn cfsetspeed(arg1: *mut termios, arg2: speed_t) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct winsize {
    pub ws_row: ::std::os::raw::c_ushort,
    pub ws_col: ::std::os::raw::c_ushort,
    pub ws_xpixel: ::std::os::raw::c_ushort,
    pub ws_ypixel: ::std::os::raw::c_ushort,
}
#[test]
fn bindgen_test_layout_winsize() {
    assert_eq!(
        ::std::mem::size_of::<winsize>(),
        8usize,
        concat!("Size of: ", stringify!(winsize))
    );
    assert_eq!(
        ::std::mem::align_of::<winsize>(),
        2usize,
        concat!("Alignment of ", stringify!(winsize))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<winsize>())).ws_row as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(winsize),
            "::",
            stringify!(ws_row)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<winsize>())).ws_col as *const _ as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(winsize),
            "::",
            stringify!(ws_col)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<winsize>())).ws_xpixel as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(winsize),
            "::",
            stringify!(ws_xpixel)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<winsize>())).ws_ypixel as *const _ as usize },
        6usize,
        concat!(
            "Offset of field: ",
            stringify!(winsize),
            "::",
            stringify!(ws_ypixel)
        )
    );
}
extern "C" {
    pub fn tcgetsid(arg1: ::std::os::raw::c_int) -> pid_t;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ttysize {
    pub ts_lines: ::std::os::raw::c_ushort,
    pub ts_cols: ::std::os::raw::c_ushort,
    pub ts_xxx: ::std::os::raw::c_ushort,
    pub ts_yyy: ::std::os::raw::c_ushort,
}
#[test]
fn bindgen_test_layout_ttysize() {
    assert_eq!(
        ::std::mem::size_of::<ttysize>(),
        8usize,
        concat!("Size of: ", stringify!(ttysize))
    );
    assert_eq!(
        ::std::mem::align_of::<ttysize>(),
        2usize,
        concat!("Alignment of ", stringify!(ttysize))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ttysize>())).ts_lines as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(ttysize),
            "::",
            stringify!(ts_lines)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ttysize>())).ts_cols as *const _ as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(ttysize),
            "::",
            stringify!(ts_cols)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ttysize>())).ts_xxx as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(ttysize),
            "::",
            stringify!(ts_xxx)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ttysize>())).ts_yyy as *const _ as usize },
        6usize,
        concat!(
            "Offset of field: ",
            stringify!(ttysize),
            "::",
            stringify!(ts_yyy)
        )
    );
}
extern "C" {
    pub fn ioctl(
        arg1: ::std::os::raw::c_int,
        arg2: ::std::os::raw::c_ulong,
        ...
    ) -> ::std::os::raw::c_int;
}
pub type sa_family_t = __uint8_t;
pub type socklen_t = __darwin_socklen_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct iovec {
    pub iov_base: *mut ::std::os::raw::c_void,
    pub iov_len: size_t,
}
#[test]
fn bindgen_test_layout_iovec() {
    assert_eq!(
        ::std::mem::size_of::<iovec>(),
        16usize,
        concat!("Size of: ", stringify!(iovec))
    );
    assert_eq!(
        ::std::mem::align_of::<iovec>(),
        8usize,
        concat!("Alignment of ", stringify!(iovec))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<iovec>())).iov_base as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(iovec),
            "::",
            stringify!(iov_base)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<iovec>())).iov_len as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(iovec),
            "::",
            stringify!(iov_len)
        )
    );
}
pub type sae_associd_t = __uint32_t;
pub type sae_connid_t = __uint32_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct sa_endpoints {
    pub sae_srcif: ::std::os::raw::c_uint,
    pub sae_srcaddr: *const sockaddr,
    pub sae_srcaddrlen: socklen_t,
    pub sae_dstaddr: *const sockaddr,
    pub sae_dstaddrlen: socklen_t,
}
#[test]
fn bindgen_test_layout_sa_endpoints() {
    assert_eq!(
        ::std::mem::size_of::<sa_endpoints>(),
        40usize,
        concat!("Size of: ", stringify!(sa_endpoints))
    );
    assert_eq!(
        ::std::mem::align_of::<sa_endpoints>(),
        8usize,
        concat!("Alignment of ", stringify!(sa_endpoints))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sa_endpoints>())).sae_srcif as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sa_endpoints),
            "::",
            stringify!(sae_srcif)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sa_endpoints>())).sae_srcaddr as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(sa_endpoints),
            "::",
            stringify!(sae_srcaddr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sa_endpoints>())).sae_srcaddrlen as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(sa_endpoints),
            "::",
            stringify!(sae_srcaddrlen)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sa_endpoints>())).sae_dstaddr as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(sa_endpoints),
            "::",
            stringify!(sae_dstaddr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sa_endpoints>())).sae_dstaddrlen as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(sa_endpoints),
            "::",
            stringify!(sae_dstaddrlen)
        )
    );
}
pub type sa_endpoints_t = sa_endpoints;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct linger {
    pub l_onoff: ::std::os::raw::c_int,
    pub l_linger: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_linger() {
    assert_eq!(
        ::std::mem::size_of::<linger>(),
        8usize,
        concat!("Size of: ", stringify!(linger))
    );
    assert_eq!(
        ::std::mem::align_of::<linger>(),
        4usize,
        concat!("Alignment of ", stringify!(linger))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<linger>())).l_onoff as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(linger),
            "::",
            stringify!(l_onoff)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<linger>())).l_linger as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(linger),
            "::",
            stringify!(l_linger)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct so_np_extensions {
    pub npx_flags: u_int32_t,
    pub npx_mask: u_int32_t,
}
#[test]
fn bindgen_test_layout_so_np_extensions() {
    assert_eq!(
        ::std::mem::size_of::<so_np_extensions>(),
        8usize,
        concat!("Size of: ", stringify!(so_np_extensions))
    );
    assert_eq!(
        ::std::mem::align_of::<so_np_extensions>(),
        4usize,
        concat!("Alignment of ", stringify!(so_np_extensions))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<so_np_extensions>())).npx_flags as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(so_np_extensions),
            "::",
            stringify!(npx_flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<so_np_extensions>())).npx_mask as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(so_np_extensions),
            "::",
            stringify!(npx_mask)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct sockaddr {
    pub sa_len: __uint8_t,
    pub sa_family: sa_family_t,
    pub sa_data: [::std::os::raw::c_char; 14usize],
}
#[test]
fn bindgen_test_layout_sockaddr() {
    assert_eq!(
        ::std::mem::size_of::<sockaddr>(),
        16usize,
        concat!("Size of: ", stringify!(sockaddr))
    );
    assert_eq!(
        ::std::mem::align_of::<sockaddr>(),
        1usize,
        concat!("Alignment of ", stringify!(sockaddr))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sockaddr>())).sa_len as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sockaddr),
            "::",
            stringify!(sa_len)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sockaddr>())).sa_family as *const _ as usize },
        1usize,
        concat!(
            "Offset of field: ",
            stringify!(sockaddr),
            "::",
            stringify!(sa_family)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sockaddr>())).sa_data as *const _ as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(sockaddr),
            "::",
            stringify!(sa_data)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct sockproto {
    pub sp_family: __uint16_t,
    pub sp_protocol: __uint16_t,
}
#[test]
fn bindgen_test_layout_sockproto() {
    assert_eq!(
        ::std::mem::size_of::<sockproto>(),
        4usize,
        concat!("Size of: ", stringify!(sockproto))
    );
    assert_eq!(
        ::std::mem::align_of::<sockproto>(),
        2usize,
        concat!("Alignment of ", stringify!(sockproto))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sockproto>())).sp_family as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sockproto),
            "::",
            stringify!(sp_family)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sockproto>())).sp_protocol as *const _ as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(sockproto),
            "::",
            stringify!(sp_protocol)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct sockaddr_storage {
    pub ss_len: __uint8_t,
    pub ss_family: sa_family_t,
    pub __ss_pad1: [::std::os::raw::c_char; 6usize],
    pub __ss_align: __int64_t,
    pub __ss_pad2: [::std::os::raw::c_char; 112usize],
}
#[test]
fn bindgen_test_layout_sockaddr_storage() {
    assert_eq!(
        ::std::mem::size_of::<sockaddr_storage>(),
        128usize,
        concat!("Size of: ", stringify!(sockaddr_storage))
    );
    assert_eq!(
        ::std::mem::align_of::<sockaddr_storage>(),
        8usize,
        concat!("Alignment of ", stringify!(sockaddr_storage))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sockaddr_storage>())).ss_len as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sockaddr_storage),
            "::",
            stringify!(ss_len)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sockaddr_storage>())).ss_family as *const _ as usize },
        1usize,
        concat!(
            "Offset of field: ",
            stringify!(sockaddr_storage),
            "::",
            stringify!(ss_family)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sockaddr_storage>())).__ss_pad1 as *const _ as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(sockaddr_storage),
            "::",
            stringify!(__ss_pad1)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sockaddr_storage>())).__ss_align as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(sockaddr_storage),
            "::",
            stringify!(__ss_align)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sockaddr_storage>())).__ss_pad2 as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(sockaddr_storage),
            "::",
            stringify!(__ss_pad2)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct msghdr {
    pub msg_name: *mut ::std::os::raw::c_void,
    pub msg_namelen: socklen_t,
    pub msg_iov: *mut iovec,
    pub msg_iovlen: ::std::os::raw::c_int,
    pub msg_control: *mut ::std::os::raw::c_void,
    pub msg_controllen: socklen_t,
    pub msg_flags: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_msghdr() {
    assert_eq!(
        ::std::mem::size_of::<msghdr>(),
        48usize,
        concat!("Size of: ", stringify!(msghdr))
    );
    assert_eq!(
        ::std::mem::align_of::<msghdr>(),
        8usize,
        concat!("Alignment of ", stringify!(msghdr))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<msghdr>())).msg_name as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(msghdr),
            "::",
            stringify!(msg_name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<msghdr>())).msg_namelen as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(msghdr),
            "::",
            stringify!(msg_namelen)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<msghdr>())).msg_iov as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(msghdr),
            "::",
            stringify!(msg_iov)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<msghdr>())).msg_iovlen as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(msghdr),
            "::",
            stringify!(msg_iovlen)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<msghdr>())).msg_control as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(msghdr),
            "::",
            stringify!(msg_control)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<msghdr>())).msg_controllen as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(msghdr),
            "::",
            stringify!(msg_controllen)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<msghdr>())).msg_flags as *const _ as usize },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(msghdr),
            "::",
            stringify!(msg_flags)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cmsghdr {
    pub cmsg_len: socklen_t,
    pub cmsg_level: ::std::os::raw::c_int,
    pub cmsg_type: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_cmsghdr() {
    assert_eq!(
        ::std::mem::size_of::<cmsghdr>(),
        12usize,
        concat!("Size of: ", stringify!(cmsghdr))
    );
    assert_eq!(
        ::std::mem::align_of::<cmsghdr>(),
        4usize,
        concat!("Alignment of ", stringify!(cmsghdr))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cmsghdr>())).cmsg_len as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cmsghdr),
            "::",
            stringify!(cmsg_len)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cmsghdr>())).cmsg_level as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(cmsghdr),
            "::",
            stringify!(cmsg_level)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cmsghdr>())).cmsg_type as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(cmsghdr),
            "::",
            stringify!(cmsg_type)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct sf_hdtr {
    pub headers: *mut iovec,
    pub hdr_cnt: ::std::os::raw::c_int,
    pub trailers: *mut iovec,
    pub trl_cnt: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_sf_hdtr() {
    assert_eq!(
        ::std::mem::size_of::<sf_hdtr>(),
        32usize,
        concat!("Size of: ", stringify!(sf_hdtr))
    );
    assert_eq!(
        ::std::mem::align_of::<sf_hdtr>(),
        8usize,
        concat!("Alignment of ", stringify!(sf_hdtr))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sf_hdtr>())).headers as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sf_hdtr),
            "::",
            stringify!(headers)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sf_hdtr>())).hdr_cnt as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(sf_hdtr),
            "::",
            stringify!(hdr_cnt)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sf_hdtr>())).trailers as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(sf_hdtr),
            "::",
            stringify!(trailers)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sf_hdtr>())).trl_cnt as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(sf_hdtr),
            "::",
            stringify!(trl_cnt)
        )
    );
}
extern "C" {
    pub fn accept(
        arg1: ::std::os::raw::c_int,
        arg2: *mut sockaddr,
        arg3: *mut socklen_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bind(
        arg1: ::std::os::raw::c_int,
        arg2: *const sockaddr,
        arg3: socklen_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn connect(
        arg1: ::std::os::raw::c_int,
        arg2: *const sockaddr,
        arg3: socklen_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getpeername(
        arg1: ::std::os::raw::c_int,
        arg2: *mut sockaddr,
        arg3: *mut socklen_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getsockname(
        arg1: ::std::os::raw::c_int,
        arg2: *mut sockaddr,
        arg3: *mut socklen_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getsockopt(
        arg1: ::std::os::raw::c_int,
        arg2: ::std::os::raw::c_int,
        arg3: ::std::os::raw::c_int,
        arg4: *mut ::std::os::raw::c_void,
        arg5: *mut socklen_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn listen(
        arg1: ::std::os::raw::c_int,
        arg2: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn recv(
        arg1: ::std::os::raw::c_int,
        arg2: *mut ::std::os::raw::c_void,
        arg3: size_t,
        arg4: ::std::os::raw::c_int,
    ) -> ssize_t;
}
extern "C" {
    pub fn recvfrom(
        arg1: ::std::os::raw::c_int,
        arg2: *mut ::std::os::raw::c_void,
        arg3: size_t,
        arg4: ::std::os::raw::c_int,
        arg5: *mut sockaddr,
        arg6: *mut socklen_t,
    ) -> ssize_t;
}
extern "C" {
    pub fn recvmsg(
        arg1: ::std::os::raw::c_int,
        arg2: *mut msghdr,
        arg3: ::std::os::raw::c_int,
    ) -> ssize_t;
}
extern "C" {
    pub fn send(
        arg1: ::std::os::raw::c_int,
        arg2: *const ::std::os::raw::c_void,
        arg3: size_t,
        arg4: ::std::os::raw::c_int,
    ) -> ssize_t;
}
extern "C" {
    pub fn sendmsg(
        arg1: ::std::os::raw::c_int,
        arg2: *const msghdr,
        arg3: ::std::os::raw::c_int,
    ) -> ssize_t;
}
extern "C" {
    pub fn sendto(
        arg1: ::std::os::raw::c_int,
        arg2: *const ::std::os::raw::c_void,
        arg3: size_t,
        arg4: ::std::os::raw::c_int,
        arg5: *const sockaddr,
        arg6: socklen_t,
    ) -> ssize_t;
}
extern "C" {
    pub fn setsockopt(
        arg1: ::std::os::raw::c_int,
        arg2: ::std::os::raw::c_int,
        arg3: ::std::os::raw::c_int,
        arg4: *const ::std::os::raw::c_void,
        arg5: socklen_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn shutdown(
        arg1: ::std::os::raw::c_int,
        arg2: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sockatmark(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn socket(
        arg1: ::std::os::raw::c_int,
        arg2: ::std::os::raw::c_int,
        arg3: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn socketpair(
        arg1: ::std::os::raw::c_int,
        arg2: ::std::os::raw::c_int,
        arg3: ::std::os::raw::c_int,
        arg4: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sendfile(
        arg1: ::std::os::raw::c_int,
        arg2: ::std::os::raw::c_int,
        arg3: off_t,
        arg4: *mut off_t,
        arg5: *mut sf_hdtr,
        arg6: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pfctlinput(arg1: ::std::os::raw::c_int, arg2: *mut sockaddr);
}
extern "C" {
    pub fn connectx(
        arg1: ::std::os::raw::c_int,
        arg2: *const sa_endpoints_t,
        arg3: sae_associd_t,
        arg4: ::std::os::raw::c_uint,
        arg5: *const iovec,
        arg6: ::std::os::raw::c_uint,
        arg7: *mut size_t,
        arg8: *mut sae_connid_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn disconnectx(
        arg1: ::std::os::raw::c_int,
        arg2: sae_associd_t,
        arg3: sae_connid_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_cons_version() -> *const ::std::os::raw::c_char;
}
pub type RConsGetSize = ::std::option::Option<
    unsafe extern "C" fn(rows: *mut ::std::os::raw::c_int) -> ::std::os::raw::c_int,
>;
pub type RConsGetCursor = ::std::option::Option<
    unsafe extern "C" fn(rows: *mut ::std::os::raw::c_int) -> ::std::os::raw::c_int,
>;
pub type RConsIsBreaked = ::std::option::Option<unsafe extern "C" fn() -> bool>;
pub type RConsFlush = ::std::option::Option<unsafe extern "C" fn()>;
pub type RConsGrepCallback =
    ::std::option::Option<unsafe extern "C" fn(grep: *const ::std::os::raw::c_char)>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_cons_bind_t {
    pub get_size: RConsGetSize,
    pub get_cursor: RConsGetCursor,
    pub cb_printf: PrintfCallback,
    pub is_breaked: RConsIsBreaked,
    pub cb_flush: RConsFlush,
    pub cb_grep: RConsGrepCallback,
}
#[test]
fn bindgen_test_layout_r_cons_bind_t() {
    assert_eq!(
        ::std::mem::size_of::<r_cons_bind_t>(),
        48usize,
        concat!("Size of: ", stringify!(r_cons_bind_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_cons_bind_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_cons_bind_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_bind_t>())).get_size as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_bind_t),
            "::",
            stringify!(get_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_bind_t>())).get_cursor as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_bind_t),
            "::",
            stringify!(get_cursor)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_bind_t>())).cb_printf as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_bind_t),
            "::",
            stringify!(cb_printf)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_bind_t>())).is_breaked as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_bind_t),
            "::",
            stringify!(is_breaked)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_bind_t>())).cb_flush as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_bind_t),
            "::",
            stringify!(cb_flush)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_bind_t>())).cb_grep as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_bind_t),
            "::",
            stringify!(cb_grep)
        )
    );
}
pub type RConsBind = r_cons_bind_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_cons_grep_t {
    pub strings: [[::std::os::raw::c_char; 64usize]; 10usize],
    pub nstrings: ::std::os::raw::c_int,
    pub str_: *mut ::std::os::raw::c_char,
    pub counter: ::std::os::raw::c_int,
    pub charCounter: bool,
    pub less: ::std::os::raw::c_int,
    pub hud: bool,
    pub human: bool,
    pub json: ::std::os::raw::c_int,
    pub json_path: *mut ::std::os::raw::c_char,
    pub range_line: ::std::os::raw::c_int,
    pub line: ::std::os::raw::c_int,
    pub sort: ::std::os::raw::c_int,
    pub sort_row: ::std::os::raw::c_int,
    pub sort_invert: bool,
    pub f_line: ::std::os::raw::c_int,
    pub l_line: ::std::os::raw::c_int,
    pub tokens: [::std::os::raw::c_int; 64usize],
    pub tokens_used: ::std::os::raw::c_int,
    pub amp: ::std::os::raw::c_int,
    pub zoom: ::std::os::raw::c_int,
    pub zoomy: ::std::os::raw::c_int,
    pub neg: ::std::os::raw::c_int,
    pub begin: ::std::os::raw::c_int,
    pub end: ::std::os::raw::c_int,
    pub icase: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_r_cons_grep_t() {
    assert_eq!(
        ::std::mem::size_of::<r_cons_grep_t>(),
        1008usize,
        concat!("Size of: ", stringify!(r_cons_grep_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_cons_grep_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_cons_grep_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_grep_t>())).strings as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_grep_t),
            "::",
            stringify!(strings)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_grep_t>())).nstrings as *const _ as usize },
        640usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_grep_t),
            "::",
            stringify!(nstrings)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_grep_t>())).str_ as *const _ as usize },
        648usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_grep_t),
            "::",
            stringify!(str_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_grep_t>())).counter as *const _ as usize },
        656usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_grep_t),
            "::",
            stringify!(counter)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_grep_t>())).charCounter as *const _ as usize },
        660usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_grep_t),
            "::",
            stringify!(charCounter)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_grep_t>())).less as *const _ as usize },
        664usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_grep_t),
            "::",
            stringify!(less)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_grep_t>())).hud as *const _ as usize },
        668usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_grep_t),
            "::",
            stringify!(hud)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_grep_t>())).human as *const _ as usize },
        669usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_grep_t),
            "::",
            stringify!(human)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_grep_t>())).json as *const _ as usize },
        672usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_grep_t),
            "::",
            stringify!(json)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_grep_t>())).json_path as *const _ as usize },
        680usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_grep_t),
            "::",
            stringify!(json_path)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_grep_t>())).range_line as *const _ as usize },
        688usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_grep_t),
            "::",
            stringify!(range_line)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_grep_t>())).line as *const _ as usize },
        692usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_grep_t),
            "::",
            stringify!(line)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_grep_t>())).sort as *const _ as usize },
        696usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_grep_t),
            "::",
            stringify!(sort)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_grep_t>())).sort_row as *const _ as usize },
        700usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_grep_t),
            "::",
            stringify!(sort_row)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_grep_t>())).sort_invert as *const _ as usize },
        704usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_grep_t),
            "::",
            stringify!(sort_invert)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_grep_t>())).f_line as *const _ as usize },
        708usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_grep_t),
            "::",
            stringify!(f_line)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_grep_t>())).l_line as *const _ as usize },
        712usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_grep_t),
            "::",
            stringify!(l_line)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_grep_t>())).tokens as *const _ as usize },
        716usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_grep_t),
            "::",
            stringify!(tokens)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_grep_t>())).tokens_used as *const _ as usize },
        972usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_grep_t),
            "::",
            stringify!(tokens_used)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_grep_t>())).amp as *const _ as usize },
        976usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_grep_t),
            "::",
            stringify!(amp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_grep_t>())).zoom as *const _ as usize },
        980usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_grep_t),
            "::",
            stringify!(zoom)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_grep_t>())).zoomy as *const _ as usize },
        984usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_grep_t),
            "::",
            stringify!(zoomy)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_grep_t>())).neg as *const _ as usize },
        988usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_grep_t),
            "::",
            stringify!(neg)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_grep_t>())).begin as *const _ as usize },
        992usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_grep_t),
            "::",
            stringify!(begin)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_grep_t>())).end as *const _ as usize },
        996usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_grep_t),
            "::",
            stringify!(end)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_grep_t>())).icase as *const _ as usize },
        1000usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_grep_t),
            "::",
            stringify!(icase)
        )
    );
}
pub type RConsGrep = r_cons_grep_t;
pub const ALPHA_RESET: ::std::os::raw::c_uint = 0;
pub const ALPHA_FG: ::std::os::raw::c_uint = 1;
pub const ALPHA_BG: ::std::os::raw::c_uint = 2;
pub const ALPHA_FGBG: ::std::os::raw::c_uint = 3;
pub type _bindgen_ty_1 = ::std::os::raw::c_uint;
pub const R_CONS_ATTR_BOLD: ::std::os::raw::c_uint = 2;
pub const R_CONS_ATTR_DIM: ::std::os::raw::c_uint = 4;
pub const R_CONS_ATTR_ITALIC: ::std::os::raw::c_uint = 8;
pub const R_CONS_ATTR_UNDERLINE: ::std::os::raw::c_uint = 16;
pub const R_CONS_ATTR_BLINK: ::std::os::raw::c_uint = 32;
pub type _bindgen_ty_2 = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rcolor_t {
    pub attr: ::std::os::raw::c_uchar,
    pub a: ::std::os::raw::c_uchar,
    pub r: ::std::os::raw::c_uchar,
    pub g: ::std::os::raw::c_uchar,
    pub b: ::std::os::raw::c_uchar,
    pub r2: ::std::os::raw::c_uchar,
    pub g2: ::std::os::raw::c_uchar,
    pub b2: ::std::os::raw::c_uchar,
    pub id16: ::std::os::raw::c_schar,
}
#[test]
fn bindgen_test_layout_rcolor_t() {
    assert_eq!(
        ::std::mem::size_of::<rcolor_t>(),
        9usize,
        concat!("Size of: ", stringify!(rcolor_t))
    );
    assert_eq!(
        ::std::mem::align_of::<rcolor_t>(),
        1usize,
        concat!("Alignment of ", stringify!(rcolor_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rcolor_t>())).attr as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(rcolor_t),
            "::",
            stringify!(attr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rcolor_t>())).a as *const _ as usize },
        1usize,
        concat!(
            "Offset of field: ",
            stringify!(rcolor_t),
            "::",
            stringify!(a)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rcolor_t>())).r as *const _ as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(rcolor_t),
            "::",
            stringify!(r)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rcolor_t>())).g as *const _ as usize },
        3usize,
        concat!(
            "Offset of field: ",
            stringify!(rcolor_t),
            "::",
            stringify!(g)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rcolor_t>())).b as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(rcolor_t),
            "::",
            stringify!(b)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rcolor_t>())).r2 as *const _ as usize },
        5usize,
        concat!(
            "Offset of field: ",
            stringify!(rcolor_t),
            "::",
            stringify!(r2)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rcolor_t>())).g2 as *const _ as usize },
        6usize,
        concat!(
            "Offset of field: ",
            stringify!(rcolor_t),
            "::",
            stringify!(g2)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rcolor_t>())).b2 as *const _ as usize },
        7usize,
        concat!(
            "Offset of field: ",
            stringify!(rcolor_t),
            "::",
            stringify!(b2)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rcolor_t>())).id16 as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(rcolor_t),
            "::",
            stringify!(id16)
        )
    );
}
pub type RColor = rcolor_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_cons_palette_t {
    pub b0x00: RColor,
    pub b0x7f: RColor,
    pub b0xff: RColor,
    pub args: RColor,
    pub bin: RColor,
    pub btext: RColor,
    pub call: RColor,
    pub cjmp: RColor,
    pub cmp: RColor,
    pub comment: RColor,
    pub usercomment: RColor,
    pub creg: RColor,
    pub flag: RColor,
    pub fline: RColor,
    pub floc: RColor,
    pub flow: RColor,
    pub flow2: RColor,
    pub fname: RColor,
    pub help: RColor,
    pub input: RColor,
    pub invalid: RColor,
    pub jmp: RColor,
    pub label: RColor,
    pub math: RColor,
    pub mov: RColor,
    pub nop: RColor,
    pub num: RColor,
    pub offset: RColor,
    pub other: RColor,
    pub pop: RColor,
    pub prompt: RColor,
    pub push: RColor,
    pub crypto: RColor,
    pub reg: RColor,
    pub reset: RColor,
    pub ret: RColor,
    pub swi: RColor,
    pub trap: RColor,
    pub ucall: RColor,
    pub ujmp: RColor,
    pub ai_read: RColor,
    pub ai_write: RColor,
    pub ai_exec: RColor,
    pub ai_seq: RColor,
    pub ai_ascii: RColor,
    pub gui_cflow: RColor,
    pub gui_dataoffset: RColor,
    pub gui_background: RColor,
    pub gui_alt_background: RColor,
    pub gui_border: RColor,
    pub wordhl: RColor,
    pub linehl: RColor,
    pub func_var: RColor,
    pub func_var_type: RColor,
    pub func_var_addr: RColor,
    pub widget_bg: RColor,
    pub widget_sel: RColor,
    pub graph_box: RColor,
    pub graph_box2: RColor,
    pub graph_box3: RColor,
    pub graph_box4: RColor,
    pub graph_true: RColor,
    pub graph_false: RColor,
    pub graph_trufae: RColor,
    pub graph_traced: RColor,
    pub graph_current: RColor,
    pub graph_diff_match: RColor,
    pub graph_diff_unmatch: RColor,
    pub graph_diff_unknown: RColor,
    pub graph_diff_new: RColor,
}
#[test]
fn bindgen_test_layout_r_cons_palette_t() {
    assert_eq!(
        ::std::mem::size_of::<r_cons_palette_t>(),
        630usize,
        concat!("Size of: ", stringify!(r_cons_palette_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_cons_palette_t>(),
        1usize,
        concat!("Alignment of ", stringify!(r_cons_palette_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_palette_t>())).b0x00 as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(b0x00)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_palette_t>())).b0x7f as *const _ as usize },
        9usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(b0x7f)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_palette_t>())).b0xff as *const _ as usize },
        18usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(b0xff)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_palette_t>())).args as *const _ as usize },
        27usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(args)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_palette_t>())).bin as *const _ as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(bin)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_palette_t>())).btext as *const _ as usize },
        45usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(btext)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_palette_t>())).call as *const _ as usize },
        54usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(call)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_palette_t>())).cjmp as *const _ as usize },
        63usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(cjmp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_palette_t>())).cmp as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(cmp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_palette_t>())).comment as *const _ as usize },
        81usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(comment)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_palette_t>())).usercomment as *const _ as usize },
        90usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(usercomment)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_palette_t>())).creg as *const _ as usize },
        99usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(creg)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_palette_t>())).flag as *const _ as usize },
        108usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(flag)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_palette_t>())).fline as *const _ as usize },
        117usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(fline)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_palette_t>())).floc as *const _ as usize },
        126usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(floc)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_palette_t>())).flow as *const _ as usize },
        135usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(flow)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_palette_t>())).flow2 as *const _ as usize },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(flow2)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_palette_t>())).fname as *const _ as usize },
        153usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(fname)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_palette_t>())).help as *const _ as usize },
        162usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(help)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_palette_t>())).input as *const _ as usize },
        171usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(input)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_palette_t>())).invalid as *const _ as usize },
        180usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(invalid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_palette_t>())).jmp as *const _ as usize },
        189usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(jmp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_palette_t>())).label as *const _ as usize },
        198usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(label)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_palette_t>())).math as *const _ as usize },
        207usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(math)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_palette_t>())).mov as *const _ as usize },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(mov)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_palette_t>())).nop as *const _ as usize },
        225usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(nop)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_palette_t>())).num as *const _ as usize },
        234usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(num)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_palette_t>())).offset as *const _ as usize },
        243usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(offset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_palette_t>())).other as *const _ as usize },
        252usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(other)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_palette_t>())).pop as *const _ as usize },
        261usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(pop)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_palette_t>())).prompt as *const _ as usize },
        270usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(prompt)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_palette_t>())).push as *const _ as usize },
        279usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(push)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_palette_t>())).crypto as *const _ as usize },
        288usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(crypto)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_palette_t>())).reg as *const _ as usize },
        297usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(reg)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_palette_t>())).reset as *const _ as usize },
        306usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(reset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_palette_t>())).ret as *const _ as usize },
        315usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(ret)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_palette_t>())).swi as *const _ as usize },
        324usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(swi)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_palette_t>())).trap as *const _ as usize },
        333usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(trap)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_palette_t>())).ucall as *const _ as usize },
        342usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(ucall)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_palette_t>())).ujmp as *const _ as usize },
        351usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(ujmp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_palette_t>())).ai_read as *const _ as usize },
        360usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(ai_read)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_palette_t>())).ai_write as *const _ as usize },
        369usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(ai_write)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_palette_t>())).ai_exec as *const _ as usize },
        378usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(ai_exec)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_palette_t>())).ai_seq as *const _ as usize },
        387usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(ai_seq)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_palette_t>())).ai_ascii as *const _ as usize },
        396usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(ai_ascii)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_palette_t>())).gui_cflow as *const _ as usize },
        405usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(gui_cflow)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_palette_t>())).gui_dataoffset as *const _ as usize },
        414usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(gui_dataoffset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_palette_t>())).gui_background as *const _ as usize },
        423usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(gui_background)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_cons_palette_t>())).gui_alt_background as *const _ as usize
        },
        432usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(gui_alt_background)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_palette_t>())).gui_border as *const _ as usize },
        441usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(gui_border)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_palette_t>())).wordhl as *const _ as usize },
        450usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(wordhl)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_palette_t>())).linehl as *const _ as usize },
        459usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(linehl)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_palette_t>())).func_var as *const _ as usize },
        468usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(func_var)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_palette_t>())).func_var_type as *const _ as usize },
        477usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(func_var_type)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_palette_t>())).func_var_addr as *const _ as usize },
        486usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(func_var_addr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_palette_t>())).widget_bg as *const _ as usize },
        495usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(widget_bg)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_palette_t>())).widget_sel as *const _ as usize },
        504usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(widget_sel)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_palette_t>())).graph_box as *const _ as usize },
        513usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(graph_box)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_palette_t>())).graph_box2 as *const _ as usize },
        522usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(graph_box2)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_palette_t>())).graph_box3 as *const _ as usize },
        531usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(graph_box3)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_palette_t>())).graph_box4 as *const _ as usize },
        540usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(graph_box4)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_palette_t>())).graph_true as *const _ as usize },
        549usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(graph_true)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_palette_t>())).graph_false as *const _ as usize },
        558usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(graph_false)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_palette_t>())).graph_trufae as *const _ as usize },
        567usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(graph_trufae)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_palette_t>())).graph_traced as *const _ as usize },
        576usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(graph_traced)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_palette_t>())).graph_current as *const _ as usize },
        585usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(graph_current)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_cons_palette_t>())).graph_diff_match as *const _ as usize
        },
        594usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(graph_diff_match)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_cons_palette_t>())).graph_diff_unmatch as *const _ as usize
        },
        603usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(graph_diff_unmatch)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_cons_palette_t>())).graph_diff_unknown as *const _ as usize
        },
        612usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(graph_diff_unknown)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_palette_t>())).graph_diff_new as *const _ as usize },
        621usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(graph_diff_new)
        )
    );
}
pub type RConsPalette = r_cons_palette_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_cons_printable_palette_t {
    pub b0x00: *mut ::std::os::raw::c_char,
    pub b0x7f: *mut ::std::os::raw::c_char,
    pub b0xff: *mut ::std::os::raw::c_char,
    pub args: *mut ::std::os::raw::c_char,
    pub bin: *mut ::std::os::raw::c_char,
    pub btext: *mut ::std::os::raw::c_char,
    pub call: *mut ::std::os::raw::c_char,
    pub cjmp: *mut ::std::os::raw::c_char,
    pub cmp: *mut ::std::os::raw::c_char,
    pub comment: *mut ::std::os::raw::c_char,
    pub usercomment: *mut ::std::os::raw::c_char,
    pub creg: *mut ::std::os::raw::c_char,
    pub flag: *mut ::std::os::raw::c_char,
    pub fline: *mut ::std::os::raw::c_char,
    pub floc: *mut ::std::os::raw::c_char,
    pub flow: *mut ::std::os::raw::c_char,
    pub flow2: *mut ::std::os::raw::c_char,
    pub fname: *mut ::std::os::raw::c_char,
    pub help: *mut ::std::os::raw::c_char,
    pub input: *mut ::std::os::raw::c_char,
    pub invalid: *mut ::std::os::raw::c_char,
    pub jmp: *mut ::std::os::raw::c_char,
    pub label: *mut ::std::os::raw::c_char,
    pub math: *mut ::std::os::raw::c_char,
    pub mov: *mut ::std::os::raw::c_char,
    pub nop: *mut ::std::os::raw::c_char,
    pub num: *mut ::std::os::raw::c_char,
    pub offset: *mut ::std::os::raw::c_char,
    pub other: *mut ::std::os::raw::c_char,
    pub pop: *mut ::std::os::raw::c_char,
    pub prompt: *mut ::std::os::raw::c_char,
    pub push: *mut ::std::os::raw::c_char,
    pub crypto: *mut ::std::os::raw::c_char,
    pub reg: *mut ::std::os::raw::c_char,
    pub reset: *mut ::std::os::raw::c_char,
    pub ret: *mut ::std::os::raw::c_char,
    pub swi: *mut ::std::os::raw::c_char,
    pub trap: *mut ::std::os::raw::c_char,
    pub ucall: *mut ::std::os::raw::c_char,
    pub ujmp: *mut ::std::os::raw::c_char,
    pub ai_read: *mut ::std::os::raw::c_char,
    pub ai_write: *mut ::std::os::raw::c_char,
    pub ai_exec: *mut ::std::os::raw::c_char,
    pub ai_seq: *mut ::std::os::raw::c_char,
    pub ai_ascii: *mut ::std::os::raw::c_char,
    pub ai_unmap: *mut ::std::os::raw::c_char,
    pub gui_cflow: *mut ::std::os::raw::c_char,
    pub gui_dataoffset: *mut ::std::os::raw::c_char,
    pub gui_background: *mut ::std::os::raw::c_char,
    pub gui_alt_background: *mut ::std::os::raw::c_char,
    pub gui_border: *mut ::std::os::raw::c_char,
    pub wordhl: *mut ::std::os::raw::c_char,
    pub linehl: *mut ::std::os::raw::c_char,
    pub func_var: *mut ::std::os::raw::c_char,
    pub func_var_type: *mut ::std::os::raw::c_char,
    pub func_var_addr: *mut ::std::os::raw::c_char,
    pub widget_bg: *mut ::std::os::raw::c_char,
    pub widget_sel: *mut ::std::os::raw::c_char,
    pub graph_box: *mut ::std::os::raw::c_char,
    pub graph_box2: *mut ::std::os::raw::c_char,
    pub graph_box3: *mut ::std::os::raw::c_char,
    pub graph_box4: *mut ::std::os::raw::c_char,
    pub graph_diff_match: *mut ::std::os::raw::c_char,
    pub graph_diff_unmatch: *mut ::std::os::raw::c_char,
    pub graph_diff_unknown: *mut ::std::os::raw::c_char,
    pub graph_diff_new: *mut ::std::os::raw::c_char,
    pub graph_true: *mut ::std::os::raw::c_char,
    pub graph_false: *mut ::std::os::raw::c_char,
    pub graph_trufae: *mut ::std::os::raw::c_char,
    pub graph_traced: *mut ::std::os::raw::c_char,
    pub graph_current: *mut ::std::os::raw::c_char,
    pub rainbow: *mut *mut ::std::os::raw::c_char,
    pub rainbow_sz: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_r_cons_printable_palette_t() {
    assert_eq!(
        ::std::mem::size_of::<r_cons_printable_palette_t>(),
        584usize,
        concat!("Size of: ", stringify!(r_cons_printable_palette_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_cons_printable_palette_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_cons_printable_palette_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_cons_printable_palette_t>())).b0x00 as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(b0x00)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_cons_printable_palette_t>())).b0x7f as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(b0x7f)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_cons_printable_palette_t>())).b0xff as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(b0xff)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_printable_palette_t>())).args as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(args)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_printable_palette_t>())).bin as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(bin)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_cons_printable_palette_t>())).btext as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(btext)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_printable_palette_t>())).call as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(call)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_printable_palette_t>())).cjmp as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(cjmp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_printable_palette_t>())).cmp as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(cmp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_cons_printable_palette_t>())).comment as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(comment)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_cons_printable_palette_t>())).usercomment as *const _ as usize
        },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(usercomment)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_printable_palette_t>())).creg as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(creg)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_printable_palette_t>())).flag as *const _ as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(flag)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_cons_printable_palette_t>())).fline as *const _ as usize
        },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(fline)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_printable_palette_t>())).floc as *const _ as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(floc)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_printable_palette_t>())).flow as *const _ as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(flow)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_cons_printable_palette_t>())).flow2 as *const _ as usize
        },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(flow2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_cons_printable_palette_t>())).fname as *const _ as usize
        },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(fname)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_printable_palette_t>())).help as *const _ as usize },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(help)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_cons_printable_palette_t>())).input as *const _ as usize
        },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(input)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_cons_printable_palette_t>())).invalid as *const _ as usize
        },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(invalid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_printable_palette_t>())).jmp as *const _ as usize },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(jmp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_cons_printable_palette_t>())).label as *const _ as usize
        },
        176usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(label)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_printable_palette_t>())).math as *const _ as usize },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(math)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_printable_palette_t>())).mov as *const _ as usize },
        192usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(mov)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_printable_palette_t>())).nop as *const _ as usize },
        200usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(nop)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_printable_palette_t>())).num as *const _ as usize },
        208usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(num)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_cons_printable_palette_t>())).offset as *const _ as usize
        },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(offset)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_cons_printable_palette_t>())).other as *const _ as usize
        },
        224usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(other)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_printable_palette_t>())).pop as *const _ as usize },
        232usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(pop)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_cons_printable_palette_t>())).prompt as *const _ as usize
        },
        240usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(prompt)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_printable_palette_t>())).push as *const _ as usize },
        248usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(push)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_cons_printable_palette_t>())).crypto as *const _ as usize
        },
        256usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(crypto)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_printable_palette_t>())).reg as *const _ as usize },
        264usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(reg)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_cons_printable_palette_t>())).reset as *const _ as usize
        },
        272usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(reset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_printable_palette_t>())).ret as *const _ as usize },
        280usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(ret)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_printable_palette_t>())).swi as *const _ as usize },
        288usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(swi)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_printable_palette_t>())).trap as *const _ as usize },
        296usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(trap)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_cons_printable_palette_t>())).ucall as *const _ as usize
        },
        304usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(ucall)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_printable_palette_t>())).ujmp as *const _ as usize },
        312usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(ujmp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_cons_printable_palette_t>())).ai_read as *const _ as usize
        },
        320usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(ai_read)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_cons_printable_palette_t>())).ai_write as *const _ as usize
        },
        328usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(ai_write)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_cons_printable_palette_t>())).ai_exec as *const _ as usize
        },
        336usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(ai_exec)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_cons_printable_palette_t>())).ai_seq as *const _ as usize
        },
        344usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(ai_seq)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_cons_printable_palette_t>())).ai_ascii as *const _ as usize
        },
        352usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(ai_ascii)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_cons_printable_palette_t>())).ai_unmap as *const _ as usize
        },
        360usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(ai_unmap)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_cons_printable_palette_t>())).gui_cflow as *const _ as usize
        },
        368usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(gui_cflow)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_cons_printable_palette_t>())).gui_dataoffset as *const _
                as usize
        },
        376usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(gui_dataoffset)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_cons_printable_palette_t>())).gui_background as *const _
                as usize
        },
        384usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(gui_background)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_cons_printable_palette_t>())).gui_alt_background as *const _
                as usize
        },
        392usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(gui_alt_background)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_cons_printable_palette_t>())).gui_border as *const _ as usize
        },
        400usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(gui_border)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_cons_printable_palette_t>())).wordhl as *const _ as usize
        },
        408usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(wordhl)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_cons_printable_palette_t>())).linehl as *const _ as usize
        },
        416usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(linehl)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_cons_printable_palette_t>())).func_var as *const _ as usize
        },
        424usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(func_var)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_cons_printable_palette_t>())).func_var_type as *const _
                as usize
        },
        432usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(func_var_type)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_cons_printable_palette_t>())).func_var_addr as *const _
                as usize
        },
        440usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(func_var_addr)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_cons_printable_palette_t>())).widget_bg as *const _ as usize
        },
        448usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(widget_bg)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_cons_printable_palette_t>())).widget_sel as *const _ as usize
        },
        456usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(widget_sel)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_cons_printable_palette_t>())).graph_box as *const _ as usize
        },
        464usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(graph_box)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_cons_printable_palette_t>())).graph_box2 as *const _ as usize
        },
        472usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(graph_box2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_cons_printable_palette_t>())).graph_box3 as *const _ as usize
        },
        480usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(graph_box3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_cons_printable_palette_t>())).graph_box4 as *const _ as usize
        },
        488usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(graph_box4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_cons_printable_palette_t>())).graph_diff_match as *const _
                as usize
        },
        496usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(graph_diff_match)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_cons_printable_palette_t>())).graph_diff_unmatch as *const _
                as usize
        },
        504usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(graph_diff_unmatch)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_cons_printable_palette_t>())).graph_diff_unknown as *const _
                as usize
        },
        512usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(graph_diff_unknown)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_cons_printable_palette_t>())).graph_diff_new as *const _
                as usize
        },
        520usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(graph_diff_new)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_cons_printable_palette_t>())).graph_true as *const _ as usize
        },
        528usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(graph_true)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_cons_printable_palette_t>())).graph_false as *const _ as usize
        },
        536usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(graph_false)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_cons_printable_palette_t>())).graph_trufae as *const _ as usize
        },
        544usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(graph_trufae)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_cons_printable_palette_t>())).graph_traced as *const _ as usize
        },
        552usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(graph_traced)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_cons_printable_palette_t>())).graph_current as *const _
                as usize
        },
        560usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(graph_current)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_cons_printable_palette_t>())).rainbow as *const _ as usize
        },
        568usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(rainbow)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_cons_printable_palette_t>())).rainbow_sz as *const _ as usize
        },
        576usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(rainbow_sz)
        )
    );
}
pub type RConsPrintablePalette = r_cons_printable_palette_t;
pub type RConsEvent =
    ::std::option::Option<unsafe extern "C" fn(arg1: *mut ::std::os::raw::c_void)>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_cons_canvas_t {
    pub w: ::std::os::raw::c_int,
    pub h: ::std::os::raw::c_int,
    pub x: ::std::os::raw::c_int,
    pub y: ::std::os::raw::c_int,
    pub b: *mut *mut ::std::os::raw::c_char,
    pub blen: *mut ::std::os::raw::c_int,
    pub bsize: *mut ::std::os::raw::c_int,
    pub attr: *const ::std::os::raw::c_char,
    pub attrs: *mut HtUP,
    pub constpool: RStrConstPool,
    pub sx: ::std::os::raw::c_int,
    pub sy: ::std::os::raw::c_int,
    pub color: ::std::os::raw::c_int,
    pub linemode: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_r_cons_canvas_t() {
    assert_eq!(
        ::std::mem::size_of::<r_cons_canvas_t>(),
        80usize,
        concat!("Size of: ", stringify!(r_cons_canvas_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_cons_canvas_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_cons_canvas_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_canvas_t>())).w as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_canvas_t),
            "::",
            stringify!(w)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_canvas_t>())).h as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_canvas_t),
            "::",
            stringify!(h)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_canvas_t>())).x as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_canvas_t),
            "::",
            stringify!(x)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_canvas_t>())).y as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_canvas_t),
            "::",
            stringify!(y)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_canvas_t>())).b as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_canvas_t),
            "::",
            stringify!(b)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_canvas_t>())).blen as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_canvas_t),
            "::",
            stringify!(blen)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_canvas_t>())).bsize as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_canvas_t),
            "::",
            stringify!(bsize)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_canvas_t>())).attr as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_canvas_t),
            "::",
            stringify!(attr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_canvas_t>())).attrs as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_canvas_t),
            "::",
            stringify!(attrs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_canvas_t>())).constpool as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_canvas_t),
            "::",
            stringify!(constpool)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_canvas_t>())).sx as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_canvas_t),
            "::",
            stringify!(sx)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_canvas_t>())).sy as *const _ as usize },
        68usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_canvas_t),
            "::",
            stringify!(sy)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_canvas_t>())).color as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_canvas_t),
            "::",
            stringify!(color)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_canvas_t>())).linemode as *const _ as usize },
        76usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_canvas_t),
            "::",
            stringify!(linemode)
        )
    );
}
pub type RConsCanvas = r_cons_canvas_t;
pub type RConsEditorCallback = ::std::option::Option<
    unsafe extern "C" fn(
        core: *mut ::std::os::raw::c_void,
        file: *const ::std::os::raw::c_char,
        str_: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char,
>;
pub type RConsClickCallback = ::std::option::Option<
    unsafe extern "C" fn(
        core: *mut ::std::os::raw::c_void,
        x: ::std::os::raw::c_int,
        y: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int,
>;
pub type RConsBreakCallback =
    ::std::option::Option<unsafe extern "C" fn(core: *mut ::std::os::raw::c_void)>;
pub type RConsSleepBeginCallback = ::std::option::Option<
    unsafe extern "C" fn(core: *mut ::std::os::raw::c_void) -> *mut ::std::os::raw::c_void,
>;
pub type RConsSleepEndCallback = ::std::option::Option<
    unsafe extern "C" fn(core: *mut ::std::os::raw::c_void, user: *mut ::std::os::raw::c_void),
>;
pub type RConsQueueTaskOneshot = ::std::option::Option<
    unsafe extern "C" fn(
        core: *mut ::std::os::raw::c_void,
        task: *mut ::std::os::raw::c_void,
        user: *mut ::std::os::raw::c_void,
    ),
>;
pub type RConsFunctionKey = ::std::option::Option<
    unsafe extern "C" fn(core: *mut ::std::os::raw::c_void, fkey: ::std::os::raw::c_int),
>;
pub const RConsColorMode_COLOR_MODE_DISABLED: RConsColorMode = 0;
pub const RConsColorMode_COLOR_MODE_16: RConsColorMode = 1;
pub const RConsColorMode_COLOR_MODE_256: RConsColorMode = 2;
pub const RConsColorMode_COLOR_MODE_16M: RConsColorMode = 3;
pub type RConsColorMode = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_cons_context_t {
    pub grep: RConsGrep,
    pub cons_stack: *mut RStack,
    pub buffer: *mut ::std::os::raw::c_char,
    pub buffer_len: size_t,
    pub buffer_sz: size_t,
    pub error: *mut RStrBuf,
    pub errmode: ::std::os::raw::c_int,
    pub breaked: bool,
    pub was_breaked: bool,
    pub break_stack: *mut RStack,
    pub event_interrupt: RConsEvent,
    pub event_interrupt_data: *mut ::std::os::raw::c_void,
    pub cmd_depth: ::std::os::raw::c_int,
    pub log_callback: RLogCallback,
    pub lastOutput: *mut ::std::os::raw::c_char,
    pub lastLength: ::std::os::raw::c_int,
    pub lastMode: bool,
    pub lastEnabled: bool,
    pub is_interactive: bool,
    pub pageable: bool,
    pub color_mode: ::std::os::raw::c_int,
    pub cpal: RConsPalette,
    pub pal: RConsPrintablePalette,
    pub sorted_lines: *mut RList,
    pub unsorted_lines: *mut RList,
    pub sorted_column: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_r_cons_context_t() {
    assert_eq!(
        ::std::mem::size_of::<r_cons_context_t>(),
        2360usize,
        concat!("Size of: ", stringify!(r_cons_context_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_cons_context_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_cons_context_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_context_t>())).grep as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_context_t),
            "::",
            stringify!(grep)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_context_t>())).cons_stack as *const _ as usize },
        1008usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_context_t),
            "::",
            stringify!(cons_stack)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_context_t>())).buffer as *const _ as usize },
        1016usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_context_t),
            "::",
            stringify!(buffer)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_context_t>())).buffer_len as *const _ as usize },
        1024usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_context_t),
            "::",
            stringify!(buffer_len)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_context_t>())).buffer_sz as *const _ as usize },
        1032usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_context_t),
            "::",
            stringify!(buffer_sz)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_context_t>())).error as *const _ as usize },
        1040usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_context_t),
            "::",
            stringify!(error)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_context_t>())).errmode as *const _ as usize },
        1048usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_context_t),
            "::",
            stringify!(errmode)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_context_t>())).breaked as *const _ as usize },
        1052usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_context_t),
            "::",
            stringify!(breaked)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_context_t>())).was_breaked as *const _ as usize },
        1053usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_context_t),
            "::",
            stringify!(was_breaked)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_context_t>())).break_stack as *const _ as usize },
        1056usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_context_t),
            "::",
            stringify!(break_stack)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_cons_context_t>())).event_interrupt as *const _ as usize
        },
        1064usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_context_t),
            "::",
            stringify!(event_interrupt)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_cons_context_t>())).event_interrupt_data as *const _ as usize
        },
        1072usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_context_t),
            "::",
            stringify!(event_interrupt_data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_context_t>())).cmd_depth as *const _ as usize },
        1080usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_context_t),
            "::",
            stringify!(cmd_depth)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_context_t>())).log_callback as *const _ as usize },
        1088usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_context_t),
            "::",
            stringify!(log_callback)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_context_t>())).lastOutput as *const _ as usize },
        1096usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_context_t),
            "::",
            stringify!(lastOutput)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_context_t>())).lastLength as *const _ as usize },
        1104usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_context_t),
            "::",
            stringify!(lastLength)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_context_t>())).lastMode as *const _ as usize },
        1108usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_context_t),
            "::",
            stringify!(lastMode)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_context_t>())).lastEnabled as *const _ as usize },
        1109usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_context_t),
            "::",
            stringify!(lastEnabled)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_context_t>())).is_interactive as *const _ as usize },
        1110usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_context_t),
            "::",
            stringify!(is_interactive)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_context_t>())).pageable as *const _ as usize },
        1111usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_context_t),
            "::",
            stringify!(pageable)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_context_t>())).color_mode as *const _ as usize },
        1112usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_context_t),
            "::",
            stringify!(color_mode)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_context_t>())).cpal as *const _ as usize },
        1116usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_context_t),
            "::",
            stringify!(cpal)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_context_t>())).pal as *const _ as usize },
        1752usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_context_t),
            "::",
            stringify!(pal)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_context_t>())).sorted_lines as *const _ as usize },
        2336usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_context_t),
            "::",
            stringify!(sorted_lines)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_context_t>())).unsorted_lines as *const _ as usize },
        2344usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_context_t),
            "::",
            stringify!(unsorted_lines)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_context_t>())).sorted_column as *const _ as usize },
        2352usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_context_t),
            "::",
            stringify!(sorted_column)
        )
    );
}
pub type RConsContext = r_cons_context_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RConsCursorPos {
    pub x: ::std::os::raw::c_int,
    pub y: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_RConsCursorPos() {
    assert_eq!(
        ::std::mem::size_of::<RConsCursorPos>(),
        8usize,
        concat!("Size of: ", stringify!(RConsCursorPos))
    );
    assert_eq!(
        ::std::mem::align_of::<RConsCursorPos>(),
        4usize,
        concat!("Alignment of ", stringify!(RConsCursorPos))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RConsCursorPos>())).x as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(RConsCursorPos),
            "::",
            stringify!(x)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RConsCursorPos>())).y as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(RConsCursorPos),
            "::",
            stringify!(y)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_cons_t {
    pub context: *mut RConsContext,
    pub lastline: *mut ::std::os::raw::c_char,
    pub is_html: bool,
    pub was_html: bool,
    pub lines: ::std::os::raw::c_int,
    pub rows: ::std::os::raw::c_int,
    pub echo: ::std::os::raw::c_int,
    pub fps: ::std::os::raw::c_int,
    pub columns: ::std::os::raw::c_int,
    pub force_rows: ::std::os::raw::c_int,
    pub force_columns: ::std::os::raw::c_int,
    pub fix_rows: ::std::os::raw::c_int,
    pub fix_columns: ::std::os::raw::c_int,
    pub break_lines: bool,
    pub noflush: ::std::os::raw::c_int,
    pub optimize: ::std::os::raw::c_int,
    pub show_autocomplete_widget: bool,
    pub fdin: *mut FILE,
    pub fdout: ::std::os::raw::c_int,
    pub teefile: *const ::std::os::raw::c_char,
    pub user_fgets: ::std::option::Option<
        unsafe extern "C" fn(
            buf: *mut ::std::os::raw::c_char,
            len: ::std::os::raw::c_int,
        ) -> ::std::os::raw::c_int,
    >,
    pub event_resize: RConsEvent,
    pub event_data: *mut ::std::os::raw::c_void,
    pub mouse_event: ::std::os::raw::c_int,
    pub cb_editor: RConsEditorCallback,
    pub cb_break: RConsBreakCallback,
    pub cb_sleep_begin: RConsSleepBeginCallback,
    pub cb_sleep_end: RConsSleepEndCallback,
    pub cb_click: RConsClickCallback,
    pub cb_task_oneshot: RConsQueueTaskOneshot,
    pub cb_fkey: RConsFunctionKey,
    pub user: *mut ::std::os::raw::c_void,
    pub term_raw: termios,
    pub term_buf: termios,
    pub num: *mut RNum,
    pub pager: *mut ::std::os::raw::c_char,
    pub blankline: ::std::os::raw::c_int,
    pub highlight: *mut ::std::os::raw::c_char,
    pub enable_highlight: bool,
    pub null: ::std::os::raw::c_int,
    pub mouse: ::std::os::raw::c_int,
    pub is_wine: ::std::os::raw::c_int,
    pub line: *mut r_line_t,
    pub vline: *mut *const ::std::os::raw::c_char,
    pub refcnt: ::std::os::raw::c_int,
    pub newline: bool,
    pub vtmode: ::std::os::raw::c_int,
    pub flush: bool,
    pub use_utf8: bool,
    pub use_utf8_curvy: bool,
    pub dotted_lines: bool,
    pub linesleep: ::std::os::raw::c_int,
    pub pagesize: ::std::os::raw::c_int,
    pub break_word: *mut ::std::os::raw::c_char,
    pub break_word_len: ::std::os::raw::c_int,
    pub timeout: ::std::os::raw::c_ulonglong,
    pub grep_color: bool,
    pub grep_highlight: bool,
    pub use_tts: bool,
    pub filter: bool,
    pub rgbstr: ::std::option::Option<
        unsafe extern "C" fn(
            str_: *mut ::std::os::raw::c_char,
            sz: size_t,
            addr: ::std::os::raw::c_ulonglong,
        ) -> *mut ::std::os::raw::c_char,
    >,
    pub click_set: bool,
    pub click_x: ::std::os::raw::c_int,
    pub click_y: ::std::os::raw::c_int,
    pub show_vals: bool,
    pub cpos: RConsCursorPos,
}
#[test]
fn bindgen_test_layout_r_cons_t() {
    assert_eq!(
        ::std::mem::size_of::<r_cons_t>(),
        488usize,
        concat!("Size of: ", stringify!(r_cons_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_cons_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_cons_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_t>())).context as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_t),
            "::",
            stringify!(context)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_t>())).lastline as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_t),
            "::",
            stringify!(lastline)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_t>())).is_html as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_t),
            "::",
            stringify!(is_html)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_t>())).was_html as *const _ as usize },
        17usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_t),
            "::",
            stringify!(was_html)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_t>())).lines as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_t),
            "::",
            stringify!(lines)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_t>())).rows as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_t),
            "::",
            stringify!(rows)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_t>())).echo as *const _ as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_t),
            "::",
            stringify!(echo)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_t>())).fps as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_t),
            "::",
            stringify!(fps)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_t>())).columns as *const _ as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_t),
            "::",
            stringify!(columns)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_t>())).force_rows as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_t),
            "::",
            stringify!(force_rows)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_t>())).force_columns as *const _ as usize },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_t),
            "::",
            stringify!(force_columns)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_t>())).fix_rows as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_t),
            "::",
            stringify!(fix_rows)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_t>())).fix_columns as *const _ as usize },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_t),
            "::",
            stringify!(fix_columns)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_t>())).break_lines as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_t),
            "::",
            stringify!(break_lines)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_t>())).noflush as *const _ as usize },
        60usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_t),
            "::",
            stringify!(noflush)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_t>())).optimize as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_t),
            "::",
            stringify!(optimize)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_cons_t>())).show_autocomplete_widget as *const _ as usize
        },
        68usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_t),
            "::",
            stringify!(show_autocomplete_widget)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_t>())).fdin as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_t),
            "::",
            stringify!(fdin)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_t>())).fdout as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_t),
            "::",
            stringify!(fdout)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_t>())).teefile as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_t),
            "::",
            stringify!(teefile)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_t>())).user_fgets as *const _ as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_t),
            "::",
            stringify!(user_fgets)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_t>())).event_resize as *const _ as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_t),
            "::",
            stringify!(event_resize)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_t>())).event_data as *const _ as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_t),
            "::",
            stringify!(event_data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_t>())).mouse_event as *const _ as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_t),
            "::",
            stringify!(mouse_event)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_t>())).cb_editor as *const _ as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_t),
            "::",
            stringify!(cb_editor)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_t>())).cb_break as *const _ as usize },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_t),
            "::",
            stringify!(cb_break)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_t>())).cb_sleep_begin as *const _ as usize },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_t),
            "::",
            stringify!(cb_sleep_begin)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_t>())).cb_sleep_end as *const _ as usize },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_t),
            "::",
            stringify!(cb_sleep_end)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_t>())).cb_click as *const _ as usize },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_t),
            "::",
            stringify!(cb_click)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_t>())).cb_task_oneshot as *const _ as usize },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_t),
            "::",
            stringify!(cb_task_oneshot)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_t>())).cb_fkey as *const _ as usize },
        176usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_t),
            "::",
            stringify!(cb_fkey)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_t>())).user as *const _ as usize },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_t),
            "::",
            stringify!(user)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_t>())).term_raw as *const _ as usize },
        192usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_t),
            "::",
            stringify!(term_raw)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_t>())).term_buf as *const _ as usize },
        264usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_t),
            "::",
            stringify!(term_buf)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_t>())).num as *const _ as usize },
        336usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_t),
            "::",
            stringify!(num)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_t>())).pager as *const _ as usize },
        344usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_t),
            "::",
            stringify!(pager)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_t>())).blankline as *const _ as usize },
        352usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_t),
            "::",
            stringify!(blankline)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_t>())).highlight as *const _ as usize },
        360usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_t),
            "::",
            stringify!(highlight)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_t>())).enable_highlight as *const _ as usize },
        368usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_t),
            "::",
            stringify!(enable_highlight)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_t>())).null as *const _ as usize },
        372usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_t),
            "::",
            stringify!(null)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_t>())).mouse as *const _ as usize },
        376usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_t),
            "::",
            stringify!(mouse)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_t>())).is_wine as *const _ as usize },
        380usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_t),
            "::",
            stringify!(is_wine)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_t>())).line as *const _ as usize },
        384usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_t),
            "::",
            stringify!(line)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_t>())).vline as *const _ as usize },
        392usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_t),
            "::",
            stringify!(vline)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_t>())).refcnt as *const _ as usize },
        400usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_t),
            "::",
            stringify!(refcnt)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_t>())).newline as *const _ as usize },
        404usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_t),
            "::",
            stringify!(newline)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_t>())).vtmode as *const _ as usize },
        408usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_t),
            "::",
            stringify!(vtmode)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_t>())).flush as *const _ as usize },
        412usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_t),
            "::",
            stringify!(flush)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_t>())).use_utf8 as *const _ as usize },
        413usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_t),
            "::",
            stringify!(use_utf8)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_t>())).use_utf8_curvy as *const _ as usize },
        414usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_t),
            "::",
            stringify!(use_utf8_curvy)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_t>())).dotted_lines as *const _ as usize },
        415usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_t),
            "::",
            stringify!(dotted_lines)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_t>())).linesleep as *const _ as usize },
        416usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_t),
            "::",
            stringify!(linesleep)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_t>())).pagesize as *const _ as usize },
        420usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_t),
            "::",
            stringify!(pagesize)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_t>())).break_word as *const _ as usize },
        424usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_t),
            "::",
            stringify!(break_word)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_t>())).break_word_len as *const _ as usize },
        432usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_t),
            "::",
            stringify!(break_word_len)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_t>())).timeout as *const _ as usize },
        440usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_t),
            "::",
            stringify!(timeout)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_t>())).grep_color as *const _ as usize },
        448usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_t),
            "::",
            stringify!(grep_color)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_t>())).grep_highlight as *const _ as usize },
        449usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_t),
            "::",
            stringify!(grep_highlight)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_t>())).use_tts as *const _ as usize },
        450usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_t),
            "::",
            stringify!(use_tts)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_t>())).filter as *const _ as usize },
        451usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_t),
            "::",
            stringify!(filter)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_t>())).rgbstr as *const _ as usize },
        456usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_t),
            "::",
            stringify!(rgbstr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_t>())).click_set as *const _ as usize },
        464usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_t),
            "::",
            stringify!(click_set)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_t>())).click_x as *const _ as usize },
        468usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_t),
            "::",
            stringify!(click_x)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_t>())).click_y as *const _ as usize },
        472usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_t),
            "::",
            stringify!(click_y)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_t>())).show_vals as *const _ as usize },
        476usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_t),
            "::",
            stringify!(show_vals)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_t>())).cpos as *const _ as usize },
        480usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_t),
            "::",
            stringify!(cpos)
        )
    );
}
pub type RCons = r_cons_t;
pub const PAL_PROMPT: ::std::os::raw::c_uint = 0;
pub const PAL_ADDRESS: ::std::os::raw::c_uint = 1;
pub const PAL_DEFAULT: ::std::os::raw::c_uint = 2;
pub const PAL_CHANGED: ::std::os::raw::c_uint = 3;
pub const PAL_JUMP: ::std::os::raw::c_uint = 4;
pub const PAL_CALL: ::std::os::raw::c_uint = 5;
pub const PAL_PUSH: ::std::os::raw::c_uint = 6;
pub const PAL_TRAP: ::std::os::raw::c_uint = 7;
pub const PAL_CMP: ::std::os::raw::c_uint = 8;
pub const PAL_RET: ::std::os::raw::c_uint = 9;
pub const PAL_NOP: ::std::os::raw::c_uint = 10;
pub const PAL_METADATA: ::std::os::raw::c_uint = 11;
pub const PAL_HEADER: ::std::os::raw::c_uint = 12;
pub const PAL_PRINTABLE: ::std::os::raw::c_uint = 13;
pub const PAL_LINES0: ::std::os::raw::c_uint = 14;
pub const PAL_LINES1: ::std::os::raw::c_uint = 15;
pub const PAL_LINES2: ::std::os::raw::c_uint = 16;
pub const PAL_00: ::std::os::raw::c_uint = 17;
pub const PAL_7F: ::std::os::raw::c_uint = 18;
pub const PAL_FF: ::std::os::raw::c_uint = 19;
pub type _bindgen_ty_3 = ::std::os::raw::c_uint;
pub const LINE_NONE: ::std::os::raw::c_uint = 0;
pub const LINE_TRUE: ::std::os::raw::c_uint = 1;
pub const LINE_FALSE: ::std::os::raw::c_uint = 2;
pub const LINE_UNCJMP: ::std::os::raw::c_uint = 3;
pub const LINE_NOSYM_VERT: ::std::os::raw::c_uint = 4;
pub const LINE_NOSYM_HORIZ: ::std::os::raw::c_uint = 5;
pub type _bindgen_ty_4 = ::std::os::raw::c_uint;
pub const RViMode_INSERT_MODE: RViMode = 105;
pub const RViMode_CONTROL_MODE: RViMode = 99;
pub type RViMode = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_cons_canvas_line_style_t {
    pub color: ::std::os::raw::c_int,
    pub symbol: ::std::os::raw::c_int,
    pub dot_style: ::std::os::raw::c_int,
    pub ansicolor: *const ::std::os::raw::c_char,
}
#[test]
fn bindgen_test_layout_r_cons_canvas_line_style_t() {
    assert_eq!(
        ::std::mem::size_of::<r_cons_canvas_line_style_t>(),
        24usize,
        concat!("Size of: ", stringify!(r_cons_canvas_line_style_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_cons_canvas_line_style_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_cons_canvas_line_style_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_cons_canvas_line_style_t>())).color as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_canvas_line_style_t),
            "::",
            stringify!(color)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_cons_canvas_line_style_t>())).symbol as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_canvas_line_style_t),
            "::",
            stringify!(symbol)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_cons_canvas_line_style_t>())).dot_style as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_canvas_line_style_t),
            "::",
            stringify!(dot_style)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_cons_canvas_line_style_t>())).ansicolor as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_canvas_line_style_t),
            "::",
            stringify!(ansicolor)
        )
    );
}
pub type RCanvasLineStyle = r_cons_canvas_line_style_t;
extern "C" {
    pub fn r_cons_image(
        buf: *const ::std::os::raw::c_uchar,
        bufsz: ::std::os::raw::c_int,
        width: ::std::os::raw::c_int,
        mode: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn r_cons_canvas_new(
        w: ::std::os::raw::c_int,
        h: ::std::os::raw::c_int,
    ) -> *mut RConsCanvas;
}
extern "C" {
    pub fn r_cons_canvas_free(c: *mut RConsCanvas);
}
extern "C" {
    pub fn r_cons_canvas_clear(c: *mut RConsCanvas);
}
extern "C" {
    pub fn r_cons_canvas_print(c: *mut RConsCanvas);
}
extern "C" {
    pub fn r_cons_canvas_print_region(c: *mut RConsCanvas);
}
extern "C" {
    pub fn r_cons_canvas_to_string(c: *mut RConsCanvas) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_cons_canvas_attr(c: *mut RConsCanvas, attr: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn r_cons_canvas_write(c: *mut RConsCanvas, _s: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn r_cons_canvas_gotoxy(
        c: *mut RConsCanvas,
        x: ::std::os::raw::c_int,
        y: ::std::os::raw::c_int,
    ) -> bool;
}
extern "C" {
    pub fn r_cons_canvas_goto_write(
        c: *mut RConsCanvas,
        x: ::std::os::raw::c_int,
        y: ::std::os::raw::c_int,
        s: *const ::std::os::raw::c_char,
    );
}
extern "C" {
    pub fn r_cons_canvas_box(
        c: *mut RConsCanvas,
        x: ::std::os::raw::c_int,
        y: ::std::os::raw::c_int,
        w: ::std::os::raw::c_int,
        h: ::std::os::raw::c_int,
        color: *const ::std::os::raw::c_char,
    );
}
extern "C" {
    pub fn r_cons_canvas_circle(
        c: *mut RConsCanvas,
        x: ::std::os::raw::c_int,
        y: ::std::os::raw::c_int,
        w: ::std::os::raw::c_int,
        h: ::std::os::raw::c_int,
        color: *const ::std::os::raw::c_char,
    );
}
extern "C" {
    pub fn r_cons_canvas_line(
        c: *mut RConsCanvas,
        x: ::std::os::raw::c_int,
        y: ::std::os::raw::c_int,
        x2: ::std::os::raw::c_int,
        y2: ::std::os::raw::c_int,
        style: *mut RCanvasLineStyle,
    );
}
extern "C" {
    pub fn r_cons_canvas_line_diagonal(
        c: *mut RConsCanvas,
        x: ::std::os::raw::c_int,
        y: ::std::os::raw::c_int,
        x2: ::std::os::raw::c_int,
        y2: ::std::os::raw::c_int,
        style: *mut RCanvasLineStyle,
    );
}
extern "C" {
    pub fn r_cons_canvas_line_square(
        c: *mut RConsCanvas,
        x: ::std::os::raw::c_int,
        y: ::std::os::raw::c_int,
        x2: ::std::os::raw::c_int,
        y2: ::std::os::raw::c_int,
        style: *mut RCanvasLineStyle,
    );
}
extern "C" {
    pub fn r_cons_canvas_resize(
        c: *mut RConsCanvas,
        w: ::std::os::raw::c_int,
        h: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_cons_canvas_fill(
        c: *mut RConsCanvas,
        x: ::std::os::raw::c_int,
        y: ::std::os::raw::c_int,
        w: ::std::os::raw::c_int,
        h: ::std::os::raw::c_int,
        ch: ::std::os::raw::c_char,
    );
}
extern "C" {
    pub fn r_cons_canvas_line_square_defined(
        c: *mut RConsCanvas,
        x: ::std::os::raw::c_int,
        y: ::std::os::raw::c_int,
        x2: ::std::os::raw::c_int,
        y2: ::std::os::raw::c_int,
        style: *mut RCanvasLineStyle,
        bendpoint: ::std::os::raw::c_int,
        isvert: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn r_cons_canvas_line_back_edge(
        c: *mut RConsCanvas,
        x: ::std::os::raw::c_int,
        y: ::std::os::raw::c_int,
        x2: ::std::os::raw::c_int,
        y2: ::std::os::raw::c_int,
        style: *mut RCanvasLineStyle,
        ybendpoint1: ::std::os::raw::c_int,
        xbendpoint: ::std::os::raw::c_int,
        ybendpoint2: ::std::os::raw::c_int,
        isvert: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn r_cons_new() -> *mut RCons;
}
extern "C" {
    pub fn r_cons_singleton() -> *mut RCons;
}
extern "C" {
    pub fn r_cons_free() -> *mut RCons;
}
extern "C" {
    pub fn r_cons_lastline(size: *mut ::std::os::raw::c_int) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_cons_lastline_utf8_ansi_len(
        len: *mut ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_cons_set_click(x: ::std::os::raw::c_int, y: ::std::os::raw::c_int);
}
extern "C" {
    pub fn r_cons_get_click(x: *mut ::std::os::raw::c_int, y: *mut ::std::os::raw::c_int) -> bool;
}
pub type RConsBreak =
    ::std::option::Option<unsafe extern "C" fn(arg1: *mut ::std::os::raw::c_void)>;
extern "C" {
    pub fn r_cons_is_breaked() -> bool;
}
extern "C" {
    pub fn r_cons_was_breaked() -> bool;
}
extern "C" {
    pub fn r_cons_is_interactive() -> bool;
}
extern "C" {
    pub fn r_cons_default_context_is_interactive() -> bool;
}
extern "C" {
    pub fn r_cons_sleep_begin() -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn r_cons_sleep_end(user: *mut ::std::os::raw::c_void);
}
extern "C" {
    pub fn r_cons_break_push(cb: RConsBreak, user: *mut ::std::os::raw::c_void);
}
extern "C" {
    pub fn r_cons_break_pop();
}
extern "C" {
    pub fn r_cons_break_clear();
}
extern "C" {
    pub fn r_cons_breakword(s: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn r_cons_break_end();
}
extern "C" {
    pub fn r_cons_break_timeout(timeout: ::std::os::raw::c_int);
}
extern "C" {
    pub fn r_cons_pipe_open(
        file: *const ::std::os::raw::c_char,
        fdn: ::std::os::raw::c_int,
        append: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_cons_pipe_close(fd: ::std::os::raw::c_int);
}
pub const R_CONS_ERRMODE_NULL: ::std::os::raw::c_uint = 0;
pub const R_CONS_ERRMODE_QUIET: ::std::os::raw::c_uint = 1;
pub const R_CONS_ERRMODE_ECHO: ::std::os::raw::c_uint = 2;
pub const R_CONS_ERRMODE_BUFFER: ::std::os::raw::c_uint = 3;
pub const R_CONS_ERRMODE_FLUSH: ::std::os::raw::c_uint = 4;
pub type _bindgen_ty_5 = ::std::os::raw::c_uint;
extern "C" {
    pub fn r_cons_push();
}
extern "C" {
    pub fn r_cons_pop();
}
extern "C" {
    pub fn r_cons_context_new(parent: *mut RConsContext) -> *mut RConsContext;
}
extern "C" {
    pub fn r_cons_context_free(context: *mut RConsContext);
}
extern "C" {
    pub fn r_cons_context_load(context: *mut RConsContext);
}
extern "C" {
    pub fn r_cons_context_reset();
}
extern "C" {
    pub fn r_cons_context_is_main() -> bool;
}
extern "C" {
    pub fn r_cons_context_break(context: *mut RConsContext);
}
extern "C" {
    pub fn r_cons_context_break_push(
        context: *mut RConsContext,
        cb: RConsBreak,
        user: *mut ::std::os::raw::c_void,
        sig: bool,
    );
}
extern "C" {
    pub fn r_cons_context_break_pop(context: *mut RConsContext, sig: bool);
}
extern "C" {
    pub fn r_cons_editor(
        file: *const ::std::os::raw::c_char,
        str_: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_cons_reset();
}
extern "C" {
    pub fn r_cons_reset_colors();
}
extern "C" {
    pub fn r_cons_errstr() -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_cons_errmode(mode: ::std::os::raw::c_int);
}
extern "C" {
    pub fn r_cons_errmodes(mode: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn r_cons_eprintf(format: *const ::std::os::raw::c_char, ...) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_cons_eflush();
}
extern "C" {
    pub fn r_cons_print_clear();
}
extern "C" {
    pub fn r_cons_echo(msg: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn r_cons_zero();
}
extern "C" {
    pub fn r_cons_highlight(word: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn r_cons_clear();
}
extern "C" {
    pub fn r_cons_clear_buffer();
}
extern "C" {
    pub fn r_cons_clear00();
}
extern "C" {
    pub fn r_cons_clear_line(err: ::std::os::raw::c_int);
}
extern "C" {
    pub fn r_cons_fill_line();
}
extern "C" {
    pub fn r_cons_stdout_open(file: *const ::std::os::raw::c_char, append: ::std::os::raw::c_int);
}
extern "C" {
    pub fn r_cons_stdout_set_fd(fd: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_cons_gotoxy(x: ::std::os::raw::c_int, y: ::std::os::raw::c_int);
}
extern "C" {
    pub fn r_cons_get_cur_line() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_cons_line(
        x: ::std::os::raw::c_int,
        y: ::std::os::raw::c_int,
        x2: ::std::os::raw::c_int,
        y2: ::std::os::raw::c_int,
        ch: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn r_cons_show_cursor(cursor: ::std::os::raw::c_int);
}
extern "C" {
    pub fn r_cons_swap_ground(col: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_cons_drop(n: ::std::os::raw::c_int) -> bool;
}
extern "C" {
    pub fn r_cons_chop();
}
extern "C" {
    pub fn r_cons_set_raw(b: bool);
}
extern "C" {
    pub fn r_cons_set_interactive(b: bool);
}
extern "C" {
    pub fn r_cons_set_last_interactive();
}
extern "C" {
    pub fn r_cons_set_utf8(b: bool);
}
extern "C" {
    pub fn r_cons_grep(grep: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn r_cons_printf(format: *const ::std::os::raw::c_char, ...) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_cons_printf_list(format: *const ::std::os::raw::c_char, ap: *mut __va_list_tag);
}
extern "C" {
    pub fn r_cons_strcat(str_: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn r_cons_strcat_at(
        str_: *const ::std::os::raw::c_char,
        x: ::std::os::raw::c_int,
        y: ::std::os::raw::c_char,
        w: ::std::os::raw::c_int,
        h: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn r_cons_println(str_: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn r_cons_strcat_justify(
        str_: *const ::std::os::raw::c_char,
        j: ::std::os::raw::c_int,
        c: ::std::os::raw::c_char,
    );
}
extern "C" {
    pub fn r_cons_printat(
        str_: *const ::std::os::raw::c_char,
        x: ::std::os::raw::c_int,
        y: ::std::os::raw::c_char,
    );
}
extern "C" {
    pub fn r_cons_write(
        str_: *const ::std::os::raw::c_char,
        len: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_cons_newline();
}
extern "C" {
    pub fn r_cons_filter();
}
extern "C" {
    pub fn r_cons_flush();
}
extern "C" {
    pub fn r_cons_print_fps(col: ::std::os::raw::c_int);
}
extern "C" {
    pub fn r_cons_last();
}
extern "C" {
    pub fn r_cons_less_str(
        str_: *const ::std::os::raw::c_char,
        exitkeys: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_cons_less();
}
extern "C" {
    pub fn r_cons_2048(color: bool);
}
extern "C" {
    pub fn r_cons_memset(ch: ::std::os::raw::c_char, len: ::std::os::raw::c_int);
}
extern "C" {
    pub fn r_cons_visual_flush();
}
extern "C" {
    pub fn r_cons_visual_write(buffer: *mut ::std::os::raw::c_char);
}
extern "C" {
    pub fn r_cons_is_utf8() -> bool;
}
extern "C" {
    pub fn r_cons_cmd_help(help: *mut *const ::std::os::raw::c_char, use_color: bool);
}
extern "C" {
    pub fn r_cons_log_stub(
        output: *const ::std::os::raw::c_char,
        funcname: *const ::std::os::raw::c_char,
        filename: *const ::std::os::raw::c_char,
        lineno: ::std::os::raw::c_uint,
        level: ::std::os::raw::c_uint,
        tag: *const ::std::os::raw::c_char,
        fmtstr: *const ::std::os::raw::c_char,
        ...
    );
}
extern "C" {
    pub fn r_cons_controlz(ch: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_cons_readchar() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_cons_readpush(str_: *const ::std::os::raw::c_char, len: ::std::os::raw::c_int)
        -> bool;
}
extern "C" {
    pub fn r_cons_readflush();
}
extern "C" {
    pub fn r_cons_switchbuf(active: bool);
}
extern "C" {
    pub fn r_cons_readchar_timeout(usec: ::std::os::raw::c_uint) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_cons_any_key(msg: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_cons_eof() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_cons_palette_init(pal: *const ::std::os::raw::c_uchar) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_cons_pal_set(
        key: *const ::std::os::raw::c_char,
        val: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_cons_pal_update_event();
}
extern "C" {
    pub fn r_cons_pal_free(ctx: *mut RConsContext);
}
extern "C" {
    pub fn r_cons_pal_init(ctx: *mut RConsContext);
}
extern "C" {
    pub fn r_cons_pal_copy(dst: *mut RConsContext, src: *mut RConsContext);
}
extern "C" {
    pub fn r_cons_pal_parse(
        str_: *const ::std::os::raw::c_char,
        outcol: *mut RColor,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_cons_pal_random();
}
extern "C" {
    pub fn r_cons_pal_get(key: *const ::std::os::raw::c_char) -> RColor;
}
extern "C" {
    pub fn r_cons_pal_get_i(index: ::std::os::raw::c_int) -> RColor;
}
extern "C" {
    pub fn r_cons_pal_get_name(index: ::std::os::raw::c_int) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_cons_pal_len() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_cons_rgb_parse(
        p: *const ::std::os::raw::c_char,
        r: *mut ::std::os::raw::c_uchar,
        g: *mut ::std::os::raw::c_uchar,
        b: *mut ::std::os::raw::c_uchar,
        a: *mut ::std::os::raw::c_uchar,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_cons_rgb_tostring(
        r: ::std::os::raw::c_uchar,
        g: ::std::os::raw::c_uchar,
        b: ::std::os::raw::c_uchar,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_cons_pal_list(rad: ::std::os::raw::c_int, arg: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn r_cons_pal_show();
}
extern "C" {
    pub fn r_cons_get_size(rows: *mut ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_cons_isatty() -> bool;
}
extern "C" {
    pub fn r_cons_get_cursor(rows: *mut ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_cons_arrow_to_hjkl(ch: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_cons_html_filter(
        ptr: *const ::std::os::raw::c_char,
        newlen: *mut ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_cons_rainbow_get(
        idx: ::std::os::raw::c_int,
        last: ::std::os::raw::c_int,
        bg: bool,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_cons_rainbow_free(ctx: *mut RConsContext);
}
extern "C" {
    pub fn r_cons_rainbow_new(ctx: *mut RConsContext, sz: ::std::os::raw::c_int);
}
extern "C" {
    pub fn r_cons_fgets(
        buf: *mut ::std::os::raw::c_char,
        len: ::std::os::raw::c_int,
        argc: ::std::os::raw::c_int,
        argv: *mut *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_cons_hud(
        list: *mut RList,
        prompt: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_cons_hud_line(
        list: *mut RList,
        prompt: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_cons_hud_line_string(s: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_cons_hud_path(
        path: *const ::std::os::raw::c_char,
        dir: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_cons_hud_string(s: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_cons_hud_file(f: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_cons_get_buffer() -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_cons_get_buffer_len() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_cons_grep_help();
}
extern "C" {
    pub fn r_cons_grep_parsecmd(
        cmd: *mut ::std::os::raw::c_char,
        quotestr: *const ::std::os::raw::c_char,
    );
}
extern "C" {
    pub fn r_cons_grep_strip(
        cmd: *mut ::std::os::raw::c_char,
        quotestr: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_cons_grep_process(grep: *mut ::std::os::raw::c_char);
}
extern "C" {
    pub fn r_cons_grep_line(
        buf: *mut ::std::os::raw::c_char,
        len: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_cons_grepbuf();
}
extern "C" {
    pub fn r_cons_rgb(
        r: ::std::os::raw::c_uchar,
        g: ::std::os::raw::c_uchar,
        b: ::std::os::raw::c_uchar,
        a: ::std::os::raw::c_uchar,
    );
}
extern "C" {
    pub fn r_cons_rgb_fgbg(
        r: ::std::os::raw::c_uchar,
        g: ::std::os::raw::c_uchar,
        b: ::std::os::raw::c_uchar,
        R: ::std::os::raw::c_uchar,
        G: ::std::os::raw::c_uchar,
        B: ::std::os::raw::c_uchar,
    );
}
extern "C" {
    pub fn r_cons_rgb_init();
}
extern "C" {
    pub fn r_cons_rgb_str_mode(
        mode: RConsColorMode,
        outstr: *mut ::std::os::raw::c_char,
        sz: size_t,
        rcolor: *mut RColor,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_cons_rgb_str(
        outstr: *mut ::std::os::raw::c_char,
        sz: size_t,
        rcolor: *mut RColor,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_cons_rgb_str_off(
        outstr: *mut ::std::os::raw::c_char,
        sz: size_t,
        off: ::std::os::raw::c_ulonglong,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_cons_color(
        fg: ::std::os::raw::c_int,
        r: ::std::os::raw::c_int,
        g: ::std::os::raw::c_int,
        b: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn r_cons_color_random(alpha: ::std::os::raw::c_uchar) -> RColor;
}
extern "C" {
    pub fn r_cons_invert(set: ::std::os::raw::c_int, color: ::std::os::raw::c_int);
}
extern "C" {
    pub fn r_cons_yesno(
        def: ::std::os::raw::c_int,
        fmt: *const ::std::os::raw::c_char,
        ...
    ) -> bool;
}
extern "C" {
    pub fn r_cons_input(msg: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_cons_password(msg: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_cons_set_cup(enable: bool) -> bool;
}
extern "C" {
    pub fn r_cons_column(c: ::std::os::raw::c_int);
}
extern "C" {
    pub fn r_cons_get_column() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_cons_message(msg: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_cons_set_title(str_: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn r_cons_enable_mouse(enable: bool) -> bool;
}
extern "C" {
    pub fn r_cons_enable_highlight(enable: bool);
}
extern "C" {
    pub fn r_cons_bind(bind: *mut RConsBind);
}
extern "C" {
    pub fn r_cons_get_rune(ch: ::std::os::raw::c_uchar) -> *const ::std::os::raw::c_char;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RConsPixel {
    pub w: ::std::os::raw::c_int,
    pub h: ::std::os::raw::c_int,
    pub buf: *mut ::std::os::raw::c_uchar,
    pub buf_size: size_t,
}
#[test]
fn bindgen_test_layout_RConsPixel() {
    assert_eq!(
        ::std::mem::size_of::<RConsPixel>(),
        24usize,
        concat!("Size of: ", stringify!(RConsPixel))
    );
    assert_eq!(
        ::std::mem::align_of::<RConsPixel>(),
        8usize,
        concat!("Alignment of ", stringify!(RConsPixel))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RConsPixel>())).w as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(RConsPixel),
            "::",
            stringify!(w)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RConsPixel>())).h as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(RConsPixel),
            "::",
            stringify!(h)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RConsPixel>())).buf as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(RConsPixel),
            "::",
            stringify!(buf)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RConsPixel>())).buf_size as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(RConsPixel),
            "::",
            stringify!(buf_size)
        )
    );
}
extern "C" {
    pub fn r_cons_pixel_new(w: ::std::os::raw::c_int, h: ::std::os::raw::c_int) -> *mut RConsPixel;
}
extern "C" {
    pub fn r_cons_pixel_free(p: *mut RConsPixel);
}
extern "C" {
    pub fn r_cons_pixel_flush(
        p: *mut RConsPixel,
        sx: ::std::os::raw::c_int,
        sy: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn r_cons_pixel_drain(p: *mut RConsPixel) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_cons_pixel_set(
        p: *mut RConsPixel,
        x: ::std::os::raw::c_int,
        y: ::std::os::raw::c_int,
        v: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn r_cons_pixel_sets(
        p: *mut RConsPixel,
        x: ::std::os::raw::c_int,
        y: ::std::os::raw::c_int,
        s: *const ::std::os::raw::c_char,
    );
}
extern "C" {
    pub fn r_cons_pixel_fill(
        p: *mut RConsPixel,
        _x: ::std::os::raw::c_int,
        _y: ::std::os::raw::c_int,
        w: ::std::os::raw::c_int,
        h: ::std::os::raw::c_int,
        v: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn r_cons_pixel_tostring(p: *mut RConsPixel) -> *mut ::std::os::raw::c_char;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_selection_widget_t {
    pub options: *mut *const ::std::os::raw::c_char,
    pub options_len: ::std::os::raw::c_int,
    pub selection: ::std::os::raw::c_int,
    pub w: ::std::os::raw::c_int,
    pub h: ::std::os::raw::c_int,
    pub scroll: ::std::os::raw::c_int,
    pub complete_common: bool,
    pub direction: bool,
}
#[test]
fn bindgen_test_layout_r_selection_widget_t() {
    assert_eq!(
        ::std::mem::size_of::<r_selection_widget_t>(),
        32usize,
        concat!("Size of: ", stringify!(r_selection_widget_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_selection_widget_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_selection_widget_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_selection_widget_t>())).options as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_selection_widget_t),
            "::",
            stringify!(options)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_selection_widget_t>())).options_len as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_selection_widget_t),
            "::",
            stringify!(options_len)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_selection_widget_t>())).selection as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(r_selection_widget_t),
            "::",
            stringify!(selection)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_selection_widget_t>())).w as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(r_selection_widget_t),
            "::",
            stringify!(w)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_selection_widget_t>())).h as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(r_selection_widget_t),
            "::",
            stringify!(h)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_selection_widget_t>())).scroll as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(r_selection_widget_t),
            "::",
            stringify!(scroll)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_selection_widget_t>())).complete_common as *const _ as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(r_selection_widget_t),
            "::",
            stringify!(complete_common)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_selection_widget_t>())).direction as *const _ as usize },
        29usize,
        concat!(
            "Offset of field: ",
            stringify!(r_selection_widget_t),
            "::",
            stringify!(direction)
        )
    );
}
pub type RSelWidget = r_selection_widget_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_line_hist_t {
    pub data: *mut *mut ::std::os::raw::c_char,
    pub match_: *mut ::std::os::raw::c_char,
    pub size: ::std::os::raw::c_int,
    pub index: ::std::os::raw::c_int,
    pub top: ::std::os::raw::c_int,
    pub autosave: ::std::os::raw::c_int,
    pub do_setup_match: bool,
}
#[test]
fn bindgen_test_layout_r_line_hist_t() {
    assert_eq!(
        ::std::mem::size_of::<r_line_hist_t>(),
        40usize,
        concat!("Size of: ", stringify!(r_line_hist_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_line_hist_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_line_hist_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_line_hist_t>())).data as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_line_hist_t),
            "::",
            stringify!(data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_line_hist_t>())).match_ as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_line_hist_t),
            "::",
            stringify!(match_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_line_hist_t>())).size as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(r_line_hist_t),
            "::",
            stringify!(size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_line_hist_t>())).index as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(r_line_hist_t),
            "::",
            stringify!(index)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_line_hist_t>())).top as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(r_line_hist_t),
            "::",
            stringify!(top)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_line_hist_t>())).autosave as *const _ as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(r_line_hist_t),
            "::",
            stringify!(autosave)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_line_hist_t>())).do_setup_match as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(r_line_hist_t),
            "::",
            stringify!(do_setup_match)
        )
    );
}
pub type RLineHistory = r_line_hist_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_line_buffer_t {
    pub data: [::std::os::raw::c_char; 4096usize],
    pub index: ::std::os::raw::c_int,
    pub length: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_r_line_buffer_t() {
    assert_eq!(
        ::std::mem::size_of::<r_line_buffer_t>(),
        4104usize,
        concat!("Size of: ", stringify!(r_line_buffer_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_line_buffer_t>(),
        4usize,
        concat!("Alignment of ", stringify!(r_line_buffer_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_line_buffer_t>())).data as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_line_buffer_t),
            "::",
            stringify!(data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_line_buffer_t>())).index as *const _ as usize },
        4096usize,
        concat!(
            "Offset of field: ",
            stringify!(r_line_buffer_t),
            "::",
            stringify!(index)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_line_buffer_t>())).length as *const _ as usize },
        4100usize,
        concat!(
            "Offset of field: ",
            stringify!(r_line_buffer_t),
            "::",
            stringify!(length)
        )
    );
}
pub type RLineBuffer = r_line_buffer_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_hud_t {
    pub current_entry_n: ::std::os::raw::c_int,
    pub top_entry_n: ::std::os::raw::c_int,
    pub activate: ::std::os::raw::c_char,
    pub vi: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_r_hud_t() {
    assert_eq!(
        ::std::mem::size_of::<r_hud_t>(),
        16usize,
        concat!("Size of: ", stringify!(r_hud_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_hud_t>(),
        4usize,
        concat!("Alignment of ", stringify!(r_hud_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_hud_t>())).current_entry_n as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_hud_t),
            "::",
            stringify!(current_entry_n)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_hud_t>())).top_entry_n as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(r_hud_t),
            "::",
            stringify!(top_entry_n)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_hud_t>())).activate as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_hud_t),
            "::",
            stringify!(activate)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_hud_t>())).vi as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(r_hud_t),
            "::",
            stringify!(vi)
        )
    );
}
pub type RLineHud = r_hud_t;
pub type RLine = r_line_t;
pub type RLineCompletion = r_line_comp_t;
pub const RLinePromptType_R_LINE_PROMPT_DEFAULT: RLinePromptType = 0;
pub const RLinePromptType_R_LINE_PROMPT_OFFSET: RLinePromptType = 1;
pub const RLinePromptType_R_LINE_PROMPT_FILE: RLinePromptType = 2;
pub type RLinePromptType = ::std::os::raw::c_uint;
pub type RLineCompletionCb = ::std::option::Option<
    unsafe extern "C" fn(
        completion: *mut RLineCompletion,
        buf: *mut RLineBuffer,
        prompt_type: RLinePromptType,
        user: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int,
>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_line_comp_t {
    pub opt: bool,
    pub args_limit: size_t,
    pub quit: bool,
    pub args: RPVector,
    pub run: RLineCompletionCb,
    pub run_user: *mut ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout_r_line_comp_t() {
    assert_eq!(
        ::std::mem::size_of::<r_line_comp_t>(),
        88usize,
        concat!("Size of: ", stringify!(r_line_comp_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_line_comp_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_line_comp_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_line_comp_t>())).opt as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_line_comp_t),
            "::",
            stringify!(opt)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_line_comp_t>())).args_limit as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_line_comp_t),
            "::",
            stringify!(args_limit)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_line_comp_t>())).quit as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(r_line_comp_t),
            "::",
            stringify!(quit)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_line_comp_t>())).args as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(r_line_comp_t),
            "::",
            stringify!(args)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_line_comp_t>())).run as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(r_line_comp_t),
            "::",
            stringify!(run)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_line_comp_t>())).run_user as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(r_line_comp_t),
            "::",
            stringify!(run_user)
        )
    );
}
pub type RLineEditorCb = ::std::option::Option<
    unsafe extern "C" fn(
        core: *mut ::std::os::raw::c_void,
        str_: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char,
>;
pub type RLineHistoryUpCb =
    ::std::option::Option<unsafe extern "C" fn(line: *mut RLine) -> ::std::os::raw::c_int>;
pub type RLineHistoryDownCb =
    ::std::option::Option<unsafe extern "C" fn(line: *mut RLine) -> ::std::os::raw::c_int>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_line_t {
    pub completion: RLineCompletion,
    pub buffer: RLineBuffer,
    pub history: RLineHistory,
    pub sel_widget: *mut RSelWidget,
    pub cb_history_up: RLineHistoryUpCb,
    pub cb_history_down: RLineHistoryDownCb,
    pub cb_editor: RLineEditorCb,
    pub cb_fkey: RConsFunctionKey,
    pub echo: bool,
    pub prompt: *mut ::std::os::raw::c_char,
    pub kill_ring: *mut RList,
    pub kill_ring_ptr: ::std::os::raw::c_int,
    pub clipboard: *mut ::std::os::raw::c_char,
    pub disable: bool,
    pub user: *mut ::std::os::raw::c_void,
    pub histfilter: bool,
    pub hist_up: ::std::option::Option<
        unsafe extern "C" fn(user: *mut ::std::os::raw::c_void) -> ::std::os::raw::c_int,
    >,
    pub hist_down: ::std::option::Option<
        unsafe extern "C" fn(user: *mut ::std::os::raw::c_void) -> ::std::os::raw::c_int,
    >,
    pub contents: *mut ::std::os::raw::c_char,
    pub zerosep: bool,
    pub enable_vi_mode: bool,
    pub vi_mode: ::std::os::raw::c_int,
    pub prompt_mode: bool,
    pub prompt_type: RLinePromptType,
    pub offset_hist_index: ::std::os::raw::c_int,
    pub file_hist_index: ::std::os::raw::c_int,
    pub hud: *mut RLineHud,
    pub sdbshell_hist: *mut RList,
    pub sdbshell_hist_iter: *mut RListIter,
    pub vtmode: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_r_line_t() {
    assert_eq!(
        ::std::mem::size_of::<r_line_t>(),
        4416usize,
        concat!("Size of: ", stringify!(r_line_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_line_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_line_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_line_t>())).completion as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_line_t),
            "::",
            stringify!(completion)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_line_t>())).buffer as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(r_line_t),
            "::",
            stringify!(buffer)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_line_t>())).history as *const _ as usize },
        4192usize,
        concat!(
            "Offset of field: ",
            stringify!(r_line_t),
            "::",
            stringify!(history)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_line_t>())).sel_widget as *const _ as usize },
        4232usize,
        concat!(
            "Offset of field: ",
            stringify!(r_line_t),
            "::",
            stringify!(sel_widget)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_line_t>())).cb_history_up as *const _ as usize },
        4240usize,
        concat!(
            "Offset of field: ",
            stringify!(r_line_t),
            "::",
            stringify!(cb_history_up)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_line_t>())).cb_history_down as *const _ as usize },
        4248usize,
        concat!(
            "Offset of field: ",
            stringify!(r_line_t),
            "::",
            stringify!(cb_history_down)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_line_t>())).cb_editor as *const _ as usize },
        4256usize,
        concat!(
            "Offset of field: ",
            stringify!(r_line_t),
            "::",
            stringify!(cb_editor)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_line_t>())).cb_fkey as *const _ as usize },
        4264usize,
        concat!(
            "Offset of field: ",
            stringify!(r_line_t),
            "::",
            stringify!(cb_fkey)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_line_t>())).echo as *const _ as usize },
        4272usize,
        concat!(
            "Offset of field: ",
            stringify!(r_line_t),
            "::",
            stringify!(echo)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_line_t>())).prompt as *const _ as usize },
        4280usize,
        concat!(
            "Offset of field: ",
            stringify!(r_line_t),
            "::",
            stringify!(prompt)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_line_t>())).kill_ring as *const _ as usize },
        4288usize,
        concat!(
            "Offset of field: ",
            stringify!(r_line_t),
            "::",
          