/* automatically generated by rust-bindgen 0.59.2 */

#[repr(C)]
#[derive(Copy, Clone, Debug, Default, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct __BindgenBitfieldUnit<Storage> {
    storage: Storage,
}
impl<Storage> __BindgenBitfieldUnit<Storage> {
    #[inline]
    pub const fn new(storage: Storage) -> Self {
        Self { storage }
    }
}
impl<Storage> __BindgenBitfieldUnit<Storage>
where
    Storage: AsRef<[u8]> + AsMut<[u8]>,
{
    #[inline]
    pub fn get_bit(&self, index: usize) -> bool {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = self.storage.as_ref()[byte_index];
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        byte & mask == mask
    }
    #[inline]
    pub fn set_bit(&mut self, index: usize, val: bool) {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = &mut self.storage.as_mut()[byte_index];
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        if val {
            *byte |= mask;
        } else {
            *byte &= !mask;
        }
    }
    #[inline]
    pub fn get(&self, bit_offset: usize, bit_width: u8) -> u64 {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        let mut val = 0;
        for i in 0..(bit_width as usize) {
            if self.get_bit(i + bit_offset) {
                let index = if cfg!(target_endian = "big") {
                    bit_width as usize - 1 - i
                } else {
                    i
                };
                val |= 1 << index;
            }
        }
        val
    }
    #[inline]
    pub fn set(&mut self, bit_offset: usize, bit_width: u8, val: u64) {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        for i in 0..(bit_width as usize) {
            let mask = 1 << i;
            let val_bit_is_set = val & mask == mask;
            let index = if cfg!(target_endian = "big") {
                bit_width as usize - 1 - i
            } else {
                i
            };
            self.set_bit(index + bit_offset, val_bit_is_set);
        }
    }
}
pub type __int8_t = ::std::os::raw::c_schar;
pub type __uint8_t = ::std::os::raw::c_uchar;
pub type __uint16_t = ::std::os::raw::c_ushort;
pub type __int32_t = ::std::os::raw::c_int;
pub type __uint32_t = ::std::os::raw::c_uint;
pub type __int64_t = ::std::os::raw::c_long;
pub type __uint64_t = ::std::os::raw::c_ulong;
pub type __off_t = ::std::os::raw::c_long;
pub type __off64_t = ::std::os::raw::c_long;
pub type __pid_t = ::std::os::raw::c_int;
pub type __time_t = ::std::os::raw::c_long;
pub type __suseconds_t = ::std::os::raw::c_long;
pub type pid_t = __pid_t;
pub type time_t = __time_t;
pub type size_t = ::std::os::raw::c_ulong;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __sigset_t {
    pub __val: [::std::os::raw::c_ulong; 16usize],
}
#[test]
fn bindgen_test_layout___sigset_t() {
    assert_eq!(
        ::std::mem::size_of::<__sigset_t>(),
        128usize,
        concat!("Size of: ", stringify!(__sigset_t))
    );
    assert_eq!(
        ::std::mem::align_of::<__sigset_t>(),
        8usize,
        concat!("Alignment of ", stringify!(__sigset_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sigset_t>())).__val as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__sigset_t),
            "::",
            stringify!(__val)
        )
    );
}
pub type sigset_t = __sigset_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct timeval {
    pub tv_sec: __time_t,
    pub tv_usec: __suseconds_t,
}
#[test]
fn bindgen_test_layout_timeval() {
    assert_eq!(
        ::std::mem::size_of::<timeval>(),
        16usize,
        concat!("Size of: ", stringify!(timeval))
    );
    assert_eq!(
        ::std::mem::align_of::<timeval>(),
        8usize,
        concat!("Alignment of ", stringify!(timeval))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<timeval>())).tv_sec as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(timeval),
            "::",
            stringify!(tv_sec)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<timeval>())).tv_usec as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(timeval),
            "::",
            stringify!(tv_usec)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __pthread_internal_list {
    pub __prev: *mut __pthread_internal_list,
    pub __next: *mut __pthread_internal_list,
}
#[test]
fn bindgen_test_layout___pthread_internal_list() {
    assert_eq!(
        ::std::mem::size_of::<__pthread_internal_list>(),
        16usize,
        concat!("Size of: ", stringify!(__pthread_internal_list))
    );
    assert_eq!(
        ::std::mem::align_of::<__pthread_internal_list>(),
        8usize,
        concat!("Alignment of ", stringify!(__pthread_internal_list))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_internal_list>())).__prev as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_internal_list),
            "::",
            stringify!(__prev)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_internal_list>())).__next as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_internal_list),
            "::",
            stringify!(__next)
        )
    );
}
pub type __pthread_list_t = __pthread_internal_list;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __pthread_mutex_s {
    pub __lock: ::std::os::raw::c_int,
    pub __count: ::std::os::raw::c_uint,
    pub __owner: ::std::os::raw::c_int,
    pub __nusers: ::std::os::raw::c_uint,
    pub __kind: ::std::os::raw::c_int,
    pub __spins: ::std::os::raw::c_short,
    pub __elision: ::std::os::raw::c_short,
    pub __list: __pthread_list_t,
}
#[test]
fn bindgen_test_layout___pthread_mutex_s() {
    assert_eq!(
        ::std::mem::size_of::<__pthread_mutex_s>(),
        40usize,
        concat!("Size of: ", stringify!(__pthread_mutex_s))
    );
    assert_eq!(
        ::std::mem::align_of::<__pthread_mutex_s>(),
        8usize,
        concat!("Alignment of ", stringify!(__pthread_mutex_s))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_mutex_s>())).__lock as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_mutex_s),
            "::",
            stringify!(__lock)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_mutex_s>())).__count as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_mutex_s),
            "::",
            stringify!(__count)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_mutex_s>())).__owner as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_mutex_s),
            "::",
            stringify!(__owner)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_mutex_s>())).__nusers as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_mutex_s),
            "::",
            stringify!(__nusers)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_mutex_s>())).__kind as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_mutex_s),
            "::",
            stringify!(__kind)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_mutex_s>())).__spins as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_mutex_s),
            "::",
            stringify!(__spins)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_mutex_s>())).__elision as *const _ as usize },
        22usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_mutex_s),
            "::",
            stringify!(__elision)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_mutex_s>())).__list as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_mutex_s),
            "::",
            stringify!(__list)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct __pthread_cond_s {
    pub __bindgen_anon_1: __pthread_cond_s__bindgen_ty_1,
    pub __bindgen_anon_2: __pthread_cond_s__bindgen_ty_2,
    pub __g_refs: [::std::os::raw::c_uint; 2usize],
    pub __g_size: [::std::os::raw::c_uint; 2usize],
    pub __g1_orig_size: ::std::os::raw::c_uint,
    pub __wrefs: ::std::os::raw::c_uint,
    pub __g_signals: [::std::os::raw::c_uint; 2usize],
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union __pthread_cond_s__bindgen_ty_1 {
    pub __wseq: ::std::os::raw::c_ulonglong,
    pub __wseq32: __pthread_cond_s__bindgen_ty_1__bindgen_ty_1,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __pthread_cond_s__bindgen_ty_1__bindgen_ty_1 {
    pub __low: ::std::os::raw::c_uint,
    pub __high: ::std::os::raw::c_uint,
}
#[test]
fn bindgen_test_layout___pthread_cond_s__bindgen_ty_1__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<__pthread_cond_s__bindgen_ty_1__bindgen_ty_1>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__pthread_cond_s__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__pthread_cond_s__bindgen_ty_1__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(__pthread_cond_s__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__pthread_cond_s__bindgen_ty_1__bindgen_ty_1>())).__low
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_cond_s__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(__low)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__pthread_cond_s__bindgen_ty_1__bindgen_ty_1>())).__high
                as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_cond_s__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(__high)
        )
    );
}
#[test]
fn bindgen_test_layout___pthread_cond_s__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<__pthread_cond_s__bindgen_ty_1>(),
        8usize,
        concat!("Size of: ", stringify!(__pthread_cond_s__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<__pthread_cond_s__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(__pthread_cond_s__bindgen_ty_1))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__pthread_cond_s__bindgen_ty_1>())).__wseq as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_cond_s__bindgen_ty_1),
            "::",
            stringify!(__wseq)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__pthread_cond_s__bindgen_ty_1>())).__wseq32 as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_cond_s__bindgen_ty_1),
            "::",
            stringify!(__wseq32)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union __pthread_cond_s__bindgen_ty_2 {
    pub __g1_start: ::std::os::raw::c_ulonglong,
    pub __g1_start32: __pthread_cond_s__bindgen_ty_2__bindgen_ty_1,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __pthread_cond_s__bindgen_ty_2__bindgen_ty_1 {
    pub __low: ::std::os::raw::c_uint,
    pub __high: ::std::os::raw::c_uint,
}
#[test]
fn bindgen_test_layout___pthread_cond_s__bindgen_ty_2__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<__pthread_cond_s__bindgen_ty_2__bindgen_ty_1>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__pthread_cond_s__bindgen_ty_2__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__pthread_cond_s__bindgen_ty_2__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(__pthread_cond_s__bindgen_ty_2__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__pthread_cond_s__bindgen_ty_2__bindgen_ty_1>())).__low
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_cond_s__bindgen_ty_2__bindgen_ty_1),
            "::",
            stringify!(__low)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__pthread_cond_s__bindgen_ty_2__bindgen_ty_1>())).__high
                as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_cond_s__bindgen_ty_2__bindgen_ty_1),
            "::",
            stringify!(__high)
        )
    );
}
#[test]
fn bindgen_test_layout___pthread_cond_s__bindgen_ty_2() {
    assert_eq!(
        ::std::mem::size_of::<__pthread_cond_s__bindgen_ty_2>(),
        8usize,
        concat!("Size of: ", stringify!(__pthread_cond_s__bindgen_ty_2))
    );
    assert_eq!(
        ::std::mem::align_of::<__pthread_cond_s__bindgen_ty_2>(),
        8usize,
        concat!("Alignment of ", stringify!(__pthread_cond_s__bindgen_ty_2))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__pthread_cond_s__bindgen_ty_2>())).__g1_start as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_cond_s__bindgen_ty_2),
            "::",
            stringify!(__g1_start)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__pthread_cond_s__bindgen_ty_2>())).__g1_start32 as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_cond_s__bindgen_ty_2),
            "::",
            stringify!(__g1_start32)
        )
    );
}
#[test]
fn bindgen_test_layout___pthread_cond_s() {
    assert_eq!(
        ::std::mem::size_of::<__pthread_cond_s>(),
        48usize,
        concat!("Size of: ", stringify!(__pthread_cond_s))
    );
    assert_eq!(
        ::std::mem::align_of::<__pthread_cond_s>(),
        8usize,
        concat!("Alignment of ", stringify!(__pthread_cond_s))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_cond_s>())).__g_refs as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_cond_s),
            "::",
            stringify!(__g_refs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_cond_s>())).__g_size as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_cond_s),
            "::",
            stringify!(__g_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_cond_s>())).__g1_orig_size as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_cond_s),
            "::",
            stringify!(__g1_orig_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_cond_s>())).__wrefs as *const _ as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_cond_s),
            "::",
            stringify!(__wrefs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_cond_s>())).__g_signals as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_cond_s),
            "::",
            stringify!(__g_signals)
        )
    );
}
pub type pthread_t = ::std::os::raw::c_ulong;
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_mutex_t {
    pub __data: __pthread_mutex_s,
    pub __size: [::std::os::raw::c_char; 40usize],
    pub __align: ::std::os::raw::c_long,
}
#[test]
fn bindgen_test_layout_pthread_mutex_t() {
    assert_eq!(
        ::std::mem::size_of::<pthread_mutex_t>(),
        40usize,
        concat!("Size of: ", stringify!(pthread_mutex_t))
    );
    assert_eq!(
        ::std::mem::align_of::<pthread_mutex_t>(),
        8usize,
        concat!("Alignment of ", stringify!(pthread_mutex_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_mutex_t>())).__data as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_mutex_t),
            "::",
            stringify!(__data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_mutex_t>())).__size as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_mutex_t),
            "::",
            stringify!(__size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_mutex_t>())).__align as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_mutex_t),
            "::",
            stringify!(__align)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_cond_t {
    pub __data: __pthread_cond_s,
    pub __size: [::std::os::raw::c_char; 48usize],
    pub __align: ::std::os::raw::c_longlong,
}
#[test]
fn bindgen_test_layout_pthread_cond_t() {
    assert_eq!(
        ::std::mem::size_of::<pthread_cond_t>(),
        48usize,
        concat!("Size of: ", stringify!(pthread_cond_t))
    );
    assert_eq!(
        ::std::mem::align_of::<pthread_cond_t>(),
        8usize,
        concat!("Alignment of ", stringify!(pthread_cond_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_cond_t>())).__data as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_cond_t),
            "::",
            stringify!(__data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_cond_t>())).__size as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_cond_t),
            "::",
            stringify!(__size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_cond_t>())).__align as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_cond_t),
            "::",
            stringify!(__align)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _ut80 {
    pub Low: u64,
    pub High: u16,
}
#[test]
fn bindgen_test_layout__ut80() {
    assert_eq!(
        ::std::mem::size_of::<_ut80>(),
        16usize,
        concat!("Size of: ", stringify!(_ut80))
    );
    assert_eq!(
        ::std::mem::align_of::<_ut80>(),
        8usize,
        concat!("Alignment of ", stringify!(_ut80))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_ut80>())).Low as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_ut80),
            "::",
            stringify!(Low)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_ut80>())).High as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_ut80),
            "::",
            stringify!(High)
        )
    );
}
pub type ut80 = _ut80;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _ut96 {
    pub Low: u64,
    pub High: u32,
}
#[test]
fn bindgen_test_layout__ut96() {
    assert_eq!(
        ::std::mem::size_of::<_ut96>(),
        16usize,
        concat!("Size of: ", stringify!(_ut96))
    );
    assert_eq!(
        ::std::mem::align_of::<_ut96>(),
        8usize,
        concat!("Alignment of ", stringify!(_ut96))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_ut96>())).Low as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_ut96),
            "::",
            stringify!(Low)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_ut96>())).High as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_ut96),
            "::",
            stringify!(High)
        )
    );
}
pub type ut96 = _ut96;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _ut128 {
    pub Low: u64,
    pub High: i64,
}
#[test]
fn bindgen_test_layout__ut128() {
    assert_eq!(
        ::std::mem::size_of::<_ut128>(),
        16usize,
        concat!("Size of: ", stringify!(_ut128))
    );
    assert_eq!(
        ::std::mem::align_of::<_ut128>(),
        8usize,
        concat!("Alignment of ", stringify!(_ut128))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_ut128>())).Low as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_ut128),
            "::",
            stringify!(Low)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_ut128>())).High as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_ut128),
            "::",
            stringify!(High)
        )
    );
}
pub type ut128 = _ut128;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _ut256 {
    pub Low: ut128,
    pub High: ut128,
}
#[test]
fn bindgen_test_layout__ut256() {
    assert_eq!(
        ::std::mem::size_of::<_ut256>(),
        32usize,
        concat!("Size of: ", stringify!(_ut256))
    );
    assert_eq!(
        ::std::mem::align_of::<_ut256>(),
        8usize,
        concat!("Alignment of ", stringify!(_ut256))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_ut256>())).Low as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_ut256),
            "::",
            stringify!(Low)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_ut256>())).High as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_ut256),
            "::",
            stringify!(High)
        )
    );
}
pub type ut256 = _ut256;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _utX {
    pub v80: ut80,
    pub v96: ut96,
    pub v128: ut128,
    pub v256: ut256,
}
#[test]
fn bindgen_test_layout__utX() {
    assert_eq!(
        ::std::mem::size_of::<_utX>(),
        80usize,
        concat!("Size of: ", stringify!(_utX))
    );
    assert_eq!(
        ::std::mem::align_of::<_utX>(),
        8usize,
        concat!("Alignment of ", stringify!(_utX))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_utX>())).v80 as *const _ as usize },
        0usize,
        concat!("Offset of field: ", stringify!(_utX), "::", stringify!(v80))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_utX>())).v96 as *const _ as usize },
        16usize,
        concat!("Offset of field: ", stringify!(_utX), "::", stringify!(v96))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_utX>())).v128 as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(_utX),
            "::",
            stringify!(v128)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_utX>())).v256 as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(_utX),
            "::",
            stringify!(v256)
        )
    );
}
pub type utX = _utX;
pub type wchar_t = ::std::os::raw::c_int;
pub type va_list = __builtin_va_list;
pub type FILE = _IO_FILE;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _IO_marker {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _IO_codecvt {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _IO_wide_data {
    _unused: [u8; 0],
}
pub type _IO_lock_t = ::std::os::raw::c_void;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _IO_FILE {
    pub _flags: ::std::os::raw::c_int,
    pub _IO_read_ptr: *mut ::std::os::raw::c_char,
    pub _IO_read_end: *mut ::std::os::raw::c_char,
    pub _IO_read_base: *mut ::std::os::raw::c_char,
    pub _IO_write_base: *mut ::std::os::raw::c_char,
    pub _IO_write_ptr: *mut ::std::os::raw::c_char,
    pub _IO_write_end: *mut ::std::os::raw::c_char,
    pub _IO_buf_base: *mut ::std::os::raw::c_char,
    pub _IO_buf_end: *mut ::std::os::raw::c_char,
    pub _IO_save_base: *mut ::std::os::raw::c_char,
    pub _IO_backup_base: *mut ::std::os::raw::c_char,
    pub _IO_save_end: *mut ::std::os::raw::c_char,
    pub _markers: *mut _IO_marker,
    pub _chain: *mut _IO_FILE,
    pub _fileno: ::std::os::raw::c_int,
    pub _flags2: ::std::os::raw::c_int,
    pub _old_offset: __off_t,
    pub _cur_column: ::std::os::raw::c_ushort,
    pub _vtable_offset: ::std::os::raw::c_schar,
    pub _shortbuf: [::std::os::raw::c_char; 1usize],
    pub _lock: *mut _IO_lock_t,
    pub _offset: __off64_t,
    pub _codecvt: *mut _IO_codecvt,
    pub _wide_data: *mut _IO_wide_data,
    pub _freeres_list: *mut _IO_FILE,
    pub _freeres_buf: *mut ::std::os::raw::c_void,
    pub __pad5: size_t,
    pub _mode: ::std::os::raw::c_int,
    pub _unused2: [::std::os::raw::c_char; 20usize],
}
#[test]
fn bindgen_test_layout__IO_FILE() {
    assert_eq!(
        ::std::mem::size_of::<_IO_FILE>(),
        216usize,
        concat!("Size of: ", stringify!(_IO_FILE))
    );
    assert_eq!(
        ::std::mem::align_of::<_IO_FILE>(),
        8usize,
        concat!("Alignment of ", stringify!(_IO_FILE))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._flags as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._IO_read_ptr as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_IO_read_ptr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._IO_read_end as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_IO_read_end)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._IO_read_base as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_IO_read_base)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._IO_write_base as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_IO_write_base)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._IO_write_ptr as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_IO_write_ptr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._IO_write_end as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_IO_write_end)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._IO_buf_base as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_IO_buf_base)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._IO_buf_end as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_IO_buf_end)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._IO_save_base as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_IO_save_base)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._IO_backup_base as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_IO_backup_base)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._IO_save_end as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_IO_save_end)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._markers as *const _ as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_markers)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._chain as *const _ as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_chain)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._fileno as *const _ as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_fileno)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._flags2 as *const _ as usize },
        116usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_flags2)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._old_offset as *const _ as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_old_offset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._cur_column as *const _ as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_cur_column)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._vtable_offset as *const _ as usize },
        130usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_vtable_offset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._shortbuf as *const _ as usize },
        131usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_shortbuf)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._lock as *const _ as usize },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_lock)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._offset as *const _ as usize },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_offset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._codecvt as *const _ as usize },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_codecvt)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._wide_data as *const _ as usize },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_wide_data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._freeres_list as *const _ as usize },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_freeres_list)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._freeres_buf as *const _ as usize },
        176usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_freeres_buf)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>())).__pad5 as *const _ as usize },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(__pad5)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._mode as *const _ as usize },
        192usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_mode)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._unused2 as *const _ as usize },
        196usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_unused2)
        )
    );
}
pub type PrintfCallback = ::std::option::Option<
    unsafe extern "C" fn(str_: *const ::std::os::raw::c_char, ...) -> ::std::os::raw::c_int,
>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __dirstream {
    _unused: [u8; 0],
}
pub type DIR = __dirstream;
extern "C" {
    pub fn r_flist_resize(
        it: *mut *mut ::std::os::raw::c_void,
        n: ::std::os::raw::c_int,
    ) -> *mut *mut ::std::os::raw::c_void;
}
pub type SdbListFree =
    ::std::option::Option<unsafe extern "C" fn(ptr: *mut ::std::os::raw::c_void)>;
pub type SdbListComparator = ::std::option::Option<
    unsafe extern "C" fn(
        a: *const ::std::os::raw::c_void,
        b: *const ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int,
>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ls_iter_t {
    pub data: *mut ::std::os::raw::c_void,
    pub n: *mut ls_iter_t,
    pub p: *mut ls_iter_t,
}
#[test]
fn bindgen_test_layout_ls_iter_t() {
    assert_eq!(
        ::std::mem::size_of::<ls_iter_t>(),
        24usize,
        concat!("Size of: ", stringify!(ls_iter_t))
    );
    assert_eq!(
        ::std::mem::align_of::<ls_iter_t>(),
        8usize,
        concat!("Alignment of ", stringify!(ls_iter_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ls_iter_t>())).data as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(ls_iter_t),
            "::",
            stringify!(data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ls_iter_t>())).n as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(ls_iter_t),
            "::",
            stringify!(n)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ls_iter_t>())).p as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(ls_iter_t),
            "::",
            stringify!(p)
        )
    );
}
pub type SdbListIter = ls_iter_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ls_t {
    pub length: size_t,
    pub head: *mut SdbListIter,
    pub tail: *mut SdbListIter,
    pub free: SdbListFree,
    pub cmp: SdbListComparator,
    pub sorted: bool,
}
#[test]
fn bindgen_test_layout_ls_t() {
    assert_eq!(
        ::std::mem::size_of::<ls_t>(),
        48usize,
        concat!("Size of: ", stringify!(ls_t))
    );
    assert_eq!(
        ::std::mem::align_of::<ls_t>(),
        8usize,
        concat!("Alignment of ", stringify!(ls_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ls_t>())).length as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(ls_t),
            "::",
            stringify!(length)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ls_t>())).head as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(ls_t),
            "::",
            stringify!(head)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ls_t>())).tail as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(ls_t),
            "::",
            stringify!(tail)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ls_t>())).free as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(ls_t),
            "::",
            stringify!(free)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ls_t>())).cmp as *const _ as usize },
        32usize,
        concat!("Offset of field: ", stringify!(ls_t), "::", stringify!(cmp))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ls_t>())).sorted as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(ls_t),
            "::",
            stringify!(sorted)
        )
    );
}
pub type SdbList = ls_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ht_pp_kv {
    pub key: *mut ::std::os::raw::c_void,
    pub value: *mut ::std::os::raw::c_void,
    pub key_len: u32,
    pub value_len: u32,
}
#[test]
fn bindgen_test_layout_ht_pp_kv() {
    assert_eq!(
        ::std::mem::size_of::<ht_pp_kv>(),
        24usize,
        concat!("Size of: ", stringify!(ht_pp_kv))
    );
    assert_eq!(
        ::std::mem::align_of::<ht_pp_kv>(),
        8usize,
        concat!("Alignment of ", stringify!(ht_pp_kv))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ht_pp_kv>())).key as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(ht_pp_kv),
            "::",
            stringify!(key)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ht_pp_kv>())).value as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(ht_pp_kv),
            "::",
            stringify!(value)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ht_pp_kv>())).key_len as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(ht_pp_kv),
            "::",
            stringify!(key_len)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ht_pp_kv>())).value_len as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(ht_pp_kv),
            "::",
            stringify!(value_len)
        )
    );
}
pub type HtPPKv = ht_pp_kv;
pub type HtPPKvFreeFunc = ::std::option::Option<unsafe extern "C" fn(arg1: *mut HtPPKv)>;
pub type HtPPDupKey = ::std::option::Option<
    unsafe extern "C" fn(arg1: *const ::std::os::raw::c_void) -> *mut ::std::os::raw::c_void,
>;
pub type HtPPDupValue = ::std::option::Option<
    unsafe extern "C" fn(arg1: *const ::std::os::raw::c_void) -> *mut ::std::os::raw::c_void,
>;
pub type HtPPCalcSizeK =
    ::std::option::Option<unsafe extern "C" fn(arg1: *const ::std::os::raw::c_void) -> u32>;
pub type HtPPCalcSizeV =
    ::std::option::Option<unsafe extern "C" fn(arg1: *const ::std::os::raw::c_void) -> u32>;
pub type HtPPHashFunction =
    ::std::option::Option<unsafe extern "C" fn(arg1: *const ::std::os::raw::c_void) -> u32>;
pub type HtPPListComparator = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: *const ::std::os::raw::c_void,
        arg2: *const ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int,
>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ht_pp_bucket_t {
    pub arr: *mut HtPPKv,
    pub count: u32,
}
#[test]
fn bindgen_test_layout_ht_pp_bucket_t() {
    assert_eq!(
        ::std::mem::size_of::<ht_pp_bucket_t>(),
        16usize,
        concat!("Size of: ", stringify!(ht_pp_bucket_t))
    );
    assert_eq!(
        ::std::mem::align_of::<ht_pp_bucket_t>(),
        8usize,
        concat!("Alignment of ", stringify!(ht_pp_bucket_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ht_pp_bucket_t>())).arr as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(ht_pp_bucket_t),
            "::",
            stringify!(arr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ht_pp_bucket_t>())).count as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(ht_pp_bucket_t),
            "::",
            stringify!(count)
        )
    );
}
pub type HtPPBucket = ht_pp_bucket_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ht_pp_options_t {
    pub cmp: HtPPListComparator,
    pub hashfn: HtPPHashFunction,
    pub dupkey: HtPPDupKey,
    pub dupvalue: HtPPDupValue,
    pub calcsizeK: HtPPCalcSizeK,
    pub calcsizeV: HtPPCalcSizeV,
    pub freefn: HtPPKvFreeFunc,
    pub elem_size: size_t,
}
#[test]
fn bindgen_test_layout_ht_pp_options_t() {
    assert_eq!(
        ::std::mem::size_of::<ht_pp_options_t>(),
        64usize,
        concat!("Size of: ", stringify!(ht_pp_options_t))
    );
    assert_eq!(
        ::std::mem::align_of::<ht_pp_options_t>(),
        8usize,
        concat!("Alignment of ", stringify!(ht_pp_options_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ht_pp_options_t>())).cmp as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(ht_pp_options_t),
            "::",
            stringify!(cmp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ht_pp_options_t>())).hashfn as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(ht_pp_options_t),
            "::",
            stringify!(hashfn)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ht_pp_options_t>())).dupkey as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(ht_pp_options_t),
            "::",
            stringify!(dupkey)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ht_pp_options_t>())).dupvalue as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(ht_pp_options_t),
            "::",
            stringify!(dupvalue)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ht_pp_options_t>())).calcsizeK as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(ht_pp_options_t),
            "::",
            stringify!(calcsizeK)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ht_pp_options_t>())).calcsizeV as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(ht_pp_options_t),
            "::",
            stringify!(calcsizeV)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ht_pp_options_t>())).freefn as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(ht_pp_options_t),
            "::",
            stringify!(freefn)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ht_pp_options_t>())).elem_size as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(ht_pp_options_t),
            "::",
            stringify!(elem_size)
        )
    );
}
pub type HtPPOptions = ht_pp_options_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ht_pp_t {
    pub size: u32,
    pub count: u32,
    pub table: *mut HtPPBucket,
    pub prime_idx: u32,
    pub opt: HtPPOptions,
}
#[test]
fn bindgen_test_layout_ht_pp_t() {
    assert_eq!(
        ::std::mem::size_of::<ht_pp_t>(),
        88usize,
        concat!("Size of: ", stringify!(ht_pp_t))
    );
    assert_eq!(
        ::std::mem::align_of::<ht_pp_t>(),
        8usize,
        concat!("Alignment of ", stringify!(ht_pp_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ht_pp_t>())).size as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(ht_pp_t),
            "::",
            stringify!(size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ht_pp_t>())).count as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(ht_pp_t),
            "::",
            stringify!(count)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ht_pp_t>())).table as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(ht_pp_t),
            "::",
            stringify!(table)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ht_pp_t>())).prime_idx as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(ht_pp_t),
            "::",
            stringify!(prime_idx)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ht_pp_t>())).opt as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(ht_pp_t),
            "::",
            stringify!(opt)
        )
    );
}
pub type HtPP = ht_pp_t;
#[doc = " keyvalue pair"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct sdb_kv {
    pub base: HtPPKv,
    pub cas: u32,
    pub expire: u64,
}
#[test]
fn bindgen_test_layout_sdb_kv() {
    assert_eq!(
        ::std::mem::size_of::<sdb_kv>(),
        40usize,
        concat!("Size of: ", stringify!(sdb_kv))
    );
    assert_eq!(
        ::std::mem::align_of::<sdb_kv>(),
        8usize,
        concat!("Alignment of ", stringify!(sdb_kv))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sdb_kv>())).base as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sdb_kv),
            "::",
            stringify!(base)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sdb_kv>())).cas as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(sdb_kv),
            "::",
            stringify!(cas)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sdb_kv>())).expire as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(sdb_kv),
            "::",
            stringify!(expire)
        )
    );
}
#[doc = " keyvalue pair"]
pub type SdbKv = sdb_kv;
extern "C" {
    pub fn sdb_hash(key: *const ::std::os::raw::c_char) -> u32;
}
extern "C" {
    pub fn sdb_ht_new() -> *mut HtPP;
}
extern "C" {
    pub fn sdb_ht_free(ht: *mut HtPP);
}
extern "C" {
    pub fn sdb_ht_insert(
        ht: *mut HtPP,
        key: *const ::std::os::raw::c_char,
        value: *const ::std::os::raw::c_char,
    ) -> bool;
}
extern "C" {
    pub fn sdb_ht_insert_kvp(ht: *mut HtPP, kvp: *mut SdbKv, update: bool) -> bool;
}
extern "C" {
    pub fn sdb_ht_update(
        ht: *mut HtPP,
        key: *const ::std::os::raw::c_char,
        value: *const ::std::os::raw::c_char,
    ) -> bool;
}
extern "C" {
    pub fn sdb_ht_delete(ht: *mut HtPP, key: *const ::std::os::raw::c_char) -> bool;
}
extern "C" {
    pub fn sdb_ht_find(
        ht: *mut HtPP,
        key: *const ::std::os::raw::c_char,
        found: *mut bool,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn sdb_ht_find_kvp(
        ht: *mut HtPP,
        key: *const ::std::os::raw::c_char,
        found: *mut bool,
    ) -> *mut SdbKv;
}
pub type dict_freecb =
    ::std::option::Option<unsafe extern "C" fn(arg1: *mut ::std::os::raw::c_void)>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct dict {
    pub table: *mut *mut ::std::os::raw::c_void,
    pub f: dict_freecb,
    pub size: u32,
}
#[test]
fn bindgen_test_layout_dict() {
    assert_eq!(
        ::std::mem::size_of::<dict>(),
        24usize,
        concat!("Size of: ", stringify!(dict))
    );
    assert_eq!(
        ::std::mem::align_of::<dict>(),
        8usize,
        concat!("Alignment of ", stringify!(dict))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<dict>())).table as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(dict),
            "::",
            stringify!(table)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<dict>())).f as *const _ as usize },
        8usize,
        concat!("Offset of field: ", stringify!(dict), "::", stringify!(f))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<dict>())).size as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(dict),
            "::",
            stringify!(size)
        )
    );
}
pub type SdbMini = dict;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cdb {
    pub map: *mut ::std::os::raw::c_char,
    pub fd: ::std::os::raw::c_int,
    pub size: u32,
    pub loop_: u32,
    pub khash: u32,
    pub kpos: u32,
    pub hpos: u32,
    pub hslots: u32,
    pub dpos: u32,
    pub dlen: u32,
}
#[test]
fn bindgen_test_layout_cdb() {
    assert_eq!(
        ::std::mem::size_of::<cdb>(),
        48usize,
        concat!("Size of: ", stringify!(cdb))
    );
    assert_eq!(
        ::std::mem::align_of::<cdb>(),
        8usize,
        concat!("Alignment of ", stringify!(cdb))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cdb>())).map as *const _ as usize },
        0usize,
        concat!("Offset of field: ", stringify!(cdb), "::", stringify!(map))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cdb>())).fd as *const _ as usize },
        8usize,
        concat!("Offset of field: ", stringify!(cdb), "::", stringify!(fd))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cdb>())).size as *const _ as usize },
        12usize,
        concat!("Offset of field: ", stringify!(cdb), "::", stringify!(size))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cdb>())).loop_ as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(cdb),
            "::",
            stringify!(loop_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cdb>())).khash as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(cdb),
            "::",
            stringify!(khash)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cdb>())).kpos as *const _ as usize },
        24usize,
        concat!("Offset of field: ", stringify!(cdb), "::", stringify!(kpos))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cdb>())).hpos as *const _ as usize },
        28usize,
        concat!("Offset of field: ", stringify!(cdb), "::", stringify!(hpos))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cdb>())).hslots as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(cdb),
            "::",
            stringify!(hslots)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cdb>())).dpos as *const _ as usize },
        36usize,
        concat!("Offset of field: ", stringify!(cdb), "::", stringify!(dpos))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cdb>())).dlen as *const _ as usize },
        40usize,
        concat!("Offset of field: ", stringify!(cdb), "::", stringify!(dlen))
    );
}
pub type BufferOp = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: ::std::os::raw::c_int,
        arg2: *const ::std::os::raw::c_char,
        arg3: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int,
>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct buffer {
    pub x: *mut ::std::os::raw::c_char,
    pub p: ::std::os::raw::c_uint,
    pub n: ::std::os::raw::c_uint,
    pub fd: ::std::os::raw::c_int,
    pub op: BufferOp,
}
#[test]
fn bindgen_test_layout_buffer() {
    assert_eq!(
        ::std::mem::size_of::<buffer>(),
        32usize,
        concat!("Size of: ", stringify!(buffer))
    );
    assert_eq!(
        ::std::mem::align_of::<buffer>(),
        8usize,
        concat!("Alignment of ", stringify!(buffer))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<buffer>())).x as *const _ as usize },
        0usize,
        concat!("Offset of field: ", stringify!(buffer), "::", stringify!(x))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<buffer>())).p as *const _ as usize },
        8usize,
        concat!("Offset of field: ", stringify!(buffer), "::", stringify!(p))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<buffer>())).n as *const _ as usize },
        12usize,
        concat!("Offset of field: ", stringify!(buffer), "::", stringify!(n))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<buffer>())).fd as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(buffer),
            "::",
            stringify!(fd)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<buffer>())).op as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(buffer),
            "::",
            stringify!(op)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cdb_hp {
    pub h: u32,
    pub p: u32,
}
#[test]
fn bindgen_test_layout_cdb_hp() {
    assert_eq!(
        ::std::mem::size_of::<cdb_hp>(),
        8usize,
        concat!("Size of: ", stringify!(cdb_hp))
    );
    assert_eq!(
        ::std::mem::align_of::<cdb_hp>(),
        4usize,
        concat!("Alignment of ", stringify!(cdb_hp))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cdb_hp>())).h as *const _ as usize },
        0usize,
        concat!("Offset of field: ", stringify!(cdb_hp), "::", stringify!(h))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cdb_hp>())).p as *const _ as usize },
        4usize,
        concat!("Offset of field: ", stringify!(cdb_hp), "::", stringify!(p))
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cdb_hplist {
    pub hp: [cdb_hp; 1000usize],
    pub next: *mut cdb_hplist,
    pub num: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_cdb_hplist() {
    assert_eq!(
        ::std::mem::size_of::<cdb_hplist>(),
        8016usize,
        concat!("Size of: ", stringify!(cdb_hplist))
    );
    assert_eq!(
        ::std::mem::align_of::<cdb_hplist>(),
        8usize,
        concat!("Alignment of ", stringify!(cdb_hplist))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cdb_hplist>())).hp as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cdb_hplist),
            "::",
            stringify!(hp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cdb_hplist>())).next as *const _ as usize },
        8000usize,
        concat!(
            "Offset of field: ",
            stringify!(cdb_hplist),
            "::",
            stringify!(next)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cdb_hplist>())).num as *const _ as usize },
        8008usize,
        concat!(
            "Offset of field: ",
            stringify!(cdb_hplist),
            "::",
            stringify!(num)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cdb_make {
    pub bspace: [::std::os::raw::c_char; 8192usize],
    pub final_: [::std::os::raw::c_char; 1024usize],
    pub count: [u32; 256usize],
    pub start: [u32; 256usize],
    pub head: *mut cdb_hplist,
    pub split: *mut cdb_hp,
    pub hash: *mut cdb_hp,
    pub numentries: u32,
    pub memsize: u32,
    pub b: buffer,
    pub pos: u32,
    pub fd: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_cdb_make() {
    assert_eq!(
        ::std::mem::size_of::<cdb_make>(),
        11336usize,
        concat!("Size of: ", stringify!(cdb_make))
    );
    assert_eq!(
        ::std::mem::align_of::<cdb_make>(),
        8usize,
        concat!("Alignment of ", stringify!(cdb_make))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cdb_make>())).bspace as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cdb_make),
            "::",
            stringify!(bspace)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cdb_make>())).final_ as *const _ as usize },
        8192usize,
        concat!(
            "Offset of field: ",
            stringify!(cdb_make),
            "::",
            stringify!(final_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cdb_make>())).count as *const _ as usize },
        9216usize,
        concat!(
            "Offset of field: ",
            stringify!(cdb_make),
            "::",
            stringify!(count)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cdb_make>())).start as *const _ as usize },
        10240usize,
        concat!(
            "Offset of field: ",
            stringify!(cdb_make),
            "::",
            stringify!(start)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cdb_make>())).head as *const _ as usize },
        11264usize,
        concat!(
            "Offset of field: ",
            stringify!(cdb_make),
            "::",
            stringify!(head)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cdb_make>())).split as *const _ as usize },
        11272usize,
        concat!(
            "Offset of field: ",
            stringify!(cdb_make),
            "::",
            stringify!(split)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cdb_make>())).hash as *const _ as usize },
        11280usize,
        concat!(
            "Offset of field: ",
            stringify!(cdb_make),
            "::",
            stringify!(hash)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cdb_make>())).numentries as *const _ as usize },
        11288usize,
        concat!(
            "Offset of field: ",
            stringify!(cdb_make),
            "::",
            stringify!(numentries)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cdb_make>())).memsize as *const _ as usize },
        11292usize,
        concat!(
            "Offset of field: ",
            stringify!(cdb_make),
            "::",
            stringify!(memsize)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cdb_make>())).b as *const _ as usize },
        11296usize,
        concat!(
            "Offset of field: ",
            stringify!(cdb_make),
            "::",
            stringify!(b)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cdb_make>())).pos as *const _ as usize },
        11328usize,
        concat!(
            "Offset of field: ",
            stringify!(cdb_make),
            "::",
            stringify!(pos)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cdb_make>())).fd as *const _ as usize },
        11332usize,
        concat!(
            "Offset of field: ",
            stringify!(cdb_make),
            "::",
            stringify!(fd)
        )
    );
}
pub type GperfForeachCallback = ::std::option::Option<
    unsafe extern "C" fn(
        user: *mut ::std::os::raw::c_void,
        k: *const ::std::os::raw::c_char,
        v: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int,
>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct sdb_gperf_t {
    pub name: *const ::std::os::raw::c_char,
    pub get: ::std::option::Option<
        unsafe extern "C" fn(k: *const ::std::os::raw::c_char) -> *const ::std::os::raw::c_char,
    >,
    pub hash: ::std::option::Option<
        unsafe extern "C" fn(k: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_uint,
    >,
    pub foreach: ::std::option::Option<
        unsafe extern "C" fn(cb: GperfForeachCallback, user: *mut ::std::os::raw::c_void) -> bool,
    >,
}
#[test]
fn bindgen_test_layout_sdb_gperf_t() {
    assert_eq!(
        ::std::mem::size_of::<sdb_gperf_t>(),
        32usize,
        concat!("Size of: ", stringify!(sdb_gperf_t))
    );
    assert_eq!(
        ::std::mem::align_of::<sdb_gperf_t>(),
        8usize,
        concat!("Alignment of ", stringify!(sdb_gperf_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sdb_gperf_t>())).name as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sdb_gperf_t),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sdb_gperf_t>())).get as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(sdb_gperf_t),
            "::",
            stringify!(get)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sdb_gperf_t>())).hash as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(sdb_gperf_t),
            "::",
            stringify!(hash)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sdb_gperf_t>())).foreach as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(sdb_gperf_t),
            "::",
            stringify!(foreach)
        )
    );
}
pub type SdbGperf = sdb_gperf_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct sdb_t {
    pub dir: *mut ::std::os::raw::c_char,
    pub path: *mut ::std::os::raw::c_char,
    pub name: *mut ::std::os::raw::c_char,
    pub fd: ::std::os::raw::c_int,
    pub refs: ::std::os::raw::c_int,
    pub lock: ::std::os::raw::c_int,
    pub journal: ::std::os::raw::c_int,
    pub db: cdb,
    pub m: cdb_make,
    pub ht: *mut HtPP,
    pub eod: u32,
    pub pos: u32,
    pub gp: *mut SdbGperf,
    pub fdump: ::std::os::raw::c_int,
    pub ndump: *mut ::std::os::raw::c_char,
    pub expire: u64,
    pub last: u64,
    pub options: ::std::os::raw::c_int,
    pub ns_lock: ::std::os::raw::c_int,
    pub ns: *mut SdbList,
    pub hooks: *mut SdbList,
    pub tmpkv: SdbKv,
    pub depth: u32,
    pub timestamped: bool,
    pub mht: SdbMini,
}
#[test]
fn bindgen_test_layout_sdb_t() {
    assert_eq!(
        ::std::mem::size_of::<sdb_t>(),
        11576usize,
        concat!("Size of: ", stringify!(sdb_t))
    );
    assert_eq!(
        ::std::mem::align_of::<sdb_t>(),
        8usize,
        concat!("Alignment of ", stringify!(sdb_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sdb_t>())).dir as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sdb_t),
            "::",
            stringify!(dir)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sdb_t>())).path as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(sdb_t),
            "::",
            stringify!(path)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sdb_t>())).name as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(sdb_t),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sdb_t>())).fd as *const _ as usize },
        24usize,
        concat!("Offset of field: ", stringify!(sdb_t), "::", stringify!(fd))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sdb_t>())).refs as *const _ as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(sdb_t),
            "::",
            stringify!(refs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sdb_t>())).lock as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(sdb_t),
            "::",
            stringify!(lock)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sdb_t>())).journal as *const _ as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(sdb_t),
            "::",
            stringify!(journal)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sdb_t>())).db as *const _ as usize },
        40usize,
        concat!("Offset of field: ", stringify!(sdb_t), "::", stringify!(db))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sdb_t>())).m as *const _ as usize },
        88usize,
        concat!("Offset of field: ", stringify!(sdb_t), "::", stringify!(m))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sdb_t>())).ht as *const _ as usize },
        11424usize,
        concat!("Offset of field: ", stringify!(sdb_t), "::", stringify!(ht))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sdb_t>())).eod as *const _ as usize },
        11432usize,
        concat!(
            "Offset of field: ",
            stringify!(sdb_t),
            "::",
            stringify!(eod)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sdb_t>())).pos as *const _ as usize },
        11436usize,
        concat!(
            "Offset of field: ",
            stringify!(sdb_t),
            "::",
            stringify!(pos)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sdb_t>())).gp as *const _ as usize },
        11440usize,
        concat!("Offset of field: ", stringify!(sdb_t), "::", stringify!(gp))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sdb_t>())).fdump as *const _ as usize },
        11448usize,
        concat!(
            "Offset of field: ",
            stringify!(sdb_t),
            "::",
            stringify!(fdump)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sdb_t>())).ndump as *const _ as usize },
        11456usize,
        concat!(
            "Offset of field: ",
            stringify!(sdb_t),
            "::",
            stringify!(ndump)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sdb_t>())).expire as *const _ as usize },
        11464usize,
        concat!(
            "Offset of field: ",
            stringify!(sdb_t),
            "::",
            stringify!(expire)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sdb_t>())).last as *const _ as usize },
        11472usize,
        concat!(
            "Offset of field: ",
            stringify!(sdb_t),
            "::",
            stringify!(last)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sdb_t>())).options as *const _ as usize },
        11480usize,
        concat!(
            "Offset of field: ",
            stringify!(sdb_t),
            "::",
            stringify!(options)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sdb_t>())).ns_lock as *const _ as usize },
        11484usize,
        concat!(
            "Offset of field: ",
            stringify!(sdb_t),
            "::",
            stringify!(ns_lock)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sdb_t>())).ns as *const _ as usize },
        11488usize,
        concat!("Offset of field: ", stringify!(sdb_t), "::", stringify!(ns))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sdb_t>())).hooks as *const _ as usize },
        11496usize,
        concat!(
            "Offset of field: ",
            stringify!(sdb_t),
            "::",
            stringify!(hooks)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sdb_t>())).tmpkv as *const _ as usize },
        11504usize,
        concat!(
            "Offset of field: ",
            stringify!(sdb_t),
            "::",
            stringify!(tmpkv)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sdb_t>())).depth as *const _ as usize },
        11544usize,
        concat!(
            "Offset of field: ",
            stringify!(sdb_t),
            "::",
            stringify!(depth)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sdb_t>())).timestamped as *const _ as usize },
        11548usize,
        concat!(
            "Offset of field: ",
            stringify!(sdb_t),
            "::",
            stringify!(timestamped)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sdb_t>())).mht as *const _ as usize },
        11552usize,
        concat!(
            "Offset of field: ",
            stringify!(sdb_t),
            "::",
            stringify!(mht)
        )
    );
}
pub type Sdb = sdb_t;
extern "C" {
    pub fn sdb_new0() -> *mut Sdb;
}
extern "C" {
    pub fn sdb_new(
        path: *const ::std::os::raw::c_char,
        file: *const ::std::os::raw::c_char,
        lock: ::std::os::raw::c_int,
    ) -> *mut Sdb;
}
extern "C" {
    pub fn sdb_open(s: *mut Sdb, file: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sdb_open_gperf(s: *mut Sdb, g: *mut SdbGperf) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sdb_close(s: *mut Sdb);
}
extern "C" {
    pub fn sdb_config(s: *mut Sdb, options: ::std::os::raw::c_int);
}
extern "C" {
    pub fn sdb_free(s: *mut Sdb) -> bool;
}
extern "C" {
    pub fn sdb_file(s: *mut Sdb, dir: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn sdb_merge(d: *mut Sdb, s: *mut Sdb) -> bool;
}
extern "C" {
    pub fn sdb_count(s: *mut Sdb) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sdb_reset(s: *mut Sdb);
}
extern "C" {
    pub fn sdb_setup(s: *mut Sdb, options: ::std::os::raw::c_int);
}
extern "C" {
    pub fn sdb_drain(arg1: *mut Sdb, arg2: *mut Sdb);
}
extern "C" {
    pub fn sdb_copy(src: *mut Sdb, dst: *mut Sdb);
}
extern "C" {
    pub fn sdb_stats(s: *mut Sdb, disk: *mut u32, mem: *mut u32) -> bool;
}
extern "C" {
    pub fn sdb_dump_hasnext(s: *mut Sdb) -> bool;
}
pub type SdbForeachCallback = ::std::option::Option<
    unsafe extern "C" fn(
        user: *mut ::std::os::raw::c_void,
        k: *const ::std::os::raw::c_char,
        v: *const ::std::os::raw::c_char,
    ) -> bool,
>;
extern "C" {
    pub fn sdb_foreach(
        s: *mut Sdb,
        cb: SdbForeachCallback,
        user: *mut ::std::os::raw::c_void,
    ) -> bool;
}
extern "C" {
    pub fn sdb_foreach_list(s: *mut Sdb, sorted: bool) -> *mut SdbList;
}
extern "C" {
    pub fn sdb_foreach_list_filter(
        s: *mut Sdb,
        filter: SdbForeachCallback,
        sorted: bool,
    ) -> *mut SdbList;
}
extern "C" {
    pub fn sdb_foreach_match(
        s: *mut Sdb,
        expr: *const ::std::os::raw::c_char,
        sorted: bool,
    ) -> *mut SdbList;
}
extern "C" {
    pub fn sdb_query(s: *mut Sdb, cmd: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sdb_queryf(
        s: *mut Sdb,
        fmt: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sdb_query_lines(
        s: *mut Sdb,
        cmd: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sdb_querys(
        s: *mut Sdb,
        buf: *mut ::std::os::raw::c_char,
        len: size_t,
        cmd: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn sdb_querysf(
        s: *mut Sdb,
        buf: *mut ::std::os::raw::c_char,
        buflen: size_t,
        fmt: *const ::std::os::raw::c_char,
        ...
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn sdb_query_file(
        s: *mut Sdb,
        file: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sdb_exists(arg1: *mut Sdb, key: *const ::std::os::raw::c_char) -> bool;
}
extern "C" {
    pub fn sdb_remove(arg1: *mut Sdb, key: *const ::std::os::raw::c_char, cas: u32) -> bool;
}
extern "C" {
    pub fn sdb_unset(
        arg1: *mut Sdb,
        key: *const ::std::os::raw::c_char,
        cas: u32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sdb_unset_like(s: *mut Sdb, k: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sdb_like(
        s: *mut Sdb,
        k: *const ::std::os::raw::c_char,
        v: *const ::std::os::raw::c_char,
        cb: SdbForeachCallback,
    ) -> *mut *mut ::std::os::raw::c_char;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct sdb_diff_t {
    pub path: *const SdbList,
    pub k: *const ::std::os::raw::c_char,
    pub v: *const ::std::os::raw::c_char,
    pub add: bool,
}
#[test]
fn bindgen_test_layout_sdb_diff_t() {
    assert_eq!(
        ::std::mem::size_of::<sdb_diff_t>(),
        32usize,
        concat!("Size of: ", stringify!(sdb_diff_t))
    );
    assert_eq!(
        ::std::mem::align_of::<sdb_diff_t>(),
        8usize,
        concat!("Alignment of ", stringify!(sdb_diff_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sdb_diff_t>())).path as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sdb_diff_t),
            "::",
            stringify!(path)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sdb_diff_t>())).k as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(sdb_diff_t),
            "::",
            stringify!(k)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sdb_diff_t>())).v as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(sdb_diff_t),
            "::",
            stringify!(v)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sdb_diff_t>())).add as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(sdb_diff_t),
            "::",
            stringify!(add)
        )
    );
}
pub type SdbDiff = sdb_diff_t;
extern "C" {
    pub fn sdb_diff_format(
        str_: *mut ::std::os::raw::c_char,
        size: ::std::os::raw::c_int,
        diff: *const SdbDiff,
    ) -> ::std::os::raw::c_int;
}
pub type SdbDiffCallback = ::std::option::Option<
    unsafe extern "C" fn(diff: *const SdbDiff, user: *mut ::std::os::raw::c_void),
>;
extern "C" {
    pub fn sdb_diff(
        a: *mut Sdb,
        b: *mut Sdb,
        cb: SdbDiffCallback,
        cb_user: *mut ::std::os::raw::c_void,
    ) -> bool;
}
extern "C" {
    pub fn sdb_get(
        arg1: *mut Sdb,
        key: *const ::std::os::raw::c_char,
        cas: *mut u32,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn sdb_get_len(
        arg1: *mut Sdb,
        key: *const ::std::os::raw::c_char,
        vlen: *mut ::std::os::raw::c_int,
        cas: *mut u32,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn sdb_const_get(
        arg1: *mut Sdb,
        key: *const ::std::os::raw::c_char,
        cas: *mut u32,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn sdb_const_get_len(
        s: *mut Sdb,
        key: *const ::std::os::raw::c_char,
        vlen: *mut ::std::os::raw::c_int,
        cas: *mut u32,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn sdb_set(
        arg1: *mut Sdb,
        key: *const ::std::os::raw::c_char,
        data: *const ::std::os::raw::c_char,
        cas: u32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sdb_set_owned(
        s: *mut Sdb,
        key: *const ::std::os::raw::c_char,
        val: *mut ::std::os::raw::c_char,
        cas: u32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sdb_concat(
        s: *mut Sdb,
        key: *const ::std::os::raw::c_char,
        value: *const ::std::os::raw::c_char,
        cas: u32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sdb_uncat(
        s: *mut Sdb,
        key: *const ::std::os::raw::c_char,
        value: *const ::std::os::raw::c_char,
        cas: u32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sdb_add(
        s: *mut Sdb,
        key: *const ::std::os::raw::c_char,
        val: *const ::std::os::raw::c_char,
        cas: u32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sdb_sync(arg1: *mut Sdb) -> bool;
}
extern "C" {
    pub fn sdb_num_exists(arg1: *mut Sdb, key: *const ::std::os::raw::c_char) -> bool;
}
extern "C" {
    pub fn sdb_num_base(s: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sdb_num_get(s: *mut Sdb, key: *const ::std::os::raw::c_char, cas: *mut u32) -> u64;
}
extern "C" {
    pub fn sdb_num_set(
        s: *mut Sdb,
        key: *const ::std::os::raw::c_char,
        v: u64,
        cas: u32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sdb_num_add(
        s: *mut Sdb,
        key: *const ::std::os::raw::c_char,
        v: u64,
        cas: u32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sdb_num_inc(s: *mut Sdb, key: *const ::std::os::raw::c_char, n: u64, cas: u32) -> u64;
}
extern "C" {
    pub fn sdb_num_dec(s: *mut Sdb, key: *const ::std::os::raw::c_char, n: u64, cas: u32) -> u64;
}
extern "C" {
    pub fn sdb_num_min(
        s: *mut Sdb,
        key: *const ::std::os::raw::c_char,
        v: u64,
        cas: u32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sdb_num_max(
        s: *mut Sdb,
        key: *const ::std::os::raw::c_char,
        v: u64,
        cas: u32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sdb_ptr_set(
        db: *mut Sdb,
        key: *const ::std::os::raw::c_char,
        p: *mut ::std::os::raw::c_void,
        cas: u32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sdb_ptr_get(
        db: *mut Sdb,
        key: *const ::std::os::raw::c_char,
        cas: *mut u32,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn sdb_disk_create(s: *mut Sdb) -> bool;
}
extern "C" {
    pub fn sdb_disk_insert(
        s: *mut Sdb,
        key: *const ::std::os::raw::c_char,
        val: *const ::std::os::raw::c_char,
    ) -> bool;
}
extern "C" {
    pub fn sdb_disk_finish(s: *mut Sdb) -> bool;
}
extern "C" {
    pub fn sdb_disk_unlink(s: *mut Sdb) -> bool;
}
extern "C" {
    pub fn sdb_text_save_fd(s: *mut Sdb, fd: ::std::os::raw::c_int, sort: bool) -> bool;
}
extern "C" {
    pub fn sdb_text_save(s: *mut Sdb, file: *const ::std::os::raw::c_char, sort: bool) -> bool;
}
extern "C" {
    pub fn sdb_text_load_buf(s: *mut Sdb, buf: *mut ::std::os::raw::c_char, sz: size_t) -> bool;
}
extern "C" {
    pub fn sdb_text_load(s: *mut Sdb, file: *const ::std::os::raw::c_char) -> bool;
}
extern "C" {
    pub fn sdb_text_check(s: *mut Sdb, file: *const ::std::os::raw::c_char) -> bool;
}
extern "C" {
    pub fn sdb_dump_begin(s: *mut Sdb);
}
extern "C" {
    pub fn sdb_dump_next(s: *mut Sdb) -> *mut SdbKv;
}
extern "C" {
    pub fn sdb_dump_dupnext(
        s: *mut Sdb,
        key: *mut ::std::os::raw::c_char,
        value: *mut *mut ::std::os::raw::c_char,
        _vlen: *mut ::std::os::raw::c_int,
    ) -> bool;
}
extern "C" {
    pub fn sdb_journal_close(s: *mut Sdb) -> bool;
}
extern "C" {
    pub fn sdb_journal_open(s: *mut Sdb) -> bool;
}
extern "C" {
    pub fn sdb_journal_load(s: *mut Sdb) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sdb_journal_log(
        s: *mut Sdb,
        key: *const ::std::os::raw::c_char,
        val: *const ::std::os::raw::c_char,
    ) -> bool;
}
extern "C" {
    pub fn sdb_journal_clear(s: *mut Sdb) -> bool;
}
extern "C" {
    pub fn sdb_journal_unlink(s: *mut Sdb) -> bool;
}
extern "C" {
    pub fn sdb_itoa(
        n: u64,
        s: *mut ::std::os::raw::c_char,
        base: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn sdb_atoi(s: *const ::std::os::raw::c_char) -> u64;
}
extern "C" {
    pub fn sdb_lock(s: *const ::std::os::raw::c_char) -> bool;
}
extern "C" {
    pub fn sdb_lock_file(
        f: *const ::std::os::raw::c_char,
        buf: *mut ::std::os::raw::c_char,
        buf_size: size_t,
    ) -> bool;
}
extern "C" {
    pub fn sdb_unlock(s: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn sdb_unlink(s: *mut Sdb) -> bool;
}
extern "C" {
    pub fn sdb_lock_wait(s: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sdb_expire_set(
        s: *mut Sdb,
        key: *const ::std::os::raw::c_char,
        expire: u64,
        cas: u32,
    ) -> bool;
}
extern "C" {
    pub fn sdb_expire_get(s: *mut Sdb, key: *const ::std::os::raw::c_char, cas: *mut u32) -> u64;
}
extern "C" {
    pub fn sdb_now() -> u64;
}
extern "C" {
    pub fn sdb_unow() -> u64;
}
extern "C" {
    pub fn sdb_hash_len(key: *const ::std::os::raw::c_char, len: *mut u32) -> u32;
}
extern "C" {
    pub fn sdb_hash_byte(s: *const ::std::os::raw::c_char) -> u8;
}
extern "C" {
    pub fn sdb_isjson(k: *const ::std::os::raw::c_char) -> bool;
}
extern "C" {
    pub fn sdb_json_get_str(
        json: *const ::std::os::raw::c_char,
        path: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn sdb_json_get_bool(
        json: *const ::std::os::raw::c_char,
        path: *const ::std::os::raw::c_char,
    ) -> bool;
}
extern "C" {
    pub fn sdb_json_get(
        s: *mut Sdb,
        key: *const ::std::os::raw::c_char,
        p: *const ::std::os::raw::c_char,
        cas: *mut u32,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn sdb_json_set(
        s: *mut Sdb,
        k: *const ::std::os::raw::c_char,
        p: *const ::std::os::raw::c_char,
        v: *const ::std::os::raw::c_char,
        cas: u32,
    ) -> bool;
}
extern "C" {
    pub fn sdb_json_num_get(
        s: *mut Sdb,
        k: *const ::std::os::raw::c_char,
        p: *const ::std::os::raw::c_char,
        cas: *mut u32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sdb_json_num_set(
        s: *mut Sdb,
        k: *const ::std::os::raw::c_char,
        p: *const ::std::os::raw::c_char,
        v: ::std::os::raw::c_int,
        cas: u32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sdb_json_num_dec(
        s: *mut Sdb,
        k: *const ::std::os::raw::c_char,
        p: *const ::std::os::raw::c_char,
        n: ::std::os::raw::c_int,
        cas: u32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sdb_json_num_inc(
        s: *mut Sdb,
        k: *const ::std::os::raw::c_char,
        p: *const ::std::os::raw::c_char,
        n: ::std::os::raw::c_int,
        cas: u32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sdb_json_indent(
        s: *const ::std::os::raw::c_char,
        tab: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn sdb_json_unindent(s: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SdbJsonString {
    pub buf: *mut ::std::os::raw::c_char,
    pub blen: size_t,
    pub len: size_t,
}
#[test]
fn bindgen_test_layout_SdbJsonString() {
    assert_eq!(
        ::std::mem::size_of::<SdbJsonString>(),
        24usize,
        concat!("Size of: ", stringify!(SdbJsonString))
    );
    assert_eq!(
        ::std::mem::align_of::<SdbJsonString>(),
        8usize,
        concat!("Alignment of ", stringify!(SdbJsonString))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<SdbJsonString>())).buf as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(SdbJsonString),
            "::",
            stringify!(buf)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<SdbJsonString>())).blen as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(SdbJsonString),
            "::",
            stringify!(blen)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<SdbJsonString>())).len as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(SdbJsonString),
            "::",
            stringify!(len)
        )
    );
}
extern "C" {
    pub fn sdb_json_format(
        s: *mut SdbJsonString,
        fmt: *const ::std::os::raw::c_char,
        ...
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn sdb_ns(
        s: *mut Sdb,
        name: *const ::std::os::raw::c_char,
        create: ::std::os::raw::c_int,
    ) -> *mut Sdb;
}
extern "C" {
    pub fn sdb_ns_path(
        s: *mut Sdb,
        path: *const ::std::os::raw::c_char,
        create: ::std::os::raw::c_int,
    ) -> *mut Sdb;
}
extern "C" {
    pub fn sdb_ns_init(s: *mut Sdb);
}
extern "C" {
    pub fn sdb_ns_free(s: *mut Sdb);
}
extern "C" {
    pub fn sdb_ns_lock(s: *mut Sdb, lock: ::std::os::raw::c_int, depth: ::std::os::raw::c_int);
}
extern "C" {
    pub fn sdb_ns_sync(s: *mut Sdb);
}
extern "C" {
    pub fn sdb_ns_set(
        s: *mut Sdb,
        name: *const ::std::os::raw::c_char,
        r: *mut Sdb,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sdb_ns_unset(s: *mut Sdb, name: *const ::std::os::raw::c_char, r: *mut Sdb) -> bool;
}
extern "C" {
    pub fn sdb_array_contains(
        s: *mut Sdb,
        key: *const ::std::os::raw::c_char,
        val: *const ::std::os::raw::c_char,
        cas: *mut u32,
    ) -> bool;
}
extern "C" {
    pub fn sdb_array_contains_num(
        s: *mut Sdb,
        key: *const ::std::os::raw::c_char,
        val: u64,
        cas: *mut u32,
    ) -> bool;
}
extern "C" {
    pub fn sdb_array_indexof(
        s: *mut Sdb,
        key: *const ::std::os::raw::c_char,
        val: *const ::std::os::raw::c_char,
        cas: u32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sdb_array_set(
        s: *mut Sdb,
        key: *const ::std::os::raw::c_char,
        idx: ::std::os::raw::c_int,
        val: *const ::std::os::raw::c_char,
        cas: u32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sdb_array_set_num(
        s: *mut Sdb,
        key: *const ::std::os::raw::c_char,
        idx: ::std::os::raw::c_int,
        val: u64,
        cas: u32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sdb_array_append(
        s: *mut Sdb,
        key: *const ::std::os::raw::c_char,
        val: *const ::std::os::raw::c_char,
        cas: u32,
    ) -> bool;
}
extern "C" {
    pub fn sdb_array_append_num(
        s: *mut Sdb,
        key: *const ::std::os::raw::c_char,
        val: u64,
        cas: u32,
    ) -> bool;
}
extern "C" {
    pub fn sdb_array_prepend(
        s: *mut Sdb,
        key: *const ::std::os::raw::c_char,
        val: *const ::std::os::raw::c_char,
        cas: u32,
    ) -> bool;
}
extern "C" {
    pub fn sdb_array_prepend_num(
        s: *mut Sdb,
        key: *const ::std::os::raw::c_char,
        val: u64,
        cas: u32,
    ) -> bool;
}
extern "C" {
    pub fn sdb_array_get(
        s: *mut Sdb,
        key: *const ::std::os::raw::c_char,
        idx: ::std::os::raw::c_int,
        cas: *mut u32,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn sdb_array_get_num(
        s: *mut Sdb,
        key: *const ::std::os::raw::c_char,
        idx: ::std::os::raw::c_int,
        cas: *mut u32,
    ) -> u64;
}
extern "C" {
    pub fn sdb_array_get_idx(
        s: *mut Sdb,
        key: *const ::std::os::raw::c_char,
        val: *const ::std::os::raw::c_char,
        cas: u32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sdb_array_insert(
        s: *mut Sdb,
        key: *const ::std::os::raw::c_char,
        idx: ::std::os::raw::c_int,
        val: *const ::std::os::raw::c_char,
        cas: u32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sdb_array_insert_num(
        s: *mut Sdb,
        key: *const ::std::os::raw::c_char,
        idx: ::std::os::raw::c_int,
        val: u64,
        cas: u32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sdb_array_unset(
        s: *mut Sdb,
        key: *const ::std::os::raw::c_char,
        n: ::std::os::raw::c_int,
        cas: u32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sdb_array_delete(
        s: *mut Sdb,
        key: *const ::std::os::raw::c_char,
        n: ::std::os::raw::c_int,
        cas: u32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sdb_array_sort(s: *mut Sdb, key: *const ::std::os::raw::c_char, cas: u32);
}
extern "C" {
    pub fn sdb_array_sort_num(s: *mut Sdb, key: *const ::std::os::raw::c_char, cas: u32);
}
extern "C" {
    pub fn sdb_array_add(
        s: *mut Sdb,
        key: *const ::std::os::raw::c_char,
        val: *const ::std::os::raw::c_char,
        cas: u32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sdb_array_add_num(
        s: *mut Sdb,
        key: *const ::std::os::raw::c_char,
        val: u64,
        cas: u32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sdb_array_add_sorted(
        s: *mut Sdb,
        key: *const ::std::os::raw::c_char,
        val: *const ::std::os::raw::c_char,
        cas: u32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sdb_array_add_sorted_num(
        s: *mut Sdb,
        key: *const ::std::os::raw::c_char,
        val: u64,
        cas: u32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sdb_array_remove(
        s: *mut Sdb,
        key: *const ::std::os::raw::c_char,
        val: *const ::std::os::raw::c_char,
        cas: u32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sdb_array_remove_num(
        s: *mut Sdb,
        key: *const ::std::os::raw::c_char,
        val: u64,
        cas: u32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sdb_anext(
        str_: *mut ::std::os::raw::c_char,
        next: *mut *mut ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn sdb_const_anext(str_: *const ::std::os::raw::c_char) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn sdb_alen(str_: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sdb_alen_ignore_empty(str_: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sdb_array_size(s: *mut Sdb, key: *const ::std::os::raw::c_char)
        -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sdb_array_length(
        s: *mut Sdb,
        key: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sdb_array_list(s: *mut Sdb, key: *const ::std::os::raw::c_char)
        -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sdb_array_push(
        s: *mut Sdb,
        key: *const ::std::os::raw::c_char,
        val: *const ::std::os::raw::c_char,
        cas: u32,
    ) -> bool;
}
extern "C" {
    pub fn sdb_array_pop(
        s: *mut Sdb,
        key: *const ::std::os::raw::c_char,
        cas: *mut u32,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn sdb_array_push_num(
        s: *mut Sdb,
        key: *const ::std::os::raw::c_char,
        num: u64,
        cas: u32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sdb_array_pop_num(s: *mut Sdb, key: *const ::std::os::raw::c_char, cas: *mut u32)
        -> u64;
}
extern "C" {
    pub fn sdb_array_pop_head(
        s: *mut Sdb,
        key: *const ::std::os::raw::c_char,
        cas: *mut u32,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn sdb_array_pop_tail(
        s: *mut Sdb,
        key: *const ::std::os::raw::c_char,
        cas: *mut u32,
    ) -> *mut ::std::os::raw::c_char;
}
pub type SdbHook = ::std::option::Option<
    unsafe extern "C" fn(
        s: *mut Sdb,
        user: *mut ::std::os::raw::c_void,
        k: *const ::std::os::raw::c_char,
        v: *const ::std::os::raw::c_char,
    ),
>;
extern "C" {
    pub fn sdb_hook(s: *mut Sdb, cb: SdbHook, user: *mut ::std::os::raw::c_void) -> bool;
}
extern "C" {
    pub fn sdb_unhook(s: *mut Sdb, h: SdbHook) -> bool;
}
extern "C" {
    pub fn sdb_hook_call(
        s: *mut Sdb,
        k: *const ::std::os::raw::c_char,
        v: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sdb_hook_free(s: *mut Sdb);
}
extern "C" {
    pub fn sdb_isnum(s: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sdb_isempty(s: *mut Sdb) -> bool;
}
extern "C" {
    pub fn sdb_type(k: *const ::std::os::raw::c_char) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn sdb_match(
        str_: *const ::std::os::raw::c_char,
        glob: *const ::std::os::raw::c_char,
    ) -> bool;
}
extern "C" {
    pub fn sdb_bool_set(
        db: *mut Sdb,
        str_: *const ::std::os::raw::c_char,
        v: bool,
        cas: u32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sdb_bool_get(db: *mut Sdb, str_: *const ::std::os::raw::c_char, cas: *mut u32) -> bool;
}
extern "C" {
    pub fn sdb_decode(
        in_: *const ::std::os::raw::c_char,
        len: *mut ::std::os::raw::c_int,
    ) -> *mut u8;
}
extern "C" {
    pub fn sdb_encode(bin: *const u8, len: ::std::os::raw::c_int) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn sdb_encode_raw(
        bout: *mut ::std::os::raw::c_char,
        bin: *const u8,
        len: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn sdb_decode_raw(
        bout: *mut u8,
        bin: *const ::std::os::raw::c_char,
        len: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sdb_fmt_init(
        p: *mut ::std::os::raw::c_void,
        fmt: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sdb_fmt_free(p: *mut ::std::os::raw::c_void, fmt: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn sdb_fmt_tobin(
        _str: *const ::std::os::raw::c_char,
        fmt: *const ::std::os::raw::c_char,
        stru: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sdb_fmt_tostr(
        stru: *mut ::std::os::raw::c_void,
        fmt: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn sdb_fmt_array(list: *const ::std::os::raw::c_char) -> *mut *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn sdb_fmt_array_num(list: *const ::std::os::raw::c_char) -> *mut u64;
}
extern "C" {
    pub fn sdb_array_compact(p: *mut ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn sdb_aslice(
        out: *mut ::std::os::raw::c_char,
        from: ::std::os::raw::c_int,
        to: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
pub type RListFree = ::std::option::Option<unsafe extern "C" fn(ptr: *mut ::std::os::raw::c_void)>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_list_iter_t {
    pub data: *mut ::std::os::raw::c_void,
    pub n: *mut r_list_iter_t,
    pub p: *mut r_list_iter_t,
}
#[test]
fn bindgen_test_layout_r_list_iter_t() {
    assert_eq!(
        ::std::mem::size_of::<r_list_iter_t>(),
        24usize,
        concat!("Size of: ", stringify!(r_list_iter_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_list_iter_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_list_iter_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_list_iter_t>())).data as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_list_iter_t),
            "::",
            stringify!(data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_list_iter_t>())).n as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_list_iter_t),
            "::",
            stringify!(n)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_list_iter_t>())).p as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(r_list_iter_t),
            "::",
            stringify!(p)
        )
    );
}
pub type RListIter = r_list_iter_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_list_t {
    pub head: *mut RListIter,
    pub tail: *mut RListIter,
    pub free: RListFree,
    pub length: ::std::os::raw::c_int,
    pub sorted: bool,
}
#[test]
fn bindgen_test_layout_r_list_t() {
    assert_eq!(
        ::std::mem::size_of::<r_list_t>(),
        32usize,
        concat!("Size of: ", stringify!(r_list_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_list_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_list_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_list_t>())).head as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_list_t),
            "::",
            stringify!(head)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_list_t>())).tail as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_list_t),
            "::",
            stringify!(tail)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_list_t>())).free as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(r_list_t),
            "::",
            stringify!(free)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_list_t>())).length as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(r_list_t),
            "::",
            stringify!(length)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_list_t>())).sorted as *const _ as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(r_list_t),
            "::",
            stringify!(sorted)
        )
    );
}
pub type RList = r_list_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_list_range_t {
    pub h: *mut HtPP,
    pub l: *mut RList,
}
#[test]
fn bindgen_test_layout_r_list_range_t() {
    assert_eq!(
        ::std::mem::size_of::<r_list_range_t>(),
        16usize,
        concat!("Size of: ", stringify!(r_list_range_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_list_range_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_list_range_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_list_range_t>())).h as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_list_range_t),
            "::",
            stringify!(h)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_list_range_t>())).l as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_list_range_t),
            "::",
            stringify!(l)
        )
    );
}
pub type RListRange = r_list_range_t;
pub type RListComparator = ::std::option::Option<
    unsafe extern "C" fn(
        a: *const ::std::os::raw::c_void,
        b: *const ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int,
>;
pub type RListComparatorItem =
    ::std::option::Option<unsafe extern "C" fn(a: *const ::std::os::raw::c_void) -> u64>;
extern "C" {
    pub fn r_list_new() -> *mut RList;
}
extern "C" {
    pub fn r_list_newf(f: RListFree) -> *mut RList;
}
extern "C" {
    pub fn r_list_iter_get_next(list: *mut RListIter) -> *mut RListIter;
}
extern "C" {
    pub fn r_list_iter_get_prev(list: *mut RListIter) -> *mut RListIter;
}
extern "C" {
    pub fn r_list_set_n(
        list: *mut RList,
        n: ::std::os::raw::c_int,
        p: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_list_iter_get_data(list: *mut RListIter) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn r_list_append(list: *mut RList, data: *mut ::std::os::raw::c_void) -> *mut RListIter;
}
extern "C" {
    pub fn r_list_prepend(list: *mut RList, data: *mut ::std::os::raw::c_void) -> *mut RListIter;
}
extern "C" {
    pub fn r_list_insert(
        list: *mut RList,
        n: u32,
        data: *mut ::std::os::raw::c_void,
    ) -> *mut RListIter;
}
extern "C" {
    pub fn r_list_length(list: *const RList) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_list_iter_length(iter: *mut RListIter) -> size_t;
}
extern "C" {
    pub fn r_list_first(list: *const RList) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn r_list_last(list: *const RList) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn r_list_add_sorted(
        list: *mut RList,
        data: *mut ::std::os::raw::c_void,
        cmp: RListComparator,
    ) -> *mut RListIter;
}
extern "C" {
    pub fn r_list_sort(list: *mut RList, cmp: RListComparator);
}
extern "C" {
    pub fn r_list_merge_sort(list: *mut RList, cmp: RListComparator);
}
extern "C" {
    pub fn r_list_insertion_sort(list: *mut RList, cmp: RListComparator);
}
extern "C" {
    pub fn r_list_uniq(list: *const RList, cmp: RListComparatorItem) -> *mut RList;
}
extern "C" {
    pub fn r_list_uniq_inplace(list: *mut RList, cmp: RListComparatorItem)
        -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_list_init(list: *mut RList);
}
extern "C" {
    pub fn r_list_delete(list: *mut RList, iter: *mut RListIter);
}
extern "C" {
    pub fn r_list_delete_data(list: *mut RList, ptr: *mut ::std::os::raw::c_void) -> bool;
}
extern "C" {
    pub fn r_list_iter_init(iter: *mut RListIter, list: *mut RList);
}
extern "C" {
    pub fn r_list_purge(list: *mut RList);
}
extern "C" {
    pub fn r_list_free(list: *mut RList);
}
extern "C" {
    pub fn r_list_item_new(data: *mut ::std::os::raw::c_void) -> *mut RListIter;
}
extern "C" {
    pub fn r_list_split(list: *mut RList, ptr: *mut ::std::os::raw::c_void);
}
extern "C" {
    pub fn r_list_split_iter(list: *mut RList, iter: *mut RListIter);
}
extern "C" {
    pub fn r_list_join(list1: *mut RList, list2: *mut RList) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_list_get_n(
        list: *const RList,
        n: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn r_list_del_n(list: *mut RList, n: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_list_get_top(list: *const RList) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn r_list_get_bottom(list: *const RList) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn r_list_iter_to_top(list: *mut RList, iter: *mut RListIter);
}
extern "C" {
    pub fn r_list_pop(list: *mut RList) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn r_list_pop_head(list: *mut RList) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn r_list_reverse(list: *mut RList);
}
extern "C" {
    pub fn r_list_clone(list: *const RList) -> *mut RList;
}
extern "C" {
    pub fn r_list_to_str(
        list: *mut RList,
        ch: ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_list_contains(list: *const RList, p: *const ::std::os::raw::c_void) -> *mut RListIter;
}
extern "C" {
    pub fn r_list_find(
        list: *const RList,
        p: *const ::std::os::raw::c_void,
        cmp: RListComparator,
    ) -> *mut RListIter;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_regex_t {
    pub re_magic: ::std::os::raw::c_int,
    pub re_nsub: size_t,
    pub re_endp: *const ::std::os::raw::c_char,
    pub re_g: *mut re_guts,
    pub re_flags: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_r_regex_t() {
    assert_eq!(
        ::std::mem::size_of::<r_regex_t>(),
        40usize,
        concat!("Size of: ", stringify!(r_regex_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_regex_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_regex_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_regex_t>())).re_magic as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_regex_t),
            "::",
            stringify!(re_magic)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_regex_t>())).re_nsub as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_regex_t),
            "::",
            stringify!(re_nsub)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_regex_t>())).re_endp as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(r_regex_t),
            "::",
            stringify!(re_endp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_regex_t>())).re_g as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(r_regex_t),
            "::",
            stringify!(re_g)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_regex_t>())).re_flags as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(r_regex_t),
            "::",
            stringify!(re_flags)
        )
    );
}
pub type RRegex = r_regex_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_regmatch_t {
    pub rm_so: i64,
    pub rm_eo: i64,
}
#[test]
fn bindgen_test_layout_r_regmatch_t() {
    assert_eq!(
        ::std::mem::size_of::<r_regmatch_t>(),
        16usize,
        concat!("Size of: ", stringify!(r_regmatch_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_regmatch_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_regmatch_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_regmatch_t>())).rm_so as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_regmatch_t),
            "::",
            stringify!(rm_so)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_regmatch_t>())).rm_eo as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_regmatch_t),
            "::",
            stringify!(rm_eo)
        )
    );
}
pub type RRegexMatch = r_regmatch_t;
extern "C" {
    pub fn r_regex_run(
        pattern: *const ::std::os::raw::c_char,
        flags: *const ::std::os::raw::c_char,
        text: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_regex_match(
        pattern: *const ::std::os::raw::c_char,
        flags: *const ::std::os::raw::c_char,
        text: *const ::std::os::raw::c_char,
    ) -> bool;
}
extern "C" {
    pub fn r_regex_flags(flags: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_regex_new(
        pattern: *const ::std::os::raw::c_char,
        cflags: *const ::std::os::raw::c_char,
    ) -> *mut RRegex;
}
extern "C" {
    pub fn r_regex_free(arg1: *mut RRegex);
}
extern "C" {
    pub fn r_regex_init(
        arg1: *mut RRegex,
        pattern: *const ::std::os::raw::c_char,
        flags: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_regex_fini(arg1: *mut RRegex);
}
extern "C" {
    pub fn r_regex_check(rr: *const RRegex, str_: *const ::std::os::raw::c_char) -> bool;
}
extern "C" {
    pub fn r_regex_exec(
        preg: *const RRegex,
        string: *const ::std::os::raw::c_char,
        nmatch: size_t,
        __pmatch: *mut RRegexMatch,
        eflags: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_regex_match_list(rx: *mut RRegex, text: *const ::std::os::raw::c_char) -> *mut RList;
}
extern "C" {
    pub fn r_regex_error(
        rx: *mut RRegex,
        errcode: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_skiplist_node_t {
    pub data: *mut ::std::os::raw::c_void,
    pub forward: *mut *mut r_skiplist_node_t,
}
#[test]
fn bindgen_test_layout_r_skiplist_node_t() {
    assert_eq!(
        ::std::mem::size_of::<r_skiplist_node_t>(),
        16usize,
        concat!("Size of: ", stringify!(r_skiplist_node_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_skiplist_node_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_skiplist_node_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_skiplist_node_t>())).data as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_skiplist_node_t),
            "::",
            stringify!(data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_skiplist_node_t>())).forward as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_skiplist_node_t),
            "::",
            stringify!(forward)
        )
    );
}
pub type RSkipListNode = r_skiplist_node_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_skiplist_t {
    pub head: *mut RSkipListNode,
    pub list_level: ::std::os::raw::c_int,
    pub size: ::std::os::raw::c_int,
    pub freefn: RListFree,
    pub compare: RListComparator,
}
#[test]
fn bindgen_test_layout_r_skiplist_t() {
    assert_eq!(
        ::std::mem::size_of::<r_skiplist_t>(),
        32usize,
        concat!("Size of: ", stringify!(r_skiplist_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_skiplist_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_skiplist_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_skiplist_t>())).head as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_skiplist_t),
            "::",
            stringify!(head)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_skiplist_t>())).list_level as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_skiplist_t),
            "::",
            stringify!(list_level)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_skiplist_t>())).size as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(r_skiplist_t),
            "::",
            stringify!(size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_skiplist_t>())).freefn as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(r_skiplist_t),
            "::",
            stringify!(freefn)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_skiplist_t>())).compare as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(r_skiplist_t),
            "::",
            stringify!(compare)
        )
    );
}
pub type RSkipList = r_skiplist_t;
extern "C" {
    pub fn r_skiplist_new(freefn: RListFree, comparefn: RListComparator) -> *mut RSkipList;
}
extern "C" {
    pub fn r_skiplist_free(list: *mut RSkipList);
}
extern "C" {
    pub fn r_skiplist_purge(list: *mut RSkipList);
}
extern "C" {
    pub fn r_skiplist_insert(
        list: *mut RSkipList,
        data: *mut ::std::os::raw::c_void,
    ) -> *mut RSkipListNode;
}
extern "C" {
    pub fn r_skiplist_insert_autofree(
        list: *mut RSkipList,
        data: *mut ::std::os::raw::c_void,
    ) -> bool;
}
extern "C" {
    pub fn r_skiplist_delete(list: *mut RSkipList, data: *mut ::std::os::raw::c_void) -> bool;
}
extern "C" {
    pub fn r_skiplist_delete_node(list: *mut RSkipList, node: *mut RSkipListNode) -> bool;
}
extern "C" {
    pub fn r_skiplist_find(
        list: *mut RSkipList,
        data: *mut ::std::os::raw::c_void,
    ) -> *mut RSkipListNode;
}
extern "C" {
    pub fn r_skiplist_find_geq(
        list: *mut RSkipList,
        data: *mut ::std::os::raw::c_void,
    ) -> *mut RSkipListNode;
}
extern "C" {
    pub fn r_skiplist_find_leq(
        list: *mut RSkipList,
        data: *mut ::std::os::raw::c_void,
    ) -> *mut RSkipListNode;
}
extern "C" {
    pub fn r_skiplist_join(l1: *mut RSkipList, l2: *mut RSkipList);
}
extern "C" {
    pub fn r_skiplist_get_first(list: *mut RSkipList) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn r_skiplist_get_n(
        list: *mut RSkipList,
        n: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn r_skiplist_get_geq(
        list: *mut RSkipList,
        data: *mut ::std::os::raw::c_void,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn r_skiplist_get_leq(
        list: *mut RSkipList,
        data: *mut ::std::os::raw::c_void,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn r_skiplist_empty(list: *mut RSkipList) -> bool;
}
extern "C" {
    pub fn r_skiplist_to_list(list: *mut RSkipList) -> *mut RList;
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union sem_t {
    pub __size: [::std::os::raw::c_char; 32usize],
    pub __align: ::std::os::raw::c_long,
}
#[test]
fn bindgen_test_layout_sem_t() {
    assert_eq!(
        ::std::mem::size_of::<sem_t>(),
        32usize,
        concat!("Size of: ", stringify!(sem_t))
    );
    assert_eq!(
        ::std::mem::align_of::<sem_t>(),
        8usize,
        concat!("Alignment of ", stringify!(sem_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sem_t>())).__size as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sem_t),
            "::",
            stringify!(__size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sem_t>())).__align as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sem_t),
            "::",
            stringify!(__align)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct tm {
    pub tm_sec: ::std::os::raw::c_int,
    pub tm_min: ::std::os::raw::c_int,
    pub tm_hour: ::std::os::raw::c_int,
    pub tm_mday: ::std::os::raw::c_int,
    pub tm_mon: ::std::os::raw::c_int,
    pub tm_year: ::std::os::raw::c_int,
    pub tm_wday: ::std::os::raw::c_int,
    pub tm_yday: ::std::os::raw::c_int,
    pub tm_isdst: ::std::os::raw::c_int,
    pub tm_gmtoff: ::std::os::raw::c_long,
    pub tm_zone: *const ::std::os::raw::c_char,
}
#[test]
fn bindgen_test_layout_tm() {
    assert_eq!(
        ::std::mem::size_of::<tm>(),
        56usize,
        concat!("Size of: ", stringify!(tm))
    );
    assert_eq!(
        ::std::mem::align_of::<tm>(),
        8usize,
        concat!("Alignment of ", stringify!(tm))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<tm>())).tm_sec as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(tm),
            "::",
            stringify!(tm_sec)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<tm>())).tm_min as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(tm),
            "::",
            stringify!(tm_min)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<tm>())).tm_hour as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(tm),
            "::",
            stringify!(tm_hour)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<tm>())).tm_mday as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(tm),
            "::",
            stringify!(tm_mday)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<tm>())).tm_mon as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(tm),
            "::",
            stringify!(tm_mon)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<tm>())).tm_year as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(tm),
            "::",
            stringify!(tm_year)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<tm>())).tm_wday as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(tm),
            "::",
            stringify!(tm_wday)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<tm>())).tm_yday as *const _ as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(tm),
            "::",
            stringify!(tm_yday)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<tm>())).tm_isdst as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(tm),
            "::",
            stringify!(tm_isdst)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<tm>())).tm_gmtoff as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(tm),
            "::",
            stringify!(tm_gmtoff)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<tm>())).tm_zone as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(tm),
            "::",
            stringify!(tm_zone)
        )
    );
}
pub const RThreadFunctionRet_R_TH_FREED: RThreadFunctionRet = -1;
pub const RThreadFunctionRet_R_TH_STOP: RThreadFunctionRet = 0;
pub const RThreadFunctionRet_R_TH_REPEAT: RThreadFunctionRet = 1;
pub type RThreadFunctionRet = ::std::os::raw::c_int;
pub type RThreadFunction =
    ::std::option::Option<unsafe extern "C" fn(arg1: *mut r_th_t) -> RThreadFunctionRet>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_th_sem_t {
    pub sem: *mut sem_t,
}
#[test]
fn bindgen_test_layout_r_th_sem_t() {
    assert_eq!(
        ::std::mem::size_of::<r_th_sem_t>(),
        8usize,
        concat!("Size of: ", stringify!(r_th_sem_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_th_sem_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_th_sem_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_th_sem_t>())).sem as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_th_sem_t),
            "::",
            stringify!(sem)
        )
    );
}
pub type RThreadSemaphore = r_th_sem_t;
pub const r_th_lock_type_t_R_TH_LOCK_TYPE_STATIC: r_th_lock_type_t = 0;
pub const r_th_lock_type_t_R_TH_LOCK_TYPE_HEAP: r_th_lock_type_t = 1;
pub type r_th_lock_type_t = ::std::os::raw::c_uint;
pub use self::r_th_lock_type_t as RThreadLockType;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct r_th_lock_t {
    pub activating: ::std::os::raw::c_int,
    pub __bindgen_anon_1: r_th_lock_t__bindgen_ty_1,
    pub lock: pthread_mutex_t,
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct r_th_lock_t__bindgen_ty_1 {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
    pub __bindgen_padding_0: [u8; 3usize],
}
#[test]
fn bindgen_test_layout_r_th_lock_t__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<r_th_lock_t__bindgen_ty_1>(),
        4usize,
        concat!("Size of: ", stringify!(r_th_lock_t__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<r_th_lock_t__bindgen_ty_1>(),
        4usize,
        concat!("Alignment of ", stringify!(r_th_lock_t__bindgen_ty_1))
    );
}
impl r_th_lock_t__bindgen_ty_1 {
    #[inline]
    pub fn active(&self) -> u8 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_active(&mut self, val: u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn type_(&self) -> RThreadLockType {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 7u8) as u32) }
    }
    #[inline]
    pub fn set_type(&mut self, val: RThreadLockType) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 7u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        active: u8,
        type_: RThreadLockType,
    ) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let active: u8 = unsafe { ::std::mem::transmute(active) };
            active as u64
        });
        __bindgen_bitfield_unit.set(1usize, 7u8, {
            let type_: u32 = unsafe { ::std::mem::transmute(type_) };
            type_ as u64
        });
        __bindgen_bitfield_unit
    }
}
#[test]
fn bindgen_test_layout_r_th_lock_t() {
    assert_eq!(
        ::std::mem::size_of::<r_th_lock_t>(),
        48usize,
        concat!("Size of: ", stringify!(r_th_lock_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_th_lock_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_th_lock_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_th_lock_t>())).activating as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_th_lock_t),
            "::",
            stringify!(activating)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_th_lock_t>())).lock as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_th_lock_t),
            "::",
            stringify!(lock)
        )
    );
}
pub type RThreadLock = r_th_lock_t;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct r_th_cond_t {
    pub cond: pthread_cond_t,
}
#[test]
fn bindgen_test_layout_r_th_cond_t() {
    assert_eq!(
        ::std::mem::size_of::<r_th_cond_t>(),
        48usize,
        concat!("Size of: ", stringify!(r_th_cond_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_th_cond_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_th_cond_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_th_cond_t>())).cond as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_th_cond_t),
            "::",
            stringify!(cond)
        )
    );
}
pub type RThreadCond = r_th_cond_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_th_t {
    pub tid: pthread_t,
    pub lock: *mut RThreadLock,
    pub fun: RThreadFunction,
    pub user: *mut ::std::os::raw::c_void,
    pub running: bool,
    pub breaked: ::std::os::raw::c_int,
    pub delay: ::std::os::raw::c_int,
    pub ready: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_r_th_t() {
    assert_eq!(
        ::std::mem::size_of::<r_th_t>(),
        48usize,
        concat!("Size of: ", stringify!(r_th_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_th_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_th_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_th_t>())).tid as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_th_t),
            "::",
            stringify!(tid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_th_t>())).lock as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_th_t),
            "::",
            stringify!(lock)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_th_t>())).fun as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(r_th_t),
            "::",
            stringify!(fun)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_th_t>())).user as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(r_th_t),
            "::",
            stringify!(user)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_th_t>())).running as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(r_th_t),
            "::",
            stringify!(running)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_th_t>())).breaked as *const _ as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(r_th_t),
            "::",
            stringify!(breaked)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_th_t>())).delay as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(r_th_t),
            "::",
            stringify!(delay)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_th_t>())).ready as *const _ as usize },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(r_th_t),
            "::",
            stringify!(ready)
        )
    );
}
pub type RThread = r_th_t;
extern "C" {
    pub fn r_th_new(
        fun: RThreadFunction,
        user: *mut ::std::os::raw::c_void,
        delay: ::std::os::raw::c_int,
    ) -> *mut RThread;
}
extern "C" {
    pub fn r_th_start(th: *mut RThread, enable: ::std::os::raw::c_int) -> bool;
}
extern "C" {
    pub fn r_th_wait(th: *mut RThread) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_th_wait_async(th: *mut RThread) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_th_break(th: *mut RThread);
}
extern "C" {
    pub fn r_th_free(th: *mut RThread) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn r_th_set_running(th: *mut RThread, b: bool);
}
extern "C" {
    pub fn r_th_is_running(th: *mut RThread) -> bool;
}
extern "C" {
    pub fn r_th_kill_free(th: *mut RThread) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn r_th_kill(th: *mut RThread, force: bool) -> bool;
}
extern "C" {
    pub fn r_th_self() -> pthread_t;
}
extern "C" {
    pub fn r_th_setname(th: *mut RThread, name: *const ::std::os::raw::c_char) -> bool;
}
extern "C" {
    pub fn r_th_getname(th: *mut RThread, name: *mut ::std::os::raw::c_char, len: size_t) -> bool;
}
extern "C" {
    pub fn r_th_setaffinity(th: *mut RThread, cpuid: ::std::os::raw::c_int) -> bool;
}
extern "C" {
    pub fn r_th_sem_new(initial: ::std::os::raw::c_uint) -> *mut RThreadSemaphore;
}
extern "C" {
    pub fn r_th_sem_free(sem: *mut RThreadSemaphore);
}
extern "C" {
    pub fn r_th_sem_post(sem: *mut RThreadSemaphore);
}
extern "C" {
    pub fn r_th_sem_wait(sem: *mut RThreadSemaphore);
}
extern "C" {
    pub fn r_th_lock_new(recursive: bool) -> *mut RThreadLock;
}
extern "C" {
    pub fn r_th_lock_wait(th: *mut RThreadLock) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_th_lock_tryenter(thl: *mut RThreadLock) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_th_lock_enter(thl: *mut RThreadLock) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_th_lock_leave(thl: *mut RThreadLock) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_th_lock_free(thl: *mut RThreadLock) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn r_th_cond_new() -> *mut RThreadCond;
}
extern "C" {
    pub fn r_th_cond_signal(cond: *mut RThreadCond);
}
extern "C" {
    pub fn r_th_cond_signal_all(cond: *mut RThreadCond);
}
extern "C" {
    pub fn r_th_cond_wait(cond: *mut RThreadCond, lock: *mut RThreadLock);
}
extern "C" {
    pub fn r_th_cond_free(cond: *mut RThreadCond);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ht_up_kv {
    pub key: u64,
    pub value: *mut ::std::os::raw::c_void,
    pub key_len: u32,
    pub value_len: u32,
}
#[test]
fn bindgen_test_layout_ht_up_kv() {
    assert_eq!(
        ::std::mem::size_of::<ht_up_kv>(),
        24usize,
        concat!("Size of: ", stringify!(ht_up_kv))
    );
    assert_eq!(
        ::std::mem::align_of::<ht_up_kv>(),
        8usize,
        concat!("Alignment of ", stringify!(ht_up_kv))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ht_up_kv>())).key as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(ht_up_kv),
            "::",
            stringify!(key)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ht_up_kv>())).value as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(ht_up_kv),
            "::",
            stringify!(value)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ht_up_kv>())).key_len as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(ht_up_kv),
            "::",
            stringify!(key_len)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ht_up_kv>())).value_len as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(ht_up_kv),
            "::",
            stringify!(value_len)
        )
    );
}
pub type HtUPKv = ht_up_kv;
pub type HtUPKvFreeFunc = ::std::option::Option<unsafe extern "C" fn(arg1: *mut HtUPKv)>;
pub type HtUPDupKey = ::std::option::Option<unsafe extern "C" fn(arg1: u64) -> u64>;
pub type HtUPDupValue = ::std::option::Option<
    unsafe extern "C" fn(arg1: *const ::std::os::raw::c_void) -> *mut ::std::os::raw::c_void,
>;
pub type HtUPCalcSizeK = ::std::option::Option<unsafe extern "C" fn(arg1: u64) -> u32>;
pub type HtUPCalcSizeV =
    ::std::option::Option<unsafe extern "C" fn(arg1: *const ::std::os::raw::c_void) -> u32>;
pub type HtUPHashFunction = ::std::option::Option<unsafe extern "C" fn(arg1: u64) -> u32>;
pub type HtUPListComparator =
    ::std::option::Option<unsafe extern "C" fn(arg1: u64, arg2: u64) -> ::std::os::raw::c_int>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ht_up_bucket_t {
    pub arr: *mut HtUPKv,
    pub count: u32,
}
#[test]
fn bindgen_test_layout_ht_up_bucket_t() {
    assert_eq!(
        ::std::mem::size_of::<ht_up_bucket_t>(),
        16usize,
        concat!("Size of: ", stringify!(ht_up_bucket_t))
    );
    assert_eq!(
        ::std::mem::align_of::<ht_up_bucket_t>(),
        8usize,
        concat!("Alignment of ", stringify!(ht_up_bucket_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ht_up_bucket_t>())).arr as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(ht_up_bucket_t),
            "::",
            stringify!(arr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ht_up_bucket_t>())).count as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(ht_up_bucket_t),
            "::",
            stringify!(count)
        )
    );
}
pub type HtUPBucket = ht_up_bucket_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ht_up_options_t {
    pub cmp: HtUPListComparator,
    pub hashfn: HtUPHashFunction,
    pub dupkey: HtUPDupKey,
    pub dupvalue: HtUPDupValue,
    pub calcsizeK: HtUPCalcSizeK,
    pub calcsizeV: HtUPCalcSizeV,
    pub freefn: HtUPKvFreeFunc,
    pub elem_size: size_t,
}
#[test]
fn bindgen_test_layout_ht_up_options_t() {
    assert_eq!(
        ::std::mem::size_of::<ht_up_options_t>(),
        64usize,
        concat!("Size of: ", stringify!(ht_up_options_t))
    );
    assert_eq!(
        ::std::mem::align_of::<ht_up_options_t>(),
        8usize,
        concat!("Alignment of ", stringify!(ht_up_options_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ht_up_options_t>())).cmp as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(ht_up_options_t),
            "::",
            stringify!(cmp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ht_up_options_t>())).hashfn as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(ht_up_options_t),
            "::",
            stringify!(hashfn)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ht_up_options_t>())).dupkey as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(ht_up_options_t),
            "::",
            stringify!(dupkey)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ht_up_options_t>())).dupvalue as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(ht_up_options_t),
            "::",
            stringify!(dupvalue)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ht_up_options_t>())).calcsizeK as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(ht_up_options_t),
            "::",
            stringify!(calcsizeK)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ht_up_options_t>())).calcsizeV as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(ht_up_options_t),
            "::",
            stringify!(calcsizeV)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ht_up_options_t>())).freefn as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(ht_up_options_t),
            "::",
            stringify!(freefn)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ht_up_options_t>())).elem_size as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(ht_up_options_t),
            "::",
            stringify!(elem_size)
        )
    );
}
pub type HtUPOptions = ht_up_options_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ht_up_t {
    pub size: u32,
    pub count: u32,
    pub table: *mut HtUPBucket,
    pub prime_idx: u32,
    pub opt: HtUPOptions,
}
#[test]
fn bindgen_test_layout_ht_up_t() {
    assert_eq!(
        ::std::mem::size_of::<ht_up_t>(),
        88usize,
        concat!("Size of: ", stringify!(ht_up_t))
    );
    assert_eq!(
        ::std::mem::align_of::<ht_up_t>(),
        8usize,
        concat!("Alignment of ", stringify!(ht_up_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ht_up_t>())).size as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(ht_up_t),
            "::",
            stringify!(size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ht_up_t>())).count as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(ht_up_t),
            "::",
            stringify!(count)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ht_up_t>())).table as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(ht_up_t),
            "::",
            stringify!(table)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ht_up_t>())).prime_idx as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(ht_up_t),
            "::",
            stringify!(prime_idx)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ht_up_t>())).opt as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(ht_up_t),
            "::",
            stringify!(opt)
        )
    );
}
pub type HtUP = ht_up_t;
pub const r_log_level_R_LOGLVL_SILLY: r_log_level = 0;
pub const r_log_level_R_LOGLVL_DEBUG: r_log_level = 1;
pub const r_log_level_R_LOGLVL_VERBOSE: r_log_level = 2;
pub const r_log_level_R_LOGLVL_INFO: r_log_level = 3;
pub const r_log_level_R_LOGLVL_WARN: r_log_level = 4;
pub const r_log_level_R_LOGLVL_ERROR: r_log_level = 5;
pub const r_log_level_R_LOGLVL_FATAL: r_log_level = 6;
pub const r_log_level_R_LOGLVL_NONE: r_log_level = 255;
pub type r_log_level = ::std::os::raw::c_uint;
pub use self::r_log_level as RLogLevel;
pub type RLogCallback = ::std::option::Option<
    unsafe extern "C" fn(
        output: *const ::std::os::raw::c_char,
        funcname: *const ::std::os::raw::c_char,
        filename: *const ::std::os::raw::c_char,
        lineno: u32,
        level: RLogLevel,
        tag: *const ::std::os::raw::c_char,
        fmtstr: *const ::std::os::raw::c_char,
        ...
    ),
>;
extern "C" {
    pub fn r_log_set_level(level: RLogLevel);
}
extern "C" {
    pub fn r_log_set_file(filename: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn r_log_set_srcinfo(show_info: bool);
}
extern "C" {
    pub fn r_log_set_colors(show_colors: bool);
}
extern "C" {
    pub fn r_log_set_traplevel(level: RLogLevel);
}
extern "C" {
    pub fn r_log_add_callback(cbfunc: RLogCallback);
}
extern "C" {
    pub fn r_log_del_callback(cbfunc: RLogCallback);
}
extern "C" {
    pub fn r_log(
        funcname: *const ::std::os::raw::c_char,
        filename: *const ::std::os::raw::c_char,
        lineno: u32,
        level: RLogLevel,
        tag: *const ::std::os::raw::c_char,
        fmtstr: *const ::std::os::raw::c_char,
        ...
    );
}
extern "C" {
    pub fn r_vlog(
        funcname: *const ::std::os::raw::c_char,
        filename: *const ::std::os::raw::c_char,
        lineno: u32,
        level: RLogLevel,
        tag: *const ::std::os::raw::c_char,
        fmtstr: *const ::std::os::raw::c_char,
        args: *mut __va_list_tag,
    );
}
extern "C" {
    pub fn r_assert_log(level: RLogLevel, fmt: *const ::std::os::raw::c_char, ...);
}
pub type RPVectorComparator = ::std::option::Option<
    unsafe extern "C" fn(
        a: *const ::std::os::raw::c_void,
        b: *const ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int,
>;
pub type RVectorFree = ::std::option::Option<
    unsafe extern "C" fn(e: *mut ::std::os::raw::c_void, user: *mut ::std::os::raw::c_void),
>;
pub type RPVectorFree = ::std::option::Option<unsafe extern "C" fn(e: *mut ::std::os::raw::c_void)>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_vector_t {
    pub a: *mut ::std::os::raw::c_void,
    pub len: size_t,
    pub capacity: size_t,
    pub elem_size: size_t,
    pub free: RVectorFree,
    pub free_user: *mut ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout_r_vector_t() {
    assert_eq!(
        ::std::mem::size_of::<r_vector_t>(),
        48usize,
        concat!("Size of: ", stringify!(r_vector_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_vector_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_vector_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_vector_t>())).a as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_vector_t),
            "::",
            stringify!(a)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_vector_t>())).len as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_vector_t),
            "::",
            stringify!(len)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_vector_t>())).capacity as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(r_vector_t),
            "::",
            stringify!(capacity)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_vector_t>())).elem_size as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(r_vector_t),
            "::",
            stringify!(elem_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_vector_t>())).free as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(r_vector_t),
            "::",
            stringify!(free)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_vector_t>())).free_user as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(r_vector_t),
            "::",
            stringify!(free_user)
        )
    );
}
pub type RVector = r_vector_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_pvector_t {
    pub v: RVector,
}
#[test]
fn bindgen_test_layout_r_pvector_t() {
    assert_eq!(
        ::std::mem::size_of::<r_pvector_t>(),
        48usize,
        concat!("Size of: ", stringify!(r_pvector_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_pvector_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_pvector_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_pvector_t>())).v as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_pvector_t),
            "::",
            stringify!(v)
        )
    );
}
pub type RPVector = r_pvector_t;
extern "C" {
    pub fn r_vector_init(
        vec: *mut RVector,
        elem_size: size_t,
        free: RVectorFree,
        free_user: *mut ::std::os::raw::c_void,
    );
}
extern "C" {
    pub fn r_vector_new(
        elem_size: size_t,
        free: RVectorFree,
        free_user: *mut ::std::os::raw::c_void,
    ) -> *mut RVector;
}
extern "C" {
    pub fn r_vector_fini(vec: *mut RVector);
}
extern "C" {
    pub fn r_vector_free(vec: *mut RVector);
}
extern "C" {
    pub fn r_vector_clone(vec: *mut RVector) -> *mut RVector;
}
extern "C" {
    pub fn r_vector_clear(vec: *mut RVector);
}
extern "C" {
    pub fn r_vector_assign(
        vec: *mut RVector,
        p: *mut ::std::os::raw::c_void,
        elem: *mut ::std::os::raw::c_void,
    );
}
extern "C" {
    pub fn r_vector_assign_at(
        vec: *mut RVector,
        index: size_t,
        elem: *mut ::std::os::raw::c_void,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn r_vector_remove_at(vec: *mut RVector, index: size_t, into: *mut ::std::os::raw::c_void);
}
extern "C" {
    pub fn r_vector_insert(
        vec: *mut RVector,
        index: size_t,
        x: *mut ::std::os::raw::c_void,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn r_vector_insert_range(
        vec: *mut RVector,
        index: size_t,
        first: *mut ::std::os::raw::c_void,
        count: size_t,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn r_vector_pop(vec: *mut RVector, into: *mut ::std::os::raw::c_void);
}
extern "C" {
    pub fn r_vector_pop_front(vec: *mut RVector, into: *mut ::std::os::raw::c_void);
}
extern "C" {
    pub fn r_vector_push(
        vec: *mut RVector,
        x: *mut ::std::os::raw::c_void,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn r_vector_push_front(
        vec: *mut RVector,
        x: *mut ::std::os::raw::c_void,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn r_vector_reserve(vec: *mut RVector, capacity: size_t) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn r_vector_shrink(vec: *mut RVector) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn r_vector_flush(vec: *mut RVector) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn r_pvector_init(vec: *mut RPVector, free: RPVectorFree);
}
extern "C" {
    pub fn r_pvector_fini(vec: *mut RPVector);
}
extern "C" {
    pub fn r_pvector_new(free: RPVectorFree) -> *mut RPVector;
}
extern "C" {
    pub fn r_pvector_new_with_len(free: RPVectorFree, length: size_t) -> *mut RPVector;
}
extern "C" {
    pub fn r_pvector_clear(vec: *mut RPVector);
}
extern "C" {
    pub fn r_pvector_free(vec: *mut RPVector);
}
extern "C" {
    pub fn r_pvector_contains(
        vec: *mut RPVector,
        x: *mut ::std::os::raw::c_void,
    ) -> *mut *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn r_pvector_remove_at(vec: *mut RPVector, index: size_t) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn r_pvector_remove_data(vec: *mut RPVector, x: *mut ::std::os::raw::c_void);
}
extern "C" {
    pub fn r_pvector_pop(vec: *mut RPVector) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn r_pvector_pop_front(vec: *mut RPVector) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn r_pvector_sort(vec: *mut RPVector, cmp: RPVectorComparator);
}
extern "C" {
    pub fn r_pvector_bsearch(
        vec: *mut RPVector,
        needle: *mut ::std::os::raw::c_void,
        cmp: RPVectorComparator,
    ) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_event_t {
    pub user: *mut ::std::os::raw::c_void,
    pub incall: bool,
    pub callbacks: *mut HtUP,
    pub all_callbacks: RVector,
    pub next_handle: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_r_event_t() {
    assert_eq!(
        ::std::mem::size_of::<r_event_t>(),
        80usize,
        concat!("Size of: ", stringify!(r_event_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_event_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_event_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_event_t>())).user as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_event_t),
            "::",
            stringify!(user)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_event_t>())).incall as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_event_t),
            "::",
            stringify!(incall)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_event_t>())).callbacks as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(r_event_t),
            "::",
            stringify!(callbacks)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_event_t>())).all_callbacks as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(r_event_t),
            "::",
            stringify!(all_callbacks)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_event_t>())).next_handle as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(r_event_t),
            "::",
            stringify!(next_handle)
        )
    );
}
pub type REvent = r_event_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_event_callback_handle_t {
    pub handle: ::std::os::raw::c_int,
    pub type_: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_r_event_callback_handle_t() {
    assert_eq!(
        ::std::mem::size_of::<r_event_callback_handle_t>(),
        8usize,
        concat!("Size of: ", stringify!(r_event_callback_handle_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_event_callback_handle_t>(),
        4usize,
        concat!("Alignment of ", stringify!(r_event_callback_handle_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_event_callback_handle_t>())).handle as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_event_callback_handle_t),
            "::",
            stringify!(handle)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_event_callback_handle_t>())).type_ as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(r_event_callback_handle_t),
            "::",
            stringify!(type_)
        )
    );
}
pub type REventCallbackHandle = r_event_callback_handle_t;
pub type REventCallback = ::std::option::Option<
    unsafe extern "C" fn(
        ev: *mut REvent,
        type_: ::std::os::raw::c_int,
        user: *mut ::std::os::raw::c_void,
        data: *mut ::std::os::raw::c_void,
    ),
>;
extern "C" {
    pub fn r_event_new(user: *mut ::std::os::raw::c_void) -> *mut REvent;
}
extern "C" {
    pub fn r_event_free(ev: *mut REvent);
}
extern "C" {
    pub fn r_event_hook(
        ev: *mut REvent,
        type_: ::std::os::raw::c_int,
        cb: REventCallback,
        user: *mut ::std::os::raw::c_void,
    ) -> REventCallbackHandle;
}
extern "C" {
    pub fn r_event_unhook(ev: *mut REvent, handle: REventCallbackHandle);
}
extern "C" {
    pub fn r_event_send(
        ev: *mut REvent,
        type_: ::std::os::raw::c_int,
        data: *mut ::std::os::raw::c_void,
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_interval_t {
    pub addr: u64,
    pub size: u64,
}
#[test]
fn bindgen_test_layout_r_interval_t() {
    assert_eq!(
        ::std::mem::size_of::<r_interval_t>(),
        16usize,
        concat!("Size of: ", stringify!(r_interval_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_interval_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_interval_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_interval_t>())).addr as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_interval_t),
            "::",
            stringify!(addr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_interval_t>())).size as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_interval_t),
            "::",
            stringify!(size)
        )
    );
}
pub type RInterval = r_interval_t;
extern "C" {
    pub fn r_signal_from_string(str_: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_signal_to_string(code: ::std::os::raw::c_int) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_signal_to_human(signum: ::std::os::raw::c_int) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_signal_sigmask(
        how: ::std::os::raw::c_int,
        newmask: *const sigset_t,
        oldmask: *mut sigset_t,
    );
}
extern "C" {
    pub fn r_malloc_aligned(size: size_t, alignment: size_t) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn r_free_aligned(p: *mut ::std::os::raw::c_void);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_rb_node_t {
    pub parent: *mut r_rb_node_t,
    pub child: [*mut r_rb_node_t; 2usize],
    pub red: bool,
}
#[test]
fn bindgen_test_layout_r_rb_node_t() {
    assert_eq!(
        ::std::mem::size_of::<r_rb_node_t>(),
        32usize,
        concat!("Size of: ", stringify!(r_rb_node_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_rb_node_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_rb_node_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_rb_node_t>())).parent as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_rb_node_t),
            "::",
            stringify!(parent)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_rb_node_t>())).child as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_rb_node_t),
            "::",
            stringify!(child)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_rb_node_t>())).red as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(r_rb_node_t),
            "::",
            stringify!(red)
        )
    );
}
pub type RBNode = r_rb_node_t;
pub type RBTree = *mut RBNode;
pub type RBComparator = ::std::option::Option<
    unsafe extern "C" fn(
        incoming: *const ::std::os::raw::c_void,
        in_tree: *const RBNode,
        user: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int,
>;
pub type RBNodeFree = ::std::option::Option<
    unsafe extern "C" fn(node: *mut RBNode, user: *mut ::std::os::raw::c_void),
>;
pub type RBNodeSum = ::std::option::Option<unsafe extern "C" fn(node: *mut RBNode)>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_rb_iter_t {
    pub len: size_t,
    pub path: [*mut RBNode; 62usize],
}
#[test]
fn bindgen_test_layout_r_rb_iter_t() {
    assert_eq!(
        ::std::mem::size_of::<r_rb_iter_t>(),
        504usize,
        concat!("Size of: ", stringify!(r_rb_iter_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_rb_iter_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_rb_iter_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_rb_iter_t>())).len as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_rb_iter_t),
            "::",
            stringify!(len)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_rb_iter_t>())).path as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_rb_iter_t),
            "::",
            stringify!(path)
        )
    );
}
pub type RBIter = r_rb_iter_t;
extern "C" {
    pub fn r_rbtree_aug_delete(
        root: *mut *mut RBNode,
        data: *mut ::std::os::raw::c_void,
        cmp: RBComparator,
        cmp_user: *mut ::std::os::raw::c_void,
        freefn: RBNodeFree,
        free_user: *mut ::std::os::raw::c_void,
        sum: RBNodeSum,
    ) -> bool;
}
extern "C" {
    pub fn r_rbtree_aug_insert(
        root: *mut *mut RBNode,
        data: *mut ::std::os::raw::c_void,
        node: *mut RBNode,
        cmp: RBComparator,
        cmp_user: *mut ::std::os::raw::c_void,
        sum: RBNodeSum,
    ) -> bool;
}
extern "C" {
    pub fn r_rbtree_aug_update_sum(
        root: *mut RBNode,
        data: *mut ::std::os::raw::c_void,
        node: *mut RBNode,
        cmp: RBComparator,
        cmp_user: *mut ::std::os::raw::c_void,
        sum: RBNodeSum,
    ) -> bool;
}
extern "C" {
    pub fn r_rbtree_delete(
        root: *mut *mut RBNode,
        data: *mut ::std::os::raw::c_void,
        cmp: RBComparator,
        cmp_user: *mut ::std::os::raw::c_void,
        freefn: RBNodeFree,
        free_user: *mut ::std::os::raw::c_void,
    ) -> bool;
}
extern "C" {
    pub fn r_rbtree_find(
        root: *mut RBNode,
        data: *mut ::std::os::raw::c_void,
        cmp: RBComparator,
        user: *mut ::std::os::raw::c_void,
    ) -> *mut RBNode;
}
extern "C" {
    pub fn r_rbtree_free(root: *mut RBNode, freefn: RBNodeFree, user: *mut ::std::os::raw::c_void);
}
extern "C" {
    pub fn r_rbtree_insert(
        root: *mut *mut RBNode,
        data: *mut ::std::os::raw::c_void,
        node: *mut RBNode,
        cmp: RBComparator,
        user: *mut ::std::os::raw::c_void,
    );
}
extern "C" {
    pub fn r_rbtree_lower_bound(
        root: *mut RBNode,
        data: *mut ::std::os::raw::c_void,
        cmp: RBComparator,
        user: *mut ::std::os::raw::c_void,
    ) -> *mut RBNode;
}
extern "C" {
    pub fn r_rbtree_upper_bound(
        root: *mut RBNode,
        data: *mut ::std::os::raw::c_void,
        cmp: RBComparator,
        user: *mut ::std::os::raw::c_void,
    ) -> *mut RBNode;
}
extern "C" {
    pub fn r_rbtree_first(root: *mut RBNode) -> RBIter;
}
extern "C" {
    pub fn r_rbtree_last(root: *mut RBNode) -> RBIter;
}
extern "C" {
    pub fn r_rbtree_lower_bound_forward(
        root: *mut RBNode,
        data: *mut ::std::os::raw::c_void,
        cmp: RBComparator,
        user: *mut ::std::os::raw::c_void,
    ) -> RBIter;
}
extern "C" {
    pub fn r_rbtree_upper_bound_backward(
        root: *mut RBNode,
        data: *mut ::std::os::raw::c_void,
        cmp: RBComparator,
        user: *mut ::std::os::raw::c_void,
    ) -> RBIter;
}
extern "C" {
    pub fn r_rbtree_iter_next(it: *mut RBIter);
}
extern "C" {
    pub fn r_rbtree_iter_prev(it: *mut RBIter);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_crbtree_node {
    pub link: [*mut r_crbtree_node; 2usize],
    pub parent: *mut r_crbtree_node,
    pub red: u32,
    pub data: *mut ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout_r_crbtree_node() {
    assert_eq!(
        ::std::mem::size_of::<r_crbtree_node>(),
        40usize,
        concat!("Size of: ", stringify!(r_crbtree_node))
    );
    assert_eq!(
        ::std::mem::align_of::<r_crbtree_node>(),
        8usize,
        concat!("Alignment of ", stringify!(r_crbtree_node))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_crbtree_node>())).link as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_crbtree_node),
            "::",
            stringify!(link)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_crbtree_node>())).parent as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(r_crbtree_node),
            "::",
            stringify!(parent)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_crbtree_node>())).red as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(r_crbtree_node),
            "::",
            stringify!(red)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_crbtree_node>())).data as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(r_crbtree_node),
            "::",
            stringify!(data)
        )
    );
}
pub type RRBNode = r_crbtree_node;
pub type RRBComparator = ::std::option::Option<
    unsafe extern "C" fn(
        incoming: *mut ::std::os::raw::c_void,
        in_: *mut ::std::os::raw::c_void,
        user: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int,
>;
pub type RRBFree = ::std::option::Option<unsafe extern "C" fn(data: *mut ::std::os::raw::c_void)>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_crbtree_t {
    pub root: *mut RRBNode,
    pub size: size_t,
    pub free: RRBFree,
}
#[test]
fn bindgen_test_layout_r_crbtree_t() {
    assert_eq!(
        ::std::mem::size_of::<r_crbtree_t>(),
        24usize,
        concat!("Size of: ", stringify!(r_crbtree_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_crbtree_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_crbtree_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_crbtree_t>())).root as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_crbtree_t),
            "::",
            stringify!(root)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_crbtree_t>())).size as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_crbtree_t),
            "::",
            stringify!(size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_crbtree_t>())).free as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(r_crbtree_t),
            "::",
            stringify!(free)
        )
    );
}
pub type RRBTree = r_crbtree_t;
extern "C" {
    pub fn r_crbtree_new(freefn: RRBFree) -> *mut RRBTree;
}
extern "C" {
    pub fn r_crbtree_clear(tree: *mut RRBTree);
}
extern "C" {
    pub fn r_crbtree_free(tree: *mut RRBTree);
}
extern "C" {
    pub fn r_crbtree_find_node(
        tree: *mut RRBTree,
        data: *mut ::std::os::raw::c_void,
        cmp: RRBComparator,
        user: *mut ::std::os::raw::c_void,
    ) -> *mut RRBNode;
}
extern "C" {
    pub fn r_crbtree_find(
        tree: *mut RRBTree,
        data: *mut ::std::os::raw::c_void,
        cmp: RRBComparator,
        user: *mut ::std::os::raw::c_void,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn r_crbtree_insert(
        tree: *mut RRBTree,
        data: *mut ::std::os::raw::c_void,
        cmp: RRBComparator,
        user: *mut ::std::os::raw::c_void,
    ) -> bool;
}
extern "C" {
    pub fn r_crbtree_take(
        tree: *mut RRBTree,
        data: *mut ::std::os::raw::c_void,
        cmp: RRBComparator,
        user: *mut ::std::os::raw::c_void,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn r_crbtree_delete(
        tree: *mut RRBTree,
        data: *mut ::std::os::raw::c_void,
        cmp: RRBComparator,
        user: *mut ::std::os::raw::c_void,
    ) -> bool;
}
extern "C" {
    pub fn r_crbtree_first_node(tree: *mut RRBTree) -> *mut RRBNode;
}
extern "C" {
    pub fn r_crbtree_last_node(tree: *mut RRBTree) -> *mut RRBNode;
}
extern "C" {
    pub fn r_rbnode_next(node: *mut RRBNode) -> *mut RRBNode;
}
extern "C" {
    pub fn r_rbnode_prev(node: *mut RRBNode) -> *mut RRBNode;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_interval_node_t {
    pub node: RBNode,
    pub start: u64,
    pub end: u64,
    pub max_end: u64,
    pub data: *mut ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout_r_interval_node_t() {
    assert_eq!(
        ::std::mem::size_of::<r_interval_node_t>(),
        64usize,
        concat!("Size of: ", stringify!(r_interval_node_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_interval_node_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_interval_node_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_interval_node_t>())).node as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_interval_node_t),
            "::",
            stringify!(node)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_interval_node_t>())).start as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(r_interval_node_t),
            "::",
            stringify!(start)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_interval_node_t>())).end as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(r_interval_node_t),
            "::",
            stringify!(end)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_interval_node_t>())).max_end as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(r_interval_node_t),
            "::",
            stringify!(max_end)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_interval_node_t>())).data as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(r_interval_node_t),
            "::",
            stringify!(data)
        )
    );
}
pub type RIntervalNode = r_interval_node_t;
pub type RIntervalNodeFree =
    ::std::option::Option<unsafe extern "C" fn(data: *mut ::std::os::raw::c_void)>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_interval_tree_t {
    pub root: *mut RIntervalNode,
    pub free: RIntervalNodeFree,
}
#[test]
fn bindgen_test_layout_r_interval_tree_t() {
    assert_eq!(
        ::std::mem::size_of::<r_interval_tree_t>(),
        16usize,
        concat!("Size of: ", stringify!(r_interval_tree_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_interval_tree_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_interval_tree_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_interval_tree_t>())).root as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_interval_tree_t),
            "::",
            stringify!(root)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_interval_tree_t>())).free as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_interval_tree_t),
            "::",
            stringify!(free)
        )
    );
}
pub type RIntervalTree = r_interval_tree_t;
extern "C" {
    pub fn r_interval_tree_init(tree: *mut RIntervalTree, free: RIntervalNodeFree);
}
extern "C" {
    pub fn r_interval_tree_fini(tree: *mut RIntervalTree);
}
extern "C" {
    pub fn r_interval_tree_insert(
        tree: *mut RIntervalTree,
        start: u64,
        end: u64,
        data: *mut ::std::os::raw::c_void,
    ) -> bool;
}
extern "C" {
    pub fn r_interval_tree_delete(
        tree: *mut RIntervalTree,
        node: *mut RIntervalNode,
        free: bool,
    ) -> bool;
}
extern "C" {
    pub fn r_interval_tree_resize(
        tree: *mut RIntervalTree,
        node: *mut RIntervalNode,
        new_start: u64,
        new_end: u64,
    ) -> bool;
}
extern "C" {
    pub fn r_interval_tree_first_at(tree: *mut RIntervalTree, start: u64) -> RBIter;
}
extern "C" {
    pub fn r_interval_tree_node_at(tree: *mut RIntervalTree, start: u64) -> *mut RIntervalNode;
}
extern "C" {
    pub fn r_interval_tree_node_at_data(
        tree: *mut RIntervalTree,
        start: u64,
        data: *mut ::std::os::raw::c_void,
    ) -> *mut RIntervalNode;
}
pub type RIntervalIterCb = ::std::option::Option<
    unsafe extern "C" fn(node: *mut RIntervalNode, user: *mut ::std::os::raw::c_void) -> bool,
>;
extern "C" {
    pub fn r_interval_tree_all_at(
        tree: *mut RIntervalTree,
        start: u64,
        cb: RIntervalIterCb,
        user: *mut ::std::os::raw::c_void,
    ) -> bool;
}
extern "C" {
    pub fn r_interval_tree_all_in(
        tree: *mut RIntervalTree,
        value: u64,
        end_inclusive: bool,
        cb: RIntervalIterCb,
        user: *mut ::std::os::raw::c_void,
    ) -> bool;
}
extern "C" {
    pub fn r_interval_tree_all_intersect(
        tree: *mut RIntervalTree,
        start: u64,
        end: u64,
        end_inclusive: bool,
        cb: RIntervalIterCb,
        user: *mut ::std::os::raw::c_void,
    ) -> bool;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_num_big_t {
    pub array: [u32; 128usize],
    pub sign: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_r_num_big_t() {
    assert_eq!(
        ::std::mem::size_of::<r_num_big_t>(),
        516usize,
        concat!("Size of: ", stringify!(r_num_big_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_num_big_t>(),
        4usize,
        concat!("Alignment of ", stringify!(r_num_big_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_num_big_t>())).array as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_num_big_t),
            "::",
            stringify!(array)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_num_big_t>())).sign as *const _ as usize },
        512usize,
        concat!(
            "Offset of field: ",
            stringify!(r_num_big_t),
            "::",
            stringify!(sign)
        )
    );
}
pub type RNumBig = r_num_big_t;
extern "C" {
    pub fn r_big_new() -> *mut RNumBig;
}
extern "C" {
    pub fn r_big_free(b: *mut RNumBig);
}
extern "C" {
    pub fn r_big_init(b: *mut RNumBig);
}
extern "C" {
    pub fn r_big_fini(b: *mut RNumBig);
}
extern "C" {
    pub fn r_big_from_int(b: *mut RNumBig, v: i64);
}
extern "C" {
    pub fn r_big_to_int(b: *mut RNumBig) -> i64;
}
extern "C" {
    pub fn r_big_from_hexstr(b: *mut RNumBig, str_: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn r_big_to_hexstr(b: *mut RNumBig) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_big_assign(dst: *mut RNumBig, src: *mut RNumBig);
}
extern "C" {
    pub fn r_big_add(c: *mut RNumBig, a: *mut RNumBig, b: *mut RNumBig);
}
extern "C" {
    pub fn r_big_sub(c: *mut RNumBig, a: *mut RNumBig, b: *mut RNumBig);
}
extern "C" {
    pub fn r_big_mul(c: *mut RNumBig, a: *mut RNumBig, b: *mut RNumBig);
}
extern "C" {
    pub fn r_big_div(c: *mut RNumBig, a: *mut RNumBig, b: *mut RNumBig);
}
extern "C" {
    pub fn r_big_mod(c: *mut RNumBig, a: *mut RNumBig, b: *mut RNumBig);
}
extern "C" {
    pub fn r_big_divmod(c: *mut RNumBig, d: *mut RNumBig, a: *mut RNumBig, b: *mut RNumBig);
}
extern "C" {
    pub fn r_big_and(c: *mut RNumBig, a: *mut RNumBig, b: *mut RNumBig);
}
extern "C" {
    pub fn r_big_or(c: *mut RNumBig, a: *mut RNumBig, b: *mut RNumBig);
}
extern "C" {
    pub fn r_big_xor(c: *mut RNumBig, a: *mut RNumBig, b: *mut RNumBig);
}
extern "C" {
    pub fn r_big_lshift(c: *mut RNumBig, a: *mut RNumBig, nbits: size_t);
}
extern "C" {
    pub fn r_big_rshift(c: *mut RNumBig, a: *mut RNumBig, nbits: size_t);
}
extern "C" {
    pub fn r_big_cmp(a: *mut RNumBig, b: *mut RNumBig) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_big_is_zero(a: *mut RNumBig) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_big_inc(a: *mut RNumBig);
}
extern "C" {
    pub fn r_big_dec(a: *mut RNumBig);
}
extern "C" {
    pub fn r_big_powm(c: *mut RNumBig, a: *mut RNumBig, b: *mut RNumBig, m: *mut RNumBig);
}
extern "C" {
    pub fn r_big_isqrt(c: *mut RNumBig, a: *mut RNumBig);
}
extern "C" {
    pub fn r_base64_encode(
        bout: *mut ::std::os::raw::c_char,
        bin: *const u8,
        len: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_base64_decode(
        bout: *mut u8,
        bin: *const ::std::os::raw::c_char,
        len: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_base64_decode_dyn(
        in_: *const ::std::os::raw::c_char,
        len: ::std::os::raw::c_int,
    ) -> *mut u8;
}
extern "C" {
    pub fn r_base64_encode_dyn(
        str_: *const ::std::os::raw::c_char,
        len: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_base91_encode(
        bout: *mut ::std::os::raw::c_char,
        bin: *const u8,
        len: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_base91_decode(
        bout: *mut u8,
        bin: *const ::std::os::raw::c_char,
        len: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_mmap_t {
    pub buf: *mut u8,
    pub base: u64,
    pub len: ::std::os::raw::c_int,
    pub fd: ::std::os::raw::c_int,
    pub rw: ::std::os::raw::c_int,
    pub filename: *mut ::std::os::raw::c_char,
}
#[test]
fn bindgen_test_layout_r_mmap_t() {
    assert_eq!(
        ::std::mem::size_of::<r_mmap_t>(),
        40usize,
        concat!("Size of: ", stringify!(r_mmap_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_mmap_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_mmap_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_mmap_t>())).buf as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_mmap_t),
            "::",
            stringify!(buf)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_mmap_t>())).base as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_mmap_t),
            "::",
            stringify!(base)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_mmap_t>())).len as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(r_mmap_t),
            "::",
            stringify!(len)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_mmap_t>())).fd as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(r_mmap_t),
            "::",
            stringify!(fd)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_mmap_t>())).rw as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(r_mmap_t),
            "::",
            stringify!(rw)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_mmap_t>())).filename as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(r_mmap_t),
            "::",
            stringify!(filename)
        )
    );
}
pub type RMmap = r_mmap_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_mem_pool_t {
    pub nodes: *mut *mut u8,
    pub ncount: ::std::os::raw::c_int,
    pub npool: ::std::os::raw::c_int,
    pub nodesize: ::std::os::raw::c_int,
    pub poolsize: ::std::os::raw::c_int,
    pub poolcount: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_r_mem_pool_t() {
    assert_eq!(
        ::std::mem::size_of::<r_mem_pool_t>(),
        32usize,
        concat!("Size of: ", stringify!(r_mem_pool_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_mem_pool_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_mem_pool_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_mem_pool_t>())).nodes as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_mem_pool_t),
            "::",
            stringify!(nodes)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_mem_pool_t>())).ncount as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_mem_pool_t),
            "::",
            stringify!(ncount)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_mem_pool_t>())).npool as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(r_mem_pool_t),
            "::",
            stringify!(npool)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_mem_pool_t>())).nodesize as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(r_mem_pool_t),
            "::",
            stringify!(nodesize)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_mem_pool_t>())).poolsize as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(r_mem_pool_t),
            "::",
            stringify!(poolsize)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_mem_pool_t>())).poolcount as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(r_mem_pool_t),
            "::",
            stringify!(poolcount)
        )
    );
}
pub type RMemoryPool = r_mem_pool_t;
extern "C" {
    pub fn r_mem_get_num(b: *const u8, size: ::std::os::raw::c_int) -> u64;
}
extern "C" {
    pub fn r_mem_pool_deinit(pool: *mut RMemoryPool) -> *mut RMemoryPool;
}
extern "C" {
    pub fn r_mem_pool_new(
        nodesize: ::std::os::raw::c_int,
        poolsize: ::std::os::raw::c_int,
        poolcount: ::std::os::raw::c_int,
    ) -> *mut RMemoryPool;
}
extern "C" {
    pub fn r_mem_pool_free(pool: *mut RMemoryPool) -> *mut RMemoryPool;
}
extern "C" {
    pub fn r_mem_pool_alloc(pool: *mut RMemoryPool) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn r_mem_dup(
        s: *const ::std::os::raw::c_void,
        l: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn r_mem_alloc(sz: ::std::os::raw::c_int) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn r_mem_free(arg1: *mut ::std::os::raw::c_void);
}
extern "C" {
    pub fn r_mem_memzero(arg1: *mut ::std::os::raw::c_void, arg2: size_t);
}
extern "C" {
    pub fn r_mem_reverse(b: *mut u8, l: ::std::os::raw::c_int);
}
extern "C" {
    pub fn r_mem_protect(
        ptr: *mut ::std::os::raw::c_void,
        size: ::std::os::raw::c_int,
        prot: *const ::std::os::raw::c_char,
    ) -> bool;
}
extern "C" {
    pub fn r_mem_set_num(
        dest: *mut u8,
        dest_size: ::std::os::raw::c_int,
        num: u64,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_mem_eq(a: *mut u8, b: *mut u8, len: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_mem_copybits(dst: *mut u8, src: *const u8, bits: ::std::os::raw::c_int);
}
extern "C" {
    pub fn r_mem_copybits_delta(
        dst: *mut u8,
        doff: ::std::os::raw::c_int,
        src: *const u8,
        soff: ::std::os::raw::c_int,
        bits: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn r_mem_copyloop(
        dest: *mut u8,
        orig: *const u8,
        dsize: ::std::os::raw::c_int,
        osize: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn r_mem_swaporcopy(
        dest: *mut u8,
        src: *const u8,
        len: ::std::os::raw::c_int,
        big_endian: bool,
    );
}
extern "C" {
    pub fn r_mem_swapendian(dest: *mut u8, orig: *const u8, size: ::std::os::raw::c_int);
}
extern "C" {
    pub fn r_mem_swap(buf: *mut u8, buf_len: size_t);
}
extern "C" {
    pub fn r_mem_cmp_mask(
        dest: *const u8,
        orig: *const u8,
        mask: *const u8,
        len: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_mem_mem(
        haystack: *const u8,
        hlen: ::std::os::raw::c_int,
        needle: *const u8,
        nlen: ::std::os::raw::c_int,
    ) -> *const u8;
}
extern "C" {
    pub fn r_mem_mem_aligned(
        haystack: *const u8,
        hlen: ::std::os::raw::c_int,
        needle: *const u8,
        nlen: ::std::os::raw::c_int,
        align: ::std::os::raw::c_int,
    ) -> *const u8;
}
extern "C" {
    pub fn r_mem_count(addr: *mut *const u8) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_mem_is_printable(a: *const u8, la: ::std::os::raw::c_int) -> bool;
}
extern "C" {
    pub fn r_mem_is_zero(b: *const u8, l: ::std::os::raw::c_int) -> bool;
}
extern "C" {
    pub fn r_mem_mmap_resize(m: *mut RMmap, newsize: u64) -> *mut ::std::os::raw::c_void;
}
pub type RBuffer = r_buf_t;
pub type RBufferInit = ::std::option::Option<
    unsafe extern "C" fn(b: *mut RBuffer, user: *const ::std::os::raw::c_void) -> bool,
>;
pub type RBufferFini = ::std::option::Option<unsafe extern "C" fn(b: *mut RBuffer) -> bool>;
pub type RBufferRead =
    ::std::option::Option<unsafe extern "C" fn(b: *mut RBuffer, buf: *mut u8, len: u64) -> i64>;
pub type RBufferWrite =
    ::std::option::Option<unsafe extern "C" fn(b: *mut RBuffer, buf: *const u8, len: u64) -> i64>;
pub type RBufferGetSize = ::std::option::Option<unsafe extern "C" fn(b: *mut RBuffer) -> u64>;
pub type RBufferResize =
    ::std::option::Option<unsafe extern "C" fn(b: *mut RBuffer, newsize: u64) -> bool>;
pub type RBufferSeek = ::std::option::Option<
    unsafe extern "C" fn(b: *mut RBuffer, addr: i64, whence: ::std::os::raw::c_int) -> i64,
>;
pub type RBufferGetWholeBuf =
    ::std::option::Option<unsafe extern "C" fn(b: *mut RBuffer, sz: *mut u64) -> *mut u8>;
pub type RBufferFreeWholeBuf = ::std::option::Option<unsafe extern "C" fn(b: *mut RBuffer)>;
pub type RBufferNonEmptyList =
    ::std::option::Option<unsafe extern "C" fn(b: *mut RBuffer) -> *mut RList>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_buffer_methods_t {
    pub init: RBufferInit,
    pub fini: RBufferFini,
    pub read: RBufferRead,
    pub write: RBufferWrite,
    pub get_size: RBufferGetSize,
    pub resize: RBufferResize,
    pub seek: RBufferSeek,
    pub get_whole_buf: RBufferGetWholeBuf,
    pub free_whole_buf: RBufferFreeWholeBuf,
    pub nonempty_list: RBufferNonEmptyList,
}
#[test]
fn bindgen_test_layout_r_buffer_methods_t() {
    assert_eq!(
        ::std::mem::size_of::<r_buffer_methods_t>(),
        80usize,
        concat!("Size of: ", stringify!(r_buffer_methods_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_buffer_methods_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_buffer_methods_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_buffer_methods_t>())).init as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_buffer_methods_t),
            "::",
            stringify!(init)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_buffer_methods_t>())).fini as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_buffer_methods_t),
            "::",
            stringify!(fini)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_buffer_methods_t>())).read as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(r_buffer_methods_t),
            "::",
            stringify!(read)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_buffer_methods_t>())).write as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(r_buffer_methods_t),
            "::",
            stringify!(write)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_buffer_methods_t>())).get_size as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(r_buffer_methods_t),
            "::",
            stringify!(get_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_buffer_methods_t>())).resize as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(r_buffer_methods_t),
            "::",
            stringify!(resize)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_buffer_methods_t>())).seek as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(r_buffer_methods_t),
            "::",
            stringify!(seek)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_buffer_methods_t>())).get_whole_buf as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(r_buffer_methods_t),
            "::",
            stringify!(get_whole_buf)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_buffer_methods_t>())).free_whole_buf as *const _ as usize
        },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(r_buffer_methods_t),
            "::",
            stringify!(free_whole_buf)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_buffer_methods_t>())).nonempty_list as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(r_buffer_methods_t),
            "::",
            stringify!(nonempty_list)
        )
    );
}
pub type RBufferMethods = r_buffer_methods_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_buf_t {
    pub methods: *const RBufferMethods,
    pub priv_: *mut ::std::os::raw::c_void,
    pub whole_buf: *mut u8,
    pub readonly: bool,
    pub Oxff_priv: u8,
    pub refctr: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_r_buf_t() {
    assert_eq!(
        ::std::mem::size_of::<r_buf_t>(),
        32usize,
        concat!("Size of: ", stringify!(r_buf_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_buf_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_buf_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_buf_t>())).methods as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_buf_t),
            "::",
            stringify!(methods)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_buf_t>())).priv_ as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_buf_t),
            "::",
            stringify!(priv_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_buf_t>())).whole_buf as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(r_buf_t),
            "::",
            stringify!(whole_buf)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_buf_t>())).readonly as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(r_buf_t),
            "::",
            stringify!(readonly)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_buf_t>())).Oxff_priv as *const _ as usize },
        25usize,
        concat!(
            "Offset of field: ",
            stringify!(r_buf_t),
            "::",
            stringify!(Oxff_priv)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_buf_t>())).refctr as *const _ as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(r_buf_t),
            "::",
            stringify!(refctr)
        )
    );
}
extern "C" {
    pub fn r_buf_new() -> *mut RBuffer;
}
extern "C" {
    pub fn r_buf_new_with_io(
        iob: *mut ::std::os::raw::c_void,
        fd: ::std::os::raw::c_int,
    ) -> *mut RBuffer;
}
extern "C" {
    pub fn r_buf_new_with_bytes(bytes: *const u8, len: u64) -> *mut RBuffer;
}
extern "C" {
    pub fn r_buf_new_with_string(msg: *const ::std::os::raw::c_char) -> *mut RBuffer;
}
extern "C" {
    pub fn r_buf_new_with_pointers(bytes: *const u8, len: u64, steal: bool) -> *mut RBuffer;
}
extern "C" {
    pub fn r_buf_new_file(
        file: *const ::std::os::raw::c_char,
        perm: ::std::os::raw::c_int,
        mode: ::std::os::raw::c_int,
    ) -> *mut RBuffer;
}
extern "C" {
    pub fn r_buf_new_with_buf(b: *mut RBuffer) -> *mut RBuffer;
}
extern "C" {
    pub fn r_buf_new_slurp(file: *const ::std::os::raw::c_char) -> *mut RBuffer;
}
extern "C" {
    pub fn r_buf_new_slice(b: *mut RBuffer, offset: u64, size: u64) -> *mut RBuffer;
}
extern "C" {
    pub fn r_buf_new_empty(len: u64) -> *mut RBuffer;
}
extern "C" {
    pub fn r_buf_new_mmap(
        file: *const ::std::os::raw::c_char,
        flags: ::std::os::raw::c_int,
    ) -> *mut RBuffer;
}
extern "C" {
    pub fn r_buf_new_sparse(Oxff: u8) -> *mut RBuffer;
}
extern "C" {
    pub fn r_buf_dump(buf: *mut RBuffer, file: *const ::std::os::raw::c_char) -> bool;
}
extern "C" {
    pub fn r_buf_set_bytes(b: *mut RBuffer, buf: *const u8, length: u64) -> bool;
}
extern "C" {
    pub fn r_buf_append_string(b: *mut RBuffer, str_: *const ::std::os::raw::c_char) -> i64;
}
extern "C" {
    pub fn r_buf_append_buf(b: *mut RBuffer, a: *mut RBuffer) -> bool;
}
extern "C" {
    pub fn r_buf_append_bytes(b: *mut RBuffer, buf: *const u8, length: u64) -> bool;
}
extern "C" {
    pub fn r_buf_append_nbytes(b: *mut RBuffer, length: u64) -> bool;
}
extern "C" {
    pub fn r_buf_append_ut8(b: *mut RBuffer, n: u8) -> bool;
}
extern "C" {
    pub fn r_buf_append_ut16(b: *mut RBuffer, n: u16) -> bool;
}
extern "C" {
    pub fn r_buf_append_buf_slice(b: *mut RBuffer, a: *mut RBuffer, offset: u64, size: u64)
        -> bool;
}
extern "C" {
    pub fn r_buf_append_ut32(b: *mut RBuffer, n: u32) -> bool;
}
extern "C" {
    pub fn r_buf_append_ut64(b: *mut RBuffer, n: u64) -> bool;
}
extern "C" {
    pub fn r_buf_prepend_bytes(b: *mut RBuffer, buf: *const u8, length: u64) -> bool;
}
extern "C" {
    pub fn r_buf_insert_bytes(b: *mut RBuffer, addr: u64, buf: *const u8, length: u64) -> i64;
}
extern "C" {
    pub fn r_buf_to_string(b: *mut RBuffer) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_buf_get_string(b: *mut RBuffer, addr: u64) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_buf_read(b: *mut RBuffer, buf: *mut u8, len: u64) -> i64;
}
extern "C" {
    pub fn r_buf_read_all(b: *mut RBuffer, blen: *mut ::std::os::raw::c_int) -> *mut u8;
}
extern "C" {
    pub fn r_buf_read8(b: *mut RBuffer) -> u8;
}
extern "C" {
    pub fn r_buf_fread(
        b: *mut RBuffer,
        buf: *mut u8,
        fmt: *const ::std::os::raw::c_char,
        n: ::std::os::raw::c_int,
    ) -> i64;
}
extern "C" {
    pub fn r_buf_read_at(b: *mut RBuffer, addr: u64, buf: *mut u8, len: u64) -> i64;
}
extern "C" {
    pub fn r_buf_read8_at(b: *mut RBuffer, addr: u64) -> u8;
}
extern "C" {
    pub fn r_buf_tell(b: *mut RBuffer) -> u64;
}
extern "C" {
    pub fn r_buf_seek(b: *mut RBuffer, addr: i64, whence: ::std::os::raw::c_int) -> i64;
}
extern "C" {
    pub fn r_buf_fread_at(
        b: *mut RBuffer,
        addr: u64,
        buf: *mut u8,
        fmt: *const ::std::os::raw::c_char,
        n: ::std::os::raw::c_int,
    ) -> i64;
}
extern "C" {
    pub fn r_buf_write(b: *mut RBuffer, buf: *const u8, len: u64) -> i64;
}
extern "C" {
    pub fn r_buf_fwrite(
        b: *mut RBuffer,
        buf: *const u8,
        fmt: *const ::std::os::raw::c_char,
        n: ::std::os::raw::c_int,
    ) -> i64;
}
extern "C" {
    pub fn r_buf_write_at(b: *mut RBuffer, addr: u64, buf: *const u8, len: u64) -> i64;
}
extern "C" {
    pub fn r_buf_fwrite_at(
        b: *mut RBuffer,
        addr: u64,
        buf: *const u8,
        fmt: *const ::std::os::raw::c_char,
        n: ::std::os::raw::c_int,
    ) -> i64;
}
extern "C" {
    pub fn r_buf_data(b: *mut RBuffer, size: *mut u64) -> *const u8;
}
extern "C" {
    pub fn r_buf_size(b: *mut RBuffer) -> u64;
}
extern "C" {
    pub fn r_buf_resize(b: *mut RBuffer, newsize: u64) -> bool;
}
extern "C" {
    pub fn r_buf_ref(b: *mut RBuffer) -> *mut RBuffer;
}
extern "C" {
    pub fn r_buf_free(b: *mut RBuffer);
}
extern "C" {
    pub fn r_buf_fini(b: *mut RBuffer);
}
extern "C" {
    pub fn r_buf_nonempty_list(b: *mut RBuffer) -> *mut RList;
}
extern "C" {
    pub fn r_buf_uleb128(b: *mut RBuffer, v: *mut u64) -> i64;
}
extern "C" {
    pub fn r_buf_sleb128(b: *mut RBuffer, v: *mut i64) -> i64;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_bitmap_t {
    pub length: ::std::os::raw::c_int,
    pub bitmap: *mut u64,
}
#[test]
fn bindgen_test_layout_r_bitmap_t() {
    assert_eq!(
        ::std::mem::size_of::<r_bitmap_t>(),
        16usize,
        concat!("Size of: ", stringify!(r_bitmap_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_bitmap_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_bitmap_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bitmap_t>())).length as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bitmap_t),
            "::",
            stringify!(length)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bitmap_t>())).bitmap as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bitmap_t),
            "::",
            stringify!(bitmap)
        )
    );
}
pub type RBitmap = r_bitmap_t;
extern "C" {
    pub fn r_bitmap_new(len: size_t) -> *mut RBitmap;
}
extern "C" {
    pub fn r_bitmap_set_bytes(b: *mut RBitmap, buf: *const u8, len: ::std::os::raw::c_int);
}
extern "C" {
    pub fn r_bitmap_free(b: *mut RBitmap);
}
extern "C" {
    pub fn r_bitmap_set(b: *mut RBitmap, bit: size_t);
}
extern "C" {
    pub fn r_bitmap_unset(b: *mut RBitmap, bit: size_t);
}
extern "C" {
    pub fn r_bitmap_test(b: *mut RBitmap, bit: size_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_time_now() -> u64;
}
extern "C" {
    pub fn r_time_now_mono() -> u64;
}
extern "C" {
    pub fn r_time_stamp_to_str(timeStamp: u32) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_time_dos_time_stamp_to_posix(timeStamp: u32) -> u32;
}
extern "C" {
    pub fn r_time_stamp_is_dos_format(
        certainPosixTimeStamp: u32,
        possiblePosixOrDosTimeStamp: u32,
    ) -> bool;
}
extern "C" {
    pub fn r_time_to_string(ts: u64) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_asctime_r(
        tm: *const tm,
        buf: *mut ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_ctime_r(
        timer: *const time_t,
        buf: *mut ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_debruijn_pattern(
        size: ::std::os::raw::c_int,
        start: ::std::os::raw::c_int,
        charset: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_debruijn_offset(value: u64, is_big_endian: bool) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_cache_t {
    pub base: u64,
    pub buf: *mut u8,
    pub len: u64,
}
#[test]
fn bindgen_test_layout_r_cache_t() {
    assert_eq!(
        ::std::mem::size_of::<r_cache_t>(),
        24usize,
        concat!("Size of: ", stringify!(r_cache_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_cache_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_cache_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cache_t>())).base as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cache_t),
            "::",
            stringify!(base)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cache_t>())).buf as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cache_t),
            "::",
            stringify!(buf)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cache_t>())).len as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cache_t),
            "::",
            stringify!(len)
        )
    );
}
pub type RCache = r_cache_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_prof_t {
    pub when: timeval,
    pub result: f64,
}
#[test]
fn bindgen_test_layout_r_prof_t() {
    assert_eq!(
        ::std::mem::size_of::<r_prof_t>(),
        24usize,
        concat!("Size of: ", stringify!(r_prof_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_prof_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_prof_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_prof_t>())).when as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_prof_t),
            "::",
            stringify!(when)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_prof_t>())).result as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(r_prof_t),
            "::",
            stringify!(result)
        )
    );
}
pub type RProfile = r_prof_t;
extern "C" {
    pub fn r_cache_new() -> *mut RCache;
}
extern "C" {
    pub fn r_cache_free(c: *mut RCache);
}
extern "C" {
    pub fn r_cache_get(c: *mut RCache, addr: u64, len: *mut ::std::os::raw::c_int) -> *const u8;
}
extern "C" {
    pub fn r_cache_set(
        c: *mut RCache,
        addr: u64,
        buf: *const u8,
        len: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_cache_flush(c: *mut RCache);
}
extern "C" {
    pub fn r_prof_start(p: *mut RProfile);
}
extern "C" {
    pub fn r_prof_end(p: *mut RProfile) -> f64;
}
extern "C" {
    pub fn r_type_set(
        TDB: *mut Sdb,
        at: u64,
        field: *const ::std::os::raw::c_char,
        val: u64,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_type_del(TDB: *mut Sdb, name: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn r_type_kind(TDB: *mut Sdb, name: *const ::std::os::raw::c_char)
        -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_type_enum_member(
        TDB: *mut Sdb,
        name: *const ::std::os::raw::c_char,
        member: *const ::std::os::raw::c_char,
        val: u64,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_type_enum_getbitfield(
        TDB: *mut Sdb,
        name: *const ::std::os::raw::c_char,
        val: u64,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_type_get_enum(TDB: *mut Sdb, name: *const ::std::os::raw::c_char) -> *mut RList;
}
extern "C" {
    pub fn r_type_get_bitsize(TDB: *mut Sdb, type_: *const ::std::os::raw::c_char) -> u64;
}
extern "C" {
    pub fn r_type_get_by_offset(TDB: *mut Sdb, offset: u64) -> *mut RList;
}
extern "C" {
    pub fn r_type_get_struct_memb(
        TDB: *mut Sdb,
        type_: *const ::std::os::raw::c_char,
        offset: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_type_link_at(TDB: *mut Sdb, addr: u64) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_type_set_link(
        TDB: *mut Sdb,
        val: *const ::std::os::raw::c_char,
        addr: u64,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_type_unlink(TDB: *mut Sdb, addr: u64) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_type_link_offset(
        TDB: *mut Sdb,
        val: *const ::std::os::raw::c_char,
        addr: u64,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_type_format(
        TDB: *mut Sdb,
        t: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_type_func_exist(
        TDB: *mut Sdb,
        func_name: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_type_func_cc(
        TDB: *mut Sdb,
        func_name: *const ::std::os::raw::c_char,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_type_func_ret(
        TDB: *mut Sdb,
        func_name: *const ::std::os::raw::c_char,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_type_func_args_count(
        TDB: *mut Sdb,
        func_name: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_type_func_args_type(
        TDB: *mut Sdb,
        func_name: *const ::std::os::raw::c_char,
        i: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_type_func_args_name(
        TDB: *mut Sdb,
        func_name: *const ::std::os::raw::c_char,
        i: ::std::os::raw::c_int,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_type_func_guess(
        TDB: *mut Sdb,
        func_name: *mut ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_file_is_abspath(file: *const ::std::os::raw::c_char) -> bool;
}
extern "C" {
    pub fn r_file_is_c(file: *const ::std::os::raw::c_char) -> bool;
}
extern "C" {
    pub fn r_file_is_directory(str_: *const ::std::os::raw::c_char) -> bool;
}
extern "C" {
    pub fn r_file_is_regular(str_: *const ::std::os::raw::c_char) -> bool;
}
extern "C" {
    pub fn r_file_truncate(filename: *const ::std::os::raw::c_char, newsize: u64) -> bool;
}
extern "C" {
    pub fn r_file_new(root: *const ::std::os::raw::c_char, ...) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_file_size(str_: *const ::std::os::raw::c_char) -> u64;
}
extern "C" {
    pub fn r_file_root(
        root: *const ::std::os::raw::c_char,
        path: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_file_mmap(file: *const ::std::os::raw::c_char, rw: bool, base: u64) -> *mut RMmap;
}
extern "C" {
    pub fn r_file_mmap_read(
        file: *const ::std::os::raw::c_char,
        addr: u64,
        buf: *mut u8,
        len: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_file_mmap_write(
        file: *const ::std::os::raw::c_char,
        addr: u64,
        buf: *const u8,
        len: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_file_mmap_free(m: *mut RMmap);
}
extern "C" {
    pub fn r_file_chmod(
        file: *const ::std::os::raw::c_char,
        mod_: *const ::std::os::raw::c_char,
        recursive: ::std::os::raw::c_int,
    ) -> bool;
}
extern "C" {
    pub fn r_file_temp(prefix: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_file_path(bin: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_file_binsh() -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_file_basename(path: *const ::std::os::raw::c_char) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_file_dirname(path: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_file_abspath_rel(
        cwd: *const ::std::os::raw::c_char,
        file: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_file_abspath(file: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_inflate(
        src: *const u8,
        srcLen: ::std::os::raw::c_int,
        srcConsumed: *mut ::std::os::raw::c_int,
        dstLen: *mut ::std::os::raw::c_int,
    ) -> *mut u8;
}
extern "C" {
    pub fn r_inflate_raw(
        src: *const u8,
        srcLen: ::std::os::raw::c_int,
        srcConsumed: *mut ::std::os::raw::c_int,
        dstLen: *mut ::std::os::raw::c_int,
    ) -> *mut u8;
}
extern "C" {
    pub fn r_file_gzslurp(
        str_: *const ::std::os::raw::c_char,
        outlen: *mut ::std::os::raw::c_int,
        origonfail: ::std::os::raw::c_int,
    ) -> *mut u8;
}
extern "C" {
    pub fn r_stdin_slurp(sz: *mut ::std::os::raw::c_int) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_file_slurp(
        str_: *const ::std::os::raw::c_char,
        usz: *mut size_t,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_file_slurp_range(
        str_: *const ::std::os::raw::c_char,
        off: u64,
        sz: ::std::os::raw::c_int,
        osz: *mut ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_file_slurp_random_line(
        file: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_file_slurp_random_line_count(
        file: *const ::std::os::raw::c_char,
        linecount: *mut ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_file_slurp_hexpairs(
        str_: *const ::std::os::raw::c_char,
        usz: *mut ::std::os::raw::c_int,
    ) -> *mut u8;
}
extern "C" {
    pub fn r_file_dump(
        file: *const ::std::os::raw::c_char,
        buf: *const u8,
        len: ::std::os::raw::c_int,
        append: bool,
    ) -> bool;
}
extern "C" {
    pub fn r_file_touch(file: *const ::std::os::raw::c_char) -> bool;
}
extern "C" {
    pub fn r_file_hexdump(
        file: *const ::std::os::raw::c_char,
        buf: *const u8,
        len: ::std::os::raw::c_int,
        append: ::std::os::raw::c_int,
    ) -> bool;
}
extern "C" {
    pub fn r_file_rm(file: *const ::std::os::raw::c_char) -> bool;
}
extern "C" {
    pub fn r_file_exists(str_: *const ::std::os::raw::c_char) -> bool;
}
extern "C" {
    pub fn r_file_fexists(fmt: *const ::std::os::raw::c_char, ...) -> bool;
}
extern "C" {
    pub fn r_file_slurp_line(
        file: *const ::std::os::raw::c_char,
        line: ::std::os::raw::c_int,
        context: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_file_slurp_lines(
        file: *const ::std::os::raw::c_char,
        line: ::std::os::raw::c_int,
        count: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_file_slurp_lines_from_bottom(
        file: *const ::std::os::raw::c_char,
        line: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_file_temp_ex(
        prefix: *const ::std::os::raw::c_char,
        ex: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_file_mkstemp(
        prefix: *const ::std::os::raw::c_char,
        oname: *mut *mut ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_file_tmpdir() -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_file_readlink(path: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_file_copy(
        src: *const ::std::os::raw::c_char,
        dst: *const ::std::os::raw::c_char,
    ) -> bool;
}
extern "C" {
    pub fn r_file_move(
        src: *const ::std::os::raw::c_char,
        dst: *const ::std::os::raw::c_char,
    ) -> bool;
}
extern "C" {
    pub fn r_file_glob(
        globbed_path: *const ::std::os::raw::c_char,
        maxdepth: ::std::os::raw::c_int,
    ) -> *mut RList;
}
extern "C" {
    pub fn r_file_mmap_arch(
        map: *mut RMmap,
        filename: *const ::std::os::raw::c_char,
        fd: ::std::os::raw::c_int,
    ) -> *mut RMmap;
}
extern "C" {
    pub fn r_file_lsrf(dir: *const ::std::os::raw::c_char) -> *mut RList;
}
extern "C" {
    pub fn r_file_rm_rf(dir: *const ::std::os::raw::c_char) -> bool;
}
extern "C" {
    pub fn r_hex_pair2bin(arg: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_hex_str2bin_until_new(
        in_: *const ::std::os::raw::c_char,
        out: *mut *mut u8,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_hex_str2binmask(
        in_: *const ::std::os::raw::c_char,
        out: *mut u8,
        mask: *mut u8,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_hex_str2bin(in_: *const ::std::os::raw::c_char, out: *mut u8)
        -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_hex_bin2str(
        in_: *const u8,
        len: ::std::os::raw::c_int,
        out: *mut ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_hex_bin2strdup(
        in_: *const u8,
        len: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_hex_to_byte(val: *mut u8, c: u8) -> bool;
}
extern "C" {
    pub fn r_hex_str_is_valid(s: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_hex_bin_truncate(in_: u64, n: ::std::os::raw::c_int) -> i64;
}
extern "C" {
    pub fn r_hex_from_c(code: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_hex_from_py(code: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_hex_from_code(code: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_hex_no_code(code: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_hex_from_py_str(
        out: *mut ::std::os::raw::c_char,
        code: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_hex_from_py_array(
        out: *mut ::std::os::raw::c_char,
        code: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_hex_from_c_str(
        out: *mut ::std::os::raw::c_char,
        code: *mut *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_hex_from_c_array(
        out: *mut ::std::os::raw::c_char,
        code: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_name_validate_print(ch: ::std::os::raw::c_char) -> bool;
}
extern "C" {
    pub fn r_name_validate_first(ch: ::std::os::raw::c_char) -> bool;
}
extern "C" {
    pub fn r_name_check(s: *const ::std::os::raw::c_char) -> bool;
}
extern "C" {
    pub fn r_name_filter_ro(a: *const ::std::os::raw::c_char) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_name_filter_flag(s: *mut ::std::os::raw::c_char) -> bool;
}
extern "C" {
    pub fn r_name_filter_print(s: *mut ::std::os::raw::c_char) -> bool;
}
extern "C" {
    pub fn r_name_filter(name: *mut ::std::os::raw::c_char, maxlen: ::std::os::raw::c_int) -> bool;
}
extern "C" {
    pub fn r_name_filter2(name: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RNumCalcValue {
    pub d: f64,
    pub n: u64,
}
#[test]
fn bindgen_test_layout_RNumCalcValue() {
    assert_eq!(
        ::std::mem::size_of::<RNumCalcValue>(),
        16usize,
        concat!("Size of: ", stringify!(RNumCalcValue))
    );
    assert_eq!(
        ::std::mem::align_of::<RNumCalcValue>(),
        8usize,
        concat!("Alignment of ", stringify!(RNumCalcValue))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RNumCalcValue>())).d as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(RNumCalcValue),
            "::",
            stringify!(d)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RNumCalcValue>())).n as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(RNumCalcValue),
            "::",
            stringify!(n)
        )
    );
}
pub const RNumCalcToken_RNCNAME: RNumCalcToken = 0;
pub const RNumCalcToken_RNCNUMBER: RNumCalcToken = 1;
pub const RNumCalcToken_RNCEND: RNumCalcToken = 2;
pub const RNumCalcToken_RNCINC: RNumCalcToken = 3;
pub const RNumCalcToken_RNCDEC: RNumCalcToken = 4;
pub const RNumCalcToken_RNCLT: RNumCalcToken = 5;
pub const RNumCalcToken_RNCGT: RNumCalcToken = 6;
pub const RNumCalcToken_RNCPLUS: RNumCalcToken = 43;
pub const RNumCalcToken_RNCMINUS: RNumCalcToken = 45;
pub const RNumCalcToken_RNCMUL: RNumCalcToken = 42;
pub const RNumCalcToken_RNCDIV: RNumCalcToken = 47;
pub const RNumCalcToken_RNCMOD: RNumCalcToken = 37;
pub const RNumCalcToken_RNCNEG: RNumCalcToken = 126;
pub const RNumCalcToken_RNCAND: RNumCalcToken = 38;
pub const RNumCalcToken_RNCOR: RNumCalcToken = 124;
pub const RNumCalcToken_RNCXOR: RNumCalcToken = 94;
pub const RNumCalcToken_RNCPRINT: RNumCalcToken = 59;
pub const RNumCalcToken_RNCASSIGN: RNumCalcToken = 61;
pub const RNumCalcToken_RNCLEFTP: RNumCalcToken = 40;
pub const RNumCalcToken_RNCRIGHTP: RNumCalcToken = 41;
pub const RNumCalcToken_RNCSHL: RNumCalcToken = 60;
pub const RNumCalcToken_RNCSHR: RNumCalcToken = 62;
pub const RNumCalcToken_RNCROL: RNumCalcToken = 35;
pub const RNumCalcToken_RNCROR: RNumCalcToken = 36;
pub type RNumCalcToken = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_num_calc_t {
    pub curr_tok: RNumCalcToken,
    pub number_value: RNumCalcValue,
    pub string_value: [::std::os::raw::c_char; 1024usize],
    pub errors: ::std::os::raw::c_int,
    pub oc: ::std::os::raw::c_char,
    pub calc_err: *const ::std::os::raw::c_char,
    pub calc_i: ::std::os::raw::c_int,
    pub calc_buf: *const ::std::os::raw::c_char,
    pub calc_len: ::std::os::raw::c_int,
    pub under_calc: bool,
}
#[test]
fn bindgen_test_layout_r_num_calc_t() {
    assert_eq!(
        ::std::mem::size_of::<r_num_calc_t>(),
        1088usize,
        concat!("Size of: ", stringify!(r_num_calc_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_num_calc_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_num_calc_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_num_calc_t>())).curr_tok as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_num_calc_t),
            "::",
            stringify!(curr_tok)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_num_calc_t>())).number_value as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_num_calc_t),
            "::",
            stringify!(number_value)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_num_calc_t>())).string_value as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(r_num_calc_t),
            "::",
            stringify!(string_value)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_num_calc_t>())).errors as *const _ as usize },
        1048usize,
        concat!(
            "Offset of field: ",
            stringify!(r_num_calc_t),
            "::",
            stringify!(errors)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_num_calc_t>())).oc as *const _ as usize },
        1052usize,
        concat!(
            "Offset of field: ",
            stringify!(r_num_calc_t),
            "::",
            stringify!(oc)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_num_calc_t>())).calc_err as *const _ as usize },
        1056usize,
        concat!(
            "Offset of field: ",
            stringify!(r_num_calc_t),
            "::",
            stringify!(calc_err)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_num_calc_t>())).calc_i as *const _ as usize },
        1064usize,
        concat!(
            "Offset of field: ",
            stringify!(r_num_calc_t),
            "::",
            stringify!(calc_i)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_num_calc_t>())).calc_buf as *const _ as usize },
        1072usize,
        concat!(
            "Offset of field: ",
            stringify!(r_num_calc_t),
            "::",
            stringify!(calc_buf)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_num_calc_t>())).calc_len as *const _ as usize },
        1080usize,
        concat!(
            "Offset of field: ",
            stringify!(r_num_calc_t),
            "::",
            stringify!(calc_len)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_num_calc_t>())).under_calc as *const _ as usize },
        1084usize,
        concat!(
            "Offset of field: ",
            stringify!(r_num_calc_t),
            "::",
            stringify!(under_calc)
        )
    );
}
pub type RNumCalc = r_num_calc_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_num_t {
    pub callback: ::std::option::Option<
        unsafe extern "C" fn(
            userptr: *mut r_num_t,
            str_: *const ::std::os::raw::c_char,
            ok: *mut ::std::os::raw::c_int,
        ) -> u64,
    >,
    pub cb_from_value: ::std::option::Option<
        unsafe extern "C" fn(
            userptr: *mut r_num_t,
            value: u64,
            ok: *mut ::std::os::raw::c_int,
        ) -> *const ::std::os::raw::c_char,
    >,
    pub value: u64,
    pub fvalue: f64,
    pub userptr: *mut ::std::os::raw::c_void,
    pub dbz: ::std::os::raw::c_int,
    #[doc = " division by zero happened"]
    pub nc: RNumCalc,
}
#[test]
fn bindgen_test_layout_r_num_t() {
    assert_eq!(
        ::std::mem::size_of::<r_num_t>(),
        1136usize,
        concat!("Size of: ", stringify!(r_num_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_num_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_num_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_num_t>())).callback as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_num_t),
            "::",
            stringify!(callback)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_num_t>())).cb_from_value as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_num_t),
            "::",
            stringify!(cb_from_value)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_num_t>())).value as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(r_num_t),
            "::",
            stringify!(value)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_num_t>())).fvalue as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(r_num_t),
            "::",
            stringify!(fvalue)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_num_t>())).userptr as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(r_num_t),
            "::",
            stringify!(userptr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_num_t>())).dbz as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(r_num_t),
            "::",
            stringify!(dbz)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_num_t>())).nc as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(r_num_t),
            "::",
            stringify!(nc)
        )
    );
}
pub type RNum = r_num_t;
pub type RNumCallback = ::std::option::Option<
    unsafe extern "C" fn(
        self_: *mut r_num_t,
        str_: *const ::std::os::raw::c_char,
        ok: *mut ::std::os::raw::c_int,
    ) -> u64,
>;
pub type RNumCallback2 = ::std::option::Option<
    unsafe extern "C" fn(
        self_: *mut r_num_t,
        arg1: u64,
        ok: *mut ::std::os::raw::c_int,
    ) -> *const ::std::os::raw::c_char,
>;
extern "C" {
    pub fn r_num_new(
        cb: RNumCallback,
        cb2: RNumCallback2,
        ptr: *mut ::std::os::raw::c_void,
    ) -> *mut RNum;
}
extern "C" {
    pub fn r_num_free(num: *mut RNum);
}
extern "C" {
    pub fn r_num_units(
        buf: *mut ::std::os::raw::c_char,
        len: size_t,
        number: u64,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_num_conditional(
        num: *mut RNum,
        str_: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_num_calc(
        num: *mut RNum,
        str_: *const ::std::os::raw::c_char,
        err: *mut *const ::std::os::raw::c_char,
    ) -> u64;
}
extern "C" {
    pub fn r_num_calc_index(
        num: *mut RNum,
        p: *const ::std::os::raw::c_char,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_num_chs(
        cylinder: ::std::os::raw::c_int,
        head: ::std::os::raw::c_int,
        sector: ::std::os::raw::c_int,
        sectorsize: ::std::os::raw::c_int,
    ) -> u64;
}
extern "C" {
    pub fn r_num_is_valid_input(
        num: *mut RNum,
        input_value: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_num_get_input_value(num: *mut RNum, input_value: *const ::std::os::raw::c_char)
        -> u64;
}
extern "C" {
    pub fn r_num_get_name(num: *mut RNum, n: u64) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_num_as_string(
        ___: *mut RNum,
        n: u64,
        printable_only: bool,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_num_tail(num: *mut RNum, addr: u64, hex: *const ::std::os::raw::c_char) -> u64;
}
extern "C" {
    pub fn r_num_tail_base(num: *mut RNum, addr: u64, off: u64) -> u64;
}
extern "C" {
    pub fn r_num_segaddr(
        addr: u64,
        sb: u64,
        sg: ::std::os::raw::c_int,
        a: *mut u32,
        b: *mut u32,
    ) -> bool;
}
extern "C" {
    pub fn r_num_minmax_swap(a: *mut u64, b: *mut u64);
}
extern "C" {
    pub fn r_num_minmax_swap_i(a: *mut ::std::os::raw::c_int, b: *mut ::std::os::raw::c_int);
}
extern "C" {
    pub fn r_num_math(num: *mut RNum, str_: *const ::std::os::raw::c_char) -> u64;
}
extern "C" {
    pub fn r_num_get(num: *mut RNum, str_: *const ::std::os::raw::c_char) -> u64;
}
extern "C" {
    pub fn r_num_to_bits(out: *mut ::std::os::raw::c_char, num: u64) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_num_to_ternary(out: *mut ::std::os::raw::c_char, num: u64) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_num_rand(max: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_num_irand();
}
extern "C" {
    pub fn r_get_input_num_value(num: *mut RNum, input_value: *const ::std::os::raw::c_char)
        -> u64;
}
extern "C" {
    pub fn r_is_valid_input_num_value(
        num: *mut RNum,
        input_value: *const ::std::os::raw::c_char,
    ) -> bool;
}
extern "C" {
    pub fn r_num_between(
        num: *mut RNum,
        input_value: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_num_is_op(c: ::std::os::raw::c_char) -> bool;
}
extern "C" {
    pub fn r_num_str_len(str_: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_num_str_split(str_: *mut ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_num_str_split_list(str_: *mut ::std::os::raw::c_char) -> *mut RList;
}
extern "C" {
    pub fn r_num_dup(n: u64) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn r_num_cos(a: f64) -> f64;
}
extern "C" {
    pub fn r_num_sin(a: f64) -> f64;
}
extern "C" {
    pub fn r_num_bit_count(val: u32) -> size_t;
}
extern "C" {
    pub fn r_num_get_float(num: *mut RNum, str_: *const ::std::os::raw::c_char) -> f64;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RTableColumnType {
    pub name: *const ::std::os::raw::c_char,
    pub cmp: RListComparator,
}
#[test]
fn bindgen_test_layout_RTableColumnType() {
    assert_eq!(
        ::std::mem::size_of::<RTableColumnType>(),
        16usize,
        concat!("Size of: ", stringify!(RTableColumnType))
    );
    assert_eq!(
        ::std::mem::align_of::<RTableColumnType>(),
        8usize,
        concat!("Alignment of ", stringify!(RTableColumnType))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RTableColumnType>())).name as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(RTableColumnType),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RTableColumnType>())).cmp as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(RTableColumnType),
            "::",
            stringify!(cmp)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RTableColumn {
    pub name: *mut ::std::os::raw::c_char,
    pub type_: *mut RTableColumnType,
    pub align: ::std::os::raw::c_int,
    pub width: ::std::os::raw::c_int,
    pub maxWidth: ::std::os::raw::c_int,
    pub forceUppercase: bool,
    pub total: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_RTableColumn() {
    assert_eq!(
        ::std::mem::size_of::<RTableColumn>(),
        40usize,
        concat!("Size of: ", stringify!(RTableColumn))
    );
    assert_eq!(
        ::std::mem::align_of::<RTableColumn>(),
        8usize,
        concat!("Alignment of ", stringify!(RTableColumn))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RTableColumn>())).name as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(RTableColumn),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RTableColumn>())).type_ as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(RTableColumn),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RTableColumn>())).align as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(RTableColumn),
            "::",
            stringify!(align)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RTableColumn>())).width as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(RTableColumn),
            "::",
            stringify!(width)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RTableColumn>())).maxWidth as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(RTableColumn),
            "::",
            stringify!(maxWidth)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RTableColumn>())).forceUppercase as *const _ as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(RTableColumn),
            "::",
            stringify!(forceUppercase)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RTableColumn>())).total as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(RTableColumn),
            "::",
            stringify!(total)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RListInfo {
    pub name: *mut ::std::os::raw::c_char,
    pub pitv: RInterval,
    pub vitv: RInterval,
    pub perm: ::std::os::raw::c_int,
    pub extra: *mut ::std::os::raw::c_char,
}
#[test]
fn bindgen_test_layout_RListInfo() {
    assert_eq!(
        ::std::mem::size_of::<RListInfo>(),
        56usize,
        concat!("Size of: ", stringify!(RListInfo))
    );
    assert_eq!(
        ::std::mem::align_of::<RListInfo>(),
        8usize,
        concat!("Alignment of ", stringify!(RListInfo))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RListInfo>())).name as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(RListInfo),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RListInfo>())).pitv as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(RListInfo),
            "::",
            stringify!(pitv)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RListInfo>())).vitv as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(RListInfo),
            "::",
            stringify!(vitv)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RListInfo>())).perm as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(RListInfo),
            "::",
            stringify!(perm)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RListInfo>())).extra as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(RListInfo),
            "::",
            stringify!(extra)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RTableRow {
    pub items: *mut RList,
}
#[test]
fn bindgen_test_layout_RTableRow() {
    assert_eq!(
        ::std::mem::size_of::<RTableRow>(),
        8usize,
        concat!("Size of: ", stringify!(RTableRow))
    );
    assert_eq!(
        ::std::mem::align_of::<RTableRow>(),
        8usize,
        concat!("Alignment of ", stringify!(RTableRow))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RTableRow>())).items as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(RTableRow),
            "::",
            stringify!(items)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RTable {
    pub name: *mut ::std::os::raw::c_char,
    pub rows: *mut RList,
    pub cols: *mut RList,
    pub totalCols: ::std::os::raw::c_int,
    pub showHeader: bool,
    pub showFancy: bool,
    pub showSQL: bool,
    pub showJSON: bool,
    pub showCSV: bool,
    pub showR2: bool,
    pub showSum: bool,
    pub adjustedCols: bool,
    pub cons: *mut ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout_RTable() {
    assert_eq!(
        ::std::mem::size_of::<RTable>(),
        48usize,
        concat!("Size of: ", stringify!(RTable))
    );
    assert_eq!(
        ::std::mem::align_of::<RTable>(),
        8usize,
        concat!("Alignment of ", stringify!(RTable))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RTable>())).name as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(RTable),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RTable>())).rows as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(RTable),
            "::",
            stringify!(rows)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RTable>())).cols as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(RTable),
            "::",
            stringify!(cols)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RTable>())).totalCols as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(RTable),
            "::",
            stringify!(totalCols)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RTable>())).showHeader as *const _ as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(RTable),
            "::",
            stringify!(showHeader)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RTable>())).showFancy as *const _ as usize },
        29usize,
        concat!(
            "Offset of field: ",
            stringify!(RTable),
            "::",
            stringify!(showFancy)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RTable>())).showSQL as *const _ as usize },
        30usize,
        concat!(
            "Offset of field: ",
            stringify!(RTable),
            "::",
            stringify!(showSQL)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RTable>())).showJSON as *const _ as usize },
        31usize,
        concat!(
            "Offset of field: ",
            stringify!(RTable),
            "::",
            stringify!(showJSON)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RTable>())).showCSV as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(RTable),
            "::",
            stringify!(showCSV)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RTable>())).showR2 as *const _ as usize },
        33usize,
        concat!(
            "Offset of field: ",
            stringify!(RTable),
            "::",
            stringify!(showR2)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RTable>())).showSum as *const _ as usize },
        34usize,
        concat!(
            "Offset of field: ",
            stringify!(RTable),
            "::",
            stringify!(showSum)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RTable>())).adjustedCols as *const _ as usize },
        35usize,
        concat!(
            "Offset of field: ",
            stringify!(RTable),
            "::",
            stringify!(adjustedCols)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RTable>())).cons as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(RTable),
            "::",
            stringify!(cons)
        )
    );
}
pub type RTableSelector = ::std::option::Option<
    unsafe extern "C" fn(acc: *mut RTableRow, new_row: *mut RTableRow, nth: ::std::os::raw::c_int),
>;
extern "C" {
    pub fn r_table_row_free(_row: *mut ::std::os::raw::c_void);
}
extern "C" {
    pub fn r_table_column_free(_col: *mut ::std::os::raw::c_void);
}
extern "C" {
    pub fn r_table_column_clone(col: *mut RTableColumn) -> *mut RTableColumn;
}
extern "C" {
    pub fn r_table_type(name: *const ::std::os::raw::c_char) -> *mut RTableColumnType;
}
extern "C" {
    pub fn r_table_new(name: *const ::std::os::raw::c_char) -> *mut RTable;
}
extern "C" {
    pub fn r_table_clone(t: *const RTable) -> *mut RTable;
}
extern "C" {
    pub fn r_table_free(t: *mut RTable);
}
extern "C" {
    pub fn r_table_column_nth(
        t: *mut RTable,
        name: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_table_add_column(
        t: *mut RTable,
        type_: *mut RTableColumnType,
        name: *const ::std::os::raw::c_char,
        maxWidth: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn r_table_set_columnsf(t: *mut RTable, fmt: *const ::std::os::raw::c_char, ...);
}
extern "C" {
    pub fn r_table_row_new(items: *mut RList) -> *mut RTableRow;
}
extern "C" {
    pub fn r_table_add_row(t: *mut RTable, name: *const ::std::os::raw::c_char, ...);
}
extern "C" {
    pub fn r_table_add_rowf(t: *mut RTable, fmt: *const ::std::os::raw::c_char, ...);
}
extern "C" {
    pub fn r_table_add_row_list(t: *mut RTable, items: *mut RList);
}
extern "C" {
    pub fn r_table_tofancystring(t: *mut RTable) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_table_tosimplestring(t: *mut RTable) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_table_tostring(t: *mut RTable) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_table_tosql(t: *mut RTable) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_table_tocsv(t: *mut RTable) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_table_tor2cmds(t: *mut RTable) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_table_tojson(t: *mut RTable) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_table_help() -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_table_filter(
        t: *mut RTable,
        nth: ::std::os::raw::c_int,
        op: ::std::os::raw::c_int,
        un: *const ::std::os::raw::c_char,
    );
}
extern "C" {
    pub fn r_table_sort(t: *mut RTable, nth: ::std::os::raw::c_int, inc: bool);
}
extern "C" {
    pub fn r_table_uniq(t: *mut RTable);
}
extern "C" {
    pub fn r_table_group(t: *mut RTable, nth: ::std::os::raw::c_int, fcn: RTableSelector);
}
extern "C" {
    pub fn r_table_query(t: *mut RTable, q: *const ::std::os::raw::c_char) -> bool;
}
extern "C" {
    pub fn r_table_hide_header(t: *mut RTable);
}
extern "C" {
    pub fn r_table_align(
        t: *mut RTable,
        nth: ::std::os::raw::c_int,
        align: ::std::os::raw::c_int,
    ) -> bool;
}
extern "C" {
    pub fn r_table_visual_list(
        table: *mut RTable,
        list: *mut RList,
        seek: u64,
        len: u64,
        width: ::std::os::raw::c_int,
        va: bool,
    );
}
extern "C" {
    pub fn r_table_push(t: *mut RTable) -> *mut RTable;
}
extern "C" {
    pub fn r_table_pop(t: *mut RTable) -> *mut RTable;
}
extern "C" {
    pub fn r_table_fromjson(t: *mut RTable, csv: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn r_table_fromcsv(t: *mut RTable, csv: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn r_table_tohtml(t: *mut RTable) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_table_transpose(t: *mut RTable);
}
extern "C" {
    pub fn r_table_format(t: *mut RTable, nth: ::std::os::raw::c_int, type_: *mut RTableColumnType);
}
extern "C" {
    pub fn r_table_reduce(t: *mut RTable, nth: ::std::os::raw::c_int) -> u64;
}
extern "C" {
    pub fn r_table_columns(t: *mut RTable, cols: *mut RList);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_graph_node_t {
    pub idx: ::std::os::raw::c_uint,
    pub data: *mut ::std::os::raw::c_void,
    pub out_nodes: *mut RList,
    pub in_nodes: *mut RList,
    pub all_neighbours: *mut RList,
    pub free: RListFree,
}
#[test]
fn bindgen_test_layout_r_graph_node_t() {
    assert_eq!(
        ::std::mem::size_of::<r_graph_node_t>(),
        48usize,
        concat!("Size of: ", stringify!(r_graph_node_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_graph_node_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_graph_node_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_graph_node_t>())).idx as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_graph_node_t),
            "::",
            stringify!(idx)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_graph_node_t>())).data as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_graph_node_t),
            "::",
            stringify!(data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_graph_node_t>())).out_nodes as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(r_graph_node_t),
            "::",
            stringify!(out_nodes)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_graph_node_t>())).in_nodes as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(r_graph_node_t),
            "::",
            stringify!(in_nodes)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_graph_node_t>())).all_neighbours as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(r_graph_node_t),
            "::",
            stringify!(all_neighbours)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_graph_node_t>())).free as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(r_graph_node_t),
            "::",
            stringify!(free)
        )
    );
}
pub type RGraphNode = r_graph_node_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_graph_edge_t {
    pub from: *mut RGraphNode,
    pub to: *mut RGraphNode,
    pub nth: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_r_graph_edge_t() {
    assert_eq!(
        ::std::mem::size_of::<r_graph_edge_t>(),
        24usize,
        concat!("Size of: ", stringify!(r_graph_edge_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_graph_edge_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_graph_edge_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_graph_edge_t>())).from as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_graph_edge_t),
            "::",
            stringify!(from)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_graph_edge_t>())).to as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_graph_edge_t),
            "::",
            stringify!(to)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_graph_edge_t>())).nth as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(r_graph_edge_t),
            "::",
            stringify!(nth)
        )
    );
}
pub type RGraphEdge = r_graph_edge_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_graph_t {
    pub n_nodes: ::std::os::raw::c_uint,
    pub n_edges: ::std::os::raw::c_uint,
    pub last_index: ::std::os::raw::c_int,
    pub nodes: *mut RList,
}
#[test]
fn bindgen_test_layout_r_graph_t() {
    assert_eq!(
        ::std::mem::size_of::<r_graph_t>(),
        24usize,
        concat!("Size of: ", stringify!(r_graph_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_graph_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_graph_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_graph_t>())).n_nodes as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_graph_t),
            "::",
            stringify!(n_nodes)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_graph_t>())).n_edges as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(r_graph_t),
            "::",
            stringify!(n_edges)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_graph_t>())).last_index as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_graph_t),
            "::",
            stringify!(last_index)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_graph_t>())).nodes as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(r_graph_t),
            "::",
            stringify!(nodes)
        )
    );
}
pub type RGraph = r_graph_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_graph_visitor_t {
    pub discover_node: ::std::option::Option<
        unsafe extern "C" fn(n: *mut RGraphNode, vis: *mut r_graph_visitor_t),
    >,
    pub finish_node: ::std::option::Option<
        unsafe extern "C" fn(n: *mut RGraphNode, vis: *mut r_graph_visitor_t),
    >,
    pub tree_edge: ::std::option::Option<
        unsafe extern "C" fn(e: *const RGraphEdge, vis: *mut r_graph_visitor_t),
    >,
    pub back_edge: ::std::option::Option<
        unsafe extern "C" fn(e: *const RGraphEdge, vis: *mut r_graph_visitor_t),
    >,
    pub fcross_edge: ::std::option::Option<
        unsafe extern "C" fn(e: *const RGraphEdge, vis: *mut r_graph_visitor_t),
    >,
    pub data: *mut ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout_r_graph_visitor_t() {
    assert_eq!(
        ::std::mem::size_of::<r_graph_visitor_t>(),
        48usize,
        concat!("Size of: ", stringify!(r_graph_visitor_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_graph_visitor_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_graph_visitor_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_graph_visitor_t>())).discover_node as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_graph_visitor_t),
            "::",
            stringify!(discover_node)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_graph_visitor_t>())).finish_node as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_graph_visitor_t),
            "::",
            stringify!(finish_node)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_graph_visitor_t>())).tree_edge as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(r_graph_visitor_t),
            "::",
            stringify!(tree_edge)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_graph_visitor_t>())).back_edge as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(r_graph_visitor_t),
            "::",
            stringify!(back_edge)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_graph_visitor_t>())).fcross_edge as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(r_graph_visitor_t),
            "::",
            stringify!(fcross_edge)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_graph_visitor_t>())).data as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(r_graph_visitor_t),
            "::",
            stringify!(data)
        )
    );
}
pub type RGraphVisitor = r_graph_visitor_t;
extern "C" {
    pub fn r_graph_new() -> *mut RGraph;
}
extern "C" {
    pub fn r_graph_free(g: *mut RGraph);
}
extern "C" {
    pub fn r_graph_get_node(g: *const RGraph, idx: ::std::os::raw::c_uint) -> *mut RGraphNode;
}
extern "C" {
    pub fn r_graph_node_iter(g: *const RGraph, idx: ::std::os::raw::c_uint) -> *mut RListIter;
}
extern "C" {
    pub fn r_graph_reset(g: *mut RGraph);
}
extern "C" {
    pub fn r_graph_add_node(g: *mut RGraph, data: *mut ::std::os::raw::c_void) -> *mut RGraphNode;
}
extern "C" {
    pub fn r_graph_add_nodef(
        g: *mut RGraph,
        data: *mut ::std::os::raw::c_void,
        user_free: RListFree,
    ) -> *mut RGraphNode;
}
extern "C" {
    pub fn r_graph_del_node(g: *mut RGraph, n: *mut RGraphNode);
}
extern "C" {
    pub fn r_graph_add_edge(g: *mut RGraph, from: *mut RGraphNode, to: *mut RGraphNode);
}
extern "C" {
    pub fn r_graph_add_edge_at(
        g: *mut RGraph,
        from: *mut RGraphNode,
        to: *mut RGraphNode,
        nth: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn r_graph_node_split_forward(
        g: *mut RGraph,
        split_me: *mut RGraphNode,
        data: *mut ::std::os::raw::c_void,
    ) -> *mut RGraphNode;
}
extern "C" {
    pub fn r_graph_del_edge(g: *mut RGraph, from: *mut RGraphNode, to: *mut RGraphNode);
}
extern "C" {
    pub fn r_graph_get_neighbours(g: *const RGraph, n: *const RGraphNode) -> *const RList;
}
extern "C" {
    pub fn r_graph_nth_neighbour(
        g: *const RGraph,
        n: *const RGraphNode,
        nth: ::std::os::raw::c_int,
    ) -> *mut RGraphNode;
}
extern "C" {
    pub fn r_graph_innodes(g: *const RGraph, n: *const RGraphNode) -> *const RList;
}
extern "C" {
    pub fn r_graph_all_neighbours(g: *const RGraph, n: *const RGraphNode) -> *const RList;
}
extern "C" {
    pub fn r_graph_get_nodes(g: *const RGraph) -> *const RList;
}
extern "C" {
    pub fn r_graph_adjacent(
        g: *const RGraph,
        from: *const RGraphNode,
        to: *const RGraphNode,
    ) -> bool;
}
extern "C" {
    pub fn r_graph_dfs_node(g: *mut RGraph, n: *mut RGraphNode, vis: *mut RGraphVisitor);
}
extern "C" {
    pub fn r_graph_dfs_node_reverse(g: *mut RGraph, n: *mut RGraphNode, vis: *mut RGraphVisitor);
}
extern "C" {
    pub fn r_graph_dfs(g: *mut RGraph, vis: *mut RGraphVisitor);
}
pub const RPanelType_PANEL_TYPE_DEFAULT: RPanelType = 0;
pub const RPanelType_PANEL_TYPE_MENU: RPanelType = 1;
pub type RPanelType = ::std::os::raw::c_uint;
pub type RPanelDirectionCallback = ::std::option::Option<
    unsafe extern "C" fn(user: *mut ::std::os::raw::c_void, direction: ::std::os::raw::c_int),
>;
pub type RPanelRotateCallback =
    ::std::option::Option<unsafe extern "C" fn(user: *mut ::std::os::raw::c_void, rev: bool)>;
pub type RPanelPrintCallback = ::std::option::Option<
    unsafe extern "C" fn(user: *mut ::std::os::raw::c_void, p: *mut ::std::os::raw::c_void),
>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_panel_pos_t {
    pub x: ::std::os::raw::c_int,
    pub y: ::std::os::raw::c_int,
    pub w: ::std::os::raw::c_int,
    pub h: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_r_panel_pos_t() {
    assert_eq!(
        ::std::mem::size_of::<r_panel_pos_t>(),
        16usize,
        concat!("Size of: ", stringify!(r_panel_pos_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_panel_pos_t>(),
        4usize,
        concat!("Alignment of ", stringify!(r_panel_pos_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_panel_pos_t>())).x as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_panel_pos_t),
            "::",
            stringify!(x)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_panel_pos_t>())).y as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(r_panel_pos_t),
            "::",
            stringify!(y)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_panel_pos_t>())).w as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_panel_pos_t),
            "::",
            stringify!(w)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_panel_pos_t>())).h as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(r_panel_pos_t),
            "::",
            stringify!(h)
        )
    );
}
pub type RPanelPos = r_panel_pos_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_panel_model_t {
    pub directionCb: RPanelDirectionCallback,
    pub rotateCb: RPanelRotateCallback,
    pub print_cb: RPanelPrintCallback,
    pub type_: RPanelType,
    pub cmd: *mut ::std::os::raw::c_char,
    pub title: *mut ::std::os::raw::c_char,
    pub baseAddr: u64,
    pub addr: u64,
    pub cache: bool,
    pub cmdStrCache: *mut ::std::os::raw::c_char,
    pub readOnly: *mut ::std::os::raw::c_char,
    pub funcName: *mut ::std::os::raw::c_char,
    pub filter: *mut *mut ::std::os::raw::c_char,
    pub n_filter: ::std::os::raw::c_int,
    pub rotate: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_r_panel_model_t() {
    assert_eq!(
        ::std::mem::size_of::<r_panel_model_t>(),
        112usize,
        concat!("Size of: ", stringify!(r_panel_model_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_panel_model_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_panel_model_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_panel_model_t>())).directionCb as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_panel_model_t),
            "::",
            stringify!(directionCb)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_panel_model_t>())).rotateCb as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_panel_model_t),
            "::",
            stringify!(rotateCb)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_panel_model_t>())).print_cb as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(r_panel_model_t),
            "::",
            stringify!(print_cb)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_panel_model_t>())).type_ as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(r_panel_model_t),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_panel_model_t>())).cmd as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(r_panel_model_t),
            "::",
            stringify!(cmd)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_panel_model_t>())).title as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(r_panel_model_t),
            "::",
            stringify!(title)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_panel_model_t>())).baseAddr as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(r_panel_model_t),
            "::",
            stringify!(baseAddr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_panel_model_t>())).addr as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(r_panel_model_t),
            "::",
            stringify!(addr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_panel_model_t>())).cache as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(r_panel_model_t),
            "::",
            stringify!(cache)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_panel_model_t>())).cmdStrCache as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(r_panel_model_t),
            "::",
            stringify!(cmdStrCache)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_panel_model_t>())).readOnly as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(r_panel_model_t),
            "::",
            stringify!(readOnly)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_panel_model_t>())).funcName as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(r_panel_model_t),
            "::",
            stringify!(funcName)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_panel_model_t>())).filter as *const _ as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(r_panel_model_t),
            "::",
            stringify!(filter)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_panel_model_t>())).n_filter as *const _ as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(r_panel_model_t),
            "::",
            stringify!(n_filter)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_panel_model_t>())).rotate as *const _ as usize },
        108usize,
        concat!(
            "Offset of field: ",
            stringify!(r_panel_model_t),
            "::",
            stringify!(rotate)
        )
    );
}
pub type RPanelModel = r_panel_model_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_panel_view_t {
    pub pos: RPanelPos,
    pub prevPos: RPanelPos,
    pub sx: ::std::os::raw::c_int,
    pub sy: ::std::os::raw::c_int,
    pub curpos: ::std::os::raw::c_int,
    pub refresh: bool,
    pub edge: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_r_panel_view_t() {
    assert_eq!(
        ::std::mem::size_of::<r_panel_view_t>(),
        52usize,
        concat!("Size of: ", stringify!(r_panel_view_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_panel_view_t>(),
        4usize,
        concat!("Alignment of ", stringify!(r_panel_view_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_panel_view_t>())).pos as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_panel_view_t),
            "::",
            stringify!(pos)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_panel_view_t>())).prevPos as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(r_panel_view_t),
            "::",
            stringify!(prevPos)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_panel_view_t>())).sx as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(r_panel_view_t),
            "::",
            stringify!(sx)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_panel_view_t>())).sy as *const _ as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(r_panel_view_t),
            "::",
            stringify!(sy)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_panel_view_t>())).curpos as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(r_panel_view_t),
            "::",
            stringify!(curpos)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_panel_view_t>())).refresh as *const _ as usize },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(r_panel_view_t),
            "::",
            stringify!(refresh)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_panel_view_t>())).edge as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(r_panel_view_t),
            "::",
            stringify!(edge)
        )
    );
}
pub type RPanelView = r_panel_view_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_panel_t {
    pub model: *mut RPanelModel,
    pub view: *mut RPanelView,
}
#[test]
fn bindgen_test_layout_r_panel_t() {
    assert_eq!(
        ::std::mem::size_of::<r_panel_t>(),
        16usize,
        concat!("Size of: ", stringify!(r_panel_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_panel_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_panel_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_panel_t>())).model as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_panel_t),
            "::",
            stringify!(model)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_panel_t>())).view as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_panel_t),
            "::",
            stringify!(view)
        )
    );
}
pub type RPanel = r_panel_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_mem_pool_factory_t {
    pub limit: ::std::os::raw::c_int,
    pub pools: *mut *mut RMemoryPool,
}
#[test]
fn bindgen_test_layout_r_mem_pool_factory_t() {
    assert_eq!(
        ::std::mem::size_of::<r_mem_pool_factory_t>(),
        16usize,
        concat!("Size of: ", stringify!(r_mem_pool_factory_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_mem_pool_factory_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_mem_pool_factory_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_mem_pool_factory_t>())).limit as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_mem_pool_factory_t),
            "::",
            stringify!(limit)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_mem_pool_factory_t>())).pools as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_mem_pool_factory_t),
            "::",
            stringify!(pools)
        )
    );
}
pub type RPoolFactory = r_mem_pool_factory_t;
extern "C" {
    pub fn r_poolfactory_instance() -> *mut RPoolFactory;
}
extern "C" {
    pub fn r_poolfactory_init(limit: ::std::os::raw::c_int);
}
extern "C" {
    pub fn r_poolfactory_new(limit: ::std::os::raw::c_int) -> *mut RPoolFactory;
}
extern "C" {
    pub fn r_poolfactory_alloc(
        pf: *mut RPoolFactory,
        nodesize: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn r_poolfactory_stats(pf: *mut RPoolFactory);
}
extern "C" {
    pub fn r_poolfactory_free(pf: *mut RPoolFactory);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RStrBuf {
    pub buf: [::std::os::raw::c_char; 32usize],
    pub len: size_t,
    pub ptr: *mut ::std::os::raw::c_char,
    pub ptrlen: size_t,
    pub weakref: bool,
}
#[test]
fn bindgen_test_layout_RStrBuf() {
    assert_eq!(
        ::std::mem::size_of::<RStrBuf>(),
        64usize,
        concat!("Size of: ", stringify!(RStrBuf))
    );
    assert_eq!(
        ::std::mem::align_of::<RStrBuf>(),
        8usize,
        concat!("Alignment of ", stringify!(RStrBuf))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RStrBuf>())).buf as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(RStrBuf),
            "::",
            stringify!(buf)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RStrBuf>())).len as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(RStrBuf),
            "::",
            stringify!(len)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RStrBuf>())).ptr as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(RStrBuf),
            "::",
            stringify!(ptr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RStrBuf>())).ptrlen as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(RStrBuf),
            "::",
            stringify!(ptrlen)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RStrBuf>())).weakref as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(RStrBuf),
            "::",
            stringify!(weakref)
        )
    );
}
extern "C" {
    pub fn r_strbuf_new(s: *const ::std::os::raw::c_char) -> *mut RStrBuf;
}
extern "C" {
    pub fn r_strbuf_set(
        sb: *mut RStrBuf,
        s: *const ::std::os::raw::c_char,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_strbuf_slice(
        sb: *mut RStrBuf,
        from: ::std::os::raw::c_int,
        len: ::std::os::raw::c_int,
    ) -> bool;
}
extern "C" {
    pub fn r_strbuf_setbin(sb: *mut RStrBuf, s: *const u8, len: size_t) -> bool;
}
extern "C" {
    pub fn r_strbuf_getbin(sb: *mut RStrBuf, len: *mut ::std::os::raw::c_int) -> *mut u8;
}
extern "C" {
    pub fn r_strbuf_setf(
        sb: *mut RStrBuf,
        fmt: *const ::std::os::raw::c_char,
        ...
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_strbuf_vsetf(
        sb: *mut RStrBuf,
        fmt: *const ::std::os::raw::c_char,
        ap: *mut __va_list_tag,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_strbuf_append(sb: *mut RStrBuf, s: *const ::std::os::raw::c_char) -> bool;
}
extern "C" {
    pub fn r_strbuf_append_n(sb: *mut RStrBuf, s: *const ::std::os::raw::c_char, l: size_t)
        -> bool;
}
extern "C" {
    pub fn r_strbuf_prepend(sb: *mut RStrBuf, s: *const ::std::os::raw::c_char) -> bool;
}
extern "C" {
    pub fn r_strbuf_appendf(sb: *mut RStrBuf, fmt: *const ::std::os::raw::c_char, ...) -> bool;
}
extern "C" {
    pub fn r_strbuf_vappendf(
        sb: *mut RStrBuf,
        fmt: *const ::std::os::raw::c_char,
        ap: *mut __va_list_tag,
    ) -> bool;
}
extern "C" {
    pub fn r_strbuf_get(sb: *mut RStrBuf) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_strbuf_drain(sb: *mut RStrBuf) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_strbuf_drain_nofree(sb: *mut RStrBuf) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_strbuf_length(sb: *mut RStrBuf) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_strbuf_size(sb: *mut RStrBuf) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_strbuf_free(sb: *mut RStrBuf);
}
extern "C" {
    pub fn r_strbuf_fini(sb: *mut RStrBuf);
}
extern "C" {
    pub fn r_strbuf_init(sb: *mut RStrBuf);
}
extern "C" {
    pub fn r_strbuf_initf(
        sb: *mut RStrBuf,
        fmt: *const ::std::os::raw::c_char,
        ...
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_strbuf_copy(dst: *mut RStrBuf, src: *mut RStrBuf) -> bool;
}
extern "C" {
    pub fn r_strbuf_equals(sa: *mut RStrBuf, sb: *mut RStrBuf) -> bool;
}
extern "C" {
    pub fn r_strbuf_reserve(sb: *mut RStrBuf, len: size_t) -> bool;
}
extern "C" {
    pub fn r_strbuf_is_empty(sb: *mut RStrBuf) -> bool;
}
extern "C" {
    pub fn r_strbuf_setptr(
        sb: *mut RStrBuf,
        p: *mut ::std::os::raw::c_char,
        l: ::std::os::raw::c_int,
    ) -> bool;
}
pub const PJEncodingStr_PJ_ENCODING_STR_DEFAULT: PJEncodingStr = 0;
pub const PJEncodingStr_PJ_ENCODING_STR_BASE64: PJEncodingStr = 1;
pub const PJEncodingStr_PJ_ENCODING_STR_HEX: PJEncodingStr = 2;
pub const PJEncodingStr_PJ_ENCODING_STR_ARRAY: PJEncodingStr = 3;
pub const PJEncodingStr_PJ_ENCODING_STR_STRIP: PJEncodingStr = 4;
pub type PJEncodingStr = ::std::os::raw::c_uint;
pub const PJEncodingNum_PJ_ENCODING_NUM_DEFAULT: PJEncodingNum = 0;
pub const PJEncodingNum_PJ_ENCODING_NUM_STR: PJEncodingNum = 1;
pub const PJEncodingNum_PJ_ENCODING_NUM_HEX: PJEncodingNum = 2;
pub type PJEncodingNum = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pj_t {
    pub sb: RStrBuf,
    pub is_first: bool,
    pub is_key: bool,
    pub comma: *const ::std::os::raw::c_char,
    pub braces: [::std::os::raw::c_char; 128usize],
    pub level: ::std::os::raw::c_int,
    pub str_encoding: PJEncodingStr,
    pub num_encoding: PJEncodingNum,
}
#[test]
fn bindgen_test_layout_pj_t() {
    assert_eq!(
        ::std::mem::size_of::<pj_t>(),
        224usize,
        concat!("Size of: ", stringify!(pj_t))
    );
    assert_eq!(
        ::std::mem::align_of::<pj_t>(),
        8usize,
        concat!("Alignment of ", stringify!(pj_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pj_t>())).sb as *const _ as usize },
        0usize,
        concat!("Offset of field: ", stringify!(pj_t), "::", stringify!(sb))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pj_t>())).is_first as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(pj_t),
            "::",
            stringify!(is_first)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pj_t>())).is_key as *const _ as usize },
        65usize,
        concat!(
            "Offset of field: ",
            stringify!(pj_t),
            "::",
            stringify!(is_key)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pj_t>())).comma as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(pj_t),
            "::",
            stringify!(comma)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pj_t>())).braces as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(pj_t),
            "::",
            stringify!(braces)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pj_t>())).level as *const _ as usize },
        208usize,
        concat!(
            "Offset of field: ",
            stringify!(pj_t),
            "::",
            stringify!(level)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pj_t>())).str_encoding as *const _ as usize },
        212usize,
        concat!(
            "Offset of field: ",
            stringify!(pj_t),
            "::",
            stringify!(str_encoding)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pj_t>())).num_encoding as *const _ as usize },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(pj_t),
            "::",
            stringify!(num_encoding)
        )
    );
}
pub type PJ = pj_t;
extern "C" {
    pub fn r_sandbox_opendir(path: *const ::std::os::raw::c_char) -> *mut DIR;
}
extern "C" {
    pub fn r_sandbox_truncate(fd: ::std::os::raw::c_int, length: u64) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_sandbox_lseek(
        fd: ::std::os::raw::c_int,
        addr: u64,
        mode: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_sandbox_close(fd: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_sandbox_read(
        fd: ::std::os::raw::c_int,
        buf: *mut u8,
        len: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_sandbox_write(
        fd: ::std::os::raw::c_int,
        buf: *const u8,
        len: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_sandbox_system(
        x: *const ::std::os::raw::c_char,
        fork: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_sandbox_creat(
        path: *const ::std::os::raw::c_char,
        mode: ::std::os::raw::c_int,
    ) -> bool;
}
extern "C" {
    pub fn r_sandbox_open(
        path: *const ::std::os::raw::c_char,
        mode: ::std::os::raw::c_int,
        perm: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_sandbox_fopen(
        path: *const ::std::os::raw::c_char,
        mode: *const ::std::os::raw::c_char,
    ) -> *mut FILE;
}
extern "C" {
    pub fn r_sandbox_chdir(path: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_sandbox_check_path(path: *const ::std::os::raw::c_char) -> bool;
}
extern "C" {
    pub fn r_sandbox_kill(
        pid: ::std::os::raw::c_int,
        sig: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_sandbox_enable(e: bool) -> bool;
}
extern "C" {
    pub fn r_sandbox_disable(e: bool) -> bool;
}
extern "C" {
    pub fn r_sandbox_grain(mask: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_sandbox_check(mask: ::std::os::raw::c_int) -> bool;
}
pub type RStackFree = ::std::option::Option<unsafe extern "C" fn(ptr: *mut ::std::os::raw::c_void)>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_stack_t {
    pub elems: *mut *mut ::std::os::raw::c_void,
    pub n_elems: ::std::os::raw::c_uint,
    pub top: ::std::os::raw::c_int,
    pub free: RStackFree,
}
#[test]
fn bindgen_test_layout_r_stack_t() {
    assert_eq!(
        ::std::mem::size_of::<r_stack_t>(),
        24usize,
        concat!("Size of: ", stringify!(r_stack_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_stack_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_stack_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_stack_t>())).elems as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_stack_t),
            "::",
            stringify!(elems)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_stack_t>())).n_elems as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_stack_t),
            "::",
            stringify!(n_elems)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_stack_t>())).top as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(r_stack_t),
            "::",
            stringify!(top)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_stack_t>())).free as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(r_stack_t),
            "::",
            stringify!(free)
        )
    );
}
pub type RStack = r_stack_t;
extern "C" {
    pub fn r_stack_new(n: u32) -> *mut RStack;
}
extern "C" {
    pub fn r_stack_free(s: *mut RStack);
}
extern "C" {
    pub fn r_stack_is_empty(s: *mut RStack) -> bool;
}
extern "C" {
    pub fn r_stack_newf(n: u32, f: RStackFree) -> *mut RStack;
}
extern "C" {
    pub fn r_stack_push(s: *mut RStack, el: *mut ::std::os::raw::c_void) -> bool;
}
extern "C" {
    pub fn r_stack_pop(s: *mut RStack) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn r_stack_size(s: *mut RStack) -> size_t;
}
extern "C" {
    pub fn r_stack_peek(s: *mut RStack) -> *mut ::std::os::raw::c_void;
}
pub const RStrEnc_R_STRING_ENC_LATIN1: RStrEnc = 97;
pub const RStrEnc_R_STRING_ENC_UTF8: RStrEnc = 56;
pub const RStrEnc_R_STRING_ENC_UTF16LE: RStrEnc = 117;
pub const RStrEnc_R_STRING_ENC_UTF32LE: RStrEnc = 85;
pub const RStrEnc_R_STRING_ENC_UTF16BE: RStrEnc = 98;
pub const RStrEnc_R_STRING_ENC_UTF32BE: RStrEnc = 66;
pub const RStrEnc_R_STRING_ENC_GUESS: RStrEnc = 103;
pub type RStrEnc = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_charset_rune_t {
    pub ch: *mut u8,
    pub hx: *mut u8,
    pub left: *mut r_charset_rune_t,
    pub right: *mut r_charset_rune_t,
}
#[test]
fn bindgen_test_layout_r_charset_rune_t() {
    assert_eq!(
        ::std::mem::size_of::<r_charset_rune_t>(),
        32usize,
        concat!("Size of: ", stringify!(r_charset_rune_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_charset_rune_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_charset_rune_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_charset_rune_t>())).ch as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_charset_rune_t),
            "::",
            stringify!(ch)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_charset_rune_t>())).hx as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_charset_rune_t),
            "::",
            stringify!(hx)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_charset_rune_t>())).left as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(r_charset_rune_t),
            "::",
            stringify!(left)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_charset_rune_t>())).right as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(r_charset_rune_t),
            "::",
            stringify!(right)
        )
    );
}
pub type RCharsetRune = r_charset_rune_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_charset_t {
    pub loaded: bool,
    pub db: *mut Sdb,
    pub db_char_to_hex: *mut Sdb,
    pub custom_charset: *mut RCharsetRune,
    pub encode_maxkeylen: size_t,
    pub decode_maxkeylen: size_t,
}
#[test]
fn bindgen_test_layout_r_charset_t() {
    assert_eq!(
        ::std::mem::size_of::<r_charset_t>(),
        48usize,
        concat!("Size of: ", stringify!(r_charset_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_charset_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_charset_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_charset_t>())).loaded as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_charset_t),
            "::",
            stringify!(loaded)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_charset_t>())).db as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_charset_t),
            "::",
            stringify!(db)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_charset_t>())).db_char_to_hex as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(r_charset_t),
            "::",
            stringify!(db_char_to_hex)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_charset_t>())).custom_charset as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(r_charset_t),
            "::",
            stringify!(custom_charset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_charset_t>())).encode_maxkeylen as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(r_charset_t),
            "::",
            stringify!(encode_maxkeylen)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_charset_t>())).decode_maxkeylen as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(r_charset_t),
            "::",
            stringify!(decode_maxkeylen)
        )
    );
}
pub type RCharset = r_charset_t;
extern "C" {
    pub fn r_charset_new() -> *mut RCharset;
}
extern "C" {
    pub fn r_charset_free(charset: *mut RCharset);
}
extern "C" {
    pub fn r_charset_rune_new(ch: *const u8, hx: *const u8) -> *mut RCharsetRune;
}
extern "C" {
    pub fn r_charset_rune_free(rcr: *mut RCharsetRune);
}
extern "C" {
    pub fn r_charset_encode_str(
        rc: *mut RCharset,
        out: *mut u8,
        out_len: size_t,
        in_: *const u8,
        in_len: size_t,
    ) -> size_t;
}
extern "C" {
    pub fn r_charset_decode_str(
        rc: *mut RCharset,
        out: *mut u8,
        out_len: size_t,
        in_: *const u8,
        in_len: size_t,
    ) -> size_t;
}
extern "C" {
    pub fn r_charset_open(c: *mut RCharset, cs: *const ::std::os::raw::c_char) -> bool;
}
extern "C" {
    pub fn r_charset_use(c: *mut RCharset, cf: *const ::std::os::raw::c_char) -> bool;
}
extern "C" {
    pub fn r_charset_list(c: *mut RCharset) -> *mut RList;
}
extern "C" {
    pub fn r_charset_close(c: *mut RCharset);
}
extern "C" {
    pub fn r_str_repeat(
        ch: *const ::std::os::raw::c_char,
        sz: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_pad(
        ch: ::std::os::raw::c_char,
        len: ::std::os::raw::c_int,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_rstr(
        base: *const ::std::os::raw::c_char,
        p: *const ::std::os::raw::c_char,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_strstr_ansi(
        a: *const ::std::os::raw::c_char,
        b: *const ::std::os::raw::c_char,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_rchr(
        base: *const ::std::os::raw::c_char,
        p: *const ::std::os::raw::c_char,
        ch: ::std::os::raw::c_int,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_closer_chr(
        b: *const ::std::os::raw::c_char,
        s: *const ::std::os::raw::c_char,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_bounds(
        str_: *const ::std::os::raw::c_char,
        h: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_str_crop(
        str_: *const ::std::os::raw::c_char,
        x: ::std::os::raw::c_uint,
        y: ::std::os::raw::c_uint,
        x2: ::std::os::raw::c_uint,
        y2: ::std::os::raw::c_uint,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_scale(
        r: *const ::std::os::raw::c_char,
        w: ::std::os::raw::c_int,
        h: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_range_in(r: *const ::std::os::raw::c_char, addr: u64) -> bool;
}
extern "C" {
    pub fn r_str_size(
        s: *const ::std::os::raw::c_char,
        rows: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_str_len_utf8(s: *const ::std::os::raw::c_char) -> size_t;
}
extern "C" {
    pub fn r_str_len_utf8_ansi(str_: *const ::std::os::raw::c_char) -> size_t;
}
extern "C" {
    pub fn r_str_len_utf8char(
        s: *const ::std::os::raw::c_char,
        left: ::std::os::raw::c_int,
    ) -> size_t;
}
extern "C" {
    pub fn r_str_utf8_charsize(str_: *const ::std::os::raw::c_char) -> size_t;
}
extern "C" {
    pub fn r_str_utf8_charsize_prev(
        str_: *const ::std::os::raw::c_char,
        prev_len: ::std::os::raw::c_int,
    ) -> size_t;
}
extern "C" {
    pub fn r_str_utf8_charsize_last(str_: *const ::std::os::raw::c_char) -> size_t;
}
extern "C" {
    pub fn r_str_filter_zeroline(str_: *mut ::std::os::raw::c_char, len: ::std::os::raw::c_int);
}
extern "C" {
    pub fn r_str_utf8_codepoint(s: *const ::std::os::raw::c_char, left: size_t) -> size_t;
}
extern "C" {
    pub fn r_str_char_fullwidth(s: *const ::std::os::raw::c_char, left: size_t) -> bool;
}
extern "C" {
    pub fn r_str_write(
        fd: ::std::os::raw::c_int,
        b: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_str_ncpy(
        dst: *mut ::std::os::raw::c_char,
        src: *const ::std::os::raw::c_char,
        n: size_t,
    ) -> size_t;
}
extern "C" {
    pub fn r_str_sanitize(c: *mut ::std::os::raw::c_char);
}
extern "C" {
    pub fn r_str_sanitize_sdb_key(s: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_casestr(
        a: *const ::std::os::raw::c_char,
        b: *const ::std::os::raw::c_char,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_firstbut(
        s: *const ::std::os::raw::c_char,
        ch: ::std::os::raw::c_char,
        but: *const ::std::os::raw::c_char,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_firstbut_escape(
        s: *const ::std::os::raw::c_char,
        ch: ::std::os::raw::c_char,
        but: *const ::std::os::raw::c_char,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_lastbut(
        s: *const ::std::os::raw::c_char,
        ch: ::std::os::raw::c_char,
        but: *const ::std::os::raw::c_char,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_split(
        str_: *mut ::std::os::raw::c_char,
        ch: ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_str_split_list(
        str_: *mut ::std::os::raw::c_char,
        c: *const ::std::os::raw::c_char,
        n: ::std::os::raw::c_int,
    ) -> *mut RList;
}
extern "C" {
    pub fn r_str_split_duplist(
        str_: *const ::std::os::raw::c_char,
        c: *const ::std::os::raw::c_char,
        trim: bool,
    ) -> *mut RList;
}
extern "C" {
    pub fn r_str_split_lines(str_: *mut ::std::os::raw::c_char, count: *mut size_t) -> *mut size_t;
}
extern "C" {
    pub fn r_str_replace(
        str_: *mut ::std::os::raw::c_char,
        key: *const ::std::os::raw::c_char,
        val: *const ::std::os::raw::c_char,
        g: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_replace_icase(
        str_: *mut ::std::os::raw::c_char,
        key: *const ::std::os::raw::c_char,
        val: *const ::std::os::raw::c_char,
        g: ::std::os::raw::c_int,
        keep_case: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_replace_in(
        str_: *mut ::std::os::raw::c_char,
        sz: u32,
        key: *const ::std::os::raw::c_char,
        val: *const ::std::os::raw::c_char,
        g: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_bits(
        strout: *mut ::std::os::raw::c_char,
        buf: *const u8,
        len: ::std::os::raw::c_int,
        bitz: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_str_bits64(strout: *mut ::std::os::raw::c_char, in_: u64) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_str_bits_from_string(
        buf: *const ::std::os::raw::c_char,
        bitz: *const ::std::os::raw::c_char,
    ) -> u64;
}
extern "C" {
    pub fn r_str_rwx(str_: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_str_replace_ch(
        s: *mut ::std::os::raw::c_char,
        a: ::std::os::raw::c_char,
        b: ::std::os::raw::c_char,
        g: bool,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_str_replace_char(
        s: *mut ::std::os::raw::c_char,
        a: ::std::os::raw::c_int,
        b: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_str_replace_char_once(
        s: *mut ::std::os::raw::c_char,
        a: ::std::os::raw::c_int,
        b: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_str_remove_char(str_: *mut ::std::os::raw::c_char, c: ::std::os::raw::c_char);
}
extern "C" {
    pub fn r_str_rwx_i(rwx: ::std::os::raw::c_int) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_fmtargs(fmt: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_str_arg_escape(arg: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_arg_unescape(arg: *mut ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_str_argv(
        str_: *const ::std::os::raw::c_char,
        _argc: *mut ::std::os::raw::c_int,
    ) -> *mut *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_argv_free(argv: *mut *mut ::std::os::raw::c_char);
}
extern "C" {
    pub fn r_str_new(str_: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_snprintf(
        string: *mut ::std::os::raw::c_char,
        len: ::std::os::raw::c_int,
        fmt: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_str_is_ascii(str_: *const ::std::os::raw::c_char) -> bool;
}
extern "C" {
    pub fn r_str_nextword(
        s: *mut ::std::os::raw::c_char,
        ch: ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_is_printable(str_: *const ::std::os::raw::c_char) -> bool;
}
extern "C" {
    pub fn r_str_is_printable_limited(
        str_: *const ::std::os::raw::c_char,
        size: ::std::os::raw::c_int,
    ) -> bool;
}
extern "C" {
    pub fn r_str_is_printable_incl_newlines(str_: *const ::std::os::raw::c_char) -> bool;
}
extern "C" {
    pub fn r_str_appendlen(
        ptr: *mut ::std::os::raw::c_char,
        string: *const ::std::os::raw::c_char,
        slen: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_newf(fmt: *const ::std::os::raw::c_char, ...) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_newvf(
        fmt: *const ::std::os::raw::c_char,
        ap: *mut __va_list_tag,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_distance(
        a: *const ::std::os::raw::c_char,
        b: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_str_newlen(
        str_: *const ::std::os::raw::c_char,
        len: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_sysbits(v: ::std::os::raw::c_int) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_trunc_ellipsis(
        str_: *const ::std::os::raw::c_char,
        len: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_bool(b: ::std::os::raw::c_int) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_is_true(s: *const ::std::os::raw::c_char) -> bool;
}
extern "C" {
    pub fn r_str_is_false(s: *const ::std::os::raw::c_char) -> bool;
}
extern "C" {
    pub fn r_str_is_bool(val: *const ::std::os::raw::c_char) -> bool;
}
extern "C" {
    pub fn r_str_ansi_chrn(
        str_: *const ::std::os::raw::c_char,
        n: size_t,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_ansi_len(str_: *const ::std::os::raw::c_char) -> size_t;
}
extern "C" {
    pub fn r_str_ansi_nlen(str_: *const ::std::os::raw::c_char, len: size_t) -> size_t;
}
extern "C" {
    pub fn r_str_ansi_trim(
        str_: *mut ::std::os::raw::c_char,
        str_len: ::std::os::raw::c_int,
        n: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_str_ansi_filter(
        str_: *mut ::std::os::raw::c_char,
        out: *mut *mut ::std::os::raw::c_char,
        cposs: *mut *mut ::std::os::raw::c_int,
        len: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_str_ansi_crop(
        str_: *const ::std::os::raw::c_char,
        x: ::std::os::raw::c_uint,
        y: ::std::os::raw::c_uint,
        x2: ::std::os::raw::c_uint,
        y2: ::std::os::raw::c_uint,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_word_count(string: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_str_char_count(
        string: *const ::std::os::raw::c_char,
        ch: ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_str_word_get0set(
        stra: *mut ::std::os::raw::c_char,
        stralen: ::std::os::raw::c_int,
        idx: ::std::os::raw::c_int,
        newstr: *const ::std::os::raw::c_char,
        newlen: *mut ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_word_set0(str_: *mut ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_str_word_set0_stack(str_: *mut ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_str_word_get0(
        str_: *const ::std::os::raw::c_char,
        idx: ::std::os::raw::c_int,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_word_get_first(
        string: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_trim(str_: *mut ::std::os::raw::c_char);
}
extern "C" {
    pub fn r_str_wrap(
        str_: *const ::std::os::raw::c_char,
        w: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_trim_dup(str_: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_trim_lines(str_: *mut ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_trim_head(str_: *mut ::std::os::raw::c_char);
}
extern "C" {
    pub fn r_str_trim_head_ro(str_: *const ::std::os::raw::c_char)
        -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_trim_head_wp(str_: *const ::std::os::raw::c_char)
        -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_trim_tail(str_: *mut ::std::os::raw::c_char);
}
extern "C" {
    pub fn r_str_trim_args(str_: *mut ::std::os::raw::c_char);
}
extern "C" {
    pub fn r_str_hash(str_: *const ::std::os::raw::c_char) -> u32;
}
extern "C" {
    pub fn r_str_hash64(str_: *const ::std::os::raw::c_char) -> u64;
}
extern "C" {
    pub fn r_str_trim_nc(str_: *mut ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_nstr(
        from: *const ::std::os::raw::c_char,
        to: *const ::std::os::raw::c_char,
        size: ::std::os::raw::c_int,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_lchr(
        str_: *const ::std::os::raw::c_char,
        chr: ::std::os::raw::c_char,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_sub_str_lchr(
        str_: *const ::std::os::raw::c_char,
        start: ::std::os::raw::c_int,
        end: ::std::os::raw::c_int,
        chr: ::std::os::raw::c_char,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_sub_str_rchr(
        str_: *const ::std::os::raw::c_char,
        start: ::std::os::raw::c_int,
        end: ::std::os::raw::c_int,
        chr: ::std::os::raw::c_char,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_ichr(
        str_: *mut ::std::os::raw::c_char,
        chr: ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_ccmp(
        dst: *const ::std::os::raw::c_char,
        orig: *const ::std::os::raw::c_char,
        ch: ::std::os::raw::c_int,
    ) -> bool;
}
extern "C" {
    pub fn r_str_cmp_list(
        list: *const ::std::os::raw::c_char,
        item: *const ::std::os::raw::c_char,
        sep: ::std::os::raw::c_char,
    ) -> bool;
}
extern "C" {
    pub fn r_str_cmp(
        dst: *const ::std::os::raw::c_char,
        orig: *const ::std::os::raw::c_char,
        len: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_str_casecmp(
        dst: *const ::std::os::raw::c_char,
        orig: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_str_ncasecmp(
        dst: *const ::std::os::raw::c_char,
        orig: *const ::std::os::raw::c_char,
        n: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_str_ccpy(
        dst: *mut ::std::os::raw::c_char,
        orig: *mut ::std::os::raw::c_char,
        ch: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_str_get(str_: *const ::std::os::raw::c_char) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_get_fail(
        str_: *const ::std::os::raw::c_char,
        failstr: *const ::std::os::raw::c_char,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_getf(str_: *const ::std::os::raw::c_char) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_ndup(
        ptr: *const ::std::os::raw::c_char,
        len: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_dup(
        ptr: *mut ::std::os::raw::c_char,
        string: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_inject(
        begin: *mut ::std::os::raw::c_char,
        end: *mut ::std::os::raw::c_char,
        str_: *mut ::std::os::raw::c_char,
        maxlen: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_str_delta(
        p: *mut ::std::os::raw::c_char,
        a: ::std::os::raw::c_char,
        b: ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_str_filter(str_: *mut ::std::os::raw::c_char, len: ::std::os::raw::c_int);
}
extern "C" {
    pub fn r_str_tok(
        str1: *const ::std::os::raw::c_char,
        b: ::std::os::raw::c_char,
        len: size_t,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_mb_to_wc(buf: *const ::std::os::raw::c_char) -> *mut wchar_t;
}
extern "C" {
    pub fn r_str_wc_to_mb(buf: *const wchar_t) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_mb_to_wc_l(
        buf: *const ::std::os::raw::c_char,
        len: ::std::os::raw::c_int,
    ) -> *mut wchar_t;
}
extern "C" {
    pub fn r_str_wc_to_mb_l(
        buf: *const wchar_t,
        len: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_str_xy(
        s: *const ::std::os::raw::c_char,
        word: *const ::std::os::raw::c_char,
        prev: *const ::std::os::raw::c_char,
        x: *mut ::std::os::raw::c_int,
        y: *mut ::std::os::raw::c_int,
    ) -> *const ::std::os::raw::c_char;
}
pub type str_operation =
    ::std::option::Option<unsafe extern "C" fn(c: *mut ::std::os::raw::c_char)>;
extern "C" {
    pub fn r_str_do_until_token(
        op: str_operation,
        str_: *mut ::std::os::raw::c_char,
        tok: ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_str_reverse(str_: *mut ::std::os::raw::c_char);
}
extern "C" {
    pub fn r_str_re_match(
        str_: *const ::std::os::raw::c_char,
        reg: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_str_re_replace(
        str_: *const ::std::os::raw::c_char,
        reg: *const ::std::os::raw::c_char,
        sub: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_str_path_unescape(path: *mut ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_str_path_escape(path: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_unescape(buf: *mut ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_str_sanitize_r2(buf: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_escape_raw(
        buf: *const u8,
        sz: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_escape(buf: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_escape_sh(buf: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_escape_sql(buf: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_escape_dot(buf: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_escape_latin1(
        buf: *const ::std::os::raw::c_char,
        show_asciidot: bool,
        esc_bslash: bool,
        colors: bool,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_escape_utf8(
        buf: *const ::std::os::raw::c_char,
        show_asciidot: bool,
        esc_bslash: bool,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_escape_utf8_keep_printable(
        buf: *const ::std::os::raw::c_char,
        show_asciidot: bool,
        esc_bslash: bool,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_escape_utf16le(
        buf: *const ::std::os::raw::c_char,
        buf_size: ::std::os::raw::c_int,
        show_asciidot: bool,
        esc_bslash: bool,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_escape_utf32le(
        buf: *const ::std::os::raw::c_char,
        buf_size: ::std::os::raw::c_int,
        show_asciidot: bool,
        esc_bslash: bool,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_escape_utf16be(
        buf: *const ::std::os::raw::c_char,
        buf_size: ::std::os::raw::c_int,
        show_asciidot: bool,
        esc_bslash: bool,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_escape_utf32be(
        buf: *const ::std::os::raw::c_char,
        buf_size: ::std::os::raw::c_int,
        show_asciidot: bool,
        esc_bslash: bool,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_byte_escape(
        p: *const ::std::os::raw::c_char,
        dst: *mut *mut ::std::os::raw::c_char,
        dot_nl: ::std::os::raw::c_int,
        default_dot: bool,
        esc_bslash: bool,
    );
}
extern "C" {
    pub fn r_str_format_msvc_argv(
        argc: size_t,
        argv: *mut *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_uri_decode(buf: *mut ::std::os::raw::c_char);
}
extern "C" {
    pub fn r_str_uri_encode(buf: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_utf16_decode(
        s: *const u8,
        len: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_utf16_to_utf8(
        dst: *mut u8,
        len_dst: ::std::os::raw::c_int,
        src: *const u8,
        len_src: ::std::os::raw::c_int,
        little_endian: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_str_utf16_encode(
        s: *const ::std::os::raw::c_char,
        len: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_escape_utf8_for_json(
        s: *const ::std::os::raw::c_char,
        len: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_escape_utf8_for_json_strip(
        buf: *const ::std::os::raw::c_char,
        buf_size: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_encoded_json(
        buf: *const ::std::os::raw::c_char,
        buf_size: ::std::os::raw::c_int,
        encoding: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_home(str_: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_r2_prefix(str_: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_nlen(s: *const ::std::os::raw::c_char, n: ::std::os::raw::c_int) -> size_t;
}
extern "C" {
    pub fn r_str_nlen_w(s: *const ::std::os::raw::c_char, n: ::std::os::raw::c_int) -> size_t;
}
extern "C" {
    pub fn r_wstr_clen(s: *const ::std::os::raw::c_char) -> size_t;
}
extern "C" {
    pub fn r_str_prepend(
        ptr: *mut ::std::os::raw::c_char,
        string: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_prefix_all(
        s: *const ::std::os::raw::c_char,
        pfx: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_append(
        ptr: *mut ::std::os::raw::c_char,
        string: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_append_owned(
        ptr: *mut ::std::os::raw::c_char,
        string: *mut ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_appendf(
        ptr: *mut ::std::os::raw::c_char,
        fmt: *const ::std::os::raw::c_char,
        ...
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_appendch(
        x: *mut ::std::os::raw::c_char,
        y: ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_case(str_: *mut ::std::os::raw::c_char, up: bool);
}
extern "C" {
    pub fn r_str_trim_path(s: *mut ::std::os::raw::c_char);
}
extern "C" {
    pub fn r_str_contains_macro(input_value: *const ::std::os::raw::c_char) -> u8;
}
extern "C" {
    pub fn r_str_truncate_cmd(string: *mut ::std::os::raw::c_char);
}
extern "C" {
    pub fn r_str_replace_thunked(
        str_: *mut ::std::os::raw::c_char,
        clean: *mut ::std::os::raw::c_char,
        thunk: *mut ::std::os::raw::c_int,
        clen: ::std::os::raw::c_int,
        key: *const ::std::os::raw::c_char,
        val: *const ::std::os::raw::c_char,
        g: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_glob(
        str_: *const ::std::os::raw::c_char,
        glob: *const ::std::os::raw::c_char,
    ) -> bool;
}
extern "C" {
    pub fn r_str_binstr2bin(
        str_: *const ::std::os::raw::c_char,
        out: *mut u8,
        outlen: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_str_between(
        str_: *const ::std::os::raw::c_char,
        prefix: *const ::std::os::raw::c_char,
        suffix: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_startswith(
        str_: *const ::std::os::raw::c_char,
        needle: *const ::std::os::raw::c_char,
    ) -> bool;
}
extern "C" {
    pub fn r_str_endswith(
        str_: *const ::std::os::raw::c_char,
        needle: *const ::std::os::raw::c_char,
    ) -> bool;
}
extern "C" {
    pub fn r_str_isnumber(str_: *const ::std::os::raw::c_char) -> bool;
}
extern "C" {
    pub fn r_str_last(
        in_: *const ::std::os::raw::c_char,
        ch: *const ::std::os::raw::c_char,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_highlight(
        str_: *mut ::std::os::raw::c_char,
        word: *const ::std::os::raw::c_char,
        color: *const ::std::os::raw::c_char,
        color_reset: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_qrcode_gen(
        text: *const u8,
        len: ::std::os::raw::c_int,
        utf8: bool,
        inverted: bool,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_from_ut64(val: u64) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_stripLine(str_: *mut ::std::os::raw::c_char, key: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn r_str_list_join(
        str_: *mut RList,
        sep: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_array_join(
        a: *mut *const ::std::os::raw::c_char,
        n: size_t,
        sep: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_sep(
        base: *const ::std::os::raw::c_char,
        sep: *const ::std::os::raw::c_char,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_rsep(
        base: *const ::std::os::raw::c_char,
        p: *const ::std::os::raw::c_char,
        sep: *const ::std::os::raw::c_char,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_donut(size: ::std::os::raw::c_int) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_version(program: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_str_ss(
        msg: *const ::std::os::raw::c_char,
        nl: *const ::std::os::raw::c_char,
        cs: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_str_constpool_t {
    pub ht: *mut HtPP,
}
#[test]
fn bindgen_test_layout_r_str_constpool_t() {
    assert_eq!(
        ::std::mem::size_of::<r_str_constpool_t>(),
        8usize,
        concat!("Size of: ", stringify!(r_str_constpool_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_str_constpool_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_str_constpool_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_str_constpool_t>())).ht as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_str_constpool_t),
            "::",
            stringify!(ht)
        )
    );
}
pub type RStrConstPool = r_str_constpool_t;
extern "C" {
    pub fn r_str_constpool_init(pool: *mut RStrConstPool) -> bool;
}
extern "C" {
    pub fn r_str_constpool_fini(pool: *mut RStrConstPool);
}
extern "C" {
    pub fn r_str_constpool_get(
        pool: *mut RStrConstPool,
        str_: *const ::std::os::raw::c_char,
    ) -> *const ::std::os::raw::c_char;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RSysInfo {
    pub sysname: *mut ::std::os::raw::c_char,
    pub nodename: *mut ::std::os::raw::c_char,
    pub release: *mut ::std::os::raw::c_char,
    pub version: *mut ::std::os::raw::c_char,
    pub machine: *mut ::std::os::raw::c_char,
}
#[test]
fn bindgen_test_layout_RSysInfo() {
    assert_eq!(
        ::std::mem::size_of::<RSysInfo>(),
        40usize,
        concat!("Size of: ", stringify!(RSysInfo))
    );
    assert_eq!(
        ::std::mem::align_of::<RSysInfo>(),
        8usize,
        concat!("Alignment of ", stringify!(RSysInfo))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RSysInfo>())).sysname as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(RSysInfo),
            "::",
            stringify!(sysname)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RSysInfo>())).nodename as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(RSysInfo),
            "::",
            stringify!(nodename)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RSysInfo>())).release as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(RSysInfo),
            "::",
            stringify!(release)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RSysInfo>())).version as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(RSysInfo),
            "::",
            stringify!(version)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RSysInfo>())).machine as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(RSysInfo),
            "::",
            stringify!(machine)
        )
    );
}
extern "C" {
    pub fn r_sys_info() -> *mut RSysInfo;
}
extern "C" {
    pub fn r_sys_info_free(si: *mut RSysInfo);
}
extern "C" {
    pub fn r_sys_sigaction(
        sig: *mut ::std::os::raw::c_int,
        handler: ::std::option::Option<unsafe extern "C" fn(arg1: ::std::os::raw::c_int)>,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_sys_signal(
        sig: ::std::os::raw::c_int,
        handler: ::std::option::Option<unsafe extern "C" fn(arg1: ::std::os::raw::c_int)>,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_sys_env_init();
}
extern "C" {
    pub fn r_sys_get_environ() -> *mut *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_sys_set_environ(e: *mut *mut ::std::os::raw::c_char);
}
extern "C" {
    pub fn r_sys_fork() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_sys_exit(status: ::std::os::raw::c_int, nocleanup: bool);
}
extern "C" {
    pub fn r_sys_stop() -> bool;
}
extern "C" {
    pub fn r_sys_pid_to_path(pid: ::std::os::raw::c_int) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_sys_run(buf: *const u8, len: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_sys_run_rop(buf: *const u8, len: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_sys_getpid() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_sys_crash_handler(cmd: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_sys_arch_str(arch: ::std::os::raw::c_int) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_sys_arch_id(arch: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_sys_arch_match(
        archstr: *const ::std::os::raw::c_char,
        arch: *const ::std::os::raw::c_char,
    ) -> bool;
}
extern "C" {
    pub fn r_sys_dir(path: *const ::std::os::raw::c_char) -> *mut RList;
}
extern "C" {
    pub fn r_sys_perror_str(fun: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn r_sys_prefix(pfx: *const ::std::os::raw::c_char) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_sys_mkdir(dir: *const ::std::os::raw::c_char) -> bool;
}
extern "C" {
    pub fn r_sys_mkdirp(dir: *const ::std::os::raw::c_char) -> bool;
}
extern "C" {
    pub fn r_sys_sleep(secs: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_sys_usleep(usecs: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_sys_getenv(key: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_sys_getenv_asbool(key: *const ::std::os::raw::c_char) -> bool;
}
extern "C" {
    pub fn r_sys_setenv(
        key: *const ::std::os::raw::c_char,
        value: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_sys_clearenv() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_sys_whoami() -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_sys_uid() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_sys_getdir() -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_sys_chdir(s: *const ::std::os::raw::c_char) -> bool;
}
extern "C" {
    pub fn r_sys_aslr(val: ::std::os::raw::c_int) -> bool;
}
extern "C" {
    pub fn r_sys_thp_mode() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_sys_cmd_str_full(
        cmd: *const ::std::os::raw::c_char,
        input: *const ::std::os::raw::c_char,
        ilen: ::std::os::raw::c_int,
        output: *mut *mut ::std::os::raw::c_char,
        len: *mut ::std::os::raw::c_int,
        sterr: *mut *mut ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_sys_truncate(
        file: *const ::std::os::raw::c_char,
        sz: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_sys_cmd(cmd: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_sys_cmdbg(cmd: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_sys_cmdf(fmt: *const ::std::os::raw::c_char, ...) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_sys_cmd_str(
        cmd: *const ::std::os::raw::c_char,
        input: *const ::std::os::raw::c_char,
        len: *mut ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_sys_cmd_strf(cmd: *const ::std::os::raw::c_char, ...) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_sys_backtrace();
}
extern "C" {
    pub fn r_sys_tts(txt: *const ::std::os::raw::c_char, bg: bool) -> bool;
}
extern "C" {
    pub fn r_syscmd_ls(
        input: *const ::std::os::raw::c_char,
        w: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_syscmd_cat(file: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_syscmd_mkdir(dir: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_syscmd_mv(input: *const ::std::os::raw::c_char) -> bool;
}
extern "C" {
    pub fn r_syscmd_uniq(file: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_syscmd_head(
        file: *const ::std::os::raw::c_char,
        count: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_syscmd_tail(
        file: *const ::std::os::raw::c_char,
        count: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_syscmd_join(
        file1: *const ::std::os::raw::c_char,
        file2: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_syscmd_sort(file: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_sys_unxz(data: *const u8, len: size_t, olen: *mut size_t) -> *mut u8;
}
extern "C" {
    pub fn r_w32_init() -> bool;
}
pub type cc_t = ::std::os::raw::c_uchar;
pub type speed_t = ::std::os::raw::c_uint;
pub type tcflag_t = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct termios {
    pub c_iflag: tcflag_t,
    pub c_oflag: tcflag_t,
    pub c_cflag: tcflag_t,
    pub c_lflag: tcflag_t,
    pub c_line: cc_t,
    pub c_cc: [cc_t; 32usize],
    pub c_ispeed: speed_t,
    pub c_ospeed: speed_t,
}
#[test]
fn bindgen_test_layout_termios() {
    assert_eq!(
        ::std::mem::size_of::<termios>(),
        60usize,
        concat!("Size of: ", stringify!(termios))
    );
    assert_eq!(
        ::std::mem::align_of::<termios>(),
        4usize,
        concat!("Alignment of ", stringify!(termios))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<termios>())).c_iflag as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(termios),
            "::",
            stringify!(c_iflag)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<termios>())).c_oflag as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(termios),
            "::",
            stringify!(c_oflag)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<termios>())).c_cflag as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(termios),
            "::",
            stringify!(c_cflag)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<termios>())).c_lflag as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(termios),
            "::",
            stringify!(c_lflag)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<termios>())).c_line as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(termios),
            "::",
            stringify!(c_line)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<termios>())).c_cc as *const _ as usize },
        17usize,
        concat!(
            "Offset of field: ",
            stringify!(termios),
            "::",
            stringify!(c_cc)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<termios>())).c_ispeed as *const _ as usize },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(termios),
            "::",
            stringify!(c_ispeed)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<termios>())).c_ospeed as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(termios),
            "::",
            stringify!(c_ospeed)
        )
    );
}
pub type sa_family_t = ::std::os::raw::c_ushort;
extern "C" {
    pub fn r_cons_version() -> *const ::std::os::raw::c_char;
}
pub type RConsGetSize = ::std::option::Option<
    unsafe extern "C" fn(rows: *mut ::std::os::raw::c_int) -> ::std::os::raw::c_int,
>;
pub type RConsGetCursor = ::std::option::Option<
    unsafe extern "C" fn(rows: *mut ::std::os::raw::c_int) -> ::std::os::raw::c_int,
>;
pub type RConsIsBreaked = ::std::option::Option<unsafe extern "C" fn() -> bool>;
pub type RConsFlush = ::std::option::Option<unsafe extern "C" fn()>;
pub type RConsGrepCallback =
    ::std::option::Option<unsafe extern "C" fn(grep: *const ::std::os::raw::c_char)>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_cons_bind_t {
    pub get_size: RConsGetSize,
    pub get_cursor: RConsGetCursor,
    pub cb_printf: PrintfCallback,
    pub is_breaked: RConsIsBreaked,
    pub cb_flush: RConsFlush,
    pub cb_grep: RConsGrepCallback,
}
#[test]
fn bindgen_test_layout_r_cons_bind_t() {
    assert_eq!(
        ::std::mem::size_of::<r_cons_bind_t>(),
        48usize,
        concat!("Size of: ", stringify!(r_cons_bind_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_cons_bind_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_cons_bind_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_bind_t>())).get_size as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_bind_t),
            "::",
            stringify!(get_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_bind_t>())).get_cursor as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_bind_t),
            "::",
            stringify!(get_cursor)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_bind_t>())).cb_printf as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_bind_t),
            "::",
            stringify!(cb_printf)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_bind_t>())).is_breaked as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_bind_t),
            "::",
            stringify!(is_breaked)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_bind_t>())).cb_flush as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_bind_t),
            "::",
            stringify!(cb_flush)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_bind_t>())).cb_grep as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_bind_t),
            "::",
            stringify!(cb_grep)
        )
    );
}
pub type RConsBind = r_cons_bind_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_cons_grep_t {
    pub strings: [[::std::os::raw::c_char; 64usize]; 10usize],
    pub nstrings: ::std::os::raw::c_int,
    pub str_: *mut ::std::os::raw::c_char,
    pub counter: ::std::os::raw::c_int,
    pub charCounter: bool,
    pub less: ::std::os::raw::c_int,
    pub hud: bool,
    pub human: bool,
    pub json: ::std::os::raw::c_int,
    pub json_path: *mut ::std::os::raw::c_char,
    pub range_line: ::std::os::raw::c_int,
    pub line: ::std::os::raw::c_int,
    pub sort: ::std::os::raw::c_int,
    pub sort_row: ::std::os::raw::c_int,
    pub sort_invert: bool,
    pub f_line: ::std::os::raw::c_int,
    pub l_line: ::std::os::raw::c_int,
    pub tokens: [::std::os::raw::c_int; 64usize],
    pub tokens_used: ::std::os::raw::c_int,
    pub amp: ::std::os::raw::c_int,
    pub zoom: ::std::os::raw::c_int,
    pub zoomy: ::std::os::raw::c_int,
    pub neg: ::std::os::raw::c_int,
    pub begin: ::std::os::raw::c_int,
    pub end: ::std::os::raw::c_int,
    pub icase: bool,
    pub ascart: bool,
}
#[test]
fn bindgen_test_layout_r_cons_grep_t() {
    assert_eq!(
        ::std::mem::size_of::<r_cons_grep_t>(),
        1008usize,
        concat!("Size of: ", stringify!(r_cons_grep_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_cons_grep_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_cons_grep_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_grep_t>())).strings as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_grep_t),
            "::",
            stringify!(strings)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_grep_t>())).nstrings as *const _ as usize },
        640usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_grep_t),
            "::",
            stringify!(nstrings)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_grep_t>())).str_ as *const _ as usize },
        648usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_grep_t),
            "::",
            stringify!(str_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_grep_t>())).counter as *const _ as usize },
        656usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_grep_t),
            "::",
            stringify!(counter)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_grep_t>())).charCounter as *const _ as usize },
        660usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_grep_t),
            "::",
            stringify!(charCounter)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_grep_t>())).less as *const _ as usize },
        664usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_grep_t),
            "::",
            stringify!(less)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_grep_t>())).hud as *const _ as usize },
        668usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_grep_t),
            "::",
            stringify!(hud)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_grep_t>())).human as *const _ as usize },
        669usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_grep_t),
            "::",
            stringify!(human)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_grep_t>())).json as *const _ as usize },
        672usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_grep_t),
            "::",
            stringify!(json)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_grep_t>())).json_path as *const _ as usize },
        680usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_grep_t),
            "::",
            stringify!(json_path)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_grep_t>())).range_line as *const _ as usize },
        688usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_grep_t),
            "::",
            stringify!(range_line)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_grep_t>())).line as *const _ as usize },
        692usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_grep_t),
            "::",
            stringify!(line)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_grep_t>())).sort as *const _ as usize },
        696usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_grep_t),
            "::",
            stringify!(sort)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_grep_t>())).sort_row as *const _ as usize },
        700usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_grep_t),
            "::",
            stringify!(sort_row)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_grep_t>())).sort_invert as *const _ as usize },
        704usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_grep_t),
            "::",
            stringify!(sort_invert)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_grep_t>())).f_line as *const _ as usize },
        708usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_grep_t),
            "::",
            stringify!(f_line)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_grep_t>())).l_line as *const _ as usize },
        712usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_grep_t),
            "::",
            stringify!(l_line)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_grep_t>())).tokens as *const _ as usize },
        716usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_grep_t),
            "::",
            stringify!(tokens)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_grep_t>())).tokens_used as *const _ as usize },
        972usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_grep_t),
            "::",
            stringify!(tokens_used)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_grep_t>())).amp as *const _ as usize },
        976usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_grep_t),
            "::",
            stringify!(amp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_grep_t>())).zoom as *const _ as usize },
        980usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_grep_t),
            "::",
            stringify!(zoom)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_grep_t>())).zoomy as *const _ as usize },
        984usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_grep_t),
            "::",
            stringify!(zoomy)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_grep_t>())).neg as *const _ as usize },
        988usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_grep_t),
            "::",
            stringify!(neg)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_grep_t>())).begin as *const _ as usize },
        992usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_grep_t),
            "::",
            stringify!(begin)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_grep_t>())).end as *const _ as usize },
        996usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_grep_t),
            "::",
            stringify!(end)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_grep_t>())).icase as *const _ as usize },
        1000usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_grep_t),
            "::",
            stringify!(icase)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_grep_t>())).ascart as *const _ as usize },
        1001usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_grep_t),
            "::",
            stringify!(ascart)
        )
    );
}
pub type RConsGrep = r_cons_grep_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rcolor_t {
    pub attr: u8,
    pub a: u8,
    pub r: u8,
    pub g: u8,
    pub b: u8,
    pub r2: u8,
    pub g2: u8,
    pub b2: u8,
    pub id16: i8,
}
#[test]
fn bindgen_test_layout_rcolor_t() {
    assert_eq!(
        ::std::mem::size_of::<rcolor_t>(),
        9usize,
        concat!("Size of: ", stringify!(rcolor_t))
    );
    assert_eq!(
        ::std::mem::align_of::<rcolor_t>(),
        1usize,
        concat!("Alignment of ", stringify!(rcolor_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rcolor_t>())).attr as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(rcolor_t),
            "::",
            stringify!(attr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rcolor_t>())).a as *const _ as usize },
        1usize,
        concat!(
            "Offset of field: ",
            stringify!(rcolor_t),
            "::",
            stringify!(a)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rcolor_t>())).r as *const _ as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(rcolor_t),
            "::",
            stringify!(r)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rcolor_t>())).g as *const _ as usize },
        3usize,
        concat!(
            "Offset of field: ",
            stringify!(rcolor_t),
            "::",
            stringify!(g)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rcolor_t>())).b as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(rcolor_t),
            "::",
            stringify!(b)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rcolor_t>())).r2 as *const _ as usize },
        5usize,
        concat!(
            "Offset of field: ",
            stringify!(rcolor_t),
            "::",
            stringify!(r2)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rcolor_t>())).g2 as *const _ as usize },
        6usize,
        concat!(
            "Offset of field: ",
            stringify!(rcolor_t),
            "::",
            stringify!(g2)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rcolor_t>())).b2 as *const _ as usize },
        7usize,
        concat!(
            "Offset of field: ",
            stringify!(rcolor_t),
            "::",
            stringify!(b2)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rcolor_t>())).id16 as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(rcolor_t),
            "::",
            stringify!(id16)
        )
    );
}
pub type RColor = rcolor_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_cons_palette_t {
    pub b0x00: RColor,
    pub b0x7f: RColor,
    pub b0xff: RColor,
    pub args: RColor,
    pub bin: RColor,
    pub btext: RColor,
    pub call: RColor,
    pub cjmp: RColor,
    pub cmp: RColor,
    pub comment: RColor,
    pub usercomment: RColor,
    pub creg: RColor,
    pub flag: RColor,
    pub fline: RColor,
    pub floc: RColor,
    pub flow: RColor,
    pub flow2: RColor,
    pub fname: RColor,
    pub help: RColor,
    pub input: RColor,
    pub invalid: RColor,
    pub jmp: RColor,
    pub label: RColor,
    pub math: RColor,
    pub mov: RColor,
    pub nop: RColor,
    pub num: RColor,
    pub offset: RColor,
    pub other: RColor,
    pub pop: RColor,
    pub prompt: RColor,
    pub push: RColor,
    pub crypto: RColor,
    pub reg: RColor,
    pub reset: RColor,
    pub ret: RColor,
    pub swi: RColor,
    pub trap: RColor,
    pub ucall: RColor,
    pub ujmp: RColor,
    pub ai_read: RColor,
    pub ai_write: RColor,
    pub ai_exec: RColor,
    pub ai_seq: RColor,
    pub ai_ascii: RColor,
    pub gui_cflow: RColor,
    pub gui_dataoffset: RColor,
    pub gui_background: RColor,
    pub gui_alt_background: RColor,
    pub gui_border: RColor,
    pub wordhl: RColor,
    pub linehl: RColor,
    pub func_var: RColor,
    pub func_var_type: RColor,
    pub func_var_addr: RColor,
    pub widget_bg: RColor,
    pub widget_sel: RColor,
    pub graph_box: RColor,
    pub graph_box2: RColor,
    pub graph_box3: RColor,
    pub graph_box4: RColor,
    pub graph_true: RColor,
    pub graph_false: RColor,
    pub graph_trufae: RColor,
    pub graph_traced: RColor,
    pub graph_current: RColor,
    pub graph_diff_match: RColor,
    pub graph_diff_unmatch: RColor,
    pub graph_diff_unknown: RColor,
    pub graph_diff_new: RColor,
}
#[test]
fn bindgen_test_layout_r_cons_palette_t() {
    assert_eq!(
        ::std::mem::size_of::<r_cons_palette_t>(),
        630usize,
        concat!("Size of: ", stringify!(r_cons_palette_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_cons_palette_t>(),
        1usize,
        concat!("Alignment of ", stringify!(r_cons_palette_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_palette_t>())).b0x00 as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(b0x00)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_palette_t>())).b0x7f as *const _ as usize },
        9usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(b0x7f)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_palette_t>())).b0xff as *const _ as usize },
        18usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(b0xff)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_palette_t>())).args as *const _ as usize },
        27usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(args)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_palette_t>())).bin as *const _ as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(bin)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_palette_t>())).btext as *const _ as usize },
        45usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(btext)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_palette_t>())).call as *const _ as usize },
        54usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(call)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_palette_t>())).cjmp as *const _ as usize },
        63usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(cjmp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_palette_t>())).cmp as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(cmp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_palette_t>())).comment as *const _ as usize },
        81usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(comment)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_palette_t>())).usercomment as *const _ as usize },
        90usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(usercomment)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_palette_t>())).creg as *const _ as usize },
        99usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(creg)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_palette_t>())).flag as *const _ as usize },
        108usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(flag)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_palette_t>())).fline as *const _ as usize },
        117usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(fline)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_palette_t>())).floc as *const _ as usize },
        126usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(floc)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_palette_t>())).flow as *const _ as usize },
        135usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(flow)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_palette_t>())).flow2 as *const _ as usize },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(flow2)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_palette_t>())).fname as *const _ as usize },
        153usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(fname)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_palette_t>())).help as *const _ as usize },
        162usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(help)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_palette_t>())).input as *const _ as usize },
        171usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(input)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_palette_t>())).invalid as *const _ as usize },
        180usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(invalid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_palette_t>())).jmp as *const _ as usize },
        189usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(jmp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_palette_t>())).label as *const _ as usize },
        198usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(label)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_palette_t>())).math as *const _ as usize },
        207usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(math)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_palette_t>())).mov as *const _ as usize },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(mov)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_palette_t>())).nop as *const _ as usize },
        225usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(nop)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_palette_t>())).num as *const _ as usize },
        234usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(num)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_palette_t>())).offset as *const _ as usize },
        243usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(offset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_palette_t>())).other as *const _ as usize },
        252usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(other)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_palette_t>())).pop as *const _ as usize },
        261usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(pop)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_palette_t>())).prompt as *const _ as usize },
        270usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(prompt)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_palette_t>())).push as *const _ as usize },
        279usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(push)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_palette_t>())).crypto as *const _ as usize },
        288usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(crypto)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_palette_t>())).reg as *const _ as usize },
        297usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(reg)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_palette_t>())).reset as *const _ as usize },
        306usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(reset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_palette_t>())).ret as *const _ as usize },
        315usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(ret)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_palette_t>())).swi as *const _ as usize },
        324usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(swi)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_palette_t>())).trap as *const _ as usize },
        333usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(trap)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_palette_t>())).ucall as *const _ as usize },
        342usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(ucall)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_palette_t>())).ujmp as *const _ as usize },
        351usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(ujmp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_palette_t>())).ai_read as *const _ as usize },
        360usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(ai_read)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_palette_t>())).ai_write as *const _ as usize },
        369usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(ai_write)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_palette_t>())).ai_exec as *const _ as usize },
        378usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(ai_exec)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_palette_t>())).ai_seq as *const _ as usize },
        387usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(ai_seq)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_palette_t>())).ai_ascii as *const _ as usize },
        396usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(ai_ascii)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_palette_t>())).gui_cflow as *const _ as usize },
        405usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(gui_cflow)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_palette_t>())).gui_dataoffset as *const _ as usize },
        414usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(gui_dataoffset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_palette_t>())).gui_background as *const _ as usize },
        423usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(gui_background)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_cons_palette_t>())).gui_alt_background as *const _ as usize
        },
        432usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(gui_alt_background)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_palette_t>())).gui_border as *const _ as usize },
        441usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(gui_border)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_palette_t>())).wordhl as *const _ as usize },
        450usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(wordhl)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_palette_t>())).linehl as *const _ as usize },
        459usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(linehl)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_palette_t>())).func_var as *const _ as usize },
        468usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(func_var)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_palette_t>())).func_var_type as *const _ as usize },
        477usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(func_var_type)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_palette_t>())).func_var_addr as *const _ as usize },
        486usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(func_var_addr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_palette_t>())).widget_bg as *const _ as usize },
        495usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(widget_bg)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_palette_t>())).widget_sel as *const _ as usize },
        504usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(widget_sel)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_palette_t>())).graph_box as *const _ as usize },
        513usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(graph_box)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_palette_t>())).graph_box2 as *const _ as usize },
        522usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(graph_box2)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_palette_t>())).graph_box3 as *const _ as usize },
        531usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(graph_box3)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_palette_t>())).graph_box4 as *const _ as usize },
        540usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(graph_box4)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_palette_t>())).graph_true as *const _ as usize },
        549usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(graph_true)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_palette_t>())).graph_false as *const _ as usize },
        558usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(graph_false)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_palette_t>())).graph_trufae as *const _ as usize },
        567usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(graph_trufae)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_palette_t>())).graph_traced as *const _ as usize },
        576usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(graph_traced)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_palette_t>())).graph_current as *const _ as usize },
        585usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(graph_current)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_cons_palette_t>())).graph_diff_match as *const _ as usize
        },
        594usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(graph_diff_match)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_cons_palette_t>())).graph_diff_unmatch as *const _ as usize
        },
        603usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(graph_diff_unmatch)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_cons_palette_t>())).graph_diff_unknown as *const _ as usize
        },
        612usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(graph_diff_unknown)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_palette_t>())).graph_diff_new as *const _ as usize },
        621usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_palette_t),
            "::",
            stringify!(graph_diff_new)
        )
    );
}
pub type RConsPalette = r_cons_palette_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_cons_printable_palette_t {
    pub b0x00: *mut ::std::os::raw::c_char,
    pub b0x7f: *mut ::std::os::raw::c_char,
    pub b0xff: *mut ::std::os::raw::c_char,
    pub args: *mut ::std::os::raw::c_char,
    pub bin: *mut ::std::os::raw::c_char,
    pub btext: *mut ::std::os::raw::c_char,
    pub call: *mut ::std::os::raw::c_char,
    pub cjmp: *mut ::std::os::raw::c_char,
    pub cmp: *mut ::std::os::raw::c_char,
    pub comment: *mut ::std::os::raw::c_char,
    pub usercomment: *mut ::std::os::raw::c_char,
    pub creg: *mut ::std::os::raw::c_char,
    pub flag: *mut ::std::os::raw::c_char,
    pub fline: *mut ::std::os::raw::c_char,
    pub floc: *mut ::std::os::raw::c_char,
    pub flow: *mut ::std::os::raw::c_char,
    pub flow2: *mut ::std::os::raw::c_char,
    pub fname: *mut ::std::os::raw::c_char,
    pub help: *mut ::std::os::raw::c_char,
    pub input: *mut ::std::os::raw::c_char,
    pub invalid: *mut ::std::os::raw::c_char,
    pub jmp: *mut ::std::os::raw::c_char,
    pub label: *mut ::std::os::raw::c_char,
    pub math: *mut ::std::os::raw::c_char,
    pub mov: *mut ::std::os::raw::c_char,
    pub nop: *mut ::std::os::raw::c_char,
    pub num: *mut ::std::os::raw::c_char,
    pub offset: *mut ::std::os::raw::c_char,
    pub other: *mut ::std::os::raw::c_char,
    pub pop: *mut ::std::os::raw::c_char,
    pub prompt: *mut ::std::os::raw::c_char,
    pub push: *mut ::std::os::raw::c_char,
    pub crypto: *mut ::std::os::raw::c_char,
    pub reg: *mut ::std::os::raw::c_char,
    pub reset: *mut ::std::os::raw::c_char,
    pub ret: *mut ::std::os::raw::c_char,
    pub swi: *mut ::std::os::raw::c_char,
    pub trap: *mut ::std::os::raw::c_char,
    pub ucall: *mut ::std::os::raw::c_char,
    pub ujmp: *mut ::std::os::raw::c_char,
    pub ai_read: *mut ::std::os::raw::c_char,
    pub ai_write: *mut ::std::os::raw::c_char,
    pub ai_exec: *mut ::std::os::raw::c_char,
    pub ai_seq: *mut ::std::os::raw::c_char,
    pub ai_ascii: *mut ::std::os::raw::c_char,
    pub ai_unmap: *mut ::std::os::raw::c_char,
    pub gui_cflow: *mut ::std::os::raw::c_char,
    pub gui_dataoffset: *mut ::std::os::raw::c_char,
    pub gui_background: *mut ::std::os::raw::c_char,
    pub gui_alt_background: *mut ::std::os::raw::c_char,
    pub gui_border: *mut ::std::os::raw::c_char,
    pub wordhl: *mut ::std::os::raw::c_char,
    pub linehl: *mut ::std::os::raw::c_char,
    pub func_var: *mut ::std::os::raw::c_char,
    pub func_var_type: *mut ::std::os::raw::c_char,
    pub func_var_addr: *mut ::std::os::raw::c_char,
    pub widget_bg: *mut ::std::os::raw::c_char,
    pub widget_sel: *mut ::std::os::raw::c_char,
    pub graph_box: *mut ::std::os::raw::c_char,
    pub graph_box2: *mut ::std::os::raw::c_char,
    pub graph_box3: *mut ::std::os::raw::c_char,
    pub graph_box4: *mut ::std::os::raw::c_char,
    pub graph_diff_match: *mut ::std::os::raw::c_char,
    pub graph_diff_unmatch: *mut ::std::os::raw::c_char,
    pub graph_diff_unknown: *mut ::std::os::raw::c_char,
    pub graph_diff_new: *mut ::std::os::raw::c_char,
    pub graph_true: *mut ::std::os::raw::c_char,
    pub graph_false: *mut ::std::os::raw::c_char,
    pub graph_trufae: *mut ::std::os::raw::c_char,
    pub graph_traced: *mut ::std::os::raw::c_char,
    pub graph_current: *mut ::std::os::raw::c_char,
    pub rainbow: *mut *mut ::std::os::raw::c_char,
    pub rainbow_sz: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_r_cons_printable_palette_t() {
    assert_eq!(
        ::std::mem::size_of::<r_cons_printable_palette_t>(),
        584usize,
        concat!("Size of: ", stringify!(r_cons_printable_palette_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_cons_printable_palette_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_cons_printable_palette_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_cons_printable_palette_t>())).b0x00 as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(b0x00)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_cons_printable_palette_t>())).b0x7f as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(b0x7f)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_cons_printable_palette_t>())).b0xff as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(b0xff)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_printable_palette_t>())).args as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(args)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_printable_palette_t>())).bin as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(bin)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_cons_printable_palette_t>())).btext as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(btext)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_printable_palette_t>())).call as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(call)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_printable_palette_t>())).cjmp as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(cjmp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_printable_palette_t>())).cmp as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(cmp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_cons_printable_palette_t>())).comment as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(comment)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_cons_printable_palette_t>())).usercomment as *const _ as usize
        },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(usercomment)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_printable_palette_t>())).creg as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(creg)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_printable_palette_t>())).flag as *const _ as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(flag)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_cons_printable_palette_t>())).fline as *const _ as usize
        },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(fline)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_printable_palette_t>())).floc as *const _ as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(floc)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_printable_palette_t>())).flow as *const _ as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(flow)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_cons_printable_palette_t>())).flow2 as *const _ as usize
        },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(flow2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_cons_printable_palette_t>())).fname as *const _ as usize
        },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(fname)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_printable_palette_t>())).help as *const _ as usize },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(help)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_cons_printable_palette_t>())).input as *const _ as usize
        },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(input)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_cons_printable_palette_t>())).invalid as *const _ as usize
        },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(invalid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_printable_palette_t>())).jmp as *const _ as usize },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(jmp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_cons_printable_palette_t>())).label as *const _ as usize
        },
        176usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(label)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_printable_palette_t>())).math as *const _ as usize },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(math)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_printable_palette_t>())).mov as *const _ as usize },
        192usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(mov)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_printable_palette_t>())).nop as *const _ as usize },
        200usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(nop)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_printable_palette_t>())).num as *const _ as usize },
        208usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(num)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_cons_printable_palette_t>())).offset as *const _ as usize
        },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(offset)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_cons_printable_palette_t>())).other as *const _ as usize
        },
        224usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(other)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_printable_palette_t>())).pop as *const _ as usize },
        232usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(pop)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_cons_printable_palette_t>())).prompt as *const _ as usize
        },
        240usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(prompt)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_printable_palette_t>())).push as *const _ as usize },
        248usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(push)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_cons_printable_palette_t>())).crypto as *const _ as usize
        },
        256usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(crypto)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_printable_palette_t>())).reg as *const _ as usize },
        264usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(reg)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_cons_printable_palette_t>())).reset as *const _ as usize
        },
        272usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(reset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_printable_palette_t>())).ret as *const _ as usize },
        280usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(ret)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_printable_palette_t>())).swi as *const _ as usize },
        288usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(swi)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_printable_palette_t>())).trap as *const _ as usize },
        296usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(trap)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_cons_printable_palette_t>())).ucall as *const _ as usize
        },
        304usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(ucall)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_printable_palette_t>())).ujmp as *const _ as usize },
        312usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(ujmp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_cons_printable_palette_t>())).ai_read as *const _ as usize
        },
        320usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(ai_read)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_cons_printable_palette_t>())).ai_write as *const _ as usize
        },
        328usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(ai_write)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_cons_printable_palette_t>())).ai_exec as *const _ as usize
        },
        336usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(ai_exec)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_cons_printable_palette_t>())).ai_seq as *const _ as usize
        },
        344usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(ai_seq)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_cons_printable_palette_t>())).ai_ascii as *const _ as usize
        },
        352usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(ai_ascii)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_cons_printable_palette_t>())).ai_unmap as *const _ as usize
        },
        360usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(ai_unmap)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_cons_printable_palette_t>())).gui_cflow as *const _ as usize
        },
        368usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(gui_cflow)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_cons_printable_palette_t>())).gui_dataoffset as *const _
                as usize
        },
        376usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(gui_dataoffset)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_cons_printable_palette_t>())).gui_background as *const _
                as usize
        },
        384usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(gui_background)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_cons_printable_palette_t>())).gui_alt_background as *const _
                as usize
        },
        392usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(gui_alt_background)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_cons_printable_palette_t>())).gui_border as *const _ as usize
        },
        400usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(gui_border)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_cons_printable_palette_t>())).wordhl as *const _ as usize
        },
        408usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(wordhl)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_cons_printable_palette_t>())).linehl as *const _ as usize
        },
        416usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(linehl)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_cons_printable_palette_t>())).func_var as *const _ as usize
        },
        424usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(func_var)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_cons_printable_palette_t>())).func_var_type as *const _
                as usize
        },
        432usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(func_var_type)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_cons_printable_palette_t>())).func_var_addr as *const _
                as usize
        },
        440usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(func_var_addr)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_cons_printable_palette_t>())).widget_bg as *const _ as usize
        },
        448usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(widget_bg)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_cons_printable_palette_t>())).widget_sel as *const _ as usize
        },
        456usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(widget_sel)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_cons_printable_palette_t>())).graph_box as *const _ as usize
        },
        464usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(graph_box)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_cons_printable_palette_t>())).graph_box2 as *const _ as usize
        },
        472usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(graph_box2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_cons_printable_palette_t>())).graph_box3 as *const _ as usize
        },
        480usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(graph_box3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_cons_printable_palette_t>())).graph_box4 as *const _ as usize
        },
        488usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(graph_box4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_cons_printable_palette_t>())).graph_diff_match as *const _
                as usize
        },
        496usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(graph_diff_match)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_cons_printable_palette_t>())).graph_diff_unmatch as *const _
                as usize
        },
        504usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(graph_diff_unmatch)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_cons_printable_palette_t>())).graph_diff_unknown as *const _
                as usize
        },
        512usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(graph_diff_unknown)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_cons_printable_palette_t>())).graph_diff_new as *const _
                as usize
        },
        520usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(graph_diff_new)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_cons_printable_palette_t>())).graph_true as *const _ as usize
        },
        528usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(graph_true)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_cons_printable_palette_t>())).graph_false as *const _ as usize
        },
        536usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(graph_false)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_cons_printable_palette_t>())).graph_trufae as *const _ as usize
        },
        544usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(graph_trufae)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_cons_printable_palette_t>())).graph_traced as *const _ as usize
        },
        552usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(graph_traced)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_cons_printable_palette_t>())).graph_current as *const _
                as usize
        },
        560usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(graph_current)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_cons_printable_palette_t>())).rainbow as *const _ as usize
        },
        568usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(rainbow)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_cons_printable_palette_t>())).rainbow_sz as *const _ as usize
        },
        576usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_printable_palette_t),
            "::",
            stringify!(rainbow_sz)
        )
    );
}
pub type RConsPrintablePalette = r_cons_printable_palette_t;
pub type RConsEvent =
    ::std::option::Option<unsafe extern "C" fn(arg1: *mut ::std::os::raw::c_void)>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_cons_canvas_t {
    pub w: ::std::os::raw::c_int,
    pub h: ::std::os::raw::c_int,
    pub x: ::std::os::raw::c_int,
    pub y: ::std::os::raw::c_int,
    pub b: *mut *mut ::std::os::raw::c_char,
    pub blen: *mut ::std::os::raw::c_int,
    pub bsize: *mut ::std::os::raw::c_int,
    pub attr: *const ::std::os::raw::c_char,
    pub attrs: *mut HtUP,
    pub constpool: RStrConstPool,
    pub sx: ::std::os::raw::c_int,
    pub sy: ::std::os::raw::c_int,
    pub color: ::std::os::raw::c_int,
    pub linemode: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_r_cons_canvas_t() {
    assert_eq!(
        ::std::mem::size_of::<r_cons_canvas_t>(),
        80usize,
        concat!("Size of: ", stringify!(r_cons_canvas_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_cons_canvas_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_cons_canvas_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_canvas_t>())).w as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_canvas_t),
            "::",
            stringify!(w)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_canvas_t>())).h as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_canvas_t),
            "::",
            stringify!(h)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_canvas_t>())).x as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_canvas_t),
            "::",
            stringify!(x)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_canvas_t>())).y as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_canvas_t),
            "::",
            stringify!(y)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_canvas_t>())).b as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_canvas_t),
            "::",
            stringify!(b)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_canvas_t>())).blen as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_canvas_t),
            "::",
            stringify!(blen)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_canvas_t>())).bsize as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_canvas_t),
            "::",
            stringify!(bsize)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_canvas_t>())).attr as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_canvas_t),
            "::",
            stringify!(attr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_canvas_t>())).attrs as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_canvas_t),
            "::",
            stringify!(attrs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_canvas_t>())).constpool as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_canvas_t),
            "::",
            stringify!(constpool)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_canvas_t>())).sx as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_canvas_t),
            "::",
            stringify!(sx)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_canvas_t>())).sy as *const _ as usize },
        68usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_canvas_t),
            "::",
            stringify!(sy)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_canvas_t>())).color as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_canvas_t),
            "::",
            stringify!(color)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_canvas_t>())).linemode as *const _ as usize },
        76usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_canvas_t),
            "::",
            stringify!(linemode)
        )
    );
}
pub type RConsCanvas = r_cons_canvas_t;
pub type RConsEditorCallback = ::std::option::Option<
    unsafe extern "C" fn(
        core: *mut ::std::os::raw::c_void,
        file: *const ::std::os::raw::c_char,
        str_: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char,
>;
pub type RConsClickCallback = ::std::option::Option<
    unsafe extern "C" fn(
        core: *mut ::std::os::raw::c_void,
        x: ::std::os::raw::c_int,
        y: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int,
>;
pub type RConsBreakCallback =
    ::std::option::Option<unsafe extern "C" fn(core: *mut ::std::os::raw::c_void)>;
pub type RConsSleepBeginCallback = ::std::option::Option<
    unsafe extern "C" fn(core: *mut ::std::os::raw::c_void) -> *mut ::std::os::raw::c_void,
>;
pub type RConsSleepEndCallback = ::std::option::Option<
    unsafe extern "C" fn(core: *mut ::std::os::raw::c_void, user: *mut ::std::os::raw::c_void),
>;
pub type RConsQueueTaskOneshot = ::std::option::Option<
    unsafe extern "C" fn(
        core: *mut ::std::os::raw::c_void,
        task: *mut ::std::os::raw::c_void,
        user: *mut ::std::os::raw::c_void,
    ),
>;
pub type RConsFunctionKey = ::std::option::Option<
    unsafe extern "C" fn(core: *mut ::std::os::raw::c_void, fkey: ::std::os::raw::c_int),
>;
pub const RConsColorMode_COLOR_MODE_DISABLED: RConsColorMode = 0;
pub const RConsColorMode_COLOR_MODE_16: RConsColorMode = 1;
pub const RConsColorMode_COLOR_MODE_256: RConsColorMode = 2;
pub const RConsColorMode_COLOR_MODE_16M: RConsColorMode = 3;
pub type RConsColorMode = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_cons_context_t {
    pub grep: RConsGrep,
    pub cons_stack: *mut RStack,
    pub buffer: *mut ::std::os::raw::c_char,
    pub buffer_len: size_t,
    pub buffer_sz: size_t,
    pub error: *mut RStrBuf,
    pub errmode: ::std::os::raw::c_int,
    pub breaked: bool,
    pub was_breaked: bool,
    pub unbreakable: bool,
    pub break_stack: *mut RStack,
    pub event_interrupt: RConsEvent,
    pub event_interrupt_data: *mut ::std::os::raw::c_void,
    pub cmd_depth: ::std::os::raw::c_int,
    pub cmd_str_depth: ::std::os::raw::c_int,
    pub noflush: bool,
    pub log_callback: RLogCallback,
    pub lastOutput: *mut ::std::os::raw::c_char,
    pub lastLength: ::std::os::raw::c_int,
    pub lastMode: bool,
    pub lastEnabled: bool,
    pub is_interactive: bool,
    pub pageable: bool,
    pub color_mode: ::std::os::raw::c_int,
    pub cpal: RConsPalette,
    pub pal: RConsPrintablePalette,
    pub sorted_lines: *mut RList,
    pub unsorted_lines: *mut RList,
    pub sorted_column: ::std::os::raw::c_int,
    pub demo: bool,
    pub is_html: bool,
    pub was_html: bool,
    pub grep_color: bool,
    pub grep_highlight: bool,
    pub filter: bool,
    pub use_tts: bool,
    pub flush: bool,
}
#[test]
fn bindgen_test_layout_r_cons_context_t() {
    assert_eq!(
        ::std::mem::size_of::<r_cons_context_t>(),
        2376usize,
        concat!("Size of: ", stringify!(r_cons_context_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_cons_context_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_cons_context_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_context_t>())).grep as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_context_t),
            "::",
            stringify!(grep)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_context_t>())).cons_stack as *const _ as usize },
        1008usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_context_t),
            "::",
            stringify!(cons_stack)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_context_t>())).buffer as *const _ as usize },
        1016usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_context_t),
            "::",
            stringify!(buffer)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_context_t>())).buffer_len as *const _ as usize },
        1024usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_context_t),
            "::",
            stringify!(buffer_len)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_context_t>())).buffer_sz as *const _ as usize },
        1032usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_context_t),
            "::",
            stringify!(buffer_sz)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_context_t>())).error as *const _ as usize },
        1040usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_context_t),
            "::",
            stringify!(error)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_context_t>())).errmode as *const _ as usize },
        1048usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_context_t),
            "::",
            stringify!(errmode)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_context_t>())).breaked as *const _ as usize },
        1052usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_context_t),
            "::",
            stringify!(breaked)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_context_t>())).was_breaked as *const _ as usize },
        1053usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_context_t),
            "::",
            stringify!(was_breaked)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_context_t>())).unbreakable as *const _ as usize },
        1054usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_context_t),
            "::",
            stringify!(unbreakable)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_context_t>())).break_stack as *const _ as usize },
        1056usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_context_t),
            "::",
            stringify!(break_stack)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_cons_context_t>())).event_interrupt as *const _ as usize
        },
        1064usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_context_t),
            "::",
            stringify!(event_interrupt)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_cons_context_t>())).event_interrupt_data as *const _ as usize
        },
        1072usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_context_t),
            "::",
            stringify!(event_interrupt_data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_context_t>())).cmd_depth as *const _ as usize },
        1080usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_context_t),
            "::",
            stringify!(cmd_depth)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_context_t>())).cmd_str_depth as *const _ as usize },
        1084usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_context_t),
            "::",
            stringify!(cmd_str_depth)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_context_t>())).noflush as *const _ as usize },
        1088usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_context_t),
            "::",
            stringify!(noflush)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_context_t>())).log_callback as *const _ as usize },
        1096usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_context_t),
            "::",
            stringify!(log_callback)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_context_t>())).lastOutput as *const _ as usize },
        1104usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_context_t),
            "::",
            stringify!(lastOutput)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_context_t>())).lastLength as *const _ as usize },
        1112usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_context_t),
            "::",
            stringify!(lastLength)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_context_t>())).lastMode as *const _ as usize },
        1116usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_context_t),
            "::",
            stringify!(lastMode)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_context_t>())).lastEnabled as *const _ as usize },
        1117usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_context_t),
            "::",
            stringify!(lastEnabled)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_context_t>())).is_interactive as *const _ as usize },
        1118usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_context_t),
            "::",
            stringify!(is_interactive)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_context_t>())).pageable as *const _ as usize },
        1119usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_context_t),
            "::",
            stringify!(pageable)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_context_t>())).color_mode as *const _ as usize },
        1120usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_context_t),
            "::",
            stringify!(color_mode)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_context_t>())).cpal as *const _ as usize },
        1124usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_context_t),
            "::",
            stringify!(cpal)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_context_t>())).pal as *const _ as usize },
        1760usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_context_t),
            "::",
            stringify!(pal)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_context_t>())).sorted_lines as *const _ as usize },
        2344usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_context_t),
            "::",
            stringify!(sorted_lines)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_context_t>())).unsorted_lines as *const _ as usize },
        2352usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_context_t),
            "::",
            stringify!(unsorted_lines)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_context_t>())).sorted_column as *const _ as usize },
        2360usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_context_t),
            "::",
            stringify!(sorted_column)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_context_t>())).demo as *const _ as usize },
        2364usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_context_t),
            "::",
            stringify!(demo)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_context_t>())).is_html as *const _ as usize },
        2365usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_context_t),
            "::",
            stringify!(is_html)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_context_t>())).was_html as *const _ as usize },
        2366usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_context_t),
            "::",
            stringify!(was_html)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_context_t>())).grep_color as *const _ as usize },
        2367usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_context_t),
            "::",
            stringify!(grep_color)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_context_t>())).grep_highlight as *const _ as usize },
        2368usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_context_t),
            "::",
            stringify!(grep_highlight)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_context_t>())).filter as *const _ as usize },
        2369usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_context_t),
            "::",
            stringify!(filter)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_context_t>())).use_tts as *const _ as usize },
        2370usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_context_t),
            "::",
            stringify!(use_tts)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_context_t>())).flush as *const _ as usize },
        2371usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_context_t),
            "::",
            stringify!(flush)
        )
    );
}
pub type RConsContext = r_cons_context_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RConsCursorPos {
    pub x: ::std::os::raw::c_int,
    pub y: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_RConsCursorPos() {
    assert_eq!(
        ::std::mem::size_of::<RConsCursorPos>(),
        8usize,
        concat!("Size of: ", stringify!(RConsCursorPos))
    );
    assert_eq!(
        ::std::mem::align_of::<RConsCursorPos>(),
        4usize,
        concat!("Alignment of ", stringify!(RConsCursorPos))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RConsCursorPos>())).x as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(RConsCursorPos),
            "::",
            stringify!(x)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RConsCursorPos>())).y as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(RConsCursorPos),
            "::",
            stringify!(y)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_cons_t {
    pub context: *mut RConsContext,
    pub lastline: *mut ::std::os::raw::c_char,
    pub lines: ::std::os::raw::c_int,
    pub rows: ::std::os::raw::c_int,
    pub echo: ::std::os::raw::c_int,
    pub fps: ::std::os::raw::c_int,
    pub columns: ::std::os::raw::c_int,
    pub force_rows: ::std::os::raw::c_int,
    pub force_columns: ::std::os::raw::c_int,
    pub fix_rows: ::std::os::raw::c_int,
    pub fix_columns: ::std::os::raw::c_int,
    pub break_lines: bool,
    pub optimize: ::std::os::raw::c_int,
    pub show_autocomplete_widget: bool,
    pub fdin: *mut FILE,
    pub fdout: ::std::os::raw::c_int,
    pub teefile: *const ::std::os::raw::c_char,
    pub user_fgets: ::std::option::Option<
        unsafe extern "C" fn(
            buf: *mut ::std::os::raw::c_char,
            len: ::std::os::raw::c_int,
        ) -> ::std::os::raw::c_int,
    >,
    pub event_resize: RConsEvent,
    pub event_data: *mut ::std::os::raw::c_void,
    pub mouse_event: ::std::os::raw::c_int,
    pub cb_editor: RConsEditorCallback,
    pub cb_break: RConsBreakCallback,
    pub cb_sleep_begin: RConsSleepBeginCallback,
    pub cb_sleep_end: RConsSleepEndCallback,
    pub cb_click: RConsClickCallback,
    pub cb_task_oneshot: RConsQueueTaskOneshot,
    pub cb_fkey: RConsFunctionKey,
    pub user: *mut ::std::os::raw::c_void,
    pub term_raw: termios,
    pub term_buf: termios,
    pub num: *mut RNum,
    pub pager: *mut ::std::os::raw::c_char,
    pub blankline: ::std::os::raw::c_int,
    pub highlight: *mut ::std::os::raw::c_char,
    pub enable_highlight: bool,
    pub null: ::std::os::raw::c_int,
    pub mouse: ::std::os::raw::c_int,
    pub is_wine: ::std::os::raw::c_int,
    pub line: *mut r_line_t,
    pub vline: *mut *const ::std::os::raw::c_char,
    pub refcnt: ::std::os::raw::c_int,
    pub newline: bool,
    pub vtmode: ::std::os::raw::c_int,
    pub use_utf8: bool,
    pub use_utf8_curvy: bool,
    pub dotted_lines: bool,
    pub linesleep: ::std::os::raw::c_int,
    pub pagesize: ::std::os::raw::c_int,
    pub break_word: *mut ::std::os::raw::c_char,
    pub break_word_len: ::std::os::raw::c_int,
    pub timeout: u64,
    pub rgbstr: ::std::option::Option<
        unsafe extern "C" fn(
            str_: *mut ::std::os::raw::c_char,
            sz: size_t,
            addr: u64,
        ) -> *mut ::std::os::raw::c_char,
    >,
    pub click_set: bool,
    pub click_x: ::std::os::raw::c_int,
    pub click_y: ::std::os::raw::c_int,
    pub show_vals: bool,
    pub cpos: RConsCursorPos,
}
#[test]
fn bindgen_test_layout_r_cons_t() {
    assert_eq!(
        ::std::mem::size_of::<r_cons_t>(),
        448usize,
        concat!("Size of: ", stringify!(r_cons_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_cons_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_cons_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_t>())).context as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_t),
            "::",
            stringify!(context)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_t>())).lastline as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_t),
            "::",
            stringify!(lastline)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_t>())).lines as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_t),
            "::",
            stringify!(lines)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_t>())).rows as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_t),
            "::",
            stringify!(rows)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_t>())).echo as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_t),
            "::",
            stringify!(echo)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_t>())).fps as *const _ as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_t),
            "::",
            stringify!(fps)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_t>())).columns as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_t),
            "::",
            stringify!(columns)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_t>())).force_rows as *const _ as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_t),
            "::",
            stringify!(force_rows)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_t>())).force_columns as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_t),
            "::",
            stringify!(force_columns)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_t>())).fix_rows as *const _ as usize },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_t),
            "::",
            stringify!(fix_rows)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_t>())).fix_columns as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_t),
            "::",
            stringify!(fix_columns)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_t>())).break_lines as *const _ as usize },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_t),
            "::",
            stringify!(break_lines)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_t>())).optimize as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_t),
            "::",
            stringify!(optimize)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_cons_t>())).show_autocomplete_widget as *const _ as usize
        },
        60usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_t),
            "::",
            stringify!(show_autocomplete_widget)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_t>())).fdin as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_t),
            "::",
            stringify!(fdin)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_t>())).fdout as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_t),
            "::",
            stringify!(fdout)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_t>())).teefile as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_t),
            "::",
            stringify!(teefile)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_t>())).user_fgets as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_t),
            "::",
            stringify!(user_fgets)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_t>())).event_resize as *const _ as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_t),
            "::",
            stringify!(event_resize)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_t>())).event_data as *const _ as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_t),
            "::",
            stringify!(event_data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_t>())).mouse_event as *const _ as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_t),
            "::",
            stringify!(mouse_event)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_t>())).cb_editor as *const _ as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_t),
            "::",
            stringify!(cb_editor)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_t>())).cb_break as *const _ as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_t),
            "::",
            stringify!(cb_break)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_t>())).cb_sleep_begin as *const _ as usize },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_t),
            "::",
            stringify!(cb_sleep_begin)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_t>())).cb_sleep_end as *const _ as usize },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_t),
            "::",
            stringify!(cb_sleep_end)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_t>())).cb_click as *const _ as usize },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_t),
            "::",
            stringify!(cb_click)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_t>())).cb_task_oneshot as *const _ as usize },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_t),
            "::",
            stringify!(cb_task_oneshot)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_t>())).cb_fkey as *const _ as usize },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_t),
            "::",
            stringify!(cb_fkey)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_t>())).user as *const _ as usize },
        176usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_t),
            "::",
            stringify!(user)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_t>())).term_raw as *const _ as usize },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_t),
            "::",
            stringify!(term_raw)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_t>())).term_buf as *const _ as usize },
        244usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_t),
            "::",
            stringify!(term_buf)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_t>())).num as *const _ as usize },
        304usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_t),
            "::",
            stringify!(num)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_t>())).pager as *const _ as usize },
        312usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_t),
            "::",
            stringify!(pager)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_t>())).blankline as *const _ as usize },
        320usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_t),
            "::",
            stringify!(blankline)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_t>())).highlight as *const _ as usize },
        328usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_t),
            "::",
            stringify!(highlight)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_t>())).enable_highlight as *const _ as usize },
        336usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_t),
            "::",
            stringify!(enable_highlight)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_t>())).null as *const _ as usize },
        340usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_t),
            "::",
            stringify!(null)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_t>())).mouse as *const _ as usize },
        344usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_t),
            "::",
            stringify!(mouse)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_t>())).is_wine as *const _ as usize },
        348usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_t),
            "::",
            stringify!(is_wine)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_t>())).line as *const _ as usize },
        352usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_t),
            "::",
            stringify!(line)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_t>())).vline as *const _ as usize },
        360usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_t),
            "::",
            stringify!(vline)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_t>())).refcnt as *const _ as usize },
        368usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_t),
            "::",
            stringify!(refcnt)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_t>())).newline as *const _ as usize },
        372usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_t),
            "::",
            stringify!(newline)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_t>())).vtmode as *const _ as usize },
        376usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_t),
            "::",
            stringify!(vtmode)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_t>())).use_utf8 as *const _ as usize },
        380usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_t),
            "::",
            stringify!(use_utf8)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_t>())).use_utf8_curvy as *const _ as usize },
        381usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_t),
            "::",
            stringify!(use_utf8_curvy)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_t>())).dotted_lines as *const _ as usize },
        382usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_t),
            "::",
            stringify!(dotted_lines)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_t>())).linesleep as *const _ as usize },
        384usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_t),
            "::",
            stringify!(linesleep)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_t>())).pagesize as *const _ as usize },
        388usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_t),
            "::",
            stringify!(pagesize)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_t>())).break_word as *const _ as usize },
        392usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_t),
            "::",
            stringify!(break_word)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_t>())).break_word_len as *const _ as usize },
        400usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_t),
            "::",
            stringify!(break_word_len)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_t>())).timeout as *const _ as usize },
        408usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_t),
            "::",
            stringify!(timeout)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_t>())).rgbstr as *const _ as usize },
        416usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_t),
            "::",
            stringify!(rgbstr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_t>())).click_set as *const _ as usize },
        424usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_t),
            "::",
            stringify!(click_set)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_t>())).click_x as *const _ as usize },
        428usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_t),
            "::",
            stringify!(click_x)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_t>())).click_y as *const _ as usize },
        432usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_t),
            "::",
            stringify!(click_y)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_t>())).show_vals as *const _ as usize },
        436usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_t),
            "::",
            stringify!(show_vals)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_cons_t>())).cpos as *const _ as usize },
        440usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_t),
            "::",
            stringify!(cpos)
        )
    );
}
pub type RCons = r_cons_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_cons_canvas_line_style_t {
    pub color: ::std::os::raw::c_int,
    pub symbol: ::std::os::raw::c_int,
    pub dot_style: ::std::os::raw::c_int,
    pub ansicolor: *const ::std::os::raw::c_char,
}
#[test]
fn bindgen_test_layout_r_cons_canvas_line_style_t() {
    assert_eq!(
        ::std::mem::size_of::<r_cons_canvas_line_style_t>(),
        24usize,
        concat!("Size of: ", stringify!(r_cons_canvas_line_style_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_cons_canvas_line_style_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_cons_canvas_line_style_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_cons_canvas_line_style_t>())).color as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_canvas_line_style_t),
            "::",
            stringify!(color)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_cons_canvas_line_style_t>())).symbol as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_canvas_line_style_t),
            "::",
            stringify!(symbol)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_cons_canvas_line_style_t>())).dot_style as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_canvas_line_style_t),
            "::",
            stringify!(dot_style)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_cons_canvas_line_style_t>())).ansicolor as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(r_cons_canvas_line_style_t),
            "::",
            stringify!(ansicolor)
        )
    );
}
pub type RCanvasLineStyle = r_cons_canvas_line_style_t;
extern "C" {
    pub fn r_cons_image(
        buf: *const u8,
        bufsz: ::std::os::raw::c_int,
        width: ::std::os::raw::c_int,
        mode: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn r_cons_canvas_new(
        w: ::std::os::raw::c_int,
        h: ::std::os::raw::c_int,
    ) -> *mut RConsCanvas;
}
extern "C" {
    pub fn r_cons_canvas_free(c: *mut RConsCanvas);
}
extern "C" {
    pub fn r_cons_canvas_clear(c: *mut RConsCanvas);
}
extern "C" {
    pub fn r_cons_canvas_print(c: *mut RConsCanvas);
}
extern "C" {
    pub fn r_cons_canvas_print_region(c: *mut RConsCanvas);
}
extern "C" {
    pub fn r_cons_canvas_to_string(c: *mut RConsCanvas) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_cons_canvas_attr(c: *mut RConsCanvas, attr: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn r_cons_canvas_write(c: *mut RConsCanvas, _s: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn r_cons_canvas_gotoxy(
        c: *mut RConsCanvas,
        x: ::std::os::raw::c_int,
        y: ::std::os::raw::c_int,
    ) -> bool;
}
extern "C" {
    pub fn r_cons_canvas_goto_write(
        c: *mut RConsCanvas,
        x: ::std::os::raw::c_int,
        y: ::std::os::raw::c_int,
        s: *const ::std::os::raw::c_char,
    );
}
extern "C" {
    pub fn r_cons_canvas_box(
        c: *mut RConsCanvas,
        x: ::std::os::raw::c_int,
        y: ::std::os::raw::c_int,
        w: ::std::os::raw::c_int,
        h: ::std::os::raw::c_int,
        color: *const ::std::os::raw::c_char,
    );
}
extern "C" {
    pub fn r_cons_canvas_circle(
        c: *mut RConsCanvas,
        x: ::std::os::raw::c_int,
        y: ::std::os::raw::c_int,
        w: ::std::os::raw::c_int,
        h: ::std::os::raw::c_int,
        color: *const ::std::os::raw::c_char,
    );
}
extern "C" {
    pub fn r_cons_canvas_line(
        c: *mut RConsCanvas,
        x: ::std::os::raw::c_int,
        y: ::std::os::raw::c_int,
        x2: ::std::os::raw::c_int,
        y2: ::std::os::raw::c_int,
        style: *mut RCanvasLineStyle,
    );
}
extern "C" {
    pub fn r_cons_canvas_line_diagonal(
        c: *mut RConsCanvas,
        x: ::std::os::raw::c_int,
        y: ::std::os::raw::c_int,
        x2: ::std::os::raw::c_int,
        y2: ::std::os::raw::c_int,
        style: *mut RCanvasLineStyle,
    );
}
extern "C" {
    pub fn r_cons_canvas_line_square(
        c: *mut RConsCanvas,
        x: ::std::os::raw::c_int,
        y: ::std::os::raw::c_int,
        x2: ::std::os::raw::c_int,
        y2: ::std::os::raw::c_int,
        style: *mut RCanvasLineStyle,
    );
}
extern "C" {
    pub fn r_cons_canvas_resize(
        c: *mut RConsCanvas,
        w: ::std::os::raw::c_int,
        h: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_cons_canvas_fill(
        c: *mut RConsCanvas,
        x: ::std::os::raw::c_int,
        y: ::std::os::raw::c_int,
        w: ::std::os::raw::c_int,
        h: ::std::os::raw::c_int,
        ch: ::std::os::raw::c_char,
    );
}
extern "C" {
    pub fn r_cons_canvas_line_square_defined(
        c: *mut RConsCanvas,
        x: ::std::os::raw::c_int,
        y: ::std::os::raw::c_int,
        x2: ::std::os::raw::c_int,
        y2: ::std::os::raw::c_int,
        style: *mut RCanvasLineStyle,
        bendpoint: ::std::os::raw::c_int,
        isvert: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn r_cons_canvas_line_back_edge(
        c: *mut RConsCanvas,
        x: ::std::os::raw::c_int,
        y: ::std::os::raw::c_int,
        x2: ::std::os::raw::c_int,
        y2: ::std::os::raw::c_int,
        style: *mut RCanvasLineStyle,
        ybendpoint1: ::std::os::raw::c_int,
        xbendpoint: ::std::os::raw::c_int,
        ybendpoint2: ::std::os::raw::c_int,
        isvert: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn r_cons_new() -> *mut RCons;
}
extern "C" {
    pub fn r_cons_singleton() -> *mut RCons;
}
extern "C" {
    pub fn r_cons_context() -> *mut RConsContext;
}
extern "C" {
    pub fn r_cons_free() -> *mut RCons;
}
extern "C" {
    pub fn r_cons_lastline(size: *mut ::std::os::raw::c_int) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_cons_lastline_utf8_ansi_len(
        len: *mut ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_cons_set_click(x: ::std::os::raw::c_int, y: ::std::os::raw::c_int);
}
extern "C" {
    pub fn r_cons_get_click(x: *mut ::std::os::raw::c_int, y: *mut ::std::os::raw::c_int) -> bool;
}
pub type RConsBreak =
    ::std::option::Option<unsafe extern "C" fn(arg1: *mut ::std::os::raw::c_void)>;
extern "C" {
    pub fn r_cons_is_breaked() -> bool;
}
extern "C" {
    pub fn r_cons_was_breaked() -> bool;
}
extern "C" {
    pub fn r_cons_is_interactive() -> bool;
}
extern "C" {
    pub fn r_cons_default_context_is_interactive() -> bool;
}
extern "C" {
    pub fn r_cons_sleep_begin() -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn r_cons_sleep_end(user: *mut ::std::os::raw::c_void);
}
extern "C" {
    pub fn r_cons_break_push(cb: RConsBreak, user: *mut ::std::os::raw::c_void);
}
extern "C" {
    pub fn r_cons_break_pop();
}
extern "C" {
    pub fn r_cons_break_clear();
}
extern "C" {
    pub fn r_cons_breakword(s: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn r_cons_break_end();
}
extern "C" {
    pub fn r_cons_break_timeout(timeout: ::std::os::raw::c_int);
}
extern "C" {
    pub fn r_cons_pipe_open(
        file: *const ::std::os::raw::c_char,
        fdn: ::std::os::raw::c_int,
        append: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_cons_pipe_close(fd: ::std::os::raw::c_int);
}
extern "C" {
    pub fn r_cons_push();
}
extern "C" {
    pub fn r_cons_pop();
}
extern "C" {
    pub fn r_cons_context_new(parent: *mut RConsContext) -> *mut RConsContext;
}
extern "C" {
    pub fn r_cons_context_free(context: *mut RConsContext);
}
extern "C" {
    pub fn r_cons_context_load(context: *mut RConsContext);
}
extern "C" {
    pub fn r_cons_context_reset();
}
extern "C" {
    pub fn r_cons_context_is_main() -> bool;
}
extern "C" {
    pub fn r_cons_context_break(context: *mut RConsContext);
}
extern "C" {
    pub fn r_cons_context_break_push(
        context: *mut RConsContext,
        cb: RConsBreak,
        user: *mut ::std::os::raw::c_void,
        sig: bool,
    );
}
extern "C" {
    pub fn r_cons_context_break_pop(context: *mut RConsContext, sig: bool);
}
extern "C" {
    pub fn r_cons_editor(
        file: *const ::std::os::raw::c_char,
        str_: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_cons_reset();
}
extern "C" {
    pub fn r_cons_reset_colors();
}
extern "C" {
    pub fn r_cons_errstr() -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_cons_errmode(mode: ::std::os::raw::c_int);
}
extern "C" {
    pub fn r_cons_errmodes(mode: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn r_cons_eprintf(format: *const ::std::os::raw::c_char, ...) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_cons_eflush();
}
extern "C" {
    pub fn r_cons_print_clear();
}
extern "C" {
    pub fn r_cons_echo(msg: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn r_cons_zero();
}
extern "C" {
    pub fn r_cons_highlight(word: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn r_cons_clear();
}
extern "C" {
    pub fn r_cons_clear_buffer();
}
extern "C" {
    pub fn r_cons_clear00();
}
extern "C" {
    pub fn r_cons_clear_line(err: ::std::os::raw::c_int);
}
extern "C" {
    pub fn r_cons_fill_line();
}
extern "C" {
    pub fn r_cons_stdout_open(file: *const ::std::os::raw::c_char, append: ::std::os::raw::c_int);
}
extern "C" {
    pub fn r_cons_stdout_set_fd(fd: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_cons_gotoxy(x: ::std::os::raw::c_int, y: ::std::os::raw::c_int);
}
extern "C" {
    pub fn r_cons_get_cur_line() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_cons_line(
        x: ::std::os::raw::c_int,
        y: ::std::os::raw::c_int,
        x2: ::std::os::raw::c_int,
        y2: ::std::os::raw::c_int,
        ch: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn r_cons_show_cursor(cursor: ::std::os::raw::c_int);
}
extern "C" {
    pub fn r_cons_swap_ground(col: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_cons_drop(n: ::std::os::raw::c_int) -> bool;
}
extern "C" {
    pub fn r_cons_chop();
}
extern "C" {
    pub fn r_cons_set_raw(b: bool);
}
extern "C" {
    pub fn r_cons_set_interactive(b: bool);
}
extern "C" {
    pub fn r_cons_set_last_interactive();
}
extern "C" {
    pub fn r_cons_set_utf8(b: bool);
}
extern "C" {
    pub fn r_cons_grep(grep: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn r_cons_printf(format: *const ::std::os::raw::c_char, ...) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_cons_printf_list(format: *const ::std::os::raw::c_char, ap: *mut __va_list_tag);
}
extern "C" {
    pub fn r_cons_strcat(str_: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn r_cons_strcat_at(
        str_: *const ::std::os::raw::c_char,
        x: ::std::os::raw::c_int,
        y: ::std::os::raw::c_char,
        w: ::std::os::raw::c_int,
        h: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn r_cons_println(str_: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn r_cons_strcat_justify(
        str_: *const ::std::os::raw::c_char,
        j: ::std::os::raw::c_int,
        c: ::std::os::raw::c_char,
    );
}
extern "C" {
    pub fn r_cons_printat(
        str_: *const ::std::os::raw::c_char,
        x: ::std::os::raw::c_int,
        y: ::std::os::raw::c_char,
    );
}
extern "C" {
    pub fn r_cons_write(
        str_: *const ::std::os::raw::c_char,
        len: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_cons_newline();
}
extern "C" {
    pub fn r_cons_filter();
}
extern "C" {
    pub fn r_cons_flush();
}
extern "C" {
    pub fn r_cons_print_fps(col: ::std::os::raw::c_int);
}
extern "C" {
    pub fn r_cons_last();
}
extern "C" {
    pub fn r_cons_less_str(
        str_: *const ::std::os::raw::c_char,
        exitkeys: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_cons_less();
}
extern "C" {
    pub fn r_cons_2048(color: bool);
}
extern "C" {
    pub fn r_cons_memset(ch: ::std::os::raw::c_char, len: ::std::os::raw::c_int);
}
extern "C" {
    pub fn r_cons_visual_flush();
}
extern "C" {
    pub fn r_cons_visual_write(buffer: *mut ::std::os::raw::c_char);
}
extern "C" {
    pub fn r_cons_is_utf8() -> bool;
}
extern "C" {
    pub fn r_cons_is_windows() -> bool;
}
extern "C" {
    pub fn r_cons_cmd_help(help: *mut *const ::std::os::raw::c_char, use_color: bool);
}
extern "C" {
    pub fn r_cons_cmd_help_match(
        help: *mut *const ::std::os::raw::c_char,
        use_color: bool,
        cmd: *mut ::std::os::raw::c_char,
        spec: ::std::os::raw::c_char,
        exact: bool,
    );
}
extern "C" {
    pub fn r_cons_log_stub(
        output: *const ::std::os::raw::c_char,
        funcname: *const ::std::os::raw::c_char,
        filename: *const ::std::os::raw::c_char,
        lineno: ::std::os::raw::c_uint,
        level: ::std::os::raw::c_uint,
        tag: *const ::std::os::raw::c_char,
        fmtstr: *const ::std::os::raw::c_char,
        ...
    );
}
extern "C" {
    pub fn r_cons_controlz(ch: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_cons_readchar() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_cons_readpush(str_: *const ::std::os::raw::c_char, len: ::std::os::raw::c_int)
        -> bool;
}
extern "C" {
    pub fn r_cons_readflush();
}
extern "C" {
    pub fn r_cons_switchbuf(active: bool);
}
extern "C" {
    pub fn r_cons_readchar_timeout(usec: u32) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_cons_any_key(msg: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_cons_eof() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_cons_thready();
}
extern "C" {
    pub fn r_cons_palette_init(pal: *const ::std::os::raw::c_uchar) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_cons_pal_set(
        key: *const ::std::os::raw::c_char,
        val: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_cons_pal_update_event();
}
extern "C" {
    pub fn r_cons_pal_free(ctx: *mut RConsContext);
}
extern "C" {
    pub fn r_cons_pal_init(ctx: *mut RConsContext);
}
extern "C" {
    pub fn r_cons_pal_copy(dst: *mut RConsContext, src: *mut RConsContext);
}
extern "C" {
    pub fn r_cons_pal_parse(
        str_: *const ::std::os::raw::c_char,
        outcol: *mut RColor,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_cons_pal_random();
}
extern "C" {
    pub fn r_cons_pal_get(key: *const ::std::os::raw::c_char) -> RColor;
}
extern "C" {
    pub fn r_cons_pal_get_i(index: ::std::os::raw::c_int) -> RColor;
}
extern "C" {
    pub fn r_cons_pal_get_name(index: ::std::os::raw::c_int) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_cons_pal_len() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_cons_rgb_parse(
        p: *const ::std::os::raw::c_char,
        r: *mut u8,
        g: *mut u8,
        b: *mut u8,
        a: *mut u8,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_cons_rgb_tostring(r: u8, g: u8, b: u8) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_cons_pal_list(rad: ::std::os::raw::c_int, arg: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn r_cons_pal_show();
}
extern "C" {
    pub fn r_cons_get_size(rows: *mut ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_cons_is_tty() -> bool;
}
extern "C" {
    pub fn r_cons_get_cursor(rows: *mut ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_cons_arrow_to_hjkl(ch: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_cons_html_filter(
        ptr: *const ::std::os::raw::c_char,
        newlen: *mut ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_cons_rainbow_get(
        idx: ::std::os::raw::c_int,
        last: ::std::os::raw::c_int,
        bg: bool,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_cons_rainbow_free(ctx: *mut RConsContext);
}
extern "C" {
    pub fn r_cons_rainbow_new(ctx: *mut RConsContext, sz: ::std::os::raw::c_int);
}
extern "C" {
    pub fn r_cons_fgets(
        buf: *mut ::std::os::raw::c_char,
        len: ::std::os::raw::c_int,
        argc: ::std::os::raw::c_int,
        argv: *mut *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_cons_hud(
        list: *mut RList,
        prompt: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_cons_hud_line(
        list: *mut RList,
        prompt: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_cons_hud_line_string(s: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_cons_hud_path(
        path: *const ::std::os::raw::c_char,
        dir: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_cons_hud_string(s: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_cons_hud_file(f: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_cons_get_buffer() -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_cons_get_buffer_len() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_cons_grep_help();
}
extern "C" {
    pub fn r_cons_grep_parsecmd(
        cmd: *mut ::std::os::raw::c_char,
        quotestr: *const ::std::os::raw::c_char,
    );
}
extern "C" {
    pub fn r_cons_grep_strip(
        cmd: *mut ::std::os::raw::c_char,
        quotestr: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_cons_grep_process(grep: *mut ::std::os::raw::c_char);
}
extern "C" {
    pub fn r_cons_grep_line(
        buf: *mut ::std::os::raw::c_char,
        len: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_cons_grepbuf();
}
extern "C" {
    pub fn r_cons_rgb(r: u8, g: u8, b: u8, a: u8);
}
extern "C" {
    pub fn r_cons_rgb_fgbg(r: u8, g: u8, b: u8, R: u8, G: u8, B: u8);
}
extern "C" {
    pub fn r_cons_rgb_init();
}
extern "C" {
    pub fn r_cons_rgb_str_mode(
        mode: RConsColorMode,
        outstr: *mut ::std::os::raw::c_char,
        sz: size_t,
        rcolor: *mut RColor,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_cons_rgb_str(
        outstr: *mut ::std::os::raw::c_char,
        sz: size_t,
        rcolor: *mut RColor,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_cons_rgb_str_off(
        outstr: *mut ::std::os::raw::c_char,
        sz: size_t,
        off: u64,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_cons_color(
        fg: ::std::os::raw::c_int,
        r: ::std::os::raw::c_int,
        g: ::std::os::raw::c_int,
        b: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn r_cons_color_random(alpha: u8) -> RColor;
}
extern "C" {
    pub fn r_cons_invert(set: ::std::os::raw::c_int, color: ::std::os::raw::c_int);
}
extern "C" {
    pub fn r_cons_yesno(
        def: ::std::os::raw::c_int,
        fmt: *const ::std::os::raw::c_char,
        ...
    ) -> bool;
}
extern "C" {
    pub fn r_cons_input(msg: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_cons_password(msg: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_cons_set_cup(enable: bool) -> bool;
}
extern "C" {
    pub fn r_cons_column(c: ::std::os::raw::c_int);
}
extern "C" {
    pub fn r_cons_get_column() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_cons_message(msg: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_cons_set_title(str_: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn r_cons_enable_mouse(enable: bool) -> bool;
}
extern "C" {
    pub fn r_cons_enable_highlight(enable: bool);
}
extern "C" {
    pub fn r_cons_bind(bind: *mut RConsBind);
}
extern "C" {
    pub fn r_cons_get_rune(ch: u8) -> *const ::std::os::raw::c_char;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RConsPixel {
    pub w: ::std::os::raw::c_int,
    pub h: ::std::os::raw::c_int,
    pub buf: *mut u8,
    pub buf_size: size_t,
}
#[test]
fn bindgen_test_layout_RConsPixel() {
    assert_eq!(
        ::std::mem::size_of::<RConsPixel>(),
        24usize,
        concat!("Size of: ", stringify!(RConsPixel))
    );
    assert_eq!(
        ::std::mem::align_of::<RConsPixel>(),
        8usize,
        concat!("Alignment of ", stringify!(RConsPixel))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RConsPixel>())).w as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(RConsPixel),
            "::",
            stringify!(w)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RConsPixel>())).h as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(RConsPixel),
            "::",
            stringify!(h)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RConsPixel>())).buf as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(RConsPixel),
            "::",
            stringify!(buf)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RConsPixel>())).buf_size as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(RConsPixel),
            "::",
            stringify!(buf_size)
        )
    );
}
extern "C" {
    pub fn r_cons_pixel_new(w: ::std::os::raw::c_int, h: ::std::os::raw::c_int) -> *mut RConsPixel;
}
extern "C" {
    pub fn r_cons_pixel_free(p: *mut RConsPixel);
}
extern "C" {
    pub fn r_cons_pixel_flush(
        p: *mut RConsPixel,
        sx: ::std::os::raw::c_int,
        sy: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn r_cons_pixel_drain(p: *mut RConsPixel) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_cons_pixel_get(
        p: *mut RConsPixel,
        x: ::std::os::raw::c_int,
        y: ::std::os::raw::c_int,
    ) -> u8;
}
extern "C" {
    pub fn r_cons_pixel_set(
        p: *mut RConsPixel,
        x: ::std::os::raw::c_int,
        y: ::std::os::raw::c_int,
        v: u8,
    );
}
extern "C" {
    pub fn r_cons_pixel_sets(
        p: *mut RConsPixel,
        x: ::std::os::raw::c_int,
        y: ::std::os::raw::c_int,
        s: *const ::std::os::raw::c_char,
    );
}
extern "C" {
    pub fn r_cons_pixel_fill(
        p: *mut RConsPixel,
        _x: ::std::os::raw::c_int,
        _y: ::std::os::raw::c_int,
        w: ::std::os::raw::c_int,
        h: ::std::os::raw::c_int,
        v: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn r_cons_pixel_tostring(p: *mut RConsPixel) -> *mut ::std::os::raw::c_char;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_selection_widget_t {
    pub options: *mut *const ::std::os::raw::c_char,
    pub options_len: ::std::os::raw::c_int,
    pub selection: ::std::os::raw::c_int,
    pub w: ::std::os::raw::c_int,
    pub h: ::std::os::raw::c_int,
    pub scroll: ::std::os::raw::c_int,
    pub complete_common: bool,
    pub direction: bool,
}
#[test]
fn bindgen_test_layout_r_selection_widget_t() {
    assert_eq!(
        ::std::mem::size_of::<r_selection_widget_t>(),
        32usize,
        concat!("Size of: ", stringify!(r_selection_widget_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_selection_widget_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_selection_widget_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_selection_widget_t>())).options as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_selection_widget_t),
            "::",
            stringify!(options)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_selection_widget_t>())).options_len as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_selection_widget_t),
            "::",
            stringify!(options_len)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_selection_widget_t>())).selection as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(r_selection_widget_t),
            "::",
            stringify!(selection)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_selection_widget_t>())).w as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(r_selection_widget_t),
            "::",
            stringify!(w)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_selection_widget_t>())).h as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(r_selection_widget_t),
            "::",
            stringify!(h)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_selection_widget_t>())).scroll as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(r_selection_widget_t),
            "::",
            stringify!(scroll)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_selection_widget_t>())).complete_common as *const _ as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(r_selection_widget_t),
            "::",
            stringify!(complete_common)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_selection_widget_t>())).direction as *const _ as usize },
        29usize,
        concat!(
            "Offset of field: ",
            stringify!(r_selection_widget_t),
            "::",
            stringify!(direction)
        )
    );
}
pub type RSelWidget = r_selection_widget_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_line_hist_t {
    pub data: *mut *mut ::std::os::raw::c_char,
    pub match_: *mut ::std::os::raw::c_char,
    pub size: ::std::os::raw::c_int,
    pub index: ::std::os::raw::c_int,
    pub top: ::std::os::raw::c_int,
    pub autosave: ::std::os::raw::c_int,
    pub do_setup_match: bool,
}
#[test]
fn bindgen_test_layout_r_line_hist_t() {
    assert_eq!(
        ::std::mem::size_of::<r_line_hist_t>(),
        40usize,
        concat!("Size of: ", stringify!(r_line_hist_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_line_hist_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_line_hist_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_line_hist_t>())).data as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_line_hist_t),
            "::",
            stringify!(data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_line_hist_t>())).match_ as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_line_hist_t),
            "::",
            stringify!(match_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_line_hist_t>())).size as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(r_line_hist_t),
            "::",
            stringify!(size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_line_hist_t>())).index as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(r_line_hist_t),
            "::",
            stringify!(index)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_line_hist_t>())).top as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(r_line_hist_t),
            "::",
            stringify!(top)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_line_hist_t>())).autosave as *const _ as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(r_line_hist_t),
            "::",
            stringify!(autosave)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_line_hist_t>())).do_setup_match as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(r_line_hist_t),
            "::",
            stringify!(do_setup_match)
        )
    );
}
pub type RLineHistory = r_line_hist_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_line_buffer_t {
    pub data: [::std::os::raw::c_char; 4096usize],
    pub index: ::std::os::raw::c_int,
    pub length: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_r_line_buffer_t() {
    assert_eq!(
        ::std::mem::size_of::<r_line_buffer_t>(),
        4104usize,
        concat!("Size of: ", stringify!(r_line_buffer_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_line_buffer_t>(),
        4usize,
        concat!("Alignment of ", stringify!(r_line_buffer_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_line_buffer_t>())).data as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_line_buffer_t),
            "::",
            stringify!(data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_line_buffer_t>())).index as *const _ as usize },
        4096usize,
        concat!(
            "Offset of field: ",
            stringify!(r_line_buffer_t),
            "::",
            stringify!(index)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_line_buffer_t>())).length as *const _ as usize },
        4100usize,
        concat!(
            "Offset of field: ",
            stringify!(r_line_buffer_t),
            "::",
            stringify!(length)
        )
    );
}
pub type RLineBuffer = r_line_buffer_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_hud_t {
    pub current_entry_n: ::std::os::raw::c_int,
    pub top_entry_n: ::std::os::raw::c_int,
    pub activate: ::std::os::raw::c_char,
    pub vi: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_r_hud_t() {
    assert_eq!(
        ::std::mem::size_of::<r_hud_t>(),
        16usize,
        concat!("Size of: ", stringify!(r_hud_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_hud_t>(),
        4usize,
        concat!("Alignment of ", stringify!(r_hud_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_hud_t>())).current_entry_n as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_hud_t),
            "::",
            stringify!(current_entry_n)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_hud_t>())).top_entry_n as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(r_hud_t),
            "::",
            stringify!(top_entry_n)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_hud_t>())).activate as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_hud_t),
            "::",
            stringify!(activate)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_hud_t>())).vi as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(r_hud_t),
            "::",
            stringify!(vi)
        )
    );
}
pub type RLineHud = r_hud_t;
pub type RLine = r_line_t;
pub type RLineCompletion = r_line_comp_t;
pub const RLinePromptType_R_LINE_PROMPT_DEFAULT: RLinePromptType = 0;
pub const RLinePromptType_R_LINE_PROMPT_OFFSET: RLinePromptType = 1;
pub const RLinePromptType_R_LINE_PROMPT_FILE: RLinePromptType = 2;
pub type RLinePromptType = ::std::os::raw::c_uint;
pub type RLineCompletionCb = ::std::option::Option<
    unsafe extern "C" fn(
        completion: *mut RLineCompletion,
        buf: *mut RLineBuffer,
        prompt_type: RLinePromptType,
        user: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int,
>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_line_comp_t {
    pub opt: bool,
    pub args_limit: size_t,
    pub quit: bool,
    pub args: RPVector,
    pub run: RLineCompletionCb,
    pub run_user: *mut ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout_r_line_comp_t() {
    assert_eq!(
        ::std::mem::size_of::<r_line_comp_t>(),
        88usize,
        concat!("Size of: ", stringify!(r_line_comp_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_line_comp_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_line_comp_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_line_comp_t>())).opt as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_line_comp_t),
            "::",
            stringify!(opt)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_line_comp_t>())).args_limit as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_line_comp_t),
            "::",
            stringify!(args_limit)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_line_comp_t>())).quit as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(r_line_comp_t),
            "::",
            stringify!(quit)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_line_comp_t>())).args as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(r_line_comp_t),
            "::",
            stringify!(args)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_line_comp_t>())).run as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(r_line_comp_t),
            "::",
            stringify!(run)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_line_comp_t>())).run_user as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(r_line_comp_t),
            "::",
            stringify!(run_user)
        )
    );
}
pub type RLineEditorCb = ::std::option::Option<
    unsafe extern "C" fn(
        core: *mut ::std::os::raw::c_void,
        str_: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char,
>;
pub type RLineHistoryUpCb =
    ::std::option::Option<unsafe extern "C" fn(line: *mut RLine) -> ::std::os::raw::c_int>;
pub type RLineHistoryDownCb =
    ::std::option::Option<unsafe extern "C" fn(line: *mut RLine) -> ::std::os::raw::c_int>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_line_t {
    pub completion: RLineCompletion,
    pub buffer: RLineBuffer,
    pub history: RLineHistory,
    pub sel_widget: *mut RSelWidget,
    pub cb_history_up: RLineHistoryUpCb,
    pub cb_history_down: RLineHistoryDownCb,
    pub cb_editor: RLineEditorCb,
    pub cb_fkey: RConsFunctionKey,
    pub echo: bool,
    pub prompt: *mut ::std::os::raw::c_char,
    pub kill_ring: *mut RList,
    pub kill_ring_ptr: ::std::os::raw::c_int,
    pub clipboard: *mut ::std::os::raw::c_char,
    pub disable: bool,
    pub user: *mut ::std::os::raw::c_void,
    pub histfilter: bool,
    pub hist_up: ::std::option::Option<
        unsafe extern "C" fn(user: *mut ::std::os::raw::c_void) -> ::std::os::raw::c_int,
    >,
    pub hist_down: ::std::option::Option<
        unsafe extern "C" fn(user: *mut ::std::os::raw::c_void) -> ::std::os::raw::c_int,
    >,
    pub contents: *mut ::std::os::raw::c_char,
    pub zerosep: bool,
    pub enable_vi_mode: bool,
    pub vi_mode: ::std::os::raw::c_int,
    pub prompt_mode: bool,
    pub prompt_type: RLinePromptType,
    pub offset_hist_index: ::std::os::raw::c_int,
    pub file_hist_index: ::std::os::raw::c_int,
    pub hud: *mut RLineHud,
    pub sdbshell_hist: *mut RList,
    pub sdbshell_hist_iter: *mut RListIter,
    pub vtmode: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_r_line_t() {
    assert_eq!(
        ::std::mem::size_of::<r_line_t>(),
        4416usize,
        concat!("Size of: ", stringify!(r_line_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_line_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_line_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_line_t>())).completion as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_line_t),
            "::",
            stringify!(completion)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_line_t>())).buffer as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(r_line_t),
            "::",
            stringify!(buffer)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_line_t>())).history as *const _ as usize },
        4192usize,
        concat!(
            "Offset of field: ",
            stringify!(r_line_t),
            "::",
            stringify!(history)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_line_t>())).sel_widget as *const _ as usize },
        4232usize,
        concat!(
            "Offset of field: ",
            stringify!(r_line_t),
            "::",
            stringify!(sel_widget)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_line_t>())).cb_history_up as *const _ as usize },
        4240usize,
        concat!(
            "Offset of field: ",
            stringify!(r_line_t),
            "::",
            stringify!(cb_history_up)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_line_t>())).cb_history_down as *const _ as usize },
        4248usize,
        concat!(
            "Offset of field: ",
            stringify!(r_line_t),
            "::",
            stringify!(cb_history_down)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_line_t>())).cb_editor as *const _ as usize },
        4256usize,
        concat!(
            "Offset of field: ",
            stringify!(r_line_t),
            "::",
            stringify!(cb_editor)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_line_t>())).cb_fkey as *const _ as usize },
        4264usize,
        concat!(
            "Offset of field: ",
            stringify!(r_line_t),
            "::",
            stringify!(cb_fkey)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_line_t>())).echo as *const _ as usize },
        4272usize,
        concat!(
            "Offset of field: ",
            stringify!(r_line_t),
            "::",
            stringify!(echo)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_line_t>())).prompt as *const _ as usize },
        4280usize,
        concat!(
            "Offset of field: ",
            stringify!(r_line_t),
            "::",
            stringify!(prompt)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_line_t>())).kill_ring as *const _ as usize },
        4288usize,
        concat!(
            "Offset of field: ",
            stringify!(r_line_t),
            "::",
            stringify!(kill_ring)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_line_t>())).kill_ring_ptr as *const _ as usize },
        4296usize,
        concat!(
            "Offset of field: ",
            stringify!(r_line_t),
            "::",
            stringify!(kill_ring_ptr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_line_t>())).clipboard as *const _ as usize },
        4304usize,
        concat!(
            "Offset of field: ",
            stringify!(r_line_t),
            "::",
            stringify!(clipboard)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_line_t>())).disable as *const _ as usize },
        4312usize,
        concat!(
            "Offset of field: ",
            stringify!(r_line_t),
            "::",
            stringify!(disable)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_line_t>())).user as *const _ as usize },
        4320usize,
        concat!(
            "Offset of field: ",
            stringify!(r_line_t),
            "::",
            stringify!(user)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_line_t>())).histfilter as *const _ as usize },
        4328usize,
        concat!(
            "Offset of field: ",
            stringify!(r_line_t),
            "::",
            stringify!(histfilter)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_line_t>())).hist_up as *const _ as usize },
        4336usize,
        concat!(
            "Offset of field: ",
            stringify!(r_line_t),
            "::",
            stringify!(hist_up)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_line_t>())).hist_down as *const _ as usize },
        4344usize,
        concat!(
            "Offset of field: ",
            stringify!(r_line_t),
            "::",
            stringify!(hist_down)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_line_t>())).contents as *const _ as usize },
        4352usize,
        concat!(
            "Offset of field: ",
            stringify!(r_line_t),
            "::",
            stringify!(contents)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_line_t>())).zerosep as *const _ as usize },
        4360usize,
        concat!(
            "Offset of field: ",
            stringify!(r_line_t),
            "::",
            stringify!(zerosep)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_line_t>())).enable_vi_mode as *const _ as usize },
        4361usize,
        concat!(
            "Offset of field: ",
            stringify!(r_line_t),
            "::",
            stringify!(enable_vi_mode)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_line_t>())).vi_mode as *const _ as usize },
        4364usize,
        concat!(
            "Offset of field: ",
            stringify!(r_line_t),
            "::",
            stringify!(vi_mode)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_line_t>())).prompt_mode as *const _ as usize },
        4368usize,
        concat!(
            "Offset of field: ",
            stringify!(r_line_t),
            "::",
            stringify!(prompt_mode)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_line_t>())).prompt_type as *const _ as usize },
        4372usize,
        concat!(
            "Offset of field: ",
            stringify!(r_line_t),
            "::",
            stringify!(prompt_type)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_line_t>())).offset_hist_index as *const _ as usize },
        4376usize,
        concat!(
            "Offset of field: ",
            stringify!(r_line_t),
            "::",
            stringify!(offset_hist_index)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_line_t>())).file_hist_index as *const _ as usize },
        4380usize,
        concat!(
            "Offset of field: ",
            stringify!(r_line_t),
            "::",
            stringify!(file_hist_index)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_line_t>())).hud as *const _ as usize },
        4384usize,
        concat!(
            "Offset of field: ",
            stringify!(r_line_t),
            "::",
            stringify!(hud)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_line_t>())).sdbshell_hist as *const _ as usize },
        4392usize,
        concat!(
            "Offset of field: ",
            stringify!(r_line_t),
            "::",
            stringify!(sdbshell_hist)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_line_t>())).sdbshell_hist_iter as *const _ as usize },
        4400usize,
        concat!(
            "Offset of field: ",
            stringify!(r_line_t),
            "::",
            stringify!(sdbshell_hist_iter)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_line_t>())).vtmode as *const _ as usize },
        4408usize,
        concat!(
            "Offset of field: ",
            stringify!(r_line_t),
            "::",
            stringify!(vtmode)
        )
    );
}
extern "C" {
    pub fn r_line_new() -> *mut RLine;
}
extern "C" {
    pub fn r_line_singleton() -> *mut RLine;
}
extern "C" {
    pub fn r_line_free();
}
extern "C" {
    pub fn r_line_get_prompt() -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_line_set_prompt(prompt: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn r_line_dietline_init() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_line_clipboard_push(str_: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn r_line_hist_free();
}
pub type RLineReadCallback = ::std::option::Option<
    unsafe extern "C" fn(
        user: *mut ::std::os::raw::c_void,
        line: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int,
>;
extern "C" {
    pub fn r_line_readline() -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_line_readline_cb(
        cb: RLineReadCallback,
        user: *mut ::std::os::raw::c_void,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_line_hist_load(file: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_line_hist_add(line: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_line_hist_save(file: *const ::std::os::raw::c_char) -> bool;
}
extern "C" {
    pub fn r_line_hist_label(
        label: *const ::std::os::raw::c_char,
        cb: ::std::option::Option<unsafe extern "C" fn(arg1: *const ::std::os::raw::c_char)>,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_line_label_show();
}
extern "C" {
    pub fn r_line_hist_list() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_line_hist_get(n: ::std::os::raw::c_int) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_line_set_hist_callback(
        line: *mut RLine,
        cb_up: RLineHistoryUpCb,
        cb_down: RLineHistoryDownCb,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_line_hist_cmd_up(line: *mut RLine) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_line_hist_cmd_down(line: *mut RLine) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_line_completion_init(completion: *mut RLineCompletion, args_limit: size_t);
}
extern "C" {
    pub fn r_line_completion_fini(completion: *mut RLineCompletion);
}
extern "C" {
    pub fn r_line_completion_push(
        completion: *mut RLineCompletion,
        str_: *const ::std::os::raw::c_char,
    );
}
extern "C" {
    pub fn r_line_completion_set(
        completion: *mut RLineCompletion,
        argc: ::std::os::raw::c_int,
        argv: *mut *const ::std::os::raw::c_char,
    );
}
extern "C" {
    pub fn r_line_completion_clear(completion: *mut RLineCompletion);
}
pub type RPanelsMenuCallback = ::std::option::Option<
    unsafe extern "C" fn(user: *mut ::std::os::raw::c_void) -> ::std::os::raw::c_int,
>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_panels_menu_item {
    pub n_sub: ::std::os::raw::c_int,
    pub selectedIndex: ::std::os::raw::c_int,
    pub name: *mut ::std::os::raw::c_char,
    pub sub: *mut *mut r_panels_menu_item,
    pub cb: RPanelsMenuCallback,
    pub p: *mut RPanel,
}
#[test]
fn bindgen_test_layout_r_panels_menu_item() {
    assert_eq!(
        ::std::mem::size_of::<r_panels_menu_item>(),
        40usize,
        concat!("Size of: ", stringify!(r_panels_menu_item))
    );
    assert_eq!(
        ::std::mem::align_of::<r_panels_menu_item>(),
        8usize,
        concat!("Alignment of ", stringify!(r_panels_menu_item))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_panels_menu_item>())).n_sub as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_panels_menu_item),
            "::",
            stringify!(n_sub)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_panels_menu_item>())).selectedIndex as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(r_panels_menu_item),
            "::",
            stringify!(selectedIndex)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_panels_menu_item>())).name as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_panels_menu_item),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_panels_menu_item>())).sub as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(r_panels_menu_item),
            "::",
            stringify!(sub)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_panels_menu_item>())).cb as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(r_panels_menu_item),
            "::",
            stringify!(cb)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_panels_menu_item>())).p as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(r_panels_menu_item),
            "::",
            stringify!(p)
        )
    );
}
pub type RPanelsMenuItem = r_panels_menu_item;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_panels_menu_t {
    pub root: *mut RPanelsMenuItem,
    pub history: *mut *mut RPanelsMenuItem,
    pub depth: ::std::os::raw::c_int,
    pub n_refresh: ::std::os::raw::c_int,
    pub refreshPanels: *mut *mut RPanel,
}
#[test]
fn bindgen_test_layout_r_panels_menu_t() {
    assert_eq!(
        ::std::mem::size_of::<r_panels_menu_t>(),
        32usize,
        concat!("Size of: ", stringify!(r_panels_menu_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_panels_menu_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_panels_menu_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_panels_menu_t>())).root as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_panels_menu_t),
            "::",
            stringify!(root)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_panels_menu_t>())).history as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_panels_menu_t),
            "::",
            stringify!(history)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_panels_menu_t>())).depth as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(r_panels_menu_t),
            "::",
            stringify!(depth)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_panels_menu_t>())).n_refresh as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(r_panels_menu_t),
            "::",
            stringify!(n_refresh)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_panels_menu_t>())).refreshPanels as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(r_panels_menu_t),
            "::",
            stringify!(refreshPanels)
        )
    );
}
pub type RPanelsMenu = r_panels_menu_t;
pub const RPanelsMode_PANEL_MODE_DEFAULT: RPanelsMode = 0;
pub const RPanelsMode_PANEL_MODE_MENU: RPanelsMode = 1;
pub const RPanelsMode_PANEL_MODE_ZOOM: RPanelsMode = 2;
pub const RPanelsMode_PANEL_MODE_WINDOW: RPanelsMode = 3;
pub const RPanelsMode_PANEL_MODE_HELP: RPanelsMode = 4;
pub type RPanelsMode = ::std::os::raw::c_uint;
pub const RPanelsFun_PANEL_FUN_SNOW: RPanelsFun = 0;
pub const RPanelsFun_PANEL_FUN_SAKURA: RPanelsFun = 1;
pub const RPanelsFun_PANEL_FUN_NOFUN: RPanelsFun = 2;
pub type RPanelsFun = ::std::os::raw::c_uint;
pub const RPanelsLayout_PANEL_LAYOUT_DEFAULT_STATIC: RPanelsLayout = 0;
pub const RPanelsLayout_PANEL_LAYOUT_DEFAULT_DYNAMIC: RPanelsLayout = 1;
pub type RPanelsLayout = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_panels_t {
    pub can: *mut RConsCanvas,
    pub panel: *mut *mut RPanel,
    pub n_panels: ::std::os::raw::c_int,
    pub columnWidth: ::std::os::raw::c_int,
    pub curnode: ::std::os::raw::c_int,
    pub mouse_orig_x: ::std::os::raw::c_int,
    pub mouse_orig_y: ::std::os::raw::c_int,
    pub autoUpdate: bool,
    pub mouse_on_edge_x: bool,
    pub mouse_on_edge_y: bool,
    pub panels_menu: *mut RPanelsMenu,
    pub db: *mut Sdb,
    pub rotate_db: *mut Sdb,
    pub modal_db: *mut Sdb,
    pub mht: *mut HtPP,
    pub mode: RPanelsMode,
    pub fun: RPanelsFun,
    pub prevMode: RPanelsMode,
    pub layout: RPanelsLayout,
    pub snows: *mut RList,
    pub name: *mut ::std::os::raw::c_char,
}
#[test]
fn bindgen_test_layout_r_panels_t() {
    assert_eq!(
        ::std::mem::size_of::<r_panels_t>(),
        112usize,
        concat!("Size of: ", stringify!(r_panels_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_panels_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_panels_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_panels_t>())).can as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_panels_t),
            "::",
            stringify!(can)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_panels_t>())).panel as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_panels_t),
            "::",
            stringify!(panel)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_panels_t>())).n_panels as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(r_panels_t),
            "::",
            stringify!(n_panels)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_panels_t>())).columnWidth as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(r_panels_t),
            "::",
            stringify!(columnWidth)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_panels_t>())).curnode as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(r_panels_t),
            "::",
            stringify!(curnode)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_panels_t>())).mouse_orig_x as *const _ as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(r_panels_t),
            "::",
            stringify!(mouse_orig_x)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_panels_t>())).mouse_orig_y as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(r_panels_t),
            "::",
            stringify!(mouse_orig_y)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_panels_t>())).autoUpdate as *const _ as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(r_panels_t),
            "::",
            stringify!(autoUpdate)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_panels_t>())).mouse_on_edge_x as *const _ as usize },
        37usize,
        concat!(
            "Offset of field: ",
            stringify!(r_panels_t),
            "::",
            stringify!(mouse_on_edge_x)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_panels_t>())).mouse_on_edge_y as *const _ as usize },
        38usize,
        concat!(
            "Offset of field: ",
            stringify!(r_panels_t),
            "::",
            stringify!(mouse_on_edge_y)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_panels_t>())).panels_menu as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(r_panels_t),
            "::",
            stringify!(panels_menu)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_panels_t>())).db as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(r_panels_t),
            "::",
            stringify!(db)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_panels_t>())).rotate_db as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(r_panels_t),
            "::",
            stringify!(rotate_db)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_panels_t>())).modal_db as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(r_panels_t),
            "::",
            stringify!(modal_db)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_panels_t>())).mht as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(r_panels_t),
            "::",
            stringify!(mht)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_panels_t>())).mode as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(r_panels_t),
            "::",
            stringify!(mode)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_panels_t>())).fun as *const _ as usize },
        84usize,
        concat!(
            "Offset of field: ",
            stringify!(r_panels_t),
            "::",
            stringify!(fun)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_panels_t>())).prevMode as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(r_panels_t),
            "::",
            stringify!(prevMode)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_panels_t>())).layout as *const _ as usize },
        92usize,
        concat!(
            "Offset of field: ",
            stringify!(r_panels_t),
            "::",
            stringify!(layout)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_panels_t>())).snows as *const _ as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(r_panels_t),
            "::",
            stringify!(snows)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_panels_t>())).name as *const _ as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(r_panels_t),
            "::",
            stringify!(name)
        )
    );
}
pub type RPanels = r_panels_t;
pub const RPanelsRootState_DEFAULT: RPanelsRootState = 0;
pub const RPanelsRootState_ROTATE: RPanelsRootState = 1;
pub const RPanelsRootState_DEL: RPanelsRootState = 2;
pub const RPanelsRootState_QUIT: RPanelsRootState = 3;
pub type RPanelsRootState = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_panels_root_t {
    pub n_panels: ::std::os::raw::c_int,
    pub cur_panels: ::std::os::raw::c_int,
    pub pdc_caches: *mut Sdb,
    pub cur_pdc_cache: *mut Sdb,
    pub panels: *mut *mut RPanels,
    pub root_state: RPanelsRootState,
}
#[test]
fn bindgen_test_layout_r_panels_root_t() {
    assert_eq!(
        ::std::mem::size_of::<r_panels_root_t>(),
        40usize,
        concat!("Size of: ", stringify!(r_panels_root_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_panels_root_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_panels_root_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_panels_root_t>())).n_panels as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_panels_root_t),
            "::",
            stringify!(n_panels)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_panels_root_t>())).cur_panels as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(r_panels_root_t),
            "::",
            stringify!(cur_panels)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_panels_root_t>())).pdc_caches as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_panels_root_t),
            "::",
            stringify!(pdc_caches)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_panels_root_t>())).cur_pdc_cache as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(r_panels_root_t),
            "::",
            stringify!(cur_pdc_cache)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_panels_root_t>())).panels as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(r_panels_root_t),
            "::",
            stringify!(panels)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_panels_root_t>())).root_state as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(r_panels_root_t),
            "::",
            stringify!(root_state)
        )
    );
}
pub type RPanelsRoot = r_panels_root_t;
extern "C" {
    pub fn r_diff_version() -> *const ::std::os::raw::c_char;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_diff_op_t {
    pub a_off: u64,
    pub a_buf: *const u8,
    pub a_len: u32,
    pub b_off: u64,
    pub b_buf: *const u8,
    pub b_len: u32,
}
#[test]
fn bindgen_test_layout_r_diff_op_t() {
    assert_eq!(
        ::std::mem::size_of::<r_diff_op_t>(),
        48usize,
        concat!("Size of: ", stringify!(r_diff_op_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_diff_op_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_diff_op_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_diff_op_t>())).a_off as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_diff_op_t),
            "::",
            stringify!(a_off)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_diff_op_t>())).a_buf as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_diff_op_t),
            "::",
            stringify!(a_buf)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_diff_op_t>())).a_len as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(r_diff_op_t),
            "::",
            stringify!(a_len)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_diff_op_t>())).b_off as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(r_diff_op_t),
            "::",
            stringify!(b_off)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_diff_op_t>())).b_buf as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(r_diff_op_t),
            "::",
            stringify!(b_buf)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_diff_op_t>())).b_len as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(r_diff_op_t),
            "::",
            stringify!(b_len)
        )
    );
}
pub type RDiffOp = r_diff_op_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_diff_t {
    pub off_a: u64,
    pub off_b: u64,
    pub delta: ::std::os::raw::c_int,
    pub user: *mut ::std::os::raw::c_void,
    pub verbose: bool,
    pub type_: ::std::os::raw::c_int,
    pub diff_cmd: *mut ::std::os::raw::c_char,
    pub callback: ::std::option::Option<
        unsafe extern "C" fn(
            diff: *mut r_diff_t,
            user: *mut ::std::os::raw::c_void,
            op: *mut RDiffOp,
        ) -> ::std::os::raw::c_int,
    >,
}
#[test]
fn bindgen_test_layout_r_diff_t() {
    assert_eq!(
        ::std::mem::size_of::<r_diff_t>(),
        56usize,
        concat!("Size of: ", stringify!(r_diff_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_diff_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_diff_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_diff_t>())).off_a as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_diff_t),
            "::",
            stringify!(off_a)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_diff_t>())).off_b as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_diff_t),
            "::",
            stringify!(off_b)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_diff_t>())).delta as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(r_diff_t),
            "::",
            stringify!(delta)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_diff_t>())).user as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(r_diff_t),
            "::",
            stringify!(user)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_diff_t>())).verbose as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(r_diff_t),
            "::",
            stringify!(verbose)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_diff_t>())).type_ as *const _ as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(r_diff_t),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_diff_t>())).diff_cmd as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(r_diff_t),
            "::",
            stringify!(diff_cmd)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_diff_t>())).callback as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(r_diff_t),
            "::",
            stringify!(callback)
        )
    );
}
pub type RDiff = r_diff_t;
pub const RLevOp_LEVEND: RLevOp = 0;
pub const RLevOp_LEVNOP: RLevOp = 1;
pub const RLevOp_LEVSUB: RLevOp = 2;
pub const RLevOp_LEVADD: RLevOp = 3;
pub const RLevOp_LEVDEL: RLevOp = 4;
pub type RLevOp = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_lev_buf {
    pub buf: *mut ::std::os::raw::c_void,
    pub len: u32,
}
#[test]
fn bindgen_test_layout_r_lev_buf() {
    assert_eq!(
        ::std::mem::size_of::<r_lev_buf>(),
        16usize,
        concat!("Size of: ", stringify!(r_lev_buf))
    );
    assert_eq!(
        ::std::mem::align_of::<r_lev_buf>(),
        8usize,
        concat!("Alignment of ", stringify!(r_lev_buf))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_lev_buf>())).buf as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_lev_buf),
            "::",
            stringify!(buf)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_lev_buf>())).len as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_lev_buf),
            "::",
            stringify!(len)
        )
    );
}
pub type RLevBuf = r_lev_buf;
pub type RLevMatches = ::std::option::Option<
    unsafe extern "C" fn(a: *mut RLevBuf, b: *mut RLevBuf, ia: u32, ib: u32) -> bool,
>;
pub type RDiffCallback = ::std::option::Option<
    unsafe extern "C" fn(
        diff: *mut RDiff,
        user: *mut ::std::os::raw::c_void,
        op: *mut RDiffOp,
    ) -> ::std::os::raw::c_int,
>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_diffchar_t {
    pub align_a: *const u8,
    pub align_b: *const u8,
    pub len_buf: size_t,
    pub start_align: size_t,
}
#[test]
fn bindgen_test_layout_r_diffchar_t() {
    assert_eq!(
        ::std::mem::size_of::<r_diffchar_t>(),
        32usize,
        concat!("Size of: ", stringify!(r_diffchar_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_diffchar_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_diffchar_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_diffchar_t>())).align_a as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_diffchar_t),
            "::",
            stringify!(align_a)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_diffchar_t>())).align_b as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_diffchar_t),
            "::",
            stringify!(align_b)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_diffchar_t>())).len_buf as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(r_diffchar_t),
            "::",
            stringify!(len_buf)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_diffchar_t>())).start_align as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(r_diffchar_t),
            "::",
            stringify!(start_align)
        )
    );
}
pub type RDiffChar = r_diffchar_t;
extern "C" {
    pub fn r_diff_new() -> *mut RDiff;
}
extern "C" {
    pub fn r_diff_new_from(off_a: u64, off_b: u64) -> *mut RDiff;
}
extern "C" {
    pub fn r_diff_free(d: *mut RDiff);
}
extern "C" {
    pub fn r_diff_buffers(
        d: *mut RDiff,
        a: *const u8,
        la: u32,
        b: *const u8,
        lb: u32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_diff_buffers_static(
        d: *mut RDiff,
        a: *const u8,
        la: ::std::os::raw::c_int,
        b: *const u8,
        lb: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_diff_buffers_radiff(
        d: *mut RDiff,
        a: *const u8,
        la: ::std::os::raw::c_int,
        b: *const u8,
        lb: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_diff_buffers_delta(
        diff: *mut RDiff,
        sa: *const u8,
        la: ::std::os::raw::c_int,
        sb: *const u8,
        lb: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_diff_buffers_to_string(
        d: *mut RDiff,
        a: *const u8,
        la: ::std::os::raw::c_int,
        b: *const u8,
        lb: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_diff_set_callback(
        d: *mut RDiff,
        callback: RDiffCallback,
        user: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_diff_buffers_distance(
        d: *mut RDiff,
        a: *const u8,
        la: u32,
        b: *const u8,
        lb: u32,
        distance: *mut u32,
        similarity: *mut f64,
    ) -> bool;
}
extern "C" {
    pub fn r_diff_buffers_distance_myers(
        diff: *mut RDiff,
        a: *const u8,
        la: u32,
        b: *const u8,
        lb: u32,
        distance: *mut u32,
        similarity: *mut f64,
    ) -> bool;
}
extern "C" {
    pub fn r_diff_buffers_distance_levenshtein(
        d: *mut RDiff,
        a: *const u8,
        la: u32,
        b: *const u8,
        lb: u32,
        distance: *mut u32,
        similarity: *mut f64,
    ) -> bool;
}
extern "C" {
    pub fn r_diff_buffers_unified(
        d: *mut RDiff,
        a: *const u8,
        la: ::std::os::raw::c_int,
        b: *const u8,
        lb: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_diff_lines(
        file1: *const ::std::os::raw::c_char,
        sa: *const ::std::os::raw::c_char,
        la: ::std::os::raw::c_int,
        file2: *const ::std::os::raw::c_char,
        sb: *const ::std::os::raw::c_char,
        lb: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_diff_set_delta(d: *mut RDiff, delta: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_diff_gdiff(
        file1: *const ::std::os::raw::c_char,
        file2: *const ::std::os::raw::c_char,
        rad: ::std::os::raw::c_int,
        va: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_diffchar_new(a: *const u8, b: *const u8) -> *mut RDiffChar;
}
extern "C" {
    pub fn r_diffchar_print(diffchar: *mut RDiffChar);
}
extern "C" {
    pub fn r_diffchar_free(diffchar: *mut RDiffChar);
}
extern "C" {
    pub fn r_diff_levenshtein_path(
        bufa: *mut RLevBuf,
        bufb: *mut RLevBuf,
        maxdst: u32,
        levdiff: RLevMatches,
        chgs: *mut *mut RLevOp,
    ) -> i32;
}
extern "C" {
    pub fn r_punycode_encode(
        src: *const u8,
        srclen: ::std::os::raw::c_int,
        dstlen: *mut ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_punycode_decode(
        src: *const ::std::os::raw::c_char,
        srclen: ::std::os::raw::c_int,
        dstlen: *mut ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_queue_t {
    pub elems: *mut *mut ::std::os::raw::c_void,
    pub capacity: ::std::os::raw::c_uint,
    pub front: ::std::os::raw::c_uint,
    pub rear: ::std::os::raw::c_int,
    pub size: ::std::os::raw::c_uint,
}
#[test]
fn bindgen_test_layout_r_queue_t() {
    assert_eq!(
        ::std::mem::size_of::<r_queue_t>(),
        24usize,
        concat!("Size of: ", stringify!(r_queue_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_queue_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_queue_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_queue_t>())).elems as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_queue_t),
            "::",
            stringify!(elems)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_queue_t>())).capacity as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_queue_t),
            "::",
            stringify!(capacity)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_queue_t>())).front as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(r_queue_t),
            "::",
            stringify!(front)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_queue_t>())).rear as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(r_queue_t),
            "::",
            stringify!(rear)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_queue_t>())).size as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(r_queue_t),
            "::",
            stringify!(size)
        )
    );
}
pub type RQueue = r_queue_t;
extern "C" {
    pub fn r_queue_new(n: ::std::os::raw::c_int) -> *mut RQueue;
}
extern "C" {
    pub fn r_queue_free(q: *mut RQueue);
}
extern "C" {
    pub fn r_queue_enqueue(
        q: *mut RQueue,
        el: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_queue_dequeue(q: *mut RQueue) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn r_queue_is_empty(q: *mut RQueue) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_range_item_t {
    pub fr: u64,
    pub to: u64,
    pub data: *mut u8,
    pub datalen: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_r_range_item_t() {
    assert_eq!(
        ::std::mem::size_of::<r_range_item_t>(),
        32usize,
        concat!("Size of: ", stringify!(r_range_item_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_range_item_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_range_item_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_range_item_t>())).fr as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_range_item_t),
            "::",
            stringify!(fr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_range_item_t>())).to as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_range_item_t),
            "::",
            stringify!(to)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_range_item_t>())).data as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(r_range_item_t),
            "::",
            stringify!(data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_range_item_t>())).datalen as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(r_range_item_t),
            "::",
            stringify!(datalen)
        )
    );
}
pub type RRangeItem = r_range_item_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_range_t {
    pub count: ::std::os::raw::c_int,
    pub changed: ::std::os::raw::c_int,
    pub ranges: *mut RList,
}
#[test]
fn bindgen_test_layout_r_range_t() {
    assert_eq!(
        ::std::mem::size_of::<r_range_t>(),
        16usize,
        concat!("Size of: ", stringify!(r_range_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_range_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_range_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_range_t>())).count as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_range_t),
            "::",
            stringify!(count)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_range_t>())).changed as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(r_range_t),
            "::",
            stringify!(changed)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_range_t>())).ranges as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_range_t),
            "::",
            stringify!(ranges)
        )
    );
}
pub type RRange = r_range_t;
extern "C" {
    pub fn r_range_new() -> *mut RRange;
}
extern "C" {
    pub fn r_range_new_from_string(string: *const ::std::os::raw::c_char) -> *mut RRange;
}
extern "C" {
    pub fn r_range_free(r: *mut RRange) -> *mut RRange;
}
extern "C" {
    pub fn r_range_item_get(r: *mut RRange, addr: u64) -> *mut RRangeItem;
}
extern "C" {
    pub fn r_range_size(r: *mut RRange) -> u64;
}
extern "C" {
    pub fn r_range_add_from_string(
        rgs: *mut RRange,
        string: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_range_add(
        rgs: *mut RRange,
        from: u64,
        to: u64,
        rw: ::std::os::raw::c_int,
    ) -> *mut RRangeItem;
}
extern "C" {
    pub fn r_range_sub(rgs: *mut RRange, from: u64, to: u64) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_range_merge(rgs: *mut RRange, r: *mut RRange);
}
extern "C" {
    pub fn r_range_contains(rgs: *mut RRange, addr: u64) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_range_sort(rgs: *mut RRange) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_range_percent(rgs: *mut RRange);
}
extern "C" {
    pub fn r_range_list(rgs: *mut RRange, rad: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_range_get_n(
        rgs: *mut RRange,
        n: ::std::os::raw::c_int,
        from: *mut u64,
        to: *mut u64,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_range_inverse(
        rgs: *mut RRange,
        from: u64,
        to: u64,
        flags: ::std::os::raw::c_int,
    ) -> *mut RRange;
}
extern "C" {
    pub fn r_range_overlap(
        a0: u64,
        a1: u64,
        b0: u64,
        b1: u64,
        d: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_space_t {
    pub name: *mut ::std::os::raw::c_char,
}
#[test]
fn bindgen_test_layout_r_space_t() {
    assert_eq!(
        ::std::mem::size_of::<r_space_t>(),
        8usize,
        concat!("Size of: ", stringify!(r_space_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_space_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_space_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_space_t>())).name as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_space_t),
            "::",
            stringify!(name)
        )
    );
}
pub type RSpace = r_space_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_spaces_t {
    pub name: *const ::std::os::raw::c_char,
    pub current: *mut RSpace,
    pub spaces: *mut RRBTree,
    pub spacestack: *mut RList,
    pub event: *mut REvent,
}
#[test]
fn bindgen_test_layout_r_spaces_t() {
    assert_eq!(
        ::std::mem::size_of::<r_spaces_t>(),
        40usize,
        concat!("Size of: ", stringify!(r_spaces_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_spaces_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_spaces_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_spaces_t>())).name as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_spaces_t),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_spaces_t>())).current as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_spaces_t),
            "::",
            stringify!(current)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_spaces_t>())).spaces as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(r_spaces_t),
            "::",
            stringify!(spaces)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_spaces_t>())).spacestack as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(r_spaces_t),
            "::",
            stringify!(spacestack)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_spaces_t>())).event as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(r_spaces_t),
            "::",
            stringify!(event)
        )
    );
}
pub type RSpaces = r_spaces_t;
extern "C" {
    pub fn r_spaces_new(name: *const ::std::os::raw::c_char) -> *mut RSpaces;
}
extern "C" {
    pub fn r_spaces_init(sp: *mut RSpaces, name: *const ::std::os::raw::c_char) -> bool;
}
extern "C" {
    pub fn r_spaces_fini(sp: *mut RSpaces);
}
extern "C" {
    pub fn r_spaces_free(sp: *mut RSpaces);
}
extern "C" {
    pub fn r_spaces_purge(sp: *mut RSpaces);
}
extern "C" {
    pub fn r_spaces_get(sp: *mut RSpaces, name: *const ::std::os::raw::c_char) -> *mut RSpace;
}
extern "C" {
    pub fn r_spaces_add(sp: *mut RSpaces, name: *const ::std::os::raw::c_char) -> *mut RSpace;
}
extern "C" {
    pub fn r_spaces_set(sp: *mut RSpaces, name: *const ::std::os::raw::c_char) -> *mut RSpace;
}
extern "C" {
    pub fn r_spaces_unset(sp: *mut RSpaces, name: *const ::std::os::raw::c_char) -> bool;
}
extern "C" {
    pub fn r_spaces_rename(
        sp: *mut RSpaces,
        oname: *const ::std::os::raw::c_char,
        nname: *const ::std::os::raw::c_char,
    ) -> bool;
}
extern "C" {
    pub fn r_spaces_count(
        sp: *mut RSpaces,
        name: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_spaces_push(sp: *mut RSpaces, name: *const ::std::os::raw::c_char) -> bool;
}
extern "C" {
    pub fn r_spaces_pop(sp: *mut RSpaces) -> bool;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RStrpool {
    pub str_: *mut ::std::os::raw::c_char,
    pub len: ::std::os::raw::c_int,
    pub size: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_RStrpool() {
    assert_eq!(
        ::std::mem::size_of::<RStrpool>(),
        16usize,
        concat!("Size of: ", stringify!(RStrpool))
    );
    assert_eq!(
        ::std::mem::align_of::<RStrpool>(),
        8usize,
        concat!("Alignment of ", stringify!(RStrpool))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RStrpool>())).str_ as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(RStrpool),
            "::",
            stringify!(str_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RStrpool>())).len as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(RStrpool),
            "::",
            stringify!(len)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RStrpool>())).size as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(RStrpool),
            "::",
            stringify!(size)
        )
    );
}
extern "C" {
    pub fn r_strpool_new(sz: ::std::os::raw::c_int) -> *mut RStrpool;
}
extern "C" {
    pub fn r_strpool_alloc(
        p: *mut RStrpool,
        l: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_strpool_memcat(
        p: *mut RStrpool,
        s: *const ::std::os::raw::c_char,
        len: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_strpool_ansi_chop(p: *mut RStrpool, n: ::std::os::raw::c_int)
        -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_strpool_append(
        p: *mut RStrpool,
        s: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_strpool_free(p: *mut RStrpool);
}
extern "C" {
    pub fn r_strpool_fit(p: *mut RStrpool) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_strpool_get(
        p: *mut RStrpool,
        index: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_strpool_get_i(
        p: *mut RStrpool,
        index: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_strpool_get_index(
        p: *mut RStrpool,
        s: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_strpool_next(
        p: *mut RStrpool,
        index: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_strpool_slice(
        p: *mut RStrpool,
        index: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_strpool_empty(p: *mut RStrpool) -> *mut ::std::os::raw::c_char;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_tree_node_t {
    pub parent: *mut r_tree_node_t,
    pub tree: *mut r_tree_t,
    pub children: *mut RList,
    pub n_children: ::std::os::raw::c_uint,
    pub depth: ::std::os::raw::c_int,
    pub free: RListFree,
    pub data: *mut ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout_r_tree_node_t() {
    assert_eq!(
        ::std::mem::size_of::<r_tree_node_t>(),
        48usize,
        concat!("Size of: ", stringify!(r_tree_node_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_tree_node_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_tree_node_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_tree_node_t>())).parent as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_tree_node_t),
            "::",
            stringify!(parent)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_tree_node_t>())).tree as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_tree_node_t),
            "::",
            stringify!(tree)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_tree_node_t>())).children as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(r_tree_node_t),
            "::",
            stringify!(children)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_tree_node_t>())).n_children as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(r_tree_node_t),
            "::",
            stringify!(n_children)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_tree_node_t>())).depth as *const _ as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(r_tree_node_t),
            "::",
            stringify!(depth)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_tree_node_t>())).free as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(r_tree_node_t),
            "::",
            stringify!(free)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_tree_node_t>())).data as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(r_tree_node_t),
            "::",
            stringify!(data)
        )
    );
}
pub type RTreeNode = r_tree_node_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_tree_t {
    pub root: *mut RTreeNode,
}
#[test]
fn bindgen_test_layout_r_tree_t() {
    assert_eq!(
        ::std::mem::size_of::<r_tree_t>(),
        8usize,
        concat!("Size of: ", stringify!(r_tree_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_tree_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_tree_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_tree_t>())).root as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_tree_t),
            "::",
            stringify!(root)
        )
    );
}
pub type RTree = r_tree_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_tree_visitor_t {
    pub pre_visit: ::std::option::Option<
        unsafe extern "C" fn(arg1: *mut RTreeNode, arg2: *mut r_tree_visitor_t),
    >,
    pub post_visit: ::std::option::Option<
        unsafe extern "C" fn(arg1: *mut RTreeNode, arg2: *mut r_tree_visitor_t),
    >,
    pub discover_child: ::std::option::Option<
        unsafe extern "C" fn(arg1: *mut RTreeNode, arg2: *mut r_tree_visitor_t),
    >,
    pub data: *mut ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout_r_tree_visitor_t() {
    assert_eq!(
        ::std::mem::size_of::<r_tree_visitor_t>(),
        32usize,
        concat!("Size of: ", stringify!(r_tree_visitor_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_tree_visitor_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_tree_visitor_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_tree_visitor_t>())).pre_visit as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_tree_visitor_t),
            "::",
            stringify!(pre_visit)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_tree_visitor_t>())).post_visit as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_tree_visitor_t),
            "::",
            stringify!(post_visit)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_tree_visitor_t>())).discover_child as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(r_tree_visitor_t),
            "::",
            stringify!(discover_child)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_tree_visitor_t>())).data as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(r_tree_visitor_t),
            "::",
            stringify!(data)
        )
    );
}
pub type RTreeVisitor = r_tree_visitor_t;
extern "C" {
    pub fn r_tree_new() -> *mut RTree;
}
extern "C" {
    pub fn r_tree_add_node(
        t: *mut RTree,
        node: *mut RTreeNode,
        child_data: *mut ::std::os::raw::c_void,
    ) -> *mut RTreeNode;
}
extern "C" {
    pub fn r_tree_reset(t: *mut RTree);
}
extern "C" {
    pub fn r_tree_free(t: *mut RTree);
}
extern "C" {
    pub fn r_tree_dfs(t: *mut RTree, vis: *mut RTreeVisitor);
}
extern "C" {
    pub fn r_tree_bfs(t: *mut RTree, vis: *mut RTreeVisitor);
}
extern "C" {
    pub fn r_uleb128(
        data: *const u8,
        datalen: ::std::os::raw::c_int,
        v: *mut u64,
        error: *mut *const ::std::os::raw::c_char,
    ) -> *const u8;
}
extern "C" {
    pub fn r_uleb128_decode(
        data: *const u8,
        datalen: *mut ::std::os::raw::c_int,
        v: *mut u64,
    ) -> *const u8;
}
extern "C" {
    pub fn r_uleb128_len(data: *const u8, size: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_uleb128_encode(s: u64, len: *mut ::std::os::raw::c_int) -> *mut u8;
}
extern "C" {
    pub fn r_leb128(data: *const u8, datalen: ::std::os::raw::c_int, v: *mut i64) -> *const u8;
}
extern "C" {
    pub fn r_sleb128(data: *mut *const u8, end: *const u8) -> i64;
}
pub type RRune = u32;
extern "C" {
    pub fn r_utf8_encode(ptr: *mut u8, ch: RRune) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_utf8_decode(
        ptr: *const u8,
        ptrlen: ::std::os::raw::c_int,
        ch: *mut RRune,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_utf8_encode_str(
        str_: *const RRune,
        dst: *mut u8,
        dst_length: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_utf8_size(ptr: *const u8) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_utf8_strlen(str_: *const u8) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_isprint(c: RRune) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_utf16_to_utf8_l(
        wc: *const wchar_t,
        len: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_utf_block_name(idx: ::std::os::raw::c_int) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_utf8_to_utf16_l(
        cstring: *const ::std::os::raw::c_char,
        len: ::std::os::raw::c_int,
    ) -> *mut wchar_t;
}
extern "C" {
    pub fn r_utf_block_idx(ch: RRune) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_utf_block_list(
        str_: *const u8,
        len: ::std::os::raw::c_int,
        freq_list: *mut *mut ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_utf_bom_encoding(ptr: *const u8, ptrlen: ::std::os::raw::c_int) -> RStrEnc;
}
extern "C" {
    pub fn r_utf16_decode(
        ptr: *const u8,
        ptrlen: ::std::os::raw::c_int,
        ch: *mut RRune,
        bigendian: bool,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_utf16le_decode(
        ptr: *const u8,
        ptrlen: ::std::os::raw::c_int,
        ch: *mut RRune,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_utf16be_decode(
        ptr: *const u8,
        ptrlen: ::std::os::raw::c_int,
        ch: *mut RRune,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_utf16le_encode(ptr: *mut u8, ch: RRune) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_utf32_decode(
        ptr: *const u8,
        ptrlen: ::std::os::raw::c_int,
        ch: *mut RRune,
        bigendian: bool,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_utf32le_decode(
        ptr: *const u8,
        ptrlen: ::std::os::raw::c_int,
        ch: *mut RRune,
    ) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_id_pool_t {
    pub start_id: u32,
    pub last_id: u32,
    pub next_id: u32,
    pub freed_ids: *mut RQueue,
}
#[test]
fn bindgen_test_layout_r_id_pool_t() {
    assert_eq!(
        ::std::mem::size_of::<r_id_pool_t>(),
        24usize,
        concat!("Size of: ", stringify!(r_id_pool_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_id_pool_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_id_pool_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_id_pool_t>())).start_id as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_id_pool_t),
            "::",
            stringify!(start_id)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_id_pool_t>())).last_id as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(r_id_pool_t),
            "::",
            stringify!(last_id)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_id_pool_t>())).next_id as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_id_pool_t),
            "::",
            stringify!(next_id)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_id_pool_t>())).freed_ids as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(r_id_pool_t),
            "::",
            stringify!(freed_ids)
        )
    );
}
pub type RIDPool = r_id_pool_t;
extern "C" {
    pub fn r_id_pool_new(start_id: u32, last_id: u32) -> *mut RIDPool;
}
extern "C" {
    pub fn r_id_pool_grab_id(pool: *mut RIDPool, grabber: *mut u32) -> bool;
}
extern "C" {
    pub fn r_id_pool_kick_id(pool: *mut RIDPool, kick: u32) -> bool;
}
extern "C" {
    pub fn r_id_pool_free(pool: *mut RIDPool);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_id_storage_t {
    pub pool: *mut RIDPool,
    pub data: *mut *mut ::std::os::raw::c_void,
    pub top_id: u32,
    pub size: u32,
}
#[test]
fn bindgen_test_layout_r_id_storage_t() {
    assert_eq!(
        ::std::mem::size_of::<r_id_storage_t>(),
        24usize,
        concat!("Size of: ", stringify!(r_id_storage_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_id_storage_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_id_storage_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_id_storage_t>())).pool as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_id_storage_t),
            "::",
            stringify!(pool)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_id_storage_t>())).data as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_id_storage_t),
            "::",
            stringify!(data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_id_storage_t>())).top_id as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(r_id_storage_t),
            "::",
            stringify!(top_id)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_id_storage_t>())).size as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(r_id_storage_t),
            "::",
            stringify!(size)
        )
    );
}
pub type RIDStorage = r_id_storage_t;
pub type RIDStorageForeachCb = ::std::option::Option<
    unsafe extern "C" fn(
        user: *mut ::std::os::raw::c_void,
        data: *mut ::std::os::raw::c_void,
        id: u32,
    ) -> bool,
>;
pub type ROIDStorageCompareCb = ::std::option::Option<
    unsafe extern "C" fn(
        in_: *mut ::std::os::raw::c_void,
        incoming: *mut ::std::os::raw::c_void,
        user: *mut ::std::os::raw::c_void,
        cmp_res: *mut ::std::os::raw::c_int,
    ) -> bool,
>;
extern "C" {
    pub fn r_id_storage_new(start_id: u32, last_id: u32) -> *mut RIDStorage;
}
extern "C" {
    pub fn r_id_storage_set(
        storage: *mut RIDStorage,
        data: *mut ::std::os::raw::c_void,
        id: u32,
    ) -> bool;
}
extern "C" {
    pub fn r_id_storage_add(
        storage: *mut RIDStorage,
        data: *mut ::std::os::raw::c_void,
        id: *mut u32,
    ) -> bool;
}
extern "C" {
    pub fn r_id_storage_get(storage: *mut RIDStorage, id: u32) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn r_id_storage_get_next(storage: *mut RIDStorage, id: *mut u32) -> bool;
}
extern "C" {
    pub fn r_id_storage_get_prev(storage: *mut RIDStorage, id: *mut u32) -> bool;
}
extern "C" {
    pub fn r_id_storage_delete(storage: *mut RIDStorage, id: u32);
}
extern "C" {
    pub fn r_id_storage_take(storage: *mut RIDStorage, id: u32) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn r_id_storage_foreach(
        storage: *mut RIDStorage,
        cb: RIDStorageForeachCb,
        user: *mut ::std::os::raw::c_void,
    ) -> bool;
}
extern "C" {
    pub fn r_id_storage_free(storage: *mut RIDStorage);
}
extern "C" {
    pub fn r_id_storage_list(s: *mut RIDStorage) -> *mut RList;
}
extern "C" {
    pub fn r_id_storage_get_lowest(storage: *mut RIDStorage, id: *mut u32) -> bool;
}
extern "C" {
    pub fn r_id_storage_get_highest(storage: *mut RIDStorage, id: *mut u32) -> bool;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_ordered_id_storage_t {
    pub permutation: *mut u32,
    pub psize: u32,
    pub ptop: u32,
    pub data: *mut RIDStorage,
    pub cmp: ROIDStorageCompareCb,
}
#[test]
fn bindgen_test_layout_r_ordered_id_storage_t() {
    assert_eq!(
        ::std::mem::size_of::<r_ordered_id_storage_t>(),
        32usize,
        concat!("Size of: ", stringify!(r_ordered_id_storage_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_ordered_id_storage_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_ordered_id_storage_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_ordered_id_storage_t>())).permutation as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_ordered_id_storage_t),
            "::",
            stringify!(permutation)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_ordered_id_storage_t>())).psize as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_ordered_id_storage_t),
            "::",
            stringify!(psize)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_ordered_id_storage_t>())).ptop as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(r_ordered_id_storage_t),
            "::",
            stringify!(ptop)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_ordered_id_storage_t>())).data as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(r_ordered_id_storage_t),
            "::",
            stringify!(data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_ordered_id_storage_t>())).cmp as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(r_ordered_id_storage_t),
            "::",
            stringify!(cmp)
        )
    );
}
pub type ROIDStorage = r_ordered_id_storage_t;
extern "C" {
    pub fn r_oids_new(start_id: u32, last_id: u32) -> *mut ROIDStorage;
}
extern "C" {
    pub fn r_oids_get(storage: *mut ROIDStorage, id: u32) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn r_oids_oget(storage: *mut ROIDStorage, od: u32) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn r_oids_get_id(storage: *mut ROIDStorage, od: u32, id: *mut u32) -> bool;
}
extern "C" {
    pub fn r_oids_get_od(storage: *mut ROIDStorage, id: u32, od: *mut u32) -> bool;
}
extern "C" {
    pub fn r_oids_to_front(storage: *mut ROIDStorage, id: u32) -> bool;
}
extern "C" {
    pub fn r_oids_to_rear(storage: *mut ROIDStorage, id: u32) -> bool;
}
extern "C" {
    pub fn r_oids_delete(storage: *mut ROIDStorage, id: u32);
}
extern "C" {
    pub fn r_oids_odelete(st: *mut ROIDStorage, od: u32);
}
extern "C" {
    pub fn r_oids_free(storage: *mut ROIDStorage);
}
extern "C" {
    pub fn r_oids_add(
        storage: *mut ROIDStorage,
        data: *mut ::std::os::raw::c_void,
        id: *mut u32,
        od: *mut u32,
    ) -> bool;
}
extern "C" {
    pub fn r_oids_take(storage: *mut ROIDStorage, id: u32) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn r_oids_otake(st: *mut ROIDStorage, od: u32) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn r_oids_foreach(
        storage: *mut ROIDStorage,
        cb: RIDStorageForeachCb,
        user: *mut ::std::os::raw::c_void,
    ) -> bool;
}
extern "C" {
    pub fn r_oids_foreach_prev(
        storage: *mut ROIDStorage,
        cb: RIDStorageForeachCb,
        user: *mut ::std::os::raw::c_void,
    ) -> bool;
}
extern "C" {
    pub fn r_oids_insert(
        storage: *mut ROIDStorage,
        data: *mut ::std::os::raw::c_void,
        id: *mut u32,
        od: *mut u32,
        user: *mut ::std::os::raw::c_void,
    ) -> bool;
}
extern "C" {
    pub fn r_oids_sort(storage: *mut ROIDStorage, user: *mut ::std::os::raw::c_void) -> bool;
}
extern "C" {
    pub fn r_oids_find(
        storage: *mut ROIDStorage,
        incoming: *mut ::std::os::raw::c_void,
        user: *mut ::std::os::raw::c_void,
    ) -> u32;
}
extern "C" {
    pub fn r_oids_last(storage: *mut ROIDStorage) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn r_oids_first(storage: *mut ROIDStorage) -> *mut ::std::os::raw::c_void;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_asn1_string_t {
    pub length: u32,
    pub string: *const ::std::os::raw::c_char,
    pub allocated: bool,
}
#[test]
fn bindgen_test_layout_r_asn1_string_t() {
    assert_eq!(
        ::std::mem::size_of::<r_asn1_string_t>(),
        24usize,
        concat!("Size of: ", stringify!(r_asn1_string_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_asn1_string_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_asn1_string_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_asn1_string_t>())).length as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_asn1_string_t),
            "::",
            stringify!(length)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_asn1_string_t>())).string as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_asn1_string_t),
            "::",
            stringify!(string)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_asn1_string_t>())).allocated as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(r_asn1_string_t),
            "::",
            stringify!(allocated)
        )
    );
}
pub type RASN1String = r_asn1_string_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_asn1_list_t {
    pub length: u32,
    pub objects: *mut *mut r_asn1_object_t,
}
#[test]
fn bindgen_test_layout_r_asn1_list_t() {
    assert_eq!(
        ::std::mem::size_of::<r_asn1_list_t>(),
        16usize,
        concat!("Size of: ", stringify!(r_asn1_list_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_asn1_list_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_asn1_list_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_asn1_list_t>())).length as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_asn1_list_t),
            "::",
            stringify!(length)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_asn1_list_t>())).objects as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_asn1_list_t),
            "::",
            stringify!(objects)
        )
    );
}
pub type ASN1List = r_asn1_list_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_asn1_bin_t {
    pub length: u32,
    pub binary: *mut u8,
}
#[test]
fn bindgen_test_layout_r_asn1_bin_t() {
    assert_eq!(
        ::std::mem::size_of::<r_asn1_bin_t>(),
        16usize,
        concat!("Size of: ", stringify!(r_asn1_bin_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_asn1_bin_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_asn1_bin_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_asn1_bin_t>())).length as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_asn1_bin_t),
            "::",
            stringify!(length)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_asn1_bin_t>())).binary as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_asn1_bin_t),
            "::",
            stringify!(binary)
        )
    );
}
pub type RASN1Binary = r_asn1_bin_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_asn1_object_t {
    pub klass: u8,
    pub form: u8,
    pub tag: u8,
    pub sector: *const u8,
    pub length: u32,
    pub offset: u64,
    pub list: ASN1List,
}
#[test]
fn bindgen_test_layout_r_asn1_object_t() {
    assert_eq!(
        ::std::mem::size_of::<r_asn1_object_t>(),
        48usize,
        concat!("Size of: ", stringify!(r_asn1_object_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_asn1_object_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_asn1_object_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_asn1_object_t>())).klass as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_asn1_object_t),
            "::",
            stringify!(klass)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_asn1_object_t>())).form as *const _ as usize },
        1usize,
        concat!(
            "Offset of field: ",
            stringify!(r_asn1_object_t),
            "::",
            stringify!(form)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_asn1_object_t>())).tag as *const _ as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(r_asn1_object_t),
            "::",
            stringify!(tag)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_asn1_object_t>())).sector as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_asn1_object_t),
            "::",
            stringify!(sector)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_asn1_object_t>())).length as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(r_asn1_object_t),
            "::",
            stringify!(length)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_asn1_object_t>())).offset as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(r_asn1_object_t),
            "::",
            stringify!(offset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_asn1_object_t>())).list as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(r_asn1_object_t),
            "::",
            stringify!(list)
        )
    );
}
pub type RASN1Object = r_asn1_object_t;
extern "C" {
    pub fn r_asn1_create_object(
        buffer: *const u8,
        length: u32,
        start_pointer: *const u8,
    ) -> *mut RASN1Object;
}
extern "C" {
    pub fn r_asn1_create_binary(buffer: *const u8, length: u32) -> *mut RASN1Binary;
}
extern "C" {
    pub fn r_asn1_create_string(
        string: *const ::std::os::raw::c_char,
        allocated: bool,
        length: u32,
    ) -> *mut RASN1String;
}
extern "C" {
    pub fn r_asn1_stringify_bits(buffer: *const u8, length: u32) -> *mut RASN1String;
}
extern "C" {
    pub fn r_asn1_stringify_utctime(buffer: *const u8, length: u32) -> *mut RASN1String;
}
extern "C" {
    pub fn r_asn1_stringify_time(buffer: *const u8, length: u32) -> *mut RASN1String;
}
extern "C" {
    pub fn r_asn1_stringify_integer(buffer: *const u8, length: u32) -> *mut RASN1String;
}
extern "C" {
    pub fn r_asn1_stringify_string(buffer: *const u8, length: u32) -> *mut RASN1String;
}
extern "C" {
    pub fn r_asn1_stringify_bytes(buffer: *const u8, length: u32) -> *mut RASN1String;
}
extern "C" {
    pub fn r_asn1_stringify_boolean(buffer: *const u8, length: u32) -> *mut RASN1String;
}
extern "C" {
    pub fn r_asn1_stringify_oid(buffer: *const u8, length: u32) -> *mut RASN1String;
}
extern "C" {
    pub fn r_asn1_free_object(object: *mut RASN1Object);
}
extern "C" {
    pub fn r_asn1_to_string(
        object: *mut RASN1Object,
        depth: u32,
        sb: *mut RStrBuf,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_asn1_free_string(string: *mut RASN1String);
}
extern "C" {
    pub fn r_asn1_free_binary(string: *mut RASN1Binary);
}
extern "C" {
    pub fn r_bplist_parse(pj: *mut PJ, data: *const u8, data_len: size_t) -> bool;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_x509_validity_t {
    pub notBefore: *mut RASN1String,
    pub notAfter: *mut RASN1String,
}
#[test]
fn bindgen_test_layout_r_x509_validity_t() {
    assert_eq!(
        ::std::mem::size_of::<r_x509_validity_t>(),
        16usize,
        concat!("Size of: ", stringify!(r_x509_validity_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_x509_validity_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_x509_validity_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_x509_validity_t>())).notBefore as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_x509_validity_t),
            "::",
            stringify!(notBefore)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_x509_validity_t>())).notAfter as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_x509_validity_t),
            "::",
            stringify!(notAfter)
        )
    );
}
pub type RX509Validity = r_x509_validity_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_x509_name_t {
    pub length: u32,
    pub oids: *mut *mut RASN1String,
    pub names: *mut *mut RASN1String,
}
#[test]
fn bindgen_test_layout_r_x509_name_t() {
    assert_eq!(
        ::std::mem::size_of::<r_x509_name_t>(),
        24usize,
        concat!("Size of: ", stringify!(r_x509_name_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_x509_name_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_x509_name_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_x509_name_t>())).length as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_x509_name_t),
            "::",
            stringify!(length)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_x509_name_t>())).oids as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_x509_name_t),
            "::",
            stringify!(oids)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_x509_name_t>())).names as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(r_x509_name_t),
            "::",
            stringify!(names)
        )
    );
}
pub type RX509Name = r_x509_name_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_x509_algorithmidentifier_t {
    pub algorithm: *mut RASN1String,
    pub parameters: *mut RASN1String,
}
#[test]
fn bindgen_test_layout_r_x509_algorithmidentifier_t() {
    assert_eq!(
        ::std::mem::size_of::<r_x509_algorithmidentifier_t>(),
        16usize,
        concat!("Size of: ", stringify!(r_x509_algorithmidentifier_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_x509_algorithmidentifier_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_x509_algorithmidentifier_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_x509_algorithmidentifier_t>())).algorithm as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_x509_algorithmidentifier_t),
            "::",
            stringify!(algorithm)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_x509_algorithmidentifier_t>())).parameters as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_x509_algorithmidentifier_t),
            "::",
            stringify!(parameters)
        )
    );
}
pub type RX509AlgorithmIdentifier = r_x509_algorithmidentifier_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_x509_subjectpublickeyinfo_t {
    pub algorithm: RX509AlgorithmIdentifier,
    pub subjectPublicKey: *mut RASN1Binary,
    pub subjectPublicKeyExponent: *mut RASN1Binary,
    pub subjectPublicKeyModule: *mut RASN1Binary,
}
#[test]
fn bindgen_test_layout_r_x509_subjectpublickeyinfo_t() {
    assert_eq!(
        ::std::mem::size_of::<r_x509_subjectpublickeyinfo_t>(),
        40usize,
        concat!("Size of: ", stringify!(r_x509_subjectpublickeyinfo_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_x509_subjectpublickeyinfo_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_x509_subjectpublickeyinfo_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_x509_subjectpublickeyinfo_t>())).algorithm as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_x509_subjectpublickeyinfo_t),
            "::",
            stringify!(algorithm)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_x509_subjectpublickeyinfo_t>())).subjectPublicKey as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(r_x509_subjectpublickeyinfo_t),
            "::",
            stringify!(subjectPublicKey)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_x509_subjectpublickeyinfo_t>())).subjectPublicKeyExponent
                as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(r_x509_subjectpublickeyinfo_t),
            "::",
            stringify!(subjectPublicKeyExponent)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_x509_subjectpublickeyinfo_t>())).subjectPublicKeyModule
                as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(r_x509_subjectpublickeyinfo_t),
            "::",
            stringify!(subjectPublicKeyModule)
        )
    );
}
pub type RX509SubjectPublicKeyInfo = r_x509_subjectpublickeyinfo_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_x509_extension_t {
    pub extnID: *mut RASN1String,
    pub critical: bool,
    pub extnValue: *mut RASN1Binary,
}
#[test]
fn bindgen_test_layout_r_x509_extension_t() {
    assert_eq!(
        ::std::mem::size_of::<r_x509_extension_t>(),
        24usize,
        concat!("Size of: ", stringify!(r_x509_extension_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_x509_extension_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_x509_extension_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_x509_extension_t>())).extnID as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_x509_extension_t),
            "::",
            stringify!(extnID)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_x509_extension_t>())).critical as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_x509_extension_t),
            "::",
            stringify!(critical)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_x509_extension_t>())).extnValue as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(r_x509_extension_t),
            "::",
            stringify!(extnValue)
        )
    );
}
pub type RX509Extension = r_x509_extension_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_x509_extensions_t {
    pub length: u32,
    pub extensions: *mut *mut RX509Extension,
}
#[test]
fn bindgen_test_layout_r_x509_extensions_t() {
    assert_eq!(
        ::std::mem::size_of::<r_x509_extensions_t>(),
        16usize,
        concat!("Size of: ", stringify!(r_x509_extensions_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_x509_extensions_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_x509_extensions_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_x509_extensions_t>())).length as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_x509_extensions_t),
            "::",
            stringify!(length)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_x509_extensions_t>())).extensions as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_x509_extensions_t),
            "::",
            stringify!(extensions)
        )
    );
}
pub type RX509Extensions = r_x509_extensions_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_x509_tbscertificate_t {
    pub version: u32,
    pub serialNumber: *mut RASN1String,
    pub signature: RX509AlgorithmIdentifier,
    pub issuer: RX509Name,
    pub validity: RX509Validity,
    pub subject: RX509Name,
    pub subjectPublicKeyInfo: RX509SubjectPublicKeyInfo,
    pub issuerUniqueID: *mut RASN1Binary,
    pub subjectUniqueID: *mut RASN1Binary,
    pub extensions: RX509Extensions,
}
#[test]
fn bindgen_test_layout_r_x509_tbscertificate_t() {
    assert_eq!(
        ::std::mem::size_of::<r_x509_tbscertificate_t>(),
        168usize,
        concat!("Size of: ", stringify!(r_x509_tbscertificate_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_x509_tbscertificate_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_x509_tbscertificate_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_x509_tbscertificate_t>())).version as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_x509_tbscertificate_t),
            "::",
            stringify!(version)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_x509_tbscertificate_t>())).serialNumber as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_x509_tbscertificate_t),
            "::",
            stringify!(serialNumber)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_x509_tbscertificate_t>())).signature as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(r_x509_tbscertificate_t),
            "::",
            stringify!(signature)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_x509_tbscertificate_t>())).issuer as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(r_x509_tbscertificate_t),
            "::",
            stringify!(issuer)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_x509_tbscertificate_t>())).validity as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(r_x509_tbscertificate_t),
            "::",
            stringify!(validity)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_x509_tbscertificate_t>())).subject as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(r_x509_tbscertificate_t),
            "::",
            stringify!(subject)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_x509_tbscertificate_t>())).subjectPublicKeyInfo as *const _
                as usize
        },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(r_x509_tbscertificate_t),
            "::",
            stringify!(subjectPublicKeyInfo)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_x509_tbscertificate_t>())).issuerUniqueID as *const _ as usize
        },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(r_x509_tbscertificate_t),
            "::",
            stringify!(issuerUniqueID)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_x509_tbscertificate_t>())).subjectUniqueID as *const _ as usize
        },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(r_x509_tbscertificate_t),
            "::",
            stringify!(subjectUniqueID)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_x509_tbscertificate_t>())).extensions as *const _ as usize
        },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(r_x509_tbscertificate_t),
            "::",
            stringify!(extensions)
        )
    );
}
pub type RX509TBSCertificate = r_x509_tbscertificate_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_x509_certificate_t {
    pub tbsCertificate: RX509TBSCertificate,
    pub algorithmIdentifier: RX509AlgorithmIdentifier,
    pub signature: *mut RASN1Binary,
}
#[test]
fn bindgen_test_layout_r_x509_certificate_t() {
    assert_eq!(
        ::std::mem::size_of::<r_x509_certificate_t>(),
        192usize,
        concat!("Size of: ", stringify!(r_x509_certificate_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_x509_certificate_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_x509_certificate_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_x509_certificate_t>())).tbsCertificate as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_x509_certificate_t),
            "::",
            stringify!(tbsCertificate)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_x509_certificate_t>())).algorithmIdentifier as *const _
                as usize
        },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(r_x509_certificate_t),
            "::",
            stringify!(algorithmIdentifier)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_x509_certificate_t>())).signature as *const _ as usize },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(r_x509_certificate_t),
            "::",
            stringify!(signature)
        )
    );
}
pub type RX509Certificate = r_x509_certificate_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_x509_crlentry {
    pub userCertificate: *mut RASN1Binary,
    pub revocationDate: *mut RASN1String,
}
#[test]
fn bindgen_test_layout_r_x509_crlentry() {
    assert_eq!(
        ::std::mem::size_of::<r_x509_crlentry>(),
        16usize,
        concat!("Size of: ", stringify!(r_x509_crlentry))
    );
    assert_eq!(
        ::std::mem::align_of::<r_x509_crlentry>(),
        8usize,
        concat!("Alignment of ", stringify!(r_x509_crlentry))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_x509_crlentry>())).userCertificate as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_x509_crlentry),
            "::",
            stringify!(userCertificate)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_x509_crlentry>())).revocationDate as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_x509_crlentry),
            "::",
            stringify!(revocationDate)
        )
    );
}
pub type RX509CRLEntry = r_x509_crlentry;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_x509_certificaterevocationlist {
    pub signature: RX509AlgorithmIdentifier,
    pub issuer: RX509Name,
    pub lastUpdate: *mut RASN1String,
    pub nextUpdate: *mut RASN1String,
    pub length: u32,
    pub revokedCertificates: *mut *mut RX509CRLEntry,
}
#[test]
fn bindgen_test_layout_r_x509_certificaterevocationlist() {
    assert_eq!(
        ::std::mem::size_of::<r_x509_certificaterevocationlist>(),
        72usize,
        concat!("Size of: ", stringify!(r_x509_certificaterevocationlist))
    );
    assert_eq!(
        ::std::mem::align_of::<r_x509_certificaterevocationlist>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(r_x509_certificaterevocationlist)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_x509_certificaterevocationlist>())).signature as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_x509_certificaterevocationlist),
            "::",
            stringify!(signature)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_x509_certificaterevocationlist>())).issuer as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(r_x509_certificaterevocationlist),
            "::",
            stringify!(issuer)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_x509_certificaterevocationlist>())).lastUpdate as *const _
                as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(r_x509_certificaterevocationlist),
            "::",
            stringify!(lastUpdate)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_x509_certificaterevocationlist>())).nextUpdate as *const _
                as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(r_x509_certificaterevocationlist),
            "::",
            stringify!(nextUpdate)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_x509_certificaterevocationlist>())).length as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(r_x509_certificaterevocationlist),
            "::",
            stringify!(length)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_x509_certificaterevocationlist>())).revokedCertificates
                as *const _ as usize
        },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(r_x509_certificaterevocationlist),
            "::",
            stringify!(revokedCertificates)
        )
    );
}
pub type RX509CertificateRevocationList = r_x509_certificaterevocationlist;
extern "C" {
    pub fn r_x509_parse_crl(object: *mut RASN1Object) -> *mut RX509CertificateRevocationList;
}
extern "C" {
    pub fn r_x509_crl_to_string(
        crl: *mut RX509CertificateRevocationList,
        pad: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_x509_crl_json(pj: *mut PJ, crl: *mut RX509CertificateRevocationList);
}
extern "C" {
    pub fn r_x509_parse_certificate(object: *mut RASN1Object) -> *mut RX509Certificate;
}
extern "C" {
    pub fn r_x509_parse_certificate2(buffer: *const u8, length: u32) -> *mut RX509Certificate;
}
extern "C" {
    pub fn r_x509_free_certificate(certificate: *mut RX509Certificate);
}
extern "C" {
    pub fn r_x509_certificate_to_string(
        certificate: *mut RX509Certificate,
        pad: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_x509_certificate_json(pj: *mut PJ, certificate: *mut RX509Certificate);
}
extern "C" {
    pub fn r_x509_certificate_dump(
        cert: *mut RX509Certificate,
        pad: *const ::std::os::raw::c_char,
        sb: *mut RStrBuf,
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_pkcs7_certificaterevocationlists_t {
    pub length: u32,
    pub elements: *mut *mut RX509CertificateRevocationList,
}
#[test]
fn bindgen_test_layout_r_pkcs7_certificaterevocationlists_t() {
    assert_eq!(
        ::std::mem::size_of::<r_pkcs7_certificaterevocationlists_t>(),
        16usize,
        concat!(
            "Size of: ",
            stringify!(r_pkcs7_certificaterevocationlists_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<r_pkcs7_certificaterevocationlists_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(r_pkcs7_certificaterevocationlists_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_pkcs7_certificaterevocationlists_t>())).length as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_pkcs7_certificaterevocationlists_t),
            "::",
            stringify!(length)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_pkcs7_certificaterevocationlists_t>())).elements as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_pkcs7_certificaterevocationlists_t),
            "::",
            stringify!(elements)
        )
    );
}
pub type RPKCS7CertificateRevocationLists = r_pkcs7_certificaterevocationlists_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_pkcs7_extendedcertificatesandcertificates_t {
    pub length: u32,
    pub elements: *mut *mut RX509Certificate,
}
#[test]
fn bindgen_test_layout_r_pkcs7_extendedcertificatesandcertificates_t() {
    assert_eq!(
        ::std::mem::size_of::<r_pkcs7_extendedcertificatesandcertificates_t>(),
        16usize,
        concat!(
            "Size of: ",
            stringify!(r_pkcs7_extendedcertificatesandcertificates_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<r_pkcs7_extendedcertificatesandcertificates_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(r_pkcs7_extendedcertificatesandcertificates_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_pkcs7_extendedcertificatesandcertificates_t>())).length
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_pkcs7_extendedcertificatesandcertificates_t),
            "::",
            stringify!(length)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_pkcs7_extendedcertificatesandcertificates_t>())).elements
                as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_pkcs7_extendedcertificatesandcertificates_t),
            "::",
            stringify!(elements)
        )
    );
}
pub type RPKCS7ExtendedCertificatesAndCertificates = r_pkcs7_extendedcertificatesandcertificates_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_pkcs7_digestalgorithmidentifiers_t {
    pub length: u32,
    pub elements: *mut *mut RX509AlgorithmIdentifier,
}
#[test]
fn bindgen_test_layout_r_pkcs7_digestalgorithmidentifiers_t() {
    assert_eq!(
        ::std::mem::size_of::<r_pkcs7_digestalgorithmidentifiers_t>(),
        16usize,
        concat!(
            "Size of: ",
            stringify!(r_pkcs7_digestalgorithmidentifiers_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<r_pkcs7_digestalgorithmidentifiers_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(r_pkcs7_digestalgorithmidentifiers_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_pkcs7_digestalgorithmidentifiers_t>())).length as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_pkcs7_digestalgorithmidentifiers_t),
            "::",
            stringify!(length)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_pkcs7_digestalgorithmidentifiers_t>())).elements as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_pkcs7_digestalgorithmidentifiers_t),
            "::",
            stringify!(elements)
        )
    );
}
pub type RPKCS7DigestAlgorithmIdentifiers = r_pkcs7_digestalgorithmidentifiers_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_pkcs7_contentinfo_t {
    pub contentType: *mut RASN1String,
    pub content: *mut RASN1Binary,
}
#[test]
fn bindgen_test_layout_r_pkcs7_contentinfo_t() {
    assert_eq!(
        ::std::mem::size_of::<r_pkcs7_contentinfo_t>(),
        16usize,
        concat!("Size of: ", stringify!(r_pkcs7_contentinfo_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_pkcs7_contentinfo_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_pkcs7_contentinfo_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_pkcs7_contentinfo_t>())).contentType as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_pkcs7_contentinfo_t),
            "::",
            stringify!(contentType)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_pkcs7_contentinfo_t>())).content as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_pkcs7_contentinfo_t),
            "::",
            stringify!(content)
        )
    );
}
pub type RPKCS7ContentInfo = r_pkcs7_contentinfo_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_pkcs7_issuerandserialnumber_t {
    pub issuer: RX509Name,
    pub serialNumber: *mut RASN1Binary,
}
#[test]
fn bindgen_test_layout_r_pkcs7_issuerandserialnumber_t() {
    assert_eq!(
        ::std::mem::size_of::<r_pkcs7_issuerandserialnumber_t>(),
        32usize,
        concat!("Size of: ", stringify!(r_pkcs7_issuerandserialnumber_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_pkcs7_issuerandserialnumber_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_pkcs7_issuerandserialnumber_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_pkcs7_issuerandserialnumber_t>())).issuer as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_pkcs7_issuerandserialnumber_t),
            "::",
            stringify!(issuer)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_pkcs7_issuerandserialnumber_t>())).serialNumber as *const _
                as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(r_pkcs7_issuerandserialnumber_t),
            "::",
            stringify!(serialNumber)
        )
    );
}
pub type RPKCS7IssuerAndSerialNumber = r_pkcs7_issuerandserialnumber_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_pkcs7_attribute_t {
    pub oid: *mut RASN1String,
    pub data: *mut RASN1Binary,
}
#[test]
fn bindgen_test_layout_r_pkcs7_attribute_t() {
    assert_eq!(
        ::std::mem::size_of::<r_pkcs7_attribute_t>(),
        16usize,
        concat!("Size of: ", stringify!(r_pkcs7_attribute_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_pkcs7_attribute_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_pkcs7_attribute_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_pkcs7_attribute_t>())).oid as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_pkcs7_attribute_t),
            "::",
            stringify!(oid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_pkcs7_attribute_t>())).data as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_pkcs7_attribute_t),
            "::",
            stringify!(data)
        )
    );
}
pub type RPKCS7Attribute = r_pkcs7_attribute_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_pkcs7_attributes_t {
    pub length: u32,
    pub elements: *mut *mut RPKCS7Attribute,
}
#[test]
fn bindgen_test_layout_r_pkcs7_attributes_t() {
    assert_eq!(
        ::std::mem::size_of::<r_pkcs7_attributes_t>(),
        16usize,
        concat!("Size of: ", stringify!(r_pkcs7_attributes_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_pkcs7_attributes_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_pkcs7_attributes_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_pkcs7_attributes_t>())).length as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_pkcs7_attributes_t),
            "::",
            stringify!(length)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_pkcs7_attributes_t>())).elements as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_pkcs7_attributes_t),
            "::",
            stringify!(elements)
        )
    );
}
pub type RPKCS7Attributes = r_pkcs7_attributes_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_pkcs7_signerinfo_t {
    pub version: u32,
    pub issuerAndSerialNumber: RPKCS7IssuerAndSerialNumber,
    pub digestAlgorithm: RX509AlgorithmIdentifier,
    pub authenticatedAttributes: RPKCS7Attributes,
    pub digestEncryptionAlgorithm: RX509AlgorithmIdentifier,
    pub encryptedDigest: *mut RASN1Binary,
    pub unauthenticatedAttributes: RPKCS7Attributes,
}
#[test]
fn bindgen_test_layout_r_pkcs7_signerinfo_t() {
    assert_eq!(
        ::std::mem::size_of::<r_pkcs7_signerinfo_t>(),
        112usize,
        concat!("Size of: ", stringify!(r_pkcs7_signerinfo_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_pkcs7_signerinfo_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_pkcs7_signerinfo_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_pkcs7_signerinfo_t>())).version as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_pkcs7_signerinfo_t),
            "::",
            stringify!(version)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_pkcs7_signerinfo_t>())).issuerAndSerialNumber as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_pkcs7_signerinfo_t),
            "::",
            stringify!(issuerAndSerialNumber)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_pkcs7_signerinfo_t>())).digestAlgorithm as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(r_pkcs7_signerinfo_t),
            "::",
            stringify!(digestAlgorithm)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_pkcs7_signerinfo_t>())).authenticatedAttributes as *const _
                as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(r_pkcs7_signerinfo_t),
            "::",
            stringify!(authenticatedAttributes)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_pkcs7_signerinfo_t>())).digestEncryptionAlgorithm as *const _
                as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(r_pkcs7_signerinfo_t),
            "::",
            stringify!(digestEncryptionAlgorithm)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_pkcs7_signerinfo_t>())).encryptedDigest as *const _ as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(r_pkcs7_signerinfo_t),
            "::",
            stringify!(encryptedDigest)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_pkcs7_signerinfo_t>())).unauthenticatedAttributes as *const _
                as usize
        },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(r_pkcs7_signerinfo_t),
            "::",
            stringify!(unauthenticatedAttributes)
        )
    );
}
pub type RPKCS7SignerInfo = r_pkcs7_signerinfo_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_pkcs7_signerinfos_t {
    pub length: u32,
    pub elements: *mut *mut RPKCS7SignerInfo,
}
#[test]
fn bindgen_test_layout_r_pkcs7_signerinfos_t() {
    assert_eq!(
        ::std::mem::size_of::<r_pkcs7_signerinfos_t>(),
        16usize,
        concat!("Size of: ", stringify!(r_pkcs7_signerinfos_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_pkcs7_signerinfos_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_pkcs7_signerinfos_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_pkcs7_signerinfos_t>())).length as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_pkcs7_signerinfos_t),
            "::",
            stringify!(length)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_pkcs7_signerinfos_t>())).elements as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_pkcs7_signerinfos_t),
            "::",
            stringify!(elements)
        )
    );
}
pub type RPKCS7SignerInfos = r_pkcs7_signerinfos_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_pkcs7_signeddata_t {
    pub version: u32,
    pub digestAlgorithms: RPKCS7DigestAlgorithmIdentifiers,
    pub contentInfo: RPKCS7ContentInfo,
    pub certificates: RPKCS7ExtendedCertificatesAndCertificates,
    pub crls: RPKCS7CertificateRevocationLists,
    pub signerinfos: RPKCS7SignerInfos,
}
#[test]
fn bindgen_test_layout_r_pkcs7_signeddata_t() {
    assert_eq!(
        ::std::mem::size_of::<r_pkcs7_signeddata_t>(),
        88usize,
        concat!("Size of: ", stringify!(r_pkcs7_signeddata_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_pkcs7_signeddata_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_pkcs7_signeddata_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_pkcs7_signeddata_t>())).version as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_pkcs7_signeddata_t),
            "::",
            stringify!(version)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_pkcs7_signeddata_t>())).digestAlgorithms as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_pkcs7_signeddata_t),
            "::",
            stringify!(digestAlgorithms)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_pkcs7_signeddata_t>())).contentInfo as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(r_pkcs7_signeddata_t),
            "::",
            stringify!(contentInfo)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_pkcs7_signeddata_t>())).certificates as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(r_pkcs7_signeddata_t),
            "::",
            stringify!(certificates)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_pkcs7_signeddata_t>())).crls as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(r_pkcs7_signeddata_t),
            "::",
            stringify!(crls)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_pkcs7_signeddata_t>())).signerinfos as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(r_pkcs7_signeddata_t),
            "::",
            stringify!(signerinfos)
        )
    );
}
pub type RPKCS7SignedData = r_pkcs7_signeddata_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_pkcs7_container_t {
    pub contentType: *mut RASN1String,
    pub signedData: RPKCS7SignedData,
}
#[test]
fn bindgen_test_layout_r_pkcs7_container_t() {
    assert_eq!(
        ::std::mem::size_of::<r_pkcs7_container_t>(),
        96usize,
        concat!("Size of: ", stringify!(r_pkcs7_container_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_pkcs7_container_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_pkcs7_container_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_pkcs7_container_t>())).contentType as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_pkcs7_container_t),
            "::",
            stringify!(contentType)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_pkcs7_container_t>())).signedData as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_pkcs7_container_t),
            "::",
            stringify!(signedData)
        )
    );
}
pub type RCMS = r_pkcs7_container_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SpcAttributeTypeAndOptionalValue {
    pub type_: *mut RASN1String,
    pub data: *mut RASN1Binary,
}
#[test]
fn bindgen_test_layout_SpcAttributeTypeAndOptionalValue() {
    assert_eq!(
        ::std::mem::size_of::<SpcAttributeTypeAndOptionalValue>(),
        16usize,
        concat!("Size of: ", stringify!(SpcAttributeTypeAndOptionalValue))
    );
    assert_eq!(
        ::std::mem::align_of::<SpcAttributeTypeAndOptionalValue>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(SpcAttributeTypeAndOptionalValue)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SpcAttributeTypeAndOptionalValue>())).type_ as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(SpcAttributeTypeAndOptionalValue),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SpcAttributeTypeAndOptionalValue>())).data as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(SpcAttributeTypeAndOptionalValue),
            "::",
            stringify!(data)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SpcDigestInfo {
    pub digestAlgorithm: RX509AlgorithmIdentifier,
    pub digest: *mut RASN1Binary,
}
#[test]
fn bindgen_test_layout_SpcDigestInfo() {
    assert_eq!(
        ::std::mem::size_of::<SpcDigestInfo>(),
        24usize,
        concat!("Size of: ", stringify!(SpcDigestInfo))
    );
    assert_eq!(
        ::std::mem::align_of::<SpcDigestInfo>(),
        8usize,
        concat!("Alignment of ", stringify!(SpcDigestInfo))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<SpcDigestInfo>())).digestAlgorithm as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(SpcDigestInfo),
            "::",
            stringify!(digestAlgorithm)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<SpcDigestInfo>())).digest as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(SpcDigestInfo),
            "::",
            stringify!(digest)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SpcIndirectDataContent {
    pub data: SpcAttributeTypeAndOptionalValue,
    pub messageDigest: SpcDigestInfo,
}
#[test]
fn bindgen_test_layout_SpcIndirectDataContent() {
    assert_eq!(
        ::std::mem::size_of::<SpcIndirectDataContent>(),
        40usize,
        concat!("Size of: ", stringify!(SpcIndirectDataContent))
    );
    assert_eq!(
        ::std::mem::align_of::<SpcIndirectDataContent>(),
        8usize,
        concat!("Alignment of ", stringify!(SpcIndirectDataContent))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<SpcIndirectDataContent>())).data as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(SpcIndirectDataContent),
            "::",
            stringify!(data)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SpcIndirectDataContent>())).messageDigest as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(SpcIndirectDataContent),
            "::",
            stringify!(messageDigest)
        )
    );
}
extern "C" {
    pub fn r_pkcs7_parse_cms(buffer: *const u8, length: u32) -> *mut RCMS;
}
extern "C" {
    pub fn r_pkcs7_free_cms(container: *mut RCMS);
}
extern "C" {
    pub fn r_pkcs7_cms_to_string(container: *mut RCMS) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_pkcs7_cms_json(container: *mut RCMS) -> *mut PJ;
}
extern "C" {
    pub fn r_pkcs7_parse_spcinfo(cms: *mut RCMS) -> *mut SpcIndirectDataContent;
}
extern "C" {
    pub fn r_pkcs7_free_spcinfo(spcinfo: *mut SpcIndirectDataContent);
}
extern "C" {
    pub fn r_protobuf_decode(
        buffer: *const u8,
        size: u64,
        debug: bool,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_axml_decode(buffer: *const u8, size: u64) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_util_version() -> *const ::std::os::raw::c_char;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_getopt_t {
    pub err: ::std::os::raw::c_int,
    pub ind: ::std::os::raw::c_int,
    pub opt: ::std::os::raw::c_int,
    pub reset: ::std::os::raw::c_int,
    pub arg: *const ::std::os::raw::c_char,
    pub argc: ::std::os::raw::c_int,
    pub argv: *mut *const ::std::os::raw::c_char,
    pub ostr: *const ::std::os::raw::c_char,
}
#[test]
fn bindgen_test_layout_r_getopt_t() {
    assert_eq!(
        ::std::mem::size_of::<r_getopt_t>(),
        48usize,
        concat!("Size of: ", stringify!(r_getopt_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_getopt_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_getopt_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_getopt_t>())).err as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_getopt_t),
            "::",
            stringify!(err)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_getopt_t>())).ind as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(r_getopt_t),
            "::",
            stringify!(ind)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_getopt_t>())).opt as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_getopt_t),
            "::",
            stringify!(opt)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_getopt_t>())).reset as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(r_getopt_t),
            "::",
            stringify!(reset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_getopt_t>())).arg as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(r_getopt_t),
            "::",
            stringify!(arg)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_getopt_t>())).argc as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(r_getopt_t),
            "::",
            stringify!(argc)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_getopt_t>())).argv as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(r_getopt_t),
            "::",
            stringify!(argv)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_getopt_t>())).ostr as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(r_getopt_t),
            "::",
            stringify!(ostr)
        )
    );
}
pub type RGetopt = r_getopt_t;
extern "C" {
    pub fn r_getopt_init(
        go: *mut RGetopt,
        argc: ::std::os::raw::c_int,
        argv: *mut *const ::std::os::raw::c_char,
        ostr: *const ::std::os::raw::c_char,
    );
}
extern "C" {
    pub fn r_getopt_next(opt: *mut RGetopt) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_main_version() -> *const ::std::os::raw::c_char;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_main_t {
    pub name: *const ::std::os::raw::c_char,
    pub main: ::std::option::Option<
        unsafe extern "C" fn(
            argc: ::std::os::raw::c_int,
            argv: *mut *const ::std::os::raw::c_char,
        ) -> ::std::os::raw::c_int,
    >,
}
#[test]
fn bindgen_test_layout_r_main_t() {
    assert_eq!(
        ::std::mem::size_of::<r_main_t>(),
        16usize,
        concat!("Size of: ", stringify!(r_main_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_main_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_main_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_main_t>())).name as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_main_t),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_main_t>())).main as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_main_t),
            "::",
            stringify!(main)
        )
    );
}
pub type RMain = r_main_t;
pub type RMainCallback = ::std::option::Option<
    unsafe extern "C" fn(
        argc: ::std::os::raw::c_int,
        argv: *mut *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int,
>;
extern "C" {
    pub fn r_main_new(name: *const ::std::os::raw::c_char) -> *mut RMain;
}
extern "C" {
    pub fn r_main_free(m: *mut RMain);
}
extern "C" {
    pub fn r_main_run(
        m: *mut RMain,
        argc: ::std::os::raw::c_int,
        argv: *mut *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_main_version_print(program: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_main_ravc2(
        argc: ::std::os::raw::c_int,
        argv: *mut *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_main_rax2(
        argc: ::std::os::raw::c_int,
        argv: *mut *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_main_rarun2(
        argc: ::std::os::raw::c_int,
        argv: *mut *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_main_rahash2(
        argc: ::std::os::raw::c_int,
        argv: *mut *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_main_rabin2(
        argc: ::std::os::raw::c_int,
        argv: *mut *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_main_radare2(
        argc: ::std::os::raw::c_int,
        argv: *mut *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_main_rasm2(
        argc: ::std::os::raw::c_int,
        argv: *mut *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_main_r2agent(
        argc: ::std::os::raw::c_int,
        argv: *mut *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_main_rafind2(
        argc: ::std::os::raw::c_int,
        argv: *mut *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_main_radiff2(
        argc: ::std::os::raw::c_int,
        argv: *mut *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_main_ragg2(
        argc: ::std::os::raw::c_int,
        argv: *mut *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_main_rasign2(
        argc: ::std::os::raw::c_int,
        argv: *mut *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_main_r2pm(
        argc: ::std::os::raw::c_int,
        argv: *mut *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
pub type RCoreCmd = ::std::option::Option<
    unsafe extern "C" fn(
        core: *mut ::std::os::raw::c_void,
        cmd: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int,
>;
pub type RCoreCmdF = ::std::option::Option<
    unsafe extern "C" fn(
        user: *mut ::std::os::raw::c_void,
        fmt: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int,
>;
pub type RCoreDebugBpHit = ::std::option::Option<
    unsafe extern "C" fn(
        core: *mut ::std::os::raw::c_void,
        bp: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int,
>;
pub type RCoreDebugSyscallHit =
    ::std::option::Option<unsafe extern "C" fn(core: *mut ::std::os::raw::c_void)>;
pub type RCoreCmdStr = ::std::option::Option<
    unsafe extern "C" fn(
        core: *mut ::std::os::raw::c_void,
        cmd: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char,
>;
pub type RCoreCmdStrF = ::std::option::Option<
    unsafe extern "C" fn(
        core: *mut ::std::os::raw::c_void,
        cmd: *const ::std::os::raw::c_char,
        ...
    ) -> *mut ::std::os::raw::c_char,
>;
pub type RCorePuts =
    ::std::option::Option<unsafe extern "C" fn(cmd: *const ::std::os::raw::c_char)>;
pub type RCoreSetArchBits = ::std::option::Option<
    unsafe extern "C" fn(
        core: *mut ::std::os::raw::c_void,
        arch: *const ::std::os::raw::c_char,
        bits: ::std::os::raw::c_int,
    ),
>;
pub type RCoreIsMapped = ::std::option::Option<
    unsafe extern "C" fn(
        core: *mut ::std::os::raw::c_void,
        addr: u64,
        perm: ::std::os::raw::c_int,
    ) -> bool,
>;
pub type RCoreDebugMapsSync =
    ::std::option::Option<unsafe extern "C" fn(core: *mut ::std::os::raw::c_void) -> bool>;
pub type RCoreGetName = ::std::option::Option<
    unsafe extern "C" fn(
        core: *mut ::std::os::raw::c_void,
        off: u64,
    ) -> *const ::std::os::raw::c_char,
>;
pub type RCoreGetNameDelta = ::std::option::Option<
    unsafe extern "C" fn(
        core: *mut ::std::os::raw::c_void,
        off: u64,
    ) -> *mut ::std::os::raw::c_char,
>;
pub type RCoreSeekArchBits =
    ::std::option::Option<unsafe extern "C" fn(core: *mut ::std::os::raw::c_void, addr: u64)>;
pub type RCoreConfigGetI = ::std::option::Option<
    unsafe extern "C" fn(
        core: *mut ::std::os::raw::c_void,
        key: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int,
>;
pub type RCoreConfigGet = ::std::option::Option<
    unsafe extern "C" fn(
        core: *mut ::std::os::raw::c_void,
        key: *const ::std::os::raw::c_char,
    ) -> *const ::std::os::raw::c_char,
>;
pub type RCoreNumGet = ::std::option::Option<
    unsafe extern "C" fn(
        core: *mut ::std::os::raw::c_void,
        str_: *const ::std::os::raw::c_char,
    ) -> u64,
>;
pub type RCorePJWithEncoding = ::std::option::Option<
    unsafe extern "C" fn(core: *mut ::std::os::raw::c_void) -> *mut ::std::os::raw::c_void,
>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_core_bind_t {
    pub core: *mut ::std::os::raw::c_void,
    pub cmd: RCoreCmd,
    pub cmdf: RCoreCmdF,
    pub cmdstr: RCoreCmdStr,
    pub cmdstrf: RCoreCmdStrF,
    pub puts: RCorePuts,
    pub bphit: RCoreDebugBpHit,
    pub syshit: RCoreDebugSyscallHit,
    pub setab: RCoreSetArchBits,
    pub getName: RCoreGetName,
    pub getNameDelta: RCoreGetNameDelta,
    pub archbits: RCoreSeekArchBits,
    pub cfggeti: RCoreConfigGetI,
    pub cfgGet: RCoreConfigGet,
    pub numGet: RCoreNumGet,
    pub isMapped: RCoreIsMapped,
    pub syncDebugMaps: RCoreDebugMapsSync,
    pub pjWithEncoding: RCorePJWithEncoding,
}
#[test]
fn bindgen_test_layout_r_core_bind_t() {
    assert_eq!(
        ::std::mem::size_of::<r_core_bind_t>(),
        144usize,
        concat!("Size of: ", stringify!(r_core_bind_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_core_bind_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_core_bind_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_core_bind_t>())).core as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_core_bind_t),
            "::",
            stringify!(core)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_core_bind_t>())).cmd as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_core_bind_t),
            "::",
            stringify!(cmd)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_core_bind_t>())).cmdf as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(r_core_bind_t),
            "::",
            stringify!(cmdf)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_core_bind_t>())).cmdstr as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(r_core_bind_t),
            "::",
            stringify!(cmdstr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_core_bind_t>())).cmdstrf as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(r_core_bind_t),
            "::",
            stringify!(cmdstrf)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_core_bind_t>())).puts as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(r_core_bind_t),
            "::",
            stringify!(puts)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_core_bind_t>())).bphit as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(r_core_bind_t),
            "::",
            stringify!(bphit)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_core_bind_t>())).syshit as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(r_core_bind_t),
            "::",
            stringify!(syshit)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_core_bind_t>())).setab as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(r_core_bind_t),
            "::",
            stringify!(setab)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_core_bind_t>())).getName as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(r_core_bind_t),
            "::",
            stringify!(getName)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_core_bind_t>())).getNameDelta as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(r_core_bind_t),
            "::",
            stringify!(getNameDelta)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_core_bind_t>())).archbits as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(r_core_bind_t),
            "::",
            stringify!(archbits)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_core_bind_t>())).cfggeti as *const _ as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(r_core_bind_t),
            "::",
            stringify!(cfggeti)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_core_bind_t>())).cfgGet as *const _ as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(r_core_bind_t),
            "::",
            stringify!(cfgGet)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_core_bind_t>())).numGet as *const _ as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(r_core_bind_t),
            "::",
            stringify!(numGet)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_core_bind_t>())).isMapped as *const _ as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(r_core_bind_t),
            "::",
            stringify!(isMapped)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_core_bind_t>())).syncDebugMaps as *const _ as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(r_core_bind_t),
            "::",
            stringify!(syncDebugMaps)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_core_bind_t>())).pjWithEncoding as *const _ as usize },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(r_core_bind_t),
            "::",
            stringify!(pjWithEncoding)
        )
    );
}
pub type RCoreBind = r_core_bind_t;
extern "C" {
    pub fn r_socket_version() -> *const ::std::os::raw::c_char;
}
pub type in_addr_t = u32;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct in_addr {
    pub s_addr: in_addr_t,
}
#[test]
fn bindgen_test_layout_in_addr() {
    assert_eq!(
        ::std::mem::size_of::<in_addr>(),
        4usize,
        concat!("Size of: ", stringify!(in_addr))
    );
    assert_eq!(
        ::std::mem::align_of::<in_addr>(),
        4usize,
        concat!("Alignment of ", stringify!(in_addr))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<in_addr>())).s_addr as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(in_addr),
            "::",
            stringify!(s_addr)
        )
    );
}
pub type in_port_t = u16;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct sockaddr_in {
    pub sin_family: sa_family_t,
    pub sin_port: in_port_t,
    pub sin_addr: in_addr,
    pub sin_zero: [::std::os::raw::c_uchar; 8usize],
}
#[test]
fn bindgen_test_layout_sockaddr_in() {
    assert_eq!(
        ::std::mem::size_of::<sockaddr_in>(),
        16usize,
        concat!("Size of: ", stringify!(sockaddr_in))
    );
    assert_eq!(
        ::std::mem::align_of::<sockaddr_in>(),
        4usize,
        concat!("Alignment of ", stringify!(sockaddr_in))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sockaddr_in>())).sin_family as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sockaddr_in),
            "::",
            stringify!(sin_family)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sockaddr_in>())).sin_port as *const _ as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(sockaddr_in),
            "::",
            stringify!(sin_port)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sockaddr_in>())).sin_addr as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(sockaddr_in),
            "::",
            stringify!(sin_addr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sockaddr_in>())).sin_zero as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(sockaddr_in),
            "::",
            stringify!(sin_zero)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_socket_t {
    pub fd: ::std::os::raw::c_int,
    pub is_ssl: bool,
    pub proto: ::std::os::raw::c_int,
    pub local: ::std::os::raw::c_int,
    pub port: ::std::os::raw::c_int,
    pub sa: sockaddr_in,
}
#[test]
fn bindgen_test_layout_r_socket_t() {
    assert_eq!(
        ::std::mem::size_of::<r_socket_t>(),
        36usize,
        concat!("Size of: ", stringify!(r_socket_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_socket_t>(),
        4usize,
        concat!("Alignment of ", stringify!(r_socket_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_socket_t>())).fd as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_socket_t),
            "::",
            stringify!(fd)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_socket_t>())).is_ssl as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(r_socket_t),
            "::",
            stringify!(is_ssl)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_socket_t>())).proto as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_socket_t),
            "::",
            stringify!(proto)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_socket_t>())).local as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(r_socket_t),
            "::",
            stringify!(local)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_socket_t>())).port as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(r_socket_t),
            "::",
            stringify!(port)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_socket_t>())).sa as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(r_socket_t),
            "::",
            stringify!(sa)
        )
    );
}
pub type RSocket = r_socket_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_socket_http_options {
    pub authtokens: *mut RList,
    pub accept_timeout: bool,
    pub timeout: ::std::os::raw::c_int,
    pub httpauth: bool,
}
#[test]
fn bindgen_test_layout_r_socket_http_options() {
    assert_eq!(
        ::std::mem::size_of::<r_socket_http_options>(),
        24usize,
        concat!("Size of: ", stringify!(r_socket_http_options))
    );
    assert_eq!(
        ::std::mem::align_of::<r_socket_http_options>(),
        8usize,
        concat!("Alignment of ", stringify!(r_socket_http_options))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_socket_http_options>())).authtokens as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_socket_http_options),
            "::",
            stringify!(authtokens)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_socket_http_options>())).accept_timeout as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_socket_http_options),
            "::",
            stringify!(accept_timeout)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_socket_http_options>())).timeout as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(r_socket_http_options),
            "::",
            stringify!(timeout)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_socket_http_options>())).httpauth as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(r_socket_http_options),
            "::",
            stringify!(httpauth)
        )
    );
}
pub type RSocketHTTPOptions = r_socket_http_options;
extern "C" {
    pub fn r_socket_new_from_fd(fd: ::std::os::raw::c_int) -> *mut RSocket;
}
extern "C" {
    pub fn r_socket_new(is_ssl: bool) -> *mut RSocket;
}
extern "C" {
    pub fn r_socket_spawn(
        s: *mut RSocket,
        cmd: *const ::std::os::raw::c_char,
        timeout: ::std::os::raw::c_uint,
    ) -> bool;
}
extern "C" {
    pub fn r_socket_connect(
        s: *mut RSocket,
        host: *const ::std::os::raw::c_char,
        port: *const ::std::os::raw::c_char,
        proto: ::std::os::raw::c_int,
        timeout: ::std::os::raw::c_uint,
    ) -> bool;
}
extern "C" {
    pub fn r_socket_connect_serial(
        sock: *mut RSocket,
        path: *const ::std::os::raw::c_char,
        speed: ::std::os::raw::c_int,
        parity: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_socket_listen(
        s: *mut RSocket,
        port: *const ::std::os::raw::c_char,
        certfile: *const ::std::os::raw::c_char,
    ) -> bool;
}
extern "C" {
    pub fn r_socket_port_by_name(name: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_socket_close_fd(s: *mut RSocket) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_socket_close(s: *mut RSocket) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_socket_free(s: *mut RSocket) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_socket_accept(s: *mut RSocket) -> *mut RSocket;
}
extern "C" {
    pub fn r_socket_accept_timeout(
        s: *mut RSocket,
        timeout: ::std::os::raw::c_uint,
    ) -> *mut RSocket;
}
extern "C" {
    pub fn r_socket_block_time(
        s: *mut RSocket,
        block: bool,
        sec: ::std::os::raw::c_int,
        usec: ::std::os::raw::c_int,
    ) -> bool;
}
extern "C" {
    pub fn r_socket_flush(s: *mut RSocket) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_socket_ready(
        s: *mut RSocket,
        secs: ::std::os::raw::c_int,
        usecs: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_socket_to_string(s: *mut RSocket) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_socket_write(
        s: *mut RSocket,
        buf: *const ::std::os::raw::c_void,
        len: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_socket_puts(
        s: *mut RSocket,
        buf: *mut ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_socket_printf(s: *mut RSocket, fmt: *const ::std::os::raw::c_char, ...);
}
extern "C" {
    pub fn r_socket_read(
        s: *mut RSocket,
        read: *mut u8,
        len: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_socket_read_block(
        s: *mut RSocket,
        buf: *mut ::std::os::raw::c_uchar,
        len: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_socket_gets(
        s: *mut RSocket,
        buf: *mut ::std::os::raw::c_char,
        size: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_socket_slurp(s: *mut RSocket, len: *mut ::std::os::raw::c_int) -> *mut u8;
}
extern "C" {
    pub fn r_socket_is_connected(arg1: *mut RSocket) -> bool;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_socket_proc_t {
    pub fd0: [::std::os::raw::c_int; 2usize],
    pub fd1: [::std::os::raw::c_int; 2usize],
    pub pid: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_r_socket_proc_t() {
    assert_eq!(
        ::std::mem::size_of::<r_socket_proc_t>(),
        20usize,
        concat!("Size of: ", stringify!(r_socket_proc_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_socket_proc_t>(),
        4usize,
        concat!("Alignment of ", stringify!(r_socket_proc_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_socket_proc_t>())).fd0 as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_socket_proc_t),
            "::",
            stringify!(fd0)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_socket_proc_t>())).fd1 as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_socket_proc_t),
            "::",
            stringify!(fd1)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_socket_proc_t>())).pid as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(r_socket_proc_t),
            "::",
            stringify!(pid)
        )
    );
}
pub type RSocketProc = r_socket_proc_t;
extern "C" {
    pub fn r_socket_proc_open(argv: *const *mut ::std::os::raw::c_char) -> *mut RSocketProc;
}
extern "C" {
    pub fn r_socket_proc_close(sp: *mut RSocketProc) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_socket_proc_read(
        sp: *mut RSocketProc,
        buf: *mut ::std::os::raw::c_uchar,
        len: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_socket_proc_gets(
        sp: *mut RSocketProc,
        buf: *mut ::std::os::raw::c_char,
        size: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_socket_proc_write(
        sp: *mut RSocketProc,
        buf: *mut ::std::os::raw::c_void,
        len: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_socket_proc_printf(sp: *mut RSocketProc, fmt: *const ::std::os::raw::c_char, ...);
}
extern "C" {
    pub fn r_socket_proc_ready(
        sp: *mut RSocketProc,
        secs: ::std::os::raw::c_int,
        usecs: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_socket_http_get(
        url: *const ::std::os::raw::c_char,
        code: *mut ::std::os::raw::c_int,
        rlen: *mut ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_socket_http_post(
        url: *const ::std::os::raw::c_char,
        data: *const ::std::os::raw::c_char,
        code: *mut ::std::os::raw::c_int,
        rlen: *mut ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_socket_http_server_set_breaked(b: *mut bool);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_socket_http_request {
    pub s: *mut RSocket,
    pub path: *mut ::std::os::raw::c_char,
    pub host: *mut ::std::os::raw::c_char,
    pub agent: *mut ::std::os::raw::c_char,
    pub method: *mut ::std::os::raw::c_char,
    pub referer: *mut ::std::os::raw::c_char,
    pub data: *mut u8,
    pub data_length: ::std::os::raw::c_int,
    pub auth: bool,
}
#[test]
fn bindgen_test_layout_r_socket_http_request() {
    assert_eq!(
        ::std::mem::size_of::<r_socket_http_request>(),
        64usize,
        concat!("Size of: ", stringify!(r_socket_http_request))
    );
    assert_eq!(
        ::std::mem::align_of::<r_socket_http_request>(),
        8usize,
        concat!("Alignment of ", stringify!(r_socket_http_request))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_socket_http_request>())).s as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_socket_http_request),
            "::",
            stringify!(s)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_socket_http_request>())).path as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_socket_http_request),
            "::",
            stringify!(path)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_socket_http_request>())).host as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(r_socket_http_request),
            "::",
            stringify!(host)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_socket_http_request>())).agent as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(r_socket_http_request),
            "::",
            stringify!(agent)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_socket_http_request>())).method as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(r_socket_http_request),
            "::",
            stringify!(method)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_socket_http_request>())).referer as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(r_socket_http_request),
            "::",
            stringify!(referer)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_socket_http_request>())).data as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(r_socket_http_request),
            "::",
            stringify!(data)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_socket_http_request>())).data_length as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(r_socket_http_request),
            "::",
            stringify!(data_length)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_socket_http_request>())).auth as *const _ as usize },
        60usize,
        concat!(
            "Offset of field: ",
            stringify!(r_socket_http_request),
            "::",
            stringify!(auth)
        )
    );
}
pub type RSocketHTTPRequest = r_socket_http_request;
extern "C" {
    pub fn r_socket_http_accept(
        s: *mut RSocket,
        so: *mut RSocketHTTPOptions,
    ) -> *mut RSocketHTTPRequest;
}
extern "C" {
    pub fn r_socket_http_response(
        rs: *mut RSocketHTTPRequest,
        code: ::std::os::raw::c_int,
        out: *const ::std::os::raw::c_char,
        x: ::std::os::raw::c_int,
        headers: *const ::std::os::raw::c_char,
    );
}
extern "C" {
    pub fn r_socket_http_close(rs: *mut RSocketHTTPRequest);
}
extern "C" {
    pub fn r_socket_http_handle_upload(
        str_: *const u8,
        len: ::std::os::raw::c_int,
        olen: *mut ::std::os::raw::c_int,
    ) -> *mut u8;
}
extern "C" {
    pub fn r_socket_http_free(rs: *mut RSocketHTTPRequest);
}
pub type rap_server_open = ::std::option::Option<
    unsafe extern "C" fn(
        user: *mut ::std::os::raw::c_void,
        file: *const ::std::os::raw::c_char,
        flg: ::std::os::raw::c_int,
        mode: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int,
>;
pub type rap_server_seek = ::std::option::Option<
    unsafe extern "C" fn(
        user: *mut ::std::os::raw::c_void,
        offset: u64,
        whence: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int,
>;
pub type rap_server_read = ::std::option::Option<
    unsafe extern "C" fn(
        user: *mut ::std::os::raw::c_void,
        buf: *mut u8,
        len: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int,
>;
pub type rap_server_write = ::std::option::Option<
    unsafe extern "C" fn(
        user: *mut ::std::os::raw::c_void,
        buf: *mut u8,
        len: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int,
>;
pub type rap_server_cmd = ::std::option::Option<
    unsafe extern "C" fn(
        user: *mut ::std::os::raw::c_void,
        command: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char,
>;
pub type rap_server_close = ::std::option::Option<
    unsafe extern "C" fn(
        user: *mut ::std::os::raw::c_void,
        fd: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int,
>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_socket_rap_server_t {
    pub fd: *mut RSocket,
    pub port: *mut ::std::os::raw::c_char,
    pub buf: [u8; 4128usize],
    pub open: rap_server_open,
    pub seek: rap_server_seek,
    pub read: rap_server_read,
    pub write: rap_server_write,
    pub system: rap_server_cmd,
    pub cmd: rap_server_cmd,
    pub close: rap_server_close,
    pub user: *mut ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout_r_socket_rap_server_t() {
    assert_eq!(
        ::std::mem::size_of::<r_socket_rap_server_t>(),
        4208usize,
        concat!("Size of: ", stringify!(r_socket_rap_server_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_socket_rap_server_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_socket_rap_server_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_socket_rap_server_t>())).fd as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_socket_rap_server_t),
            "::",
            stringify!(fd)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_socket_rap_server_t>())).port as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_socket_rap_server_t),
            "::",
            stringify!(port)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_socket_rap_server_t>())).buf as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(r_socket_rap_server_t),
            "::",
            stringify!(buf)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_socket_rap_server_t>())).open as *const _ as usize },
        4144usize,
        concat!(
            "Offset of field: ",
            stringify!(r_socket_rap_server_t),
            "::",
            stringify!(open)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_socket_rap_server_t>())).seek as *const _ as usize },
        4152usize,
        concat!(
            "Offset of field: ",
            stringify!(r_socket_rap_server_t),
            "::",
            stringify!(seek)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_socket_rap_server_t>())).read as *const _ as usize },
        4160usize,
        concat!(
            "Offset of field: ",
            stringify!(r_socket_rap_server_t),
            "::",
            stringify!(read)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_socket_rap_server_t>())).write as *const _ as usize },
        4168usize,
        concat!(
            "Offset of field: ",
            stringify!(r_socket_rap_server_t),
            "::",
            stringify!(write)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_socket_rap_server_t>())).system as *const _ as usize },
        4176usize,
        concat!(
            "Offset of field: ",
            stringify!(r_socket_rap_server_t),
            "::",
            stringify!(system)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_socket_rap_server_t>())).cmd as *const _ as usize },
        4184usize,
        concat!(
            "Offset of field: ",
            stringify!(r_socket_rap_server_t),
            "::",
            stringify!(cmd)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_socket_rap_server_t>())).close as *const _ as usize },
        4192usize,
        concat!(
            "Offset of field: ",
            stringify!(r_socket_rap_server_t),
            "::",
            stringify!(close)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_socket_rap_server_t>())).user as *const _ as usize },
        4200usize,
        concat!(
            "Offset of field: ",
            stringify!(r_socket_rap_server_t),
            "::",
            stringify!(user)
        )
    );
}
pub type RSocketRapServer = r_socket_rap_server_t;
extern "C" {
    pub fn r_socket_rap_server_new(
        is_ssl: bool,
        port: *const ::std::os::raw::c_char,
    ) -> *mut RSocketRapServer;
}
extern "C" {
    pub fn r_socket_rap_server_create(
        pathname: *const ::std::os::raw::c_char,
    ) -> *mut RSocketRapServer;
}
extern "C" {
    pub fn r_socket_rap_server_free(rap_s: *mut RSocketRapServer);
}
extern "C" {
    pub fn r_socket_rap_server_listen(
        rap_s: *mut RSocketRapServer,
        certfile: *const ::std::os::raw::c_char,
    ) -> bool;
}
extern "C" {
    pub fn r_socket_rap_server_accept(rap_s: *mut RSocketRapServer) -> *mut RSocket;
}
extern "C" {
    pub fn r_socket_rap_server_continue(rap_s: *mut RSocketRapServer) -> bool;
}
extern "C" {
    pub fn r_socket_rap_client_open(
        s: *mut RSocket,
        file: *const ::std::os::raw::c_char,
        rw: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_socket_rap_client_command(
        s: *mut RSocket,
        cmd: *const ::std::os::raw::c_char,
        c: *mut RCoreBind,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_socket_rap_client_write(
        s: *mut RSocket,
        buf: *const u8,
        count: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_socket_rap_client_read(
        s: *mut RSocket,
        buf: *mut u8,
        count: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_socket_rap_client_seek(
        s: *mut RSocket,
        offset: u64,
        whence: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_run_profile_t {
    pub _args: [*mut ::std::os::raw::c_char; 512usize],
    pub _argc: ::std::os::raw::c_int,
    pub _daemon: bool,
    pub _system: *mut ::std::os::raw::c_char,
    pub _program: *mut ::std::os::raw::c_char,
    pub _runlib: *mut ::std::os::raw::c_char,
    pub _runlib_fcn: *mut ::std::os::raw::c_char,
    pub _stdio: *mut ::std::os::raw::c_char,
    pub _stdin: *mut ::std::os::raw::c_char,
    pub _stdout: *mut ::std::os::raw::c_char,
    pub _stderr: *mut ::std::os::raw::c_char,
    pub _chgdir: *mut ::std::os::raw::c_char,
    pub _chroot: *mut ::std::os::raw::c_char,
    pub _libpath: *mut ::std::os::raw::c_char,
    pub _preload: *mut ::std::os::raw::c_char,
    pub _bits: ::std::os::raw::c_int,
    pub _time: bool,
    pub _pid: ::std::os::raw::c_int,
    pub _pidfile: *mut ::std::os::raw::c_char,
    pub _r2preload: ::std::os::raw::c_int,
    pub _docore: ::std::os::raw::c_int,
    pub _dofork: ::std::os::raw::c_int,
    pub _dodebug: ::std::os::raw::c_int,
    pub _aslr: ::std::os::raw::c_int,
    pub _maxstack: ::std::os::raw::c_int,
    pub _maxproc: ::std::os::raw::c_int,
    pub _maxfd: ::std::os::raw::c_int,
    pub _r2sleep: ::std::os::raw::c_int,
    pub _execve: ::std::os::raw::c_int,
    pub _setuid: *mut ::std::os::raw::c_char,
    pub _seteuid: *mut ::std::os::raw::c_char,
    pub _setgid: *mut ::std::os::raw::c_char,
    pub _setegid: *mut ::std::os::raw::c_char,
    pub _input: *mut ::std::os::raw::c_char,
    pub _connect: *mut ::std::os::raw::c_char,
    pub _listen: *mut ::std::os::raw::c_char,
    pub _pty: ::std::os::raw::c_int,
    pub _timeout: ::std::os::raw::c_int,
    pub _timeout_sig: ::std::os::raw::c_int,
    pub _nice: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_r_run_profile_t() {
    assert_eq!(
        ::std::mem::size_of::<r_run_profile_t>(),
        4336usize,
        concat!("Size of: ", stringify!(r_run_profile_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_run_profile_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_run_profile_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_run_profile_t>()))._args as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_run_profile_t),
            "::",
            stringify!(_args)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_run_profile_t>()))._argc as *const _ as usize },
        4096usize,
        concat!(
            "Offset of field: ",
            stringify!(r_run_profile_t),
            "::",
            stringify!(_argc)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_run_profile_t>()))._daemon as *const _ as usize },
        4100usize,
        concat!(
            "Offset of field: ",
            stringify!(r_run_profile_t),
            "::",
            stringify!(_daemon)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_run_profile_t>()))._system as *const _ as usize },
        4104usize,
        concat!(
            "Offset of field: ",
            stringify!(r_run_profile_t),
            "::",
            stringify!(_system)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_run_profile_t>()))._program as *const _ as usize },
        4112usize,
        concat!(
            "Offset of field: ",
            stringify!(r_run_profile_t),
            "::",
            stringify!(_program)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_run_profile_t>()))._runlib as *const _ as usize },
        4120usize,
        concat!(
            "Offset of field: ",
            stringify!(r_run_profile_t),
            "::",
            stringify!(_runlib)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_run_profile_t>()))._runlib_fcn as *const _ as usize },
        4128usize,
        concat!(
            "Offset of field: ",
            stringify!(r_run_profile_t),
            "::",
            stringify!(_runlib_fcn)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_run_profile_t>()))._stdio as *const _ as usize },
        4136usize,
        concat!(
            "Offset of field: ",
            stringify!(r_run_profile_t),
            "::",
            stringify!(_stdio)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_run_profile_t>()))._stdin as *const _ as usize },
        4144usize,
        concat!(
            "Offset of field: ",
            stringify!(r_run_profile_t),
            "::",
            stringify!(_stdin)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_run_profile_t>()))._stdout as *const _ as usize },
        4152usize,
        concat!(
            "Offset of field: ",
            stringify!(r_run_profile_t),
            "::",
            stringify!(_stdout)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_run_profile_t>()))._stderr as *const _ as usize },
        4160usize,
        concat!(
            "Offset of field: ",
            stringify!(r_run_profile_t),
            "::",
            stringify!(_stderr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_run_profile_t>()))._chgdir as *const _ as usize },
        4168usize,
        concat!(
            "Offset of field: ",
            stringify!(r_run_profile_t),
            "::",
            stringify!(_chgdir)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_run_profile_t>()))._chroot as *const _ as usize },
        4176usize,
        concat!(
            "Offset of field: ",
            stringify!(r_run_profile_t),
            "::",
            stringify!(_chroot)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_run_profile_t>()))._libpath as *const _ as usize },
        4184usize,
        concat!(
            "Offset of field: ",
            stringify!(r_run_profile_t),
            "::",
            stringify!(_libpath)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_run_profile_t>()))._preload as *const _ as usize },
        4192usize,
        concat!(
            "Offset of field: ",
            stringify!(r_run_profile_t),
            "::",
            stringify!(_preload)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_run_profile_t>()))._bits as *const _ as usize },
        4200usize,
        concat!(
            "Offset of field: ",
            stringify!(r_run_profile_t),
            "::",
            stringify!(_bits)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_run_profile_t>()))._time as *const _ as usize },
        4204usize,
        concat!(
            "Offset of field: ",
            stringify!(r_run_profile_t),
            "::",
            stringify!(_time)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_run_profile_t>()))._pid as *const _ as usize },
        4208usize,
        concat!(
            "Offset of field: ",
            stringify!(r_run_profile_t),
            "::",
            stringify!(_pid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_run_profile_t>()))._pidfile as *const _ as usize },
        4216usize,
        concat!(
            "Offset of field: ",
            stringify!(r_run_profile_t),
            "::",
            stringify!(_pidfile)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_run_profile_t>()))._r2preload as *const _ as usize },
        4224usize,
        concat!(
            "Offset of field: ",
            stringify!(r_run_profile_t),
            "::",
            stringify!(_r2preload)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_run_profile_t>()))._docore as *const _ as usize },
        4228usize,
        concat!(
            "Offset of field: ",
            stringify!(r_run_profile_t),
            "::",
            stringify!(_docore)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_run_profile_t>()))._dofork as *const _ as usize },
        4232usize,
        concat!(
            "Offset of field: ",
            stringify!(r_run_profile_t),
            "::",
            stringify!(_dofork)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_run_profile_t>()))._dodebug as *const _ as usize },
        4236usize,
        concat!(
            "Offset of field: ",
            stringify!(r_run_profile_t),
            "::",
            stringify!(_dodebug)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_run_profile_t>()))._aslr as *const _ as usize },
        4240usize,
        concat!(
            "Offset of field: ",
            stringify!(r_run_profile_t),
            "::",
            stringify!(_aslr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_run_profile_t>()))._maxstack as *const _ as usize },
        4244usize,
        concat!(
            "Offset of field: ",
            stringify!(r_run_profile_t),
            "::",
            stringify!(_maxstack)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_run_profile_t>()))._maxproc as *const _ as usize },
        4248usize,
        concat!(
            "Offset of field: ",
            stringify!(r_run_profile_t),
            "::",
            stringify!(_maxproc)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_run_profile_t>()))._maxfd as *const _ as usize },
        4252usize,
        concat!(
            "Offset of field: ",
            stringify!(r_run_profile_t),
            "::",
            stringify!(_maxfd)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_run_profile_t>()))._r2sleep as *const _ as usize },
        4256usize,
        concat!(
            "Offset of field: ",
            stringify!(r_run_profile_t),
            "::",
            stringify!(_r2sleep)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_run_profile_t>()))._execve as *const _ as usize },
        4260usize,
        concat!(
            "Offset of field: ",
            stringify!(r_run_profile_t),
            "::",
            stringify!(_execve)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_run_profile_t>()))._setuid as *const _ as usize },
        4264usize,
        concat!(
            "Offset of field: ",
            stringify!(r_run_profile_t),
            "::",
            stringify!(_setuid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_run_profile_t>()))._seteuid as *const _ as usize },
        4272usize,
        concat!(
            "Offset of field: ",
            stringify!(r_run_profile_t),
            "::",
            stringify!(_seteuid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_run_profile_t>()))._setgid as *const _ as usize },
        4280usize,
        concat!(
            "Offset of field: ",
            stringify!(r_run_profile_t),
            "::",
            stringify!(_setgid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_run_profile_t>()))._setegid as *const _ as usize },
        4288usize,
        concat!(
            "Offset of field: ",
            stringify!(r_run_profile_t),
            "::",
            stringify!(_setegid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_run_profile_t>()))._input as *const _ as usize },
        4296usize,
        concat!(
            "Offset of field: ",
            stringify!(r_run_profile_t),
            "::",
            stringify!(_input)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_run_profile_t>()))._connect as *const _ as usize },
        4304usize,
        concat!(
            "Offset of field: ",
            stringify!(r_run_profile_t),
            "::",
            stringify!(_connect)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_run_profile_t>()))._listen as *const _ as usize },
        4312usize,
        concat!(
            "Offset of field: ",
            stringify!(r_run_profile_t),
            "::",
            stringify!(_listen)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_run_profile_t>()))._pty as *const _ as usize },
        4320usize,
        concat!(
            "Offset of field: ",
            stringify!(r_run_profile_t),
            "::",
            stringify!(_pty)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_run_profile_t>()))._timeout as *const _ as usize },
        4324usize,
        concat!(
            "Offset of field: ",
            stringify!(r_run_profile_t),
            "::",
            stringify!(_timeout)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_run_profile_t>()))._timeout_sig as *const _ as usize },
        4328usize,
        concat!(
            "Offset of field: ",
            stringify!(r_run_profile_t),
            "::",
            stringify!(_timeout_sig)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_run_profile_t>()))._nice as *const _ as usize },
        4332usize,
        concat!(
            "Offset of field: ",
            stringify!(r_run_profile_t),
            "::",
            stringify!(_nice)
        )
    );
}
pub type RRunProfile = r_run_profile_t;
extern "C" {
    pub fn r_run_new(str_: *const ::std::os::raw::c_char) -> *mut RRunProfile;
}
extern "C" {
    pub fn r_run_parse(pf: *mut RRunProfile, profile: *const ::std::os::raw::c_char) -> bool;
}
extern "C" {
    pub fn r_run_free(r: *mut RRunProfile);
}
extern "C" {
    pub fn r_run_parseline(p: *mut RRunProfile, b: *const ::std::os::raw::c_char) -> bool;
}
extern "C" {
    pub fn r_run_help() -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_run_config_env(p: *mut RRunProfile) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_run_start(p: *mut RRunProfile) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_run_reset(p: *mut RRunProfile);
}
extern "C" {
    pub fn r_run_parsefile(p: *mut RRunProfile, b: *const ::std::os::raw::c_char) -> bool;
}
extern "C" {
    pub fn r_run_get_environ_profile(
        env: *mut *mut ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_magic_version() -> *const ::std::os::raw::c_char;
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union VALUETYPE {
    pub b: u8,
    pub h: u16,
    pub l: u32,
    pub q: u64,
    pub hs: [u8; 2usize],
    pub hl: [u8; 4usize],
    pub hq: [u8; 8usize],
    pub s: [::std::os::raw::c_char; 32usize],
    pub f: f32,
    pub d: f64,
}
#[test]
fn bindgen_test_layout_VALUETYPE() {
    assert_eq!(
        ::std::mem::size_of::<VALUETYPE>(),
        32usize,
        concat!("Size of: ", stringify!(VALUETYPE))
    );
    assert_eq!(
        ::std::mem::align_of::<VALUETYPE>(),
        8usize,
        concat!("Alignment of ", stringify!(VALUETYPE))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VALUETYPE>())).b as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VALUETYPE),
            "::",
            stringify!(b)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VALUETYPE>())).h as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VALUETYPE),
            "::",
            stringify!(h)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VALUETYPE>())).l as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VALUETYPE),
            "::",
            stringify!(l)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VALUETYPE>())).q as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VALUETYPE),
            "::",
            stringify!(q)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VALUETYPE>())).hs as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VALUETYPE),
            "::",
            stringify!(hs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VALUETYPE>())).hl as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VALUETYPE),
            "::",
            stringify!(hl)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VALUETYPE>())).hq as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VALUETYPE),
            "::",
            stringify!(hq)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VALUETYPE>())).s as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VALUETYPE),
            "::",
            stringify!(s)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VALUETYPE>())).f as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VALUETYPE),
            "::",
            stringify!(f)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VALUETYPE>())).d as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VALUETYPE),
            "::",
            stringify!(d)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct r_magic {
    pub cont_level: u16,
    pub flag: u8,
    pub dummy1: u8,
    pub reln: u8,
    pub vallen: u8,
    pub type_: u8,
    pub in_type: u8,
    pub in_op: u8,
    pub mask_op: u8,
    pub cond: u8,
    pub dummy2: u8,
    pub offset: u32,
    pub in_offset: u32,
    pub lineno: u32,
    pub _u: r_magic__bindgen_ty_1,
    pub value: VALUETYPE,
    pub desc: [::std::os::raw::c_char; 64usize],
    pub mimetype: [::std::os::raw::c_char; 64usize],
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union r_magic__bindgen_ty_1 {
    pub _mask: u64,
    pub _s: r_magic__bindgen_ty_1__bindgen_ty_1,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_magic__bindgen_ty_1__bindgen_ty_1 {
    pub _count: u32,
    pub _flags: u32,
}
#[test]
fn bindgen_test_layout_r_magic__bindgen_ty_1__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<r_magic__bindgen_ty_1__bindgen_ty_1>(),
        8usize,
        concat!("Size of: ", stringify!(r_magic__bindgen_ty_1__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<r_magic__bindgen_ty_1__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(r_magic__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_magic__bindgen_ty_1__bindgen_ty_1>()))._count as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_magic__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(_count)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_magic__bindgen_ty_1__bindgen_ty_1>()))._flags as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(r_magic__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(_flags)
        )
    );
}
#[test]
fn bindgen_test_layout_r_magic__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<r_magic__bindgen_ty_1>(),
        8usize,
        concat!("Size of: ", stringify!(r_magic__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<r_magic__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(r_magic__bindgen_ty_1))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_magic__bindgen_ty_1>()))._mask as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_magic__bindgen_ty_1),
            "::",
            stringify!(_mask)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_magic__bindgen_ty_1>()))._s as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_magic__bindgen_ty_1),
            "::",
            stringify!(_s)
        )
    );
}
#[test]
fn bindgen_test_layout_r_magic() {
    assert_eq!(
        ::std::mem::size_of::<r_magic>(),
        192usize,
        concat!("Size of: ", stringify!(r_magic))
    );
    assert_eq!(
        ::std::mem::align_of::<r_magic>(),
        8usize,
        concat!("Alignment of ", stringify!(r_magic))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_magic>())).cont_level as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_magic),
            "::",
            stringify!(cont_level)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_magic>())).flag as *const _ as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(r_magic),
            "::",
            stringify!(flag)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_magic>())).dummy1 as *const _ as usize },
        3usize,
        concat!(
            "Offset of field: ",
            stringify!(r_magic),
            "::",
            stringify!(dummy1)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_magic>())).reln as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(r_magic),
            "::",
            stringify!(reln)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_magic>())).vallen as *const _ as usize },
        5usize,
        concat!(
            "Offset of field: ",
            stringify!(r_magic),
            "::",
            stringify!(vallen)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_magic>())).type_ as *const _ as usize },
        6usize,
        concat!(
            "Offset of field: ",
            stringify!(r_magic),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_magic>())).in_type as *const _ as usize },
        7usize,
        concat!(
            "Offset of field: ",
            stringify!(r_magic),
            "::",
            stringify!(in_type)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_magic>())).in_op as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_magic),
            "::",
            stringify!(in_op)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_magic>())).mask_op as *const _ as usize },
        9usize,
        concat!(
            "Offset of field: ",
            stringify!(r_magic),
            "::",
            stringify!(mask_op)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_magic>())).cond as *const _ as usize },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(r_magic),
            "::",
            stringify!(cond)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_magic>())).dummy2 as *const _ as usize },
        11usize,
        concat!(
            "Offset of field: ",
            stringify!(r_magic),
            "::",
            stringify!(dummy2)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_magic>())).offset as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(r_magic),
            "::",
            stringify!(offset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_magic>())).in_offset as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(r_magic),
            "::",
            stringify!(in_offset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_magic>())).lineno as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(r_magic),
            "::",
            stringify!(lineno)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_magic>()))._u as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(r_magic),
            "::",
            stringify!(_u)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_magic>())).value as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(r_magic),
            "::",
            stringify!(value)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_magic>())).desc as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(r_magic),
            "::",
            stringify!(desc)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_magic>())).mimetype as *const _ as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(r_magic),
            "::",
            stringify!(mimetype)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct mlist {
    pub magic: *mut r_magic,
    pub nmagic: u32,
    pub mapped: ::std::os::raw::c_int,
    pub next: *mut mlist,
    pub prev: *mut mlist,
}
#[test]
fn bindgen_test_layout_mlist() {
    assert_eq!(
        ::std::mem::size_of::<mlist>(),
        32usize,
        concat!("Size of: ", stringify!(mlist))
    );
    assert_eq!(
        ::std::mem::align_of::<mlist>(),
        8usize,
        concat!("Alignment of ", stringify!(mlist))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<mlist>())).magic as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(mlist),
            "::",
            stringify!(magic)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<mlist>())).nmagic as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(mlist),
            "::",
            stringify!(nmagic)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<mlist>())).mapped as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(mlist),
            "::",
            stringify!(mapped)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<mlist>())).next as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(mlist),
            "::",
            stringify!(next)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<mlist>())).prev as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(mlist),
            "::",
            stringify!(prev)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct r_magic_set {
    pub mlist: *mut mlist,
    pub c: r_magic_set_cont,
    pub o: r_magic_set_out,
    pub offset: u32,
    pub error: ::std::os::raw::c_int,
    pub flags: ::std::os::raw::c_int,
    pub haderr: ::std::os::raw::c_int,
    pub file: *const ::std::os::raw::c_char,
    pub line: size_t,
    pub search: r_magic_set__bindgen_ty_1,
    pub ms_value: VALUETYPE,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_magic_set_cont {
    pub len: size_t,
    pub li: *mut r_magic_set_cont_level_info,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_magic_set_cont_level_info {
    pub off: i32,
    pub got_match: ::std::os::raw::c_int,
    pub last_match: ::std::os::raw::c_int,
    pub last_cond: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_r_magic_set_cont_level_info() {
    assert_eq!(
        ::std::mem::size_of::<r_magic_set_cont_level_info>(),
        16usize,
        concat!("Size of: ", stringify!(r_magic_set_cont_level_info))
    );
    assert_eq!(
        ::std::mem::align_of::<r_magic_set_cont_level_info>(),
        4usize,
        concat!("Alignment of ", stringify!(r_magic_set_cont_level_info))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_magic_set_cont_level_info>())).off as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_magic_set_cont_level_info),
            "::",
            stringify!(off)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_magic_set_cont_level_info>())).got_match as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(r_magic_set_cont_level_info),
            "::",
            stringify!(got_match)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_magic_set_cont_level_info>())).last_match as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_magic_set_cont_level_info),
            "::",
            stringify!(last_match)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_magic_set_cont_level_info>())).last_cond as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(r_magic_set_cont_level_info),
            "::",
            stringify!(last_cond)
        )
    );
}
#[test]
fn bindgen_test_layout_r_magic_set_cont() {
    assert_eq!(
        ::std::mem::size_of::<r_magic_set_cont>(),
        16usize,
        concat!("Size of: ", stringify!(r_magic_set_cont))
    );
    assert_eq!(
        ::std::mem::align_of::<r_magic_set_cont>(),
        8usize,
        concat!("Alignment of ", stringify!(r_magic_set_cont))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_magic_set_cont>())).len as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_magic_set_cont),
            "::",
            stringify!(len)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_magic_set_cont>())).li as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_magic_set_cont),
            "::",
            stringify!(li)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_magic_set_out {
    pub buf: *mut ::std::os::raw::c_char,
    pub pbuf: *mut ::std::os::raw::c_char,
}
#[test]
fn bindgen_test_layout_r_magic_set_out() {
    assert_eq!(
        ::std::mem::size_of::<r_magic_set_out>(),
        16usize,
        concat!("Size of: ", stringify!(r_magic_set_out))
    );
    assert_eq!(
        ::std::mem::align_of::<r_magic_set_out>(),
        8usize,
        concat!("Alignment of ", stringify!(r_magic_set_out))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_magic_set_out>())).buf as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_magic_set_out),
            "::",
            stringify!(buf)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_magic_set_out>())).pbuf as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_magic_set_out),
            "::",
            stringify!(pbuf)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_magic_set__bindgen_ty_1 {
    pub s: *const ::std::os::raw::c_char,
    pub s_len: size_t,
    pub offset: size_t,
    pub rm_len: size_t,
}
#[test]
fn bindgen_test_layout_r_magic_set__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<r_magic_set__bindgen_ty_1>(),
        32usize,
        concat!("Size of: ", stringify!(r_magic_set__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<r_magic_set__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(r_magic_set__bindgen_ty_1))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_magic_set__bindgen_ty_1>())).s as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_magic_set__bindgen_ty_1),
            "::",
            stringify!(s)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_magic_set__bindgen_ty_1>())).s_len as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_magic_set__bindgen_ty_1),
            "::",
            stringify!(s_len)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_magic_set__bindgen_ty_1>())).offset as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(r_magic_set__bindgen_ty_1),
            "::",
            stringify!(offset)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_magic_set__bindgen_ty_1>())).rm_len as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(r_magic_set__bindgen_ty_1),
            "::",
            stringify!(rm_len)
        )
    );
}
#[test]
fn bindgen_test_layout_r_magic_set() {
    assert_eq!(
        ::std::mem::size_of::<r_magic_set>(),
        136usize,
        concat!("Size of: ", stringify!(r_magic_set))
    );
    assert_eq!(
        ::std::mem::align_of::<r_magic_set>(),
        8usize,
        concat!("Alignment of ", stringify!(r_magic_set))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_magic_set>())).mlist as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_magic_set),
            "::",
            stringify!(mlist)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_magic_set>())).c as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_magic_set),
            "::",
            stringify!(c)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_magic_set>())).o as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(r_magic_set),
            "::",
            stringify!(o)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_magic_set>())).offset as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(r_magic_set),
            "::",
            stringify!(offset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_magic_set>())).error as *const _ as usize },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(r_magic_set),
            "::",
            stringify!(error)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_magic_set>())).flags as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(r_magic_set),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_magic_set>())).haderr as *const _ as usize },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(r_magic_set),
            "::",
            stringify!(haderr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_magic_set>())).file as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(r_magic_set),
            "::",
            stringify!(file)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_magic_set>())).line as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(r_magic_set),
            "::",
            stringify!(line)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_magic_set>())).search as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(r_magic_set),
            "::",
            stringify!(search)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_magic_set>())).ms_value as *const _ as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(r_magic_set),
            "::",
            stringify!(ms_value)
        )
    );
}
pub type RMagic = r_magic_set;
extern "C" {
    pub fn r_magic_new(flags: ::std::os::raw::c_int) -> *mut RMagic;
}
extern "C" {
    pub fn r_magic_free(arg1: *mut RMagic);
}
extern "C" {
    pub fn r_magic_file(
        arg1: *mut RMagic,
        arg2: *const ::std::os::raw::c_char,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_magic_descriptor(
        arg1: *mut RMagic,
        arg2: ::std::os::raw::c_int,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_magic_buffer(
        arg1: *mut RMagic,
        arg2: *const ::std::os::raw::c_void,
        arg3: size_t,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_magic_error(arg1: *mut RMagic) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_magic_setflags(arg1: *mut RMagic, arg2: ::std::os::raw::c_int);
}
extern "C" {
    pub fn r_magic_load(arg1: *mut RMagic, arg2: *const ::std::os::raw::c_char) -> bool;
}
extern "C" {
    pub fn r_magic_load_buffer(arg1: *mut RMagic, arg2: *const u8, arg3: size_t) -> bool;
}
extern "C" {
    pub fn r_magic_compile(arg1: *mut RMagic, arg2: *const ::std::os::raw::c_char) -> bool;
}
extern "C" {
    pub fn r_magic_check(arg1: *mut RMagic, arg2: *const ::std::os::raw::c_char) -> bool;
}
extern "C" {
    pub fn r_magic_errno(arg1: *mut RMagic) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_ascii_node_t {
    pub gnode: *mut RGraphNode,
    pub title: *mut ::std::os::raw::c_char,
    pub body: *mut ::std::os::raw::c_char,
    pub color: *mut ::std::os::raw::c_char,
    pub x: ::std::os::raw::c_int,
    pub y: ::std::os::raw::c_int,
    pub w: ::std::os::raw::c_int,
    pub h: ::std::os::raw::c_int,
    pub layer: ::std::os::raw::c_int,
    pub layer_height: ::std::os::raw::c_int,
    pub layer_width: ::std::os::raw::c_int,
    pub pos_in_layer: ::std::os::raw::c_int,
    pub is_dummy: ::std::os::raw::c_int,
    pub is_reversed: ::std::os::raw::c_int,
    pub klass: ::std::os::raw::c_int,
    pub difftype: ::std::os::raw::c_int,
    pub is_mini: bool,
}
#[test]
fn bindgen_test_layout_r_ascii_node_t() {
    assert_eq!(
        ::std::mem::size_of::<r_ascii_node_t>(),
        88usize,
        concat!("Size of: ", stringify!(r_ascii_node_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_ascii_node_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_ascii_node_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_ascii_node_t>())).gnode as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_ascii_node_t),
            "::",
            stringify!(gnode)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_ascii_node_t>())).title as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_ascii_node_t),
            "::",
            stringify!(title)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_ascii_node_t>())).body as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(r_ascii_node_t),
            "::",
            stringify!(body)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_ascii_node_t>())).color as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(r_ascii_node_t),
            "::",
            stringify!(color)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_ascii_node_t>())).x as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(r_ascii_node_t),
            "::",
            stringify!(x)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_ascii_node_t>())).y as *const _ as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(r_ascii_node_t),
            "::",
            stringify!(y)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_ascii_node_t>())).w as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(r_ascii_node_t),
            "::",
            stringify!(w)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_ascii_node_t>())).h as *const _ as usize },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(r_ascii_node_t),
            "::",
            stringify!(h)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_ascii_node_t>())).layer as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(r_ascii_node_t),
            "::",
            stringify!(layer)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_ascii_node_t>())).layer_height as *const _ as usize },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(r_ascii_node_t),
            "::",
            stringify!(layer_height)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_ascii_node_t>())).layer_width as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(r_ascii_node_t),
            "::",
            stringify!(layer_width)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_ascii_node_t>())).pos_in_layer as *const _ as usize },
        60usize,
        concat!(
            "Offset of field: ",
            stringify!(r_ascii_node_t),
            "::",
            stringify!(pos_in_layer)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_ascii_node_t>())).is_dummy as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(r_ascii_node_t),
            "::",
            stringify!(is_dummy)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_ascii_node_t>())).is_reversed as *const _ as usize },
        68usize,
        concat!(
            "Offset of field: ",
            stringify!(r_ascii_node_t),
            "::",
            stringify!(is_reversed)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_ascii_node_t>())).klass as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(r_ascii_node_t),
            "::",
            stringify!(klass)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_ascii_node_t>())).difftype as *const _ as usize },
        76usize,
        concat!(
            "Offset of field: ",
            stringify!(r_ascii_node_t),
            "::",
            stringify!(difftype)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_ascii_node_t>())).is_mini as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(r_ascii_node_t),
            "::",
            stringify!(is_mini)
        )
    );
}
pub type RANode = r_ascii_node_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_core_graph_hits_t {
    pub old_word: *mut ::std::os::raw::c_char,
    pub word_list: RVector,
    pub word_nth: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_r_core_graph_hits_t() {
    assert_eq!(
        ::std::mem::size_of::<r_core_graph_hits_t>(),
        64usize,
        concat!("Size of: ", stringify!(r_core_graph_hits_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_core_graph_hits_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_core_graph_hits_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_core_graph_hits_t>())).old_word as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_core_graph_hits_t),
            "::",
            stringify!(old_word)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_core_graph_hits_t>())).word_list as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_core_graph_hits_t),
            "::",
            stringify!(word_list)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_core_graph_hits_t>())).word_nth as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(r_core_graph_hits_t),
            "::",
            stringify!(word_nth)
        )
    );
}
pub type RAGraphHits = r_core_graph_hits_t;
pub type RANodeCallback =
    ::std::option::Option<unsafe extern "C" fn(n: *mut RANode, user: *mut ::std::os::raw::c_void)>;
pub type RAEdgeCallback = ::std::option::Option<
    unsafe extern "C" fn(from: *mut RANode, to: *mut RANode, user: *mut ::std::os::raw::c_void),
>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_ascii_graph_t {
    pub can: *mut RConsCanvas,
    pub graph: *mut RGraph,
    pub curnode: *const RGraphNode,
    pub title: *mut ::std::os::raw::c_char,
    pub db: *mut Sdb,
    pub nodes: *mut Sdb,
    pub layout: ::std::os::raw::c_int,
    pub is_instep: ::std::os::raw::c_int,
    pub is_tiny: bool,
    pub is_dis: bool,
    pub edgemode: ::std::os::raw::c_int,
    pub mode: ::std::os::raw::c_int,
    pub is_callgraph: bool,
    pub is_interactive: bool,
    pub zoom: ::std::os::raw::c_int,
    pub movspeed: ::std::os::raw::c_int,
    pub hints: bool,
    pub update_seek_on: *mut RANode,
    pub need_reload_nodes: bool,
    pub need_set_layout: bool,
    pub need_update_dim: ::std::os::raw::c_int,
    pub force_update_seek: ::std::os::raw::c_int,
    pub on_curnode_change: RANodeCallback,
    pub on_curnode_change_data: *mut ::std::os::raw::c_void,
    pub dummy: bool,
    pub show_node_titles: bool,
    pub show_node_body: bool,
    pub show_node_bubble: bool,
    pub x: ::std::os::raw::c_int,
    pub y: ::std::os::raw::c_int,
    pub w: ::std::os::raw::c_int,
    pub h: ::std::os::raw::c_int,
    pub back_edges: *mut RList,
    pub long_edges: *mut RList,
    pub layers: *mut layer_t,
    pub n_layers: ::std::os::raw::c_uint,
    pub dists: *mut RList,
    pub edges: *mut RList,
    pub ghits: RAGraphHits,
}
#[test]
fn bindgen_test_layout_r_ascii_graph_t() {
    assert_eq!(
        ::std::mem::size_of::<r_ascii_graph_t>(),
        264usize,
        concat!("Size of: ", stringify!(r_ascii_graph_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_ascii_graph_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_ascii_graph_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_ascii_graph_t>())).can as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_ascii_graph_t),
            "::",
            stringify!(can)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_ascii_graph_t>())).graph as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_ascii_graph_t),
            "::",
            stringify!(graph)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_ascii_graph_t>())).curnode as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(r_ascii_graph_t),
            "::",
            stringify!(curnode)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_ascii_graph_t>())).title as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(r_ascii_graph_t),
            "::",
            stringify!(title)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_ascii_graph_t>())).db as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(r_ascii_graph_t),
            "::",
            stringify!(db)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_ascii_graph_t>())).nodes as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(r_ascii_graph_t),
            "::",
            stringify!(nodes)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_ascii_graph_t>())).layout as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(r_ascii_graph_t),
            "::",
            stringify!(layout)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_ascii_graph_t>())).is_instep as *const _ as usize },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(r_ascii_graph_t),
            "::",
            stringify!(is_instep)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_ascii_graph_t>())).is_tiny as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(r_ascii_graph_t),
            "::",
            stringify!(is_tiny)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_ascii_graph_t>())).is_dis as *const _ as usize },
        57usize,
        concat!(
            "Offset of field: ",
            stringify!(r_ascii_graph_t),
            "::",
            stringify!(is_dis)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_ascii_graph_t>())).edgemode as *const _ as usize },
        60usize,
        concat!(
            "Offset of field: ",
            stringify!(r_ascii_graph_t),
            "::",
            stringify!(edgemode)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_ascii_graph_t>())).mode as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(r_ascii_graph_t),
            "::",
            stringify!(mode)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_ascii_graph_t>())).is_callgraph as *const _ as usize },
        68usize,
        concat!(
            "Offset of field: ",
            stringify!(r_ascii_graph_t),
            "::",
            stringify!(is_callgraph)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_ascii_graph_t>())).is_interactive as *const _ as usize },
        69usize,
        concat!(
            "Offset of field: ",
            stringify!(r_ascii_graph_t),
            "::",
            stringify!(is_interactive)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_ascii_graph_t>())).zoom as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(r_ascii_graph_t),
            "::",
            stringify!(zoom)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_ascii_graph_t>())).movspeed as *const _ as usize },
        76usize,
        concat!(
            "Offset of field: ",
            stringify!(r_ascii_graph_t),
            "::",
            stringify!(movspeed)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_ascii_graph_t>())).hints as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(r_ascii_graph_t),
            "::",
            stringify!(hints)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_ascii_graph_t>())).update_seek_on as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(r_ascii_graph_t),
            "::",
            stringify!(update_seek_on)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_ascii_graph_t>())).need_reload_nodes as *const _ as usize
        },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(r_ascii_graph_t),
            "::",
            stringify!(need_reload_nodes)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_ascii_graph_t>())).need_set_layout as *const _ as usize },
        97usize,
        concat!(
            "Offset of field: ",
            stringify!(r_ascii_graph_t),
            "::",
            stringify!(need_set_layout)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_ascii_graph_t>())).need_update_dim as *const _ as usize },
        100usize,
        concat!(
            "Offset of field: ",
            stringify!(r_ascii_graph_t),
            "::",
            stringify!(need_update_dim)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_ascii_graph_t>())).force_update_seek as *const _ as usize
        },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(r_ascii_graph_t),
            "::",
            stringify!(force_update_seek)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_ascii_graph_t>())).on_curnode_change as *const _ as usize
        },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(r_ascii_graph_t),
            "::",
            stringify!(on_curnode_change)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_ascii_graph_t>())).on_curnode_change_data as *const _ as usize
        },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(r_ascii_graph_t),
            "::",
            stringify!(on_curnode_change_data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_ascii_graph_t>())).dummy as *const _ as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(r_ascii_graph_t),
            "::",
            stringify!(dummy)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_ascii_graph_t>())).show_node_titles as *const _ as usize
        },
        129usize,
        concat!(
            "Offset of field: ",
            stringify!(r_ascii_graph_t),
            "::",
            stringify!(show_node_titles)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_ascii_graph_t>())).show_node_body as *const _ as usize },
        130usize,
        concat!(
            "Offset of field: ",
            stringify!(r_ascii_graph_t),
            "::",
            stringify!(show_node_body)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_ascii_graph_t>())).show_node_bubble as *const _ as usize
        },
        131usize,
        concat!(
            "Offset of field: ",
            stringify!(r_ascii_graph_t),
            "::",
            stringify!(show_node_bubble)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_ascii_graph_t>())).x as *const _ as usize },
        132usize,
        concat!(
            "Offset of field: ",
            stringify!(r_ascii_graph_t),
            "::",
            stringify!(x)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_ascii_graph_t>())).y as *const _ as usize },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(r_ascii_graph_t),
            "::",
            stringify!(y)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_ascii_graph_t>())).w as *const _ as usize },
        140usize,
        concat!(
            "Offset of field: ",
            stringify!(r_ascii_graph_t),
            "::",
            stringify!(w)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_ascii_graph_t>())).h as *const _ as usize },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(r_ascii_graph_t),
            "::",
            stringify!(h)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_ascii_graph_t>())).back_edges as *const _ as usize },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(r_ascii_graph_t),
            "::",
            stringify!(back_edges)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_ascii_graph_t>())).long_edges as *const _ as usize },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(r_ascii_graph_t),
            "::",
            stringify!(long_edges)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_ascii_graph_t>())).layers as *const _ as usize },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(r_ascii_graph_t),
            "::",
            stringify!(layers)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_ascii_graph_t>())).n_layers as *const _ as usize },
        176usize,
        concat!(
            "Offset of field: ",
            stringify!(r_ascii_graph_t),
            "::",
            stringify!(n_layers)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_ascii_graph_t>())).dists as *const _ as usize },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(r_ascii_graph_t),
            "::",
            stringify!(dists)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_ascii_graph_t>())).edges as *const _ as usize },
        192usize,
        concat!(
            "Offset of field: ",
            stringify!(r_ascii_graph_t),
            "::",
            stringify!(edges)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_ascii_graph_t>())).ghits as *const _ as usize },
        200usize,
        concat!(
            "Offset of field: ",
            stringify!(r_ascii_graph_t),
            "::",
            stringify!(ghits)
        )
    );
}
pub type RAGraph = r_ascii_graph_t;
extern "C" {
    pub fn r_agraph_new(can: *mut RConsCanvas) -> *mut RAGraph;
}
extern "C" {
    pub fn r_agraph_free(g: *mut RAGraph);
}
extern "C" {
    pub fn r_agraph_reset(g: *mut RAGraph);
}
extern "C" {
    pub fn r_agraph_set_title(g: *mut RAGraph, title: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn r_agraph_get_first_node(g: *const RAGraph) -> *mut RANode;
}
extern "C" {
    pub fn r_agraph_get_node(
        g: *const RAGraph,
        title: *const ::std::os::raw::c_char,
    ) -> *mut RANode;
}
extern "C" {
    pub fn r_agraph_add_node(
        g: *const RAGraph,
        title: *const ::std::os::raw::c_char,
        body: *const ::std::os::raw::c_char,
        color: *const ::std::os::raw::c_char,
    ) -> *mut RANode;
}
extern "C" {
    pub fn r_agraph_del_node(g: *const RAGraph, title: *const ::std::os::raw::c_char) -> bool;
}
extern "C" {
    pub fn r_agraph_add_edge(g: *const RAGraph, a: *mut RANode, b: *mut RANode, highlight: bool);
}
extern "C" {
    pub fn r_agraph_add_edge_at(
        g: *const RAGraph,
        a: *mut RANode,
        b: *mut RANode,
        nth: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn r_agraph_del_edge(g: *const RAGraph, a: *mut RANode, b: *mut RANode);
}
extern "C" {
    pub fn r_agraph_print(g: *mut RAGraph);
}
extern "C" {
    pub fn r_agraph_print_json(g: *mut RAGraph, pj: *mut PJ);
}
extern "C" {
    pub fn r_agraph_get_sdb(g: *mut RAGraph) -> *mut Sdb;
}
extern "C" {
    pub fn r_agraph_foreach(g: *mut RAGraph, cb: RANodeCallback, user: *mut ::std::os::raw::c_void);
}
extern "C" {
    pub fn r_agraph_foreach_edge(
        g: *mut RAGraph,
        cb: RAEdgeCallback,
        user: *mut ::std::os::raw::c_void,
    );
}
extern "C" {
    pub fn r_agraph_set_curnode(g: *mut RAGraph, node: *mut RANode);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_skyline_item_t {
    pub itv: RInterval,
    pub user: *mut ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout_r_skyline_item_t() {
    assert_eq!(
        ::std::mem::size_of::<r_skyline_item_t>(),
        24usize,
        concat!("Size of: ", stringify!(r_skyline_item_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_skyline_item_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_skyline_item_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_skyline_item_t>())).itv as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_skyline_item_t),
            "::",
            stringify!(itv)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_skyline_item_t>())).user as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(r_skyline_item_t),
            "::",
            stringify!(user)
        )
    );
}
pub type RSkylineItem = r_skyline_item_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_skyline_t {
    pub v: RVector,
}
#[test]
fn bindgen_test_layout_r_skyline_t() {
    assert_eq!(
        ::std::mem::size_of::<r_skyline_t>(),
        48usize,
        concat!("Size of: ", stringify!(r_skyline_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_skyline_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_skyline_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_skyline_t>())).v as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_skyline_t),
            "::",
            stringify!(v)
        )
    );
}
pub type RSkyline = r_skyline_t;
extern "C" {
    pub fn r_skyline_add(
        skyline: *mut RSkyline,
        itv: RInterval,
        user: *mut ::std::os::raw::c_void,
    ) -> bool;
}
extern "C" {
    pub fn r_skyline_get_item_intersect(
        skyline: *mut RSkyline,
        addr: u64,
        len: u64,
    ) -> *const RSkylineItem;
}
pub const __ptrace_request_PTRACE_TRACEME: __ptrace_request = 0;
pub const __ptrace_request_PTRACE_PEEKTEXT: __ptrace_request = 1;
pub const __ptrace_request_PTRACE_PEEKDATA: __ptrace_request = 2;
pub const __ptrace_request_PTRACE_PEEKUSER: __ptrace_request = 3;
pub const __ptrace_request_PTRACE_POKETEXT: __ptrace_request = 4;
pub const __ptrace_request_PTRACE_POKEDATA: __ptrace_request = 5;
pub const __ptrace_request_PTRACE_POKEUSER: __ptrace_request = 6;
pub const __ptrace_request_PTRACE_CONT: __ptrace_request = 7;
pub const __ptrace_request_PTRACE_KILL: __ptrace_request = 8;
pub const __ptrace_request_PTRACE_SINGLESTEP: __ptrace_request = 9;
pub const __ptrace_request_PTRACE_GETREGS: __ptrace_request = 12;
pub const __ptrace_request_PTRACE_SETREGS: __ptrace_request = 13;
pub const __ptrace_request_PTRACE_GETFPREGS: __ptrace_request = 14;
pub const __ptrace_request_PTRACE_SETFPREGS: __ptrace_request = 15;
pub const __ptrace_request_PTRACE_ATTACH: __ptrace_request = 16;
pub const __ptrace_request_PTRACE_DETACH: __ptrace_request = 17;
pub const __ptrace_request_PTRACE_GETFPXREGS: __ptrace_request = 18;
pub const __ptrace_request_PTRACE_SETFPXREGS: __ptrace_request = 19;
pub const __ptrace_request_PTRACE_SYSCALL: __ptrace_request = 24;
pub const __ptrace_request_PTRACE_GET_THREAD_AREA: __ptrace_request = 25;
pub const __ptrace_request_PTRACE_SET_THREAD_AREA: __ptrace_request = 26;
pub const __ptrace_request_PTRACE_ARCH_PRCTL: __ptrace_request = 30;
pub const __ptrace_request_PTRACE_SYSEMU: __ptrace_request = 31;
pub const __ptrace_request_PTRACE_SYSEMU_SINGLESTEP: __ptrace_request = 32;
pub const __ptrace_request_PTRACE_SINGLEBLOCK: __ptrace_request = 33;
pub const __ptrace_request_PTRACE_SETOPTIONS: __ptrace_request = 16896;
pub const __ptrace_request_PTRACE_GETEVENTMSG: __ptrace_request = 16897;
pub const __ptrace_request_PTRACE_GETSIGINFO: __ptrace_request = 16898;
pub const __ptrace_request_PTRACE_SETSIGINFO: __ptrace_request = 16899;
pub const __ptrace_request_PTRACE_GETREGSET: __ptrace_request = 16900;
pub const __ptrace_request_PTRACE_SETREGSET: __ptrace_request = 16901;
pub const __ptrace_request_PTRACE_SEIZE: __ptrace_request = 16902;
pub const __ptrace_request_PTRACE_INTERRUPT: __ptrace_request = 16903;
pub const __ptrace_request_PTRACE_LISTEN: __ptrace_request = 16904;
pub const __ptrace_request_PTRACE_PEEKSIGINFO: __ptrace_request = 16905;
pub const __ptrace_request_PTRACE_GETSIGMASK: __ptrace_request = 16906;
pub const __ptrace_request_PTRACE_SETSIGMASK: __ptrace_request = 16907;
pub const __ptrace_request_PTRACE_SECCOMP_GET_FILTER: __ptrace_request = 16908;
pub const __ptrace_request_PTRACE_SECCOMP_GET_METADATA: __ptrace_request = 16909;
pub const __ptrace_request_PTRACE_GET_SYSCALL_INFO: __ptrace_request = 16910;
pub type __ptrace_request = ::std::os::raw::c_uint;
pub use self::__ptrace_request as r_ptrace_request_t;
pub type r_ptrace_data_t = *mut ::std::os::raw::c_void;
extern "C" {
    pub fn r_io_version() -> *const ::std::os::raw::c_char;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_io_undos_t {
    pub off: u64,
    pub cursor: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_r_io_undos_t() {
    assert_eq!(
        ::std::mem::size_of::<r_io_undos_t>(),
        16usize,
        concat!("Size of: ", stringify!(r_io_undos_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_io_undos_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_io_undos_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_io_undos_t>())).off as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_io_undos_t),
            "::",
            stringify!(off)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_io_undos_t>())).cursor as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_io_undos_t),
            "::",
            stringify!(cursor)
        )
    );
}
pub type RIOUndos = r_io_undos_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_io_undo_t {
    pub s_enable: ::std::os::raw::c_int,
    pub w_enable: ::std::os::raw::c_int,
    pub w_list: *mut RList,
    pub w_init: ::std::os::raw::c_int,
    pub idx: ::std::os::raw::c_int,
    pub undos: ::std::os::raw::c_int,
    pub redos: ::std::os::raw::c_int,
    pub seek: [RIOUndos; 64usize],
}
#[test]
fn bindgen_test_layout_r_io_undo_t() {
    assert_eq!(
        ::std::mem::size_of::<r_io_undo_t>(),
        1056usize,
        concat!("Size of: ", stringify!(r_io_undo_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_io_undo_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_io_undo_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_io_undo_t>())).s_enable as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_io_undo_t),
            "::",
            stringify!(s_enable)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_io_undo_t>())).w_enable as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(r_io_undo_t),
            "::",
            stringify!(w_enable)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_io_undo_t>())).w_list as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_io_undo_t),
            "::",
            stringify!(w_list)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_io_undo_t>())).w_init as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(r_io_undo_t),
            "::",
            stringify!(w_init)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_io_undo_t>())).idx as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(r_io_undo_t),
            "::",
            stringify!(idx)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_io_undo_t>())).undos as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(r_io_undo_t),
            "::",
            stringify!(undos)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_io_undo_t>())).redos as *const _ as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(r_io_undo_t),
            "::",
            stringify!(redos)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_io_undo_t>())).seek as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(r_io_undo_t),
            "::",
            stringify!(seek)
        )
    );
}
pub type RIOUndo = r_io_undo_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_io_undo_w_t {
    pub set: bool,
    pub off: u64,
    pub o: *mut u8,
    pub n: *mut u8,
    pub len: size_t,
}
#[test]
fn bindgen_test_layout_r_io_undo_w_t() {
    assert_eq!(
        ::std::mem::size_of::<r_io_undo_w_t>(),
        40usize,
        concat!("Size of: ", stringify!(r_io_undo_w_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_io_undo_w_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_io_undo_w_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_io_undo_w_t>())).set as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_io_undo_w_t),
            "::",
            stringify!(set)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_io_undo_w_t>())).off as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_io_undo_w_t),
            "::",
            stringify!(off)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_io_undo_w_t>())).o as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(r_io_undo_w_t),
            "::",
            stringify!(o)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_io_undo_w_t>())).n as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(r_io_undo_w_t),
            "::",
            stringify!(n)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_io_undo_w_t>())).len as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(r_io_undo_w_t),
            "::",
            stringify!(len)
        )
    );
}
pub type RIOUndoWrite = r_io_undo_w_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_io_t {
    pub desc: *mut r_io_desc_t,
    pub off: u64,
    pub bank: u32,
    pub bits: ::std::os::raw::c_int,
    pub va: ::std::os::raw::c_int,
    pub ff: bool,
    pub Oxff: u8,
    pub addrbytes: size_t,
    pub aslr: bool,
    pub autofd: bool,
    pub cached: u32,
    pub cachemode: bool,
    pub p_cache: u32,
    pub mts: u64,
    pub files: *mut RIDStorage,
    pub maps: *mut RIDStorage,
    pub banks: *mut RIDStorage,
    pub buffer: *mut RCache,
    pub cache: RPVector,
    pub cache_skyline: RSkyline,
    pub write_mask: *mut u8,
    pub write_mask_len: ::std::os::raw::c_int,
    pub mask: u64,
    pub undo: RIOUndo,
    pub plugins: *mut SdbList,
    pub nodup: bool,
    pub runprofile: *mut ::std::os::raw::c_char,
    pub envprofile: *mut ::std::os::raw::c_char,
    pub args: *mut ::std::os::raw::c_char,
    pub event: *mut REvent,
    pub cb_printf: PrintfCallback,
    pub corebind: RCoreBind,
    pub want_ptrace_wrap: bool,
}
#[test]
fn bindgen_test_layout_r_io_t() {
    assert_eq!(
        ::std::mem::size_of::<r_io_t>(),
        1480usize,
        concat!("Size of: ", stringify!(r_io_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_io_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_io_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_io_t>())).desc as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_io_t),
            "::",
            stringify!(desc)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_io_t>())).off as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_io_t),
            "::",
            stringify!(off)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_io_t>())).bank as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(r_io_t),
            "::",
            stringify!(bank)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_io_t>())).bits as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(r_io_t),
            "::",
            stringify!(bits)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_io_t>())).va as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(r_io_t),
            "::",
            stringify!(va)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_io_t>())).ff as *const _ as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(r_io_t),
            "::",
            stringify!(ff)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_io_t>())).Oxff as *const _ as usize },
        29usize,
        concat!(
            "Offset of field: ",
            stringify!(r_io_t),
            "::",
            stringify!(Oxff)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_io_t>())).addrbytes as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(r_io_t),
            "::",
            stringify!(addrbytes)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_io_t>())).aslr as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(r_io_t),
            "::",
            stringify!(aslr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_io_t>())).autofd as *const _ as usize },
        41usize,
        concat!(
            "Offset of field: ",
            stringify!(r_io_t),
            "::",
            stringify!(autofd)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_io_t>())).cached as *const _ as usize },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(r_io_t),
            "::",
            stringify!(cached)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_io_t>())).cachemode as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(r_io_t),
            "::",
            stringify!(cachemode)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_io_t>())).p_cache as *const _ as usize },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(r_io_t),
            "::",
            stringify!(p_cache)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_io_t>())).mts as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(r_io_t),
            "::",
            stringify!(mts)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_io_t>())).files as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(r_io_t),
            "::",
            stringify!(files)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_io_t>())).maps as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(r_io_t),
            "::",
            stringify!(maps)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_io_t>())).banks as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(r_io_t),
            "::",
            stringify!(banks)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_io_t>())).buffer as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(r_io_t),
            "::",
            stringify!(buffer)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_io_t>())).cache as *const _ as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(r_io_t),
            "::",
            stringify!(cache)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_io_t>())).cache_skyline as *const _ as usize },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(r_io_t),
            "::",
            stringify!(cache_skyline)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_io_t>())).write_mask as *const _ as usize },
        192usize,
        concat!(
            "Offset of field: ",
            stringify!(r_io_t),
            "::",
            stringify!(write_mask)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_io_t>())).write_mask_len as *const _ as usize },
        200usize,
        concat!(
            "Offset of field: ",
            stringify!(r_io_t),
            "::",
            stringify!(write_mask_len)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_io_t>())).mask as *const _ as usize },
        208usize,
        concat!(
            "Offset of field: ",
            stringify!(r_io_t),
            "::",
            stringify!(mask)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_io_t>())).undo as *const _ as usize },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(r_io_t),
            "::",
            stringify!(undo)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_io_t>())).plugins as *const _ as usize },
        1272usize,
        concat!(
            "Offset of field: ",
            stringify!(r_io_t),
            "::",
            stringify!(plugins)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_io_t>())).nodup as *const _ as usize },
        1280usize,
        concat!(
            "Offset of field: ",
            stringify!(r_io_t),
            "::",
            stringify!(nodup)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_io_t>())).runprofile as *const _ as usize },
        1288usize,
        concat!(
            "Offset of field: ",
            stringify!(r_io_t),
            "::",
            stringify!(runprofile)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_io_t>())).envprofile as *const _ as usize },
        1296usize,
        concat!(
            "Offset of field: ",
            stringify!(r_io_t),
            "::",
            stringify!(envprofile)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_io_t>())).args as *const _ as usize },
        1304usize,
        concat!(
            "Offset of field: ",
            stringify!(r_io_t),
            "::",
            stringify!(args)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_io_t>())).event as *const _ as usize },
        1312usize,
        concat!(
            "Offset of field: ",
            stringify!(r_io_t),
            "::",
            stringify!(event)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_io_t>())).cb_printf as *const _ as usize },
        1320usize,
        concat!(
            "Offset of field: ",
            stringify!(r_io_t),
            "::",
            stringify!(cb_printf)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_io_t>())).corebind as *const _ as usize },
        1328usize,
        concat!(
            "Offset of field: ",
            stringify!(r_io_t),
            "::",
            stringify!(corebind)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_io_t>())).want_ptrace_wrap as *const _ as usize },
        1472usize,
        concat!(
            "Offset of field: ",
            stringify!(r_io_t),
            "::",
            stringify!(want_ptrace_wrap)
        )
    );
}
pub type RIO = r_io_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_io_desc_t {
    pub fd: ::std::os::raw::c_int,
    pub perm: ::std::os::raw::c_int,
    pub uri: *mut ::std::os::raw::c_char,
    pub name: *mut ::std::os::raw::c_char,
    pub referer: *mut ::std::os::raw::c_char,
    pub cache: *mut HtUP,
    pub data: *mut ::std::os::raw::c_void,
    pub plugin: *mut r_io_plugin_t,
    pub io: *mut RIO,
}
#[test]
fn bindgen_test_layout_r_io_desc_t() {
    assert_eq!(
        ::std::mem::size_of::<r_io_desc_t>(),
        64usize,
        concat!("Size of: ", stringify!(r_io_desc_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_io_desc_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_io_desc_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_io_desc_t>())).fd as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_io_desc_t),
            "::",
            stringify!(fd)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_io_desc_t>())).perm as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(r_io_desc_t),
            "::",
            stringify!(perm)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_io_desc_t>())).uri as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_io_desc_t),
            "::",
            stringify!(uri)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_io_desc_t>())).name as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(r_io_desc_t),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_io_desc_t>())).referer as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(r_io_desc_t),
            "::",
            stringify!(referer)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_io_desc_t>())).cache as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(r_io_desc_t),
            "::",
            stringify!(cache)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_io_desc_t>())).data as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(r_io_desc_t),
            "::",
            stringify!(data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_io_desc_t>())).plugin as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(r_io_desc_t),
            "::",
            stringify!(plugin)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_io_desc_t>())).io as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(r_io_desc_t),
            "::",
            stringify!(io)
        )
    );
}
pub type RIODesc = r_io_desc_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_io_plugin_t {
    pub name: *const ::std::os::raw::c_char,
    pub desc: *const ::std::os::raw::c_char,
    pub version: *const ::std::os::raw::c_char,
    pub author: *const ::std::os::raw::c_char,
    pub license: *const ::std::os::raw::c_char,
    pub widget: *mut ::std::os::raw::c_void,
    pub uris: *const ::std::os::raw::c_char,
    pub listener:
        ::std::option::Option<unsafe extern "C" fn(io: *mut RIODesc) -> ::std::os::raw::c_int>,
    pub init: ::std::option::Option<unsafe extern "C" fn() -> bool>,
    pub undo: RIOUndo,
    pub isdbg: bool,
    pub system: ::std::option::Option<
        unsafe extern "C" fn(
            io: *mut RIO,
            fd: *mut RIODesc,
            arg1: *const ::std::os::raw::c_char,
        ) -> *mut ::std::os::raw::c_char,
    >,
    pub open: ::std::option::Option<
        unsafe extern "C" fn(
            io: *mut RIO,
            arg1: *const ::std::os::raw::c_char,
            perm: ::std::os::raw::c_int,
            mode: ::std::os::raw::c_int,
        ) -> *mut RIODesc,
    >,
    pub open_many: ::std::option::Option<
        unsafe extern "C" fn(
            io: *mut RIO,
            arg1: *const ::std::os::raw::c_char,
            perm: ::std::os::raw::c_int,
            mode: ::std::os::raw::c_int,
        ) -> *mut RList,
    >,
    pub read: ::std::option::Option<
        unsafe extern "C" fn(
            io: *mut RIO,
            fd: *mut RIODesc,
            buf: *mut u8,
            count: ::std::os::raw::c_int,
        ) -> ::std::os::raw::c_int,
    >,
    pub seek: ::std::option::Option<
        unsafe extern "C" fn(
            io: *mut RIO,
            fd: *mut RIODesc,
            offset: u64,
            whence: ::std::os::raw::c_int,
        ) -> u64,
    >,
    pub write: ::std::option::Option<
        unsafe extern "C" fn(
            io: *mut RIO,
            fd: *mut RIODesc,
            buf: *const u8,
            count: ::std::os::raw::c_int,
        ) -> ::std::os::raw::c_int,
    >,
    pub close: ::std::option::Option<unsafe extern "C" fn(desc: *mut RIODesc) -> bool>,
    pub is_blockdevice: ::std::option::Option<unsafe extern "C" fn(desc: *mut RIODesc) -> bool>,
    pub is_chardevice: ::std::option::Option<unsafe extern "C" fn(desc: *mut RIODesc) -> bool>,
    pub getpid:
        ::std::option::Option<unsafe extern "C" fn(desc: *mut RIODesc) -> ::std::os::raw::c_int>,
    pub gettid:
        ::std::option::Option<unsafe extern "C" fn(desc: *mut RIODesc) -> ::std::os::raw::c_int>,
    pub getbase:
        ::std::option::Option<unsafe extern "C" fn(desc: *mut RIODesc, base: *mut u64) -> bool>,
    pub resize: ::std::option::Option<
        unsafe extern "C" fn(io: *mut RIO, fd: *mut RIODesc, size: u64) -> bool,
    >,
    pub extend: ::std::option::Option<
        unsafe extern "C" fn(io: *mut RIO, fd: *mut RIODesc, size: u64) -> ::std::os::raw::c_int,
    >,
    pub accept: ::std::option::Option<
        unsafe extern "C" fn(io: *mut RIO, desc: *mut RIODesc, fd: ::std::os::raw::c_int) -> bool,
    >,
    pub create: ::std::option::Option<
        unsafe extern "C" fn(
            io: *mut RIO,
            file: *const ::std::os::raw::c_char,
            mode: ::std::os::raw::c_int,
            type_: ::std::os::raw::c_int,
        ) -> ::std::os::raw::c_int,
    >,
    pub check: ::std::option::Option<
        unsafe extern "C" fn(io: *mut RIO, arg1: *const ::std::os::raw::c_char, many: bool) -> bool,
    >,
}
#[test]
fn bindgen_test_layout_r_io_plugin_t() {
    assert_eq!(
        ::std::mem::size_of::<r_io_plugin_t>(),
        1272usize,
        concat!("Size of: ", stringify!(r_io_plugin_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_io_plugin_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_io_plugin_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_io_plugin_t>())).name as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_io_plugin_t),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_io_plugin_t>())).desc as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_io_plugin_t),
            "::",
            stringify!(desc)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_io_plugin_t>())).version as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(r_io_plugin_t),
            "::",
            stringify!(version)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_io_plugin_t>())).author as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(r_io_plugin_t),
            "::",
            stringify!(author)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_io_plugin_t>())).license as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(r_io_plugin_t),
            "::",
            stringify!(license)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_io_plugin_t>())).widget as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(r_io_plugin_t),
            "::",
            stringify!(widget)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_io_plugin_t>())).uris as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(r_io_plugin_t),
            "::",
            stringify!(uris)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_io_plugin_t>())).listener as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(r_io_plugin_t),
            "::",
            stringify!(listener)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_io_plugin_t>())).init as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(r_io_plugin_t),
            "::",
            stringify!(init)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_io_plugin_t>())).undo as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(r_io_plugin_t),
            "::",
            stringify!(undo)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_io_plugin_t>())).isdbg as *const _ as usize },
        1128usize,
        concat!(
            "Offset of field: ",
            stringify!(r_io_plugin_t),
            "::",
            stringify!(isdbg)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_io_plugin_t>())).system as *const _ as usize },
        1136usize,
        concat!(
            "Offset of field: ",
            stringify!(r_io_plugin_t),
            "::",
            stringify!(system)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_io_plugin_t>())).open as *const _ as usize },
        1144usize,
        concat!(
            "Offset of field: ",
            stringify!(r_io_plugin_t),
            "::",
            stringify!(open)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_io_plugin_t>())).open_many as *const _ as usize },
        1152usize,
        concat!(
            "Offset of field: ",
            stringify!(r_io_plugin_t),
            "::",
            stringify!(open_many)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_io_plugin_t>())).read as *const _ as usize },
        1160usize,
        concat!(
            "Offset of field: ",
            stringify!(r_io_plugin_t),
            "::",
            stringify!(read)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_io_plugin_t>())).seek as *const _ as usize },
        1168usize,
        concat!(
            "Offset of field: ",
            stringify!(r_io_plugin_t),
            "::",
            stringify!(seek)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_io_plugin_t>())).write as *const _ as usize },
        1176usize,
        concat!(
            "Offset of field: ",
            stringify!(r_io_plugin_t),
            "::",
            stringify!(write)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_io_plugin_t>())).close as *const _ as usize },
        1184usize,
        concat!(
            "Offset of field: ",
            stringify!(r_io_plugin_t),
            "::",
            stringify!(close)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_io_plugin_t>())).is_blockdevice as *const _ as usize },
        1192usize,
        concat!(
            "Offset of field: ",
            stringify!(r_io_plugin_t),
            "::",
            stringify!(is_blockdevice)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_io_plugin_t>())).is_chardevice as *const _ as usize },
        1200usize,
        concat!(
            "Offset of field: ",
            stringify!(r_io_plugin_t),
            "::",
            stringify!(is_chardevice)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_io_plugin_t>())).getpid as *const _ as usize },
        1208usize,
        concat!(
            "Offset of field: ",
            stringify!(r_io_plugin_t),
            "::",
            stringify!(getpid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_io_plugin_t>())).gettid as *const _ as usize },
        1216usize,
        concat!(
            "Offset of field: ",
            stringify!(r_io_plugin_t),
            "::",
            stringify!(gettid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_io_plugin_t>())).getbase as *const _ as usize },
        1224usize,
        concat!(
            "Offset of field: ",
            stringify!(r_io_plugin_t),
            "::",
            stringify!(getbase)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_io_plugin_t>())).resize as *const _ as usize },
        1232usize,
        concat!(
            "Offset of field: ",
            stringify!(r_io_plugin_t),
            "::",
            stringify!(resize)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_io_plugin_t>())).extend as *const _ as usize },
        1240usize,
        concat!(
            "Offset of field: ",
            stringify!(r_io_plugin_t),
            "::",
            stringify!(extend)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_io_plugin_t>())).accept as *const _ as usize },
        1248usize,
        concat!(
            "Offset of field: ",
            stringify!(r_io_plugin_t),
            "::",
            stringify!(accept)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_io_plugin_t>())).create as *const _ as usize },
        1256usize,
        concat!(
            "Offset of field: ",
            stringify!(r_io_plugin_t),
            "::",
            stringify!(create)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_io_plugin_t>())).check as *const _ as usize },
        1264usize,
        concat!(
            "Offset of field: ",
            stringify!(r_io_plugin_t),
            "::",
            stringify!(check)
        )
    );
}
pub type RIOPlugin = r_io_plugin_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_io_map_t {
    pub fd: ::std::os::raw::c_int,
    pub perm: ::std::os::raw::c_int,
    pub id: u32,
    pub ts: u64,
    pub itv: RInterval,
    pub delta: u64,
    pub name: *mut ::std::os::raw::c_char,
}
#[test]
fn bindgen_test_layout_r_io_map_t() {
    assert_eq!(
        ::std::mem::size_of::<r_io_map_t>(),
        56usize,
        concat!("Size of: ", stringify!(r_io_map_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_io_map_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_io_map_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_io_map_t>())).fd as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_io_map_t),
            "::",
            stringify!(fd)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_io_map_t>())).perm as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(r_io_map_t),
            "::",
            stringify!(perm)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_io_map_t>())).id as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_io_map_t),
            "::",
            stringify!(id)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_io_map_t>())).ts as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(r_io_map_t),
            "::",
            stringify!(ts)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_io_map_t>())).itv as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(r_io_map_t),
            "::",
            stringify!(itv)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_io_map_t>())).delta as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(r_io_map_t),
            "::",
            stringify!(delta)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_io_map_t>())).name as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(r_io_map_t),
            "::",
            stringify!(name)
        )
    );
}
pub type RIOMap = r_io_map_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_io_map_ref_t {
    pub id: u32,
    pub ts: u64,
}
#[test]
fn bindgen_test_layout_r_io_map_ref_t() {
    assert_eq!(
        ::std::mem::size_of::<r_io_map_ref_t>(),
        16usize,
        concat!("Size of: ", stringify!(r_io_map_ref_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_io_map_ref_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_io_map_ref_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_io_map_ref_t>())).id as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_io_map_ref_t),
            "::",
            stringify!(id)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_io_map_ref_t>())).ts as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_io_map_ref_t),
            "::",
            stringify!(ts)
        )
    );
}
pub type RIOMapRef = r_io_map_ref_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_io_submap_t {
    pub mapref: RIOMapRef,
    pub itv: RInterval,
}
#[test]
fn bindgen_test_layout_r_io_submap_t() {
    assert_eq!(
        ::std::mem::size_of::<r_io_submap_t>(),
        32usize,
        concat!("Size of: ", stringify!(r_io_submap_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_io_submap_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_io_submap_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_io_submap_t>())).mapref as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_io_submap_t),
            "::",
            stringify!(mapref)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_io_submap_t>())).itv as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(r_io_submap_t),
            "::",
            stringify!(itv)
        )
    );
}
pub type RIOSubMap = r_io_submap_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_io_bank_t {
    pub name: *mut ::std::os::raw::c_char,
    pub submaps: *mut RRBTree,
    pub maprefs: *mut RList,
    pub todo: *mut RQueue,
    pub last_used: *mut RRBNode,
    pub id: u32,
}
#[test]
fn bindgen_test_layout_r_io_bank_t() {
    assert_eq!(
        ::std::mem::size_of::<r_io_bank_t>(),
        48usize,
        concat!("Size of: ", stringify!(r_io_bank_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_io_bank_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_io_bank_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_io_bank_t>())).name as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_io_bank_t),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_io_bank_t>())).submaps as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_io_bank_t),
            "::",
            stringify!(submaps)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_io_bank_t>())).maprefs as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(r_io_bank_t),
            "::",
            stringify!(maprefs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_io_bank_t>())).todo as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(r_io_bank_t),
            "::",
            stringify!(todo)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_io_bank_t>())).last_used as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(r_io_bank_t),
            "::",
            stringify!(last_used)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_io_bank_t>())).id as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(r_io_bank_t),
            "::",
            stringify!(id)
        )
    );
}
pub type RIOBank = r_io_bank_t;
pub type RIODescUse =
    ::std::option::Option<unsafe extern "C" fn(io: *mut RIO, fd: ::std::os::raw::c_int) -> bool>;
pub type RIODescGet = ::std::option::Option<
    unsafe extern "C" fn(io: *mut RIO, fd: ::std::os::raw::c_int) -> *mut RIODesc,
>;
pub type RIODescSize = ::std::option::Option<unsafe extern "C" fn(desc: *mut RIODesc) -> u64>;
pub type RIOOpen = ::std::option::Option<
    unsafe extern "C" fn(
        io: *mut RIO,
        uri: *const ::std::os::raw::c_char,
        flags: ::std::os::raw::c_int,
        mode: ::std::os::raw::c_int,
    ) -> *mut RIODesc,
>;
pub type RIOOpenAt = ::std::option::Option<
    unsafe extern "C" fn(
        io: *mut RIO,
        uri: *const ::std::os::raw::c_char,
        flags: ::std::os::raw::c_int,
        mode: ::std::os::raw::c_int,
        at: u64,
    ) -> *mut RIODesc,
>;
pub type RIOClose =
    ::std::option::Option<unsafe extern "C" fn(io: *mut RIO, fd: ::std::os::raw::c_int) -> bool>;
pub type RIOReadAt = ::std::option::Option<
    unsafe extern "C" fn(io: *mut RIO, addr: u64, buf: *mut u8, len: ::std::os::raw::c_int) -> bool,
>;
pub type RIOWriteAt = ::std::option::Option<
    unsafe extern "C" fn(
        io: *mut RIO,
        addr: u64,
        buf: *const u8,
        len: ::std::os::raw::c_int,
    ) -> bool,
>;
pub type RIOSystem = ::std::option::Option<
    unsafe extern "C" fn(
        io: *mut RIO,
        cmd: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char,
>;
pub type RIOFdOpen = ::std::option::Option<
    unsafe extern "C" fn(
        io: *mut RIO,
        uri: *const ::std::os::raw::c_char,
        flags: ::std::os::raw::c_int,
        mode: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int,
>;
pub type RIOFdClose =
    ::std::option::Option<unsafe extern "C" fn(io: *mut RIO, fd: ::std::os::raw::c_int) -> bool>;
pub type RIOFdSeek = ::std::option::Option<
    unsafe extern "C" fn(
        io: *mut RIO,
        fd: ::std::os::raw::c_int,
        addr: u64,
        whence: ::std::os::raw::c_int,
    ) -> u64,
>;
pub type RIOFdSize =
    ::std::option::Option<unsafe extern "C" fn(io: *mut RIO, fd: ::std::os::raw::c_int) -> u64>;
pub type RIOFdResize = ::std::option::Option<
    unsafe extern "C" fn(io: *mut RIO, fd: ::std::os::raw::c_int, newsize: u64) -> bool,
>;
pub type RIOP2V = ::std::option::Option<unsafe extern "C" fn(io: *mut RIO, pa: u64) -> u64>;
pub type RIOV2P = ::std::option::Option<unsafe extern "C" fn(io: *mut RIO, va: u64) -> u64>;
pub type RIOFdRead = ::std::option::Option<
    unsafe extern "C" fn(
        io: *mut RIO,
        fd: ::std::os::raw::c_int,
        buf: *mut u8,
        len: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int,
>;
pub type RIOFdWrite = ::std::option::Option<
    unsafe extern "C" fn(
        io: *mut RIO,
        fd: ::std::os::raw::c_int,
        buf: *const u8,
        len: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int,
>;
pub type RIOFdReadAt = ::std::option::Option<
    unsafe extern "C" fn(
        io: *mut RIO,
        fd: ::std::os::raw::c_int,
        addr: u64,
        buf: *mut u8,
        len: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int,
>;
pub type RIOFdWriteAt = ::std::option::Option<
    unsafe extern "C" fn(
        io: *mut RIO,
        fd: ::std::os::raw::c_int,
        addr: u64,
        buf: *const u8,
        len: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int,
>;
pub type RIOFdIsDbg =
    ::std::option::Option<unsafe extern "C" fn(io: *mut RIO, fd: ::std::os::raw::c_int) -> bool>;
pub type RIOFdGetName = ::std::option::Option<
    unsafe extern "C" fn(io: *mut RIO, fd: ::std::os::raw::c_int) -> *const ::std::os::raw::c_char,
>;
pub type RIOFdGetMap = ::std::option::Option<
    unsafe extern "C" fn(io: *mut RIO, fd: ::std::os::raw::c_int) -> *mut RList,
>;
pub type RIOFdRemap = ::std::option::Option<
    unsafe extern "C" fn(io: *mut RIO, fd: ::std::os::raw::c_int, addr: u64) -> bool,
>;
pub type RIOIsValidOff = ::std::option::Option<
    unsafe extern "C" fn(io: *mut RIO, addr: u64, hasperm: ::std::os::raw::c_int) -> bool,
>;
pub type RIOBankGet =
    ::std::option::Option<unsafe extern "C" fn(io: *mut RIO, bankid: u32) -> *mut RIOBank>;
pub type RIOMapGet =
    ::std::option::Option<unsafe extern "C" fn(io: *mut RIO, id: u32) -> *mut RIOMap>;
pub type RIOMapGetAt =
    ::std::option::Option<unsafe extern "C" fn(io: *mut RIO, addr: u64) -> *mut RIOMap>;
pub type RIOMapGetPaddr =
    ::std::option::Option<unsafe extern "C" fn(io: *mut RIO, paddr: u64) -> *mut RIOMap>;
pub type RIOAddrIsMapped =
    ::std::option::Option<unsafe extern "C" fn(io: *mut RIO, addr: u64) -> bool>;
pub type RIOMapAdd = ::std::option::Option<
    unsafe extern "C" fn(
        io: *mut RIO,
        fd: ::std::os::raw::c_int,
        flags: ::std::os::raw::c_int,
        delta: u64,
        addr: u64,
        size: u64,
    ) -> *mut RIOMap,
>;
pub type RIOPtraceFn = ::std::option::Option<
    unsafe extern "C" fn(
        io: *mut RIO,
        request: r_ptrace_request_t,
        pid: pid_t,
        addr: *mut ::std::os::raw::c_void,
        data: r_ptrace_data_t,
    ) -> ::std::os::raw::c_long,
>;
pub type RIOPtraceFuncFn = ::std::option::Option<
    unsafe extern "C" fn(
        io: *mut RIO,
        func: ::std::option::Option<
            unsafe extern "C" fn(arg1: *mut ::std::os::raw::c_void) -> *mut ::std::os::raw::c_void,
        >,
        user: *mut ::std::os::raw::c_void,
    ) -> *mut ::std::os::raw::c_void,
>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_io_bind_t {
    pub init: ::std::os::raw::c_int,
    pub io: *mut RIO,
    pub desc_use: RIODescUse,
    pub desc_get: RIODescGet,
    pub desc_size: RIODescSize,
    pub open: RIOOpen,
    pub open_at: RIOOpenAt,
    pub close: RIOClose,
    pub read_at: RIOReadAt,
    pub write_at: RIOWriteAt,
    pub system: RIOSystem,
    pub fd_open: RIOFdOpen,
    pub fd_close: RIOFdClose,
    pub fd_seek: RIOFdSeek,
    pub fd_size: RIOFdSize,
    pub fd_resize: RIOFdResize,
    pub fd_read: RIOFdRead,
    pub fd_write: RIOFdWrite,
    pub fd_read_at: RIOFdReadAt,
    pub fd_write_at: RIOFdWriteAt,
    pub fd_is_dbg: RIOFdIsDbg,
    pub fd_get_name: RIOFdGetName,
    pub fd_get_map: RIOFdGetMap,
    pub fd_remap: RIOFdRemap,
    pub is_valid_offset: RIOIsValidOff,
    pub addr_is_mapped: RIOAddrIsMapped,
    pub bank_get: RIOBankGet,
    pub map_get: RIOMapGet,
    pub map_get_at: RIOMapGetAt,
    pub map_get_paddr: RIOMapGetPaddr,
    pub map_add: RIOMapAdd,
    pub v2p: RIOV2P,
    pub p2v: RIOP2V,
    pub ptrace: RIOPtraceFn,
    pub ptrace_func: RIOPtraceFuncFn,
}
#[test]
fn bindgen_test_layout_r_io_bind_t() {
    assert_eq!(
        ::std::mem::size_of::<r_io_bind_t>(),
        280usize,
        concat!("Size of: ", stringify!(r_io_bind_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_io_bind_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_io_bind_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_io_bind_t>())).init as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_io_bind_t),
            "::",
            stringify!(init)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_io_bind_t>())).io as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_io_bind_t),
            "::",
            stringify!(io)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_io_bind_t>())).desc_use as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(r_io_bind_t),
            "::",
            stringify!(desc_use)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_io_bind_t>())).desc_get as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(r_io_bind_t),
            "::",
            stringify!(desc_get)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_io_bind_t>())).desc_size as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(r_io_bind_t),
            "::",
            stringify!(desc_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_io_bind_t>())).open as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(r_io_bind_t),
            "::",
            stringify!(open)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_io_bind_t>())).open_at as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(r_io_bind_t),
            "::",
            stringify!(open_at)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_io_bind_t>())).close as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(r_io_bind_t),
            "::",
            stringify!(close)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_io_bind_t>())).read_at as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(r_io_bind_t),
            "::",
            stringify!(read_at)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_io_bind_t>())).write_at as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(r_io_bind_t),
            "::",
            stringify!(write_at)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_io_bind_t>())).system as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(r_io_bind_t),
            "::",
            stringify!(system)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_io_bind_t>())).fd_open as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(r_io_bind_t),
            "::",
            stringify!(fd_open)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_io_bind_t>())).fd_close as *const _ as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(r_io_bind_t),
            "::",
            stringify!(fd_close)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_io_bind_t>())).fd_seek as *const _ as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(r_io_bind_t),
            "::",
            stringify!(fd_seek)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_io_bind_t>())).fd_size as *const _ as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(r_io_bind_t),
            "::",
            stringify!(fd_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_io_bind_t>())).fd_resize as *const _ as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(r_io_bind_t),
            "::",
            stringify!(fd_resize)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_io_bind_t>())).fd_read as *const _ as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(r_io_bind_t),
            "::",
            stringify!(fd_read)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_io_bind_t>())).fd_write as *const _ as usize },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(r_io_bind_t),
            "::",
            stringify!(fd_write)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_io_bind_t>())).fd_read_at as *const _ as usize },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(r_io_bind_t),
            "::",
            stringify!(fd_read_at)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_io_bind_t>())).fd_write_at as *const _ as usize },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(r_io_bind_t),
            "::",
            stringify!(fd_write_at)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_io_bind_t>())).fd_is_dbg as *const _ as usize },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(r_io_bind_t),
            "::",
            stringify!(fd_is_dbg)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_io_bind_t>())).fd_get_name as *const _ as usize },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(r_io_bind_t),
            "::",
            stringify!(fd_get_name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_io_bind_t>())).fd_get_map as *const _ as usize },
        176usize,
        concat!(
            "Offset of field: ",
            stringify!(r_io_bind_t),
            "::",
            stringify!(fd_get_map)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_io_bind_t>())).fd_remap as *const _ as usize },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(r_io_bind_t),
            "::",
            stringify!(fd_remap)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_io_bind_t>())).is_valid_offset as *const _ as usize },
        192usize,
        concat!(
            "Offset of field: ",
            stringify!(r_io_bind_t),
            "::",
            stringify!(is_valid_offset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_io_bind_t>())).addr_is_mapped as *const _ as usize },
        200usize,
        concat!(
            "Offset of field: ",
            stringify!(r_io_bind_t),
            "::",
            stringify!(addr_is_mapped)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_io_bind_t>())).bank_get as *const _ as usize },
        208usize,
        concat!(
            "Offset of field: ",
            stringify!(r_io_bind_t),
            "::",
            stringify!(bank_get)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_io_bind_t>())).map_get as *const _ as usize },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(r_io_bind_t),
            "::",
            stringify!(map_get)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_io_bind_t>())).map_get_at as *const _ as usize },
        224usize,
        concat!(
            "Offset of field: ",
            stringify!(r_io_bind_t),
            "::",
            stringify!(map_get_at)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_io_bind_t>())).map_get_paddr as *const _ as usize },
        232usize,
        concat!(
            "Offset of field: ",
            stringify!(r_io_bind_t),
            "::",
            stringify!(map_get_paddr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_io_bind_t>())).map_add as *const _ as usize },
        240usize,
        concat!(
            "Offset of field: ",
            stringify!(r_io_bind_t),
            "::",
            stringify!(map_add)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_io_bind_t>())).v2p as *const _ as usize },
        248usize,
        concat!(
            "Offset of field: ",
            stringify!(r_io_bind_t),
            "::",
            stringify!(v2p)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_io_bind_t>())).p2v as *const _ as usize },
        256usize,
        concat!(
            "Offset of field: ",
            stringify!(r_io_bind_t),
            "::",
            stringify!(p2v)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_io_bind_t>())).ptrace as *const _ as usize },
        264usize,
        concat!(
            "Offset of field: ",
            stringify!(r_io_bind_t),
            "::",
            stringify!(ptrace)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_io_bind_t>())).ptrace_func as *const _ as usize },
        272usize,
        concat!(
            "Offset of field: ",
            stringify!(r_io_bind_t),
            "::",
            stringify!(ptrace_func)
        )
    );
}
pub type RIOBind = r_io_bind_t;
extern "C" {
    pub fn r_io_map_init(io: *mut RIO);
}
extern "C" {
    pub fn r_io_map_remap(io: *mut RIO, id: u32, addr: u64) -> bool;
}
extern "C" {
    pub fn r_io_map_remap_fd(io: *mut RIO, fd: ::std::os::raw::c_int, addr: u64) -> bool;
}
extern "C" {
    pub fn r_io_map_exists(io: *mut RIO, map: *mut RIOMap) -> bool;
}
extern "C" {
    pub fn r_io_map_exists_for_id(io: *mut RIO, id: u32) -> bool;
}
extern "C" {
    pub fn r_io_map_get(io: *mut RIO, id: u32) -> *mut RIOMap;
}
extern "C" {
    pub fn r_io_map_add(
        io: *mut RIO,
        fd: ::std::os::raw::c_int,
        flags: ::std::os::raw::c_int,
        delta: u64,
        addr: u64,
        size: u64,
    ) -> *mut RIOMap;
}
extern "C" {
    pub fn r_io_map_add_bottom(
        io: *mut RIO,
        fd: ::std::os::raw::c_int,
        flags: ::std::os::raw::c_int,
        delta: u64,
        addr: u64,
        size: u64,
    ) -> *mut RIOMap;
}
extern "C" {
    pub fn r_io_map_get_at(io: *mut RIO, addr: u64) -> *mut RIOMap;
}
extern "C" {
    pub fn r_io_map_get_by_ref(io: *mut RIO, ref_: *mut RIOMapRef) -> *mut RIOMap;
}
extern "C" {
    pub fn r_io_map_is_mapped(io: *mut RIO, addr: u64) -> bool;
}
extern "C" {
    pub fn r_io_map_get_paddr(io: *mut RIO, paddr: u64) -> *mut RIOMap;
}
extern "C" {
    pub fn r_io_map_reset(io: *mut RIO);
}
extern "C" {
    pub fn r_io_map_del(io: *mut RIO, id: u32);
}
extern "C" {
    pub fn r_io_map_del_for_fd(io: *mut RIO, fd: ::std::os::raw::c_int) -> bool;
}
extern "C" {
    pub fn r_io_map_depriorize(io: *mut RIO, id: u32) -> bool;
}
extern "C" {
    pub fn r_io_map_priorize(io: *mut RIO, id: u32) -> bool;
}
extern "C" {
    pub fn r_io_map_priorize_for_fd(io: *mut RIO, fd: ::std::os::raw::c_int) -> bool;
}
extern "C" {
    pub fn r_io_map_cleanup(io: *mut RIO);
}
extern "C" {
    pub fn r_io_map_fini(io: *mut RIO);
}
extern "C" {
    pub fn r_io_map_is_in_range(map: *mut RIOMap, from: u64, to: u64) -> bool;
}
extern "C" {
    pub fn r_io_map_set_name(map: *mut RIOMap, name: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn r_io_map_del_name(map: *mut RIOMap);
}
extern "C" {
    pub fn r_io_map_get_by_fd(io: *mut RIO, fd: ::std::os::raw::c_int) -> *mut RList;
}
extern "C" {
    pub fn r_io_map_resize(io: *mut RIO, id: u32, newsize: u64) -> bool;
}
extern "C" {
    pub fn r_io_map_locate(io: *mut RIO, addr: *mut u64, size: u64, load_align: u64) -> bool;
}
extern "C" {
    pub fn r_io_p2v(io: *mut RIO, pa: u64) -> u64;
}
extern "C" {
    pub fn r_io_v2p(io: *mut RIO, va: u64) -> u64;
}
extern "C" {
    pub fn r_io_submap_new(io: *mut RIO, mapref: *mut RIOMapRef) -> *mut RIOSubMap;
}
extern "C" {
    pub fn r_io_submap_set_from(sm: *mut RIOSubMap, from: u64) -> bool;
}
extern "C" {
    pub fn r_io_submap_set_to(sm: *mut RIOSubMap, to: u64) -> bool;
}
extern "C" {
    pub fn r_io_bank_new(name: *const ::std::os::raw::c_char) -> *mut RIOBank;
}
extern "C" {
    pub fn r_io_bank_del(io: *mut RIO, bankid: u32);
}
extern "C" {
    pub fn r_io_bank_first(io: *mut RIO) -> u32;
}
extern "C" {
    pub fn r_io_bank_add(io: *mut RIO, bank: *mut RIOBank) -> bool;
}
extern "C" {
    pub fn r_io_bank_clear(bank: *mut RIOBank);
}
extern "C" {
    pub fn r_io_bank_free(bank: *mut RIOBank);
}
extern "C" {
    pub fn r_io_bank_init(io: *mut RIO);
}
extern "C" {
    pub fn r_io_bank_fini(io: *mut RIO);
}
extern "C" {
    pub fn r_io_bank_get(io: *mut RIO, bankid: u32) -> *mut RIOBank;
}
extern "C" {
    pub fn r_io_bank_use(io: *mut RIO, bankid: u32) -> bool;
}
extern "C" {
    pub fn r_io_bank_map_add_top(io: *mut RIO, bankid: u32, mapid: u32) -> bool;
}
extern "C" {
    pub fn r_io_bank_map_add_bottom(io: *mut RIO, bankid: u32, mapid: u32) -> bool;
}
extern "C" {
    pub fn r_io_bank_map_priorize(io: *mut RIO, bankid: u32, mapid: u32) -> bool;
}
extern "C" {
    pub fn r_io_bank_map_depriorize(io: *mut RIO, bankid: u32, mapid: u32) -> bool;
}
extern "C" {
    pub fn r_io_bank_update_map_boundaries(
        io: *mut RIO,
        bankid: u32,
        mapid: u32,
        ofrom: u64,
        oto: u64,
    ) -> bool;
}
extern "C" {
    pub fn r_io_bank_locate(
        io: *mut RIO,
        bankid: u32,
        addr: *mut u64,
        size: u64,
        load_align: u64,
    ) -> bool;
}
extern "C" {
    pub fn r_io_bank_del_map(io: *mut RIO, bankid: u32, mapid: u32);
}
extern "C" {
    pub fn r_io_bank_get_map_at(io: *mut RIO, bankid: u32, addr: u64) -> *mut RIOMap;
}
extern "C" {
    pub fn r_io_bank_read_at(
        io: *mut RIO,
        bankid: u32,
        addr: u64,
        buf: *mut u8,
        len: ::std::os::raw::c_int,
    ) -> bool;
}
extern "C" {
    pub fn r_io_bank_write_at(
        io: *mut RIO,
        bankid: u32,
        addr: u64,
        buf: *const u8,
        len: ::std::os::raw::c_int,
    ) -> bool;
}
extern "C" {
    pub fn r_io_bank_read_from_submap_at(
        io: *mut RIO,
        bankid: u32,
        addr: u64,
        buf: *mut u8,
        len: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_io_bank_write_to_submap_at(
        io: *mut RIO,
        bankid: u32,
        addr: u64,
        buf: *const u8,
        len: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_io_bank_drain(io: *mut RIO, bankid: u32);
}
extern "C" {
    pub fn r_io_new() -> *mut RIO;
}
extern "C" {
    pub fn r_io_init(io: *mut RIO) -> *mut RIO;
}
extern "C" {
    pub fn r_io_open_nomap(
        io: *mut RIO,
        uri: *const ::std::os::raw::c_char,
        flags: ::std::os::raw::c_int,
        mode: ::std::os::raw::c_int,
    ) -> *mut RIODesc;
}
extern "C" {
    pub fn r_io_open(
        io: *mut RIO,
        uri: *const ::std::os::raw::c_char,
        flags: ::std::os::raw::c_int,
        mode: ::std::os::raw::c_int,
    ) -> *mut RIODesc;
}
extern "C" {
    pub fn r_io_open_at(
        io: *mut RIO,
        uri: *const ::std::os::raw::c_char,
        flags: ::std::os::raw::c_int,
        mode: ::std::os::raw::c_int,
        at: u64,
    ) -> *mut RIODesc;
}
extern "C" {
    pub fn r_io_open_many(
        io: *mut RIO,
        uri: *const ::std::os::raw::c_char,
        flags: ::std::os::raw::c_int,
        mode: ::std::os::raw::c_int,
    ) -> *mut RList;
}
extern "C" {
    pub fn r_io_open_buffer(
        io: *mut RIO,
        b: *mut RBuffer,
        flags: ::std::os::raw::c_int,
        mode: ::std::os::raw::c_int,
    ) -> *mut RIODesc;
}
extern "C" {
    pub fn r_io_close(io: *mut RIO) -> bool;
}
extern "C" {
    pub fn r_io_reopen(
        io: *mut RIO,
        fd: ::std::os::raw::c_int,
        flags: ::std::os::raw::c_int,
        mode: ::std::os::raw::c_int,
    ) -> bool;
}
extern "C" {
    pub fn r_io_close_all(io: *mut RIO);
}
extern "C" {
    pub fn r_io_pread_at(
        io: *mut RIO,
        paddr: u64,
        buf: *mut u8,
        len: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_io_pwrite_at(
        io: *mut RIO,
        paddr: u64,
        buf: *const u8,
        len: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_io_vread_at(
        io: *mut RIO,
        vaddr: u64,
        buf: *mut u8,
        len: ::std::os::raw::c_int,
    ) -> bool;
}
extern "C" {
    pub fn r_io_vwrite_at(
        io: *mut RIO,
        vaddr: u64,
        buf: *const u8,
        len: ::std::os::raw::c_int,
    ) -> bool;
}
extern "C" {
    pub fn r_io_read_at(io: *mut RIO, addr: u64, buf: *mut u8, len: ::std::os::raw::c_int) -> bool;
}
extern "C" {
    pub fn r_io_read_at_mapped(
        io: *mut RIO,
        addr: u64,
        buf: *mut u8,
        len: ::std::os::raw::c_int,
    ) -> bool;
}
extern "C" {
    pub fn r_io_nread_at(
        io: *mut RIO,
        addr: u64,
        buf: *mut u8,
        len: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_io_write_at(
        io: *mut RIO,
        addr: u64,
        buf: *const u8,
        len: ::std::os::raw::c_int,
    ) -> bool;
}
extern "C" {
    pub fn r_io_read(io: *mut RIO, buf: *mut u8, len: ::std::os::raw::c_int) -> bool;
}
extern "C" {
    pub fn r_io_write(io: *mut RIO, buf: *mut u8, len: ::std::os::raw::c_int) -> bool;
}
extern "C" {
    pub fn r_io_size(io: *mut RIO) -> u64;
}
extern "C" {
    pub fn r_io_is_listener(io: *mut RIO) -> bool;
}
extern "C" {
    pub fn r_io_system(
        io: *mut RIO,
        cmd: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_io_resize(io: *mut RIO, newsize: u64) -> bool;
}
extern "C" {
    pub fn r_io_extend_at(io: *mut RIO, addr: u64, size: u64) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_io_set_write_mask(io: *mut RIO, mask: *const u8, len: ::std::os::raw::c_int) -> bool;
}
extern "C" {
    pub fn r_io_bind(io: *mut RIO, bnd: *mut RIOBind);
}
extern "C" {
    pub fn r_io_shift(io: *mut RIO, start: u64, end: u64, move_: i64) -> bool;
}
extern "C" {
    pub fn r_io_seek(io: *mut RIO, offset: u64, whence: ::std::os::raw::c_int) -> u64;
}
extern "C" {
    pub fn r_io_fini(io: *mut RIO);
}
extern "C" {
    pub fn r_io_free(io: *mut RIO);
}
extern "C" {
    pub fn r_io_plugin_init(io: *mut RIO) -> bool;
}
extern "C" {
    pub fn r_io_plugin_add(io: *mut RIO, plugin: *mut RIOPlugin) -> bool;
}
extern "C" {
    pub fn r_io_plugin_list(io: *mut RIO) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_io_plugin_list_json(io: *mut RIO) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_io_plugin_read(
        desc: *mut RIODesc,
        buf: *mut u8,
        len: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_io_plugin_write(
        desc: *mut RIODesc,
        buf: *const u8,
        len: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_io_plugin_read_at(
        desc: *mut RIODesc,
        addr: u64,
        buf: *mut u8,
        len: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_io_plugin_write_at(
        desc: *mut RIODesc,
        addr: u64,
        buf: *const u8,
        len: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_io_plugin_resolve(
        io: *mut RIO,
        filename: *const ::std::os::raw::c_char,
        many: bool,
    ) -> *mut RIOPlugin;
}
extern "C" {
    pub fn r_io_plugin_get_default(
        io: *mut RIO,
        filename: *const ::std::os::raw::c_char,
        many: bool,
    ) -> *mut RIOPlugin;
}
extern "C" {
    pub fn r_io_undo_init(io: *mut RIO) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_io_undo_enable(
        io: *mut RIO,
        seek: ::std::os::raw::c_int,
        write: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn r_io_sundo(io: *mut RIO, offset: u64) -> *mut RIOUndos;
}
extern "C" {
    pub fn r_io_sundo_redo(io: *mut RIO) -> *mut RIOUndos;
}
extern "C" {
    pub fn r_io_sundo_push(io: *mut RIO, off: u64, cursor: ::std::os::raw::c_int);
}
extern "C" {
    pub fn r_io_sundo_reset(io: *mut RIO);
}
extern "C" {
    pub fn r_io_sundo_list(io: *mut RIO, mode: ::std::os::raw::c_int) -> *mut RList;
}
extern "C" {
    pub fn r_io_wundo_new(io: *mut RIO, off: u64, data: *const u8, len: ::std::os::raw::c_int);
}
extern "C" {
    pub fn r_io_wundo_apply_all(io: *mut RIO, set: ::std::os::raw::c_int);
}
extern "C" {
    pub fn r_io_wundo_apply(
        io: *mut RIO,
        u: *mut r_io_undo_w_t,
        set: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_io_wundo_clear(io: *mut RIO);
}
extern "C" {
    pub fn r_io_wundo_size(io: *mut RIO) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_io_wundo_list(io: *mut RIO);
}
extern "C" {
    pub fn r_io_wundo_set_t(
        io: *mut RIO,
        u: *mut RIOUndoWrite,
        set: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_io_wundo_set_all(io: *mut RIO, set: ::std::os::raw::c_int);
}
extern "C" {
    pub fn r_io_wundo_set(
        io: *mut RIO,
        n: ::std::os::raw::c_int,
        set: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_io_desc_new(
        io: *mut RIO,
        plugin: *mut RIOPlugin,
        uri: *const ::std::os::raw::c_char,
        flags: ::std::os::raw::c_int,
        mode: ::std::os::raw::c_int,
        data: *mut ::std::os::raw::c_void,
    ) -> *mut RIODesc;
}
extern "C" {
    pub fn r_io_desc_open(
        io: *mut RIO,
        uri: *const ::std::os::raw::c_char,
        flags: ::std::os::raw::c_int,
        mode: ::std::os::raw::c_int,
    ) -> *mut RIODesc;
}
extern "C" {
    pub fn r_io_desc_open_plugin(
        io: *mut RIO,
        plugin: *mut RIOPlugin,
        uri: *const ::std::os::raw::c_char,
        flags: ::std::os::raw::c_int,
        mode: ::std::os::raw::c_int,
    ) -> *mut RIODesc;
}
extern "C" {
    pub fn r_io_desc_close(desc: *mut RIODesc) -> bool;
}
extern "C" {
    pub fn r_io_desc_read(
        desc: *mut RIODesc,
        buf: *mut u8,
        count: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_io_desc_write(
        desc: *mut RIODesc,
        buf: *const u8,
        count: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_io_desc_free(desc: *mut RIODesc);
}
extern "C" {
    pub fn r_io_desc_add(io: *mut RIO, desc: *mut RIODesc) -> bool;
}
extern "C" {
    pub fn r_io_desc_del(io: *mut RIO, fd: ::std::os::raw::c_int) -> bool;
}
extern "C" {
    pub fn r_io_desc_get(io: *mut RIO, fd: ::std::os::raw::c_int) -> *mut RIODesc;
}
extern "C" {
    pub fn r_io_desc_get_byuri(io: *mut RIO, uri: *const ::std::os::raw::c_char) -> *mut RIODesc;
}
extern "C" {
    pub fn r_io_desc_get_next(io: *mut RIO, desc: *mut RIODesc) -> *mut RIODesc;
}
extern "C" {
    pub fn r_io_desc_get_prev(io: *mut RIO, desc: *mut RIODesc) -> *mut RIODesc;
}
extern "C" {
    pub fn r_io_desc_get_highest(io: *mut RIO) -> *mut RIODesc;
}
extern "C" {
    pub fn r_io_desc_get_lowest(io: *mut RIO) -> *mut RIODesc;
}
extern "C" {
    pub fn r_io_desc_seek(desc: *mut RIODesc, offset: u64, whence: ::std::os::raw::c_int) -> u64;
}
extern "C" {
    pub fn r_io_desc_resize(desc: *mut RIODesc, newsize: u64) -> bool;
}
extern "C" {
    pub fn r_io_desc_size(desc: *mut RIODesc) -> u64;
}
extern "C" {
    pub fn r_io_desc_is_blockdevice(desc: *mut RIODesc) -> bool;
}
extern "C" {
    pub fn r_io_desc_is_chardevice(desc: *mut RIODesc) -> bool;
}
extern "C" {
    pub fn r_io_desc_exchange(
        io: *mut RIO,
        fd: ::std::os::raw::c_int,
        fdx: ::std::os::raw::c_int,
    ) -> bool;
}
extern "C" {
    pub fn r_io_desc_is_dbg(desc: *mut RIODesc) -> bool;
}
extern "C" {
    pub fn r_io_desc_get_pid(desc: *mut RIODesc) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_io_desc_get_tid(desc: *mut RIODesc) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_io_desc_get_base(desc: *mut RIODesc, base: *mut u64) -> bool;
}
extern "C" {
    pub fn r_io_desc_read_at(
        desc: *mut RIODesc,
        addr: u64,
        buf: *mut u8,
        len: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_io_desc_write_at(
        desc: *mut RIODesc,
        addr: u64,
        buf: *const u8,
        len: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_io_desc_init(io: *mut RIO) -> bool;
}
extern "C" {
    pub fn r_io_desc_fini(io: *mut RIO);
}
extern "C" {
    pub fn r_io_cache_invalidate(io: *mut RIO, from: u64, to: u64) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_io_cache_at(io: *mut RIO, addr: u64) -> bool;
}
extern "C" {
    pub fn r_io_cache_commit(io: *mut RIO, from: u64, to: u64);
}
extern "C" {
    pub fn r_io_cache_init(io: *mut RIO);
}
extern "C" {
    pub fn r_io_cache_fini(io: *mut RIO);
}
extern "C" {
    pub fn r_io_cache_list(io: *mut RIO, rad: ::std::os::raw::c_int) -> bool;
}
extern "C" {
    pub fn r_io_cache_reset(io: *mut RIO, set: ::std::os::raw::c_int);
}
extern "C" {
    pub fn r_io_cache_write(
        io: *mut RIO,
        addr: u64,
        buf: *const u8,
        len: ::std::os::raw::c_int,
    ) -> bool;
}
extern "C" {
    pub fn r_io_cache_read(
        io: *mut RIO,
        addr: u64,
        buf: *mut u8,
        len: ::std::os::raw::c_int,
    ) -> bool;
}
extern "C" {
    pub fn r_io_desc_cache_init(desc: *mut RIODesc) -> bool;
}
extern "C" {
    pub fn r_io_desc_cache_write(
        desc: *mut RIODesc,
        paddr: u64,
        buf: *const u8,
        len: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_io_desc_cache_read(
        desc: *mut RIODesc,
        paddr: u64,
        buf: *mut u8,
        len: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_io_desc_cache_commit(desc: *mut RIODesc) -> bool;
}
extern "C" {
    pub fn r_io_desc_cache_cleanup(desc: *mut RIODesc);
}
extern "C" {
    pub fn r_io_desc_cache_fini(desc: *mut RIODesc);
}
extern "C" {
    pub fn r_io_desc_cache_fini_all(io: *mut RIO);
}
extern "C" {
    pub fn r_io_desc_cache_list(desc: *mut RIODesc) -> *mut RList;
}
extern "C" {
    pub fn r_io_desc_extend(desc: *mut RIODesc, size: u64) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_io_buffer_read(
        io: *mut RIO,
        addr: u64,
        buf: *mut u8,
        len: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_io_buffer_load(
        io: *mut RIO,
        addr: u64,
        len: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_io_buffer_close(io: *mut RIO);
}
extern "C" {
    pub fn r_io_fd_open(
        io: *mut RIO,
        uri: *const ::std::os::raw::c_char,
        flags: ::std::os::raw::c_int,
        mode: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_io_fd_close(io: *mut RIO, fd: ::std::os::raw::c_int) -> bool;
}
extern "C" {
    pub fn r_io_fd_read(
        io: *mut RIO,
        fd: ::std::os::raw::c_int,
        buf: *mut u8,
        len: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_io_fd_write(
        io: *mut RIO,
        fd: ::std::os::raw::c_int,
        buf: *const u8,
        len: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_io_fd_seek(
        io: *mut RIO,
        fd: ::std::os::raw::c_int,
        addr: u64,
        whence: ::std::os::raw::c_int,
    ) -> u64;
}
extern "C" {
    pub fn r_io_fd_size(io: *mut RIO, fd: ::std::os::raw::c_int) -> u64;
}
extern "C" {
    pub fn r_io_fd_resize(io: *mut RIO, fd: ::std::os::raw::c_int, newsize: u64) -> bool;
}
extern "C" {
    pub fn r_io_fd_is_blockdevice(io: *mut RIO, fd: ::std::os::raw::c_int) -> bool;
}
extern "C" {
    pub fn r_io_fd_is_chardevice(io: *mut RIO, fd: ::std::os::raw::c_int) -> bool;
}
extern "C" {
    pub fn r_io_fd_read_at(
        io: *mut RIO,
        fd: ::std::os::raw::c_int,
        addr: u64,
        buf: *mut u8,
        len: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_io_fd_write_at(
        io: *mut RIO,
        fd: ::std::os::raw::c_int,
        addr: u64,
        buf: *const u8,
        len: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_io_fd_is_dbg(io: *mut RIO, fd: ::std::os::raw::c_int) -> bool;
}
extern "C" {
    pub fn r_io_fd_get_pid(io: *mut RIO, fd: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_io_fd_get_tid(io: *mut RIO, fd: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_io_fd_get_base(io: *mut RIO, fd: ::std::os::raw::c_int, base: *mut u64) -> bool;
}
extern "C" {
    pub fn r_io_fd_get_name(
        io: *mut RIO,
        fd: ::std::os::raw::c_int,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_io_fd_get_current(io: *mut RIO) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_io_use_fd(io: *mut RIO, fd: ::std::os::raw::c_int) -> bool;
}
extern "C" {
    pub fn r_io_fd_get_next(io: *mut RIO, fd: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_io_fd_get_prev(io: *mut RIO, fd: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_io_fd_get_highest(io: *mut RIO) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_io_fd_get_lowest(io: *mut RIO) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_io_is_valid_offset(io: *mut RIO, offset: u64, hasperm: ::std::os::raw::c_int) -> bool;
}
extern "C" {
    pub fn r_io_addr_is_mapped(io: *mut RIO, vaddr: u64) -> bool;
}
extern "C" {
    pub fn r_io_read_i(
        io: *mut RIO,
        addr: u64,
        val: *mut u64,
        size: ::std::os::raw::c_int,
        endian: bool,
    ) -> bool;
}
extern "C" {
    pub fn r_io_write_i(
        io: *mut RIO,
        addr: u64,
        val: *mut u64,
        size: ::std::os::raw::c_int,
        endian: bool,
    ) -> bool;
}
extern "C" {
    pub fn r_io_ptrace(
        io: *mut RIO,
        request: r_ptrace_request_t,
        pid: pid_t,
        addr: *mut ::std::os::raw::c_void,
        data: r_ptrace_data_t,
    ) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn r_io_ptrace_fork(
        io: *mut RIO,
        child_callback: ::std::option::Option<
            unsafe extern "C" fn(arg1: *mut ::std::os::raw::c_void),
        >,
        child_callback_user: *mut ::std::os::raw::c_void,
    ) -> pid_t;
}
extern "C" {
    pub fn r_io_ptrace_func(
        io: *mut RIO,
        func: ::std::option::Option<
            unsafe extern "C" fn(arg1: *mut ::std::os::raw::c_void) -> *mut ::std::os::raw::c_void,
        >,
        user: *mut ::std::os::raw::c_void,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn r_fs_version() -> *const ::std::os::raw::c_char;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_fs_t {
    pub iob: RIOBind,
    pub cob: RCoreBind,
    pub csb: RConsBind,
    pub plugins: *mut RList,
    pub roots: *mut RList,
    pub view: ::std::os::raw::c_int,
    pub ptr: *mut ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout_r_fs_t() {
    assert_eq!(
        ::std::mem::size_of::<r_fs_t>(),
        504usize,
        concat!("Size of: ", stringify!(r_fs_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_fs_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_fs_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_fs_t>())).iob as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_fs_t),
            "::",
            stringify!(iob)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_fs_t>())).cob as *const _ as usize },
        280usize,
        concat!(
            "Offset of field: ",
            stringify!(r_fs_t),
            "::",
            stringify!(cob)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_fs_t>())).csb as *const _ as usize },
        424usize,
        concat!(
            "Offset of field: ",
            stringify!(r_fs_t),
            "::",
            stringify!(csb)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_fs_t>())).plugins as *const _ as usize },
        472usize,
        concat!(
            "Offset of field: ",
            stringify!(r_fs_t),
            "::",
            stringify!(plugins)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_fs_t>())).roots as *const _ as usize },
        480usize,
        concat!(
            "Offset of field: ",
            stringify!(r_fs_t),
            "::",
            stringify!(roots)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_fs_t>())).view as *const _ as usize },
        488usize,
        concat!(
            "Offset of field: ",
            stringify!(r_fs_t),
            "::",
            stringify!(view)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_fs_t>())).ptr as *const _ as usize },
        496usize,
        concat!(
            "Offset of field: ",
            stringify!(r_fs_t),
            "::",
            stringify!(ptr)
        )
    );
}
pub type RFS = r_fs_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_fs_file_t {
    pub name: *mut ::std::os::raw::c_char,
    pub path: *mut ::std::os::raw::c_char,
    pub off: u64,
    pub size: u32,
    pub data: *mut u8,
    pub ctx: *mut ::std::os::raw::c_void,
    pub type_: ::std::os::raw::c_char,
    pub time: u64,
    pub p: *mut r_fs_plugin_t,
    pub root: *mut r_fs_root_t,
    pub ptr: *mut ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout_r_fs_file_t() {
    assert_eq!(
        ::std::mem::size_of::<r_fs_file_t>(),
        88usize,
        concat!("Size of: ", stringify!(r_fs_file_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_fs_file_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_fs_file_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_fs_file_t>())).name as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_fs_file_t),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_fs_file_t>())).path as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_fs_file_t),
            "::",
            stringify!(path)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_fs_file_t>())).off as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(r_fs_file_t),
            "::",
            stringify!(off)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_fs_file_t>())).size as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(r_fs_file_t),
            "::",
            stringify!(size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_fs_file_t>())).data as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(r_fs_file_t),
            "::",
            stringify!(data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_fs_file_t>())).ctx as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(r_fs_file_t),
            "::",
            stringify!(ctx)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_fs_file_t>())).type_ as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(r_fs_file_t),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_fs_file_t>())).time as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(r_fs_file_t),
            "::",
            stringify!(time)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_fs_file_t>())).p as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(r_fs_file_t),
            "::",
            stringify!(p)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_fs_file_t>())).root as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(r_fs_file_t),
            "::",
            stringify!(root)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_fs_file_t>())).ptr as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(r_fs_file_t),
            "::",
            stringify!(ptr)
        )
    );
}
pub type RFSFile = r_fs_file_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_fs_root_t {
    pub path: *mut ::std::os::raw::c_char,
    pub delta: u64,
    pub p: *mut r_fs_plugin_t,
    pub ptr: *mut ::std::os::raw::c_void,
    pub iob: RIOBind,
    pub cob: RCoreBind,
}
#[test]
fn bindgen_test_layout_r_fs_root_t() {
    assert_eq!(
        ::std::mem::size_of::<r_fs_root_t>(),
        456usize,
        concat!("Size of: ", stringify!(r_fs_root_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_fs_root_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_fs_root_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_fs_root_t>())).path as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_fs_root_t),
            "::",
            stringify!(path)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_fs_root_t>())).delta as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_fs_root_t),
            "::",
            stringify!(delta)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_fs_root_t>())).p as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(r_fs_root_t),
            "::",
            stringify!(p)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_fs_root_t>())).ptr as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(r_fs_root_t),
            "::",
            stringify!(ptr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_fs_root_t>())).iob as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(r_fs_root_t),
            "::",
            stringify!(iob)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_fs_root_t>())).cob as *const _ as usize },
        312usize,
        concat!(
            "Offset of field: ",
            stringify!(r_fs_root_t),
            "::",
            stringify!(cob)
        )
    );
}
pub type RFSRoot = r_fs_root_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_fs_plugin_t {
    pub name: *const ::std::os::raw::c_char,
    pub desc: *const ::std::os::raw::c_char,
    pub license: *const ::std::os::raw::c_char,
    pub slurp: ::std::option::Option<
        unsafe extern "C" fn(
            root: *mut RFSRoot,
            path: *const ::std::os::raw::c_char,
        ) -> *mut RFSFile,
    >,
    pub open: ::std::option::Option<
        unsafe extern "C" fn(
            root: *mut RFSRoot,
            path: *const ::std::os::raw::c_char,
            create: bool,
        ) -> *mut RFSFile,
    >,
    pub unlink: ::std::option::Option<
        unsafe extern "C" fn(root: *mut RFSRoot, path: *const ::std::os::raw::c_char) -> bool,
    >,
    pub write: ::std::option::Option<
        unsafe extern "C" fn(
            fs: *mut RFSFile,
            addr: u64,
            data: *const u8,
            len: ::std::os::raw::c_int,
        ) -> ::std::os::raw::c_int,
    >,
    pub read: ::std::option::Option<
        unsafe extern "C" fn(
            fs: *mut RFSFile,
            addr: u64,
            len: ::std::os::raw::c_int,
        ) -> ::std::os::raw::c_int,
    >,
    pub close: ::std::option::Option<unsafe extern "C" fn(fs: *mut RFSFile)>,
    pub dir: ::std::option::Option<
        unsafe extern "C" fn(
            root: *mut RFSRoot,
            path: *const ::std::os::raw::c_char,
            view: ::std::os::raw::c_int,
        ) -> *mut RList,
    >,
    pub init: ::std::option::Option<unsafe extern "C" fn()>,
    pub fini: ::std::option::Option<unsafe extern "C" fn()>,
    pub mount:
        ::std::option::Option<unsafe extern "C" fn(root: *mut RFSRoot) -> ::std::os::raw::c_int>,
    pub umount: ::std::option::Option<unsafe extern "C" fn(root: *mut RFSRoot)>,
}
#[test]
fn bindgen_test_layout_r_fs_plugin_t() {
    assert_eq!(
        ::std::mem::size_of::<r_fs_plugin_t>(),
        112usize,
        concat!("Size of: ", stringify!(r_fs_plugin_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_fs_plugin_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_fs_plugin_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_fs_plugin_t>())).name as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_fs_plugin_t),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_fs_plugin_t>())).desc as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_fs_plugin_t),
            "::",
            stringify!(desc)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_fs_plugin_t>())).license as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(r_fs_plugin_t),
            "::",
            stringify!(license)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_fs_plugin_t>())).slurp as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(r_fs_plugin_t),
            "::",
            stringify!(slurp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_fs_plugin_t>())).open as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(r_fs_plugin_t),
            "::",
            stringify!(open)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_fs_plugin_t>())).unlink as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(r_fs_plugin_t),
            "::",
            stringify!(unlink)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_fs_plugin_t>())).write as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(r_fs_plugin_t),
            "::",
            stringify!(write)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_fs_plugin_t>())).read as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(r_fs_plugin_t),
            "::",
            stringify!(read)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_fs_plugin_t>())).close as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(r_fs_plugin_t),
            "::",
            stringify!(close)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_fs_plugin_t>())).dir as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(r_fs_plugin_t),
            "::",
            stringify!(dir)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_fs_plugin_t>())).init as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(r_fs_plugin_t),
            "::",
            stringify!(init)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_fs_plugin_t>())).fini as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(r_fs_plugin_t),
            "::",
            stringify!(fini)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_fs_plugin_t>())).mount as *const _ as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(r_fs_plugin_t),
            "::",
            stringify!(mount)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_fs_plugin_t>())).umount as *const _ as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(r_fs_plugin_t),
            "::",
            stringify!(umount)
        )
    );
}
pub type RFSPlugin = r_fs_plugin_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_fs_partition_t {
    pub number: ::std::os::raw::c_int,
    pub start: u64,
    pub length: u64,
    pub index: ::std::os::raw::c_int,
    pub type_: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_r_fs_partition_t() {
    assert_eq!(
        ::std::mem::size_of::<r_fs_partition_t>(),
        32usize,
        concat!("Size of: ", stringify!(r_fs_partition_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_fs_partition_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_fs_partition_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_fs_partition_t>())).number as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_fs_partition_t),
            "::",
            stringify!(number)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_fs_partition_t>())).start as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_fs_partition_t),
            "::",
            stringify!(start)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_fs_partition_t>())).length as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(r_fs_partition_t),
            "::",
            stringify!(length)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_fs_partition_t>())).index as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(r_fs_partition_t),
            "::",
            stringify!(index)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_fs_partition_t>())).type_ as *const _ as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(r_fs_partition_t),
            "::",
            stringify!(type_)
        )
    );
}
pub type RFSPartition = r_fs_partition_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_fs_shell_t {
    pub cwd: *mut *mut ::std::os::raw::c_char,
    pub set_prompt:
        ::std::option::Option<unsafe extern "C" fn(prompt: *const ::std::os::raw::c_char)>,
    pub readline: ::std::option::Option<unsafe extern "C" fn() -> *const ::std::os::raw::c_char>,
    pub hist_add: ::std::option::Option<
        unsafe extern "C" fn(line: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int,
    >,
}
#[test]
fn bindgen_test_layout_r_fs_shell_t() {
    assert_eq!(
        ::std::mem::size_of::<r_fs_shell_t>(),
        32usize,
        concat!("Size of: ", stringify!(r_fs_shell_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_fs_shell_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_fs_shell_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_fs_shell_t>())).cwd as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_fs_shell_t),
            "::",
            stringify!(cwd)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_fs_shell_t>())).set_prompt as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_fs_shell_t),
            "::",
            stringify!(set_prompt)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_fs_shell_t>())).readline as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(r_fs_shell_t),
            "::",
            stringify!(readline)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_fs_shell_t>())).hist_add as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(r_fs_shell_t),
            "::",
            stringify!(hist_add)
        )
    );
}
pub type RFSShell = r_fs_shell_t;
extern "C" {
    pub fn r_fs_new() -> *mut RFS;
}
extern "C" {
    pub fn r_fs_view(fs: *mut RFS, view: ::std::os::raw::c_int);
}
extern "C" {
    pub fn r_fs_free(fs: *mut RFS);
}
extern "C" {
    pub fn r_fs_add(fs: *mut RFS, p: *mut RFSPlugin);
}
extern "C" {
    pub fn r_fs_del(fs: *mut RFS, p: *mut RFSPlugin);
}
extern "C" {
    pub fn r_fs_mount(
        fs: *mut RFS,
        fstype: *const ::std::os::raw::c_char,
        path: *const ::std::os::raw::c_char,
        delta: u64,
    ) -> *mut RFSRoot;
}
extern "C" {
    pub fn r_fs_umount(fs: *mut RFS, path: *const ::std::os::raw::c_char) -> bool;
}
extern "C" {
    pub fn r_fs_root(fs: *mut RFS, path: *const ::std::os::raw::c_char) -> *mut RList;
}
extern "C" {
    pub fn r_fs_open(
        fs: *mut RFS,
        path: *const ::std::os::raw::c_char,
        create: bool,
    ) -> *mut RFSFile;
}
extern "C" {
    pub fn r_fs_close(fs: *mut RFS, file: *mut RFSFile);
}
extern "C" {
    pub fn r_fs_read(
        fs: *mut RFS,
        file: *mut RFSFile,
        addr: u64,
        len: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_fs_write(
        fs: *mut RFS,
        file: *mut RFSFile,
        addr: u64,
        data: *const u8,
        len: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_fs_slurp(fs: *mut RFS, path: *const ::std::os::raw::c_char) -> *mut RFSFile;
}
extern "C" {
    pub fn r_fs_dir(fs: *mut RFS, path: *const ::std::os::raw::c_char) -> *mut RList;
}
extern "C" {
    pub fn r_fs_dir_dump(
        fs: *mut RFS,
        path: *const ::std::os::raw::c_char,
        name: *const ::std::os::raw::c_char,
    ) -> bool;
}
extern "C" {
    pub fn r_fs_find_name(
        fs: *mut RFS,
        name: *const ::std::os::raw::c_char,
        glob: *const ::std::os::raw::c_char,
    ) -> *mut RList;
}
extern "C" {
    pub fn r_fs_find_off(fs: *mut RFS, name: *const ::std::os::raw::c_char, off: u64)
        -> *mut RList;
}
extern "C" {
    pub fn r_fs_partitions(
        fs: *mut RFS,
        ptype: *const ::std::os::raw::c_char,
        delta: u64,
    ) -> *mut RList;
}
extern "C" {
    pub fn r_fs_name(fs: *mut RFS, offset: u64) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_fs_prompt(fs: *mut RFS, root: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_fs_check(fs: *mut RFS, p: *const ::std::os::raw::c_char) -> bool;
}
extern "C" {
    pub fn r_fs_shell_prompt(
        shell: *mut RFSShell,
        fs: *mut RFS,
        root: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_fs_file_new(root: *mut RFSRoot, path: *const ::std::os::raw::c_char) -> *mut RFSFile;
}
extern "C" {
    pub fn r_fs_file_free(file: *mut RFSFile);
}
extern "C" {
    pub fn r_fs_file_copy_abs_path(file: *mut RFSFile) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_fs_root_new(path: *const ::std::os::raw::c_char, delta: u64) -> *mut RFSRoot;
}
extern "C" {
    pub fn r_fs_root_free(root: *mut RFSRoot);
}
extern "C" {
    pub fn r_fs_partition_new(
        num: ::std::os::raw::c_int,
        start: u64,
        length: u64,
    ) -> *mut RFSPartition;
}
extern "C" {
    pub fn r_fs_partition_free(p: *mut RFSPartition);
}
extern "C" {
    pub fn r_fs_partition_type(
        part: *const ::std::os::raw::c_char,
        type_: ::std::os::raw::c_int,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_fs_partition_type_get(n: ::std::os::raw::c_int) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_fs_partition_get_size() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_lib_version() -> *const ::std::os::raw::c_char;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_lib_plugin_t {
    pub type_: ::std::os::raw::c_int,
    pub file: *mut ::std::os::raw::c_char,
    pub data: *mut ::std::os::raw::c_void,
    pub handler: *mut r_lib_handler_t,
    pub dl_handler: *mut ::std::os::raw::c_void,
    pub author: *mut ::std::os::raw::c_char,
    pub version: *mut ::std::os::raw::c_char,
    pub free: ::std::option::Option<unsafe extern "C" fn(data: *mut ::std::os::raw::c_void)>,
}
#[test]
fn bindgen_test_layout_r_lib_plugin_t() {
    assert_eq!(
        ::std::mem::size_of::<r_lib_plugin_t>(),
        64usize,
        concat!("Size of: ", stringify!(r_lib_plugin_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_lib_plugin_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_lib_plugin_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_lib_plugin_t>())).type_ as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_lib_plugin_t),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_lib_plugin_t>())).file as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_lib_plugin_t),
            "::",
            stringify!(file)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_lib_plugin_t>())).data as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(r_lib_plugin_t),
            "::",
            stringify!(data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_lib_plugin_t>())).handler as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(r_lib_plugin_t),
            "::",
            stringify!(handler)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_lib_plugin_t>())).dl_handler as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(r_lib_plugin_t),
            "::",
            stringify!(dl_handler)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_lib_plugin_t>())).author as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(r_lib_plugin_t),
            "::",
            stringify!(author)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_lib_plugin_t>())).version as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(r_lib_plugin_t),
            "::",
            stringify!(version)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_lib_plugin_t>())).free as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(r_lib_plugin_t),
            "::",
            stringify!(free)
        )
    );
}
pub type RLibPlugin = r_lib_plugin_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_lib_handler_t {
    pub type_: ::std::os::raw::c_int,
    pub desc: [::std::os::raw::c_char; 128usize],
    pub user: *mut ::std::os::raw::c_void,
    pub constructor: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut RLibPlugin,
            user: *mut ::std::os::raw::c_void,
            data: *mut ::std::os::raw::c_void,
        ) -> ::std::os::raw::c_int,
    >,
    pub destructor: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut RLibPlugin,
            user: *mut ::std::os::raw::c_void,
            data: *mut ::std::os::raw::c_void,
        ) -> ::std::os::raw::c_int,
    >,
}
#[test]
fn bindgen_test_layout_r_lib_handler_t() {
    assert_eq!(
        ::std::mem::size_of::<r_lib_handler_t>(),
        160usize,
        concat!("Size of: ", stringify!(r_lib_handler_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_lib_handler_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_lib_handler_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_lib_handler_t>())).type_ as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_lib_handler_t),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_lib_handler_t>())).desc as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(r_lib_handler_t),
            "::",
            stringify!(desc)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_lib_handler_t>())).user as *const _ as usize },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(r_lib_handler_t),
            "::",
            stringify!(user)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_lib_handler_t>())).constructor as *const _ as usize },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(r_lib_handler_t),
            "::",
            stringify!(constructor)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_lib_handler_t>())).destructor as *const _ as usize },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(r_lib_handler_t),
            "::",
            stringify!(destructor)
        )
    );
}
pub type RLibHandler = r_lib_handler_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_lib_struct_t {
    pub type_: ::std::os::raw::c_int,
    pub data: *mut ::std::os::raw::c_void,
    pub version: *const ::std::os::raw::c_char,
    pub free: ::std::option::Option<unsafe extern "C" fn(data: *mut ::std::os::raw::c_void)>,
    pub pkgname: *const ::std::os::raw::c_char,
}
#[test]
fn bindgen_test_layout_r_lib_struct_t() {
    assert_eq!(
        ::std::mem::size_of::<r_lib_struct_t>(),
        40usize,
        concat!("Size of: ", stringify!(r_lib_struct_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_lib_struct_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_lib_struct_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_lib_struct_t>())).type_ as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_lib_struct_t),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_lib_struct_t>())).data as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_lib_struct_t),
            "::",
            stringify!(data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_lib_struct_t>())).version as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(r_lib_struct_t),
            "::",
            stringify!(version)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_lib_struct_t>())).free as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(r_lib_struct_t),
            "::",
            stringify!(free)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_lib_struct_t>())).pkgname as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(r_lib_struct_t),
            "::",
            stringify!(pkgname)
        )
    );
}
pub type RLibStruct = r_lib_struct_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_lib_t {
    pub symname: *mut ::std::os::raw::c_char,
    pub symnamefunc: *mut ::std::os::raw::c_char,
    pub plugins: *mut RList,
    pub handlers: *mut RList,
    pub ignore_version: bool,
}
#[test]
fn bindgen_test_layout_r_lib_t() {
    assert_eq!(
        ::std::mem::size_of::<r_lib_t>(),
        40usize,
        concat!("Size of: ", stringify!(r_lib_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_lib_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_lib_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_lib_t>())).symname as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_lib_t),
            "::",
            stringify!(symname)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_lib_t>())).symnamefunc as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_lib_t),
            "::",
            stringify!(symnamefunc)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_lib_t>())).plugins as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(r_lib_t),
            "::",
            stringify!(plugins)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_lib_t>())).handlers as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(r_lib_t),
            "::",
            stringify!(handlers)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_lib_t>())).ignore_version as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(r_lib_t),
            "::",
            stringify!(ignore_version)
        )
    );
}
pub type RLib = r_lib_t;
extern "C" {
    pub fn r_lib_dl_open(libname: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn r_lib_dl_sym(
        handler: *mut ::std::os::raw::c_void,
        name: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn r_lib_dl_close(handler: *mut ::std::os::raw::c_void) -> ::std::os::raw::c_int;
}
pub type RLibCallback = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: *mut RLibPlugin,
        arg2: *mut ::std::os::raw::c_void,
        arg3: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int,
>;
extern "C" {
    pub fn r_lib_new(
        symname: *const ::std::os::raw::c_char,
        symnamefunc: *const ::std::os::raw::c_char,
    ) -> *mut RLib;
}
extern "C" {
    pub fn r_lib_free(lib: *mut RLib);
}
extern "C" {
    pub fn r_lib_run_handler(
        lib: *mut RLib,
        plugin: *mut RLibPlugin,
        symbol: *mut RLibStruct,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_lib_get_handler(lib: *mut RLib, type_: ::std::os::raw::c_int) -> *mut RLibHandler;
}
extern "C" {
    pub fn r_lib_open(lib: *mut RLib, file: *const ::std::os::raw::c_char)
        -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_lib_opendir(lib: *mut RLib, path: *const ::std::os::raw::c_char) -> bool;
}
extern "C" {
    pub fn r_lib_open_ptr(
        lib: *mut RLib,
        file: *const ::std::os::raw::c_char,
        handler: *mut ::std::os::raw::c_void,
        stru: *mut RLibStruct,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_lib_path(libname: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_lib_list(lib: *mut RLib);
}
extern "C" {
    pub fn r_lib_add_handler(
        lib: *mut RLib,
        type_: ::std::os::raw::c_int,
        desc: *const ::std::os::raw::c_char,
        ct: RLibCallback,
        dt: RLibCallback,
        user: *mut ::std::os::raw::c_void,
    ) -> bool;
}
extern "C" {
    pub fn r_lib_del_handler(lib: *mut RLib, type_: ::std::os::raw::c_int) -> bool;
}
extern "C" {
    pub fn r_lib_close(
        lib: *mut RLib,
        file: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_lib_types_get(idx: ::std::os::raw::c_int) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_lib_types_get_i(str_: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ht_pu_kv {
    pub key: *mut ::std::os::raw::c_void,
    pub value: u64,
    pub key_len: u32,
    pub value_len: u32,
}
#[test]
fn bindgen_test_layout_ht_pu_kv() {
    assert_eq!(
        ::std::mem::size_of::<ht_pu_kv>(),
        24usize,
        concat!("Size of: ", stringify!(ht_pu_kv))
    );
    assert_eq!(
        ::std::mem::align_of::<ht_pu_kv>(),
        8usize,
        concat!("Alignment of ", stringify!(ht_pu_kv))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ht_pu_kv>())).key as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(ht_pu_kv),
            "::",
            stringify!(key)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ht_pu_kv>())).value as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(ht_pu_kv),
            "::",
            stringify!(value)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ht_pu_kv>())).key_len as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(ht_pu_kv),
            "::",
            stringify!(key_len)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ht_pu_kv>())).value_len as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(ht_pu_kv),
            "::",
            stringify!(value_len)
        )
    );
}
pub type HtPUKv = ht_pu_kv;
pub type HtPUKvFreeFunc = ::std::option::Option<unsafe extern "C" fn(arg1: *mut HtPUKv)>;
pub type HtPUDupKey = ::std::option::Option<
    unsafe extern "C" fn(arg1: *const ::std::os::raw::c_void) -> *mut ::std::os::raw::c_void,
>;
pub type HtPUDupValue = ::std::option::Option<unsafe extern "C" fn(arg1: u64) -> u64>;
pub type HtPUCalcSizeK =
    ::std::option::Option<unsafe extern "C" fn(arg1: *const ::std::os::raw::c_void) -> u32>;
pub type HtPUCalcSizeV = ::std::option::Option<unsafe extern "C" fn(arg1: u64) -> u32>;
pub type HtPUHashFunction =
    ::std::option::Option<unsafe extern "C" fn(arg1: *const ::std::os::raw::c_void) -> u32>;
pub type HtPUListComparator = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: *const ::std::os::raw::c_void,
        arg2: *const ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int,
>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ht_pu_bucket_t {
    pub arr: *mut HtPUKv,
    pub count: u32,
}
#[test]
fn bindgen_test_layout_ht_pu_bucket_t() {
    assert_eq!(
        ::std::mem::size_of::<ht_pu_bucket_t>(),
        16usize,
        concat!("Size of: ", stringify!(ht_pu_bucket_t))
    );
    assert_eq!(
        ::std::mem::align_of::<ht_pu_bucket_t>(),
        8usize,
        concat!("Alignment of ", stringify!(ht_pu_bucket_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ht_pu_bucket_t>())).arr as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(ht_pu_bucket_t),
            "::",
            stringify!(arr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ht_pu_bucket_t>())).count as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(ht_pu_bucket_t),
            "::",
            stringify!(count)
        )
    );
}
pub type HtPUBucket = ht_pu_bucket_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ht_pu_options_t {
    pub cmp: HtPUListComparator,
    pub hashfn: HtPUHashFunction,
    pub dupkey: HtPUDupKey,
    pub dupvalue: HtPUDupValue,
    pub calcsizeK: HtPUCalcSizeK,
    pub calcsizeV: HtPUCalcSizeV,
    pub freefn: HtPUKvFreeFunc,
    pub elem_size: size_t,
}
#[test]
fn bindgen_test_layout_ht_pu_options_t() {
    assert_eq!(
        ::std::mem::size_of::<ht_pu_options_t>(),
        64usize,
        concat!("Size of: ", stringify!(ht_pu_options_t))
    );
    assert_eq!(
        ::std::mem::align_of::<ht_pu_options_t>(),
        8usize,
        concat!("Alignment of ", stringify!(ht_pu_options_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ht_pu_options_t>())).cmp as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(ht_pu_options_t),
            "::",
            stringify!(cmp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ht_pu_options_t>())).hashfn as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(ht_pu_options_t),
            "::",
            stringify!(hashfn)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ht_pu_options_t>())).dupkey as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(ht_pu_options_t),
            "::",
            stringify!(dupkey)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ht_pu_options_t>())).dupvalue as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(ht_pu_options_t),
            "::",
            stringify!(dupvalue)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ht_pu_options_t>())).calcsizeK as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(ht_pu_options_t),
            "::",
            stringify!(calcsizeK)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ht_pu_options_t>())).calcsizeV as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(ht_pu_options_t),
            "::",
            stringify!(calcsizeV)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ht_pu_options_t>())).freefn as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(ht_pu_options_t),
            "::",
            stringify!(freefn)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ht_pu_options_t>())).elem_size as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(ht_pu_options_t),
            "::",
            stringify!(elem_size)
        )
    );
}
pub type HtPUOptions = ht_pu_options_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ht_pu_t {
    pub size: u32,
    pub count: u32,
    pub table: *mut HtPUBucket,
    pub prime_idx: u32,
    pub opt: HtPUOptions,
}
#[test]
fn bindgen_test_layout_ht_pu_t() {
    assert_eq!(
        ::std::mem::size_of::<ht_pu_t>(),
        88usize,
        concat!("Size of: ", stringify!(ht_pu_t))
    );
    assert_eq!(
        ::std::mem::align_of::<ht_pu_t>(),
        8usize,
        concat!("Alignment of ", stringify!(ht_pu_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ht_pu_t>())).size as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(ht_pu_t),
            "::",
            stringify!(size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ht_pu_t>())).count as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(ht_pu_t),
            "::",
            stringify!(count)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ht_pu_t>())).table as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(ht_pu_t),
            "::",
            stringify!(table)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ht_pu_t>())).prime_idx as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(ht_pu_t),
            "::",
            stringify!(prime_idx)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ht_pu_t>())).opt as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(ht_pu_t),
            "::",
            stringify!(opt)
        )
    );
}
pub type HtPU = ht_pu_t;
pub type RBin = r_bin_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RBinDwarfAttrDef {
    pub attr_name: u64,
    pub attr_form: u64,
    pub special: i64,
}
#[test]
fn bindgen_test_layout_RBinDwarfAttrDef() {
    assert_eq!(
        ::std::mem::size_of::<RBinDwarfAttrDef>(),
        24usize,
        concat!("Size of: ", stringify!(RBinDwarfAttrDef))
    );
    assert_eq!(
        ::std::mem::align_of::<RBinDwarfAttrDef>(),
        8usize,
        concat!("Alignment of ", stringify!(RBinDwarfAttrDef))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RBinDwarfAttrDef>())).attr_name as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(RBinDwarfAttrDef),
            "::",
            stringify!(attr_name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RBinDwarfAttrDef>())).attr_form as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(RBinDwarfAttrDef),
            "::",
            stringify!(attr_form)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RBinDwarfAttrDef>())).special as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(RBinDwarfAttrDef),
            "::",
            stringify!(special)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RBinDwarfBlock {
    pub length: u64,
    pub data: *mut u8,
}
#[test]
fn bindgen_test_layout_RBinDwarfBlock() {
    assert_eq!(
        ::std::mem::size_of::<RBinDwarfBlock>(),
        16usize,
        concat!("Size of: ", stringify!(RBinDwarfBlock))
    );
    assert_eq!(
        ::std::mem::align_of::<RBinDwarfBlock>(),
        8usize,
        concat!("Alignment of ", stringify!(RBinDwarfBlock))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RBinDwarfBlock>())).length as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(RBinDwarfBlock),
            "::",
            stringify!(length)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RBinDwarfBlock>())).data as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(RBinDwarfBlock),
            "::",
            stringify!(data)
        )
    );
}
pub const RBinDwarfAttrKind_DW_AT_KIND_ADDRESS: RBinDwarfAttrKind = 0;
pub const RBinDwarfAttrKind_DW_AT_KIND_BLOCK: RBinDwarfAttrKind = 1;
pub const RBinDwarfAttrKind_DW_AT_KIND_CONSTANT: RBinDwarfAttrKind = 2;
pub const RBinDwarfAttrKind_DW_AT_KIND_EXPRLOC: RBinDwarfAttrKind = 3;
pub const RBinDwarfAttrKind_DW_AT_KIND_FLAG: RBinDwarfAttrKind = 4;
pub const RBinDwarfAttrKind_DW_AT_KIND_LINEPTR: RBinDwarfAttrKind = 5;
pub const RBinDwarfAttrKind_DW_AT_KIND_LOCLISTPTR: RBinDwarfAttrKind = 6;
pub const RBinDwarfAttrKind_DW_AT_KIND_MACPTR: RBinDwarfAttrKind = 7;
pub const RBinDwarfAttrKind_DW_AT_KIND_RANGELISTPTR: RBinDwarfAttrKind = 8;
pub const RBinDwarfAttrKind_DW_AT_KIND_REFERENCE: RBinDwarfAttrKind = 9;
pub const RBinDwarfAttrKind_DW_AT_KIND_STRING: RBinDwarfAttrKind = 10;
pub type RBinDwarfAttrKind = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct dwarf_attr_kind {
    pub attr_name: u64,
    pub attr_form: u64,
    pub kind: RBinDwarfAttrKind,
    pub __bindgen_anon_1: dwarf_attr_kind__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union dwarf_attr_kind__bindgen_ty_1 {
    pub address: u64,
    pub uconstant: u64,
    pub sconstant: i64,
    pub flag: u8,
    pub reference: u64,
    pub block: RBinDwarfBlock,
    pub string: dwarf_attr_kind__bindgen_ty_1__bindgen_ty_1,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct dwarf_attr_kind__bindgen_ty_1__bindgen_ty_1 {
    pub offset: u64,
    pub content: *const ::std::os::raw::c_char,
}
#[test]
fn bindgen_test_layout_dwarf_attr_kind__bindgen_ty_1__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<dwarf_attr_kind__bindgen_ty_1__bindgen_ty_1>(),
        16usize,
        concat!(
            "Size of: ",
            stringify!(dwarf_attr_kind__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<dwarf_attr_kind__bindgen_ty_1__bindgen_ty_1>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(dwarf_attr_kind__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<dwarf_attr_kind__bindgen_ty_1__bindgen_ty_1>())).offset
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(dwarf_attr_kind__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(offset)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<dwarf_attr_kind__bindgen_ty_1__bindgen_ty_1>())).content
                as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(dwarf_attr_kind__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(content)
        )
    );
}
#[test]
fn bindgen_test_layout_dwarf_attr_kind__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<dwarf_attr_kind__bindgen_ty_1>(),
        16usize,
        concat!("Size of: ", stringify!(dwarf_attr_kind__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<dwarf_attr_kind__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(dwarf_attr_kind__bindgen_ty_1))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<dwarf_attr_kind__bindgen_ty_1>())).address as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(dwarf_attr_kind__bindgen_ty_1),
            "::",
            stringify!(address)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<dwarf_attr_kind__bindgen_ty_1>())).uconstant as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(dwarf_attr_kind__bindgen_ty_1),
            "::",
            stringify!(uconstant)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<dwarf_attr_kind__bindgen_ty_1>())).sconstant as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(dwarf_attr_kind__bindgen_ty_1),
            "::",
            stringify!(sconstant)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<dwarf_attr_kind__bindgen_ty_1>())).flag as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(dwarf_attr_kind__bindgen_ty_1),
            "::",
            stringify!(flag)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<dwarf_attr_kind__bindgen_ty_1>())).reference as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(dwarf_attr_kind__bindgen_ty_1),
            "::",
            stringify!(reference)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<dwarf_attr_kind__bindgen_ty_1>())).block as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(dwarf_attr_kind__bindgen_ty_1),
            "::",
            stringify!(block)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<dwarf_attr_kind__bindgen_ty_1>())).string as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(dwarf_attr_kind__bindgen_ty_1),
            "::",
            stringify!(string)
        )
    );
}
#[test]
fn bindgen_test_layout_dwarf_attr_kind() {
    assert_eq!(
        ::std::mem::size_of::<dwarf_attr_kind>(),
        40usize,
        concat!("Size of: ", stringify!(dwarf_attr_kind))
    );
    assert_eq!(
        ::std::mem::align_of::<dwarf_attr_kind>(),
        8usize,
        concat!("Alignment of ", stringify!(dwarf_attr_kind))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<dwarf_attr_kind>())).attr_name as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(dwarf_attr_kind),
            "::",
            stringify!(attr_name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<dwarf_attr_kind>())).attr_form as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(dwarf_attr_kind),
            "::",
            stringify!(attr_form)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<dwarf_attr_kind>())).kind as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(dwarf_attr_kind),
            "::",
            stringify!(kind)
        )
    );
}
pub type RBinDwarfAttrValue = dwarf_attr_kind;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RBinDwarfCompUnitHdr {
    pub length: u64,
    pub version: u16,
    pub abbrev_offset: u64,
    pub address_size: u8,
    pub unit_type: u8,
    pub dwo_id: u8,
    pub type_sig: u64,
    pub type_offset: u64,
    pub header_size: u64,
    pub unit_offset: u64,
    pub is_64bit: bool,
}
#[test]
fn bindgen_test_layout_RBinDwarfCompUnitHdr() {
    assert_eq!(
        ::std::mem::size_of::<RBinDwarfCompUnitHdr>(),
        72usize,
        concat!("Size of: ", stringify!(RBinDwarfCompUnitHdr))
    );
    assert_eq!(
        ::std::mem::align_of::<RBinDwarfCompUnitHdr>(),
        8usize,
        concat!("Alignment of ", stringify!(RBinDwarfCompUnitHdr))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RBinDwarfCompUnitHdr>())).length as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(RBinDwarfCompUnitHdr),
            "::",
            stringify!(length)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RBinDwarfCompUnitHdr>())).version as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(RBinDwarfCompUnitHdr),
            "::",
            stringify!(version)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RBinDwarfCompUnitHdr>())).abbrev_offset as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(RBinDwarfCompUnitHdr),
            "::",
            stringify!(abbrev_offset)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RBinDwarfCompUnitHdr>())).address_size as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(RBinDwarfCompUnitHdr),
            "::",
            stringify!(address_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RBinDwarfCompUnitHdr>())).unit_type as *const _ as usize },
        25usize,
        concat!(
            "Offset of field: ",
            stringify!(RBinDwarfCompUnitHdr),
            "::",
            stringify!(unit_type)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RBinDwarfCompUnitHdr>())).dwo_id as *const _ as usize },
        26usize,
        concat!(
            "Offset of field: ",
            stringify!(RBinDwarfCompUnitHdr),
            "::",
            stringify!(dwo_id)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RBinDwarfCompUnitHdr>())).type_sig as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(RBinDwarfCompUnitHdr),
            "::",
            stringify!(type_sig)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RBinDwarfCompUnitHdr>())).type_offset as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(RBinDwarfCompUnitHdr),
            "::",
            stringify!(type_offset)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RBinDwarfCompUnitHdr>())).header_size as *const _ as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(RBinDwarfCompUnitHdr),
            "::",
            stringify!(header_size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RBinDwarfCompUnitHdr>())).unit_offset as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(RBinDwarfCompUnitHdr),
            "::",
            stringify!(unit_offset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RBinDwarfCompUnitHdr>())).is_64bit as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(RBinDwarfCompUnitHdr),
            "::",
            stringify!(is_64bit)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RBinDwarfDie {
    pub tag: u64,
    pub abbrev_code: u64,
    pub count: size_t,
    pub capacity: size_t,
    pub offset: u64,
    pub has_children: bool,
    pub attr_values: *mut RBinDwarfAttrValue,
}
#[test]
fn bindgen_test_layout_RBinDwarfDie() {
    assert_eq!(
        ::std::mem::size_of::<RBinDwarfDie>(),
        56usize,
        concat!("Size of: ", stringify!(RBinDwarfDie))
    );
    assert_eq!(
        ::std::mem::align_of::<RBinDwarfDie>(),
        8usize,
        concat!("Alignment of ", stringify!(RBinDwarfDie))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RBinDwarfDie>())).tag as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(RBinDwarfDie),
            "::",
            stringify!(tag)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RBinDwarfDie>())).abbrev_code as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(RBinDwarfDie),
            "::",
            stringify!(abbrev_code)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RBinDwarfDie>())).count as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(RBinDwarfDie),
            "::",
            stringify!(count)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RBinDwarfDie>())).capacity as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(RBinDwarfDie),
            "::",
            stringify!(capacity)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RBinDwarfDie>())).offset as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(RBinDwarfDie),
            "::",
            stringify!(offset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RBinDwarfDie>())).has_children as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(RBinDwarfDie),
            "::",
            stringify!(has_children)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RBinDwarfDie>())).attr_values as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(RBinDwarfDie),
            "::",
            stringify!(attr_values)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RBinDwarfCompUnit {
    pub hdr: RBinDwarfCompUnitHdr,
    pub offset: u64,
    pub count: size_t,
    pub capacity: size_t,
    pub dies: *mut RBinDwarfDie,
}
#[test]
fn bindgen_test_layout_RBinDwarfCompUnit() {
    assert_eq!(
        ::std::mem::size_of::<RBinDwarfCompUnit>(),
        104usize,
        concat!("Size of: ", stringify!(RBinDwarfCompUnit))
    );
    assert_eq!(
        ::std::mem::align_of::<RBinDwarfCompUnit>(),
        8usize,
        concat!("Alignment of ", stringify!(RBinDwarfCompUnit))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RBinDwarfCompUnit>())).hdr as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(RBinDwarfCompUnit),
            "::",
            stringify!(hdr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RBinDwarfCompUnit>())).offset as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(RBinDwarfCompUnit),
            "::",
            stringify!(offset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RBinDwarfCompUnit>())).count as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(RBinDwarfCompUnit),
            "::",
            stringify!(count)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RBinDwarfCompUnit>())).capacity as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(RBinDwarfCompUnit),
            "::",
            stringify!(capacity)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RBinDwarfCompUnit>())).dies as *const _ as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(RBinDwarfCompUnit),
            "::",
            stringify!(dies)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RBinDwarfDebugInfo {
    pub count: size_t,
    pub capacity: size_t,
    pub comp_units: *mut RBinDwarfCompUnit,
    pub lookup_table: *mut HtUP,
}
#[test]
fn bindgen_test_layout_RBinDwarfDebugInfo() {
    assert_eq!(
        ::std::mem::size_of::<RBinDwarfDebugInfo>(),
        32usize,
        concat!("Size of: ", stringify!(RBinDwarfDebugInfo))
    );
    assert_eq!(
        ::std::mem::align_of::<RBinDwarfDebugInfo>(),
        8usize,
        concat!("Alignment of ", stringify!(RBinDwarfDebugInfo))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RBinDwarfDebugInfo>())).count as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(RBinDwarfDebugInfo),
            "::",
            stringify!(count)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RBinDwarfDebugInfo>())).capacity as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(RBinDwarfDebugInfo),
            "::",
            stringify!(capacity)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RBinDwarfDebugInfo>())).comp_units as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(RBinDwarfDebugInfo),
            "::",
            stringify!(comp_units)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RBinDwarfDebugInfo>())).lookup_table as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(RBinDwarfDebugInfo),
            "::",
            stringify!(lookup_table)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RBinDwarfAbbrevDecl {
    pub code: u64,
    pub tag: u64,
    pub offset: u64,
    pub has_children: u8,
    pub count: size_t,
    pub capacity: size_t,
    pub defs: *mut RBinDwarfAttrDef,
}
#[test]
fn bindgen_test_layout_RBinDwarfAbbrevDecl() {
    assert_eq!(
        ::std::mem::size_of::<RBinDwarfAbbrevDecl>(),
        56usize,
        concat!("Size of: ", stringify!(RBinDwarfAbbrevDecl))
    );
    assert_eq!(
        ::std::mem::align_of::<RBinDwarfAbbrevDecl>(),
        8usize,
        concat!("Alignment of ", stringify!(RBinDwarfAbbrevDecl))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RBinDwarfAbbrevDecl>())).code as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(RBinDwarfAbbrevDecl),
            "::",
            stringify!(code)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RBinDwarfAbbrevDecl>())).tag as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(RBinDwarfAbbrevDecl),
            "::",
            stringify!(tag)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RBinDwarfAbbrevDecl>())).offset as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(RBinDwarfAbbrevDecl),
            "::",
            stringify!(offset)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RBinDwarfAbbrevDecl>())).has_children as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(RBinDwarfAbbrevDecl),
            "::",
            stringify!(has_children)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RBinDwarfAbbrevDecl>())).count as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(RBinDwarfAbbrevDecl),
            "::",
            stringify!(count)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RBinDwarfAbbrevDecl>())).capacity as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(RBinDwarfAbbrevDecl),
            "::",
            stringify!(capacity)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RBinDwarfAbbrevDecl>())).defs as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(RBinDwarfAbbrevDecl),
            "::",
            stringify!(defs)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RBinDwarfDebugAbbrev {
    pub count: size_t,
    pub capacity: size_t,
    pub decls: *mut RBinDwarfAbbrevDecl,
}
#[test]
fn bindgen_test_layout_RBinDwarfDebugAbbrev() {
    assert_eq!(
        ::std::mem::size_of::<RBinDwarfDebugAbbrev>(),
        24usize,
        concat!("Size of: ", stringify!(RBinDwarfDebugAbbrev))
    );
    assert_eq!(
        ::std::mem::align_of::<RBinDwarfDebugAbbrev>(),
        8usize,
        concat!("Alignment of ", stringify!(RBinDwarfDebugAbbrev))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RBinDwarfDebugAbbrev>())).count as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(RBinDwarfDebugAbbrev),
            "::",
            stringify!(count)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RBinDwarfDebugAbbrev>())).capacity as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(RBinDwarfDebugAbbrev),
            "::",
            stringify!(capacity)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RBinDwarfDebugAbbrev>())).decls as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(RBinDwarfDebugAbbrev),
            "::",
            stringify!(decls)
        )
    );
}
extern "C" {
    pub fn r_bin_dwarf_parse_aranges(a: *mut RBin, mode: ::std::os::raw::c_int) -> *mut RList;
}
extern "C" {
    pub fn r_bin_dwarf_parse_line(a: *mut RBin, mode: ::std::os::raw::c_int) -> *mut RList;
}
extern "C" {
    pub fn r_bin_dwarf_parse_abbrev(
        a: *mut RBin,
        mode: ::std::os::raw::c_int,
    ) -> *mut RBinDwarfDebugAbbrev;
}
extern "C" {
    pub fn r_bin_dwarf_parse_info(
        da: *mut RBinDwarfDebugAbbrev,
        a: *mut RBin,
        mode: ::std::os::raw::c_int,
    ) -> *mut RBinDwarfDebugInfo;
}
extern "C" {
    pub fn r_bin_dwarf_parse_loc(bin: *mut RBin, addr_size: ::std::os::raw::c_int) -> *mut HtUP;
}
extern "C" {
    pub fn r_bin_dwarf_print_loc(
        loc_table: *mut HtUP,
        addr_size: ::std::os::raw::c_int,
        print: PrintfCallback,
    );
}
extern "C" {
    pub fn r_bin_dwarf_free_loc(loc_table: *mut HtUP);
}
extern "C" {
    pub fn r_bin_dwarf_free_debug_info(inf: *mut RBinDwarfDebugInfo);
}
extern "C" {
    pub fn r_bin_dwarf_free_debug_abbrev(da: *mut RBinDwarfDebugAbbrev);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct R_PDB7_ROOT_STREAM {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_pdb_t {
    pub pdb_parse: ::std::option::Option<unsafe extern "C" fn(pdb: *mut r_pdb_t) -> bool>,
    pub finish_pdb_parse: ::std::option::Option<unsafe extern "C" fn(pdb: *mut r_pdb_t)>,
    pub print_types: ::std::option::Option<
        unsafe extern "C" fn(pdb: *const r_pdb_t, pj: *mut PJ, mode: ::std::os::raw::c_int),
    >,
    pub cb_printf: PrintfCallback,
    pub root_stream: *mut R_PDB7_ROOT_STREAM,
    pub stream_map: *mut ::std::os::raw::c_void,
    pub pdb_streams: *mut RList,
    pub pdb_streams2: *mut RList,
    pub buf: *mut RBuffer,
    pub print_gvars: ::std::option::Option<
        unsafe extern "C" fn(
            pdb: *mut r_pdb_t,
            img_base: u64,
            pj: *mut PJ,
            format: ::std::os::raw::c_int,
        ),
    >,
}
#[test]
fn bindgen_test_layout_r_pdb_t() {
    assert_eq!(
        ::std::mem::size_of::<r_pdb_t>(),
        80usize,
        concat!("Size of: ", stringify!(r_pdb_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_pdb_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_pdb_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_pdb_t>())).pdb_parse as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_pdb_t),
            "::",
            stringify!(pdb_parse)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_pdb_t>())).finish_pdb_parse as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_pdb_t),
            "::",
            stringify!(finish_pdb_parse)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_pdb_t>())).print_types as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(r_pdb_t),
            "::",
            stringify!(print_types)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_pdb_t>())).cb_printf as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(r_pdb_t),
            "::",
            stringify!(cb_printf)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_pdb_t>())).root_stream as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(r_pdb_t),
            "::",
            stringify!(root_stream)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_pdb_t>())).stream_map as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(r_pdb_t),
            "::",
            stringify!(stream_map)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_pdb_t>())).pdb_streams as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(r_pdb_t),
            "::",
            stringify!(pdb_streams)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_pdb_t>())).pdb_streams2 as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(r_pdb_t),
            "::",
            stringify!(pdb_streams2)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_pdb_t>())).buf as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(r_pdb_t),
            "::",
            stringify!(buf)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_pdb_t>())).print_gvars as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(r_pdb_t),
            "::",
            stringify!(print_gvars)
        )
    );
}
pub type RPdb = r_pdb_t;
extern "C" {
    pub fn r_bin_version() -> *const ::std::os::raw::c_char;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_bin_addr_t {
    pub vaddr: u64,
    pub paddr: u64,
    pub hvaddr: u64,
    pub hpaddr: u64,
    pub type_: ::std::os::raw::c_int,
    pub bits: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_r_bin_addr_t() {
    assert_eq!(
        ::std::mem::size_of::<r_bin_addr_t>(),
        40usize,
        concat!("Size of: ", stringify!(r_bin_addr_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_bin_addr_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_bin_addr_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_addr_t>())).vaddr as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_addr_t),
            "::",
            stringify!(vaddr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_addr_t>())).paddr as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_addr_t),
            "::",
            stringify!(paddr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_addr_t>())).hvaddr as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_addr_t),
            "::",
            stringify!(hvaddr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_addr_t>())).hpaddr as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_addr_t),
            "::",
            stringify!(hpaddr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_addr_t>())).type_ as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_addr_t),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_addr_t>())).bits as *const _ as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_addr_t),
            "::",
            stringify!(bits)
        )
    );
}
pub type RBinAddr = r_bin_addr_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_bin_hash_t {
    pub type_: *const ::std::os::raw::c_char,
    pub addr: u64,
    pub len: ::std::os::raw::c_int,
    pub from: u64,
    pub to: u64,
    pub buf: [u8; 32usize],
    pub cmd: *const ::std::os::raw::c_char,
}
#[test]
fn bindgen_test_layout_r_bin_hash_t() {
    assert_eq!(
        ::std::mem::size_of::<r_bin_hash_t>(),
        80usize,
        concat!("Size of: ", stringify!(r_bin_hash_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_bin_hash_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_bin_hash_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_hash_t>())).type_ as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_hash_t),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_hash_t>())).addr as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_hash_t),
            "::",
            stringify!(addr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_hash_t>())).len as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_hash_t),
            "::",
            stringify!(len)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_hash_t>())).from as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_hash_t),
            "::",
            stringify!(from)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_hash_t>())).to as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_hash_t),
            "::",
            stringify!(to)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_hash_t>())).buf as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_hash_t),
            "::",
            stringify!(buf)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_hash_t>())).cmd as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_hash_t),
            "::",
            stringify!(cmd)
        )
    );
}
pub type RBinHash = r_bin_hash_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_bin_file_hash_t {
    pub type_: *const ::std::os::raw::c_char,
    pub hex: *const ::std::os::raw::c_char,
}
#[test]
fn bindgen_test_layout_r_bin_file_hash_t() {
    assert_eq!(
        ::std::mem::size_of::<r_bin_file_hash_t>(),
        16usize,
        concat!("Size of: ", stringify!(r_bin_file_hash_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_bin_file_hash_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_bin_file_hash_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_file_hash_t>())).type_ as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_file_hash_t),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_file_hash_t>())).hex as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_file_hash_t),
            "::",
            stringify!(hex)
        )
    );
}
pub type RBinFileHash = r_bin_file_hash_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_bin_info_t {
    pub file: *mut ::std::os::raw::c_char,
    pub type_: *mut ::std::os::raw::c_char,
    pub bclass: *mut ::std::os::raw::c_char,
    pub rclass: *mut ::std::os::raw::c_char,
    pub arch: *mut ::std::os::raw::c_char,
    pub cpu: *mut ::std::os::raw::c_char,
    pub machine: *mut ::std::os::raw::c_char,
    pub head_flag: *mut ::std::os::raw::c_char,
    pub features: *mut ::std::os::raw::c_char,
    pub os: *mut ::std::os::raw::c_char,
    pub subsystem: *mut ::std::os::raw::c_char,
    pub rpath: *mut ::std::os::raw::c_char,
    pub guid: *mut ::std::os::raw::c_char,
    pub debug_file_name: *mut ::std::os::raw::c_char,
    pub lang: *const ::std::os::raw::c_char,
    pub default_cc: *mut ::std::os::raw::c_char,
    pub file_hashes: *mut RList,
    pub bits: ::std::os::raw::c_int,
    pub has_va: ::std::os::raw::c_int,
    pub has_pi: ::std::os::raw::c_int,
    pub has_canary: ::std::os::raw::c_int,
    pub has_retguard: ::std::os::raw::c_int,
    pub has_sanitizers: ::std::os::raw::c_int,
    pub has_crypto: ::std::os::raw::c_int,
    pub has_nx: ::std::os::raw::c_int,
    pub big_endian: ::std::os::raw::c_int,
    pub has_lit: bool,
    pub actual_checksum: *mut ::std::os::raw::c_char,
    pub claimed_checksum: *mut ::std::os::raw::c_char,
    pub pe_overlay: ::std::os::raw::c_int,
    pub signature: bool,
    pub dbg_info: u64,
    pub sum: [RBinHash; 3usize],
    pub baddr: u64,
    pub intrp: *mut ::std::os::raw::c_char,
    pub compiler: *mut ::std::os::raw::c_char,
}
#[test]
fn bindgen_test_layout_r_bin_info_t() {
    assert_eq!(
        ::std::mem::size_of::<r_bin_info_t>(),
        472usize,
        concat!("Size of: ", stringify!(r_bin_info_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_bin_info_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_bin_info_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_info_t>())).file as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_info_t),
            "::",
            stringify!(file)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_info_t>())).type_ as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_info_t),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_info_t>())).bclass as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_info_t),
            "::",
            stringify!(bclass)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_info_t>())).rclass as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_info_t),
            "::",
            stringify!(rclass)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_info_t>())).arch as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_info_t),
            "::",
            stringify!(arch)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_info_t>())).cpu as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_info_t),
            "::",
            stringify!(cpu)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_info_t>())).machine as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_info_t),
            "::",
            stringify!(machine)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_info_t>())).head_flag as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_info_t),
            "::",
            stringify!(head_flag)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_info_t>())).features as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_info_t),
            "::",
            stringify!(features)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_info_t>())).os as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_info_t),
            "::",
            stringify!(os)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_info_t>())).subsystem as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_info_t),
            "::",
            stringify!(subsystem)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_info_t>())).rpath as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_info_t),
            "::",
            stringify!(rpath)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_info_t>())).guid as *const _ as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_info_t),
            "::",
            stringify!(guid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_info_t>())).debug_file_name as *const _ as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_info_t),
            "::",
            stringify!(debug_file_name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_info_t>())).lang as *const _ as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_info_t),
            "::",
            stringify!(lang)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_info_t>())).default_cc as *const _ as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_info_t),
            "::",
            stringify!(default_cc)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_info_t>())).file_hashes as *const _ as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_info_t),
            "::",
            stringify!(file_hashes)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_info_t>())).bits as *const _ as usize },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_info_t),
            "::",
            stringify!(bits)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_info_t>())).has_va as *const _ as usize },
        140usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_info_t),
            "::",
            stringify!(has_va)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_info_t>())).has_pi as *const _ as usize },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_info_t),
            "::",
            stringify!(has_pi)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_info_t>())).has_canary as *const _ as usize },
        148usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_info_t),
            "::",
            stringify!(has_canary)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_info_t>())).has_retguard as *const _ as usize },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_info_t),
            "::",
            stringify!(has_retguard)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_info_t>())).has_sanitizers as *const _ as usize },
        156usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_info_t),
            "::",
            stringify!(has_sanitizers)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_info_t>())).has_crypto as *const _ as usize },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_info_t),
            "::",
            stringify!(has_crypto)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_info_t>())).has_nx as *const _ as usize },
        164usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_info_t),
            "::",
            stringify!(has_nx)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_info_t>())).big_endian as *const _ as usize },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_info_t),
            "::",
            stringify!(big_endian)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_info_t>())).has_lit as *const _ as usize },
        172usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_info_t),
            "::",
            stringify!(has_lit)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_info_t>())).actual_checksum as *const _ as usize },
        176usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_info_t),
            "::",
            stringify!(actual_checksum)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_info_t>())).claimed_checksum as *const _ as usize },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_info_t),
            "::",
            stringify!(claimed_checksum)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_info_t>())).pe_overlay as *const _ as usize },
        192usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_info_t),
            "::",
            stringify!(pe_overlay)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_info_t>())).signature as *const _ as usize },
        196usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_info_t),
            "::",
            stringify!(signature)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_info_t>())).dbg_info as *const _ as usize },
        200usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_info_t),
            "::",
            stringify!(dbg_info)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_info_t>())).sum as *const _ as usize },
        208usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_info_t),
            "::",
            stringify!(sum)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_info_t>())).baddr as *const _ as usize },
        448usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_info_t),
            "::",
            stringify!(baddr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_info_t>())).intrp as *const _ as usize },
        456usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_info_t),
            "::",
            stringify!(intrp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_info_t>())).compiler as *const _ as usize },
        464usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_info_t),
            "::",
            stringify!(compiler)
        )
    );
}
pub type RBinInfo = r_bin_info_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_bin_object_t {
    pub baddr: u64,
    pub baddr_shift: i64,
    pub loadaddr: u64,
    pub boffset: u64,
    pub size: u64,
    pub obj_size: u64,
    pub sections: *mut RList,
    pub imports: *mut RList,
    pub symbols: *mut RList,
    pub entries: *mut RList,
    pub fields: *mut RList,
    pub libs: *mut RList,
    pub relocs: *mut RRBTree,
    pub strings: *mut RList,
    pub classes: *mut RList,
    pub classes_ht: *mut HtPP,
    pub methods_ht: *mut HtPP,
    pub lines: *mut RList,
    pub strings_db: *mut HtUP,
    pub mem: *mut RList,
    pub maps: *mut RList,
    pub regstate: *mut ::std::os::raw::c_char,
    pub info: *mut RBinInfo,
    pub binsym: [*mut RBinAddr; 4usize],
    pub plugin: *mut r_bin_plugin_t,
    pub lang: ::std::os::raw::c_int,
    pub kv: *mut Sdb,
    pub addr2klassmethod: *mut HtUP,
    pub bin_obj: *mut ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout_r_bin_object_t() {
    assert_eq!(
        ::std::mem::size_of::<r_bin_object_t>(),
        256usize,
        concat!("Size of: ", stringify!(r_bin_object_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_bin_object_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_bin_object_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_object_t>())).baddr as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_object_t),
            "::",
            stringify!(baddr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_object_t>())).baddr_shift as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_object_t),
            "::",
            stringify!(baddr_shift)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_object_t>())).loadaddr as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_object_t),
            "::",
            stringify!(loadaddr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_object_t>())).boffset as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_object_t),
            "::",
            stringify!(boffset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_object_t>())).size as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_object_t),
            "::",
            stringify!(size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_object_t>())).obj_size as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_object_t),
            "::",
            stringify!(obj_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_object_t>())).sections as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_object_t),
            "::",
            stringify!(sections)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_object_t>())).imports as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_object_t),
            "::",
            stringify!(imports)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_object_t>())).symbols as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_object_t),
            "::",
            stringify!(symbols)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_object_t>())).entries as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_object_t),
            "::",
            stringify!(entries)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_object_t>())).fields as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_object_t),
            "::",
            stringify!(fields)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_object_t>())).libs as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_object_t),
            "::",
            stringify!(libs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_object_t>())).relocs as *const _ as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_object_t),
            "::",
            stringify!(relocs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_object_t>())).strings as *const _ as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_object_t),
            "::",
            stringify!(strings)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_object_t>())).classes as *const _ as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_object_t),
            "::",
            stringify!(classes)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_object_t>())).classes_ht as *const _ as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_object_t),
            "::",
            stringify!(classes_ht)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_object_t>())).methods_ht as *const _ as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_object_t),
            "::",
            stringify!(methods_ht)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_object_t>())).lines as *const _ as usize },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_object_t),
            "::",
            stringify!(lines)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_object_t>())).strings_db as *const _ as usize },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_object_t),
            "::",
            stringify!(strings_db)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_object_t>())).mem as *const _ as usize },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_object_t),
            "::",
            stringify!(mem)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_object_t>())).maps as *const _ as usize },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_object_t),
            "::",
            stringify!(maps)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_object_t>())).regstate as *const _ as usize },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_object_t),
            "::",
            stringify!(regstate)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_object_t>())).info as *const _ as usize },
        176usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_object_t),
            "::",
            stringify!(info)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_object_t>())).binsym as *const _ as usize },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_object_t),
            "::",
            stringify!(binsym)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_object_t>())).plugin as *const _ as usize },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_object_t),
            "::",
            stringify!(plugin)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_object_t>())).lang as *const _ as usize },
        224usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_object_t),
            "::",
            stringify!(lang)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_object_t>())).kv as *const _ as usize },
        232usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_object_t),
            "::",
            stringify!(kv)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_object_t>())).addr2klassmethod as *const _ as usize },
        240usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_object_t),
            "::",
            stringify!(addr2klassmethod)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_object_t>())).bin_obj as *const _ as usize },
        248usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_object_t),
            "::",
            stringify!(bin_obj)
        )
    );
}
pub type RBinObject = r_bin_object_t;
#[doc = " XX curplugin == o->plugin"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_bin_file_t {
    pub file: *mut ::std::os::raw::c_char,
    pub fd: ::std::os::raw::c_int,
    pub size: ::std::os::raw::c_int,
    pub rawstr: ::std::os::raw::c_int,
    pub strmode: ::std::os::raw::c_int,
    pub id: u32,
    pub buf: *mut RBuffer,
    pub offset: u64,
    pub o: *mut RBinObject,
    pub xtr_obj: *mut ::std::os::raw::c_void,
    pub loadaddr: u64,
    pub minstrlen: ::std::os::raw::c_int,
    pub maxstrlen: ::std::os::raw::c_int,
    pub narch: ::std::os::raw::c_int,
    pub curxtr: *mut r_bin_xtr_plugin_t,
    pub xtr_data: *mut RList,
    pub sdb: *mut Sdb,
    pub sdb_info: *mut Sdb,
    pub sdb_addrinfo: *mut Sdb,
    pub rbin: *mut r_bin_t,
}
#[test]
fn bindgen_test_layout_r_bin_file_t() {
    assert_eq!(
        ::std::mem::size_of::<r_bin_file_t>(),
        136usize,
        concat!("Size of: ", stringify!(r_bin_file_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_bin_file_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_bin_file_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_file_t>())).file as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_file_t),
            "::",
            stringify!(file)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_file_t>())).fd as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_file_t),
            "::",
            stringify!(fd)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_file_t>())).size as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_file_t),
            "::",
            stringify!(size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_file_t>())).rawstr as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_file_t),
            "::",
            stringify!(rawstr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_file_t>())).strmode as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_file_t),
            "::",
            stringify!(strmode)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_file_t>())).id as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_file_t),
            "::",
            stringify!(id)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_file_t>())).buf as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_file_t),
            "::",
            stringify!(buf)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_file_t>())).offset as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_file_t),
            "::",
            stringify!(offset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_file_t>())).o as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_file_t),
            "::",
            stringify!(o)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_file_t>())).xtr_obj as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_file_t),
            "::",
            stringify!(xtr_obj)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_file_t>())).loadaddr as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_file_t),
            "::",
            stringify!(loadaddr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_file_t>())).minstrlen as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_file_t),
            "::",
            stringify!(minstrlen)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_file_t>())).maxstrlen as *const _ as usize },
        76usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_file_t),
            "::",
            stringify!(maxstrlen)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_file_t>())).narch as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_file_t),
            "::",
            stringify!(narch)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_file_t>())).curxtr as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_file_t),
            "::",
            stringify!(curxtr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_file_t>())).xtr_data as *const _ as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_file_t),
            "::",
            stringify!(xtr_data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_file_t>())).sdb as *const _ as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_file_t),
            "::",
            stringify!(sdb)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_file_t>())).sdb_info as *const _ as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_file_t),
            "::",
            stringify!(sdb_info)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_file_t>())).sdb_addrinfo as *const _ as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_file_t),
            "::",
            stringify!(sdb_addrinfo)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_file_t>())).rbin as *const _ as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_file_t),
            "::",
            stringify!(rbin)
        )
    );
}
#[doc = " XX curplugin == o->plugin"]
pub type RBinFile = r_bin_file_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_bin_file_options_t {
    pub pluginname: *const ::std::os::raw::c_char,
    pub baseaddr: u64,
    pub loadaddr: u64,
    pub sz: u64,
    pub xtr_idx: ::std::os::raw::c_int,
    pub rawstr: ::std::os::raw::c_int,
    pub fd: ::std::os::raw::c_int,
    pub filename: *const ::std::os::raw::c_char,
}
#[test]
fn bindgen_test_layout_r_bin_file_options_t() {
    assert_eq!(
        ::std::mem::size_of::<r_bin_file_options_t>(),
        56usize,
        concat!("Size of: ", stringify!(r_bin_file_options_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_bin_file_options_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_bin_file_options_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_file_options_t>())).pluginname as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_file_options_t),
            "::",
            stringify!(pluginname)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_file_options_t>())).baseaddr as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_file_options_t),
            "::",
            stringify!(baseaddr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_file_options_t>())).loadaddr as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_file_options_t),
            "::",
            stringify!(loadaddr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_file_options_t>())).sz as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_file_options_t),
            "::",
            stringify!(sz)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_file_options_t>())).xtr_idx as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_file_options_t),
            "::",
            stringify!(xtr_idx)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_file_options_t>())).rawstr as *const _ as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_file_options_t),
            "::",
            stringify!(rawstr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_file_options_t>())).fd as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_file_options_t),
            "::",
            stringify!(fd)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_file_options_t>())).filename as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_file_options_t),
            "::",
            stringify!(filename)
        )
    );
}
pub type RBinFileOptions = r_bin_file_options_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_bin_t {
    pub file: *const ::std::os::raw::c_char,
    pub cur: *mut RBinFile,
    pub narch: ::std::os::raw::c_int,
    pub user: *mut ::std::os::raw::c_void,
    pub debase64: ::std::os::raw::c_int,
    pub minstrlen: ::std::os::raw::c_int,
    pub maxstrlen: ::std::os::raw::c_int,
    pub maxstrbuf: u64,
    pub rawstr: ::std::os::raw::c_int,
    pub sdb: *mut Sdb,
    pub ids: *mut RIDStorage,
    pub plugins: *mut RList,
    pub binxtrs: *mut RList,
    pub binldrs: *mut RList,
    pub binfiles: *mut RList,
    pub cb_printf: PrintfCallback,
    pub loadany: ::std::os::raw::c_int,
    pub iob: RIOBind,
    pub consb: RConsBind,
    pub force: *mut ::std::os::raw::c_char,
    pub want_dbginfo: bool,
    pub filter: ::std::os::raw::c_int,
    pub strfilter: ::std::os::raw::c_char,
    pub strpurge: *mut ::std::os::raw::c_char,
    pub srcdir: *mut ::std::os::raw::c_char,
    pub prefix: *mut ::std::os::raw::c_char,
    pub strenc: *mut ::std::os::raw::c_char,
    pub filter_rules: u64,
    pub demangle_usecmd: bool,
    pub demangle_trylib: bool,
    pub verbose: bool,
    pub use_xtr: bool,
    pub use_ldr: bool,
    pub constpool: RStrConstPool,
    pub is_reloc_patched: bool,
}
#[test]
fn bindgen_test_layout_r_bin_t() {
    assert_eq!(
        ::std::mem::size_of::<r_bin_t>(),
        544usize,
        concat!("Size of: ", stringify!(r_bin_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_bin_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_bin_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_t>())).file as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_t),
            "::",
            stringify!(file)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_t>())).cur as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_t),
            "::",
            stringify!(cur)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_t>())).narch as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_t),
            "::",
            stringify!(narch)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_t>())).user as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_t),
            "::",
            stringify!(user)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_t>())).debase64 as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_t),
            "::",
            stringify!(debase64)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_t>())).minstrlen as *const _ as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_t),
            "::",
            stringify!(minstrlen)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_t>())).maxstrlen as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_t),
            "::",
            stringify!(maxstrlen)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_t>())).maxstrbuf as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_t),
            "::",
            stringify!(maxstrbuf)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_t>())).rawstr as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_t),
            "::",
            stringify!(rawstr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_t>())).sdb as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_t),
            "::",
            stringify!(sdb)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_t>())).ids as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_t),
            "::",
            stringify!(ids)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_t>())).plugins as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_t),
            "::",
            stringify!(plugins)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_t>())).binxtrs as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_t),
            "::",
            stringify!(binxtrs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_t>())).binldrs as *const _ as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_t),
            "::",
            stringify!(binldrs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_t>())).binfiles as *const _ as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_t),
            "::",
            stringify!(binfiles)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_t>())).cb_printf as *const _ as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_t),
            "::",
            stringify!(cb_printf)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_t>())).loadany as *const _ as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_t),
            "::",
            stringify!(loadany)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_t>())).iob as *const _ as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_t),
            "::",
            stringify!(iob)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_t>())).consb as *const _ as usize },
        408usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_t),
            "::",
            stringify!(consb)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_t>())).force as *const _ as usize },
        456usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_t),
            "::",
            stringify!(force)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_t>())).want_dbginfo as *const _ as usize },
        464usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_t),
            "::",
            stringify!(want_dbginfo)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_t>())).filter as *const _ as usize },
        468usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_t),
            "::",
            stringify!(filter)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_t>())).strfilter as *const _ as usize },
        472usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_t),
            "::",
            stringify!(strfilter)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_t>())).strpurge as *const _ as usize },
        480usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_t),
            "::",
            stringify!(strpurge)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_t>())).srcdir as *const _ as usize },
        488usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_t),
            "::",
            stringify!(srcdir)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_t>())).prefix as *const _ as usize },
        496usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_t),
            "::",
            stringify!(prefix)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_t>())).strenc as *const _ as usize },
        504usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_t),
            "::",
            stringify!(strenc)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_t>())).filter_rules as *const _ as usize },
        512usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_t),
            "::",
            stringify!(filter_rules)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_t>())).demangle_usecmd as *const _ as usize },
        520usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_t),
            "::",
            stringify!(demangle_usecmd)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_t>())).demangle_trylib as *const _ as usize },
        521usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_t),
            "::",
            stringify!(demangle_trylib)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_t>())).verbose as *const _ as usize },
        522usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_t),
            "::",
            stringify!(verbose)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_t>())).use_xtr as *const _ as usize },
        523usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_t),
            "::",
            stringify!(use_xtr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_t>())).use_ldr as *const _ as usize },
        524usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_t),
            "::",
            stringify!(use_ldr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_t>())).constpool as *const _ as usize },
        528usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_t),
            "::",
            stringify!(constpool)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_t>())).is_reloc_patched as *const _ as usize },
        536usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_t),
            "::",
            stringify!(is_reloc_patched)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_bin_xtr_metadata_t {
    pub arch: *mut ::std::os::raw::c_char,
    pub bits: ::std::os::raw::c_int,
    pub libname: *mut ::std::os::raw::c_char,
    pub machine: *mut ::std::os::raw::c_char,
    pub type_: *mut ::std::os::raw::c_char,
    pub xtr_type: *const ::std::os::raw::c_char,
}
#[test]
fn bindgen_test_layout_r_bin_xtr_metadata_t() {
    assert_eq!(
        ::std::mem::size_of::<r_bin_xtr_metadata_t>(),
        48usize,
        concat!("Size of: ", stringify!(r_bin_xtr_metadata_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_bin_xtr_metadata_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_bin_xtr_metadata_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_xtr_metadata_t>())).arch as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_xtr_metadata_t),
            "::",
            stringify!(arch)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_xtr_metadata_t>())).bits as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_xtr_metadata_t),
            "::",
            stringify!(bits)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_xtr_metadata_t>())).libname as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_xtr_metadata_t),
            "::",
            stringify!(libname)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_xtr_metadata_t>())).machine as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_xtr_metadata_t),
            "::",
            stringify!(machine)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_xtr_metadata_t>())).type_ as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_xtr_metadata_t),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_xtr_metadata_t>())).xtr_type as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_xtr_metadata_t),
            "::",
            stringify!(xtr_type)
        )
    );
}
pub type RBinXtrMetadata = r_bin_xtr_metadata_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_bin_xtr_extract_t {
    pub file: *mut ::std::os::raw::c_char,
    pub buf: *mut RBuffer,
    pub size: u64,
    pub offset: u64,
    pub baddr: u64,
    pub laddr: u64,
    pub file_count: ::std::os::raw::c_int,
    pub loaded: bool,
    pub metadata: *mut RBinXtrMetadata,
}
#[test]
fn bindgen_test_layout_r_bin_xtr_extract_t() {
    assert_eq!(
        ::std::mem::size_of::<r_bin_xtr_extract_t>(),
        64usize,
        concat!("Size of: ", stringify!(r_bin_xtr_extract_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_bin_xtr_extract_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_bin_xtr_extract_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_xtr_extract_t>())).file as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_xtr_extract_t),
            "::",
            stringify!(file)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_xtr_extract_t>())).buf as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_xtr_extract_t),
            "::",
            stringify!(buf)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_xtr_extract_t>())).size as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_xtr_extract_t),
            "::",
            stringify!(size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_xtr_extract_t>())).offset as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_xtr_extract_t),
            "::",
            stringify!(offset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_xtr_extract_t>())).baddr as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_xtr_extract_t),
            "::",
            stringify!(baddr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_xtr_extract_t>())).laddr as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_xtr_extract_t),
            "::",
            stringify!(laddr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_xtr_extract_t>())).file_count as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_xtr_extract_t),
            "::",
            stringify!(file_count)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_xtr_extract_t>())).loaded as *const _ as usize },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_xtr_extract_t),
            "::",
            stringify!(loaded)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_xtr_extract_t>())).metadata as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_xtr_extract_t),
            "::",
            stringify!(metadata)
        )
    );
}
pub type RBinXtrData = r_bin_xtr_extract_t;
extern "C" {
    pub fn r_bin_xtrdata_new(
        buf: *mut RBuffer,
        offset: u64,
        size: u64,
        file_count: u32,
        metadata: *mut RBinXtrMetadata,
    ) -> *mut RBinXtrData;
}
extern "C" {
    pub fn r_bin_xtrdata_free(data: *mut ::std::os::raw::c_void);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_bin_xtr_plugin_t {
    pub name: *mut ::std::os::raw::c_char,
    pub desc: *mut ::std::os::raw::c_char,
    pub license: *mut ::std::os::raw::c_char,
    pub init: ::std::option::Option<
        unsafe extern "C" fn(user: *mut ::std::os::raw::c_void) -> ::std::os::raw::c_int,
    >,
    pub fini: ::std::option::Option<
        unsafe extern "C" fn(user: *mut ::std::os::raw::c_void) -> ::std::os::raw::c_int,
    >,
    pub check_buffer:
        ::std::option::Option<unsafe extern "C" fn(bf: *mut RBinFile, buf: *mut RBuffer) -> bool>,
    pub extract_from_bytes: ::std::option::Option<
        unsafe extern "C" fn(
            bin: *mut RBin,
            buf: *const u8,
            size: u64,
            idx: ::std::os::raw::c_int,
        ) -> *mut RBinXtrData,
    >,
    pub extract_from_buffer: ::std::option::Option<
        unsafe extern "C" fn(
            bin: *mut RBin,
            buf: *mut RBuffer,
            idx: ::std::os::raw::c_int,
        ) -> *mut RBinXtrData,
    >,
    pub extractall_from_bytes: ::std::option::Option<
        unsafe extern "C" fn(bin: *mut RBin, buf: *const u8, size: u64) -> *mut RList,
    >,
    pub extractall_from_buffer: ::std::option::Option<
        unsafe extern "C" fn(bin: *mut RBin, buf: *mut RBuffer) -> *mut RList,
    >,
    pub extract: ::std::option::Option<
        unsafe extern "C" fn(bin: *mut RBin, idx: ::std::os::raw::c_int) -> *mut RBinXtrData,
    >,
    pub extractall: ::std::option::Option<unsafe extern "C" fn(bin: *mut RBin) -> *mut RList>,
    pub load: ::std::option::Option<unsafe extern "C" fn(bin: *mut RBin) -> bool>,
    pub size: ::std::option::Option<unsafe extern "C" fn(bin: *mut RBin) -> ::std::os::raw::c_int>,
    pub destroy: ::std::option::Option<unsafe extern "C" fn(bin: *mut RBin)>,
    pub free_xtr: ::std::option::Option<unsafe extern "C" fn(xtr_obj: *mut ::std::os::raw::c_void)>,
}
#[test]
fn bindgen_test_layout_r_bin_xtr_plugin_t() {
    assert_eq!(
        ::std::mem::size_of::<r_bin_xtr_plugin_t>(),
        128usize,
        concat!("Size of: ", stringify!(r_bin_xtr_plugin_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_bin_xtr_plugin_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_bin_xtr_plugin_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_xtr_plugin_t>())).name as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_xtr_plugin_t),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_xtr_plugin_t>())).desc as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_xtr_plugin_t),
            "::",
            stringify!(desc)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_xtr_plugin_t>())).license as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_xtr_plugin_t),
            "::",
            stringify!(license)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_xtr_plugin_t>())).init as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_xtr_plugin_t),
            "::",
            stringify!(init)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_xtr_plugin_t>())).fini as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_xtr_plugin_t),
            "::",
            stringify!(fini)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_xtr_plugin_t>())).check_buffer as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_xtr_plugin_t),
            "::",
            stringify!(check_buffer)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_bin_xtr_plugin_t>())).extract_from_bytes as *const _ as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_xtr_plugin_t),
            "::",
            stringify!(extract_from_bytes)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_bin_xtr_plugin_t>())).extract_from_buffer as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_xtr_plugin_t),
            "::",
            stringify!(extract_from_buffer)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_bin_xtr_plugin_t>())).extractall_from_bytes as *const _
                as usize
        },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_xtr_plugin_t),
            "::",
            stringify!(extractall_from_bytes)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<r_bin_xtr_plugin_t>())).extractall_from_buffer as *const _
                as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_xtr_plugin_t),
            "::",
            stringify!(extractall_from_buffer)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_xtr_plugin_t>())).extract as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_xtr_plugin_t),
            "::",
            stringify!(extract)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_xtr_plugin_t>())).extractall as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_xtr_plugin_t),
            "::",
            stringify!(extractall)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_xtr_plugin_t>())).load as *const _ as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_xtr_plugin_t),
            "::",
            stringify!(load)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_xtr_plugin_t>())).size as *const _ as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_xtr_plugin_t),
            "::",
            stringify!(size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_xtr_plugin_t>())).destroy as *const _ as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_xtr_plugin_t),
            "::",
            stringify!(destroy)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_xtr_plugin_t>())).free_xtr as *const _ as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_xtr_plugin_t),
            "::",
            stringify!(free_xtr)
        )
    );
}
pub type RBinXtrPlugin = r_bin_xtr_plugin_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_bin_ldr_plugin_t {
    pub name: *mut ::std::os::raw::c_char,
    pub desc: *mut ::std::os::raw::c_char,
    pub license: *mut ::std::os::raw::c_char,
    pub init: ::std::option::Option<
        unsafe extern "C" fn(user: *mut ::std::os::raw::c_void) -> ::std::os::raw::c_int,
    >,
    pub fini: ::std::option::Option<
        unsafe extern "C" fn(user: *mut ::std::os::raw::c_void) -> ::std::os::raw::c_int,
    >,
    pub load: ::std::option::Option<unsafe extern "C" fn(bin: *mut RBin) -> bool>,
}
#[test]
fn bindgen_test_layout_r_bin_ldr_plugin_t() {
    assert_eq!(
        ::std::mem::size_of::<r_bin_ldr_plugin_t>(),
        48usize,
        concat!("Size of: ", stringify!(r_bin_ldr_plugin_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_bin_ldr_plugin_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_bin_ldr_plugin_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_ldr_plugin_t>())).name as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_ldr_plugin_t),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_ldr_plugin_t>())).desc as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_ldr_plugin_t),
            "::",
            stringify!(desc)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_ldr_plugin_t>())).license as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_ldr_plugin_t),
            "::",
            stringify!(license)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_ldr_plugin_t>())).init as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_ldr_plugin_t),
            "::",
            stringify!(init)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_ldr_plugin_t>())).fini as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_ldr_plugin_t),
            "::",
            stringify!(fini)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_ldr_plugin_t>())).load as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_ldr_plugin_t),
            "::",
            stringify!(load)
        )
    );
}
pub type RBinLdrPlugin = r_bin_ldr_plugin_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_bin_arch_options_t {
    pub arch: *const ::std::os::raw::c_char,
    pub bits: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_r_bin_arch_options_t() {
    assert_eq!(
        ::std::mem::size_of::<r_bin_arch_options_t>(),
        16usize,
        concat!("Size of: ", stringify!(r_bin_arch_options_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_bin_arch_options_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_bin_arch_options_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_arch_options_t>())).arch as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_arch_options_t),
            "::",
            stringify!(arch)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_arch_options_t>())).bits as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_arch_options_t),
            "::",
            stringify!(bits)
        )
    );
}
pub type RBinArchOptions = r_bin_arch_options_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_bin_trycatch_t {
    pub source: u64,
    pub from: u64,
    pub to: u64,
    pub handler: u64,
    pub filter: u64,
}
#[test]
fn bindgen_test_layout_r_bin_trycatch_t() {
    assert_eq!(
        ::std::mem::size_of::<r_bin_trycatch_t>(),
        40usize,
        concat!("Size of: ", stringify!(r_bin_trycatch_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_bin_trycatch_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_bin_trycatch_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_trycatch_t>())).source as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_trycatch_t),
            "::",
            stringify!(source)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_trycatch_t>())).from as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_trycatch_t),
            "::",
            stringify!(from)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_trycatch_t>())).to as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_trycatch_t),
            "::",
            stringify!(to)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_trycatch_t>())).handler as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_trycatch_t),
            "::",
            stringify!(handler)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_trycatch_t>())).filter as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_trycatch_t),
            "::",
            stringify!(filter)
        )
    );
}
pub type RBinTrycatch = r_bin_trycatch_t;
extern "C" {
    pub fn r_bin_trycatch_new(
        source: u64,
        from: u64,
        to: u64,
        handler: u64,
        filter: u64,
    ) -> *mut RBinTrycatch;
}
extern "C" {
    pub fn r_bin_trycatch_free(tc: *mut RBinTrycatch);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_bin_plugin_t {
    pub name: *mut ::std::os::raw::c_char,
    pub desc: *mut ::std::os::raw::c_char,
    pub author: *mut ::std::os::raw::c_char,
    pub version: *mut ::std::os::raw::c_char,
    pub license: *mut ::std::os::raw::c_char,
    pub init: ::std::option::Option<
        unsafe extern "C" fn(user: *mut ::std::os::raw::c_void) -> ::std::os::raw::c_int,
    >,
    pub fini: ::std::option::Option<
        unsafe extern "C" fn(user: *mut ::std::os::raw::c_void) -> ::std::os::raw::c_int,
    >,
    pub get_sdb: ::std::option::Option<unsafe extern "C" fn(obj: *mut RBinFile) -> *mut Sdb>,
    pub load_buffer: ::std::option::Option<
        unsafe extern "C" fn(
            bf: *mut RBinFile,
            bin_obj: *mut *mut ::std::os::raw::c_void,
            buf: *mut RBuffer,
            loadaddr: u64,
            sdb: *mut Sdb,
        ) -> bool,
    >,
    pub size: ::std::option::Option<unsafe extern "C" fn(bin: *mut RBinFile) -> u64>,
    pub destroy: ::std::option::Option<unsafe extern "C" fn(bf: *mut RBinFile)>,
    pub check_buffer:
        ::std::option::Option<unsafe extern "C" fn(bf: *mut RBinFile, buf: *mut RBuffer) -> bool>,
    pub baddr: ::std::option::Option<unsafe extern "C" fn(bf: *mut RBinFile) -> u64>,
    pub boffset: ::std::option::Option<unsafe extern "C" fn(bf: *mut RBinFile) -> u64>,
    pub binsym: ::std::option::Option<
        unsafe extern "C" fn(bf: *mut RBinFile, num: ::std::os::raw::c_int) -> *mut RBinAddr,
    >,
    pub entries: ::std::option::Option<unsafe extern "C" fn(bf: *mut RBinFile) -> *mut RList>,
    pub sections: ::std::option::Option<unsafe extern "C" fn(bf: *mut RBinFile) -> *mut RList>,
    pub lines: ::std::option::Option<unsafe extern "C" fn(bf: *mut RBinFile) -> *mut RList>,
    pub symbols: ::std::option::Option<unsafe extern "C" fn(bf: *mut RBinFile) -> *mut RList>,
    pub imports: ::std::option::Option<unsafe extern "C" fn(bf: *mut RBinFile) -> *mut RList>,
    pub strings: ::std::option::Option<unsafe extern "C" fn(bf: *mut RBinFile) -> *mut RList>,
    pub info: ::std::option::Option<unsafe extern "C" fn(bf: *mut RBinFile) -> *mut RBinInfo>,
    pub fields: ::std::option::Option<unsafe extern "C" fn(bf: *mut RBinFile) -> *mut RList>,
    pub libs: ::std::option::Option<unsafe extern "C" fn(bf: *mut RBinFile) -> *mut RList>,
    pub relocs: ::std::option::Option<unsafe extern "C" fn(bf: *mut RBinFile) -> *mut RList>,
    pub trycatch: ::std::option::Option<unsafe extern "C" fn(bf: *mut RBinFile) -> *mut RList>,
    pub classes: ::std::option::Option<unsafe extern "C" fn(bf: *mut RBinFile) -> *mut RList>,
    pub mem: ::std::option::Option<unsafe extern "C" fn(bf: *mut RBinFile) -> *mut RList>,
    pub patch_relocs: ::std::option::Option<unsafe extern "C" fn(bin: *mut RBin) -> *mut RList>,
    pub maps: ::std::option::Option<unsafe extern "C" fn(bf: *mut RBinFile) -> *mut RList>,
    pub hashes: ::std::option::Option<unsafe extern "C" fn(bf: *mut RBinFile) -> *mut RList>,
    pub header: ::std::option::Option<unsafe extern "C" fn(bf: *mut RBinFile)>,
    pub signature: ::std::option::Option<
        unsafe extern "C" fn(bf: *mut RBinFile, json: bool) -> *mut ::std::os::raw::c_char,
    >,
    pub demangle_type: ::std::option::Option<
        unsafe extern "C" fn(str_: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int,
    >,
    pub dbginfo: *mut r_bin_dbginfo_t,
    pub write: *mut r_bin_write_t,
    pub get_offset: ::std::option::Option<
        unsafe extern "C" fn(
            bf: *mut RBinFile,
            type_: ::std::os::raw::c_int,
            idx: ::std::os::raw::c_int,
        ) -> ::std::os::raw::c_int,
    >,
    pub get_name: ::std::option::Option<
        unsafe extern "C" fn(
            bf: *mut RBinFile,
            type_: ::std::os::raw::c_int,
            idx: ::std::os::raw::c_int,
            simplified: bool,
        ) -> *const ::std::os::raw::c_char,
    >,
    pub get_vaddr: ::std::option::Option<
        unsafe extern "C" fn(bf: *mut RBinFile, baddr: u64, paddr: u64, vaddr: u64) -> u64,
    >,
    pub create: ::std::option::Option<
        unsafe extern "C" fn(
            bin: *mut RBin,
            code: *const u8,
            codelen: ::std::os::raw::c_int,
            data: *const u8,
            datalen: ::std::os::raw::c_int,
            opt: *mut RBinArchOptions,
        ) -> *mut RBuffer,
    >,
    pub demangle: ::std::option::Option<
        unsafe extern "C" fn(str_: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char,
    >,
    pub regstate: ::std::option::Option<
        unsafe extern "C" fn(bf: *mut RBinFile) -> *mut ::std::os::raw::c_char,
    >,
    pub file_type:
        ::std::option::Option<unsafe extern "C" fn(bf: *mut RBinFile) -> ::std::os::raw::c_int>,
    pub minstrlen: ::std::os::raw::c_int,
    pub strfilter: ::std::os::raw::c_char,
    pub user: *mut ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout_r_bin_plugin_t() {
    assert_eq!(
        ::std::mem::size_of::<r_bin_plugin_t>(),
        360usize,
        concat!("Size of: ", stringify!(r_bin_plugin_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_bin_plugin_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_bin_plugin_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_plugin_t>())).name as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_plugin_t),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_plugin_t>())).desc as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_plugin_t),
            "::",
            stringify!(desc)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_plugin_t>())).author as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_plugin_t),
            "::",
            stringify!(author)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_plugin_t>())).version as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_plugin_t),
            "::",
            stringify!(version)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_plugin_t>())).license as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_plugin_t),
            "::",
            stringify!(license)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_plugin_t>())).init as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_plugin_t),
            "::",
            stringify!(init)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_plugin_t>())).fini as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_plugin_t),
            "::",
            stringify!(fini)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_plugin_t>())).get_sdb as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_plugin_t),
            "::",
            stringify!(get_sdb)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_plugin_t>())).load_buffer as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_plugin_t),
            "::",
            stringify!(load_buffer)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_plugin_t>())).size as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_plugin_t),
            "::",
            stringify!(size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_plugin_t>())).destroy as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_plugin_t),
            "::",
            stringify!(destroy)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_plugin_t>())).check_buffer as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_plugin_t),
            "::",
            stringify!(check_buffer)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_plugin_t>())).baddr as *const _ as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_plugin_t),
            "::",
            stringify!(baddr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_plugin_t>())).boffset as *const _ as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_plugin_t),
            "::",
            stringify!(boffset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_plugin_t>())).binsym as *const _ as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_plugin_t),
            "::",
            stringify!(binsym)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_plugin_t>())).entries as *const _ as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_plugin_t),
            "::",
            stringify!(entries)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_plugin_t>())).sections as *const _ as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_plugin_t),
            "::",
            stringify!(sections)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_plugin_t>())).lines as *const _ as usize },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_plugin_t),
            "::",
            stringify!(lines)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_plugin_t>())).symbols as *const _ as usize },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_plugin_t),
            "::",
            stringify!(symbols)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_plugin_t>())).imports as *const _ as usize },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_plugin_t),
            "::",
            stringify!(imports)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_plugin_t>())).strings as *const _ as usize },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_plugin_t),
            "::",
            stringify!(strings)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_plugin_t>())).info as *const _ as usize },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_plugin_t),
            "::",
            stringify!(info)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_plugin_t>())).fields as *const _ as usize },
        176usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_plugin_t),
            "::",
            stringify!(fields)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_plugin_t>())).libs as *const _ as usize },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_plugin_t),
            "::",
            stringify!(libs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_plugin_t>())).relocs as *const _ as usize },
        192usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_plugin_t),
            "::",
            stringify!(relocs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_plugin_t>())).trycatch as *const _ as usize },
        200usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_plugin_t),
            "::",
            stringify!(trycatch)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_plugin_t>())).classes as *const _ as usize },
        208usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_plugin_t),
            "::",
            stringify!(classes)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_plugin_t>())).mem as *const _ as usize },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_plugin_t),
            "::",
            stringify!(mem)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_plugin_t>())).patch_relocs as *const _ as usize },
        224usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_plugin_t),
            "::",
            stringify!(patch_relocs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_plugin_t>())).maps as *const _ as usize },
        232usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_plugin_t),
            "::",
            stringify!(maps)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_plugin_t>())).hashes as *const _ as usize },
        240usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_plugin_t),
            "::",
            stringify!(hashes)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_plugin_t>())).header as *const _ as usize },
        248usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_plugin_t),
            "::",
            stringify!(header)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_plugin_t>())).signature as *const _ as usize },
        256usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_plugin_t),
            "::",
            stringify!(signature)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_plugin_t>())).demangle_type as *const _ as usize },
        264usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_plugin_t),
            "::",
            stringify!(demangle_type)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_plugin_t>())).dbginfo as *const _ as usize },
        272usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_plugin_t),
            "::",
            stringify!(dbginfo)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_plugin_t>())).write as *const _ as usize },
        280usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_plugin_t),
            "::",
            stringify!(write)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_plugin_t>())).get_offset as *const _ as usize },
        288usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_plugin_t),
            "::",
            stringify!(get_offset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_plugin_t>())).get_name as *const _ as usize },
        296usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_plugin_t),
            "::",
            stringify!(get_name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_plugin_t>())).get_vaddr as *const _ as usize },
        304usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_plugin_t),
            "::",
            stringify!(get_vaddr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_plugin_t>())).create as *const _ as usize },
        312usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_plugin_t),
            "::",
            stringify!(create)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_plugin_t>())).demangle as *const _ as usize },
        320usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_plugin_t),
            "::",
            stringify!(demangle)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_plugin_t>())).regstate as *const _ as usize },
        328usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_plugin_t),
            "::",
            stringify!(regstate)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_plugin_t>())).file_type as *const _ as usize },
        336usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_plugin_t),
            "::",
            stringify!(file_type)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_plugin_t>())).minstrlen as *const _ as usize },
        344usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_plugin_t),
            "::",
            stringify!(minstrlen)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_plugin_t>())).strfilter as *const _ as usize },
        348usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_plugin_t),
            "::",
            stringify!(strfilter)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_plugin_t>())).user as *const _ as usize },
        352usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_plugin_t),
            "::",
            stringify!(user)
        )
    );
}
pub type RBinPlugin = r_bin_plugin_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_bin_section_t {
    pub name: *mut ::std::os::raw::c_char,
    pub size: u64,
    pub vsize: u64,
    pub vaddr: u64,
    pub paddr: u64,
    pub perm: u32,
    pub arch: *const ::std::os::raw::c_char,
    pub format: *mut ::std::os::raw::c_char,
    pub bits: ::std::os::raw::c_int,
    pub has_strings: bool,
    pub add: bool,
    pub is_data: bool,
    pub is_segment: bool,
}
#[test]
fn bindgen_test_layout_r_bin_section_t() {
    assert_eq!(
        ::std::mem::size_of::<r_bin_section_t>(),
        72usize,
        concat!("Size of: ", stringify!(r_bin_section_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_bin_section_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_bin_section_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_section_t>())).name as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_section_t),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_section_t>())).size as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_section_t),
            "::",
            stringify!(size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_section_t>())).vsize as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_section_t),
            "::",
            stringify!(vsize)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_section_t>())).vaddr as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_section_t),
            "::",
            stringify!(vaddr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_section_t>())).paddr as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_section_t),
            "::",
            stringify!(paddr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_section_t>())).perm as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_section_t),
            "::",
            stringify!(perm)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_section_t>())).arch as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_section_t),
            "::",
            stringify!(arch)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_section_t>())).format as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_section_t),
            "::",
            stringify!(format)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_section_t>())).bits as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_section_t),
            "::",
            stringify!(bits)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_section_t>())).has_strings as *const _ as usize },
        68usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_section_t),
            "::",
            stringify!(has_strings)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_section_t>())).add as *const _ as usize },
        69usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_section_t),
            "::",
            stringify!(add)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_section_t>())).is_data as *const _ as usize },
        70usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_section_t),
            "::",
            stringify!(is_data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_section_t>())).is_segment as *const _ as usize },
        71usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_section_t),
            "::",
            stringify!(is_segment)
        )
    );
}
pub type RBinSection = r_bin_section_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_bin_class_t {
    pub name: *mut ::std::os::raw::c_char,
    pub super_: *mut ::std::os::raw::c_char,
    pub visibility_str: *mut ::std::os::raw::c_char,
    pub index: ::std::os::raw::c_int,
    pub addr: u64,
    pub methods: *mut RList,
    pub fields: *mut RList,
    pub visibility: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_r_bin_class_t() {
    assert_eq!(
        ::std::mem::size_of::<r_bin_class_t>(),
        64usize,
        concat!("Size of: ", stringify!(r_bin_class_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_bin_class_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_bin_class_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_class_t>())).name as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_class_t),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_class_t>())).super_ as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_class_t),
            "::",
            stringify!(super_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_class_t>())).visibility_str as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_class_t),
            "::",
            stringify!(visibility_str)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_class_t>())).index as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_class_t),
            "::",
            stringify!(index)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_class_t>())).addr as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_class_t),
            "::",
            stringify!(addr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_class_t>())).methods as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_class_t),
            "::",
            stringify!(methods)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_class_t>())).fields as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_class_t),
            "::",
            stringify!(fields)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_class_t>())).visibility as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_class_t),
            "::",
            stringify!(visibility)
        )
    );
}
pub type RBinClass = r_bin_class_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_bin_symbol_t {
    pub name: *mut ::std::os::raw::c_char,
    pub dname: *mut ::std::os::raw::c_char,
    pub libname: *mut ::std::os::raw::c_char,
    pub classname: *mut ::std::os::raw::c_char,
    pub forwarder: *const ::std::os::raw::c_char,
    pub bind: *const ::std::os::raw::c_char,
    pub type_: *const ::std::os::raw::c_char,
    pub rtype: *const ::std::os::raw::c_char,
    pub is_imported: bool,
    pub visibility_str: *const ::std::os::raw::c_char,
    pub vaddr: u64,
    pub paddr: u64,
    pub size: u32,
    pub ordinal: u32,
    pub visibility: u32,
    pub bits: ::std::os::raw::c_int,
    pub method_flags: u64,
    pub dup_count: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_r_bin_symbol_t() {
    assert_eq!(
        ::std::mem::size_of::<r_bin_symbol_t>(),
        128usize,
        concat!("Size of: ", stringify!(r_bin_symbol_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_bin_symbol_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_bin_symbol_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_symbol_t>())).name as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_symbol_t),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_symbol_t>())).dname as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_symbol_t),
            "::",
            stringify!(dname)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_symbol_t>())).libname as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_symbol_t),
            "::",
            stringify!(libname)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_symbol_t>())).classname as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_symbol_t),
            "::",
            stringify!(classname)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_symbol_t>())).forwarder as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_symbol_t),
            "::",
            stringify!(forwarder)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_symbol_t>())).bind as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_symbol_t),
            "::",
            stringify!(bind)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_symbol_t>())).type_ as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_symbol_t),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_symbol_t>())).rtype as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_symbol_t),
            "::",
            stringify!(rtype)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_symbol_t>())).is_imported as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_symbol_t),
            "::",
            stringify!(is_imported)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_symbol_t>())).visibility_str as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_symbol_t),
            "::",
            stringify!(visibility_str)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_symbol_t>())).vaddr as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_symbol_t),
            "::",
            stringify!(vaddr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_symbol_t>())).paddr as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_symbol_t),
            "::",
            stringify!(paddr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_symbol_t>())).size as *const _ as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_symbol_t),
            "::",
            stringify!(size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_symbol_t>())).ordinal as *const _ as usize },
        100usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_symbol_t),
            "::",
            stringify!(ordinal)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_symbol_t>())).visibility as *const _ as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_symbol_t),
            "::",
            stringify!(visibility)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_symbol_t>())).bits as *const _ as usize },
        108usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_symbol_t),
            "::",
            stringify!(bits)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_symbol_t>())).method_flags as *const _ as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_symbol_t),
            "::",
            stringify!(method_flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_symbol_t>())).dup_count as *const _ as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_symbol_t),
            "::",
            stringify!(dup_count)
        )
    );
}
pub type RBinSymbol = r_bin_symbol_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_bin_import_t {
    pub name: *mut ::std::os::raw::c_char,
    pub libname: *mut ::std::os::raw::c_char,
    pub bind: *const ::std::os::raw::c_char,
    pub type_: *const ::std::os::raw::c_char,
    pub classname: *mut ::std::os::raw::c_char,
    pub descriptor: *mut ::std::os::raw::c_char,
    pub ordinal: u32,
    pub visibility: u32,
}
#[test]
fn bindgen_test_layout_r_bin_import_t() {
    assert_eq!(
        ::std::mem::size_of::<r_bin_import_t>(),
        56usize,
        concat!("Size of: ", stringify!(r_bin_import_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_bin_import_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_bin_import_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_import_t>())).name as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_import_t),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_import_t>())).libname as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_import_t),
            "::",
            stringify!(libname)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_import_t>())).bind as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_import_t),
            "::",
            stringify!(bind)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_import_t>())).type_ as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_import_t),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_import_t>())).classname as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_import_t),
            "::",
            stringify!(classname)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_import_t>())).descriptor as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_import_t),
            "::",
            stringify!(descriptor)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_import_t>())).ordinal as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_import_t),
            "::",
            stringify!(ordinal)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_import_t>())).visibility as *const _ as usize },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_import_t),
            "::",
            stringify!(visibility)
        )
    );
}
pub type RBinImport = r_bin_import_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_bin_reloc_t {
    pub type_: u8,
    pub additive: u8,
    pub symbol: *mut RBinSymbol,
    pub import: *mut RBinImport,
    pub addend: i64,
    pub vaddr: u64,
    pub paddr: u64,
    pub visibility: u32,
    pub is_ifunc: bool,
}
#[test]
fn bindgen_test_layout_r_bin_reloc_t() {
    assert_eq!(
        ::std::mem::size_of::<r_bin_reloc_t>(),
        56usize,
        concat!("Size of: ", stringify!(r_bin_reloc_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_bin_reloc_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_bin_reloc_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_reloc_t>())).type_ as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_reloc_t),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_reloc_t>())).additive as *const _ as usize },
        1usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_reloc_t),
            "::",
            stringify!(additive)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_reloc_t>())).symbol as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_reloc_t),
            "::",
            stringify!(symbol)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_reloc_t>())).import as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_reloc_t),
            "::",
            stringify!(import)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_reloc_t>())).addend as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_reloc_t),
            "::",
            stringify!(addend)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_reloc_t>())).vaddr as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_reloc_t),
            "::",
            stringify!(vaddr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_reloc_t>())).paddr as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_reloc_t),
            "::",
            stringify!(paddr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_reloc_t>())).visibility as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_reloc_t),
            "::",
            stringify!(visibility)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_reloc_t>())).is_ifunc as *const _ as usize },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_reloc_t),
            "::",
            stringify!(is_ifunc)
        )
    );
}
pub type RBinReloc = r_bin_reloc_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_bin_field_t {
    pub vaddr: u64,
    pub paddr: u64,
    pub size: ::std::os::raw::c_int,
    pub offset: ::std::os::raw::c_int,
    pub visibility: u32,
    pub name: *mut ::std::os::raw::c_char,
    pub type_: *mut ::std::os::raw::c_char,
    pub comment: *mut ::std::os::raw::c_char,
    pub format: *mut ::std::os::raw::c_char,
    pub format_named: bool,
    pub flags: u64,
}
#[test]
fn bindgen_test_layout_r_bin_field_t() {
    assert_eq!(
        ::std::mem::size_of::<r_bin_field_t>(),
        80usize,
        concat!("Size of: ", stringify!(r_bin_field_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_bin_field_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_bin_field_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_field_t>())).vaddr as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_field_t),
            "::",
            stringify!(vaddr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_field_t>())).paddr as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_field_t),
            "::",
            stringify!(paddr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_field_t>())).size as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_field_t),
            "::",
            stringify!(size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_field_t>())).offset as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_field_t),
            "::",
            stringify!(offset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_field_t>())).visibility as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_field_t),
            "::",
            stringify!(visibility)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_field_t>())).name as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_field_t),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_field_t>())).type_ as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_field_t),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_field_t>())).comment as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_field_t),
            "::",
            stringify!(comment)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_field_t>())).format as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_field_t),
            "::",
            stringify!(format)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_field_t>())).format_named as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_field_t),
            "::",
            stringify!(format_named)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_field_t>())).flags as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_field_t),
            "::",
            stringify!(flags)
        )
    );
}
pub type RBinField = r_bin_field_t;
extern "C" {
    pub fn r_bin_field_new(
        paddr: u64,
        vaddr: u64,
        size: ::std::os::raw::c_int,
        name: *const ::std::os::raw::c_char,
        comment: *const ::std::os::raw::c_char,
        format: *const ::std::os::raw::c_char,
        format_named: bool,
    ) -> *mut RBinField;
}
extern "C" {
    pub fn r_bin_field_free(arg1: *mut ::std::os::raw::c_void);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_bin_dbginfo_t {
    pub get_line: ::std::option::Option<
        unsafe extern "C" fn(
            arch: *mut RBinFile,
            addr: u64,
            file: *mut ::std::os::raw::c_char,
            len: ::std::os::raw::c_int,
            line: *mut ::std::os::raw::c_int,
        ) -> bool,
    >,
}
#[test]
fn bindgen_test_layout_r_bin_dbginfo_t() {
    assert_eq!(
        ::std::mem::size_of::<r_bin_dbginfo_t>(),
        8usize,
        concat!("Size of: ", stringify!(r_bin_dbginfo_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_bin_dbginfo_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_bin_dbginfo_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_dbginfo_t>())).get_line as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_dbginfo_t),
            "::",
            stringify!(get_line)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_bin_write_t {
    pub scn_resize: ::std::option::Option<
        unsafe extern "C" fn(
            bf: *mut RBinFile,
            name: *const ::std::os::raw::c_char,
            size: u64,
        ) -> u64,
    >,
    pub scn_perms: ::std::option::Option<
        unsafe extern "C" fn(
            bf: *mut RBinFile,
            name: *const ::std::os::raw::c_char,
            perms: ::std::os::raw::c_int,
        ) -> bool,
    >,
    pub rpath_del:
        ::std::option::Option<unsafe extern "C" fn(bf: *mut RBinFile) -> ::std::os::raw::c_int>,
    pub entry: ::std::option::Option<unsafe extern "C" fn(bf: *mut RBinFile, addr: u64) -> bool>,
    pub addlib: ::std::option::Option<
        unsafe extern "C" fn(bf: *mut RBinFile, lib: *const ::std::os::raw::c_char) -> bool,
    >,
}
#[test]
fn bindgen_test_layout_r_bin_write_t() {
    assert_eq!(
        ::std::mem::size_of::<r_bin_write_t>(),
        40usize,
        concat!("Size of: ", stringify!(r_bin_write_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_bin_write_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_bin_write_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_write_t>())).scn_resize as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_write_t),
            "::",
            stringify!(scn_resize)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_write_t>())).scn_perms as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_write_t),
            "::",
            stringify!(scn_perms)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_write_t>())).rpath_del as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_write_t),
            "::",
            stringify!(rpath_del)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_write_t>())).entry as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_write_t),
            "::",
            stringify!(entry)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_write_t>())).addlib as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_write_t),
            "::",
            stringify!(addlib)
        )
    );
}
pub type RBinGetOffset = ::std::option::Option<
    unsafe extern "C" fn(
        bin: *mut RBin,
        type_: ::std::os::raw::c_int,
        idx: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int,
>;
pub type RBinGetName = ::std::option::Option<
    unsafe extern "C" fn(
        bin: *mut RBin,
        type_: ::std::os::raw::c_int,
        idx: ::std::os::raw::c_int,
        sd: bool,
    ) -> *const ::std::os::raw::c_char,
>;
pub type RBinGetSections =
    ::std::option::Option<unsafe extern "C" fn(bin: *mut RBin) -> *mut RList>;
pub type RBinGetSectionAt =
    ::std::option::Option<unsafe extern "C" fn(bin: *mut RBin, addr: u64) -> *mut RBinSection>;
pub type RBinDemangle = ::std::option::Option<
    unsafe extern "C" fn(
        bf: *mut RBinFile,
        def: *const ::std::os::raw::c_char,
        str_: *const ::std::os::raw::c_char,
        vaddr: u64,
        libs: bool,
    ) -> *mut ::std::os::raw::c_char,
>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_bin_bind_t {
    pub bin: *mut RBin,
    pub get_offset: RBinGetOffset,
    pub get_name: RBinGetName,
    pub get_sections: RBinGetSections,
    pub get_vsect_at: RBinGetSectionAt,
    pub demangle: RBinDemangle,
    pub visibility: u32,
}
#[test]
fn bindgen_test_layout_r_bin_bind_t() {
    assert_eq!(
        ::std::mem::size_of::<r_bin_bind_t>(),
        56usize,
        concat!("Size of: ", stringify!(r_bin_bind_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_bin_bind_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_bin_bind_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_bind_t>())).bin as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_bind_t),
            "::",
            stringify!(bin)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_bind_t>())).get_offset as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_bind_t),
            "::",
            stringify!(get_offset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_bind_t>())).get_name as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_bind_t),
            "::",
            stringify!(get_name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_bind_t>())).get_sections as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_bind_t),
            "::",
            stringify!(get_sections)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_bind_t>())).get_vsect_at as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_bind_t),
            "::",
            stringify!(get_vsect_at)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_bind_t>())).demangle as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_bind_t),
            "::",
            stringify!(demangle)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_bin_bind_t>())).visibility as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(r_bin_bind_t),
            "::",
            stringify!(visibility)
        )
    );
}
pub type RBinBind = r_bin_bind_t;
extern "C" {
    pub fn r_bin_section_new(name: *const ::std::os::raw::c_char) -> *mut RBinSection;
}
extern "C" {
    pub fn r_bin_section_free(bs: *mut RBinSection);
}
extern "C" {
    pub fn r_bin_info_free(rb: *mut RBinInfo);
}
extern "C" {
    pub fn r_bin_import_free(imp: *mut RBinImport);
}
extern "C" {
    pub fn r_bin_symbol_free(_sym: *mut ::std::os::raw::c_void);
}
extern "C" {
    pub fn r_bin_symbol_new(
        name: *const ::std::os::raw::c_char,
        paddr: u64,
        vaddr: u64,
    ) -> *mut RBinSymbol;
}
extern "C" {
    pub fn r_bin_string_free(_str: *mut ::std::os::raw::c_void);
}
extern "C" {
    pub fn r_bin_import_clone(o: *mut RBinImport) -> *mut RBinImport;
}
extern "C" {
    pub fn r_bin_file_options_init(
        opt: *mut RBinFileOptions,
        fd: ::std::os::raw::c_int,
        baseaddr: u64,
        loadaddr: u64,
        rawstr: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn r_bin_arch_options_init(
        opt: *mut RBinArchOptions,
        arch: *const ::std::os::raw::c_char,
        bits: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn r_bin_new() -> *mut RBin;
}
extern "C" {
    pub fn r_bin_free(bin: *mut RBin);
}
extern "C" {
    pub fn r_bin_open(
        bin: *mut RBin,
        file: *const ::std::os::raw::c_char,
        opt: *mut RBinFileOptions,
    ) -> bool;
}
extern "C" {
    pub fn r_bin_open_io(bin: *mut RBin, opt: *mut RBinFileOptions) -> bool;
}
extern "C" {
    pub fn r_bin_open_buf(bin: *mut RBin, buf: *mut RBuffer, opt: *mut RBinFileOptions) -> bool;
}
extern "C" {
    pub fn r_bin_reload(bin: *mut RBin, bf_id: u32, baseaddr: u64) -> bool;
}
extern "C" {
    pub fn r_bin_bind(b: *mut RBin, bnd: *mut RBinBind);
}
extern "C" {
    pub fn r_bin_add(bin: *mut RBin, foo: *mut RBinPlugin) -> bool;
}
extern "C" {
    pub fn r_bin_xtr_add(bin: *mut RBin, foo: *mut RBinXtrPlugin) -> bool;
}
extern "C" {
    pub fn r_bin_ldr_add(bin: *mut RBin, foo: *mut RBinLdrPlugin) -> bool;
}
extern "C" {
    pub fn r_bin_list(bin: *mut RBin, pj: *mut PJ, format: ::std::os::raw::c_int);
}
extern "C" {
    pub fn r_bin_list_plugin(
        bin: *mut RBin,
        name: *const ::std::os::raw::c_char,
        pj: *mut PJ,
        json: ::std::os::raw::c_int,
    ) -> bool;
}
extern "C" {
    pub fn r_bin_get_binplugin_by_buffer(
        bin: *mut RBin,
        bf: *mut RBinFile,
        buf: *mut RBuffer,
    ) -> *mut RBinPlugin;
}
extern "C" {
    pub fn r_bin_force_plugin(bin: *mut RBin, pname: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn r_bin_get_baddr(bin: *mut RBin) -> u64;
}
extern "C" {
    pub fn r_bin_file_get_baddr(bf: *mut RBinFile) -> u64;
}
extern "C" {
    pub fn r_bin_set_user_ptr(bin: *mut RBin, user: *mut ::std::os::raw::c_void);
}
extern "C" {
    pub fn r_bin_get_info(bin: *mut RBin) -> *mut RBinInfo;
}
extern "C" {
    pub fn r_bin_set_baddr(bin: *mut RBin, baddr: u64);
}
extern "C" {
    pub fn r_bin_get_laddr(bin: *mut RBin) -> u64;
}
extern "C" {
    pub fn r_bin_get_size(bin: *mut RBin) -> u64;
}
extern "C" {
    pub fn r_bin_get_sym(bin: *mut RBin, sym: ::std::os::raw::c_int) -> *mut RBinAddr;
}
extern "C" {
    pub fn r_bin_raw_strings(a: *mut RBinFile, min: ::std::os::raw::c_int) -> *mut RList;
}
extern "C" {
    pub fn r_bin_dump_strings(
        a: *mut RBinFile,
        min: ::std::os::raw::c_int,
        raw: ::std::os::raw::c_int,
    ) -> *mut RList;
}
extern "C" {
    pub fn r_bin_get_entries(bin: *mut RBin) -> *mut RList;
}
extern "C" {
    pub fn r_bin_get_fields(bin: *mut RBin) -> *mut RList;
}
extern "C" {
    pub fn r_bin_get_imports(bin: *mut RBin) -> *const RList;
}
extern "C" {
    pub fn r_bin_get_libs(bin: *mut RBin) -> *mut RList;
}
extern "C" {
    pub fn r_bin_patch_relocs(bin: *mut RBin) -> *mut RRBTree;
}
extern "C" {
    pub fn r_bin_patch_relocs_list(bin: *mut RBin) -> *mut RList;
}
extern "C" {
    pub fn r_bin_get_relocs(bin: *mut RBin) -> *mut RRBTree;
}
extern "C" {
    pub fn r_bin_get_relocs_list(bin: *mut RBin) -> *mut RList;
}
extern "C" {
    pub fn r_bin_get_sections(bin: *mut RBin) -> *mut RList;
}
extern "C" {
    pub fn r_bin_get_classes(bin: *mut RBin) -> *mut RList;
}
extern "C" {
    pub fn r_bin_get_strings(bin: *mut RBin) -> *mut RList;
}
extern "C" {
    pub fn r_bin_file_get_trycatch(bf: *mut RBinFile) -> *mut RList;
}
extern "C" {
    pub fn r_bin_get_symbols(bin: *mut RBin) -> *mut RList;
}
extern "C" {
    pub fn r_bin_reset_strings(bin: *mut RBin) -> *mut RList;
}
extern "C" {
    pub fn r_bin_is_string(bin: *mut RBin, va: u64) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_bin_is_big_endian(bin: *mut RBin) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_bin_is_static(bin: *mut RBin) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_bin_get_vaddr(bin: *mut RBin, paddr: u64, vaddr: u64) -> u64;
}
extern "C" {
    pub fn r_bin_file_get_vaddr(bf: *mut RBinFile, paddr: u64, vaddr: u64) -> u64;
}
extern "C" {
    pub fn r_bin_a2b(bin: *mut RBin, addr: u64) -> u64;
}
extern "C" {
    pub fn r_bin_load_languages(binfile: *mut RBinFile) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_bin_cur(bin: *mut RBin) -> *mut RBinFile;
}
extern "C" {
    pub fn r_bin_cur_object(bin: *mut RBin) -> *mut RBinObject;
}
extern "C" {
    pub fn r_bin_select(
        bin: *mut RBin,
        arch: *const ::std::os::raw::c_char,
        bits: ::std::os::raw::c_int,
        name: *const ::std::os::raw::c_char,
    ) -> bool;
}
extern "C" {
    pub fn r_bin_select_bfid(bin: *mut RBin, bf_id: u32) -> bool;
}
extern "C" {
    pub fn r_bin_use_arch(
        bin: *mut RBin,
        arch: *const ::std::os::raw::c_char,
        bits: ::std::os::raw::c_int,
        name: *const ::std::os::raw::c_char,
    ) -> bool;
}
extern "C" {
    pub fn r_bin_list_archs(bin: *mut RBin, pj: *mut PJ, mode: ::std::os::raw::c_int);
}
extern "C" {
    pub fn r_bin_create(
        bin: *mut RBin,
        plugin_name: *const ::std::os::raw::c_char,
        code: *const u8,
        codelen: ::std::os::raw::c_int,
        data: *const u8,
        datalen: ::std::os::raw::c_int,
        opt: *mut RBinArchOptions,
    ) -> *mut RBuffer;
}
extern "C" {
    pub fn r_bin_package(
        bin: *mut RBin,
        type_: *const ::std::os::raw::c_char,
        file: *const ::std::os::raw::c_char,
        files: *mut RList,
    ) -> *mut RBuffer;
}
extern "C" {
    pub fn r_bin_string_type(type_: ::std::os::raw::c_int) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_bin_entry_type_string(etype: ::std::os::raw::c_int) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_bin_file_object_new_from_xtr_data(
        bin: *mut RBin,
        bf: *mut RBinFile,
        baseaddr: u64,
        loadaddr: u64,
        data: *mut RBinXtrData,
    ) -> bool;
}
extern "C" {
    pub fn r_bin_file_close(bin: *mut RBin, bd: ::std::os::raw::c_int) -> bool;
}
extern "C" {
    pub fn r_bin_file_free(bf_: *mut ::std::os::raw::c_void);
}
extern "C" {
    pub fn r_bin_file_at(bin: *mut RBin, addr: u64) -> *mut RBinFile;
}
extern "C" {
    pub fn r_bin_file_find_by_object_id(bin: *mut RBin, binobj_id: u32) -> *mut RBinFile;
}
extern "C" {
    pub fn r_bin_file_get_symbols(bf: *mut RBinFile) -> *mut RList;
}
extern "C" {
    pub fn r_bin_file_add_class(
        binfile: *mut RBinFile,
        name: *const ::std::os::raw::c_char,
        super_: *const ::std::os::raw::c_char,
        view: ::std::os::raw::c_int,
    ) -> *mut RBinClass;
}
extern "C" {
    pub fn r_bin_file_add_method(
        bf: *mut RBinFile,
        classname: *const ::std::os::raw::c_char,
        name: *const ::std::os::raw::c_char,
        nargs: ::std::os::raw::c_int,
    ) -> *mut RBinSymbol;
}
extern "C" {
    pub fn r_bin_file_add_field(
        binfile: *mut RBinFile,
        classname: *const ::std::os::raw::c_char,
        name: *const ::std::os::raw::c_char,
    ) -> *mut RBinField;
}
extern "C" {
    pub fn r_bin_file_find_by_arch_bits(
        bin: *mut RBin,
        arch: *const ::std::os::raw::c_char,
        bits: ::std::os::raw::c_int,
    ) -> *mut RBinFile;
}
extern "C" {
    pub fn r_bin_file_find_by_id(bin: *mut RBin, bin_id: u32) -> *mut RBinFile;
}
extern "C" {
    pub fn r_bin_file_find_by_fd(bin: *mut RBin, bin_fd: u32) -> *mut RBinFile;
}
extern "C" {
    pub fn r_bin_file_find_by_name(
        bin: *mut RBin,
        name: *const ::std::os::raw::c_char,
    ) -> *mut RBinFile;
}
extern "C" {
    pub fn r_bin_file_set_cur_binfile(bin: *mut RBin, bf: *mut RBinFile) -> bool;
}
extern "C" {
    pub fn r_bin_file_set_cur_by_name(bin: *mut RBin, name: *const ::std::os::raw::c_char) -> bool;
}
extern "C" {
    pub fn r_bin_file_deref(bin: *mut RBin, a: *mut RBinFile) -> bool;
}
extern "C" {
    pub fn r_bin_file_set_cur_by_fd(bin: *mut RBin, bin_fd: u32) -> bool;
}
extern "C" {
    pub fn r_bin_file_set_cur_by_id(bin: *mut RBin, bin_id: u32) -> bool;
}
extern "C" {
    pub fn r_bin_file_delete_all(bin: *mut RBin) -> u64;
}
extern "C" {
    pub fn r_bin_file_delete(bin: *mut RBin, bin_id: u32) -> bool;
}
extern "C" {
    pub fn r_bin_file_compute_hashes(bin: *mut RBin, limit: u64) -> *mut RList;
}
extern "C" {
    pub fn r_bin_file_set_hashes(bin: *mut RBin, new_hashes: *mut RList) -> *mut RList;
}
extern "C" {
    pub fn r_bin_file_cur_plugin(binfile: *mut RBinFile) -> *mut RBinPlugin;
}
extern "C" {
    pub fn r_bin_file_hash_free(fhash: *mut RBinFileHash);
}
extern "C" {
    pub fn r_bin_object_set_items(
        binfile: *mut RBinFile,
        o: *mut RBinObject,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_bin_object_delete(bin: *mut RBin, binfile_id: u32) -> bool;
}
extern "C" {
    pub fn r_bin_mem_free(data: *mut ::std::os::raw::c_void);
}
extern "C" {
    pub fn r_bin_demangle(
        binfile: *mut RBinFile,
        lang: *const ::std::os::raw::c_char,
        str_: *const ::std::os::raw::c_char,
        vaddr: u64,
        libs: bool,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_bin_demangle_java(str_: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_bin_demangle_cxx(
        binfile: *mut RBinFile,
        str_: *const ::std::os::raw::c_char,
        vaddr: u64,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_bin_demangle_msvc(str_: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_bin_demangle_swift(
        s: *const ::std::os::raw::c_char,
        syscmd: bool,
        trylib: bool,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_bin_demangle_objc(
        binfile: *mut RBinFile,
        sym: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_bin_demangle_rust(
        binfile: *mut RBinFile,
        str_: *const ::std::os::raw::c_char,
        vaddr: u64,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_bin_demangle_type(str_: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_bin_demangle_list(bin: *mut RBin);
}
extern "C" {
    pub fn r_bin_demangle_plugin(
        bin: *mut RBin,
        name: *const ::std::os::raw::c_char,
        str_: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_bin_get_meth_flag_string(flag: u64, compact: bool) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_bin_get_section_at(
        o: *mut RBinObject,
        off: u64,
        va: ::std::os::raw::c_int,
    ) -> *mut RBinSection;
}
extern "C" {
    pub fn r_bin_addr2line(
        bin: *mut RBin,
        addr: u64,
        file: *mut ::std::os::raw::c_char,
        len: ::std::os::raw::c_int,
        line: *mut ::std::os::raw::c_int,
    ) -> bool;
}
extern "C" {
    pub fn r_bin_addr2line2(
        bin: *mut RBin,
        addr: u64,
        file: *mut ::std::os::raw::c_char,
        len: ::std::os::raw::c_int,
        line: *mut ::std::os::raw::c_int,
    ) -> bool;
}
extern "C" {
    pub fn r_bin_addr2text(
        bin: *mut RBin,
        addr: u64,
        origin: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_bin_addr2fileline(bin: *mut RBin, addr: u64) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_bin_wr_addlib(bin: *mut RBin, lib: *const ::std::os::raw::c_char) -> bool;
}
extern "C" {
    pub fn r_bin_wr_scn_resize(
        bin: *mut RBin,
        name: *const ::std::os::raw::c_char,
        size: u64,
    ) -> u64;
}
extern "C" {
    pub fn r_bin_wr_scn_perms(
        bin: *mut RBin,
        name: *const ::std::os::raw::c_char,
        perms: ::std::os::raw::c_int,
    ) -> bool;
}
extern "C" {
    pub fn r_bin_wr_rpath_del(bin: *mut RBin) -> bool;
}
extern "C" {
    pub fn r_bin_wr_entry(bin: *mut RBin, addr: u64) -> bool;
}
extern "C" {
    pub fn r_bin_wr_output(bin: *mut RBin, filename: *const ::std::os::raw::c_char) -> bool;
}
extern "C" {
    pub fn r_bin_get_mem(bin: *mut RBin) -> *mut RList;
}
extern "C" {
    pub fn r_bin_load_filter(bin: *mut RBin, rules: u64);
}
extern "C" {
    pub fn r_bin_filter_symbols(bf: *mut RBinFile, list: *mut RList);
}
extern "C" {
    pub fn r_bin_filter_sections(bf: *mut RBinFile, list: *mut RList);
}
extern "C" {
    pub fn r_bin_filter_name(
        bf: *mut RBinFile,
        db: *mut HtPU,
        addr: u64,
        name: *mut ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_bin_filter_sym(bf: *mut RBinFile, ht: *mut HtPP, vaddr: u64, sym: *mut RBinSymbol);
}
extern "C" {
    pub fn r_bin_strpurge(bin: *mut RBin, str_: *const ::std::os::raw::c_char, addr: u64) -> bool;
}
extern "C" {
    pub fn r_bin_string_filter(
        bin: *mut RBin,
        str_: *const ::std::os::raw::c_char,
        addr: u64,
    ) -> bool;
}
extern "C" {
    pub fn r_flag_version() -> *const ::std::os::raw::c_char;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_flag_item_t {
    pub name: *mut ::std::os::raw::c_char,
    pub realname: *mut ::std::os::raw::c_char,
    pub demangled: bool,
    pub offset: u64,
    pub size: u64,
    pub space: *mut RSpace,
    pub color: *mut ::std::os::raw::c_char,
    pub comment: *mut ::std::os::raw::c_char,
    pub alias: *mut ::std::os::raw::c_char,
    pub type_: *mut ::std::os::raw::c_char,
}
#[test]
fn bindgen_test_layout_r_flag_item_t() {
    assert_eq!(
        ::std::mem::size_of::<r_flag_item_t>(),
        80usize,
        concat!("Size of: ", stringify!(r_flag_item_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_flag_item_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_flag_item_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_flag_item_t>())).name as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_flag_item_t),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_flag_item_t>())).realname as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_flag_item_t),
            "::",
            stringify!(realname)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_flag_item_t>())).demangled as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(r_flag_item_t),
            "::",
            stringify!(demangled)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_flag_item_t>())).offset as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(r_flag_item_t),
            "::",
            stringify!(offset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_flag_item_t>())).size as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(r_flag_item_t),
            "::",
            stringify!(size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_flag_item_t>())).space as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(r_flag_item_t),
            "::",
            stringify!(space)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_flag_item_t>())).color as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(r_flag_item_t),
            "::",
            stringify!(color)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_flag_item_t>())).comment as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(r_flag_item_t),
            "::",
            stringify!(comment)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_flag_item_t>())).alias as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(r_flag_item_t),
            "::",
            stringify!(alias)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_flag_item_t>())).type_ as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(r_flag_item_t),
            "::",
            stringify!(type_)
        )
    );
}
pub type RFlagItem = r_flag_item_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_flag_t {
    pub spaces: RSpaces,
    pub base: i64,
    pub realnames: bool,
    pub tags: *mut Sdb,
    pub num: *mut RNum,
    pub by_off: *mut RSkipList,
    pub ht_name: *mut HtPP,
    pub cb_printf: PrintfCallback,
    pub zones: *mut RList,
    pub mask: u64,
    pub is_dirty: bool,
}
#[test]
fn bindgen_test_layout_r_flag_t() {
    assert_eq!(
        ::std::mem::size_of::<r_flag_t>(),
        120usize,
        concat!("Size of: ", stringify!(r_flag_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_flag_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_flag_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_flag_t>())).spaces as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_flag_t),
            "::",
            stringify!(spaces)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_flag_t>())).base as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(r_flag_t),
            "::",
            stringify!(base)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_flag_t>())).realnames as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(r_flag_t),
            "::",
            stringify!(realnames)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_flag_t>())).tags as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(r_flag_t),
            "::",
            stringify!(tags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_flag_t>())).num as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(r_flag_t),
            "::",
            stringify!(num)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_flag_t>())).by_off as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(r_flag_t),
            "::",
            stringify!(by_off)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_flag_t>())).ht_name as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(r_flag_t),
            "::",
            stringify!(ht_name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_flag_t>())).cb_printf as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(r_flag_t),
            "::",
            stringify!(cb_printf)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_flag_t>())).zones as *const _ as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(r_flag_t),
            "::",
            stringify!(zones)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_flag_t>())).mask as *const _ as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(r_flag_t),
            "::",
            stringify!(mask)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_flag_t>())).is_dirty as *const _ as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(r_flag_t),
            "::",
            stringify!(is_dirty)
        )
    );
}
pub type RFlag = r_flag_t;
pub type RFlagExistAt = ::std::option::Option<
    unsafe extern "C" fn(
        f: *mut RFlag,
        flag_prefix: *const ::std::os::raw::c_char,
        fp_size: u16,
        off: u64,
    ) -> bool,
>;
pub type RFlagGet = ::std::option::Option<
    unsafe extern "C" fn(f: *mut RFlag, name: *const ::std::os::raw::c_char) -> *mut RFlagItem,
>;
pub type RFlagGetAtAddr =
    ::std::option::Option<unsafe extern "C" fn(f: *mut RFlag, arg1: u64) -> *mut RFlagItem>;
pub type RFlagGetAt = ::std::option::Option<
    unsafe extern "C" fn(f: *mut RFlag, addr: u64, closest: bool) -> *mut RFlagItem,
>;
pub type RFlagGetList =
    ::std::option::Option<unsafe extern "C" fn(f: *mut RFlag, addr: u64) -> *const RList>;
pub type RFlagSet = ::std::option::Option<
    unsafe extern "C" fn(
        f: *mut RFlag,
        name: *const ::std::os::raw::c_char,
        addr: u64,
        size: u32,
    ) -> *mut RFlagItem,
>;
pub type RFlagUnset =
    ::std::option::Option<unsafe extern "C" fn(f: *mut RFlag, item: *mut RFlagItem) -> bool>;
pub type RFlagUnsetName = ::std::option::Option<
    unsafe extern "C" fn(f: *mut RFlag, name: *const ::std::os::raw::c_char) -> bool,
>;
pub type RFlagUnsetOff =
    ::std::option::Option<unsafe extern "C" fn(f: *mut RFlag, addr: u64) -> bool>;
pub type RFlagSetSpace = ::std::option::Option<
    unsafe extern "C" fn(f: *mut RFlag, name: *const ::std::os::raw::c_char) -> *mut RSpace,
>;
pub type RFlagPopSpace = ::std::option::Option<unsafe extern "C" fn(f: *mut RFlag) -> bool>;
pub type RFlagPushSpace = ::std::option::Option<
    unsafe extern "C" fn(f: *mut RFlag, name: *const ::std::os::raw::c_char) -> bool,
>;
pub type RFlagItemCb = ::std::option::Option<
    unsafe extern "C" fn(fi: *mut RFlagItem, user: *mut ::std::os::raw::c_void) -> bool,
>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_flag_bind_t {
    pub init: ::std::os::raw::c_int,
    pub f: *mut RFlag,
    pub exist_at: RFlagExistAt,
    pub get: RFlagGet,
    pub get_at: RFlagGetAt,
    pub get_list: RFlagGetList,
    pub set: RFlagSet,
    pub unset: RFlagUnset,
    pub unset_name: RFlagUnsetName,
    pub unset_off: RFlagUnsetOff,
    pub set_fs: RFlagSetSpace,
    pub push_fs: RFlagPushSpace,
    pub pop_fs: RFlagPopSpace,
}
#[test]
fn bindgen_test_layout_r_flag_bind_t() {
    assert_eq!(
        ::std::mem::size_of::<r_flag_bind_t>(),
        104usize,
        concat!("Size of: ", stringify!(r_flag_bind_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_flag_bind_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_flag_bind_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_flag_bind_t>())).init as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_flag_bind_t),
            "::",
            stringify!(init)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_flag_bind_t>())).f as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_flag_bind_t),
            "::",
            stringify!(f)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_flag_bind_t>())).exist_at as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(r_flag_bind_t),
            "::",
            stringify!(exist_at)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_flag_bind_t>())).get as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(r_flag_bind_t),
            "::",
            stringify!(get)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_flag_bind_t>())).get_at as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(r_flag_bind_t),
            "::",
            stringify!(get_at)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_flag_bind_t>())).get_list as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(r_flag_bind_t),
            "::",
            stringify!(get_list)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_flag_bind_t>())).set as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(r_flag_bind_t),
            "::",
            stringify!(set)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_flag_bind_t>())).unset as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(r_flag_bind_t),
            "::",
            stringify!(unset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_flag_bind_t>())).unset_name as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(r_flag_bind_t),
            "::",
            stringify!(unset_name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_flag_bind_t>())).unset_off as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(r_flag_bind_t),
            "::",
            stringify!(unset_off)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_flag_bind_t>())).set_fs as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(r_flag_bind_t),
            "::",
            stringify!(set_fs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_flag_bind_t>())).push_fs as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(r_flag_bind_t),
            "::",
            stringify!(push_fs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_flag_bind_t>())).pop_fs as *const _ as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(r_flag_bind_t),
            "::",
            stringify!(pop_fs)
        )
    );
}
pub type RFlagBind = r_flag_bind_t;
extern "C" {
    pub fn r_flag_bind(io: *mut RFlag, bnd: *mut RFlagBind);
}
extern "C" {
    pub fn r_flag_new() -> *mut RFlag;
}
extern "C" {
    pub fn r_flag_free(f: *mut RFlag) -> *mut RFlag;
}
extern "C" {
    pub fn r_flag_list(
        f: *mut RFlag,
        rad: ::std::os::raw::c_int,
        pfx: *const ::std::os::raw::c_char,
    );
}
extern "C" {
    pub fn r_flag_exist_at(
        f: *mut RFlag,
        flag_prefix: *const ::std::os::raw::c_char,
        fp_size: u16,
        off: u64,
    ) -> bool;
}
extern "C" {
    pub fn r_flag_get(f: *mut RFlag, name: *const ::std::os::raw::c_char) -> *mut RFlagItem;
}
extern "C" {
    pub fn r_flag_get_i(f: *mut RFlag, off: u64) -> *mut RFlagItem;
}
extern "C" {
    pub fn r_flag_get_by_spaces(f: *mut RFlag, off: u64, ...) -> *mut RFlagItem;
}
extern "C" {
    pub fn r_flag_get_at(f: *mut RFlag, off: u64, closest: bool) -> *mut RFlagItem;
}
extern "C" {
    pub fn r_flag_all_list(f: *mut RFlag, by_space: bool) -> *mut RList;
}
extern "C" {
    pub fn r_flag_get_list(f: *mut RFlag, off: u64) -> *const RList;
}
extern "C" {
    pub fn r_flag_get_liststr(f: *mut RFlag, off: u64) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_flag_unset(f: *mut RFlag, item: *mut RFlagItem) -> bool;
}
extern "C" {
    pub fn r_flag_unset_name(f: *mut RFlag, name: *const ::std::os::raw::c_char) -> bool;
}
extern "C" {
    pub fn r_flag_item_set_type(fi: *mut RFlagItem, type_: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn r_flag_unset_off(f: *mut RFlag, addr: u64) -> bool;
}
extern "C" {
    pub fn r_flag_unset_all(f: *mut RFlag);
}
extern "C" {
    pub fn r_flag_set(
        fo: *mut RFlag,
        name: *const ::std::os::raw::c_char,
        addr: u64,
        size: u32,
    ) -> *mut RFlagItem;
}
extern "C" {
    pub fn r_flag_set_inspace(
        f: *mut RFlag,
        space: *const ::std::os::raw::c_char,
        name: *const ::std::os::raw::c_char,
        off: u64,
        size: u32,
    ) -> *mut RFlagItem;
}
extern "C" {
    pub fn r_flag_set_next(
        fo: *mut RFlag,
        name: *const ::std::os::raw::c_char,
        addr: u64,
        size: u32,
    ) -> *mut RFlagItem;
}
extern "C" {
    pub fn r_flag_item_set_alias(item: *mut RFlagItem, alias: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn r_flag_item_free(item: *mut RFlagItem);
}
extern "C" {
    pub fn r_flag_item_set_comment(item: *mut RFlagItem, comment: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn r_flag_item_set_realname(item: *mut RFlagItem, realname: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn r_flag_item_set_color(
        item: *mut RFlagItem,
        color: *const ::std::os::raw::c_char,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn r_flag_item_clone(item: *mut RFlagItem) -> *mut RFlagItem;
}
extern "C" {
    pub fn r_flag_unset_glob(
        f: *mut RFlag,
        name: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_flag_rename(
        f: *mut RFlag,
        item: *mut RFlagItem,
        name: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_flag_relocate(
        f: *mut RFlag,
        off: u64,
        off_mask: u64,
        to: u64,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_flag_move(f: *mut RFlag, at: u64, to: u64) -> bool;
}
extern "C" {
    pub fn r_flag_count(
        f: *mut RFlag,
        glob: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn r_flag_foreach(f: *mut RFlag, cb: RFlagItemCb, user: *mut ::std::os::raw::c_void);
}
extern "C" {
    pub fn r_flag_foreach_prefix(
        f: *mut RFlag,
        pfx: *const ::std::os::raw::c_char,
        pfx_len: ::std::os::raw::c_int,
        cb: RFlagItemCb,
        user: *mut ::std::os::raw::c_void,
    );
}
extern "C" {
    pub fn r_flag_foreach_range(
        f: *mut RFlag,
        from: u64,
        to: u64,
        cb: RFlagItemCb,
        user: *mut ::std::os::raw::c_void,
    );
}
extern "C" {
    pub fn r_flag_foreach_glob(
        f: *mut RFlag,
        glob: *const ::std::os::raw::c_char,
        cb: RFlagItemCb,
        user: *mut ::std::os::raw::c_void,
    );
}
extern "C" {
    pub fn r_flag_foreach_space(
        f: *mut RFlag,
        space: *const RSpace,
        cb: RFlagItemCb,
        user: *mut ::std::os::raw::c_void,
    );
}
extern "C" {
    pub fn r_flag_foreach_space_glob(
        f: *mut RFlag,
        glob: *const ::std::os::raw::c_char,
        space: *const RSpace,
        cb: RFlagItemCb,
        user: *mut ::std::os::raw::c_void,
    );
}
extern "C" {
    pub fn r_flag_tags_list(f: *mut RFlag, name: *const ::std::os::raw::c_char) -> *mut RList;
}
extern "C" {
    pub fn r_flag_tags_set(
        f: *mut RFlag,
        name: *const ::std::os::raw::c_char,
        words: *const ::std::os::raw::c_char,
    ) -> *mut RList;
}
extern "C" {
    pub fn r_flag_tags_reset(f: *mut RFlag, name: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn r_flag_tags_get(f: *mut RFlag, name: *const ::std::os::raw::c_char) -> *mut RList;
}
extern "C" {
    pub fn r_flag_zone_item_free(a: *mut ::std::os::raw::c_void);
}
extern "C" {
    pub fn r_flag_zone_add(fz: *mut RFlag, name: *const ::std::os::raw::c_char, addr: u64) -> bool;
}
extern "C" {
    pub fn r_flag_zone_del(fz: *mut RFlag, name: *const ::std::os::raw::c_char) -> bool;
}
extern "C" {
    pub fn r_flag_zone_around(
        fz: *mut RFlag,
        addr: u64,
        prev: *mut *const ::std::os::raw::c_char,
        next: *mut *const ::std::os::raw::c_char,
    ) -> bool;
}
extern "C" {
    pub fn r_flag_zone_list(fz: *mut RFlag, mode: ::std::os::raw::c_int) -> bool;
}
extern "C" {
    pub fn r_flag_zone_reset(f: *mut RFlag) -> bool;
}
extern "C" {
    pub fn r_flag_zone_barlist(
        f: *mut RFlag,
        from: u64,
        bsize: u64,
        rows: ::std::os::raw::c_int,
    ) -> *mut RList;
}
extern "C" {
    pub fn r_reg_version() -> *const ::std::os::raw::c_char;
}
pub const RRegisterId_R_REG_NAME_PC: RRegisterId = 0;
pub const RRegisterId_R_REG_NAME_SP: RRegisterId = 1;
pub const RRegisterId_R_REG_NAME_SR: RRegisterId = 2;
pub const RRegisterId_R_REG_NAME_BP: RRegisterId = 3;
pub const RRegisterId_R_REG_NAME_LR: RRegisterId = 4;
pub const RRegisterId_R_REG_NAME_RS: RRegisterId = 5;
pub const RRegisterId_R_REG_NAME_A0: RRegisterId = 6;
pub const RRegisterId_R_REG_NAME_A1: RRegisterId = 7;
pub const RRegisterId_R_REG_NAME_A2: RRegisterId = 8;
pub const RRegisterId_R_REG_NAME_A3: RRegisterId = 9;
pub const RRegisterId_R_REG_NAME_A4: RRegisterId = 10;
pub const RRegisterId_R_REG_NAME_A5: RRegisterId = 11;
pub const RRegisterId_R_REG_NAME_A6: RRegisterId = 12;
pub const RRegisterId_R_REG_NAME_A7: RRegisterId = 13;
pub const RRegisterId_R_REG_NAME_A8: RRegisterId = 14;
pub const RRegisterId_R_REG_NAME_A9: RRegisterId = 15;
pub const RRegisterId_R_REG_NAME_R0: RRegisterId = 16;
pub const RRegisterId_R_REG_NAME_R1: RRegisterId = 17;
pub const RRegisterId_R_REG_NAME_R2: RRegisterId = 18;
pub const RRegisterId_R_REG_NAME_R3: RRegisterId = 19;
pub const RRegisterId_R_REG_NAME_ZF: RRegisterId = 20;
pub const RRegisterId_R_REG_NAME_SF: RRegisterId = 21;
pub const RRegisterId_R_REG_NAME_CF: RRegisterId = 22;
pub const RRegisterId_R_REG_NAME_OF: RRegisterId = 23;
pub const RRegisterId_R_REG_NAME_SN: RRegisterId = 24;
pub const RRegisterId_R_REG_NAME_LAST: RRegisterId = 25;
pub type RRegisterId = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_reg_item_t {
    pub name: *mut ::std::os::raw::c_char,
    pub type_: ::std::os::raw::c_int,
    pub size: ::std::os::raw::c_int,
    pub offset: ::std::os::raw::c_int,
    pub packed_size: ::std::os::raw::c_int,
    pub is_float: bool,
    pub flags: *mut ::std::os::raw::c_char,
    pub comment: *mut ::std::os::raw::c_char,
    pub index: ::std::os::raw::c_int,
    pub arena: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_r_reg_item_t() {
    assert_eq!(
        ::std::mem::size_of::<r_reg_item_t>(),
        56usize,
        concat!("Size of: ", stringify!(r_reg_item_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_reg_item_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_reg_item_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_reg_item_t>())).name as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_reg_item_t),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_reg_item_t>())).type_ as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_reg_item_t),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_reg_item_t>())).size as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(r_reg_item_t),
            "::",
            stringify!(size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_reg_item_t>())).offset as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(r_reg_item_t),
            "::",
            stringify!(offset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_reg_item_t>())).packed_size as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(r_reg_item_t),
            "::",
            stringify!(packed_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_reg_item_t>())).is_float as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(r_reg_item_t),
            "::",
            stringify!(is_float)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_reg_item_t>())).flags as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(r_reg_item_t),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_reg_item_t>())).comment as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(r_reg_item_t),
            "::",
            stringify!(comment)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_reg_item_t>())).index as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(r_reg_item_t),
            "::",
            stringify!(index)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_reg_item_t>())).arena as *const _ as usize },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(r_reg_item_t),
            "::",
            stringify!(arena)
        )
    );
}
pub type RRegItem = r_reg_item_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_reg_arena_t {
    pub bytes: *mut u8,
    pub size: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_r_reg_arena_t() {
    assert_eq!(
        ::std::mem::size_of::<r_reg_arena_t>(),
        16usize,
        concat!("Size of: ", stringify!(r_reg_arena_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_reg_arena_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_reg_arena_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_reg_arena_t>())).bytes as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_reg_arena_t),
            "::",
            stringify!(bytes)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_reg_arena_t>())).size as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_reg_arena_t),
            "::",
            stringify!(size)
        )
    );
}
pub type RRegArena = r_reg_arena_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_reg_set_t {
    pub arena: *mut RRegArena,
    pub pool: *mut RList,
    pub regs: *mut RList,
    pub ht_regs: *mut HtPP,
    pub cur: *mut RListIter,
    pub maskregstype: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_r_reg_set_t() {
    assert_eq!(
        ::std::mem::size_of::<r_reg_set_t>(),
        48usize,
        concat!("Size of: ", stringify!(r_reg_set_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_reg_set_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_reg_set_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_reg_set_t>())).arena as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_reg_set_t),
            "::",
            stringify!(arena)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_reg_set_t>())).pool as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_reg_set_t),
            "::",
            stringify!(pool)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_reg_set_t>())).regs as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(r_reg_set_t),
            "::",
            stringify!(regs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_reg_set_t>())).ht_regs as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(r_reg_set_t),
            "::",
            stringify!(ht_regs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_reg_set_t>())).cur as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(r_reg_set_t),
            "::",
            stringify!(cur)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_reg_set_t>())).maskregstype as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(r_reg_set_t),
            "::",
            stringify!(maskregstype)
        )
    );
}
pub type RRegSet = r_reg_set_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_reg_t {
    pub profile: *mut ::std::os::raw::c_char,
    pub reg_profile_cmt: *mut ::std::os::raw::c_char,
    pub reg_profile_str: *mut ::std::os::raw::c_char,
    pub name: [*mut ::std::os::raw::c_char; 25usize],
    pub regset: [RRegSet; 8usize],
    pub allregs: *mut RList,
    pub roregs: *mut RList,
    pub iters: ::std::os::raw::c_int,
    pub arch: ::std::os::raw::c_int,
    pub bits: ::std::os::raw::c_int,
    pub size: ::std::os::raw::c_int,
    pub bits_default: ::std::os::raw::c_int,
    pub is_thumb: bool,
    pub big_endian: bool,
}
#[test]
fn bindgen_test_layout_r_reg_t() {
    assert_eq!(
        ::std::mem::size_of::<r_reg_t>(),
        648usize,
        concat!("Size of: ", stringify!(r_reg_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_reg_t>(),
        8usize,
        concat!("Alignment of ", stringify!(r_reg_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_reg_t>())).profile as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(r_reg_t),
            "::",
            stringify!(profile)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_reg_t>())).reg_profile_cmt as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(r_reg_t),
            "::",
            stringify!(reg_profile_cmt)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_reg_t>())).reg_profile_str as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(r_reg_t),
            "::",
            stringify!(reg_profile_str)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_reg_t>())).name as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(r_reg_t),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_reg_t>())).regset as *const _ as usize },
        224usize,
        concat!(
            "Offset of field: ",
            stringify!(r_reg_t),
            "::",
            stringify!(regset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_reg_t>())).allregs as *const _ as usize },
        608usize,
        concat!(
            "Offset of field: ",
            stringify!(r_reg_t),
            "::",
            stringify!(allregs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_reg_t>())).roregs as *const _ as usize },
        616usize,
        concat!(
            "Offset of field: ",
            stringify!(r_reg_t),
            "::",
            stringify!(roregs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_reg_t>())).iters as *const _ as usize },
        624usize,
        concat!(
            "Offset of field: ",
            stringify!(r_reg_t),
            "::",
            stringify!(iters)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_reg_t>())).arch as *const _ as usize },
        628usize,
        concat!(
            "Offset of field: ",
            stringify!(r_reg_t),
            "::",
            stringify!(arch)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_reg_t>())).bits as *const _ as usize },
        632usize,
        concat!(
            "Offset of field: ",
            stringify!(r_reg_t),
            "::",
            stringify!(bits)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_reg_t>())).size as *const _ as usize },
        636usize,
        concat!(
            "Offset of field: ",
            stringify!(r_reg_t),
            "::",
            stringify!(size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_reg_t>())).bits_default as *const _ as usize },
        640usize,
        concat!(
            "Offset of field: ",
            stringify!(r_reg_t),
            "::",
            stringify!(bits_default)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_reg_t>())).is_thumb as *const _ as usize },
        644usize,
        concat!(
            "Offset of field: ",
            stringify!(r_reg_t),
            "::",
            stringify!(is_thumb)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<r_reg_t>())).big_endian as *const _ as usize },
        645usize,
        concat!(
            "Offset of field: ",
            stringify!(r_reg_t),
            "::",
            stringify!(big_endian)
        )
    );
}
pub type RReg = r_reg_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct r_reg_flags_t {
    pub s: bool,
    pub z: bool,
    pub a: bool,
    pub c: bool,
    pub o: bool,
    pub p: bool,
}
#[test]
fn bindgen_test_layout_r_reg_flags_t() {
    assert_eq!(
        ::std::mem::size_of::<r_reg_flags_t>(),
        6usize,
        concat!("Size of: ", stringify!(r_reg_flags_t))
    );
    assert_eq!(
        ::std::mem::align_of::<r_reg_flags_t>(),