pub use crate::ffi::GamepadButton;

#[derive(Clone, Copy, Hash, Debug, Eq, PartialEq, Ord, PartialOrd)]
pub enum ButtonState {
    Pressed,
    Released,
}

#[derive(Clone, Copy, Hash, Debug, Eq, PartialEq, Ord, PartialOrd)]
#[non_exhaustive]
pub enum Event {
    GamepadButton {
        button: GamepadButton,
        state: ButtonState,
        player: u8,
    },
}
