pub use crate::ffi::GamepadButton;

#[derive(Clone, Copy, Hash, Debug, Eq, PartialEq, Ord, PartialOrd)]
pub enum ButtonState {
    Pressed,
    Released,
}

#[derive(Clone, Copy, Hash, Debug, Eq, PartialEq, Ord, PartialOrd)]
pub enum KeyboardState {
    Pressed,
    Released,
}

#[derive(Clone, Copy, Hash, Debug, Eq, PartialEq, Ord, PartialOrd)]
pub enum MouseState {
    ButtonPressed,
    ButtonReleased,
    Moved,
}

#[derive(Clone, Copy, Hash, Debug, Eq, PartialEq, Ord, PartialOrd)]
#[non_exhaustive]
pub enum Event {
    GamepadButton {
        button: GamepadButton,
        state: ButtonState,
        player: u8,
    },
    Keyboard {
        code: u32,
        key: char,
        state: KeyboardState,
        player: u8,
    },
    Mouse {
        state: MouseState,
        x: u16,
        y: u16,
        player: u8,
    },
}
