#[derive(Clone, Copy, Hash, Debug, Eq, PartialEq, Ord, PartialOrd)]
#[repr(u8)]
pub enum GamepadButton {
    Up = 0,
    Down,
    Left,
    Right,
    Select,
    Start,
    LeftShoulder,
    RightShoulder,
    North,
    South,
    East,
    West,
}

extern "C" {
    pub fn qwac_log(string: *const u8, length: u32);

    pub fn qwac_canvas_create() -> u32;
    pub fn qwac_canvas_resize(canvas: u32, width_px: u32, height_px: u32);
    pub fn qwac_canvas_clear(canvas: u32);
    pub fn qwac_canvas_draw_rectangle(
        canvas: u32,
        x: f64,
        y: f64,
        width: f64,
        height: f64,
        r: u8,
        g: u8,
        b: u8,
        a: u8,
    );
    pub fn qwac_canvas_draw_texture(
        canvas: u32,
        texture: u32,
        source_x: f64,
        source_y: f64,
        source_width: f64,
        source_height: f64,
        dest_x: f64,
        dest_y: f64,
        dest_width: f64,
        dest_height: f64,
    );

    pub fn qwac_canvas_delete(canvas: u32);

    pub fn qwac_audio_buffer_from_opus(data: *const u8, size: u32) -> u32;
    pub fn qwac_audio_oscillator() -> u32;
    pub fn qwac_audio_oscillator_sine(audio_node: u32);
    pub fn qwac_audio_oscillator_square(audio_node: u32);
    pub fn qwac_audio_oscillator_sawtooth(audio_node: u32);
    pub fn qwac_audio_oscillator_triangle(audio_node: u32);
    pub fn qwac_audio_source_delay(audio_node: u32, seconds: f64);
    pub fn qwac_audio_source_length(audio_node: u32, seconds: f64);
    pub fn qwac_audio_source_play(audio_node: u32);
    pub fn qwac_audio_source_stop(audio_node: u32);
    pub fn qwac_audio_gain() -> u32;
    pub fn qwac_audio_delay(max_seconds: f64) -> u32;
    pub fn qwac_audio_set_value(audio_node: u32, value: f64);
    pub fn qwac_audio_set_value_at_time(audio_node: u32, time: f64, value: f64);
    pub fn qwac_audio_linear_ramp_to_value_at_time(audio_node: u32, time: f64, value: f64);
    pub fn qwac_audio_exponential_ramp_to_value_at_time(audio_node: u32, time: f64, value: f64);
    pub fn qwac_audio_connect(source: u32, target: u32);
    pub fn qwac_audio_disconnect(source: u32, target: u32);
    pub fn qwac_audio_sink(audio_node: u32);
    pub fn qwac_audio_unsink(audio_node: u32);
    pub fn qwac_audio_delete(audio_node: u32);

    pub fn qwac_texture_from_canvas(canvas: u32) -> u32;
    pub fn qwac_texture_from_rgba(data: *const u8, width: u32, height: u32) -> u32;
    pub fn qwac_texture_from_png(data: *const u8, size: u32) -> u32;
    pub fn qwac_texture_from_webp(data: *const u8, size: u32) -> u32;
    pub fn qwac_texture_delete(texture: u32);

    pub fn qwac_data_save(data: *const u8, size: u32);
    pub fn qwac_data_load(data: *mut u8, size: u32) -> u32;
}
