#[derive(Clone, Copy, Hash, Debug, Eq, PartialEq, Ord, PartialOrd)]
#[repr(u8)]
pub enum GamepadButton {
    Up = 0,
    Down,
    Left,
    Right,
    Select,
    Start,
    LeftShoulder,
    RightShoulder,
    North,
    South,
    East,
    West,
}

extern "C" {
    pub fn qwac_log(string: *const u8, length: u32);
    pub fn qwac_display(width_px: u16, height_px: u16);
    pub fn qwac_clear_color(r: u8, g: u8, b: u8);
    pub fn qwac_clear();
    pub fn qwac_fill_rectangle(x: u16, y: u16, width: u16, height: u16, r: u8, g: u8, b: u8, a: u8);

    pub fn qwac_audio_oscillator() -> u32;
    pub fn qwac_audio_oscillator_sine(audio_node: u32);
    pub fn qwac_audio_oscillator_square(audio_node: u32);
    pub fn qwac_audio_oscillator_sawtooth(audio_node: u32);
    pub fn qwac_audio_oscillator_triangle(audio_node: u32);
    pub fn qwac_audio_oscillator_delay(audio_node: u32, seconds: f64);
    pub fn qwac_audio_oscillator_length(audio_node: u32, seconds: f64);
    pub fn qwac_audio_source_play(audio_node: u32);
    pub fn qwac_audio_source_stop(audio_node: u32);
    pub fn qwac_audio_gain() -> u32;
    pub fn qwac_audio_delay(max_seconds: f64) -> u32;
    pub fn qwac_audio_set_value(audio_node: u32, value: f64);
    pub fn qwac_audio_set_value_at_time(audio_node: u32, time: f64, value: f64);
    pub fn qwac_audio_linear_ramp_to_value_at_time(audio_node: u32, time: f64, value: f64);
    pub fn qwac_audio_exponential_ramp_to_value_at_time(audio_node: u32, time: f64, value: f64);
    pub fn qwac_audio_connect(source: u32, target: u32);
    pub fn qwac_audio_disconnect(source: u32, target: u32);
    pub fn qwac_audio_sink(audio_node: u32);
    pub fn qwac_audio_unsink(audio_node: u32);
    pub fn qwac_audio_delete(audio_node: u32);

    pub fn qwac_texture_rgba(data: *const u8, width: u16, height: u16) -> u32;
    pub fn qwac_texture_png(data: *const u8, size: u32) -> u32;
    pub fn qwac_texture_webp(data: *const u8, size: u32) -> u32;
    pub fn qwac_texture_free(texture: u32);
    pub fn qwac_texture_draw(
        texture: u32,
        source_x: u16,
        source_y: u16,
        source_width: u16,
        source_height: u16,
        dest_x: u16,
        dest_y: u16,
        dest_width: u16,
        dest_height: u16,
    );
    pub fn qwac_data_save(data: *const u8, size: u32);
    pub fn qwac_data_load(data: *mut u8, size: u32) -> u32;
}
