#[repr(u8)]
pub enum EventType {
    GamepadButtonPress = 0,
    GamepadButtonRelease,
    KeyPress,
    KeyRelease,
    MouseButtonPress,
    MouseButtonRelease,
}

extern "C" {
    pub fn wag_log(string: *const u8, length: u32);
    pub fn wag_display(width_px: u16, height_px: u16);
    pub fn wag_clear_color(r: u8, g: u8, b: u8);
    pub fn wag_clear();
    pub fn wag_fill_rectangle(x: u16, y: u16, width: u16, height: u16, r: u8, g: u8, b: u8, a: u8);
    pub fn wag_texture_rgba(data: *const u8, width: u16, height: u16) -> u32;
    pub fn wag_texture_png(data: *const u8, size: u32) -> u32;
    pub fn wag_texture_webp(data: *const u8, size: u32) -> u32;
    pub fn wag_texture_free(texture: u32);
    pub fn wag_texture_draw(
        texture: u32,
        source_x: u16,
        source_y: u16,
        source_width: u16,
        source_height: u16,
        dest_x: u16,
        dest_y: u16,
        dest_width: u16,
        dest_height: u16,
    );
    pub fn wag_data_store(data: *const u8, size: u32);
    pub fn wag_data_load(data: *mut u8, size: u32) -> u32;
}
