#[derive(Clone, Copy, Hash, Debug, Eq, PartialEq, Ord, PartialOrd)]
pub enum ButtonState {
    Pressed,
    Released,
}

#[derive(Clone, Copy, Hash, Debug, Eq, PartialEq, Ord, PartialOrd)]
pub enum KeyboardState {
    Pressed,
    Released,
}

#[derive(Clone, Copy, Hash, Debug, Eq, PartialEq, Ord, PartialOrd)]
pub enum MouseState {
    ButtonPressed,
    ButtonReleased,
    Moved,
}

#[derive(Clone, Copy, Hash, Debug, Eq, PartialEq, Ord, PartialOrd)]
pub enum GamepadButton {
    Up,
    Down,
    Left,
    Right,
    Select,
    Start,
    LeftShoulder,
    RightShoulder,
    North,
    South,
    East,
    West,
}

impl GamepadButton {
    pub fn from_code(button: u8) -> Option<Self> {
        match button {
            0 => Some(GamepadButton::Up),
            1 => Some(GamepadButton::Down),
            2 => Some(GamepadButton::Left),
            3 => Some(GamepadButton::Right),
            4 => Some(GamepadButton::Select),
            5 => Some(GamepadButton::Start),
            6 => Some(GamepadButton::LeftShoulder),
            7 => Some(GamepadButton::RightShoulder),
            8 => Some(GamepadButton::North),
            9 => Some(GamepadButton::South),
            10 => Some(GamepadButton::East),
            11 => Some(GamepadButton::West),
            _ => None,
        }
    }
}

#[derive(Clone, Copy, Hash, Debug, Eq, PartialEq, Ord, PartialOrd)]
#[non_exhaustive]
pub enum Event {
    GamepadButton {
        button: GamepadButton,
        state: ButtonState,
        player: u8,
    },
    Keyboard {
        key: GamepadButton,
        state: KeyboardState,
        player: u8,
    },
    Mouse {
        state: MouseState,
        x: u16,
        y: u16,
    },
}
