use {
    std::mem::MaybeUninit,
    rayon::*,
};

const DEFAULT_NUM_THREADS: usize = 1;
static mut GLOBAL_POOL: (usize, MaybeUninit<ThreadPool>) =
    (0, MaybeUninit::uninit());

pub fn num_threads(num_threads: usize) {
    unsafe {
        if GLOBAL_POOL.0 != num_threads {
            GLOBAL_POOL.0 = num_threads;
            GLOBAL_POOL.1 = MaybeUninit::new(ThreadPoolBuilder::new()
                .num_threads(num_threads)
                .build().unwrap());
        }
    }
}

pub(crate) fn global_install<OP: FnOnce() -> R + Send, R: Send>(op: OP) -> R {
    unsafe {
        if GLOBAL_POOL.0 == 0 {
            num_threads(DEFAULT_NUM_THREADS);
        }
        &*GLOBAL_POOL.1.as_ptr()
    }.install(op)
}