pub use std::f64::consts::*;

pub use self::{consts::*, types::*};

pub mod approx_cmp;
pub mod bits_iter;
pub mod matrix;

mod consts {
    use super::types::*;

    pub const C_ONE: C = C { re: 1., im: 0. };
    pub const C_ZERO: C = C { re: 0., im: 0. };
    pub const C_IMAG: C = C { re: 0., im: 1. };

    pub const I_POW_TABLE: [C; 4] = [
        C { re: 1., im: 0. },
        C { re: 0., im: 1. },
        C { re: -1., im: 0. },
        C { re: 0., im: -1. },
    ];

    /*pub const ANGLE_TABLE: [C; 46] = [
        C{ re: 1.0000000000000000, im: 0.00000000000000000 },
        C{ re: 0.9998476951563913, im: 0.01745240643728351 },
        C{ re: 0.9993908270190958, im: 0.03489949670250097 },
        C{ re: 0.9986295347545738, im: 0.05233595624294383 },
        C{ re: 0.9975640502598242, im: 0.06975647374412530 },
        C{ re: 0.9961946980917455, im: 0.08715574274765817 },
        C{ re: 0.9945218953682733, im: 0.10452846326765346 },
        C{ re: 0.9925461516413220, im: 0.12186934340514748 },
        C{ re: 0.9902680687415704, im: 0.13917310096006544 },
        C{ re: 0.9876883405951378, im: 0.15643446504023087 },
        C{ re: 0.9848077530122080, im: 0.17364817766693033 },
        C{ re: 0.9816271834476640, im: 0.19080899537654480 },
        C{ re: 0.9781476007338057, im: 0.20791169081775931 },
        C{ re: 0.9743700647852352, im: 0.22495105434386500 },
        C{ re: 0.9702957262759965, im: 0.24192189559966773 },
        C{ re: 0.9659258262890683, im: 0.25881904510252074 },
        C{ re: 0.9612616959383189, im: 0.27563735581699916 },
        C{ re: 0.9563047559630354, im: 0.29237170472273677 },
        C{ re: 0.9510565162951535, im: 0.30901699437494740 },
        C{ re: 0.9455185755993168, im: 0.32556815445715664 },
        C{ re: 0.9396926207859084, im: 0.34202014332566870 },
        C{ re: 0.9335804264972017, im: 0.35836794954530027 },
        C{ re: 0.9271838545667874, im: 0.37460659341591200 },
        C{ re: 0.9205048534524404, im: 0.39073112848927370 },
        C{ re: 0.9135454576426009, im: 0.40673664307580015 },
        C{ re: 0.9063077870366499, im: 0.42261826174069944 },
        C{ re: 0.8987940462991670, im: 0.43837114678907740 },
        C{ re: 0.8910065241883679, im: 0.45399049973954675 },
        C{ re: 0.8829475928589270, im: 0.46947156278589080 },
        C{ re: 0.8746197071393957, im: 0.48480962024633706 },
        C{ re: 0.8660254037844387, im: 0.49999999999999994 },
        C{ re: 0.8571673007021123, im: 0.51503807491005420 },
        C{ re: 0.8480480961564260, im: 0.52991926423320490 },
        C{ re: 0.8386705679454240, im: 0.54463903501502710 },
        C{ re: 0.8290375725550417, im: 0.55919290347074690 },
        C{ re: 0.8191520442889918, im: 0.57357643635104600 },
        C{ re: 0.8090169943749475, im: 0.58778525229247310 },
        C{ re: 0.7986355100472928, im: 0.60181502315204830 },
        C{ re: 0.7880107536067220, im: 0.61566147532565820 },
        C{ re: 0.7771459614569709, im: 0.62932039104983740 },
        C{ re: 0.7660444431189780, im: 0.64278760968653930 },
        C{ re: 0.7547095802227720, im: 0.65605902899050720 },
        C{ re: 0.7431448254773942, im: 0.66913060635885820 },
        C{ re: 0.7313537016191706, im: 0.68199836006249850 },
        C{ re: 0.7193398003386512, im: 0.69465837045899730 },
        C{ re: 0.7071067811865476, im: 0.70710678118654760 },
    ];*/
}

mod types {
    pub type N = usize;
    pub type Z = isize;

    pub type R = f64;
    pub type C = num_complex::Complex<R>;

    pub type M1 = [C; 4];
    pub type M2 = [C; 16];
}

#[inline]
pub fn count_bits(n: N) -> N {
    n.count_ones() as N
}

#[inline]
pub fn rotate(mut z: C, q: N) -> C {
    if q & 0b10 != 0 {
        z = -z;
    }
    if q & 0b01 != 0 {
        z.im = -z.im;
        std::mem::swap(&mut z.re, &mut z.im);
    }
    z
}

#[inline]
pub fn phase_from_rad(rad: R) -> C {
    /*
    let deg = (rad.to_degrees().round() as Z).mod_floor(&360) as N;
    let (quat, deg) = deg.div_mod_floor(&90);

    I_POW_TABLE[quat] *
        if deg > 45 {
            let c = ANGLE_TABLE[90 - deg];
            C { re: c.im, im: c.re }
        } else {
            ANGLE_TABLE[deg]
        }
     */
    C::from_polar(1.0, rad)
}