/// Modelled after std::option::Option
/// See: https://doc.rust-lang.org/std/option/enum.Option.html#variant.None
pub enum Quizas<T> {
    Nada,
    Algo(T),
}

use Quizas::{Algo, Nada};

impl<T> Quizas<T> {
    pub fn unwrap(self) -> T {
        match self {
            Algo(t) => t,
            Nada => panic!("called `Quizas::unwrap()` on a `Nada` value"),
        }
    }
    pub fn is_none(&self) -> bool {
        match self {
            Nada => true,
            _ => false,
        }
    }
    pub fn is_some(&self) -> bool {
        !self.is_none()
    }
    pub fn as_ref(&self) -> Quizas<&T> {
        match *self {
            Algo(ref x) => Algo(x),
            Nada => Nada,
        }
    }
}

#[cfg(test)]
mod tests {
    use super::*;

    #[test]
    fn it_works() {
        let result = 2 + 2;
        assert_eq!(result, 4);
    }

    #[test]
    fn it_just_works(){
        let _ = Algo(Algo(Algo(0)));
    }

    #[test]
    fn nada_works() {
        let _nada: Quizas<u8> = Nada;
    }

    #[test]
    fn algo_works() {
        let _algo: Quizas<u8> = Algo(42);
    }
}
