<p  align="center">
    <img src="./docs/logos/logo-white.png" alt="Quilkin logo" height="220">
</p>

[![GitHub](https://img.shields.io/github/license/googleforgames/quilkin)](./LICENSE)
[![Crates.io](https://img.shields.io/crates/v/quilkin)](https://crates.io/crates/quilkin)
[![Docs.rs](https://docs.rs/quilkin/badge.svg)](https://docs.rs/quilkin)
[![GitHub release (latest SemVer)](https://img.shields.io/github/v/release/googleforgames/quilkin)](https://github.com/googleforgames/quilkin/releases)
[![Discord](https://img.shields.io/discord/773975408265134100)](https://discord.gg/mfBNZjBDnc)
[![Twitter Follow](https://img.shields.io/twitter/follow/quilkindev?style=social)](https://twitter.com/quilkindev)

Quilkin is a non-transparent UDP proxy specifically designed for use with large scale multiplayer dedicated game servers
deployments, to ensure security, access control, telemetry data, metrics and more.
 
It is designed to be used behind game clients as well as in front of dedicated game servers.

## Announcements

* [Embark Studios: Say hi to Quilkin, an open-source UDP proxy](https://medium.com/embarkstudios/say-hi-to-quilkin-an-open-source-udp-proxy-88577c795204)
* [Google Cloud: Introducing Quilkin: open-source UDP proxies built for game server communication](https://cloud.google.com/blog/products/gaming/introducing-quilkin)

## Project State

Project is currently in *alpha* status, and is being actively developed. Expect things to break.

Not to be used in production systems.

## Documentation

### Releases

* v0.2.0 ([guides](https://googleforgames.github.io/quilkin/v0.2.0/book/), 
  [api](https://googleforgames.github.io/quilkin/v0.2.0/api/quilkin/), 
  [macros](https://googleforgames.github.io/quilkin/v0.2.0/api/quilkin_macros/))
* v0.1.0 ([guides](https://github.com/googleforgames/quilkin/blob/v0.1.0/README.md#usage), 
  [api](https://docs.rs/quilkin/0.1.0/quilkin/), [macros](https://docs.rs/quilkin-macros/0.1.0/quilkin_macros/)).

### Development

> This documentation is for the development version of Quilkin, currently active on the `main` branch. To view the 
> documentation for a specific release, click on the appropriate release documentation link above.

* [Guide](https://googleforgames.github.io/quilkin/main/book/)
* [Api](https://googleforgames.github.io/quilkin/main/api/quilkin/)
* [Macros](https://googleforgames.github.io/quilkin/main/api/quilkin_macros/)

## Code of Conduct

Participation in this project comes under the [Contributor Covenant Code of Conduct](code-of-conduct.md)

## Development and Contribution

Please read the [contributing](CONTRIBUTING.md) guide for directions on writing code and submitting Pull Requests.

Quilkin is in active development - we would love your help in shaping its future!

## Community

There are lots of ways to engage with the Quilkin community:

* Here on [Github](https://github.com/googleforgames/quilkin) via 
  [issues](https://github.com/googleforgames/quilkin/issues) and 
  [pull requests](https://github.com/googleforgames/quilkin/pulls).
* Join our [mailing list](https://groups.google.com/forum/#!forum/quilkin-discuss), which also gives you access to
  our continuous integration builds.
* Join our [Discord chat server](https://discord.gg/mfBNZjBDnc).
* Follow up on [Twitter](https://twitter.com/quilkindev).
* Join our monthly community meetings ([webcal](https://calendar.google.com/calendar/embed?src=c_9mgnkieltlphoijg5uio0g6a14%40group.calendar.google.com&ctz=America%2FLos_Angeles),
  [ical](https://calendar.google.com/calendar/ical/c_9mgnkieltlphoijg5uio0g6a14%40group.calendar.google.com/public/basic.ics),
  [recordings](https://www.youtube.com/playlist?list=PLhkWKwFGACw1oG-qbKQZBlAKAfuG_XpTd)).

## Credits

Many concepts and architectural decisions were inspired by [Envoy Proxy](https://www.envoyproxy.io/). 
Huge thanks to that team for the inspiration they provided with all their hard work. 

## Companies using Quilkin

[<img src="./image/embark.png" alt="Embark Studios" height="100">](https://www.embark-studios.com/)

## Licence

Apache 2.0

<img src="./docs/logos/mascot.png" alt="Quilly, the Quilkin mascot" height="200" align="right">
