# ⛑ Quick Test - Command Line Interface (CLI) for stress testing in competitive programming contest



[![Current Crates.io Version](https://img.shields.io/crates/v/quicktest.svg)](https://crates.io/crates/quicktest) [![](https://docs.rs/quicktest/badge.svg)](https://docs.rs/crate/quicktest)

```
quicktest 0.0.1-beta.0
CLI for stress testing in competitive programming contest

USAGE:
    quicktest <SUBCOMMAND>

FLAGS:
    -h, --help       Prints help information
    -V, --version    Prints version information

SUBCOMMANDS:
    compare    Compare correctness with a slower program
    help       Prints this message or the help of the given subcommand(s)
    tle        Check TLE

```

### TLE Subcommand

```
quicktest tle
Check that <target-file> does not have the TLE status using random test cases generated by <gen-file>

USAGE:
    $ quicktest tle --target-file "code/main.cpp" --gen-file "code/gen.cpp" --timeout=1000 --test-cases=100
FLAGS:
    -h, --help          Prints help information
    -s, --save-cases    Save test cases
    -b, --tle-break     TLE Break
    -V, --version       Prints version information

OPTIONS:
    -g, --gen-file <gen-file>          Generator File
    -t, --target-file <target-file>    Target File
    -n, --test-cases <test-cases>      Number of test cases [default: 10000]
    -o, --timeout <timeout>            Timeout TLE [default: 2000]
```

## Supported Languages

* C++17

# License
Licensed under either of these:
* MIT license ([LICENSE-MIT](https://github.com/LuisMBaezCo/quicktest/blob/main/LICENSE) or https://opensource.org/licenses/MIT)