#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 13
#define STATE_COUNT 58
#define LARGE_STATE_COUNT 2
#define SYMBOL_COUNT 60
#define ALIAS_COUNT 0
#define TOKEN_COUNT 39
#define EXTERNAL_TOKEN_COUNT 0
#define FIELD_COUNT 11
#define MAX_ALIAS_SEQUENCE_LENGTH 7
#define PRODUCTION_ID_COUNT 15

enum {
  anon_sym_LT = 1,
  anon_sym_GT = 2,
  anon_sym_BANG_EQ = 3,
  anon_sym_LT_GT = 4,
  anon_sym_BANG_EQ_EQ = 5,
  anon_sym_EQ_EQ = 6,
  anon_sym_EQ = 7,
  anon_sym_EQ_EQ_EQ = 8,
  sym_print = 9,
  sym_set = 10,
  sym_startfunction = 11,
  sym_endfunction = 12,
  sym_callfunction = 13,
  sym_long = 14,
  sym_endian = 15,
  sym_little = 16,
  sym_intel = 17,
  sym_big = 18,
  sym_network = 19,
  sym_swap = 20,
  sym_change = 21,
  sym_invert = 22,
  sym_guess = 23,
  sym_guess16 = 24,
  sym_guess64 = 25,
  sym_guess24 = 26,
  sym_save = 27,
  sym_store = 28,
  sym_idstring = 29,
  sym_if = 30,
  sym_elif = 31,
  sym_else = 32,
  sym_endif = 33,
  sym_identifier = 34,
  sym_integer_literal = 35,
  anon_sym_DQUOTE = 36,
  aux_sym_string_literal_token1 = 37,
  sym_comment = 38,
  sym_source_file = 39,
  sym__top_statement = 40,
  sym_function_declaration = 41,
  sym__statement = 42,
  sym_set_statement = 43,
  sym_print_statement = 44,
  sym_function_call_statement = 45,
  sym_endian_statement = 46,
  sym_idstring_statement = 47,
  sym_if_statement = 48,
  sym_elif_statement = 49,
  sym_else_statement = 50,
  sym_comparison = 51,
  sym_type = 52,
  sym__endian_type = 53,
  sym__expression = 54,
  sym_string_literal = 55,
  aux_sym_source_file_repeat1 = 56,
  aux_sym_function_declaration_repeat1 = 57,
  aux_sym_if_statement_repeat1 = 58,
  aux_sym_string_literal_repeat1 = 59,
};

static const char *ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [anon_sym_LT] = "<",
  [anon_sym_GT] = ">",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_LT_GT] = "<>",
  [anon_sym_BANG_EQ_EQ] = "!==",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_EQ] = "=",
  [anon_sym_EQ_EQ_EQ] = "===",
  [sym_print] = "print",
  [sym_set] = "set",
  [sym_startfunction] = "startfunction",
  [sym_endfunction] = "endfunction",
  [sym_callfunction] = "callfunction",
  [sym_long] = "long",
  [sym_endian] = "endian",
  [sym_little] = "little",
  [sym_intel] = "intel",
  [sym_big] = "big",
  [sym_network] = "network",
  [sym_swap] = "swap",
  [sym_change] = "change",
  [sym_invert] = "invert",
  [sym_guess] = "guess",
  [sym_guess16] = "guess16",
  [sym_guess64] = "guess64",
  [sym_guess24] = "guess24",
  [sym_save] = "save",
  [sym_store] = "store",
  [sym_idstring] = "idstring",
  [sym_if] = "if",
  [sym_elif] = "elif",
  [sym_else] = "else",
  [sym_endif] = "endif",
  [sym_identifier] = "identifier",
  [sym_integer_literal] = "integer_literal",
  [anon_sym_DQUOTE] = "\"",
  [aux_sym_string_literal_token1] = "string_literal_token1",
  [sym_comment] = "comment",
  [sym_source_file] = "source_file",
  [sym__top_statement] = "_top_statement",
  [sym_function_declaration] = "function_declaration",
  [sym__statement] = "_statement",
  [sym_set_statement] = "set_statement",
  [sym_print_statement] = "print_statement",
  [sym_function_call_statement] = "function_call_statement",
  [sym_endian_statement] = "endian_statement",
  [sym_idstring_statement] = "idstring_statement",
  [sym_if_statement] = "if_statement",
  [sym_elif_statement] = "elif_statement",
  [sym_else_statement] = "else_statement",
  [sym_comparison] = "comparison",
  [sym_type] = "type",
  [sym__endian_type] = "_endian_type",
  [sym__expression] = "_expression",
  [sym_string_literal] = "string_literal",
  [aux_sym_source_file_repeat1] = "source_file_repeat1",
  [aux_sym_function_declaration_repeat1] = "function_declaration_repeat1",
  [aux_sym_if_statement_repeat1] = "if_statement_repeat1",
  [aux_sym_string_literal_repeat1] = "string_literal_repeat1",
};

static TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_LT_GT] = anon_sym_LT_GT,
  [anon_sym_BANG_EQ_EQ] = anon_sym_BANG_EQ_EQ,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_EQ_EQ_EQ] = anon_sym_EQ_EQ_EQ,
  [sym_print] = sym_print,
  [sym_set] = sym_set,
  [sym_startfunction] = sym_startfunction,
  [sym_endfunction] = sym_endfunction,
  [sym_callfunction] = sym_callfunction,
  [sym_long] = sym_long,
  [sym_endian] = sym_endian,
  [sym_little] = sym_little,
  [sym_intel] = sym_intel,
  [sym_big] = sym_big,
  [sym_network] = sym_network,
  [sym_swap] = sym_swap,
  [sym_change] = sym_change,
  [sym_invert] = sym_invert,
  [sym_guess] = sym_guess,
  [sym_guess16] = sym_guess16,
  [sym_guess64] = sym_guess64,
  [sym_guess24] = sym_guess24,
  [sym_save] = sym_save,
  [sym_store] = sym_store,
  [sym_idstring] = sym_idstring,
  [sym_if] = sym_if,
  [sym_elif] = sym_elif,
  [sym_else] = sym_else,
  [sym_endif] = sym_endif,
  [sym_identifier] = sym_identifier,
  [sym_integer_literal] = sym_integer_literal,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [aux_sym_string_literal_token1] = aux_sym_string_literal_token1,
  [sym_comment] = sym_comment,
  [sym_source_file] = sym_source_file,
  [sym__top_statement] = sym__top_statement,
  [sym_function_declaration] = sym_function_declaration,
  [sym__statement] = sym__statement,
  [sym_set_statement] = sym_set_statement,
  [sym_print_statement] = sym_print_statement,
  [sym_function_call_statement] = sym_function_call_statement,
  [sym_endian_statement] = sym_endian_statement,
  [sym_idstring_statement] = sym_idstring_statement,
  [sym_if_statement] = sym_if_statement,
  [sym_elif_statement] = sym_elif_statement,
  [sym_else_statement] = sym_else_statement,
  [sym_comparison] = sym_comparison,
  [sym_type] = sym_type,
  [sym__endian_type] = sym__endian_type,
  [sym__expression] = sym__expression,
  [sym_string_literal] = sym_string_literal,
  [aux_sym_source_file_repeat1] = aux_sym_source_file_repeat1,
  [aux_sym_function_declaration_repeat1] = aux_sym_function_declaration_repeat1,
  [aux_sym_if_statement_repeat1] = aux_sym_if_statement_repeat1,
  [aux_sym_string_literal_repeat1] = aux_sym_string_literal_repeat1,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [sym_print] = {
    .visible = true,
    .named = true,
  },
  [sym_set] = {
    .visible = true,
    .named = true,
  },
  [sym_startfunction] = {
    .visible = true,
    .named = true,
  },
  [sym_endfunction] = {
    .visible = true,
    .named = true,
  },
  [sym_callfunction] = {
    .visible = true,
    .named = true,
  },
  [sym_long] = {
    .visible = true,
    .named = true,
  },
  [sym_endian] = {
    .visible = true,
    .named = true,
  },
  [sym_little] = {
    .visible = true,
    .named = true,
  },
  [sym_intel] = {
    .visible = true,
    .named = true,
  },
  [sym_big] = {
    .visible = true,
    .named = true,
  },
  [sym_network] = {
    .visible = true,
    .named = true,
  },
  [sym_swap] = {
    .visible = true,
    .named = true,
  },
  [sym_change] = {
    .visible = true,
    .named = true,
  },
  [sym_invert] = {
    .visible = true,
    .named = true,
  },
  [sym_guess] = {
    .visible = true,
    .named = true,
  },
  [sym_guess16] = {
    .visible = true,
    .named = true,
  },
  [sym_guess64] = {
    .visible = true,
    .named = true,
  },
  [sym_guess24] = {
    .visible = true,
    .named = true,
  },
  [sym_save] = {
    .visible = true,
    .named = true,
  },
  [sym_store] = {
    .visible = true,
    .named = true,
  },
  [sym_idstring] = {
    .visible = true,
    .named = true,
  },
  [sym_if] = {
    .visible = true,
    .named = true,
  },
  [sym_elif] = {
    .visible = true,
    .named = true,
  },
  [sym_else] = {
    .visible = true,
    .named = true,
  },
  [sym_endif] = {
    .visible = true,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_integer_literal] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_string_literal_token1] = {
    .visible = false,
    .named = false,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_source_file] = {
    .visible = true,
    .named = true,
  },
  [sym__top_statement] = {
    .visible = false,
    .named = true,
  },
  [sym_function_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym__statement] = {
    .visible = false,
    .named = true,
  },
  [sym_set_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_print_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_function_call_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_endian_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_idstring_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_if_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_elif_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_else_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_comparison] = {
    .visible = true,
    .named = true,
  },
  [sym_type] = {
    .visible = true,
    .named = true,
  },
  [sym__endian_type] = {
    .visible = false,
    .named = true,
  },
  [sym__expression] = {
    .visible = false,
    .named = true,
  },
  [sym_string_literal] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_source_file_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_function_declaration_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_if_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_literal_repeat1] = {
    .visible = false,
    .named = false,
  },
};

enum {
  field_body = 1,
  field_comparison = 2,
  field_else_clauses = 3,
  field_filenum = 4,
  field_left_expression = 5,
  field_magic = 6,
  field_name = 7,
  field_right_expression = 8,
  field_type = 9,
  field_value = 10,
  field_variable = 11,
};

static const char *ts_field_names[] = {
  [0] = NULL,
  [field_body] = "body",
  [field_comparison] = "comparison",
  [field_else_clauses] = "else_clauses",
  [field_filenum] = "filenum",
  [field_left_expression] = "left_expression",
  [field_magic] = "magic",
  [field_name] = "name",
  [field_right_expression] = "right_expression",
  [field_type] = "type",
  [field_value] = "value",
  [field_variable] = "variable",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [1] = {.index = 0, .length = 1},
  [2] = {.index = 1, .length = 1},
  [3] = {.index = 2, .length = 1},
  [4] = {.index = 3, .length = 1},
  [5] = {.index = 4, .length = 2},
  [6] = {.index = 6, .length = 2},
  [7] = {.index = 8, .length = 2},
  [8] = {.index = 10, .length = 3},
  [9] = {.index = 13, .length = 2},
  [10] = {.index = 15, .length = 3},
  [11] = {.index = 18, .length = 1},
  [12] = {.index = 19, .length = 4},
  [13] = {.index = 23, .length = 4},
  [14] = {.index = 27, .length = 5},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_value, 1},
  [1] =
    {field_name, 1},
  [2] =
    {field_type, 1},
  [3] =
    {field_magic, 1},
  [4] =
    {field_value, 2},
    {field_variable, 1},
  [6] =
    {field_type, 1},
    {field_value, 2},
  [8] =
    {field_filenum, 1},
    {field_magic, 2},
  [10] =
    {field_type, 2},
    {field_value, 3},
    {field_variable, 1},
  [13] =
    {field_body, 2},
    {field_name, 1},
  [15] =
    {field_comparison, 2},
    {field_left_expression, 1},
    {field_right_expression, 3},
  [18] =
    {field_body, 1},
  [19] =
    {field_body, 4},
    {field_comparison, 2},
    {field_left_expression, 1},
    {field_right_expression, 3},
  [23] =
    {field_comparison, 2},
    {field_else_clauses, 4},
    {field_left_expression, 1},
    {field_right_expression, 3},
  [27] =
    {field_body, 4},
    {field_comparison, 2},
    {field_else_clauses, 5},
    {field_left_expression, 1},
    {field_right_expression, 3},
};

static TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
};

static uint16_t ts_non_terminal_alias_map[] = {
  0,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(121);
      if (lookahead == '!') ADVANCE(26);
      if (lookahead == '"') ADVANCE(237);
      if (lookahead == '#') ADVANCE(244);
      if (lookahead == '/') ADVANCE(20);
      if (lookahead == '0') ADVANCE(232);
      if (lookahead == '<') ADVANCE(122);
      if (lookahead == '=') ADVANCE(128);
      if (lookahead == '>') ADVANCE(123);
      if (lookahead == '\\') SKIP(117)
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(233);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(234);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(108);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(36);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(57);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(44);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(87);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(27);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(0)
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(236);
      END_STATE();
    case 1:
      if (lookahead == '\n') SKIP(19)
      END_STATE();
    case 2:
      if (lookahead == '\n') SKIP(19)
      if (lookahead == '\r') SKIP(1)
      END_STATE();
    case 3:
      if (lookahead == '\n') SKIP(14)
      END_STATE();
    case 4:
      if (lookahead == '\n') SKIP(14)
      if (lookahead == '\r') SKIP(3)
      END_STATE();
    case 5:
      if (lookahead == '\n') SKIP(16)
      END_STATE();
    case 6:
      if (lookahead == '\n') SKIP(16)
      if (lookahead == '\r') SKIP(5)
      END_STATE();
    case 7:
      if (lookahead == '\n') SKIP(17)
      END_STATE();
    case 8:
      if (lookahead == '\n') SKIP(17)
      if (lookahead == '\r') SKIP(7)
      END_STATE();
    case 9:
      if (lookahead == '\n') SKIP(18)
      END_STATE();
    case 10:
      if (lookahead == '\n') SKIP(18)
      if (lookahead == '\r') SKIP(9)
      END_STATE();
    case 11:
      if (lookahead == '\n') SKIP(18)
      if (lookahead == '"') ADVANCE(237);
      if (lookahead == '#') ADVANCE(242);
      if (lookahead == '/') ADVANCE(239);
      if (lookahead == '\\') SKIP(10)
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(238);
      if (lookahead != 0) ADVANCE(242);
      END_STATE();
    case 12:
      if (lookahead == '\n') SKIP(15)
      END_STATE();
    case 13:
      if (lookahead == '\n') SKIP(15)
      if (lookahead == '\r') SKIP(12)
      END_STATE();
    case 14:
      if (lookahead == '"') ADVANCE(237);
      if (lookahead == '#') ADVANCE(244);
      if (lookahead == '/') ADVANCE(20);
      if (lookahead == '0') ADVANCE(232);
      if (lookahead == '\\') SKIP(4)
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(167);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(168);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(179);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(215);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(184);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(14)
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(172);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(236);
      if (('G' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('g' <= lookahead && lookahead <= 'z')) ADVANCE(229);
      END_STATE();
    case 15:
      if (lookahead == '"') ADVANCE(237);
      if (lookahead == '#') ADVANCE(244);
      if (lookahead == '/') ADVANCE(20);
      if (lookahead == '0') ADVANCE(232);
      if (lookahead == '\\') SKIP(13)
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(167);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(170);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(179);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(215);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(184);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(15)
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(172);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(236);
      if (('G' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('g' <= lookahead && lookahead <= 'z')) ADVANCE(229);
      END_STATE();
    case 16:
      if (lookahead == '"') ADVANCE(237);
      if (lookahead == '#') ADVANCE(244);
      if (lookahead == '/') ADVANCE(20);
      if (lookahead == '0') ADVANCE(232);
      if (lookahead == '\\') SKIP(6)
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(214);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(16)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(236);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(172);
      if (('G' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('g' <= lookahead && lookahead <= 'z')) ADVANCE(229);
      END_STATE();
    case 17:
      if (lookahead == '"') ADVANCE(237);
      if (lookahead == '#') ADVANCE(244);
      if (lookahead == '/') ADVANCE(20);
      if (lookahead == '0') ADVANCE(232);
      if (lookahead == '\\') SKIP(8)
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(17)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(236);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(172);
      if (('G' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('g' <= lookahead && lookahead <= 'z')) ADVANCE(229);
      END_STATE();
    case 18:
      if (lookahead == '"') ADVANCE(237);
      if (lookahead == '#') ADVANCE(244);
      if (lookahead == '/') ADVANCE(20);
      if (lookahead == '\\') SKIP(10)
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(18)
      END_STATE();
    case 19:
      if (lookahead == '#') ADVANCE(244);
      if (lookahead == '/') ADVANCE(20);
      if (lookahead == '\\') SKIP(2)
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(61);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(55);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(108);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(69);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(56);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(44);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(28);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(19)
      END_STATE();
    case 20:
      if (lookahead == '*') ADVANCE(22);
      if (lookahead == '/') ADVANCE(244);
      END_STATE();
    case 21:
      if (lookahead == '*') ADVANCE(21);
      if (lookahead == '/') ADVANCE(243);
      if (lookahead != 0) ADVANCE(22);
      END_STATE();
    case 22:
      if (lookahead == '*') ADVANCE(21);
      if (lookahead != 0) ADVANCE(22);
      END_STATE();
    case 23:
      if (lookahead == '4') ADVANCE(154);
      END_STATE();
    case 24:
      if (lookahead == '4') ADVANCE(153);
      END_STATE();
    case 25:
      if (lookahead == '6') ADVANCE(152);
      END_STATE();
    case 26:
      if (lookahead == '=') ADVANCE(124);
      END_STATE();
    case 27:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(112);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(97);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(30);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(29);
      END_STATE();
    case 28:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(112);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(81);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(29);
      END_STATE();
    case 29:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(86);
      END_STATE();
    case 30:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(91);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(90);
      END_STATE();
    case 31:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(72);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(165);
      END_STATE();
    case 32:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(76);
      END_STATE();
    case 33:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(100);
      END_STATE();
    case 34:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(105);
      END_STATE();
    case 35:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(106);
      END_STATE();
    case 36:
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(95);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(159);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(102);
      END_STATE();
    case 37:
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(48);
      END_STATE();
    case 38:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(163);
      END_STATE();
    case 39:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(155);
      END_STATE();
    case 40:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(156);
      END_STATE();
    case 41:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(149);
      END_STATE();
    case 42:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(144);
      END_STATE();
    case 43:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(94);
      END_STATE();
    case 44:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(96);
      END_STATE();
    case 45:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(66);
      END_STATE();
    case 46:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(92);
      END_STATE();
    case 47:
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(161);
      END_STATE();
    case 48:
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(109);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(31);
      END_STATE();
    case 49:
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(110);
      END_STATE();
    case 50:
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(111);
      END_STATE();
    case 51:
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(140);
      END_STATE();
    case 52:
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(157);
      END_STATE();
    case 53:
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(146);
      END_STATE();
    case 54:
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(41);
      END_STATE();
    case 55:
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(32);
      END_STATE();
    case 56:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(103);
      END_STATE();
    case 57:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(103);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(70);
      END_STATE();
    case 58:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(47);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(38);
      END_STATE();
    case 59:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(78);
      END_STATE();
    case 60:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(83);
      END_STATE();
    case 61:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(53);
      END_STATE();
    case 62:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(84);
      END_STATE();
    case 63:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(77);
      END_STATE();
    case 64:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(85);
      END_STATE();
    case 65:
      if (lookahead == 'K' ||
          lookahead == 'k') ADVANCE(147);
      END_STATE();
    case 66:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(145);
      END_STATE();
    case 67:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(49);
      END_STATE();
    case 68:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(42);
      END_STATE();
    case 69:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(102);
      END_STATE();
    case 70:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(51);
      END_STATE();
    case 71:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(33);
      END_STATE();
    case 72:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(142);
      END_STATE();
    case 73:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(136);
      END_STATE();
    case 74:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(138);
      END_STATE();
    case 75:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(134);
      END_STATE();
    case 76:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(54);
      END_STATE();
    case 77:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(52);
      END_STATE();
    case 78:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(98);
      END_STATE();
    case 79:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(34);
      END_STATE();
    case 80:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(35);
      END_STATE();
    case 81:
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(90);
      END_STATE();
    case 82:
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(88);
      END_STATE();
    case 83:
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(73);
      END_STATE();
    case 84:
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(74);
      END_STATE();
    case 85:
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(75);
      END_STATE();
    case 86:
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(148);
      END_STATE();
    case 87:
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(59);
      END_STATE();
    case 88:
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(65);
      END_STATE();
    case 89:
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(63);
      END_STATE();
    case 90:
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(40);
      END_STATE();
    case 91:
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(107);
      END_STATE();
    case 92:
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(99);
      END_STATE();
    case 93:
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(151);
      END_STATE();
    case 94:
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(93);
      END_STATE();
    case 95:
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(104);
      END_STATE();
    case 96:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(113);
      END_STATE();
    case 97:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(132);
      END_STATE();
    case 98:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(130);
      END_STATE();
    case 99:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(150);
      END_STATE();
    case 100:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(60);
      END_STATE();
    case 101:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(68);
      END_STATE();
    case 102:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(45);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(46);
      END_STATE();
    case 103:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(101);
      END_STATE();
    case 104:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(89);
      END_STATE();
    case 105:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(62);
      END_STATE();
    case 106:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(64);
      END_STATE();
    case 107:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(50);
      END_STATE();
    case 108:
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(43);
      END_STATE();
    case 109:
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(71);
      END_STATE();
    case 110:
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(79);
      END_STATE();
    case 111:
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(80);
      END_STATE();
    case 112:
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(39);
      END_STATE();
    case 113:
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(82);
      END_STATE();
    case 114:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(236);
      END_STATE();
    case 115:
      if (lookahead != 0 &&
          lookahead != '\r') ADVANCE(244);
      if (lookahead == '\r') ADVANCE(245);
      END_STATE();
    case 116:
      if (eof) ADVANCE(121);
      if (lookahead == '\n') SKIP(0)
      END_STATE();
    case 117:
      if (eof) ADVANCE(121);
      if (lookahead == '\n') SKIP(0)
      if (lookahead == '\r') SKIP(116)
      END_STATE();
    case 118:
      if (eof) ADVANCE(121);
      if (lookahead == '\n') SKIP(120)
      END_STATE();
    case 119:
      if (eof) ADVANCE(121);
      if (lookahead == '\n') SKIP(120)
      if (lookahead == '\r') SKIP(118)
      END_STATE();
    case 120:
      if (eof) ADVANCE(121);
      if (lookahead == '"') ADVANCE(237);
      if (lookahead == '#') ADVANCE(244);
      if (lookahead == '/') ADVANCE(20);
      if (lookahead == '0') ADVANCE(232);
      if (lookahead == '\\') SKIP(119)
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(167);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(171);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(179);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(215);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(183);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(120)
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(172);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(236);
      if (('G' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('g' <= lookahead && lookahead <= 'z')) ADVANCE(229);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '>') ADVANCE(125);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(anon_sym_GT);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      if (lookahead == '=') ADVANCE(126);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(anon_sym_LT_GT);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(anon_sym_BANG_EQ_EQ);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      if (lookahead == '=') ADVANCE(129);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(127);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(anon_sym_EQ_EQ_EQ);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(sym_print);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(sym_print);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(231);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(229);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(sym_set);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(sym_set);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(231);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(229);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(sym_startfunction);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(sym_startfunction);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(231);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(229);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(sym_endfunction);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(sym_endfunction);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(231);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(229);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(sym_callfunction);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(sym_callfunction);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(231);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(229);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(sym_long);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(sym_long);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(231);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(229);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(sym_endian);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(sym_endian);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(231);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(229);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(sym_little);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(sym_intel);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(sym_big);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(sym_network);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(sym_swap);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(sym_change);
      END_STATE();
    case 150:
      ACCEPT_TOKEN(sym_invert);
      END_STATE();
    case 151:
      ACCEPT_TOKEN(sym_guess);
      if (lookahead == '1') ADVANCE(25);
      if (lookahead == '2') ADVANCE(23);
      if (lookahead == '6') ADVANCE(24);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(sym_guess16);
      END_STATE();
    case 153:
      ACCEPT_TOKEN(sym_guess64);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(sym_guess24);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(sym_save);
      END_STATE();
    case 156:
      ACCEPT_TOKEN(sym_store);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(sym_idstring);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(sym_idstring);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(231);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(229);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(sym_if);
      END_STATE();
    case 160:
      ACCEPT_TOKEN(sym_if);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(231);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(229);
      END_STATE();
    case 161:
      ACCEPT_TOKEN(sym_elif);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(sym_elif);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(231);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(229);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(sym_else);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(sym_else);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(231);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(229);
      END_STATE();
    case 165:
      ACCEPT_TOKEN(sym_endif);
      END_STATE();
    case 166:
      ACCEPT_TOKEN(sym_endif);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(231);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(229);
      END_STATE();
    case 167:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '-') ADVANCE(231);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(169);
      if (('B' <= lookahead && lookahead <= 'F') ||
          ('b' <= lookahead && lookahead <= 'f')) ADVANCE(172);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(230);
      if (('G' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('g' <= lookahead && lookahead <= 'z')) ADVANCE(229);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '-') ADVANCE(231);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(192);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(181);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(230);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(172);
      if (('G' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('g' <= lookahead && lookahead <= 'z')) ADVANCE(229);
      END_STATE();
    case 169:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '-') ADVANCE(231);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(200);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(230);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(172);
      if (('G' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('g' <= lookahead && lookahead <= 'z')) ADVANCE(229);
      END_STATE();
    case 170:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '-') ADVANCE(231);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(180);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(230);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(172);
      if (('G' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('g' <= lookahead && lookahead <= 'z')) ADVANCE(229);
      END_STATE();
    case 171:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '-') ADVANCE(231);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(182);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(230);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(172);
      if (('G' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('g' <= lookahead && lookahead <= 'z')) ADVANCE(229);
      END_STATE();
    case 172:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '-') ADVANCE(231);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(230);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(172);
      if (('G' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('g' <= lookahead && lookahead <= 'z')) ADVANCE(229);
      END_STATE();
    case 173:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(216);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(231);
      if (('B' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(229);
      END_STATE();
    case 174:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(201);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(166);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(231);
      if (('B' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(229);
      END_STATE();
    case 175:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(201);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(231);
      if (('B' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(229);
      END_STATE();
    case 176:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(221);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(231);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(229);
      END_STATE();
    case 177:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(222);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(231);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(229);
      END_STATE();
    case 178:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(223);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(231);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(229);
      END_STATE();
    case 179:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(218);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(160);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(231);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(229);
      END_STATE();
    case 180:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(189);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(231);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(229);
      END_STATE();
    case 181:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(194);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(231);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(229);
      END_STATE();
    case 182:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(196);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(231);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(229);
      END_STATE();
    case 183:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(219);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(173);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(231);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(229);
      END_STATE();
    case 184:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(219);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(231);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(229);
      END_STATE();
    case 185:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(164);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(231);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(229);
      END_STATE();
    case 186:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(162);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(231);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(229);
      END_STATE();
    case 187:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(226);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(231);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(229);
      END_STATE();
    case 188:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(227);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(231);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(229);
      END_STATE();
    case 189:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(228);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(175);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(231);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(229);
      END_STATE();
    case 190:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(158);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(231);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(229);
      END_STATE();
    case 191:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(141);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(231);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(229);
      END_STATE();
    case 192:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(186);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(185);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(231);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(229);
      END_STATE();
    case 193:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(208);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(231);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(229);
      END_STATE();
    case 194:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(174);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(231);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(229);
      END_STATE();
    case 195:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(211);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(231);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(229);
      END_STATE();
    case 196:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(175);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(231);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(229);
      END_STATE();
    case 197:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(203);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(231);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(229);
      END_STATE();
    case 198:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(212);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(231);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(229);
      END_STATE();
    case 199:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(213);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(231);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(229);
      END_STATE();
    case 200:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(187);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(231);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(229);
      END_STATE();
    case 201:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(143);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(231);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(229);
      END_STATE();
    case 202:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(176);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(231);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(229);
      END_STATE();
    case 203:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(190);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(231);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(229);
      END_STATE();
    case 204:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(139);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(231);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(229);
      END_STATE();
    case 205:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(135);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(231);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(229);
      END_STATE();
    case 206:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(137);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(231);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(229);
      END_STATE();
    case 207:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(191);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(231);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(229);
      END_STATE();
    case 208:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(220);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(231);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(229);
      END_STATE();
    case 209:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(177);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(231);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(229);
      END_STATE();
    case 210:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(178);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(231);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(229);
      END_STATE();
    case 211:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(204);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(231);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(229);
      END_STATE();
    case 212:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(205);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(231);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(229);
      END_STATE();
    case 213:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(206);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(231);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(229);
      END_STATE();
    case 214:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(207);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(231);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(229);
      END_STATE();
    case 215:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(193);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(231);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(229);
      END_STATE();
    case 216:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(225);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(231);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(229);
      END_STATE();
    case 217:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(197);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(231);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(229);
      END_STATE();
    case 218:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(224);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(231);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(229);
      END_STATE();
    case 219:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(133);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(231);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(229);
      END_STATE();
    case 220:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(131);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(231);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(229);
      END_STATE();
    case 221:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(195);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(231);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(229);
      END_STATE();
    case 222:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(198);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(231);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(229);
      END_STATE();
    case 223:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(199);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(231);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(229);
      END_STATE();
    case 224:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(217);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(231);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(229);
      END_STATE();
    case 225:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(188);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(231);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(229);
      END_STATE();
    case 226:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(202);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(231);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(229);
      END_STATE();
    case 227:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(209);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(231);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(229);
      END_STATE();
    case 228:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(210);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(231);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(229);
      END_STATE();
    case 229:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(231);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(229);
      END_STATE();
    case 230:
      ACCEPT_TOKEN(sym_identifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(230);
      if (lookahead == '-' ||
          ('G' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('g' <= lookahead && lookahead <= 'z')) ADVANCE(231);
      END_STATE();
    case 231:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(231);
      END_STATE();
    case 232:
      ACCEPT_TOKEN(sym_integer_literal);
      if (lookahead == 'x') ADVANCE(114);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(236);
      END_STATE();
    case 233:
      ACCEPT_TOKEN(sym_integer_literal);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(235);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(32);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'F') ||
          ('b' <= lookahead && lookahead <= 'f')) ADVANCE(236);
      END_STATE();
    case 234:
      ACCEPT_TOKEN(sym_integer_literal);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(58);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(37);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(236);
      END_STATE();
    case 235:
      ACCEPT_TOKEN(sym_integer_literal);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(67);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(236);
      END_STATE();
    case 236:
      ACCEPT_TOKEN(sym_integer_literal);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(236);
      END_STATE();
    case 237:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 238:
      ACCEPT_TOKEN(aux_sym_string_literal_token1);
      if (lookahead == '#') ADVANCE(242);
      if (lookahead == '/') ADVANCE(239);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(238);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(242);
      END_STATE();
    case 239:
      ACCEPT_TOKEN(aux_sym_string_literal_token1);
      if (lookahead == '*') ADVANCE(241);
      if (lookahead == '/') ADVANCE(242);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(242);
      END_STATE();
    case 240:
      ACCEPT_TOKEN(aux_sym_string_literal_token1);
      if (lookahead == '*') ADVANCE(240);
      if (lookahead == '/') ADVANCE(242);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(241);
      END_STATE();
    case 241:
      ACCEPT_TOKEN(aux_sym_string_literal_token1);
      if (lookahead == '*') ADVANCE(240);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(241);
      END_STATE();
    case 242:
      ACCEPT_TOKEN(aux_sym_string_literal_token1);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(242);
      END_STATE();
    case 243:
      ACCEPT_TOKEN(sym_comment);
      END_STATE();
    case 244:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\\') ADVANCE(115);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(244);
      END_STATE();
    case 245:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\\') ADVANCE(244);
      if (lookahead == '\\') ADVANCE(115);
      END_STATE();
    default:
      return false;
  }
}

static TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0},
  [1] = {.lex_state = 0},
  [2] = {.lex_state = 0},
  [3] = {.lex_state = 0},
  [4] = {.lex_state = 0},
  [5] = {.lex_state = 0},
  [6] = {.lex_state = 0},
  [7] = {.lex_state = 0},
  [8] = {.lex_state = 0},
  [9] = {.lex_state = 0},
  [10] = {.lex_state = 0},
  [11] = {.lex_state = 0},
  [12] = {.lex_state = 0},
  [13] = {.lex_state = 0},
  [14] = {.lex_state = 0},
  [15] = {.lex_state = 0},
  [16] = {.lex_state = 19},
  [17] = {.lex_state = 19},
  [18] = {.lex_state = 14},
  [19] = {.lex_state = 19},
  [20] = {.lex_state = 120},
  [21] = {.lex_state = 0},
  [22] = {.lex_state = 0},
  [23] = {.lex_state = 0},
  [24] = {.lex_state = 15},
  [25] = {.lex_state = 0},
  [26] = {.lex_state = 0},
  [27] = {.lex_state = 0},
  [28] = {.lex_state = 0},
  [29] = {.lex_state = 0},
  [30] = {.lex_state = 0},
  [31] = {.lex_state = 0},
  [32] = {.lex_state = 0},
  [33] = {.lex_state = 0},
  [34] = {.lex_state = 0},
  [35] = {.lex_state = 0},
  [36] = {.lex_state = 0},
  [37] = {.lex_state = 16},
  [38] = {.lex_state = 0},
  [39] = {.lex_state = 0},
  [40] = {.lex_state = 0},
  [41] = {.lex_state = 17},
  [42] = {.lex_state = 17},
  [43] = {.lex_state = 17},
  [44] = {.lex_state = 17},
  [45] = {.lex_state = 17},
  [46] = {.lex_state = 17},
  [47] = {.lex_state = 17},
  [48] = {.lex_state = 11},
  [49] = {.lex_state = 11},
  [50] = {.lex_state = 11},
  [51] = {.lex_state = 17},
  [52] = {.lex_state = 17},
  [53] = {.lex_state = 0},
  [54] = {.lex_state = 0},
  [55] = {.lex_state = 17},
  [56] = {.lex_state = 17},
  [57] = {.lex_state = 17},
};

static uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_LT_GT] = ACTIONS(1),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(1),
    [sym_print] = ACTIONS(1),
    [sym_set] = ACTIONS(1),
    [sym_startfunction] = ACTIONS(1),
    [sym_endfunction] = ACTIONS(1),
    [sym_callfunction] = ACTIONS(1),
    [sym_long] = ACTIONS(1),
    [sym_endian] = ACTIONS(1),
    [sym_little] = ACTIONS(1),
    [sym_intel] = ACTIONS(1),
    [sym_network] = ACTIONS(1),
    [sym_swap] = ACTIONS(1),
    [sym_change] = ACTIONS(1),
    [sym_invert] = ACTIONS(1),
    [sym_guess] = ACTIONS(1),
    [sym_guess16] = ACTIONS(1),
    [sym_guess64] = ACTIONS(1),
    [sym_guess24] = ACTIONS(1),
    [sym_save] = ACTIONS(1),
    [sym_store] = ACTIONS(1),
    [sym_idstring] = ACTIONS(1),
    [sym_if] = ACTIONS(1),
    [sym_elif] = ACTIONS(1),
    [sym_else] = ACTIONS(1),
    [sym_endif] = ACTIONS(1),
    [sym_integer_literal] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
  },
  [1] = {
    [sym_source_file] = STATE(54),
    [sym__top_statement] = STATE(7),
    [sym_function_declaration] = STATE(7),
    [sym__statement] = STATE(7),
    [sym_set_statement] = STATE(7),
    [sym_print_statement] = STATE(7),
    [sym_function_call_statement] = STATE(7),
    [sym_endian_statement] = STATE(7),
    [sym_idstring_statement] = STATE(7),
    [sym_if_statement] = STATE(7),
    [aux_sym_source_file_repeat1] = STATE(7),
    [ts_builtin_sym_end] = ACTIONS(5),
    [sym_print] = ACTIONS(7),
    [sym_set] = ACTIONS(9),
    [sym_startfunction] = ACTIONS(11),
    [sym_callfunction] = ACTIONS(13),
    [sym_endian] = ACTIONS(15),
    [sym_idstring] = ACTIONS(17),
    [sym_if] = ACTIONS(19),
    [sym_comment] = ACTIONS(3),
  },
};

static uint16_t ts_small_parse_table[] = {
  [0] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 4,
      anon_sym_LT,
      anon_sym_BANG_EQ,
      anon_sym_EQ_EQ,
      anon_sym_EQ,
    ACTIONS(21), 17,
      ts_builtin_sym_end,
      anon_sym_GT,
      anon_sym_LT_GT,
      anon_sym_BANG_EQ_EQ,
      anon_sym_EQ_EQ_EQ,
      sym_print,
      sym_set,
      sym_startfunction,
      sym_endfunction,
      sym_callfunction,
      sym_endian,
      sym_idstring,
      sym_if,
      sym_elif,
      sym_else,
      sym_endif,
      anon_sym_DQUOTE,
  [29] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 4,
      anon_sym_LT,
      anon_sym_BANG_EQ,
      anon_sym_EQ_EQ,
      anon_sym_EQ,
    ACTIONS(25), 17,
      ts_builtin_sym_end,
      anon_sym_GT,
      anon_sym_LT_GT,
      anon_sym_BANG_EQ_EQ,
      anon_sym_EQ_EQ_EQ,
      sym_print,
      sym_set,
      sym_startfunction,
      sym_endfunction,
      sym_callfunction,
      sym_endian,
      sym_idstring,
      sym_if,
      sym_elif,
      sym_else,
      sym_endif,
      anon_sym_DQUOTE,
  [58] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_print,
    ACTIONS(9), 1,
      sym_set,
    ACTIONS(13), 1,
      sym_callfunction,
    ACTIONS(17), 1,
      sym_idstring,
    ACTIONS(19), 1,
      sym_if,
    ACTIONS(29), 1,
      sym_endian,
    ACTIONS(31), 1,
      sym_elif,
    ACTIONS(33), 1,
      sym_else,
    ACTIONS(35), 1,
      sym_endif,
    STATE(38), 3,
      sym_elif_statement,
      sym_else_statement,
      aux_sym_if_statement_repeat1,
    STATE(5), 8,
      sym__statement,
      sym_set_statement,
      sym_print_statement,
      sym_function_call_statement,
      sym_endian_statement,
      sym_idstring_statement,
      sym_if_statement,
      aux_sym_function_declaration_repeat1,
  [104] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_print,
    ACTIONS(9), 1,
      sym_set,
    ACTIONS(13), 1,
      sym_callfunction,
    ACTIONS(17), 1,
      sym_idstring,
    ACTIONS(19), 1,
      sym_if,
    ACTIONS(29), 1,
      sym_endian,
    ACTIONS(31), 1,
      sym_elif,
    ACTIONS(33), 1,
      sym_else,
    ACTIONS(37), 1,
      sym_endif,
    STATE(39), 3,
      sym_elif_statement,
      sym_else_statement,
      aux_sym_if_statement_repeat1,
    STATE(8), 8,
      sym__statement,
      sym_set_statement,
      sym_print_statement,
      sym_function_call_statement,
      sym_endian_statement,
      sym_idstring_statement,
      sym_if_statement,
      aux_sym_function_declaration_repeat1,
  [150] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(39), 1,
      ts_builtin_sym_end,
    ACTIONS(41), 1,
      sym_print,
    ACTIONS(44), 1,
      sym_set,
    ACTIONS(47), 1,
      sym_startfunction,
    ACTIONS(50), 1,
      sym_callfunction,
    ACTIONS(53), 1,
      sym_endian,
    ACTIONS(56), 1,
      sym_idstring,
    ACTIONS(59), 1,
      sym_if,
    STATE(6), 10,
      sym__top_statement,
      sym_function_declaration,
      sym__statement,
      sym_set_statement,
      sym_print_statement,
      sym_function_call_statement,
      sym_endian_statement,
      sym_idstring_statement,
      sym_if_statement,
      aux_sym_source_file_repeat1,
  [190] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_print,
    ACTIONS(9), 1,
      sym_set,
    ACTIONS(11), 1,
      sym_startfunction,
    ACTIONS(13), 1,
      sym_callfunction,
    ACTIONS(15), 1,
      sym_endian,
    ACTIONS(17), 1,
      sym_idstring,
    ACTIONS(19), 1,
      sym_if,
    ACTIONS(62), 1,
      ts_builtin_sym_end,
    STATE(6), 10,
      sym__top_statement,
      sym_function_declaration,
      sym__statement,
      sym_set_statement,
      sym_print_statement,
      sym_function_call_statement,
      sym_endian_statement,
      sym_idstring_statement,
      sym_if_statement,
      aux_sym_source_file_repeat1,
  [230] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(64), 1,
      sym_print,
    ACTIONS(67), 1,
      sym_set,
    ACTIONS(70), 1,
      sym_callfunction,
    ACTIONS(73), 1,
      sym_endian,
    ACTIONS(76), 1,
      sym_idstring,
    ACTIONS(79), 1,
      sym_if,
    ACTIONS(82), 3,
      sym_elif,
      sym_else,
      sym_endif,
    STATE(8), 8,
      sym__statement,
      sym_set_statement,
      sym_print_statement,
      sym_function_call_statement,
      sym_endian_statement,
      sym_idstring_statement,
      sym_if_statement,
      aux_sym_function_declaration_repeat1,
  [267] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_print,
    ACTIONS(9), 1,
      sym_set,
    ACTIONS(13), 1,
      sym_callfunction,
    ACTIONS(17), 1,
      sym_idstring,
    ACTIONS(19), 1,
      sym_if,
    ACTIONS(29), 1,
      sym_endian,
    ACTIONS(84), 3,
      sym_elif,
      sym_else,
      sym_endif,
    STATE(8), 8,
      sym__statement,
      sym_set_statement,
      sym_print_statement,
      sym_function_call_statement,
      sym_endian_statement,
      sym_idstring_statement,
      sym_if_statement,
      aux_sym_function_declaration_repeat1,
  [304] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_print,
    ACTIONS(9), 1,
      sym_set,
    ACTIONS(13), 1,
      sym_callfunction,
    ACTIONS(17), 1,
      sym_idstring,
    ACTIONS(19), 1,
      sym_if,
    ACTIONS(29), 1,
      sym_endian,
    ACTIONS(86), 3,
      sym_elif,
      sym_else,
      sym_endif,
    STATE(9), 8,
      sym__statement,
      sym_set_statement,
      sym_print_statement,
      sym_function_call_statement,
      sym_endian_statement,
      sym_idstring_statement,
      sym_if_statement,
      aux_sym_function_declaration_repeat1,
  [341] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_print,
    ACTIONS(9), 1,
      sym_set,
    ACTIONS(13), 1,
      sym_callfunction,
    ACTIONS(17), 1,
      sym_idstring,
    ACTIONS(19), 1,
      sym_if,
    ACTIONS(29), 1,
      sym_endian,
    ACTIONS(88), 3,
      sym_elif,
      sym_else,
      sym_endif,
    STATE(8), 8,
      sym__statement,
      sym_set_statement,
      sym_print_statement,
      sym_function_call_statement,
      sym_endian_statement,
      sym_idstring_statement,
      sym_if_statement,
      aux_sym_function_declaration_repeat1,
  [378] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_print,
    ACTIONS(9), 1,
      sym_set,
    ACTIONS(13), 1,
      sym_callfunction,
    ACTIONS(17), 1,
      sym_idstring,
    ACTIONS(19), 1,
      sym_if,
    ACTIONS(29), 1,
      sym_endian,
    ACTIONS(90), 3,
      sym_elif,
      sym_else,
      sym_endif,
    STATE(11), 8,
      sym__statement,
      sym_set_statement,
      sym_print_statement,
      sym_function_call_statement,
      sym_endian_statement,
      sym_idstring_statement,
      sym_if_statement,
      aux_sym_function_declaration_repeat1,
  [415] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(64), 1,
      sym_print,
    ACTIONS(67), 1,
      sym_set,
    ACTIONS(70), 1,
      sym_callfunction,
    ACTIONS(76), 1,
      sym_idstring,
    ACTIONS(79), 1,
      sym_if,
    ACTIONS(82), 1,
      sym_endfunction,
    ACTIONS(92), 1,
      sym_endian,
    STATE(13), 8,
      sym__statement,
      sym_set_statement,
      sym_print_statement,
      sym_function_call_statement,
      sym_endian_statement,
      sym_idstring_statement,
      sym_if_statement,
      aux_sym_function_declaration_repeat1,
  [450] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_print,
    ACTIONS(9), 1,
      sym_set,
    ACTIONS(13), 1,
      sym_callfunction,
    ACTIONS(17), 1,
      sym_idstring,
    ACTIONS(19), 1,
      sym_if,
    ACTIONS(95), 1,
      sym_endfunction,
    ACTIONS(97), 1,
      sym_endian,
    STATE(15), 8,
      sym__statement,
      sym_set_statement,
      sym_print_statement,
      sym_function_call_statement,
      sym_endian_statement,
      sym_idstring_statement,
      sym_if_statement,
      aux_sym_function_declaration_repeat1,
  [485] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_print,
    ACTIONS(9), 1,
      sym_set,
    ACTIONS(13), 1,
      sym_callfunction,
    ACTIONS(17), 1,
      sym_idstring,
    ACTIONS(19), 1,
      sym_if,
    ACTIONS(97), 1,
      sym_endian,
    ACTIONS(99), 1,
      sym_endfunction,
    STATE(13), 8,
      sym__statement,
      sym_set_statement,
      sym_print_statement,
      sym_function_call_statement,
      sym_endian_statement,
      sym_idstring_statement,
      sym_if_statement,
      aux_sym_function_declaration_repeat1,
  [520] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(103), 1,
      sym_guess,
    STATE(18), 1,
      sym__endian_type,
    ACTIONS(101), 12,
      sym_little,
      sym_intel,
      sym_big,
      sym_network,
      sym_swap,
      sym_change,
      sym_invert,
      sym_guess16,
      sym_guess64,
      sym_guess24,
      sym_save,
      sym_store,
  [544] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(107), 1,
      sym_guess,
    STATE(20), 1,
      sym__endian_type,
    ACTIONS(105), 12,
      sym_little,
      sym_intel,
      sym_big,
      sym_network,
      sym_swap,
      sym_change,
      sym_invert,
      sym_guess16,
      sym_guess64,
      sym_guess24,
      sym_save,
      sym_store,
  [568] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(113), 1,
      anon_sym_DQUOTE,
    ACTIONS(111), 2,
      sym_identifier,
      sym_integer_literal,
    STATE(22), 2,
      sym__expression,
      sym_string_literal,
    ACTIONS(109), 9,
      sym_print,
      sym_set,
      sym_callfunction,
      sym_endian,
      sym_idstring,
      sym_if,
      sym_elif,
      sym_else,
      sym_endif,
  [594] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(117), 1,
      sym_guess,
    STATE(24), 1,
      sym__endian_type,
    ACTIONS(115), 12,
      sym_little,
      sym_intel,
      sym_big,
      sym_network,
      sym_swap,
      sym_change,
      sym_invert,
      sym_guess16,
      sym_guess64,
      sym_guess24,
      sym_save,
      sym_store,
  [618] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(113), 1,
      anon_sym_DQUOTE,
    ACTIONS(119), 1,
      ts_builtin_sym_end,
    ACTIONS(111), 2,
      sym_identifier,
      sym_integer_literal,
    STATE(22), 2,
      sym__expression,
      sym_string_literal,
    ACTIONS(109), 7,
      sym_print,
      sym_set,
      sym_startfunction,
      sym_callfunction,
      sym_endian,
      sym_idstring,
      sym_if,
  [645] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(123), 1,
      anon_sym_DQUOTE,
    ACTIONS(121), 12,
      ts_builtin_sym_end,
      sym_print,
      sym_set,
      sym_startfunction,
      sym_endfunction,
      sym_callfunction,
      sym_endian,
      sym_idstring,
      sym_if,
      sym_elif,
      sym_else,
      sym_endif,
  [666] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(125), 12,
      ts_builtin_sym_end,
      sym_print,
      sym_set,
      sym_startfunction,
      sym_endfunction,
      sym_callfunction,
      sym_endian,
      sym_idstring,
      sym_if,
      sym_elif,
      sym_else,
      sym_endif,
  [684] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(127), 12,
      ts_builtin_sym_end,
      sym_print,
      sym_set,
      sym_startfunction,
      sym_endfunction,
      sym_callfunction,
      sym_endian,
      sym_idstring,
      sym_if,
      sym_elif,
      sym_else,
      sym_endif,
  [702] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(113), 1,
      anon_sym_DQUOTE,
    ACTIONS(111), 2,
      sym_identifier,
      sym_integer_literal,
    STATE(22), 2,
      sym__expression,
      sym_string_literal,
    ACTIONS(109), 7,
      sym_print,
      sym_set,
      sym_endfunction,
      sym_callfunction,
      sym_endian,
      sym_idstring,
      sym_if,
  [726] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(129), 12,
      ts_builtin_sym_end,
      sym_print,
      sym_set,
      sym_startfunction,
      sym_endfunction,
      sym_callfunction,
      sym_endian,
      sym_idstring,
      sym_if,
      sym_elif,
      sym_else,
      sym_endif,
  [744] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(131), 12,
      ts_builtin_sym_end,
      sym_print,
      sym_set,
      sym_startfunction,
      sym_endfunction,
      sym_callfunction,
      sym_endian,
      sym_idstring,
      sym_if,
      sym_elif,
      sym_else,
      sym_endif,
  [762] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(133), 12,
      ts_builtin_sym_end,
      sym_print,
      sym_set,
      sym_startfunction,
      sym_endfunction,
      sym_callfunction,
      sym_endian,
      sym_idstring,
      sym_if,
      sym_elif,
      sym_else,
      sym_endif,
  [780] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(135), 12,
      ts_builtin_sym_end,
      sym_print,
      sym_set,
      sym_startfunction,
      sym_endfunction,
      sym_callfunction,
      sym_endian,
      sym_idstring,
      sym_if,
      sym_elif,
      sym_else,
      sym_endif,
  [798] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(137), 12,
      ts_builtin_sym_end,
      sym_print,
      sym_set,
      sym_startfunction,
      sym_endfunction,
      sym_callfunction,
      sym_endian,
      sym_idstring,
      sym_if,
      sym_elif,
      sym_else,
      sym_endif,
  [816] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(139), 12,
      ts_builtin_sym_end,
      sym_print,
      sym_set,
      sym_startfunction,
      sym_endfunction,
      sym_callfunction,
      sym_endian,
      sym_idstring,
      sym_if,
      sym_elif,
      sym_else,
      sym_endif,
  [834] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(141), 12,
      ts_builtin_sym_end,
      sym_print,
      sym_set,
      sym_startfunction,
      sym_endfunction,
      sym_callfunction,
      sym_endian,
      sym_idstring,
      sym_if,
      sym_elif,
      sym_else,
      sym_endif,
  [852] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(143), 12,
      ts_builtin_sym_end,
      sym_print,
      sym_set,
      sym_startfunction,
      sym_endfunction,
      sym_callfunction,
      sym_endian,
      sym_idstring,
      sym_if,
      sym_elif,
      sym_else,
      sym_endif,
  [870] = 4,
    ACTIONS(3), 1,
      sym_comment,
    STATE(44), 1,
      sym_comparison,
    ACTIONS(145), 4,
      anon_sym_LT,
      anon_sym_BANG_EQ,
      anon_sym_EQ_EQ,
      anon_sym_EQ,
    ACTIONS(147), 4,
      anon_sym_GT,
      anon_sym_LT_GT,
      anon_sym_BANG_EQ_EQ,
      anon_sym_EQ_EQ_EQ,
  [889] = 4,
    ACTIONS(3), 1,
      sym_comment,
    STATE(43), 1,
      sym_comparison,
    ACTIONS(145), 4,
      anon_sym_LT,
      anon_sym_BANG_EQ,
      anon_sym_EQ_EQ,
      anon_sym_EQ,
    ACTIONS(147), 4,
      anon_sym_GT,
      anon_sym_LT_GT,
      anon_sym_BANG_EQ_EQ,
      anon_sym_EQ_EQ_EQ,
  [908] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(149), 8,
      ts_builtin_sym_end,
      sym_print,
      sym_set,
      sym_startfunction,
      sym_callfunction,
      sym_endian,
      sym_idstring,
      sym_if,
  [922] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(151), 8,
      ts_builtin_sym_end,
      sym_print,
      sym_set,
      sym_startfunction,
      sym_callfunction,
      sym_endian,
      sym_idstring,
      sym_if,
  [936] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(113), 1,
      anon_sym_DQUOTE,
    ACTIONS(153), 1,
      sym_long,
    STATE(45), 1,
      sym_type,
    ACTIONS(155), 2,
      sym_identifier,
      sym_integer_literal,
    STATE(27), 2,
      sym__expression,
      sym_string_literal,
  [957] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      sym_elif,
    ACTIONS(33), 1,
      sym_else,
    ACTIONS(157), 1,
      sym_endif,
    STATE(40), 3,
      sym_elif_statement,
      sym_else_statement,
      aux_sym_if_statement_repeat1,
  [975] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      sym_elif,
    ACTIONS(33), 1,
      sym_else,
    ACTIONS(159), 1,
      sym_endif,
    STATE(40), 3,
      sym_elif_statement,
      sym_else_statement,
      aux_sym_if_statement_repeat1,
  [993] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(161), 1,
      sym_elif,
    ACTIONS(164), 1,
      sym_else,
    ACTIONS(167), 1,
      sym_endif,
    STATE(40), 3,
      sym_elif_statement,
      sym_else_statement,
      aux_sym_if_statement_repeat1,
  [1011] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(113), 1,
      anon_sym_DQUOTE,
    ACTIONS(169), 1,
      sym_identifier,
    ACTIONS(171), 1,
      sym_integer_literal,
    STATE(33), 2,
      sym__expression,
      sym_string_literal,
  [1028] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(113), 1,
      anon_sym_DQUOTE,
    ACTIONS(173), 1,
      sym_identifier,
    ACTIONS(175), 1,
      sym_integer_literal,
    STATE(30), 2,
      sym__expression,
      sym_string_literal,
  [1045] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(113), 1,
      anon_sym_DQUOTE,
    ACTIONS(177), 1,
      sym_identifier,
    ACTIONS(179), 1,
      sym_integer_literal,
    STATE(4), 2,
      sym__expression,
      sym_string_literal,
  [1062] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(113), 1,
      anon_sym_DQUOTE,
    ACTIONS(181), 1,
      sym_identifier,
    ACTIONS(183), 1,
      sym_integer_literal,
    STATE(10), 2,
      sym__expression,
      sym_string_literal,
  [1079] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(113), 1,
      anon_sym_DQUOTE,
    ACTIONS(185), 1,
      sym_identifier,
    ACTIONS(187), 1,
      sym_integer_literal,
    STATE(32), 2,
      sym__expression,
      sym_string_literal,
  [1096] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(113), 1,
      anon_sym_DQUOTE,
    ACTIONS(189), 1,
      sym_identifier,
    ACTIONS(191), 1,
      sym_integer_literal,
    STATE(34), 2,
      sym__expression,
      sym_string_literal,
  [1113] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(113), 1,
      anon_sym_DQUOTE,
    ACTIONS(193), 1,
      sym_identifier,
    ACTIONS(195), 1,
      sym_integer_literal,
    STATE(21), 1,
      sym_string_literal,
    STATE(53), 1,
      sym__expression,
  [1132] = 4,
    ACTIONS(197), 1,
      anon_sym_DQUOTE,
    ACTIONS(199), 1,
      aux_sym_string_literal_token1,
    ACTIONS(201), 1,
      sym_comment,
    STATE(49), 1,
      aux_sym_string_literal_repeat1,
  [1145] = 4,
    ACTIONS(201), 1,
      sym_comment,
    ACTIONS(203), 1,
      anon_sym_DQUOTE,
    ACTIONS(205), 1,
      aux_sym_string_literal_token1,
    STATE(49), 1,
      aux_sym_string_literal_repeat1,
  [1158] = 4,
    ACTIONS(201), 1,
      sym_comment,
    ACTIONS(208), 1,
      anon_sym_DQUOTE,
    ACTIONS(210), 1,
      aux_sym_string_literal_token1,
    STATE(48), 1,
      aux_sym_string_literal_repeat1,
  [1171] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(214), 1,
      sym_integer_literal,
    ACTIONS(212), 2,
      sym_identifier,
      anon_sym_DQUOTE,
  [1182] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(218), 1,
      sym_integer_literal,
    ACTIONS(216), 2,
      sym_identifier,
      anon_sym_DQUOTE,
  [1193] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(113), 1,
      anon_sym_DQUOTE,
    STATE(28), 1,
      sym_string_literal,
  [1203] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(220), 1,
      ts_builtin_sym_end,
  [1210] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(222), 1,
      sym_identifier,
  [1217] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(224), 1,
      sym_identifier,
  [1224] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(226), 1,
      sym_identifier,
};

static uint32_t ts_small_parse_table_map[] = {
  [SMALL_STATE(2)] = 0,
  [SMALL_STATE(3)] = 29,
  [SMALL_STATE(4)] = 58,
  [SMALL_STATE(5)] = 104,
  [SMALL_STATE(6)] = 150,
  [SMALL_STATE(7)] = 190,
  [SMALL_STATE(8)] = 230,
  [SMALL_STATE(9)] = 267,
  [SMALL_STATE(10)] = 304,
  [SMALL_STATE(11)] = 341,
  [SMALL_STATE(12)] = 378,
  [SMALL_STATE(13)] = 415,
  [SMALL_STATE(14)] = 450,
  [SMALL_STATE(15)] = 485,
  [SMALL_STATE(16)] = 520,
  [SMALL_STATE(17)] = 544,
  [SMALL_STATE(18)] = 568,
  [SMALL_STATE(19)] = 594,
  [SMALL_STATE(20)] = 618,
  [SMALL_STATE(21)] = 645,
  [SMALL_STATE(22)] = 666,
  [SMALL_STATE(23)] = 684,
  [SMALL_STATE(24)] = 702,
  [SMALL_STATE(25)] = 726,
  [SMALL_STATE(26)] = 744,
  [SMALL_STATE(27)] = 762,
  [SMALL_STATE(28)] = 780,
  [SMALL_STATE(29)] = 798,
  [SMALL_STATE(30)] = 816,
  [SMALL_STATE(31)] = 834,
  [SMALL_STATE(32)] = 852,
  [SMALL_STATE(33)] = 870,
  [SMALL_STATE(34)] = 889,
  [SMALL_STATE(35)] = 908,
  [SMALL_STATE(36)] = 922,
  [SMALL_STATE(37)] = 936,
  [SMALL_STATE(38)] = 957,
  [SMALL_STATE(39)] = 975,
  [SMALL_STATE(40)] = 993,
  [SMALL_STATE(41)] = 1011,
  [SMALL_STATE(42)] = 1028,
  [SMALL_STATE(43)] = 1045,
  [SMALL_STATE(44)] = 1062,
  [SMALL_STATE(45)] = 1079,
  [SMALL_STATE(46)] = 1096,
  [SMALL_STATE(47)] = 1113,
  [SMALL_STATE(48)] = 1132,
  [SMALL_STATE(49)] = 1145,
  [SMALL_STATE(50)] = 1158,
  [SMALL_STATE(51)] = 1171,
  [SMALL_STATE(52)] = 1182,
  [SMALL_STATE(53)] = 1193,
  [SMALL_STATE(54)] = 1203,
  [SMALL_STATE(55)] = 1210,
  [SMALL_STATE(56)] = 1217,
  [SMALL_STATE(57)] = 1224,
};

static TSParseActionEntry ts_parse_actions[] = {
  [0] = {.entry = {.count = 0, .reusable = false}},
  [1] = {.entry = {.count = 1, .reusable = false}}, RECOVER(),
  [3] = {.entry = {.count = 1, .reusable = true}}, SHIFT_EXTRA(),
  [5] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_source_file, 0),
  [7] = {.entry = {.count = 1, .reusable = true}}, SHIFT(42),
  [9] = {.entry = {.count = 1, .reusable = true}}, SHIFT(57),
  [11] = {.entry = {.count = 1, .reusable = true}}, SHIFT(56),
  [13] = {.entry = {.count = 1, .reusable = true}}, SHIFT(55),
  [15] = {.entry = {.count = 1, .reusable = true}}, SHIFT(17),
  [17] = {.entry = {.count = 1, .reusable = true}}, SHIFT(47),
  [19] = {.entry = {.count = 1, .reusable = true}}, SHIFT(46),
  [21] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_string_literal, 2),
  [23] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_string_literal, 2),
  [25] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_string_literal, 3),
  [27] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_string_literal, 3),
  [29] = {.entry = {.count = 1, .reusable = true}}, SHIFT(16),
  [31] = {.entry = {.count = 1, .reusable = true}}, SHIFT(41),
  [33] = {.entry = {.count = 1, .reusable = true}}, SHIFT(12),
  [35] = {.entry = {.count = 1, .reusable = true}}, SHIFT(31),
  [37] = {.entry = {.count = 1, .reusable = true}}, SHIFT(29),
  [39] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2),
  [41] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(42),
  [44] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(57),
  [47] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(56),
  [50] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(55),
  [53] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(17),
  [56] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(47),
  [59] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(46),
  [62] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_source_file, 1),
  [64] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_function_declaration_repeat1, 2), SHIFT_REPEAT(42),
  [67] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_function_declaration_repeat1, 2), SHIFT_REPEAT(57),
  [70] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_function_declaration_repeat1, 2), SHIFT_REPEAT(55),
  [73] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_function_declaration_repeat1, 2), SHIFT_REPEAT(16),
  [76] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_function_declaration_repeat1, 2), SHIFT_REPEAT(47),
  [79] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_function_declaration_repeat1, 2), SHIFT_REPEAT(46),
  [82] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_function_declaration_repeat1, 2),
  [84] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_elif_statement, 5, .production_id = 12),
  [86] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_elif_statement, 4, .production_id = 10),
  [88] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_else_statement, 2, .production_id = 11),
  [90] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_else_statement, 1),
  [92] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_function_declaration_repeat1, 2), SHIFT_REPEAT(19),
  [95] = {.entry = {.count = 1, .reusable = true}}, SHIFT(35),
  [97] = {.entry = {.count = 1, .reusable = true}}, SHIFT(19),
  [99] = {.entry = {.count = 1, .reusable = true}}, SHIFT(36),
  [101] = {.entry = {.count = 1, .reusable = true}}, SHIFT(18),
  [103] = {.entry = {.count = 1, .reusable = false}}, SHIFT(18),
  [105] = {.entry = {.count = 1, .reusable = true}}, SHIFT(20),
  [107] = {.entry = {.count = 1, .reusable = false}}, SHIFT(20),
  [109] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_endian_statement, 2, .production_id = 3),
  [111] = {.entry = {.count = 1, .reusable = false}}, SHIFT(22),
  [113] = {.entry = {.count = 1, .reusable = true}}, SHIFT(50),
  [115] = {.entry = {.count = 1, .reusable = true}}, SHIFT(24),
  [117] = {.entry = {.count = 1, .reusable = false}}, SHIFT(24),
  [119] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_endian_statement, 2, .production_id = 3),
  [121] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_idstring_statement, 2, .production_id = 4),
  [123] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__expression, 1),
  [125] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_endian_statement, 3, .production_id = 6),
  [127] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_call_statement, 2, .production_id = 2),
  [129] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_statement, 7, .production_id = 14),
  [131] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_statement, 6, .production_id = 13),
  [133] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_set_statement, 3, .production_id = 5),
  [135] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_idstring_statement, 3, .production_id = 7),
  [137] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_statement, 6, .production_id = 12),
  [139] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_print_statement, 2, .production_id = 1),
  [141] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_statement, 5, .production_id = 10),
  [143] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_set_statement, 4, .production_id = 8),
  [145] = {.entry = {.count = 1, .reusable = false}}, SHIFT(51),
  [147] = {.entry = {.count = 1, .reusable = true}}, SHIFT(51),
  [149] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_declaration, 3, .production_id = 2),
  [151] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_declaration, 4, .production_id = 9),
  [153] = {.entry = {.count = 1, .reusable = false}}, SHIFT(52),
  [155] = {.entry = {.count = 1, .reusable = false}}, SHIFT(27),
  [157] = {.entry = {.count = 1, .reusable = true}}, SHIFT(26),
  [159] = {.entry = {.count = 1, .reusable = true}}, SHIFT(25),
  [161] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_if_statement_repeat1, 2), SHIFT_REPEAT(41),
  [164] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_if_statement_repeat1, 2), SHIFT_REPEAT(12),
  [167] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_if_statement_repeat1, 2),
  [169] = {.entry = {.count = 1, .reusable = true}}, SHIFT(33),
  [171] = {.entry = {.count = 1, .reusable = false}}, SHIFT(33),
  [173] = {.entry = {.count = 1, .reusable = true}}, SHIFT(30),
  [175] = {.entry = {.count = 1, .reusable = false}}, SHIFT(30),
  [177] = {.entry = {.count = 1, .reusable = true}}, SHIFT(4),
  [179] = {.entry = {.count = 1, .reusable = false}}, SHIFT(4),
  [181] = {.entry = {.count = 1, .reusable = true}}, SHIFT(10),
  [183] = {.entry = {.count = 1, .reusable = false}}, SHIFT(10),
  [185] = {.entry = {.count = 1, .reusable = true}}, SHIFT(32),
  [187] = {.entry = {.count = 1, .reusable = false}}, SHIFT(32),
  [189] = {.entry = {.count = 1, .reusable = true}}, SHIFT(34),
  [191] = {.entry = {.count = 1, .reusable = false}}, SHIFT(34),
  [193] = {.entry = {.count = 1, .reusable = true}}, SHIFT(53),
  [195] = {.entry = {.count = 1, .reusable = false}}, SHIFT(53),
  [197] = {.entry = {.count = 1, .reusable = false}}, SHIFT(3),
  [199] = {.entry = {.count = 1, .reusable = true}}, SHIFT(49),
  [201] = {.entry = {.count = 1, .reusable = false}}, SHIFT_EXTRA(),
  [203] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_string_literal_repeat1, 2),
  [205] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_string_literal_repeat1, 2), SHIFT_REPEAT(49),
  [208] = {.entry = {.count = 1, .reusable = false}}, SHIFT(2),
  [210] = {.entry = {.count = 1, .reusable = true}}, SHIFT(48),
  [212] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_comparison, 1),
  [214] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_comparison, 1),
  [216] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type, 1),
  [218] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_type, 1),
  [220] = {.entry = {.count = 1, .reusable = true}},  ACCEPT_INPUT(),
  [222] = {.entry = {.count = 1, .reusable = true}}, SHIFT(23),
  [224] = {.entry = {.count = 1, .reusable = true}}, SHIFT(14),
  [226] = {.entry = {.count = 1, .reusable = true}}, SHIFT(37),
};

#ifdef __cplusplus
extern "C" {
#endif
#ifdef _WIN32
#define extern __declspec(dllexport)
#endif

extern const TSLanguage *tree_sitter_quickbms(void) {
  static TSLanguage language = {
    .version = LANGUAGE_VERSION,
    .symbol_count = SYMBOL_COUNT,
    .alias_count = ALIAS_COUNT,
    .token_count = TOKEN_COUNT,
    .external_token_count = EXTERNAL_TOKEN_COUNT,
    .state_count = STATE_COUNT,
    .large_state_count = LARGE_STATE_COUNT,
    .production_id_count = PRODUCTION_ID_COUNT,
    .field_count = FIELD_COUNT,
    .max_alias_sequence_length = MAX_ALIAS_SEQUENCE_LENGTH,
    .parse_table = (const uint16_t *)ts_parse_table,
    .small_parse_table = (const uint16_t *)ts_small_parse_table,
    .small_parse_table_map = (const uint32_t *)ts_small_parse_table_map,
    .parse_actions = ts_parse_actions,
    .symbol_names = ts_symbol_names,
    .field_names = ts_field_names,
    .field_map_slices = (const TSFieldMapSlice *)ts_field_map_slices,
    .field_map_entries = (const TSFieldMapEntry *)ts_field_map_entries,
    .symbol_metadata = ts_symbol_metadata,
    .public_symbol_map = ts_symbol_map,
    .alias_map = ts_non_terminal_alias_map,
    .alias_sequences = (const TSSymbol *)ts_alias_sequences,
    .lex_modes = ts_lex_modes,
    .lex_fn = ts_lex,
  };
  return &language;
}
#ifdef __cplusplus
}
#endif
