# Quick Quantum Simulator

[![Build](https://github.com/swernli/quick-quantum-sim/actions/workflows/build.yml/badge.svg?branch=main)](https://github.com/swernli/quick-quantum-sim/actions/workflows/build.yml)

This is a quantum simulator written purely in Rust. The Quick Quantum Simulator (qqs) uses a combination of first principals and patterns drawn from the full state, sparse state and open system simulators in the Microsoft Quantum Development Kit (see <http://github.com/Microsoft/qsharp-runtime>). While this implementation does try to achieve resonable performance via parallelism and avoiding large memory footprints, at this point the "quick" refers more to the fashion in which it was written than the speed with which it operates.

This repo contains two quantum simulators written as a Rust library with unit tests along with four test binaries that serve both to show how the simulators can be used and act as basic performance benchmarks. The "advantage" benchmarks run on the full state simulator and are based on the same advantage benchmark used for the full state simulator in the qsharp-runtime repo (see [here](https://github.com/microsoft/qsharp-runtime/tree/main/AdvantageBenchmark) for that code). The "ghz" benchmark runs on the sparse state simulator and demonstrates the efficiency of using that approach for highly entangled states.

## Getting Started

Using qqs requiers creating a new simulator instance, allocating one or more qubits, applying gates
to those qubits, measuring them, and then releasing them. For example, simulating using a qubit to
generate a single random bit would look like this:

```rust
use qqs::*;
let mut sim = FullStateQuantumSim::new();
let qubit = sim.allocate();
sim.apply(&common_matrices::h(), &[qubit], None);
let random_bit = sim.measure(qubit);
sim.release(qubit);
```

For more examples of using qqs, see the sample programs implemented in advantage44.rs and ghz.rs that
use the full state simulator and sparse state simulator respectively.

## When should I use `FullStateQuantumSim` vs `SparseStateQuantumSim`?

In general, unless you require high performance simulation of 25 or fewer qubits, you should use the
`SparseStateQuantumSim`. For sufficiently sparse states, it can accomodate up to 128 qubits, and on
dense states it has similar limitations as the `FullStateQuantumSim`. For more information on
the comparison between full state vs sparse state approaches, see [Leveraging state sparsity for more efficient quantum simulations](https://arxiv.org/pdf/2105.01533.pdf).
