#[cfg(debug_assertions)]
fn main() -> Result<(), Box<dyn std::error::Error>> {
    let should_build = std::env::var("BUILD").unwrap_or("0".into());
    if &should_build == "1" {
        tonic_build::configure()
            .build_server(false)
            .out_dir("./src")
            // .type_attribute(".", "#[derive(serde::Serialize, serde::Deserialize)]")
            .compile(
                &["../protos/health.proto", "../protos/core.proto"],
                &["../protos"],
            )?;
    }

    Ok(())
}
