use quakeml;
use structopt::StructOpt;

#[derive(StructOpt)]
struct Cli {
    #[structopt(parse(from_os_str))]
    path: std::path::PathBuf,
}

fn main() {
    let args = Cli::from_args();
    let catalog = quakeml::read_quakeml(&args.path);
    println!("{}", catalog);
}
