---
title: Designing Data-Intensive Applications
tag: data
author: 
created_date: 2021-12-15 19:54:55
updated_date: 2021-12-15 19:54:55
---

豆瓣：https://book.douban.com/subject/30329536/

开源版本：https://github.com/Vonng/ddia

## 简介


全书分为三大部分：

第一部分，主要讨论有关增强数据密集型应用系统所需的若干基本原则。首先开篇第1章即瞄准目标：可靠性、可扩展性与可维护性，如何认识这些问题以及如何达成目标。第2章我们比较了多种不同的数据模型和查询语言，讨论各自的适用场景。接下来第3章主要针对存储引擎，即数据库是如何安排磁盘结构从而提高检索效率。第4章转向数据编码（序列化）方面，包括常见模式的演化历程。

第二部分，我们将从单机的数据存储转向跨机器的分布式系统，这是扩展性的重要一步，但随之而来的是各种挑战。所以将依次讨论数据远程复制（第5章）、数据分区（第6章）以及事务（第7章）。接下来的第8章包括分布式系统的更多细节，以及分布式环境如何达成一致性与共识（第9章）。

第三部分，主要针对产生派生数据的系统，所谓派生数据主要指在异构系统中，如果无法用一个数据源来解决所有问题，那么一种自然的方式就是集成多个不同的数据库、缓存模块以及索引模块等。首先第10章以批处理开始来处理派生数据，紧接着第11章采用流式处理。第12章总结之前介绍的多种技术，并分析讨论未来构建可靠、可扩展和可维护应用系统可能的新方向或方法。

## 中文目录

```@book-toc
前言 .....................................................1
第一部分 数据系统基础
第1章 可靠、可扩展与可维护的应用系统 ................... 11
认识数据系统 ...........................................12
可靠性 ..................................................14
可扩展性 ................................................18
可维护性 ................................................25
小结 .....................................................28
第2章 数据模型与查询语言 ............................... 33
关系模型与文档模型 .......................................34
数据查询语言 ...........................................46
图状数据模型 ......................................52
小结 ...................................................65
第3章 数据存储与检索 .................................. 71
数据库核心：数据结构 ...................................72
事务处理与分析处理 ...................................89
列式存储 .........................................94
小结 ..............................................101
第4章 数据编码与演化 .............................. 109
数据编码格式 .................................... 110
数据流模式 ......................................124
小结 .............................................134
第二部分 分布式数据系统
第5章 数据复制 ................................. 145
主节点与从节点 ..................................146
复制滞后问题 ......................................154
多主节点复制 .......................................160
无主节点复制 .....................................168
小结 ..............................................181
第6章 数据分区 ............................... 189
数据分区与数据复制 .................................190
键-值数据的分区 ...................................190
分区与二级索引 ...................................195
分区再平衡 ....................................198
请求路由 ..................................202
小结 .................................204
第7章 事务 .............................. 211
深入理解事务 ......................................212
弱隔离级别 .................................221
串行化 ...........................................237
小结 ...........................................250
第8章 分布式系统的挑战 ...................... 259
故障与部分失效 ...............................260
不可靠的网络 ..................................262
不可靠的时钟 ..................................271
知识，真相与谎言 ...............................282
小结 ..........................................292
第9章 一致性与共识 ..................... 303
一致性保证 ....................................304
可线性化 ........................................305
顺序保证 ........................................319
分布式事务与共识 .................................330
小结 ...............................................349
第三部分 派生数据
第10章 批处理系统 ................................ 367
使用UNIX工具进行批处理 .............................368
MapReduce与分布式文件系统 .........................375
超越MapReduce ....................................394
小结 ............................................403
第11章 流处理系统 .............................. 413
发送事件流 .......................................414
数据库与流 .......................................424
流处理 .........................................435
小结 ............................................449
第12章 数据系统的未来 ............................ 461
数据集成 .........................................461
分拆数据库 .......................................469
端到端的正确性 ....................................484
做正确的事情 .......................................500
小结 ..............................................509
术语表 ............................................ 521
```

