/* automatically generated by rust-bindgen 0.56.0 */

#[repr(C)]
#[derive(Copy, Clone, Debug, Default, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct __BindgenBitfieldUnit<Storage, Align> {
    storage: Storage,
    align: [Align; 0],
}
impl<Storage, Align> __BindgenBitfieldUnit<Storage, Align> {
    #[inline]
    pub const fn new(storage: Storage) -> Self {
        Self { storage, align: [] }
    }
}
impl<Storage, Align> __BindgenBitfieldUnit<Storage, Align>
where
    Storage: AsRef<[u8]> + AsMut<[u8]>,
{
    #[inline]
    pub fn get_bit(&self, index: usize) -> bool {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = self.storage.as_ref()[byte_index];
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        byte & mask == mask
    }
    #[inline]
    pub fn set_bit(&mut self, index: usize, val: bool) {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = &mut self.storage.as_mut()[byte_index];
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        if val {
            *byte |= mask;
        } else {
            *byte &= !mask;
        }
    }
    #[inline]
    pub fn get(&self, bit_offset: usize, bit_width: u8) -> u64 {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        let mut val = 0;
        for i in 0..(bit_width as usize) {
            if self.get_bit(i + bit_offset) {
                let index = if cfg!(target_endian = "big") {
                    bit_width as usize - 1 - i
                } else {
                    i
                };
                val |= 1 << index;
            }
        }
        val
    }
    #[inline]
    pub fn set(&mut self, bit_offset: usize, bit_width: u8, val: u64) {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        for i in 0..(bit_width as usize) {
            let mask = 1 << i;
            let val_bit_is_set = val & mask == mask;
            let index = if cfg!(target_endian = "big") {
                bit_width as usize - 1 - i
            } else {
                i
            };
            self.set_bit(index + bit_offset, val_bit_is_set);
        }
    }
}
#[repr(C)]
#[derive(Default)]
pub struct __IncompleteArrayField<T>(::std::marker::PhantomData<T>, [T; 0]);
impl<T> __IncompleteArrayField<T> {
    #[inline]
    pub const fn new() -> Self {
        __IncompleteArrayField(::std::marker::PhantomData, [])
    }
    #[inline]
    pub fn as_ptr(&self) -> *const T {
        self as *const _ as *const T
    }
    #[inline]
    pub fn as_mut_ptr(&mut self) -> *mut T {
        self as *mut _ as *mut T
    }
    #[inline]
    pub unsafe fn as_slice(&self, len: usize) -> &[T] {
        ::std::slice::from_raw_parts(self.as_ptr(), len)
    }
    #[inline]
    pub unsafe fn as_mut_slice(&mut self, len: usize) -> &mut [T] {
        ::std::slice::from_raw_parts_mut(self.as_mut_ptr(), len)
    }
}
impl<T> ::std::fmt::Debug for __IncompleteArrayField<T> {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.write_str("__IncompleteArrayField")
    }
}
pub type va_list = __builtin_va_list;
pub type __gnuc_va_list = __builtin_va_list;
extern "C" {
    #[doc = "  \\defgroup Global Global defines and functions"]
    #[doc = "  Global defines and functions."]
    #[doc = "  \\par"]
    #[doc = "  The ALSA library implementation uses these macros and functions."]
    #[doc = "  Most applications probably do not need them."]
    #[doc = "  \\{"]
    pub fn snd_asoundlib_version() -> *const ::std::os::raw::c_char;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct snd_dlsym_link {
    pub next: *mut snd_dlsym_link,
    pub dlsym_name: *const ::std::os::raw::c_char,
    pub dlsym_ptr: *const ::std::os::raw::c_void,
}
extern "C" {
    pub fn snd_dlpath(
        path: *mut ::std::os::raw::c_char,
        path_len: usize,
        name: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_dlopen(
        file: *const ::std::os::raw::c_char,
        mode: ::std::os::raw::c_int,
        errbuf: *mut ::std::os::raw::c_char,
        errbuflen: usize,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn snd_dlsym(
        handle: *mut ::std::os::raw::c_void,
        name: *const ::std::os::raw::c_char,
        version: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn snd_dlclose(handle: *mut ::std::os::raw::c_void) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _snd_async_handler {
    _unused: [u8; 0],
}
#[doc = " \\brief Internal structure for an async notification client handler."]
#[doc = ""]
#[doc = " The ALSA library uses a pointer to this structure as a handle to an async"]
#[doc = " notification object. Applications don't access its contents directly."]
pub type snd_async_handler_t = _snd_async_handler;
#[doc = " \\brief Async notification callback."]
#[doc = ""]
#[doc = " See the #snd_async_add_handler function for details."]
pub type snd_async_callback_t =
    ::std::option::Option<unsafe extern "C" fn(handler: *mut snd_async_handler_t)>;
extern "C" {
    pub fn snd_async_add_handler(
        handler: *mut *mut snd_async_handler_t,
        fd: ::std::os::raw::c_int,
        callback: snd_async_callback_t,
        private_data: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_async_del_handler(handler: *mut snd_async_handler_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_async_handler_get_fd(handler: *mut snd_async_handler_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_async_handler_get_signo(handler: *mut snd_async_handler_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_async_handler_get_callback_private(
        handler: *mut snd_async_handler_t,
    ) -> *mut ::std::os::raw::c_void;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct snd_shm_area {
    _unused: [u8; 0],
}
extern "C" {
    pub fn snd_shm_area_create(
        shmid: ::std::os::raw::c_int,
        ptr: *mut ::std::os::raw::c_void,
    ) -> *mut snd_shm_area;
}
extern "C" {
    pub fn snd_shm_area_share(area: *mut snd_shm_area) -> *mut snd_shm_area;
}
extern "C" {
    pub fn snd_shm_area_destroy(area: *mut snd_shm_area) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_user_file(
        file: *const ::std::os::raw::c_char,
        result: *mut *mut ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
#[doc = " Timestamp"]
pub type snd_timestamp_t = timeval;
#[doc = " Hi-res timestamp"]
pub type snd_htimestamp_t = timespec;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _snd_input {
    _unused: [u8; 0],
}
#[doc = " \\brief Internal structure for an input object."]
#[doc = ""]
#[doc = " The ALSA library uses a pointer to this structure as a handle to an"]
#[doc = " input object. Applications don't access its contents directly."]
pub type snd_input_t = _snd_input;
#[doc = " Input from a stdio stream."]
pub const SND_INPUT_STDIO: _snd_input_type = 0;
#[doc = " Input from a memory buffer."]
pub const SND_INPUT_BUFFER: _snd_input_type = 1;
#[doc = " Input type."]
pub type _snd_input_type = ::std::os::raw::c_uint;
#[doc = " Input type."]
pub use self::_snd_input_type as snd_input_type_t;
extern "C" {
    pub fn snd_input_stdio_open(
        inputp: *mut *mut snd_input_t,
        file: *const ::std::os::raw::c_char,
        mode: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_input_stdio_attach(
        inputp: *mut *mut snd_input_t,
        fp: *mut FILE,
        _close: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_input_buffer_open(
        inputp: *mut *mut snd_input_t,
        buffer: *const ::std::os::raw::c_char,
        size: isize,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_input_close(input: *mut snd_input_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_input_scanf(
        input: *mut snd_input_t,
        format: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_input_gets(
        input: *mut snd_input_t,
        str_: *mut ::std::os::raw::c_char,
        size: usize,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn snd_input_getc(input: *mut snd_input_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_input_ungetc(
        input: *mut snd_input_t,
        c: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _snd_output {
    _unused: [u8; 0],
}
#[doc = " \\brief Internal structure for an output object."]
#[doc = ""]
#[doc = " The ALSA library uses a pointer to this structure as a handle to an"]
#[doc = " output object. Applications don't access its contents directly."]
pub type snd_output_t = _snd_output;
#[doc = " Output to a stdio stream."]
pub const SND_OUTPUT_STDIO: _snd_output_type = 0;
#[doc = " Output to a memory buffer."]
pub const SND_OUTPUT_BUFFER: _snd_output_type = 1;
#[doc = " Output type."]
pub type _snd_output_type = ::std::os::raw::c_uint;
#[doc = " Output type."]
pub use self::_snd_output_type as snd_output_type_t;
extern "C" {
    pub fn snd_output_stdio_open(
        outputp: *mut *mut snd_output_t,
        file: *const ::std::os::raw::c_char,
        mode: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_output_stdio_attach(
        outputp: *mut *mut snd_output_t,
        fp: *mut FILE,
        _close: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_output_buffer_open(outputp: *mut *mut snd_output_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_output_buffer_string(
        output: *mut snd_output_t,
        buf: *mut *mut ::std::os::raw::c_char,
    ) -> usize;
}
extern "C" {
    pub fn snd_output_close(output: *mut snd_output_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_output_printf(
        output: *mut snd_output_t,
        format: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_output_vprintf(
        output: *mut snd_output_t,
        format: *const ::std::os::raw::c_char,
        args: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_output_puts(
        output: *mut snd_output_t,
        str_: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_output_putc(
        output: *mut snd_output_t,
        c: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_output_flush(output: *mut snd_output_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_strerror(errnum: ::std::os::raw::c_int) -> *const ::std::os::raw::c_char;
}
#[doc = " \\brief Error handler callback."]
#[doc = " \\param file Source file name."]
#[doc = " \\param line Line number."]
#[doc = " \\param function Function name."]
#[doc = " \\param err Value of \\c errno, or 0 if not relevant."]
#[doc = " \\param fmt \\c printf(3) format."]
#[doc = " \\param ... \\c printf(3) arguments."]
#[doc = ""]
#[doc = " A function of this type is called by the ALSA library when an error occurs."]
#[doc = " This function usually shows the message on the screen, and/or logs it."]
pub type snd_lib_error_handler_t = ::std::option::Option<
    unsafe extern "C" fn(
        file: *const ::std::os::raw::c_char,
        line: ::std::os::raw::c_int,
        function: *const ::std::os::raw::c_char,
        err: ::std::os::raw::c_int,
        fmt: *const ::std::os::raw::c_char,
        ...
    ),
>;
extern "C" {
    pub fn snd_lib_error_set_handler(handler: snd_lib_error_handler_t) -> ::std::os::raw::c_int;
}
#[doc = " Local error handler function type"]
pub type snd_local_error_handler_t = ::std::option::Option<
    unsafe extern "C" fn(
        file: *const ::std::os::raw::c_char,
        line: ::std::os::raw::c_int,
        func: *const ::std::os::raw::c_char,
        err: ::std::os::raw::c_int,
        fmt: *const ::std::os::raw::c_char,
        arg: *mut __va_list_tag,
    ),
>;
extern "C" {
    pub fn snd_lib_error_set_local(func: snd_local_error_handler_t) -> snd_local_error_handler_t;
}
#[doc = " Integer number."]
pub const SND_CONFIG_TYPE_INTEGER: _snd_config_type = 0;
#[doc = " 64-bit integer number."]
pub const SND_CONFIG_TYPE_INTEGER64: _snd_config_type = 1;
#[doc = " Real number."]
pub const SND_CONFIG_TYPE_REAL: _snd_config_type = 2;
#[doc = " Character string."]
pub const SND_CONFIG_TYPE_STRING: _snd_config_type = 3;
#[doc = " Pointer (runtime only, cannot be saved)."]
pub const SND_CONFIG_TYPE_POINTER: _snd_config_type = 4;
#[doc = " Compound node."]
pub const SND_CONFIG_TYPE_COMPOUND: _snd_config_type = 1024;
#[doc = " \\brief Configuration node type."]
pub type _snd_config_type = ::std::os::raw::c_uint;
#[doc = " \\brief Configuration node type."]
pub use self::_snd_config_type as snd_config_type_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _snd_config {
    _unused: [u8; 0],
}
#[doc = " \\brief Internal structure for a configuration node object."]
#[doc = ""]
#[doc = " The ALSA library uses a pointer to this structure as a handle to a"]
#[doc = " configuration node. Applications don't access its contents directly."]
pub type snd_config_t = _snd_config;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _snd_config_iterator {
    _unused: [u8; 0],
}
#[doc = " \\brief Type for a configuration compound iterator."]
#[doc = ""]
#[doc = " The ALSA library uses this pointer type as a handle to a configuration"]
#[doc = " compound iterator. Applications don't directly access the contents of"]
#[doc = " the structure pointed to by this type."]
pub type snd_config_iterator_t = *mut _snd_config_iterator;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _snd_config_update {
    _unused: [u8; 0],
}
#[doc = " \\brief Internal structure for a configuration private update object."]
#[doc = ""]
#[doc = " The ALSA library uses this structure to save private update information."]
pub type snd_config_update_t = _snd_config_update;
extern "C" {
    pub fn snd_config_topdir() -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn snd_config_top(config: *mut *mut snd_config_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_config_load(
        config: *mut snd_config_t,
        in_: *mut snd_input_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_config_load_override(
        config: *mut snd_config_t,
        in_: *mut snd_input_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_config_save(
        config: *mut snd_config_t,
        out: *mut snd_output_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_config_update() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_config_update_r(
        top: *mut *mut snd_config_t,
        update: *mut *mut snd_config_update_t,
        path: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_config_update_free(update: *mut snd_config_update_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_config_update_free_global() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_config_update_ref(top: *mut *mut snd_config_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_config_ref(top: *mut snd_config_t);
}
extern "C" {
    pub fn snd_config_unref(top: *mut snd_config_t);
}
extern "C" {
    pub fn snd_config_search(
        config: *mut snd_config_t,
        key: *const ::std::os::raw::c_char,
        result: *mut *mut snd_config_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_config_searchv(
        config: *mut snd_config_t,
        result: *mut *mut snd_config_t,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_config_search_definition(
        config: *mut snd_config_t,
        base: *const ::std::os::raw::c_char,
        key: *const ::std::os::raw::c_char,
        result: *mut *mut snd_config_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_config_expand(
        config: *mut snd_config_t,
        root: *mut snd_config_t,
        args: *const ::std::os::raw::c_char,
        private_data: *mut snd_config_t,
        result: *mut *mut snd_config_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_config_evaluate(
        config: *mut snd_config_t,
        root: *mut snd_config_t,
        private_data: *mut snd_config_t,
        result: *mut *mut snd_config_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_config_add(
        config: *mut snd_config_t,
        child: *mut snd_config_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_config_add_before(
        before: *mut snd_config_t,
        child: *mut snd_config_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_config_add_after(
        after: *mut snd_config_t,
        child: *mut snd_config_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_config_remove(config: *mut snd_config_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_config_delete(config: *mut snd_config_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_config_delete_compound_members(config: *const snd_config_t)
        -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_config_copy(
        dst: *mut *mut snd_config_t,
        src: *mut snd_config_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_config_make(
        config: *mut *mut snd_config_t,
        key: *const ::std::os::raw::c_char,
        type_: snd_config_type_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_config_make_integer(
        config: *mut *mut snd_config_t,
        key: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_config_make_integer64(
        config: *mut *mut snd_config_t,
        key: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_config_make_real(
        config: *mut *mut snd_config_t,
        key: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_config_make_string(
        config: *mut *mut snd_config_t,
        key: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_config_make_pointer(
        config: *mut *mut snd_config_t,
        key: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_config_make_compound(
        config: *mut *mut snd_config_t,
        key: *const ::std::os::raw::c_char,
        join: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_config_imake_integer(
        config: *mut *mut snd_config_t,
        key: *const ::std::os::raw::c_char,
        value: ::std::os::raw::c_long,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_config_imake_integer64(
        config: *mut *mut snd_config_t,
        key: *const ::std::os::raw::c_char,
        value: ::std::os::raw::c_longlong,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_config_imake_real(
        config: *mut *mut snd_config_t,
        key: *const ::std::os::raw::c_char,
        value: f64,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_config_imake_string(
        config: *mut *mut snd_config_t,
        key: *const ::std::os::raw::c_char,
        ascii: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_config_imake_safe_string(
        config: *mut *mut snd_config_t,
        key: *const ::std::os::raw::c_char,
        ascii: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_config_imake_pointer(
        config: *mut *mut snd_config_t,
        key: *const ::std::os::raw::c_char,
        ptr: *const ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_config_get_type(config: *const snd_config_t) -> snd_config_type_t;
}
extern "C" {
    pub fn snd_config_is_array(config: *const snd_config_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_config_set_id(
        config: *mut snd_config_t,
        id: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_config_set_integer(
        config: *mut snd_config_t,
        value: ::std::os::raw::c_long,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_config_set_integer64(
        config: *mut snd_config_t,
        value: ::std::os::raw::c_longlong,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_config_set_real(config: *mut snd_config_t, value: f64) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_config_set_string(
        config: *mut snd_config_t,
        value: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_config_set_ascii(
        config: *mut snd_config_t,
        ascii: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_config_set_pointer(
        config: *mut snd_config_t,
        ptr: *const ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_config_get_id(
        config: *const snd_config_t,
        value: *mut *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_config_get_integer(
        config: *const snd_config_t,
        value: *mut ::std::os::raw::c_long,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_config_get_integer64(
        config: *const snd_config_t,
        value: *mut ::std::os::raw::c_longlong,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_config_get_real(
        config: *const snd_config_t,
        value: *mut f64,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_config_get_ireal(
        config: *const snd_config_t,
        value: *mut f64,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_config_get_string(
        config: *const snd_config_t,
        value: *mut *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_config_get_ascii(
        config: *const snd_config_t,
        value: *mut *mut ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_config_get_pointer(
        config: *const snd_config_t,
        value: *mut *const ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_config_test_id(
        config: *const snd_config_t,
        id: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_config_iterator_first(node: *const snd_config_t) -> snd_config_iterator_t;
}
extern "C" {
    pub fn snd_config_iterator_next(iterator: snd_config_iterator_t) -> snd_config_iterator_t;
}
extern "C" {
    pub fn snd_config_iterator_end(node: *const snd_config_t) -> snd_config_iterator_t;
}
extern "C" {
    pub fn snd_config_iterator_entry(iterator: snd_config_iterator_t) -> *mut snd_config_t;
}
extern "C" {
    pub fn snd_config_get_bool_ascii(ascii: *const ::std::os::raw::c_char)
        -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_config_get_bool(conf: *const snd_config_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_config_get_ctl_iface_ascii(
        ascii: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_config_get_ctl_iface(conf: *const snd_config_t) -> ::std::os::raw::c_int;
}
#[doc = " Device-name list element"]
pub type snd_devname_t = snd_devname;
#[doc = " Device-name list element (definition)"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct snd_devname {
    #[doc = "< Device name string"]
    pub name: *mut ::std::os::raw::c_char,
    #[doc = "< Comments"]
    pub comment: *mut ::std::os::raw::c_char,
    #[doc = "< Next pointer"]
    pub next: *mut snd_devname_t,
}
extern "C" {
    pub fn snd_names_list(
        iface: *const ::std::os::raw::c_char,
        list: *mut *mut snd_devname_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_names_list_free(list: *mut snd_devname_t);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _snd_pcm_info {
    _unused: [u8; 0],
}
#[doc = " PCM generic info container"]
pub type snd_pcm_info_t = _snd_pcm_info;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _snd_pcm_hw_params {
    _unused: [u8; 0],
}
#[doc = " PCM hardware configuration space container"]
#[doc = ""]
#[doc = "  snd_pcm_hw_params_t is an opaque structure which contains a set of possible"]
#[doc = "  PCM hardware configurations. For example, a given instance might include a"]
#[doc = "  range of buffer sizes, a range of period sizes, and a set of several sample"]
#[doc = "  formats. Some subset of all possible combinations these sets may be valid,"]
#[doc = "  but not necessarily any combination will be valid."]
#[doc = ""]
#[doc = "  When a parameter is set or restricted using a snd_pcm_hw_params_set*"]
#[doc = "  function, all of the other ranges will be updated to exclude as many"]
#[doc = "  impossible configurations as possible. Attempting to set a parameter"]
#[doc = "  outside of its acceptable range will result in the function failing"]
#[doc = "  and an error code being returned."]
pub type snd_pcm_hw_params_t = _snd_pcm_hw_params;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _snd_pcm_sw_params {
    _unused: [u8; 0],
}
#[doc = " PCM software configuration container"]
pub type snd_pcm_sw_params_t = _snd_pcm_sw_params;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _snd_pcm_status {
    _unused: [u8; 0],
}
#[doc = " PCM status container"]
pub type snd_pcm_status_t = _snd_pcm_status;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _snd_pcm_access_mask {
    _unused: [u8; 0],
}
#[doc = " PCM access types mask"]
pub type snd_pcm_access_mask_t = _snd_pcm_access_mask;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _snd_pcm_format_mask {
    _unused: [u8; 0],
}
#[doc = " PCM formats mask"]
pub type snd_pcm_format_mask_t = _snd_pcm_format_mask;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _snd_pcm_subformat_mask {
    _unused: [u8; 0],
}
#[doc = " PCM subformats mask"]
pub type snd_pcm_subformat_mask_t = _snd_pcm_subformat_mask;
#[doc = " standard device"]
pub const SND_PCM_CLASS_GENERIC: _snd_pcm_class = 0;
#[doc = " multichannel device"]
pub const SND_PCM_CLASS_MULTI: _snd_pcm_class = 1;
#[doc = " software modem device"]
pub const SND_PCM_CLASS_MODEM: _snd_pcm_class = 2;
#[doc = " digitizer device"]
pub const SND_PCM_CLASS_DIGITIZER: _snd_pcm_class = 3;
#[doc = " digitizer device"]
pub const SND_PCM_CLASS_LAST: _snd_pcm_class = 3;
#[doc = " PCM class"]
pub type _snd_pcm_class = ::std::os::raw::c_uint;
#[doc = " PCM class"]
pub use self::_snd_pcm_class as snd_pcm_class_t;
#[doc = " subdevices are mixed together"]
pub const SND_PCM_SUBCLASS_GENERIC_MIX: _snd_pcm_subclass = 0;
#[doc = " multichannel subdevices are mixed together"]
pub const SND_PCM_SUBCLASS_MULTI_MIX: _snd_pcm_subclass = 1;
#[doc = " multichannel subdevices are mixed together"]
pub const SND_PCM_SUBCLASS_LAST: _snd_pcm_subclass = 1;
#[doc = " PCM subclass"]
pub type _snd_pcm_subclass = ::std::os::raw::c_uint;
#[doc = " PCM subclass"]
pub use self::_snd_pcm_subclass as snd_pcm_subclass_t;
#[doc = " Playback stream"]
pub const SND_PCM_STREAM_PLAYBACK: _snd_pcm_stream = 0;
#[doc = " Capture stream"]
pub const SND_PCM_STREAM_CAPTURE: _snd_pcm_stream = 1;
#[doc = " Capture stream"]
pub const SND_PCM_STREAM_LAST: _snd_pcm_stream = 1;
#[doc = " PCM stream (direction)"]
pub type _snd_pcm_stream = ::std::os::raw::c_uint;
#[doc = " PCM stream (direction)"]
pub use self::_snd_pcm_stream as snd_pcm_stream_t;
#[doc = " mmap access with simple interleaved channels"]
pub const SND_PCM_ACCESS_MMAP_INTERLEAVED: _snd_pcm_access = 0;
#[doc = " mmap access with simple non interleaved channels"]
pub const SND_PCM_ACCESS_MMAP_NONINTERLEAVED: _snd_pcm_access = 1;
#[doc = " mmap access with complex placement"]
pub const SND_PCM_ACCESS_MMAP_COMPLEX: _snd_pcm_access = 2;
#[doc = " snd_pcm_readi/snd_pcm_writei access"]
pub const SND_PCM_ACCESS_RW_INTERLEAVED: _snd_pcm_access = 3;
#[doc = " snd_pcm_readn/snd_pcm_writen access"]
pub const SND_PCM_ACCESS_RW_NONINTERLEAVED: _snd_pcm_access = 4;
#[doc = " snd_pcm_readn/snd_pcm_writen access"]
pub const SND_PCM_ACCESS_LAST: _snd_pcm_access = 4;
#[doc = " PCM access type"]
pub type _snd_pcm_access = ::std::os::raw::c_uint;
#[doc = " PCM access type"]
pub use self::_snd_pcm_access as snd_pcm_access_t;
#[doc = " Unknown"]
pub const SND_PCM_FORMAT_UNKNOWN: _snd_pcm_format = -1;
#[doc = " Signed 8 bit"]
pub const SND_PCM_FORMAT_S8: _snd_pcm_format = 0;
#[doc = " Unsigned 8 bit"]
pub const SND_PCM_FORMAT_U8: _snd_pcm_format = 1;
#[doc = " Signed 16 bit Little Endian"]
pub const SND_PCM_FORMAT_S16_LE: _snd_pcm_format = 2;
#[doc = " Signed 16 bit Big Endian"]
pub const SND_PCM_FORMAT_S16_BE: _snd_pcm_format = 3;
#[doc = " Unsigned 16 bit Little Endian"]
pub const SND_PCM_FORMAT_U16_LE: _snd_pcm_format = 4;
#[doc = " Unsigned 16 bit Big Endian"]
pub const SND_PCM_FORMAT_U16_BE: _snd_pcm_format = 5;
#[doc = " Signed 24 bit Little Endian using low three bytes in 32-bit word"]
pub const SND_PCM_FORMAT_S24_LE: _snd_pcm_format = 6;
#[doc = " Signed 24 bit Big Endian using low three bytes in 32-bit word"]
pub const SND_PCM_FORMAT_S24_BE: _snd_pcm_format = 7;
#[doc = " Unsigned 24 bit Little Endian using low three bytes in 32-bit word"]
pub const SND_PCM_FORMAT_U24_LE: _snd_pcm_format = 8;
#[doc = " Unsigned 24 bit Big Endian using low three bytes in 32-bit word"]
pub const SND_PCM_FORMAT_U24_BE: _snd_pcm_format = 9;
#[doc = " Signed 32 bit Little Endian"]
pub const SND_PCM_FORMAT_S32_LE: _snd_pcm_format = 10;
#[doc = " Signed 32 bit Big Endian"]
pub const SND_PCM_FORMAT_S32_BE: _snd_pcm_format = 11;
#[doc = " Unsigned 32 bit Little Endian"]
pub const SND_PCM_FORMAT_U32_LE: _snd_pcm_format = 12;
#[doc = " Unsigned 32 bit Big Endian"]
pub const SND_PCM_FORMAT_U32_BE: _snd_pcm_format = 13;
#[doc = " Float 32 bit Little Endian, Range -1.0 to 1.0"]
pub const SND_PCM_FORMAT_FLOAT_LE: _snd_pcm_format = 14;
#[doc = " Float 32 bit Big Endian, Range -1.0 to 1.0"]
pub const SND_PCM_FORMAT_FLOAT_BE: _snd_pcm_format = 15;
#[doc = " Float 64 bit Little Endian, Range -1.0 to 1.0"]
pub const SND_PCM_FORMAT_FLOAT64_LE: _snd_pcm_format = 16;
#[doc = " Float 64 bit Big Endian, Range -1.0 to 1.0"]
pub const SND_PCM_FORMAT_FLOAT64_BE: _snd_pcm_format = 17;
#[doc = " IEC-958 Little Endian"]
pub const SND_PCM_FORMAT_IEC958_SUBFRAME_LE: _snd_pcm_format = 18;
#[doc = " IEC-958 Big Endian"]
pub const SND_PCM_FORMAT_IEC958_SUBFRAME_BE: _snd_pcm_format = 19;
#[doc = " Mu-Law"]
pub const SND_PCM_FORMAT_MU_LAW: _snd_pcm_format = 20;
#[doc = " A-Law"]
pub const SND_PCM_FORMAT_A_LAW: _snd_pcm_format = 21;
#[doc = " Ima-ADPCM"]
pub const SND_PCM_FORMAT_IMA_ADPCM: _snd_pcm_format = 22;
#[doc = " MPEG"]
pub const SND_PCM_FORMAT_MPEG: _snd_pcm_format = 23;
#[doc = " GSM"]
pub const SND_PCM_FORMAT_GSM: _snd_pcm_format = 24;
#[doc = " Signed 20bit Little Endian in 4bytes format, LSB justified"]
pub const SND_PCM_FORMAT_S20_LE: _snd_pcm_format = 25;
#[doc = " Signed 20bit Big Endian in 4bytes format, LSB justified"]
pub const SND_PCM_FORMAT_S20_BE: _snd_pcm_format = 26;
#[doc = " Unsigned 20bit Little Endian in 4bytes format, LSB justified"]
pub const SND_PCM_FORMAT_U20_LE: _snd_pcm_format = 27;
#[doc = " Unsigned 20bit Big Endian in 4bytes format, LSB justified"]
pub const SND_PCM_FORMAT_U20_BE: _snd_pcm_format = 28;
#[doc = " Special"]
pub const SND_PCM_FORMAT_SPECIAL: _snd_pcm_format = 31;
#[doc = " Signed 24bit Little Endian in 3bytes format"]
pub const SND_PCM_FORMAT_S24_3LE: _snd_pcm_format = 32;
#[doc = " Signed 24bit Big Endian in 3bytes format"]
pub const SND_PCM_FORMAT_S24_3BE: _snd_pcm_format = 33;
#[doc = " Unsigned 24bit Little Endian in 3bytes format"]
pub const SND_PCM_FORMAT_U24_3LE: _snd_pcm_format = 34;
#[doc = " Unsigned 24bit Big Endian in 3bytes format"]
pub const SND_PCM_FORMAT_U24_3BE: _snd_pcm_format = 35;
#[doc = " Signed 20bit Little Endian in 3bytes format"]
pub const SND_PCM_FORMAT_S20_3LE: _snd_pcm_format = 36;
#[doc = " Signed 20bit Big Endian in 3bytes format"]
pub const SND_PCM_FORMAT_S20_3BE: _snd_pcm_format = 37;
#[doc = " Unsigned 20bit Little Endian in 3bytes format"]
pub const SND_PCM_FORMAT_U20_3LE: _snd_pcm_format = 38;
#[doc = " Unsigned 20bit Big Endian in 3bytes format"]
pub const SND_PCM_FORMAT_U20_3BE: _snd_pcm_format = 39;
#[doc = " Signed 18bit Little Endian in 3bytes format"]
pub const SND_PCM_FORMAT_S18_3LE: _snd_pcm_format = 40;
#[doc = " Signed 18bit Big Endian in 3bytes format"]
pub const SND_PCM_FORMAT_S18_3BE: _snd_pcm_format = 41;
#[doc = " Unsigned 18bit Little Endian in 3bytes format"]
pub const SND_PCM_FORMAT_U18_3LE: _snd_pcm_format = 42;
#[doc = " Unsigned 18bit Big Endian in 3bytes format"]
pub const SND_PCM_FORMAT_U18_3BE: _snd_pcm_format = 43;
#[doc = " Unsigned 18bit Big Endian in 3bytes format"]
pub const SND_PCM_FORMAT_G723_24: _snd_pcm_format = 44;
#[doc = " Unsigned 18bit Big Endian in 3bytes format"]
pub const SND_PCM_FORMAT_G723_24_1B: _snd_pcm_format = 45;
#[doc = " Unsigned 18bit Big Endian in 3bytes format"]
pub const SND_PCM_FORMAT_G723_40: _snd_pcm_format = 46;
#[doc = " Unsigned 18bit Big Endian in 3bytes format"]
pub const SND_PCM_FORMAT_G723_40_1B: _snd_pcm_format = 47;
#[doc = " Unsigned 18bit Big Endian in 3bytes format"]
pub const SND_PCM_FORMAT_DSD_U8: _snd_pcm_format = 48;
#[doc = " Unsigned 18bit Big Endian in 3bytes format"]
pub const SND_PCM_FORMAT_DSD_U16_LE: _snd_pcm_format = 49;
#[doc = " Unsigned 18bit Big Endian in 3bytes format"]
pub const SND_PCM_FORMAT_DSD_U32_LE: _snd_pcm_format = 50;
#[doc = " Unsigned 18bit Big Endian in 3bytes format"]
pub const SND_PCM_FORMAT_DSD_U16_BE: _snd_pcm_format = 51;
#[doc = " Unsigned 18bit Big Endian in 3bytes format"]
pub const SND_PCM_FORMAT_DSD_U32_BE: _snd_pcm_format = 52;
#[doc = " Unsigned 18bit Big Endian in 3bytes format"]
pub const SND_PCM_FORMAT_LAST: _snd_pcm_format = 52;
#[doc = " Signed 16 bit CPU endian"]
pub const SND_PCM_FORMAT_S16: _snd_pcm_format = 2;
#[doc = " Unsigned 16 bit CPU endian"]
pub const SND_PCM_FORMAT_U16: _snd_pcm_format = 4;
#[doc = " Signed 24 bit CPU endian"]
pub const SND_PCM_FORMAT_S24: _snd_pcm_format = 6;
#[doc = " Unsigned 24 bit CPU endian"]
pub const SND_PCM_FORMAT_U24: _snd_pcm_format = 8;
#[doc = " Signed 32 bit CPU endian"]
pub const SND_PCM_FORMAT_S32: _snd_pcm_format = 10;
#[doc = " Unsigned 32 bit CPU endian"]
pub const SND_PCM_FORMAT_U32: _snd_pcm_format = 12;
#[doc = " Float 32 bit CPU endian"]
pub const SND_PCM_FORMAT_FLOAT: _snd_pcm_format = 14;
#[doc = " Float 64 bit CPU endian"]
pub const SND_PCM_FORMAT_FLOAT64: _snd_pcm_format = 16;
#[doc = " IEC-958 CPU Endian"]
pub const SND_PCM_FORMAT_IEC958_SUBFRAME: _snd_pcm_format = 18;
#[doc = " Signed 20bit in 4bytes format, LSB justified, CPU Endian"]
pub const SND_PCM_FORMAT_S20: _snd_pcm_format = 25;
#[doc = " Unsigned 20bit in 4bytes format, LSB justified, CPU Endian"]
pub const SND_PCM_FORMAT_U20: _snd_pcm_format = 27;
#[doc = " PCM sample format"]
pub type _snd_pcm_format = ::std::os::raw::c_int;
#[doc = " PCM sample format"]
pub use self::_snd_pcm_format as snd_pcm_format_t;
#[doc = " Standard"]
pub const SND_PCM_SUBFORMAT_STD: _snd_pcm_subformat = 0;
#[doc = " Standard"]
pub const SND_PCM_SUBFORMAT_LAST: _snd_pcm_subformat = 0;
#[doc = " PCM sample subformat"]
pub type _snd_pcm_subformat = ::std::os::raw::c_uint;
#[doc = " PCM sample subformat"]
pub use self::_snd_pcm_subformat as snd_pcm_subformat_t;
#[doc = " Open"]
pub const SND_PCM_STATE_OPEN: _snd_pcm_state = 0;
#[doc = " Setup installed"]
pub const SND_PCM_STATE_SETUP: _snd_pcm_state = 1;
#[doc = " Ready to start"]
pub const SND_PCM_STATE_PREPARED: _snd_pcm_state = 2;
#[doc = " Running"]
pub const SND_PCM_STATE_RUNNING: _snd_pcm_state = 3;
#[doc = " Stopped: underrun (playback) or overrun (capture) detected"]
pub const SND_PCM_STATE_XRUN: _snd_pcm_state = 4;
#[doc = " Draining: running (playback) or stopped (capture)"]
pub const SND_PCM_STATE_DRAINING: _snd_pcm_state = 5;
#[doc = " Paused"]
pub const SND_PCM_STATE_PAUSED: _snd_pcm_state = 6;
#[doc = " Hardware is suspended"]
pub const SND_PCM_STATE_SUSPENDED: _snd_pcm_state = 7;
#[doc = " Hardware is disconnected"]
pub const SND_PCM_STATE_DISCONNECTED: _snd_pcm_state = 8;
#[doc = " Hardware is disconnected"]
pub const SND_PCM_STATE_LAST: _snd_pcm_state = 8;
#[doc = " Private - used internally in the library - do not use"]
pub const SND_PCM_STATE_PRIVATE1: _snd_pcm_state = 1024;
#[doc = " PCM state"]
pub type _snd_pcm_state = ::std::os::raw::c_uint;
#[doc = " PCM state"]
pub use self::_snd_pcm_state as snd_pcm_state_t;
#[doc = " Automatic start on data read/write"]
pub const SND_PCM_START_DATA: _snd_pcm_start = 0;
#[doc = " Explicit start"]
pub const SND_PCM_START_EXPLICIT: _snd_pcm_start = 1;
#[doc = " Explicit start"]
pub const SND_PCM_START_LAST: _snd_pcm_start = 1;
#[doc = " PCM start mode"]
pub type _snd_pcm_start = ::std::os::raw::c_uint;
#[doc = " PCM start mode"]
pub use self::_snd_pcm_start as snd_pcm_start_t;
#[doc = " Xrun detection disabled"]
pub const SND_PCM_XRUN_NONE: _snd_pcm_xrun = 0;
#[doc = " Stop on xrun detection"]
pub const SND_PCM_XRUN_STOP: _snd_pcm_xrun = 1;
#[doc = " Stop on xrun detection"]
pub const SND_PCM_XRUN_LAST: _snd_pcm_xrun = 1;
#[doc = " PCM xrun mode"]
pub type _snd_pcm_xrun = ::std::os::raw::c_uint;
#[doc = " PCM xrun mode"]
pub use self::_snd_pcm_xrun as snd_pcm_xrun_t;
#[doc = " No timestamp"]
pub const SND_PCM_TSTAMP_NONE: _snd_pcm_tstamp = 0;
#[doc = " Update timestamp at every hardware position update"]
pub const SND_PCM_TSTAMP_ENABLE: _snd_pcm_tstamp = 1;
#[doc = " Equivalent with #SND_PCM_TSTAMP_ENABLE,"]
#[doc = " just for compatibility with older versions"]
pub const SND_PCM_TSTAMP_MMAP: _snd_pcm_tstamp = 1;
#[doc = " Equivalent with #SND_PCM_TSTAMP_ENABLE,"]
#[doc = " just for compatibility with older versions"]
pub const SND_PCM_TSTAMP_LAST: _snd_pcm_tstamp = 1;
#[doc = " PCM timestamp mode"]
pub type _snd_pcm_tstamp = ::std::os::raw::c_uint;
#[doc = " PCM timestamp mode"]
pub use self::_snd_pcm_tstamp as snd_pcm_tstamp_t;
#[doc = "< gettimeofday equivalent"]
pub const SND_PCM_TSTAMP_TYPE_GETTIMEOFDAY: _snd_pcm_tstamp_type = 0;
#[doc = "< posix_clock_monotonic equivalent"]
pub const SND_PCM_TSTAMP_TYPE_MONOTONIC: _snd_pcm_tstamp_type = 1;
#[doc = "< monotonic_raw (no NTP)"]
pub const SND_PCM_TSTAMP_TYPE_MONOTONIC_RAW: _snd_pcm_tstamp_type = 2;
pub const SND_PCM_TSTAMP_TYPE_LAST: _snd_pcm_tstamp_type = 2;
pub type _snd_pcm_tstamp_type = ::std::os::raw::c_uint;
pub use self::_snd_pcm_tstamp_type as snd_pcm_tstamp_type_t;
#[doc = " first definition for backwards compatibility only,"]
#[doc = " maps to wallclock/link time for HDAudio playback and DEFAULT/DMA time for everything else"]
pub const SND_PCM_AUDIO_TSTAMP_TYPE_COMPAT: _snd_pcm_audio_tstamp_type = 0;
#[doc = "< DMA time, reported as per hw_ptr"]
pub const SND_PCM_AUDIO_TSTAMP_TYPE_DEFAULT: _snd_pcm_audio_tstamp_type = 1;
#[doc = "< link time reported by sample or wallclock counter, reset on startup"]
pub const SND_PCM_AUDIO_TSTAMP_TYPE_LINK: _snd_pcm_audio_tstamp_type = 2;
#[doc = "< link time reported by sample or wallclock counter, not reset on startup"]
pub const SND_PCM_AUDIO_TSTAMP_TYPE_LINK_ABSOLUTE: _snd_pcm_audio_tstamp_type = 3;
#[doc = "< link time estimated indirectly"]
pub const SND_PCM_AUDIO_TSTAMP_TYPE_LINK_ESTIMATED: _snd_pcm_audio_tstamp_type = 4;
#[doc = "< link time synchronized with system time"]
pub const SND_PCM_AUDIO_TSTAMP_TYPE_LINK_SYNCHRONIZED: _snd_pcm_audio_tstamp_type = 5;
pub const SND_PCM_AUDIO_TSTAMP_TYPE_LAST: _snd_pcm_audio_tstamp_type = 5;
pub type _snd_pcm_audio_tstamp_type = ::std::os::raw::c_uint;
pub use self::_snd_pcm_audio_tstamp_type as snd_pcm_audio_tstamp_type_t;
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct _snd_pcm_audio_tstamp_config {
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize], u8>,
    pub __bindgen_padding_0: [u8; 3usize],
}
impl _snd_pcm_audio_tstamp_config {
    #[inline]
    pub fn type_requested(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 4u8) as u32) }
    }
    #[inline]
    pub fn set_type_requested(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 4u8, val as u64)
        }
    }
    #[inline]
    pub fn report_delay(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_report_delay(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        type_requested: ::std::os::raw::c_uint,
        report_delay: ::std::os::raw::c_uint,
    ) -> __BindgenBitfieldUnit<[u8; 1usize], u8> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize], u8> =
            Default::default();
        __bindgen_bitfield_unit.set(0usize, 4u8, {
            let type_requested: u32 = unsafe { ::std::mem::transmute(type_requested) };
            type_requested as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let report_delay: u32 = unsafe { ::std::mem::transmute(report_delay) };
            report_delay as u64
        });
        __bindgen_bitfield_unit
    }
}
pub type snd_pcm_audio_tstamp_config_t = _snd_pcm_audio_tstamp_config;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _snd_pcm_audio_tstamp_report {
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize], u8>,
    pub accuracy: ::std::os::raw::c_uint,
}
impl _snd_pcm_audio_tstamp_report {
    #[inline]
    pub fn valid(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_valid(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn actual_type(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 4u8) as u32) }
    }
    #[inline]
    pub fn set_actual_type(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 4u8, val as u64)
        }
    }
    #[inline]
    pub fn accuracy_report(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(5usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_accuracy_report(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(5usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        valid: ::std::os::raw::c_uint,
        actual_type: ::std::os::raw::c_uint,
        accuracy_report: ::std::os::raw::c_uint,
    ) -> __BindgenBitfieldUnit<[u8; 1usize], u8> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize], u8> =
            Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let valid: u32 = unsafe { ::std::mem::transmute(valid) };
            valid as u64
        });
        __bindgen_bitfield_unit.set(1usize, 4u8, {
            let actual_type: u32 = unsafe { ::std::mem::transmute(actual_type) };
            actual_type as u64
        });
        __bindgen_bitfield_unit.set(5usize, 1u8, {
            let accuracy_report: u32 = unsafe { ::std::mem::transmute(accuracy_report) };
            accuracy_report as u64
        });
        __bindgen_bitfield_unit
    }
}
pub type snd_pcm_audio_tstamp_report_t = _snd_pcm_audio_tstamp_report;
#[doc = " Unsigned frames quantity"]
pub type snd_pcm_uframes_t = ::std::os::raw::c_ulong;
#[doc = " Signed frames quantity"]
pub type snd_pcm_sframes_t = ::std::os::raw::c_long;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _snd_pcm {
    _unused: [u8; 0],
}
#[doc = " PCM handle"]
pub type snd_pcm_t = _snd_pcm;
#[doc = " Kernel level PCM"]
pub const SND_PCM_TYPE_HW: _snd_pcm_type = 0;
#[doc = " Hooked PCM"]
pub const SND_PCM_TYPE_HOOKS: _snd_pcm_type = 1;
#[doc = " One or more linked PCM with exclusive access to selected"]
#[doc = "channels"]
pub const SND_PCM_TYPE_MULTI: _snd_pcm_type = 2;
#[doc = " File writing plugin"]
pub const SND_PCM_TYPE_FILE: _snd_pcm_type = 3;
#[doc = " Null endpoint PCM"]
pub const SND_PCM_TYPE_NULL: _snd_pcm_type = 4;
#[doc = " Shared memory client PCM"]
pub const SND_PCM_TYPE_SHM: _snd_pcm_type = 5;
#[doc = " INET client PCM (not yet implemented)"]
pub const SND_PCM_TYPE_INET: _snd_pcm_type = 6;
#[doc = " Copying plugin"]
pub const SND_PCM_TYPE_COPY: _snd_pcm_type = 7;
#[doc = " Linear format conversion PCM"]
pub const SND_PCM_TYPE_LINEAR: _snd_pcm_type = 8;
#[doc = " A-Law format conversion PCM"]
pub const SND_PCM_TYPE_ALAW: _snd_pcm_type = 9;
#[doc = " Mu-Law format conversion PCM"]
pub const SND_PCM_TYPE_MULAW: _snd_pcm_type = 10;
#[doc = " IMA-ADPCM format conversion PCM"]
pub const SND_PCM_TYPE_ADPCM: _snd_pcm_type = 11;
#[doc = " Rate conversion PCM"]
pub const SND_PCM_TYPE_RATE: _snd_pcm_type = 12;
#[doc = " Attenuated static route PCM"]
pub const SND_PCM_TYPE_ROUTE: _snd_pcm_type = 13;
#[doc = " Format adjusted PCM"]
pub const SND_PCM_TYPE_PLUG: _snd_pcm_type = 14;
#[doc = " Sharing PCM"]
pub const SND_PCM_TYPE_SHARE: _snd_pcm_type = 15;
#[doc = " Meter plugin"]
pub const SND_PCM_TYPE_METER: _snd_pcm_type = 16;
#[doc = " Mixing PCM"]
pub const SND_PCM_TYPE_MIX: _snd_pcm_type = 17;
#[doc = " Attenuated dynamic route PCM (not yet implemented)"]
pub const SND_PCM_TYPE_DROUTE: _snd_pcm_type = 18;
#[doc = " Loopback server plugin (not yet implemented)"]
pub const SND_PCM_TYPE_LBSERVER: _snd_pcm_type = 19;
#[doc = " Linear Integer <-> Linear Float format conversion PCM"]
pub const SND_PCM_TYPE_LINEAR_FLOAT: _snd_pcm_type = 20;
#[doc = " LADSPA integration plugin"]
pub const SND_PCM_TYPE_LADSPA: _snd_pcm_type = 21;
#[doc = " Direct Mixing plugin"]
pub const SND_PCM_TYPE_DMIX: _snd_pcm_type = 22;
#[doc = " Jack Audio Connection Kit plugin"]
pub const SND_PCM_TYPE_JACK: _snd_pcm_type = 23;
#[doc = " Direct Snooping plugin"]
pub const SND_PCM_TYPE_DSNOOP: _snd_pcm_type = 24;
#[doc = " Direct Sharing plugin"]
pub const SND_PCM_TYPE_DSHARE: _snd_pcm_type = 25;
#[doc = " IEC958 subframe plugin"]
pub const SND_PCM_TYPE_IEC958: _snd_pcm_type = 26;
#[doc = " Soft volume plugin"]
pub const SND_PCM_TYPE_SOFTVOL: _snd_pcm_type = 27;
#[doc = " External I/O plugin"]
pub const SND_PCM_TYPE_IOPLUG: _snd_pcm_type = 28;
#[doc = " External filter plugin"]
pub const SND_PCM_TYPE_EXTPLUG: _snd_pcm_type = 29;
#[doc = " Mmap-emulation plugin"]
pub const SND_PCM_TYPE_MMAP_EMUL: _snd_pcm_type = 30;
#[doc = " Mmap-emulation plugin"]
pub const SND_PCM_TYPE_LAST: _snd_pcm_type = 30;
#[doc = " PCM type"]
pub type _snd_pcm_type = ::std::os::raw::c_uint;
#[doc = " PCM type"]
pub use self::_snd_pcm_type as snd_pcm_type_t;
#[doc = " PCM area specification"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _snd_pcm_channel_area {
    #[doc = " base address of channel samples"]
    pub addr: *mut ::std::os::raw::c_void,
    #[doc = " offset to first sample in bits"]
    pub first: ::std::os::raw::c_uint,
    #[doc = " samples distance in bits"]
    pub step: ::std::os::raw::c_uint,
}
#[doc = " PCM area specification"]
pub type snd_pcm_channel_area_t = _snd_pcm_channel_area;
#[doc = " PCM synchronization ID"]
#[repr(C)]
#[derive(Copy, Clone)]
pub union _snd_pcm_sync_id {
    #[doc = " 8-bit ID"]
    pub id: [::std::os::raw::c_uchar; 16usize],
    #[doc = " 16-bit ID"]
    pub id16: [::std::os::raw::c_ushort; 8usize],
    #[doc = " 32-bit ID"]
    pub id32: [::std::os::raw::c_uint; 4usize],
    _bindgen_union_align: [u32; 4usize],
}
#[doc = " PCM synchronization ID"]
pub type snd_pcm_sync_id_t = _snd_pcm_sync_id;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _snd_pcm_scope {
    _unused: [u8; 0],
}
#[doc = " #SND_PCM_TYPE_METER scope handle"]
pub type snd_pcm_scope_t = _snd_pcm_scope;
extern "C" {
    pub fn snd_pcm_open(
        pcm: *mut *mut snd_pcm_t,
        name: *const ::std::os::raw::c_char,
        stream: snd_pcm_stream_t,
        mode: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_open_lconf(
        pcm: *mut *mut snd_pcm_t,
        name: *const ::std::os::raw::c_char,
        stream: snd_pcm_stream_t,
        mode: ::std::os::raw::c_int,
        lconf: *mut snd_config_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_open_fallback(
        pcm: *mut *mut snd_pcm_t,
        root: *mut snd_config_t,
        name: *const ::std::os::raw::c_char,
        orig_name: *const ::std::os::raw::c_char,
        stream: snd_pcm_stream_t,
        mode: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_close(pcm: *mut snd_pcm_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_name(pcm: *mut snd_pcm_t) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn snd_pcm_type(pcm: *mut snd_pcm_t) -> snd_pcm_type_t;
}
extern "C" {
    pub fn snd_pcm_stream(pcm: *mut snd_pcm_t) -> snd_pcm_stream_t;
}
extern "C" {
    pub fn snd_pcm_poll_descriptors_count(pcm: *mut snd_pcm_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_poll_descriptors(
        pcm: *mut snd_pcm_t,
        pfds: *mut pollfd,
        space: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_poll_descriptors_revents(
        pcm: *mut snd_pcm_t,
        pfds: *mut pollfd,
        nfds: ::std::os::raw::c_uint,
        revents: *mut ::std::os::raw::c_ushort,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_nonblock(
        pcm: *mut snd_pcm_t,
        nonblock: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_async_add_pcm_handler(
        handler: *mut *mut snd_async_handler_t,
        pcm: *mut snd_pcm_t,
        callback: snd_async_callback_t,
        private_data: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_async_handler_get_pcm(handler: *mut snd_async_handler_t) -> *mut snd_pcm_t;
}
extern "C" {
    pub fn snd_pcm_info(pcm: *mut snd_pcm_t, info: *mut snd_pcm_info_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hw_params_current(
        pcm: *mut snd_pcm_t,
        params: *mut snd_pcm_hw_params_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hw_params(
        pcm: *mut snd_pcm_t,
        params: *mut snd_pcm_hw_params_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hw_free(pcm: *mut snd_pcm_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_sw_params_current(
        pcm: *mut snd_pcm_t,
        params: *mut snd_pcm_sw_params_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_sw_params(
        pcm: *mut snd_pcm_t,
        params: *mut snd_pcm_sw_params_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_prepare(pcm: *mut snd_pcm_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_reset(pcm: *mut snd_pcm_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_status(
        pcm: *mut snd_pcm_t,
        status: *mut snd_pcm_status_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_start(pcm: *mut snd_pcm_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_drop(pcm: *mut snd_pcm_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_drain(pcm: *mut snd_pcm_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_pause(
        pcm: *mut snd_pcm_t,
        enable: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_state(pcm: *mut snd_pcm_t) -> snd_pcm_state_t;
}
extern "C" {
    pub fn snd_pcm_hwsync(pcm: *mut snd_pcm_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_delay(
        pcm: *mut snd_pcm_t,
        delayp: *mut snd_pcm_sframes_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_resume(pcm: *mut snd_pcm_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_htimestamp(
        pcm: *mut snd_pcm_t,
        avail: *mut snd_pcm_uframes_t,
        tstamp: *mut snd_htimestamp_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_avail(pcm: *mut snd_pcm_t) -> snd_pcm_sframes_t;
}
extern "C" {
    pub fn snd_pcm_avail_update(pcm: *mut snd_pcm_t) -> snd_pcm_sframes_t;
}
extern "C" {
    pub fn snd_pcm_avail_delay(
        pcm: *mut snd_pcm_t,
        availp: *mut snd_pcm_sframes_t,
        delayp: *mut snd_pcm_sframes_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_rewindable(pcm: *mut snd_pcm_t) -> snd_pcm_sframes_t;
}
extern "C" {
    pub fn snd_pcm_rewind(pcm: *mut snd_pcm_t, frames: snd_pcm_uframes_t) -> snd_pcm_sframes_t;
}
extern "C" {
    pub fn snd_pcm_forwardable(pcm: *mut snd_pcm_t) -> snd_pcm_sframes_t;
}
extern "C" {
    pub fn snd_pcm_forward(pcm: *mut snd_pcm_t, frames: snd_pcm_uframes_t) -> snd_pcm_sframes_t;
}
extern "C" {
    pub fn snd_pcm_writei(
        pcm: *mut snd_pcm_t,
        buffer: *const ::std::os::raw::c_void,
        size: snd_pcm_uframes_t,
    ) -> snd_pcm_sframes_t;
}
extern "C" {
    pub fn snd_pcm_readi(
        pcm: *mut snd_pcm_t,
        buffer: *mut ::std::os::raw::c_void,
        size: snd_pcm_uframes_t,
    ) -> snd_pcm_sframes_t;
}
extern "C" {
    pub fn snd_pcm_writen(
        pcm: *mut snd_pcm_t,
        bufs: *mut *mut ::std::os::raw::c_void,
        size: snd_pcm_uframes_t,
    ) -> snd_pcm_sframes_t;
}
extern "C" {
    pub fn snd_pcm_readn(
        pcm: *mut snd_pcm_t,
        bufs: *mut *mut ::std::os::raw::c_void,
        size: snd_pcm_uframes_t,
    ) -> snd_pcm_sframes_t;
}
extern "C" {
    pub fn snd_pcm_wait(
        pcm: *mut snd_pcm_t,
        timeout: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_link(pcm1: *mut snd_pcm_t, pcm2: *mut snd_pcm_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_unlink(pcm: *mut snd_pcm_t) -> ::std::os::raw::c_int;
}
#[doc = "< unspecified channel position"]
pub const SND_CHMAP_TYPE_NONE: snd_pcm_chmap_type = 0;
#[doc = "< fixed channel position"]
pub const SND_CHMAP_TYPE_FIXED: snd_pcm_chmap_type = 1;
#[doc = "< freely swappable channel position"]
pub const SND_CHMAP_TYPE_VAR: snd_pcm_chmap_type = 2;
#[doc = "< pair-wise swappable channel position"]
pub const SND_CHMAP_TYPE_PAIRED: snd_pcm_chmap_type = 3;
#[doc = "< last entry"]
pub const SND_CHMAP_TYPE_LAST: snd_pcm_chmap_type = 3;
#[doc = " channel map list type"]
pub type snd_pcm_chmap_type = ::std::os::raw::c_uint;
#[doc = "< unspecified"]
pub const SND_CHMAP_UNKNOWN: snd_pcm_chmap_position = 0;
#[doc = "< N/A, silent"]
pub const SND_CHMAP_NA: snd_pcm_chmap_position = 1;
#[doc = "< mono stream"]
pub const SND_CHMAP_MONO: snd_pcm_chmap_position = 2;
#[doc = "< front left"]
pub const SND_CHMAP_FL: snd_pcm_chmap_position = 3;
#[doc = "< front right"]
pub const SND_CHMAP_FR: snd_pcm_chmap_position = 4;
#[doc = "< rear left"]
pub const SND_CHMAP_RL: snd_pcm_chmap_position = 5;
#[doc = "< rear right"]
pub const SND_CHMAP_RR: snd_pcm_chmap_position = 6;
#[doc = "< front center"]
pub const SND_CHMAP_FC: snd_pcm_chmap_position = 7;
#[doc = "< LFE"]
pub const SND_CHMAP_LFE: snd_pcm_chmap_position = 8;
#[doc = "< side left"]
pub const SND_CHMAP_SL: snd_pcm_chmap_position = 9;
#[doc = "< side right"]
pub const SND_CHMAP_SR: snd_pcm_chmap_position = 10;
#[doc = "< rear center"]
pub const SND_CHMAP_RC: snd_pcm_chmap_position = 11;
#[doc = "< front left center"]
pub const SND_CHMAP_FLC: snd_pcm_chmap_position = 12;
#[doc = "< front right center"]
pub const SND_CHMAP_FRC: snd_pcm_chmap_position = 13;
#[doc = "< rear left center"]
pub const SND_CHMAP_RLC: snd_pcm_chmap_position = 14;
#[doc = "< rear right center"]
pub const SND_CHMAP_RRC: snd_pcm_chmap_position = 15;
#[doc = "< front left wide"]
pub const SND_CHMAP_FLW: snd_pcm_chmap_position = 16;
#[doc = "< front right wide"]
pub const SND_CHMAP_FRW: snd_pcm_chmap_position = 17;
#[doc = "< front left high"]
pub const SND_CHMAP_FLH: snd_pcm_chmap_position = 18;
#[doc = "< front center high"]
pub const SND_CHMAP_FCH: snd_pcm_chmap_position = 19;
#[doc = "< front right high"]
pub const SND_CHMAP_FRH: snd_pcm_chmap_position = 20;
#[doc = "< top center"]
pub const SND_CHMAP_TC: snd_pcm_chmap_position = 21;
#[doc = "< top front left"]
pub const SND_CHMAP_TFL: snd_pcm_chmap_position = 22;
#[doc = "< top front right"]
pub const SND_CHMAP_TFR: snd_pcm_chmap_position = 23;
#[doc = "< top front center"]
pub const SND_CHMAP_TFC: snd_pcm_chmap_position = 24;
#[doc = "< top rear left"]
pub const SND_CHMAP_TRL: snd_pcm_chmap_position = 25;
#[doc = "< top rear right"]
pub const SND_CHMAP_TRR: snd_pcm_chmap_position = 26;
#[doc = "< top rear center"]
pub const SND_CHMAP_TRC: snd_pcm_chmap_position = 27;
#[doc = "< top front left center"]
pub const SND_CHMAP_TFLC: snd_pcm_chmap_position = 28;
#[doc = "< top front right center"]
pub const SND_CHMAP_TFRC: snd_pcm_chmap_position = 29;
#[doc = "< top side left"]
pub const SND_CHMAP_TSL: snd_pcm_chmap_position = 30;
#[doc = "< top side right"]
pub const SND_CHMAP_TSR: snd_pcm_chmap_position = 31;
#[doc = "< left LFE"]
pub const SND_CHMAP_LLFE: snd_pcm_chmap_position = 32;
#[doc = "< right LFE"]
pub const SND_CHMAP_RLFE: snd_pcm_chmap_position = 33;
#[doc = "< bottom center"]
pub const SND_CHMAP_BC: snd_pcm_chmap_position = 34;
#[doc = "< bottom left center"]
pub const SND_CHMAP_BLC: snd_pcm_chmap_position = 35;
#[doc = "< bottom right center"]
pub const SND_CHMAP_BRC: snd_pcm_chmap_position = 36;
pub const SND_CHMAP_LAST: snd_pcm_chmap_position = 36;
#[doc = " channel positions"]
pub type snd_pcm_chmap_position = ::std::os::raw::c_uint;
#[doc = " the channel map header"]
#[repr(C)]
#[derive(Debug)]
pub struct snd_pcm_chmap {
    #[doc = "< number of channels"]
    pub channels: ::std::os::raw::c_uint,
    #[doc = "< channel position array"]
    pub pos: __IncompleteArrayField<::std::os::raw::c_uint>,
}
#[doc = " the channel map header"]
pub type snd_pcm_chmap_t = snd_pcm_chmap;
#[doc = " the header of array items returned from snd_pcm_query_chmaps()"]
#[repr(C)]
#[derive(Debug)]
pub struct snd_pcm_chmap_query {
    #[doc = "< channel map type"]
    pub type_: snd_pcm_chmap_type,
    #[doc = "< available channel map"]
    pub map: snd_pcm_chmap_t,
}
#[doc = " the header of array items returned from snd_pcm_query_chmaps()"]
pub type snd_pcm_chmap_query_t = snd_pcm_chmap_query;
extern "C" {
    pub fn snd_pcm_query_chmaps(pcm: *mut snd_pcm_t) -> *mut *mut snd_pcm_chmap_query_t;
}
extern "C" {
    pub fn snd_pcm_query_chmaps_from_hw(
        card: ::std::os::raw::c_int,
        dev: ::std::os::raw::c_int,
        subdev: ::std::os::raw::c_int,
        stream: snd_pcm_stream_t,
    ) -> *mut *mut snd_pcm_chmap_query_t;
}
extern "C" {
    pub fn snd_pcm_free_chmaps(maps: *mut *mut snd_pcm_chmap_query_t);
}
extern "C" {
    pub fn snd_pcm_get_chmap(pcm: *mut snd_pcm_t) -> *mut snd_pcm_chmap_t;
}
extern "C" {
    pub fn snd_pcm_set_chmap(
        pcm: *mut snd_pcm_t,
        map: *const snd_pcm_chmap_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_chmap_type_name(val: snd_pcm_chmap_type) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn snd_pcm_chmap_name(val: snd_pcm_chmap_position) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn snd_pcm_chmap_long_name(val: snd_pcm_chmap_position) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn snd_pcm_chmap_print(
        map: *const snd_pcm_chmap_t,
        maxlen: usize,
        buf: *mut ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_chmap_from_string(str_: *const ::std::os::raw::c_char)
        -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn snd_pcm_chmap_parse_string(str_: *const ::std::os::raw::c_char) -> *mut snd_pcm_chmap_t;
}
extern "C" {
    pub fn snd_pcm_recover(
        pcm: *mut snd_pcm_t,
        err: ::std::os::raw::c_int,
        silent: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_set_params(
        pcm: *mut snd_pcm_t,
        format: snd_pcm_format_t,
        access: snd_pcm_access_t,
        channels: ::std::os::raw::c_uint,
        rate: ::std::os::raw::c_uint,
        soft_resample: ::std::os::raw::c_int,
        latency: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_get_params(
        pcm: *mut snd_pcm_t,
        buffer_size: *mut snd_pcm_uframes_t,
        period_size: *mut snd_pcm_uframes_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " \\defgroup PCM_Info Stream Information"]
    #[doc = " \\ingroup PCM"]
    #[doc = " See the \\ref pcm page for more details."]
    #[doc = " \\{"]
    pub fn snd_pcm_info_sizeof() -> usize;
}
extern "C" {
    pub fn snd_pcm_info_malloc(ptr: *mut *mut snd_pcm_info_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_info_free(obj: *mut snd_pcm_info_t);
}
extern "C" {
    pub fn snd_pcm_info_copy(dst: *mut snd_pcm_info_t, src: *const snd_pcm_info_t);
}
extern "C" {
    pub fn snd_pcm_info_get_device(obj: *const snd_pcm_info_t) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn snd_pcm_info_get_subdevice(obj: *const snd_pcm_info_t) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn snd_pcm_info_get_stream(obj: *const snd_pcm_info_t) -> snd_pcm_stream_t;
}
extern "C" {
    pub fn snd_pcm_info_get_card(obj: *const snd_pcm_info_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_info_get_id(obj: *const snd_pcm_info_t) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn snd_pcm_info_get_name(obj: *const snd_pcm_info_t) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn snd_pcm_info_get_subdevice_name(
        obj: *const snd_pcm_info_t,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn snd_pcm_info_get_class(obj: *const snd_pcm_info_t) -> snd_pcm_class_t;
}
extern "C" {
    pub fn snd_pcm_info_get_subclass(obj: *const snd_pcm_info_t) -> snd_pcm_subclass_t;
}
extern "C" {
    pub fn snd_pcm_info_get_subdevices_count(obj: *const snd_pcm_info_t) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn snd_pcm_info_get_subdevices_avail(obj: *const snd_pcm_info_t) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn snd_pcm_info_get_sync(obj: *const snd_pcm_info_t) -> snd_pcm_sync_id_t;
}
extern "C" {
    pub fn snd_pcm_info_set_device(obj: *mut snd_pcm_info_t, val: ::std::os::raw::c_uint);
}
extern "C" {
    pub fn snd_pcm_info_set_subdevice(obj: *mut snd_pcm_info_t, val: ::std::os::raw::c_uint);
}
extern "C" {
    pub fn snd_pcm_info_set_stream(obj: *mut snd_pcm_info_t, val: snd_pcm_stream_t);
}
extern "C" {
    #[doc = " \\defgroup PCM_HW_Params Hardware Parameters"]
    #[doc = " \\ingroup PCM"]
    #[doc = " See the \\ref pcm page for more details."]
    #[doc = " \\{"]
    pub fn snd_pcm_hw_params_any(
        pcm: *mut snd_pcm_t,
        params: *mut snd_pcm_hw_params_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hw_params_can_mmap_sample_resolution(
        params: *const snd_pcm_hw_params_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hw_params_is_double(params: *const snd_pcm_hw_params_t)
        -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hw_params_is_batch(params: *const snd_pcm_hw_params_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hw_params_is_block_transfer(
        params: *const snd_pcm_hw_params_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hw_params_is_monotonic(
        params: *const snd_pcm_hw_params_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hw_params_can_overrange(
        params: *const snd_pcm_hw_params_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hw_params_can_pause(params: *const snd_pcm_hw_params_t)
        -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hw_params_can_resume(
        params: *const snd_pcm_hw_params_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hw_params_is_half_duplex(
        params: *const snd_pcm_hw_params_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hw_params_is_joint_duplex(
        params: *const snd_pcm_hw_params_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hw_params_can_sync_start(
        params: *const snd_pcm_hw_params_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hw_params_can_disable_period_wakeup(
        params: *const snd_pcm_hw_params_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hw_params_supports_audio_wallclock_ts(
        params: *const snd_pcm_hw_params_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hw_params_supports_audio_ts_type(
        params: *const snd_pcm_hw_params_t,
        type_: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hw_params_get_rate_numden(
        params: *const snd_pcm_hw_params_t,
        rate_num: *mut ::std::os::raw::c_uint,
        rate_den: *mut ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hw_params_get_sbits(params: *const snd_pcm_hw_params_t)
        -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hw_params_get_fifo_size(
        params: *const snd_pcm_hw_params_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hw_params_sizeof() -> usize;
}
extern "C" {
    pub fn snd_pcm_hw_params_malloc(ptr: *mut *mut snd_pcm_hw_params_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hw_params_free(obj: *mut snd_pcm_hw_params_t);
}
extern "C" {
    pub fn snd_pcm_hw_params_copy(dst: *mut snd_pcm_hw_params_t, src: *const snd_pcm_hw_params_t);
}
extern "C" {
    pub fn snd_pcm_hw_params_get_access(
        params: *const snd_pcm_hw_params_t,
        _access: *mut snd_pcm_access_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hw_params_test_access(
        pcm: *mut snd_pcm_t,
        params: *mut snd_pcm_hw_params_t,
        _access: snd_pcm_access_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hw_params_set_access(
        pcm: *mut snd_pcm_t,
        params: *mut snd_pcm_hw_params_t,
        _access: snd_pcm_access_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hw_params_set_access_first(
        pcm: *mut snd_pcm_t,
        params: *mut snd_pcm_hw_params_t,
        _access: *mut snd_pcm_access_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hw_params_set_access_last(
        pcm: *mut snd_pcm_t,
        params: *mut snd_pcm_hw_params_t,
        _access: *mut snd_pcm_access_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hw_params_set_access_mask(
        pcm: *mut snd_pcm_t,
        params: *mut snd_pcm_hw_params_t,
        mask: *mut snd_pcm_access_mask_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hw_params_get_access_mask(
        params: *mut snd_pcm_hw_params_t,
        mask: *mut snd_pcm_access_mask_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hw_params_get_format(
        params: *const snd_pcm_hw_params_t,
        val: *mut snd_pcm_format_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hw_params_test_format(
        pcm: *mut snd_pcm_t,
        params: *mut snd_pcm_hw_params_t,
        val: snd_pcm_format_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hw_params_set_format(
        pcm: *mut snd_pcm_t,
        params: *mut snd_pcm_hw_params_t,
        val: snd_pcm_format_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hw_params_set_format_first(
        pcm: *mut snd_pcm_t,
        params: *mut snd_pcm_hw_params_t,
        format: *mut snd_pcm_format_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hw_params_set_format_last(
        pcm: *mut snd_pcm_t,
        params: *mut snd_pcm_hw_params_t,
        format: *mut snd_pcm_format_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hw_params_set_format_mask(
        pcm: *mut snd_pcm_t,
        params: *mut snd_pcm_hw_params_t,
        mask: *mut snd_pcm_format_mask_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hw_params_get_format_mask(
        params: *mut snd_pcm_hw_params_t,
        mask: *mut snd_pcm_format_mask_t,
    );
}
extern "C" {
    pub fn snd_pcm_hw_params_get_subformat(
        params: *const snd_pcm_hw_params_t,
        subformat: *mut snd_pcm_subformat_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hw_params_test_subformat(
        pcm: *mut snd_pcm_t,
        params: *mut snd_pcm_hw_params_t,
        subformat: snd_pcm_subformat_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hw_params_set_subformat(
        pcm: *mut snd_pcm_t,
        params: *mut snd_pcm_hw_params_t,
        subformat: snd_pcm_subformat_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hw_params_set_subformat_first(
        pcm: *mut snd_pcm_t,
        params: *mut snd_pcm_hw_params_t,
        subformat: *mut snd_pcm_subformat_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hw_params_set_subformat_last(
        pcm: *mut snd_pcm_t,
        params: *mut snd_pcm_hw_params_t,
        subformat: *mut snd_pcm_subformat_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hw_params_set_subformat_mask(
        pcm: *mut snd_pcm_t,
        params: *mut snd_pcm_hw_params_t,
        mask: *mut snd_pcm_subformat_mask_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hw_params_get_subformat_mask(
        params: *mut snd_pcm_hw_params_t,
        mask: *mut snd_pcm_subformat_mask_t,
    );
}
extern "C" {
    pub fn snd_pcm_hw_params_get_channels(
        params: *const snd_pcm_hw_params_t,
        val: *mut ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hw_params_get_channels_min(
        params: *const snd_pcm_hw_params_t,
        val: *mut ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hw_params_get_channels_max(
        params: *const snd_pcm_hw_params_t,
        val: *mut ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hw_params_test_channels(
        pcm: *mut snd_pcm_t,
        params: *mut snd_pcm_hw_params_t,
        val: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hw_params_set_channels(
        pcm: *mut snd_pcm_t,
        params: *mut snd_pcm_hw_params_t,
        val: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hw_params_set_channels_min(
        pcm: *mut snd_pcm_t,
        params: *mut snd_pcm_hw_params_t,
        val: *mut ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hw_params_set_channels_max(
        pcm: *mut snd_pcm_t,
        params: *mut snd_pcm_hw_params_t,
        val: *mut ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hw_params_set_channels_minmax(
        pcm: *mut snd_pcm_t,
        params: *mut snd_pcm_hw_params_t,
        min: *mut ::std::os::raw::c_uint,
        max: *mut ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hw_params_set_channels_near(
        pcm: *mut snd_pcm_t,
        params: *mut snd_pcm_hw_params_t,
        val: *mut ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hw_params_set_channels_first(
        pcm: *mut snd_pcm_t,
        params: *mut snd_pcm_hw_params_t,
        val: *mut ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hw_params_set_channels_last(
        pcm: *mut snd_pcm_t,
        params: *mut snd_pcm_hw_params_t,
        val: *mut ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hw_params_get_rate(
        params: *const snd_pcm_hw_params_t,
        val: *mut ::std::os::raw::c_uint,
        dir: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hw_params_get_rate_min(
        params: *const snd_pcm_hw_params_t,
        val: *mut ::std::os::raw::c_uint,
        dir: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hw_params_get_rate_max(
        params: *const snd_pcm_hw_params_t,
        val: *mut ::std::os::raw::c_uint,
        dir: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hw_params_test_rate(
        pcm: *mut snd_pcm_t,
        params: *mut snd_pcm_hw_params_t,
        val: ::std::os::raw::c_uint,
        dir: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hw_params_set_rate(
        pcm: *mut snd_pcm_t,
        params: *mut snd_pcm_hw_params_t,
        val: ::std::os::raw::c_uint,
        dir: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hw_params_set_rate_min(
        pcm: *mut snd_pcm_t,
        params: *mut snd_pcm_hw_params_t,
        val: *mut ::std::os::raw::c_uint,
        dir: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hw_params_set_rate_max(
        pcm: *mut snd_pcm_t,
        params: *mut snd_pcm_hw_params_t,
        val: *mut ::std::os::raw::c_uint,
        dir: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hw_params_set_rate_minmax(
        pcm: *mut snd_pcm_t,
        params: *mut snd_pcm_hw_params_t,
        min: *mut ::std::os::raw::c_uint,
        mindir: *mut ::std::os::raw::c_int,
        max: *mut ::std::os::raw::c_uint,
        maxdir: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hw_params_set_rate_near(
        pcm: *mut snd_pcm_t,
        params: *mut snd_pcm_hw_params_t,
        val: *mut ::std::os::raw::c_uint,
        dir: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hw_params_set_rate_first(
        pcm: *mut snd_pcm_t,
        params: *mut snd_pcm_hw_params_t,
        val: *mut ::std::os::raw::c_uint,
        dir: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hw_params_set_rate_last(
        pcm: *mut snd_pcm_t,
        params: *mut snd_pcm_hw_params_t,
        val: *mut ::std::os::raw::c_uint,
        dir: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hw_params_set_rate_resample(
        pcm: *mut snd_pcm_t,
        params: *mut snd_pcm_hw_params_t,
        val: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hw_params_get_rate_resample(
        pcm: *mut snd_pcm_t,
        params: *mut snd_pcm_hw_params_t,
        val: *mut ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hw_params_set_export_buffer(
        pcm: *mut snd_pcm_t,
        params: *mut snd_pcm_hw_params_t,
        val: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hw_params_get_export_buffer(
        pcm: *mut snd_pcm_t,
        params: *mut snd_pcm_hw_params_t,
        val: *mut ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hw_params_set_period_wakeup(
        pcm: *mut snd_pcm_t,
        params: *mut snd_pcm_hw_params_t,
        val: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hw_params_get_period_wakeup(
        pcm: *mut snd_pcm_t,
        params: *mut snd_pcm_hw_params_t,
        val: *mut ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hw_params_get_period_time(
        params: *const snd_pcm_hw_params_t,
        val: *mut ::std::os::raw::c_uint,
        dir: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hw_params_get_period_time_min(
        params: *const snd_pcm_hw_params_t,
        val: *mut ::std::os::raw::c_uint,
        dir: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hw_params_get_period_time_max(
        params: *const snd_pcm_hw_params_t,
        val: *mut ::std::os::raw::c_uint,
        dir: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hw_params_test_period_time(
        pcm: *mut snd_pcm_t,
        params: *mut snd_pcm_hw_params_t,
        val: ::std::os::raw::c_uint,
        dir: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hw_params_set_period_time(
        pcm: *mut snd_pcm_t,
        params: *mut snd_pcm_hw_params_t,
        val: ::std::os::raw::c_uint,
        dir: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hw_params_set_period_time_min(
        pcm: *mut snd_pcm_t,
        params: *mut snd_pcm_hw_params_t,
        val: *mut ::std::os::raw::c_uint,
        dir: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hw_params_set_period_time_max(
        pcm: *mut snd_pcm_t,
        params: *mut snd_pcm_hw_params_t,
        val: *mut ::std::os::raw::c_uint,
        dir: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hw_params_set_period_time_minmax(
        pcm: *mut snd_pcm_t,
        params: *mut snd_pcm_hw_params_t,
        min: *mut ::std::os::raw::c_uint,
        mindir: *mut ::std::os::raw::c_int,
        max: *mut ::std::os::raw::c_uint,
        maxdir: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hw_params_set_period_time_near(
        pcm: *mut snd_pcm_t,
        params: *mut snd_pcm_hw_params_t,
        val: *mut ::std::os::raw::c_uint,
        dir: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hw_params_set_period_time_first(
        pcm: *mut snd_pcm_t,
        params: *mut snd_pcm_hw_params_t,
        val: *mut ::std::os::raw::c_uint,
        dir: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hw_params_set_period_time_last(
        pcm: *mut snd_pcm_t,
        params: *mut snd_pcm_hw_params_t,
        val: *mut ::std::os::raw::c_uint,
        dir: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hw_params_get_period_size(
        params: *const snd_pcm_hw_params_t,
        frames: *mut snd_pcm_uframes_t,
        dir: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hw_params_get_period_size_min(
        params: *const snd_pcm_hw_params_t,
        frames: *mut snd_pcm_uframes_t,
        dir: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hw_params_get_period_size_max(
        params: *const snd_pcm_hw_params_t,
        frames: *mut snd_pcm_uframes_t,
        dir: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hw_params_test_period_size(
        pcm: *mut snd_pcm_t,
        params: *mut snd_pcm_hw_params_t,
        val: snd_pcm_uframes_t,
        dir: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hw_params_set_period_size(
        pcm: *mut snd_pcm_t,
        params: *mut snd_pcm_hw_params_t,
        val: snd_pcm_uframes_t,
        dir: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hw_params_set_period_size_min(
        pcm: *mut snd_pcm_t,
        params: *mut snd_pcm_hw_params_t,
        val: *mut snd_pcm_uframes_t,
        dir: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hw_params_set_period_size_max(
        pcm: *mut snd_pcm_t,
        params: *mut snd_pcm_hw_params_t,
        val: *mut snd_pcm_uframes_t,
        dir: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hw_params_set_period_size_minmax(
        pcm: *mut snd_pcm_t,
        params: *mut snd_pcm_hw_params_t,
        min: *mut snd_pcm_uframes_t,
        mindir: *mut ::std::os::raw::c_int,
        max: *mut snd_pcm_uframes_t,
        maxdir: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hw_params_set_period_size_near(
        pcm: *mut snd_pcm_t,
        params: *mut snd_pcm_hw_params_t,
        val: *mut snd_pcm_uframes_t,
        dir: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hw_params_set_period_size_first(
        pcm: *mut snd_pcm_t,
        params: *mut snd_pcm_hw_params_t,
        val: *mut snd_pcm_uframes_t,
        dir: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hw_params_set_period_size_last(
        pcm: *mut snd_pcm_t,
        params: *mut snd_pcm_hw_params_t,
        val: *mut snd_pcm_uframes_t,
        dir: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hw_params_set_period_size_integer(
        pcm: *mut snd_pcm_t,
        params: *mut snd_pcm_hw_params_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hw_params_get_periods(
        params: *const snd_pcm_hw_params_t,
        val: *mut ::std::os::raw::c_uint,
        dir: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hw_params_get_periods_min(
        params: *const snd_pcm_hw_params_t,
        val: *mut ::std::os::raw::c_uint,
        dir: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hw_params_get_periods_max(
        params: *const snd_pcm_hw_params_t,
        val: *mut ::std::os::raw::c_uint,
        dir: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hw_params_test_periods(
        pcm: *mut snd_pcm_t,
        params: *mut snd_pcm_hw_params_t,
        val: ::std::os::raw::c_uint,
        dir: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hw_params_set_periods(
        pcm: *mut snd_pcm_t,
        params: *mut snd_pcm_hw_params_t,
        val: ::std::os::raw::c_uint,
        dir: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hw_params_set_periods_min(
        pcm: *mut snd_pcm_t,
        params: *mut snd_pcm_hw_params_t,
        val: *mut ::std::os::raw::c_uint,
        dir: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hw_params_set_periods_max(
        pcm: *mut snd_pcm_t,
        params: *mut snd_pcm_hw_params_t,
        val: *mut ::std::os::raw::c_uint,
        dir: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hw_params_set_periods_minmax(
        pcm: *mut snd_pcm_t,
        params: *mut snd_pcm_hw_params_t,
        min: *mut ::std::os::raw::c_uint,
        mindir: *mut ::std::os::raw::c_int,
        max: *mut ::std::os::raw::c_uint,
        maxdir: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hw_params_set_periods_near(
        pcm: *mut snd_pcm_t,
        params: *mut snd_pcm_hw_params_t,
        val: *mut ::std::os::raw::c_uint,
        dir: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hw_params_set_periods_first(
        pcm: *mut snd_pcm_t,
        params: *mut snd_pcm_hw_params_t,
        val: *mut ::std::os::raw::c_uint,
        dir: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hw_params_set_periods_last(
        pcm: *mut snd_pcm_t,
        params: *mut snd_pcm_hw_params_t,
        val: *mut ::std::os::raw::c_uint,
        dir: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hw_params_set_periods_integer(
        pcm: *mut snd_pcm_t,
        params: *mut snd_pcm_hw_params_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hw_params_get_buffer_time(
        params: *const snd_pcm_hw_params_t,
        val: *mut ::std::os::raw::c_uint,
        dir: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hw_params_get_buffer_time_min(
        params: *const snd_pcm_hw_params_t,
        val: *mut ::std::os::raw::c_uint,
        dir: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hw_params_get_buffer_time_max(
        params: *const snd_pcm_hw_params_t,
        val: *mut ::std::os::raw::c_uint,
        dir: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hw_params_test_buffer_time(
        pcm: *mut snd_pcm_t,
        params: *mut snd_pcm_hw_params_t,
        val: ::std::os::raw::c_uint,
        dir: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hw_params_set_buffer_time(
        pcm: *mut snd_pcm_t,
        params: *mut snd_pcm_hw_params_t,
        val: ::std::os::raw::c_uint,
        dir: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hw_params_set_buffer_time_min(
        pcm: *mut snd_pcm_t,
        params: *mut snd_pcm_hw_params_t,
        val: *mut ::std::os::raw::c_uint,
        dir: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hw_params_set_buffer_time_max(
        pcm: *mut snd_pcm_t,
        params: *mut snd_pcm_hw_params_t,
        val: *mut ::std::os::raw::c_uint,
        dir: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hw_params_set_buffer_time_minmax(
        pcm: *mut snd_pcm_t,
        params: *mut snd_pcm_hw_params_t,
        min: *mut ::std::os::raw::c_uint,
        mindir: *mut ::std::os::raw::c_int,
        max: *mut ::std::os::raw::c_uint,
        maxdir: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hw_params_set_buffer_time_near(
        pcm: *mut snd_pcm_t,
        params: *mut snd_pcm_hw_params_t,
        val: *mut ::std::os::raw::c_uint,
        dir: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hw_params_set_buffer_time_first(
        pcm: *mut snd_pcm_t,
        params: *mut snd_pcm_hw_params_t,
        val: *mut ::std::os::raw::c_uint,
        dir: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hw_params_set_buffer_time_last(
        pcm: *mut snd_pcm_t,
        params: *mut snd_pcm_hw_params_t,
        val: *mut ::std::os::raw::c_uint,
        dir: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hw_params_get_buffer_size(
        params: *const snd_pcm_hw_params_t,
        val: *mut snd_pcm_uframes_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hw_params_get_buffer_size_min(
        params: *const snd_pcm_hw_params_t,
        val: *mut snd_pcm_uframes_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hw_params_get_buffer_size_max(
        params: *const snd_pcm_hw_params_t,
        val: *mut snd_pcm_uframes_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hw_params_test_buffer_size(
        pcm: *mut snd_pcm_t,
        params: *mut snd_pcm_hw_params_t,
        val: snd_pcm_uframes_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hw_params_set_buffer_size(
        pcm: *mut snd_pcm_t,
        params: *mut snd_pcm_hw_params_t,
        val: snd_pcm_uframes_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hw_params_set_buffer_size_min(
        pcm: *mut snd_pcm_t,
        params: *mut snd_pcm_hw_params_t,
        val: *mut snd_pcm_uframes_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hw_params_set_buffer_size_max(
        pcm: *mut snd_pcm_t,
        params: *mut snd_pcm_hw_params_t,
        val: *mut snd_pcm_uframes_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hw_params_set_buffer_size_minmax(
        pcm: *mut snd_pcm_t,
        params: *mut snd_pcm_hw_params_t,
        min: *mut snd_pcm_uframes_t,
        max: *mut snd_pcm_uframes_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hw_params_set_buffer_size_near(
        pcm: *mut snd_pcm_t,
        params: *mut snd_pcm_hw_params_t,
        val: *mut snd_pcm_uframes_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hw_params_set_buffer_size_first(
        pcm: *mut snd_pcm_t,
        params: *mut snd_pcm_hw_params_t,
        val: *mut snd_pcm_uframes_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hw_params_set_buffer_size_last(
        pcm: *mut snd_pcm_t,
        params: *mut snd_pcm_hw_params_t,
        val: *mut snd_pcm_uframes_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hw_params_get_min_align(
        params: *const snd_pcm_hw_params_t,
        val: *mut snd_pcm_uframes_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " \\defgroup PCM_SW_Params Software Parameters"]
    #[doc = " \\ingroup PCM"]
    #[doc = " See the \\ref pcm page for more details."]
    #[doc = " \\{"]
    pub fn snd_pcm_sw_params_sizeof() -> usize;
}
extern "C" {
    pub fn snd_pcm_sw_params_malloc(ptr: *mut *mut snd_pcm_sw_params_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_sw_params_free(obj: *mut snd_pcm_sw_params_t);
}
extern "C" {
    pub fn snd_pcm_sw_params_copy(dst: *mut snd_pcm_sw_params_t, src: *const snd_pcm_sw_params_t);
}
extern "C" {
    pub fn snd_pcm_sw_params_get_boundary(
        params: *const snd_pcm_sw_params_t,
        val: *mut snd_pcm_uframes_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_sw_params_set_tstamp_mode(
        pcm: *mut snd_pcm_t,
        params: *mut snd_pcm_sw_params_t,
        val: snd_pcm_tstamp_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_sw_params_get_tstamp_mode(
        params: *const snd_pcm_sw_params_t,
        val: *mut snd_pcm_tstamp_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_sw_params_set_tstamp_type(
        pcm: *mut snd_pcm_t,
        params: *mut snd_pcm_sw_params_t,
        val: snd_pcm_tstamp_type_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_sw_params_get_tstamp_type(
        params: *const snd_pcm_sw_params_t,
        val: *mut snd_pcm_tstamp_type_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_sw_params_set_avail_min(
        pcm: *mut snd_pcm_t,
        params: *mut snd_pcm_sw_params_t,
        val: snd_pcm_uframes_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_sw_params_get_avail_min(
        params: *const snd_pcm_sw_params_t,
        val: *mut snd_pcm_uframes_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_sw_params_set_period_event(
        pcm: *mut snd_pcm_t,
        params: *mut snd_pcm_sw_params_t,
        val: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_sw_params_get_period_event(
        params: *const snd_pcm_sw_params_t,
        val: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_sw_params_set_start_threshold(
        pcm: *mut snd_pcm_t,
        params: *mut snd_pcm_sw_params_t,
        val: snd_pcm_uframes_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_sw_params_get_start_threshold(
        paramsm: *const snd_pcm_sw_params_t,
        val: *mut snd_pcm_uframes_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_sw_params_set_stop_threshold(
        pcm: *mut snd_pcm_t,
        params: *mut snd_pcm_sw_params_t,
        val: snd_pcm_uframes_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_sw_params_get_stop_threshold(
        params: *const snd_pcm_sw_params_t,
        val: *mut snd_pcm_uframes_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_sw_params_set_silence_threshold(
        pcm: *mut snd_pcm_t,
        params: *mut snd_pcm_sw_params_t,
        val: snd_pcm_uframes_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_sw_params_get_silence_threshold(
        params: *const snd_pcm_sw_params_t,
        val: *mut snd_pcm_uframes_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_sw_params_set_silence_size(
        pcm: *mut snd_pcm_t,
        params: *mut snd_pcm_sw_params_t,
        val: snd_pcm_uframes_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_sw_params_get_silence_size(
        params: *const snd_pcm_sw_params_t,
        val: *mut snd_pcm_uframes_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " \\defgroup PCM_Access Access Mask Functions"]
    #[doc = " \\ingroup PCM"]
    #[doc = " See the \\ref pcm page for more details."]
    #[doc = " \\{"]
    pub fn snd_pcm_access_mask_sizeof() -> usize;
}
extern "C" {
    pub fn snd_pcm_access_mask_malloc(
        ptr: *mut *mut snd_pcm_access_mask_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_access_mask_free(obj: *mut snd_pcm_access_mask_t);
}
extern "C" {
    pub fn snd_pcm_access_mask_copy(
        dst: *mut snd_pcm_access_mask_t,
        src: *const snd_pcm_access_mask_t,
    );
}
extern "C" {
    pub fn snd_pcm_access_mask_none(mask: *mut snd_pcm_access_mask_t);
}
extern "C" {
    pub fn snd_pcm_access_mask_any(mask: *mut snd_pcm_access_mask_t);
}
extern "C" {
    pub fn snd_pcm_access_mask_test(
        mask: *const snd_pcm_access_mask_t,
        val: snd_pcm_access_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_access_mask_empty(mask: *const snd_pcm_access_mask_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_access_mask_set(mask: *mut snd_pcm_access_mask_t, val: snd_pcm_access_t);
}
extern "C" {
    pub fn snd_pcm_access_mask_reset(mask: *mut snd_pcm_access_mask_t, val: snd_pcm_access_t);
}
extern "C" {
    #[doc = " \\defgroup PCM_Format Format Mask Functions"]
    #[doc = " \\ingroup PCM"]
    #[doc = " See the \\ref pcm page for more details."]
    #[doc = " \\{"]
    pub fn snd_pcm_format_mask_sizeof() -> usize;
}
extern "C" {
    pub fn snd_pcm_format_mask_malloc(
        ptr: *mut *mut snd_pcm_format_mask_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_format_mask_free(obj: *mut snd_pcm_format_mask_t);
}
extern "C" {
    pub fn snd_pcm_format_mask_copy(
        dst: *mut snd_pcm_format_mask_t,
        src: *const snd_pcm_format_mask_t,
    );
}
extern "C" {
    pub fn snd_pcm_format_mask_none(mask: *mut snd_pcm_format_mask_t);
}
extern "C" {
    pub fn snd_pcm_format_mask_any(mask: *mut snd_pcm_format_mask_t);
}
extern "C" {
    pub fn snd_pcm_format_mask_test(
        mask: *const snd_pcm_format_mask_t,
        val: snd_pcm_format_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_format_mask_empty(mask: *const snd_pcm_format_mask_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_format_mask_set(mask: *mut snd_pcm_format_mask_t, val: snd_pcm_format_t);
}
extern "C" {
    pub fn snd_pcm_format_mask_reset(mask: *mut snd_pcm_format_mask_t, val: snd_pcm_format_t);
}
extern "C" {
    #[doc = " \\defgroup PCM_SubFormat Subformat Mask Functions"]
    #[doc = " \\ingroup PCM"]
    #[doc = " See the \\ref pcm page for more details."]
    #[doc = " \\{"]
    pub fn snd_pcm_subformat_mask_sizeof() -> usize;
}
extern "C" {
    pub fn snd_pcm_subformat_mask_malloc(
        ptr: *mut *mut snd_pcm_subformat_mask_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_subformat_mask_free(obj: *mut snd_pcm_subformat_mask_t);
}
extern "C" {
    pub fn snd_pcm_subformat_mask_copy(
        dst: *mut snd_pcm_subformat_mask_t,
        src: *const snd_pcm_subformat_mask_t,
    );
}
extern "C" {
    pub fn snd_pcm_subformat_mask_none(mask: *mut snd_pcm_subformat_mask_t);
}
extern "C" {
    pub fn snd_pcm_subformat_mask_any(mask: *mut snd_pcm_subformat_mask_t);
}
extern "C" {
    pub fn snd_pcm_subformat_mask_test(
        mask: *const snd_pcm_subformat_mask_t,
        val: snd_pcm_subformat_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_subformat_mask_empty(
        mask: *const snd_pcm_subformat_mask_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_subformat_mask_set(
        mask: *mut snd_pcm_subformat_mask_t,
        val: snd_pcm_subformat_t,
    );
}
extern "C" {
    pub fn snd_pcm_subformat_mask_reset(
        mask: *mut snd_pcm_subformat_mask_t,
        val: snd_pcm_subformat_t,
    );
}
extern "C" {
    #[doc = " \\defgroup PCM_Status Status Functions"]
    #[doc = " \\ingroup PCM"]
    #[doc = " See the \\ref pcm page for more details."]
    #[doc = " \\{"]
    pub fn snd_pcm_status_sizeof() -> usize;
}
extern "C" {
    pub fn snd_pcm_status_malloc(ptr: *mut *mut snd_pcm_status_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_status_free(obj: *mut snd_pcm_status_t);
}
extern "C" {
    pub fn snd_pcm_status_copy(dst: *mut snd_pcm_status_t, src: *const snd_pcm_status_t);
}
extern "C" {
    pub fn snd_pcm_status_get_state(obj: *const snd_pcm_status_t) -> snd_pcm_state_t;
}
extern "C" {
    pub fn snd_pcm_status_get_trigger_tstamp(
        obj: *const snd_pcm_status_t,
        ptr: *mut snd_timestamp_t,
    );
}
extern "C" {
    pub fn snd_pcm_status_get_trigger_htstamp(
        obj: *const snd_pcm_status_t,
        ptr: *mut snd_htimestamp_t,
    );
}
extern "C" {
    pub fn snd_pcm_status_get_tstamp(obj: *const snd_pcm_status_t, ptr: *mut snd_timestamp_t);
}
extern "C" {
    pub fn snd_pcm_status_get_htstamp(obj: *const snd_pcm_status_t, ptr: *mut snd_htimestamp_t);
}
extern "C" {
    pub fn snd_pcm_status_get_audio_htstamp(
        obj: *const snd_pcm_status_t,
        ptr: *mut snd_htimestamp_t,
    );
}
extern "C" {
    pub fn snd_pcm_status_get_driver_htstamp(
        obj: *const snd_pcm_status_t,
        ptr: *mut snd_htimestamp_t,
    );
}
extern "C" {
    pub fn snd_pcm_status_get_audio_htstamp_report(
        obj: *const snd_pcm_status_t,
        audio_tstamp_report: *mut snd_pcm_audio_tstamp_report_t,
    );
}
extern "C" {
    pub fn snd_pcm_status_set_audio_htstamp_config(
        obj: *mut snd_pcm_status_t,
        audio_tstamp_config: *mut snd_pcm_audio_tstamp_config_t,
    );
}
extern "C" {
    pub fn snd_pcm_status_get_delay(obj: *const snd_pcm_status_t) -> snd_pcm_sframes_t;
}
extern "C" {
    pub fn snd_pcm_status_get_avail(obj: *const snd_pcm_status_t) -> snd_pcm_uframes_t;
}
extern "C" {
    pub fn snd_pcm_status_get_avail_max(obj: *const snd_pcm_status_t) -> snd_pcm_uframes_t;
}
extern "C" {
    pub fn snd_pcm_status_get_overrange(obj: *const snd_pcm_status_t) -> snd_pcm_uframes_t;
}
extern "C" {
    #[doc = " \\defgroup PCM_Description Description Functions"]
    #[doc = " \\ingroup PCM"]
    #[doc = " See the \\ref pcm page for more details."]
    #[doc = " \\{"]
    pub fn snd_pcm_type_name(type_: snd_pcm_type_t) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn snd_pcm_stream_name(stream: snd_pcm_stream_t) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn snd_pcm_access_name(_access: snd_pcm_access_t) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn snd_pcm_format_name(format: snd_pcm_format_t) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn snd_pcm_format_description(format: snd_pcm_format_t) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn snd_pcm_subformat_name(subformat: snd_pcm_subformat_t) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn snd_pcm_subformat_description(
        subformat: snd_pcm_subformat_t,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn snd_pcm_format_value(name: *const ::std::os::raw::c_char) -> snd_pcm_format_t;
}
extern "C" {
    pub fn snd_pcm_tstamp_mode_name(mode: snd_pcm_tstamp_t) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn snd_pcm_state_name(state: snd_pcm_state_t) -> *const ::std::os::raw::c_char;
}
extern "C" {
    #[doc = " \\defgroup PCM_Dump Debug Functions"]
    #[doc = " \\ingroup PCM"]
    #[doc = " See the \\ref pcm page for more details."]
    #[doc = " \\{"]
    pub fn snd_pcm_dump(pcm: *mut snd_pcm_t, out: *mut snd_output_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_dump_hw_setup(
        pcm: *mut snd_pcm_t,
        out: *mut snd_output_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_dump_sw_setup(
        pcm: *mut snd_pcm_t,
        out: *mut snd_output_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_dump_setup(pcm: *mut snd_pcm_t, out: *mut snd_output_t)
        -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hw_params_dump(
        params: *mut snd_pcm_hw_params_t,
        out: *mut snd_output_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_sw_params_dump(
        params: *mut snd_pcm_sw_params_t,
        out: *mut snd_output_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_status_dump(
        status: *mut snd_pcm_status_t,
        out: *mut snd_output_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " \\defgroup PCM_Direct Direct Access (MMAP) Functions"]
    #[doc = " \\ingroup PCM"]
    #[doc = " See the \\ref pcm page for more details."]
    #[doc = " \\{"]
    pub fn snd_pcm_mmap_begin(
        pcm: *mut snd_pcm_t,
        areas: *mut *const snd_pcm_channel_area_t,
        offset: *mut snd_pcm_uframes_t,
        frames: *mut snd_pcm_uframes_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_mmap_commit(
        pcm: *mut snd_pcm_t,
        offset: snd_pcm_uframes_t,
        frames: snd_pcm_uframes_t,
    ) -> snd_pcm_sframes_t;
}
extern "C" {
    pub fn snd_pcm_mmap_writei(
        pcm: *mut snd_pcm_t,
        buffer: *const ::std::os::raw::c_void,
        size: snd_pcm_uframes_t,
    ) -> snd_pcm_sframes_t;
}
extern "C" {
    pub fn snd_pcm_mmap_readi(
        pcm: *mut snd_pcm_t,
        buffer: *mut ::std::os::raw::c_void,
        size: snd_pcm_uframes_t,
    ) -> snd_pcm_sframes_t;
}
extern "C" {
    pub fn snd_pcm_mmap_writen(
        pcm: *mut snd_pcm_t,
        bufs: *mut *mut ::std::os::raw::c_void,
        size: snd_pcm_uframes_t,
    ) -> snd_pcm_sframes_t;
}
extern "C" {
    pub fn snd_pcm_mmap_readn(
        pcm: *mut snd_pcm_t,
        bufs: *mut *mut ::std::os::raw::c_void,
        size: snd_pcm_uframes_t,
    ) -> snd_pcm_sframes_t;
}
extern "C" {
    #[doc = " \\defgroup PCM_Helpers Helper Functions"]
    #[doc = " \\ingroup PCM"]
    #[doc = " See the \\ref pcm page for more details."]
    #[doc = " \\{"]
    pub fn snd_pcm_format_signed(format: snd_pcm_format_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_format_unsigned(format: snd_pcm_format_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_format_linear(format: snd_pcm_format_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_format_float(format: snd_pcm_format_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_format_little_endian(format: snd_pcm_format_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_format_big_endian(format: snd_pcm_format_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_format_cpu_endian(format: snd_pcm_format_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_format_width(format: snd_pcm_format_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_format_physical_width(format: snd_pcm_format_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_build_linear_format(
        width: ::std::os::raw::c_int,
        pwidth: ::std::os::raw::c_int,
        unsignd: ::std::os::raw::c_int,
        big_endian: ::std::os::raw::c_int,
    ) -> snd_pcm_format_t;
}
extern "C" {
    pub fn snd_pcm_format_size(format: snd_pcm_format_t, samples: usize) -> isize;
}
extern "C" {
    pub fn snd_pcm_format_silence(format: snd_pcm_format_t) -> u8;
}
extern "C" {
    pub fn snd_pcm_format_silence_16(format: snd_pcm_format_t) -> u16;
}
extern "C" {
    pub fn snd_pcm_format_silence_32(format: snd_pcm_format_t) -> u32;
}
extern "C" {
    pub fn snd_pcm_format_silence_64(format: snd_pcm_format_t) -> u64;
}
extern "C" {
    pub fn snd_pcm_format_set_silence(
        format: snd_pcm_format_t,
        buf: *mut ::std::os::raw::c_void,
        samples: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_bytes_to_frames(pcm: *mut snd_pcm_t, bytes: isize) -> snd_pcm_sframes_t;
}
extern "C" {
    pub fn snd_pcm_frames_to_bytes(pcm: *mut snd_pcm_t, frames: snd_pcm_sframes_t) -> isize;
}
extern "C" {
    pub fn snd_pcm_bytes_to_samples(pcm: *mut snd_pcm_t, bytes: isize) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn snd_pcm_samples_to_bytes(pcm: *mut snd_pcm_t, samples: ::std::os::raw::c_long) -> isize;
}
extern "C" {
    pub fn snd_pcm_area_silence(
        dst_channel: *const snd_pcm_channel_area_t,
        dst_offset: snd_pcm_uframes_t,
        samples: ::std::os::raw::c_uint,
        format: snd_pcm_format_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_areas_silence(
        dst_channels: *const snd_pcm_channel_area_t,
        dst_offset: snd_pcm_uframes_t,
        channels: ::std::os::raw::c_uint,
        frames: snd_pcm_uframes_t,
        format: snd_pcm_format_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_area_copy(
        dst_channel: *const snd_pcm_channel_area_t,
        dst_offset: snd_pcm_uframes_t,
        src_channel: *const snd_pcm_channel_area_t,
        src_offset: snd_pcm_uframes_t,
        samples: ::std::os::raw::c_uint,
        format: snd_pcm_format_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_areas_copy(
        dst_channels: *const snd_pcm_channel_area_t,
        dst_offset: snd_pcm_uframes_t,
        src_channels: *const snd_pcm_channel_area_t,
        src_offset: snd_pcm_uframes_t,
        channels: ::std::os::raw::c_uint,
        frames: snd_pcm_uframes_t,
        format: snd_pcm_format_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_areas_copy_wrap(
        dst_channels: *const snd_pcm_channel_area_t,
        dst_offset: snd_pcm_uframes_t,
        dst_size: snd_pcm_uframes_t,
        src_channels: *const snd_pcm_channel_area_t,
        src_offset: snd_pcm_uframes_t,
        src_size: snd_pcm_uframes_t,
        channels: ::std::os::raw::c_uint,
        frames: snd_pcm_uframes_t,
        format: snd_pcm_format_t,
    ) -> ::std::os::raw::c_int;
}
pub const SND_PCM_HOOK_TYPE_HW_PARAMS: _snd_pcm_hook_type = 0;
pub const SND_PCM_HOOK_TYPE_HW_FREE: _snd_pcm_hook_type = 1;
pub const SND_PCM_HOOK_TYPE_CLOSE: _snd_pcm_hook_type = 2;
pub const SND_PCM_HOOK_TYPE_LAST: _snd_pcm_hook_type = 2;
#[doc = " type of pcm hook"]
pub type _snd_pcm_hook_type = ::std::os::raw::c_uint;
#[doc = " type of pcm hook"]
pub use self::_snd_pcm_hook_type as snd_pcm_hook_type_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _snd_pcm_hook {
    _unused: [u8; 0],
}
#[doc = " PCM hook container"]
pub type snd_pcm_hook_t = _snd_pcm_hook;
#[doc = " PCM hook callback function"]
pub type snd_pcm_hook_func_t =
    ::std::option::Option<unsafe extern "C" fn(hook: *mut snd_pcm_hook_t) -> ::std::os::raw::c_int>;
extern "C" {
    pub fn snd_pcm_hook_get_pcm(hook: *mut snd_pcm_hook_t) -> *mut snd_pcm_t;
}
extern "C" {
    pub fn snd_pcm_hook_get_private(hook: *mut snd_pcm_hook_t) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn snd_pcm_hook_set_private(
        hook: *mut snd_pcm_hook_t,
        private_data: *mut ::std::os::raw::c_void,
    );
}
extern "C" {
    pub fn snd_pcm_hook_add(
        hookp: *mut *mut snd_pcm_hook_t,
        pcm: *mut snd_pcm_t,
        type_: snd_pcm_hook_type_t,
        func: snd_pcm_hook_func_t,
        private_data: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hook_remove(hook: *mut snd_pcm_hook_t) -> ::std::os::raw::c_int;
}
#[doc = " #SND_PCM_TYPE_METER scope functions"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _snd_pcm_scope_ops {
    #[doc = " \\brief Enable and prepare it using current params"]
    #[doc = " \\param scope scope handle"]
    pub enable: ::std::option::Option<
        unsafe extern "C" fn(scope: *mut snd_pcm_scope_t) -> ::std::os::raw::c_int,
    >,
    #[doc = " \\brief Disable"]
    #[doc = " \\param scope scope handle"]
    pub disable: ::std::option::Option<unsafe extern "C" fn(scope: *mut snd_pcm_scope_t)>,
    #[doc = " \\brief PCM has been started"]
    #[doc = " \\param scope scope handle"]
    pub start: ::std::option::Option<unsafe extern "C" fn(scope: *mut snd_pcm_scope_t)>,
    #[doc = " \\brief PCM has been stopped"]
    #[doc = " \\param scope scope handle"]
    pub stop: ::std::option::Option<unsafe extern "C" fn(scope: *mut snd_pcm_scope_t)>,
    #[doc = " \\brief New frames are present"]
    #[doc = " \\param scope scope handle"]
    pub update: ::std::option::Option<unsafe extern "C" fn(scope: *mut snd_pcm_scope_t)>,
    #[doc = " \\brief Reset status"]
    #[doc = " \\param scope scope handle"]
    pub reset: ::std::option::Option<unsafe extern "C" fn(scope: *mut snd_pcm_scope_t)>,
    #[doc = " \\brief PCM is closing"]
    #[doc = " \\param scope scope handle"]
    pub close: ::std::option::Option<unsafe extern "C" fn(scope: *mut snd_pcm_scope_t)>,
}
#[doc = " #SND_PCM_TYPE_METER scope functions"]
pub type snd_pcm_scope_ops_t = _snd_pcm_scope_ops;
extern "C" {
    pub fn snd_pcm_meter_get_bufsize(pcm: *mut snd_pcm_t) -> snd_pcm_uframes_t;
}
extern "C" {
    pub fn snd_pcm_meter_get_channels(pcm: *mut snd_pcm_t) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn snd_pcm_meter_get_rate(pcm: *mut snd_pcm_t) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn snd_pcm_meter_get_now(pcm: *mut snd_pcm_t) -> snd_pcm_uframes_t;
}
extern "C" {
    pub fn snd_pcm_meter_get_boundary(pcm: *mut snd_pcm_t) -> snd_pcm_uframes_t;
}
extern "C" {
    pub fn snd_pcm_meter_add_scope(
        pcm: *mut snd_pcm_t,
        scope: *mut snd_pcm_scope_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_meter_search_scope(
        pcm: *mut snd_pcm_t,
        name: *const ::std::os::raw::c_char,
    ) -> *mut snd_pcm_scope_t;
}
extern "C" {
    pub fn snd_pcm_scope_malloc(ptr: *mut *mut snd_pcm_scope_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_scope_set_ops(scope: *mut snd_pcm_scope_t, val: *const snd_pcm_scope_ops_t);
}
extern "C" {
    pub fn snd_pcm_scope_set_name(scope: *mut snd_pcm_scope_t, val: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn snd_pcm_scope_get_name(scope: *mut snd_pcm_scope_t) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn snd_pcm_scope_get_callback_private(
        scope: *mut snd_pcm_scope_t,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn snd_pcm_scope_set_callback_private(
        scope: *mut snd_pcm_scope_t,
        val: *mut ::std::os::raw::c_void,
    );
}
extern "C" {
    pub fn snd_pcm_scope_s16_open(
        pcm: *mut snd_pcm_t,
        name: *const ::std::os::raw::c_char,
        scopep: *mut *mut snd_pcm_scope_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_scope_s16_get_channel_buffer(
        scope: *mut snd_pcm_scope_t,
        channel: ::std::os::raw::c_uint,
    ) -> *mut i16;
}
#[doc = " standard latency - for standard playback or capture"]
#[doc = "(estimated latency in one direction 350ms)"]
pub const SND_SPCM_LATENCY_STANDARD: _snd_spcm_latency = 0;
#[doc = " medium latency - software phones etc."]
#[doc = "(estimated latency in one direction maximally 25ms"]
pub const SND_SPCM_LATENCY_MEDIUM: _snd_spcm_latency = 1;
#[doc = " realtime latency - realtime applications (effect processors etc.)"]
#[doc = "(estimated latency in one direction 5ms and better)"]
pub const SND_SPCM_LATENCY_REALTIME: _snd_spcm_latency = 2;
#[doc = " Simple PCM latency type"]
pub type _snd_spcm_latency = ::std::os::raw::c_uint;
#[doc = " Simple PCM latency type"]
pub use self::_snd_spcm_latency as snd_spcm_latency_t;
#[doc = " driver / library will ignore all xruns, the stream runs forever"]
pub const SND_SPCM_XRUN_IGNORE: _snd_spcm_xrun_type = 0;
#[doc = " driver / library stops the stream when an xrun occurs"]
pub const SND_SPCM_XRUN_STOP: _snd_spcm_xrun_type = 1;
#[doc = " Simple PCM xrun type"]
pub type _snd_spcm_xrun_type = ::std::os::raw::c_uint;
#[doc = " Simple PCM xrun type"]
pub use self::_snd_spcm_xrun_type as snd_spcm_xrun_type_t;
#[doc = " liberal duplex - the buffer and period sizes might not match"]
pub const SND_SPCM_DUPLEX_LIBERAL: _snd_spcm_duplex_type = 0;
#[doc = " pedantic duplex - the buffer and period sizes MUST match"]
pub const SND_SPCM_DUPLEX_PEDANTIC: _snd_spcm_duplex_type = 1;
#[doc = " Simple PCM duplex type"]
pub type _snd_spcm_duplex_type = ::std::os::raw::c_uint;
#[doc = " Simple PCM duplex type"]
pub use self::_snd_spcm_duplex_type as snd_spcm_duplex_type_t;
extern "C" {
    pub fn snd_spcm_init(
        pcm: *mut snd_pcm_t,
        rate: ::std::os::raw::c_uint,
        channels: ::std::os::raw::c_uint,
        format: snd_pcm_format_t,
        subformat: snd_pcm_subformat_t,
        latency: snd_spcm_latency_t,
        _access: snd_pcm_access_t,
        xrun_type: snd_spcm_xrun_type_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_spcm_init_duplex(
        playback_pcm: *mut snd_pcm_t,
        capture_pcm: *mut snd_pcm_t,
        rate: ::std::os::raw::c_uint,
        channels: ::std::os::raw::c_uint,
        format: snd_pcm_format_t,
        subformat: snd_pcm_subformat_t,
        latency: snd_spcm_latency_t,
        _access: snd_pcm_access_t,
        xrun_type: snd_spcm_xrun_type_t,
        duplex_type: snd_spcm_duplex_type_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_spcm_init_get_params(
        pcm: *mut snd_pcm_t,
        rate: *mut ::std::os::raw::c_uint,
        buffer_size: *mut snd_pcm_uframes_t,
        period_size: *mut snd_pcm_uframes_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " \\defgroup PCM_Deprecated Deprecated Functions"]
    #[doc = " \\ingroup PCM"]
    #[doc = " See the \\ref pcm page for more details."]
    #[doc = " \\{"]
    pub fn snd_pcm_start_mode_name(mode: snd_pcm_start_t) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn snd_pcm_xrun_mode_name(mode: snd_pcm_xrun_t) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn snd_pcm_sw_params_set_start_mode(
        pcm: *mut snd_pcm_t,
        params: *mut snd_pcm_sw_params_t,
        val: snd_pcm_start_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_sw_params_get_start_mode(params: *const snd_pcm_sw_params_t) -> snd_pcm_start_t;
}
extern "C" {
    pub fn snd_pcm_sw_params_set_xrun_mode(
        pcm: *mut snd_pcm_t,
        params: *mut snd_pcm_sw_params_t,
        val: snd_pcm_xrun_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_sw_params_get_xrun_mode(params: *const snd_pcm_sw_params_t) -> snd_pcm_xrun_t;
}
extern "C" {
    pub fn snd_pcm_sw_params_set_xfer_align(
        pcm: *mut snd_pcm_t,
        params: *mut snd_pcm_sw_params_t,
        val: snd_pcm_uframes_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_sw_params_get_xfer_align(
        params: *const snd_pcm_sw_params_t,
        val: *mut snd_pcm_uframes_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_sw_params_set_sleep_min(
        pcm: *mut snd_pcm_t,
        params: *mut snd_pcm_sw_params_t,
        val: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_sw_params_get_sleep_min(
        params: *const snd_pcm_sw_params_t,
        val: *mut ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hw_params_get_tick_time(
        params: *const snd_pcm_hw_params_t,
        val: *mut ::std::os::raw::c_uint,
        dir: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hw_params_get_tick_time_min(
        params: *const snd_pcm_hw_params_t,
        val: *mut ::std::os::raw::c_uint,
        dir: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hw_params_get_tick_time_max(
        params: *const snd_pcm_hw_params_t,
        val: *mut ::std::os::raw::c_uint,
        dir: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hw_params_test_tick_time(
        pcm: *mut snd_pcm_t,
        params: *mut snd_pcm_hw_params_t,
        val: ::std::os::raw::c_uint,
        dir: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hw_params_set_tick_time(
        pcm: *mut snd_pcm_t,
        params: *mut snd_pcm_hw_params_t,
        val: ::std::os::raw::c_uint,
        dir: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hw_params_set_tick_time_min(
        pcm: *mut snd_pcm_t,
        params: *mut snd_pcm_hw_params_t,
        val: *mut ::std::os::raw::c_uint,
        dir: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hw_params_set_tick_time_max(
        pcm: *mut snd_pcm_t,
        params: *mut snd_pcm_hw_params_t,
        val: *mut ::std::os::raw::c_uint,
        dir: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hw_params_set_tick_time_minmax(
        pcm: *mut snd_pcm_t,
        params: *mut snd_pcm_hw_params_t,
        min: *mut ::std::os::raw::c_uint,
        mindir: *mut ::std::os::raw::c_int,
        max: *mut ::std::os::raw::c_uint,
        maxdir: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hw_params_set_tick_time_near(
        pcm: *mut snd_pcm_t,
        params: *mut snd_pcm_hw_params_t,
        val: *mut ::std::os::raw::c_uint,
        dir: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hw_params_set_tick_time_first(
        pcm: *mut snd_pcm_t,
        params: *mut snd_pcm_hw_params_t,
        val: *mut ::std::os::raw::c_uint,
        dir: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_pcm_hw_params_set_tick_time_last(
        pcm: *mut snd_pcm_t,
        params: *mut snd_pcm_hw_params_t,
        val: *mut ::std::os::raw::c_uint,
        dir: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _snd_rawmidi_info {
    _unused: [u8; 0],
}
#[doc = " RawMidi information container"]
pub type snd_rawmidi_info_t = _snd_rawmidi_info;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _snd_rawmidi_params {
    _unused: [u8; 0],
}
#[doc = " RawMidi settings container"]
pub type snd_rawmidi_params_t = _snd_rawmidi_params;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _snd_rawmidi_status {
    _unused: [u8; 0],
}
#[doc = " RawMidi status container"]
pub type snd_rawmidi_status_t = _snd_rawmidi_status;
#[doc = " Output stream"]
pub const SND_RAWMIDI_STREAM_OUTPUT: _snd_rawmidi_stream = 0;
#[doc = " Input stream"]
pub const SND_RAWMIDI_STREAM_INPUT: _snd_rawmidi_stream = 1;
#[doc = " Input stream"]
pub const SND_RAWMIDI_STREAM_LAST: _snd_rawmidi_stream = 1;
#[doc = " RawMidi stream (direction)"]
pub type _snd_rawmidi_stream = ::std::os::raw::c_uint;
#[doc = " RawMidi stream (direction)"]
pub use self::_snd_rawmidi_stream as snd_rawmidi_stream_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _snd_rawmidi {
    _unused: [u8; 0],
}
#[doc = " RawMidi handle"]
pub type snd_rawmidi_t = _snd_rawmidi;
#[doc = " Kernel level RawMidi"]
pub const SND_RAWMIDI_TYPE_HW: _snd_rawmidi_type = 0;
#[doc = " Shared memory client RawMidi (not yet implemented)"]
pub const SND_RAWMIDI_TYPE_SHM: _snd_rawmidi_type = 1;
#[doc = " INET client RawMidi (not yet implemented)"]
pub const SND_RAWMIDI_TYPE_INET: _snd_rawmidi_type = 2;
#[doc = " Virtual (sequencer) RawMidi"]
pub const SND_RAWMIDI_TYPE_VIRTUAL: _snd_rawmidi_type = 3;
#[doc = " RawMidi type"]
pub type _snd_rawmidi_type = ::std::os::raw::c_uint;
#[doc = " RawMidi type"]
pub use self::_snd_rawmidi_type as snd_rawmidi_type_t;
extern "C" {
    pub fn snd_rawmidi_open(
        in_rmidi: *mut *mut snd_rawmidi_t,
        out_rmidi: *mut *mut snd_rawmidi_t,
        name: *const ::std::os::raw::c_char,
        mode: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_rawmidi_open_lconf(
        in_rmidi: *mut *mut snd_rawmidi_t,
        out_rmidi: *mut *mut snd_rawmidi_t,
        name: *const ::std::os::raw::c_char,
        mode: ::std::os::raw::c_int,
        lconf: *mut snd_config_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_rawmidi_close(rmidi: *mut snd_rawmidi_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_rawmidi_poll_descriptors_count(rmidi: *mut snd_rawmidi_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_rawmidi_poll_descriptors(
        rmidi: *mut snd_rawmidi_t,
        pfds: *mut pollfd,
        space: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_rawmidi_poll_descriptors_revents(
        rawmidi: *mut snd_rawmidi_t,
        pfds: *mut pollfd,
        nfds: ::std::os::raw::c_uint,
        revent: *mut ::std::os::raw::c_ushort,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_rawmidi_nonblock(
        rmidi: *mut snd_rawmidi_t,
        nonblock: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_rawmidi_info_sizeof() -> usize;
}
extern "C" {
    pub fn snd_rawmidi_info_malloc(ptr: *mut *mut snd_rawmidi_info_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_rawmidi_info_free(obj: *mut snd_rawmidi_info_t);
}
extern "C" {
    pub fn snd_rawmidi_info_copy(dst: *mut snd_rawmidi_info_t, src: *const snd_rawmidi_info_t);
}
extern "C" {
    pub fn snd_rawmidi_info_get_device(obj: *const snd_rawmidi_info_t) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn snd_rawmidi_info_get_subdevice(obj: *const snd_rawmidi_info_t)
        -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn snd_rawmidi_info_get_stream(obj: *const snd_rawmidi_info_t) -> snd_rawmidi_stream_t;
}
extern "C" {
    pub fn snd_rawmidi_info_get_card(obj: *const snd_rawmidi_info_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_rawmidi_info_get_flags(obj: *const snd_rawmidi_info_t) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn snd_rawmidi_info_get_id(obj: *const snd_rawmidi_info_t)
        -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn snd_rawmidi_info_get_name(
        obj: *const snd_rawmidi_info_t,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn snd_rawmidi_info_get_subdevice_name(
        obj: *const snd_rawmidi_info_t,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn snd_rawmidi_info_get_subdevices_count(
        obj: *const snd_rawmidi_info_t,
    ) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn snd_rawmidi_info_get_subdevices_avail(
        obj: *const snd_rawmidi_info_t,
    ) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn snd_rawmidi_info_set_device(obj: *mut snd_rawmidi_info_t, val: ::std::os::raw::c_uint);
}
extern "C" {
    pub fn snd_rawmidi_info_set_subdevice(
        obj: *mut snd_rawmidi_info_t,
        val: ::std::os::raw::c_uint,
    );
}
extern "C" {
    pub fn snd_rawmidi_info_set_stream(obj: *mut snd_rawmidi_info_t, val: snd_rawmidi_stream_t);
}
extern "C" {
    pub fn snd_rawmidi_info(
        rmidi: *mut snd_rawmidi_t,
        info: *mut snd_rawmidi_info_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_rawmidi_params_sizeof() -> usize;
}
extern "C" {
    pub fn snd_rawmidi_params_malloc(ptr: *mut *mut snd_rawmidi_params_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_rawmidi_params_free(obj: *mut snd_rawmidi_params_t);
}
extern "C" {
    pub fn snd_rawmidi_params_copy(
        dst: *mut snd_rawmidi_params_t,
        src: *const snd_rawmidi_params_t,
    );
}
extern "C" {
    pub fn snd_rawmidi_params_set_buffer_size(
        rmidi: *mut snd_rawmidi_t,
        params: *mut snd_rawmidi_params_t,
        val: usize,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_rawmidi_params_get_buffer_size(params: *const snd_rawmidi_params_t) -> usize;
}
extern "C" {
    pub fn snd_rawmidi_params_set_avail_min(
        rmidi: *mut snd_rawmidi_t,
        params: *mut snd_rawmidi_params_t,
        val: usize,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_rawmidi_params_get_avail_min(params: *const snd_rawmidi_params_t) -> usize;
}
extern "C" {
    pub fn snd_rawmidi_params_set_no_active_sensing(
        rmidi: *mut snd_rawmidi_t,
        params: *mut snd_rawmidi_params_t,
        val: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_rawmidi_params_get_no_active_sensing(
        params: *const snd_rawmidi_params_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_rawmidi_params(
        rmidi: *mut snd_rawmidi_t,
        params: *mut snd_rawmidi_params_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_rawmidi_params_current(
        rmidi: *mut snd_rawmidi_t,
        params: *mut snd_rawmidi_params_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_rawmidi_status_sizeof() -> usize;
}
extern "C" {
    pub fn snd_rawmidi_status_malloc(ptr: *mut *mut snd_rawmidi_status_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_rawmidi_status_free(obj: *mut snd_rawmidi_status_t);
}
extern "C" {
    pub fn snd_rawmidi_status_copy(
        dst: *mut snd_rawmidi_status_t,
        src: *const snd_rawmidi_status_t,
    );
}
extern "C" {
    pub fn snd_rawmidi_status_get_tstamp(
        obj: *const snd_rawmidi_status_t,
        ptr: *mut snd_htimestamp_t,
    );
}
extern "C" {
    pub fn snd_rawmidi_status_get_avail(obj: *const snd_rawmidi_status_t) -> usize;
}
extern "C" {
    pub fn snd_rawmidi_status_get_xruns(obj: *const snd_rawmidi_status_t) -> usize;
}
extern "C" {
    pub fn snd_rawmidi_status(
        rmidi: *mut snd_rawmidi_t,
        status: *mut snd_rawmidi_status_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_rawmidi_drain(rmidi: *mut snd_rawmidi_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_rawmidi_drop(rmidi: *mut snd_rawmidi_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_rawmidi_write(
        rmidi: *mut snd_rawmidi_t,
        buffer: *const ::std::os::raw::c_void,
        size: usize,
    ) -> isize;
}
extern "C" {
    pub fn snd_rawmidi_read(
        rmidi: *mut snd_rawmidi_t,
        buffer: *mut ::std::os::raw::c_void,
        size: usize,
    ) -> isize;
}
extern "C" {
    pub fn snd_rawmidi_name(rmidi: *mut snd_rawmidi_t) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn snd_rawmidi_type(rmidi: *mut snd_rawmidi_t) -> snd_rawmidi_type_t;
}
extern "C" {
    pub fn snd_rawmidi_stream(rawmidi: *mut snd_rawmidi_t) -> snd_rawmidi_stream_t;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _snd_timer_id {
    _unused: [u8; 0],
}
#[doc = " timer identification structure"]
pub type snd_timer_id_t = _snd_timer_id;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _snd_timer_ginfo {
    _unused: [u8; 0],
}
#[doc = " timer global info structure"]
pub type snd_timer_ginfo_t = _snd_timer_ginfo;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _snd_timer_gparams {
    _unused: [u8; 0],
}
#[doc = " timer global params structure"]
pub type snd_timer_gparams_t = _snd_timer_gparams;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _snd_timer_gstatus {
    _unused: [u8; 0],
}
#[doc = " timer global status structure"]
pub type snd_timer_gstatus_t = _snd_timer_gstatus;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _snd_timer_info {
    _unused: [u8; 0],
}
#[doc = " timer info structure"]
pub type snd_timer_info_t = _snd_timer_info;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _snd_timer_params {
    _unused: [u8; 0],
}
#[doc = " timer params structure"]
pub type snd_timer_params_t = _snd_timer_params;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _snd_timer_status {
    _unused: [u8; 0],
}
#[doc = " timer status structure"]
pub type snd_timer_status_t = _snd_timer_status;
#[doc = "< invalid"]
pub const SND_TIMER_CLASS_NONE: _snd_timer_class = -1;
#[doc = "< slave timer"]
pub const SND_TIMER_CLASS_SLAVE: _snd_timer_class = 0;
#[doc = "< global timer"]
pub const SND_TIMER_CLASS_GLOBAL: _snd_timer_class = 1;
#[doc = "< card timer"]
pub const SND_TIMER_CLASS_CARD: _snd_timer_class = 2;
#[doc = "< PCM timer"]
pub const SND_TIMER_CLASS_PCM: _snd_timer_class = 3;
#[doc = "< last timer"]
pub const SND_TIMER_CLASS_LAST: _snd_timer_class = 3;
#[doc = " timer master class"]
pub type _snd_timer_class = ::std::os::raw::c_int;
#[doc = " timer master class"]
pub use self::_snd_timer_class as snd_timer_class_t;
#[doc = "< none"]
pub const SND_TIMER_SCLASS_NONE: _snd_timer_slave_class = 0;
#[doc = "< for internal use"]
pub const SND_TIMER_SCLASS_APPLICATION: _snd_timer_slave_class = 1;
#[doc = "< sequencer timer"]
pub const SND_TIMER_SCLASS_SEQUENCER: _snd_timer_slave_class = 2;
#[doc = "< OSS sequencer timer"]
pub const SND_TIMER_SCLASS_OSS_SEQUENCER: _snd_timer_slave_class = 3;
#[doc = "< last slave timer"]
pub const SND_TIMER_SCLASS_LAST: _snd_timer_slave_class = 3;
#[doc = " timer slave class"]
pub type _snd_timer_slave_class = ::std::os::raw::c_uint;
#[doc = " timer slave class"]
pub use self::_snd_timer_slave_class as snd_timer_slave_class_t;
pub const SND_TIMER_EVENT_RESOLUTION: _snd_timer_event = 0;
pub const SND_TIMER_EVENT_TICK: _snd_timer_event = 1;
pub const SND_TIMER_EVENT_START: _snd_timer_event = 2;
pub const SND_TIMER_EVENT_STOP: _snd_timer_event = 3;
pub const SND_TIMER_EVENT_CONTINUE: _snd_timer_event = 4;
pub const SND_TIMER_EVENT_PAUSE: _snd_timer_event = 5;
pub const SND_TIMER_EVENT_EARLY: _snd_timer_event = 6;
pub const SND_TIMER_EVENT_SUSPEND: _snd_timer_event = 7;
pub const SND_TIMER_EVENT_RESUME: _snd_timer_event = 8;
pub const SND_TIMER_EVENT_MSTART: _snd_timer_event = 12;
pub const SND_TIMER_EVENT_MSTOP: _snd_timer_event = 13;
pub const SND_TIMER_EVENT_MCONTINUE: _snd_timer_event = 14;
pub const SND_TIMER_EVENT_MPAUSE: _snd_timer_event = 15;
pub const SND_TIMER_EVENT_MSUSPEND: _snd_timer_event = 17;
pub const SND_TIMER_EVENT_MRESUME: _snd_timer_event = 18;
#[doc = " timer read event identification"]
pub type _snd_timer_event = ::std::os::raw::c_uint;
#[doc = " timer read event identification"]
pub use self::_snd_timer_event as snd_timer_event_t;
#[doc = " timer read structure"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _snd_timer_read {
    #[doc = "< tick resolution in nanoseconds"]
    pub resolution: ::std::os::raw::c_uint,
    #[doc = "< count of happened ticks"]
    pub ticks: ::std::os::raw::c_uint,
}
#[doc = " timer read structure"]
pub type snd_timer_read_t = _snd_timer_read;
#[doc = " timer tstamp + event read structure"]
#[repr(C)]
pub struct _snd_timer_tread {
    #[doc = "< Timer event"]
    pub event: snd_timer_event_t,
    #[doc = "< Time stamp of each event"]
    pub tstamp: snd_htimestamp_t,
    #[doc = "< Event value"]
    pub val: ::std::os::raw::c_uint,
}
#[doc = " timer tstamp + event read structure"]
pub type snd_timer_tread_t = _snd_timer_tread;
#[doc = " Kernel level HwDep"]
pub const SND_TIMER_TYPE_HW: _snd_timer_type = 0;
#[doc = " Shared memory client timer (not yet implemented)"]
pub const SND_TIMER_TYPE_SHM: _snd_timer_type = 1;
#[doc = " INET client timer (not yet implemented)"]
pub const SND_TIMER_TYPE_INET: _snd_timer_type = 2;
#[doc = " timer handle type"]
pub type _snd_timer_type = ::std::os::raw::c_uint;
#[doc = " timer handle type"]
pub use self::_snd_timer_type as snd_timer_type_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _snd_timer_query {
    _unused: [u8; 0],
}
#[doc = " timer query handle"]
pub type snd_timer_query_t = _snd_timer_query;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _snd_timer {
    _unused: [u8; 0],
}
#[doc = " timer handle"]
pub type snd_timer_t = _snd_timer;
extern "C" {
    pub fn snd_timer_query_open(
        handle: *mut *mut snd_timer_query_t,
        name: *const ::std::os::raw::c_char,
        mode: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_timer_query_open_lconf(
        handle: *mut *mut snd_timer_query_t,
        name: *const ::std::os::raw::c_char,
        mode: ::std::os::raw::c_int,
        lconf: *mut snd_config_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_timer_query_close(handle: *mut snd_timer_query_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_timer_query_next_device(
        handle: *mut snd_timer_query_t,
        tid: *mut snd_timer_id_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_timer_query_info(
        handle: *mut snd_timer_query_t,
        info: *mut snd_timer_ginfo_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_timer_query_params(
        handle: *mut snd_timer_query_t,
        params: *mut snd_timer_gparams_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_timer_query_status(
        handle: *mut snd_timer_query_t,
        status: *mut snd_timer_gstatus_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_timer_open(
        handle: *mut *mut snd_timer_t,
        name: *const ::std::os::raw::c_char,
        mode: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_timer_open_lconf(
        handle: *mut *mut snd_timer_t,
        name: *const ::std::os::raw::c_char,
        mode: ::std::os::raw::c_int,
        lconf: *mut snd_config_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_timer_close(handle: *mut snd_timer_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_async_add_timer_handler(
        handler: *mut *mut snd_async_handler_t,
        timer: *mut snd_timer_t,
        callback: snd_async_callback_t,
        private_data: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_async_handler_get_timer(handler: *mut snd_async_handler_t) -> *mut snd_timer_t;
}
extern "C" {
    pub fn snd_timer_poll_descriptors_count(handle: *mut snd_timer_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_timer_poll_descriptors(
        handle: *mut snd_timer_t,
        pfds: *mut pollfd,
        space: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_timer_poll_descriptors_revents(
        timer: *mut snd_timer_t,
        pfds: *mut pollfd,
        nfds: ::std::os::raw::c_uint,
        revents: *mut ::std::os::raw::c_ushort,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_timer_info(
        handle: *mut snd_timer_t,
        timer: *mut snd_timer_info_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_timer_params(
        handle: *mut snd_timer_t,
        params: *mut snd_timer_params_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_timer_status(
        handle: *mut snd_timer_t,
        status: *mut snd_timer_status_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_timer_start(handle: *mut snd_timer_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_timer_stop(handle: *mut snd_timer_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_timer_continue(handle: *mut snd_timer_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_timer_read(
        handle: *mut snd_timer_t,
        buffer: *mut ::std::os::raw::c_void,
        size: usize,
    ) -> isize;
}
extern "C" {
    pub fn snd_timer_id_sizeof() -> usize;
}
extern "C" {
    pub fn snd_timer_id_malloc(ptr: *mut *mut snd_timer_id_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_timer_id_free(obj: *mut snd_timer_id_t);
}
extern "C" {
    pub fn snd_timer_id_copy(dst: *mut snd_timer_id_t, src: *const snd_timer_id_t);
}
extern "C" {
    pub fn snd_timer_id_set_class(id: *mut snd_timer_id_t, dev_class: ::std::os::raw::c_int);
}
extern "C" {
    pub fn snd_timer_id_get_class(id: *mut snd_timer_id_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_timer_id_set_sclass(id: *mut snd_timer_id_t, dev_sclass: ::std::os::raw::c_int);
}
extern "C" {
    pub fn snd_timer_id_get_sclass(id: *mut snd_timer_id_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_timer_id_set_card(id: *mut snd_timer_id_t, card: ::std::os::raw::c_int);
}
extern "C" {
    pub fn snd_timer_id_get_card(id: *mut snd_timer_id_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_timer_id_set_device(id: *mut snd_timer_id_t, device: ::std::os::raw::c_int);
}
extern "C" {
    pub fn snd_timer_id_get_device(id: *mut snd_timer_id_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_timer_id_set_subdevice(id: *mut snd_timer_id_t, subdevice: ::std::os::raw::c_int);
}
extern "C" {
    pub fn snd_timer_id_get_subdevice(id: *mut snd_timer_id_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_timer_ginfo_sizeof() -> usize;
}
extern "C" {
    pub fn snd_timer_ginfo_malloc(ptr: *mut *mut snd_timer_ginfo_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_timer_ginfo_free(obj: *mut snd_timer_ginfo_t);
}
extern "C" {
    pub fn snd_timer_ginfo_copy(dst: *mut snd_timer_ginfo_t, src: *const snd_timer_ginfo_t);
}
extern "C" {
    pub fn snd_timer_ginfo_set_tid(
        obj: *mut snd_timer_ginfo_t,
        tid: *mut snd_timer_id_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_timer_ginfo_get_tid(obj: *mut snd_timer_ginfo_t) -> *mut snd_timer_id_t;
}
extern "C" {
    pub fn snd_timer_ginfo_get_flags(obj: *mut snd_timer_ginfo_t) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn snd_timer_ginfo_get_card(obj: *mut snd_timer_ginfo_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_timer_ginfo_get_id(obj: *mut snd_timer_ginfo_t) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn snd_timer_ginfo_get_name(obj: *mut snd_timer_ginfo_t) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn snd_timer_ginfo_get_resolution(obj: *mut snd_timer_ginfo_t) -> ::std::os::raw::c_ulong;
}
extern "C" {
    pub fn snd_timer_ginfo_get_resolution_min(
        obj: *mut snd_timer_ginfo_t,
    ) -> ::std::os::raw::c_ulong;
}
extern "C" {
    pub fn snd_timer_ginfo_get_resolution_max(
        obj: *mut snd_timer_ginfo_t,
    ) -> ::std::os::raw::c_ulong;
}
extern "C" {
    pub fn snd_timer_ginfo_get_clients(obj: *mut snd_timer_ginfo_t) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn snd_timer_info_sizeof() -> usize;
}
extern "C" {
    pub fn snd_timer_info_malloc(ptr: *mut *mut snd_timer_info_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_timer_info_free(obj: *mut snd_timer_info_t);
}
extern "C" {
    pub fn snd_timer_info_copy(dst: *mut snd_timer_info_t, src: *const snd_timer_info_t);
}
extern "C" {
    pub fn snd_timer_info_is_slave(info: *mut snd_timer_info_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_timer_info_get_card(info: *mut snd_timer_info_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_timer_info_get_id(info: *mut snd_timer_info_t) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn snd_timer_info_get_name(info: *mut snd_timer_info_t) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn snd_timer_info_get_resolution(info: *mut snd_timer_info_t) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn snd_timer_params_sizeof() -> usize;
}
extern "C" {
    pub fn snd_timer_params_malloc(ptr: *mut *mut snd_timer_params_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_timer_params_free(obj: *mut snd_timer_params_t);
}
extern "C" {
    pub fn snd_timer_params_copy(dst: *mut snd_timer_params_t, src: *const snd_timer_params_t);
}
extern "C" {
    pub fn snd_timer_params_set_auto_start(
        params: *mut snd_timer_params_t,
        auto_start: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_timer_params_get_auto_start(
        params: *mut snd_timer_params_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_timer_params_set_exclusive(
        params: *mut snd_timer_params_t,
        exclusive: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_timer_params_get_exclusive(params: *mut snd_timer_params_t)
        -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_timer_params_set_early_event(
        params: *mut snd_timer_params_t,
        early_event: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_timer_params_get_early_event(
        params: *mut snd_timer_params_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_timer_params_set_ticks(
        params: *mut snd_timer_params_t,
        ticks: ::std::os::raw::c_long,
    );
}
extern "C" {
    pub fn snd_timer_params_get_ticks(params: *mut snd_timer_params_t) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn snd_timer_params_set_queue_size(
        params: *mut snd_timer_params_t,
        queue_size: ::std::os::raw::c_long,
    );
}
extern "C" {
    pub fn snd_timer_params_get_queue_size(
        params: *mut snd_timer_params_t,
    ) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn snd_timer_params_set_filter(
        params: *mut snd_timer_params_t,
        filter: ::std::os::raw::c_uint,
    );
}
extern "C" {
    pub fn snd_timer_params_get_filter(params: *mut snd_timer_params_t) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn snd_timer_status_sizeof() -> usize;
}
extern "C" {
    pub fn snd_timer_status_malloc(ptr: *mut *mut snd_timer_status_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_timer_status_free(obj: *mut snd_timer_status_t);
}
extern "C" {
    pub fn snd_timer_status_copy(dst: *mut snd_timer_status_t, src: *const snd_timer_status_t);
}
extern "C" {
    pub fn snd_timer_status_get_timestamp(status: *mut snd_timer_status_t) -> snd_htimestamp_t;
}
extern "C" {
    pub fn snd_timer_status_get_resolution(
        status: *mut snd_timer_status_t,
    ) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn snd_timer_status_get_lost(status: *mut snd_timer_status_t) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn snd_timer_status_get_overrun(status: *mut snd_timer_status_t) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn snd_timer_status_get_queue(status: *mut snd_timer_status_t) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn snd_timer_info_get_ticks(info: *mut snd_timer_info_t) -> ::std::os::raw::c_long;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _snd_hwdep_info {
    _unused: [u8; 0],
}
#[doc = " HwDep information container"]
pub type snd_hwdep_info_t = _snd_hwdep_info;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _snd_hwdep_dsp_status {
    _unused: [u8; 0],
}
#[doc = " HwDep DSP status container"]
pub type snd_hwdep_dsp_status_t = _snd_hwdep_dsp_status;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _snd_hwdep_dsp_image {
    _unused: [u8; 0],
}
#[doc = " HwDep DSP image container"]
pub type snd_hwdep_dsp_image_t = _snd_hwdep_dsp_image;
#[doc = "< OPL2 raw driver"]
pub const SND_HWDEP_IFACE_OPL2: _snd_hwdep_iface = 0;
#[doc = "< OPL3 raw driver"]
pub const SND_HWDEP_IFACE_OPL3: _snd_hwdep_iface = 1;
#[doc = "< OPL4 raw driver"]
pub const SND_HWDEP_IFACE_OPL4: _snd_hwdep_iface = 2;
#[doc = "< SB16CSP driver"]
pub const SND_HWDEP_IFACE_SB16CSP: _snd_hwdep_iface = 3;
#[doc = "< EMU10K1 driver"]
pub const SND_HWDEP_IFACE_EMU10K1: _snd_hwdep_iface = 4;
#[doc = "< YSS225 driver"]
pub const SND_HWDEP_IFACE_YSS225: _snd_hwdep_iface = 5;
#[doc = "< ICS2115 driver"]
pub const SND_HWDEP_IFACE_ICS2115: _snd_hwdep_iface = 6;
#[doc = "< Ensoniq SoundScape ISA card (MC68EC000)"]
pub const SND_HWDEP_IFACE_SSCAPE: _snd_hwdep_iface = 7;
#[doc = "< Digigram VX cards"]
pub const SND_HWDEP_IFACE_VX: _snd_hwdep_iface = 8;
#[doc = "< Digigram miXart cards"]
pub const SND_HWDEP_IFACE_MIXART: _snd_hwdep_iface = 9;
#[doc = "< Tascam US122, US224 & US428 usb"]
pub const SND_HWDEP_IFACE_USX2Y: _snd_hwdep_iface = 10;
#[doc = "< EmuX wavetable"]
pub const SND_HWDEP_IFACE_EMUX_WAVETABLE: _snd_hwdep_iface = 11;
#[doc = "< Bluetooth audio"]
pub const SND_HWDEP_IFACE_BLUETOOTH: _snd_hwdep_iface = 12;
#[doc = "< Tascam US122, US224 & US428 raw USB PCM"]
pub const SND_HWDEP_IFACE_USX2Y_PCM: _snd_hwdep_iface = 13;
#[doc = "< Digigram PCXHR"]
pub const SND_HWDEP_IFACE_PCXHR: _snd_hwdep_iface = 14;
#[doc = "< SB Extigy/Audigy2NX remote control"]
pub const SND_HWDEP_IFACE_SB_RC: _snd_hwdep_iface = 15;
#[doc = "< HD-audio"]
pub const SND_HWDEP_IFACE_HDA: _snd_hwdep_iface = 16;
#[doc = "< direct access to usb stream"]
pub const SND_HWDEP_IFACE_USB_STREAM: _snd_hwdep_iface = 17;
#[doc = "< TC DICE FireWire device"]
pub const SND_HWDEP_IFACE_FW_DICE: _snd_hwdep_iface = 18;
#[doc = "< Echo Audio Fireworks based device"]
pub const SND_HWDEP_IFACE_FW_FIREWORKS: _snd_hwdep_iface = 19;
#[doc = "< BridgeCo BeBoB based device"]
pub const SND_HWDEP_IFACE_FW_BEBOB: _snd_hwdep_iface = 20;
#[doc = "< Oxford OXFW970/971 based device"]
pub const SND_HWDEP_IFACE_FW_OXFW: _snd_hwdep_iface = 21;
pub const SND_HWDEP_IFACE_FW_DIGI00X: _snd_hwdep_iface = 22;
pub const SND_HWDEP_IFACE_FW_TASCAM: _snd_hwdep_iface = 23;
pub const SND_HWDEP_IFACE_LINE6: _snd_hwdep_iface = 24;
pub const SND_HWDEP_IFACE_FW_MOTU: _snd_hwdep_iface = 25;
pub const SND_HWDEP_IFACE_FW_FIREFACE: _snd_hwdep_iface = 26;
#[doc = "< last known hwdep interface"]
pub const SND_HWDEP_IFACE_LAST: _snd_hwdep_iface = 26;
#[doc = " HwDep interface"]
pub type _snd_hwdep_iface = ::std::os::raw::c_uint;
#[doc = " HwDep interface"]
pub use self::_snd_hwdep_iface as snd_hwdep_iface_t;
#[doc = " Kernel level HwDep"]
pub const SND_HWDEP_TYPE_HW: _snd_hwdep_type = 0;
#[doc = " Shared memory client HwDep (not yet implemented)"]
pub const SND_HWDEP_TYPE_SHM: _snd_hwdep_type = 1;
#[doc = " INET client HwDep (not yet implemented)"]
pub const SND_HWDEP_TYPE_INET: _snd_hwdep_type = 2;
#[doc = " HwDep handle type"]
pub type _snd_hwdep_type = ::std::os::raw::c_uint;
#[doc = " HwDep handle type"]
pub use self::_snd_hwdep_type as snd_hwdep_type_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _snd_hwdep {
    _unused: [u8; 0],
}
#[doc = " HwDep handle"]
pub type snd_hwdep_t = _snd_hwdep;
extern "C" {
    pub fn snd_hwdep_open(
        hwdep: *mut *mut snd_hwdep_t,
        name: *const ::std::os::raw::c_char,
        mode: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_hwdep_close(hwdep: *mut snd_hwdep_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_hwdep_poll_descriptors(
        hwdep: *mut snd_hwdep_t,
        pfds: *mut pollfd,
        space: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_hwdep_poll_descriptors_count(hwdep: *mut snd_hwdep_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_hwdep_poll_descriptors_revents(
        hwdep: *mut snd_hwdep_t,
        pfds: *mut pollfd,
        nfds: ::std::os::raw::c_uint,
        revents: *mut ::std::os::raw::c_ushort,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_hwdep_nonblock(
        hwdep: *mut snd_hwdep_t,
        nonblock: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_hwdep_info(
        hwdep: *mut snd_hwdep_t,
        info: *mut snd_hwdep_info_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_hwdep_dsp_status(
        hwdep: *mut snd_hwdep_t,
        status: *mut snd_hwdep_dsp_status_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_hwdep_dsp_load(
        hwdep: *mut snd_hwdep_t,
        block: *mut snd_hwdep_dsp_image_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_hwdep_ioctl(
        hwdep: *mut snd_hwdep_t,
        request: ::std::os::raw::c_uint,
        arg: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_hwdep_write(
        hwdep: *mut snd_hwdep_t,
        buffer: *const ::std::os::raw::c_void,
        size: usize,
    ) -> isize;
}
extern "C" {
    pub fn snd_hwdep_read(
        hwdep: *mut snd_hwdep_t,
        buffer: *mut ::std::os::raw::c_void,
        size: usize,
    ) -> isize;
}
extern "C" {
    pub fn snd_hwdep_info_sizeof() -> usize;
}
extern "C" {
    pub fn snd_hwdep_info_malloc(ptr: *mut *mut snd_hwdep_info_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_hwdep_info_free(obj: *mut snd_hwdep_info_t);
}
extern "C" {
    pub fn snd_hwdep_info_copy(dst: *mut snd_hwdep_info_t, src: *const snd_hwdep_info_t);
}
extern "C" {
    pub fn snd_hwdep_info_get_device(obj: *const snd_hwdep_info_t) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn snd_hwdep_info_get_card(obj: *const snd_hwdep_info_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_hwdep_info_get_id(obj: *const snd_hwdep_info_t) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn snd_hwdep_info_get_name(obj: *const snd_hwdep_info_t) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn snd_hwdep_info_get_iface(obj: *const snd_hwdep_info_t) -> snd_hwdep_iface_t;
}
extern "C" {
    pub fn snd_hwdep_info_set_device(obj: *mut snd_hwdep_info_t, val: ::std::os::raw::c_uint);
}
extern "C" {
    pub fn snd_hwdep_dsp_status_sizeof() -> usize;
}
extern "C" {
    pub fn snd_hwdep_dsp_status_malloc(
        ptr: *mut *mut snd_hwdep_dsp_status_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_hwdep_dsp_status_free(obj: *mut snd_hwdep_dsp_status_t);
}
extern "C" {
    pub fn snd_hwdep_dsp_status_copy(
        dst: *mut snd_hwdep_dsp_status_t,
        src: *const snd_hwdep_dsp_status_t,
    );
}
extern "C" {
    pub fn snd_hwdep_dsp_status_get_version(
        obj: *const snd_hwdep_dsp_status_t,
    ) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn snd_hwdep_dsp_status_get_id(
        obj: *const snd_hwdep_dsp_status_t,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn snd_hwdep_dsp_status_get_num_dsps(
        obj: *const snd_hwdep_dsp_status_t,
    ) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn snd_hwdep_dsp_status_get_dsp_loaded(
        obj: *const snd_hwdep_dsp_status_t,
    ) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn snd_hwdep_dsp_status_get_chip_ready(
        obj: *const snd_hwdep_dsp_status_t,
    ) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn snd_hwdep_dsp_image_sizeof() -> usize;
}
extern "C" {
    pub fn snd_hwdep_dsp_image_malloc(
        ptr: *mut *mut snd_hwdep_dsp_image_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_hwdep_dsp_image_free(obj: *mut snd_hwdep_dsp_image_t);
}
extern "C" {
    pub fn snd_hwdep_dsp_image_copy(
        dst: *mut snd_hwdep_dsp_image_t,
        src: *const snd_hwdep_dsp_image_t,
    );
}
extern "C" {
    pub fn snd_hwdep_dsp_image_get_index(
        obj: *const snd_hwdep_dsp_image_t,
    ) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn snd_hwdep_dsp_image_get_name(
        obj: *const snd_hwdep_dsp_image_t,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn snd_hwdep_dsp_image_get_image(
        obj: *const snd_hwdep_dsp_image_t,
    ) -> *const ::std::os::raw::c_void;
}
extern "C" {
    pub fn snd_hwdep_dsp_image_get_length(obj: *const snd_hwdep_dsp_image_t) -> usize;
}
extern "C" {
    pub fn snd_hwdep_dsp_image_set_index(
        obj: *mut snd_hwdep_dsp_image_t,
        _index: ::std::os::raw::c_uint,
    );
}
extern "C" {
    pub fn snd_hwdep_dsp_image_set_name(
        obj: *mut snd_hwdep_dsp_image_t,
        name: *const ::std::os::raw::c_char,
    );
}
extern "C" {
    pub fn snd_hwdep_dsp_image_set_image(
        obj: *mut snd_hwdep_dsp_image_t,
        buffer: *mut ::std::os::raw::c_void,
    );
}
extern "C" {
    pub fn snd_hwdep_dsp_image_set_length(obj: *mut snd_hwdep_dsp_image_t, length: usize);
}
#[doc = " IEC958 structure"]
#[repr(C)]
#[derive(Copy, Clone)]
pub struct snd_aes_iec958 {
    #[doc = "< AES/IEC958 channel status bits"]
    pub status: [::std::os::raw::c_uchar; 24usize],
    #[doc = "< AES/IEC958 subcode bits"]
    pub subcode: [::std::os::raw::c_uchar; 147usize],
    #[doc = "< nothing"]
    pub pad: ::std::os::raw::c_uchar,
    #[doc = "< AES/IEC958 subframe bits"]
    pub dig_subframe: [::std::os::raw::c_uchar; 4usize],
}
#[doc = " IEC958 structure"]
pub type snd_aes_iec958_t = snd_aes_iec958;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _snd_ctl_card_info {
    _unused: [u8; 0],
}
#[doc = " CTL card info container"]
pub type snd_ctl_card_info_t = _snd_ctl_card_info;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _snd_ctl_elem_id {
    _unused: [u8; 0],
}
#[doc = " CTL element identifier container"]
pub type snd_ctl_elem_id_t = _snd_ctl_elem_id;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _snd_ctl_elem_list {
    _unused: [u8; 0],
}
#[doc = " CTL element list container"]
#[doc = ""]
#[doc = " This is a list of CTL elements. The list contains management"]
#[doc = " information (e.g. how many elements the sound card has) as well as"]
#[doc = " the element identifiers. All functions which operate on the list"]
#[doc = " are named snd_ctl_elem_list_*()."]
#[doc = ""]
#[doc = " \\par Memory management"]
#[doc = ""]
#[doc = " There are two memory areas to deal with: The list container itself"]
#[doc = " and the memory for the element identifiers."]
#[doc = ""]
#[doc = " To manage the area for the list container, the following functions"]
#[doc = " are used:"]
#[doc = ""]
#[doc = " - snd_ctl_elem_list_malloc() / snd_ctl_elem_list_free() to allocate"]
#[doc = "   and free memory on the heap, or"]
#[doc = " - snd_ctl_elem_list_alloca() to allocate the memory on the"]
#[doc = "   stack. This memory is auto-released when the stack is unwound."]
#[doc = ""]
#[doc = " To manage the space for the element identifiers, the"]
#[doc = " snd_ctl_elem_list_alloc_space() and snd_ctl_elem_list_free_space()"]
#[doc = " are used. Allocating the right amount of space can be achieved by"]
#[doc = " first obtaining the number of elements and then calling"]
#[doc = " snd_ctl_elem_list_alloc_space():"]
#[doc = ""]
#[doc = " \\code"]
#[doc = "   snd_ctl_elem_list_t* list;"]
#[doc = "   int count;"]
#[doc = ""]
#[doc = "   // Initialise list"]
#[doc = "   snd_ctl_elem_list_malloc(&list);"]
#[doc = ""]
#[doc = "   // Get number of elements"]
#[doc = "   snd_ctl_elem_list(ctl, list);"]
#[doc = "   count = snd_ctl_elem_list_get_count(list);"]
#[doc = ""]
#[doc = "   // Allocate space for identifiers"]
#[doc = "   snd_ctl_elem_list_alloc_space(list, count);"]
#[doc = ""]
#[doc = "   // Get identifiers"]
#[doc = "   snd_ctl_elem_list(ctl, list); // yes, this is same as above :)"]
#[doc = ""]
#[doc = "   // Do something useful with the list..."]
#[doc = ""]
#[doc = "   // Cleanup"]
#[doc = "   snd_ctl_elem_list_free_space(list);"]
#[doc = "   snd_ctl_elem_list_free(list);"]
#[doc = " \\endcode"]
#[doc = ""]
#[doc = ""]
#[doc = " \\par The Elements"]
#[doc = ""]
#[doc = " The elements in the list are accessed using an index. This index is"]
#[doc = " the location in the list; Don't confuse it with the 'index' of the"]
#[doc = " element identifier. For example:"]
#[doc = ""]
#[doc = " \\code"]
#[doc = "     snd_ctl_elem_list_t list;"]
#[doc = "     unsigned int element_index;"]
#[doc = ""]
#[doc = "     // Allocate space, fill list ..."]
#[doc = ""]
#[doc = "     element_index = snd_ctl_elem_list_get_index(&list, 2);"]
#[doc = " \\endcode"]
#[doc = ""]
#[doc = " This will access the 3rd element in the list (index=2) and get the"]
#[doc = " elements index from the driver (which might be 13, for example)."]
pub type snd_ctl_elem_list_t = _snd_ctl_elem_list;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _snd_ctl_elem_info {
    _unused: [u8; 0],
}
#[doc = " CTL element info container"]
pub type snd_ctl_elem_info_t = _snd_ctl_elem_info;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _snd_ctl_elem_value {
    _unused: [u8; 0],
}
#[doc = " CTL element value container"]
#[doc = ""]
#[doc = " Contains the value(s) (i.e. members) of a single element. All"]
#[doc = " values of a given element are of the same type."]
#[doc = ""]
#[doc = " \\par Memory management"]
#[doc = ""]
#[doc = " To access a value, a snd_ctl_elem_value_t must be allocated using"]
#[doc = " snd_ctl_elem_value_alloca() or snd_ctl_elem_value_malloc(). When"]
#[doc = " using the latter, it must be freed again using"]
#[doc = " snd_ctl_elem_value_free()."]
#[doc = ""]
#[doc = " \\par Identifier"]
#[doc = ""]
#[doc = " Then, the ID must be filled. It is sufficient to fill only the"]
#[doc = " numid, if known. Otherwise, interface type, device, subdevice,"]
#[doc = " name, index must all be given.  The following functions can be used"]
#[doc = " to fill the ID:"]
#[doc = ""]
#[doc = " - snd_ctl_elem_value_set_id(): Set the ID. Requires an"]
#[doc = "   snd_ctl_elem_id_t object."]
#[doc = " - snd_ctl_elem_value_set_numid(): Set the numid."]
#[doc = " - Or use all of the following:"]
#[doc = ""]
#[doc = "   - snd_ctl_elem_value_set_interface()"]
#[doc = "   - snd_ctl_elem_value_set_device()"]
#[doc = "   - snd_ctl_elem_value_set_subdevice()"]
#[doc = "   - snd_ctl_elem_value_set_name()"]
#[doc = "   - snd_ctl_elem_value_set_index()"]
#[doc = ""]
#[doc = " When communicating with the driver (snd_ctl_elem_read(),"]
#[doc = " snd_ctl_elem_write()), and the numid was given, the interface,"]
#[doc = " device, ... are filled (even if you set the before). When the numid"]
#[doc = " is unset (i.e. it is 0), it is filled."]
#[doc = ""]
#[doc = " \\par Communicating with the driver"]
#[doc = ""]
#[doc = " After the value container was created and filled with the ID of the"]
#[doc = " desired element, the value(s) can be fetched from the driver (and"]
#[doc = " thus from the hardware) or written to the driver."]
#[doc = ""]
#[doc = " To fetch a value, use snd_ctl_elem_read(). Thereafter, use the"]
#[doc = " snd_ctl_elem_value_get_*() functions to obtain the actual value."]
#[doc = ""]
#[doc = " To write a new value, first use a snd_ctl_elem_value_set_*() to set"]
#[doc = " it, then call snd_ctl_elem_write() to write it to the driver."]
pub type snd_ctl_elem_value_t = _snd_ctl_elem_value;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _snd_ctl_event {
    _unused: [u8; 0],
}
#[doc = " CTL event container"]
pub type snd_ctl_event_t = _snd_ctl_event;
#[doc = " Invalid type"]
pub const SND_CTL_ELEM_TYPE_NONE: _snd_ctl_elem_type = 0;
#[doc = " Boolean contents"]
pub const SND_CTL_ELEM_TYPE_BOOLEAN: _snd_ctl_elem_type = 1;
#[doc = " Integer contents"]
pub const SND_CTL_ELEM_TYPE_INTEGER: _snd_ctl_elem_type = 2;
#[doc = " Enumerated contents"]
pub const SND_CTL_ELEM_TYPE_ENUMERATED: _snd_ctl_elem_type = 3;
#[doc = " Bytes contents"]
pub const SND_CTL_ELEM_TYPE_BYTES: _snd_ctl_elem_type = 4;
#[doc = " IEC958 (S/PDIF) setting content"]
pub const SND_CTL_ELEM_TYPE_IEC958: _snd_ctl_elem_type = 5;
#[doc = " 64-bit integer contents"]
pub const SND_CTL_ELEM_TYPE_INTEGER64: _snd_ctl_elem_type = 6;
#[doc = " 64-bit integer contents"]
pub const SND_CTL_ELEM_TYPE_LAST: _snd_ctl_elem_type = 6;
#[doc = " CTL element type"]
pub type _snd_ctl_elem_type = ::std::os::raw::c_uint;
#[doc = " CTL element type"]
pub use self::_snd_ctl_elem_type as snd_ctl_elem_type_t;
#[doc = " Card level"]
pub const SND_CTL_ELEM_IFACE_CARD: _snd_ctl_elem_iface = 0;
#[doc = " Hardware dependent device"]
pub const SND_CTL_ELEM_IFACE_HWDEP: _snd_ctl_elem_iface = 1;
#[doc = " Mixer"]
pub const SND_CTL_ELEM_IFACE_MIXER: _snd_ctl_elem_iface = 2;
#[doc = " PCM"]
pub const SND_CTL_ELEM_IFACE_PCM: _snd_ctl_elem_iface = 3;
#[doc = " RawMidi"]
pub const SND_CTL_ELEM_IFACE_RAWMIDI: _snd_ctl_elem_iface = 4;
#[doc = " Timer"]
pub const SND_CTL_ELEM_IFACE_TIMER: _snd_ctl_elem_iface = 5;
#[doc = " Sequencer"]
pub const SND_CTL_ELEM_IFACE_SEQUENCER: _snd_ctl_elem_iface = 6;
#[doc = " Sequencer"]
pub const SND_CTL_ELEM_IFACE_LAST: _snd_ctl_elem_iface = 6;
#[doc = " CTL related interface"]
pub type _snd_ctl_elem_iface = ::std::os::raw::c_uint;
#[doc = " CTL related interface"]
pub use self::_snd_ctl_elem_iface as snd_ctl_elem_iface_t;
#[doc = " Elements related event"]
pub const SND_CTL_EVENT_ELEM: _snd_ctl_event_type = 0;
#[doc = " Elements related event"]
pub const SND_CTL_EVENT_LAST: _snd_ctl_event_type = 0;
#[doc = " Event class"]
pub type _snd_ctl_event_type = ::std::os::raw::c_uint;
#[doc = " Event class"]
pub use self::_snd_ctl_event_type as snd_ctl_event_type_t;
#[doc = " Kernel level CTL"]
pub const SND_CTL_TYPE_HW: _snd_ctl_type = 0;
#[doc = " Shared memory client CTL"]
pub const SND_CTL_TYPE_SHM: _snd_ctl_type = 1;
#[doc = " INET client CTL (not yet implemented)"]
pub const SND_CTL_TYPE_INET: _snd_ctl_type = 2;
#[doc = " External control plugin"]
pub const SND_CTL_TYPE_EXT: _snd_ctl_type = 3;
#[doc = " CTL type"]
pub type _snd_ctl_type = ::std::os::raw::c_uint;
#[doc = " CTL type"]
pub use self::_snd_ctl_type as snd_ctl_type_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _snd_ctl {
    _unused: [u8; 0],
}
#[doc = " CTL handle"]
pub type snd_ctl_t = _snd_ctl;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _snd_sctl {
    _unused: [u8; 0],
}
#[doc = " SCTL type"]
pub type snd_sctl_t = _snd_sctl;
extern "C" {
    pub fn snd_card_load(card: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_card_next(card: *mut ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_card_get_index(name: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_card_get_name(
        card: ::std::os::raw::c_int,
        name: *mut *mut ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_card_get_longname(
        card: ::std::os::raw::c_int,
        name: *mut *mut ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_device_name_hint(
        card: ::std::os::raw::c_int,
        iface: *const ::std::os::raw::c_char,
        hints: *mut *mut *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_device_name_free_hint(
        hints: *mut *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_device_name_get_hint(
        hint: *const ::std::os::raw::c_void,
        id: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn snd_ctl_open(
        ctl: *mut *mut snd_ctl_t,
        name: *const ::std::os::raw::c_char,
        mode: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_ctl_open_lconf(
        ctl: *mut *mut snd_ctl_t,
        name: *const ::std::os::raw::c_char,
        mode: ::std::os::raw::c_int,
        lconf: *mut snd_config_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_ctl_open_fallback(
        ctl: *mut *mut snd_ctl_t,
        root: *mut snd_config_t,
        name: *const ::std::os::raw::c_char,
        orig_name: *const ::std::os::raw::c_char,
        mode: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_ctl_close(ctl: *mut snd_ctl_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_ctl_nonblock(
        ctl: *mut snd_ctl_t,
        nonblock: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_async_add_ctl_handler(
        handler: *mut *mut snd_async_handler_t,
        ctl: *mut snd_ctl_t,
        callback: snd_async_callback_t,
        private_data: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_async_handler_get_ctl(handler: *mut snd_async_handler_t) -> *mut snd_ctl_t;
}
extern "C" {
    pub fn snd_ctl_poll_descriptors_count(ctl: *mut snd_ctl_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_ctl_poll_descriptors(
        ctl: *mut snd_ctl_t,
        pfds: *mut pollfd,
        space: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_ctl_poll_descriptors_revents(
        ctl: *mut snd_ctl_t,
        pfds: *mut pollfd,
        nfds: ::std::os::raw::c_uint,
        revents: *mut ::std::os::raw::c_ushort,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_ctl_subscribe_events(
        ctl: *mut snd_ctl_t,
        subscribe: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_ctl_card_info(
        ctl: *mut snd_ctl_t,
        info: *mut snd_ctl_card_info_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_ctl_elem_list(
        ctl: *mut snd_ctl_t,
        list: *mut snd_ctl_elem_list_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_ctl_elem_info(
        ctl: *mut snd_ctl_t,
        info: *mut snd_ctl_elem_info_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_ctl_elem_read(
        ctl: *mut snd_ctl_t,
        data: *mut snd_ctl_elem_value_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_ctl_elem_write(
        ctl: *mut snd_ctl_t,
        data: *mut snd_ctl_elem_value_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_ctl_elem_lock(
        ctl: *mut snd_ctl_t,
        id: *mut snd_ctl_elem_id_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_ctl_elem_unlock(
        ctl: *mut snd_ctl_t,
        id: *mut snd_ctl_elem_id_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_ctl_elem_tlv_read(
        ctl: *mut snd_ctl_t,
        id: *const snd_ctl_elem_id_t,
        tlv: *mut ::std::os::raw::c_uint,
        tlv_size: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_ctl_elem_tlv_write(
        ctl: *mut snd_ctl_t,
        id: *const snd_ctl_elem_id_t,
        tlv: *const ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_ctl_elem_tlv_command(
        ctl: *mut snd_ctl_t,
        id: *const snd_ctl_elem_id_t,
        tlv: *const ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_ctl_hwdep_next_device(
        ctl: *mut snd_ctl_t,
        device: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_ctl_hwdep_info(
        ctl: *mut snd_ctl_t,
        info: *mut snd_hwdep_info_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_ctl_pcm_next_device(
        ctl: *mut snd_ctl_t,
        device: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_ctl_pcm_info(
        ctl: *mut snd_ctl_t,
        info: *mut snd_pcm_info_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_ctl_pcm_prefer_subdevice(
        ctl: *mut snd_ctl_t,
        subdev: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_ctl_rawmidi_next_device(
        ctl: *mut snd_ctl_t,
        device: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_ctl_rawmidi_info(
        ctl: *mut snd_ctl_t,
        info: *mut snd_rawmidi_info_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_ctl_rawmidi_prefer_subdevice(
        ctl: *mut snd_ctl_t,
        subdev: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_ctl_set_power_state(
        ctl: *mut snd_ctl_t,
        state: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_ctl_get_power_state(
        ctl: *mut snd_ctl_t,
        state: *mut ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_ctl_read(ctl: *mut snd_ctl_t, event: *mut snd_ctl_event_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_ctl_wait(
        ctl: *mut snd_ctl_t,
        timeout: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_ctl_name(ctl: *mut snd_ctl_t) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn snd_ctl_type(ctl: *mut snd_ctl_t) -> snd_ctl_type_t;
}
extern "C" {
    pub fn snd_ctl_elem_type_name(type_: snd_ctl_elem_type_t) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn snd_ctl_elem_iface_name(iface: snd_ctl_elem_iface_t) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn snd_ctl_event_type_name(type_: snd_ctl_event_type_t) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn snd_ctl_event_elem_get_mask(obj: *const snd_ctl_event_t) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn snd_ctl_event_elem_get_numid(obj: *const snd_ctl_event_t) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn snd_ctl_event_elem_get_id(obj: *const snd_ctl_event_t, ptr: *mut snd_ctl_elem_id_t);
}
extern "C" {
    pub fn snd_ctl_event_elem_get_interface(obj: *const snd_ctl_event_t) -> snd_ctl_elem_iface_t;
}
extern "C" {
    pub fn snd_ctl_event_elem_get_device(obj: *const snd_ctl_event_t) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn snd_ctl_event_elem_get_subdevice(obj: *const snd_ctl_event_t) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn snd_ctl_event_elem_get_name(
        obj: *const snd_ctl_event_t,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn snd_ctl_event_elem_get_index(obj: *const snd_ctl_event_t) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn snd_ctl_elem_list_alloc_space(
        obj: *mut snd_ctl_elem_list_t,
        entries: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_ctl_elem_list_free_space(obj: *mut snd_ctl_elem_list_t);
}
extern "C" {
    pub fn snd_ctl_ascii_elem_id_get(id: *mut snd_ctl_elem_id_t) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn snd_ctl_ascii_elem_id_parse(
        dst: *mut snd_ctl_elem_id_t,
        str_: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_ctl_ascii_value_parse(
        handle: *mut snd_ctl_t,
        dst: *mut snd_ctl_elem_value_t,
        info: *mut snd_ctl_elem_info_t,
        value: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_ctl_elem_id_sizeof() -> usize;
}
extern "C" {
    pub fn snd_ctl_elem_id_malloc(ptr: *mut *mut snd_ctl_elem_id_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_ctl_elem_id_free(obj: *mut snd_ctl_elem_id_t);
}
extern "C" {
    pub fn snd_ctl_elem_id_clear(obj: *mut snd_ctl_elem_id_t);
}
extern "C" {
    pub fn snd_ctl_elem_id_copy(dst: *mut snd_ctl_elem_id_t, src: *const snd_ctl_elem_id_t);
}
extern "C" {
    pub fn snd_ctl_elem_id_get_numid(obj: *const snd_ctl_elem_id_t) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn snd_ctl_elem_id_get_interface(obj: *const snd_ctl_elem_id_t) -> snd_ctl_elem_iface_t;
}
extern "C" {
    pub fn snd_ctl_elem_id_get_device(obj: *const snd_ctl_elem_id_t) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn snd_ctl_elem_id_get_subdevice(obj: *const snd_ctl_elem_id_t) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn snd_ctl_elem_id_get_name(obj: *const snd_ctl_elem_id_t)
        -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn snd_ctl_elem_id_get_index(obj: *const snd_ctl_elem_id_t) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn snd_ctl_elem_id_set_numid(obj: *mut snd_ctl_elem_id_t, val: ::std::os::raw::c_uint);
}
extern "C" {
    pub fn snd_ctl_elem_id_set_interface(obj: *mut snd_ctl_elem_id_t, val: snd_ctl_elem_iface_t);
}
extern "C" {
    pub fn snd_ctl_elem_id_set_device(obj: *mut snd_ctl_elem_id_t, val: ::std::os::raw::c_uint);
}
extern "C" {
    pub fn snd_ctl_elem_id_set_subdevice(obj: *mut snd_ctl_elem_id_t, val: ::std::os::raw::c_uint);
}
extern "C" {
    pub fn snd_ctl_elem_id_set_name(
        obj: *mut snd_ctl_elem_id_t,
        val: *const ::std::os::raw::c_char,
    );
}
extern "C" {
    pub fn snd_ctl_elem_id_set_index(obj: *mut snd_ctl_elem_id_t, val: ::std::os::raw::c_uint);
}
extern "C" {
    pub fn snd_ctl_card_info_sizeof() -> usize;
}
extern "C" {
    pub fn snd_ctl_card_info_malloc(ptr: *mut *mut snd_ctl_card_info_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_ctl_card_info_free(obj: *mut snd_ctl_card_info_t);
}
extern "C" {
    pub fn snd_ctl_card_info_clear(obj: *mut snd_ctl_card_info_t);
}
extern "C" {
    pub fn snd_ctl_card_info_copy(dst: *mut snd_ctl_card_info_t, src: *const snd_ctl_card_info_t);
}
extern "C" {
    pub fn snd_ctl_card_info_get_card(obj: *const snd_ctl_card_info_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_ctl_card_info_get_id(
        obj: *const snd_ctl_card_info_t,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn snd_ctl_card_info_get_driver(
        obj: *const snd_ctl_card_info_t,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn snd_ctl_card_info_get_name(
        obj: *const snd_ctl_card_info_t,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn snd_ctl_card_info_get_longname(
        obj: *const snd_ctl_card_info_t,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn snd_ctl_card_info_get_mixername(
        obj: *const snd_ctl_card_info_t,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn snd_ctl_card_info_get_components(
        obj: *const snd_ctl_card_info_t,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn snd_ctl_event_sizeof() -> usize;
}
extern "C" {
    pub fn snd_ctl_event_malloc(ptr: *mut *mut snd_ctl_event_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_ctl_event_free(obj: *mut snd_ctl_event_t);
}
extern "C" {
    pub fn snd_ctl_event_clear(obj: *mut snd_ctl_event_t);
}
extern "C" {
    pub fn snd_ctl_event_copy(dst: *mut snd_ctl_event_t, src: *const snd_ctl_event_t);
}
extern "C" {
    pub fn snd_ctl_event_get_type(obj: *const snd_ctl_event_t) -> snd_ctl_event_type_t;
}
extern "C" {
    pub fn snd_ctl_elem_list_sizeof() -> usize;
}
extern "C" {
    pub fn snd_ctl_elem_list_malloc(ptr: *mut *mut snd_ctl_elem_list_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_ctl_elem_list_free(obj: *mut snd_ctl_elem_list_t);
}
extern "C" {
    pub fn snd_ctl_elem_list_clear(obj: *mut snd_ctl_elem_list_t);
}
extern "C" {
    pub fn snd_ctl_elem_list_copy(dst: *mut snd_ctl_elem_list_t, src: *const snd_ctl_elem_list_t);
}
extern "C" {
    pub fn snd_ctl_elem_list_set_offset(obj: *mut snd_ctl_elem_list_t, val: ::std::os::raw::c_uint);
}
extern "C" {
    pub fn snd_ctl_elem_list_get_used(obj: *const snd_ctl_elem_list_t) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn snd_ctl_elem_list_get_count(obj: *const snd_ctl_elem_list_t) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn snd_ctl_elem_list_get_id(
        obj: *const snd_ctl_elem_list_t,
        idx: ::std::os::raw::c_uint,
        ptr: *mut snd_ctl_elem_id_t,
    );
}
extern "C" {
    pub fn snd_ctl_elem_list_get_numid(
        obj: *const snd_ctl_elem_list_t,
        idx: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn snd_ctl_elem_list_get_interface(
        obj: *const snd_ctl_elem_list_t,
        idx: ::std::os::raw::c_uint,
    ) -> snd_ctl_elem_iface_t;
}
extern "C" {
    pub fn snd_ctl_elem_list_get_device(
        obj: *const snd_ctl_elem_list_t,
        idx: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn snd_ctl_elem_list_get_subdevice(
        obj: *const snd_ctl_elem_list_t,
        idx: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn snd_ctl_elem_list_get_name(
        obj: *const snd_ctl_elem_list_t,
        idx: ::std::os::raw::c_uint,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn snd_ctl_elem_list_get_index(
        obj: *const snd_ctl_elem_list_t,
        idx: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn snd_ctl_elem_info_sizeof() -> usize;
}
extern "C" {
    pub fn snd_ctl_elem_info_malloc(ptr: *mut *mut snd_ctl_elem_info_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_ctl_elem_info_free(obj: *mut snd_ctl_elem_info_t);
}
extern "C" {
    pub fn snd_ctl_elem_info_clear(obj: *mut snd_ctl_elem_info_t);
}
extern "C" {
    pub fn snd_ctl_elem_info_copy(dst: *mut snd_ctl_elem_info_t, src: *const snd_ctl_elem_info_t);
}
extern "C" {
    pub fn snd_ctl_elem_info_get_type(obj: *const snd_ctl_elem_info_t) -> snd_ctl_elem_type_t;
}
extern "C" {
    pub fn snd_ctl_elem_info_is_readable(obj: *const snd_ctl_elem_info_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_ctl_elem_info_is_writable(obj: *const snd_ctl_elem_info_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_ctl_elem_info_is_volatile(obj: *const snd_ctl_elem_info_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_ctl_elem_info_is_inactive(obj: *const snd_ctl_elem_info_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_ctl_elem_info_is_locked(obj: *const snd_ctl_elem_info_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_ctl_elem_info_is_tlv_readable(
        obj: *const snd_ctl_elem_info_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_ctl_elem_info_is_tlv_writable(
        obj: *const snd_ctl_elem_info_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_ctl_elem_info_is_tlv_commandable(
        obj: *const snd_ctl_elem_info_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_ctl_elem_info_is_owner(obj: *const snd_ctl_elem_info_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_ctl_elem_info_is_user(obj: *const snd_ctl_elem_info_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_ctl_elem_info_get_owner(obj: *const snd_ctl_elem_info_t) -> pid_t;
}
extern "C" {
    pub fn snd_ctl_elem_info_get_count(obj: *const snd_ctl_elem_info_t) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn snd_ctl_elem_info_get_min(obj: *const snd_ctl_elem_info_t) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn snd_ctl_elem_info_get_max(obj: *const snd_ctl_elem_info_t) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn snd_ctl_elem_info_get_step(obj: *const snd_ctl_elem_info_t) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn snd_ctl_elem_info_get_min64(
        obj: *const snd_ctl_elem_info_t,
    ) -> ::std::os::raw::c_longlong;
}
extern "C" {
    pub fn snd_ctl_elem_info_get_max64(
        obj: *const snd_ctl_elem_info_t,
    ) -> ::std::os::raw::c_longlong;
}
extern "C" {
    pub fn snd_ctl_elem_info_get_step64(
        obj: *const snd_ctl_elem_info_t,
    ) -> ::std::os::raw::c_longlong;
}
extern "C" {
    pub fn snd_ctl_elem_info_get_items(obj: *const snd_ctl_elem_info_t) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn snd_ctl_elem_info_set_item(obj: *mut snd_ctl_elem_info_t, val: ::std::os::raw::c_uint);
}
extern "C" {
    pub fn snd_ctl_elem_info_get_item_name(
        obj: *const snd_ctl_elem_info_t,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn snd_ctl_elem_info_get_dimensions(
        obj: *const snd_ctl_elem_info_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_ctl_elem_info_get_dimension(
        obj: *const snd_ctl_elem_info_t,
        idx: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_ctl_elem_info_set_dimension(
        info: *mut snd_ctl_elem_info_t,
        dimension: *const ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_ctl_elem_info_get_id(obj: *const snd_ctl_elem_info_t, ptr: *mut snd_ctl_elem_id_t);
}
extern "C" {
    pub fn snd_ctl_elem_info_get_numid(obj: *const snd_ctl_elem_info_t) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn snd_ctl_elem_info_get_interface(obj: *const snd_ctl_elem_info_t)
        -> snd_ctl_elem_iface_t;
}
extern "C" {
    pub fn snd_ctl_elem_info_get_device(obj: *const snd_ctl_elem_info_t) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn snd_ctl_elem_info_get_subdevice(
        obj: *const snd_ctl_elem_info_t,
    ) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn snd_ctl_elem_info_get_name(
        obj: *const snd_ctl_elem_info_t,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn snd_ctl_elem_info_get_index(obj: *const snd_ctl_elem_info_t) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn snd_ctl_elem_info_set_id(obj: *mut snd_ctl_elem_info_t, ptr: *const snd_ctl_elem_id_t);
}
extern "C" {
    pub fn snd_ctl_elem_info_set_numid(obj: *mut snd_ctl_elem_info_t, val: ::std::os::raw::c_uint);
}
extern "C" {
    pub fn snd_ctl_elem_info_set_interface(
        obj: *mut snd_ctl_elem_info_t,
        val: snd_ctl_elem_iface_t,
    );
}
extern "C" {
    pub fn snd_ctl_elem_info_set_device(obj: *mut snd_ctl_elem_info_t, val: ::std::os::raw::c_uint);
}
extern "C" {
    pub fn snd_ctl_elem_info_set_subdevice(
        obj: *mut snd_ctl_elem_info_t,
        val: ::std::os::raw::c_uint,
    );
}
extern "C" {
    pub fn snd_ctl_elem_info_set_name(
        obj: *mut snd_ctl_elem_info_t,
        val: *const ::std::os::raw::c_char,
    );
}
extern "C" {
    pub fn snd_ctl_elem_info_set_index(obj: *mut snd_ctl_elem_info_t, val: ::std::os::raw::c_uint);
}
extern "C" {
    pub fn snd_ctl_add_integer_elem_set(
        ctl: *mut snd_ctl_t,
        info: *mut snd_ctl_elem_info_t,
        element_count: ::std::os::raw::c_uint,
        member_count: ::std::os::raw::c_uint,
        min: ::std::os::raw::c_long,
        max: ::std::os::raw::c_long,
        step: ::std::os::raw::c_long,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_ctl_add_integer64_elem_set(
        ctl: *mut snd_ctl_t,
        info: *mut snd_ctl_elem_info_t,
        element_count: ::std::os::raw::c_uint,
        member_count: ::std::os::raw::c_uint,
        min: ::std::os::raw::c_longlong,
        max: ::std::os::raw::c_longlong,
        step: ::std::os::raw::c_longlong,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_ctl_add_boolean_elem_set(
        ctl: *mut snd_ctl_t,
        info: *mut snd_ctl_elem_info_t,
        element_count: ::std::os::raw::c_uint,
        member_count: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_ctl_add_enumerated_elem_set(
        ctl: *mut snd_ctl_t,
        info: *mut snd_ctl_elem_info_t,
        element_count: ::std::os::raw::c_uint,
        member_count: ::std::os::raw::c_uint,
        items: ::std::os::raw::c_uint,
        labels: *const *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_ctl_add_bytes_elem_set(
        ctl: *mut snd_ctl_t,
        info: *mut snd_ctl_elem_info_t,
        element_count: ::std::os::raw::c_uint,
        member_count: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_ctl_elem_add_integer(
        ctl: *mut snd_ctl_t,
        id: *const snd_ctl_elem_id_t,
        count: ::std::os::raw::c_uint,
        imin: ::std::os::raw::c_long,
        imax: ::std::os::raw::c_long,
        istep: ::std::os::raw::c_long,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_ctl_elem_add_integer64(
        ctl: *mut snd_ctl_t,
        id: *const snd_ctl_elem_id_t,
        count: ::std::os::raw::c_uint,
        imin: ::std::os::raw::c_longlong,
        imax: ::std::os::raw::c_longlong,
        istep: ::std::os::raw::c_longlong,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_ctl_elem_add_boolean(
        ctl: *mut snd_ctl_t,
        id: *const snd_ctl_elem_id_t,
        count: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_ctl_elem_add_enumerated(
        ctl: *mut snd_ctl_t,
        id: *const snd_ctl_elem_id_t,
        count: ::std::os::raw::c_uint,
        items: ::std::os::raw::c_uint,
        names: *const *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_ctl_elem_add_iec958(
        ctl: *mut snd_ctl_t,
        id: *const snd_ctl_elem_id_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_ctl_elem_remove(
        ctl: *mut snd_ctl_t,
        id: *mut snd_ctl_elem_id_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_ctl_elem_value_sizeof() -> usize;
}
extern "C" {
    pub fn snd_ctl_elem_value_malloc(ptr: *mut *mut snd_ctl_elem_value_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_ctl_elem_value_free(obj: *mut snd_ctl_elem_value_t);
}
extern "C" {
    pub fn snd_ctl_elem_value_clear(obj: *mut snd_ctl_elem_value_t);
}
extern "C" {
    pub fn snd_ctl_elem_value_copy(
        dst: *mut snd_ctl_elem_value_t,
        src: *const snd_ctl_elem_value_t,
    );
}
extern "C" {
    pub fn snd_ctl_elem_value_compare(
        left: *mut snd_ctl_elem_value_t,
        right: *const snd_ctl_elem_value_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_ctl_elem_value_get_id(obj: *const snd_ctl_elem_value_t, ptr: *mut snd_ctl_elem_id_t);
}
extern "C" {
    pub fn snd_ctl_elem_value_get_numid(obj: *const snd_ctl_elem_value_t)
        -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn snd_ctl_elem_value_get_interface(
        obj: *const snd_ctl_elem_value_t,
    ) -> snd_ctl_elem_iface_t;
}
extern "C" {
    pub fn snd_ctl_elem_value_get_device(
        obj: *const snd_ctl_elem_value_t,
    ) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn snd_ctl_elem_value_get_subdevice(
        obj: *const snd_ctl_elem_value_t,
    ) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn snd_ctl_elem_value_get_name(
        obj: *const snd_ctl_elem_value_t,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn snd_ctl_elem_value_get_index(obj: *const snd_ctl_elem_value_t)
        -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn snd_ctl_elem_value_set_id(obj: *mut snd_ctl_elem_value_t, ptr: *const snd_ctl_elem_id_t);
}
extern "C" {
    pub fn snd_ctl_elem_value_set_numid(
        obj: *mut snd_ctl_elem_value_t,
        val: ::std::os::raw::c_uint,
    );
}
extern "C" {
    pub fn snd_ctl_elem_value_set_interface(
        obj: *mut snd_ctl_elem_value_t,
        val: snd_ctl_elem_iface_t,
    );
}
extern "C" {
    pub fn snd_ctl_elem_value_set_device(
        obj: *mut snd_ctl_elem_value_t,
        val: ::std::os::raw::c_uint,
    );
}
extern "C" {
    pub fn snd_ctl_elem_value_set_subdevice(
        obj: *mut snd_ctl_elem_value_t,
        val: ::std::os::raw::c_uint,
    );
}
extern "C" {
    pub fn snd_ctl_elem_value_set_name(
        obj: *mut snd_ctl_elem_value_t,
        val: *const ::std::os::raw::c_char,
    );
}
extern "C" {
    pub fn snd_ctl_elem_value_set_index(
        obj: *mut snd_ctl_elem_value_t,
        val: ::std::os::raw::c_uint,
    );
}
extern "C" {
    pub fn snd_ctl_elem_value_get_boolean(
        obj: *const snd_ctl_elem_value_t,
        idx: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_ctl_elem_value_get_integer(
        obj: *const snd_ctl_elem_value_t,
        idx: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn snd_ctl_elem_value_get_integer64(
        obj: *const snd_ctl_elem_value_t,
        idx: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_longlong;
}
extern "C" {
    pub fn snd_ctl_elem_value_get_enumerated(
        obj: *const snd_ctl_elem_value_t,
        idx: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn snd_ctl_elem_value_get_byte(
        obj: *const snd_ctl_elem_value_t,
        idx: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_uchar;
}
extern "C" {
    pub fn snd_ctl_elem_value_set_boolean(
        obj: *mut snd_ctl_elem_value_t,
        idx: ::std::os::raw::c_uint,
        val: ::std::os::raw::c_long,
    );
}
extern "C" {
    pub fn snd_ctl_elem_value_set_integer(
        obj: *mut snd_ctl_elem_value_t,
        idx: ::std::os::raw::c_uint,
        val: ::std::os::raw::c_long,
    );
}
extern "C" {
    pub fn snd_ctl_elem_value_set_integer64(
        obj: *mut snd_ctl_elem_value_t,
        idx: ::std::os::raw::c_uint,
        val: ::std::os::raw::c_longlong,
    );
}
extern "C" {
    pub fn snd_ctl_elem_value_set_enumerated(
        obj: *mut snd_ctl_elem_value_t,
        idx: ::std::os::raw::c_uint,
        val: ::std::os::raw::c_uint,
    );
}
extern "C" {
    pub fn snd_ctl_elem_value_set_byte(
        obj: *mut snd_ctl_elem_value_t,
        idx: ::std::os::raw::c_uint,
        val: ::std::os::raw::c_uchar,
    );
}
extern "C" {
    pub fn snd_ctl_elem_set_bytes(
        obj: *mut snd_ctl_elem_value_t,
        data: *mut ::std::os::raw::c_void,
        size: usize,
    );
}
extern "C" {
    pub fn snd_ctl_elem_value_get_bytes(
        obj: *const snd_ctl_elem_value_t,
    ) -> *const ::std::os::raw::c_void;
}
extern "C" {
    pub fn snd_ctl_elem_value_get_iec958(
        obj: *const snd_ctl_elem_value_t,
        ptr: *mut snd_aes_iec958_t,
    );
}
extern "C" {
    pub fn snd_ctl_elem_value_set_iec958(
        obj: *mut snd_ctl_elem_value_t,
        ptr: *const snd_aes_iec958_t,
    );
}
extern "C" {
    pub fn snd_tlv_parse_dB_info(
        tlv: *mut ::std::os::raw::c_uint,
        tlv_size: ::std::os::raw::c_uint,
        db_tlvp: *mut *mut ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_tlv_get_dB_range(
        tlv: *mut ::std::os::raw::c_uint,
        rangemin: ::std::os::raw::c_long,
        rangemax: ::std::os::raw::c_long,
        min: *mut ::std::os::raw::c_long,
        max: *mut ::std::os::raw::c_long,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_tlv_convert_to_dB(
        tlv: *mut ::std::os::raw::c_uint,
        rangemin: ::std::os::raw::c_long,
        rangemax: ::std::os::raw::c_long,
        volume: ::std::os::raw::c_long,
        db_gain: *mut ::std::os::raw::c_long,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_tlv_convert_from_dB(
        tlv: *mut ::std::os::raw::c_uint,
        rangemin: ::std::os::raw::c_long,
        rangemax: ::std::os::raw::c_long,
        db_gain: ::std::os::raw::c_long,
        value: *mut ::std::os::raw::c_long,
        xdir: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_ctl_get_dB_range(
        ctl: *mut snd_ctl_t,
        id: *const snd_ctl_elem_id_t,
        min: *mut ::std::os::raw::c_long,
        max: *mut ::std::os::raw::c_long,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_ctl_convert_to_dB(
        ctl: *mut snd_ctl_t,
        id: *const snd_ctl_elem_id_t,
        volume: ::std::os::raw::c_long,
        db_gain: *mut ::std::os::raw::c_long,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_ctl_convert_from_dB(
        ctl: *mut snd_ctl_t,
        id: *const snd_ctl_elem_id_t,
        db_gain: ::std::os::raw::c_long,
        value: *mut ::std::os::raw::c_long,
        xdir: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _snd_hctl_elem {
    _unused: [u8; 0],
}
#[doc = " HCTL element handle"]
pub type snd_hctl_elem_t = _snd_hctl_elem;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _snd_hctl {
    _unused: [u8; 0],
}
#[doc = " HCTL handle"]
pub type snd_hctl_t = _snd_hctl;
#[doc = " \\brief Compare function for sorting HCTL elements"]
#[doc = " \\param e1 First element"]
#[doc = " \\param e2 Second element"]
#[doc = " \\return -1 if e1 < e2, 0 if e1 == e2, 1 if e1 > e2"]
pub type snd_hctl_compare_t = ::std::option::Option<
    unsafe extern "C" fn(
        e1: *const snd_hctl_elem_t,
        e2: *const snd_hctl_elem_t,
    ) -> ::std::os::raw::c_int,
>;
extern "C" {
    pub fn snd_hctl_compare_fast(
        c1: *const snd_hctl_elem_t,
        c2: *const snd_hctl_elem_t,
    ) -> ::std::os::raw::c_int;
}
#[doc = " \\brief HCTL callback function"]
#[doc = " \\param hctl HCTL handle"]
#[doc = " \\param mask event mask"]
#[doc = " \\param elem related HCTL element (if any)"]
#[doc = " \\return 0 on success otherwise a negative error code"]
pub type snd_hctl_callback_t = ::std::option::Option<
    unsafe extern "C" fn(
        hctl: *mut snd_hctl_t,
        mask: ::std::os::raw::c_uint,
        elem: *mut snd_hctl_elem_t,
    ) -> ::std::os::raw::c_int,
>;
#[doc = " \\brief HCTL element callback function"]
#[doc = " \\param elem HCTL element"]
#[doc = " \\param mask event mask"]
#[doc = " \\return 0 on success otherwise a negative error code"]
pub type snd_hctl_elem_callback_t = ::std::option::Option<
    unsafe extern "C" fn(
        elem: *mut snd_hctl_elem_t,
        mask: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int,
>;
extern "C" {
    pub fn snd_hctl_open(
        hctl: *mut *mut snd_hctl_t,
        name: *const ::std::os::raw::c_char,
        mode: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_hctl_open_ctl(
        hctlp: *mut *mut snd_hctl_t,
        ctl: *mut snd_ctl_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_hctl_close(hctl: *mut snd_hctl_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_hctl_nonblock(
        hctl: *mut snd_hctl_t,
        nonblock: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_hctl_poll_descriptors_count(hctl: *mut snd_hctl_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_hctl_poll_descriptors(
        hctl: *mut snd_hctl_t,
        pfds: *mut pollfd,
        space: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_hctl_poll_descriptors_revents(
        ctl: *mut snd_hctl_t,
        pfds: *mut pollfd,
        nfds: ::std::os::raw::c_uint,
        revents: *mut ::std::os::raw::c_ushort,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_hctl_get_count(hctl: *mut snd_hctl_t) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn snd_hctl_set_compare(
        hctl: *mut snd_hctl_t,
        hsort: snd_hctl_compare_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_hctl_first_elem(hctl: *mut snd_hctl_t) -> *mut snd_hctl_elem_t;
}
extern "C" {
    pub fn snd_hctl_last_elem(hctl: *mut snd_hctl_t) -> *mut snd_hctl_elem_t;
}
extern "C" {
    pub fn snd_hctl_find_elem(
        hctl: *mut snd_hctl_t,
        id: *const snd_ctl_elem_id_t,
    ) -> *mut snd_hctl_elem_t;
}
extern "C" {
    pub fn snd_hctl_set_callback(hctl: *mut snd_hctl_t, callback: snd_hctl_callback_t);
}
extern "C" {
    pub fn snd_hctl_set_callback_private(hctl: *mut snd_hctl_t, data: *mut ::std::os::raw::c_void);
}
extern "C" {
    pub fn snd_hctl_get_callback_private(hctl: *mut snd_hctl_t) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn snd_hctl_load(hctl: *mut snd_hctl_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_hctl_free(hctl: *mut snd_hctl_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_hctl_handle_events(hctl: *mut snd_hctl_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_hctl_name(hctl: *mut snd_hctl_t) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn snd_hctl_wait(
        hctl: *mut snd_hctl_t,
        timeout: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_hctl_ctl(hctl: *mut snd_hctl_t) -> *mut snd_ctl_t;
}
extern "C" {
    pub fn snd_hctl_elem_next(elem: *mut snd_hctl_elem_t) -> *mut snd_hctl_elem_t;
}
extern "C" {
    pub fn snd_hctl_elem_prev(elem: *mut snd_hctl_elem_t) -> *mut snd_hctl_elem_t;
}
extern "C" {
    pub fn snd_hctl_elem_info(
        elem: *mut snd_hctl_elem_t,
        info: *mut snd_ctl_elem_info_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_hctl_elem_read(
        elem: *mut snd_hctl_elem_t,
        value: *mut snd_ctl_elem_value_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_hctl_elem_write(
        elem: *mut snd_hctl_elem_t,
        value: *mut snd_ctl_elem_value_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_hctl_elem_tlv_read(
        elem: *mut snd_hctl_elem_t,
        tlv: *mut ::std::os::raw::c_uint,
        tlv_size: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_hctl_elem_tlv_write(
        elem: *mut snd_hctl_elem_t,
        tlv: *const ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_hctl_elem_tlv_command(
        elem: *mut snd_hctl_elem_t,
        tlv: *const ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_hctl_elem_get_hctl(elem: *mut snd_hctl_elem_t) -> *mut snd_hctl_t;
}
extern "C" {
    pub fn snd_hctl_elem_get_id(obj: *const snd_hctl_elem_t, ptr: *mut snd_ctl_elem_id_t);
}
extern "C" {
    pub fn snd_hctl_elem_get_numid(obj: *const snd_hctl_elem_t) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn snd_hctl_elem_get_interface(obj: *const snd_hctl_elem_t) -> snd_ctl_elem_iface_t;
}
extern "C" {
    pub fn snd_hctl_elem_get_device(obj: *const snd_hctl_elem_t) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn snd_hctl_elem_get_subdevice(obj: *const snd_hctl_elem_t) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn snd_hctl_elem_get_name(obj: *const snd_hctl_elem_t) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn snd_hctl_elem_get_index(obj: *const snd_hctl_elem_t) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn snd_hctl_elem_set_callback(obj: *mut snd_hctl_elem_t, val: snd_hctl_elem_callback_t);
}
extern "C" {
    pub fn snd_hctl_elem_get_callback_private(
        obj: *const snd_hctl_elem_t,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn snd_hctl_elem_set_callback_private(
        obj: *mut snd_hctl_elem_t,
        val: *mut ::std::os::raw::c_void,
    );
}
extern "C" {
    #[doc = "  \\defgroup SControl Setup Control Interface"]
    #[doc = "  \\ingroup Control"]
    #[doc = "  The setup control interface - set or modify control elements from a configuration file."]
    #[doc = "  \\{"]
    pub fn snd_sctl_build(
        ctl: *mut *mut snd_sctl_t,
        handle: *mut snd_ctl_t,
        config: *mut snd_config_t,
        private_data: *mut snd_config_t,
        mode: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_sctl_free(handle: *mut snd_sctl_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_sctl_install(handle: *mut snd_sctl_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_sctl_remove(handle: *mut snd_sctl_t) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _snd_mixer {
    _unused: [u8; 0],
}
#[doc = " Mixer handle"]
pub type snd_mixer_t = _snd_mixer;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _snd_mixer_class {
    _unused: [u8; 0],
}
#[doc = " Mixer elements class handle"]
pub type snd_mixer_class_t = _snd_mixer_class;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _snd_mixer_elem {
    _unused: [u8; 0],
}
#[doc = " Mixer element handle"]
pub type snd_mixer_elem_t = _snd_mixer_elem;
#[doc = " \\brief Mixer callback function"]
#[doc = " \\param mixer Mixer handle"]
#[doc = " \\param mask event mask"]
#[doc = " \\param elem related mixer element (if any)"]
#[doc = " \\return 0 on success otherwise a negative error code"]
pub type snd_mixer_callback_t = ::std::option::Option<
    unsafe extern "C" fn(
        ctl: *mut snd_mixer_t,
        mask: ::std::os::raw::c_uint,
        elem: *mut snd_mixer_elem_t,
    ) -> ::std::os::raw::c_int,
>;
#[doc = " \\brief Mixer element callback function"]
#[doc = " \\param elem Mixer element"]
#[doc = " \\param mask event mask"]
#[doc = " \\return 0 on success otherwise a negative error code"]
pub type snd_mixer_elem_callback_t = ::std::option::Option<
    unsafe extern "C" fn(
        elem: *mut snd_mixer_elem_t,
        mask: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int,
>;
#[doc = " \\brief Compare function for sorting mixer elements"]
#[doc = " \\param e1 First element"]
#[doc = " \\param e2 Second element"]
#[doc = " \\return -1 if e1 < e2, 0 if e1 == e2, 1 if e1 > e2"]
pub type snd_mixer_compare_t = ::std::option::Option<
    unsafe extern "C" fn(
        e1: *const snd_mixer_elem_t,
        e2: *const snd_mixer_elem_t,
    ) -> ::std::os::raw::c_int,
>;
#[doc = " \\brief Event callback for the mixer class"]
#[doc = " \\param class_ Mixer class"]
#[doc = " \\param mask Event mask (SND_CTL_EVENT_*)"]
#[doc = " \\param helem HCTL element which invoked the event"]
#[doc = " \\param melem Mixer element associated to HCTL element"]
#[doc = " \\return zero if success, otherwise a negative error value"]
pub type snd_mixer_event_t = ::std::option::Option<
    unsafe extern "C" fn(
        class_: *mut snd_mixer_class_t,
        mask: ::std::os::raw::c_uint,
        helem: *mut snd_hctl_elem_t,
        melem: *mut snd_mixer_elem_t,
    ) -> ::std::os::raw::c_int,
>;
pub const SND_MIXER_ELEM_SIMPLE: _snd_mixer_elem_type = 0;
pub const SND_MIXER_ELEM_LAST: _snd_mixer_elem_type = 0;
#[doc = " Mixer element type"]
pub type _snd_mixer_elem_type = ::std::os::raw::c_uint;
#[doc = " Mixer element type"]
pub use self::_snd_mixer_elem_type as snd_mixer_elem_type_t;
extern "C" {
    pub fn snd_mixer_open(
        mixer: *mut *mut snd_mixer_t,
        mode: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_mixer_close(mixer: *mut snd_mixer_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_mixer_first_elem(mixer: *mut snd_mixer_t) -> *mut snd_mixer_elem_t;
}
extern "C" {
    pub fn snd_mixer_last_elem(mixer: *mut snd_mixer_t) -> *mut snd_mixer_elem_t;
}
extern "C" {
    pub fn snd_mixer_handle_events(mixer: *mut snd_mixer_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_mixer_attach(
        mixer: *mut snd_mixer_t,
        name: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_mixer_attach_hctl(
        mixer: *mut snd_mixer_t,
        hctl: *mut snd_hctl_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_mixer_detach(
        mixer: *mut snd_mixer_t,
        name: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_mixer_detach_hctl(
        mixer: *mut snd_mixer_t,
        hctl: *mut snd_hctl_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_mixer_get_hctl(
        mixer: *mut snd_mixer_t,
        name: *const ::std::os::raw::c_char,
        hctl: *mut *mut snd_hctl_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_mixer_poll_descriptors_count(mixer: *mut snd_mixer_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_mixer_poll_descriptors(
        mixer: *mut snd_mixer_t,
        pfds: *mut pollfd,
        space: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_mixer_poll_descriptors_revents(
        mixer: *mut snd_mixer_t,
        pfds: *mut pollfd,
        nfds: ::std::os::raw::c_uint,
        revents: *mut ::std::os::raw::c_ushort,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_mixer_load(mixer: *mut snd_mixer_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_mixer_free(mixer: *mut snd_mixer_t);
}
extern "C" {
    pub fn snd_mixer_wait(
        mixer: *mut snd_mixer_t,
        timeout: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_mixer_set_compare(
        mixer: *mut snd_mixer_t,
        msort: snd_mixer_compare_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_mixer_set_callback(obj: *mut snd_mixer_t, val: snd_mixer_callback_t);
}
extern "C" {
    pub fn snd_mixer_get_callback_private(obj: *const snd_mixer_t) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn snd_mixer_set_callback_private(obj: *mut snd_mixer_t, val: *mut ::std::os::raw::c_void);
}
extern "C" {
    pub fn snd_mixer_get_count(obj: *const snd_mixer_t) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn snd_mixer_class_unregister(clss: *mut snd_mixer_class_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_mixer_elem_next(elem: *mut snd_mixer_elem_t) -> *mut snd_mixer_elem_t;
}
extern "C" {
    pub fn snd_mixer_elem_prev(elem: *mut snd_mixer_elem_t) -> *mut snd_mixer_elem_t;
}
extern "C" {
    pub fn snd_mixer_elem_set_callback(obj: *mut snd_mixer_elem_t, val: snd_mixer_elem_callback_t);
}
extern "C" {
    pub fn snd_mixer_elem_get_callback_private(
        obj: *const snd_mixer_elem_t,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn snd_mixer_elem_set_callback_private(
        obj: *mut snd_mixer_elem_t,
        val: *mut ::std::os::raw::c_void,
    );
}
extern "C" {
    pub fn snd_mixer_elem_get_type(obj: *const snd_mixer_elem_t) -> snd_mixer_elem_type_t;
}
extern "C" {
    pub fn snd_mixer_class_register(
        class_: *mut snd_mixer_class_t,
        mixer: *mut snd_mixer_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_mixer_elem_new(
        elem: *mut *mut snd_mixer_elem_t,
        type_: snd_mixer_elem_type_t,
        compare_weight: ::std::os::raw::c_int,
        private_data: *mut ::std::os::raw::c_void,
        private_free: ::std::option::Option<unsafe extern "C" fn(elem: *mut snd_mixer_elem_t)>,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_mixer_elem_add(
        elem: *mut snd_mixer_elem_t,
        class_: *mut snd_mixer_class_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_mixer_elem_remove(elem: *mut snd_mixer_elem_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_mixer_elem_free(elem: *mut snd_mixer_elem_t);
}
extern "C" {
    pub fn snd_mixer_elem_info(elem: *mut snd_mixer_elem_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_mixer_elem_value(elem: *mut snd_mixer_elem_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_mixer_elem_attach(
        melem: *mut snd_mixer_elem_t,
        helem: *mut snd_hctl_elem_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_mixer_elem_detach(
        melem: *mut snd_mixer_elem_t,
        helem: *mut snd_hctl_elem_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_mixer_elem_empty(melem: *mut snd_mixer_elem_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_mixer_elem_get_private(
        melem: *const snd_mixer_elem_t,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn snd_mixer_class_sizeof() -> usize;
}
extern "C" {
    pub fn snd_mixer_class_malloc(ptr: *mut *mut snd_mixer_class_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_mixer_class_free(obj: *mut snd_mixer_class_t);
}
extern "C" {
    pub fn snd_mixer_class_copy(dst: *mut snd_mixer_class_t, src: *const snd_mixer_class_t);
}
extern "C" {
    pub fn snd_mixer_class_get_mixer(class_: *const snd_mixer_class_t) -> *mut snd_mixer_t;
}
extern "C" {
    pub fn snd_mixer_class_get_event(class_: *const snd_mixer_class_t) -> snd_mixer_event_t;
}
extern "C" {
    pub fn snd_mixer_class_get_private(
        class_: *const snd_mixer_class_t,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn snd_mixer_class_get_compare(class_: *const snd_mixer_class_t) -> snd_mixer_compare_t;
}
extern "C" {
    pub fn snd_mixer_class_set_event(
        class_: *mut snd_mixer_class_t,
        event: snd_mixer_event_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_mixer_class_set_private(
        class_: *mut snd_mixer_class_t,
        private_data: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_mixer_class_set_private_free(
        class_: *mut snd_mixer_class_t,
        private_free: ::std::option::Option<unsafe extern "C" fn(arg1: *mut snd_mixer_class_t)>,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_mixer_class_set_compare(
        class_: *mut snd_mixer_class_t,
        compare: snd_mixer_compare_t,
    ) -> ::std::os::raw::c_int;
}
#[doc = " Unknown"]
pub const SND_MIXER_SCHN_UNKNOWN: _snd_mixer_selem_channel_id = -1;
#[doc = " Front left"]
pub const SND_MIXER_SCHN_FRONT_LEFT: _snd_mixer_selem_channel_id = 0;
#[doc = " Front right"]
pub const SND_MIXER_SCHN_FRONT_RIGHT: _snd_mixer_selem_channel_id = 1;
#[doc = " Rear left"]
pub const SND_MIXER_SCHN_REAR_LEFT: _snd_mixer_selem_channel_id = 2;
#[doc = " Rear right"]
pub const SND_MIXER_SCHN_REAR_RIGHT: _snd_mixer_selem_channel_id = 3;
#[doc = " Front center"]
pub const SND_MIXER_SCHN_FRONT_CENTER: _snd_mixer_selem_channel_id = 4;
#[doc = " Woofer"]
pub const SND_MIXER_SCHN_WOOFER: _snd_mixer_selem_channel_id = 5;
#[doc = " Side Left"]
pub const SND_MIXER_SCHN_SIDE_LEFT: _snd_mixer_selem_channel_id = 6;
#[doc = " Side Right"]
pub const SND_MIXER_SCHN_SIDE_RIGHT: _snd_mixer_selem_channel_id = 7;
#[doc = " Rear Center"]
pub const SND_MIXER_SCHN_REAR_CENTER: _snd_mixer_selem_channel_id = 8;
#[doc = " Rear Center"]
pub const SND_MIXER_SCHN_LAST: _snd_mixer_selem_channel_id = 31;
#[doc = " Mono (Front left alias)"]
pub const SND_MIXER_SCHN_MONO: _snd_mixer_selem_channel_id = 0;
#[doc = " Mixer simple element channel identifier"]
pub type _snd_mixer_selem_channel_id = ::std::os::raw::c_int;
#[doc = " Mixer simple element channel identifier"]
pub use self::_snd_mixer_selem_channel_id as snd_mixer_selem_channel_id_t;
#[doc = " no abstraction - try use all universal controls from driver"]
pub const SND_MIXER_SABSTRACT_NONE: snd_mixer_selem_regopt_abstract = 0;
#[doc = " basic abstraction - Master,PCM,CD,Aux,Record-Gain etc."]
pub const SND_MIXER_SABSTRACT_BASIC: snd_mixer_selem_regopt_abstract = 1;
#[doc = " Mixer simple element - register options - abstraction level"]
pub type snd_mixer_selem_regopt_abstract = ::std::os::raw::c_uint;
#[doc = " Mixer simple element - register options"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct snd_mixer_selem_regopt {
    #[doc = " structure version"]
    pub ver: ::std::os::raw::c_int,
    #[doc = " v1: abstract layer selection"]
    pub abstract_: snd_mixer_selem_regopt_abstract,
    #[doc = " v1: device name (must be NULL when playback_pcm or capture_pcm != NULL)"]
    pub device: *const ::std::os::raw::c_char,
    #[doc = " v1: playback PCM connected to mixer device (NULL == none)"]
    pub playback_pcm: *mut snd_pcm_t,
    #[doc = " v1: capture PCM connected to mixer device (NULL == none)"]
    pub capture_pcm: *mut snd_pcm_t,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _snd_mixer_selem_id {
    _unused: [u8; 0],
}
#[doc = " Mixer simple element identifier"]
pub type snd_mixer_selem_id_t = _snd_mixer_selem_id;
extern "C" {
    pub fn snd_mixer_selem_channel_name(
        channel: snd_mixer_selem_channel_id_t,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn snd_mixer_selem_register(
        mixer: *mut snd_mixer_t,
        options: *mut snd_mixer_selem_regopt,
        classp: *mut *mut snd_mixer_class_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_mixer_selem_get_id(element: *mut snd_mixer_elem_t, id: *mut snd_mixer_selem_id_t);
}
extern "C" {
    pub fn snd_mixer_selem_get_name(elem: *mut snd_mixer_elem_t) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn snd_mixer_selem_get_index(elem: *mut snd_mixer_elem_t) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn snd_mixer_find_selem(
        mixer: *mut snd_mixer_t,
        id: *const snd_mixer_selem_id_t,
    ) -> *mut snd_mixer_elem_t;
}
extern "C" {
    pub fn snd_mixer_selem_is_active(elem: *mut snd_mixer_elem_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_mixer_selem_is_playback_mono(elem: *mut snd_mixer_elem_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_mixer_selem_has_playback_channel(
        obj: *mut snd_mixer_elem_t,
        channel: snd_mixer_selem_channel_id_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_mixer_selem_is_capture_mono(elem: *mut snd_mixer_elem_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_mixer_selem_has_capture_channel(
        obj: *mut snd_mixer_elem_t,
        channel: snd_mixer_selem_channel_id_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_mixer_selem_get_capture_group(elem: *mut snd_mixer_elem_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_mixer_selem_has_common_volume(elem: *mut snd_mixer_elem_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_mixer_selem_has_playback_volume(
        elem: *mut snd_mixer_elem_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_mixer_selem_has_playback_volume_joined(
        elem: *mut snd_mixer_elem_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_mixer_selem_has_capture_volume(elem: *mut snd_mixer_elem_t)
        -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_mixer_selem_has_capture_volume_joined(
        elem: *mut snd_mixer_elem_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_mixer_selem_has_common_switch(elem: *mut snd_mixer_elem_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_mixer_selem_has_playback_switch(
        elem: *mut snd_mixer_elem_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_mixer_selem_has_playback_switch_joined(
        elem: *mut snd_mixer_elem_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_mixer_selem_has_capture_switch(elem: *mut snd_mixer_elem_t)
        -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_mixer_selem_has_capture_switch_joined(
        elem: *mut snd_mixer_elem_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_mixer_selem_has_capture_switch_exclusive(
        elem: *mut snd_mixer_elem_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_mixer_selem_ask_playback_vol_dB(
        elem: *mut snd_mixer_elem_t,
        value: ::std::os::raw::c_long,
        dBvalue: *mut ::std::os::raw::c_long,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_mixer_selem_ask_capture_vol_dB(
        elem: *mut snd_mixer_elem_t,
        value: ::std::os::raw::c_long,
        dBvalue: *mut ::std::os::raw::c_long,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_mixer_selem_ask_playback_dB_vol(
        elem: *mut snd_mixer_elem_t,
        dBvalue: ::std::os::raw::c_long,
        dir: ::std::os::raw::c_int,
        value: *mut ::std::os::raw::c_long,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_mixer_selem_ask_capture_dB_vol(
        elem: *mut snd_mixer_elem_t,
        dBvalue: ::std::os::raw::c_long,
        dir: ::std::os::raw::c_int,
        value: *mut ::std::os::raw::c_long,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_mixer_selem_get_playback_volume(
        elem: *mut snd_mixer_elem_t,
        channel: snd_mixer_selem_channel_id_t,
        value: *mut ::std::os::raw::c_long,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_mixer_selem_get_capture_volume(
        elem: *mut snd_mixer_elem_t,
        channel: snd_mixer_selem_channel_id_t,
        value: *mut ::std::os::raw::c_long,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_mixer_selem_get_playback_dB(
        elem: *mut snd_mixer_elem_t,
        channel: snd_mixer_selem_channel_id_t,
        value: *mut ::std::os::raw::c_long,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_mixer_selem_get_capture_dB(
        elem: *mut snd_mixer_elem_t,
        channel: snd_mixer_selem_channel_id_t,
        value: *mut ::std::os::raw::c_long,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_mixer_selem_get_playback_switch(
        elem: *mut snd_mixer_elem_t,
        channel: snd_mixer_selem_channel_id_t,
        value: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_mixer_selem_get_capture_switch(
        elem: *mut snd_mixer_elem_t,
        channel: snd_mixer_selem_channel_id_t,
        value: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_mixer_selem_set_playback_volume(
        elem: *mut snd_mixer_elem_t,
        channel: snd_mixer_selem_channel_id_t,
        value: ::std::os::raw::c_long,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_mixer_selem_set_capture_volume(
        elem: *mut snd_mixer_elem_t,
        channel: snd_mixer_selem_channel_id_t,
        value: ::std::os::raw::c_long,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_mixer_selem_set_playback_dB(
        elem: *mut snd_mixer_elem_t,
        channel: snd_mixer_selem_channel_id_t,
        value: ::std::os::raw::c_long,
        dir: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_mixer_selem_set_capture_dB(
        elem: *mut snd_mixer_elem_t,
        channel: snd_mixer_selem_channel_id_t,
        value: ::std::os::raw::c_long,
        dir: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_mixer_selem_set_playback_volume_all(
        elem: *mut snd_mixer_elem_t,
        value: ::std::os::raw::c_long,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_mixer_selem_set_capture_volume_all(
        elem: *mut snd_mixer_elem_t,
        value: ::std::os::raw::c_long,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_mixer_selem_set_playback_dB_all(
        elem: *mut snd_mixer_elem_t,
        value: ::std::os::raw::c_long,
        dir: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_mixer_selem_set_capture_dB_all(
        elem: *mut snd_mixer_elem_t,
        value: ::std::os::raw::c_long,
        dir: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_mixer_selem_set_playback_switch(
        elem: *mut snd_mixer_elem_t,
        channel: snd_mixer_selem_channel_id_t,
        value: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_mixer_selem_set_capture_switch(
        elem: *mut snd_mixer_elem_t,
        channel: snd_mixer_selem_channel_id_t,
        value: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_mixer_selem_set_playback_switch_all(
        elem: *mut snd_mixer_elem_t,
        value: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_mixer_selem_set_capture_switch_all(
        elem: *mut snd_mixer_elem_t,
        value: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_mixer_selem_get_playback_volume_range(
        elem: *mut snd_mixer_elem_t,
        min: *mut ::std::os::raw::c_long,
        max: *mut ::std::os::raw::c_long,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_mixer_selem_get_playback_dB_range(
        elem: *mut snd_mixer_elem_t,
        min: *mut ::std::os::raw::c_long,
        max: *mut ::std::os::raw::c_long,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_mixer_selem_set_playback_volume_range(
        elem: *mut snd_mixer_elem_t,
        min: ::std::os::raw::c_long,
        max: ::std::os::raw::c_long,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_mixer_selem_get_capture_volume_range(
        elem: *mut snd_mixer_elem_t,
        min: *mut ::std::os::raw::c_long,
        max: *mut ::std::os::raw::c_long,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_mixer_selem_get_capture_dB_range(
        elem: *mut snd_mixer_elem_t,
        min: *mut ::std::os::raw::c_long,
        max: *mut ::std::os::raw::c_long,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_mixer_selem_set_capture_volume_range(
        elem: *mut snd_mixer_elem_t,
        min: ::std::os::raw::c_long,
        max: ::std::os::raw::c_long,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_mixer_selem_is_enumerated(elem: *mut snd_mixer_elem_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_mixer_selem_is_enum_playback(elem: *mut snd_mixer_elem_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_mixer_selem_is_enum_capture(elem: *mut snd_mixer_elem_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_mixer_selem_get_enum_items(elem: *mut snd_mixer_elem_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_mixer_selem_get_enum_item_name(
        elem: *mut snd_mixer_elem_t,
        idx: ::std::os::raw::c_uint,
        maxlen: usize,
        str_: *mut ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_mixer_selem_get_enum_item(
        elem: *mut snd_mixer_elem_t,
        channel: snd_mixer_selem_channel_id_t,
        idxp: *mut ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_mixer_selem_set_enum_item(
        elem: *mut snd_mixer_elem_t,
        channel: snd_mixer_selem_channel_id_t,
        idx: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_mixer_selem_id_sizeof() -> usize;
}
extern "C" {
    pub fn snd_mixer_selem_id_malloc(ptr: *mut *mut snd_mixer_selem_id_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_mixer_selem_id_free(obj: *mut snd_mixer_selem_id_t);
}
extern "C" {
    pub fn snd_mixer_selem_id_copy(
        dst: *mut snd_mixer_selem_id_t,
        src: *const snd_mixer_selem_id_t,
    );
}
extern "C" {
    pub fn snd_mixer_selem_id_get_name(
        obj: *const snd_mixer_selem_id_t,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn snd_mixer_selem_id_get_index(obj: *const snd_mixer_selem_id_t)
        -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn snd_mixer_selem_id_set_name(
        obj: *mut snd_mixer_selem_id_t,
        val: *const ::std::os::raw::c_char,
    );
}
extern "C" {
    pub fn snd_mixer_selem_id_set_index(
        obj: *mut snd_mixer_selem_id_t,
        val: ::std::os::raw::c_uint,
    );
}
extern "C" {
    pub fn snd_mixer_selem_id_parse(
        dst: *mut snd_mixer_selem_id_t,
        str_: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
#[doc = " Sequencer event data type"]
pub type snd_seq_event_type_t = ::std::os::raw::c_uchar;
#[doc = " system status; event data type = #snd_seq_result_t"]
pub const SND_SEQ_EVENT_SYSTEM: snd_seq_event_type = 0;
#[doc = " returned result status; event data type = #snd_seq_result_t"]
pub const SND_SEQ_EVENT_RESULT: snd_seq_event_type = 1;
#[doc = " note on and off with duration; event data type = #snd_seq_ev_note_t"]
pub const SND_SEQ_EVENT_NOTE: snd_seq_event_type = 5;
#[doc = " note on; event data type = #snd_seq_ev_note_t"]
pub const SND_SEQ_EVENT_NOTEON: snd_seq_event_type = 6;
#[doc = " note off; event data type = #snd_seq_ev_note_t"]
pub const SND_SEQ_EVENT_NOTEOFF: snd_seq_event_type = 7;
#[doc = " key pressure change (aftertouch); event data type = #snd_seq_ev_note_t"]
pub const SND_SEQ_EVENT_KEYPRESS: snd_seq_event_type = 8;
#[doc = " controller; event data type = #snd_seq_ev_ctrl_t"]
pub const SND_SEQ_EVENT_CONTROLLER: snd_seq_event_type = 10;
#[doc = " program change; event data type = #snd_seq_ev_ctrl_t"]
pub const SND_SEQ_EVENT_PGMCHANGE: snd_seq_event_type = 11;
#[doc = " channel pressure; event data type = #snd_seq_ev_ctrl_t"]
pub const SND_SEQ_EVENT_CHANPRESS: snd_seq_event_type = 12;
#[doc = " pitchwheel; event data type = #snd_seq_ev_ctrl_t; data is from -8192 to 8191)"]
pub const SND_SEQ_EVENT_PITCHBEND: snd_seq_event_type = 13;
#[doc = " 14 bit controller value; event data type = #snd_seq_ev_ctrl_t"]
pub const SND_SEQ_EVENT_CONTROL14: snd_seq_event_type = 14;
#[doc = " 14 bit NRPN;  event data type = #snd_seq_ev_ctrl_t"]
pub const SND_SEQ_EVENT_NONREGPARAM: snd_seq_event_type = 15;
#[doc = " 14 bit RPN; event data type = #snd_seq_ev_ctrl_t"]
pub const SND_SEQ_EVENT_REGPARAM: snd_seq_event_type = 16;
#[doc = " SPP with LSB and MSB values; event data type = #snd_seq_ev_ctrl_t"]
pub const SND_SEQ_EVENT_SONGPOS: snd_seq_event_type = 20;
#[doc = " Song Select with song ID number; event data type = #snd_seq_ev_ctrl_t"]
pub const SND_SEQ_EVENT_SONGSEL: snd_seq_event_type = 21;
#[doc = " midi time code quarter frame; event data type = #snd_seq_ev_ctrl_t"]
pub const SND_SEQ_EVENT_QFRAME: snd_seq_event_type = 22;
#[doc = " SMF Time Signature event; event data type = #snd_seq_ev_ctrl_t"]
pub const SND_SEQ_EVENT_TIMESIGN: snd_seq_event_type = 23;
#[doc = " SMF Key Signature event; event data type = #snd_seq_ev_ctrl_t"]
pub const SND_SEQ_EVENT_KEYSIGN: snd_seq_event_type = 24;
#[doc = " MIDI Real Time Start message; event data type = #snd_seq_ev_queue_control_t"]
pub const SND_SEQ_EVENT_START: snd_seq_event_type = 30;
#[doc = " MIDI Real Time Continue message; event data type = #snd_seq_ev_queue_control_t"]
pub const SND_SEQ_EVENT_CONTINUE: snd_seq_event_type = 31;
#[doc = " MIDI Real Time Stop message; event data type = #snd_seq_ev_queue_control_t"]
pub const SND_SEQ_EVENT_STOP: snd_seq_event_type = 32;
#[doc = " Set tick queue position; event data type = #snd_seq_ev_queue_control_t"]
pub const SND_SEQ_EVENT_SETPOS_TICK: snd_seq_event_type = 33;
#[doc = " Set real-time queue position; event data type = #snd_seq_ev_queue_control_t"]
pub const SND_SEQ_EVENT_SETPOS_TIME: snd_seq_event_type = 34;
#[doc = " (SMF) Tempo event; event data type = #snd_seq_ev_queue_control_t"]
pub const SND_SEQ_EVENT_TEMPO: snd_seq_event_type = 35;
#[doc = " MIDI Real Time Clock message; event data type = #snd_seq_ev_queue_control_t"]
pub const SND_SEQ_EVENT_CLOCK: snd_seq_event_type = 36;
#[doc = " MIDI Real Time Tick message; event data type = #snd_seq_ev_queue_control_t"]
pub const SND_SEQ_EVENT_TICK: snd_seq_event_type = 37;
#[doc = " Queue timer skew; event data type = #snd_seq_ev_queue_control_t"]
pub const SND_SEQ_EVENT_QUEUE_SKEW: snd_seq_event_type = 38;
#[doc = " Sync position changed; event data type = #snd_seq_ev_queue_control_t"]
pub const SND_SEQ_EVENT_SYNC_POS: snd_seq_event_type = 39;
#[doc = " Tune request; event data type = none"]
pub const SND_SEQ_EVENT_TUNE_REQUEST: snd_seq_event_type = 40;
#[doc = " Reset to power-on state; event data type = none"]
pub const SND_SEQ_EVENT_RESET: snd_seq_event_type = 41;
#[doc = " Active sensing event; event data type = none"]
pub const SND_SEQ_EVENT_SENSING: snd_seq_event_type = 42;
#[doc = " Echo-back event; event data type = any type"]
pub const SND_SEQ_EVENT_ECHO: snd_seq_event_type = 50;
#[doc = " OSS emulation raw event; event data type = any type"]
pub const SND_SEQ_EVENT_OSS: snd_seq_event_type = 51;
#[doc = " New client has connected; event data type = #snd_seq_addr_t"]
pub const SND_SEQ_EVENT_CLIENT_START: snd_seq_event_type = 60;
#[doc = " Client has left the system; event data type = #snd_seq_addr_t"]
pub const SND_SEQ_EVENT_CLIENT_EXIT: snd_seq_event_type = 61;
#[doc = " Client status/info has changed; event data type = #snd_seq_addr_t"]
pub const SND_SEQ_EVENT_CLIENT_CHANGE: snd_seq_event_type = 62;
#[doc = " New port was created; event data type = #snd_seq_addr_t"]
pub const SND_SEQ_EVENT_PORT_START: snd_seq_event_type = 63;
#[doc = " Port was deleted from system; event data type = #snd_seq_addr_t"]
pub const SND_SEQ_EVENT_PORT_EXIT: snd_seq_event_type = 64;
#[doc = " Port status/info has changed; event data type = #snd_seq_addr_t"]
pub const SND_SEQ_EVENT_PORT_CHANGE: snd_seq_event_type = 65;
#[doc = " Ports connected; event data type = #snd_seq_connect_t"]
pub const SND_SEQ_EVENT_PORT_SUBSCRIBED: snd_seq_event_type = 66;
#[doc = " Ports disconnected; event data type = #snd_seq_connect_t"]
pub const SND_SEQ_EVENT_PORT_UNSUBSCRIBED: snd_seq_event_type = 67;
#[doc = " user-defined event; event data type = any (fixed size)"]
pub const SND_SEQ_EVENT_USR0: snd_seq_event_type = 90;
#[doc = " user-defined event; event data type = any (fixed size)"]
pub const SND_SEQ_EVENT_USR1: snd_seq_event_type = 91;
#[doc = " user-defined event; event data type = any (fixed size)"]
pub const SND_SEQ_EVENT_USR2: snd_seq_event_type = 92;
#[doc = " user-defined event; event data type = any (fixed size)"]
pub const SND_SEQ_EVENT_USR3: snd_seq_event_type = 93;
#[doc = " user-defined event; event data type = any (fixed size)"]
pub const SND_SEQ_EVENT_USR4: snd_seq_event_type = 94;
#[doc = " user-defined event; event data type = any (fixed size)"]
pub const SND_SEQ_EVENT_USR5: snd_seq_event_type = 95;
#[doc = " user-defined event; event data type = any (fixed size)"]
pub const SND_SEQ_EVENT_USR6: snd_seq_event_type = 96;
#[doc = " user-defined event; event data type = any (fixed size)"]
pub const SND_SEQ_EVENT_USR7: snd_seq_event_type = 97;
#[doc = " user-defined event; event data type = any (fixed size)"]
pub const SND_SEQ_EVENT_USR8: snd_seq_event_type = 98;
#[doc = " user-defined event; event data type = any (fixed size)"]
pub const SND_SEQ_EVENT_USR9: snd_seq_event_type = 99;
#[doc = " system exclusive data (variable length);  event data type = #snd_seq_ev_ext_t"]
pub const SND_SEQ_EVENT_SYSEX: snd_seq_event_type = 130;
#[doc = " error event;  event data type = #snd_seq_ev_ext_t"]
pub const SND_SEQ_EVENT_BOUNCE: snd_seq_event_type = 131;
#[doc = " reserved for user apps;  event data type = #snd_seq_ev_ext_t"]
pub const SND_SEQ_EVENT_USR_VAR0: snd_seq_event_type = 135;
#[doc = " reserved for user apps; event data type = #snd_seq_ev_ext_t"]
pub const SND_SEQ_EVENT_USR_VAR1: snd_seq_event_type = 136;
#[doc = " reserved for user apps; event data type = #snd_seq_ev_ext_t"]
pub const SND_SEQ_EVENT_USR_VAR2: snd_seq_event_type = 137;
#[doc = " reserved for user apps; event data type = #snd_seq_ev_ext_t"]
pub const SND_SEQ_EVENT_USR_VAR3: snd_seq_event_type = 138;
#[doc = " reserved for user apps; event data type = #snd_seq_ev_ext_t"]
pub const SND_SEQ_EVENT_USR_VAR4: snd_seq_event_type = 139;
#[doc = " NOP; ignored in any case"]
pub const SND_SEQ_EVENT_NONE: snd_seq_event_type = 255;
#[doc = " Sequencer event type"]
pub type snd_seq_event_type = ::std::os::raw::c_uint;
#[doc = " Sequencer event address"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct snd_seq_addr {
    #[doc = "< Client id"]
    pub client: ::std::os::raw::c_uchar,
    #[doc = "< Port id"]
    pub port: ::std::os::raw::c_uchar,
}
#[doc = " Sequencer event address"]
pub type snd_seq_addr_t = snd_seq_addr;
#[doc = " Connection (subscription) between ports"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct snd_seq_connect {
    #[doc = "< sender address"]
    pub sender: snd_seq_addr_t,
    #[doc = "< destination address"]
    pub dest: snd_seq_addr_t,
}
#[doc = " Connection (subscription) between ports"]
pub type snd_seq_connect_t = snd_seq_connect;
#[doc = " Real-time data record"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct snd_seq_real_time {
    #[doc = "< seconds"]
    pub tv_sec: ::std::os::raw::c_uint,
    #[doc = "< nanoseconds"]
    pub tv_nsec: ::std::os::raw::c_uint,
}
#[doc = " Real-time data record"]
pub type snd_seq_real_time_t = snd_seq_real_time;
#[doc = " (MIDI) Tick-time data record"]
pub type snd_seq_tick_time_t = ::std::os::raw::c_uint;
#[doc = " unioned time stamp"]
#[repr(C)]
#[derive(Copy, Clone)]
pub union snd_seq_timestamp {
    #[doc = "< tick-time"]
    pub tick: snd_seq_tick_time_t,
    #[doc = "< real-time"]
    pub time: snd_seq_real_time,
    _bindgen_union_align: [u32; 2usize],
}
#[doc = " unioned time stamp"]
pub type snd_seq_timestamp_t = snd_seq_timestamp;
#[doc = " Note event"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct snd_seq_ev_note {
    #[doc = "< channel number"]
    pub channel: ::std::os::raw::c_uchar,
    #[doc = "< note"]
    pub note: ::std::os::raw::c_uchar,
    #[doc = "< velocity"]
    pub velocity: ::std::os::raw::c_uchar,
    #[doc = "< note-off velocity; only for #SND_SEQ_EVENT_NOTE"]
    pub off_velocity: ::std::os::raw::c_uchar,
    #[doc = "< duration until note-off; only for #SND_SEQ_EVENT_NOTE"]
    pub duration: ::std::os::raw::c_uint,
}
#[doc = " Note event"]
pub type snd_seq_ev_note_t = snd_seq_ev_note;
#[doc = " Controller event"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct snd_seq_ev_ctrl {
    #[doc = "< channel number"]
    pub channel: ::std::os::raw::c_uchar,
    #[doc = "< reserved"]
    pub unused: [::std::os::raw::c_uchar; 3usize],
    #[doc = "< control parameter"]
    pub param: ::std::os::raw::c_uint,
    #[doc = "< control value"]
    pub value: ::std::os::raw::c_int,
}
#[doc = " Controller event"]
pub type snd_seq_ev_ctrl_t = snd_seq_ev_ctrl;
#[doc = " generic set of bytes (12x8 bit)"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct snd_seq_ev_raw8 {
    #[doc = "< 8 bit value"]
    pub d: [::std::os::raw::c_uchar; 12usize],
}
#[doc = " generic set of bytes (12x8 bit)"]
pub type snd_seq_ev_raw8_t = snd_seq_ev_raw8;
#[doc = " generic set of integers (3x32 bit)"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct snd_seq_ev_raw32 {
    #[doc = "< 32 bit value"]
    pub d: [::std::os::raw::c_uint; 3usize],
}
#[doc = " generic set of integers (3x32 bit)"]
pub type snd_seq_ev_raw32_t = snd_seq_ev_raw32;
#[doc = " external stored data"]
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct snd_seq_ev_ext {
    #[doc = "< length of data"]
    pub len: ::std::os::raw::c_uint,
    #[doc = "< pointer to data (note: can be 64-bit)"]
    pub ptr: *mut ::std::os::raw::c_void,
}
#[doc = " external stored data"]
pub type snd_seq_ev_ext_t = snd_seq_ev_ext;
#[doc = " Result events"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct snd_seq_result {
    #[doc = "< processed event type"]
    pub event: ::std::os::raw::c_int,
    #[doc = "< status"]
    pub result: ::std::os::raw::c_int,
}
#[doc = " Result events"]
pub type snd_seq_result_t = snd_seq_result;
#[doc = " Queue skew values"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct snd_seq_queue_skew {
    #[doc = "< skew value"]
    pub value: ::std::os::raw::c_uint,
    #[doc = "< skew base"]
    pub base: ::std::os::raw::c_uint,
}
#[doc = " Queue skew values"]
pub type snd_seq_queue_skew_t = snd_seq_queue_skew;
#[doc = " queue timer control"]
#[repr(C)]
#[derive(Copy, Clone)]
pub struct snd_seq_ev_queue_control {
    #[doc = "< affected queue"]
    pub queue: ::std::os::raw::c_uchar,
    #[doc = "< reserved"]
    pub unused: [::std::os::raw::c_uchar; 3usize],
    #[doc = "< data value union"]
    pub param: snd_seq_ev_queue_control__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union snd_seq_ev_queue_control__bindgen_ty_1 {
    #[doc = "< affected value (e.g. tempo)"]
    pub value: ::std::os::raw::c_int,
    #[doc = "< time"]
    pub time: snd_seq_timestamp_t,
    #[doc = "< sync position"]
    pub position: ::std::os::raw::c_uint,
    #[doc = "< queue skew"]
    pub skew: snd_seq_queue_skew_t,
    #[doc = "< any data"]
    pub d32: [::std::os::raw::c_uint; 2usize],
    #[doc = "< any data"]
    pub d8: [::std::os::raw::c_uchar; 8usize],
    _bindgen_union_align: [u32; 2usize],
}
#[doc = " queue timer control"]
pub type snd_seq_ev_queue_control_t = snd_seq_ev_queue_control;
#[doc = " Sequencer event"]
#[repr(C)]
#[derive(Copy, Clone)]
pub struct snd_seq_event {
    #[doc = "< event type"]
    pub type_: snd_seq_event_type_t,
    #[doc = "< event flags"]
    pub flags: ::std::os::raw::c_uchar,
    #[doc = "< tag"]
    pub tag: ::std::os::raw::c_uchar,
    #[doc = "< schedule queue"]
    pub queue: ::std::os::raw::c_uchar,
    #[doc = "< schedule time"]
    pub time: snd_seq_timestamp_t,
    #[doc = "< source address"]
    pub source: snd_seq_addr_t,
    #[doc = "< destination address"]
    pub dest: snd_seq_addr_t,
    #[doc = "< event data..."]
    pub data: snd_seq_event__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union snd_seq_event__bindgen_ty_1 {
    #[doc = "< note information"]
    pub note: snd_seq_ev_note_t,
    #[doc = "< MIDI control information"]
    pub control: snd_seq_ev_ctrl_t,
    #[doc = "< raw8 data"]
    pub raw8: snd_seq_ev_raw8_t,
    #[doc = "< raw32 data"]
    pub raw32: snd_seq_ev_raw32_t,
    #[doc = "< external data"]
    pub ext: snd_seq_ev_ext_t,
    #[doc = "< queue control"]
    pub queue: snd_seq_ev_queue_control_t,
    #[doc = "< timestamp"]
    pub time: snd_seq_timestamp_t,
    #[doc = "< address"]
    pub addr: snd_seq_addr_t,
    #[doc = "< connect information"]
    pub connect: snd_seq_connect_t,
    #[doc = "< operation result code"]
    pub result: snd_seq_result_t,
    _bindgen_union_align: [u32; 3usize],
}
#[doc = " Sequencer event"]
pub type snd_seq_event_t = snd_seq_event;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _snd_seq {
    _unused: [u8; 0],
}
#[doc = " Sequencer handle"]
pub type snd_seq_t = _snd_seq;
#[doc = "< hardware"]
pub const SND_SEQ_TYPE_HW: _snd_seq_type = 0;
#[doc = "< shared memory (NYI)"]
pub const SND_SEQ_TYPE_SHM: _snd_seq_type = 1;
#[doc = "< network (NYI)"]
pub const SND_SEQ_TYPE_INET: _snd_seq_type = 2;
#[doc = " sequencer handle type"]
pub type _snd_seq_type = ::std::os::raw::c_uint;
#[doc = " sequencer handle type"]
pub use self::_snd_seq_type as snd_seq_type_t;
extern "C" {
    pub fn snd_seq_open(
        handle: *mut *mut snd_seq_t,
        name: *const ::std::os::raw::c_char,
        streams: ::std::os::raw::c_int,
        mode: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_seq_open_lconf(
        handle: *mut *mut snd_seq_t,
        name: *const ::std::os::raw::c_char,
        streams: ::std::os::raw::c_int,
        mode: ::std::os::raw::c_int,
        lconf: *mut snd_config_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_seq_name(seq: *mut snd_seq_t) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn snd_seq_type(seq: *mut snd_seq_t) -> snd_seq_type_t;
}
extern "C" {
    pub fn snd_seq_close(handle: *mut snd_seq_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_seq_poll_descriptors_count(
        handle: *mut snd_seq_t,
        events: ::std::os::raw::c_short,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_seq_poll_descriptors(
        handle: *mut snd_seq_t,
        pfds: *mut pollfd,
        space: ::std::os::raw::c_uint,
        events: ::std::os::raw::c_short,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_seq_poll_descriptors_revents(
        seq: *mut snd_seq_t,
        pfds: *mut pollfd,
        nfds: ::std::os::raw::c_uint,
        revents: *mut ::std::os::raw::c_ushort,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_seq_nonblock(
        handle: *mut snd_seq_t,
        nonblock: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_seq_client_id(handle: *mut snd_seq_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_seq_get_output_buffer_size(handle: *mut snd_seq_t) -> usize;
}
extern "C" {
    pub fn snd_seq_get_input_buffer_size(handle: *mut snd_seq_t) -> usize;
}
extern "C" {
    pub fn snd_seq_set_output_buffer_size(
        handle: *mut snd_seq_t,
        size: usize,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_seq_set_input_buffer_size(
        handle: *mut snd_seq_t,
        size: usize,
    ) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _snd_seq_system_info {
    _unused: [u8; 0],
}
#[doc = " system information container"]
pub type snd_seq_system_info_t = _snd_seq_system_info;
extern "C" {
    pub fn snd_seq_system_info_sizeof() -> usize;
}
extern "C" {
    pub fn snd_seq_system_info_malloc(
        ptr: *mut *mut snd_seq_system_info_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_seq_system_info_free(ptr: *mut snd_seq_system_info_t);
}
extern "C" {
    pub fn snd_seq_system_info_copy(
        dst: *mut snd_seq_system_info_t,
        src: *const snd_seq_system_info_t,
    );
}
extern "C" {
    pub fn snd_seq_system_info_get_queues(
        info: *const snd_seq_system_info_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_seq_system_info_get_clients(
        info: *const snd_seq_system_info_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_seq_system_info_get_ports(
        info: *const snd_seq_system_info_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_seq_system_info_get_channels(
        info: *const snd_seq_system_info_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_seq_system_info_get_cur_clients(
        info: *const snd_seq_system_info_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_seq_system_info_get_cur_queues(
        info: *const snd_seq_system_info_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_seq_system_info(
        handle: *mut snd_seq_t,
        info: *mut snd_seq_system_info_t,
    ) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _snd_seq_client_info {
    _unused: [u8; 0],
}
#[doc = " client information container"]
pub type snd_seq_client_info_t = _snd_seq_client_info;
#[doc = "< user client"]
pub const SND_SEQ_USER_CLIENT: snd_seq_client_type = 1;
#[doc = "< kernel client"]
pub const SND_SEQ_KERNEL_CLIENT: snd_seq_client_type = 2;
#[doc = " client types"]
pub type snd_seq_client_type = ::std::os::raw::c_uint;
#[doc = " client types"]
pub use self::snd_seq_client_type as snd_seq_client_type_t;
extern "C" {
    pub fn snd_seq_client_info_sizeof() -> usize;
}
extern "C" {
    pub fn snd_seq_client_info_malloc(
        ptr: *mut *mut snd_seq_client_info_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_seq_client_info_free(ptr: *mut snd_seq_client_info_t);
}
extern "C" {
    pub fn snd_seq_client_info_copy(
        dst: *mut snd_seq_client_info_t,
        src: *const snd_seq_client_info_t,
    );
}
extern "C" {
    pub fn snd_seq_client_info_get_client(
        info: *const snd_seq_client_info_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_seq_client_info_get_type(
        info: *const snd_seq_client_info_t,
    ) -> snd_seq_client_type_t;
}
extern "C" {
    pub fn snd_seq_client_info_get_name(
        info: *mut snd_seq_client_info_t,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn snd_seq_client_info_get_broadcast_filter(
        info: *const snd_seq_client_info_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_seq_client_info_get_error_bounce(
        info: *const snd_seq_client_info_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_seq_client_info_get_card(
        info: *const snd_seq_client_info_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_seq_client_info_get_pid(info: *const snd_seq_client_info_t)
        -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_seq_client_info_get_event_filter(
        info: *const snd_seq_client_info_t,
    ) -> *const ::std::os::raw::c_uchar;
}
extern "C" {
    pub fn snd_seq_client_info_get_num_ports(
        info: *const snd_seq_client_info_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_seq_client_info_get_event_lost(
        info: *const snd_seq_client_info_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_seq_client_info_set_client(
        info: *mut snd_seq_client_info_t,
        client: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn snd_seq_client_info_set_name(
        info: *mut snd_seq_client_info_t,
        name: *const ::std::os::raw::c_char,
    );
}
extern "C" {
    pub fn snd_seq_client_info_set_broadcast_filter(
        info: *mut snd_seq_client_info_t,
        val: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn snd_seq_client_info_set_error_bounce(
        info: *mut snd_seq_client_info_t,
        val: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn snd_seq_client_info_set_event_filter(
        info: *mut snd_seq_client_info_t,
        filter: *mut ::std::os::raw::c_uchar,
    );
}
extern "C" {
    pub fn snd_seq_client_info_event_filter_clear(info: *mut snd_seq_client_info_t);
}
extern "C" {
    pub fn snd_seq_client_info_event_filter_add(
        info: *mut snd_seq_client_info_t,
        event_type: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn snd_seq_client_info_event_filter_del(
        info: *mut snd_seq_client_info_t,
        event_type: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn snd_seq_client_info_event_filter_check(
        info: *mut snd_seq_client_info_t,
        event_type: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_seq_get_client_info(
        handle: *mut snd_seq_t,
        info: *mut snd_seq_client_info_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_seq_get_any_client_info(
        handle: *mut snd_seq_t,
        client: ::std::os::raw::c_int,
        info: *mut snd_seq_client_info_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_seq_set_client_info(
        handle: *mut snd_seq_t,
        info: *mut snd_seq_client_info_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_seq_query_next_client(
        handle: *mut snd_seq_t,
        info: *mut snd_seq_client_info_t,
    ) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _snd_seq_client_pool {
    _unused: [u8; 0],
}
#[doc = " client pool information container"]
pub type snd_seq_client_pool_t = _snd_seq_client_pool;
extern "C" {
    pub fn snd_seq_client_pool_sizeof() -> usize;
}
extern "C" {
    pub fn snd_seq_client_pool_malloc(
        ptr: *mut *mut snd_seq_client_pool_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_seq_client_pool_free(ptr: *mut snd_seq_client_pool_t);
}
extern "C" {
    pub fn snd_seq_client_pool_copy(
        dst: *mut snd_seq_client_pool_t,
        src: *const snd_seq_client_pool_t,
    );
}
extern "C" {
    pub fn snd_seq_client_pool_get_client(
        info: *const snd_seq_client_pool_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_seq_client_pool_get_output_pool(info: *const snd_seq_client_pool_t) -> usize;
}
extern "C" {
    pub fn snd_seq_client_pool_get_input_pool(info: *const snd_seq_client_pool_t) -> usize;
}
extern "C" {
    pub fn snd_seq_client_pool_get_output_room(info: *const snd_seq_client_pool_t) -> usize;
}
extern "C" {
    pub fn snd_seq_client_pool_get_output_free(info: *const snd_seq_client_pool_t) -> usize;
}
extern "C" {
    pub fn snd_seq_client_pool_get_input_free(info: *const snd_seq_client_pool_t) -> usize;
}
extern "C" {
    pub fn snd_seq_client_pool_set_output_pool(info: *mut snd_seq_client_pool_t, size: usize);
}
extern "C" {
    pub fn snd_seq_client_pool_set_input_pool(info: *mut snd_seq_client_pool_t, size: usize);
}
extern "C" {
    pub fn snd_seq_client_pool_set_output_room(info: *mut snd_seq_client_pool_t, size: usize);
}
extern "C" {
    pub fn snd_seq_get_client_pool(
        handle: *mut snd_seq_t,
        info: *mut snd_seq_client_pool_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_seq_set_client_pool(
        handle: *mut snd_seq_t,
        info: *mut snd_seq_client_pool_t,
    ) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _snd_seq_port_info {
    _unused: [u8; 0],
}
#[doc = " port information container"]
pub type snd_seq_port_info_t = _snd_seq_port_info;
extern "C" {
    pub fn snd_seq_port_info_sizeof() -> usize;
}
extern "C" {
    pub fn snd_seq_port_info_malloc(ptr: *mut *mut snd_seq_port_info_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_seq_port_info_free(ptr: *mut snd_seq_port_info_t);
}
extern "C" {
    pub fn snd_seq_port_info_copy(dst: *mut snd_seq_port_info_t, src: *const snd_seq_port_info_t);
}
extern "C" {
    pub fn snd_seq_port_info_get_client(info: *const snd_seq_port_info_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_seq_port_info_get_port(info: *const snd_seq_port_info_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_seq_port_info_get_addr(info: *const snd_seq_port_info_t) -> *const snd_seq_addr_t;
}
extern "C" {
    pub fn snd_seq_port_info_get_name(
        info: *const snd_seq_port_info_t,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn snd_seq_port_info_get_capability(
        info: *const snd_seq_port_info_t,
    ) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn snd_seq_port_info_get_type(info: *const snd_seq_port_info_t) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn snd_seq_port_info_get_midi_channels(
        info: *const snd_seq_port_info_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_seq_port_info_get_midi_voices(
        info: *const snd_seq_port_info_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_seq_port_info_get_synth_voices(
        info: *const snd_seq_port_info_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_seq_port_info_get_read_use(
        info: *const snd_seq_port_info_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_seq_port_info_get_write_use(
        info: *const snd_seq_port_info_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_seq_port_info_get_port_specified(
        info: *const snd_seq_port_info_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_seq_port_info_get_timestamping(
        info: *const snd_seq_port_info_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_seq_port_info_get_timestamp_real(
        info: *const snd_seq_port_info_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_seq_port_info_get_timestamp_queue(
        info: *const snd_seq_port_info_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_seq_port_info_set_client(
        info: *mut snd_seq_port_info_t,
        client: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn snd_seq_port_info_set_port(info: *mut snd_seq_port_info_t, port: ::std::os::raw::c_int);
}
extern "C" {
    pub fn snd_seq_port_info_set_addr(info: *mut snd_seq_port_info_t, addr: *const snd_seq_addr_t);
}
extern "C" {
    pub fn snd_seq_port_info_set_name(
        info: *mut snd_seq_port_info_t,
        name: *const ::std::os::raw::c_char,
    );
}
extern "C" {
    pub fn snd_seq_port_info_set_capability(
        info: *mut snd_seq_port_info_t,
        capability: ::std::os::raw::c_uint,
    );
}
extern "C" {
    pub fn snd_seq_port_info_set_type(
        info: *mut snd_seq_port_info_t,
        type_: ::std::os::raw::c_uint,
    );
}
extern "C" {
    pub fn snd_seq_port_info_set_midi_channels(
        info: *mut snd_seq_port_info_t,
        channels: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn snd_seq_port_info_set_midi_voices(
        info: *mut snd_seq_port_info_t,
        voices: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn snd_seq_port_info_set_synth_voices(
        info: *mut snd_seq_port_info_t,
        voices: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn snd_seq_port_info_set_port_specified(
        info: *mut snd_seq_port_info_t,
        val: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn snd_seq_port_info_set_timestamping(
        info: *mut snd_seq_port_info_t,
        enable: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn snd_seq_port_info_set_timestamp_real(
        info: *mut snd_seq_port_info_t,
        realtime: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn snd_seq_port_info_set_timestamp_queue(
        info: *mut snd_seq_port_info_t,
        queue: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn snd_seq_create_port(
        handle: *mut snd_seq_t,
        info: *mut snd_seq_port_info_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_seq_delete_port(
        handle: *mut snd_seq_t,
        port: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_seq_get_port_info(
        handle: *mut snd_seq_t,
        port: ::std::os::raw::c_int,
        info: *mut snd_seq_port_info_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_seq_get_any_port_info(
        handle: *mut snd_seq_t,
        client: ::std::os::raw::c_int,
        port: ::std::os::raw::c_int,
        info: *mut snd_seq_port_info_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_seq_set_port_info(
        handle: *mut snd_seq_t,
        port: ::std::os::raw::c_int,
        info: *mut snd_seq_port_info_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_seq_query_next_port(
        handle: *mut snd_seq_t,
        info: *mut snd_seq_port_info_t,
    ) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _snd_seq_port_subscribe {
    _unused: [u8; 0],
}
#[doc = " port subscription container"]
pub type snd_seq_port_subscribe_t = _snd_seq_port_subscribe;
extern "C" {
    pub fn snd_seq_port_subscribe_sizeof() -> usize;
}
extern "C" {
    pub fn snd_seq_port_subscribe_malloc(
        ptr: *mut *mut snd_seq_port_subscribe_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_seq_port_subscribe_free(ptr: *mut snd_seq_port_subscribe_t);
}
extern "C" {
    pub fn snd_seq_port_subscribe_copy(
        dst: *mut snd_seq_port_subscribe_t,
        src: *const snd_seq_port_subscribe_t,
    );
}
extern "C" {
    pub fn snd_seq_port_subscribe_get_sender(
        info: *const snd_seq_port_subscribe_t,
    ) -> *const snd_seq_addr_t;
}
extern "C" {
    pub fn snd_seq_port_subscribe_get_dest(
        info: *const snd_seq_port_subscribe_t,
    ) -> *const snd_seq_addr_t;
}
extern "C" {
    pub fn snd_seq_port_subscribe_get_queue(
        info: *const snd_seq_port_subscribe_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_seq_port_subscribe_get_exclusive(
        info: *const snd_seq_port_subscribe_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_seq_port_subscribe_get_time_update(
        info: *const snd_seq_port_subscribe_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_seq_port_subscribe_get_time_real(
        info: *const snd_seq_port_subscribe_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_seq_port_subscribe_set_sender(
        info: *mut snd_seq_port_subscribe_t,
        addr: *const snd_seq_addr_t,
    );
}
extern "C" {
    pub fn snd_seq_port_subscribe_set_dest(
        info: *mut snd_seq_port_subscribe_t,
        addr: *const snd_seq_addr_t,
    );
}
extern "C" {
    pub fn snd_seq_port_subscribe_set_queue(
        info: *mut snd_seq_port_subscribe_t,
        q: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn snd_seq_port_subscribe_set_exclusive(
        info: *mut snd_seq_port_subscribe_t,
        val: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn snd_seq_port_subscribe_set_time_update(
        info: *mut snd_seq_port_subscribe_t,
        val: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn snd_seq_port_subscribe_set_time_real(
        info: *mut snd_seq_port_subscribe_t,
        val: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn snd_seq_get_port_subscription(
        handle: *mut snd_seq_t,
        sub: *mut snd_seq_port_subscribe_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_seq_subscribe_port(
        handle: *mut snd_seq_t,
        sub: *mut snd_seq_port_subscribe_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_seq_unsubscribe_port(
        handle: *mut snd_seq_t,
        sub: *mut snd_seq_port_subscribe_t,
    ) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _snd_seq_query_subscribe {
    _unused: [u8; 0],
}
#[doc = " subscription query container"]
pub type snd_seq_query_subscribe_t = _snd_seq_query_subscribe;
#[doc = "< query read subscriptions"]
pub const SND_SEQ_QUERY_SUBS_READ: snd_seq_query_subs_type_t = 0;
#[doc = "< query write subscriptions"]
pub const SND_SEQ_QUERY_SUBS_WRITE: snd_seq_query_subs_type_t = 1;
#[doc = " type of query subscription"]
pub type snd_seq_query_subs_type_t = ::std::os::raw::c_uint;
extern "C" {
    pub fn snd_seq_query_subscribe_sizeof() -> usize;
}
extern "C" {
    pub fn snd_seq_query_subscribe_malloc(
        ptr: *mut *mut snd_seq_query_subscribe_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_seq_query_subscribe_free(ptr: *mut snd_seq_query_subscribe_t);
}
extern "C" {
    pub fn snd_seq_query_subscribe_copy(
        dst: *mut snd_seq_query_subscribe_t,
        src: *const snd_seq_query_subscribe_t,
    );
}
extern "C" {
    pub fn snd_seq_query_subscribe_get_client(
        info: *const snd_seq_query_subscribe_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_seq_query_subscribe_get_port(
        info: *const snd_seq_query_subscribe_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_seq_query_subscribe_get_root(
        info: *const snd_seq_query_subscribe_t,
    ) -> *const snd_seq_addr_t;
}
extern "C" {
    pub fn snd_seq_query_subscribe_get_type(
        info: *const snd_seq_query_subscribe_t,
    ) -> snd_seq_query_subs_type_t;
}
extern "C" {
    pub fn snd_seq_query_subscribe_get_index(
        info: *const snd_seq_query_subscribe_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_seq_query_subscribe_get_num_subs(
        info: *const snd_seq_query_subscribe_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_seq_query_subscribe_get_addr(
        info: *const snd_seq_query_subscribe_t,
    ) -> *const snd_seq_addr_t;
}
extern "C" {
    pub fn snd_seq_query_subscribe_get_queue(
        info: *const snd_seq_query_subscribe_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_seq_query_subscribe_get_exclusive(
        info: *const snd_seq_query_subscribe_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_seq_query_subscribe_get_time_update(
        info: *const snd_seq_query_subscribe_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_seq_query_subscribe_get_time_real(
        info: *const snd_seq_query_subscribe_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_seq_query_subscribe_set_client(
        info: *mut snd_seq_query_subscribe_t,
        client: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn snd_seq_query_subscribe_set_port(
        info: *mut snd_seq_query_subscribe_t,
        port: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn snd_seq_query_subscribe_set_root(
        info: *mut snd_seq_query_subscribe_t,
        addr: *const snd_seq_addr_t,
    );
}
extern "C" {
    pub fn snd_seq_query_subscribe_set_type(
        info: *mut snd_seq_query_subscribe_t,
        type_: snd_seq_query_subs_type_t,
    );
}
extern "C" {
    pub fn snd_seq_query_subscribe_set_index(
        info: *mut snd_seq_query_subscribe_t,
        _index: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn snd_seq_query_port_subscribers(
        seq: *mut snd_seq_t,
        subs: *mut snd_seq_query_subscribe_t,
    ) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _snd_seq_queue_info {
    _unused: [u8; 0],
}
#[doc = " queue information container"]
pub type snd_seq_queue_info_t = _snd_seq_queue_info;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _snd_seq_queue_status {
    _unused: [u8; 0],
}
#[doc = " queue status container"]
pub type snd_seq_queue_status_t = _snd_seq_queue_status;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _snd_seq_queue_tempo {
    _unused: [u8; 0],
}
#[doc = " queue tempo container"]
pub type snd_seq_queue_tempo_t = _snd_seq_queue_tempo;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _snd_seq_queue_timer {
    _unused: [u8; 0],
}
#[doc = " queue timer information container"]
pub type snd_seq_queue_timer_t = _snd_seq_queue_timer;
extern "C" {
    pub fn snd_seq_queue_info_sizeof() -> usize;
}
extern "C" {
    pub fn snd_seq_queue_info_malloc(ptr: *mut *mut snd_seq_queue_info_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_seq_queue_info_free(ptr: *mut snd_seq_queue_info_t);
}
extern "C" {
    pub fn snd_seq_queue_info_copy(
        dst: *mut snd_seq_queue_info_t,
        src: *const snd_seq_queue_info_t,
    );
}
extern "C" {
    pub fn snd_seq_queue_info_get_queue(info: *const snd_seq_queue_info_t)
        -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_seq_queue_info_get_name(
        info: *const snd_seq_queue_info_t,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn snd_seq_queue_info_get_owner(info: *const snd_seq_queue_info_t)
        -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_seq_queue_info_get_locked(
        info: *const snd_seq_queue_info_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_seq_queue_info_get_flags(
        info: *const snd_seq_queue_info_t,
    ) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn snd_seq_queue_info_set_name(
        info: *mut snd_seq_queue_info_t,
        name: *const ::std::os::raw::c_char,
    );
}
extern "C" {
    pub fn snd_seq_queue_info_set_owner(
        info: *mut snd_seq_queue_info_t,
        owner: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn snd_seq_queue_info_set_locked(
        info: *mut snd_seq_queue_info_t,
        locked: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn snd_seq_queue_info_set_flags(
        info: *mut snd_seq_queue_info_t,
        flags: ::std::os::raw::c_uint,
    );
}
extern "C" {
    pub fn snd_seq_create_queue(
        seq: *mut snd_seq_t,
        info: *mut snd_seq_queue_info_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_seq_alloc_named_queue(
        seq: *mut snd_seq_t,
        name: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_seq_alloc_queue(handle: *mut snd_seq_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_seq_free_queue(
        handle: *mut snd_seq_t,
        q: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_seq_get_queue_info(
        seq: *mut snd_seq_t,
        q: ::std::os::raw::c_int,
        info: *mut snd_seq_queue_info_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_seq_set_queue_info(
        seq: *mut snd_seq_t,
        q: ::std::os::raw::c_int,
        info: *mut snd_seq_queue_info_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_seq_query_named_queue(
        seq: *mut snd_seq_t,
        name: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_seq_get_queue_usage(
        handle: *mut snd_seq_t,
        q: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_seq_set_queue_usage(
        handle: *mut snd_seq_t,
        q: ::std::os::raw::c_int,
        used: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_seq_queue_status_sizeof() -> usize;
}
extern "C" {
    pub fn snd_seq_queue_status_malloc(
        ptr: *mut *mut snd_seq_queue_status_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_seq_queue_status_free(ptr: *mut snd_seq_queue_status_t);
}
extern "C" {
    pub fn snd_seq_queue_status_copy(
        dst: *mut snd_seq_queue_status_t,
        src: *const snd_seq_queue_status_t,
    );
}
extern "C" {
    pub fn snd_seq_queue_status_get_queue(
        info: *const snd_seq_queue_status_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_seq_queue_status_get_events(
        info: *const snd_seq_queue_status_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_seq_queue_status_get_tick_time(
        info: *const snd_seq_queue_status_t,
    ) -> snd_seq_tick_time_t;
}
extern "C" {
    pub fn snd_seq_queue_status_get_real_time(
        info: *const snd_seq_queue_status_t,
    ) -> *const snd_seq_real_time_t;
}
extern "C" {
    pub fn snd_seq_queue_status_get_status(
        info: *const snd_seq_queue_status_t,
    ) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn snd_seq_get_queue_status(
        handle: *mut snd_seq_t,
        q: ::std::os::raw::c_int,
        status: *mut snd_seq_queue_status_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_seq_queue_tempo_sizeof() -> usize;
}
extern "C" {
    pub fn snd_seq_queue_tempo_malloc(
        ptr: *mut *mut snd_seq_queue_tempo_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_seq_queue_tempo_free(ptr: *mut snd_seq_queue_tempo_t);
}
extern "C" {
    pub fn snd_seq_queue_tempo_copy(
        dst: *mut snd_seq_queue_tempo_t,
        src: *const snd_seq_queue_tempo_t,
    );
}
extern "C" {
    pub fn snd_seq_queue_tempo_get_queue(
        info: *const snd_seq_queue_tempo_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_seq_queue_tempo_get_tempo(
        info: *const snd_seq_queue_tempo_t,
    ) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn snd_seq_queue_tempo_get_ppq(info: *const snd_seq_queue_tempo_t)
        -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_seq_queue_tempo_get_skew(
        info: *const snd_seq_queue_tempo_t,
    ) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn snd_seq_queue_tempo_get_skew_base(
        info: *const snd_seq_queue_tempo_t,
    ) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn snd_seq_queue_tempo_set_tempo(
        info: *mut snd_seq_queue_tempo_t,
        tempo: ::std::os::raw::c_uint,
    );
}
extern "C" {
    pub fn snd_seq_queue_tempo_set_ppq(
        info: *mut snd_seq_queue_tempo_t,
        ppq: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn snd_seq_queue_tempo_set_skew(
        info: *mut snd_seq_queue_tempo_t,
        skew: ::std::os::raw::c_uint,
    );
}
extern "C" {
    pub fn snd_seq_queue_tempo_set_skew_base(
        info: *mut snd_seq_queue_tempo_t,
        base: ::std::os::raw::c_uint,
    );
}
extern "C" {
    pub fn snd_seq_get_queue_tempo(
        handle: *mut snd_seq_t,
        q: ::std::os::raw::c_int,
        tempo: *mut snd_seq_queue_tempo_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_seq_set_queue_tempo(
        handle: *mut snd_seq_t,
        q: ::std::os::raw::c_int,
        tempo: *mut snd_seq_queue_tempo_t,
    ) -> ::std::os::raw::c_int;
}
pub const SND_SEQ_TIMER_ALSA: snd_seq_queue_timer_type_t = 0;
pub const SND_SEQ_TIMER_MIDI_CLOCK: snd_seq_queue_timer_type_t = 1;
pub const SND_SEQ_TIMER_MIDI_TICK: snd_seq_queue_timer_type_t = 2;
#[doc = " sequencer timer sources"]
pub type snd_seq_queue_timer_type_t = ::std::os::raw::c_uint;
extern "C" {
    pub fn snd_seq_queue_timer_sizeof() -> usize;
}
extern "C" {
    pub fn snd_seq_queue_timer_malloc(
        ptr: *mut *mut snd_seq_queue_timer_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_seq_queue_timer_free(ptr: *mut snd_seq_queue_timer_t);
}
extern "C" {
    pub fn snd_seq_queue_timer_copy(
        dst: *mut snd_seq_queue_timer_t,
        src: *const snd_seq_queue_timer_t,
    );
}
extern "C" {
    pub fn snd_seq_queue_timer_get_queue(
        info: *const snd_seq_queue_timer_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_seq_queue_timer_get_type(
        info: *const snd_seq_queue_timer_t,
    ) -> snd_seq_queue_timer_type_t;
}
extern "C" {
    pub fn snd_seq_queue_timer_get_id(info: *const snd_seq_queue_timer_t) -> *const snd_timer_id_t;
}
extern "C" {
    pub fn snd_seq_queue_timer_get_resolution(
        info: *const snd_seq_queue_timer_t,
    ) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn snd_seq_queue_timer_set_type(
        info: *mut snd_seq_queue_timer_t,
        type_: snd_seq_queue_timer_type_t,
    );
}
extern "C" {
    pub fn snd_seq_queue_timer_set_id(info: *mut snd_seq_queue_timer_t, id: *const snd_timer_id_t);
}
extern "C" {
    pub fn snd_seq_queue_timer_set_resolution(
        info: *mut snd_seq_queue_timer_t,
        resolution: ::std::os::raw::c_uint,
    );
}
extern "C" {
    pub fn snd_seq_get_queue_timer(
        handle: *mut snd_seq_t,
        q: ::std::os::raw::c_int,
        timer: *mut snd_seq_queue_timer_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_seq_set_queue_timer(
        handle: *mut snd_seq_t,
        q: ::std::os::raw::c_int,
        timer: *mut snd_seq_queue_timer_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = "  \\defgroup SeqEvent Sequencer Event API"]
    #[doc = "  Sequencer Event API"]
    #[doc = "  \\ingroup Sequencer"]
    #[doc = "  \\{"]
    pub fn snd_seq_free_event(ev: *mut snd_seq_event_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_seq_event_length(ev: *mut snd_seq_event_t) -> isize;
}
extern "C" {
    pub fn snd_seq_event_output(
        handle: *mut snd_seq_t,
        ev: *mut snd_seq_event_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_seq_event_output_buffer(
        handle: *mut snd_seq_t,
        ev: *mut snd_seq_event_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_seq_event_output_direct(
        handle: *mut snd_seq_t,
        ev: *mut snd_seq_event_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_seq_event_input(
        handle: *mut snd_seq_t,
        ev: *mut *mut snd_seq_event_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_seq_event_input_pending(
        seq: *mut snd_seq_t,
        fetch_sequencer: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_seq_drain_output(handle: *mut snd_seq_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_seq_event_output_pending(seq: *mut snd_seq_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_seq_extract_output(
        handle: *mut snd_seq_t,
        ev: *mut *mut snd_seq_event_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_seq_drop_output(handle: *mut snd_seq_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_seq_drop_output_buffer(handle: *mut snd_seq_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_seq_drop_input(handle: *mut snd_seq_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_seq_drop_input_buffer(handle: *mut snd_seq_t) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _snd_seq_remove_events {
    _unused: [u8; 0],
}
#[doc = " event removal conditionals"]
pub type snd_seq_remove_events_t = _snd_seq_remove_events;
extern "C" {
    pub fn snd_seq_remove_events_sizeof() -> usize;
}
extern "C" {
    pub fn snd_seq_remove_events_malloc(
        ptr: *mut *mut snd_seq_remove_events_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_seq_remove_events_free(ptr: *mut snd_seq_remove_events_t);
}
extern "C" {
    pub fn snd_seq_remove_events_copy(
        dst: *mut snd_seq_remove_events_t,
        src: *const snd_seq_remove_events_t,
    );
}
extern "C" {
    pub fn snd_seq_remove_events_get_condition(
        info: *const snd_seq_remove_events_t,
    ) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn snd_seq_remove_events_get_queue(
        info: *const snd_seq_remove_events_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_seq_remove_events_get_time(
        info: *const snd_seq_remove_events_t,
    ) -> *const snd_seq_timestamp_t;
}
extern "C" {
    pub fn snd_seq_remove_events_get_dest(
        info: *const snd_seq_remove_events_t,
    ) -> *const snd_seq_addr_t;
}
extern "C" {
    pub fn snd_seq_remove_events_get_channel(
        info: *const snd_seq_remove_events_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_seq_remove_events_get_event_type(
        info: *const snd_seq_remove_events_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_seq_remove_events_get_tag(
        info: *const snd_seq_remove_events_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_seq_remove_events_set_condition(
        info: *mut snd_seq_remove_events_t,
        flags: ::std::os::raw::c_uint,
    );
}
extern "C" {
    pub fn snd_seq_remove_events_set_queue(
        info: *mut snd_seq_remove_events_t,
        queue: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn snd_seq_remove_events_set_time(
        info: *mut snd_seq_remove_events_t,
        time: *const snd_seq_timestamp_t,
    );
}
extern "C" {
    pub fn snd_seq_remove_events_set_dest(
        info: *mut snd_seq_remove_events_t,
        addr: *const snd_seq_addr_t,
    );
}
extern "C" {
    pub fn snd_seq_remove_events_set_channel(
        info: *mut snd_seq_remove_events_t,
        channel: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn snd_seq_remove_events_set_event_type(
        info: *mut snd_seq_remove_events_t,
        type_: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn snd_seq_remove_events_set_tag(
        info: *mut snd_seq_remove_events_t,
        tag: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn snd_seq_remove_events(
        handle: *mut snd_seq_t,
        info: *mut snd_seq_remove_events_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = "  \\defgroup SeqMisc Sequencer Miscellaneous"]
    #[doc = "  Sequencer Miscellaneous"]
    #[doc = "  \\ingroup Sequencer"]
    #[doc = "  \\{"]
    pub fn snd_seq_set_bit(nr: ::std::os::raw::c_int, array: *mut ::std::os::raw::c_void);
}
extern "C" {
    pub fn snd_seq_unset_bit(nr: ::std::os::raw::c_int, array: *mut ::std::os::raw::c_void);
}
extern "C" {
    pub fn snd_seq_change_bit(
        nr: ::std::os::raw::c_int,
        array: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_seq_get_bit(
        nr: ::std::os::raw::c_int,
        array: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_seq_control_queue(
        seq: *mut snd_seq_t,
        q: ::std::os::raw::c_int,
        type_: ::std::os::raw::c_int,
        value: ::std::os::raw::c_int,
        ev: *mut snd_seq_event_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_seq_create_simple_port(
        seq: *mut snd_seq_t,
        name: *const ::std::os::raw::c_char,
        caps: ::std::os::raw::c_uint,
        type_: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_seq_delete_simple_port(
        seq: *mut snd_seq_t,
        port: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_seq_connect_from(
        seq: *mut snd_seq_t,
        my_port: ::std::os::raw::c_int,
        src_client: ::std::os::raw::c_int,
        src_port: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_seq_connect_to(
        seq: *mut snd_seq_t,
        my_port: ::std::os::raw::c_int,
        dest_client: ::std::os::raw::c_int,
        dest_port: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_seq_disconnect_from(
        seq: *mut snd_seq_t,
        my_port: ::std::os::raw::c_int,
        src_client: ::std::os::raw::c_int,
        src_port: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_seq_disconnect_to(
        seq: *mut snd_seq_t,
        my_port: ::std::os::raw::c_int,
        dest_client: ::std::os::raw::c_int,
        dest_port: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_seq_set_client_name(
        seq: *mut snd_seq_t,
        name: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_seq_set_client_event_filter(
        seq: *mut snd_seq_t,
        event_type: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_seq_set_client_pool_output(
        seq: *mut snd_seq_t,
        size: usize,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_seq_set_client_pool_output_room(
        seq: *mut snd_seq_t,
        size: usize,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_seq_set_client_pool_input(seq: *mut snd_seq_t, size: usize)
        -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_seq_sync_output_queue(seq: *mut snd_seq_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_seq_parse_address(
        seq: *mut snd_seq_t,
        addr: *mut snd_seq_addr_t,
        str_: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_seq_reset_pool_output(seq: *mut snd_seq_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_seq_reset_pool_input(seq: *mut snd_seq_t) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct snd_midi_event {
    _unused: [u8; 0],
}
#[doc = " container for sequencer midi event parsers"]
pub type snd_midi_event_t = snd_midi_event;
extern "C" {
    pub fn snd_midi_event_new(
        bufsize: usize,
        rdev: *mut *mut snd_midi_event_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_midi_event_resize_buffer(
        dev: *mut snd_midi_event_t,
        bufsize: usize,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_midi_event_free(dev: *mut snd_midi_event_t);
}
extern "C" {
    pub fn snd_midi_event_init(dev: *mut snd_midi_event_t);
}
extern "C" {
    pub fn snd_midi_event_reset_encode(dev: *mut snd_midi_event_t);
}
extern "C" {
    pub fn snd_midi_event_reset_decode(dev: *mut snd_midi_event_t);
}
extern "C" {
    pub fn snd_midi_event_no_status(dev: *mut snd_midi_event_t, on: ::std::os::raw::c_int);
}
extern "C" {
    pub fn snd_midi_event_encode(
        dev: *mut snd_midi_event_t,
        buf: *const ::std::os::raw::c_uchar,
        count: ::std::os::raw::c_long,
        ev: *mut snd_seq_event_t,
    ) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn snd_midi_event_encode_byte(
        dev: *mut snd_midi_event_t,
        c: ::std::os::raw::c_int,
        ev: *mut snd_seq_event_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snd_midi_event_decode(
        dev: *mut snd_midi_event_t,
        buf: *mut ::std::os::raw::c_uchar,
        count: ::std::os::raw::c_long,
        ev: *const snd_seq_event_t,
    ) -> ::std::os::raw::c_long;
}
pub type __builtin_va_list = [__va_list_tag; 1usize];
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __va_list_tag {
    pub gp_offset: ::std::os::raw::c_uint,
    pub fp_offset: ::std::os::raw::c_uint,
    pub overflow_arg_area: *mut ::std::os::raw::c_void,
    pub reg_save_area: *mut ::std::os::raw::c_void,
}
