use ansi_term::Style;
use text_io::read;

use egg_mode::error::{Error::TwitterError, TwitterErrors};
use egg_mode::tweet::{like, mentions_timeline, DraftTweet, Tweet};
use egg_mode::{KeyPair, Token};

use std::future::Future;
use std::io::{stdout, Write};
use std::process::exit;

type TwitterAction = Result<(), TwitterErrors>;

fn authenticate() -> Token {
    let consumer_pair = KeyPair::new(
        "vXMOPsR8G6uVMost8MoWHJ8vY",
        "aKDztJ89tP4ZStPyW3cPzYccJvzg1wOBsxTT4t7NrzuHAuPYQt",
    );
    let access_token_pair = KeyPair::new(
        "1252277511746183168-JoeErjnsvTS4tSQBephfWJOzrxqvRb",
        "OAJeUKQ4ZKi1NC8dGVndLEGkjIQxZNVajdR5GQp3HJ4uk",
    );

    Token::Access {
        consumer: consumer_pair,
        access: access_token_pair,
    }
}

async fn get_mentions(token: &Token) -> Vec<Tweet> {
    println!("{}\n", Style::new().italic().paint("Getting mentions..."));
    mentions_timeline(&token).start().await.unwrap().1.to_vec()
}

async fn send_like(tweet: &Tweet, token: &Token) -> Result<(), TwitterErrors> {
    match like(tweet.id, &token).await {
        Ok(_) => Ok(()),
        Err(TwitterError(_, e)) => Err(e),
        Err(_) => panic!(),
    }
}

async fn send_reply(tweet: &Tweet, reply_text: String, token: &Token) {
    // TODO should mention everyone in the thread, not just who was directly replied to
    let reply_text = format!(
        "@{} {}",
        tweet.user.as_ref().unwrap().screen_name,
        reply_text
    );
    DraftTweet::new(reply_text)
        .in_reply_to(tweet.id)
        .send(&token)
        .await
        .unwrap();
}

async fn prompt<'a>(
    tweet: &'a Tweet,
    token: &'a Token,
) -> Option<impl Future<Output = TwitterAction> + 'a> {
    let mut like_future = None;

    let screen_name = &tweet.user.as_ref().unwrap().screen_name;
    let screen_name_msg = Style::new().bold().paint(format!("@{} says:", screen_name));
    let in_response_msg = match &tweet.in_reply_to_screen_name {
        None => Style::new().paint(""),
        Some(name) => {
            let reply_to_msg = format!("in response to @{}\n", name);
            Style::new().italic().paint(reply_to_msg)
        }
    };
    println!("{}\n{}{}\n", screen_name_msg, in_response_msg, tweet.text);

    print!("> ");
    stdout().flush().unwrap();
    let actions: String = read!("{}\n");
    println!();

    for action in actions.chars() {
        if action == 'l' {
            like_future = Some(send_like(&tweet, &token));
        } else if action == 'r' {
            let reply_prompt = Style::new().italic().paint("Your reply: ");
            print!("{}", reply_prompt);
            stdout().flush().unwrap();

            let reply_text: String = read!();
            send_reply(&tweet, reply_text, &token).await;
            println!();
        } else if action == 'x' {
            exit(0);
        }
    }

    like_future
}

fn show_err(errs: TwitterErrors) {
    for err in errs.errors {
        println!("{}", Style::new().italic().paint(err.message))
    }
    println!()
}

async fn run_action(action: Option<impl Future<Output = TwitterAction>>) {
    let result = match action {
        None => None,
        Some(f) => Some(f.await),
    };

    if result.is_some() {
        let result = result.unwrap();
        match result {
            Ok(()) => (),
            Err(e) => show_err(e),
        };
    };
}

#[tokio::main]
async fn main() {
    let token = authenticate();
    let tweets = get_mentions(&token).await;
    for tweet in tweets {
        let like_future = prompt(&tweet, &token).await;
        run_action(like_future).await;
    }
}
