
pub trait UrlEncoding {
    fn url_encode(&self) -> String;
}

pub trait QueryString {
    fn to_qs(&self, k: &str) -> String;
}
impl UrlEncoding for i8 { 
    fn url_encode(&self) -> String {
        self.to_string()
    }
}

impl QueryString for i8 {
    fn to_qs(&self, k: &str) -> String {
        format!("{}={}", k, self)
    }
}
impl UrlEncoding for i16 { 
    fn url_encode(&self) -> String {
        self.to_string()
    }
}

impl QueryString for i16 {
    fn to_qs(&self, k: &str) -> String {
        format!("{}={}", k, self)
    }
}

impl UrlEncoding for i32 { 
    fn url_encode(&self) -> String {
        self.to_string()
    }
}

impl QueryString for i32 {
    fn to_qs(&self, k: &str) -> String {
        format!("{}={}", k, self)
    }
}
impl UrlEncoding for i64 { 
    fn url_encode(&self) -> String {
        self.to_string()
    }
}

impl QueryString for i64 {
    fn to_qs(&self, k: &str) -> String {
        format!("{}={}", k, self)
    }
}
impl UrlEncoding for u8 { 
    fn url_encode(&self) -> String {
        self.to_string()
    }
}

impl QueryString for u8 {
    fn to_qs(&self, k: &str) -> String {
        format!("{}={}", k, self)
    }
}
impl UrlEncoding for u16 { 
    fn url_encode(&self) -> String {
        self.to_string()
    }
}

impl QueryString for u16 {
    fn to_qs(&self, k: &str) -> String {
        format!("{}={}", k, self)
    }
}

impl UrlEncoding for u32 { 
    fn url_encode(&self) -> String {
        self.to_string()
    }
}

impl QueryString for u32 {
    fn to_qs(&self, k: &str) -> String {
        format!("{}={}", k, self)
    }
}
impl UrlEncoding for u64 { 
    fn url_encode(&self) -> String {
        self.to_string()
    }
}

impl QueryString for u64 {
    fn to_qs(&self, k: &str) -> String {
        format!("{}={}", k, self)
    }
}
impl UrlEncoding for u128 { 
    fn url_encode(&self) -> String {
        self.to_string()
    }
}

impl QueryString for u128 {
    fn to_qs(&self, k: &str) -> String {
        format!("{}={}", k, self)
    }
}
impl UrlEncoding for f32 { 
    fn url_encode(&self) -> String {
        self.to_string()
    }
}

impl QueryString for f32 {
    fn to_qs(&self, k: &str) -> String {
        format!("{}={}", k, self)
    }
}
impl UrlEncoding for f64 { 
    fn url_encode(&self) -> String {
        self.to_string()
    }
}

impl QueryString for f64 {
    fn to_qs(&self, k: &str) -> String {
        format!("{}={}", k, self)
    }
}
impl UrlEncoding for isize { 
    fn url_encode(&self) -> String {
        self.to_string()
    }
}

impl QueryString for isize {
    fn to_qs(&self, k: &str) -> String {
        format!("{}={}", k, self)
    }
}
impl UrlEncoding for bool { 
    fn url_encode(&self) -> String {
        self.to_string()
    }
}

impl QueryString for bool {
    fn to_qs(&self, k: &str) -> String {
        format!("{}={}", k, self)
    }
}
impl UrlEncoding for usize { 
    fn url_encode(&self) -> String {
        self.to_string()
    }
}

impl QueryString for usize {
    fn to_qs(&self, k: &str) -> String {
        format!("{}={}", k, self)
    }
}
impl UrlEncoding for &str { 
    fn url_encode(&self) -> String {
        urlencoding::encode(self).to_string()
    }
}

impl QueryString for &str {
    fn to_qs(&self, k: &str) -> String {
        format!("{}={}", k, self.url_encode())
    }
}

impl UrlEncoding for String { 
    fn url_encode(&self) -> String {
        urlencoding::encode(self.as_str()).to_string()
    }
}

impl QueryString for String {
    fn to_qs(&self, k: &str) -> String {
        format!("{}={}", k, self.url_encode())
    }
}

impl<T: UrlEncoding> QueryString for Vec<T> {
    fn to_qs(&self, k: &str) -> String {
        self.into_iter().map(|it| format!("{}[]={}", k, it.url_encode())).collect::<Vec<String>>().join("&")
    }
}

impl<T: QueryString> QueryString for Option<T> {
    fn to_qs(&self, k: &str) -> String {
        match self {
            Some(ref v) => v.to_qs(k),
            None => format!("{}=", k),
        }
    }
}