// pub mod lib;

use clipboard::ClipboardContext;
use clipboard::ClipboardProvider;
use png::Encoder;
use qrcodegen::QrCode;
use qrcodegen::QrCodeEcc;

use std::fs::File;
use std::io::BufWriter;
use std::path::Path;

pub fn get_clipboard() -> String {
    let mut ctx: ClipboardContext = ClipboardProvider::new().unwrap();
    ctx.get_contents().unwrap()
}

pub fn make_qr_code(input: String) -> QrCode {
    match QrCode::encode_binary(input.as_bytes(), QrCodeEcc::Medium) {
        Ok(img) => img,
        Err(e) => panic!("{}", e),
    }
}

pub fn qr_code_to_png(input: QrCode) -> &'static Path {
    let path = Path::new(r"/tmp/qrcode.png");
    let file = File::create(path).unwrap();
    let ref mut w = BufWriter::new(file);
    let size: i32 = input.size().try_into().unwrap();
    let mut encoder = Encoder::new(w, size.try_into().unwrap(), size.try_into().unwrap());

    encoder.set_color(png::ColorType::Grayscale);
    let mut writer = encoder.write_header().unwrap();
    let mut data: Vec<u8> = Vec::new();
    for x in 0..size {
        for y in 0..size {
            data.push(match input.get_module(x, y) {
                true => 0,
                false => 255,
            });
        }
    }
    writer
        .write_image_data(&data)
        .expect("Could not write to writer");
    writer.finish().expect("Could not finish writing!");
    path
}

pub fn run() {
    qr_code_to_png(make_qr_code(get_clipboard()));
}
