/*
 * Rigetti QCS API
 *
 * # Introduction  This is the documentation for the Rigetti QCS HTTP API.  You can find out more about Rigetti at [https://rigetti.com](https://rigetti.com), and also interact with QCS via the web at [https://qcs.rigetti.com](https://qcs.rigetti.com).  This API is documented in **OpenAPI format** and so is compatible with the dozens of language-specific client generators available [here](https://github.com/OpenAPITools/openapi-generator) and elsewhere on the web.  # Principles  This API follows REST design principles where appropriate, and otherwise an HTTP RPC paradigm. We adhere to the Google [API Improvement Proposals](https://google.aip.dev/general) where reasonable to provide a consistent, intuitive developer experience. HTTP response codes match their specifications, and error messages fit a common format.  # Authentication  All access to the QCS API requires OAuth2 authentication provided by Okta. You can request access [here](https://www.rigetti.com/get-quantum). Once you have a user account, you can download your access token from QCS [here](https://qcs.rigetti.com/auth/token).   That access token is valid for 24 hours after issuance. The value of `access_token` within the JSON file is the token used for authentication (don't use the entire JSON file).  Authenticate requests using the `Authorization` header and a `Bearer` prefix:  ``` curl --header \"Authorization: Bearer eyJraW...Iow\" ```  # Quantum Processor Access  Access to the quantum processors themselves is not yet provided directly by this HTTP API, but is instead performed over ZeroMQ/[rpcq](https://gitlab.com/rigetti/rpcq). Until that changes, we suggest using [pyquil](https://gitlab.com/rigetti/pyquil) to build and execute quantum programs via the Legacy API.  # Legacy API  Our legacy HTTP API remains accessible at https://forest-server.qcs.rigetti.com, and it shares a source of truth with this API's services. You can use either service with the same user account and means of authentication. We strongly recommend using the API documented here, as the legacy API is on the path to deprecation.
 *
 * The version of the OpenAPI document: 2020-07-31
 * Contact: support@rigetti.com
 * Generated by: https://openapi-generator.tech
 */

/// InstructionSetArchitecture : The native instruction set architecture of a quantum processor, annotated with characteristics.  The operations described by the `instructions` field are named by their QUIL instruction name, while the operation described by the `benchmarks` field are named by their benchmark routine and are a future extension point that will be populated in future iterations.  The characteristics that annotate both instructions and benchmarks assist the user to generate the best native QUIL program for a desired task, and so are provided as part of the native ISA.

#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct InstructionSetArchitecture {
    /// The architecture of the quantum processor.
    #[serde(rename = "architecture")]
    pub architecture: Box<crate::models::Architecture>,
    /// The list of benchmarks that have characterized the quantum processor.
    #[serde(rename = "benchmarks")]
    pub benchmarks: Vec<crate::models::Operation>,
    /// The list of native QUIL instructions supported by the quantum processor.
    #[serde(rename = "instructions")]
    pub instructions: Vec<crate::models::Operation>,
    /// The name of the quantum processor.
    #[serde(rename = "name")]
    pub name: String,
}

impl InstructionSetArchitecture {
    /// The native instruction set architecture of a quantum processor, annotated with characteristics.  The operations described by the `instructions` field are named by their QUIL instruction name, while the operation described by the `benchmarks` field are named by their benchmark routine and are a future extension point that will be populated in future iterations.  The characteristics that annotate both instructions and benchmarks assist the user to generate the best native QUIL program for a desired task, and so are provided as part of the native ISA.
    pub fn new(
        architecture: crate::models::Architecture,
        benchmarks: Vec<crate::models::Operation>,
        instructions: Vec<crate::models::Operation>,
        name: String,
    ) -> InstructionSetArchitecture {
        InstructionSetArchitecture {
            architecture: Box::new(architecture),
            benchmarks,
            instructions,
            name,
        }
    }
}
