# Rust API client for openapi

# Introduction

This is the documentation for the Rigetti QCS HTTP API.

You can find out more about Rigetti at [https://rigetti.com](https://rigetti.com), and also
interact with QCS via the web at [https://qcs.rigetti.com](https://qcs.rigetti.com).

This API is documented in **OpenAPI format** and so is compatible with the dozens of
language-specific client generators available
[here](https://github.com/OpenAPITools/openapi-generator) and elsewhere on the web.

# Principles

This API follows REST design principles where appropriate, and otherwise an HTTP RPC paradigm.
We adhere to the Google [API Improvement Proposals](https://google.aip.dev/general) where
reasonable to provide a consistent, intuitive developer experience. HTTP response codes match
their specifications, and error messages fit a common format.

# Authentication

All access to the QCS API requires OAuth2 authentication provided by Okta. You can request
access [here](https://www.rigetti.com/get-quantum). Once you have a user account, you can download
your access token from QCS [here](https://qcs.rigetti.com/auth/token). 

That access token is valid for 24 hours after issuance. The value of `access_token` within the
JSON file is the token used for authentication (don't use the entire JSON file).

Authenticate requests using the `Authorization` header and a `Bearer` prefix:

```
curl --header \"Authorization: Bearer eyJraW...Iow\"
```

# Quantum Processor Access

Access to the quantum processors themselves is not yet provided directly by this HTTP API, but
is instead performed over ZeroMQ/[rpcq](https://gitlab.com/rigetti/rpcq). Until that changes,
we suggest using [pyquil](https://gitlab.com/rigetti/pyquil) to build and execute quantum
programs via the Legacy API.

# Legacy API

Our legacy HTTP API remains accessible at https://forest-server.qcs.rigetti.com, and it shares
a source of truth with this API's services. You can use either service with the same user
account and means of authentication. We strongly recommend using the API documented here, as the
legacy API is on the path to deprecation.


## Overview

This API client was generated by the [OpenAPI Generator](https://openapi-generator.tech) project.  By using the [openapi-spec](https://openapis.org) from a remote server, you can easily generate an API client.

- API version: 2020-07-31
- Package version: 1.0.0
- Build package: org.openapitools.codegen.languages.RustClientCodegen
For more information, please visit [https://rigetti.zendesk.com](https://rigetti.zendesk.com)

## Installation

Put the package under your project folder and add the following to `Cargo.toml` under `[dependencies]`:

```
    openapi = { path = "./generated" }
```

## Documentation for API Endpoints

All URIs are relative to *https://api.qcs.rigetti.com*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AccountApi* | [**add_group_user**](docs/AccountApi.md#add_group_user) | **POST** /v1/groups:addUser | Add user to a group
*AccountApi* | [**list_group_users**](docs/AccountApi.md#list_group_users) | **GET** /v1/groups/{groupName}/users | List users belonging to a group
*AccountApi* | [**list_user_groups**](docs/AccountApi.md#list_user_groups) | **GET** /v1/users/{userId}/groups | List QCS groups for the requested user
*AccountApi* | [**remove_group_user**](docs/AccountApi.md#remove_group_user) | **POST** /v1/groups:removeUser | Remove user from a group.
*AuthenticationApi* | [**auth_email_password_reset_token**](docs/AuthenticationApi.md#auth_email_password_reset_token) | **POST** /v1/auth:emailPasswordResetToken | Email Password Reset Token
*AuthenticationApi* | [**auth_get_user**](docs/AuthenticationApi.md#auth_get_user) | **GET** /v1/auth:getUser | Get User
*AuthenticationApi* | [**auth_reset_password**](docs/AuthenticationApi.md#auth_reset_password) | **POST** /v1/auth:resetPassword | Reset Password
*AuthenticationApi* | [**auth_reset_password_with_token**](docs/AuthenticationApi.md#auth_reset_password_with_token) | **POST** /v1/auth:resetPasswordWithToken | Reset Password With Token
*ClientApplicationsApi* | [**check_client_application**](docs/ClientApplicationsApi.md#check_client_application) | **POST** /v1/clientApplications:check | Check Client Application
*ClientApplicationsApi* | [**get_client_application**](docs/ClientApplicationsApi.md#get_client_application) | **GET** /v1/clientApplications/{clientApplicationName} | Get Client Application
*ClientApplicationsApi* | [**list_client_applications**](docs/ClientApplicationsApi.md#list_client_applications) | **GET** /v1/clientApplications | List Client Applications
*DefaultApi* | [**get_health**](docs/DefaultApi.md#get_health) | **GET** / | 
*DefaultApi* | [**health_check**](docs/DefaultApi.md#health_check) | **GET** /v1/ | Health Check
*EndpointsApi* | [**create_endpoint**](docs/EndpointsApi.md#create_endpoint) | **POST** /v1/endpoints | Create Endpoint
*EndpointsApi* | [**delete_endpoint**](docs/EndpointsApi.md#delete_endpoint) | **DELETE** /v1/endpoints/{endpointId} | Delete Endpoint
*EndpointsApi* | [**get_default_endpoint**](docs/EndpointsApi.md#get_default_endpoint) | **GET** /v1/quantumProcessors/{quantumProcessorId}/endpoints:getDefault | Get Default Endpoint
*EndpointsApi* | [**get_endpoint**](docs/EndpointsApi.md#get_endpoint) | **GET** /v1/endpoints/{endpointId} | Get Endpoint
*EndpointsApi* | [**list_endpoints**](docs/EndpointsApi.md#list_endpoints) | **GET** /v1/endpoints | List Endpoints
*EngagementsApi* | [**create_engagement**](docs/EngagementsApi.md#create_engagement) | **POST** /v1/engagements | Create Engagement
*QuantumProcessorsApi* | [**get_instruction_set_architecture**](docs/QuantumProcessorsApi.md#get_instruction_set_architecture) | **GET** /v1/quantumProcessors/{quantumProcessorId}/instructionSetArchitecture | Get Instruction Set Architecture
*QuantumProcessorsApi* | [**get_quantum_processor**](docs/QuantumProcessorsApi.md#get_quantum_processor) | **GET** /v1/quantumProcessors/{quantumProcessorId} | Get Quantum Processor
*QuantumProcessorsApi* | [**list_quantum_processors**](docs/QuantumProcessorsApi.md#list_quantum_processors) | **GET** /v1/quantumProcessors | List Quantum Processors
*ReservationsApi* | [**create_reservation**](docs/ReservationsApi.md#create_reservation) | **POST** /v1/reservations | Create Reservation
*ReservationsApi* | [**delete_reservation**](docs/ReservationsApi.md#delete_reservation) | **DELETE** /v1/reservations/{reservationId} | Delete Reservation
*ReservationsApi* | [**find_available_reservations**](docs/ReservationsApi.md#find_available_reservations) | **GET** /v1/reservations:findAvailable | Find Available Reservations
*ReservationsApi* | [**list_group_reservations**](docs/ReservationsApi.md#list_group_reservations) | **GET** /v1/groups/{groupName}/reservations | List Reservations
*ReservationsApi* | [**list_reservations**](docs/ReservationsApi.md#list_reservations) | **GET** /v1/reservations | List Reservations
*TranslationApi* | [**get_quilt_calibrations**](docs/TranslationApi.md#get_quilt_calibrations) | **GET** /v1/quantumProcessors/{quantumProcessorId}/quiltCalibrations | Get Quilt Calibrations
*TranslationApi* | [**translate_native_quil_to_encrypted_binary**](docs/TranslationApi.md#translate_native_quil_to_encrypted_binary) | **POST** /v1/quantumProcessors/{quantumProcessorId}:translateNativeQuilToEncryptedBinary | Translate Native Quil To Encrypted Binary


## Documentation For Models

 - [AccountType](docs/AccountType.md)
 - [AddGroupUserRequest](docs/AddGroupUserRequest.md)
 - [Architecture](docs/Architecture.md)
 - [AuthEmailPasswordResetTokenRequest](docs/AuthEmailPasswordResetTokenRequest.md)
 - [AuthResetPasswordRequest](docs/AuthResetPasswordRequest.md)
 - [AuthResetPasswordWithTokenRequest](docs/AuthResetPasswordWithTokenRequest.md)
 - [AvailableReservation](docs/AvailableReservation.md)
 - [Characteristic](docs/Characteristic.md)
 - [CheckClientApplicationRequest](docs/CheckClientApplicationRequest.md)
 - [CheckClientApplicationResponse](docs/CheckClientApplicationResponse.md)
 - [ChecksumDescription](docs/ChecksumDescription.md)
 - [ClientApplication](docs/ClientApplication.md)
 - [ClientApplicationsDownloadLink](docs/ClientApplicationsDownloadLink.md)
 - [CreateEndpointParameters](docs/CreateEndpointParameters.md)
 - [CreateEngagementRequest](docs/CreateEngagementRequest.md)
 - [CreateReservationRequest](docs/CreateReservationRequest.md)
 - [Edge](docs/Edge.md)
 - [Endpoint](docs/Endpoint.md)
 - [EngagementCredentials](docs/EngagementCredentials.md)
 - [EngagementWithCredentials](docs/EngagementWithCredentials.md)
 - [Error](docs/Error.md)
 - [Family](docs/Family.md)
 - [FindAvailableReservationsResponse](docs/FindAvailableReservationsResponse.md)
 - [GetQuiltCalibrationsResponse](docs/GetQuiltCalibrationsResponse.md)
 - [Group](docs/Group.md)
 - [Health](docs/Health.md)
 - [InstructionSetArchitecture](docs/InstructionSetArchitecture.md)
 - [InternalCreateReservationRequest](docs/InternalCreateReservationRequest.md)
 - [InternalCreateReservationRequestAllOf](docs/InternalCreateReservationRequestAllOf.md)
 - [InviteUserRequest](docs/InviteUserRequest.md)
 - [ListClientApplicationsResponse](docs/ListClientApplicationsResponse.md)
 - [ListEndpointsResponse](docs/ListEndpointsResponse.md)
 - [ListGroupUsersResponse](docs/ListGroupUsersResponse.md)
 - [ListGroupsResponse](docs/ListGroupsResponse.md)
 - [ListQuantumProcessorsResponse](docs/ListQuantumProcessorsResponse.md)
 - [ListReservationsResponse](docs/ListReservationsResponse.md)
 - [Node](docs/Node.md)
 - [Operation](docs/Operation.md)
 - [OperationSite](docs/OperationSite.md)
 - [Parameter](docs/Parameter.md)
 - [ParameterSpec](docs/ParameterSpec.md)
 - [QuantumProcessor](docs/QuantumProcessor.md)
 - [RemoveGroupUserRequest](docs/RemoveGroupUserRequest.md)
 - [Reservation](docs/Reservation.md)
 - [TranslateNativeQuilToEncryptedBinaryRequest](docs/TranslateNativeQuilToEncryptedBinaryRequest.md)
 - [TranslateNativeQuilToEncryptedBinaryResponse](docs/TranslateNativeQuilToEncryptedBinaryResponse.md)
 - [User](docs/User.md)
 - [UserCredentials](docs/UserCredentials.md)
 - [UserCredentialsPassword](docs/UserCredentialsPassword.md)
 - [UserProfile](docs/UserProfile.md)
 - [ValidationError](docs/ValidationError.md)


To get access to the crate's generated documentation, use:

```
cargo doc --open
```

## Author

support@rigetti.com

