use chrono::Local;
use chrono::TimeZone;
use std::ops::Index;

pub struct QATradeDate {
    pub(crate) trade_date: Vec<i32>,
}

pub fn QA_util_date_to_string(date: i32) -> String {
    let year = date / 10000;
    let month = (date - year * 10000) / 100;
    let day = (date - year * 10000 - month * 100);
    let month_1 = if month < 10 {
        format!("0{}", month)
    } else {
        format!("{}", month)
    };
    let day_1 = if day < 10 {
        format!("0{}", day)
    } else {
        format!("{}", day)
    };

    let u = format!("{}-{}-{}", year, month_1, day_1);
    u
}
pub fn QA_util_datelist_to_string(date: Vec<i32>) -> Vec<String> {
    date.into_iter()
        .map(|x| QA_util_date_to_string(x))
        .collect::<Vec<String>>()
}

impl QATradeDate {
    pub fn new() -> Self {
        let trade_date = vec![
            19901219, 19901220, 19901221, 19901224, 19901225, 19901226, 19901227, 19901228,
            19901231, 19910102, 19910103, 19910104, 19910107, 19910108, 19910109, 19910110,
            19910111, 19910114, 19910115, 19910116, 19910117, 19910118, 19910121, 19910122,
            19910123, 19910124, 19910125, 19910128, 19910129, 19910130, 19910131, 19910201,
            19910204, 19910205, 19910206, 19910207, 19910208, 19910211, 19910212, 19910213,
            19910214, 19910219, 19910220, 19910221, 19910222, 19910225, 19910226, 19910227,
            19910228, 19910301, 19910304, 19910305, 19910306, 19910307, 19910308, 19910311,
            19910312, 19910313, 19910314, 19910315, 19910318, 19910319, 19910320, 19910321,
            19910322, 19910325, 19910326, 19910327, 19910328, 19910329, 19910401, 19910402,
            19910403, 19910404, 19910405, 19910408, 19910409, 19910410, 19910411, 19910412,
            19910415, 19910416, 19910417, 19910418, 19910419, 19910422, 19910423, 19910424,
            19910425, 19910426, 19910429, 19910430, 19910502, 19910503, 19910506, 19910507,
            19910508, 19910509, 19910510, 19910513, 19910514, 19910515, 19910516, 19910517,
            19910520, 19910521, 19910522, 19910523, 19910524, 19910527, 19910528, 19910529,
            19910530, 19910531, 19910603, 19910604, 19910605, 19910606, 19910607, 19910610,
            19910611, 19910612, 19910613, 19910614, 19910617, 19910618, 19910619, 19910620,
            19910621, 19910624, 19910625, 19910626, 19910627, 19910628, 19910701, 19910702,
            19910703, 19910704, 19910705, 19910708, 19910709, 19910710, 19910711, 19910712,
            19910715, 19910716, 19910717, 19910718, 19910719, 19910722, 19910723, 19910724,
            19910725, 19910726, 19910729, 19910730, 19910731, 19910801, 19910802, 19910805,
            19910806, 19910807, 19910808, 19910809, 19910812, 19910813, 19910814, 19910815,
            19910816, 19910819, 19910820, 19910821, 19910822, 19910823, 19910826, 19910827,
            19910828, 19910829, 19910830, 19910902, 19910903, 19910904, 19910905, 19910906,
            19910909, 19910910, 19910911, 19910912, 19910913, 19910916, 19910917, 19910918,
            19910919, 19910920, 19910923, 19910924, 19910925, 19910926, 19910927, 19910930,
            19911003, 19911004, 19911007, 19911008, 19911009, 19911010, 19911011, 19911014,
            19911015, 19911016, 19911017, 19911018, 19911021, 19911022, 19911023, 19911024,
            19911025, 19911028, 19911029, 19911030, 19911031, 19911101, 19911104, 19911105,
            19911106, 19911107, 19911108, 19911111, 19911112, 19911113, 19911114, 19911115,
            19911118, 19911119, 19911120, 19911121, 19911122, 19911125, 19911126, 19911127,
            19911128, 19911129, 19911202, 19911203, 19911204, 19911205, 19911206, 19911209,
            19911210, 19911211, 19911212, 19911213, 19911216, 19911217, 19911218, 19911219,
            19911220, 19911223, 19911224, 19911225, 19911226, 19911227, 19911230, 19911231,
            19920102, 19920103, 19920106, 19920107, 19920108, 19920109, 19920110, 19920113,
            19920114, 19920115, 19920116, 19920117, 19920120, 19920121, 19920122, 19920123,
            19920124, 19920127, 19920128, 19920129, 19920130, 19920131, 19920203, 19920207,
            19920210, 19920211, 19920212, 19920213, 19920214, 19920217, 19920218, 19920219,
            19920220, 19920221, 19920224, 19920225, 19920226, 19920227, 19920228, 19920302,
            19920303, 19920304, 19920305, 19920306, 19920309, 19920310, 19920311, 19920312,
            19920313, 19920316, 19920317, 19920318, 19920319, 19920320, 19920323, 19920324,
            19920325, 19920326, 19920327, 19920330, 19920331, 19920401, 19920402, 19920403,
            19920406, 19920407, 19920408, 19920409, 19920410, 19920413, 19920414, 19920415,
            19920416, 19920417, 19920420, 19920421, 19920422, 19920423, 19920424, 19920427,
            19920428, 19920429, 19920430, 19920504, 19920505, 19920506, 19920507, 19920508,
            19920511, 19920512, 19920513, 19920514, 19920515, 19920518, 19920519, 19920520,
            19920521, 19920522, 19920525, 19920526, 19920527, 19920528, 19920529, 19920601,
            19920602, 19920603, 19920604, 19920605, 19920608, 19920609, 19920610, 19920611,
            19920612, 19920615, 19920616, 19920617, 19920618, 19920619, 19920622, 19920623,
            19920624, 19920625, 19920626, 19920629, 19920630, 19920701, 19920702, 19920703,
            19920706, 19920707, 19920708, 19920709, 19920710, 19920713, 19920714, 19920715,
            19920716, 19920717, 19920720, 19920721, 19920722, 19920723, 19920724, 19920727,
            19920728, 19920729, 19920730, 19920731, 19920803, 19920804, 19920805, 19920806,
            19920807, 19920810, 19920811, 19920812, 19920813, 19920814, 19920817, 19920818,
            19920819, 19920820, 19920821, 19920824, 19920825, 19920826, 19920827, 19920828,
            19920831, 19920901, 19920902, 19920903, 19920904, 19920907, 19920908, 19920909,
            19920910, 19920911, 19920914, 19920915, 19920916, 19920917, 19920918, 19920921,
            19920922, 19920923, 19920924, 19920925, 19920928, 19920929, 19920930, 19921005,
            19921006, 19921007, 19921008, 19921009, 19921012, 19921013, 19921014, 19921015,
            19921016, 19921019, 19921020, 19921021, 19921022, 19921023, 19921026, 19921027,
            19921028, 19921029, 19921030, 19921102, 19921103, 19921104, 19921105, 19921106,
            19921109, 19921110, 19921111, 19921112, 19921113, 19921116, 19921117, 19921118,
            19921119, 19921120, 19921123, 19921124, 19921125, 19921126, 19921127, 19921130,
            19921201, 19921202, 19921203, 19921204, 19921207, 19921208, 19921209, 19921210,
            19921211, 19921214, 19921215, 19921216, 19921217, 19921218, 19921221, 19921222,
            19921223, 19921224, 19921225, 19921228, 19921229, 19921230, 19921231, 19930104,
            19930105, 19930106, 19930107, 19930108, 19930111, 19930112, 19930113, 19930114,
            19930115, 19930118, 19930119, 19930120, 19930121, 19930122, 19930127, 19930128,
            19930129, 19930201, 19930202, 19930203, 19930204, 19930205, 19930208, 19930209,
            19930210, 19930211, 19930212, 19930215, 19930216, 19930217, 19930218, 19930219,
            19930222, 19930223, 19930224, 19930225, 19930226, 19930301, 19930302, 19930303,
            19930304, 19930305, 19930308, 19930309, 19930310, 19930311, 19930312, 19930315,
            19930316, 19930317, 19930318, 19930319, 19930322, 19930323, 19930324, 19930325,
            19930326, 19930329, 19930330, 19930331, 19930401, 19930402, 19930405, 19930406,
            19930407, 19930408, 19930409, 19930412, 19930413, 19930414, 19930415, 19930416,
            19930419, 19930420, 19930421, 19930422, 19930423, 19930426, 19930427, 19930428,
            19930429, 19930430, 19930503, 19930504, 19930505, 19930506, 19930507, 19930510,
            19930511, 19930512, 19930513, 19930514, 19930517, 19930518, 19930519, 19930520,
            19930521, 19930524, 19930525, 19930526, 19930527, 19930528, 19930531, 19930601,
            19930602, 19930603, 19930604, 19930607, 19930608, 19930609, 19930610, 19930611,
            19930614, 19930615, 19930616, 19930617, 19930618, 19930621, 19930622, 19930623,
            19930624, 19930625, 19930628, 19930629, 19930630, 19930701, 19930702, 19930705,
            19930706, 19930707, 19930708, 19930709, 19930712, 19930713, 19930714, 19930715,
            19930716, 19930719, 19930720, 19930721, 19930722, 19930723, 19930726, 19930727,
            19930728, 19930729, 19930730, 19930802, 19930803, 19930804, 19930805, 19930806,
            19930809, 19930810, 19930811, 19930812, 19930813, 19930816, 19930817, 19930818,
            19930819, 19930820, 19930823, 19930824, 19930825, 19930826, 19930827, 19930830,
            19930831, 19930901, 19930902, 19930903, 19930906, 19930907, 19930908, 19930909,
            19930910, 19930913, 19930914, 19930915, 19930916, 19930917, 19930920, 19930921,
            19930922, 19930923, 19930924, 19930927, 19930928, 19930929, 19930930, 19931004,
            19931005, 19931006, 19931007, 19931008, 19931011, 19931012, 19931013, 19931014,
            19931015, 19931018, 19931019, 19931020, 19931021, 19931022, 19931025, 19931026,
            19931027, 19931028, 19931029, 19931101, 19931102, 19931103, 19931104, 19931105,
            19931108, 19931109, 19931110, 19931111, 19931112, 19931115, 19931116, 19931117,
            19931118, 19931119, 19931122, 19931123, 19931124, 19931125, 19931126, 19931129,
            19931130, 19931201, 19931202, 19931203, 19931206, 19931207, 19931208, 19931209,
            19931210, 19931213, 19931214, 19931215, 19931216, 19931217, 19931220, 19931221,
            19931222, 19931223, 19931224, 19931227, 19931228, 19931229, 19931230, 19931231,
            19940103, 19940104, 19940105, 19940106, 19940107, 19940110, 19940111, 19940112,
            19940113, 19940114, 19940117, 19940118, 19940119, 19940120, 19940121, 19940124,
            19940125, 19940126, 19940127, 19940128, 19940131, 19940201, 19940202, 19940203,
            19940204, 19940214, 19940215, 19940216, 19940217, 19940218, 19940221, 19940222,
            19940223, 19940224, 19940225, 19940228, 19940301, 19940302, 19940303, 19940304,
            19940307, 19940308, 19940309, 19940310, 19940311, 19940314, 19940315, 19940316,
            19940317, 19940318, 19940321, 19940322, 19940323, 19940324, 19940325, 19940328,
            19940329, 19940330, 19940331, 19940401, 19940404, 19940405, 19940406, 19940407,
            19940408, 19940411, 19940412, 19940413, 19940414, 19940415, 19940418, 19940419,
            19940420, 19940421, 19940422, 19940425, 19940426, 19940427, 19940428, 19940429,
            19940503, 19940504, 19940505, 19940506, 19940509, 19940510, 19940511, 19940512,
            19940513, 19940516, 19940517, 19940518, 19940519, 19940520, 19940523, 19940524,
            19940525, 19940526, 19940527, 19940530, 19940531, 19940601, 19940602, 19940603,
            19940606, 19940607, 19940608, 19940609, 19940610, 19940613, 19940614, 19940615,
            19940616, 19940617, 19940620, 19940621, 19940622, 19940623, 19940624, 19940627,
            19940628, 19940629, 19940630, 19940701, 19940704, 19940705, 19940706, 19940707,
            19940708, 19940711, 19940712, 19940713, 19940714, 19940715, 19940718, 19940719,
            19940720, 19940721, 19940722, 19940725, 19940726, 19940727, 19940728, 19940729,
            19940801, 19940802, 19940803, 19940804, 19940805, 19940808, 19940809, 19940810,
            19940811, 19940812, 19940815, 19940816, 19940817, 19940818, 19940819, 19940822,
            19940823, 19940824, 19940825, 19940826, 19940829, 19940830, 19940831, 19940901,
            19940902, 19940905, 19940906, 19940907, 19940908, 19940909, 19940912, 19940913,
            19940914, 19940915, 19940916, 19940919, 19940920, 19940921, 19940922, 19940923,
            19940926, 19940927, 19940928, 19940929, 19940930, 19941005, 19941006, 19941007,
            19941010, 19941011, 19941012, 19941013, 19941014, 19941017, 19941018, 19941019,
            19941020, 19941021, 19941024, 19941025, 19941026, 19941027, 19941028, 19941031,
            19941101, 19941102, 19941103, 19941104, 19941107, 19941108, 19941109, 19941110,
            19941111, 19941114, 19941115, 19941116, 19941117, 19941118, 19941121, 19941122,
            19941123, 19941124, 19941125, 19941128, 19941129, 19941130, 19941201, 19941202,
            19941205, 19941206, 19941207, 19941208, 19941209, 19941212, 19941213, 19941214,
            19941215, 19941216, 19941219, 19941220, 19941221, 19941222, 19941223, 19941226,
            19941227, 19941228, 19941229, 19941230, 19950103, 19950104, 19950105, 19950106,
            19950109, 19950110, 19950111, 19950112, 19950113, 19950116, 19950117, 19950118,
            19950119, 19950120, 19950123, 19950124, 19950125, 19950126, 19950127, 19950206,
            19950207, 19950208, 19950209, 19950210, 19950213, 19950214, 19950215, 19950216,
            19950217, 19950220, 19950221, 19950222, 19950223, 19950224, 19950227, 19950228,
            19950301, 19950302, 19950303, 19950306, 19950307, 19950308, 19950309, 19950310,
            19950313, 19950314, 19950315, 19950316, 19950317, 19950320, 19950321, 19950322,
            19950323, 19950324, 19950327, 19950328, 19950329, 19950330, 19950331, 19950403,
            19950404, 19950405, 19950406, 19950407, 19950410, 19950411, 19950412, 19950413,
            19950414, 19950417, 19950418, 19950419, 19950420, 19950421, 19950424, 19950425,
            19950426, 19950427, 19950428, 19950502, 19950503, 19950504, 19950505, 19950508,
            19950509, 19950510, 19950511, 19950512, 19950515, 19950516, 19950517, 19950518,
            19950519, 19950522, 19950523, 19950524, 19950525, 19950526, 19950529, 19950530,
            19950531, 19950601, 19950602, 19950605, 19950606, 19950607, 19950608, 19950609,
            19950612, 19950613, 19950614, 19950615, 19950616, 19950619, 19950620, 19950621,
            19950622, 19950623, 19950626, 19950627, 19950628, 19950629, 19950630, 19950703,
            19950704, 19950705, 19950706, 19950707, 19950710, 19950711, 19950712, 19950713,
            19950714, 19950717, 19950718, 19950719, 19950720, 19950721, 19950724, 19950725,
            19950726, 19950727, 19950728, 19950731, 19950801, 19950802, 19950803, 19950804,
            19950807, 19950808, 19950809, 19950810, 19950811, 19950814, 19950815, 19950816,
            19950817, 19950818, 19950821, 19950822, 19950823, 19950824, 19950825, 19950828,
            19950829, 19950830, 19950831, 19950901, 19950904, 19950905, 19950906, 19950907,
            19950908, 19950911, 19950912, 19950913, 19950914, 19950915, 19950918, 19950919,
            19950920, 19950921, 19950922, 19950925, 19950926, 19950927, 19950928, 19950929,
            19951004, 19951005, 19951006, 19951009, 19951010, 19951011, 19951012, 19951013,
            19951016, 19951017, 19951018, 19951019, 19951020, 19951023, 19951024, 19951025,
            19951026, 19951027, 19951030, 19951031, 19951101, 19951102, 19951103, 19951106,
            19951107, 19951108, 19951109, 19951110, 19951113, 19951114, 19951115, 19951116,
            19951117, 19951120, 19951121, 19951122, 19951123, 19951124, 19951127, 19951128,
            19951129, 19951130, 19951201, 19951204, 19951205, 19951206, 19951207, 19951208,
            19951211, 19951212, 19951213, 19951214, 19951215, 19951218, 19951219, 19951220,
            19951221, 19951222, 19951225, 19951226, 19951227, 19951228, 19951229, 19960102,
            19960103, 19960104, 19960105, 19960108, 19960109, 19960110, 19960111, 19960112,
            19960115, 19960116, 19960117, 19960118, 19960119, 19960122, 19960123, 19960124,
            19960125, 19960126, 19960129, 19960130, 19960131, 19960201, 19960202, 19960205,
            19960206, 19960207, 19960208, 19960209, 19960212, 19960213, 19960214, 19960215,
            19960216, 19960304, 19960305, 19960306, 19960307, 19960308, 19960311, 19960312,
            19960313, 19960314, 19960315, 19960318, 19960319, 19960320, 19960321, 19960322,
            19960325, 19960326, 19960327, 19960328, 19960329, 19960401, 19960402, 19960403,
            19960404, 19960405, 19960408, 19960409, 19960410, 19960411, 19960412, 19960415,
            19960416, 19960417, 19960418, 19960419, 19960422, 19960423, 19960424, 19960425,
            19960426, 19960429, 19960430, 19960502, 19960503, 19960506, 19960507, 19960508,
            19960509, 19960510, 19960513, 19960514, 19960515, 19960516, 19960517, 19960520,
            19960521, 19960522, 19960523, 19960524, 19960527, 19960528, 19960529, 19960530,
            19960531, 19960603, 19960604, 19960605, 19960606, 19960607, 19960610, 19960611,
            19960612, 19960613, 19960614, 19960617, 19960618, 19960619, 19960620, 19960621,
            19960624, 19960625, 19960626, 19960627, 19960628, 19960701, 19960702, 19960703,
            19960704, 19960705, 19960708, 19960709, 19960710, 19960711, 19960712, 19960715,
            19960716, 19960717, 19960718, 19960719, 19960722, 19960723, 19960724, 19960725,
            19960726, 19960729, 19960730, 19960731, 19960801, 19960802, 19960805, 19960806,
            19960807, 19960808, 19960809, 19960812, 19960813, 19960814, 19960815, 19960816,
            19960819, 19960820, 19960821, 19960822, 19960823, 19960826, 19960827, 19960828,
            19960829, 19960830, 19960902, 19960903, 19960904, 19960905, 19960906, 19960909,
            19960910, 19960911, 19960912, 19960913, 19960916, 19960917, 19960918, 19960919,
            19960920, 19960923, 19960924, 19960925, 19960926, 19960927, 19961003, 19961004,
            19961007, 19961008, 19961009, 19961010, 19961011, 19961014, 19961015, 19961016,
            19961017, 19961018, 19961021, 19961022, 19961023, 19961024, 19961025, 19961028,
            19961029, 19961030, 19961031, 19961101, 19961104, 19961105, 19961106, 19961107,
            19961108, 19961111, 19961112, 19961113, 19961114, 19961115, 19961118, 19961119,
            19961120, 19961121, 19961122, 19961125, 19961126, 19961127, 19961128, 19961129,
            19961202, 19961203, 19961204, 19961205, 19961206, 19961209, 19961210, 19961211,
            19961212, 19961213, 19961216, 19961217, 19961218, 19961219, 19961220, 19961223,
            19961224, 19961225, 19961226, 19961227, 19961230, 19961231, 19970102, 19970103,
            19970106, 19970107, 19970108, 19970109, 19970110, 19970113, 19970114, 19970115,
            19970116, 19970117, 19970120, 19970121, 19970122, 19970123, 19970124, 19970127,
            19970128, 19970129, 19970130, 19970131, 19970217, 19970218, 19970219, 19970220,
            19970221, 19970224, 19970225, 19970226, 19970227, 19970228, 19970303, 19970304,
            19970305, 19970306, 19970307, 19970310, 19970311, 19970312, 19970313, 19970314,
            19970317, 19970318, 19970319, 19970320, 19970321, 19970324, 19970325, 19970326,
            19970327, 19970328, 19970331, 19970401, 19970402, 19970403, 19970404, 19970407,
            19970408, 19970409, 19970410, 19970411, 19970414, 19970415, 19970416, 19970417,
            19970418, 19970421, 19970422, 19970423, 19970424, 19970425, 19970428, 19970429,
            19970430, 19970505, 19970506, 19970507, 19970508, 19970509, 19970512, 19970513,
            19970514, 19970515, 19970516, 19970519, 19970520, 19970521, 19970522, 19970523,
            19970526, 19970527, 19970528, 19970529, 19970530, 19970602, 19970603, 19970604,
            19970605, 19970606, 19970609, 19970610, 19970611, 19970612, 19970613, 19970616,
            19970617, 19970618, 19970619, 19970620, 19970623, 19970624, 19970625, 19970626,
            19970627, 19970702, 19970703, 19970704, 19970707, 19970708, 19970709, 19970710,
            19970711, 19970714, 19970715, 19970716, 19970717, 19970718, 19970721, 19970722,
            19970723, 19970724, 19970725, 19970728, 19970729, 19970730, 19970731, 19970801,
            19970804, 19970805, 19970806, 19970807, 19970808, 19970811, 19970812, 19970813,
            19970814, 19970815, 19970818, 19970819, 19970820, 19970821, 19970822, 19970825,
            19970826, 19970827, 19970828, 19970829, 19970901, 19970902, 19970903, 19970904,
            19970905, 19970908, 19970909, 19970910, 19970911, 19970912, 19970915, 19970916,
            19970917, 19970918, 19970919, 19970922, 19970923, 19970924, 19970925, 19970926,
            19970929, 19970930, 19971006, 19971007, 19971008, 19971009, 19971010, 19971013,
            19971014, 19971015, 19971016, 19971017, 19971020, 19971021, 19971022, 19971023,
            19971024, 19971027, 19971028, 19971029, 19971030, 19971031, 19971103, 19971104,
            19971105, 19971106, 19971107, 19971110, 19971111, 19971112, 19971113, 19971114,
            19971117, 19971118, 19971119, 19971120, 19971121, 19971124, 19971125, 19971126,
            19971127, 19971128, 19971201, 19971202, 19971203, 19971204, 19971205, 19971208,
            19971209, 19971210, 19971211, 19971212, 19971215, 19971216, 19971217, 19971218,
            19971219, 19971222, 19971223, 19971224, 19971225, 19971226, 19971229, 19971230,
            19971231, 19980105, 19980106, 19980107, 19980108, 19980109, 19980112, 19980113,
            19980114, 19980115, 19980116, 19980119, 19980120, 19980121, 19980122, 19980123,
            19980209, 19980210, 19980211, 19980212, 19980213, 19980216, 19980217, 19980218,
            19980219, 19980220, 19980223, 19980224, 19980225, 19980226, 19980227, 19980302,
            19980303, 19980304, 19980305, 19980306, 19980309, 19980310, 19980311, 19980312,
            19980313, 19980316, 19980317, 19980318, 19980319, 19980320, 19980323, 19980324,
            19980325, 19980326, 19980327, 19980330, 19980331, 19980401, 19980402, 19980403,
            19980406, 19980407, 19980408, 19980409, 19980410, 19980413, 19980414, 19980415,
            19980416, 19980417, 19980420, 19980421, 19980422, 19980423, 19980424, 19980427,
            19980428, 19980429, 19980430, 19980504, 19980505, 19980506, 19980507, 19980508,
            19980511, 19980512, 19980513, 19980514, 19980515, 19980518, 19980519, 19980520,
            19980521, 19980522, 19980525, 19980526, 19980527, 19980528, 19980529, 19980601,
            19980602, 19980603, 19980604, 19980605, 19980608, 19980609, 19980610, 19980611,
            19980612, 19980615, 19980616, 19980617, 19980618, 19980619, 19980622, 19980623,
            19980624, 19980625, 19980626, 19980629, 19980630, 19980701, 19980702, 19980703,
            19980706, 19980707, 19980708, 19980709, 19980710, 19980713, 19980714, 19980715,
            19980716, 19980717, 19980720, 19980721, 19980722, 19980723, 19980724, 19980727,
            19980728, 19980729, 19980730, 19980731, 19980803, 19980804, 19980805, 19980806,
            19980807, 19980810, 19980811, 19980812, 19980813, 19980814, 19980817, 19980818,
            19980819, 19980820, 19980821, 19980824, 19980825, 19980826, 19980827, 19980828,
            19980831, 19980901, 19980902, 19980903, 19980904, 19980907, 19980908, 19980909,
            19980910, 19980911, 19980914, 19980915, 19980916, 19980917, 19980918, 19980921,
            19980922, 19980923, 19980924, 19980925, 19980928, 19980929, 19980930, 19981005,
            19981006, 19981007, 19981008, 19981009, 19981012, 19981013, 19981014, 19981015,
            19981016, 19981019, 19981020, 19981021, 19981022, 19981023, 19981026, 19981027,
            19981028, 19981029, 19981030, 19981102, 19981103, 19981104, 19981105, 19981106,
            19981109, 19981110, 19981111, 19981112, 19981113, 19981116, 19981117, 19981118,
            19981119, 19981120, 19981123, 19981124, 19981125, 19981126, 19981127, 19981130,
            19981201, 19981202, 19981203, 19981204, 19981207, 19981208, 19981209, 19981210,
            19981211, 19981214, 19981215, 19981216, 19981217, 19981218, 19981221, 19981222,
            19981223, 19981224, 19981225, 19981228, 19981229, 19981230, 19981231, 19990104,
            19990105, 19990106, 19990107, 19990108, 19990111, 19990112, 19990113, 19990114,
            19990115, 19990118, 19990119, 19990120, 19990121, 19990122, 19990125, 19990126,
            19990127, 19990128, 19990129, 19990201, 19990202, 19990203, 19990204, 19990205,
            19990208, 19990209, 19990301, 19990302, 19990303, 19990304, 19990305, 19990308,
            19990309, 19990310, 19990311, 19990312, 19990315, 19990316, 19990317, 19990318,
            19990319, 19990322, 19990323, 19990324, 19990325, 19990326, 19990329, 19990330,
            19990331, 19990401, 19990402, 19990405, 19990406, 19990407, 19990408, 19990409,
            19990412, 19990413, 19990414, 19990415, 19990416, 19990419, 19990420, 19990421,
            19990422, 19990423, 19990426, 19990427, 19990428, 19990429, 19990430, 19990504,
            19990505, 19990506, 19990507, 19990510, 19990511, 19990512, 19990513, 19990514,
            19990517, 19990518, 19990519, 19990520, 19990521, 19990524, 19990525, 19990526,
            19990527, 19990528, 19990531, 19990601, 19990602, 19990603, 19990604, 19990607,
            19990608, 19990609, 19990610, 19990611, 19990614, 19990615, 19990616, 19990617,
            19990618, 19990621, 19990622, 19990623, 19990624, 19990625, 19990628, 19990629,
            19990630, 19990701, 19990702, 19990705, 19990706, 19990707, 19990708, 19990709,
            19990712, 19990713, 19990714, 19990715, 19990716, 19990719, 19990720, 19990721,
            19990722, 19990723, 19990726, 19990727, 19990728, 19990729, 19990730, 19990802,
            19990803, 19990804, 19990805, 19990806, 19990809, 19990810, 19990811, 19990812,
            19990813, 19990816, 19990817, 19990818, 19990819, 19990820, 19990823, 19990824,
            19990825, 19990826, 19990827, 19990830, 19990831, 19990901, 19990902, 19990903,
            19990906, 19990907, 19990908, 19990909, 19990910, 19990913, 19990914, 19990915,
            19990916, 19990917, 19990920, 19990921, 19990922, 19990923, 19990924, 19990927,
            19990928, 19990929, 19990930, 19991008, 19991011, 19991012, 19991013, 19991014,
            19991015, 19991018, 19991019, 19991020, 19991021, 19991022, 19991025, 19991026,
            19991027, 19991028, 19991029, 19991101, 19991102, 19991103, 19991104, 19991105,
            19991108, 19991109, 19991110, 19991111, 19991112, 19991115, 19991116, 19991117,
            19991118, 19991119, 19991122, 19991123, 19991124, 19991125, 19991126, 19991129,
            19991130, 19991201, 19991202, 19991203, 19991206, 19991207, 19991208, 19991209,
            19991210, 19991213, 19991214, 19991215, 19991216, 19991217, 19991221, 19991222,
            19991223, 19991224, 19991227, 19991228, 19991229, 19991230, 20000104, 20000105,
            20000106, 20000107, 20000110, 20000111, 20000112, 20000113, 20000114, 20000117,
            20000118, 20000119, 20000120, 20000121, 20000124, 20000125, 20000126, 20000127,
            20000128, 20000214, 20000215, 20000216, 20000217, 20000218, 20000221, 20000222,
            20000223, 20000224, 20000225, 20000228, 20000229, 20000301, 20000302, 20000303,
            20000306, 20000307, 20000308, 20000309, 20000310, 20000313, 20000314, 20000315,
            20000316, 20000317, 20000320, 20000321, 20000322, 20000323, 20000324, 20000327,
            20000328, 20000329, 20000330, 20000331, 20000403, 20000404, 20000405, 20000406,
            20000407, 20000410, 20000411, 20000412, 20000413, 20000414, 20000417, 20000418,
            20000419, 20000420, 20000421, 20000424, 20000425, 20000426, 20000427, 20000428,
            20000508, 20000509, 20000510, 20000511, 20000512, 20000515, 20000516, 20000517,
            20000518, 20000519, 20000522, 20000523, 20000524, 20000525, 20000526, 20000529,
            20000530, 20000531, 20000601, 20000602, 20000605, 20000606, 20000607, 20000608,
            20000609, 20000612, 20000613, 20000614, 20000615, 20000616, 20000619, 20000620,
            20000621, 20000622, 20000623, 20000626, 20000627, 20000628, 20000629, 20000630,
            20000703, 20000704, 20000705, 20000706, 20000707, 20000710, 20000711, 20000712,
            20000713, 20000714, 20000717, 20000718, 20000719, 20000720, 20000721, 20000724,
            20000725, 20000726, 20000727, 20000728, 20000731, 20000801, 20000802, 20000803,
            20000804, 20000807, 20000808, 20000809, 20000810, 20000811, 20000814, 20000815,
            20000816, 20000817, 20000818, 20000821, 20000822, 20000823, 20000824, 20000825,
            20000828, 20000829, 20000830, 20000831, 20000901, 20000904, 20000905, 20000906,
            20000907, 20000908, 20000911, 20000912, 20000913, 20000914, 20000915, 20000918,
            20000919, 20000920, 20000921, 20000922, 20000925, 20000926, 20000927, 20000928,
            20000929, 20001009, 20001010, 20001011, 20001012, 20001013, 20001016, 20001017,
            20001018, 20001019, 20001020, 20001023, 20001024, 20001025, 20001026, 20001027,
            20001030, 20001031, 20001101, 20001102, 20001103, 20001106, 20001107, 20001108,
            20001109, 20001110, 20001113, 20001114, 20001115, 20001116, 20001117, 20001120,
            20001121, 20001122, 20001123, 20001124, 20001127, 20001128, 20001129, 20001130,
            20001201, 20001204, 20001205, 20001206, 20001207, 20001208, 20001211, 20001212,
            20001213, 20001214, 20001215, 20001218, 20001219, 20001220, 20001221, 20001222,
            20001225, 20001226, 20001227, 20001228, 20001229, 20010102, 20010103, 20010104,
            20010105, 20010108, 20010109, 20010110, 20010111, 20010112, 20010115, 20010116,
            20010117, 20010118, 20010119, 20010205, 20010206, 20010207, 20010208, 20010209,
            20010212, 20010213, 20010214, 20010215, 20010216, 20010219, 20010220, 20010221,
            20010222, 20010223, 20010226, 20010227, 20010228, 20010301, 20010302, 20010305,
            20010306, 20010307, 20010308, 20010309, 20010312, 20010313, 20010314, 20010315,
            20010316, 20010319, 20010320, 20010321, 20010322, 20010323, 20010326, 20010327,
            20010328, 20010329, 20010330, 20010402, 20010403, 20010404, 20010405, 20010406,
            20010409, 20010410, 20010411, 20010412, 20010413, 20010416, 20010417, 20010418,
            20010419, 20010420, 20010423, 20010424, 20010425, 20010426, 20010427, 20010430,
            20010508, 20010509, 20010510, 20010511, 20010514, 20010515, 20010516, 20010517,
            20010518, 20010521, 20010522, 20010523, 20010524, 20010525, 20010528, 20010529,
            20010530, 20010531, 20010601, 20010604, 20010605, 20010606, 20010607, 20010608,
            20010611, 20010612, 20010613, 20010614, 20010615, 20010618, 20010619, 20010620,
            20010621, 20010622, 20010625, 20010626, 20010627, 20010628, 20010629, 20010702,
            20010703, 20010704, 20010705, 20010706, 20010709, 20010710, 20010711, 20010712,
            20010713, 20010716, 20010717, 20010718, 20010719, 20010720, 20010723, 20010724,
            20010725, 20010726, 20010727, 20010730, 20010731, 20010801, 20010802, 20010803,
            20010806, 20010807, 20010808, 20010809, 20010810, 20010813, 20010814, 20010815,
            20010816, 20010817, 20010820, 20010821, 20010822, 20010823, 20010824, 20010827,
            20010828, 20010829, 20010830, 20010831, 20010903, 20010904, 20010905, 20010906,
            20010907, 20010910, 20010911, 20010912, 20010913, 20010914, 20010917, 20010918,
            20010919, 20010920, 20010921, 20010924, 20010925, 20010926, 20010927, 20010928,
            20011008, 20011009, 20011010, 20011011, 20011012, 20011015, 20011016, 20011017,
            20011018, 20011019, 20011022, 20011023, 20011024, 20011025, 20011026, 20011029,
            20011030, 20011031, 20011101, 20011102, 20011105, 20011106, 20011107, 20011108,
            20011109, 20011112, 20011113, 20011114, 20011115, 20011116, 20011119, 20011120,
            20011121, 20011122, 20011123, 20011126, 20011127, 20011128, 20011129, 20011130,
            20011203, 20011204, 20011205, 20011206, 20011207, 20011210, 20011211, 20011212,
            20011213, 20011214, 20011217, 20011218, 20011219, 20011220, 20011221, 20011224,
            20011225, 20011226, 20011227, 20011228, 20011231, 20020104, 20020107, 20020108,
            20020109, 20020110, 20020111, 20020114, 20020115, 20020116, 20020117, 20020118,
            20020121, 20020122, 20020123, 20020124, 20020125, 20020128, 20020129, 20020130,
            20020131, 20020201, 20020204, 20020205, 20020206, 20020207, 20020208, 20020225,
            20020226, 20020227, 20020228, 20020301, 20020304, 20020305, 20020306, 20020307,
            20020308, 20020311, 20020312, 20020313, 20020314, 20020315, 20020318, 20020319,
            20020320, 20020321, 20020322, 20020325, 20020326, 20020327, 20020328, 20020329,
            20020401, 20020402, 20020403, 20020404, 20020405, 20020408, 20020409, 20020410,
            20020411, 20020412, 20020415, 20020416, 20020417, 20020418, 20020419, 20020422,
            20020423, 20020424, 20020425, 20020426, 20020429, 20020430, 20020508, 20020509,
            20020510, 20020513, 20020514, 20020515, 20020516, 20020517, 20020520, 20020521,
            20020522, 20020523, 20020524, 20020527, 20020528, 20020529, 20020530, 20020531,
            20020603, 20020604, 20020605, 20020606, 20020607, 20020610, 20020611, 20020612,
            20020613, 20020614, 20020617, 20020618, 20020619, 20020620, 20020621, 20020624,
            20020625, 20020626, 20020627, 20020628, 20020701, 20020702, 20020703, 20020704,
            20020705, 20020708, 20020709, 20020710, 20020711, 20020712, 20020715, 20020716,
            20020717, 20020718, 20020719, 20020722, 20020723, 20020724, 20020725, 20020726,
            20020729, 20020730, 20020731, 20020801, 20020802, 20020805, 20020806, 20020807,
            20020808, 20020809, 20020812, 20020813, 20020814, 20020815, 20020816, 20020819,
            20020820, 20020821, 20020822, 20020823, 20020826, 20020827, 20020828, 20020829,
            20020830, 20020902, 20020903, 20020904, 20020905, 20020906, 20020909, 20020910,
            20020911, 20020912, 20020913, 20020916, 20020917, 20020918, 20020919, 20020920,
            20020923, 20020924, 20020925, 20020926, 20020927, 20021008, 20021009, 20021010,
            20021011, 20021014, 20021015, 20021016, 20021017, 20021018, 20021021, 20021022,
            20021023, 20021024, 20021025, 20021028, 20021029, 20021030, 20021031, 20021101,
            20021104, 20021105, 20021106, 20021107, 20021108, 20021111, 20021112, 20021113,
            20021114, 20021115, 20021118, 20021119, 20021120, 20021121, 20021122, 20021125,
            20021126, 20021127, 20021128, 20021129, 20021202, 20021203, 20021204, 20021205,
            20021206, 20021209, 20021210, 20021211, 20021212, 20021213, 20021216, 20021217,
            20021218, 20021219, 20021220, 20021223, 20021224, 20021225, 20021226, 20021227,
            20021230, 20021231, 20030102, 20030103, 20030106, 20030107, 20030108, 20030109,
            20030110, 20030113, 20030114, 20030115, 20030116, 20030117, 20030120, 20030121,
            20030122, 20030123, 20030124, 20030127, 20030128, 20030129, 20030210, 20030211,
            20030212, 20030213, 20030214, 20030217, 20030218, 20030219, 20030220, 20030221,
            20030224, 20030225, 20030226, 20030227, 20030228, 20030303, 20030304, 20030305,
            20030306, 20030307, 20030310, 20030311, 20030312, 20030313, 20030314, 20030317,
            20030318, 20030319, 20030320, 20030321, 20030324, 20030325, 20030326, 20030327,
            20030328, 20030331, 20030401, 20030402, 20030403, 20030404, 20030407, 20030408,
            20030409, 20030410, 20030411, 20030414, 20030415, 20030416, 20030417, 20030418,
            20030421, 20030422, 20030423, 20030424, 20030425, 20030428, 20030429, 20030430,
            20030512, 20030513, 20030514, 20030515, 20030516, 20030519, 20030520, 20030521,
            20030522, 20030523, 20030526, 20030527, 20030528, 20030529, 20030530, 20030602,
            20030603, 20030604, 20030605, 20030606, 20030609, 20030610, 20030611, 20030612,
            20030613, 20030616, 20030617, 20030618, 20030619, 20030620, 20030623, 20030624,
            20030625, 20030626, 20030627, 20030630, 20030701, 20030702, 20030703, 20030704,
            20030707, 20030708, 20030709, 20030710, 20030711, 20030714, 20030715, 20030716,
            20030717, 20030718, 20030721, 20030722, 20030723, 20030724, 20030725, 20030728,
            20030729, 20030730, 20030731, 20030801, 20030804, 20030805, 20030806, 20030807,
            20030808, 20030811, 20030812, 20030813, 20030814, 20030815, 20030818, 20030819,
            20030820, 20030821, 20030822, 20030825, 20030826, 20030827, 20030828, 20030829,
            20030901, 20030902, 20030903, 20030904, 20030905, 20030908, 20030909, 20030910,
            20030911, 20030912, 20030915, 20030916, 20030917, 20030918, 20030919, 20030922,
            20030923, 20030924, 20030925, 20030926, 20030929, 20030930, 20031008, 20031009,
            20031010, 20031013, 20031014, 20031015, 20031016, 20031017, 20031020, 20031021,
            20031022, 20031023, 20031024, 20031027, 20031028, 20031029, 20031030, 20031031,
            20031103, 20031104, 20031105, 20031106, 20031107, 20031110, 20031111, 20031112,
            20031113, 20031114, 20031117, 20031118, 20031119, 20031120, 20031121, 20031124,
            20031125, 20031126, 20031127, 20031128, 20031201, 20031202, 20031203, 20031204,
            20031205, 20031208, 20031209, 20031210, 20031211, 20031212, 20031215, 20031216,
            20031217, 20031218, 20031219, 20031222, 20031223, 20031224, 20031225, 20031226,
            20031229, 20031230, 20031231, 20040102, 20040105, 20040106, 20040107, 20040108,
            20040109, 20040112, 20040113, 20040114, 20040115, 20040116, 20040129, 20040130,
            20040202, 20040203, 20040204, 20040205, 20040206, 20040209, 20040210, 20040211,
            20040212, 20040213, 20040216, 20040217, 20040218, 20040219, 20040220, 20040223,
            20040224, 20040225, 20040226, 20040227, 20040301, 20040302, 20040303, 20040304,
            20040305, 20040308, 20040309, 20040310, 20040311, 20040312, 20040315, 20040316,
            20040317, 20040318, 20040319, 20040322, 20040323, 20040324, 20040325, 20040326,
            20040329, 20040330, 20040331, 20040401, 20040402, 20040405, 20040406, 20040407,
            20040408, 20040409, 20040412, 20040413, 20040414, 20040415, 20040416, 20040419,
            20040420, 20040421, 20040422, 20040423, 20040426, 20040427, 20040428, 20040429,
            20040430, 20040510, 20040511, 20040512, 20040513, 20040514, 20040517, 20040518,
            20040519, 20040520, 20040521, 20040524, 20040525, 20040526, 20040527, 20040528,
            20040531, 20040601, 20040602, 20040603, 20040604, 20040607, 20040608, 20040609,
            20040610, 20040611, 20040614, 20040615, 20040616, 20040617, 20040618, 20040621,
            20040622, 20040623, 20040624, 20040625, 20040628, 20040629, 20040630, 20040701,
            20040702, 20040705, 20040706, 20040707, 20040708, 20040709, 20040712, 20040713,
            20040714, 20040715, 20040716, 20040719, 20040720, 20040721, 20040722, 20040723,
            20040726, 20040727, 20040728, 20040729, 20040730, 20040802, 20040803, 20040804,
            20040805, 20040806, 20040809, 20040810, 20040811, 20040812, 20040813, 20040816,
            20040817, 20040818, 20040819, 20040820, 20040823, 20040824, 20040825, 20040826,
            20040827, 20040830, 20040831, 20040901, 20040902, 20040903, 20040906, 20040907,
            20040908, 20040909, 20040910, 20040913, 20040914, 20040915, 20040916, 20040917,
            20040920, 20040921, 20040922, 20040923, 20040924, 20040927, 20040928, 20040929,
            20040930, 20041008, 20041011, 20041012, 20041013, 20041014, 20041015, 20041018,
            20041019, 20041020, 20041021, 20041022, 20041025, 20041026, 20041027, 20041028,
            20041029, 20041101, 20041102, 20041103, 20041104, 20041105, 20041108, 20041109,
            20041110, 20041111, 20041112, 20041115, 20041116, 20041117, 20041118, 20041119,
            20041122, 20041123, 20041124, 20041125, 20041126, 20041129, 20041130, 20041201,
            20041202, 20041203, 20041206, 20041207, 20041208, 20041209, 20041210, 20041213,
            20041214, 20041215, 20041216, 20041217, 20041220, 20041221, 20041222, 20041223,
            20041224, 20041227, 20041228, 20041229, 20041230, 20041231, 20050104, 20050105,
            20050106, 20050107, 20050110, 20050111, 20050112, 20050113, 20050114, 20050117,
            20050118, 20050119, 20050120, 20050121, 20050124, 20050125, 20050126, 20050127,
            20050128, 20050131, 20050201, 20050202, 20050203, 20050204, 20050216, 20050217,
            20050218, 20050221, 20050222, 20050223, 20050224, 20050225, 20050228, 20050301,
            20050302, 20050303, 20050304, 20050307, 20050308, 20050309, 20050310, 20050311,
            20050314, 20050315, 20050316, 20050317, 20050318, 20050321, 20050322, 20050323,
            20050324, 20050325, 20050328, 20050329, 20050330, 20050331, 20050401, 20050404,
            20050405, 20050406, 20050407, 20050408, 20050411, 20050412, 20050413, 20050414,
            20050415, 20050418, 20050419, 20050420, 20050421, 20050422, 20050425, 20050426,
            20050427, 20050428, 20050429, 20050509, 20050510, 20050511, 20050512, 20050513,
            20050516, 20050517, 20050518, 20050519, 20050520, 20050523, 20050524, 20050525,
            20050526, 20050527, 20050530, 20050531, 20050601, 20050602, 20050603, 20050606,
            20050607, 20050608, 20050609, 20050610, 20050613, 20050614, 20050615, 20050616,
            20050617, 20050620, 20050621, 20050622, 20050623, 20050624, 20050627, 20050628,
            20050629, 20050630, 20050701, 20050704, 20050705, 20050706, 20050707, 20050708,
            20050711, 20050712, 20050713, 20050714, 20050715, 20050718, 20050719, 20050720,
            20050721, 20050722, 20050725, 20050726, 20050727, 20050728, 20050729, 20050801,
            20050802, 20050803, 20050804, 20050805, 20050808, 20050809, 20050810, 20050811,
            20050812, 20050815, 20050816, 20050817, 20050818, 20050819, 20050822, 20050823,
            20050824, 20050825, 20050826, 20050829, 20050830, 20050831, 20050901, 20050902,
            20050905, 20050906, 20050907, 20050908, 20050909, 20050912, 20050913, 20050914,
            20050915, 20050916, 20050919, 20050920, 20050921, 20050922, 20050923, 20050926,
            20050927, 20050928, 20050929, 20050930, 20051010, 20051011, 20051012, 20051013,
            20051014, 20051017, 20051018, 20051019, 20051020, 20051021, 20051024, 20051025,
            20051026, 20051027, 20051028, 20051031, 20051101, 20051102, 20051103, 20051104,
            20051107, 20051108, 20051109, 20051110, 20051111, 20051114, 20051115, 20051116,
            20051117, 20051118, 20051121, 20051122, 20051123, 20051124, 20051125, 20051128,
            20051129, 20051130, 20051201, 20051202, 20051205, 20051206, 20051207, 20051208,
            20051209, 20051212, 20051213, 20051214, 20051215, 20051216, 20051219, 20051220,
            20051221, 20051222, 20051223, 20051226, 20051227, 20051228, 20051229, 20051230,
            20060104, 20060105, 20060106, 20060109, 20060110, 20060111, 20060112, 20060113,
            20060116, 20060117, 20060118, 20060119, 20060120, 20060123, 20060124, 20060125,
            20060206, 20060207, 20060208, 20060209, 20060210, 20060213, 20060214, 20060215,
            20060216, 20060217, 20060220, 20060221, 20060222, 20060223, 20060224, 20060227,
            20060228, 20060301, 20060302, 20060303, 20060306, 20060307, 20060308, 20060309,
            20060310, 20060313, 20060314, 20060315, 20060316, 20060317, 20060320, 20060321,
            20060322, 20060323, 20060324, 20060327, 20060328, 20060329, 20060330, 20060331,
            20060403, 20060404, 20060405, 20060406, 20060407, 20060410, 20060411, 20060412,
            20060413, 20060414, 20060417, 20060418, 20060419, 20060420, 20060421, 20060424,
            20060425, 20060426, 20060427, 20060428, 20060508, 20060509, 20060510, 20060511,
            20060512, 20060515, 20060516, 20060517, 20060518, 20060519, 20060522, 20060523,
            20060524, 20060525, 20060526, 20060529, 20060530, 20060531, 20060601, 20060602,
            20060605, 20060606, 20060607, 20060608, 20060609, 20060612, 20060613, 20060614,
            20060615, 20060616, 20060619, 20060620, 20060621, 20060622, 20060623, 20060626,
            20060627, 20060628, 20060629, 20060630, 20060703, 20060704, 20060705, 20060706,
            20060707, 20060710, 20060711, 20060712, 20060713, 20060714, 20060717, 20060718,
            20060719, 20060720, 20060721, 20060724, 20060725, 20060726, 20060727, 20060728,
            20060731, 20060801, 20060802, 20060803, 20060804, 20060807, 20060808, 20060809,
            20060810, 20060811, 20060814, 20060815, 20060816, 20060817, 20060818, 20060821,
            20060822, 20060823, 20060824, 20060825, 20060828, 20060829, 20060830, 20060831,
            20060901, 20060904, 20060905, 20060906, 20060907, 20060908, 20060911, 20060912,
            20060913, 20060914, 20060915, 20060918, 20060919, 20060920, 20060921, 20060922,
            20060925, 20060926, 20060927, 20060928, 20060929, 20061009, 20061010, 20061011,
            20061012, 20061013, 20061016, 20061017, 20061018, 20061019, 20061020, 20061023,
            20061024, 20061025, 20061026, 20061027, 20061030, 20061031, 20061101, 20061102,
            20061103, 20061106, 20061107, 20061108, 20061109, 20061110, 20061113, 20061114,
            20061115, 20061116, 20061117, 20061120, 20061121, 20061122, 20061123, 20061124,
            20061127, 20061128, 20061129, 20061130, 20061201, 20061204, 20061205, 20061206,
            20061207, 20061208, 20061211, 20061212, 20061213, 20061214, 20061215, 20061218,
            20061219, 20061220, 20061221, 20061222, 20061225, 20061226, 20061227, 20061228,
            20061229, 20070104, 20070105, 20070108, 20070109, 20070110, 20070111, 20070112,
            20070115, 20070116, 20070117, 20070118, 20070119, 20070122, 20070123, 20070124,
            20070125, 20070126, 20070129, 20070130, 20070131, 20070201, 20070202, 20070205,
            20070206, 20070207, 20070208, 20070209, 20070212, 20070213, 20070214, 20070215,
            20070216, 20070226, 20070227, 20070228, 20070301, 20070302, 20070305, 20070306,
            20070307, 20070308, 20070309, 20070312, 20070313, 20070314, 20070315, 20070316,
            20070319, 20070320, 20070321, 20070322, 20070323, 20070326, 20070327, 20070328,
            20070329, 20070330, 20070402, 20070403, 20070404, 20070405, 20070406, 20070409,
            20070410, 20070411, 20070412, 20070413, 20070416, 20070417, 20070418, 20070419,
            20070420, 20070423, 20070424, 20070425, 20070426, 20070427, 20070430, 20070508,
            20070509, 20070510, 20070511, 20070514, 20070515, 20070516, 20070517, 20070518,
            20070521, 20070522, 20070523, 20070524, 20070525, 20070528, 20070529, 20070530,
            20070531, 20070601, 20070604, 20070605, 20070606, 20070607, 20070608, 20070611,
            20070612, 20070613, 20070614, 20070615, 20070618, 20070619, 20070620, 20070621,
            20070622, 20070625, 20070626, 20070627, 20070628, 20070629, 20070702, 20070703,
            20070704, 20070705, 20070706, 20070709, 20070710, 20070711, 20070712, 20070713,
            20070716, 20070717, 20070718, 20070719, 20070720, 20070723, 20070724, 20070725,
            20070726, 20070727, 20070730, 20070731, 20070801, 20070802, 20070803, 20070806,
            20070807, 20070808, 20070809, 20070810, 20070813, 20070814, 20070815, 20070816,
            20070817, 20070820, 20070821, 20070822, 20070823, 20070824, 20070827, 20070828,
            20070829, 20070830, 20070831, 20070903, 20070904, 20070905, 20070906, 20070907,
            20070910, 20070911, 20070912, 20070913, 20070914, 20070917, 20070918, 20070919,
            20070920, 20070921, 20070924, 20070925, 20070926, 20070927, 20070928, 20071008,
            20071009, 20071010, 20071011, 20071012, 20071015, 20071016, 20071017, 20071018,
            20071019, 20071022, 20071023, 20071024, 20071025, 20071026, 20071029, 20071030,
            20071031, 20071101, 20071102, 20071105, 20071106, 20071107, 20071108, 20071109,
            20071112, 20071113, 20071114, 20071115, 20071116, 20071119, 20071120, 20071121,
            20071122, 20071123, 20071126, 20071127, 20071128, 20071129, 20071130, 20071203,
            20071204, 20071205, 20071206, 20071207, 20071210, 20071211, 20071212, 20071213,
            20071214, 20071217, 20071218, 20071219, 20071220, 20071221, 20071224, 20071225,
            20071226, 20071227, 20071228, 20080102, 20080103, 20080104, 20080107, 20080108,
            20080109, 20080110, 20080111, 20080114, 20080115, 20080116, 20080117, 20080118,
            20080121, 20080122, 20080123, 20080124, 20080125, 20080128, 20080129, 20080130,
            20080131, 20080201, 20080204, 20080205, 20080213, 20080214, 20080215, 20080218,
            20080219, 20080220, 20080221, 20080222, 20080225, 20080226, 20080227, 20080228,
            20080229, 20080303, 20080304, 20080305, 20080306, 20080307, 20080310, 20080311,
            20080312, 20080313, 20080314, 20080317, 20080318, 20080319, 20080320, 20080321,
            20080324, 20080325, 20080326, 20080327, 20080328, 20080331, 20080401, 20080402,
            20080403, 20080407, 20080408, 20080409, 20080410, 20080411, 20080414, 20080415,
            20080416, 20080417, 20080418, 20080421, 20080422, 20080423, 20080424, 20080425,
            20080428, 20080429, 20080430, 20080505, 20080506, 20080507, 20080508, 20080509,
            20080512, 20080513, 20080514, 20080515, 20080516, 20080519, 20080520, 20080521,
            20080522, 20080523, 20080526, 20080527, 20080528, 20080529, 20080530, 20080602,
            20080603, 20080604, 20080605, 20080606, 20080610, 20080611, 20080612, 20080613,
            20080616, 20080617, 20080618, 20080619, 20080620, 20080623, 20080624, 20080625,
            20080626, 20080627, 20080630, 20080701, 20080702, 20080703, 20080704, 20080707,
            20080708, 20080709, 20080710, 20080711, 20080714, 20080715, 20080716, 20080717,
            20080718, 20080721, 20080722, 20080723, 20080724, 20080725, 20080728, 20080729,
            20080730, 20080731, 20080801, 20080804, 20080805, 20080806, 20080807, 20080808,
            20080811, 20080812, 20080813, 20080814, 20080815, 20080818, 20080819, 20080820,
            20080821, 20080822, 20080825, 20080826, 20080827, 20080828, 20080829, 20080901,
            20080902, 20080903, 20080904, 20080905, 20080908, 20080909, 20080910, 20080911,
            20080912, 20080916, 20080917, 20080918, 20080919, 20080922, 20080923, 20080924,
            20080925, 20080926, 20081006, 20081007, 20081008, 20081009, 20081010, 20081013,
            20081014, 20081015, 20081016, 20081017, 20081020, 20081021, 20081022, 20081023,
            20081024, 20081027, 20081028, 20081029, 20081030, 20081031, 20081103, 20081104,
            20081105, 20081106, 20081107, 20081110, 20081111, 20081112, 20081113, 20081114,
            20081117, 20081118, 20081119, 20081120, 20081121, 20081124, 20081125, 20081126,
            20081127, 20081128, 20081201, 20081202, 20081203, 20081204, 20081205, 20081208,
            20081209, 20081210, 20081211, 20081212, 20081215, 20081216, 20081217, 20081218,
            20081219, 20081222, 20081223, 20081224, 20081225, 20081226, 20081229, 20081230,
            20081231, 20090105, 20090106, 20090107, 20090108, 20090109, 20090112, 20090113,
            20090114, 20090115, 20090116, 20090119, 20090120, 20090121, 20090122, 20090123,
            20090202, 20090203, 20090204, 20090205, 20090206, 20090209, 20090210, 20090211,
            20090212, 20090213, 20090216, 20090217, 20090218, 20090219, 20090220, 20090223,
            20090224, 20090225, 20090226, 20090227, 20090302, 20090303, 20090304, 20090305,
            20090306, 20090309, 20090310, 20090311, 20090312, 20090313, 20090316, 20090317,
            20090318, 20090319, 20090320, 20090323, 20090324, 20090325, 20090326, 20090327,
            20090330, 20090331, 20090401, 20090402, 20090403, 20090407, 20090408, 20090409,
            20090410, 20090413, 20090414, 20090415, 20090416, 20090417, 20090420, 20090421,
            20090422, 20090423, 20090424, 20090427, 20090428, 20090429, 20090430, 20090504,
            20090505, 20090506, 20090507, 20090508, 20090511, 20090512, 20090513, 20090514,
            20090515, 20090518, 20090519, 20090520, 20090521, 20090522, 20090525, 20090526,
            20090527, 20090601, 20090602, 20090603, 20090604, 20090605, 20090608, 20090609,
            20090610, 20090611, 20090612, 20090615, 20090616, 20090617, 20090618, 20090619,
            20090622, 20090623, 20090624, 20090625, 20090626, 20090629, 20090630, 20090701,
            20090702, 20090703, 20090706, 20090707, 20090708, 20090709, 20090710, 20090713,
            20090714, 20090715, 20090716, 20090717, 20090720, 20090721, 20090722, 20090723,
            20090724, 20090727, 20090728, 20090729, 20090730, 20090731, 20090803, 20090804,
            20090805, 20090806, 20090807, 20090810, 20090811, 20090812, 20090813, 20090814,
            20090817, 20090818, 20090819, 20090820, 20090821, 20090824, 20090825, 20090826,
            20090827, 20090828, 20090831, 20090901, 20090902, 20090903, 20090904, 20090907,
            20090908, 20090909, 20090910, 20090911, 20090914, 20090915, 20090916, 20090917,
            20090918, 20090921, 20090922, 20090923, 20090924, 20090925, 20090928, 20090929,
            20090930, 20091009, 20091012, 20091013, 20091014, 20091015, 20091016, 20091019,
            20091020, 20091021, 20091022, 20091023, 20091026, 20091027, 20091028, 20091029,
            20091030, 20091102, 20091103, 20091104, 20091105, 20091106, 20091109, 20091110,
            20091111, 20091112, 20091113, 20091116, 20091117, 20091118, 20091119, 20091120,
            20091123, 20091124, 20091125, 20091126, 20091127, 20091130, 20091201, 20091202,
            20091203, 20091204, 20091207, 20091208, 20091209, 20091210, 20091211, 20091214,
            20091215, 20091216, 20091217, 20091218, 20091221, 20091222, 20091223, 20091224,
            20091225, 20091228, 20091229, 20091230, 20091231, 20100104, 20100105, 20100106,
            20100107, 20100108, 20100111, 20100112, 20100113, 20100114, 20100115, 20100118,
            20100119, 20100120, 20100121, 20100122, 20100125, 20100126, 20100127, 20100128,
            20100129, 20100201, 20100202, 20100203, 20100204, 20100205, 20100208, 20100209,
            20100210, 20100211, 20100212, 20100222, 20100223, 20100224, 20100225, 20100226,
            20100301, 20100302, 20100303, 20100304, 20100305, 20100308, 20100309, 20100310,
            20100311, 20100312, 20100315, 20100316, 20100317, 20100318, 20100319, 20100322,
            20100323, 20100324, 20100325, 20100326, 20100329, 20100330, 20100331, 20100401,
            20100402, 20100406, 20100407, 20100408, 20100409, 20100412, 20100413, 20100414,
            20100415, 20100416, 20100419, 20100420, 20100421, 20100422, 20100423, 20100426,
            20100427, 20100428, 20100429, 20100430, 20100504, 20100505, 20100506, 20100507,
            20100510, 20100511, 20100512, 20100513, 20100514, 20100517, 20100518, 20100519,
            20100520, 20100521, 20100524, 20100525, 20100526, 20100527, 20100528, 20100531,
            20100601, 20100602, 20100603, 20100604, 20100607, 20100608, 20100609, 20100610,
            20100611, 20100617, 20100618, 20100621, 20100622, 20100623, 20100624, 20100625,
            20100628, 20100629, 20100630, 20100701, 20100702, 20100705, 20100706, 20100707,
            20100708, 20100709, 20100712, 20100713, 20100714, 20100715, 20100716, 20100719,
            20100720, 20100721, 20100722, 20100723, 20100726, 20100727, 20100728, 20100729,
            20100730, 20100802, 20100803, 20100804, 20100805, 20100806, 20100809, 20100810,
            20100811, 20100812, 20100813, 20100816, 20100817, 20100818, 20100819, 20100820,
            20100823, 20100824, 20100825, 20100826, 20100827, 20100830, 20100831, 20100901,
            20100902, 20100903, 20100906, 20100907, 20100908, 20100909, 20100910, 20100913,
            20100914, 20100915, 20100916, 20100917, 20100920, 20100921, 20100927, 20100928,
            20100929, 20100930, 20101008, 20101011, 20101012, 20101013, 20101014, 20101015,
            20101018, 20101019, 20101020, 20101021, 20101022, 20101025, 20101026, 20101027,
            20101028, 20101029, 20101101, 20101102, 20101103, 20101104, 20101105, 20101108,
            20101109, 20101110, 20101111, 20101112, 20101115, 20101116, 20101117, 20101118,
            20101119, 20101122, 20101123, 20101124, 20101125, 20101126, 20101129, 20101130,
            20101201, 20101202, 20101203, 20101206, 20101207, 20101208, 20101209, 20101210,
            20101213, 20101214, 20101215, 20101216, 20101217, 20101220, 20101221, 20101222,
            20101223, 20101224, 20101227, 20101228, 20101229, 20101230, 20101231, 20110104,
            20110105, 20110106, 20110107, 20110110, 20110111, 20110112, 20110113, 20110114,
            20110117, 20110118, 20110119, 20110120, 20110121, 20110124, 20110125, 20110126,
            20110127, 20110128, 20110131, 20110201, 20110209, 20110210, 20110211, 20110214,
            20110215, 20110216, 20110217, 20110218, 20110221, 20110222, 20110223, 20110224,
            20110225, 20110228, 20110301, 20110302, 20110303, 20110304, 20110307, 20110308,
            20110309, 20110310, 20110311, 20110314, 20110315, 20110316, 20110317, 20110318,
            20110321, 20110322, 20110323, 20110324, 20110325, 20110328, 20110329, 20110330,
            20110331, 20110401, 20110406, 20110407, 20110408, 20110411, 20110412, 20110413,
            20110414, 20110415, 20110418, 20110419, 20110420, 20110421, 20110422, 20110425,
            20110426, 20110427, 20110428, 20110429, 20110503, 20110504, 20110505, 20110506,
            20110509, 20110510, 20110511, 20110512, 20110513, 20110516, 20110517, 20110518,
            20110519, 20110520, 20110523, 20110524, 20110525, 20110526, 20110527, 20110530,
            20110531, 20110601, 20110602, 20110603, 20110607, 20110608, 20110609, 20110610,
            20110613, 20110614, 20110615, 20110616, 20110617, 20110620, 20110621, 20110622,
            20110623, 20110624, 20110627, 20110628, 20110629, 20110630, 20110701, 20110704,
            20110705, 20110706, 20110707, 20110708, 20110711, 20110712, 20110713, 20110714,
            20110715, 20110718, 20110719, 20110720, 20110721, 20110722, 20110725, 20110726,
            20110727, 20110728, 20110729, 20110801, 20110802, 20110803, 20110804, 20110805,
            20110808, 20110809, 20110810, 20110811, 20110812, 20110815, 20110816, 20110817,
            20110818, 20110819, 20110822, 20110823, 20110824, 20110825, 20110826, 20110829,
            20110830, 20110831, 20110901, 20110902, 20110905, 20110906, 20110907, 20110908,
            20110909, 20110913, 20110914, 20110915, 20110916, 20110919, 20110920, 20110921,
            20110922, 20110923, 20110926, 20110927, 20110928, 20110929, 20110930, 20111010,
            20111011, 20111012, 20111013, 20111014, 20111017, 20111018, 20111019, 20111020,
            20111021, 20111024, 20111025, 20111026, 20111027, 20111028, 20111031, 20111101,
            20111102, 20111103, 20111104, 20111107, 20111108, 20111109, 20111110, 20111111,
            20111114, 20111115, 20111116, 20111117, 20111118, 20111121, 20111122, 20111123,
            20111124, 20111125, 20111128, 20111129, 20111130, 20111201, 20111202, 20111205,
            20111206, 20111207, 20111208, 20111209, 20111212, 20111213, 20111214, 20111215,
            20111216, 20111219, 20111220, 20111221, 20111222, 20111223, 20111226, 20111227,
            20111228, 20111229, 20111230, 20120104, 20120105, 20120106, 20120109, 20120110,
            20120111, 20120112, 20120113, 20120116, 20120117, 20120118, 20120119, 20120120,
            20120130, 20120131, 20120201, 20120202, 20120203, 20120206, 20120207, 20120208,
            20120209, 20120210, 20120213, 20120214, 20120215, 20120216, 20120217, 20120220,
            20120221, 20120222, 20120223, 20120224, 20120227, 20120228, 20120229, 20120301,
            20120302, 20120305, 20120306, 20120307, 20120308, 20120309, 20120312, 20120313,
            20120314, 20120315, 20120316, 20120319, 20120320, 20120321, 20120322, 20120323,
            20120326, 20120327, 20120328, 20120329, 20120330, 20120405, 20120406, 20120409,
            20120410, 20120411, 20120412, 20120413, 20120416, 20120417, 20120418, 20120419,
            20120420, 20120423, 20120424, 20120425, 20120426, 20120427, 20120502, 20120503,
            20120504, 20120507, 20120508, 20120509, 20120510, 20120511, 20120514, 20120515,
            20120516, 20120517, 20120518, 20120521, 20120522, 20120523, 20120524, 20120525,
            20120528, 20120529, 20120530, 20120531, 20120601, 20120604, 20120605, 20120606,
            20120607, 20120608, 20120611, 20120612, 20120613, 20120614, 20120615, 20120618,
            20120619, 20120620, 20120621, 20120625, 20120626, 20120627, 20120628, 20120629,
            20120702, 20120703, 20120704, 20120705, 20120706, 20120709, 20120710, 20120711,
            20120712, 20120713, 20120716, 20120717, 20120718, 20120719, 20120720, 20120723,
            20120724, 20120725, 20120726, 20120727, 20120730, 20120731, 20120801, 20120802,
            20120803, 20120806, 20120807, 20120808, 20120809, 20120810, 20120813, 20120814,
            20120815, 20120816, 20120817, 20120820, 20120821, 20120822, 20120823, 20120824,
            20120827, 20120828, 20120829, 20120830, 20120831, 20120903, 20120904, 20120905,
            20120906, 20120907, 20120910, 20120911, 20120912, 20120913, 20120914, 20120917,
            20120918, 20120919, 20120920, 20120921, 20120924, 20120925, 20120926, 20120927,
            20120928, 20121008, 20121009, 20121010, 20121011, 20121012, 20121015, 20121016,
            20121017, 20121018, 20121019, 20121022, 20121023, 20121024, 20121025, 20121026,
            20121029, 20121030, 20121031, 20121101, 20121102, 20121105, 20121106, 20121107,
            20121108, 20121109, 20121112, 20121113, 20121114, 20121115, 20121116, 20121119,
            20121120, 20121121, 20121122, 20121123, 20121126, 20121127, 20121128, 20121129,
            20121130, 20121203, 20121204, 20121205, 20121206, 20121207, 20121210, 20121211,
            20121212, 20121213, 20121214, 20121217, 20121218, 20121219, 20121220, 20121221,
            20121224, 20121225, 20121226, 20121227, 20121228, 20121231, 20130104, 20130107,
            20130108, 20130109, 20130110, 20130111, 20130114, 20130115, 20130116, 20130117,
            20130118, 20130121, 20130122, 20130123, 20130124, 20130125, 20130128, 20130129,
            20130130, 20130131, 20130201, 20130204, 20130205, 20130206, 20130207, 20130208,
            20130218, 20130219, 20130220, 20130221, 20130222, 20130225, 20130226, 20130227,
            20130228, 20130301, 20130304, 20130305, 20130306, 20130307, 20130308, 20130311,
            20130312, 20130313, 20130314, 20130315, 20130318, 20130319, 20130320, 20130321,
            20130322, 20130325, 20130326, 20130327, 20130328, 20130329, 20130401, 20130402,
            20130403, 20130408, 20130409, 20130410, 20130411, 20130412, 20130415, 20130416,
            20130417, 20130418, 20130419, 20130422, 20130423, 20130424, 20130425, 20130426,
            20130502, 20130503, 20130506, 20130507, 20130508, 20130509, 20130510, 20130513,
            20130514, 20130515, 20130516, 20130517, 20130520, 20130521, 20130522, 20130523,
            20130524, 20130527, 20130528, 20130529, 20130530, 20130531, 20130603, 20130604,
            20130605, 20130606, 20130607, 20130613, 20130614, 20130617, 20130618, 20130619,
            20130620, 20130621, 20130624, 20130625, 20130626, 20130627, 20130628, 20130701,
            20130702, 20130703, 20130704, 20130705, 20130708, 20130709, 20130710, 20130711,
            20130712, 20130715, 20130716, 20130717, 20130718, 20130719, 20130722, 20130723,
            20130724, 20130725, 20130726, 20130729, 20130730, 20130731, 20130801, 20130802,
            20130805, 20130806, 20130807, 20130808, 20130809, 20130812, 20130813, 20130814,
            20130815, 20130816, 20130819, 20130820, 20130821, 20130822, 20130823, 20130826,
            20130827, 20130828, 20130829, 20130830, 20130902, 20130903, 20130904, 20130905,
            20130906, 20130909, 20130910, 20130911, 20130912, 20130913, 20130916, 20130917,
            20130918, 20130923, 20130924, 20130925, 20130926, 20130927, 20130930, 20131008,
            20131009, 20131010, 20131011, 20131014, 20131015, 20131016, 20131017, 20131018,
            20131021, 20131022, 20131023, 20131024, 20131025, 20131028, 20131029, 20131030,
            20131031, 20131101, 20131104, 20131105, 20131106, 20131107, 20131108, 20131111,
            20131112, 20131113, 20131114, 20131115, 20131118, 20131119, 20131120, 20131121,
            20131122, 20131125, 20131126, 20131127, 20131128, 20131129, 20131202, 20131203,
            20131204, 20131205, 20131206, 20131209, 20131210, 20131211, 20131212, 20131213,
            20131216, 20131217, 20131218, 20131219, 20131220, 20131223, 20131224, 20131225,
            20131226, 20131227, 20131230, 20131231, 20140102, 20140103, 20140106, 20140107,
            20140108, 20140109, 20140110, 20140113, 20140114, 20140115, 20140116, 20140117,
            20140120, 20140121, 20140122, 20140123, 20140124, 20140127, 20140128, 20140129,
            20140130, 20140207, 20140210, 20140211, 20140212, 20140213, 20140214, 20140217,
            20140218, 20140219, 20140220, 20140221, 20140224, 20140225, 20140226, 20140227,
            20140228, 20140303, 20140304, 20140305, 20140306, 20140307, 20140310, 20140311,
            20140312, 20140313, 20140314, 20140317, 20140318, 20140319, 20140320, 20140321,
            20140324, 20140325, 20140326, 20140327, 20140328, 20140331, 20140401, 20140402,
            20140403, 20140404, 20140408, 20140409, 20140410, 20140411, 20140414, 20140415,
            20140416, 20140417, 20140418, 20140421, 20140422, 20140423, 20140424, 20140425,
            20140428, 20140429, 20140430, 20140505, 20140506, 20140507, 20140508, 20140509,
            20140512, 20140513, 20140514, 20140515, 20140516, 20140519, 20140520, 20140521,
            20140522, 20140523, 20140526, 20140527, 20140528, 20140529, 20140530, 20140603,
            20140604, 20140605, 20140606, 20140609, 20140610, 20140611, 20140612, 20140613,
            20140616, 20140617, 20140618, 20140619, 20140620, 20140623, 20140624, 20140625,
            20140626, 20140627, 20140630, 20140701, 20140702, 20140703, 20140704, 20140707,
            20140708, 20140709, 20140710, 20140711, 20140714, 20140715, 20140716, 20140717,
            20140718, 20140721, 20140722, 20140723, 20140724, 20140725, 20140728, 20140729,
            20140730, 20140731, 20140801, 20140804, 20140805, 20140806, 20140807, 20140808,
            20140811, 20140812, 20140813, 20140814, 20140815, 20140818, 20140819, 20140820,
            20140821, 20140822, 20140825, 20140826, 20140827, 20140828, 20140829, 20140901,
            20140902, 20140903, 20140904, 20140905, 20140909, 20140910, 20140911, 20140912,
            20140915, 20140916, 20140917, 20140918, 20140919, 20140922, 20140923, 20140924,
            20140925, 20140926, 20140929, 20140930, 20141008, 20141009, 20141010, 20141013,
            20141014, 20141015, 20141016, 20141017, 20141020, 20141021, 20141022, 20141023,
            20141024, 20141027, 20141028, 20141029, 20141030, 20141031, 20141103, 20141104,
            20141105, 20141106, 20141107, 20141110, 20141111, 20141112, 20141113, 20141114,
            20141117, 20141118, 20141119, 20141120, 20141121, 20141124, 20141125, 20141126,
            20141127, 20141128, 20141201, 20141202, 20141203, 20141204, 20141205, 20141208,
            20141209, 20141210, 20141211, 20141212, 20141215, 20141216, 20141217, 20141218,
            20141219, 20141222, 20141223, 20141224, 20141225, 20141226, 20141229, 20141230,
            20141231, 20150105, 20150106, 20150107, 20150108, 20150109, 20150112, 20150113,
            20150114, 20150115, 20150116, 20150119, 20150120, 20150121, 20150122, 20150123,
            20150126, 20150127, 20150128, 20150129, 20150130, 20150202, 20150203, 20150204,
            20150205, 20150206, 20150209, 20150210, 20150211, 20150212, 20150213, 20150216,
            20150217, 20150225, 20150226, 20150227, 20150302, 20150303, 20150304, 20150305,
            20150306, 20150309, 20150310, 20150311, 20150312, 20150313, 20150316, 20150317,
            20150318, 20150319, 20150320, 20150323, 20150324, 20150325, 20150326, 20150327,
            20150330, 20150331, 20150401, 20150402, 20150403, 20150407, 20150408, 20150409,
            20150410, 20150413, 20150414, 20150415, 20150416, 20150417, 20150420, 20150421,
            20150422, 20150423, 20150424, 20150427, 20150428, 20150429, 20150430, 20150504,
            20150505, 20150506, 20150507, 20150508, 20150511, 20150512, 20150513, 20150514,
            20150515, 20150518, 20150519, 20150520, 20150521, 20150522, 20150525, 20150526,
            20150527, 20150528, 20150529, 20150601, 20150602, 20150603, 20150604, 20150605,
            20150608, 20150609, 20150610, 20150611, 20150612, 20150615, 20150616, 20150617,
            20150618, 20150619, 20150623, 20150624, 20150625, 20150626, 20150629, 20150630,
            20150701, 20150702, 20150703, 20150706, 20150707, 20150708, 20150709, 20150710,
            20150713, 20150714, 20150715, 20150716, 20150717, 20150720, 20150721, 20150722,
            20150723, 20150724, 20150727, 20150728, 20150729, 20150730, 20150731, 20150803,
            20150804, 20150805, 20150806, 20150807, 20150810, 20150811, 20150812, 20150813,
            20150814, 20150817, 20150818, 20150819, 20150820, 20150821, 20150824, 20150825,
            20150826, 20150827, 20150828, 20150831, 20150901, 20150902, 20150907, 20150908,
            20150909, 20150910, 20150911, 20150914, 20150915, 20150916, 20150917, 20150918,
            20150921, 20150922, 20150923, 20150924, 20150925, 20150928, 20150929, 20150930,
            20151008, 20151009, 20151012, 20151013, 20151014, 20151015, 20151016, 20151019,
            20151020, 20151021, 20151022, 20151023, 20151026, 20151027, 20151028, 20151029,
            20151030, 20151102, 20151103, 20151104, 20151105, 20151106, 20151109, 20151110,
            20151111, 20151112, 20151113, 20151116, 20151117, 20151118, 20151119, 20151120,
            20151123, 20151124, 20151125, 20151126, 20151127, 20151130, 20151201, 20151202,
            20151203, 20151204, 20151207, 20151208, 20151209, 20151210, 20151211, 20151214,
            20151215, 20151216, 20151217, 20151218, 20151221, 20151222, 20151223, 20151224,
            20151225, 20151228, 20151229, 20151230, 20151231, 20160104, 20160105, 20160106,
            20160107, 20160108, 20160111, 20160112, 20160113, 20160114, 20160115, 20160118,
            20160119, 20160120, 20160121, 20160122, 20160125, 20160126, 20160127, 20160128,
            20160129, 20160201, 20160202, 20160203, 20160204, 20160205, 20160215, 20160216,
            20160217, 20160218, 20160219, 20160222, 20160223, 20160224, 20160225, 20160226,
            20160229, 20160301, 20160302, 20160303, 20160304, 20160307, 20160308, 20160309,
            20160310, 20160311, 20160314, 20160315, 20160316, 20160317, 20160318, 20160321,
            20160322, 20160323, 20160324, 20160325, 20160328, 20160329, 20160330, 20160331,
            20160401, 20160405, 20160406, 20160407, 20160408, 20160411, 20160412, 20160413,
            20160414, 20160415, 20160418, 20160419, 20160420, 20160421, 20160422, 20160425,
            20160426, 20160427, 20160428, 20160429, 20160503, 20160504, 20160505, 20160506,
            20160509, 20160510, 20160511, 20160512, 20160513, 20160516, 20160517, 20160518,
            20160519, 20160520, 20160523, 20160524, 20160525, 20160526, 20160527, 20160530,
            20160531, 20160601, 20160602, 20160603, 20160606, 20160607, 20160608, 20160613,
            20160614, 20160615, 20160616, 20160617, 20160620, 20160621, 20160622, 20160623,
            20160624, 20160627, 20160628, 20160629, 20160630, 20160701, 20160704, 20160705,
            20160706, 20160707, 20160708, 20160711, 20160712, 20160713, 20160714, 20160715,
            20160718, 20160719, 20160720, 20160721, 20160722, 20160725, 20160726, 20160727,
            20160728, 20160729, 20160801, 20160802, 20160803, 20160804, 20160805, 20160808,
            20160809, 20160810, 20160811, 20160812, 20160815, 20160816, 20160817, 20160818,
            20160819, 20160822, 20160823, 20160824, 20160825, 20160826, 20160829, 20160830,
            20160831, 20160901, 20160902, 20160905, 20160906, 20160907, 20160908, 20160909,
            20160912, 20160913, 20160914, 20160919, 20160920, 20160921, 20160922, 20160923,
            20160926, 20160927, 20160928, 20160929, 20160930, 20161010, 20161011, 20161012,
            20161013, 20161014, 20161017, 20161018, 20161019, 20161020, 20161021, 20161024,
            20161025, 20161026, 20161027, 20161028, 20161031, 20161101, 20161102, 20161103,
            20161104, 20161107, 20161108, 20161109, 20161110, 20161111, 20161114, 20161115,
            20161116, 20161117, 20161118, 20161121, 20161122, 20161123, 20161124, 20161125,
            20161128, 20161129, 20161130, 20161201, 20161202, 20161205, 20161206, 20161207,
            20161208, 20161209, 20161212, 20161213, 20161214, 20161215, 20161216, 20161219,
            20161220, 20161221, 20161222, 20161223, 20161226, 20161227, 20161228, 20161229,
            20161230, 20170103, 20170104, 20170105, 20170106, 20170109, 20170110, 20170111,
            20170112, 20170113, 20170116, 20170117, 20170118, 20170119, 20170120, 20170123,
            20170124, 20170125, 20170126, 20170203, 20170206, 20170207, 20170208, 20170209,
            20170210, 20170213, 20170214, 20170215, 20170216, 20170217, 20170220, 20170221,
            20170222, 20170223, 20170224, 20170227, 20170228, 20170301, 20170302, 20170303,
            20170306, 20170307, 20170308, 20170309, 20170310, 20170313, 20170314, 20170315,
            20170316, 20170317, 20170320, 20170321, 20170322, 20170323, 20170324, 20170327,
            20170328, 20170329, 20170330, 20170331, 20170405, 20170406, 20170407, 20170410,
            20170411, 20170412, 20170413, 20170414, 20170417, 20170418, 20170419, 20170420,
            20170421, 20170424, 20170425, 20170426, 20170427, 20170428, 20170502, 20170503,
            20170504, 20170505, 20170508, 20170509, 20170510, 20170511, 20170512, 20170515,
            20170516, 20170517, 20170518, 20170519, 20170522, 20170523, 20170524, 20170525,
            20170526, 20170531, 20170601, 20170602, 20170605, 20170606, 20170607, 20170608,
            20170609, 20170612, 20170613, 20170614, 20170615, 20170616, 20170619, 20170620,
            20170621, 20170622, 20170623, 20170626, 20170627, 20170628, 20170629, 20170630,
            20170703, 20170704, 20170705, 20170706, 20170707, 20170710, 20170711, 20170712,
            20170713, 20170714, 20170717, 20170718, 20170719, 20170720, 20170721, 20170724,
            20170725, 20170726, 20170727, 20170728, 20170731, 20170801, 20170802, 20170803,
            20170804, 20170807, 20170808, 20170809, 20170810, 20170811, 20170814, 20170815,
            20170816, 20170817, 20170818, 20170821, 20170822, 20170823, 20170824, 20170825,
            20170828, 20170829, 20170830, 20170831, 20170901, 20170904, 20170905, 20170906,
            20170907, 20170908, 20170911, 20170912, 20170913, 20170914, 20170915, 20170918,
            20170919, 20170920, 20170921, 20170922, 20170925, 20170926, 20170927, 20170928,
            20170929, 20171009, 20171010, 20171011, 20171012, 20171013, 20171016, 20171017,
            20171018, 20171019, 20171020, 20171023, 20171024, 20171025, 20171026, 20171027,
            20171030, 20171031, 20171101, 20171102, 20171103, 20171106, 20171107, 20171108,
            20171109, 20171110, 20171113, 20171114, 20171115, 20171116, 20171117, 20171120,
            20171121, 20171122, 20171123, 20171124, 20171127, 20171128, 20171129, 20171130,
            20171201, 20171204, 20171205, 20171206, 20171207, 20171208, 20171211, 20171212,
            20171213, 20171214, 20171215, 20171218, 20171219, 20171220, 20171221, 20171222,
            20171225, 20171226, 20171227, 20171228, 20171229, 20180102, 20180103, 20180104,
            20180105, 20180108, 20180109, 20180110, 20180111, 20180112, 20180115, 20180116,
            20180117, 20180118, 20180119, 20180122, 20180123, 20180124, 20180125, 20180126,
            20180129, 20180130, 20180131, 20180201, 20180202, 20180205, 20180206, 20180207,
            20180208, 20180209, 20180212, 20180213, 20180214, 20180222, 20180223, 20180226,
            20180227, 20180228, 20180301, 20180302, 20180305, 20180306, 20180307, 20180308,
            20180309, 20180312, 20180313, 20180314, 20180315, 20180316, 20180319, 20180320,
            20180321, 20180322, 20180323, 20180326, 20180327, 20180328, 20180329, 20180330,
            20180402, 20180403, 20180404, 20180409, 20180410, 20180411, 20180412, 20180413,
            20180416, 20180417, 20180418, 20180419, 20180420, 20180423, 20180424, 20180425,
            20180426, 20180427, 20180502, 20180503, 20180504, 20180507, 20180508, 20180509,
            20180510, 20180511, 20180514, 20180515, 20180516, 20180517, 20180518, 20180521,
            20180522, 20180523, 20180524, 20180525, 20180528, 20180529, 20180530, 20180531,
            20180601, 20180604, 20180605, 20180606, 20180607, 20180608, 20180611, 20180612,
            20180613, 20180614, 20180615, 20180619, 20180620, 20180621, 20180622, 20180625,
            20180626, 20180627, 20180628, 20180629, 20180702, 20180703, 20180704, 20180705,
            20180706, 20180709, 20180710, 20180711, 20180712, 20180713, 20180716, 20180717,
            20180718, 20180719, 20180720, 20180723, 20180724, 20180725, 20180726, 20180727,
            20180730, 20180731, 20180801, 20180802, 20180803, 20180806, 20180807, 20180808,
            20180809, 20180810, 20180813, 20180814, 20180815, 20180816, 20180817, 20180820,
            20180821, 20180822, 20180823, 20180824, 20180827, 20180828, 20180829, 20180830,
            20180831, 20180903, 20180904, 20180905, 20180906, 20180907, 20180910, 20180911,
            20180912, 20180913, 20180914, 20180917, 20180918, 20180919, 20180920, 20180921,
            20180925, 20180926, 20180927, 20180928, 20181008, 20181009, 20181010, 20181011,
            20181012, 20181015, 20181016, 20181017, 20181018, 20181019, 20181022, 20181023,
            20181024, 20181025, 20181026, 20181029, 20181030, 20181031, 20181101, 20181102,
            20181105, 20181106, 20181107, 20181108, 20181109, 20181112, 20181113, 20181114,
            20181115, 20181116, 20181119, 20181120, 20181121, 20181122, 20181123, 20181126,
            20181127, 20181128, 20181129, 20181130, 20181203, 20181204, 20181205, 20181206,
            20181207, 20181210, 20181211, 20181212, 20181213, 20181214, 20181217, 20181218,
            20181219, 20181220, 20181221, 20181224, 20181225, 20181226, 20181227, 20181228,
            20190102, 20190103, 20190104, 20190107, 20190108, 20190109, 20190110, 20190111,
            20190114, 20190115, 20190116, 20190117, 20190118, 20190121, 20190122, 20190123,
            20190124, 20190125, 20190128, 20190129, 20190130, 20190131, 20190201, 20190211,
            20190212, 20190213, 20190214, 20190215, 20190218, 20190219, 20190220, 20190221,
            20190222, 20190225, 20190226, 20190227, 20190228, 20190301, 20190304, 20190305,
            20190306, 20190307, 20190308, 20190311, 20190312, 20190313, 20190314, 20190315,
            20190318, 20190319, 20190320, 20190321, 20190322, 20190325, 20190326, 20190327,
            20190328, 20190329, 20190401, 20190402, 20190403, 20190404, 20190408, 20190409,
            20190410, 20190411, 20190412, 20190415, 20190416, 20190417, 20190418, 20190419,
            20190422, 20190423, 20190424, 20190425, 20190426, 20190429, 20190430, 20190506,
            20190507, 20190508, 20190509, 20190510, 20190513, 20190514, 20190515, 20190516,
            20190517, 20190520, 20190521, 20190522, 20190523, 20190524, 20190527, 20190528,
            20190529, 20190530, 20190531, 20190603, 20190604, 20190605, 20190606, 20190610,
            20190611, 20190612, 20190613, 20190614, 20190617, 20190618, 20190619, 20190620,
            20190621, 20190624, 20190625, 20190626, 20190627, 20190628, 20190701, 20190702,
            20190703, 20190704, 20190705, 20190708, 20190709, 20190710, 20190711, 20190712,
            20190715, 20190716, 20190717, 20190718, 20190719, 20190722, 20190723, 20190724,
            20190725, 20190726, 20190729, 20190730, 20190731, 20190801, 20190802, 20190805,
            20190806, 20190807, 20190808, 20190809, 20190812, 20190813, 20190814, 20190815,
            20190816, 20190819, 20190820, 20190821, 20190822, 20190823, 20190826, 20190827,
            20190828, 20190829, 20190830, 20190902, 20190903, 20190904, 20190905, 20190906,
            20190909, 20190910, 20190911, 20190912, 20190916, 20190917, 20190918, 20190919,
            20190920, 20190923, 20190924, 20190925, 20190926, 20190927, 20190930, 20191008,
            20191009, 20191010, 20191011, 20191014, 20191015, 20191016, 20191017, 20191018,
            20191021, 20191022, 20191023, 20191024, 20191025, 20191028, 20191029, 20191030,
            20191031, 20191101, 20191104, 20191105, 20191106, 20191107, 20191108, 20191111,
            20191112, 20191113, 20191114, 20191115, 20191118, 20191119, 20191120, 20191121,
            20191122, 20191125, 20191126, 20191127, 20191128, 20191129, 20191202, 20191203,
            20191204, 20191205, 20191206, 20191209, 20191210, 20191211, 20191212, 20191213,
            20191216, 20191217, 20191218, 20191219, 20191220, 20191223, 20191224, 20191225,
            20191226, 20191227, 20191230, 20191231, 20200102, 20200103, 20200106, 20200107,
            20200108, 20200109, 20200110, 20200113, 20200114, 20200115, 20200116, 20200117,
            20200120, 20200121, 20200122, 20200123, 20200203, 20200204, 20200205, 20200206,
            20200207, 20200210, 20200211, 20200212, 20200213, 20200214, 20200217, 20200218,
            20200219, 20200220, 20200221, 20200224, 20200225, 20200226, 20200227, 20200228,
            20200302, 20200303, 20200304, 20200305, 20200306, 20200309, 20200310, 20200311,
            20200312, 20200313, 20200316, 20200317, 20200318, 20200319, 20200320, 20200323,
            20200324, 20200325, 20200326, 20200327, 20200330, 20200331, 20200401, 20200402,
            20200403, 20200407, 20200408, 20200409, 20200410, 20200413, 20200414, 20200415,
            20200416, 20200417, 20200420, 20200421, 20200422, 20200423, 20200424, 20200427,
            20200428, 20200429, 20200430, 20200506, 20200507, 20200508, 20200511, 20200512,
            20200513, 20200514, 20200515, 20200518, 20200519, 20200520, 20200521, 20200522,
            20200525, 20200526, 20200527, 20200528, 20200529, 20200601, 20200602, 20200603,
            20200604, 20200605, 20200608, 20200609, 20200610, 20200611, 20200612, 20200615,
            20200616, 20200617, 20200618, 20200619, 20200622, 20200623, 20200624, 20200629,
            20200630, 20200701, 20200702, 20200703, 20200706, 20200707, 20200708, 20200709,
            20200710, 20200713, 20200714, 20200715, 20200716, 20200717, 20200720, 20200721,
            20200722, 20200723, 20200724, 20200727, 20200728, 20200729, 20200730, 20200731,
            20200803, 20200804, 20200805, 20200806, 20200807, 20200810, 20200811, 20200812,
            20200813, 20200814, 20200817, 20200818, 20200819, 20200820, 20200821, 20200824,
            20200825, 20200826, 20200827, 20200828, 20200831, 20200901, 20200902, 20200903,
            20200904, 20200907, 20200908, 20200909, 20200910, 20200911, 20200914, 20200915,
            20200916, 20200917, 20200918, 20200921, 20200922, 20200923, 20200924, 20200925,
            20200928, 20200929, 20200930, 20201009, 20201012, 20201013, 20201014, 20201015,
            20201016, 20201019, 20201020, 20201021, 20201022, 20201023, 20201026, 20201027,
            20201028, 20201029, 20201030, 20201102, 20201103, 20201104, 20201105, 20201106,
            20201109, 20201110, 20201111, 20201112, 20201113, 20201116, 20201117, 20201118,
            20201119, 20201120, 20201123, 20201124, 20201125, 20201126, 20201127, 20201130,
            20201201, 20201202, 20201203, 20201204, 20201207, 20201208, 20201209, 20201210,
            20201211, 20201214, 20201215, 20201216, 20201217, 20201218, 20201221, 20201222,
            20201223, 20201224, 20201225, 20201228, 20201229, 20201230, 20201231, 20210104,
            20210105, 20210106, 20210107, 20210108, 20210111, 20210112, 20210113, 20210114,
            20210115, 20210118, 20210119, 20210120, 20210121, 20210122, 20210125, 20210126,
            20210127, 20210128, 20210129, 20210201, 20210202, 20210203, 20210204, 20210205,
            20210208, 20210209, 20210210, 20210218, 20210219, 20210222, 20210223, 20210224,
            20210225, 20210226, 20210301, 20210302, 20210303, 20210304, 20210305, 20210308,
            20210309, 20210310, 20210311, 20210312, 20210315, 20210316, 20210317, 20210318,
            20210319, 20210322, 20210323, 20210324, 20210325, 20210326, 20210329, 20210330,
            20210331, 20210401, 20210402, 20210406, 20210407, 20210408, 20210409, 20210412,
            20210413, 20210414, 20210415, 20210416, 20210419, 20210420, 20210421, 20210422,
            20210423, 20210426, 20210427, 20210428, 20210429, 20210430, 20210506, 20210507,
            20210510, 20210511, 20210512, 20210513, 20210514, 20210517, 20210518, 20210519,
            20210520, 20210521, 20210524, 20210525, 20210526, 20210527, 20210528, 20210531,
            20210601, 20210602, 20210603, 20210604, 20210607, 20210608, 20210609, 20210610,
            20210611, 20210615, 20210616, 20210617, 20210618, 20210621, 20210622, 20210623,
            20210624, 20210625, 20210628, 20210629, 20210630, 20210701, 20210702, 20210705,
            20210706, 20210707, 20210708, 20210709, 20210712, 20210713, 20210714, 20210715,
            20210716, 20210719, 20210720, 20210721, 20210722, 20210723, 20210726, 20210727,
            20210728, 20210729, 20210730, 20210802, 20210803, 20210804, 20210805, 20210806,
            20210809, 20210810, 20210811, 20210812, 20210813, 20210816, 20210817, 20210818,
            20210819, 20210820, 20210823, 20210824, 20210825, 20210826, 20210827, 20210830,
            20210831, 20210901, 20210902, 20210903, 20210906, 20210907, 20210908, 20210909,
            20210910, 20210913, 20210914, 20210915, 20210916, 20210917, 20210920, 20210922,
            20210923, 20210924, 20210927, 20210928, 20210929, 20210930, 20211008, 20211011,
            20211012, 20211013, 20211014, 20211015, 20211018, 20211019, 20211020, 20211021,
            20211022, 20211025, 20211026, 20211027, 20211028, 20211029, 20211101, 20211102,
            20211103, 20211104, 20211105, 20211108, 20211109, 20211110, 20211111, 20211112,
            20211115, 20211116, 20211117, 20211118, 20211119, 20211122, 20211123, 20211124,
            20211125, 20211126, 20211129, 20211130, 20211201, 20211202, 20211203, 20211206,
            20211207, 20211208, 20211209, 20211210, 20211213, 20211214, 20211215, 20211216,
            20211217, 20211220, 20211221, 20211222, 20211223, 20211224, 20211227, 20211228,
            20211229, 20211230, 20211231,
        ];

        QATradeDate { trade_date }
    }
    pub fn get_index(&mut self, start: &str, end: &str) -> Vec<i32> {
        let startint = self.to_i32(start);
        let endint = self.to_i32(end);

        let s = self.trade_date.iter().position(|x| x >= &startint).unwrap();

        let e = self.trade_date.iter().position(|x| x > &endint).unwrap();
        let res = &self.trade_date[s..e];
        res.to_vec()
    }

    pub fn to_i32(&mut self, date: &str) -> i32 {
        let u: i32 = date.replace('-', "").parse::<i32>().unwrap();
        u
    }
    pub fn to_string(&mut self, date: i32) -> String {
        let year = date / 10000;
        let month = (date - year * 10000) / 100;
        let day = (date - year * 10000 - month * 100);
        let month_1 = if month < 10 {
            format!("0{}", month)
        } else {
            format!("{}", month)
        };
        let day_1 = if day < 10 {
            format!("0{}", day)
        } else {
            format!("{}", day)
        };

        let u = format!("{}-{}-{}", year, month_1, day_1);
        u
    }
    pub fn if_trade_date(&mut self, date: &str) -> bool {
        let u = self.to_i32(date);
        if self.trade_date.contains(&u) {
            true
        } else {
            false
        }
    }

    pub fn get_real_date(&mut self, date: &str) -> String {
        let realdate: String;

        if self.if_trade_date(date) {
            realdate = date.to_string()
        } else {
            realdate = self.get_last_day(date)
        }
        realdate
    }

    pub fn get_next_day(&mut self, date: &str) -> String {
        let ur = self.to_i32(date);

        let u = self.trade_date.iter().position(|x| x >= &ur).unwrap();

        let mut res = 0;
        if self.trade_date.contains(&ur) {
            res = self.trade_date.get_mut(u + 1).unwrap().to_owned();
        } else {
            res = self.trade_date.get_mut(u).unwrap().to_owned();
        }
        self.to_string(res)
    }
    pub fn get_last_day(&mut self, date: &str) -> String {
        let ur = self.to_i32(date);
        let u = self.trade_date.iter().position(|x| x >= &ur).unwrap();
        let mut res = 0;
        res = self.trade_date.get_mut(u - 1).unwrap().to_owned();
        self.to_string(res)
    }
    pub fn get_next_n_day(&mut self, date: &str, n: i32) -> String {
        let ur = self.to_i32(date);

        let u = self.trade_date.iter().position(|x| x >= &ur).unwrap();
        let mut res = 0;
        if self.trade_date.contains(&ur) {
            res = self.trade_date.get_mut(u + n as usize).unwrap().to_owned();
        } else {
            res = self
                .trade_date
                .get_mut(u + n as usize - 1)
                .unwrap()
                .to_owned();
        }
        self.to_string(res)
    }
    pub fn get_last_n_day(&mut self, date: &str, n: i32) -> String {
        let ur = self.to_i32(date);
        let u = self.trade_date.iter().position(|x| x >= &ur).unwrap();
        let mut res = 0;
        res = self.trade_date.get_mut(u - n as usize).unwrap().to_owned();
        self.to_string(res)
    }
    pub fn get_trade_day(&mut self, datetime: String) -> String {
        println!("datetime now: {}", datetime);
        if datetime.len() == 10 {
            if self.if_trade_date(&datetime) {
                datetime
            } else {
                self.get_next_day(&datetime)
            }
        } else {
            let hour = datetime[11..13].parse::<i32>().unwrap();
            let date = datetime[0..10].to_string();
            if hour < 16 {
                if self.if_trade_date(&date) {
                    date
                } else {
                    self.get_next_day(&date)
                }
            } else {
                let today = self.get_real_date(&datetime[0..10]);
                self.get_next_day(&today)
            }
        }
    }
}

pub fn get_n_day_before_date9(n: i64) -> String {
    let now = Local::now().timestamp();
    let sec = now - 3600 * 24 * n;
    let dt = Local.timestamp(sec, 0);
    let backtest_start = format!("{} 09:00:00", dt.format("%Y-%m-%d").to_string());
    backtest_start
}

#[cfg(test)]
mod tests {
    use super::*;

    #[test]
    fn test_to_string() {
        let mut u = QATradeDate::new();
        let x = u.to_string(20200202);
        println!("{:#?}", x);
        assert_eq!(x, "2020-02-02".to_string());
    }

    #[test]
    fn test_get_next_day() {
        let mut u = QATradeDate::new();
        let x = u.get_next_day("2020-04-03");
        println!("{:#?}", x);
        assert_eq!(x, "2020-04-07".to_string());
        let x = u.get_next_day("2020-04-04");
        println!("{:#?}", x);
        assert_eq!(x, "2020-04-07".to_string());
    }

    #[test]
    fn test_get_last_day() {
        let mut u = QATradeDate::new();
        let x = u.get_last_day("2020-04-03");
        println!("{:#?}", x);
        assert_eq!(x, "2020-04-02".to_string());
        let x = u.get_last_day("2020-04-04");
        println!("{:#?}", x);
        assert_eq!(x, "2020-04-03".to_string());
    }

    #[test]
    fn test_get_last_n_day() {
        let mut u = QATradeDate::new();
        let x = u.get_last_n_day("2020-04-03", 2);
        println!("{:#?}", x);

        assert_eq!(x, "2020-04-01".to_string());
        let x = u.get_last_n_day("2020-04-04", 2);
        println!("{:#?}", x);
        assert_eq!(x, "2020-04-02".to_string());
    }

    #[test]
    fn test_get_next_n_day() {
        let mut u = QATradeDate::new();
        let x = u.get_next_n_day("2020-04-03", 3);
        println!("{:#?}", x);

        assert_eq!(x, "2020-04-09".to_string());
        let x = u.get_next_n_day("2020-04-04", 3);
        println!("{:#?}", x);
        assert_eq!(x, "2020-04-09".to_string());
    }

    #[test]
    fn test_get_real_date() {
        let mut u = QATradeDate::new();
        let x = u.get_real_date("2020-07-04");
        println!("{:#?}", x);
    }

    #[test]
    fn test_get_real_tradeday() {
        let mut u = QATradeDate::new();
        let x = u.get_trade_day("2020-07-04 02:00".to_string());
        println!("{:#?}", x);
        assert_eq!(&x, "2020-07-06");
        let x = u.get_trade_day("2020-07-03 02:00".to_string());
        println!("{:#?}", x);
        assert_eq!(&x, "2020-07-03");
        let x = u.get_trade_day("2020-07-03 22:00".to_string());
        println!("{:#?}", x);
        assert_eq!(&x, "2020-07-06");
        let x = u.get_trade_day("2020-07-03 16:22:00".to_string());
        println!("{:#?}", x);
        assert_eq!(&x, "2020-07-06");
        let x = u.get_trade_day("2020-07-05 22:00".to_string());
        println!("{:#?}", x);
        assert_eq!(&x, "2020-07-06");
        let x = u.get_trade_day("2020-07-03 12:00".to_string());
        println!("{:#?}", x);
        assert_eq!(&x, "2020-07-03");
    }

    #[test]
    fn test_get_index() {
        let start = "2021-01-04";
        let end = "2021-01-20";
        let mut u = QATradeDate::new();
        let res = u.get_index(start, end);
        println!("{:#?}", res);
        assert_eq!(
            res,
            vec![
                20210104, 20210105, 20210106, 20210107, 20210108, 20210111, 20210112, 20210113,
                20210114, 20210115, 20210118, 20210119, 20210120,
            ]
        );
        println!(
            "{:#?}",
            res.into_iter()
                .map(|x| QA_util_date_to_string(x))
                .collect::<Vec<String>>()
        );
    }
}
