use crate::types::Key;

// Keyboard
pub const KEY_NONE: Key = 0;
pub const KEY_A: Key = 4;
pub const KEY_B: Key = 5;
pub const KEY_C: Key = 6;
pub const KEY_D: Key = 7;
pub const KEY_E: Key = 8;
pub const KEY_F: Key = 9;
pub const KEY_G: Key = 10;
pub const KEY_H: Key = 11;
pub const KEY_I: Key = 12;
pub const KEY_J: Key = 13;
pub const KEY_K: Key = 14;
pub const KEY_L: Key = 15;
pub const KEY_M: Key = 16;
pub const KEY_N: Key = 17;
pub const KEY_O: Key = 18;
pub const KEY_P: Key = 19;
pub const KEY_Q: Key = 20;
pub const KEY_R: Key = 21;
pub const KEY_S: Key = 22;
pub const KEY_T: Key = 23;
pub const KEY_U: Key = 24;
pub const KEY_V: Key = 25;
pub const KEY_W: Key = 26;
pub const KEY_X: Key = 27;
pub const KEY_Y: Key = 28;
pub const KEY_Z: Key = 29;
pub const KEY_1: Key = 30;
pub const KEY_2: Key = 31;
pub const KEY_3: Key = 32;
pub const KEY_4: Key = 33;
pub const KEY_5: Key = 34;
pub const KEY_6: Key = 35;
pub const KEY_7: Key = 36;
pub const KEY_8: Key = 37;
pub const KEY_9: Key = 38;
pub const KEY_0: Key = 39;
pub const KEY_RETURN: Key = 40;
pub const KEY_ESCAPE: Key = 41;
pub const KEY_BACKSPACE: Key = 42;
pub const KEY_TAB: Key = 43;
pub const KEY_SPACE: Key = 44;
pub const KEY_MINUS: Key = 45;
pub const KEY_EQUALS: Key = 46;
pub const KEY_LEFTBRACKET: Key = 47;
pub const KEY_RIGHTBRACKET: Key = 48;
pub const KEY_BACKSLASH: Key = 49;
pub const KEY_NONUSHASH: Key = 50;
pub const KEY_SEMICOLON: Key = 51;
pub const KEY_APOSTROPHE: Key = 52;
pub const KEY_GRAVE: Key = 53;
pub const KEY_COMMA: Key = 54;
pub const KEY_PERIOD: Key = 55;
pub const KEY_SLASH: Key = 56;
pub const KEY_CAPSLOCK: Key = 57;
pub const KEY_F1: Key = 58;
pub const KEY_F2: Key = 59;
pub const KEY_F3: Key = 60;
pub const KEY_F4: Key = 61;
pub const KEY_F5: Key = 62;
pub const KEY_F6: Key = 63;
pub const KEY_F7: Key = 64;
pub const KEY_F8: Key = 65;
pub const KEY_F9: Key = 66;
pub const KEY_F10: Key = 67;
pub const KEY_F11: Key = 68;
pub const KEY_F12: Key = 69;
pub const KEY_PRINTSCREEN: Key = 70;
pub const KEY_SCROLLLOCK: Key = 71;
pub const KEY_PAUSE: Key = 72;
pub const KEY_INSERT: Key = 73;
pub const KEY_HOME: Key = 74;
pub const KEY_PAGEUP: Key = 75;
pub const KEY_DELETE: Key = 76;
pub const KEY_END: Key = 77;
pub const KEY_PAGEDOWN: Key = 78;
pub const KEY_RIGHT: Key = 79;
pub const KEY_LEFT: Key = 80;
pub const KEY_DOWN: Key = 81;
pub const KEY_UP: Key = 82;
pub const KEY_NUMLOCKCLEAR: Key = 83;
pub const KEY_KP_DIVIDE: Key = 84;
pub const KEY_KP_MULTIPLY: Key = 85;
pub const KEY_KP_MINUS: Key = 86;
pub const KEY_KP_PLUS: Key = 87;
pub const KEY_KP_ENTER: Key = 88;
pub const KEY_KP_1: Key = 89;
pub const KEY_KP_2: Key = 90;
pub const KEY_KP_3: Key = 91;
pub const KEY_KP_4: Key = 92;
pub const KEY_KP_5: Key = 93;
pub const KEY_KP_6: Key = 94;
pub const KEY_KP_7: Key = 95;
pub const KEY_KP_8: Key = 96;
pub const KEY_KP_9: Key = 97;
pub const KEY_KP_0: Key = 98;
pub const KEY_KP_PERIOD: Key = 99;
pub const KEY_NONUSBACKSLASH: Key = 100;
pub const KEY_APPLICATION: Key = 101;
pub const KEY_POWER: Key = 102;
pub const KEY_KP_EQUALS: Key = 103;
pub const KEY_F13: Key = 104;
pub const KEY_F14: Key = 105;
pub const KEY_F15: Key = 106;
pub const KEY_F16: Key = 107;
pub const KEY_F17: Key = 108;
pub const KEY_F18: Key = 109;
pub const KEY_F19: Key = 110;
pub const KEY_F20: Key = 111;
pub const KEY_F21: Key = 112;
pub const KEY_F22: Key = 113;
pub const KEY_F23: Key = 114;
pub const KEY_F24: Key = 115;
pub const KEY_EXECUTE: Key = 116;
pub const KEY_HELP: Key = 117;
pub const KEY_MENU: Key = 118;
pub const KEY_SELECT: Key = 119;
pub const KEY_STOP: Key = 120;
pub const KEY_AGAIN: Key = 121;
pub const KEY_UNDO: Key = 122;
pub const KEY_CUT: Key = 123;
pub const KEY_COPY: Key = 124;
pub const KEY_PASTE: Key = 125;
pub const KEY_FIND: Key = 126;
pub const KEY_MUTE: Key = 127;
pub const KEY_VOLUMEUP: Key = 128;
pub const KEY_VOLUMEDOWN: Key = 129;
pub const KEY_KP_COMMA: Key = 133;
pub const KEY_KP_EQUALSAS400: Key = 134;
pub const KEY_INTERNATIONAL1: Key = 135;
pub const KEY_INTERNATIONAL2: Key = 136;
pub const KEY_INTERNATIONAL3: Key = 137;
pub const KEY_INTERNATIONAL4: Key = 138;
pub const KEY_INTERNATIONAL5: Key = 139;
pub const KEY_INTERNATIONAL6: Key = 140;
pub const KEY_INTERNATIONAL7: Key = 141;
pub const KEY_INTERNATIONAL8: Key = 142;
pub const KEY_INTERNATIONAL9: Key = 143;
pub const KEY_LANG1: Key = 144;
pub const KEY_LANG2: Key = 145;
pub const KEY_LANG3: Key = 146;
pub const KEY_LANG4: Key = 147;
pub const KEY_LANG5: Key = 148;
pub const KEY_LANG6: Key = 149;
pub const KEY_LANG7: Key = 150;
pub const KEY_LANG8: Key = 151;
pub const KEY_LANG9: Key = 152;
pub const KEY_ALTERASE: Key = 153;
pub const KEY_SYSREQ: Key = 154;
pub const KEY_CANCEL: Key = 155;
pub const KEY_CLEAR: Key = 156;
pub const KEY_PRIOR: Key = 157;
pub const KEY_RETURN2: Key = 158;
pub const KEY_SEPARATOR: Key = 159;
pub const KEY_OUT: Key = 160;
pub const KEY_OPER: Key = 161;
pub const KEY_CLEARAGAIN: Key = 162;
pub const KEY_CRSEL: Key = 163;
pub const KEY_EXSEL: Key = 164;
pub const KEY_KP_00: Key = 176;
pub const KEY_KP_000: Key = 177;
pub const KEY_THOUSANDSSEPARATOR: Key = 178;
pub const KEY_DECIMALSEPARATOR: Key = 179;
pub const KEY_CURRENCYUNIT: Key = 180;
pub const KEY_CURRENCYSUBUNIT: Key = 181;
pub const KEY_KP_LEFTPAREN: Key = 182;
pub const KEY_KP_RIGHTPAREN: Key = 183;
pub const KEY_KP_LEFTBRACE: Key = 184;
pub const KEY_KP_RIGHTBRACE: Key = 185;
pub const KEY_KP_TAB: Key = 186;
pub const KEY_KP_BACKSPACE: Key = 187;
pub const KEY_KP_A: Key = 188;
pub const KEY_KP_B: Key = 189;
pub const KEY_KP_C: Key = 190;
pub const KEY_KP_D: Key = 191;
pub const KEY_KP_E: Key = 192;
pub const KEY_KP_F: Key = 193;
pub const KEY_KP_XOR: Key = 194;
pub const KEY_KP_POWER: Key = 195;
pub const KEY_KP_PERCENT: Key = 196;
pub const KEY_KP_LESS: Key = 197;
pub const KEY_KP_GREATER: Key = 198;
pub const KEY_KP_AMPERSAND: Key = 199;
pub const KEY_KP_DBLAMPERSAND: Key = 200;
pub const KEY_KP_VERTICALBAR: Key = 201;
pub const KEY_KP_DBLVERTICALBAR: Key = 202;
pub const KEY_KP_COLON: Key = 203;
pub const KEY_KP_HASH: Key = 204;
pub const KEY_KP_SPACE: Key = 205;
pub const KEY_KP_AT: Key = 206;
pub const KEY_KP_EXCLAM: Key = 207;
pub const KEY_KP_MEMSTORE: Key = 208;
pub const KEY_KP_MEMRECALL: Key = 209;
pub const KEY_KP_MEMCLEAR: Key = 210;
pub const KEY_KP_MEMADD: Key = 211;
pub const KEY_KP_MEMSUBTRACT: Key = 212;
pub const KEY_KP_MEMMULTIPLY: Key = 213;
pub const KEY_KP_MEMDIVIDE: Key = 214;
pub const KEY_KP_PLUSMINUS: Key = 215;
pub const KEY_KP_CLEAR: Key = 216;
pub const KEY_KP_CLEARENTRY: Key = 217;
pub const KEY_KP_BINARY: Key = 218;
pub const KEY_KP_OCTAL: Key = 219;
pub const KEY_KP_DECIMAL: Key = 220;
pub const KEY_KP_HEXADECIMAL: Key = 221;
pub const KEY_LCTRL: Key = 224;
pub const KEY_LSHIFT: Key = 225;
pub const KEY_LALT: Key = 226;
pub const KEY_LGUI: Key = 227;
pub const KEY_RCTRL: Key = 228;
pub const KEY_RSHIFT: Key = 229;
pub const KEY_RALT: Key = 230;
pub const KEY_RGUI: Key = 231;
pub const KEY_MODE: Key = 257;
pub const KEY_AUDIONEXT: Key = 258;
pub const KEY_AUDIOPREV: Key = 259;
pub const KEY_AUDIOSTOP: Key = 260;
pub const KEY_AUDIOPLAY: Key = 261;
pub const KEY_AUDIOMUTE: Key = 262;
pub const KEY_MEDIASELECT: Key = 263;
pub const KEY_WWW: Key = 264;
pub const KEY_MAIL: Key = 265;
pub const KEY_CALCULATOR: Key = 266;
pub const KEY_COMPUTER: Key = 267;
pub const KEY_AC_SEARCH: Key = 268;
pub const KEY_AC_HOME: Key = 269;
pub const KEY_AC_BACK: Key = 270;
pub const KEY_AC_FORWARD: Key = 271;
pub const KEY_AC_STOP: Key = 272;
pub const KEY_AC_REFRESH: Key = 273;
pub const KEY_AC_BOOKMARKS: Key = 274;
pub const KEY_BRIGHTNESSDOWN: Key = 275;
pub const KEY_BRIGHTNESSUP: Key = 276;
pub const KEY_DISPLAYSWITCH: Key = 277;
pub const KEY_KBDILLUMTOGGLE: Key = 278;
pub const KEY_KBDILLUMDOWN: Key = 279;
pub const KEY_KBDILLUMUP: Key = 280;
pub const KEY_EJECT: Key = 281;
pub const KEY_SLEEP: Key = 282;
pub const KEY_APP1: Key = 283;
pub const KEY_APP2: Key = 284;
pub const KEY_AUDIOREWIND: Key = 285;
pub const KEY_AUDIOFASTFORWARD: Key = 286;
pub const KEY_MIN_VALUE: Key = KEY_A; // not to export
pub const KEY_MAX_VALUE: Key = KEY_AUDIOFASTFORWARD; // not to export
pub const KEY_SHIFT: Key = 300;
pub const KEY_CTRL: Key = 301;
pub const KEY_ALT: Key = 302;
pub const KEY_GUI: Key = 303;

// Mouse
pub const MOUSE_POS_X: Key = 400;
pub const MOUSE_POS_Y: Key = 401;
pub const MOUSE_WHEEL_X: Key = 402;
pub const MOUSE_WHEEL_Y: Key = 403;
pub const MOUSE_BUTTON_LEFT: Key = 450;
pub const MOUSE_BUTTON_MIDDLE: Key = 451;
pub const MOUSE_BUTTON_RIGHT: Key = 452;
pub const MOUSE_BUTTON_X1: Key = 453;
pub const MOUSE_BUTTON_X2: Key = 454;
pub const MOUSE_BUTTON_UNKOWN: Key = 455;

// Gamepad1
pub const GAMEPAD1_AXIS_LEFTX: Key = 500;
pub const GAMEPAD1_AXIS_LEFTY: Key = 501;
pub const GAMEPAD1_AXIS_RIGHTX: Key = 502;
pub const GAMEPAD1_AXIS_RIGHTY: Key = 503;
pub const GAMEPAD1_AXIS_TRIGGERLEFT: Key = 504;
pub const GAMEPAD1_AXIS_TRIGGERRIGHT: Key = 505;
pub const GAMEPAD1_BUTTON_A: Key = 550;
pub const GAMEPAD1_BUTTON_B: Key = 551;
pub const GAMEPAD1_BUTTON_X: Key = 552;
pub const GAMEPAD1_BUTTON_Y: Key = 553;
pub const GAMEPAD1_BUTTON_BACK: Key = 554;
pub const GAMEPAD1_BUTTON_GUIDE: Key = 555;
pub const GAMEPAD1_BUTTON_START: Key = 556;
pub const GAMEPAD1_BUTTON_LEFTSTICK: Key = 557;
pub const GAMEPAD1_BUTTON_RIGHTSTICK: Key = 558;
pub const GAMEPAD1_BUTTON_LEFTSHOULDER: Key = 559;
pub const GAMEPAD1_BUTTON_RIGHTSHOULDER: Key = 560;
pub const GAMEPAD1_BUTTON_DPAD_UP: Key = 561;
pub const GAMEPAD1_BUTTON_DPAD_DOWN: Key = 562;
pub const GAMEPAD1_BUTTON_DPAD_LEFT: Key = 563;
pub const GAMEPAD1_BUTTON_DPAD_RIGHT: Key = 564;

// Gamepad2
pub const GAMEPAD2_AXIS_LEFTX: Key = 600;
pub const GAMEPAD2_AXIS_LEFTY: Key = 601;
pub const GAMEPAD2_AXIS_RIGHTX: Key = 602;
pub const GAMEPAD2_AXIS_RIGHTY: Key = 603;
pub const GAMEPAD2_AXIS_TRIGGERLEFT: Key = 604;
pub const GAMEPAD2_AXIS_TRIGGERRIGHT: Key = 605;
pub const GAMEPAD2_BUTTON_A: Key = 650;
pub const GAMEPAD2_BUTTON_B: Key = 651;
pub const GAMEPAD2_BUTTON_X: Key = 652;
pub const GAMEPAD2_BUTTON_Y: Key = 653;
pub const GAMEPAD2_BUTTON_BACK: Key = 654;
pub const GAMEPAD2_BUTTON_GUIDE: Key = 655;
pub const GAMEPAD2_BUTTON_START: Key = 656;
pub const GAMEPAD2_BUTTON_LEFTSTICK: Key = 657;
pub const GAMEPAD2_BUTTON_RIGHTSTICK: Key = 658;
pub const GAMEPAD2_BUTTON_LEFTSHOULDER: Key = 659;
pub const GAMEPAD2_BUTTON_RIGHTSHOULDER: Key = 660;
pub const GAMEPAD2_BUTTON_DPAD_UP: Key = 661;
pub const GAMEPAD2_BUTTON_DPAD_DOWN: Key = 662;
pub const GAMEPAD2_BUTTON_DPAD_LEFT: Key = 663;
pub const GAMEPAD2_BUTTON_DPAD_RIGHT: Key = 664;
