# Wyz

Wiz is a Python Task runner with battery included:

- tasks dependencies management
- docker-based tasks support
- services handling (`containerd` or `docker-compose`)
- try to use types as much as possible to automate parsing and documentation
- try to be PEP-compliant

    - parse and expose PEP-621 metadata
    - available as a PEP-9999 task provider
    - store its configuration into `pyproject.toml` under the `tool.wyz`sections

- allows to watch/launch tasks on changes
- try to provide as much customization as possible
- support namespaces
- support matrixes
- provides some builtin helpers for common tasks
- builtin templating when possible

## Installation

You can install `wyz` like any other PyPI poackage with `pip` or any other dedicated tool:

```console
# pip
pip install wyz
# poetry
poetry add --dev wyz
# Pipenv
pipenv add --dev wyz
```

## Inspiration

Wyz main inspiration is [`invoke`](https://www.pyinvoke.org/) which I heavily used for the past years.
But, my exerienmces hit some `ìnvoke` limitation:

- lack of `pathlib` support
- project seems in maintenance-only mode
- it's hard to provide custom `Context` methods
- configuration managment is a bit weird to me
- total lack of typing
- no ANSI colors support
- lack of bsaic helpers: I have been copy-pasting the same helpers accross all my `invoke`-based project
- lack of extensibility: I have been monkey-patching some `invoke` classes to obtain my expected behavior

I've also been using [`tox`](https://tox.wiki) and [`nox`](https://nox.thea.codes/) a lot, most of the time in addition to `invoke` and I had the following issues:

- most of the time, none of them allows to be DRY:

    - they impose manual duplicated dependency management
    - most of the time, they were simply a rewrite of an `invoke` `test` or `lint` task
    - not really CI compliant as their featurew overlap the CI role in case of matrix testing

- half of the projects I contributed to had an unmaintained `tox.ini`
- commandline usage is not task-fist oriented
- only run in isolation (`nox` allow running into the project virtual env but commandline syntax is not helpful)

And this is how I decided to start `wyz` based on those experiences.
