
pub enum Key
{
    Ctrl = 0,
    Shift = 1,
    Space = 2,
    Backsspace = 3,
    Enter = 4,
    Alt = 5,
    A = 6,
    B = 7,
    C = 8,
    D = 9,
    E = 10,
    F = 11,
    G = 12,
    H = 13,
    I = 14,
    J = 15,
    K = 16,
    L = 17,
    M = 18,
    N = 19,
    O = 20,
    P = 21,
    Q = 22,
    R = 23,
    S = 24,
    T = 25,
    U = 26,
    V = 27,
    W = 28,
    X = 29,
    Y = 30,
    Z = 31,
    Up = 32,
    Down = 33,
    Left = 34,
    Right = 35,
    N0 = 36,
    N1 = 37,
    N2 = 38,
    N3 = 39,
    N4 = 40,
    N5 = 41,
    N6 = 42,
    N7 = 43,
    N8 = 44,
    N9 = 45,
    F1 = 46,
    F2 = 47,
    F3 = 48,
    F4 = 49,
    F5 = 50,
    F6 = 51,
    F7 = 52,
    F8 = 53,
    F9 = 54,
    F10 = 55,
    F11 = 56,
    F12 = 57,
    ESC = 58
}


pub struct Input
{
    pub(crate) keys: [bool; 59],
    pub(crate) mouse_left: bool,
    pub(crate) mouse_right: bool,
    pub(crate) mouse_position: [f32; 2]
}

impl Input
{
    pub(crate) fn new() -> Input
    {
        Input {
            keys: [false; 59],
            mouse_left: false,
            mouse_right: false,
            mouse_position: [0.0; 2]
        }
    }

    pub(crate) fn set_key(&mut self, key: Key, key_down: bool)
    {
        self.keys[key as usize] = key_down
    }

    pub fn get_key(&self, key: Key) -> bool
    {
        self.keys[key as usize]
    }

    pub fn get_mouse_l(&self) -> bool
    {
        self.mouse_left
    }

    pub fn get_mouse_r(&self) -> bool
    {
        self.mouse_right
    }

    pub fn get_mouse_pos(&self) -> [f32; 2]
    {
        self.mouse_position
    }

}